/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class FloatTag
extends NumberTag {
    private final float value;
    public static final FloatTag ZERO = new FloatTag(0.0f);
    public static final TagReader<FloatTag> READER = new TagReader<FloatTag>(){

        @Override
        public FloatTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return FloatTag.valueOf(in.readFloat());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readFloat());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(4);
        }
    };

    private FloatTag(float f) {
        this.value = f;
    }

    public static FloatTag valueOf(float f) {
        return f == 0.0f ? ZERO : new FloatTag(f);
    }

    @Override
    public byte asByte() {
        return (byte)(this.floor(this.value) & 0xFF);
    }

    @Override
    public short asShort() {
        return (short)(this.floor(this.value) & 0xFFFF);
    }

    @Override
    public int asInt() {
        return this.floor(this.value);
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return Float.valueOf(this.value);
    }

    private int floor(float f) {
        int o = (int)f;
        return f < (float)o ? o - 1 : o;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public FloatTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FloatTag && this.value == ((FloatTag)other).value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public String toString() {
        return this.value + "f";
    }
}

