/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class LongArrayTag
extends CollectionTag<LongTag> {
    private long[] value;
    public static final TagReader<CollectionTag<? extends NumberTag>> READER = new TagReader<CollectionTag<? extends NumberTag>>(){

        @Override
        public CollectionTag<? extends NumberTag> read(DataInput in, boolean rawArrays, int depth) throws IOException {
            if (rawArrays) {
                return new ByteArrayTag(this.readByteArray(in, in.readInt() * 8));
            }
            long[] data = new long[in.readInt()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = in.readLong();
            }
            return new LongArrayTag(data);
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            if (rawArrays) {
                return visitor.visit(this.readByteArray(in, in.readInt() * 8));
            }
            long[] data = new long[in.readInt()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = in.readLong();
            }
            return visitor.visit(data);
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(in.readInt() * 8);
        }
    };

    public LongArrayTag(long[] l) {
        Objects.requireNonNull(l);
        this.value = l;
    }

    @Override
    public LongTag get(int index) {
        return LongTag.valueOf(this.value[index]);
    }

    @Override
    public LongTag set(int index, LongTag tag) {
        long old = this.value[index];
        this.value[index] = tag.asLong();
        return LongTag.valueOf(old);
    }

    @Override
    public void add(int index, LongTag tag) {
        if (index > this.value.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        long[] output = new long[this.value.length + 1];
        System.arraycopy(this.value, 0, output, 0, index);
        output[index] = tag.asLong();
        if (index < this.value.length) {
            System.arraycopy(this.value, index, output, index + 1, this.value.length - index);
        }
        this.value = output;
    }

    @Override
    public LongTag remove(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        long old = this.value[index];
        long[] output = new long[this.value.length - 1];
        System.arraycopy(this.value, 0, output, 0, index);
        if (index < this.value.length - 1) {
            System.arraycopy(this.value, index + 1, output, index, this.value.length - index - 1);
        }
        this.value = output;
        return LongTag.valueOf(old);
    }

    @Override
    public Tag.Type getElementType() {
        return Tag.Type.LONG;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        for (long l : this.value) {
            out.writeLong(l);
        }
    }

    @Override
    public LongArrayTag copy() {
        long[] copy = new long[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return new LongArrayTag(copy);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LongArrayTag && Arrays.equals(this.value, ((LongArrayTag)other).value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public void clear() {
        this.value = new long[0];
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(long[] value) {
        this.value = value;
    }
}

