/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class StringTag
implements Tag {
    private final String value;
    private static final StringTag EMPTY = new StringTag("");
    public static final TagReader<StringTag> READER = new TagReader<StringTag>(){

        @Override
        public StringTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return StringTag.valueOf(in.readUTF());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readUTF());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(in.readUnsignedShort());
        }
    };

    private StringTag(String s) {
        this.value = s;
    }

    public static StringTag valueOf(String s) {
        return s.isEmpty() ? EMPTY : new StringTag(s);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    public static void skipUTF(DataInput in) throws IOException {
        in.skipBytes(in.readUnsignedShort());
    }

    @Override
    public StringTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StringTag && this.value.equals(((StringTag)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String getValue() {
        return this.value;
    }

    public static String escapeString(String s) {
        StringBuilder sb = new StringBuilder(" ");
        int quote = 0;
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 92) {
                sb.append('\\');
                continue;
            }
            if (c == 34 || c == 39) {
                if (quote == 0) {
                    int n = quote = c == 34 ? 39 : 34;
                }
                if (quote != c) continue;
                sb.append('\\');
                continue;
            }
            if (c == 8) {
                sb.append("\\b");
                continue;
            }
            if (c == 9) {
                sb.append("\\t");
                continue;
            }
            if (c == 10) {
                sb.append("\\n");
                continue;
            }
            if (c == 12) {
                sb.append("\\f");
                continue;
            }
            if (c == 13) {
                sb.append("\\r");
                continue;
            }
            sb.append((char)c);
        }
        if (quote == 0) {
            quote = 34;
        }
        sb.setCharAt(0, (char)quote);
        sb.append((char)quote);
        return sb.toString();
    }
}

