/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.querz.io.LittleEndianOutputStream;
import net.querz.nbt.NamedTag;
import net.querz.nbt.Tag;

public final class NBTWriter {
    private boolean compression;
    private boolean littleEndian;

    public NBTWriter compressed(boolean compressed) {
        this.compression = compressed;
        return this;
    }

    public NBTWriter littleEndian() {
        this.littleEndian = true;
        return this;
    }

    public NBTWriter bigEndian() {
        this.littleEndian = false;
        return this;
    }

    public void writeNamed(OutputStream out, NamedTag named) throws IOException {
        this.writeNamed(out, named.name(), named.tag());
    }

    public void write(OutputStream out, Tag tag) throws IOException {
        this.writeNamed(out, "", tag);
    }

    public void writeNamed(OutputStream out, String name, Tag tag) throws IOException {
        BufferedOutputStream stream = this.compression ? new BufferedOutputStream(new GZIPOutputStream(out)) : new BufferedOutputStream(out);
        DataOutput output = this.littleEndian ? new LittleEndianOutputStream(stream) : new DataOutputStream(stream);
        output.writeByte(tag.getType().id);
        if (tag.getType() != Tag.Type.END) {
            output.writeUTF(name);
            tag.write(output);
        }
        ((OutputStream)stream).flush();
    }

    public void writeNamed(File file, NamedTag named) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.writeNamed(fos, named);
        }
    }

    public void write(File file, Tag tag) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.write(fos, tag);
        }
    }

    public void writeNamed(File file, String name, Tag tag) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.writeNamed(fos, name, tag);
        }
    }
}

