/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.snbt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import net.querz.nbt.Tag;
import net.querz.nbt.io.snbt.SNBTWriterTagVisitor;

public final class SNBTWriter {
    private String indent = "";

    public SNBTWriter indent(String indent) {
        this.indent = indent;
        return this;
    }

    public void write(OutputStream out, Tag tag) throws IOException {
        PrintWriter writer = new PrintWriter(out, false, StandardCharsets.UTF_8);
        tag.accept(new SNBTWriterTagVisitor(writer, this.indent));
        writer.flush();
    }

    public void write(File file, Tag tag) throws IOException {
        this.write(new FileOutputStream(file), tag);
    }

    public String toString(Tag tag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos, tag);
            return baos.toString(StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

