/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.snbt;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.querz.io.util.ThrowingFunction;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.EndTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagVisitor;

public class SNBTWriterTagVisitor
implements TagVisitor {
    private static final Pattern NO_ESCAPE = Pattern.compile("[a-zA-Z0-9._+-]+");
    private final String indent;
    private final int depth;
    private final Writer writer;

    public SNBTWriterTagVisitor(Writer writer) {
        this(writer, "", 0);
    }

    public SNBTWriterTagVisitor(Writer writer, String indent) {
        this(writer, indent, 0);
    }

    private SNBTWriterTagVisitor(Writer writer, String indent, int depth) {
        this.writer = writer;
        this.indent = indent;
        this.depth = depth;
    }

    @Override
    public void visit(ByteTag t) {
        this.writeNumber(t);
    }

    @Override
    public void visit(ShortTag t) {
        this.writeNumber(t);
    }

    @Override
    public void visit(IntTag t) {
        this.writeNumber(t);
    }

    @Override
    public void visit(LongTag t) {
        this.writeNumber(t);
    }

    @Override
    public void visit(FloatTag t) {
        this.writeNumber(t);
    }

    @Override
    public void visit(DoubleTag t) {
        this.writeNumber(t);
    }

    private void writeNumber(NumberTag t) {
        try {
            this.writer.write(t.toString());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void visit(StringTag t) {
        try {
            this.writer.write(StringTag.escapeString(t.getValue()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void visit(ByteArrayTag t) {
        this.writeArray(t, "B");
    }

    @Override
    public void visit(IntArrayTag t) {
        this.writeArray(t, "I");
    }

    @Override
    public void visit(LongArrayTag t) {
        this.writeArray(t, "L");
    }

    private void writeArray(CollectionTag<? extends NumberTag> t, String prefix) {
        try {
            this.writer.write("[" + prefix + ";");
            for (int i = 0; i < t.size(); ++i) {
                this.writer.write(" ");
                this.writeNumber((NumberTag)t.get(i));
                if (i >= t.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("]");
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void visit(ListTag t) {
        this.writeHierarchy(t, "[", "]", ThrowingFunction.identity());
    }

    @Override
    public void visit(CompoundTag t) {
        this.writeHierarchy(t, "{", "}", entry -> {
            String key = (String)entry.getKey();
            String escapedKey = NO_ESCAPE.matcher(key).matches() ? key : StringTag.escapeString(key);
            this.writer.write(escapedKey);
            this.writer.write(": ");
            return (Tag)entry.getValue();
        });
    }

    private <T> void writeHierarchy(Iterable<T> hierarchy, String open, String close, ThrowingFunction<T, Tag, IOException> elementHandler) {
        try {
            Iterator<T> iterator = hierarchy.iterator();
            if (!iterator.hasNext()) {
                this.writer.write(open + close);
                return;
            }
            this.writer.write(open);
            this.writeSpacing();
            while (iterator.hasNext()) {
                T el = iterator.next();
                this.writeIndent(this.depth + 1);
                Tag tag = elementHandler.apply(el);
                tag.accept(new SNBTWriterTagVisitor(this.writer, this.indent, this.depth + 1));
                if (iterator.hasNext()) {
                    this.writer.write(44);
                }
                this.writeSpacing();
            }
            this.writeIndent(this.depth);
            this.writer.write(close);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void writeSpacing() throws IOException {
        if (!this.indent.isEmpty()) {
            this.writer.write(10);
        } else {
            this.writer.write(32);
        }
    }

    private void writeIndent(int depth) throws IOException {
        this.writer.write(this.indent.repeat(depth));
    }

    @Override
    public void visit(EndTag t) {
    }
}

