/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.snbt;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.querz.io.util.ThrowingFunction;
import net.querz.nbt.io.snbt.ParseException;

class StringPointer {
    private final String value;
    private int index;
    private static final Map<Character, ThrowingFunction<StringPointer, String, ParseException>> escapes = new HashMap<Character, ThrowingFunction<StringPointer, String, ParseException>>();
    private static final Pattern HEX_DIGIT = Pattern.compile("^[0-9a-fA-F]*$");

    public StringPointer(String value) {
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int size() {
        return this.value.length();
    }

    public String parseString() throws ParseException {
        if (!this.hasNext()) {
            return "";
        }
        char start = this.currentChar();
        if (start == '\"' || start == '\'') {
            this.skip(1);
            return this.parseStringUntil(start);
        }
        return this.parseSimpleString();
    }

    public String parseSimpleString() throws ParseException {
        int start = this.index;
        while (this.hasNext() && StringPointer.isSimpleChar(this.currentChar())) {
            this.skip(1);
        }
        return this.value.substring(start, this.index);
    }

    public String parseQuotedString() throws ParseException {
        if (!this.hasNext()) {
            return "";
        }
        char quote = this.next();
        if (quote == '\"' || quote == '\'') {
            return this.parseStringUntil(quote);
        }
        throw this.parseException("expected quote at start of string");
    }

    public String parseStringUntil(char end) throws ParseException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while (this.hasNext()) {
            char c = this.next();
            if (escaped) {
                if (c == end || c == '\\') {
                    sb.append(c);
                    escaped = false;
                    continue;
                }
                if (escapes.containsKey(Character.valueOf(c))) {
                    String decoded = escapes.get(Character.valueOf(c)).apply(this);
                    sb.append(decoded);
                    escaped = false;
                    continue;
                }
                throw this.parseException("invalid escape of '" + c + "'");
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == end) {
                return sb.toString();
            }
            sb.append(c);
        }
        throw this.parseException("missing end quote");
    }

    private String readUnicodeHex(int length) throws ParseException {
        String seq = this.read(length);
        if (!HEX_DIGIT.matcher(seq).matches()) {
            throw this.parseException("invalid hex digit '" + seq + "'");
        }
        int c = Integer.parseInt(seq, 16);
        if (!Character.isDefined(c)) {
            throw this.parseException("undefined character '" + seq + "'");
        }
        return String.valueOf(Character.toChars(c));
    }

    public String read(int length) throws ParseException {
        if (!this.hasCharsLeft(length)) {
            this.index = this.value.length() - 1;
            throw this.parseException("unexpected end of string");
        }
        int start = this.index;
        this.index += length;
        return this.value.substring(start, this.index);
    }

    public void skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    public void expectChar(char c) throws ParseException {
        if (this.hasNext() && this.currentChar() != c) {
            throw this.parseException("expected " + c + " but got " + this.currentChar());
        }
        this.skip(1);
    }

    public boolean hasNext() {
        return this.index < this.value.length();
    }

    public boolean hasCharsLeft(int num) {
        return this.index + num < this.value.length();
    }

    public char currentChar() {
        return this.value.charAt(this.index);
    }

    public char next() {
        return this.value.charAt(this.index++);
    }

    public void skip(int offset) {
        this.index += offset;
    }

    public char lookAhead(int offset) {
        return this.value.charAt(this.index + offset);
    }

    private static boolean isNumberChar(char c) {
        return c >= '0' && c <= '9' || c == '-' || c == '.';
    }

    private static boolean isSimpleChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '+' || c == '.';
    }

    public ParseException parseException(String msg) {
        return new ParseException(msg, this.value, this.index);
    }

    static {
        escapes.put(Character.valueOf('x'), p -> p.readUnicodeHex(2));
        escapes.put(Character.valueOf('u'), p -> p.readUnicodeHex(4));
        escapes.put(Character.valueOf('U'), p -> p.readUnicodeHex(8));
        escapes.put(Character.valueOf('N'), p -> {
            p.expectChar('{');
            String name = p.parseStringUntil('}');
            try {
                int c = Character.codePointOf(name);
                return String.valueOf(Character.toChars(c));
            }
            catch (IllegalArgumentException ex) {
                throw p.parseException("undefined character name '" + name + "'");
            }
        });
        escapes.put(Character.valueOf('b'), p -> "\b");
        escapes.put(Character.valueOf('s'), p -> " ");
        escapes.put(Character.valueOf('t'), p -> "\t");
        escapes.put(Character.valueOf('n'), p -> "\n");
        escapes.put(Character.valueOf('f'), p -> "\f");
        escapes.put(Character.valueOf('r'), p -> "\r");
    }
}

