/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.stream;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.io.stream.StreamTagVisitor;
import net.querz.nbt.io.stream.TagSelector;
import net.querz.nbt.io.stream.TagTree;

public class SelectionStreamTagVisitor
extends StreamTagVisitor {
    private int remainingNumberOfFields;
    private final Set<TagReader<?>> wantedTypes;
    private final Deque<TagTree> stack = new ArrayDeque<TagTree>();

    public SelectionStreamTagVisitor(TagSelector ... selectors) {
        this.remainingNumberOfFields = selectors.length;
        HashSet wt = new HashSet();
        TagTree tree = new TagTree();
        for (TagSelector selector : selectors) {
            tree.addEntry(selector);
            wt.add(selector.type());
        }
        this.stack.push(tree);
        wt.add(CompoundTag.READER);
        this.wantedTypes = Collections.unmodifiableSet(wt);
    }

    @Override
    public TagTypeVisitor.ValueResult visitRootEntry(TagReader<?> reader) {
        return reader != CompoundTag.READER ? TagTypeVisitor.ValueResult.RETURN : super.visitRootEntry(reader);
    }

    @Override
    public TagTypeVisitor.EntryResult visitEntry(TagReader<?> reader) {
        TagTree tree = this.stack.element();
        if (this.depth() > tree.depth()) {
            return super.visitEntry(reader);
        }
        if (this.remainingNumberOfFields <= 0) {
            return TagTypeVisitor.EntryResult.RETURN;
        }
        return !this.wantedTypes.contains(reader) ? TagTypeVisitor.EntryResult.SKIP : super.visitEntry(reader);
    }

    @Override
    public TagTypeVisitor.EntryResult visitEntry(TagReader<?> reader, String name) {
        TagTree child;
        TagTree tree = this.stack.element();
        if (this.depth() > tree.depth()) {
            return super.visitEntry(reader, name);
        }
        if (tree.selected().remove(name, reader)) {
            --this.remainingNumberOfFields;
            return super.visitEntry(reader, name);
        }
        if (reader == CompoundTag.READER && (child = tree.tree().get(name)) != null) {
            this.stack.push(child);
            return super.visitEntry(reader, name);
        }
        return TagTypeVisitor.EntryResult.SKIP;
    }

    @Override
    public TagTypeVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }

    public int getRemainingNumberOfFields() {
        return this.remainingNumberOfFields;
    }
}

