/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;

class PausableSuccessionStream<O>
extends EventStreamBase<O>
implements AwaitingEventStream<O> {
    private final EventStream<O> input;
    private final Function<? super O, ? extends O> initial;
    private final BiFunction<? super O, ? super O, ? extends O> reduction;
    private final Timer timer;
    private boolean hasEvent = false;
    private BooleanBinding pending = null;
    private BooleanProperty successionOff;
    private Predicate<O> successionOffCond;
    private O event = null;

    public PausableSuccessionStream(EventStream<O> input, Duration timeout, BooleanProperty realTime) {
        this(input, timeout, realTime, a -> realTime.get());
    }

    public PausableSuccessionStream(EventStream<O> input, Duration timeout, Predicate<O> condition) {
        this(input, timeout, (BooleanProperty)new SimpleBooleanProperty(), condition);
    }

    private PausableSuccessionStream(EventStream<O> input, Duration timeout, BooleanProperty realTime, Predicate<O> condition) {
        this.input = input;
        this.initial = Function.identity();
        this.reduction = (a, b) -> b;
        this.successionOff = realTime;
        this.successionOffCond = condition;
        this.timer = FxTimer.create(timeout, this::handleTimeout);
    }

    @Override
    public ObservableBooleanValue pendingProperty() {
        if (this.pending == null) {
            this.pending = new BooleanBinding(){

                protected boolean computeValue() {
                    return PausableSuccessionStream.this.hasEvent;
                }
            };
        }
        return this.pending;
    }

    @Override
    public boolean isPending() {
        return this.pending != null ? this.pending.get() : this.hasEvent;
    }

    @Override
    protected final Subscription observeInputs() {
        return this.input.subscribe(this::handleEvent);
    }

    private void handleEvent(O i) {
        this.timer.stop();
        if (this.successionOffCond.test(i)) {
            this.hasEvent = false;
            this.event = null;
            this.emit(i);
            this.successionOff.setValue(Boolean.valueOf(false));
        } else {
            if (this.hasEvent) {
                this.event = this.reduction.apply(this.event, i);
            } else {
                this.event = this.initial.apply(i);
                this.hasEvent = true;
                this.invalidatePending();
            }
            this.timer.restart();
        }
    }

    private void handleTimeout() {
        this.hasEvent = false;
        O toEmit = this.event;
        this.event = null;
        this.emit(toEmit);
        this.invalidatePending();
    }

    private void invalidatePending() {
        if (this.pending != null) {
            this.pending.invalidate();
        }
    }
}

