/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.InlineCssTextArea;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;

public class LineNumberFactory<PS>
implements IntFunction<Node> {
    private static final Insets DEFAULT_INSETS = new Insets(0.0, 5.0, 0.0, 5.0);
    private static final Paint DEFAULT_TEXT_FILL = Color.web((String)"#666");
    private static final Font DEFAULT_FONT = Font.font((String)"monospace", (FontPosture)FontPosture.ITALIC, (double)13.0);
    private static final Font DEFAULT_FOLD_FONT = Font.font((String)"monospace", (FontWeight)FontWeight.BOLD, (double)13.0);
    private static final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#ddd"), null, null)});
    private final Val<Integer> nParagraphs;
    private final IntFunction<String> format;
    private final GenericStyledArea<PS, ?, ?> area;
    private final UnaryOperator<PS> removeFoldStyle;
    private final Predicate<PS> isFoldedCheck;

    public static IntFunction<Node> get(GenericStyledArea<?, ?, ?> area) {
        return LineNumberFactory.get(area, digits -> "%1$" + digits + "s");
    }

    public static <PS> IntFunction<Node> get(GenericStyledArea<PS, ?, ?> area, IntFunction<String> format) {
        if (area instanceof StyleClassedTextArea) {
            StyleClassedTextArea classArea = (StyleClassedTextArea)area;
            return LineNumberFactory.get(classArea, format, classArea.getFoldStyleCheck(), classArea.getRemoveFoldStyle());
        }
        if (area instanceof InlineCssTextArea) {
            InlineCssTextArea inlineArea = (InlineCssTextArea)area;
            return LineNumberFactory.get(inlineArea, format, inlineArea.getFoldStyleCheck(), inlineArea.getRemoveFoldStyle());
        }
        return LineNumberFactory.get(area, format, null, null);
    }

    public static <PS> IntFunction<Node> get(GenericStyledArea<PS, ?, ?> area, IntFunction<String> format, Predicate<PS> isFolded, UnaryOperator<PS> removeFoldStyle) {
        return new LineNumberFactory<PS>(area, format, isFolded, removeFoldStyle);
    }

    private LineNumberFactory(GenericStyledArea<PS, ?, ?> area, IntFunction<String> format, Predicate<PS> isFolded, UnaryOperator<PS> removeFoldStyle) {
        this.nParagraphs = LiveList.sizeOf(area.getParagraphs());
        this.removeFoldStyle = removeFoldStyle;
        this.isFoldedCheck = isFolded;
        this.format = format;
        this.area = area;
        if (this.isFoldedCheck != null) {
            area.getParagraphs().sizeProperty().addListener((ChangeListener<Integer>)((ChangeListener)(ob, ov, nv) -> {
                if (nv <= ov) {
                    Platform.runLater(() -> this.deleteParagraphCheck());
                } else {
                    Platform.runLater(() -> this.insertParagraphCheck());
                }
            }));
        }
    }

    @Override
    public Node apply(int idx) {
        Val<String> formatted = this.nParagraphs.map(n -> this.format(idx + 1, (int)n));
        Label lineNo = new Label();
        lineNo.setFont(DEFAULT_FONT);
        lineNo.setBackground(DEFAULT_BACKGROUND);
        lineNo.setTextFill(DEFAULT_TEXT_FILL);
        lineNo.setPadding(DEFAULT_INSETS);
        lineNo.setAlignment(Pos.TOP_RIGHT);
        lineNo.getStyleClass().add((Object)"lineno");
        lineNo.textProperty().bind(formatted.conditionOnShowing((Node)lineNo));
        if (this.isFoldedCheck != null) {
            Label foldIndicator = new Label(" ");
            foldIndicator.setTextFill((Paint)Color.BLUE);
            foldIndicator.setFont(DEFAULT_FOLD_FONT);
            lineNo.setContentDisplay(ContentDisplay.RIGHT);
            lineNo.setGraphic((Node)foldIndicator);
            if (this.area.getParagraphs().size() > idx + 1 && this.isFoldedCheck.test(this.area.getParagraph(idx + 1).getParagraphStyle()) && !this.isFoldedCheck.test(this.area.getParagraph(idx).getParagraphStyle())) {
                foldIndicator.setOnMouseClicked(ME -> this.area.unfoldParagraphs(idx, this.isFoldedCheck, this.removeFoldStyle));
                foldIndicator.getStyleClass().add((Object)"fold-indicator");
                foldIndicator.setCursor(Cursor.HAND);
                foldIndicator.setText("+");
            }
        }
        return lineNo;
    }

    private String format(int x, int max) {
        int digits = (int)Math.floor(Math.log10(max)) + 1;
        return String.format(this.format.apply(digits), x);
    }

    private void deleteParagraphCheck() {
        int p = this.area.getCurrentParagraph();
        if (p >= this.area.firstVisibleParToAllParIndex() && p <= this.area.lastVisibleParToAllParIndex()) {
            int col = this.area.getCaretColumn();
            if (col == 0) {
                if (this.isFoldedCheck.test(this.area.getParagraph(p).getParagraphStyle())) {
                    p = Math.max(p - 1, 0);
                    this.area.recreateParagraphGraphic(p);
                    this.area.moveTo(p, 0);
                }
            } else if (col == this.area.getParagraph(p).length()) {
                this.area.recreateParagraphGraphic(p);
            }
        }
    }

    private void insertParagraphCheck() {
        int p = this.area.getCurrentParagraph();
        if (p > this.area.firstVisibleParToAllParIndex() && p <= this.area.lastVisibleParToAllParIndex() && p > 0 && p + 1 < this.area.getParagraphs().size() && this.isFoldedCheck.test(this.area.getParagraph(p + 1).getParagraphStyle())) {
            this.area.recreateParagraphGraphic(p - 1);
        }
    }
}

