/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.model.StyledDocument;

public interface Selection<PS, SEG, S> {
    public ObservableValue<IndexRange> rangeProperty();

    public IndexRange getRange();

    public ObservableValue<Integer> lengthProperty();

    public int getLength();

    public ObservableValue<Integer> paragraphSpanProperty();

    public int getParagraphSpan();

    public ObservableValue<StyledDocument<PS, SEG, S>> selectedDocumentProperty();

    public StyledDocument<PS, SEG, S> getSelectedDocument();

    public ObservableValue<String> selectedTextProperty();

    public String getSelectedText();

    public ObservableValue<Integer> startPositionProperty();

    public int getStartPosition();

    public ObservableValue<Integer> startParagraphIndexProperty();

    public int getStartParagraphIndex();

    public ObservableValue<Integer> startColumnPositionProperty();

    public int getStartColumnPosition();

    public ObservableValue<Integer> endPositionProperty();

    public int getEndPosition();

    public ObservableValue<Integer> endParagraphIndexProperty();

    public int getEndParagraphIndex();

    public ObservableValue<Integer> endColumnPositionProperty();

    public int getEndColumnPosition();

    public ObservableValue<Optional<Bounds>> selectionBoundsProperty();

    public Optional<Bounds> getSelectionBounds();

    public boolean isBeingUpdated();

    public ObservableValue<Boolean> beingUpdatedProperty();

    public void selectRange(int var1, int var2, int var3, int var4);

    public void selectRange(int var1, int var2);

    public void updateStartBy(int var1, Direction var2);

    public void updateEndBy(int var1, Direction var2);

    public void updateStartTo(int var1);

    public void updateStartTo(int var1, int var2);

    public void updateStartByBreaksForward(int var1, BreakIterator var2);

    public void updateStartByBreaksBackward(int var1, BreakIterator var2);

    public void updateEndTo(int var1);

    public void updateEndTo(int var1, int var2);

    public void updateEndByBreaksForward(int var1, BreakIterator var2);

    public void updateEndByBreaksBackward(int var1, BreakIterator var2);

    public void selectAll();

    public void selectParagraph(int var1);

    public void selectWord(int var1);

    default public void deselect() {
        this.selectRange(this.getStartPosition(), this.getStartPosition());
    }

    public void configureSelectionPath(SelectionPath var1);

    public void dispose();

    public String getSelectionName();

    public GenericStyledArea<PS, SEG, S> getArea();

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

