/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;

public interface EditableStyledDocument<PS, SEG, S>
extends StyledDocument<PS, SEG, S> {
    public ObservableValue<String> textProperty();

    public int getLength();

    public Val<Integer> lengthProperty();

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs();

    public ReadOnlyStyledDocument<PS, SEG, S> snapshot();

    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges();

    default public EventStream<List<PlainTextChange>> multiPlainChanges() {
        return this.multiRichChanges().map(list -> Arrays.asList((PlainTextChange[])list.stream().filter(rtc -> !rtc.isPlainTextIdentity()).map(RichTextChange::toPlainTextChange).toArray(PlainTextChange[]::new))).filter(list -> !list.isEmpty());
    }

    default public EventStream<PlainTextChange> plainChanges() {
        return new EventStreamBase<PlainTextChange>(){

            @Override
            protected Subscription observeInputs() {
                return EditableStyledDocument.this.multiPlainChanges().subscribe(l -> l.forEach(this::emit));
            }
        };
    }

    default public EventStream<RichTextChange<PS, SEG, S>> richChanges() {
        return new EventStreamBase<RichTextChange<PS, SEG, S>>(){

            @Override
            protected Subscription observeInputs() {
                return EditableStyledDocument.this.multiRichChanges().subscribe(list -> list.forEach(this::emit));
            }
        };
    }

    public SuspendableNo beingUpdatedProperty();

    public boolean isBeingUpdated();

    public void replaceMulti(List<Replacement<PS, SEG, S>> var1);

    default public void replace(Replacement<PS, SEG, S> replacement) {
        this.replace(replacement.getStart(), replacement.getEnd(), replacement.getDocument());
    }

    public void replace(int var1, int var2, StyledDocument<PS, SEG, S> var3);

    public void setStyle(int var1, int var2, S var3);

    public void setStyle(int var1, S var2);

    public void setStyle(int var1, int var2, int var3, S var4);

    public void setStyleSpans(int var1, StyleSpans<? extends S> var2);

    public void setStyleSpans(int var1, int var2, StyleSpans<? extends S> var3);

    public void setParagraphStyle(int var1, PS var2);
}

