#include "camera_param.h"
#include "common.h"

// 逆变换(俯视->原图)
bool map_inv(float pt0[2], int pt1[2]){    
    int rx = 0.5+(H[0][0]*pt0[0]+H[0][1]*pt0[1]+H[0][2])/(H[2][0]*pt0[0]+H[2][1]*pt0[1]+H[2][2]);
    int ry = 0.5+(H[1][0]*pt0[0]+H[1][1]*pt0[1]+H[1][2])/(H[2][0]*pt0[0]+H[2][1]*pt0[1]+H[2][2]);
    if(rx<0 || rx>=376 || ry<0 || ry>=240) return false;
    pt1[0] = invx[ry][rx];
    pt1[1] = invy[ry][rx];
    return true;
}
// 内参矩阵
AT_DTCM_SECTION_ALIGN_INIT(float K[3][3], 8) = {{123.1638, 0, 189.0743},
                                                {0, 123.1638, 107.7948},
                                                {0, 0, 1}};
// 畸变参数(matlab fisheye 模型)
AT_DTCM_SECTION_ALIGN_INIT(float D[4], 8) = {1.231637608244545e+02,0.002375247904180,-1.849673325270101e-05,1.754638932017615e-08};
// 逆透视变换矩阵(俯视->去畸变原图)
AT_DTCM_SECTION_ALIGN_INIT(float H[3][3], 8) = {{ 2.8571427e+00, -3.4526258e+00,  3.9284460e+02},
                                                {-3.2463454e-16, -2.0630111e-01,  2.1206279e+02},
                                                { 2.2362882e-18, -1.8260682e-02,  4.9212947e+00}};
// 逆透视变换矩阵(去畸变原图->俯视)
AT_DTCM_SECTION_ALIGN_INIT(float H_inv[3][3], 8) = {{ 3.5000002e-01,  1.2026778e+00, -7.9763329e+01},
                                                    { 2.5380233e-16,  1.7224531e+00, -7.4221977e+01},
                                                    { 7.8270115e-19,  6.3912389e-03, -7.2205387e-02}};
// 打表变换(原图x->俯视x)
AT_SDRAM_SECTION_ALIGN_INIT(float mapx[240][376], 64) = {
{522.57,528.32,534.24,540.36,546.68,553.2,559.93,566.9,574.1,581.56,589.28,597.28,605.58,614.18,623.12,632.4,642.05,652.09,662.54,673.43,684.79,696.65,709.05,722.01,735.58,749.8,764.72,780.4,796.89,814.26,832.57,851.92,872.38,894.06,917.07,941.53,967.59,995.42,1025.2,1057.1,1091.5,1128.5,1168.5,1211.9,1259.2,1310.9,1367.6,1430.0,1499.3,1576.4,1662.9,1760.5,1871.6,1999.1,2147.1,2320.8,2527.6,2778.0,3087.5,3479.7,3993.0,4693.8,5707.9,7306.1,10197.0,17018.0,52787.0,-46736.0,-16057.0,-9641.7,-6862.2,-5309.9,-4318.9,-3631.4,-3126.3,-2739.5,-2433.8,-2186.0,-1981.1,-1808.8,-1661.9,-1535.0,-1424.5,-1327.2,-1240.9,-1163.8,-1094.5,-1031.9,-975.05,-923.14,-875.56,-831.77,-791.34,-753.87,-719.04,-686.57,-656.23,-627.79,-601.08,-575.93,-552.2,-529.77,-508.53,-488.37,-469.21,-450.96,-433.56,-416.94,-401.04,-385.82,-371.21,-357.18,-343.69,-330.7,-318.18,-306.09,-294.42,-283.12,-272.19,-261.59,-251.31,-241.32,-231.61,-222.16,-212.96,-204.0,-195.25,-186.71,-178.36,-170.19,-162.2,-154.38,-146.7,-139.18,-131.79,-124.53,-117.39,-110.38,-103.47,-96.663,-89.957,-83.344,-76.819,-70.376,-64.012,-57.723,-51.503,-45.35,-39.259,-33.227,-27.25,-21.326,-15.452,-9.6241,-3.8402,1.9024,7.606,13.273,18.906,24.506,30.076,35.618,41.132,46.622,52.089,57.533,62.958,68.363,73.75,79.121,84.477,89.818,95.146,100.46,105.77,111.06,116.35,121.62,126.89,132.16,137.41,142.66,147.91,153.15,158.38,163.62,168.85,174.08,179.31,184.54,189.76,194.99,200.22,205.45,210.68,215.92,221.16,226.4,231.65,236.9,242.16,247.43,252.7,257.98,263.27,268.57,273.88,279.2,284.54,289.88,295.25,300.63,306.02,311.44,316.87,322.33,327.81,333.31,338.84,344.4,349.98,355.6,361.25,366.94,372.66,378.43,384.24,390.09,395.99,401.95,407.95,414.02,420.14,426.34,432.59,438.93,445.34,451.83,458.4,465.07,471.83,478.7,485.67,492.76,499.97,507.3,514.78,522.39,530.16,538.08,546.18,554.46,562.92,571.59,580.48,589.59,598.94,608.55,618.44,628.61,639.1,649.91,661.08,672.62,684.56,696.93,709.76,723.08,736.92,751.33,766.35,782.03,798.41,815.56,833.54,852.41,872.26,893.17,915.23,938.57,963.29,989.54,1017.5,1047.3,1079.1,1113.3,1150.0,1189.7,1232.6,1279.1,1329.9,1385.5,1446.7,1514.3,1589.4,1673.5,1768.2,1875.6,1998.7,2141.0,2307.7,2505.3,2743.7,3036.9,3406.3,3886.2,4534.9,5460.7,6889.7,9385.8,14857.0,36484.0,-75943.0,-18366.0,-10367.0,-7183.2,-5472.1,-4403.7,-3673.2,-3142.1,-2738.6,-2421.5,-2165.8,-1955.2,-1778.8,-1628.7,-1499.6,-1387.3,-1288.8,-1201.6,-1123.8,-1054.1,-991.28,-934.3,-882.4,-834.94,-791.36,-751.21,-714.1,-679.7,-647.72,-617.9,-590.05,-563.96,-539.49,-516.47,-494.79,-474.34,-455.0,-436.7,-419.34,-402.87,-387.21,-372.31,-358.11,-344.56,-331.62,-319.25,-307.41,-296.07,-285.2,-274.77,-264.76,-255.13,-245.88,-236.97,-228.38,-220.11,-212.13,-204.43,-197.0,-189.82,-182.87,-176.16,-169.66,-163.36,},
{538.25,544.62,551.21,558.01,565.06,572.35,579.9,587.72,595.84,604.26,613.01,622.1,631.55,641.39,651.64,662.32,673.46,685.1,697.27,710.0,723.34,737.32,752.0,767.43,783.66,800.77,818.83,837.91,858.11,879.53,902.27,926.48,952.29,979.87,1009.4,1041.1,1075.3,1112.1,1152.0,1195.4,1242.6,1294.4,1351.2,1414.1,1483.8,1561.8,1649.3,1748.5,1861.8,1992.4,2144.6,2324.2,2539.6,2802.3,3130.2,3550.8,4110.0,4890.0,6053.7,7976.9,11764.0,22670.0,376330.0,-25400.0,-12197.0,-7986.6,-5915.1,-4682.7,-3865.4,-3283.6,-2848.2,-2510.2,-2240.1,-2019.3,-1835.4,-1679.8,-1546.5,-1430.9,-1329.8,-1240.5,-1161.1,-1090.0,-1026.0,-967.96,-915.18,-866.92,-822.63,-781.81,-744.08,-709.07,-676.5,-646.12,-617.7,-591.04,-565.99,-542.39,-520.12,-499.05,-479.09,-460.14,-442.13,-424.97,-408.61,-392.97,-378.02,-363.69,-349.95,-336.76,-324.07,-311.85,-300.08,-288.71,-277.74,-267.12,-256.85,-246.89,-237.23,-227.86,-218.75,-209.89,-201.26,-192.86,-184.66,-176.66,-168.85,-161.21,-153.74,-146.43,-139.26,-132.23,-125.34,-118.57,-111.92,-105.39,-98.958,-92.628,-86.394,-80.249,-74.19,-68.212,-62.31,-56.48,-50.718,-45.021,-39.386,-33.807,-28.284,-22.812,-17.389,-12.011,-6.6771,-1.3839,3.8708,9.0892,14.273,19.425,24.547,29.64,34.707,39.749,44.767,49.763,54.738,59.694,64.632,69.553,74.459,79.35,84.227,89.092,93.945,98.787,103.62,108.44,113.26,118.06,122.86,127.66,132.44,137.22,142.0,146.77,151.54,156.31,161.07,165.83,170.59,175.35,180.11,184.86,189.62,194.38,199.13,203.89,208.65,213.41,218.18,222.95,227.72,232.49,237.27,242.05,246.84,251.64,256.44,261.25,266.07,270.9,275.74,280.59,285.44,290.32,295.2,300.1,305.01,309.94,314.89,319.86,324.84,329.85,334.88,339.94,345.02,350.13,355.26,360.43,365.64,370.88,376.15,381.47,386.83,392.23,397.68,403.18,408.74,414.35,420.02,425.75,431.56,437.43,443.37,449.4,455.51,461.71,468.0,474.39,480.88,487.49,494.21,501.05,508.03,515.14,522.39,529.81,537.38,545.13,553.06,561.18,569.5,578.05,586.82,595.84,605.12,614.68,624.53,634.69,645.19,656.04,667.27,678.9,690.97,703.5,716.53,730.09,744.22,758.97,774.39,790.52,807.43,825.17,843.83,863.49,884.22,906.14,929.35,953.97,980.17,1008.1,1037.9,1069.9,1104.2,1141.2,1181.2,1224.6,1271.8,1323.5,1380.2,1442.7,1512.1,1589.5,1676.5,1774.8,1887.1,2016.4,2167.0,2344.7,2557.5,2816.9,3140.5,3555.2,4106.1,4873.4,6016.1,7899.4,11589.0,22078.0,279470.0,-25721.0,-12180.0,-7929.0,-5849.6,-4616.1,-3799.6,-3219.2,-2785.3,-2448.7,-2180.0,-1960.4,-1777.6,-1623.2,-1490.8,-1376.2,-1276.0,-1187.6,-1109.0,-1038.7,-975.47,-918.26,-866.25,-818.77,-775.25,-735.2,-698.24,-664.01,-632.23,-602.64,-575.01,-549.17,-524.94,-502.18,-480.75,-460.55,-441.47,-423.42,-406.31,-390.08,-374.67,-360.0,-346.03,-332.72,-320.0,-307.85,-296.23,-285.1,-274.44,-264.21,-254.4,-244.96,-235.89,-227.17,-218.76,-210.67,-202.86,-195.33,-188.06,-181.03,},
{555.42,562.51,569.85,577.46,585.35,593.54,602.04,610.89,620.08,629.65,639.62,650.02,660.86,672.19,684.04,696.43,709.42,723.04,737.34,752.37,768.2,784.88,802.48,821.09,840.79,861.69,883.89,907.52,932.73,959.67,988.54,1019.5,1052.9,1089.0,1128.1,1170.5,1216.8,1267.6,1323.4,1385.1,1453.7,1530.3,1616.6,1714.4,1826.2,1955.3,2106.0,2284.3,2498.4,2760.5,3088.7,3511.7,4077.3,4872.7,6073.5,8095.7,12221.0,25287.0,-299840.0,-21353.0,-10993.0,-7366.5,-5518.6,-4398.4,-3646.7,-3107.4,-2701.4,-2384.8,-2131.0,-1922.9,-1749.1,-1601.9,-1475.5,-1365.8,-1269.6,-1184.7,-1109.1,-1041.3,-980.22,-924.88,-874.48,-828.39,-786.07,-747.06,-710.98,-677.5,-646.35,-617.28,-590.09,-564.58,-540.61,-518.03,-496.72,-476.56,-457.46,-439.33,-422.1,-405.69,-390.04,-375.1,-360.8,-347.11,-333.99,-321.38,-309.27,-297.61,-286.37,-275.54,-265.07,-254.96,-245.17,-235.69,-226.5,-217.59,-208.93,-200.51,-192.32,-184.34,-176.57,-168.98,-161.58,-154.35,-147.28,-140.37,-133.6,-126.96,-120.46,-114.07,-107.81,-101.65,-95.6,-89.647,-83.788,-78.017,-72.33,-66.723,-61.192,-55.731,-50.338,-45.01,-39.742,-34.531,-29.374,-24.269,-19.213,-14.202,-9.2344,-4.308,0.5798,5.4311,10.248,15.032,19.786,24.511,29.209,33.882,38.531,43.157,47.762,52.348,56.914,61.464,65.997,70.516,75.02,79.511,83.99,88.457,92.914,97.361,101.8,106.23,110.65,115.07,119.47,123.88,128.27,132.67,137.05,141.44,145.82,150.19,154.57,158.94,163.31,167.68,172.04,176.41,180.77,185.14,189.5,193.86,198.23,202.59,206.96,211.33,215.7,220.07,224.45,228.83,233.21,237.59,241.98,246.38,250.78,255.18,259.59,264.01,268.44,272.87,277.32,281.77,286.23,290.7,295.19,299.69,304.2,308.72,313.27,317.83,322.4,327.0,331.62,336.25,340.92,345.6,350.32,355.06,359.83,364.63,369.47,374.34,379.25,384.2,389.19,394.23,399.31,404.45,409.64,414.88,420.19,425.55,430.99,436.49,442.07,447.72,453.46,459.28,465.2,471.21,477.33,483.55,489.89,496.35,502.93,509.65,516.51,523.52,530.69,538.03,545.55,553.25,561.15,569.27,577.6,586.18,595.01,604.1,613.48,623.16,633.16,643.5,654.21,665.31,676.83,688.8,701.24,714.2,727.71,741.81,756.55,771.98,788.15,805.14,822.99,841.8,861.65,882.62,904.84,928.41,953.48,980.2,1008.8,1039.3,1072.2,1107.6,1145.8,1187.3,1232.4,1281.7,1335.9,1395.5,1461.7,1535.4,1618.2,1711.8,1818.4,1941.1,2083.7,2251.6,2452.3,2696.4,2999.7,3386.9,3898.2,4605.1,5646.3,7332.8,10534.0,18958.0,101970.0,-29483.0,-12746.0,-8075.8,-5880.2,-4604.2,-3770.0,-3182.1,-2745.3,-2408.1,-2139.7,-1921.2,-1739.7,-1586.6,-1455.8,-1342.6,-1243.7,-1156.6,-1079.2,-1010.1,-948.0,-891.83,-840.8,-794.25,-751.6,-712.38,-676.19,-642.7,-611.61,-582.68,-555.68,-530.44,-506.77,-484.55,-463.63,-443.92,-425.3,-407.7,-391.02,-375.2,-360.17,-345.88,-332.27,-319.29,-306.91,-295.08,-283.76,-272.93,-262.55,-252.6,-243.04,-233.87,-225.04,-216.55,-208.38,-200.5,},
{574.29,582.21,590.43,598.98,607.87,617.12,626.76,636.8,647.28,658.23,669.68,681.66,694.2,707.36,721.17,735.69,750.97,767.08,784.08,802.05,821.07,841.24,862.66,885.46,909.78,935.77,963.61,993.51,1025.7,1060.4,1098.1,1139.0,1183.6,1232.4,1286.2,1345.5,1411.4,1485.1,1567.9,1661.8,1769.0,1892.7,2036.9,2207.3,2411.7,2661.5,2973.5,3374.4,3908.7,4656.1,5776.0,7639.4,11355.0,22418.0,1955000.0,-22604.0,-11152.0,-7364.5,-5475.8,-4344.2,-3590.4,-3052.2,-2648.7,-2334.8,-2083.7,-1878.3,-1707.0,-1562.0,-1437.7,-1329.9,-1235.6,-1152.2,-1078.1,-1011.8,-951.96,-897.81,-848.53,-803.49,-762.14,-724.05,-688.83,-656.18,-625.8,-597.47,-570.97,-546.13,-522.8,-500.82,-480.09,-460.49,-441.93,-424.32,-407.59,-391.67,-376.49,-361.99,-348.14,-334.88,-322.17,-309.98,-298.26,-286.99,-276.14,-265.67,-255.58,-245.82,-236.39,-227.26,-218.41,-209.83,-201.51,-193.42,-185.56,-177.9,-170.45,-163.18,-156.1,-149.18,-142.42,-135.81,-129.35,-123.02,-116.82,-110.74,-104.78,-98.921,-93.17,-87.517,-81.957,-76.485,-71.097,-65.788,-60.555,-55.393,-50.299,-45.269,-40.3,-35.389,-30.532,-25.727,-20.97,-16.261,-11.595,-6.9701,-2.3849,2.1633,6.6764,11.156,15.605,20.025,24.417,28.782,33.123,37.441,41.737,46.013,50.27,54.508,58.73,62.936,67.127,71.305,75.47,79.622,83.764,87.895,92.017,96.129,100.23,104.33,108.42,112.5,116.58,120.65,124.72,128.78,132.84,136.89,140.94,144.99,149.04,153.08,157.12,161.16,165.19,169.23,173.27,177.3,181.33,185.37,189.4,193.43,197.47,201.5,205.53,209.57,213.61,217.65,221.69,225.73,229.78,233.83,237.88,241.94,246.0,250.06,254.13,258.21,262.29,266.37,270.47,274.57,278.68,282.79,286.92,291.06,295.2,299.36,303.53,307.72,311.92,316.13,320.37,324.61,328.88,333.17,337.48,341.81,346.16,350.54,354.95,359.39,363.85,368.35,372.89,377.46,382.07,386.71,391.41,396.14,400.93,405.76,410.65,415.6,420.61,425.67,430.81,436.02,441.29,446.65,452.09,457.62,463.23,468.95,474.76,480.69,486.72,492.88,499.16,505.57,512.13,518.83,525.69,532.72,539.92,547.3,554.88,562.67,570.68,578.93,587.42,596.17,605.21,614.54,624.18,634.17,644.51,655.23,666.37,677.94,689.98,702.53,715.61,729.28,743.58,758.55,774.25,790.74,808.08,826.37,845.66,866.07,887.69,910.64,935.06,961.11,988.94,1018.8,1050.8,1085.4,1122.7,1163.2,1207.4,1255.6,1308.6,1367.0,1431.8,1504.1,1585.3,1677.1,1781.9,1902.6,2043.0,2208.6,2406.7,2648.2,2948.8,3333.6,3843.7,4552.2,5603.1,7323.6,10654.0,19842.0,163060.0,-25664.0,-11776.0,-7589.2,-5570.2,-4381.5,-3598.1,-3043.0,-2629.0,-2308.4,-2052.8,-1844.1,-1670.7,-1524.1,-1398.7,-1290.1,-1195.2,-1111.5,-1037.2,-970.75,-910.97,-856.91,-807.78,-762.94,-721.84,-684.05,-649.16,-616.87,-586.89,-558.97,-532.93,-508.56,-485.72,-464.27,-444.07,-425.04,-407.06,-390.06,-373.95,-358.66,-344.14,-330.34,-317.18,-304.65,-292.68,-281.24,-270.31,-259.83,-249.8,-240.18,-230.94,-222.06,},
{595.13,604.02,613.28,622.93,633.0,643.51,654.5,666.0,678.03,690.65,703.9,717.81,732.46,747.88,764.16,781.35,799.55,818.83,839.3,861.08,884.3,909.09,935.63,964.12,994.76,1027.8,1063.6,1102.4,1144.7,1191.0,1241.8,1297.9,1360.1,1429.4,1507.3,1595.3,1695.6,1810.9,1945.0,2102.8,2291.2,2520.1,2804.0,3165.7,3642.2,4298.3,5259.5,6803.0,9688.1,17009.0,73040.0,-31153.0,-12722.0,-7947.0,-5753.2,-4492.9,-3674.7,-3100.7,-2675.7,-2348.3,-2088.3,-1876.9,-1701.6,-1553.8,-1427.5,-1318.3,-1223.0,-1139.1,-1064.5,-997.93,-938.03,-883.88,-834.66,-789.73,-748.55,-710.65,-675.65,-643.22,-613.1,-585.02,-558.79,-534.22,-511.15,-489.46,-469.0,-449.67,-431.39,-414.05,-397.59,-381.93,-367.02,-352.79,-339.2,-326.21,-313.76,-301.82,-290.36,-279.34,-268.73,-258.52,-248.67,-239.16,-229.98,-221.09,-212.49,-204.15,-196.06,-188.21,-180.59,-173.17,-165.96,-158.93,-152.08,-145.4,-138.87,-132.5,-126.27,-120.18,-114.22,-108.37,-102.64,-97.027,-91.513,-86.097,-80.775,-75.542,-70.394,-65.325,-60.332,-55.412,-50.56,-45.772,-41.047,-36.38,-31.768,-27.209,-22.7,-18.238,-13.821,-9.4462,-5.1117,-0.81517,3.4454,7.6719,11.866,16.03,20.166,24.274,28.357,32.416,36.452,40.467,44.462,48.438,52.396,56.338,60.264,64.176,68.074,71.96,75.834,79.696,83.549,87.392,91.226,95.052,98.87,102.68,106.49,110.28,114.08,117.87,121.65,125.43,129.2,132.97,136.74,140.51,144.27,148.03,151.79,155.55,159.3,163.06,166.81,170.56,174.31,178.06,181.81,185.56,189.31,193.06,196.81,200.56,204.31,208.07,211.82,215.57,219.33,223.09,226.85,230.61,234.37,238.14,241.91,245.68,249.46,253.24,257.03,260.82,264.62,268.42,272.23,276.04,279.86,283.69,287.53,291.38,295.24,299.11,302.99,306.88,310.79,314.71,318.64,322.59,326.56,330.55,334.55,338.58,342.63,346.7,350.8,354.93,359.08,363.26,367.47,371.72,376.0,380.32,384.68,389.08,393.52,398.01,402.55,407.14,411.79,416.49,421.26,426.08,430.98,435.94,440.98,446.1,451.3,456.59,461.97,467.45,473.03,478.71,484.51,490.43,496.48,502.66,508.98,515.45,522.07,528.86,535.83,542.98,550.33,557.88,565.65,573.66,581.91,590.42,599.21,608.3,617.7,627.44,637.54,648.02,658.9,670.22,682.01,694.3,707.13,720.54,734.57,749.28,764.72,780.94,798.02,816.04,835.06,855.2,876.56,899.24,923.4,949.19,976.77,1006.4,1038.2,1072.5,1109.7,1150.1,1194.1,1242.2,1295.2,1353.7,1418.8,1491.5,1573.3,1666.0,1772.1,1894.7,2037.8,2207.3,2411.1,2660.9,2974.2,3378.9,3922.0,4688.9,5854.2,7837.7,11967.0,25836.0,-142780.0,-18658.0,-9891.4,-6687.1,-5026.1,-4009.8,-3323.9,-2829.7,-2456.7,-2165.1,-1931.0,-1738.8,-1578.2,-1442.0,-1325.1,-1223.5,-1134.5,-1055.9,-985.91,-923.22,-866.74,-815.59,-769.04,-726.51,-687.49,-651.56,-618.38,-587.63,-559.06,-532.45,-507.59,-484.33,-462.51,-442.01,-422.7,-404.48,-387.28,-370.99,-355.56,-340.91,-326.99,-313.75,-301.13,-289.1,-277.61,-266.63,-256.13,-246.07,},
{618.26,628.3,638.78,649.75,661.23,673.26,685.88,699.13,713.06,727.74,743.2,759.53,776.8,795.09,814.49,835.12,857.07,880.51,905.56,932.42,961.27,992.37,1026.0,1062.4,1102.0,1145.2,1192.6,1244.8,1302.5,1366.8,1438.6,1519.6,1611.5,1716.8,1838.5,1980.9,2149.7,2353.0,2602.7,2916.7,3323.4,3871.1,4648.5,5838.7,7889.3,12262.0,28046.0,-91199.0,-17145.0,-9394.1,-6436.7,-4876.3,-3912.0,-3257.0,-2783.1,-2424.1,-2142.9,-1916.5,-1730.4,-1574.6,-1442.4,-1328.6,-1229.8,-1143.1,-1066.3,-998.0,-936.71,-881.44,-831.33,-785.68,-743.91,-705.56,-670.19,-637.48,-607.14,-578.9,-552.55,-527.9,-504.79,-483.07,-462.62,-443.32,-425.08,-407.8,-391.41,-375.84,-361.02,-346.9,-333.42,-320.54,-308.21,-296.4,-285.07,-274.19,-263.73,-253.66,-243.96,-234.6,-225.56,-216.83,-208.39,-200.21,-192.28,-184.6,-177.14,-169.89,-162.84,-155.98,-149.3,-142.79,-136.44,-130.25,-124.2,-118.28,-112.5,-106.83,-101.29,-95.853,-90.523,-85.294,-80.159,-75.115,-70.156,-65.279,-60.478,-55.752,-51.095,-46.504,-41.976,-37.508,-33.097,-28.739,-24.433,-20.175,-15.964,-11.796,-7.6694,-3.5822,0.46783,4.4826,8.464,12.414,16.334,20.226,24.091,27.931,31.747,35.541,39.314,43.068,46.802,50.519,54.22,57.905,61.575,65.232,68.877,72.51,76.131,79.743,83.344,86.937,90.522,94.099,97.669,101.23,104.79,108.34,111.89,115.43,118.97,122.5,126.03,129.56,133.08,136.6,140.12,143.64,147.15,150.66,154.17,157.68,161.19,164.7,168.21,171.71,175.22,178.72,182.23,185.73,189.24,192.74,196.25,199.75,203.26,206.76,210.27,213.78,217.29,220.8,224.31,227.82,231.34,234.86,238.38,241.9,245.42,248.95,252.48,256.02,259.56,263.1,266.65,270.21,273.77,277.34,280.91,284.49,288.08,291.68,295.29,298.9,302.53,306.17,309.82,313.49,317.17,320.86,324.57,328.3,332.04,335.81,339.59,343.4,347.23,351.09,354.97,358.88,362.81,366.78,370.78,374.82,378.89,383.0,387.16,391.35,395.59,399.88,404.22,408.61,413.05,417.56,422.12,426.76,431.46,436.23,441.08,446.01,451.02,456.12,461.32,466.61,472.01,477.51,483.13,488.87,494.74,500.74,506.89,513.18,519.64,526.26,533.05,540.04,547.22,554.61,562.22,570.06,578.16,586.51,595.15,604.09,613.34,622.93,632.89,643.22,653.97,665.16,676.83,689.0,701.71,715.01,728.94,743.56,758.91,775.06,792.09,810.06,829.06,849.19,870.56,893.3,917.54,943.44,971.18,1001.0,1033.1,1067.8,1105.4,1146.3,1191.0,1240.1,1294.1,1354.0,1420.8,1495.6,1580.1,1676.2,1786.7,1915.0,2065.7,2245.4,2463.4,2733.2,3076.1,3526.3,4143.7,5042.7,6473.1,9104.2,15541.0,55644.0,-34118.0,-12898.0,-7891.4,-5652.5,-4383.2,-3565.8,-2995.3,-2574.6,-2251.5,-1995.5,-1787.7,-1615.6,-1470.8,-1347.3,-1240.6,-1147.6,-1065.7,-993.14,-928.35,-870.16,-817.6,-769.89,-726.39,-686.56,-649.97,-616.22,-585.01,-556.05,-529.11,-503.98,-480.49,-458.48,-437.82,-418.39,-400.07,-382.78,-366.44,-350.96,-336.28,-322.34,-309.08,-296.46,-284.44,-272.96,},
{644.08,655.48,667.44,679.99,693.17,707.04,721.65,737.06,753.34,770.57,788.83,808.21,828.82,850.79,874.25,899.35,926.29,955.27,986.52,1020.3,1057.0,1097.0,1140.7,1188.7,1241.6,1300.2,1365.6,1439.0,1521.8,1616.2,1724.7,1850.6,1998.7,2175.2,2389.3,2654.4,2991.2,3433.4,4039.7,4922.1,6325.2,8902.9,15192.0,53831.0,-33972.0,-12782.0,-7821.6,-5608.5,-4355.2,-3548.5,-2985.8,-2570.9,-2252.3,-1999.9,-1795.0,-1625.4,-1482.6,-1360.7,-1255.5,-1163.7,-1082.9,-1011.3,-947.27,-889.76,-837.79,-790.59,-747.53,-708.07,-671.78,-638.29,-607.27,-578.47,-551.64,-526.58,-503.13,-481.12,-460.43,-440.93,-422.52,-405.11,-388.61,-372.95,-358.07,-343.9,-330.4,-317.5,-305.18,-293.38,-282.08,-271.23,-260.81,-250.8,-241.15,-231.86,-222.9,-214.24,-205.88,-197.79,-189.96,-182.37,-175.01,-167.86,-160.92,-154.18,-147.61,-141.22,-134.99,-128.92,-122.99,-117.21,-111.55,-106.02,-100.61,-95.318,-90.128,-85.041,-80.05,-75.152,-70.341,-65.613,-60.965,-56.392,-51.89,-47.457,-43.088,-38.781,-34.532,-30.339,-26.198,-22.108,-18.065,-14.068,-10.114,-6.2002,-2.3253,1.5129,5.3162,9.0866,12.826,16.535,20.217,23.872,27.502,31.109,34.693,38.257,41.8,45.325,48.832,52.323,55.798,59.259,62.706,66.141,69.564,72.975,76.376,79.767,83.15,86.524,89.89,93.249,96.601,99.948,103.29,106.62,109.95,113.28,116.6,119.92,123.24,126.55,129.86,133.16,136.47,139.77,143.07,146.37,149.67,152.96,156.26,159.55,162.84,166.14,169.43,172.72,176.01,179.3,182.59,185.88,189.17,192.46,195.75,199.04,202.33,205.63,208.92,212.21,215.5,218.8,222.09,225.39,228.69,231.99,235.29,238.59,241.9,245.21,248.52,251.83,255.15,258.47,261.79,265.12,268.46,271.79,275.14,278.49,281.84,285.21,288.58,291.96,295.34,298.74,302.15,305.57,309.0,312.44,315.89,319.36,322.85,326.35,329.86,333.4,336.96,340.53,344.13,347.75,351.4,355.07,358.77,362.49,366.25,370.04,373.87,377.73,381.63,385.57,389.55,393.57,397.64,401.77,405.94,410.17,414.45,418.8,423.21,427.68,432.23,436.85,441.55,446.33,451.2,456.16,461.21,466.36,471.62,476.99,482.48,488.09,493.83,499.7,505.73,511.9,518.24,524.74,531.43,538.3,545.38,552.67,560.18,567.93,575.94,584.21,592.77,601.64,610.83,620.36,630.26,640.56,651.27,662.44,674.09,686.25,698.98,712.31,726.28,740.96,756.39,772.65,789.81,807.94,827.14,847.51,869.17,892.24,916.88,943.25,971.55,1002.0,1034.9,1070.5,1109.2,1151.4,1197.6,1248.4,1304.7,1367.2,1437.1,1515.8,1605.2,1707.5,1825.8,1964.1,2128.1,2325.6,2568.2,2873.2,3268.3,3800.6,4556.4,5714.0,7710.5,11976.0,27468.0,-86014.0,-16495.0,-9039.5,-6185.8,-4678.1,-3745.7,-3112.1,-2653.5,-2306.1,-2033.9,-1814.8,-1634.7,-1484.0,-1356.0,-1246.0,-1150.4,-1066.5,-992.42,-926.41,-867.25,-813.93,-765.61,-721.64,-681.44,-644.55,-610.58,-579.19,-550.1,-523.07,-497.88,-474.36,-452.33,-431.67,-412.25,-393.97,-376.71,-360.41,-344.98,-330.36,-316.48,-303.29,},
{673.09,686.14,699.86,714.33,729.6,745.73,762.81,780.91,800.14,820.6,842.42,865.73,890.69,917.49,946.33,977.46,1011.2,1047.8,1087.7,1131.4,1179.4,1232.4,1291.2,1356.9,1430.7,1514.2,1609.6,1719.4,1847.2,1998.0,2178.5,2398.3,2672.1,3022.3,3486.4,4130.6,5084.9,6644.7,9653.8,17886.0,134270.0,-23908.0,-10877.0,-6998.0,-5134.8,-4040.3,-3320.0,-2810.0,-2429.9,-2135.7,-1901.1,-1709.8,-1550.7,-1416.3,-1301.3,-1201.8,-1114.7,-1038.0,-969.82,-908.83,-853.95,-804.3,-759.16,-717.94,-680.13,-645.34,-613.2,-583.42,-555.75,-529.96,-505.87,-483.3,-462.12,-442.2,-423.42,-405.68,-388.9,-373.0,-357.91,-343.56,-329.89,-316.87,-304.43,-292.54,-281.16,-270.25,-259.79,-249.73,-240.07,-230.76,-221.8,-213.15,-204.81,-196.74,-188.94,-181.39,-174.07,-166.97,-160.09,-153.4,-146.9,-140.58,-134.43,-128.43,-122.58,-116.88,-111.32,-105.88,-100.56,-95.366,-90.277,-85.293,-80.409,-75.62,-70.921,-66.307,-61.776,-57.322,-52.941,-48.631,-44.388,-40.209,-36.09,-32.028,-28.021,-24.067,-20.162,-16.304,-12.491,-8.7207,-4.9906,-1.299,2.3562,5.9767,9.5645,13.121,16.648,20.147,23.62,27.068,30.492,33.893,37.274,40.634,43.976,47.3,50.608,53.9,57.177,60.44,63.691,66.929,70.156,73.372,76.579,79.776,82.965,86.145,89.319,92.485,95.646,98.8,101.95,105.09,108.23,111.37,114.5,117.63,120.75,123.87,126.99,130.11,133.23,136.34,139.45,142.56,145.67,148.78,151.88,154.99,158.09,161.2,164.3,167.4,170.51,173.61,176.71,179.81,182.91,186.01,189.11,192.22,195.32,198.42,201.52,204.62,207.73,210.83,213.93,217.04,220.14,223.25,226.35,229.46,232.57,235.68,238.79,241.91,245.03,248.14,251.26,254.39,257.52,260.65,263.78,266.92,270.06,273.21,276.36,279.52,282.68,285.85,289.03,292.21,295.41,298.61,301.82,305.05,308.28,311.52,314.78,318.05,321.34,324.64,327.96,331.29,334.65,338.02,341.41,344.83,348.27,351.73,355.22,358.74,362.28,365.86,369.47,373.11,376.79,380.5,384.26,388.05,391.9,395.78,399.72,403.71,407.75,411.85,416.0,420.22,424.51,428.86,433.29,437.8,442.38,447.05,451.81,456.66,461.6,466.66,471.82,477.09,482.49,488.01,493.66,499.46,505.4,511.51,517.77,524.21,530.84,537.66,544.68,551.93,559.4,567.13,575.11,583.37,591.92,600.78,609.98,619.54,629.47,639.81,650.59,661.83,673.57,685.84,698.7,712.18,726.33,741.22,756.89,773.43,790.9,809.4,829.02,849.87,872.07,895.77,921.12,948.32,977.57,1009.1,1043.3,1080.3,1120.8,1165.0,1213.6,1267.2,1326.8,1393.4,1468.3,1553.0,1649.9,1761.6,1891.9,2045.8,2230.4,2456.1,2738.0,3100.6,3583.9,4260.7,5276.0,6968.8,10357.0,20547.0,-5605200.0,-19990.0,-9910.3,-6542.2,-4856.6,-3844.6,-3169.7,-2687.5,-2325.8,-2044.3,-1819.1,-1634.8,-1481.2,-1351.2,-1239.8,-1143.2,-1058.6,-984.02,-917.68,-858.32,-804.88,-756.52,-712.54,-672.39,-635.57,-601.69,-570.42,-541.45,-514.55,-489.5,-466.12,-444.24,-423.73,-404.46,-386.32,-369.21,-353.05,-337.77,},
{705.92,720.96,736.86,753.69,771.53,790.49,810.67,832.19,855.18,879.82,906.27,934.75,965.5,998.81,1035.0,1074.5,1117.7,1165.2,1217.7,1276.0,1341.2,1414.4,1497.4,1592.2,1701.5,1828.9,1979.4,2159.9,2380.2,2655.3,3008.5,3478.6,4135.0,5116.1,6742.0,9959.6,19349.0,468750.0,-20718.0,-10046.0,-6591.1,-4882.2,-3862.7,-3185.3,-2702.6,-2341.2,-2060.4,-1836.0,-1652.5,-1499.6,-1370.3,-1259.5,-1163.5,-1079.4,-1005.3,-939.32,-880.3,-827.16,-779.06,-735.31,-695.34,-658.67,-624.91,-593.72,-564.81,-537.94,-512.89,-489.49,-467.57,-446.99,-427.63,-409.38,-392.14,-375.83,-360.38,-345.7,-331.76,-318.48,-305.82,-293.73,-282.17,-271.11,-260.51,-250.35,-240.58,-231.19,-222.16,-213.45,-205.06,-196.95,-189.13,-181.56,-174.23,-167.13,-160.25,-153.58,-147.1,-140.8,-134.67,-128.71,-122.91,-117.25,-111.74,-106.35,-101.1,-95.961,-90.938,-86.024,-81.213,-76.5,-71.88,-67.349,-62.903,-58.537,-54.248,-50.031,-45.884,-41.803,-37.786,-33.828,-29.927,-26.08,-22.286,-18.54,-14.842,-11.187,-7.5758,-4.0045,-0.47157,3.0249,6.4868,9.9159,13.314,16.682,20.022,23.335,26.624,29.888,33.13,36.35,39.551,42.732,45.895,49.042,52.172,55.288,58.389,61.477,64.553,67.617,70.67,73.713,76.747,79.772,82.788,85.797,88.799,91.795,94.784,97.768,100.75,103.72,106.69,109.66,112.62,115.58,118.53,121.48,124.44,127.38,130.33,133.27,136.22,139.16,142.1,145.04,147.98,150.92,153.85,156.79,159.72,162.66,165.59,168.53,171.46,174.4,177.33,180.26,183.2,186.13,189.06,192.0,194.93,197.86,200.8,203.73,206.67,209.6,212.54,215.47,218.41,221.34,224.28,227.22,230.16,233.1,236.04,238.98,241.93,244.87,247.82,250.77,253.72,256.68,259.63,262.59,265.56,268.53,271.5,274.47,277.46,280.44,283.44,286.44,289.44,292.46,295.48,298.51,301.55,304.6,307.66,310.73,313.81,316.91,320.02,323.14,326.28,329.44,332.61,335.81,339.02,342.25,345.51,348.79,352.09,355.42,358.78,362.17,365.58,369.03,372.52,376.04,379.59,383.19,386.83,390.51,394.24,398.02,401.84,405.73,409.66,413.66,417.72,421.84,426.03,430.3,434.64,439.05,443.55,448.14,452.82,457.6,462.48,467.46,472.56,477.78,483.12,488.59,494.2,499.95,505.86,511.93,518.17,524.59,531.21,538.02,545.05,552.3,559.79,567.54,575.56,583.86,592.47,601.41,610.69,620.34,630.39,640.86,651.78,663.19,675.13,687.63,700.73,714.49,728.96,744.2,760.27,777.26,795.24,814.31,834.57,856.14,879.16,903.79,930.2,958.61,989.24,1022.4,1058.3,1097.5,1140.4,1187.5,1239.5,1297.2,1361.6,1433.9,1515.8,1609.3,1717.0,1842.4,1990.3,2167.5,2383.6,2652.9,2997.9,3455.8,4093.0,5040.5,6598.0,9634.5,18162.0,187690.0,-22008.0,-10280.0,-6657.2,-4894.8,-3852.6,-3163.9,-2675.0,-2310.0,-2026.9,-1801.1,-1616.7,-1463.3,-1333.7,-1222.7,-1126.6,-1042.6,-968.51,-902.7,-843.84,-790.9,-743.01,-699.49,-659.77,-623.36,-589.88,-558.98,-530.37,-503.81,-479.08,-456.01,-434.42,-414.19,-395.18,-377.3,},
{743.39,760.88,779.46,799.24,820.33,842.87,867.02,892.95,920.86,951.0,983.64,1019.1,1057.8,1100.2,1146.7,1198.2,1255.3,1319.2,1391.0,1472.3,1565.2,1672.3,1797.1,1944.6,2121.4,2337.2,2606.7,2952.5,3412.7,4055.1,5014.9,6604.2,9744.9,18876.0,404040.0,-20443.0,-9879.5,-6473.9,-4792.0,-3789.3,-3123.6,-2649.3,-2294.2,-2018.5,-1798.1,-1617.9,-1467.9,-1340.9,-1232.2,-1137.9,-1055.4,-982.65,-917.95,-860.04,-807.91,-760.73,-717.81,-678.61,-642.65,-609.54,-578.96,-550.62,-524.27,-499.72,-476.78,-455.3,-435.13,-416.16,-398.28,-381.4,-365.42,-350.29,-335.92,-322.27,-309.27,-296.88,-285.05,-273.75,-262.93,-252.56,-242.62,-233.08,-223.9,-215.07,-206.57,-198.37,-190.46,-182.82,-175.43,-168.28,-161.36,-154.65,-148.15,-141.83,-135.7,-129.73,-123.93,-118.29,-112.78,-107.42,-102.19,-97.082,-92.093,-87.217,-82.448,-77.782,-73.212,-68.735,-64.346,-60.04,-55.815,-51.665,-47.588,-43.58,-39.638,-35.758,-31.938,-28.175,-24.466,-20.808,-17.2,-13.639,-10.122,-6.6481,-3.2143,0.18099,3.5397,6.8636,10.154,13.414,16.643,19.844,23.018,26.167,29.292,32.393,35.473,38.532,41.572,44.594,47.598,50.586,53.559,56.517,59.462,62.393,65.313,68.222,71.12,74.008,76.887,79.758,82.62,85.476,88.324,91.166,94.002,96.833,99.659,102.48,105.3,108.11,110.92,113.73,116.53,119.33,122.13,124.93,127.72,130.52,133.31,136.1,138.89,141.68,144.47,147.25,150.04,152.83,155.61,158.4,161.18,163.97,166.75,169.53,172.32,175.1,177.88,180.67,183.45,186.24,189.02,191.8,194.59,197.37,200.15,202.94,205.72,208.5,211.29,214.07,216.86,219.64,222.43,225.21,228.0,230.79,233.58,236.37,239.16,241.95,244.74,247.54,250.33,253.13,255.93,258.73,261.54,264.35,267.16,269.98,272.8,275.62,278.45,281.28,284.12,286.97,289.82,292.68,295.55,298.42,301.31,304.2,307.11,310.02,312.95,315.89,318.84,321.81,324.79,327.79,330.81,333.84,336.89,339.96,343.06,346.17,349.31,352.48,355.67,358.89,362.14,365.42,368.73,372.08,375.46,378.88,382.34,385.84,389.38,392.97,396.61,400.3,404.05,407.85,411.71,415.63,419.61,423.67,427.79,431.99,436.27,440.63,445.07,449.61,454.25,458.98,463.82,468.77,473.84,479.03,484.35,489.8,495.4,501.15,507.06,513.14,519.4,525.84,532.49,539.34,546.42,553.73,561.29,569.12,577.23,585.64,594.37,603.45,612.88,622.71,632.95,643.63,654.8,666.48,678.71,691.54,705.01,719.18,734.11,749.85,766.49,784.11,802.8,822.65,843.8,866.37,890.52,916.41,944.27,974.31,1006.8,1042.1,1080.5,1122.6,1168.8,1219.8,1276.4,1339.6,1410.6,1491.0,1582.8,1688.5,1811.6,1956.9,2130.9,2343.0,2607.6,2946.5,3396.6,4023.0,4954.9,6487.9,9480.6,17914.0,194950.0,-21444.0,-10050.0,-6513.8,-4791.1,-3771.4,-3097.4,-2618.6,-2261.1,-1983.9,-1762.6,-1581.9,-1431.6,-1304.6,-1195.8,-1101.6,-1019.3,-946.65,-882.14,-824.44,-772.54,-725.6,-682.94,-644.0,-608.31,-575.49,-545.19,-517.15,-491.11,-466.87,-444.25,-423.09,},
{786.54,807.1,829.06,852.58,877.82,905.0,934.33,966.09,1000.6,1038.2,1079.3,1124.6,1174.5,1229.9,1291.8,1361.4,1440.1,1529.9,1633.4,1753.8,1895.8,2065.8,2272.8,2530.6,2860.3,3297.1,3903.1,4800.5,6265.6,9087.4,16775.0,120620.0,-22751.0,-10294.0,-6608.5,-4842.6,-3806.3,-3124.9,-2642.6,-2283.4,-2005.3,-1783.7,-1603.0,-1452.8,-1325.9,-1217.3,-1123.4,-1041.2,-968.81,-904.49,-846.96,-795.2,-748.39,-705.83,-666.97,-631.35,-598.57,-568.3,-540.25,-514.2,-489.93,-467.26,-446.04,-426.12,-407.39,-389.74,-373.08,-357.33,-342.4,-328.24,-314.79,-301.98,-289.78,-278.13,-267.0,-256.36,-246.16,-236.39,-227.0,-217.98,-209.31,-200.96,-192.91,-185.14,-177.64,-170.4,-163.39,-156.6,-150.03,-143.66,-137.48,-131.47,-125.64,-119.96,-114.44,-109.07,-103.83,-98.718,-93.734,-88.867,-84.112,-79.464,-74.917,-70.467,-66.109,-61.839,-57.652,-53.545,-49.513,-45.554,-41.664,-37.839,-34.077,-30.375,-26.73,-23.139,-19.599,-16.109,-12.667,-9.2686,-5.9133,-2.5987,0.67706,3.9159,7.1197,10.29,13.428,16.537,19.616,22.668,25.694,28.696,31.674,34.63,37.565,40.48,43.377,46.256,49.117,51.964,54.795,57.612,60.416,63.207,65.987,68.756,71.515,74.264,77.004,79.736,82.46,85.177,87.888,90.592,93.29,95.983,98.672,101.36,104.04,106.71,109.38,112.05,114.72,117.39,120.05,122.71,125.37,128.02,130.68,133.34,135.99,138.64,141.29,143.94,146.59,149.25,151.89,154.54,157.19,159.84,162.49,165.14,167.79,170.44,173.09,175.73,178.38,181.03,183.68,186.33,188.98,191.63,194.27,196.92,199.57,202.22,204.87,207.52,210.17,212.82,215.46,218.11,220.76,223.41,226.06,228.71,231.36,234.02,236.67,239.32,241.98,244.63,247.29,249.95,252.6,255.27,257.93,260.6,263.27,265.94,268.61,271.29,273.97,276.66,279.35,282.05,284.75,287.46,290.17,292.89,295.62,298.36,301.11,303.86,306.63,309.4,312.19,314.99,317.8,320.63,323.47,326.32,329.2,332.09,335.0,337.92,340.87,343.84,346.84,349.85,352.9,355.96,359.06,362.19,365.35,368.54,371.77,375.03,378.33,381.67,385.05,388.48,391.95,395.48,399.05,402.68,406.36,410.1,413.9,417.77,421.71,425.71,429.79,433.95,438.2,442.52,446.94,451.46,456.07,460.79,465.62,470.57,475.63,480.83,486.16,491.64,497.26,503.04,508.99,515.12,521.43,527.94,534.66,541.6,548.77,556.19,563.88,571.84,580.1,588.68,597.6,606.87,616.54,626.61,637.13,648.12,659.62,671.67,684.31,697.59,711.55,726.27,741.81,758.23,775.62,794.07,813.68,834.57,856.88,880.76,906.37,933.93,963.67,995.85,1030.8,1068.9,1110.6,1156.5,1207.1,1263.4,1326.2,1396.9,1476.9,1568.4,1673.9,1797.0,1942.4,2116.9,2330.2,2596.8,2939.7,3397.0,4037.6,4999.3,6604.4,9823.5,19554.0,-1696300.0,-18716.0,-9309.2,-6150.0,-4565.9,-3614.0,-2978.7,-2524.6,-2183.9,-1918.7,-1706.5,-1532.8,-1388.1,-1265.5,-1160.5,-1069.4,-989.7,-919.35,-856.81,-800.84,-750.46,-704.86,-663.41,-625.55,-590.84,-558.9,-529.42,-502.11,-476.75,},
{836.78,861.22,887.51,915.87,946.56,979.87,1016.2,1055.8,1099.4,1147.4,1200.7,1260.1,1326.8,1402.1,1488.0,1586.6,1701.2,1835.9,1996.6,2191.5,2433.1,2740.2,3143.7,3697.5,4504.8,5791.5,8164.9,14008.0,51609.0,-29773.0,-11425.0,-7018.3,-5038.3,-3913.1,-3187.4,-2680.6,-2306.5,-2019.0,-1791.2,-1606.2,-1453.0,-1324.0,-1213.9,-1118.8,-1035.9,-962.87,-898.13,-840.31,-788.35,-741.4,-698.77,-659.88,-624.26,-591.5,-561.28,-533.3,-507.32,-483.14,-460.56,-439.44,-419.62,-401.0,-383.47,-366.92,-351.28,-336.47,-322.42,-309.08,-296.38,-284.29,-272.76,-261.75,-251.21,-241.13,-231.46,-222.19,-213.28,-204.71,-196.47,-188.52,-180.86,-173.47,-166.33,-159.42,-152.74,-146.27,-140.0,-133.92,-128.02,-122.28,-116.71,-111.29,-106.01,-100.87,-95.862,-90.977,-86.209,-81.552,-77.003,-72.555,-68.203,-63.944,-59.772,-55.684,-51.676,-47.743,-43.883,-40.093,-36.368,-32.706,-29.103,-25.559,-22.069,-18.63,-15.242,-11.901,-8.6055,-5.353,-2.1415,1.0307,4.1655,7.2647,10.33,13.363,16.365,19.338,22.283,25.202,28.095,30.965,33.812,36.637,39.442,42.228,44.996,47.746,50.479,53.198,55.902,58.592,61.269,63.934,66.588,69.231,71.863,74.487,77.102,79.708,82.307,84.899,87.485,90.064,92.638,95.207,97.77,100.33,102.89,105.44,107.99,110.53,113.07,115.62,118.15,120.69,123.23,125.76,128.29,130.82,133.35,135.88,138.41,140.94,143.46,145.99,148.52,151.05,153.57,156.1,158.62,161.15,163.68,166.2,168.73,171.26,173.78,176.31,178.83,181.36,183.89,186.41,188.94,191.47,193.99,196.52,199.05,201.57,204.1,206.63,209.15,211.68,214.2,216.73,219.26,221.78,224.31,226.84,229.36,231.89,234.42,236.95,239.48,242.01,244.54,247.07,249.6,252.14,254.67,257.21,259.75,262.29,264.84,267.38,269.93,272.49,275.05,277.61,280.18,282.75,285.33,287.91,290.5,293.09,295.7,298.31,300.93,303.56,306.2,308.85,311.51,314.18,316.87,319.57,322.28,325.01,327.75,330.52,333.29,336.09,338.91,341.75,344.61,347.5,350.41,353.34,356.31,359.3,362.32,365.37,368.46,371.58,374.74,377.94,381.18,384.46,387.78,391.16,394.58,398.05,401.57,405.16,408.8,412.5,416.27,420.11,424.02,428.0,432.06,436.2,440.43,444.75,449.17,453.69,458.31,463.04,467.89,472.85,477.95,483.19,488.56,494.09,499.77,505.62,511.64,517.86,524.26,530.88,537.72,544.79,552.1,559.68,567.54,575.7,584.17,592.98,602.15,611.7,621.67,632.08,642.96,654.35,666.28,678.81,691.98,705.83,720.44,735.87,752.18,769.46,787.8,807.32,828.11,850.33,874.12,899.66,927.16,956.85,989.01,1024.0,1062.1,1103.9,1149.9,1200.7,1257.3,1320.5,1391.7,1472.6,1565.1,1672.1,1797.2,1945.4,2124.0,2343.2,2618.6,2975.3,3455.3,4136.0,5176.7,6965.9,10765.0,24295.0,-85535.0,-15221.0,-8271.3,-5638.9,-4254.2,-3400.1,-2820.6,-2401.6,-2084.5,-1836.2,-1636.5,-1472.3,-1335.0,-1218.5,-1118.3,-1031.3,-955.05,-887.62,-827.58,-773.78,-725.3,-681.39,-641.42,-604.89,-571.37,-540.5,},
{896.01,925.48,957.44,992.21,1030.2,1071.9,1117.7,1168.5,1225.1,1288.4,1359.8,1440.9,1533.9,1641.6,1767.7,1917.4,2098.1,2320.5,2600.9,2965.5,3458.6,4163.2,5252.1,7158.1,11353.0,28159.0,-55446.0,-13776.0,-7801.2,-5409.7,-4121.6,-3316.3,-2765.3,-2364.4,-2059.7,-1820.3,-1627.1,-1468.0,-1334.7,-1221.3,-1123.7,-1038.9,-964.34,-898.4,-839.63,-786.92,-739.36,-696.24,-656.96,-621.02,-588.01,-557.59,-529.45,-503.35,-479.07,-456.43,-435.25,-415.41,-396.77,-379.23,-362.69,-347.07,-332.28,-318.27,-304.96,-292.31,-280.27,-268.79,-257.83,-247.35,-237.32,-227.72,-218.51,-209.66,-201.16,-192.98,-185.11,-177.52,-170.19,-163.12,-156.29,-149.68,-143.29,-137.09,-131.08,-125.25,-119.59,-114.1,-108.75,-103.55,-98.489,-93.557,-88.749,-84.059,-79.482,-75.011,-70.643,-66.371,-62.192,-58.101,-54.095,-50.168,-46.318,-42.54,-38.832,-35.191,-31.613,-28.096,-24.636,-21.232,-17.88,-14.578,-11.325,-8.1168,-4.9527,-1.8302,1.2524,4.2971,7.3056,10.28,13.221,16.13,19.01,21.861,24.686,27.484,30.258,33.009,35.738,38.446,41.133,43.802,46.453,49.087,51.705,54.308,56.897,59.472,62.035,64.585,67.124,69.653,72.172,74.682,77.183,79.676,82.161,84.64,87.112,89.578,92.038,94.494,96.944,99.391,101.83,104.27,106.71,109.14,111.57,114.0,116.42,118.85,121.27,123.69,126.11,128.53,130.94,133.36,135.78,138.19,140.61,143.02,145.44,147.85,150.27,152.68,155.09,157.51,159.92,162.34,164.75,167.17,169.58,172.0,174.41,176.83,179.24,181.66,184.08,186.49,188.91,191.32,193.74,196.15,198.57,200.98,203.4,205.82,208.23,210.64,213.06,215.47,217.89,220.3,222.72,225.13,227.55,229.96,232.38,234.79,237.21,239.62,242.04,244.46,246.87,249.29,251.71,254.13,256.56,258.98,261.41,263.84,266.27,268.71,271.14,273.58,276.03,278.48,280.93,283.39,285.86,288.33,290.8,293.28,295.78,298.27,300.78,303.3,305.82,308.36,310.9,313.46,316.03,318.62,321.21,323.83,326.46,329.1,331.76,334.44,337.15,339.87,342.61,345.38,348.17,350.98,353.82,356.69,359.59,362.52,365.49,368.48,371.51,374.58,377.69,380.84,384.04,387.27,390.56,393.89,397.28,400.72,404.22,407.78,411.4,415.08,418.84,422.66,426.56,430.54,434.61,438.76,443.0,447.33,451.77,456.31,460.97,465.74,470.63,475.65,480.81,486.11,491.56,497.16,502.94,508.89,515.03,521.37,527.91,534.68,541.68,548.92,556.43,564.23,572.32,580.72,589.47,598.58,608.07,617.98,628.33,639.16,650.5,662.39,674.88,688.01,701.83,716.42,731.83,748.13,765.42,783.78,803.32,824.16,846.45,870.33,895.99,923.65,953.54,985.94,1021.2,1059.7,1102.0,1148.6,1200.2,1257.6,1322.0,1394.7,1477.4,1572.3,1682.4,1811.7,1965.6,2151.9,2382.0,2673.7,3055.2,3575.8,4328.7,5513.6,7652.9,12676.0,38485.0,-35612.0,-11998.0,-7150.1,-5059.2,-3894.1,-3151.4,-2636.6,-2258.7,-1969.6,-1741.2,-1556.2,-1403.3,-1274.9,-1165.4,-1071.0,-988.77,-916.48,-852.44,-795.32,-744.03,-697.75,-655.76,-617.49,},
{966.87,1003.0,1042.6,1086.1,1134.2,1187.6,1247.2,1314.3,1390.3,1477.2,1577.3,1694.0,1831.9,1997.2,2199.0,2451.0,2774.4,3204.9,3806.0,4704.2,6192.3,9135.6,17711.0,406300.0,-19022.0,-9202.4,-6029.2,-4460.6,-3525.1,-2903.8,-2461.1,-2129.6,-1872.2,-1666.4,-1498.2,-1358.1,-1239.6,-1138.0,-1050.0,-973.04,-905.11,-844.72,-790.68,-742.04,-698.02,-657.98,-621.42,-587.88,-557.01,-528.5,-502.09,-477.55,-454.68,-433.31,-413.31,-394.54,-376.89,-360.26,-344.56,-329.72,-315.65,-302.31,-289.64,-277.58,-266.09,-255.13,-244.65,-234.64,-225.05,-215.86,-207.04,-198.56,-190.41,-182.57,-175.02,-167.73,-160.7,-153.91,-147.35,-141.0,-134.85,-128.89,-123.12,-117.51,-112.07,-106.77,-101.63,-96.625,-91.75,-87.001,-82.371,-77.855,-73.446,-69.14,-64.931,-60.816,-56.79,-52.849,-48.989,-45.205,-41.496,-37.857,-34.285,-30.777,-27.33,-23.942,-20.609,-17.33,-14.102,-10.923,-7.7898,-4.7013,-1.6553,1.3503,4.3173,7.2473,10.142,13.003,15.833,18.631,21.401,24.142,26.858,29.548,32.214,34.857,37.479,40.08,42.662,45.225,47.771,50.299,52.813,55.311,57.795,60.266,62.724,65.171,67.606,70.031,72.446,74.852,77.25,79.639,82.021,84.396,86.765,89.127,91.485,93.837,96.184,98.527,100.87,103.2,105.53,107.86,110.19,112.51,114.84,117.16,119.48,121.79,124.11,126.42,128.74,131.05,133.37,135.68,137.99,140.3,142.61,144.93,147.24,149.55,151.86,154.17,156.49,158.8,161.11,163.42,165.74,168.05,170.36,172.68,174.99,177.3,179.62,181.93,184.25,186.56,188.88,191.19,193.51,195.82,198.13,200.45,202.76,205.08,207.39,209.7,212.02,214.33,216.64,218.95,221.26,223.58,225.89,228.2,230.51,232.82,235.14,237.45,239.76,242.07,244.39,246.7,249.02,251.33,253.65,255.97,258.29,260.61,262.93,265.26,267.59,269.92,272.25,274.59,276.93,279.28,281.63,283.99,286.35,288.71,291.09,293.47,295.85,298.25,300.65,303.06,305.48,307.92,310.36,312.81,315.28,317.76,320.25,322.76,325.28,327.82,330.38,332.96,335.55,338.17,340.8,343.46,346.14,348.85,351.58,354.34,357.13,359.95,362.8,365.68,368.6,371.55,374.55,377.58,380.65,383.77,386.94,390.15,393.41,396.72,400.09,403.52,407.01,410.56,414.18,417.86,421.62,425.46,429.37,433.37,437.45,441.63,445.91,450.28,454.77,459.36,464.07,468.91,473.87,478.97,484.22,489.61,495.17,500.89,506.8,512.89,519.18,525.68,532.4,539.36,546.57,554.05,561.8,569.86,578.24,586.97,596.05,605.53,615.43,625.78,636.61,647.96,659.86,672.38,685.54,699.41,714.06,729.54,745.93,763.33,781.82,801.52,822.55,845.05,869.2,895.17,923.19,953.51,986.44,1022.3,1061.6,1104.7,1152.3,1205.2,1264.2,1330.6,1405.6,1491.3,1590.1,1705.1,1840.9,2003.4,2201.7,2448.8,2765.5,3185.8,3770.9,4641.0,6071.8,8862.9,16712.0,176290.0,-20120.0,-9405.0,-6088.2,-4473.8,-3518.8,-2887.7,-2439.5,-2104.9,-1845.4,-1638.4,-1469.4,-1328.7,-1209.9,-1108.1,-1020.1,-943.03,-875.12,-814.79,-760.85,-712.32,},
{1053.2,1098.4,1148.5,1204.3,1266.9,1337.6,1418.0,1510.3,1617.4,1743.0,1892.6,2073.6,2297.3,2580.5,2950.8,3455.7,4184.9,5330.6,7392.0,12199.0,36165.0,-36067.0,-11878.0,-7053.8,-4987.5,-3839.8,-3109.6,-2604.1,-2233.3,-1949.8,-1726.0,-1544.7,-1395.0,-1269.2,-1162.0,-1069.6,-989.06,-918.28,-855.56,-799.61,-749.37,-704.02,-662.87,-625.35,-591.01,-559.45,-530.35,-503.42,-478.44,-455.19,-433.5,-413.21,-394.19,-376.32,-359.51,-343.64,-328.66,-314.48,-301.03,-288.27,-276.13,-264.58,-253.56,-243.04,-232.99,-223.38,-214.16,-205.33,-196.84,-188.69,-180.85,-173.3,-166.03,-159.01,-152.23,-145.69,-139.36,-133.23,-127.3,-121.55,-115.98,-110.57,-105.31,-100.21,-95.238,-90.403,-85.695,-81.108,-76.636,-72.272,-68.013,-63.852,-59.786,-55.81,-51.92,-48.112,-44.382,-40.727,-37.143,-33.627,-30.177,-26.788,-23.459,-20.186,-16.968,-13.802,-10.685,-7.615,-4.5906,-1.6095,1.3303,4.2307,7.0934,9.9201,12.712,15.472,18.2,20.898,23.568,26.211,28.827,31.419,33.988,36.534,39.058,41.563,44.048,46.515,48.965,51.398,53.816,56.219,58.608,60.983,63.347,65.698,68.039,70.369,72.69,75.001,77.304,79.599,81.887,84.167,86.441,88.709,90.972,93.229,95.482,97.73,99.974,102.22,104.45,106.69,108.92,111.15,113.38,115.6,117.83,120.05,122.27,124.49,126.71,128.93,131.15,133.36,135.58,137.8,140.02,142.23,144.45,146.67,148.89,151.1,153.32,155.54,157.76,159.98,162.2,164.42,166.64,168.86,171.08,173.3,175.52,177.74,179.96,182.18,184.41,186.63,188.85,191.07,193.29,195.51,197.73,199.96,202.18,204.4,206.62,208.84,211.06,213.28,215.5,217.72,219.93,222.15,224.37,226.59,228.81,231.02,233.24,235.46,237.68,239.89,242.11,244.33,246.55,248.77,250.99,253.21,255.43,257.65,259.88,262.11,264.33,266.57,268.8,271.04,273.28,275.52,277.77,280.02,282.27,284.54,286.8,289.07,291.35,293.64,295.93,298.23,300.54,302.86,305.18,307.52,309.87,312.23,314.6,316.98,319.38,321.8,324.22,326.67,329.13,331.61,334.11,336.62,339.16,341.72,344.31,346.92,349.55,352.21,354.9,357.62,360.37,363.15,365.96,368.81,371.7,374.63,377.59,380.6,383.66,386.76,389.91,393.11,396.37,399.68,403.05,406.48,409.97,413.53,417.16,420.87,424.65,428.52,432.46,436.5,440.63,444.86,449.19,453.63,458.18,462.85,467.64,472.57,477.64,482.85,488.21,493.73,499.43,505.31,511.37,517.64,524.12,530.83,537.78,544.98,552.45,560.21,568.27,576.66,585.4,594.51,604.01,613.95,624.34,635.22,646.63,658.61,671.21,684.48,698.47,713.26,728.9,745.47,763.08,781.82,801.8,823.15,846.03,870.61,897.08,925.68,956.67,990.39,1027.2,1067.5,1112.0,1161.2,1215.9,1277.2,1346.2,1424.7,1514.7,1618.9,1740.9,1885.8,2060.8,2276.1,2547.8,2901.1,3379.5,4063.8,5123.3,6983.2,11102.0,27954.0,-50638.0,-13066.0,-7428.0,-5152.6,-3922.6,-3152.1,-2624.1,-2239.7,-1947.4,-1717.5,-1532.0,-1379.2,-1251.1,-1142.2,-1048.4,-966.89,-895.32,-831.98,},
{1160.6,1218.6,1283.9,1357.9,1442.3,1539.8,1653.4,1787.7,1948.7,2145.3,2390.9,2706.4,3126.5,3713.5,4591.9,6050.1,8944.9,17461.0,596770.0,-18176.0,-8861.3,-5818.9,-4309.1,-3406.8,-2806.7,-2378.8,-2058.2,-1809.0,-1609.9,-1447.0,-1311.3,-1196.5,-1098.1,-1012.8,-938.19,-872.35,-813.82,-761.44,-714.29,-671.61,-632.81,-597.36,-564.85,-534.93,-507.29,-481.69,-457.9,-435.74,-415.03,-395.65,-377.46,-360.36,-344.25,-329.05,-314.67,-301.05,-288.13,-275.86,-264.19,-253.07,-242.46,-232.33,-222.64,-213.36,-204.48,-195.95,-187.76,-179.89,-172.31,-165.02,-157.99,-151.2,-144.65,-138.32,-132.2,-126.27,-120.53,-114.97,-109.57,-104.33,-99.241,-94.294,-89.483,-84.801,-80.24,-75.797,-71.464,-67.236,-63.11,-59.079,-55.14,-51.288,-47.519,-43.83,-40.217,-36.676,-33.204,-29.799,-26.457,-23.175,-19.951,-16.783,-13.667,-10.602,-7.585,-4.6143,-1.6877,1.1966,4.0406,6.846,9.6144,12.348,15.047,17.715,20.351,22.959,25.538,28.09,30.617,33.12,35.6,38.057,40.494,42.91,45.308,47.687,50.05,52.396,54.726,57.042,59.344,61.633,63.91,66.175,68.429,70.673,72.907,75.132,77.348,79.556,81.757,83.951,86.138,88.319,90.495,92.665,94.831,96.992,99.15,101.3,103.45,105.6,107.75,109.89,112.03,114.17,116.3,118.44,120.57,122.7,124.84,126.97,129.1,131.23,133.36,135.49,137.62,139.75,141.88,144.01,146.14,148.27,150.4,152.53,154.67,156.8,158.93,161.06,163.2,165.33,167.47,169.6,171.73,173.87,176.01,178.14,180.28,182.41,184.55,186.69,188.82,190.96,193.1,195.23,197.37,199.5,201.64,203.77,205.91,208.04,210.18,212.31,214.44,216.58,218.71,220.84,222.97,225.11,227.24,229.37,231.5,233.63,235.76,237.89,240.02,242.15,244.28,246.41,248.54,250.67,252.81,254.94,257.07,259.21,261.35,263.49,265.63,267.77,269.92,272.07,274.22,276.38,278.54,280.7,282.87,285.05,287.23,289.41,291.6,293.8,296.01,298.22,300.44,302.67,304.91,307.17,309.43,311.7,313.98,316.28,318.59,320.92,323.26,325.62,327.99,330.38,332.79,335.22,337.67,340.15,342.64,345.16,347.7,350.27,352.87,355.5,358.16,360.85,363.57,366.32,369.12,371.95,374.82,377.73,380.69,383.69,386.74,389.84,392.99,396.2,399.46,402.78,406.17,409.62,413.13,416.72,420.39,424.13,427.96,431.87,435.87,439.97,444.16,448.46,452.87,457.4,462.04,466.81,471.72,476.76,481.96,487.31,492.82,498.51,504.38,510.45,516.72,523.2,529.92,536.88,544.1,551.6,559.39,567.49,575.92,584.71,593.88,603.45,613.47,623.95,634.93,646.46,658.58,671.33,684.77,698.95,713.95,729.84,746.69,764.62,783.71,804.1,825.91,849.32,874.5,901.67,931.07,963.0,997.79,1035.9,1077.7,1123.9,1175.1,1232.4,1296.7,1369.4,1452.5,1548.2,1659.7,1791.2,1948.7,2140.7,2379.9,2686.3,3092.8,3658.1,4497.8,5875.9,8554.9,16023.0,149250.0,-19886.0,-9208.7,-5942.9,-4359.9,-3425.4,-2808.7,-2371.3,-2044.8,-1791.8,-1590.0,-1425.3,-1288.3,-1172.6,-1073.5,-987.73,},
{1297.9,1374.8,1463.0,1565.2,1684.9,1827.2,1999.0,2210.6,2477.7,2825.5,3296.9,3972.0,5019.7,6865.6,10984.0,28282.0,-46634.0,-12595.0,-7218.6,-5027.8,-3838.4,-3091.6,-2579.0,-2205.3,-1920.9,-1697.1,-1516.5,-1367.5,-1242.7,-1136.4,-1045.0,-965.37,-895.48,-833.61,-778.47,-728.99,-684.35,-643.88,-607.0,-573.26,-542.28,-513.72,-487.31,-462.81,-440.02,-418.77,-398.9,-380.28,-362.8,-346.34,-330.83,-316.18,-302.32,-289.19,-276.73,-264.88,-253.6,-242.85,-232.6,-222.8,-213.42,-204.45,-195.84,-187.58,-179.65,-172.02,-164.68,-157.61,-150.79,-144.21,-137.85,-131.71,-125.77,-120.01,-114.44,-109.04,-103.8,-98.711,-93.769,-88.965,-84.293,-79.745,-75.315,-70.999,-66.79,-62.684,-58.676,-54.76,-50.934,-47.193,-43.533,-39.95,-36.441,-33.003,-29.632,-26.326,-23.081,-19.896,-16.767,-13.692,-10.668,-7.6945,-4.7678,-1.8863,0.95194,3.7488,6.506,9.2254,11.909,14.557,17.173,19.756,22.31,24.835,27.332,29.803,32.248,34.67,37.068,39.445,41.801,44.138,46.455,48.755,51.037,53.304,55.555,57.791,60.014,62.223,64.421,66.606,68.781,70.945,73.1,75.245,77.382,79.51,81.631,83.745,85.853,87.954,90.05,92.14,94.226,96.307,98.384,100.46,102.53,104.59,106.66,108.72,110.78,112.84,114.89,116.95,119.0,121.05,123.1,125.15,127.2,129.25,131.3,133.35,135.4,137.45,139.5,141.55,143.6,145.65,147.7,149.75,151.8,153.85,155.9,157.96,160.01,162.07,164.12,166.17,168.23,170.29,172.34,174.4,176.45,178.51,180.57,182.63,184.68,186.74,188.8,190.86,192.91,194.97,197.03,199.09,201.14,203.2,205.25,207.31,209.37,211.42,213.47,215.53,217.58,219.63,221.69,223.74,225.79,227.84,229.89,231.94,233.99,236.04,238.09,240.14,242.19,244.24,246.29,248.33,250.39,252.44,254.49,256.54,258.6,260.65,262.71,264.77,266.83,268.89,270.96,273.03,275.1,277.18,279.26,281.34,283.43,285.52,287.62,289.73,291.84,293.96,296.09,298.22,300.36,302.51,304.68,306.85,309.03,311.22,313.43,315.65,317.88,320.12,322.39,324.66,326.96,329.27,331.6,333.95,336.32,338.71,341.12,343.56,346.02,348.51,351.03,353.57,356.15,358.75,361.39,364.06,366.77,369.51,372.3,375.12,377.99,380.9,383.86,386.87,389.93,393.04,396.2,399.43,402.72,406.07,409.48,412.97,416.53,420.16,423.88,427.68,431.57,435.55,439.62,443.8,448.08,452.48,456.99,461.62,466.39,471.29,476.33,481.53,486.88,492.4,498.1,503.99,510.07,516.37,522.88,529.64,536.64,543.9,551.45,559.3,567.47,575.98,584.86,594.12,603.81,613.95,624.56,635.7,647.4,659.71,672.67,686.35,700.8,716.1,732.32,749.56,767.9,787.47,808.4,830.83,854.93,880.9,908.97,939.41,972.54,1008.7,1048.4,1092.2,1140.6,1194.5,1255.0,1323.2,1400.8,1489.9,1593.1,1714.3,1858.4,2032.8,2248.0,2520.5,2876.4,3361.1,4060.2,5155.8,7119.7,11661.0,33543.0,-36473.0,-11630.0,-6852.6,-4823.6,-3701.2,-2988.6,-2496.1,-2135.3,-1859.6,-1642.1,-1466.1,-1320.8,-1198.8,},
{1479.7,1586.0,1711.2,1860.6,2042.3,2267.9,2555.3,2934.3,3456.7,4223.0,5456.2,7769.9,13692.0,61536.0,-23984.0,-9917.0,-6202.9,-4487.0,-3498.4,-2855.7,-2404.2,-2069.8,-1812.0,-1607.3,-1440.7,-1302.6,-1186.1,-1086.6,-1000.7,-925.6,-859.5,-800.84,-748.44,-701.33,-658.75,-620.08,-584.8,-552.48,-522.75,-495.33,-469.94,-446.37,-424.42,-403.94,-384.77,-366.8,-349.91,-334.01,-319.01,-304.84,-291.42,-278.7,-266.62,-255.14,-244.2,-233.78,-223.82,-214.31,-205.21,-196.49,-188.13,-180.1,-172.39,-164.98,-157.84,-150.96,-144.33,-137.92,-131.74,-125.76,-119.98,-114.38,-108.96,-103.7,-98.596,-93.643,-88.831,-84.153,-79.603,-75.174,-70.861,-66.658,-62.56,-58.562,-54.659,-50.847,-47.122,-43.479,-39.916,-36.428,-33.013,-29.667,-26.387,-23.17,-20.013,-16.914,-13.87,-10.88,-7.9397,-5.0481,-2.2029,0.59794,3.3563,6.0739,8.7526,11.394,14.0,16.572,19.111,21.619,24.097,26.546,28.968,31.365,33.736,36.084,38.408,40.712,42.994,45.257,47.502,49.728,51.938,54.131,56.309,58.473,60.623,62.759,64.884,66.996,69.098,71.189,73.271,75.343,77.406,79.462,81.509,83.55,85.584,87.612,89.634,91.65,93.662,95.669,97.672,99.671,101.67,103.66,105.65,107.64,109.62,111.6,113.58,115.56,117.54,119.52,121.5,123.47,125.45,127.42,129.39,131.37,133.34,135.32,137.29,139.26,141.24,143.21,145.19,147.16,149.14,151.12,153.1,155.07,157.05,159.03,161.01,162.99,164.97,166.96,168.94,170.92,172.9,174.89,176.87,178.85,180.84,182.82,184.81,186.79,188.78,190.76,192.75,194.73,196.72,198.7,200.68,202.67,204.65,206.63,208.61,210.59,212.58,214.56,216.54,218.51,220.49,222.47,224.45,226.43,228.4,230.38,232.35,234.33,236.3,238.28,240.25,242.22,244.2,246.17,248.15,250.12,252.1,254.07,256.05,258.03,260.01,261.99,263.97,265.95,267.94,269.93,271.92,273.92,275.92,277.92,279.92,281.93,283.95,285.97,288.0,290.03,292.07,294.11,296.16,298.23,300.3,302.37,304.46,306.56,308.67,310.79,312.92,315.07,317.23,319.4,321.59,323.79,326.02,328.25,330.51,332.79,335.08,337.4,339.74,342.11,344.49,346.91,349.35,351.82,354.32,356.84,359.41,362.0,364.63,367.3,370.0,372.75,375.53,378.36,381.24,384.17,387.14,390.17,393.25,396.39,399.58,402.84,406.17,409.56,413.03,416.57,420.19,423.89,427.67,431.55,435.51,439.58,443.75,448.03,452.43,456.94,461.58,466.35,471.26,476.32,481.53,486.91,492.46,498.19,504.11,510.23,516.57,523.14,529.95,537.02,544.36,551.99,559.93,568.2,576.82,585.82,595.22,605.06,615.36,626.17,637.51,649.44,661.99,675.24,689.22,704.02,719.7,736.35,754.06,772.94,793.12,814.72,837.92,862.89,889.86,919.07,950.82,985.45,1023.4,1065.1,1111.3,1162.5,1219.9,1284.5,1357.7,1441.4,1538.2,1651.3,1785.1,1946.0,2143.2,2390.5,2709.9,3138.0,3742.1,4658.6,6214.6,9438.2,20105.0,-128560.0,-15005.0,-7879.6,-5301.4,-3970.6,-3158.2,-2610.6,-2216.5,-1919.4,-1687.2,-1500.9,},
{1731.7,1887.4,2077.7,2315.6,2621.4,3029.2,3600.1,4456.4,5883.8,8739.1,17310.0,-19650000.0,-16928.0,-8379.5,-5528.3,-4102.4,-3246.7,-2676.1,-2268.5,-1962.8,-1725.0,-1534.7,-1379.0,-1249.3,-1139.4,-1045.3,-963.64,-892.2,-829.15,-773.09,-722.91,-677.73,-636.84,-599.66,-565.69,-534.54,-505.86,-479.38,-454.84,-432.05,-410.81,-390.97,-372.4,-354.97,-338.59,-323.16,-308.59,-294.82,-281.78,-269.42,-257.67,-246.5,-235.85,-225.71,-216.01,-206.75,-197.88,-189.39,-181.24,-173.42,-165.9,-158.67,-151.7,-145.0,-138.53,-132.28,-126.25,-120.41,-114.77,-109.31,-104.01,-98.88,-93.9,-89.065,-84.369,-79.803,-75.362,-71.039,-66.829,-62.727,-58.727,-54.825,-51.016,-47.296,-43.661,-40.107,-36.631,-33.229,-29.897,-26.634,-23.435,-20.298,-17.22,-14.199,-11.233,-8.3182,-5.4534,-2.6363,0.13523,2.863,5.549,8.1948,10.802,13.373,15.909,18.41,20.88,23.319,25.728,28.109,30.463,32.792,35.095,37.375,39.633,41.869,44.084,46.28,48.457,50.617,52.759,54.886,56.997,59.094,61.177,63.246,65.304,67.349,69.384,71.408,73.422,75.427,77.423,79.41,81.39,83.363,85.329,87.289,89.243,91.191,93.134,95.073,97.007,98.938,100.86,102.79,104.71,106.63,108.54,110.46,112.37,114.28,116.19,118.09,120.0,121.9,123.81,125.71,127.62,129.52,131.43,133.33,135.23,137.14,139.04,140.95,142.85,144.76,146.66,148.57,150.48,152.39,154.3,156.21,158.12,160.03,161.94,163.85,165.77,167.68,169.59,171.51,173.42,175.34,177.26,179.17,181.09,183.01,184.92,186.84,188.76,190.67,192.59,194.51,196.42,198.34,200.26,202.17,204.09,206.0,207.92,209.83,211.74,213.65,215.57,217.48,219.39,221.3,223.21,225.11,227.02,228.93,230.83,232.74,234.65,236.55,238.45,240.36,242.26,244.17,246.07,247.98,249.88,251.78,253.69,255.6,257.5,259.41,261.32,263.23,265.15,267.06,268.98,270.9,272.82,274.75,276.68,278.61,280.55,282.49,284.44,286.39,288.35,290.31,292.28,294.26,296.24,298.24,300.24,302.25,304.27,306.3,308.35,310.4,312.47,314.54,316.64,318.74,320.86,323.0,325.16,327.33,329.52,331.73,333.96,336.21,338.48,340.78,343.1,345.44,347.81,350.22,352.64,355.1,357.6,360.12,362.68,365.28,367.91,370.58,373.3,376.05,378.86,381.71,384.61,387.56,390.56,393.62,396.74,399.92,403.16,406.47,409.85,413.3,416.83,420.44,424.14,427.92,431.79,435.76,439.83,444.01,448.3,452.71,457.24,461.89,466.69,471.62,476.71,481.96,487.37,492.97,498.75,504.72,510.91,517.32,523.96,530.85,538.01,545.45,553.19,561.25,569.65,578.42,587.58,597.16,607.19,617.71,628.74,640.34,652.56,665.43,679.02,693.39,708.61,724.76,741.94,760.24,779.78,800.7,823.14,847.28,873.33,901.51,932.12,965.47,1002.0,1042.1,1086.3,1135.4,1190.3,1251.9,1321.6,1401.2,1492.8,1599.5,1725.3,1875.9,2059.4,2287.9,2580.2,2967.6,3505.5,4302.5,5605.6,8121.0,15013.0,114120.0,-19822.0,-9002.6,-5774.4,-4222.9,-3311.1,-2711.0,-2286.0,-1969.3,},
{2104.3,2352.5,2674.0,3106.9,3721.2,4661.3,6279.7,9725.5,22106.0,-73784.0,-13590.0,-7412.7,-5062.0,-3823.0,-3058.0,-2538.5,-2162.8,-1878.3,-1655.5,-1476.2,-1328.8,-1205.6,-1100.9,-1010.9,-932.76,-864.2,-803.59,-749.62,-701.24,-657.64,-618.12,-582.15,-549.26,-519.08,-491.27,-465.57,-441.74,-419.59,-398.94,-379.64,-361.57,-344.6,-328.65,-313.61,-299.41,-285.98,-273.27,-261.2,-249.74,-238.83,-228.44,-218.53,-209.06,-200.01,-191.35,-183.05,-175.08,-167.43,-160.08,-153.01,-146.2,-139.64,-133.31,-127.21,-121.3,-115.6,-110.08,-104.73,-99.553,-94.532,-89.66,-84.93,-80.335,-75.868,-71.523,-67.294,-63.176,-59.164,-55.251,-51.435,-47.71,-44.072,-40.518,-37.044,-33.645,-30.319,-27.063,-23.874,-20.748,-17.683,-14.677,-11.726,-8.829,-5.9831,-3.1862,-0.43643,2.2684,4.93,7.5503,10.131,12.674,15.18,17.652,20.09,22.497,24.873,27.219,29.538,31.83,34.096,36.337,38.556,40.751,42.926,45.08,47.214,49.33,51.428,53.509,55.574,57.624,59.659,61.68,63.689,65.684,67.668,69.641,71.603,73.555,75.497,77.431,79.356,81.274,83.184,85.087,86.984,88.874,90.76,92.639,94.515,96.385,98.252,100.11,101.97,103.83,105.68,107.54,109.38,111.23,113.08,114.92,116.76,118.6,120.44,122.28,124.12,125.96,127.8,129.64,131.48,133.32,135.15,136.99,138.83,140.67,142.51,144.35,146.2,148.04,149.88,151.73,153.57,155.42,157.26,159.11,160.96,162.81,164.66,166.51,168.36,170.21,172.06,173.91,175.76,177.62,179.47,181.32,183.18,185.03,186.88,188.74,190.59,192.45,194.3,196.15,198.01,199.86,201.71,203.56,205.41,207.27,209.12,210.97,212.81,214.66,216.51,218.36,220.2,222.05,223.89,225.74,227.58,229.42,231.26,233.1,234.94,236.78,238.62,240.46,242.3,244.14,245.98,247.82,249.66,251.5,253.34,255.18,257.02,258.86,260.7,262.55,264.39,266.24,268.09,269.95,271.8,273.66,275.52,277.39,279.26,281.13,283.01,284.89,286.78,288.68,290.58,292.49,294.4,296.33,298.26,300.2,302.15,304.11,306.07,308.06,310.05,312.05,314.07,316.1,318.14,320.2,322.28,324.37,326.48,328.61,330.76,332.93,335.12,337.33,339.56,341.82,344.1,346.41,348.75,351.12,353.52,355.94,358.41,360.9,363.43,366.0,368.61,371.26,373.95,376.68,379.47,382.3,385.18,388.11,391.1,394.15,397.25,400.42,403.66,406.96,410.34,413.79,417.32,420.93,424.63,428.42,432.3,436.29,440.37,444.57,448.88,453.31,457.87,462.56,467.39,472.37,477.5,482.8,488.27,493.92,499.77,505.82,512.09,518.59,525.33,532.33,539.6,547.17,555.05,563.26,571.83,580.78,590.14,599.94,610.2,620.98,632.3,644.22,656.77,670.03,684.04,698.87,714.61,731.34,749.15,768.16,788.5,810.31,833.76,859.04,886.38,916.04,948.34,983.65,1022.4,1065.2,1112.5,1165.3,1224.6,1291.5,1367.7,1455.3,1557.1,1676.7,1819.3,1992.3,2206.6,2479.0,2836.7,3327.5,4042.5,5180.8,7276.7,12416.0,44798.0,-26824.0,-10171.0,-6217.0,-4445.9,-3441.0,-2793.6,},
{2711.4,3164.5,3814.6,4826.4,6617.6,10653.0,28233.0,-41204.0,-11731.0,-6777.8,-4734.6,-3619.2,-2916.6,-2433.4,-2080.7,-1811.9,-1600.2,-1429.3,-1288.2,-1169.9,-1069.3,-982.59,-907.13,-840.85,-782.18,-729.87,-682.94,-640.59,-602.19,-567.2,-535.19,-505.79,-478.69,-453.64,-430.39,-408.77,-388.61,-369.77,-352.11,-335.53,-319.93,-305.22,-291.34,-278.2,-265.75,-253.94,-242.72,-232.04,-221.86,-212.16,-202.88,-194.01,-185.52,-177.39,-169.58,-162.09,-154.88,-147.95,-141.27,-134.84,-128.64,-122.65,-116.86,-111.26,-105.85,-100.61,-95.532,-90.608,-85.831,-81.193,-76.688,-72.309,-68.049,-63.904,-59.867,-55.934,-52.099,-48.359,-44.709,-41.145,-37.663,-34.259,-30.93,-27.673,-24.485,-21.362,-18.301,-15.301,-12.359,-9.4718,-6.6373,-3.8535,-1.1181,1.5709,4.2153,6.817,9.3779,11.9,14.384,16.832,19.245,21.626,23.975,26.293,28.583,30.844,33.079,35.289,37.474,39.635,41.774,43.892,45.99,48.068,50.127,52.169,54.194,56.202,58.195,60.174,62.139,64.09,66.029,67.955,69.871,71.776,73.67,75.555,77.432,79.299,81.159,83.011,84.856,86.694,88.526,90.353,92.174,93.99,95.802,97.609,99.412,101.21,103.01,104.8,106.59,108.38,110.17,111.95,113.74,115.52,117.3,119.08,120.86,122.64,124.41,126.19,127.97,129.75,131.52,133.3,135.08,136.86,138.63,140.41,142.19,143.97,145.76,147.54,149.32,151.1,152.89,154.67,156.46,158.25,160.04,161.82,163.61,165.4,167.19,168.99,170.78,172.57,174.36,176.16,177.95,179.75,181.54,183.34,185.13,186.93,188.72,190.52,192.31,194.11,195.9,197.69,199.49,201.28,203.07,204.87,206.66,208.45,210.24,212.03,213.82,215.61,217.4,219.18,220.97,222.75,224.54,226.32,228.1,229.88,231.67,233.45,235.23,237.0,238.78,240.56,242.34,244.12,245.89,247.67,249.45,251.23,253.01,254.78,256.56,258.34,260.13,261.91,263.69,265.48,267.27,269.06,270.85,272.65,274.45,276.25,278.06,279.87,281.68,283.5,285.33,287.16,288.99,290.84,292.69,294.54,296.41,298.28,300.17,302.06,303.96,305.87,307.79,309.73,311.68,313.64,315.61,317.6,319.6,321.62,323.66,325.71,327.79,329.88,331.99,334.12,336.28,338.45,340.66,342.88,345.14,347.42,349.73,352.07,354.44,356.84,359.28,361.75,364.26,366.81,369.4,372.03,374.7,377.42,380.19,383.01,385.88,388.81,391.79,394.83,397.94,401.1,404.34,407.65,411.03,414.49,418.03,421.65,425.36,429.17,433.07,437.08,441.19,445.42,449.76,454.23,458.83,463.57,468.45,473.49,478.68,484.05,489.59,495.32,501.26,507.4,513.77,520.38,527.24,534.38,541.79,549.52,557.57,565.97,574.74,583.91,593.5,603.56,614.11,625.2,636.87,649.16,662.12,675.83,690.34,705.73,722.08,739.48,758.06,777.92,799.2,822.08,846.73,873.38,902.28,933.72,968.07,1005.8,1047.3,1093.2,1144.4,1201.8,1266.5,1340.1,1424.6,1522.5,1637.3,1773.8,1939.0,2142.7,2400.3,2736.5,3193.8,3852.0,4880.6,6715.1,10913.0,30300.0,-36989.0,-11295.0,-6598.9,-4627.1,},
{3876.0,4941.9,6870.8,11424.0,35339.0,-31036.0,-10631.0,-6358.7,-4506.8,-3472.6,-2812.4,-2354.4,-2018.0,-1760.5,-1557.0,-1392.1,-1255.8,-1141.3,-1043.7,-959.46,-886.08,-821.57,-764.4,-713.39,-667.6,-626.25,-588.73,-554.52,-523.22,-494.45,-467.92,-443.39,-420.62,-399.44,-379.68,-361.2,-343.88,-327.62,-312.32,-297.89,-284.26,-271.36,-259.14,-247.55,-236.53,-226.04,-216.04,-206.51,-197.4,-188.69,-180.34,-172.35,-164.68,-157.31,-150.23,-143.42,-136.86,-130.54,-124.44,-118.55,-112.87,-107.37,-102.05,-96.898,-91.908,-87.07,-82.376,-77.82,-73.393,-69.091,-64.907,-60.835,-56.87,-53.008,-49.242,-45.57,-41.986,-38.487,-35.069,-31.729,-28.462,-25.266,-22.138,-19.075,-16.074,-13.132,-10.248,-7.4173,-4.6393,-1.9114,0.76848,3.4024,5.9921,8.5396,11.047,13.515,15.945,18.34,20.701,23.029,25.325,27.592,29.829,32.038,34.221,36.379,38.512,40.622,42.71,44.776,46.822,48.848,50.855,52.845,54.818,56.774,58.716,60.642,62.554,64.453,66.339,68.214,70.076,71.928,73.77,75.602,77.425,79.239,81.045,82.843,84.634,86.418,88.196,89.968,91.734,93.496,95.252,97.004,98.753,100.5,102.24,103.98,105.71,107.44,109.17,110.9,112.63,114.35,116.08,117.8,119.52,121.24,122.96,124.68,126.4,128.12,129.84,131.56,133.28,135.0,136.73,138.45,140.17,141.89,143.62,145.34,147.07,148.79,150.52,152.25,153.98,155.71,157.44,159.17,160.9,162.63,164.37,166.1,167.84,169.58,171.31,173.05,174.79,176.53,178.27,180.0,181.74,183.48,185.22,186.96,188.7,190.44,192.18,193.92,195.66,197.4,199.14,200.88,202.62,204.36,206.09,207.83,209.56,211.3,213.03,214.76,216.5,218.23,219.96,221.69,223.42,225.14,226.87,228.6,230.32,232.04,233.77,235.49,237.21,238.93,240.66,242.38,244.1,245.82,247.54,249.26,250.98,252.7,254.42,256.14,257.86,259.59,261.31,263.04,264.77,266.5,268.23,269.96,271.7,273.44,275.18,276.93,278.68,280.44,282.2,283.96,285.73,287.51,289.29,291.08,292.88,294.68,296.49,298.31,300.14,301.98,303.83,305.69,307.56,309.44,311.34,313.25,315.17,317.11,319.06,321.03,323.01,325.01,327.03,329.07,331.13,333.21,335.32,337.44,339.59,341.77,343.97,346.2,348.46,350.74,353.06,355.41,357.8,360.21,362.67,365.17,367.7,370.28,372.9,375.56,378.28,381.04,383.85,386.72,389.65,392.63,395.67,398.78,401.96,405.2,408.52,411.92,415.39,418.95,422.59,426.33,430.17,434.1,438.14,442.29,446.56,450.95,455.47,460.13,464.92,469.87,474.98,480.25,485.7,491.33,497.16,503.21,509.47,515.96,522.71,529.72,537.01,544.6,552.51,560.76,569.38,578.38,587.81,597.69,608.06,618.95,630.4,642.47,655.2,668.65,682.89,697.99,714.03,731.1,749.31,768.78,789.64,812.05,836.2,862.29,890.57,921.33,954.91,991.73,1032.3,1077.1,1127.1,1183.0,1246.0,1317.6,1399.7,1494.6,1605.8,1737.9,1897.2,2093.1,2340.1,2661.1,3095.0,3714.5,4670.7,6340.8,10001.0,24453.0,-50954.0,-12251.0,},
{7017.4,11932.0,41945.0,-26713.0,-9993.2,-6093.7,-4355.5,-3371.7,-2738.7,-2297.2,-1971.8,-1721.9,-1524.1,-1363.5,-1230.6,-1118.7,-1023.3,-940.92,-869.08,-805.88,-749.85,-699.83,-654.89,-614.31,-577.47,-543.88,-513.12,-484.85,-458.77,-434.65,-412.26,-391.43,-371.99,-353.81,-336.77,-320.76,-305.7,-291.5,-278.08,-265.38,-253.35,-241.94,-231.08,-220.75,-210.91,-201.52,-192.55,-183.96,-175.75,-167.87,-160.32,-153.06,-146.09,-139.38,-132.92,-126.69,-120.69,-114.89,-109.29,-103.87,-98.633,-93.561,-88.648,-83.884,-79.263,-74.777,-70.42,-66.186,-62.068,-58.06,-54.159,-50.359,-46.654,-43.042,-39.517,-36.076,-32.716,-29.431,-26.22,-23.079,-20.005,-16.996,-14.047,-11.158,-8.3249,-5.546,-2.8188,-0.14136,2.4885,5.0726,7.613,10.111,12.569,14.989,17.371,19.718,22.031,24.311,26.559,28.778,30.968,33.13,35.265,37.375,39.461,41.524,43.564,45.582,47.581,49.559,51.519,53.461,55.386,57.295,59.188,61.067,62.931,64.781,66.619,68.445,70.259,72.062,73.854,75.637,77.41,79.175,80.931,82.679,84.42,86.154,87.881,89.603,91.318,93.028,94.734,96.435,98.131,99.824,101.51,103.2,104.88,106.56,108.24,109.92,111.59,113.26,114.93,116.6,118.27,119.94,121.6,123.27,124.94,126.6,128.27,129.93,131.6,133.27,134.93,136.6,138.27,139.94,141.61,143.28,144.95,146.62,148.3,149.97,151.64,153.32,155.0,156.67,158.35,160.03,161.71,163.39,165.08,166.76,168.44,170.13,171.81,173.5,175.19,176.87,178.56,180.25,181.94,183.62,185.31,187.0,188.69,190.38,192.07,193.75,195.44,197.13,198.82,200.5,202.19,203.87,205.56,207.24,208.93,210.61,212.29,213.97,215.65,217.33,219.01,220.69,222.36,224.04,225.71,227.39,229.06,230.73,232.4,234.07,235.74,237.41,239.08,240.75,242.41,244.08,245.75,247.41,249.08,250.74,252.41,254.08,255.75,257.41,259.08,260.75,262.43,264.1,265.77,267.45,269.13,270.81,272.5,274.19,275.88,277.58,279.28,280.98,282.69,284.4,286.12,287.85,289.58,291.32,293.07,294.82,296.58,298.35,300.13,301.92,303.72,305.53,307.36,309.19,311.04,312.9,314.77,316.66,318.56,320.48,322.42,324.37,326.35,328.34,330.35,332.39,334.44,336.52,338.62,340.75,342.9,345.09,347.3,349.53,351.8,354.11,356.44,358.82,361.22,363.67,366.16,368.68,371.25,373.87,376.53,379.24,382.01,384.82,387.7,390.63,393.62,396.67,399.79,402.98,406.25,409.59,413.0,416.5,420.09,423.77,427.54,431.41,435.39,439.47,443.67,448.0,452.45,457.03,461.75,466.62,471.65,476.84,482.21,487.76,493.51,499.45,505.62,512.02,518.66,525.57,532.75,540.23,548.02,556.15,564.64,573.51,582.8,592.53,602.74,613.46,624.74,636.62,649.16,662.4,676.42,691.28,707.07,723.87,741.79,760.95,781.47,803.51,827.25,852.9,880.69,910.92,943.91,980.07,1019.9,1063.9,1112.9,1167.7,1229.4,1299.6,1379.8,1472.7,1581.3,1710.1,1865.3,2055.9,2295.7,2606.4,3024.9,3619.5,4530.5,6102.3,9463.3,21705.0,},
{45425.0,-25032.0,-9680.5,-5949.2,-4266.7,-3309.1,-2690.9,-2258.9,-1939.8,-1694.6,-1500.3,-1342.4,-1211.7,-1101.6,-1007.6,-926.5,-855.72,-793.44,-738.21,-688.89,-644.58,-604.55,-568.21,-535.07,-504.73,-476.83,-451.1,-427.29,-405.19,-384.63,-365.44,-347.49,-330.67,-314.87,-300.0,-285.97,-272.73,-260.19,-248.31,-237.04,-226.32,-216.13,-206.41,-197.13,-188.27,-179.8,-171.69,-163.91,-156.46,-149.29,-142.41,-135.79,-129.41,-123.26,-117.33,-111.61,-106.08,-100.74,-95.572,-90.568,-85.721,-81.022,-76.464,-72.04,-67.743,-63.567,-59.507,-55.556,-51.711,-47.965,-44.315,-40.755,-37.282,-33.893,-30.583,-27.348,-24.187,-21.094,-18.069,-15.106,-12.205,-9.3628,-6.5762,-3.8433,-1.1619,1.4702,4.055,6.5943,9.0901,11.544,13.958,16.333,18.672,20.975,23.244,25.48,27.686,29.861,32.007,34.126,36.218,38.285,40.327,42.346,44.343,46.318,48.273,50.208,52.124,54.022,55.903,57.768,59.617,61.451,63.27,65.076,66.869,68.65,70.419,72.176,73.924,75.661,77.388,79.107,80.817,82.518,84.213,85.9,87.58,89.255,90.923,92.586,94.243,95.896,97.545,99.189,100.83,102.47,104.1,105.73,107.36,108.99,110.61,112.23,113.85,115.47,117.09,118.71,120.33,121.94,123.56,125.17,126.79,128.4,130.02,131.64,133.25,134.87,136.48,138.1,139.72,141.34,142.96,144.58,146.2,147.83,149.45,151.07,152.7,154.33,155.95,157.58,159.21,160.84,162.48,164.11,165.74,167.38,169.01,170.65,172.28,173.92,175.56,177.2,178.84,180.48,182.12,183.75,185.39,187.03,188.67,190.31,191.95,193.59,195.23,196.87,198.51,200.15,201.79,203.42,205.06,206.7,208.33,209.96,211.6,213.23,214.86,216.49,218.12,219.75,221.38,223.0,224.63,226.25,227.88,229.5,231.12,232.74,234.36,235.98,237.6,239.21,240.83,242.45,244.06,245.68,247.29,248.91,250.53,252.14,253.76,255.37,256.99,258.61,260.23,261.85,263.47,265.1,266.72,268.35,269.98,271.62,273.25,274.89,276.54,278.18,279.83,281.49,283.15,284.82,286.49,288.17,289.86,291.55,293.25,294.96,296.67,298.4,300.13,301.88,303.63,305.4,307.17,308.96,310.77,312.58,314.41,316.25,318.11,319.99,321.88,323.79,325.72,327.67,329.64,331.63,333.64,335.68,337.74,339.82,341.93,344.07,346.24,348.43,350.66,352.92,355.21,357.54,359.9,362.31,364.75,367.23,369.76,372.33,374.95,377.61,380.33,383.1,385.93,388.81,391.75,394.76,397.83,400.98,404.19,407.48,410.84,414.29,417.83,421.45,425.17,428.98,432.9,436.93,441.08,445.34,449.73,454.25,458.91,463.71,468.68,473.8,479.09,484.57,490.24,496.11,502.2,508.52,515.08,521.89,528.98,536.37,544.06,552.09,560.47,569.23,578.4,588.01,598.09,608.68,619.82,631.55,643.93,657.01,670.85,685.52,701.11,717.7,735.39,754.3,774.56,796.32,819.75,845.07,872.5,902.32,934.87,970.54,1009.8,1053.2,1101.5,1155.6,1216.4,1285.5,1364.6,1456.0,1563.0,1689.7,1842.3,2029.6,2264.9,2569.6,2979.4,3560.3,4447.7,5970.9,},
{-9634.2,-5907.9,-4232.7,-3280.6,-2666.4,-2237.4,-1920.8,-1677.5,-1484.7,-1328.2,-1198.5,-1089.4,-996.26,-915.84,-845.69,-783.97,-729.23,-680.36,-636.46,-596.8,-560.79,-527.96,-497.9,-470.26,-444.78,-421.19,-399.31,-378.94,-359.94,-342.16,-325.51,-309.86,-295.13,-281.25,-268.13,-255.72,-243.96,-232.8,-222.19,-212.1,-202.48,-193.3,-184.53,-176.15,-168.12,-160.43,-153.05,-145.97,-139.16,-132.6,-126.3,-120.22,-114.35,-108.7,-103.23,-97.949,-92.839,-87.893,-83.102,-78.458,-73.954,-69.583,-65.338,-61.214,-57.203,-53.302,-49.505,-45.807,-42.203,-38.69,-35.263,-31.919,-28.653,-25.463,-22.345,-19.296,-16.313,-13.393,-10.534,-7.7336,-4.9884,-2.2967,0.34379,2.9352,5.4794,7.9784,10.434,12.848,15.222,17.558,19.856,22.12,24.349,26.546,28.712,30.847,32.954,35.033,37.086,39.113,41.116,43.095,45.052,46.987,48.902,50.797,52.673,54.531,56.371,58.195,60.004,61.797,63.575,65.34,67.092,68.831,70.558,72.274,73.979,75.673,77.358,79.034,80.701,82.36,84.011,85.655,87.292,88.922,90.546,92.165,93.778,95.386,96.99,98.589,100.18,101.78,103.36,104.95,106.53,108.11,109.69,111.27,112.84,114.41,115.98,117.55,119.12,120.69,122.26,123.83,125.4,126.96,128.53,130.1,131.67,133.23,134.8,136.37,137.94,139.51,141.09,142.66,144.23,145.81,147.38,148.96,150.53,152.11,153.69,155.27,156.86,158.44,160.02,161.61,163.19,164.78,166.37,167.96,169.55,171.14,172.73,174.32,175.91,177.5,179.1,180.69,182.28,183.88,185.47,187.07,188.66,190.26,191.85,193.44,195.04,196.63,198.22,199.82,201.41,203.0,204.59,206.18,207.77,209.36,210.94,212.53,214.12,215.7,217.28,218.87,220.45,222.03,223.61,225.18,226.76,228.34,229.91,231.49,233.06,234.63,236.2,237.77,239.34,240.91,242.48,244.05,245.62,247.19,248.75,250.32,251.89,253.46,255.03,256.6,258.17,259.74,261.31,262.88,264.46,266.04,267.62,269.2,270.78,272.37,273.96,275.56,277.16,278.76,280.37,281.98,283.59,285.22,286.85,288.48,290.12,291.77,293.43,295.09,296.77,298.45,300.14,301.84,303.56,305.28,307.02,308.76,310.52,312.3,314.09,315.89,317.71,319.55,321.4,323.27,325.16,327.07,329.0,330.95,332.92,334.92,336.94,338.98,341.05,343.15,345.28,347.43,349.62,351.84,354.09,356.38,358.71,361.07,363.47,365.91,368.4,370.93,373.51,376.13,378.81,381.54,384.32,387.17,390.07,393.03,396.06,399.16,402.33,405.57,408.89,412.3,415.78,419.36,423.03,426.8,430.67,434.65,438.75,442.96,447.29,451.76,456.37,461.12,466.02,471.09,476.32,481.74,487.34,493.15,499.17,505.42,511.91,518.65,525.67,532.97,540.58,548.53,556.82,565.49,574.57,584.08,594.06,604.54,615.57,627.19,639.44,652.39,666.1,680.63,696.07,712.5,730.02,748.75,768.81,790.37,813.58,838.66,865.83,895.38,927.63,962.97,1001.9,1044.9,1092.8,1146.3,1206.7,1275.1,1353.5,1444.2,1550.2,1675.9,1827.2,2013.0,2246.5,2548.9,2955.8,3532.9,},
{-4250.1,-3283.8,-2663.6,-2231.8,-1913.8,-1669.9,-1476.9,-1320.3,-1190.8,-1081.8,-988.87,-908.67,-838.74,-777.24,-722.73,-674.06,-630.36,-590.9,-555.08,-522.42,-492.52,-465.05,-439.71,-416.27,-394.52,-374.28,-355.41,-337.75,-321.21,-305.67,-291.05,-277.26,-264.24,-251.92,-240.25,-229.18,-218.65,-208.64,-199.09,-189.99,-181.29,-172.98,-165.02,-157.39,-150.07,-143.05,-136.3,-129.8,-123.55,-117.53,-111.72,-106.12,-100.7,-95.47,-90.41,-85.512,-80.769,-76.172,-71.713,-67.387,-63.187,-59.106,-55.138,-51.28,-47.524,-43.867,-40.305,-36.832,-33.445,-30.14,-26.913,-23.762,-20.682,-17.671,-14.726,-11.844,-9.0222,-6.2585,-3.5502,-0.89516,1.7088,4.2638,6.7717,9.2345,11.654,14.032,16.37,18.67,20.933,23.16,25.354,27.515,29.645,31.744,33.815,35.858,37.875,39.866,41.832,43.775,45.696,47.594,49.472,51.331,53.17,54.991,56.794,58.581,60.351,62.107,63.847,65.574,67.287,68.988,70.677,72.354,74.02,75.675,77.321,78.957,80.584,82.203,83.814,85.417,87.013,88.603,90.186,91.763,93.335,94.901,96.463,98.02,99.573,101.12,102.67,104.21,105.75,107.29,108.82,110.35,111.88,113.41,114.94,116.47,117.99,119.51,121.04,122.56,124.08,125.6,127.13,128.65,130.17,131.69,133.22,134.74,136.27,137.79,139.32,140.84,142.37,143.9,145.43,146.96,148.49,150.02,151.56,153.09,154.63,156.17,157.71,159.25,160.79,162.33,163.87,165.41,166.96,168.5,170.05,171.6,173.15,174.69,176.24,177.79,179.34,180.89,182.44,183.99,185.55,187.1,188.65,190.2,191.75,193.3,194.85,196.4,197.95,199.5,201.05,202.6,204.15,205.69,207.24,208.78,210.33,211.87,213.41,214.95,216.49,218.03,219.57,221.11,222.64,224.18,225.71,227.24,228.77,230.31,231.83,233.36,234.89,236.42,237.94,239.47,240.99,242.51,244.04,245.56,247.08,248.61,250.13,251.65,253.17,254.7,256.22,257.75,259.27,260.8,262.33,263.86,265.39,266.92,268.46,270.0,271.54,273.09,274.64,276.19,277.74,279.3,280.87,282.44,284.02,285.6,287.19,288.78,290.38,291.99,293.61,295.23,296.87,298.51,300.16,301.82,303.5,305.18,306.88,308.59,310.31,312.05,313.8,315.57,317.35,319.15,320.96,322.8,324.65,326.52,328.41,330.33,332.26,334.22,336.21,338.22,340.25,342.31,344.4,346.53,348.68,350.86,353.08,355.33,357.62,359.95,362.31,364.72,367.17,369.66,372.21,374.79,377.43,380.13,382.87,385.68,388.54,391.47,394.46,397.52,400.65,403.86,407.14,410.5,413.95,417.49,421.12,424.85,428.68,432.61,436.66,440.83,445.12,449.54,454.1,458.81,463.66,468.68,473.87,479.23,484.78,490.54,496.51,502.7,509.13,515.81,522.77,530.01,537.56,545.44,553.66,562.27,571.27,580.71,590.61,601.01,611.95,623.49,635.65,648.51,662.12,676.55,691.88,708.2,725.6,744.21,764.15,785.57,808.64,833.57,860.59,889.98,922.06,957.22,995.94,1038.8,1086.4,1139.8,1199.9,1268.2,1346.3,1436.8,1542.7,1668.2,1819.6,2005.6,2239.7,2543.3,},
{-2682.0,-2241.4,-1918.4,-1671.4,-1476.4,-1318.5,-1188.1,-1078.6,-985.25,-904.8,-834.71,-773.11,-718.55,-669.87,-626.18,-586.74,-550.96,-518.35,-488.51,-461.09,-435.82,-412.45,-390.76,-370.59,-351.78,-334.2,-317.72,-302.24,-287.69,-273.96,-261.01,-248.75,-237.14,-226.12,-215.65,-205.69,-196.2,-187.15,-178.51,-170.25,-162.34,-154.76,-147.49,-140.51,-133.81,-127.36,-121.15,-115.17,-109.41,-103.85,-98.475,-93.284,-88.264,-83.406,-78.701,-74.143,-69.723,-65.434,-61.271,-57.227,-53.296,-49.473,-45.753,-42.132,-38.604,-35.166,-31.813,-28.543,-25.35,-22.232,-19.186,-16.208,-13.296,-10.447,-7.6582,-4.9271,-2.2515,0.37101,2.9425,5.4651,7.9407,10.371,12.758,15.104,17.41,19.677,21.908,24.103,26.264,28.393,30.49,32.557,34.595,36.606,38.59,40.548,42.481,44.391,46.278,48.143,49.988,51.812,53.618,55.404,57.174,58.926,60.662,62.383,64.088,65.78,67.458,69.123,70.776,72.417,74.047,75.666,77.275,78.875,80.465,82.047,83.62,85.186,86.744,88.295,89.84,91.379,92.912,94.439,95.962,97.48,98.993,100.5,102.01,103.51,105.01,106.51,108.0,109.49,110.98,112.47,113.95,115.44,116.92,118.4,119.88,121.36,122.84,124.32,125.8,127.28,128.76,130.24,131.72,133.2,134.68,136.16,137.65,139.13,140.61,142.1,143.59,145.07,146.56,148.05,149.54,151.03,152.53,154.02,155.52,157.01,158.51,160.01,161.51,163.01,164.51,166.01,167.52,169.02,170.53,172.03,173.54,175.05,176.56,178.07,179.57,181.08,182.59,184.1,185.62,187.13,188.64,190.15,191.66,193.17,194.68,196.19,197.7,199.2,200.71,202.22,203.73,205.23,206.74,208.24,209.75,211.25,212.75,214.25,215.75,217.25,218.74,220.24,221.73,223.23,224.72,226.21,227.7,229.19,230.68,232.16,233.65,235.13,236.62,238.1,239.58,241.07,242.55,244.03,245.51,246.99,248.47,249.95,251.43,252.91,254.39,255.87,257.35,258.83,260.32,261.8,263.29,264.78,266.27,267.76,269.26,270.76,272.26,273.76,275.27,276.79,278.3,279.82,281.35,282.88,284.42,285.96,287.51,289.07,290.63,292.2,293.78,295.37,296.97,298.57,300.19,301.82,303.46,305.11,306.77,308.44,310.13,311.83,313.55,315.28,317.03,318.79,320.57,322.37,324.19,326.03,327.89,329.77,331.67,333.6,335.55,337.53,339.53,341.56,343.62,345.7,347.82,349.98,352.16,354.38,356.64,358.93,361.27,363.64,366.06,368.52,371.03,373.59,376.19,378.85,381.57,384.34,387.17,390.07,393.03,396.05,399.15,402.32,405.57,408.9,412.31,415.82,419.41,423.1,426.9,430.8,434.81,438.94,443.2,447.58,452.1,456.77,461.58,466.56,471.71,477.03,482.54,488.25,494.18,500.33,506.71,513.35,520.26,527.45,534.96,542.78,550.96,559.51,568.46,577.84,587.69,598.04,608.93,620.4,632.5,645.3,658.85,673.22,688.48,704.74,722.08,740.62,760.49,781.85,804.86,829.73,856.69,886.02,918.06,953.18,991.87,1034.7,1082.4,1135.8,1196.0,1264.4,1342.8,1433.6,1540.1,1666.4,1819.0,2006.9,},
{-1934.4,-1681.8,-1483.1,-1322.6,-1190.4,-1079.6,-985.27,-904.1,-833.47,-771.47,-716.59,-667.68,-623.81,-584.24,-548.36,-515.68,-485.79,-458.34,-433.04,-409.66,-387.98,-367.82,-349.02,-331.45,-314.99,-299.54,-285.01,-271.32,-258.39,-246.16,-234.59,-223.6,-213.17,-203.24,-193.79,-184.77,-176.16,-167.93,-160.06,-152.51,-145.28,-138.34,-131.67,-125.25,-119.08,-113.13,-107.4,-101.87,-96.53,-91.371,-86.383,-81.557,-76.884,-72.356,-67.967,-63.709,-59.577,-55.563,-51.662,-47.869,-44.179,-40.587,-37.089,-33.68,-30.357,-27.115,-23.952,-20.863,-17.845,-14.897,-12.013,-9.193,-6.4329,-3.7305,-1.0835,1.5103,4.0532,6.5471,8.994,11.396,13.754,16.071,18.348,20.587,22.788,24.954,27.086,29.186,31.254,33.291,35.3,37.281,39.235,41.163,43.066,44.946,46.802,48.637,50.451,52.245,54.019,55.774,57.512,59.233,60.937,62.626,64.299,65.959,67.604,69.237,70.856,72.464,74.061,75.646,77.222,78.787,80.343,81.89,83.428,84.959,86.482,87.998,89.507,91.01,92.507,93.998,95.484,96.965,98.441,99.913,101.38,102.85,104.31,105.76,107.22,108.67,110.12,111.57,113.02,114.46,115.91,117.35,118.79,120.23,121.67,123.11,124.55,125.99,127.43,128.87,130.31,131.75,133.19,134.63,136.07,137.51,138.95,140.4,141.84,143.29,144.73,146.18,147.63,149.08,150.53,151.99,153.44,154.9,156.35,157.81,159.27,160.73,162.19,163.65,165.12,166.58,168.04,169.51,170.98,172.45,173.91,175.38,176.85,178.32,179.79,181.27,182.74,184.21,185.68,187.15,188.63,190.1,191.57,193.04,194.51,195.98,197.45,198.92,200.39,201.86,203.33,204.8,206.26,207.73,209.19,210.66,212.12,213.58,215.04,216.5,217.96,219.42,220.87,222.33,223.78,225.23,226.68,228.13,229.58,231.03,232.48,233.92,235.37,236.81,238.25,239.7,241.14,242.58,244.02,245.46,246.9,248.34,249.78,251.21,252.65,254.09,255.54,256.98,258.42,259.86,261.31,262.75,264.2,265.65,267.1,268.56,270.02,271.48,272.94,274.41,275.88,277.36,278.84,280.32,281.81,283.31,284.81,286.31,287.83,289.35,290.88,292.41,293.96,295.51,297.08,298.65,300.23,301.82,303.43,305.05,306.67,308.32,309.97,311.64,313.33,315.03,316.74,318.47,320.22,321.99,323.78,325.59,327.42,329.27,331.14,333.04,334.96,336.9,338.88,340.88,342.91,344.97,347.06,349.18,351.33,353.53,355.75,358.02,360.32,362.67,365.06,367.49,369.97,372.5,375.08,377.71,380.4,383.14,385.95,388.81,391.74,394.74,397.81,400.95,404.17,407.47,410.86,414.33,417.89,421.56,425.32,429.19,433.18,437.28,441.5,445.85,450.34,454.98,459.76,464.71,469.82,475.12,480.6,486.28,492.17,498.28,504.64,511.24,518.12,525.28,532.75,540.54,548.68,557.2,566.12,575.47,585.28,595.59,606.45,617.89,629.97,642.73,656.25,670.59,685.84,702.07,719.4,737.92,757.79,779.15,802.17,827.06,854.05,883.44,915.54,950.77,989.59,1032.6,1080.5,1134.2,1194.8,1263.7,1342.8,1434.6,1542.3,1670.4,},
{-1497.0,-1332.6,-1197.6,-1084.7,-988.86,-906.5,-834.96,-772.23,-716.79,-667.43,-623.19,-583.33,-547.22,-514.34,-484.3,-456.73,-431.33,-407.87,-386.12,-365.91,-347.07,-329.47,-312.99,-297.53,-282.99,-269.29,-256.36,-244.14,-232.57,-221.59,-211.17,-201.26,-191.82,-182.82,-174.22,-166.01,-158.16,-150.63,-143.42,-136.5,-129.85,-123.46,-117.31,-111.38,-105.67,-100.17,-94.852,-89.716,-84.752,-79.949,-75.3,-70.797,-66.432,-62.199,-58.09,-54.1,-50.224,-46.455,-42.79,-39.222,-35.748,-32.364,-29.065,-25.848,-22.709,-19.645,-16.652,-13.728,-10.869,-8.0736,-5.3382,-2.6607,-0.038665,2.5302,5.0479,7.5167,9.9383,12.315,14.648,16.939,19.19,21.403,23.579,25.719,27.825,29.898,31.94,33.951,35.933,37.887,39.814,41.715,43.591,45.443,47.272,49.079,50.865,52.63,54.376,56.103,57.812,59.503,61.179,62.838,64.482,66.111,67.727,69.329,70.918,72.495,74.061,75.615,77.159,78.693,80.217,81.732,83.238,84.736,86.226,87.709,89.185,90.654,92.117,93.574,95.026,96.472,97.914,99.351,100.78,102.21,103.64,105.06,106.48,107.9,109.31,110.72,112.13,113.54,114.95,116.35,117.76,119.16,120.56,121.96,123.36,124.76,126.17,127.57,128.97,130.37,131.77,133.17,134.57,135.98,137.38,138.78,140.19,141.6,143.0,144.41,145.82,147.23,148.65,150.06,151.47,152.89,154.31,155.73,157.15,158.57,159.99,161.41,162.84,164.26,165.69,167.12,168.54,169.97,171.4,172.84,174.27,175.7,177.13,178.57,180.0,181.44,182.87,184.31,185.74,187.18,188.61,190.05,191.49,192.92,194.36,195.79,197.22,198.66,200.09,201.52,202.95,204.39,205.82,207.24,208.67,210.1,211.53,212.95,214.37,215.8,217.22,218.64,220.06,221.48,222.89,224.31,225.72,227.13,228.55,229.96,231.37,232.77,234.18,235.59,236.99,238.4,239.8,241.2,242.61,244.01,245.41,246.81,248.21,249.61,251.01,252.41,253.82,255.22,256.62,258.03,259.43,260.84,262.25,263.65,265.07,266.48,267.9,269.31,270.74,272.16,273.59,275.02,276.46,277.9,279.34,280.8,282.25,283.71,285.18,286.65,288.14,289.62,291.12,292.62,294.14,295.66,297.19,298.73,300.28,301.84,303.42,305.0,306.6,308.21,309.84,311.48,313.13,314.81,316.49,318.2,319.92,321.66,323.42,325.2,327.0,328.82,330.67,332.54,334.43,336.35,338.3,340.27,342.27,344.3,346.37,348.46,350.59,352.76,354.96,357.2,359.48,361.8,364.17,366.58,369.03,371.53,374.09,376.7,379.36,382.08,384.85,387.69,390.6,393.57,396.62,399.74,402.93,406.21,409.57,413.02,416.56,420.2,423.94,427.79,431.74,435.82,440.02,444.35,448.82,453.43,458.19,463.11,468.2,473.47,478.93,484.59,490.46,496.55,502.88,509.47,516.32,523.46,530.91,538.68,546.81,555.31,564.21,573.54,583.35,593.65,604.5,615.93,628.0,640.77,654.3,668.65,683.91,700.16,717.52,736.08,756.0,777.42,800.52,825.51,852.63,882.17,914.46,949.91,989.02,1032.4,1080.7,1135.0,1196.3,1266.1,1346.3,1439.6,},
{-1209.8,-1094.0,-996.01,-911.99,-839.14,-775.38,-719.11,-669.08,-624.29,-583.98,-547.49,-514.31,-484.01,-456.22,-430.65,-407.03,-385.15,-364.83,-345.9,-328.23,-311.68,-296.17,-281.58,-267.85,-254.89,-242.64,-231.05,-220.06,-209.63,-199.71,-190.27,-181.27,-172.68,-164.47,-156.62,-149.1,-141.9,-134.98,-128.34,-121.96,-115.82,-109.91,-104.22,-98.726,-93.426,-88.306,-83.357,-78.571,-73.939,-69.453,-65.106,-60.89,-56.8,-52.829,-48.971,-45.221,-41.575,-38.027,-34.573,-31.208,-27.929,-24.732,-21.613,-18.569,-15.597,-12.693,-9.8558,-7.0811,-4.3669,-1.7107,0.8899,3.4372,5.9332,8.3801,10.78,13.134,15.445,17.714,19.942,22.132,24.285,26.402,28.485,30.535,32.552,34.54,36.498,38.427,40.33,42.206,44.058,45.885,47.689,49.471,51.231,52.971,54.69,56.391,58.074,59.739,61.387,63.02,64.636,66.238,67.826,69.4,70.962,72.51,74.047,75.573,77.087,78.592,80.086,81.571,83.048,84.515,85.975,87.427,88.872,90.31,91.742,93.167,94.587,96.001,97.41,98.815,100.22,101.61,103.0,104.39,105.78,107.16,108.54,109.92,111.29,112.67,114.04,115.41,116.78,118.14,119.51,120.87,122.24,123.6,124.97,126.33,127.7,129.06,130.43,131.79,133.16,134.52,135.89,137.26,138.62,139.99,141.36,142.74,144.11,145.48,146.86,148.23,149.61,150.99,152.37,153.75,155.13,156.51,157.9,159.28,160.67,162.06,163.45,164.84,166.23,167.63,169.02,170.41,171.81,173.21,174.6,176.0,177.4,178.8,180.2,181.6,183.0,184.4,185.8,187.2,188.6,190.01,191.41,192.81,194.21,195.61,197.01,198.41,199.8,201.2,202.6,203.99,205.39,206.78,208.18,209.57,210.96,212.35,213.74,215.13,216.51,217.9,219.28,220.67,222.05,223.43,224.81,226.19,227.56,228.94,230.31,231.69,233.06,234.43,235.8,237.17,238.53,239.9,241.27,242.63,244.0,245.36,246.73,248.09,249.46,250.82,252.19,253.55,254.92,256.29,257.65,259.02,260.39,261.76,263.14,264.51,265.89,267.27,268.65,270.03,271.42,272.81,274.21,275.61,277.01,278.42,279.83,281.25,282.68,284.11,285.54,286.99,288.44,289.89,291.36,292.83,294.32,295.81,297.31,298.82,300.34,301.88,303.42,304.98,306.55,308.14,309.73,311.35,312.97,314.62,316.28,317.96,319.65,321.37,323.1,324.85,326.63,328.43,330.25,332.09,333.96,335.86,337.78,339.73,341.71,343.72,345.76,347.83,349.94,352.08,354.26,356.48,358.73,361.03,363.37,365.76,368.19,370.68,373.21,375.79,378.43,381.13,383.89,386.71,389.59,392.55,395.57,398.67,401.84,405.1,408.44,411.87,415.39,419.01,422.74,426.56,430.51,434.56,438.75,443.06,447.51,452.1,456.85,461.75,466.83,472.08,477.53,483.17,489.03,495.11,501.43,508.0,514.85,521.98,529.42,537.19,545.32,553.82,562.72,572.06,581.87,592.18,603.04,614.5,626.59,639.39,652.95,667.35,682.66,698.98,716.41,735.07,755.09,776.64,799.89,825.05,852.38,882.17,914.77,950.58,990.13,1034.0,1083.0,1138.1,1200.4,1271.4,},
{-1006.8,-920.6,-846.04,-780.92,-723.54,-672.61,-627.09,-586.17,-549.17,-515.56,-484.89,-456.8,-430.96,-407.12,-385.05,-364.57,-345.5,-327.7,-311.05,-295.44,-280.78,-266.98,-253.96,-241.66,-230.03,-219.0,-208.54,-198.59,-189.13,-180.11,-171.5,-163.28,-155.42,-147.9,-140.69,-133.77,-127.13,-120.75,-114.62,-108.71,-103.02,-97.533,-92.239,-87.127,-82.188,-77.411,-72.789,-68.314,-63.978,-59.774,-55.697,-51.738,-47.894,-44.158,-40.526,-36.992,-33.553,-30.204,-26.94,-23.759,-20.656,-17.629,-14.674,-11.787,-8.9665,-6.2093,-3.5127,-0.87438,1.7081,4.2371,6.7146,9.1427,11.523,13.859,16.15,18.399,20.608,22.778,24.911,27.007,29.069,31.098,33.095,35.061,36.998,38.906,40.787,42.641,44.47,46.275,48.056,49.815,51.552,53.268,54.964,56.641,58.3,59.941,61.565,63.172,64.764,66.341,67.903,69.452,70.987,72.509,74.02,75.519,77.007,78.484,79.951,81.408,82.857,84.296,85.728,87.151,88.567,89.976,91.378,92.774,94.164,95.548,96.927,98.301,99.67,101.04,102.4,103.75,105.11,106.46,107.81,109.15,110.49,111.83,113.17,114.51,115.84,117.18,118.51,119.84,121.17,122.5,123.83,125.16,126.49,127.82,129.15,130.48,131.81,133.14,134.47,135.81,137.14,138.47,139.81,141.14,142.48,143.82,145.16,146.5,147.84,149.18,150.52,151.87,153.22,154.56,155.91,157.26,158.61,159.97,161.32,162.68,164.03,165.39,166.75,168.11,169.47,170.83,172.2,173.56,174.92,176.29,177.65,179.02,180.39,181.76,183.12,184.49,185.86,187.23,188.59,189.96,191.33,192.7,194.07,195.43,196.8,198.17,199.53,200.9,202.26,203.62,204.98,206.35,207.71,209.07,210.42,211.78,213.14,214.49,215.85,217.2,218.55,219.9,221.25,222.59,223.94,225.28,226.63,227.97,229.31,230.65,231.99,233.33,234.66,236.0,237.33,238.66,240.0,241.33,242.66,243.99,245.32,246.65,247.98,249.31,250.64,251.97,253.3,254.63,255.96,257.3,258.63,259.97,261.3,262.64,263.98,265.32,266.67,268.02,269.37,270.72,272.08,273.44,274.8,276.17,277.54,278.92,280.3,281.69,283.09,284.49,285.89,287.31,288.73,290.16,291.6,293.04,294.5,295.96,297.44,298.92,300.42,301.92,303.44,304.98,306.52,308.08,309.65,311.24,312.84,314.46,316.1,317.75,319.42,321.11,322.82,324.55,326.31,328.08,329.88,331.7,333.55,335.42,337.32,339.25,341.21,343.2,345.22,347.27,349.36,351.48,353.64,355.84,358.07,360.35,362.68,365.04,367.46,369.92,372.44,375.0,377.63,380.31,383.05,385.85,388.72,391.65,394.66,397.74,400.9,404.14,407.47,410.88,414.39,418.0,421.71,425.52,429.45,433.5,437.67,441.97,446.41,450.99,455.73,460.63,465.69,470.94,476.38,482.02,487.87,493.95,500.27,506.84,513.69,520.83,528.28,536.06,544.19,552.71,561.63,570.99,580.82,591.17,602.07,613.56,625.71,638.57,652.2,666.67,682.07,698.5,716.05,734.84,755.03,776.77,800.24,825.66,853.29,883.43,916.45,952.76,992.91,1037.5,1087.4,1143.5,},
{-855.73,-788.88,-730.12,-678.05,-631.6,-589.89,-552.24,-518.08,-486.94,-458.45,-432.27,-408.13,-385.81,-365.1,-345.83,-327.87,-311.07,-295.33,-280.56,-266.65,-253.55,-241.18,-229.47,-218.39,-207.87,-197.88,-188.37,-179.32,-170.68,-162.44,-154.55,-147.01,-139.78,-132.86,-126.2,-119.82,-113.67,-107.76,-102.07,-96.577,-91.282,-86.171,-81.233,-76.459,-71.841,-67.37,-63.04,-58.842,-54.771,-50.821,-46.985,-43.258,-39.635,-36.112,-32.683,-29.344,-26.092,-22.923,-19.833,-16.818,-13.875,-11.002,-8.1954,-5.4522,-2.77,-0.14631,2.4213,4.935,7.397,9.8093,12.174,14.493,16.768,19.0,21.192,23.344,25.459,27.538,29.582,31.593,33.571,35.519,37.436,39.325,41.186,43.021,44.83,46.614,48.375,50.113,51.829,53.524,55.199,56.855,58.491,60.11,61.711,63.296,64.865,66.419,67.958,69.483,70.994,72.493,73.979,75.453,76.916,78.368,79.81,81.242,82.664,84.078,85.483,86.879,88.268,89.65,91.025,92.393,93.755,95.111,96.462,97.807,99.148,100.48,101.82,103.14,104.47,105.79,107.11,108.42,109.73,111.04,112.35,113.65,114.96,116.26,117.56,118.86,120.16,121.46,122.75,124.05,125.35,126.64,127.94,129.24,130.53,131.83,133.13,134.43,135.73,137.03,138.33,139.63,140.93,142.23,143.54,144.85,146.15,147.46,148.77,150.08,151.39,152.71,154.02,155.34,156.66,157.97,159.3,160.62,161.94,163.26,164.59,165.92,167.24,168.57,169.9,171.23,172.56,173.9,175.23,176.56,177.9,179.23,180.57,181.9,183.24,184.58,185.91,187.25,188.59,189.92,191.26,192.6,193.93,195.27,196.6,197.94,199.27,200.6,201.94,203.27,204.6,205.93,207.26,208.59,209.91,211.24,212.56,213.89,215.21,216.53,217.85,219.17,220.48,221.8,223.11,224.43,225.74,227.05,228.36,229.67,230.97,232.28,233.58,234.89,236.19,237.49,238.79,240.09,241.39,242.69,243.98,245.28,246.58,247.87,249.17,250.47,251.77,253.06,254.36,255.66,256.96,258.26,259.56,260.87,262.17,263.48,264.79,266.1,267.41,268.73,270.05,271.37,272.7,274.03,275.37,276.71,278.05,279.4,280.76,282.12,283.48,284.86,286.24,287.62,289.02,290.42,291.83,293.25,294.68,296.12,297.57,299.03,300.5,301.98,303.48,304.99,306.51,308.04,309.59,311.16,312.74,314.33,315.95,317.58,319.23,320.9,322.59,324.3,326.03,327.79,329.56,331.37,333.19,335.05,336.93,338.84,340.78,342.75,344.75,346.78,348.85,350.95,353.1,355.28,357.5,359.76,362.07,364.42,366.82,369.27,371.77,374.32,376.93,379.59,382.32,385.11,387.96,390.89,393.88,396.95,400.1,403.33,406.64,410.05,413.55,417.14,420.84,424.65,428.57,432.61,436.77,441.07,445.5,450.08,454.82,459.71,464.78,470.03,475.47,481.11,486.97,493.06,499.39,505.97,512.84,519.99,527.46,535.26,543.42,551.97,560.92,570.32,580.2,590.6,601.56,613.12,625.35,638.29,652.01,666.6,682.13,698.7,716.41,735.4,755.81,777.8,801.56,827.32,855.34,885.94,919.49,956.45,997.35,1042.9,},
{-738.89,-685.43,-637.83,-595.17,-556.71,-521.87,-490.15,-461.16,-434.55,-410.05,-387.4,-366.41,-346.9,-328.72,-311.74,-295.83,-280.91,-266.87,-253.65,-241.17,-229.38,-218.21,-207.62,-197.56,-188.0,-178.89,-170.21,-161.93,-154.01,-146.43,-139.18,-132.22,-125.55,-119.14,-112.98,-107.05,-101.35,-95.849,-90.546,-85.428,-80.484,-75.707,-71.086,-66.614,-62.283,-58.086,-54.017,-50.069,-46.236,-42.514,-38.896,-35.378,-31.955,-28.624,-25.379,-22.218,-19.136,-16.13,-13.197,-10.334,-7.5373,-4.8049,-2.1339,0.47825,3.0339,5.5353,7.9847,10.384,12.735,15.041,17.301,19.52,21.697,23.835,25.935,27.998,30.027,32.021,33.983,35.914,37.815,39.687,41.531,43.348,45.139,46.905,48.648,50.367,52.065,53.741,55.396,57.032,58.649,60.247,61.828,63.393,64.941,66.473,67.991,69.494,70.984,72.46,73.924,75.375,76.815,78.244,79.662,81.071,82.469,83.858,85.239,86.611,87.975,89.331,90.681,92.023,93.359,94.689,96.013,97.332,98.646,99.954,101.26,102.56,103.85,105.15,106.44,107.72,109.01,110.29,111.56,112.84,114.11,115.39,116.66,117.93,119.19,120.46,121.73,122.99,124.26,125.53,126.79,128.06,129.32,130.59,131.85,133.12,134.38,135.65,136.92,138.19,139.46,140.73,142.0,143.28,144.55,145.82,147.1,148.38,149.66,150.94,152.22,153.51,154.79,156.08,157.36,158.65,159.94,161.24,162.53,163.82,165.12,166.41,167.71,169.01,170.31,171.61,172.91,174.21,175.52,176.82,178.13,179.43,180.74,182.04,183.35,184.66,185.96,187.27,188.58,189.88,191.19,192.5,193.8,195.11,196.41,197.72,199.02,200.33,201.63,202.93,204.23,205.53,206.83,208.13,209.43,210.72,212.02,213.31,214.6,215.89,217.18,218.47,219.76,221.04,222.33,223.61,224.89,226.17,227.45,228.73,230.0,231.28,232.55,233.83,235.1,236.37,237.64,238.91,240.18,241.44,242.71,243.98,245.24,246.51,247.77,249.04,250.3,251.57,252.83,254.1,255.37,256.64,257.91,259.18,260.45,261.72,263.0,264.28,265.56,266.84,268.13,269.41,270.71,272.0,273.3,274.6,275.91,277.22,278.54,279.86,281.19,282.53,283.87,285.22,286.57,287.93,289.3,290.68,292.07,293.46,294.87,296.29,297.71,299.15,300.6,302.06,303.53,305.02,306.52,308.03,309.56,311.1,312.66,314.24,315.83,317.44,319.07,320.72,322.39,324.09,325.8,327.53,329.29,331.08,332.89,334.72,336.59,338.48,340.4,342.36,344.34,346.36,348.42,350.5,352.63,354.8,357.0,359.25,361.55,363.89,366.27,368.71,371.19,373.73,376.33,378.99,381.7,384.48,387.33,390.24,393.23,396.29,399.43,402.65,405.96,409.36,412.85,416.44,420.13,423.94,427.86,431.89,436.06,440.35,444.79,449.37,454.11,459.01,464.09,469.34,474.79,480.45,486.32,492.43,498.77,505.38,512.27,519.45,526.95,534.79,542.99,551.58,560.59,570.05,579.99,590.46,601.5,613.16,625.48,638.54,652.4,667.13,682.82,699.58,717.51,736.74,757.42,779.72,803.84,830.02,858.53,889.7,923.91,961.65,},
{-645.85,-602.04,-562.62,-526.96,-494.54,-464.95,-437.83,-412.88,-389.84,-368.51,-348.7,-330.26,-313.04,-296.93,-281.82,-267.62,-254.25,-241.65,-229.74,-218.46,-207.78,-197.64,-188.0,-178.82,-170.08,-161.74,-153.77,-146.15,-138.85,-131.86,-125.16,-118.72,-112.54,-106.59,-100.86,-95.342,-90.023,-84.89,-79.935,-75.147,-70.517,-66.038,-61.701,-57.499,-53.427,-49.476,-45.642,-41.919,-38.302,-34.785,-31.365,-28.036,-24.795,-21.638,-18.561,-15.561,-12.634,-9.777,-6.9878,-4.263,-1.6001,1.0034,3.5501,6.042,8.4815,10.871,13.211,15.506,17.755,19.961,22.127,24.252,26.339,28.39,30.405,32.386,34.334,36.25,38.136,39.993,41.822,43.624,45.399,47.15,48.876,50.579,52.259,53.918,55.556,57.174,58.773,60.354,61.916,63.462,64.991,66.504,68.002,69.486,70.955,72.411,73.854,75.285,76.704,78.111,79.508,80.894,82.271,83.637,84.995,86.344,87.685,89.018,90.344,91.663,92.974,94.28,95.579,96.873,98.161,99.445,100.72,102.0,103.27,104.53,105.8,107.05,108.31,109.56,110.81,112.06,113.31,114.55,115.8,117.04,118.28,119.51,120.75,121.99,123.22,124.46,125.69,126.93,128.16,129.4,130.63,131.87,133.11,134.34,135.58,136.82,138.06,139.3,140.54,141.78,143.02,144.27,145.51,146.76,148.01,149.26,150.51,151.76,153.01,154.27,155.52,156.78,158.04,159.3,160.56,161.83,163.09,164.36,165.62,166.89,168.16,169.43,170.7,171.97,173.25,174.52,175.79,177.07,178.35,179.62,180.9,182.18,183.46,184.73,186.01,187.29,188.57,189.85,191.13,192.4,193.68,194.96,196.24,197.51,198.79,200.06,201.34,202.61,203.88,205.15,206.42,207.69,208.96,210.23,211.5,212.76,214.02,215.29,216.55,217.81,219.07,220.32,221.58,222.83,224.08,225.34,226.59,227.83,229.08,230.33,231.57,232.82,234.06,235.3,236.54,237.78,239.02,240.26,241.49,242.73,243.97,245.2,246.44,247.67,248.91,250.14,251.38,252.62,253.85,255.09,256.33,257.57,258.81,260.05,261.3,262.54,263.79,265.04,266.29,267.55,268.81,270.07,271.33,272.6,273.88,275.15,276.44,277.72,279.02,280.31,281.62,282.93,284.25,285.57,286.9,288.24,289.59,290.94,292.31,293.68,295.06,296.46,297.86,299.28,300.71,302.15,303.6,305.06,306.54,308.04,309.55,311.07,312.61,314.17,315.75,317.34,318.95,320.58,322.24,323.91,325.61,327.33,329.07,330.84,332.64,334.46,336.31,338.18,340.09,342.03,344.0,346.01,348.05,350.13,352.24,354.39,356.59,358.83,361.11,363.44,365.81,368.24,370.72,373.25,375.84,378.48,381.19,383.96,386.8,389.71,392.69,395.75,398.88,402.1,405.41,408.8,412.29,415.88,419.58,423.38,427.3,431.35,435.51,439.82,444.26,448.85,453.6,458.51,463.6,468.88,474.34,480.02,485.92,492.04,498.42,505.06,511.98,519.21,526.75,534.64,542.9,551.55,560.62,570.16,580.18,590.75,601.89,613.66,626.11,639.31,653.33,668.24,684.14,701.12,719.31,738.84,759.85,782.54,807.1,833.78,862.88,894.73,},
{-570.0,-533.37,-500.14,-469.84,-442.11,-416.63,-393.13,-371.4,-351.23,-332.47,-314.98,-298.62,-283.29,-268.9,-255.36,-242.59,-230.54,-219.14,-208.34,-198.09,-188.36,-179.1,-170.28,-161.87,-153.84,-146.16,-138.81,-131.77,-125.03,-118.55,-112.33,-106.35,-100.59,-95.048,-89.706,-84.553,-79.578,-74.773,-70.129,-65.636,-61.288,-57.077,-52.995,-49.037,-45.197,-41.469,-37.848,-34.329,-30.906,-27.577,-24.336,-21.179,-18.104,-15.105,-12.181,-9.328,-6.5427,-3.8226,-1.1649,1.4329,3.9733,6.4585,8.8908,11.272,13.605,15.89,18.131,20.328,22.484,24.599,26.676,28.715,30.719,32.688,34.625,36.529,38.403,40.247,42.062,43.85,45.612,47.349,49.06,50.749,52.414,54.058,55.68,57.283,58.866,60.43,61.976,63.504,65.016,66.512,67.992,69.457,70.909,72.346,73.77,75.182,76.581,77.969,79.346,80.712,82.068,83.414,84.751,86.079,87.398,88.71,90.013,91.309,92.599,93.881,95.158,96.428,97.693,98.953,100.21,101.46,102.7,103.94,105.18,106.41,107.65,108.87,110.1,111.32,112.54,113.76,114.97,116.19,117.4,118.61,119.82,121.03,122.24,123.44,124.65,125.86,127.06,128.27,129.48,130.68,131.89,133.1,134.3,135.51,136.72,137.93,139.14,140.36,141.57,142.78,144.0,145.21,146.43,147.65,148.87,150.09,151.32,152.54,153.77,155.0,156.22,157.45,158.69,159.92,161.15,162.39,163.63,164.86,166.1,167.34,168.59,169.83,171.07,172.32,173.56,174.81,176.06,177.31,178.56,179.81,181.06,182.31,183.56,184.81,186.06,187.31,188.56,189.81,191.06,192.31,193.56,194.81,196.06,197.31,198.56,199.81,201.06,202.3,203.55,204.79,206.04,207.28,208.52,209.76,211.0,212.24,213.47,214.71,215.94,217.17,218.4,219.63,220.86,222.09,223.31,224.54,225.76,226.98,228.2,229.42,230.64,231.85,233.07,234.28,235.49,236.71,237.92,239.13,240.34,241.54,242.75,243.96,245.17,246.37,247.58,248.79,249.99,251.2,252.41,253.62,254.82,256.03,257.25,258.46,259.67,260.89,262.1,263.32,264.55,265.77,267.0,268.23,269.46,270.7,271.94,273.18,274.43,275.68,276.94,278.21,279.48,280.75,282.03,283.32,284.61,285.92,287.23,288.54,289.87,291.2,292.55,293.9,295.26,296.64,298.02,299.42,300.83,302.25,303.68,305.13,306.59,308.07,309.56,311.07,312.59,314.13,315.69,317.27,318.86,320.48,322.12,323.78,325.46,327.17,328.9,330.65,332.43,334.24,336.08,337.94,339.84,341.76,343.72,345.72,347.75,349.81,351.92,354.06,356.25,358.48,360.75,363.07,365.44,367.86,370.33,372.85,375.44,378.08,380.78,383.55,386.38,389.29,392.27,395.32,398.46,401.68,404.98,408.38,411.88,415.47,419.17,422.98,426.91,430.96,435.14,439.45,443.91,448.51,453.28,458.21,463.32,468.62,474.11,479.82,485.74,491.91,498.32,505.01,511.98,519.25,526.85,534.8,543.13,551.85,561.01,570.64,580.77,591.45,602.71,614.62,627.23,640.61,654.82,669.95,686.09,703.34,721.84,741.71,763.12,786.26,811.34,838.62,},
{-506.98,-475.86,-447.42,-421.32,-397.28,-375.08,-354.5,-335.38,-317.56,-300.91,-285.32,-270.7,-256.95,-244.0,-231.78,-220.23,-209.3,-198.93,-189.08,-179.72,-170.81,-162.31,-154.2,-146.45,-139.04,-131.95,-125.15,-118.62,-112.36,-106.33,-100.54,-94.964,-89.591,-84.409,-79.41,-74.582,-69.916,-65.405,-61.04,-56.813,-52.718,-48.748,-44.897,-41.16,-37.531,-34.004,-30.576,-27.242,-23.997,-20.838,-17.76,-14.761,-11.836,-8.9831,-6.1989,-3.4805,-0.82509,1.7698,4.3066,6.7878,9.2154,11.592,13.919,16.198,18.432,20.622,22.77,24.878,26.946,28.977,30.972,32.931,34.858,36.752,38.615,40.448,42.253,44.029,45.779,47.503,49.203,50.878,52.53,54.161,55.769,57.358,58.926,60.476,62.007,63.52,65.016,66.496,67.96,69.409,70.844,72.264,73.672,75.066,76.447,77.817,79.176,80.523,81.86,83.187,84.505,85.813,87.113,88.404,89.687,90.963,92.231,93.492,94.747,95.996,97.239,98.476,99.708,100.94,102.16,103.38,104.59,105.8,107.01,108.21,109.41,110.61,111.8,112.99,114.18,115.37,116.56,117.74,118.93,120.11,121.29,122.47,123.65,124.83,126.01,127.19,128.37,129.55,130.73,131.91,133.09,134.27,135.45,136.63,137.81,139.0,140.18,141.37,142.55,143.74,144.93,146.12,147.31,148.5,149.7,150.89,152.09,153.29,154.49,155.69,156.89,158.1,159.3,160.51,161.72,162.93,164.14,165.35,166.56,167.78,169.0,170.21,171.43,172.65,173.87,175.09,176.31,177.53,178.76,179.98,181.2,182.43,183.65,184.88,186.1,187.33,188.55,189.78,191.0,192.23,193.45,194.68,195.9,197.12,198.35,199.57,200.79,202.01,203.23,204.45,205.66,206.88,208.1,209.31,210.52,211.73,212.94,214.15,215.36,216.57,217.77,218.97,220.18,221.38,222.58,223.77,224.97,226.17,227.36,228.55,229.74,230.93,232.12,233.31,234.49,235.68,236.86,238.05,239.23,240.41,241.59,242.77,243.95,245.13,246.31,247.49,248.67,249.85,251.03,252.21,253.39,254.57,255.75,256.94,258.12,259.31,260.5,261.69,262.88,264.07,265.27,266.47,267.67,268.88,270.09,271.3,272.52,273.74,274.97,276.2,277.43,278.67,279.92,281.18,282.44,283.7,284.98,286.26,287.55,288.84,290.15,291.47,292.79,294.12,295.47,296.82,298.19,299.57,300.96,302.36,303.78,305.21,306.66,308.12,309.59,311.09,312.59,314.12,315.66,317.23,318.81,320.41,322.04,323.68,325.35,327.05,328.76,330.51,332.28,334.07,335.9,337.75,339.64,341.56,343.51,345.49,347.51,349.57,351.67,353.8,355.98,358.2,360.47,362.79,365.15,367.56,370.03,372.55,375.13,377.77,380.47,383.24,386.07,388.98,391.96,395.01,398.15,401.38,404.69,408.09,411.59,415.19,418.9,422.73,426.67,430.73,434.92,439.25,443.73,448.36,453.14,458.1,463.24,468.56,474.09,479.83,485.8,492.01,498.47,505.21,512.24,519.57,527.24,535.27,543.68,552.5,561.76,571.5,581.75,592.56,603.98,616.05,628.84,642.42,656.86,672.24,688.66,706.24,725.09,745.37,767.25,790.91,},
{-453.79,-426.98,-402.33,-379.58,-358.53,-338.98,-320.79,-303.81,-287.92,-273.04,-259.05,-245.88,-233.47,-221.74,-210.65,-200.14,-190.16,-180.68,-171.66,-163.06,-154.86,-147.03,-139.55,-132.38,-125.52,-118.93,-112.61,-106.54,-100.7,-95.085,-89.673,-84.457,-79.425,-74.568,-69.876,-65.34,-60.952,-56.705,-52.591,-48.605,-44.739,-40.988,-37.346,-33.809,-30.371,-27.028,-23.776,-20.61,-17.527,-14.523,-11.595,-8.7394,-5.9532,-3.2336,-0.57784,2.0168,4.5527,7.0323,9.4578,11.831,14.155,16.431,18.66,20.846,22.988,25.09,27.152,29.176,31.164,33.117,35.035,36.921,38.775,40.6,42.395,44.161,45.901,47.615,49.304,50.968,52.609,54.227,55.824,57.4,58.956,60.492,62.01,63.51,64.992,66.458,67.907,69.342,70.761,72.166,73.558,74.936,76.302,77.655,78.997,80.327,81.647,82.957,84.256,85.546,86.828,88.1,89.364,90.621,91.87,93.111,94.346,95.575,96.797,98.014,99.225,100.43,101.63,102.83,104.02,105.21,106.39,107.57,108.75,109.92,111.1,112.26,113.43,114.6,115.76,116.92,118.08,119.23,120.39,121.55,122.7,123.86,125.01,126.16,127.31,128.47,129.62,130.77,131.93,133.08,134.23,135.39,136.54,137.7,138.86,140.01,141.17,142.33,143.49,144.66,145.82,146.99,148.15,149.32,150.49,151.66,152.83,154.01,155.18,156.36,157.53,158.71,159.89,161.08,162.26,163.44,164.63,165.82,167.01,168.2,169.39,170.58,171.77,172.97,174.16,175.36,176.55,177.75,178.95,180.15,181.35,182.55,183.75,184.95,186.15,187.35,188.55,189.75,190.95,192.15,193.35,194.54,195.74,196.94,198.14,199.34,200.53,201.73,202.92,204.12,205.31,206.5,207.69,208.88,210.07,211.25,212.44,213.62,214.81,215.99,217.17,218.34,219.52,220.7,221.87,223.04,224.21,225.38,226.55,227.72,228.89,230.05,231.21,232.38,233.54,234.7,235.85,237.01,238.17,239.32,240.48,241.63,242.79,243.94,245.1,246.25,247.4,248.55,249.71,250.86,252.02,253.17,254.33,255.48,256.64,257.8,258.96,260.12,261.29,262.45,263.62,264.79,265.97,267.14,268.32,269.51,270.69,271.88,273.08,274.28,275.48,276.69,277.91,279.13,280.36,281.59,282.83,284.08,285.33,286.6,287.87,289.14,290.43,291.73,293.04,294.35,295.68,297.02,298.37,299.73,301.11,302.5,303.9,305.31,306.74,308.19,309.65,311.13,312.62,314.14,315.67,317.22,318.79,320.38,321.99,323.63,325.29,326.97,328.67,330.41,332.17,333.95,335.77,337.62,339.49,341.4,343.35,345.32,347.34,349.39,351.48,353.61,355.79,358.0,360.27,362.58,364.94,367.35,369.81,372.34,374.91,377.55,380.26,383.03,385.86,388.77,391.76,394.82,397.96,401.19,404.51,407.93,411.44,415.05,418.78,422.61,426.57,430.65,434.87,439.22,443.72,448.37,453.19,458.18,463.35,468.71,474.28,480.07,486.09,492.35,498.87,505.67,512.76,520.18,527.93,536.05,544.55,553.48,562.86,572.72,583.12,594.09,605.67,617.94,630.94,644.76,659.46,675.13,691.88,709.82,729.09,749.84,},
{-408.29,-384.93,-363.33,-343.3,-324.68,-307.32,-291.1,-275.91,-261.65,-248.24,-235.6,-223.68,-212.4,-201.72,-191.6,-181.98,-172.83,-164.12,-155.82,-147.89,-140.32,-133.07,-126.13,-119.48,-113.1,-106.97,-101.08,-95.407,-89.95,-84.692,-79.622,-74.729,-70.003,-65.437,-61.022,-56.749,-52.612,-48.604,-44.718,-40.949,-37.291,-33.739,-30.287,-26.932,-23.669,-20.493,-17.402,-14.39,-11.456,-8.5943,-5.8033,-3.0797,-0.42077,2.1762,4.7138,7.1944,9.6202,11.993,14.316,16.59,18.818,21.001,23.14,25.238,27.296,29.316,31.298,33.245,35.158,37.037,38.885,40.702,42.489,44.248,45.979,47.684,49.364,51.019,52.65,54.258,55.845,57.41,58.954,60.479,61.985,63.473,64.943,66.396,67.833,69.254,70.66,72.051,73.429,74.793,76.143,77.482,78.808,80.123,81.427,82.721,84.004,85.277,86.542,87.797,89.044,90.282,91.513,92.737,93.953,95.163,96.366,97.564,98.755,99.941,101.12,102.3,103.47,104.64,105.8,106.96,108.12,109.27,110.42,111.56,112.71,113.85,114.99,116.13,117.26,118.4,119.53,120.66,121.79,122.92,124.05,125.18,126.31,127.43,128.56,129.69,130.82,131.94,133.07,134.2,135.33,136.46,137.59,138.72,139.86,140.99,142.12,143.26,144.4,145.54,146.67,147.82,148.96,150.1,151.25,152.39,153.54,154.69,155.84,156.99,158.15,159.3,160.46,161.62,162.78,163.94,165.1,166.26,167.43,168.59,169.76,170.93,172.1,173.27,174.44,175.61,176.78,177.96,179.13,180.31,181.48,182.66,183.83,185.01,186.19,187.36,188.54,189.72,190.89,192.07,193.24,194.42,195.59,196.77,197.94,199.11,200.29,201.46,202.63,203.8,204.97,206.13,207.3,208.47,209.63,210.79,211.95,213.11,214.27,215.43,216.59,217.74,218.89,220.05,221.2,222.34,223.49,224.64,225.78,226.92,228.07,229.21,230.35,231.48,232.62,233.75,234.89,236.02,237.15,238.29,239.42,240.55,241.68,242.8,243.93,245.06,246.19,247.32,248.44,249.57,250.7,251.83,252.96,254.09,255.22,256.36,257.49,258.63,259.76,260.9,262.04,263.19,264.33,265.48,266.63,267.79,268.95,270.11,271.28,272.45,273.62,274.8,275.99,277.18,278.37,279.58,280.78,282.0,283.22,284.45,285.69,286.93,288.18,289.45,290.72,292.0,293.29,294.59,295.9,297.23,298.56,299.91,301.27,302.64,304.03,305.43,306.85,308.28,309.73,311.2,312.68,314.18,315.7,317.24,318.8,320.38,321.98,323.61,325.26,326.93,328.63,330.35,332.1,333.88,335.69,337.53,339.4,341.3,343.24,345.22,347.22,349.27,351.36,353.49,355.66,357.87,360.14,362.45,364.81,367.22,369.68,372.21,374.79,377.43,380.14,382.91,385.75,388.67,391.66,394.73,397.89,401.13,404.46,407.89,411.41,415.04,418.78,422.64,426.62,430.72,434.96,439.34,443.87,448.56,453.41,458.44,463.65,469.06,474.68,480.52,486.59,492.92,499.51,506.38,513.56,521.06,528.9,537.12,545.74,554.79,564.31,574.32,584.88,596.03,607.81,620.3,633.54,647.62,662.62,678.63,695.75,714.11,},
{-368.93,-348.36,-329.26,-311.47,-294.87,-279.33,-264.77,-251.08,-238.19,-226.04,-214.56,-203.69,-193.4,-183.62,-174.33,-165.49,-157.07,-149.03,-141.36,-134.02,-126.99,-120.26,-113.81,-107.61,-101.66,-95.93,-90.42,-85.113,-79.997,-75.062,-70.298,-65.695,-61.247,-56.943,-52.778,-48.743,-44.833,-41.042,-37.363,-33.792,-30.323,-26.952,-23.675,-20.486,-17.382,-14.36,-11.416,-8.5456,-5.747,-3.0167,-0.3519,2.2501,4.7919,7.2759,9.7044,12.08,14.404,16.679,18.906,21.088,23.227,25.323,27.379,29.396,31.375,33.318,35.226,37.101,38.944,40.755,42.537,44.29,46.014,47.712,49.384,51.031,52.654,54.254,55.832,57.388,58.923,60.438,61.934,63.411,64.87,66.312,67.737,69.146,70.54,71.919,73.284,74.635,75.972,77.297,78.61,79.911,81.2,82.479,83.747,85.005,86.254,87.494,88.724,89.947,91.161,92.367,93.567,94.759,95.945,97.124,98.297,99.465,100.63,101.78,102.94,104.08,105.23,106.37,107.5,108.63,109.76,110.89,112.01,113.13,114.25,115.37,116.48,117.59,118.7,119.81,120.92,122.03,123.13,124.24,125.34,126.44,127.55,128.65,129.76,130.86,131.96,133.07,134.17,135.28,136.38,137.49,138.6,139.7,140.81,141.92,143.04,144.15,145.26,146.38,147.49,148.61,149.73,150.85,151.97,153.1,154.22,155.35,156.48,157.61,158.74,159.87,161.0,162.14,163.27,164.41,165.55,166.69,167.83,168.98,170.12,171.27,172.41,173.56,174.71,175.86,177.01,178.16,179.31,180.46,181.61,182.77,183.92,185.07,186.23,187.38,188.53,189.69,190.84,191.99,193.15,194.3,195.45,196.6,197.75,198.9,200.05,201.2,202.35,203.49,204.64,205.78,206.93,208.07,209.21,210.35,211.49,212.63,213.76,214.9,216.03,217.16,218.29,219.42,220.55,221.67,222.8,223.92,225.04,226.16,227.28,228.4,229.51,230.63,231.74,232.85,233.96,235.07,236.18,237.29,238.4,239.5,240.61,241.71,242.82,243.92,245.03,246.13,247.23,248.34,249.44,250.55,251.65,252.76,253.87,254.97,256.08,257.19,258.3,259.42,260.53,261.65,262.77,263.89,265.02,266.15,267.28,268.41,269.55,270.7,271.84,272.99,274.15,275.31,276.48,277.65,278.83,280.01,281.2,282.4,283.6,284.82,286.04,287.27,288.5,289.75,291.01,292.27,293.55,294.83,296.13,297.44,298.76,300.1,301.44,302.81,304.18,305.57,306.98,308.4,309.83,311.29,312.76,314.25,315.76,317.29,318.84,320.41,322.01,323.62,325.27,326.93,328.62,330.34,332.08,333.86,335.66,337.5,339.36,341.26,343.19,345.16,347.17,349.22,351.3,353.43,355.6,357.82,360.08,362.39,364.75,367.16,369.63,372.16,374.75,377.4,380.11,382.89,385.74,388.67,391.67,394.75,397.92,401.17,404.52,407.97,411.51,415.16,418.93,422.81,426.81,430.94,435.21,439.63,444.19,448.92,453.81,458.89,464.15,469.61,475.28,481.18,487.32,493.72,500.39,507.35,514.61,522.21,530.17,538.51,547.26,556.45,566.11,576.3,587.04,598.39,610.4,623.13,636.65,651.03,666.37,682.75,},
{-334.55,-316.28,-299.25,-283.33,-268.41,-254.41,-241.24,-228.84,-217.12,-206.05,-195.56,-185.61,-176.16,-167.17,-158.61,-150.45,-142.66,-135.22,-128.1,-121.28,-114.74,-108.47,-102.44,-96.652,-91.081,-85.717,-80.549,-75.566,-70.756,-66.112,-61.625,-57.285,-53.086,-49.021,-45.082,-41.264,-37.561,-33.967,-30.477,-27.086,-23.791,-20.585,-17.467,-14.43,-11.473,-8.5917,-5.7826,-3.0428,-0.36954,2.24,4.7885,7.2783,9.7119,12.091,14.419,16.697,18.926,21.11,23.249,25.346,27.401,29.417,31.395,33.337,35.243,37.115,38.954,40.762,42.539,44.287,46.007,47.699,49.365,51.006,52.623,54.215,55.786,57.334,58.861,60.367,61.854,63.322,64.772,66.204,67.62,69.019,70.402,71.77,73.123,74.462,75.788,77.1,78.401,79.689,80.965,82.23,83.485,84.729,85.964,87.189,88.405,89.612,90.811,92.002,93.185,94.362,95.531,96.694,97.85,99.001,100.15,101.28,102.42,103.55,104.67,105.79,106.91,108.02,109.13,110.24,111.34,112.44,113.54,114.64,115.73,116.82,117.91,119.0,120.08,121.17,122.25,123.33,124.42,125.5,126.58,127.66,128.74,129.82,130.9,131.98,133.06,134.14,135.23,136.31,137.39,138.48,139.56,140.65,141.73,142.82,143.91,145.0,146.09,147.18,148.28,149.37,150.47,151.57,152.67,153.77,154.87,155.98,157.08,158.19,159.3,160.41,161.52,162.64,163.75,164.87,165.98,167.1,168.22,169.34,170.47,171.59,172.71,173.84,174.97,176.09,177.22,178.35,179.48,180.61,181.74,182.87,184.0,185.13,186.26,187.39,188.53,189.66,190.79,191.92,193.05,194.18,195.31,196.44,197.57,198.7,199.83,200.95,202.08,203.2,204.33,205.45,206.57,207.69,208.81,209.93,211.04,212.16,213.27,214.39,215.5,216.61,217.71,218.82,219.93,221.03,222.13,223.23,224.33,225.43,226.53,227.62,228.71,229.81,230.9,231.99,233.08,234.16,235.25,236.34,237.42,238.5,239.59,240.67,241.75,242.83,243.91,244.99,246.07,247.16,248.24,249.32,250.4,251.48,252.56,253.65,254.73,255.82,256.91,258.0,259.09,260.18,261.27,262.37,263.47,264.57,265.68,266.79,267.9,269.02,270.14,271.26,272.39,273.52,274.66,275.81,276.95,278.11,279.27,280.44,281.61,282.8,283.98,285.18,286.39,287.6,288.82,290.06,291.3,292.55,293.81,295.09,296.37,297.67,298.98,300.3,301.63,302.98,304.35,305.73,307.12,308.53,309.96,311.41,312.87,314.35,315.85,317.37,318.92,320.48,322.07,323.68,325.31,326.97,328.66,330.37,332.11,333.88,335.68,337.51,339.37,341.27,343.2,345.17,347.18,349.22,351.31,353.43,355.61,357.82,360.09,362.4,364.77,367.19,369.66,372.2,374.79,377.45,380.17,382.96,385.83,388.76,391.78,394.88,398.06,401.33,404.7,408.17,411.73,415.41,419.2,423.11,427.14,431.31,435.62,440.07,444.67,449.44,454.39,459.51,464.83,470.35,476.09,482.06,488.28,494.76,501.51,508.56,515.94,523.65,531.73,540.2,549.09,558.44,568.28,578.65,589.6,601.18,613.44,626.45,640.28,655.0,},
{-304.26,-287.9,-272.6,-258.25,-244.77,-232.08,-220.11,-208.8,-198.09,-187.95,-178.32,-169.17,-160.46,-152.16,-144.24,-136.68,-129.45,-122.53,-115.9,-109.54,-103.44,-97.572,-91.933,-86.506,-81.278,-76.24,-71.379,-66.688,-62.155,-57.775,-53.537,-49.436,-45.464,-41.615,-37.882,-34.261,-30.747,-27.333,-24.016,-20.79,-17.653,-14.6,-11.627,-8.7311,-5.9087,-3.1568,-0.47238,2.1473,4.7049,7.203,9.6439,12.03,14.363,16.646,18.88,21.067,23.209,25.308,27.365,29.382,31.361,33.302,35.207,37.078,38.916,40.722,42.496,44.241,45.957,47.646,49.308,50.944,52.555,54.142,55.706,57.248,58.769,60.268,61.748,63.208,64.65,66.074,67.48,68.87,70.244,71.602,72.945,74.274,75.589,76.891,78.18,79.457,80.721,81.974,83.217,84.448,85.67,86.882,88.084,89.278,90.463,91.639,92.808,93.969,95.124,96.271,97.412,98.546,99.675,100.8,101.92,103.03,104.14,105.24,106.34,107.43,108.52,109.61,110.7,111.78,112.86,113.93,115.01,116.08,117.15,118.21,119.28,120.34,121.41,122.47,123.53,124.59,125.65,126.71,127.77,128.83,129.88,130.94,132.0,133.06,134.12,135.18,136.24,137.3,138.36,139.42,140.49,141.55,142.62,143.68,144.75,145.82,146.89,147.96,149.03,150.11,151.18,152.26,153.34,154.42,155.5,156.58,157.67,158.76,159.84,160.93,162.02,163.12,164.21,165.3,166.4,167.5,168.6,169.7,170.8,171.9,173.0,174.11,175.21,176.32,177.43,178.53,179.64,180.75,181.86,182.97,184.08,185.19,186.3,187.41,188.52,189.63,190.74,191.85,192.96,194.07,195.18,196.29,197.39,198.5,199.61,200.71,201.82,202.92,204.02,205.13,206.23,207.33,208.42,209.52,210.62,211.71,212.8,213.89,214.98,216.07,217.16,218.24,219.33,220.41,221.49,222.57,223.65,224.73,225.8,226.87,227.95,229.02,230.09,231.16,232.22,233.29,234.35,235.42,236.48,237.54,238.6,239.67,240.73,241.78,242.84,243.9,244.96,246.02,247.08,248.14,249.2,250.26,251.32,252.38,253.44,254.5,255.57,256.63,257.7,258.77,259.84,260.91,261.99,263.07,264.15,265.23,266.32,267.41,268.5,269.6,270.7,271.81,272.92,274.04,275.16,276.29,277.42,278.56,279.71,280.86,282.02,283.19,284.36,285.54,286.74,287.94,289.15,290.36,291.59,292.83,294.08,295.35,296.62,297.9,299.2,300.51,301.84,303.18,304.53,305.9,307.29,308.69,310.11,311.55,313.0,314.48,315.97,317.49,319.02,320.58,322.16,323.77,325.4,327.05,328.73,330.44,332.18,333.95,335.74,337.57,339.43,341.33,343.26,345.23,347.24,349.28,351.37,353.5,355.68,357.9,360.17,362.49,364.86,367.29,369.77,372.32,374.92,377.59,380.32,383.13,386.0,388.96,391.99,395.11,398.31,401.6,404.99,408.48,412.08,415.78,419.6,423.55,427.62,431.82,436.17,440.66,445.32,450.14,455.14,460.32,465.7,471.29,477.1,483.15,489.45,496.02,502.88,510.04,517.53,525.37,533.58,542.2,551.26,560.78,570.81,581.4,592.58,604.41,616.96,630.27,},
{-277.36,-262.62,-248.79,-235.78,-223.52,-211.95,-201.01,-190.65,-180.82,-171.49,-162.61,-154.16,-146.1,-138.41,-131.05,-124.02,-117.29,-110.83,-104.64,-98.693,-92.977,-87.478,-82.184,-77.084,-72.166,-67.42,-62.838,-58.41,-54.129,-49.987,-45.977,-42.092,-38.327,-34.675,-31.132,-27.691,-24.349,-21.1,-17.941,-14.868,-11.876,-8.9628,-6.1243,-3.3575,-0.65939,1.9729,4.5421,7.0508,9.5013,11.896,14.237,16.527,18.767,20.96,23.107,25.21,27.271,29.291,31.271,33.214,35.121,36.992,38.83,40.635,42.409,44.152,45.866,47.552,49.211,50.844,52.452,54.035,55.595,57.132,58.647,60.141,61.614,63.068,64.503,65.92,67.319,68.701,70.067,71.416,72.751,74.071,75.377,76.669,77.948,79.214,80.468,81.71,82.941,84.162,85.371,86.571,87.761,88.942,90.114,91.278,92.433,93.581,94.721,95.854,96.981,98.101,99.214,100.32,101.42,102.52,103.61,104.7,105.78,106.86,107.94,109.01,110.07,111.14,112.2,113.25,114.31,115.36,116.41,117.46,118.51,119.55,120.6,121.64,122.68,123.72,124.76,125.8,126.83,127.87,128.91,129.94,130.98,132.02,133.06,134.09,135.13,136.17,137.21,138.25,139.29,140.33,141.37,142.42,143.46,144.51,145.56,146.6,147.65,148.71,149.76,150.81,151.87,152.92,153.98,155.04,156.1,157.17,158.23,159.3,160.37,161.43,162.5,163.58,164.65,165.72,166.8,167.88,168.96,170.04,171.12,172.2,173.28,174.37,175.45,176.54,177.62,178.71,179.8,180.89,181.97,183.06,184.15,185.24,186.33,187.42,188.51,189.6,190.69,191.78,192.87,193.96,195.05,196.14,197.23,198.31,199.4,200.48,201.57,202.65,203.73,204.82,205.9,206.98,208.05,209.13,210.2,211.28,212.35,213.42,214.49,215.56,216.63,217.69,218.75,219.82,220.88,221.94,222.99,224.05,225.1,226.16,227.21,228.26,229.31,230.36,231.4,232.45,233.49,234.54,235.58,236.62,237.66,238.7,239.74,240.78,241.82,242.85,243.89,244.93,245.97,247.0,248.04,249.08,250.12,251.16,252.2,253.24,254.28,255.32,256.37,257.41,258.46,259.51,260.56,261.62,262.68,263.74,264.8,265.87,266.94,268.01,269.09,270.17,271.26,272.35,273.44,274.54,275.65,276.76,277.88,279.01,280.14,281.28,282.42,283.58,284.74,285.91,287.09,288.27,289.47,290.68,291.9,293.12,294.36,295.61,296.88,298.15,299.44,300.74,302.06,303.39,304.74,306.1,307.48,308.87,310.28,311.71,313.16,314.63,316.12,317.63,319.16,320.71,322.29,323.89,325.52,327.17,328.85,330.56,332.29,334.06,335.85,337.68,339.55,341.44,343.38,345.35,347.36,349.41,351.5,353.64,355.82,358.04,360.32,362.65,365.03,367.47,369.96,372.51,375.13,377.81,380.56,383.38,386.28,389.25,392.3,395.44,398.67,401.98,405.4,408.92,412.55,416.28,420.14,424.12,428.23,432.48,436.87,441.42,446.12,451.0,456.06,461.31,466.76,472.43,478.32,484.46,490.85,497.53,504.49,511.77,519.39,527.37,535.73,544.52,553.75,563.48,573.72,584.54,595.98,608.1,},
{-253.32,-239.96,-227.38,-215.52,-204.32,-193.71,-183.67,-174.13,-165.07,-156.45,-148.23,-140.4,-132.91,-125.75,-118.91,-112.35,-106.05,-100.02,-94.214,-88.636,-83.268,-78.099,-73.116,-68.311,-63.673,-59.193,-54.863,-50.675,-46.622,-42.698,-38.895,-35.208,-31.632,-28.16,-24.789,-21.514,-18.33,-15.233,-12.22,-9.2861,-6.4287,-3.6443,-0.92981,1.7177,4.3009,6.8226,9.2851,11.691,14.042,16.341,18.59,20.79,22.944,25.053,27.119,29.143,31.128,33.074,34.984,36.857,38.696,40.503,42.277,44.02,45.734,47.419,49.077,50.708,52.313,53.893,55.45,56.983,58.494,59.984,61.453,62.902,64.331,65.742,67.135,68.511,69.87,71.212,72.539,73.851,75.149,76.432,77.703,78.96,80.205,81.437,82.658,83.868,85.067,86.256,87.435,88.605,89.765,90.917,92.06,93.195,94.323,95.443,96.556,97.662,98.762,99.856,100.94,102.03,103.1,104.17,105.24,106.3,107.36,108.42,109.47,110.52,111.56,112.6,113.64,114.67,115.71,116.74,117.76,118.79,119.82,120.84,121.86,122.88,123.9,124.92,125.94,126.96,127.97,128.99,130.01,131.02,132.04,133.05,134.07,135.09,136.11,137.13,138.14,139.16,140.19,141.21,142.23,143.25,144.28,145.31,146.33,147.36,148.39,149.42,150.46,151.49,152.53,153.56,154.6,155.64,156.68,157.73,158.77,159.82,160.87,161.92,162.97,164.02,165.07,166.13,167.19,168.24,169.3,170.36,171.42,172.49,173.55,174.61,175.68,176.75,177.81,178.88,179.95,181.02,182.09,183.16,184.23,185.3,186.37,187.44,188.51,189.58,190.65,191.72,192.79,193.86,194.93,196.0,197.06,198.13,199.2,200.26,201.33,202.39,203.46,204.52,205.58,206.64,207.7,208.75,209.81,210.86,211.92,212.97,214.02,215.07,216.11,217.16,218.2,219.24,220.29,221.33,222.36,223.4,224.43,225.47,226.5,227.53,228.56,229.59,230.62,231.64,232.67,233.69,234.71,235.73,236.75,237.77,238.79,239.81,240.83,241.85,242.86,243.88,244.9,245.91,246.93,247.95,248.97,249.98,251.0,252.02,253.04,254.06,255.09,256.11,257.14,258.17,259.2,260.23,261.26,262.3,263.34,264.39,265.43,266.48,267.54,268.59,269.66,270.72,271.79,272.87,273.95,275.04,276.13,277.23,278.33,279.44,280.56,281.69,282.82,283.96,285.11,286.27,287.44,288.61,289.8,291.0,292.2,293.42,294.65,295.89,297.15,298.42,299.7,300.99,302.3,303.62,304.96,306.31,307.69,309.07,310.48,311.9,313.35,314.81,316.3,317.8,319.33,320.88,322.45,324.05,325.68,327.33,329.01,330.71,332.45,334.21,336.01,337.84,339.71,341.61,343.54,345.52,347.53,349.59,351.69,353.83,356.02,358.25,360.54,362.88,365.27,367.72,370.22,372.79,375.42,378.12,380.89,383.73,386.64,389.64,392.71,395.87,399.13,402.47,405.92,409.47,413.13,416.91,420.8,424.83,428.98,433.28,437.72,442.32,447.09,452.03,457.16,462.48,468.01,473.76,479.75,485.98,492.48,499.27,506.35,513.77,521.53,529.66,538.2,547.16,556.6,566.54,577.02,588.1,},
{-231.71,-219.53,-208.03,-197.16,-186.87,-177.12,-167.85,-159.04,-150.65,-142.66,-135.03,-127.73,-120.76,-114.08,-107.68,-101.54,-95.646,-89.981,-84.531,-79.286,-74.233,-69.361,-64.661,-60.123,-55.738,-51.5,-47.399,-43.43,-39.585,-35.859,-32.246,-28.74,-25.337,-22.032,-18.819,-15.696,-12.658,-9.7006,-6.8214,-4.0167,-1.2832,1.382,3.9818,6.5187,8.9955,11.415,13.778,16.088,18.347,20.557,22.72,24.836,26.91,28.941,30.931,32.882,34.796,36.673,38.516,40.325,42.101,43.846,45.561,47.246,48.904,50.535,52.139,53.718,55.273,56.804,58.312,59.799,61.264,62.709,64.135,65.541,66.929,68.299,69.652,70.989,72.31,73.615,74.906,76.182,77.445,78.694,79.93,81.154,82.367,83.567,84.757,85.936,87.105,88.265,89.415,90.555,91.687,92.811,93.927,95.035,96.136,97.23,98.317,99.397,100.47,101.54,102.6,103.66,104.71,105.76,106.81,107.85,108.88,109.91,110.94,111.97,112.99,114.01,115.02,116.04,117.05,118.06,119.06,120.07,121.07,122.08,123.08,124.08,125.08,126.07,127.07,128.07,129.07,130.06,131.06,132.06,133.05,134.05,135.05,136.05,137.05,138.04,139.04,140.05,141.05,142.05,143.05,144.06,145.06,146.07,147.08,148.09,149.1,150.11,151.13,152.14,153.16,154.18,155.2,156.22,157.24,158.27,159.29,160.32,161.35,162.38,163.41,164.45,165.48,166.52,167.56,168.6,169.64,170.68,171.72,172.76,173.81,174.85,175.9,176.95,178.0,179.04,180.09,181.14,182.19,183.25,184.3,185.35,186.4,187.45,188.5,189.56,190.61,191.66,192.71,193.76,194.81,195.86,196.91,197.96,199.0,200.05,201.1,202.14,203.19,204.23,205.27,206.31,207.35,208.39,209.43,210.46,211.5,212.53,213.56,214.59,215.62,216.64,217.67,218.69,219.72,220.74,221.76,222.77,223.79,224.8,225.82,226.83,227.84,228.85,229.86,230.86,231.87,232.87,233.88,234.88,235.88,236.88,237.88,238.88,239.88,240.88,241.87,242.87,243.87,244.87,245.86,246.86,247.86,248.86,249.85,250.85,251.85,252.86,253.86,254.86,255.87,256.87,257.88,258.89,259.91,260.92,261.94,262.96,263.99,265.01,266.05,267.08,268.12,269.16,270.21,271.26,272.32,273.38,274.45,275.52,276.6,277.69,278.78,279.88,280.98,282.1,283.22,284.35,285.49,286.64,287.79,288.96,290.14,291.32,292.52,293.73,294.95,296.19,297.43,298.69,299.96,301.25,302.55,303.87,305.2,306.55,307.92,309.3,310.7,312.12,313.56,315.02,316.5,318.01,319.53,321.08,322.65,324.25,325.87,327.52,329.2,330.91,332.65,334.41,336.22,338.05,339.92,341.82,343.76,345.74,347.76,349.83,351.93,354.08,356.28,358.53,360.82,363.17,365.58,368.04,370.56,373.15,375.8,378.51,381.3,384.16,387.1,390.12,393.22,396.41,399.69,403.07,406.55,410.14,413.84,417.66,421.6,425.67,429.87,434.22,438.73,443.39,448.22,453.23,458.43,463.84,469.45,475.3,481.38,487.73,494.34,501.25,508.47,516.03,523.95,532.25,540.97,550.14,559.79,569.97,},
{-212.17,-201.01,-190.45,-180.45,-170.96,-161.95,-153.37,-145.2,-137.4,-129.96,-122.85,-116.05,-109.53,-103.28,-97.277,-91.516,-85.977,-80.648,-75.516,-70.572,-65.803,-61.201,-56.757,-52.462,-48.309,-44.29,-40.399,-36.63,-32.976,-29.432,-25.992,-22.653,-19.409,-16.256,-13.189,-10.206,-7.3023,-4.4744,-1.7193,0.96617,3.5849,6.1396,8.633,11.067,13.445,15.769,18.04,20.262,22.435,24.561,26.644,28.683,30.681,32.639,34.558,36.441,38.288,40.101,41.881,43.629,45.347,47.034,48.693,50.325,51.929,53.508,55.062,56.593,58.1,59.585,61.048,62.49,63.913,65.316,66.7,68.066,69.415,70.747,72.062,73.362,74.647,75.917,77.173,78.415,79.645,80.861,82.066,83.259,84.44,85.611,86.771,87.921,89.061,90.192,91.314,92.427,93.532,94.63,95.719,96.802,97.877,98.946,100.01,101.06,102.11,103.16,104.2,105.23,106.26,107.29,108.31,109.33,110.34,111.35,112.36,113.36,114.36,115.36,116.35,117.35,118.34,119.33,120.31,121.3,122.28,123.27,124.25,125.23,126.21,127.19,128.17,129.14,130.12,131.1,132.08,133.06,134.03,135.01,135.99,136.97,137.95,138.93,139.91,140.89,141.88,142.86,143.85,144.83,145.82,146.81,147.8,148.79,149.79,150.78,151.78,152.77,153.77,154.77,155.77,156.78,157.78,158.79,159.8,160.81,161.82,162.83,163.84,164.86,165.88,166.89,167.91,168.93,169.96,170.98,172.0,173.03,174.06,175.08,176.11,177.14,178.17,179.2,180.23,181.27,182.3,183.33,184.36,185.4,186.43,187.46,188.5,189.53,190.57,191.6,192.63,193.66,194.7,195.73,196.76,197.79,198.82,199.85,200.87,201.9,202.93,203.95,204.98,206.0,207.02,208.04,209.06,210.08,211.09,212.11,213.12,214.13,215.14,216.15,217.16,218.16,219.17,220.17,221.17,222.17,223.17,224.16,225.16,226.15,227.15,228.14,229.13,230.11,231.1,232.09,233.07,234.06,235.04,236.02,237.0,237.98,238.96,239.94,240.92,241.9,242.88,243.86,244.83,245.81,246.79,247.77,248.75,249.73,250.71,251.69,252.67,253.66,254.64,255.63,256.62,257.61,258.6,259.6,260.59,261.59,262.6,263.6,264.61,265.62,266.64,267.66,268.69,269.72,270.75,271.79,272.83,273.88,274.94,276.0,277.06,278.14,279.22,280.31,281.4,282.51,283.62,284.74,285.87,287.0,288.15,289.31,290.48,291.66,292.85,294.05,295.26,296.49,297.73,298.98,300.25,301.53,302.82,304.13,305.46,306.81,308.17,309.55,310.95,312.36,313.8,315.26,316.74,318.24,319.76,321.31,322.88,324.48,326.11,327.76,329.44,331.15,332.89,334.66,336.46,338.3,340.18,342.09,344.03,346.02,348.05,350.12,352.24,354.4,356.61,358.87,361.18,363.54,365.96,368.44,370.98,373.58,376.25,378.99,381.8,384.69,387.65,390.7,393.83,397.05,400.37,403.78,407.3,410.93,414.67,418.53,422.52,426.64,430.91,435.32,439.88,444.61,449.52,454.61,459.89,465.38,471.09,477.04,483.23,489.69,496.44,503.48,510.85,518.57,526.66,535.15,544.08,553.46,},
{-194.42,-184.15,-174.42,-165.17,-156.39,-148.03,-140.06,-132.45,-125.19,-118.24,-111.59,-105.22,-99.111,-93.244,-87.607,-82.187,-76.97,-71.945,-67.102,-62.43,-57.92,-53.563,-49.352,-45.279,-41.337,-37.52,-33.821,-30.234,-26.755,-23.379,-20.099,-16.913,-13.815,-10.803,-7.8715,-5.0177,-2.2382,0.47013,3.1103,5.6852,8.1975,10.65,13.044,15.383,17.669,19.904,22.089,24.228,26.321,28.37,30.377,32.343,34.271,36.161,38.014,39.833,41.618,43.37,45.091,46.782,48.444,50.078,51.684,53.264,54.819,56.35,57.857,59.341,60.804,62.245,63.665,65.066,66.448,67.811,69.156,70.484,71.796,73.091,74.371,75.636,76.887,78.123,79.347,80.557,81.755,82.941,84.115,85.278,86.43,87.572,88.703,89.826,90.939,92.043,93.138,94.226,95.305,96.377,97.442,98.5,99.551,100.6,101.63,102.67,103.69,104.72,105.73,106.75,107.75,108.76,109.76,110.75,111.75,112.74,113.72,114.7,115.68,116.66,117.64,118.61,119.58,120.55,121.52,122.48,123.45,124.41,125.38,126.34,127.3,128.26,129.22,130.18,131.14,132.1,133.06,134.02,134.98,135.94,136.9,137.86,138.82,139.78,140.75,141.71,142.68,143.64,144.61,145.58,146.55,147.52,148.49,149.47,150.44,151.42,152.4,153.38,154.36,155.34,156.33,157.31,158.3,159.29,160.28,161.27,162.27,163.26,164.26,165.26,166.26,167.26,168.26,169.26,170.27,171.27,172.28,173.29,174.3,175.31,176.32,177.33,178.34,179.35,180.37,181.38,182.4,183.41,184.43,185.44,186.46,187.48,188.49,189.51,190.53,191.54,192.56,193.57,194.59,195.6,196.61,197.63,198.64,199.65,200.66,201.67,202.68,203.69,204.69,205.7,206.7,207.7,208.7,209.7,210.7,211.7,212.7,213.69,214.68,215.67,216.66,217.65,218.64,219.62,220.61,221.59,222.57,223.55,224.53,225.5,226.48,227.45,228.42,229.39,230.36,231.33,232.3,233.26,234.23,235.19,236.16,237.12,238.08,239.04,240.0,240.96,241.92,242.88,243.84,244.8,245.76,246.72,247.68,248.64,249.61,250.57,251.53,252.5,253.46,254.43,255.4,256.37,257.34,258.32,259.3,260.28,261.26,262.24,263.23,264.22,265.22,266.22,267.22,268.23,269.24,270.26,271.28,272.3,273.34,274.37,275.42,276.47,277.52,278.59,279.66,280.73,281.82,282.91,284.02,285.13,286.25,287.38,288.52,289.66,290.83,292.0,293.18,294.37,295.58,296.8,298.03,299.28,300.54,301.82,303.11,304.42,305.74,307.08,308.44,309.82,311.21,312.63,314.07,315.52,317.0,318.5,320.03,321.58,323.15,324.75,326.38,328.03,329.71,331.43,333.17,334.95,336.76,338.6,340.48,342.4,344.36,346.36,348.39,350.48,352.6,354.78,357.0,359.27,361.6,363.98,366.42,368.91,371.47,374.1,376.79,379.55,382.39,385.3,388.29,391.37,394.54,397.79,401.15,404.6,408.16,411.83,415.62,419.54,423.58,427.76,432.08,436.56,441.19,446.0,450.98,456.15,461.53,467.12,472.93,478.99,485.31,491.89,498.78,505.97,513.5,521.39,529.67,538.37,},
{-178.22,-168.74,-159.73,-151.15,-142.99,-135.21,-127.78,-120.68,-113.89,-107.39,-101.15,-95.171,-89.427,-83.907,-78.597,-73.485,-68.56,-63.811,-59.229,-54.806,-50.531,-46.399,-42.401,-38.531,-34.783,-31.15,-27.627,-24.209,-20.891,-17.668,-14.536,-11.491,-8.5294,-5.6469,-2.8403,-0.10638,2.5579,5.1553,7.6888,10.161,12.574,14.931,17.233,19.483,21.684,23.835,25.941,28.002,30.02,31.996,33.933,35.831,37.693,39.519,41.31,43.069,44.795,46.491,48.157,49.794,51.403,52.986,54.543,56.075,57.584,59.069,60.531,61.972,63.392,64.791,66.172,67.533,68.876,70.202,71.51,72.802,74.079,75.34,76.586,77.818,79.036,80.241,81.433,82.613,83.781,84.937,86.082,87.217,88.341,89.456,90.561,91.656,92.743,93.822,94.892,95.955,97.01,98.057,99.098,100.13,101.16,102.18,103.2,104.21,105.22,106.22,107.21,108.2,109.19,110.17,111.15,112.13,113.1,114.07,115.03,116.0,116.96,117.92,118.87,119.83,120.78,121.73,122.68,123.63,124.57,125.52,126.46,127.41,128.35,129.29,130.23,131.18,132.12,133.06,134.0,134.94,135.89,136.83,137.77,138.72,139.66,140.61,141.55,142.5,143.45,144.4,145.35,146.3,147.25,148.21,149.16,150.12,151.08,152.04,153.0,153.97,154.93,155.9,156.86,157.83,158.8,159.78,160.75,161.72,162.7,163.68,164.66,165.64,166.62,167.61,168.59,169.58,170.57,171.55,172.54,173.54,174.53,175.52,176.52,177.51,178.51,179.5,180.5,181.5,182.49,183.49,184.49,185.49,186.49,187.49,188.49,189.49,190.49,191.49,192.48,193.48,194.48,195.48,196.47,197.47,198.46,199.46,200.45,201.45,202.44,203.43,204.42,205.4,206.39,207.38,208.36,209.34,210.33,211.31,212.29,213.26,214.24,215.21,216.19,217.16,218.13,219.09,220.06,221.03,221.99,222.95,223.91,224.87,225.83,226.79,227.74,228.7,229.65,230.6,231.55,232.5,233.45,234.39,235.34,236.28,237.23,238.17,239.12,240.06,241.0,241.94,242.89,243.83,244.77,245.71,246.66,247.6,248.54,249.49,250.43,251.38,252.33,253.28,254.23,255.18,256.13,257.09,258.05,259.01,259.97,260.94,261.9,262.88,263.85,264.83,265.81,266.8,267.79,268.78,269.78,270.79,271.8,272.81,273.83,274.86,275.89,276.93,277.98,279.03,280.09,281.16,282.24,283.32,284.42,285.52,286.63,287.75,288.88,290.03,291.18,292.35,293.52,294.71,295.91,297.13,298.36,299.6,300.86,302.13,303.42,304.72,306.04,307.38,308.74,310.11,311.51,312.92,314.36,315.82,317.3,318.8,320.32,321.87,323.45,325.05,326.68,328.34,330.03,331.75,333.5,335.28,337.1,338.95,340.84,342.77,344.74,346.74,348.79,350.89,353.03,355.22,357.45,359.74,362.09,364.49,366.94,369.46,372.04,374.69,377.41,380.2,383.06,386.01,389.03,392.14,395.34,398.64,402.03,405.53,409.14,412.86,416.7,420.67,424.77,429.01,433.4,437.95,442.66,447.55,452.62,457.88,463.36,469.05,474.98,481.16,487.6,494.33,501.36,508.72,516.43,524.51,},
{-163.39,-154.59,-146.22,-138.24,-130.63,-123.37,-116.42,-109.77,-103.41,-97.301,-91.441,-85.812,-80.401,-75.194,-70.18,-65.348,-60.688,-56.191,-51.848,-47.651,-43.593,-39.666,-35.863,-32.18,-28.609,-25.146,-21.785,-18.523,-15.353,-12.272,-9.2767,-6.3624,-3.5259,-0.76383,1.927,4.5496,7.1067,9.6011,12.035,14.412,16.733,19.0,21.217,23.384,25.504,27.578,29.609,31.597,33.545,35.454,37.324,39.159,40.959,42.724,44.457,46.159,47.831,49.473,51.087,52.673,54.234,55.769,57.279,58.766,60.23,61.672,63.092,64.492,65.872,67.232,68.574,69.898,71.205,72.495,73.768,75.026,76.269,77.498,78.712,79.912,81.1,82.275,83.437,84.588,85.727,86.856,87.974,89.081,90.179,91.267,92.347,93.417,94.479,95.533,96.58,97.618,98.65,99.675,100.69,101.7,102.71,103.71,104.71,105.7,106.68,107.66,108.63,109.61,110.57,111.54,112.49,113.45,114.4,115.35,116.3,117.24,118.19,119.13,120.06,121.0,121.93,122.87,123.8,124.73,125.66,126.58,127.51,128.44,129.36,130.29,131.21,132.14,133.06,133.99,134.91,135.84,136.76,137.69,138.62,139.55,140.47,141.4,142.33,143.26,144.2,145.13,146.06,147.0,147.93,148.87,149.81,150.75,151.7,152.64,153.58,154.53,155.48,156.43,157.38,158.33,159.29,160.24,161.2,162.16,163.12,164.08,165.05,166.01,166.98,167.94,168.91,169.88,170.85,171.83,172.8,173.78,174.75,175.73,176.71,177.68,178.66,179.64,180.62,181.61,182.59,183.57,184.55,185.53,186.52,187.5,188.48,189.47,190.45,191.43,192.41,193.4,194.38,195.36,196.34,197.32,198.3,199.27,200.25,201.23,202.2,203.18,204.15,205.12,206.09,207.06,208.03,209.0,209.96,210.93,211.89,212.85,213.81,214.77,215.72,216.68,217.63,218.59,219.54,220.48,221.43,222.38,223.32,224.26,225.21,226.15,227.08,228.02,228.96,229.89,230.83,231.76,232.69,233.62,234.55,235.48,236.41,237.33,238.26,239.19,240.11,241.04,241.96,242.89,243.81,244.74,245.67,246.59,247.52,248.45,249.37,250.3,251.23,252.16,253.1,254.03,254.97,255.9,256.84,257.78,258.73,259.67,260.62,261.58,262.53,263.49,264.45,265.42,266.39,267.36,268.34,269.33,270.31,271.31,272.31,273.31,274.32,275.34,276.36,277.39,278.43,279.47,280.53,281.59,282.66,283.73,284.82,285.91,287.02,288.13,289.26,290.4,291.55,292.7,293.88,295.06,296.26,297.47,298.69,299.93,301.19,302.46,303.74,305.05,306.37,307.7,309.06,310.43,311.83,313.24,314.68,316.14,317.62,319.12,320.65,322.21,323.79,325.39,327.03,328.69,330.39,332.11,333.87,335.66,337.49,339.35,341.25,343.19,345.16,347.18,349.25,351.36,353.51,355.72,357.97,360.28,362.64,365.06,367.54,370.08,372.69,375.37,378.11,380.93,383.82,386.8,389.86,393.01,396.25,399.59,403.03,406.57,410.23,414.01,417.9,421.93,426.1,430.41,434.87,439.49,444.29,449.26,454.43,459.79,465.37,471.18,477.23,483.55,490.13,497.01,504.21,511.75,},
{-149.75,-141.56,-133.76,-126.31,-119.2,-112.39,-105.88,-99.64,-93.654,-87.908,-82.387,-77.077,-71.967,-67.045,-62.3,-57.724,-53.306,-49.039,-44.914,-40.925,-37.064,-33.325,-29.703,-26.19,-22.784,-19.477,-16.266,-13.147,-10.114,-7.1653,-4.296,-1.503,1.2171,3.8674,6.4506,8.9697,11.427,13.826,16.167,18.454,20.689,22.874,25.01,27.1,29.144,31.146,33.107,35.027,36.909,38.754,40.563,42.337,44.078,45.788,47.466,49.114,50.734,52.326,53.891,55.43,56.944,58.433,59.9,61.344,62.766,64.167,65.547,66.908,68.25,69.574,70.879,72.168,73.44,74.696,75.937,77.162,78.373,79.571,80.754,81.925,83.083,84.23,85.364,86.487,87.599,88.701,89.793,90.875,91.947,93.011,94.066,95.112,96.15,97.181,98.204,99.221,100.23,101.23,102.23,103.22,104.2,105.18,106.16,107.13,108.09,109.05,110.01,110.96,111.91,112.85,113.79,114.73,115.66,116.59,117.52,118.45,119.37,120.29,121.21,122.13,123.05,123.96,124.88,125.79,126.7,127.61,128.52,129.43,130.34,131.25,132.16,133.07,133.98,134.88,135.79,136.7,137.61,138.52,139.43,140.34,141.26,142.17,143.08,144.0,144.92,145.83,146.75,147.67,148.59,149.51,150.44,151.36,152.29,153.22,154.15,155.08,156.01,156.94,157.88,158.82,159.75,160.7,161.64,162.58,163.52,164.47,165.42,166.37,167.32,168.27,169.22,170.18,171.13,172.09,173.05,174.01,174.97,175.93,176.89,177.85,178.82,179.78,180.75,181.71,182.68,183.64,184.61,185.58,186.54,187.51,188.48,189.45,190.41,191.38,192.35,193.31,194.28,195.24,196.21,197.17,198.13,199.1,200.06,201.02,201.98,202.94,203.89,204.85,205.81,206.76,207.71,208.66,209.61,210.56,211.51,212.45,213.4,214.34,215.28,216.22,217.16,218.09,219.03,219.96,220.89,221.82,222.75,223.68,224.6,225.53,226.45,227.37,228.29,229.21,230.13,231.05,231.96,232.88,233.79,234.7,235.61,236.53,237.44,238.35,239.26,240.16,241.07,241.98,242.89,243.8,244.71,245.62,246.53,247.44,248.35,249.26,250.17,251.09,252.0,252.92,253.84,254.76,255.68,256.6,257.53,258.46,259.39,260.32,261.26,262.2,263.14,264.09,265.04,266.0,266.95,267.92,268.89,269.86,270.84,271.82,272.81,273.81,274.81,275.81,276.83,277.85,278.88,279.92,280.96,282.01,283.08,284.15,285.23,286.31,287.41,288.52,289.64,290.78,291.92,293.07,294.24,295.42,296.62,297.82,299.05,300.28,301.54,302.8,304.09,305.39,306.71,308.05,309.4,310.78,312.17,313.59,315.03,316.49,317.97,319.48,321.01,322.57,324.16,325.77,327.41,329.08,330.78,332.52,334.28,336.08,337.92,339.79,341.7,343.65,345.65,347.68,349.76,351.88,354.06,356.28,358.55,360.88,363.27,365.71,368.21,370.78,373.42,376.12,378.89,381.75,384.68,387.69,390.79,393.98,397.26,400.65,404.13,407.73,411.44,415.28,419.24,423.33,427.57,431.95,436.49,441.2,446.08,451.15,456.41,461.89,467.59,473.52,479.71,486.16,492.9,499.95,},
{-137.17,-129.52,-122.23,-115.25,-108.58,-102.2,-96.074,-90.2,-84.56,-79.139,-73.924,-68.904,-64.068,-59.406,-54.907,-50.564,-46.368,-42.311,-38.387,-34.589,-30.91,-27.344,-23.887,-20.533,-17.278,-14.116,-11.043,-8.0567,-5.1516,-2.3247,0.42736,3.1078,5.7197,8.2658,10.749,13.171,15.536,17.845,20.1,22.304,24.458,26.565,28.626,30.643,32.617,34.551,36.445,38.302,40.122,41.907,43.657,45.376,47.062,48.718,50.345,51.943,53.513,55.058,56.576,58.07,59.54,60.987,62.412,63.815,65.198,66.56,67.903,69.227,70.533,71.821,73.093,74.348,75.587,76.811,78.02,79.215,80.396,81.564,82.719,83.861,84.991,86.11,87.218,88.315,89.401,90.477,91.544,92.601,93.65,94.69,95.721,96.745,97.76,98.769,99.77,100.76,101.75,102.73,103.71,104.68,105.64,106.6,107.56,108.51,109.45,110.39,111.33,112.26,113.19,114.12,115.04,115.96,116.88,117.79,118.7,119.61,120.52,121.42,122.32,123.23,124.13,125.02,125.92,126.82,127.71,128.61,129.5,130.39,131.29,132.18,133.07,133.97,134.86,135.75,136.64,137.54,138.43,139.33,140.22,141.12,142.01,142.91,143.81,144.71,145.61,146.51,147.42,148.32,149.23,150.13,151.04,151.95,152.86,153.78,154.69,155.61,156.52,157.44,158.36,159.28,160.21,161.13,162.06,162.99,163.92,164.85,165.78,166.71,167.65,168.59,169.52,170.46,171.4,172.35,173.29,174.23,175.18,176.12,177.07,178.02,178.97,179.91,180.86,181.81,182.77,183.72,184.67,185.62,186.57,187.52,188.47,189.43,190.38,191.33,192.28,193.23,194.18,195.13,196.08,197.03,197.98,198.92,199.87,200.82,201.76,202.7,203.65,204.59,205.53,206.46,207.4,208.34,209.27,210.21,211.14,212.07,213.0,213.92,214.85,215.77,216.7,217.62,218.54,219.45,220.37,221.28,222.2,223.11,224.02,224.93,225.84,226.74,227.65,228.55,229.45,230.36,231.26,232.16,233.05,233.95,234.85,235.74,236.64,237.53,238.43,239.32,240.21,241.11,242.0,242.89,243.79,244.68,245.57,246.47,247.36,248.26,249.15,250.05,250.95,251.85,252.75,253.65,254.56,255.46,256.37,257.28,258.2,259.11,260.03,260.95,261.88,262.81,263.74,264.68,265.62,266.56,267.51,268.46,269.42,270.38,271.35,272.33,273.31,274.29,275.29,276.29,277.29,278.31,279.33,280.36,281.4,282.44,283.5,284.56,285.64,286.72,287.82,288.92,290.04,291.16,292.3,293.45,294.62,295.8,296.99,298.19,299.41,300.65,301.9,303.17,304.45,305.75,307.07,308.41,309.77,311.15,312.55,313.96,315.41,316.87,318.36,319.87,321.41,322.97,324.56,326.18,327.83,329.51,331.22,332.96,334.74,336.55,338.4,340.28,342.21,344.17,346.18,348.23,350.33,352.47,354.66,356.9,359.2,361.55,363.96,366.43,368.96,371.56,374.22,376.95,379.76,382.65,385.62,388.67,391.81,395.05,398.38,401.81,405.35,409.0,412.78,416.67,420.7,424.86,429.17,433.64,438.26,443.06,448.04,453.21,458.59,464.18,470.01,476.08,482.41,489.02,},
{-125.52,-118.36,-111.52,-104.98,-98.708,-92.696,-86.927,-81.385,-76.058,-70.933,-65.998,-61.242,-56.656,-52.231,-47.958,-43.828,-39.836,-35.973,-32.233,-28.61,-25.098,-21.693,-18.389,-15.181,-12.066,-9.0378,-6.0939,-3.2303,-0.44345,2.2699,4.913,7.4886,9.9996,12.449,14.838,17.171,19.448,21.673,23.848,25.973,28.052,30.086,32.076,34.025,35.934,37.804,39.636,41.432,43.194,44.923,46.619,48.283,49.918,51.524,53.102,54.652,56.177,57.676,59.151,60.603,62.031,63.438,64.823,66.188,67.533,68.858,70.165,71.455,72.726,73.981,75.22,76.443,77.651,78.845,80.024,81.19,82.342,83.481,84.609,85.724,86.828,87.921,89.003,90.074,91.136,92.188,93.231,94.265,95.291,96.308,97.317,98.318,99.312,100.3,101.28,102.25,103.22,104.18,105.14,106.09,107.03,107.97,108.91,109.84,110.77,111.69,112.61,113.52,114.43,115.34,116.25,117.15,118.05,118.94,119.84,120.73,121.62,122.51,123.4,124.28,125.17,126.05,126.93,127.81,128.69,129.57,130.45,131.32,132.2,133.08,133.96,134.83,135.71,136.59,137.47,138.35,139.22,140.1,140.98,141.87,142.75,143.63,144.51,145.4,146.28,147.17,148.06,148.95,149.84,150.73,151.63,152.52,153.42,154.32,155.22,156.12,157.02,157.92,158.83,159.74,160.65,161.56,162.47,163.38,164.3,165.21,166.13,167.05,167.97,168.89,169.82,170.74,171.67,172.59,173.52,174.45,175.38,176.31,177.24,178.18,179.11,180.04,180.98,181.91,182.85,183.79,184.72,185.66,186.6,187.53,188.47,189.41,190.34,191.28,192.22,193.15,194.09,195.02,195.96,196.89,197.83,198.76,199.69,200.62,201.55,202.48,203.41,204.33,205.26,206.18,207.1,208.02,208.94,209.86,210.78,211.69,212.61,213.52,214.43,215.34,216.25,217.16,218.06,218.96,219.86,220.76,221.66,222.56,223.46,224.35,225.24,226.14,227.03,227.91,228.8,229.69,230.57,231.46,232.34,233.22,234.11,234.99,235.87,236.75,237.62,238.5,239.38,240.26,241.14,242.01,242.89,243.77,244.65,245.53,246.41,247.29,248.17,249.05,249.93,250.81,251.7,252.59,253.47,254.36,255.26,256.15,257.05,257.95,258.85,259.75,260.66,261.57,262.48,263.4,264.32,265.25,266.18,267.11,268.05,269.0,269.95,270.9,271.86,272.83,273.8,274.78,275.76,276.76,277.76,278.76,279.78,280.8,281.83,282.87,283.92,284.98,286.05,287.13,288.22,289.32,290.44,291.56,292.7,293.85,295.01,296.19,297.38,298.58,299.8,301.03,302.29,303.55,304.84,306.14,307.46,308.8,310.16,311.54,312.94,314.37,315.81,317.28,318.77,320.29,321.84,323.41,325.01,326.63,328.29,329.98,331.7,333.45,335.24,337.07,338.93,340.83,342.77,344.75,346.77,348.84,350.95,353.11,355.33,357.59,359.91,362.29,364.72,367.22,369.78,372.41,375.1,377.87,380.72,383.64,386.65,389.75,392.93,396.22,399.6,403.09,406.68,410.4,414.23,418.2,422.3,426.54,430.93,435.48,440.2,445.09,450.18,455.46,460.96,466.68,472.64,478.85,},
{-114.71,-107.99,-101.56,-95.403,-89.495,-83.823,-78.374,-73.135,-68.093,-63.237,-58.557,-54.044,-49.687,-45.479,-41.413,-37.48,-33.674,-29.989,-26.42,-22.959,-19.602,-16.345,-13.183,-10.11,-7.1246,-4.2212,-1.3966,1.3525,4.0293,6.637,9.1783,11.656,14.073,16.431,18.733,20.982,23.178,25.325,27.423,29.476,31.484,33.449,35.373,37.258,39.104,40.914,42.688,44.428,46.135,47.81,49.454,51.069,52.655,54.213,55.745,57.251,58.732,60.188,61.622,63.033,64.422,65.791,67.138,68.467,69.776,71.067,72.34,73.596,74.835,76.059,77.267,78.459,79.638,80.802,81.953,83.09,84.215,85.328,86.429,87.519,88.597,89.665,90.723,91.77,92.809,93.838,94.858,95.869,96.873,97.868,98.856,99.836,100.81,101.78,102.74,103.69,104.64,105.58,106.52,107.45,108.38,109.3,110.21,111.13,112.04,112.94,113.84,114.74,115.63,116.52,117.41,118.3,119.18,120.06,120.94,121.82,122.69,123.56,124.43,125.3,126.17,127.04,127.9,128.77,129.63,130.5,131.36,132.22,133.09,133.95,134.81,135.67,136.54,137.4,138.26,139.13,139.99,140.86,141.72,142.59,143.46,144.33,145.19,146.07,146.94,147.81,148.68,149.56,150.44,151.31,152.19,153.07,153.96,154.84,155.73,156.61,157.5,158.39,159.28,160.17,161.07,161.97,162.86,163.76,164.66,165.57,166.47,167.37,168.28,169.19,170.1,171.01,171.92,172.83,173.75,174.66,175.58,176.49,177.41,178.33,179.25,180.17,181.09,182.01,182.93,183.85,184.78,185.7,186.62,187.54,188.47,189.39,190.31,191.23,192.16,193.08,194.0,194.92,195.84,196.76,197.68,198.6,199.51,200.43,201.35,202.26,203.17,204.08,205.0,205.9,206.81,207.72,208.63,209.53,210.43,211.33,212.23,213.13,214.03,214.92,215.82,216.71,217.6,218.49,219.38,220.26,221.15,222.03,222.91,223.79,224.67,225.55,226.42,227.3,228.17,229.04,229.91,230.78,231.65,232.52,233.39,234.25,235.12,235.98,236.85,237.71,238.58,239.44,240.3,241.16,242.03,242.89,243.75,244.62,245.48,246.35,247.21,248.08,248.94,249.81,250.68,251.55,252.43,253.3,254.18,255.05,255.93,256.82,257.7,258.59,259.48,260.37,261.27,262.17,263.08,263.98,264.9,265.81,266.73,267.66,268.59,269.52,270.46,271.41,272.36,273.32,274.29,275.26,276.24,277.22,278.22,279.22,280.23,281.25,282.27,283.31,284.36,285.41,286.48,287.55,288.64,289.74,290.85,291.97,293.11,294.25,295.41,296.59,297.78,298.98,300.2,301.44,302.69,303.96,305.24,306.55,307.87,309.22,310.58,311.96,313.37,314.8,316.25,317.72,319.22,320.75,322.3,323.88,325.49,327.12,328.79,330.49,332.22,333.99,335.79,337.63,339.5,341.42,343.37,345.37,347.41,349.5,351.64,353.82,356.06,358.34,360.69,363.09,365.56,368.08,370.68,373.34,376.07,378.88,381.76,384.73,387.78,390.92,394.16,397.49,400.93,404.47,408.13,411.91,415.82,419.85,424.03,428.35,432.83,437.48,442.29,447.3,452.49,457.9,463.52,469.38,},
{-104.65,-98.33,-92.271,-86.46,-80.88,-75.517,-70.36,-65.397,-60.615,-56.006,-51.56,-47.268,-43.122,-39.114,-35.238,-31.486,-27.853,-24.333,-20.92,-17.609,-14.396,-11.276,-8.2452,-5.2989,-2.4337,0.35389,3.0673,5.7097,8.2839,10.793,13.239,15.626,17.955,20.228,22.448,24.618,26.738,28.811,30.838,32.822,34.763,36.664,38.526,40.351,42.139,43.891,45.611,47.297,48.952,50.577,52.173,53.74,55.28,56.793,58.281,59.745,61.184,62.601,63.995,65.368,66.72,68.052,69.364,70.658,71.933,73.191,74.432,75.656,76.865,78.058,79.236,80.4,81.55,82.687,83.81,84.922,86.02,87.108,88.184,89.248,90.303,91.347,92.381,93.406,94.422,95.429,96.427,97.417,98.399,99.374,100.34,101.3,102.26,103.2,104.14,105.08,106.01,106.93,107.85,108.76,109.67,110.58,111.47,112.37,113.26,114.15,115.03,115.92,116.79,117.67,118.54,119.41,120.28,121.14,122.0,122.86,123.72,124.58,125.44,126.29,127.14,128.0,128.85,129.7,130.55,131.4,132.25,133.09,133.94,134.79,135.64,136.49,137.34,138.19,139.03,139.88,140.73,141.59,142.44,143.29,144.14,145.0,145.85,146.71,147.57,148.43,149.29,150.15,151.01,151.88,152.74,153.61,154.48,155.35,156.22,157.09,157.97,158.84,159.72,160.6,161.48,162.36,163.25,164.13,165.02,165.91,166.8,167.69,168.58,169.47,170.37,171.27,172.16,173.06,173.96,174.86,175.77,176.67,177.57,178.48,179.38,180.29,181.2,182.1,183.01,183.92,184.83,185.74,186.64,187.55,188.46,189.37,190.28,191.19,192.1,193.01,193.91,194.82,195.73,196.63,197.54,198.44,199.34,200.25,201.15,202.05,202.95,203.85,204.74,205.64,206.53,207.43,208.32,209.21,210.1,210.98,211.87,212.75,213.64,214.52,215.4,216.28,217.15,218.03,218.9,219.77,220.64,221.51,222.38,223.25,224.11,224.98,225.84,226.7,227.56,228.42,229.27,230.13,230.99,231.84,232.69,233.54,234.4,235.25,236.1,236.95,237.8,238.65,239.49,240.34,241.19,242.04,242.89,243.74,244.59,245.44,246.29,247.14,247.99,248.84,249.7,250.55,251.41,252.27,253.13,253.99,254.86,255.72,256.59,257.47,258.34,259.22,260.1,260.98,261.87,262.76,263.65,264.55,265.46,266.36,267.28,268.19,269.12,270.04,270.98,271.92,272.86,273.82,274.77,275.74,276.71,277.69,278.68,279.68,280.68,281.7,282.72,283.75,284.79,285.85,286.91,287.98,289.07,290.16,291.27,292.39,293.52,294.67,295.83,297.01,298.2,299.4,300.62,301.86,303.11,304.38,305.67,306.98,308.31,309.65,311.02,312.41,313.82,315.26,316.71,318.2,319.7,321.24,322.8,324.39,326.0,327.65,329.33,331.04,332.79,334.57,336.38,338.23,340.13,342.06,344.03,346.05,348.11,350.22,352.38,354.59,356.85,359.16,361.54,363.97,366.46,369.02,371.65,374.35,377.12,379.96,382.89,385.9,389.0,392.2,395.48,398.87,402.37,405.98,409.7,413.55,417.53,421.65,425.91,430.32,434.89,439.64,444.56,449.68,455.0,460.53,},
{-95.266,-89.303,-83.582,-78.087,-72.806,-67.727,-62.836,-58.124,-53.582,-49.199,-44.967,-40.879,-36.927,-33.103,-29.402,-25.818,-22.345,-18.977,-15.709,-12.538,-9.4581,-6.4656,-3.5566,-0.72744,2.0254,4.7051,7.3149,9.8576,12.336,14.753,17.11,19.411,21.658,23.852,25.995,28.09,30.139,32.143,34.103,36.022,37.901,39.742,41.545,43.312,45.045,46.744,48.412,50.048,51.654,53.232,54.781,56.303,57.799,59.27,60.717,62.14,63.54,64.919,66.276,67.612,68.929,70.226,71.505,72.766,74.009,75.235,76.446,77.64,78.819,79.984,81.134,82.27,83.393,84.503,85.601,86.687,87.761,88.824,89.876,90.917,91.948,92.97,93.982,94.985,95.979,96.965,97.942,98.912,99.874,100.83,101.78,102.72,103.65,104.58,105.5,106.42,107.33,108.24,109.14,110.03,110.92,111.81,112.69,113.57,114.45,115.32,116.19,117.05,117.92,118.77,119.63,120.49,121.34,122.19,123.03,123.88,124.72,125.57,126.41,127.25,128.09,128.92,129.76,130.6,131.43,132.27,133.1,133.94,134.77,135.61,136.44,137.28,138.11,138.95,139.78,140.62,141.45,142.29,143.13,143.97,144.81,145.65,146.49,147.34,148.18,149.03,149.87,150.72,151.57,152.42,153.27,154.13,154.98,155.84,156.7,157.56,158.42,159.28,160.15,161.01,161.88,162.75,163.62,164.49,165.36,166.24,167.12,167.99,168.87,169.75,170.63,171.52,172.4,173.29,174.17,175.06,175.95,176.84,177.73,178.62,179.51,180.41,181.3,182.19,183.09,183.98,184.88,185.77,186.67,187.56,188.46,189.35,190.25,191.14,192.04,192.93,193.83,194.72,195.61,196.51,197.4,198.29,199.18,200.07,200.96,201.84,202.73,203.61,204.5,205.38,206.26,207.14,208.02,208.89,209.77,210.64,211.52,212.39,213.26,214.13,214.99,215.86,216.72,217.58,218.44,219.3,220.16,221.01,221.87,222.72,223.57,224.42,225.27,226.12,226.97,227.81,228.65,229.5,230.34,231.18,232.02,232.86,233.7,234.53,235.37,236.21,237.04,237.88,238.71,239.55,240.38,241.22,242.05,242.89,243.72,244.56,245.39,246.23,247.07,247.91,248.75,249.59,250.43,251.27,252.12,252.97,253.82,254.67,255.52,256.38,257.24,258.1,258.96,259.83,260.7,261.58,262.45,263.34,264.22,265.11,266.01,266.91,267.81,268.72,269.64,270.56,271.49,272.42,273.36,274.31,275.26,276.22,277.19,278.16,279.15,280.14,281.14,282.15,283.17,284.2,285.24,286.29,287.35,288.42,289.5,290.6,291.7,292.82,293.96,295.1,296.27,297.44,298.63,299.84,301.06,302.3,303.56,304.83,306.12,307.44,308.77,310.12,311.49,312.89,314.3,315.75,317.21,318.7,320.22,321.76,323.33,324.93,326.56,328.22,329.91,331.64,333.39,335.19,337.02,338.89,340.8,342.75,344.74,346.78,348.87,351.0,353.18,355.41,357.7,360.05,362.45,364.91,367.44,370.04,372.7,375.44,378.25,381.14,384.11,387.17,390.32,393.57,396.92,400.37,403.93,407.6,411.4,415.32,419.38,423.58,427.93,432.44,437.11,441.97,447.01,452.24,},
{-86.49,-80.853,-75.438,-70.233,-65.225,-60.404,-55.757,-51.277,-46.954,-42.779,-38.745,-34.844,-31.071,-27.418,-23.879,-20.45,-17.124,-13.898,-10.765,-7.7233,-4.7673,-1.8935,0.9017,3.6217,6.2696,8.8486,11.362,13.811,16.2,18.53,20.805,23.025,25.194,27.314,29.385,31.411,33.392,35.331,37.228,39.086,40.906,42.689,44.437,46.151,47.832,49.481,51.099,52.687,54.247,55.78,57.285,58.765,60.22,61.651,63.058,64.443,65.806,67.148,68.47,69.772,71.055,72.319,73.566,74.795,76.008,77.205,78.386,79.551,80.703,81.84,82.963,84.073,85.17,86.255,87.328,88.39,89.44,90.48,91.509,92.527,93.537,94.536,95.527,96.509,97.483,98.448,99.406,100.36,101.3,102.23,103.16,104.09,105.0,105.91,106.82,107.72,108.61,109.5,110.38,111.26,112.14,113.01,113.87,114.74,115.6,116.45,117.3,118.15,119.0,119.85,120.69,121.53,122.36,123.2,124.03,124.86,125.69,126.52,127.35,128.17,129.0,129.82,130.65,131.47,132.29,133.11,133.93,134.75,135.58,136.4,137.22,138.04,138.86,139.68,140.5,141.33,142.15,142.98,143.8,144.63,145.45,146.28,147.11,147.94,148.77,149.61,150.44,151.27,152.11,152.95,153.79,154.63,155.47,156.32,157.16,158.01,158.86,159.71,160.56,161.41,162.27,163.12,163.98,164.84,165.7,166.56,167.42,168.29,169.15,170.02,170.89,171.76,172.63,173.51,174.38,175.25,176.13,177.01,177.88,178.76,179.64,180.52,181.4,182.28,183.16,184.04,184.93,185.81,186.69,187.57,188.46,189.34,190.22,191.1,191.98,192.87,193.75,194.63,195.51,196.39,197.26,198.14,199.02,199.89,200.77,201.64,202.52,203.39,204.26,205.13,206.0,206.86,207.73,208.59,209.45,210.32,211.18,212.03,212.89,213.74,214.6,215.45,216.3,217.15,218.0,218.84,219.69,220.53,221.37,222.21,223.05,223.89,224.72,225.56,226.39,227.22,228.05,228.88,229.71,230.54,231.37,232.19,233.02,233.84,234.66,235.49,236.31,237.13,237.95,238.77,239.6,240.42,241.24,242.06,242.88,243.7,244.53,245.35,246.17,247.0,247.82,248.65,249.48,250.31,251.14,251.97,252.81,253.65,254.48,255.33,256.17,257.02,257.87,258.72,259.57,260.43,261.29,262.16,263.03,263.9,264.78,265.67,266.55,267.45,268.34,269.25,270.16,271.07,271.99,272.92,273.86,274.8,275.74,276.7,277.66,278.64,279.62,280.6,281.6,282.61,283.63,284.65,285.69,286.74,287.8,288.87,289.95,291.04,292.15,293.27,294.4,295.55,296.71,297.89,299.08,300.29,301.52,302.76,304.02,305.3,306.6,307.91,309.25,310.61,311.99,313.39,314.82,316.27,317.74,319.24,320.76,322.32,323.9,325.51,327.15,328.83,330.53,332.27,334.05,335.86,337.71,339.59,341.52,343.5,345.51,347.57,349.68,351.84,354.05,356.31,358.62,361.0,363.44,365.93,368.5,371.13,373.83,376.61,379.47,382.41,385.43,388.54,391.75,395.05,398.46,401.97,405.6,409.35,413.22,417.22,421.37,425.66,430.11,434.72,439.5,444.47,},
{-78.264,-72.925,-67.791,-62.851,-58.093,-53.508,-49.086,-44.818,-40.697,-36.714,-32.862,-29.135,-25.527,-22.032,-18.644,-15.358,-12.17,-9.0745,-6.0681,-3.1464,-0.30578,2.4573,5.1463,7.7642,10.314,12.799,15.221,17.583,19.888,22.138,24.334,26.479,28.576,30.625,32.628,34.588,36.506,38.383,40.222,42.022,43.787,45.516,47.212,48.874,50.506,52.107,53.679,55.222,56.739,58.228,59.692,61.132,62.548,63.94,65.31,66.659,67.987,69.294,70.582,71.852,73.102,74.336,75.552,76.751,77.935,79.103,80.256,81.394,82.519,83.63,84.728,85.813,86.885,87.946,88.996,90.034,91.061,92.078,93.086,94.083,95.071,96.05,97.02,97.982,98.936,99.882,100.82,101.75,102.68,103.59,104.5,105.41,106.31,107.2,108.09,108.97,109.85,110.72,111.59,112.45,113.31,114.16,115.02,115.86,116.71,117.55,118.39,119.22,120.05,120.88,121.71,122.54,123.36,124.18,125.0,125.82,126.63,127.45,128.26,129.07,129.88,130.69,131.5,132.31,133.12,133.93,134.74,135.55,136.35,137.16,137.97,138.78,139.59,140.4,141.21,142.02,142.83,143.64,144.45,145.27,146.08,146.9,147.71,148.53,149.35,150.17,150.99,151.81,152.64,153.46,154.29,155.12,155.95,156.78,157.61,158.45,159.28,160.12,160.96,161.8,162.64,163.48,164.33,165.18,166.02,166.87,167.72,168.58,169.43,170.28,171.14,172.0,172.86,173.72,174.58,175.44,176.3,177.17,178.03,178.9,179.76,180.63,181.5,182.37,183.23,184.1,184.97,185.84,186.71,187.58,188.45,189.32,190.19,191.06,191.93,192.8,193.67,194.53,195.4,196.27,197.13,198.0,198.86,199.73,200.59,201.45,202.31,203.17,204.03,204.88,205.74,206.59,207.45,208.3,209.15,210.0,210.84,211.69,212.53,213.38,214.22,215.06,215.89,216.73,217.57,218.4,219.23,220.06,220.89,221.72,222.54,223.37,224.19,225.01,225.83,226.65,227.47,228.29,229.1,229.92,230.73,231.55,232.36,233.17,233.98,234.79,235.6,236.41,237.22,238.03,238.84,239.64,240.45,241.26,242.07,242.88,243.69,244.5,245.31,246.12,246.93,247.74,248.56,249.38,250.19,251.01,251.83,252.66,253.48,254.31,255.14,255.97,256.8,257.64,258.48,259.32,260.17,261.02,261.88,262.73,263.6,264.46,265.33,266.21,267.09,267.98,268.87,269.77,270.67,271.58,272.5,273.42,274.35,275.29,276.23,277.18,278.14,279.11,280.09,281.07,282.07,283.07,284.09,285.11,286.15,287.2,288.25,289.32,290.41,291.5,292.61,293.73,294.87,296.02,297.18,298.36,299.56,300.77,302.0,303.24,304.51,305.79,307.09,308.42,309.76,311.13,312.51,313.92,315.36,316.82,318.3,319.81,321.35,322.91,324.51,326.13,327.79,329.47,331.19,332.95,334.74,336.57,338.44,340.35,342.3,344.29,346.33,348.42,350.55,352.74,354.97,357.26,359.61,362.02,364.49,367.03,369.63,372.3,375.05,377.87,380.78,383.76,386.84,390.01,393.27,396.64,400.11,403.69,407.39,411.22,415.17,419.27,423.5,427.89,432.44,437.16,},
{-70.54,-65.472,-60.595,-55.898,-51.37,-47.003,-42.788,-38.716,-34.781,-30.975,-27.292,-23.726,-20.271,-16.922,-13.674,-10.522,-7.4615,-4.4886,-1.5993,1.21,3.9429,6.6026,9.1922,11.715,14.173,16.569,18.907,21.187,23.413,25.586,27.709,29.784,31.812,33.794,35.734,37.632,39.491,41.31,43.092,44.839,46.55,48.229,49.875,51.49,53.074,54.63,56.158,57.659,59.133,60.583,62.008,63.409,64.787,66.143,67.478,68.792,70.087,71.361,72.617,73.855,75.076,76.279,77.466,78.637,79.793,80.934,82.06,83.173,84.272,85.358,86.431,87.492,88.541,89.579,90.606,91.622,92.628,93.623,94.609,95.586,96.554,97.513,98.464,99.406,100.34,101.27,102.19,103.1,104.01,104.91,105.8,106.69,107.57,108.45,109.32,110.18,111.05,111.9,112.75,113.6,114.45,115.29,116.12,116.95,117.78,118.61,119.43,120.25,121.07,121.89,122.7,123.51,124.32,125.13,125.94,126.74,127.54,128.34,129.14,129.94,130.74,131.54,132.34,133.13,133.93,134.72,135.52,136.31,137.11,137.91,138.7,139.5,140.29,141.09,141.89,142.69,143.48,144.28,145.08,145.89,146.69,147.49,148.3,149.1,149.91,150.72,151.52,152.33,153.15,153.96,154.77,155.59,156.41,157.23,158.05,158.87,159.69,160.52,161.35,162.17,163.0,163.84,164.67,165.5,166.34,167.18,168.01,168.85,169.7,170.54,171.38,172.23,173.07,173.92,174.77,175.62,176.47,177.32,178.18,179.03,179.88,180.74,181.59,182.45,183.3,184.16,185.02,185.88,186.73,187.59,188.45,189.31,190.16,191.02,191.88,192.73,193.59,194.44,195.3,196.15,197.01,197.86,198.71,199.56,200.41,201.26,202.11,202.96,203.8,204.65,205.49,206.33,207.17,208.01,208.85,209.69,210.52,211.35,212.19,213.02,213.85,214.67,215.5,216.32,217.15,217.97,218.79,219.6,220.42,221.24,222.05,222.86,223.67,224.48,225.29,226.1,226.91,227.71,228.51,229.32,230.12,230.92,231.72,232.52,233.32,234.11,234.91,235.71,236.5,237.3,238.1,238.89,239.69,240.48,241.28,242.08,242.87,243.67,244.47,245.27,246.07,246.87,247.67,248.47,249.27,250.08,250.89,251.7,252.51,253.32,254.13,254.95,255.77,256.6,257.42,258.25,259.08,259.92,260.76,261.6,262.45,263.3,264.15,265.01,265.88,266.75,267.63,268.51,269.39,270.28,271.18,272.09,273.0,273.92,274.84,275.78,276.72,277.67,278.62,279.59,280.56,281.55,282.54,283.55,284.56,285.58,286.62,287.67,288.72,289.79,290.88,291.97,293.08,294.21,295.34,296.5,297.66,298.85,300.05,301.26,302.5,303.75,305.02,306.31,307.62,308.95,310.3,311.67,313.07,314.49,315.93,317.4,318.89,320.41,321.96,323.54,325.15,326.79,328.46,330.16,331.9,333.68,335.49,337.34,339.22,341.15,343.13,345.14,347.21,349.32,351.48,353.7,355.96,358.29,360.67,363.12,365.62,368.2,370.84,373.56,376.35,379.22,382.18,385.22,388.35,391.58,394.9,398.34,401.88,405.54,409.32,413.22,417.27,421.45,425.79,430.28,},
{-63.272,-58.454,-53.813,-49.339,-45.023,-40.857,-36.832,-32.942,-29.179,-25.537,-22.011,-18.594,-15.282,-12.069,-8.9506,-5.9229,-2.9815,-0.12277,2.6571,5.3615,7.9936,10.557,13.053,15.486,17.858,20.172,22.429,24.633,26.784,28.886,30.94,32.948,34.911,36.832,38.711,40.551,42.353,44.118,45.847,47.542,49.204,50.834,52.433,54.003,55.543,57.056,58.542,60.003,61.438,62.849,64.236,65.601,66.944,68.266,69.567,70.848,72.11,73.354,74.579,75.788,76.979,78.154,79.313,80.457,81.586,82.701,83.802,84.89,85.964,87.026,88.076,89.114,90.141,91.157,92.162,93.157,94.142,95.117,96.083,97.04,97.988,98.928,99.86,100.78,101.7,102.61,103.51,104.41,105.3,106.18,107.06,107.93,108.79,109.65,110.51,111.36,112.21,113.05,113.88,114.72,115.55,116.37,117.19,118.01,118.83,119.64,120.45,121.26,122.06,122.86,123.66,124.46,125.26,126.05,126.84,127.63,128.42,129.21,130.0,130.79,131.57,132.36,133.14,133.93,134.71,135.49,136.28,137.06,137.84,138.63,139.41,140.19,140.98,141.76,142.55,143.34,144.12,144.91,145.7,146.49,147.28,148.07,148.86,149.66,150.45,151.25,152.04,152.84,153.64,154.44,155.25,156.05,156.86,157.66,158.47,159.28,160.1,160.91,161.72,162.54,163.36,164.18,165.0,165.82,166.64,167.47,168.3,169.13,169.95,170.79,171.62,172.45,173.29,174.12,174.96,175.8,176.63,177.47,178.32,179.16,180.0,180.84,181.68,182.53,183.37,184.22,185.06,185.91,186.75,187.6,188.44,189.29,190.14,190.98,191.83,192.67,193.51,194.36,195.2,196.04,196.88,197.73,198.57,199.4,200.24,201.08,201.92,202.75,203.58,204.42,205.25,206.08,206.91,207.73,208.56,209.39,210.21,211.03,211.85,212.67,213.49,214.3,215.11,215.93,216.74,217.55,218.36,219.16,219.97,220.77,221.57,222.37,223.17,223.97,224.77,225.56,226.36,227.15,227.94,228.73,229.52,230.31,231.1,231.89,232.67,233.46,234.24,235.03,235.81,236.6,237.38,238.16,238.95,239.73,240.51,241.3,242.08,242.87,243.65,244.44,245.22,246.01,246.8,247.59,248.38,249.17,249.97,250.76,251.56,252.36,253.16,253.97,254.77,255.58,256.4,257.21,258.03,258.85,259.67,260.5,261.33,262.17,263.01,263.86,264.71,265.56,266.42,267.28,268.15,269.03,269.91,270.8,271.69,272.59,273.5,274.42,275.34,276.27,277.21,278.15,279.11,280.07,281.05,282.03,283.02,284.02,285.04,286.06,287.1,288.15,289.2,290.28,291.36,292.46,293.57,294.7,295.84,296.99,298.16,299.35,300.56,301.78,303.02,304.27,305.55,306.85,308.16,309.5,310.86,312.24,313.65,315.08,316.53,318.01,319.52,321.05,322.62,324.21,325.83,327.49,329.17,330.9,332.65,334.45,336.28,338.15,340.06,342.01,344.01,346.05,348.14,350.28,352.48,354.72,357.02,359.38,361.8,364.28,366.83,369.45,372.14,374.9,377.74,380.66,383.67,386.77,389.96,393.25,396.65,400.15,403.77,407.5,411.37,415.36,419.5,423.78,},
{-56.421,-51.832,-47.409,-43.141,-39.021,-35.04,-31.192,-27.469,-23.866,-20.377,-16.996,-13.718,-10.538,-7.4521,-4.4552,-1.5436,1.2865,4.0385,6.7161,9.3222,11.86,14.332,16.741,19.091,21.382,23.618,25.8,27.931,30.013,32.047,34.036,35.981,37.883,39.745,41.568,43.353,45.101,46.814,48.493,50.14,51.754,53.339,54.893,56.42,57.918,59.391,60.837,62.259,63.657,65.031,66.383,67.713,69.022,70.311,71.58,72.83,74.062,75.276,76.472,77.652,78.816,79.963,81.096,82.214,83.318,84.408,85.485,86.549,87.6,88.639,89.667,90.683,91.688,92.683,93.667,94.641,95.606,96.562,97.509,98.447,99.377,100.3,101.21,102.12,103.02,103.91,104.8,105.67,106.55,107.41,108.27,109.13,109.98,110.82,111.66,112.5,113.33,114.16,114.98,115.8,116.61,117.43,118.23,119.04,119.84,120.64,121.43,122.23,123.02,123.81,124.6,125.38,126.16,126.95,127.73,128.5,129.28,130.06,130.83,131.61,132.38,133.15,133.93,134.7,135.47,136.24,137.01,137.78,138.56,139.33,140.1,140.87,141.64,142.42,143.19,143.97,144.74,145.52,146.29,147.07,147.85,148.63,149.41,150.19,150.98,151.76,152.55,153.33,154.12,154.91,155.71,156.5,157.29,158.09,158.89,159.68,160.48,161.29,162.09,162.9,163.7,164.51,165.32,166.13,166.94,167.76,168.57,169.39,170.21,171.03,171.85,172.67,173.49,174.32,175.14,175.97,176.79,177.62,178.45,179.28,180.11,180.94,181.77,182.61,183.44,184.27,185.11,185.94,186.77,187.61,188.44,189.28,190.11,190.94,191.78,192.61,193.44,194.27,195.1,195.94,196.77,197.59,198.42,199.25,200.08,200.9,201.73,202.55,203.37,204.19,205.01,205.83,206.65,207.47,208.28,209.09,209.9,210.71,211.52,212.33,213.13,213.94,214.74,215.54,216.34,217.14,217.94,218.73,219.52,220.32,221.11,221.9,222.68,223.47,224.26,225.04,225.82,226.6,227.38,228.16,228.94,229.72,230.5,231.27,232.05,232.82,233.59,234.37,235.14,235.91,236.68,237.46,238.23,239.0,239.77,240.54,241.31,242.09,242.86,243.63,244.41,245.18,245.96,246.74,247.52,248.3,249.08,249.86,250.65,251.43,252.22,253.01,253.81,254.6,255.4,256.2,257.01,257.81,258.62,259.44,260.26,261.08,261.9,262.73,263.57,264.41,265.25,266.1,266.95,267.81,268.68,269.55,270.43,271.31,272.2,273.1,274.01,274.92,275.84,276.77,277.7,278.65,279.6,280.56,281.54,282.52,283.51,284.51,285.53,286.55,287.59,288.64,289.7,290.77,291.86,292.96,294.07,295.2,296.35,297.51,298.68,299.88,301.09,302.31,303.56,304.82,306.11,307.41,308.74,310.08,311.45,312.85,314.26,315.7,317.17,318.66,320.18,321.73,323.31,324.92,326.55,328.23,329.93,331.67,333.45,335.26,337.11,339.01,340.94,342.92,344.95,347.02,349.14,351.31,353.53,355.81,358.15,360.54,363.0,365.52,368.12,370.78,373.51,376.33,379.22,382.2,385.26,388.42,391.68,395.04,398.51,402.08,405.78,409.6,413.56,417.65,},
{-49.952,-45.575,-41.352,-37.275,-33.335,-29.527,-25.842,-22.276,-18.821,-15.474,-12.228,-9.0795,-6.0233,-3.0554,-0.17179,2.6312,5.3572,8.0094,10.591,13.105,15.554,17.941,20.269,22.539,24.754,26.916,29.028,31.091,33.107,35.078,37.005,38.891,40.736,42.542,44.311,46.043,47.741,49.405,51.037,52.637,54.207,55.748,57.261,58.746,60.205,61.639,63.047,64.432,65.794,67.134,68.452,69.749,71.027,72.284,73.523,74.743,75.945,77.131,78.3,79.452,80.589,81.711,82.819,83.912,84.991,86.058,87.111,88.152,89.181,90.198,91.204,92.2,93.184,94.159,95.123,96.078,97.024,97.961,98.889,99.809,100.72,101.62,102.52,103.41,104.29,105.17,106.04,106.9,107.76,108.61,109.45,110.29,111.13,111.96,112.78,113.61,114.42,115.23,116.04,116.85,117.65,118.45,119.24,120.03,120.82,121.61,122.39,123.17,123.95,124.73,125.5,126.27,127.04,127.81,128.58,129.35,130.11,130.88,131.64,132.4,133.17,133.93,134.69,135.45,136.21,136.97,137.73,138.49,139.25,140.01,140.77,141.53,142.29,143.05,143.82,144.58,145.34,146.11,146.87,147.64,148.41,149.18,149.95,150.72,151.49,152.26,153.04,153.81,154.59,155.37,156.15,156.93,157.72,158.5,159.29,160.07,160.86,161.65,162.45,163.24,164.04,164.83,165.63,166.43,167.23,168.04,168.84,169.64,170.45,171.26,172.07,172.88,173.69,174.5,175.32,176.13,176.95,177.77,178.58,179.4,180.22,181.04,181.86,182.68,183.5,184.33,185.15,185.97,186.79,187.62,188.44,189.26,190.08,190.91,191.73,192.55,193.37,194.19,195.01,195.83,196.65,197.47,198.28,199.1,199.92,200.73,201.54,202.36,203.17,203.98,204.79,205.59,206.4,207.2,208.01,208.81,209.61,210.41,211.2,212.0,212.79,213.59,214.38,215.17,215.96,216.74,217.53,218.31,219.09,219.88,220.66,221.43,222.21,222.99,223.76,224.53,225.3,226.07,226.84,227.61,228.38,229.14,229.91,230.67,231.44,232.2,232.96,233.73,234.49,235.25,236.01,236.77,237.53,238.29,239.05,239.81,240.57,241.33,242.09,242.85,243.62,244.38,245.14,245.91,246.68,247.44,248.21,248.98,249.76,250.53,251.31,252.09,252.87,253.65,254.43,255.22,256.01,256.81,257.6,258.41,259.21,260.02,260.83,261.64,262.46,263.29,264.12,264.95,265.79,266.64,267.49,268.34,269.2,270.07,270.95,271.83,272.71,273.61,274.51,275.42,276.34,277.27,278.2,279.14,280.1,281.06,282.03,283.01,284.01,285.01,286.03,287.05,288.09,289.14,290.2,291.28,292.37,293.47,294.59,295.73,296.88,298.04,299.22,300.42,301.64,302.87,304.12,305.4,306.69,308.0,309.34,310.69,312.07,313.48,314.91,316.36,317.84,319.34,320.88,322.44,324.04,325.66,327.32,329.01,330.73,332.49,334.29,336.13,338.0,339.92,341.88,343.89,345.94,348.04,350.19,352.39,354.65,356.97,359.34,361.78,364.28,366.84,369.48,372.19,374.98,377.84,380.79,383.83,386.96,390.18,393.51,396.94,400.48,404.14,407.93,411.84,},
{-43.834,-39.653,-35.616,-31.715,-27.943,-24.294,-20.762,-17.34,-14.024,-10.809,-7.6894,-4.6614,-1.7206,1.1367,3.9143,6.6157,9.2441,11.803,14.294,16.722,19.088,21.395,23.645,25.841,27.984,30.078,32.123,34.121,36.075,37.986,39.855,41.684,43.475,45.229,46.946,48.63,50.28,51.897,53.484,55.041,56.568,58.068,59.54,60.987,62.408,63.805,65.178,66.528,67.856,69.162,70.448,71.714,72.961,74.188,75.398,76.589,77.764,78.922,80.065,81.191,82.303,83.4,84.484,85.553,86.609,87.653,88.684,89.703,90.711,91.707,92.693,93.668,94.633,95.588,96.533,97.469,98.397,99.315,100.23,101.13,102.02,102.91,103.79,104.66,105.53,106.39,107.24,108.09,108.93,109.77,110.6,111.42,112.24,113.06,113.87,114.68,115.48,116.28,117.07,117.87,118.65,119.44,120.22,121.0,121.77,122.55,123.32,124.09,124.85,125.62,126.38,127.14,127.9,128.66,129.41,130.17,130.92,131.67,132.43,133.18,133.93,134.68,135.43,136.18,136.93,137.67,138.42,139.17,139.92,140.67,141.42,142.17,142.92,143.67,144.42,145.17,145.93,146.68,147.44,148.19,148.95,149.71,150.47,151.23,151.99,152.75,153.51,154.28,155.05,155.81,156.58,157.36,158.13,158.9,159.68,160.45,161.23,162.01,162.79,163.58,164.36,165.15,165.93,166.72,167.51,168.31,169.1,169.89,170.69,171.49,172.29,173.08,173.89,174.69,175.49,176.29,177.1,177.91,178.71,179.52,180.33,181.14,181.95,182.76,183.57,184.38,185.19,186.0,186.81,187.62,188.44,189.25,190.06,190.87,191.68,192.49,193.3,194.11,194.92,195.73,196.54,197.34,198.15,198.95,199.76,200.56,201.36,202.17,202.97,203.76,204.56,205.36,206.15,206.95,207.74,208.53,209.32,210.11,210.89,211.68,212.46,213.25,214.03,214.8,215.58,216.36,217.13,217.91,218.68,219.45,220.22,220.98,221.75,222.51,223.28,224.04,224.8,225.56,226.32,227.07,227.83,228.59,229.34,230.09,230.85,231.6,232.35,233.1,233.85,234.6,235.35,236.1,236.85,237.6,238.35,239.1,239.85,240.6,241.35,242.1,242.85,243.6,244.35,245.11,245.86,246.62,247.37,248.13,248.89,249.66,250.42,251.19,251.95,252.72,253.5,254.27,255.05,255.83,256.62,257.4,258.19,258.99,259.79,260.59,261.39,262.21,263.02,263.84,264.66,265.49,266.33,267.17,268.02,268.87,269.73,270.59,271.46,272.34,273.23,274.12,275.02,275.93,276.85,277.77,278.71,279.65,280.6,281.56,282.54,283.52,284.51,285.52,286.54,287.56,288.6,289.66,290.72,291.8,292.9,294.01,295.13,296.27,297.42,298.59,299.78,300.99,302.21,303.45,304.71,306.0,307.3,308.62,309.97,311.33,312.73,314.14,315.58,317.05,318.54,320.06,321.61,323.19,324.8,326.45,328.12,329.83,331.58,333.36,335.18,337.04,338.94,340.89,342.87,344.91,346.99,349.12,351.31,353.55,355.84,358.19,360.61,363.09,365.63,368.24,370.93,373.69,376.53,379.45,382.46,385.56,388.76,392.05,395.45,398.96,402.59,406.33,},
{-38.04,-34.04,-30.175,-26.438,-22.822,-19.321,-15.93,-12.644,-9.4571,-6.365,-3.3634,-0.44821,2.3844,5.1381,7.8164,10.422,12.959,15.43,17.837,20.183,22.471,24.702,26.88,29.006,31.082,33.11,35.092,37.03,38.925,40.779,42.593,44.369,46.108,47.812,49.482,51.118,52.722,54.296,55.84,57.355,58.842,60.303,61.737,63.147,64.532,65.893,67.232,68.549,69.845,71.12,72.375,73.611,74.828,76.027,77.209,78.373,79.522,80.654,81.771,82.873,83.96,85.034,86.094,87.141,88.175,89.196,90.206,91.205,92.192,93.168,94.134,95.089,96.035,96.971,97.899,98.817,99.727,100.63,101.52,102.41,103.28,104.16,105.02,105.88,106.73,107.57,108.41,109.24,110.07,110.89,111.71,112.52,113.33,114.13,114.93,115.72,116.51,117.29,118.08,118.85,119.63,120.4,121.17,121.94,122.7,123.46,124.22,124.98,125.73,126.48,127.23,127.98,128.73,129.48,130.22,130.96,131.71,132.45,133.19,133.93,134.67,135.41,136.15,136.88,137.62,138.36,139.1,139.84,140.58,141.31,142.05,142.79,143.53,144.27,145.01,145.75,146.5,147.24,147.98,148.73,149.48,150.22,150.97,151.72,152.47,153.23,153.98,154.73,155.49,156.25,157.01,157.77,158.53,159.29,160.06,160.82,161.59,162.36,163.13,163.9,164.68,165.45,166.23,167.01,167.79,168.57,169.35,170.14,170.92,171.71,172.5,173.28,174.08,174.87,175.66,176.45,177.25,178.04,178.84,179.63,180.43,181.23,182.03,182.83,183.63,184.43,185.23,186.03,186.83,187.63,188.43,189.23,190.03,190.83,191.63,192.43,193.23,194.03,194.83,195.63,196.43,197.22,198.02,198.81,199.61,200.4,201.19,201.98,202.77,203.56,204.35,205.13,205.92,206.7,207.48,208.26,209.04,209.82,210.59,211.37,212.14,212.91,213.68,214.45,215.22,215.98,216.75,217.51,218.27,219.03,219.79,220.54,221.3,222.05,222.81,223.56,224.31,225.06,225.81,226.55,227.3,228.04,228.79,229.53,230.27,231.01,231.75,232.49,233.23,233.97,234.71,235.45,236.19,236.93,237.66,238.4,239.14,239.88,240.62,241.36,242.1,242.84,243.58,244.32,245.07,245.81,246.56,247.31,248.05,248.8,249.56,250.31,251.07,251.83,252.59,253.35,254.12,254.88,255.66,256.43,257.21,257.99,258.77,259.56,260.36,261.15,261.95,262.76,263.57,264.39,265.21,266.03,266.86,267.7,268.54,269.39,270.25,271.11,271.98,272.86,273.74,274.63,275.53,276.44,277.36,278.28,279.22,280.16,281.11,282.08,283.05,284.04,285.03,286.04,287.06,288.09,289.13,290.19,291.26,292.34,293.44,294.56,295.69,296.83,297.99,299.17,300.36,301.58,302.81,304.06,305.33,306.62,307.93,309.27,310.62,312.0,313.41,314.84,316.29,317.77,319.28,320.82,322.38,323.98,325.61,327.27,328.97,330.7,332.47,334.27,336.12,338.0,339.93,341.91,343.92,345.99,348.1,350.27,352.49,354.77,357.1,359.49,361.95,364.47,367.06,369.73,372.46,375.28,378.18,381.16,384.23,387.4,390.67,394.03,397.51,401.1,},
{-32.544,-28.712,-25.007,-21.422,-17.951,-14.589,-11.33,-8.17,-5.1036,-2.1269,0.76437,3.5738,6.3052,8.9617,11.547,14.063,16.514,18.902,21.229,23.499,25.713,27.873,29.982,32.042,34.054,36.021,37.944,39.824,41.663,43.463,45.225,46.951,48.642,50.298,51.922,53.514,55.075,56.607,58.11,59.585,61.034,62.458,63.856,65.23,66.581,67.909,69.215,70.501,71.765,73.01,74.236,75.443,76.633,77.804,78.959,80.098,81.221,82.328,83.421,84.499,85.563,86.614,87.652,88.677,89.69,90.691,91.68,92.658,93.626,94.583,95.53,96.467,97.394,98.313,99.222,100.12,101.02,101.9,102.78,103.65,104.51,105.36,106.21,107.05,107.89,108.72,109.54,110.36,111.17,111.98,112.78,113.58,114.38,115.16,115.95,116.73,117.51,118.28,119.05,119.81,120.58,121.34,122.09,122.85,123.6,124.35,125.1,125.84,126.58,127.33,128.06,128.8,129.54,130.27,131.01,131.74,132.47,133.2,133.93,134.66,135.39,136.12,136.85,137.57,138.3,139.03,139.76,140.48,141.21,141.94,142.67,143.4,144.13,144.86,145.59,146.32,147.05,147.78,148.52,149.25,149.99,150.73,151.46,152.2,152.95,153.69,154.43,155.18,155.92,156.67,157.42,158.17,158.92,159.67,160.43,161.18,161.94,162.7,163.46,164.22,164.99,165.75,166.52,167.29,168.06,168.83,169.6,170.37,171.15,171.92,172.7,173.48,174.26,175.04,175.82,176.61,177.39,178.17,178.96,179.75,180.53,181.32,182.11,182.9,183.69,184.48,185.27,186.06,186.85,187.64,188.43,189.22,190.01,190.8,191.59,192.38,193.17,193.96,194.75,195.53,196.32,197.11,197.89,198.67,199.46,200.24,201.02,201.8,202.58,203.36,204.14,204.91,205.68,206.46,207.23,208.0,208.77,209.53,210.3,211.06,211.83,212.59,213.35,214.11,214.86,215.62,216.37,217.12,217.87,218.62,219.37,220.12,220.86,221.61,222.35,223.09,223.83,224.57,225.31,226.04,226.78,227.51,228.25,228.98,229.71,230.44,231.17,231.9,232.63,233.36,234.09,234.82,235.55,236.27,237.0,237.73,238.46,239.18,239.91,240.64,241.37,242.1,242.83,243.56,244.3,245.03,245.76,246.5,247.24,247.98,248.72,249.46,250.21,250.95,251.7,252.45,253.21,253.96,254.72,255.48,256.25,257.02,257.79,258.57,259.35,260.13,260.92,261.71,262.51,263.31,264.12,264.93,265.75,266.57,267.4,268.23,269.07,269.92,270.77,271.63,272.5,273.38,274.26,275.15,276.05,276.96,277.87,278.8,279.73,280.68,281.63,282.6,283.57,284.56,285.56,286.57,287.59,288.63,289.67,290.74,291.81,292.9,294.0,295.12,296.26,297.41,298.58,299.76,300.97,302.19,303.43,304.69,305.97,307.27,308.59,309.94,311.31,312.7,314.12,315.56,317.03,318.53,320.05,321.61,323.19,324.81,326.46,328.14,329.86,331.61,333.41,335.24,337.11,339.02,340.98,342.98,345.03,347.13,349.28,351.48,353.74,356.05,358.43,360.86,363.37,365.94,368.58,371.29,374.09,376.96,379.92,382.97,386.11,389.35,392.69,396.14,},
{-27.323,-23.648,-20.092,-16.649,-13.314,-10.081,-6.9453,-3.9029,-0.94934,1.9195,4.7072,7.4175,10.054,12.619,15.116,17.549,19.918,22.228,24.481,26.678,28.822,30.916,32.96,34.957,36.909,38.818,40.684,42.51,44.296,46.046,47.758,49.436,51.08,52.692,54.272,55.822,57.342,58.834,60.298,61.736,63.149,64.537,65.9,67.241,68.559,69.855,71.13,72.385,73.621,74.837,76.035,77.215,78.377,79.523,80.652,81.766,82.865,83.948,85.018,86.073,87.115,88.144,89.161,90.165,91.157,92.138,93.108,94.067,95.015,95.954,96.883,97.802,98.712,99.613,100.51,101.39,102.27,103.13,104.0,104.85,105.7,106.54,107.37,108.2,109.02,109.83,110.64,111.45,112.25,113.04,113.83,114.62,115.4,116.17,116.94,117.71,118.48,119.24,119.99,120.75,121.5,122.25,122.99,123.73,124.47,125.21,125.95,126.68,127.41,128.14,128.87,129.6,130.32,131.05,131.77,132.49,133.21,133.93,134.65,135.37,136.09,136.81,137.53,138.24,138.96,139.68,140.4,141.11,141.83,142.55,143.27,143.99,144.71,145.43,146.15,146.87,147.59,148.31,149.04,149.76,150.49,151.22,151.94,152.67,153.4,154.14,154.87,155.6,156.34,157.08,157.82,158.56,159.3,160.04,160.79,161.53,162.28,163.03,163.78,164.53,165.29,166.04,166.8,167.56,168.32,169.08,169.84,170.6,171.37,172.13,172.9,173.67,174.44,175.21,175.98,176.75,177.53,178.3,179.08,179.86,180.63,181.41,182.19,182.97,183.75,184.53,185.31,186.09,186.87,187.65,188.43,189.21,189.99,190.77,191.55,192.33,193.1,193.88,194.66,195.44,196.21,196.99,197.77,198.54,199.31,200.09,200.86,201.63,202.4,203.16,203.93,204.69,205.46,206.22,206.98,207.74,208.5,209.26,210.01,210.77,211.52,212.27,213.02,213.77,214.52,215.26,216.01,216.75,217.49,218.23,218.97,219.7,220.44,221.17,221.9,222.64,223.37,224.09,224.82,225.55,226.27,227.0,227.72,228.44,229.17,229.89,230.61,231.33,232.05,232.77,233.48,234.2,234.92,235.64,236.36,237.07,237.79,238.51,239.23,239.94,240.66,241.38,242.1,242.82,243.55,244.27,244.99,245.72,246.45,247.17,247.9,248.63,249.37,250.1,250.84,251.58,252.32,253.07,253.82,254.57,255.32,256.08,256.84,257.6,258.37,259.14,259.91,260.69,261.48,262.27,263.06,263.86,264.66,265.47,266.28,267.1,267.93,268.76,269.6,270.45,271.3,272.16,273.02,273.9,274.78,275.67,276.57,277.48,278.4,279.32,280.26,281.21,282.16,283.13,284.11,285.1,286.1,287.11,288.14,289.18,290.23,291.3,292.38,293.47,294.58,295.71,296.85,298.01,299.19,300.38,301.59,302.82,304.07,305.34,306.64,307.95,309.29,310.64,312.03,313.43,314.87,316.32,317.81,319.32,320.87,322.44,324.04,325.68,327.35,329.06,330.8,332.58,334.39,336.25,338.15,340.09,342.08,344.11,346.2,348.33,350.52,352.76,355.05,357.41,359.83,362.31,364.86,367.49,370.18,372.95,375.8,378.74,381.76,384.88,388.09,391.41,},
{-22.358,-18.829,-15.412,-12.102,-8.8927,-5.7805,-2.7605,0.17139,3.0192,5.7867,8.4774,11.095,13.641,16.121,18.536,20.888,23.182,25.418,27.6,29.729,31.808,33.838,35.821,37.759,39.654,41.507,43.32,45.094,46.831,48.531,50.197,51.83,53.43,54.999,56.537,58.047,59.528,60.982,62.41,63.812,65.19,66.544,67.874,69.183,70.469,71.735,72.981,74.207,75.414,76.603,77.774,78.928,80.065,81.186,82.291,83.381,84.456,85.517,86.564,87.598,88.618,89.627,90.623,91.607,92.579,93.541,94.492,95.432,96.363,97.283,98.195,99.097,99.99,100.87,101.75,102.62,103.48,104.33,105.18,106.02,106.85,107.67,108.49,109.31,110.11,110.92,111.71,112.5,113.29,114.07,114.85,115.62,116.39,117.15,117.91,118.67,119.42,120.17,120.91,121.65,122.39,123.13,123.86,124.6,125.33,126.05,126.78,127.5,128.22,128.94,129.66,130.37,131.09,131.8,132.52,133.23,133.94,134.65,135.36,136.07,136.77,137.48,138.19,138.9,139.6,140.31,141.02,141.73,142.43,143.14,143.85,144.56,145.27,145.98,146.69,147.4,148.12,148.83,149.54,150.26,150.98,151.69,152.41,153.13,153.85,154.58,155.3,156.02,156.75,157.48,158.21,158.94,159.67,160.4,161.14,161.87,162.61,163.35,164.09,164.84,165.58,166.32,167.07,167.82,168.57,169.32,170.07,170.83,171.58,172.34,173.1,173.85,174.61,175.38,176.14,176.9,177.66,178.43,179.19,179.96,180.73,181.5,182.26,183.03,183.8,184.57,185.34,186.11,186.88,187.65,188.42,189.19,189.96,190.73,191.5,192.27,193.04,193.81,194.58,195.35,196.11,196.88,197.64,198.41,199.17,199.93,200.7,201.46,202.21,202.97,203.73,204.48,205.24,205.99,206.74,207.49,208.24,208.99,209.74,210.48,211.22,211.96,212.7,213.44,214.18,214.91,215.65,216.38,217.11,217.84,218.57,219.3,220.02,220.75,221.47,222.19,222.91,223.63,224.35,225.07,225.78,226.5,227.21,227.92,228.64,229.35,230.06,230.77,231.48,232.19,232.89,233.6,234.31,235.02,235.73,236.43,237.14,237.85,238.56,239.27,239.97,240.68,241.39,242.1,242.82,243.53,244.24,244.96,245.67,246.39,247.11,247.83,248.55,249.28,250.0,250.73,251.46,252.2,252.93,253.67,254.42,255.16,255.91,256.66,257.42,258.17,258.94,259.7,260.48,261.25,262.03,262.82,263.61,264.4,265.2,266.01,266.82,267.64,268.46,269.29,270.13,270.97,271.83,272.68,273.55,274.43,275.31,276.2,277.1,278.01,278.93,279.86,280.79,281.74,282.7,283.67,284.65,285.65,286.65,287.67,288.7,289.75,290.8,291.88,292.96,294.06,295.18,296.32,297.47,298.63,299.82,301.02,302.24,303.48,304.75,306.03,307.33,308.66,310.01,311.38,312.77,314.2,315.64,317.12,318.62,320.16,321.72,323.31,324.94,326.59,328.29,330.02,331.78,333.59,335.43,337.32,339.25,341.22,343.24,345.31,347.43,349.6,351.82,354.1,356.44,358.84,361.31,363.84,366.44,369.12,371.87,374.7,377.62,380.62,383.71,386.9,},
{-17.631,-14.238,-10.95,-7.7638,-4.6733,-1.6742,1.2375,4.0657,6.8143,9.4866,12.086,14.615,17.078,19.477,21.814,24.092,26.313,28.48,30.595,32.66,34.676,36.646,38.571,40.453,42.294,44.095,45.857,47.582,49.271,50.926,52.548,54.137,55.695,57.223,58.723,60.194,61.638,63.056,64.448,65.816,67.161,68.482,69.782,71.059,72.316,73.553,74.771,75.969,77.149,78.312,79.457,80.586,81.698,82.795,83.877,84.944,85.997,87.036,88.062,89.075,90.075,91.063,92.039,93.004,93.958,94.901,95.834,96.757,97.67,98.573,99.468,100.35,101.23,102.1,102.96,103.81,104.66,105.5,106.33,107.15,107.97,108.78,109.59,110.39,111.18,111.97,112.75,113.53,114.3,115.07,115.83,116.59,117.35,118.1,118.85,119.59,120.33,121.07,121.81,122.54,123.27,123.99,124.71,125.43,126.15,126.87,127.58,128.3,129.01,129.72,130.42,131.13,131.83,132.54,133.24,133.94,134.64,135.34,136.04,136.74,137.44,138.14,138.83,139.53,140.23,140.93,141.63,142.32,143.02,143.72,144.42,145.12,145.82,146.52,147.22,147.92,148.63,149.33,150.04,150.74,151.45,152.16,152.87,153.58,154.29,155.0,155.72,156.43,157.15,157.87,158.59,159.31,160.03,160.76,161.48,162.21,162.94,163.67,164.4,165.13,165.87,166.6,167.34,168.08,168.82,169.56,170.3,171.05,171.79,172.54,173.29,174.03,174.79,175.54,176.29,177.04,177.8,178.55,179.31,180.06,180.82,181.58,182.34,183.1,183.86,184.62,185.38,186.14,186.9,187.66,188.42,189.18,189.94,190.7,191.46,192.22,192.98,193.74,194.5,195.26,196.01,196.77,197.53,198.28,199.03,199.79,200.54,201.29,202.04,202.79,203.53,204.28,205.02,205.77,206.51,207.25,207.99,208.73,209.46,210.2,210.93,211.66,212.39,213.12,213.85,214.58,215.3,216.02,216.75,217.47,218.19,218.9,219.62,220.33,221.05,221.76,222.47,223.18,223.89,224.6,225.3,226.01,226.71,227.42,228.12,228.82,229.52,230.22,230.92,231.62,232.32,233.02,233.72,234.42,235.11,235.81,236.51,237.21,237.91,238.6,239.3,240.0,240.7,241.4,242.11,242.81,243.51,244.22,244.92,245.63,246.34,247.05,247.76,248.47,249.19,249.91,250.63,251.35,252.08,252.8,253.54,254.27,255.01,255.75,256.49,257.24,257.99,258.74,259.5,260.26,261.03,261.8,262.58,263.36,264.15,264.94,265.74,266.55,267.36,268.17,269.0,269.83,270.66,271.51,272.36,273.22,274.08,274.96,275.84,276.74,277.64,278.55,279.47,280.4,281.34,282.29,283.25,284.23,285.21,286.21,287.22,288.24,289.28,290.33,291.39,292.47,293.57,294.67,295.8,296.94,298.1,299.28,300.47,301.68,302.92,304.17,305.44,306.74,308.05,309.39,310.76,312.14,313.56,314.99,316.46,317.95,319.47,321.03,322.61,324.22,325.87,327.55,329.27,331.02,332.82,334.65,336.52,338.44,340.4,342.4,344.46,346.56,348.72,350.93,353.19,355.52,357.9,360.35,362.87,365.45,368.11,370.84,373.66,376.55,379.53,382.6,},
{-13.123,-9.8578,-6.6921,-3.6216,-0.64205,2.2508,5.0609,7.7917,10.447,13.03,15.543,17.99,20.373,22.696,24.959,27.167,29.32,31.421,33.473,35.477,37.434,39.347,41.217,43.046,44.836,46.587,48.301,49.979,51.624,53.235,54.814,56.362,57.88,59.37,60.832,62.266,63.675,65.058,66.417,67.753,69.066,70.356,71.625,72.874,74.102,75.312,76.502,77.674,78.828,79.966,81.086,82.191,83.28,84.354,85.413,86.459,87.49,88.508,89.514,90.506,91.487,92.456,93.413,94.36,95.296,96.221,97.136,98.042,98.938,99.825,100.7,101.57,102.43,103.29,104.13,104.97,105.8,106.63,107.44,108.25,109.06,109.86,110.65,111.43,112.21,112.99,113.76,114.53,115.29,116.04,116.8,117.54,118.29,119.03,119.76,120.5,121.23,121.95,122.68,123.4,124.11,124.83,125.54,126.25,126.96,127.66,128.37,129.07,129.77,130.47,131.17,131.86,132.56,133.25,133.94,134.64,135.33,136.02,136.71,137.4,138.09,138.77,139.46,140.15,140.84,141.53,142.22,142.91,143.59,144.28,144.97,145.66,146.36,147.05,147.74,148.43,149.13,149.82,150.52,151.21,151.91,152.61,153.31,154.01,154.72,155.42,156.12,156.83,157.54,158.25,158.96,159.67,160.38,161.1,161.81,162.53,163.25,163.97,164.69,165.42,166.14,166.87,167.6,168.33,169.06,169.79,170.52,171.26,171.99,172.73,173.47,174.21,174.95,175.69,176.44,177.18,177.93,178.67,179.42,180.17,180.91,181.66,182.41,183.16,183.91,184.66,185.41,186.16,186.92,187.67,188.42,189.17,189.92,190.67,191.42,192.17,192.92,193.67,194.42,195.17,195.92,196.66,197.41,198.16,198.9,199.64,200.39,201.13,201.87,202.61,203.34,204.08,204.82,205.55,206.28,207.01,207.74,208.47,209.2,209.92,210.65,211.37,212.09,212.81,213.53,214.25,214.96,215.68,216.39,217.1,217.81,218.52,219.22,219.93,220.63,221.34,222.04,222.74,223.44,224.14,224.83,225.53,226.23,226.92,227.61,228.31,229.0,229.69,230.38,231.07,231.76,232.45,233.14,233.83,234.52,235.21,235.89,236.58,237.27,237.96,238.65,239.34,240.03,240.72,241.41,242.11,242.8,243.49,244.19,244.89,245.59,246.29,246.99,247.69,248.4,249.11,249.82,250.53,251.24,251.96,252.68,253.4,254.13,254.86,255.59,256.32,257.06,257.81,258.55,259.31,260.06,260.82,261.59,262.36,263.13,263.91,264.7,265.49,266.28,267.09,267.89,268.71,269.53,270.36,271.2,272.04,272.89,273.75,274.62,275.5,276.38,277.28,278.18,279.09,280.02,280.95,281.9,282.85,283.82,284.79,285.78,286.79,287.8,288.83,289.87,290.93,292.0,293.09,294.19,295.3,296.44,297.59,298.76,299.94,301.15,302.37,303.62,304.88,306.17,307.48,308.81,310.16,311.54,312.94,314.37,315.83,317.31,318.82,320.36,321.94,323.54,325.18,326.85,328.55,330.3,332.08,333.9,335.76,337.66,339.61,341.61,343.65,345.74,347.88,350.08,352.33,354.64,357.01,359.44,361.94,364.51,367.15,369.87,372.66,375.54,378.5,},
{-8.8219,-5.6754,-2.6236,0.3379,3.2133,6.0064,8.7209,11.36,13.927,16.426,18.858,21.227,23.536,25.786,27.98,30.121,32.209,34.249,36.241,38.186,40.088,41.947,43.765,45.544,47.284,48.988,50.657,52.291,53.892,55.462,57.0,58.51,59.99,61.443,62.868,64.268,65.643,66.994,68.321,69.625,70.908,72.169,73.409,74.63,75.831,77.013,78.178,79.324,80.454,81.567,82.664,83.746,84.813,85.865,86.903,87.927,88.938,89.936,90.922,91.895,92.857,93.807,94.747,95.675,96.594,97.502,98.4,99.29,100.17,101.04,101.9,102.76,103.6,104.44,105.27,106.1,106.91,107.72,108.53,109.32,110.11,110.9,111.68,112.45,113.22,113.98,114.74,115.5,116.25,116.99,117.73,118.47,119.2,119.93,120.65,121.38,122.09,122.81,123.52,124.23,124.94,125.64,126.35,127.05,127.74,128.44,129.13,129.83,130.52,131.2,131.89,132.58,133.26,133.95,134.63,135.31,136.0,136.68,137.36,138.04,138.72,139.4,140.08,140.76,141.43,142.11,142.79,143.47,144.15,144.83,145.51,146.2,146.88,147.56,148.24,148.93,149.61,150.3,150.99,151.67,152.36,153.05,153.74,154.44,155.13,155.83,156.52,157.22,157.92,158.62,159.32,160.02,160.73,161.43,162.14,162.85,163.56,164.27,164.98,165.7,166.42,167.13,167.85,168.57,169.29,170.02,170.74,171.47,172.19,172.92,173.65,174.38,175.11,175.85,176.58,177.32,178.05,178.79,179.53,180.26,181.0,181.74,182.48,183.22,183.96,184.71,185.45,186.19,186.93,187.67,188.42,189.16,189.9,190.64,191.38,192.12,192.87,193.61,194.35,195.08,195.82,196.56,197.3,198.03,198.77,199.5,200.24,200.97,201.7,202.43,203.16,203.88,204.61,205.34,206.06,206.78,207.5,208.22,208.94,209.66,210.37,211.09,211.8,212.51,213.22,213.93,214.63,215.34,216.04,216.74,217.44,218.14,218.84,219.54,220.23,220.93,221.62,222.31,223.0,223.69,224.38,225.07,225.75,226.44,227.12,227.81,228.49,229.17,229.85,230.53,231.22,231.9,232.58,233.26,233.94,234.61,235.29,235.97,236.65,237.33,238.01,238.69,239.37,240.06,240.74,241.42,242.11,242.79,243.48,244.17,244.85,245.55,246.24,246.93,247.63,248.32,249.02,249.73,250.43,251.14,251.85,252.56,253.27,253.99,254.71,255.44,256.17,256.9,257.63,258.37,259.12,259.86,260.62,261.37,262.14,262.9,263.68,264.46,265.24,266.03,266.82,267.63,268.43,269.25,270.07,270.9,271.74,272.58,273.44,274.3,275.17,276.04,276.93,277.83,278.73,279.65,280.58,281.51,282.46,283.42,284.39,285.38,286.37,287.38,288.4,289.44,290.48,291.55,292.63,293.72,294.83,295.96,297.1,298.26,299.44,300.63,301.85,303.09,304.34,305.62,306.92,308.24,309.59,310.96,312.35,313.77,315.22,316.69,318.2,319.73,321.29,322.89,324.51,326.18,327.87,329.6,331.37,333.18,335.03,336.93,338.86,340.85,342.88,344.95,347.08,349.27,351.51,353.8,356.16,358.58,361.06,363.61,366.24,368.94,371.72,374.57,},
{-4.712,-1.6775,1.2674,4.1266,6.9041,9.6033,12.228,14.781,17.265,19.684,22.04,24.335,26.573,28.755,30.883,32.961,34.989,36.969,38.904,40.795,42.644,44.451,46.22,47.951,49.645,51.304,52.929,54.521,56.082,57.611,59.112,60.584,62.028,63.445,64.837,66.203,67.546,68.865,70.162,71.436,72.69,73.923,75.136,76.329,77.504,78.661,79.801,80.923,82.029,83.119,84.194,85.254,86.299,87.33,88.347,89.351,90.342,91.321,92.288,93.243,94.186,95.119,96.041,96.952,97.854,98.746,99.628,100.5,101.37,102.22,103.07,103.91,104.74,105.56,106.38,107.19,107.99,108.79,109.58,110.37,111.14,111.92,112.68,113.44,114.2,114.95,115.7,116.44,117.18,117.91,118.64,119.37,120.09,120.8,121.52,122.23,122.94,123.64,124.35,125.05,125.74,126.44,127.13,127.82,128.51,129.19,129.88,130.56,131.24,131.92,132.6,133.28,133.95,134.63,135.3,135.97,136.65,137.32,137.99,138.66,139.33,140.0,140.67,141.34,142.01,142.68,143.36,144.03,144.7,145.37,146.04,146.71,147.39,148.06,148.74,149.41,150.09,150.77,151.44,152.12,152.8,153.48,154.17,154.85,155.54,156.22,156.91,157.6,158.29,158.98,159.67,160.37,161.06,161.76,162.46,163.16,163.86,164.56,165.27,165.97,166.68,167.39,168.1,168.81,169.52,170.24,170.95,171.67,172.39,173.11,173.83,174.55,175.27,176.0,176.72,177.45,178.17,178.9,179.63,180.36,181.09,181.82,182.55,183.28,184.02,184.75,185.48,186.21,186.95,187.68,188.41,189.15,189.88,190.61,191.34,192.08,192.81,193.54,194.27,195.0,195.73,196.46,197.19,197.91,198.64,199.37,200.09,200.81,201.54,202.26,202.98,203.69,204.41,205.13,205.84,206.56,207.27,207.98,208.69,209.39,210.1,210.81,211.51,212.21,212.91,213.61,214.31,215.0,215.7,216.39,217.08,217.78,218.46,219.15,219.84,220.52,221.21,221.89,222.57,223.25,223.93,224.61,225.29,225.97,226.64,227.32,227.99,228.67,229.34,230.01,230.68,231.36,232.03,232.7,233.37,234.04,234.71,235.38,236.05,236.72,237.39,238.06,238.74,239.41,240.08,240.76,241.43,242.11,242.78,243.46,244.14,244.82,245.51,246.19,246.88,247.56,248.25,248.94,249.64,250.34,251.03,251.74,252.44,253.15,253.86,254.57,255.29,256.01,256.74,257.46,258.2,258.93,259.67,260.42,261.17,261.93,262.69,263.45,264.22,265.0,265.78,266.57,267.37,268.17,268.98,269.79,270.62,271.45,272.28,273.13,273.98,274.85,275.72,276.6,277.49,278.39,279.3,280.22,281.15,282.09,283.04,284.01,284.98,285.97,286.97,287.99,289.01,290.06,291.11,292.18,293.27,294.37,295.49,296.63,297.78,298.95,300.14,301.35,302.58,303.83,305.1,306.39,307.7,309.04,310.4,311.79,313.2,314.64,316.11,317.6,319.12,320.68,322.26,323.88,325.53,327.22,328.94,330.7,332.5,334.34,336.22,338.15,340.12,342.14,344.21,346.32,348.5,350.72,353.0,355.35,357.75,360.22,362.76,365.37,368.06,370.82,},
{-0.78136,2.1481,4.9924,7.7554,10.441,13.051,15.591,18.062,20.469,22.812,25.096,27.322,29.492,31.61,33.676,35.694,37.664,39.588,41.469,43.308,45.107,46.866,48.587,50.272,51.922,53.539,55.122,56.674,58.196,59.688,61.151,62.588,63.997,65.381,66.74,68.075,69.387,70.676,71.943,73.189,74.415,75.621,76.807,77.975,79.125,80.258,81.374,82.473,83.556,84.624,85.677,86.715,87.74,88.75,89.748,90.733,91.705,92.665,93.614,94.551,95.477,96.392,97.297,98.193,99.078,99.954,100.82,101.68,102.53,103.37,104.2,105.03,105.85,106.66,107.46,108.26,109.05,109.83,110.61,111.38,112.14,112.9,113.66,114.41,115.15,115.89,116.63,117.36,118.09,118.81,119.53,120.24,120.95,121.66,122.36,123.06,123.76,124.46,125.15,125.84,126.53,127.21,127.89,128.57,129.25,129.93,130.6,131.28,131.95,132.62,133.29,133.96,134.62,135.29,135.95,136.62,137.28,137.95,138.61,139.27,139.93,140.59,141.26,141.92,142.58,143.24,143.9,144.57,145.23,145.89,146.56,147.22,147.88,148.55,149.22,149.88,150.55,151.22,151.89,152.56,153.23,153.91,154.58,155.25,155.93,156.61,157.29,157.97,158.65,159.33,160.02,160.7,161.39,162.08,162.77,163.46,164.15,164.85,165.54,166.24,166.94,167.64,168.34,169.04,169.75,170.45,171.16,171.87,172.58,173.29,174.0,174.71,175.43,176.14,176.86,177.58,178.29,179.01,179.73,180.45,181.18,181.9,182.62,183.34,184.07,184.79,185.51,186.24,186.96,187.69,188.41,189.14,189.86,190.58,191.31,192.03,192.75,193.48,194.2,194.92,195.64,196.36,197.08,197.8,198.52,199.23,199.95,200.66,201.38,202.09,202.8,203.51,204.22,204.92,205.63,206.33,207.04,207.74,208.44,209.14,209.84,210.53,211.23,211.92,212.61,213.3,213.99,214.68,215.37,216.05,216.74,217.42,218.1,218.78,219.46,220.13,220.81,221.48,222.16,222.83,223.5,224.17,224.84,225.51,226.18,226.84,227.51,228.17,228.84,229.5,230.16,230.83,231.49,232.15,232.81,233.48,234.14,234.8,235.46,236.12,236.79,237.45,238.11,238.78,239.44,240.11,240.77,241.44,242.11,242.78,243.45,244.12,244.79,245.47,246.14,246.82,247.5,248.18,248.87,249.55,250.24,250.94,251.63,252.33,253.03,253.73,254.44,255.15,255.86,256.58,257.3,258.03,258.76,259.49,260.23,260.97,261.72,262.48,263.24,264.0,264.77,265.55,266.33,267.12,267.91,268.72,269.52,270.34,271.16,272.0,272.84,273.68,274.54,275.4,276.28,277.16,278.05,278.96,279.87,280.79,281.73,282.68,283.63,284.6,285.59,286.58,287.59,288.61,289.64,290.69,291.76,292.84,293.93,295.05,296.18,297.32,298.49,299.67,300.87,302.09,303.33,304.6,305.88,307.19,308.52,309.87,311.25,312.65,314.08,315.54,317.03,318.54,320.09,321.67,323.28,324.92,326.6,328.31,330.06,331.85,333.68,335.55,337.47,339.43,341.44,343.49,345.6,347.76,349.98,352.25,354.58,356.97,359.43,361.96,364.55,367.22,},
{2.9816,5.8121,8.5618,11.234,13.832,16.36,18.819,21.214,23.546,25.818,28.034,30.194,32.301,34.357,36.365,38.325,40.24,42.112,43.942,45.731,47.482,49.194,50.871,52.513,54.121,55.696,57.24,58.754,60.239,61.695,63.123,64.525,65.902,67.254,68.582,69.886,71.168,72.429,73.668,74.887,76.086,77.266,78.427,79.571,80.697,81.806,82.899,83.975,85.037,86.084,87.116,88.134,89.138,90.129,91.108,92.074,93.028,93.97,94.901,95.821,96.731,97.63,98.518,99.398,100.27,101.13,101.98,102.82,103.66,104.49,105.3,106.12,106.92,107.72,108.51,109.29,110.07,110.84,111.61,112.36,113.12,113.87,114.61,115.35,116.08,116.81,117.53,118.25,118.97,119.68,120.39,121.09,121.79,122.49,123.18,123.88,124.56,125.25,125.93,126.61,127.29,127.96,128.64,129.31,129.98,130.65,131.31,131.98,132.64,133.3,133.96,134.62,135.28,135.94,136.59,137.25,137.9,138.56,139.21,139.86,140.52,141.17,141.83,142.48,143.13,143.79,144.44,145.09,145.75,146.4,147.06,147.71,148.37,149.03,149.69,150.34,151.0,151.66,152.33,152.99,153.65,154.32,154.98,155.65,156.32,156.99,157.66,158.33,159.0,159.68,160.35,161.03,161.71,162.39,163.07,163.76,164.44,165.13,165.81,166.5,167.19,167.88,168.58,169.27,169.97,170.66,171.36,172.06,172.76,173.47,174.17,174.87,175.58,176.29,176.99,177.7,178.41,179.12,179.83,180.55,181.26,181.97,182.69,183.4,184.11,184.83,185.55,186.26,186.98,187.69,188.41,189.12,189.84,190.56,191.27,191.99,192.7,193.41,194.13,194.84,195.55,196.26,196.97,197.68,198.39,199.1,199.81,200.51,201.22,201.92,202.63,203.33,204.03,204.73,205.42,206.12,206.81,207.51,208.2,208.89,209.58,210.27,210.95,211.64,212.32,213.0,213.69,214.36,215.04,215.72,216.39,217.07,217.74,218.41,219.08,219.75,220.42,221.08,221.75,222.41,223.08,223.74,224.4,225.06,225.72,226.38,227.03,227.69,228.35,229.0,229.66,230.31,230.97,231.62,232.27,232.93,233.58,234.24,234.89,235.54,236.2,236.85,237.51,238.16,238.82,239.47,240.13,240.79,241.45,242.11,242.77,243.43,244.1,244.76,245.43,246.1,246.77,247.44,248.12,248.79,249.47,250.16,250.84,251.53,252.22,252.91,253.61,254.31,255.01,255.72,256.43,257.15,257.86,258.59,259.32,260.05,260.78,261.53,262.27,263.03,263.79,264.55,265.32,266.1,266.88,267.67,268.46,269.27,270.08,270.89,271.72,272.55,273.39,274.24,275.1,275.97,276.85,277.73,278.63,279.54,280.46,281.38,282.32,283.28,284.24,285.22,286.2,287.21,288.22,289.25,290.29,291.35,292.43,293.51,294.62,295.74,296.88,298.04,299.22,300.41,301.63,302.86,304.12,305.39,306.69,308.02,309.36,310.73,312.13,313.55,315.0,316.48,317.99,319.53,321.1,322.7,324.33,326.0,327.71,329.45,331.23,333.05,334.92,336.82,338.77,340.77,342.82,344.91,347.06,349.27,351.53,353.85,356.23,358.68,361.19,363.77,},
{6.5873,9.3247,11.985,14.572,17.088,19.536,21.92,24.242,26.504,28.71,30.86,32.958,35.005,37.003,38.954,40.861,42.724,44.545,46.326,48.068,49.773,51.442,53.076,54.676,56.244,57.781,59.287,60.765,62.214,63.635,65.03,66.4,67.745,69.066,70.364,71.64,72.893,74.126,75.339,76.531,77.705,78.86,79.998,81.117,82.22,83.307,84.378,85.433,86.474,87.5,88.512,89.511,90.496,91.468,92.428,93.377,94.313,95.238,96.152,97.056,97.949,98.832,99.705,100.57,101.42,102.27,103.11,103.94,104.76,105.57,106.38,107.17,107.97,108.75,109.53,110.3,111.06,111.82,112.58,113.32,114.07,114.8,115.54,116.26,116.98,117.7,118.42,119.13,119.83,120.53,121.23,121.92,122.61,123.3,123.99,124.67,125.35,126.02,126.69,127.37,128.03,128.7,129.36,130.03,130.69,131.34,132.0,132.66,133.31,133.96,134.62,135.27,135.92,136.57,137.21,137.86,138.51,139.15,139.8,140.44,141.09,141.74,142.38,143.03,143.67,144.32,144.96,145.61,146.25,146.9,147.55,148.2,148.84,149.49,150.14,150.79,151.45,152.1,152.75,153.41,154.06,154.72,155.38,156.03,156.69,157.36,158.02,158.68,159.35,160.01,160.68,161.35,162.02,162.69,163.37,164.04,164.72,165.4,166.08,166.76,167.44,168.12,168.81,169.49,170.18,170.87,171.56,172.25,172.95,173.64,174.33,175.03,175.73,176.43,177.13,177.83,178.53,179.23,179.93,180.64,181.34,182.04,182.75,183.46,184.16,184.87,185.58,186.28,186.99,187.7,188.41,189.11,189.82,190.53,191.23,191.94,192.65,193.35,194.06,194.76,195.47,196.17,196.87,197.57,198.27,198.97,199.67,200.37,201.07,201.76,202.46,203.15,203.84,204.53,205.22,205.91,206.6,207.28,207.96,208.65,209.33,210.01,210.69,211.36,212.04,212.71,213.38,214.06,214.73,215.39,216.06,216.73,217.39,218.05,218.72,219.38,220.04,220.69,221.35,222.01,222.66,223.32,223.97,224.62,225.27,225.92,226.57,227.22,227.87,228.52,229.16,229.81,230.46,231.1,231.75,232.39,233.04,233.68,234.33,234.97,235.62,236.27,236.91,237.56,238.21,238.85,239.5,240.15,240.8,241.45,242.11,242.76,243.42,244.07,244.73,245.39,246.05,246.72,247.38,248.05,248.72,249.4,250.07,250.75,251.43,252.11,252.8,253.49,254.18,254.88,255.58,256.29,256.99,257.71,258.42,259.15,259.87,260.6,261.34,262.08,262.83,263.58,264.34,265.1,265.87,266.65,267.43,268.22,269.02,269.82,270.63,271.45,272.28,273.11,273.96,274.81,275.67,276.55,277.43,278.32,279.22,280.13,281.05,281.99,282.93,283.89,284.86,285.84,286.84,287.85,288.87,289.91,290.96,292.03,293.11,294.21,295.33,296.46,297.61,298.78,299.97,301.18,302.41,303.66,304.93,306.22,307.54,308.88,310.24,311.63,313.05,314.49,315.96,317.46,318.99,320.55,322.15,323.78,325.44,327.13,328.87,330.64,332.45,334.31,336.21,338.15,340.14,342.18,344.26,346.4,348.6,350.85,353.16,355.53,357.96,360.47,},
{10.045,12.695,15.271,17.777,20.216,22.59,24.902,27.155,29.351,31.492,33.581,35.619,37.609,39.553,41.451,43.306,45.119,46.893,48.627,50.325,51.986,53.613,55.206,56.767,58.297,59.796,61.267,62.709,64.124,65.513,66.876,68.215,69.53,70.821,72.091,73.338,74.565,75.771,76.958,78.126,79.275,80.406,81.52,82.618,83.699,84.764,85.813,86.848,87.869,88.875,89.868,90.848,91.814,92.769,93.711,94.642,95.562,96.47,97.368,98.256,99.133,100.0,100.86,101.71,102.55,103.38,104.2,105.02,105.83,106.63,107.42,108.21,108.98,109.76,110.52,111.28,112.03,112.78,113.52,114.26,114.99,115.72,116.44,117.15,117.87,118.57,119.28,119.97,120.67,121.36,122.05,122.73,123.41,124.09,124.77,125.44,126.11,126.77,127.44,128.1,128.76,129.42,130.07,130.73,131.38,132.03,132.68,133.32,133.97,134.61,135.26,135.9,136.54,137.18,137.82,138.46,139.1,139.74,140.37,141.01,141.65,142.29,142.92,143.56,144.2,144.83,145.47,146.11,146.75,147.39,148.03,148.67,149.31,149.95,150.59,151.23,151.88,152.52,153.17,153.81,154.46,155.11,155.76,156.41,157.06,157.72,158.37,159.03,159.69,160.34,161.0,161.67,162.33,162.99,163.66,164.33,164.99,165.66,166.33,167.01,167.68,168.36,169.03,169.71,170.39,171.07,171.75,172.44,173.12,173.81,174.5,175.18,175.87,176.56,177.25,177.95,178.64,179.33,180.03,180.72,181.42,182.12,182.81,183.51,184.21,184.91,185.61,186.31,187.01,187.7,188.4,189.1,189.8,190.5,191.2,191.9,192.6,193.29,193.99,194.69,195.38,196.08,196.77,197.46,198.16,198.85,199.54,200.23,200.92,201.6,202.29,202.98,203.66,204.34,205.02,205.7,206.38,207.06,207.73,208.41,209.08,209.75,210.42,211.09,211.76,212.43,213.09,213.75,214.42,215.08,215.74,216.39,217.05,217.7,218.36,219.01,219.66,220.31,220.96,221.61,222.26,222.9,223.55,224.19,224.84,225.48,226.12,226.76,227.4,228.04,228.68,229.32,229.96,230.59,231.23,231.87,232.51,233.14,233.78,234.42,235.06,235.69,236.33,236.97,237.61,238.25,238.89,239.53,240.17,240.82,241.46,242.11,242.75,243.4,244.05,244.7,245.36,246.01,246.67,247.33,247.99,248.65,249.32,249.99,250.66,251.33,252.01,252.69,253.38,254.06,254.75,255.45,256.15,256.85,257.56,258.27,258.98,259.7,260.43,261.16,261.89,262.63,263.38,264.13,264.89,265.65,266.42,267.2,267.99,268.78,269.57,270.38,271.19,272.02,272.85,273.68,274.53,275.39,276.25,277.13,278.02,278.91,279.82,280.73,281.66,282.6,283.56,284.52,285.5,286.49,287.49,288.51,289.54,290.59,291.65,292.73,293.82,294.93,296.06,297.2,298.37,299.55,300.75,301.97,303.22,304.48,305.77,307.08,308.41,309.77,311.16,312.56,314.0,315.47,316.96,318.48,320.04,321.62,323.24,324.9,326.59,328.32,330.08,331.89,333.73,335.62,337.56,339.54,341.57,343.64,345.77,347.96,350.2,352.5,354.86,357.29,},
{13.365,15.931,18.428,20.857,23.223,25.526,27.77,29.958,32.091,34.172,36.203,38.185,40.12,42.011,43.859,45.665,47.431,49.159,50.85,52.504,54.124,55.711,57.265,58.789,60.282,61.746,63.182,64.591,65.974,67.331,68.663,69.972,71.258,72.522,73.763,74.985,76.185,77.366,78.529,79.672,80.798,81.907,82.998,84.074,85.133,86.178,87.207,88.222,89.223,90.211,91.185,92.147,93.096,94.033,94.958,95.873,96.776,97.668,98.551,99.423,100.29,101.14,101.98,102.82,103.64,104.46,105.27,106.07,106.87,107.66,108.44,109.21,109.98,110.74,111.49,112.24,112.98,113.71,114.44,115.17,115.89,116.61,117.32,118.02,118.72,119.42,120.11,120.8,121.49,122.17,122.85,123.52,124.19,124.86,125.53,126.19,126.85,127.51,128.16,128.82,129.47,130.12,130.76,131.41,132.05,132.69,133.33,133.97,134.61,135.25,135.88,136.51,137.15,137.78,138.41,139.04,139.67,140.3,140.93,141.56,142.19,142.82,143.45,144.08,144.71,145.34,145.97,146.6,147.23,147.86,148.49,149.13,149.76,150.39,151.03,151.66,152.3,152.94,153.57,154.21,154.85,155.49,156.14,156.78,157.42,158.07,158.72,159.37,160.01,160.67,161.32,161.97,162.63,163.28,163.94,164.6,165.26,165.92,166.59,167.25,167.92,168.59,169.25,169.92,170.6,171.27,171.94,172.62,173.3,173.97,174.65,175.33,176.01,176.7,177.38,178.06,178.75,179.43,180.12,180.81,181.5,182.19,182.88,183.57,184.26,184.95,185.64,186.33,187.02,187.71,188.4,189.09,189.78,190.47,191.17,191.86,192.55,193.23,193.92,194.61,195.3,195.99,196.67,197.36,198.04,198.73,199.41,200.09,200.77,201.45,202.13,202.81,203.48,204.16,204.83,205.5,206.17,206.84,207.51,208.18,208.84,209.51,210.17,210.83,211.49,212.15,212.8,213.46,214.11,214.77,215.42,216.07,216.72,217.36,218.01,218.65,219.3,219.94,220.58,221.22,221.86,222.5,223.14,223.77,224.41,225.04,225.68,226.31,226.94,227.58,228.21,228.84,229.47,230.1,230.73,231.36,231.99,232.62,233.25,233.88,234.51,235.14,235.77,236.4,237.03,237.66,238.29,238.93,239.56,240.2,240.83,241.47,242.11,242.75,243.39,244.03,244.68,245.32,245.97,246.62,247.28,247.93,248.59,249.25,249.91,250.57,251.24,251.91,252.59,253.27,253.95,254.63,255.32,256.01,256.71,257.41,258.11,258.82,259.54,260.26,260.98,261.71,262.45,263.19,263.93,264.69,265.44,266.21,266.98,267.76,268.55,269.34,270.14,270.95,271.76,272.59,273.42,274.26,275.12,275.98,276.85,277.73,278.62,279.52,280.43,281.35,282.29,283.23,284.19,285.16,286.15,287.15,288.16,289.19,290.23,291.28,292.36,293.44,294.55,295.67,296.81,297.97,299.15,300.34,301.56,302.8,304.06,305.34,306.64,307.97,309.32,310.7,312.1,313.53,314.99,316.48,318.0,319.54,321.12,322.74,324.39,326.07,327.79,329.55,331.35,333.19,335.07,336.99,338.97,340.99,343.06,345.18,347.36,349.59,351.88,354.24,},
{16.554,19.042,21.463,23.82,26.116,28.352,30.532,32.658,34.732,36.755,38.73,40.659,42.543,44.384,46.183,47.943,49.664,51.348,52.997,54.611,56.191,57.739,59.257,60.744,62.202,63.633,65.036,66.413,67.764,69.092,70.395,71.675,72.933,74.17,75.385,76.581,77.757,78.914,80.052,81.173,82.276,83.363,84.433,85.487,86.527,87.551,88.561,89.557,90.539,91.509,92.465,93.409,94.341,95.262,96.171,97.069,97.957,98.834,99.701,100.56,101.41,102.25,103.07,103.9,104.71,105.51,106.31,107.1,107.88,108.66,109.42,110.19,110.94,111.69,112.43,113.17,113.9,114.62,115.34,116.06,116.77,117.47,118.17,118.87,119.56,120.25,120.93,121.61,122.29,122.96,123.63,124.29,124.96,125.62,126.27,126.93,127.58,128.23,128.87,129.52,130.16,130.8,131.44,132.07,132.71,133.34,133.97,134.61,135.23,135.86,136.49,137.12,137.74,138.37,138.99,139.61,140.24,140.86,141.48,142.1,142.73,143.35,143.97,144.59,145.21,145.84,146.46,147.08,147.7,148.33,148.95,149.58,150.2,150.83,151.45,152.08,152.71,153.34,153.97,154.6,155.24,155.87,156.5,157.14,157.78,158.41,159.05,159.7,160.34,160.98,161.63,162.27,162.92,163.57,164.22,164.87,165.52,166.18,166.83,167.49,168.15,168.81,169.47,170.13,170.8,171.46,172.13,172.8,173.47,174.14,174.81,175.48,176.15,176.83,177.5,178.18,178.86,179.53,180.21,180.89,181.57,182.25,182.94,183.62,184.3,184.98,185.67,186.35,187.03,187.72,188.4,189.08,189.77,190.45,191.13,191.81,192.5,193.18,193.86,194.54,195.22,195.9,196.58,197.25,197.93,198.61,199.28,199.96,200.63,201.3,201.97,202.64,203.31,203.97,204.64,205.3,205.97,206.63,207.29,207.95,208.61,209.26,209.92,210.57,211.22,211.87,212.52,213.17,213.82,214.46,215.11,215.75,216.39,217.03,217.67,218.31,218.94,219.58,220.21,220.84,221.48,222.11,222.74,223.37,223.99,224.62,225.25,225.87,226.5,227.12,227.75,228.37,228.99,229.62,230.24,230.86,231.48,232.1,232.73,233.35,233.97,234.59,235.22,235.84,236.46,237.09,237.71,238.34,238.96,239.59,240.22,240.85,241.48,242.11,242.74,243.38,244.01,244.65,245.29,245.93,246.58,247.22,247.87,248.52,249.18,249.83,250.49,251.15,251.82,252.49,253.16,253.83,254.51,255.2,255.88,256.57,257.27,257.97,258.67,259.38,260.09,260.81,261.54,262.27,263.0,263.74,264.49,265.24,266.0,266.77,267.54,268.32,269.11,269.91,270.71,271.52,272.34,273.17,274.01,274.85,275.71,276.57,277.45,278.33,279.23,280.14,281.06,281.98,282.93,283.88,284.85,285.83,286.82,287.83,288.85,289.88,290.94,292.0,293.09,294.19,295.3,296.44,297.59,298.76,299.95,301.17,302.4,303.65,304.93,306.23,307.55,308.89,310.27,311.66,313.09,314.54,316.02,317.53,319.08,320.65,322.26,323.9,325.58,327.29,329.04,330.83,332.67,334.54,336.46,338.43,340.44,342.5,344.62,346.79,349.01,351.3,},
{19.62,22.034,24.383,26.672,28.902,31.075,33.194,35.261,37.277,39.246,41.168,43.046,44.881,46.674,48.428,50.144,51.822,53.464,55.073,56.648,58.19,59.702,61.184,62.637,64.062,65.46,66.831,68.178,69.5,70.798,72.073,73.326,74.558,75.768,76.959,78.13,79.282,80.415,81.531,82.629,83.711,84.776,85.826,86.86,87.88,88.885,89.876,90.854,91.819,92.77,93.71,94.637,95.553,96.457,97.35,98.233,99.105,99.968,100.82,101.66,102.5,103.32,104.14,104.95,105.75,106.54,107.32,108.1,108.87,109.63,110.39,111.14,111.88,112.62,113.35,114.08,114.8,115.51,116.22,116.92,117.62,118.32,119.01,119.69,120.38,121.05,121.73,122.4,123.06,123.73,124.39,125.04,125.7,126.35,127.0,127.64,128.29,128.93,129.56,130.2,130.83,131.47,132.1,132.73,133.35,133.98,134.6,135.22,135.85,136.47,137.09,137.7,138.32,138.94,139.56,140.17,140.79,141.4,142.02,142.63,143.25,143.86,144.47,145.09,145.7,146.32,146.93,147.55,148.17,148.78,149.4,150.02,150.63,151.25,151.87,152.49,153.11,153.74,154.36,154.98,155.61,156.24,156.86,157.49,158.12,158.75,159.38,160.02,160.65,161.29,161.93,162.56,163.21,163.85,164.49,165.13,165.78,166.43,167.07,167.72,168.38,169.03,169.68,170.34,170.99,171.65,172.31,172.97,173.63,174.29,174.96,175.62,176.29,176.95,177.62,178.29,178.96,179.63,180.3,180.98,181.65,182.32,182.99,183.67,184.34,185.02,185.69,186.37,187.05,187.72,188.4,189.07,189.75,190.42,191.1,191.77,192.45,193.12,193.8,194.47,195.14,195.81,196.48,197.15,197.82,198.49,199.16,199.82,200.49,201.15,201.82,202.48,203.14,203.8,204.45,205.11,205.77,206.42,207.07,207.73,208.38,209.02,209.67,210.32,210.96,211.61,212.25,212.89,213.53,214.16,214.8,215.44,216.07,216.7,217.33,217.96,218.59,219.22,219.85,220.47,221.1,221.72,222.34,222.97,223.59,224.21,224.83,225.44,226.06,226.68,227.3,227.91,228.53,229.14,229.76,230.37,230.99,231.6,232.22,232.83,233.45,234.06,234.68,235.29,235.91,236.52,237.14,237.76,238.38,239.0,239.62,240.24,240.86,241.48,242.11,242.74,243.37,244.0,244.63,245.26,245.9,246.53,247.17,247.82,248.46,249.11,249.76,250.41,251.07,251.73,252.39,253.06,253.73,254.4,255.08,255.76,256.44,257.13,257.83,258.53,259.23,259.94,260.65,261.37,262.09,262.83,263.56,264.3,265.05,265.81,266.57,267.34,268.11,268.89,269.69,270.48,271.29,272.1,272.93,273.76,274.6,275.45,276.31,277.18,278.06,278.95,279.86,280.77,281.69,282.63,283.58,284.54,285.52,286.51,287.51,288.52,289.56,290.6,291.67,292.74,293.84,294.95,296.08,297.23,298.4,299.58,300.79,302.02,303.26,304.54,305.83,307.15,308.49,309.85,311.25,312.67,314.11,315.59,317.09,318.63,320.2,321.8,323.44,325.11,326.82,328.56,330.35,332.17,334.04,335.96,337.92,339.92,341.98,344.09,346.25,348.47,},
{22.57,24.913,27.195,29.419,31.586,33.699,35.76,37.771,39.733,41.65,43.522,45.351,47.139,48.888,50.598,52.271,53.908,55.511,57.081,58.618,60.125,61.602,63.05,64.47,65.863,67.23,68.571,69.889,71.182,72.452,73.701,74.928,76.134,77.319,78.486,79.633,80.762,81.873,82.967,84.044,85.105,86.15,87.18,88.195,89.196,90.182,91.155,92.115,93.062,93.997,94.92,95.831,96.731,97.62,98.498,99.366,100.22,101.07,101.91,102.74,103.56,104.37,105.17,105.97,106.76,107.54,108.31,109.07,109.83,110.58,111.33,112.07,112.8,113.53,114.25,114.96,115.67,116.37,117.07,117.77,118.46,119.14,119.82,120.5,121.17,121.84,122.51,123.17,123.82,124.48,125.13,125.78,126.42,127.07,127.71,128.34,128.98,129.61,130.24,130.87,131.49,132.12,132.74,133.36,133.98,134.6,135.21,135.83,136.44,137.06,137.67,138.28,138.89,139.5,140.11,140.72,141.33,141.93,142.54,143.15,143.75,144.36,144.97,145.58,146.18,146.79,147.4,148.01,148.62,149.23,149.84,150.45,151.06,151.67,152.28,152.89,153.51,154.12,154.74,155.36,155.98,156.59,157.21,157.84,158.46,159.08,159.71,160.33,160.96,161.59,162.22,162.85,163.48,164.12,164.75,165.39,166.03,166.67,167.31,167.95,168.6,169.24,169.89,170.54,171.18,171.84,172.49,173.14,173.79,174.45,175.1,175.76,176.42,177.08,177.74,178.4,179.06,179.73,180.39,181.06,181.72,182.39,183.05,183.72,184.39,185.05,185.72,186.39,187.06,187.73,188.39,189.06,189.73,190.4,191.07,191.73,192.4,193.07,193.73,194.4,195.06,195.73,196.39,197.05,197.71,198.38,199.03,199.69,200.35,201.01,201.66,202.32,202.97,203.62,204.27,204.92,205.57,206.22,206.86,207.51,208.15,208.79,209.43,210.07,210.71,211.34,211.98,212.61,213.24,213.87,214.5,215.13,215.76,216.38,217.01,217.63,218.25,218.87,219.49,220.11,220.73,221.34,221.96,222.57,223.19,223.8,224.41,225.02,225.64,226.25,226.85,227.46,228.07,228.68,229.29,229.9,230.5,231.11,231.72,232.33,232.93,233.54,234.15,234.76,235.36,235.97,236.58,237.19,237.8,238.42,239.03,239.64,240.26,240.88,241.49,242.11,242.73,243.35,243.98,244.6,245.23,245.86,246.49,247.13,247.76,248.4,249.05,249.69,250.34,250.99,251.64,252.3,252.96,253.62,254.29,254.96,255.64,256.32,257.0,257.69,258.39,259.08,259.79,260.5,261.21,261.93,262.65,263.39,264.12,264.87,265.62,266.37,267.14,267.91,268.69,269.47,270.27,271.07,271.88,272.7,273.52,274.36,275.21,276.06,276.93,277.8,278.69,279.59,280.5,281.42,282.35,283.29,284.25,285.22,286.21,287.2,288.22,289.24,290.28,291.34,292.42,293.51,294.61,295.74,296.88,298.05,299.23,300.43,301.65,302.9,304.16,305.45,306.76,308.1,309.46,310.85,312.26,313.71,315.18,316.68,318.21,319.77,321.37,323.0,324.67,326.37,328.11,329.89,331.71,333.57,335.48,337.44,339.44,341.49,343.59,345.75,},
{25.41,27.687,29.905,32.067,34.174,36.23,38.235,40.193,42.104,43.972,45.796,47.579,49.322,51.027,52.696,54.328,55.926,57.491,59.024,60.527,61.999,63.442,64.858,66.246,67.609,68.946,70.258,71.547,72.813,74.057,75.28,76.481,77.663,78.825,79.968,81.093,82.199,83.289,84.362,85.419,86.459,87.485,88.496,89.492,90.475,91.443,92.399,93.342,94.273,95.191,96.098,96.994,97.878,98.752,99.615,100.47,101.31,102.15,102.97,103.79,104.59,105.39,106.18,106.97,107.74,108.51,109.27,110.02,110.77,111.51,112.24,112.97,113.69,114.41,115.12,115.82,116.52,117.22,117.91,118.59,119.27,119.95,120.62,121.29,121.95,122.61,123.27,123.92,124.57,125.21,125.86,126.49,127.13,127.77,128.4,129.03,129.65,130.28,130.9,131.52,132.14,132.75,133.37,133.98,134.59,135.2,135.81,136.42,137.03,137.63,138.24,138.84,139.44,140.05,140.65,141.25,141.85,142.45,143.05,143.65,144.25,144.85,145.45,146.05,146.65,147.25,147.85,148.46,149.06,149.66,150.26,150.87,151.47,152.08,152.68,153.29,153.89,154.5,155.11,155.72,156.33,156.95,157.56,158.17,158.79,159.41,160.02,160.64,161.26,161.89,162.51,163.13,163.76,164.39,165.01,165.64,166.28,166.91,167.54,168.18,168.81,169.45,170.09,170.73,171.37,172.02,172.66,173.31,173.95,174.6,175.25,175.9,176.55,177.2,177.86,178.51,179.16,179.82,180.48,181.13,181.79,182.45,183.11,183.77,184.43,185.09,185.75,186.41,187.07,187.73,188.39,189.05,189.71,190.37,191.04,191.7,192.35,193.01,193.67,194.33,194.99,195.64,196.3,196.96,197.61,198.26,198.92,199.57,200.22,200.87,201.51,202.16,202.81,203.45,204.1,204.74,205.38,206.02,206.66,207.29,207.93,208.56,209.2,209.83,210.46,211.09,211.71,212.34,212.97,213.59,214.21,214.83,215.45,216.07,216.69,217.3,217.92,218.53,219.14,219.76,220.37,220.98,221.58,222.19,222.8,223.4,224.01,224.61,225.22,225.82,226.42,227.03,227.63,228.23,228.83,229.43,230.03,230.63,231.23,231.83,232.43,233.03,233.63,234.23,234.83,235.44,236.04,236.64,237.25,237.85,238.46,239.06,239.67,240.28,240.89,241.5,242.11,242.73,243.34,243.96,244.58,245.2,245.83,246.45,247.08,247.71,248.35,248.98,249.62,250.27,250.91,251.56,252.21,252.87,253.52,254.19,254.85,255.53,256.2,256.88,257.56,258.25,258.95,259.64,260.35,261.06,261.77,262.49,263.22,263.95,264.69,265.43,266.19,266.95,267.71,268.49,269.27,270.06,270.85,271.66,272.47,273.3,274.13,274.97,275.82,276.68,277.56,278.44,279.33,280.24,281.15,282.08,283.02,283.97,284.94,285.92,286.91,287.92,288.94,289.98,291.03,292.1,293.19,294.29,295.41,296.55,297.71,298.89,300.09,301.31,302.55,303.81,305.09,306.4,307.73,309.09,310.47,311.88,313.32,314.79,316.28,317.81,319.37,320.96,322.59,324.25,325.95,327.68,329.46,331.27,333.13,335.03,336.98,338.98,341.02,343.12,},
{28.147,30.361,32.517,34.62,36.671,38.672,40.625,42.532,44.395,46.215,47.993,49.732,51.433,53.097,54.725,56.319,57.88,59.409,60.907,62.375,63.814,65.225,66.61,67.968,69.301,70.61,71.895,73.157,74.397,75.615,76.813,77.99,79.148,80.287,81.408,82.511,83.596,84.665,85.718,86.755,87.776,88.783,89.775,90.754,91.719,92.67,93.609,94.536,95.45,96.353,97.245,98.125,98.995,99.854,100.7,101.54,102.37,103.19,104.01,104.81,105.6,106.39,107.17,107.94,108.7,109.46,110.21,110.95,111.69,112.41,113.14,113.85,114.57,115.27,115.97,116.67,117.36,118.04,118.72,119.4,120.07,120.73,121.4,122.05,122.71,123.36,124.01,124.65,125.29,125.93,126.56,127.19,127.82,128.45,129.07,129.69,130.31,130.93,131.54,132.16,132.77,133.38,133.98,134.59,135.19,135.8,136.4,137.0,137.6,138.2,138.79,139.39,139.99,140.58,141.18,141.77,142.37,142.96,143.55,144.15,144.74,145.33,145.93,146.52,147.11,147.71,148.3,148.9,149.49,150.09,150.68,151.28,151.88,152.47,153.07,153.67,154.27,154.87,155.48,156.08,156.68,157.29,157.9,158.5,159.11,159.72,160.33,160.95,161.56,162.17,162.79,163.41,164.03,164.65,165.27,165.89,166.52,167.14,167.77,168.4,169.03,169.66,170.29,170.92,171.56,172.19,172.83,173.47,174.11,174.75,175.39,176.03,176.68,177.32,177.97,178.62,179.26,179.91,180.56,181.21,181.86,182.51,183.17,183.82,184.47,185.12,185.78,186.43,187.08,187.74,188.39,189.04,189.7,190.35,191.0,191.66,192.31,192.96,193.61,194.26,194.91,195.56,196.21,196.86,197.51,198.15,198.8,199.44,200.09,200.73,201.37,202.01,202.65,203.29,203.92,204.56,205.19,205.82,206.45,207.08,207.71,208.34,208.97,209.59,210.21,210.84,211.46,212.08,212.69,213.31,213.93,214.54,215.15,215.76,216.37,216.98,217.59,218.2,218.8,219.41,220.01,220.61,221.22,221.82,222.42,223.02,223.61,224.21,224.81,225.41,226.0,226.6,227.19,227.79,228.38,228.97,229.57,230.16,230.75,231.35,231.94,232.53,233.13,233.72,234.32,234.91,235.51,236.1,236.7,237.3,237.9,238.49,239.09,239.7,240.3,240.9,241.51,242.12,242.72,243.34,243.95,244.56,245.18,245.8,246.42,247.04,247.67,248.29,248.93,249.56,250.2,250.84,251.48,252.13,252.78,253.43,254.09,254.75,255.42,256.09,256.76,257.44,258.12,258.81,259.51,260.2,260.91,261.62,262.34,263.06,263.79,264.52,265.26,266.01,266.76,267.52,268.29,269.07,269.86,270.65,271.45,272.26,273.08,273.91,274.75,275.59,276.45,277.32,278.2,279.09,279.99,280.9,281.82,282.76,283.71,284.67,285.65,286.64,287.64,288.66,289.69,290.74,291.81,292.89,293.99,295.11,296.24,297.4,298.57,299.76,300.98,302.21,303.47,304.75,306.05,307.38,308.74,310.11,311.52,312.95,314.42,315.91,317.43,318.99,320.57,322.2,323.85,325.55,327.28,329.05,330.86,332.71,334.61,336.56,338.55,340.59,},
{30.786,32.939,35.038,37.085,39.082,41.031,42.934,44.793,46.609,48.383,50.119,51.815,53.475,55.1,56.69,58.247,59.772,61.266,62.73,64.166,65.574,66.954,68.309,69.638,70.943,72.224,73.482,74.719,75.933,77.127,78.301,79.455,80.591,81.708,82.807,83.889,84.954,86.003,87.036,88.054,89.057,90.046,91.02,91.981,92.929,93.864,94.787,95.698,96.597,97.484,98.361,99.227,100.08,100.93,101.76,102.59,103.41,104.21,105.01,105.8,106.59,107.36,108.13,108.89,109.64,110.38,111.12,111.85,112.58,113.3,114.01,114.72,115.42,116.11,116.8,117.49,118.17,118.84,119.51,120.18,120.84,121.5,122.15,122.8,123.45,124.09,124.73,125.37,126.0,126.63,127.25,127.88,128.5,129.12,129.73,130.35,130.96,131.57,132.17,132.78,133.38,133.98,134.58,135.18,135.78,136.38,136.97,137.56,138.16,138.75,139.34,139.93,140.52,141.11,141.69,142.28,142.87,143.46,144.04,144.63,145.22,145.8,146.39,146.98,147.56,148.15,148.74,149.32,149.91,150.5,151.09,151.68,152.27,152.86,153.46,154.05,154.64,155.24,155.83,156.43,157.03,157.63,158.23,158.83,159.43,160.03,160.64,161.24,161.85,162.46,163.07,163.68,164.29,164.9,165.52,166.13,166.75,167.37,167.99,168.61,169.23,169.86,170.48,171.11,171.74,172.37,173.0,173.63,174.26,174.89,175.53,176.17,176.8,177.44,178.08,178.72,179.36,180.0,180.64,181.29,181.93,182.57,183.22,183.86,184.51,185.16,185.8,186.45,187.1,187.74,188.39,189.04,189.68,190.33,190.97,191.62,192.26,192.91,193.55,194.2,194.84,195.48,196.13,196.77,197.41,198.05,198.68,199.32,199.96,200.59,201.23,201.86,202.49,203.12,203.75,204.38,205.01,205.63,206.26,206.88,207.5,208.12,208.74,209.36,209.97,210.59,211.2,211.82,212.43,213.04,213.65,214.25,214.86,215.46,216.07,216.67,217.27,217.87,218.47,219.07,219.66,220.26,220.86,221.45,222.04,222.64,223.23,223.82,224.41,225.0,225.59,226.18,226.76,227.35,227.94,228.53,229.11,229.7,230.29,230.87,231.46,232.05,232.63,233.22,233.81,234.4,234.99,235.57,236.16,236.76,237.35,237.94,238.53,239.13,239.72,240.32,240.92,241.52,242.12,242.72,243.33,243.93,244.54,245.15,245.77,246.38,247.0,247.62,248.24,248.87,249.5,250.13,250.76,251.4,252.04,252.69,253.34,253.99,254.65,255.31,255.98,256.65,257.32,258.0,258.68,259.37,260.07,260.77,261.47,262.19,262.9,263.63,264.36,265.09,265.84,266.59,267.35,268.11,268.88,269.66,270.45,271.25,272.06,272.87,273.7,274.53,275.37,276.23,277.09,277.97,278.85,279.75,280.66,281.58,282.51,283.45,284.41,285.38,286.37,287.37,288.39,289.42,290.46,291.52,292.6,293.7,294.81,295.94,297.09,298.26,299.45,300.66,301.9,303.15,304.43,305.73,307.05,308.4,309.78,311.18,312.61,314.07,315.56,317.08,318.63,320.21,321.83,323.48,325.17,326.9,328.67,330.47,332.32,334.22,336.16,338.15,},
{33.333,35.428,37.472,39.465,41.411,43.311,45.166,46.978,48.75,50.481,52.175,53.831,55.453,57.039,58.593,60.115,61.605,63.066,64.498,65.903,67.28,68.631,69.957,71.258,72.536,73.791,75.024,76.235,77.426,78.596,79.747,80.879,81.993,83.088,84.167,85.229,86.274,87.304,88.318,89.318,90.303,91.274,92.232,93.176,94.108,95.027,95.934,96.829,97.713,98.586,99.449,100.3,101.14,101.97,102.8,103.61,104.41,105.21,106.0,106.77,107.54,108.31,109.06,109.81,110.55,111.29,112.01,112.73,113.45,114.16,114.86,115.56,116.25,116.93,117.62,118.29,118.96,119.63,120.29,120.95,121.6,122.25,122.89,123.54,124.17,124.81,125.44,126.07,126.69,127.31,127.93,128.55,129.16,129.77,130.38,130.98,131.59,132.19,132.79,133.39,133.98,134.58,135.17,135.76,136.35,136.94,137.53,138.12,138.7,139.29,139.87,140.45,141.04,141.62,142.2,142.78,143.36,143.94,144.52,145.1,145.68,146.26,146.84,147.42,148.0,148.58,149.16,149.75,150.33,150.91,151.49,152.08,152.66,153.25,153.83,154.42,155.0,155.59,156.18,156.77,157.36,157.96,158.55,159.14,159.74,160.34,160.93,161.53,162.13,162.73,163.34,163.94,164.55,165.15,165.76,166.37,166.98,167.59,168.21,168.82,169.44,170.06,170.67,171.29,171.91,172.54,173.16,173.78,174.41,175.04,175.67,176.29,176.93,177.56,178.19,178.82,179.46,180.09,180.73,181.36,182.0,182.64,183.27,183.91,184.55,185.19,185.83,186.47,187.11,187.75,188.39,189.03,189.67,190.31,190.94,191.58,192.22,192.86,193.5,194.13,194.77,195.41,196.04,196.67,197.31,197.94,198.57,199.2,199.83,200.46,201.09,201.71,202.34,202.96,203.58,204.21,204.83,205.44,206.06,206.68,207.29,207.91,208.52,209.13,209.74,210.35,210.96,211.56,212.17,212.77,213.37,213.97,214.57,215.17,215.77,216.36,216.96,217.55,218.14,218.73,219.33,219.91,220.5,221.09,221.68,222.26,222.85,223.43,224.02,224.6,225.18,225.77,226.35,226.93,227.51,228.09,228.67,229.25,229.83,230.41,230.99,231.57,232.15,232.73,233.31,233.89,234.48,235.06,235.64,236.23,236.81,237.4,237.98,238.57,239.16,239.75,240.34,240.93,241.53,242.12,242.72,243.32,243.92,244.52,245.13,245.74,246.35,246.96,247.58,248.19,248.82,249.44,250.07,250.7,251.33,251.97,252.61,253.25,253.9,254.55,255.21,255.87,256.54,257.21,257.88,258.56,259.25,259.94,260.63,261.33,262.04,262.76,263.48,264.2,264.93,265.67,266.42,267.17,267.94,268.7,269.48,270.27,271.06,271.86,272.67,273.49,274.32,275.16,276.01,276.87,277.75,278.63,279.52,280.43,281.34,282.27,283.21,284.17,285.14,286.12,287.12,288.13,289.15,290.2,291.25,292.33,293.42,294.53,295.66,296.81,297.97,299.16,300.37,301.6,302.85,304.12,305.42,306.74,308.09,309.46,310.86,312.28,313.74,315.22,316.74,318.29,319.87,321.48,323.13,324.82,326.54,328.31,330.11,331.96,333.85,335.79,},
{35.791,37.832,39.822,41.765,43.662,45.514,47.324,49.093,50.821,52.512,54.166,55.784,57.368,58.918,60.437,61.925,63.383,64.812,66.213,67.587,68.935,70.258,71.557,72.832,74.083,75.313,76.521,77.709,78.876,80.024,81.153,82.263,83.356,84.431,85.49,86.532,87.558,88.57,89.566,90.548,91.516,92.47,93.411,94.34,95.255,96.159,97.051,97.932,98.801,99.66,100.51,101.35,102.18,102.99,103.8,104.6,105.4,106.18,106.95,107.72,108.48,109.23,109.98,110.71,111.44,112.17,112.88,113.59,114.3,115.0,115.69,116.38,117.06,117.74,118.41,119.07,119.74,120.39,121.05,121.7,122.34,122.98,123.62,124.25,124.88,125.51,126.13,126.75,127.37,127.98,128.59,129.2,129.81,130.41,131.01,131.61,132.21,132.8,133.39,133.98,134.57,135.16,135.75,136.33,136.91,137.5,138.08,138.66,139.24,139.81,140.39,140.97,141.54,142.12,142.69,143.27,143.84,144.42,144.99,145.56,146.14,146.71,147.29,147.86,148.43,149.01,149.58,150.16,150.73,151.31,151.89,152.46,153.04,153.62,154.2,154.78,155.36,155.94,156.52,157.11,157.69,158.28,158.87,159.45,160.04,160.63,161.22,161.82,162.41,163.01,163.6,164.2,164.8,165.4,166.0,166.6,167.21,167.81,168.42,169.03,169.64,170.25,170.86,171.47,172.09,172.7,173.32,173.94,174.56,175.18,175.8,176.42,177.04,177.67,178.29,178.92,179.55,180.18,180.8,181.43,182.06,182.69,183.33,183.96,184.59,185.22,185.85,186.49,187.12,187.75,188.38,189.02,189.65,190.28,190.92,191.55,192.18,192.81,193.44,194.07,194.7,195.33,195.96,196.58,197.21,197.84,198.46,199.08,199.71,200.33,200.95,201.57,202.19,202.8,203.42,204.03,204.65,205.26,205.87,206.48,207.09,207.7,208.3,208.91,209.51,210.11,210.71,211.31,211.91,212.51,213.1,213.7,214.29,214.88,215.47,216.06,216.65,217.24,217.82,218.41,218.99,219.58,220.16,220.74,221.32,221.9,222.48,223.06,223.63,224.21,224.79,225.36,225.94,226.51,227.09,227.66,228.24,228.81,229.38,229.96,230.53,231.1,231.68,232.25,232.83,233.4,233.98,234.55,235.13,235.71,236.28,236.86,237.44,238.02,238.61,239.19,239.77,240.36,240.95,241.54,242.13,242.72,243.31,243.91,244.51,245.11,245.71,246.32,246.93,247.54,248.15,248.77,249.38,250.01,250.63,251.26,251.89,252.53,253.17,253.81,254.46,255.11,255.77,256.43,257.1,257.77,258.45,259.13,259.81,260.5,261.2,261.91,262.62,263.33,264.05,264.78,265.52,266.26,267.01,267.77,268.53,269.31,270.09,270.88,271.68,272.49,273.3,274.13,274.97,275.81,276.67,277.54,278.41,279.3,280.21,281.12,282.05,282.98,283.94,284.9,285.88,286.87,287.88,288.91,289.94,291.0,292.07,293.16,294.27,295.39,296.54,297.7,298.88,300.09,301.31,302.56,303.83,305.13,306.44,307.79,309.16,310.55,311.98,313.43,314.91,316.42,317.97,319.55,321.16,322.8,324.49,326.21,327.97,329.77,331.62,333.51,},
{38.165,40.154,42.095,43.989,45.839,47.647,49.413,51.139,52.827,54.478,56.094,57.675,59.223,60.739,62.225,63.68,65.107,66.505,67.877,69.222,70.542,71.838,73.11,74.359,75.586,76.792,77.976,79.141,80.286,81.412,82.519,83.609,84.682,85.737,86.777,87.8,88.808,89.802,90.781,91.745,92.697,93.635,94.56,95.473,96.373,97.262,98.14,99.006,99.862,100.71,101.54,102.37,103.18,103.99,104.79,105.57,106.35,107.13,107.89,108.64,109.39,110.13,110.87,111.59,112.31,113.03,113.73,114.43,115.13,115.82,116.5,117.18,117.85,118.52,119.18,119.84,120.49,121.14,121.79,122.43,123.06,123.7,124.33,124.95,125.57,126.19,126.81,127.42,128.03,128.63,129.24,129.84,130.44,131.03,131.63,132.22,132.81,133.4,133.98,134.57,135.15,135.73,136.31,136.89,137.46,138.04,138.61,139.19,139.76,140.33,140.9,141.47,142.04,142.61,143.18,143.75,144.31,144.88,145.45,146.02,146.58,147.15,147.72,148.29,148.85,149.42,149.99,150.56,151.13,151.7,152.27,152.84,153.41,153.99,154.56,155.13,155.71,156.28,156.86,157.44,158.02,158.6,159.18,159.76,160.34,160.92,161.51,162.1,162.68,163.27,163.86,164.45,165.05,165.64,166.24,166.83,167.43,168.03,168.63,169.23,169.83,170.44,171.04,171.65,172.26,172.87,173.48,174.09,174.7,175.32,175.93,176.55,177.16,177.78,178.4,179.02,179.64,180.26,180.88,181.51,182.13,182.75,183.38,184.0,184.63,185.25,185.88,186.5,187.13,187.76,188.38,189.01,189.64,190.26,190.89,191.51,192.14,192.76,193.39,194.01,194.63,195.25,195.88,196.5,197.12,197.73,198.35,198.97,199.59,200.2,200.81,201.43,202.04,202.65,203.26,203.87,204.47,205.08,205.68,206.29,206.89,207.49,208.09,208.69,209.28,209.88,210.47,211.07,211.66,212.25,212.84,213.43,214.01,214.6,215.18,215.77,216.35,216.93,217.51,218.09,218.67,219.24,219.82,220.39,220.97,221.54,222.11,222.69,223.26,223.83,224.4,224.97,225.54,226.11,226.67,227.24,227.81,228.38,228.95,229.51,230.08,230.65,231.22,231.78,232.35,232.92,233.49,234.06,234.63,235.2,235.77,236.34,236.92,237.49,238.07,238.64,239.22,239.8,240.38,240.96,241.55,242.13,242.72,243.31,243.9,244.49,245.09,245.69,246.29,246.89,247.5,248.11,248.72,249.33,249.95,250.57,251.2,251.82,252.46,253.09,253.73,254.38,255.02,255.68,256.33,257.0,257.66,258.33,259.01,259.69,260.38,261.08,261.78,262.48,263.19,263.91,264.64,265.37,266.11,266.86,267.61,268.37,269.14,269.92,270.71,271.5,272.31,273.12,273.94,274.78,275.62,276.47,277.34,278.21,279.1,280.0,280.91,281.83,282.77,283.71,284.68,285.65,286.64,287.65,288.67,289.71,290.76,291.83,292.91,294.02,295.14,296.28,297.44,298.62,299.82,301.05,302.29,303.56,304.85,306.17,307.51,308.87,310.27,311.69,313.14,314.62,316.13,317.67,319.25,320.85,322.5,324.18,325.9,327.66,329.46,331.3,},
{40.461,42.4,44.292,46.141,47.946,49.71,51.435,53.121,54.77,56.383,57.963,59.509,61.023,62.506,63.959,65.383,66.779,68.148,69.492,70.809,72.103,73.373,74.619,75.844,77.047,78.229,79.391,80.533,81.657,82.762,83.849,84.919,85.971,87.008,88.029,89.035,90.025,91.001,91.963,92.912,93.847,94.769,95.679,96.577,97.463,98.337,99.201,100.05,100.9,101.73,102.55,103.36,104.16,104.96,105.74,106.52,107.29,108.05,108.8,109.55,110.28,111.01,111.74,112.45,113.16,113.87,114.56,115.25,115.94,116.62,117.29,117.96,118.63,119.29,119.94,120.59,121.23,121.87,122.51,123.14,123.77,124.4,125.02,125.64,126.25,126.86,127.47,128.07,128.67,129.27,129.87,130.46,131.06,131.64,132.23,132.82,133.4,133.98,134.56,135.14,135.71,136.29,136.86,137.43,138.0,138.57,139.14,139.71,140.27,140.84,141.4,141.96,142.53,143.09,143.65,144.22,144.78,145.34,145.9,146.46,147.02,147.58,148.15,148.71,149.27,149.83,150.39,150.96,151.52,152.08,152.65,153.21,153.78,154.34,154.91,155.48,156.05,156.62,157.19,157.76,158.33,158.91,159.48,160.06,160.63,161.21,161.79,162.37,162.95,163.53,164.12,164.7,165.29,165.88,166.47,167.06,167.65,168.24,168.83,169.43,170.03,170.62,171.22,171.82,172.42,173.03,173.63,174.24,174.84,175.45,176.06,176.67,177.28,177.89,178.5,179.11,179.73,180.34,180.96,181.57,182.19,182.81,183.43,184.05,184.66,185.28,185.9,186.52,187.14,187.76,188.38,189.0,189.62,190.24,190.86,191.48,192.1,192.71,193.33,193.95,194.56,195.18,195.79,196.41,197.02,197.63,198.25,198.86,199.47,200.08,200.68,201.29,201.89,202.5,203.1,203.7,204.3,204.9,205.5,206.1,206.69,207.29,207.88,208.47,209.06,209.65,210.24,210.83,211.41,212.0,212.58,213.16,213.74,214.32,214.9,215.48,216.05,216.63,217.2,217.77,218.35,218.92,219.49,220.06,220.62,221.19,221.76,222.32,222.89,223.45,224.02,224.58,225.14,225.71,226.27,226.83,227.39,227.95,228.52,229.08,229.64,230.2,230.76,231.32,231.89,232.45,233.01,233.57,234.14,234.7,235.27,235.83,236.4,236.97,237.54,238.11,238.68,239.25,239.83,240.4,240.98,241.56,242.14,242.72,243.3,243.89,244.48,245.07,245.66,246.26,246.86,247.46,248.07,248.67,249.28,249.9,250.51,251.13,251.76,252.39,253.02,253.65,254.29,254.94,255.59,256.24,256.9,257.56,258.23,258.9,259.58,260.26,260.96,261.65,262.35,263.06,263.78,264.5,265.23,265.96,266.71,267.46,268.22,268.98,269.76,270.54,271.33,272.14,272.95,273.77,274.6,275.44,276.29,277.15,278.02,278.9,279.8,280.71,281.63,282.56,283.51,284.46,285.44,286.43,287.43,288.45,289.48,290.53,291.6,292.68,293.78,294.9,296.04,297.2,298.38,299.58,300.8,302.04,303.3,304.59,305.91,307.25,308.61,310.0,311.42,312.87,314.34,315.85,317.39,318.97,320.57,322.22,323.89,325.61,327.37,329.17,},
{42.681,44.572,46.419,48.223,49.986,51.709,53.393,55.041,56.653,58.23,59.775,61.287,62.768,64.219,65.641,67.036,68.403,69.744,71.06,72.351,73.619,74.864,76.086,77.287,78.467,79.626,80.766,81.887,82.99,84.075,85.142,86.193,87.227,88.245,89.248,90.237,91.21,92.17,93.115,94.048,94.968,95.875,96.77,97.653,98.525,99.385,100.24,101.07,101.9,102.72,103.53,104.33,105.12,105.9,106.68,107.44,108.2,108.95,109.69,110.43,111.15,111.87,112.59,113.29,113.99,114.69,115.37,116.06,116.73,117.4,118.07,118.73,119.38,120.03,120.68,121.32,121.96,122.59,123.22,123.84,124.46,125.08,125.69,126.3,126.91,127.51,128.12,128.71,129.31,129.9,130.49,131.08,131.66,132.24,132.82,133.4,133.98,134.55,135.12,135.69,136.26,136.83,137.4,137.96,138.53,139.09,139.65,140.21,140.77,141.33,141.89,142.45,143.01,143.56,144.12,144.67,145.23,145.79,146.34,146.9,147.45,148.01,148.56,149.12,149.67,150.23,150.79,151.34,151.9,152.46,153.02,153.58,154.14,154.7,155.26,155.82,156.38,156.95,157.51,158.08,158.64,159.21,159.78,160.35,160.92,161.49,162.06,162.64,163.21,163.79,164.37,164.95,165.53,166.11,166.69,167.28,167.86,168.45,169.04,169.62,170.21,170.81,171.4,171.99,172.59,173.18,173.78,174.38,174.98,175.58,176.18,176.79,177.39,178.0,178.6,179.21,179.82,180.42,181.03,181.64,182.25,182.86,183.48,184.09,184.7,185.31,185.93,186.54,187.15,187.77,188.38,188.99,189.61,190.22,190.83,191.44,192.06,192.67,193.28,193.89,194.5,195.11,195.72,196.32,196.93,197.54,198.14,198.75,199.35,199.95,200.55,201.15,201.75,202.35,202.95,203.54,204.14,204.73,205.32,205.91,206.5,207.09,207.68,208.26,208.85,209.43,210.01,210.59,211.17,211.75,212.33,212.9,213.48,214.05,214.62,215.19,215.76,216.33,216.9,217.47,218.03,218.6,219.16,219.72,220.29,220.85,221.41,221.97,222.53,223.09,223.65,224.2,224.76,225.32,225.87,226.43,226.98,227.54,228.1,228.65,229.21,229.76,230.32,230.87,231.43,231.99,232.54,233.1,233.66,234.22,234.78,235.33,235.9,236.46,237.02,237.58,238.15,238.71,239.28,239.85,240.42,240.99,241.57,242.14,242.72,243.3,243.88,244.47,245.05,245.64,246.24,246.83,247.43,248.03,248.63,249.24,249.85,250.46,251.07,251.7,252.32,252.95,253.58,254.21,254.86,255.5,256.15,256.8,257.46,258.13,258.8,259.47,260.15,260.84,261.53,262.23,262.94,263.65,264.37,265.09,265.83,266.57,267.31,268.07,268.83,269.6,270.39,271.17,271.97,272.78,273.6,274.43,275.26,276.11,276.97,277.84,278.72,279.61,280.52,281.43,282.36,283.31,284.26,285.24,286.22,287.22,288.24,289.27,290.32,291.38,292.46,293.56,294.68,295.81,296.97,298.15,299.34,300.56,301.8,303.07,304.35,305.66,307.0,308.36,309.75,311.17,312.61,314.09,315.6,317.13,318.71,320.31,321.95,323.63,325.35,327.1,},
{44.829,46.675,48.478,50.24,51.962,53.645,55.292,56.902,58.478,60.021,61.532,63.012,64.462,65.882,67.275,68.641,69.98,71.294,72.584,73.85,75.092,76.313,77.512,78.69,79.848,80.986,82.105,83.205,84.288,85.353,86.401,87.433,88.45,89.45,90.436,91.407,92.365,93.308,94.238,95.155,96.06,96.953,97.833,98.702,99.56,100.41,101.24,102.07,102.89,103.69,104.49,105.28,106.06,106.83,107.59,108.35,109.09,109.83,110.56,111.28,112.0,112.71,113.41,114.11,114.8,115.49,116.17,116.84,117.51,118.17,118.82,119.48,120.12,120.77,121.4,122.04,122.66,123.29,123.91,124.53,125.14,125.75,126.36,126.96,127.56,128.15,128.75,129.34,129.93,130.51,131.09,131.67,132.25,132.83,133.4,133.97,134.54,135.11,135.68,136.24,136.8,137.37,137.93,138.48,139.04,139.6,140.16,140.71,141.26,141.82,142.37,142.92,143.47,144.02,144.57,145.12,145.67,146.22,146.77,147.32,147.87,148.42,148.97,149.52,150.07,150.62,151.17,151.72,152.27,152.83,153.38,153.93,154.49,155.04,155.6,156.15,156.71,157.27,157.83,158.39,158.95,159.51,160.07,160.64,161.2,161.77,162.33,162.9,163.47,164.04,164.61,165.19,165.76,166.34,166.91,167.49,168.07,168.65,169.23,169.82,170.4,170.99,171.57,172.16,172.75,173.34,173.93,174.52,175.12,175.71,176.31,176.9,177.5,178.1,178.7,179.3,179.9,180.5,181.11,181.71,182.31,182.92,183.52,184.13,184.74,185.34,185.95,186.56,187.16,187.77,188.38,188.98,189.59,190.2,190.8,191.41,192.02,192.62,193.23,193.83,194.43,195.04,195.64,196.24,196.84,197.44,198.04,198.64,199.24,199.83,200.43,201.02,201.61,202.2,202.8,203.38,203.97,204.56,205.15,205.73,206.31,206.9,207.48,208.06,208.63,209.21,209.79,210.36,210.94,211.51,212.08,212.65,213.22,213.78,214.35,214.92,215.48,216.04,216.6,217.17,217.73,218.28,218.84,219.4,219.96,220.51,221.07,221.62,222.17,222.73,223.28,223.83,224.38,224.93,225.48,226.03,226.58,227.13,227.68,228.23,228.78,229.33,229.88,230.43,230.98,231.53,232.08,232.64,233.19,233.74,234.29,234.85,235.4,235.96,236.51,237.07,237.63,238.19,238.75,239.31,239.88,240.44,241.01,241.58,242.15,242.73,243.3,243.88,244.46,245.04,245.63,246.21,246.8,247.4,247.99,248.59,249.19,249.8,250.41,251.02,251.64,252.26,252.88,253.51,254.14,254.78,255.42,256.06,256.72,257.37,258.03,258.7,259.37,260.05,260.73,261.42,262.12,262.82,263.53,264.24,264.97,265.7,266.43,267.18,267.93,268.69,269.46,270.24,271.02,271.82,272.62,273.44,274.26,275.1,275.94,276.8,277.67,278.54,279.43,280.34,281.25,282.18,283.12,284.08,285.04,286.03,287.03,288.04,289.07,290.11,291.17,292.25,293.35,294.47,295.6,296.76,297.93,299.12,300.34,301.58,302.84,304.13,305.44,306.77,308.13,309.52,310.93,312.38,313.85,315.36,316.9,318.47,320.07,321.71,323.39,325.1,},
{46.909,48.711,50.473,52.194,53.877,55.522,57.132,58.707,60.249,61.759,63.238,64.686,66.106,67.497,68.862,70.2,71.513,72.801,74.065,75.306,76.525,77.722,78.899,80.055,81.191,82.308,83.407,84.488,85.551,86.598,87.628,88.642,89.641,90.624,91.593,92.548,93.49,94.418,95.333,96.235,97.125,98.004,98.87,99.726,100.57,101.4,102.23,103.04,103.85,104.64,105.43,106.2,106.97,107.73,108.48,109.23,109.96,110.69,111.41,112.12,112.83,113.53,114.23,114.91,115.59,116.27,116.94,117.6,118.26,118.92,119.56,120.21,120.85,121.48,122.11,122.74,123.36,123.97,124.59,125.2,125.8,126.4,127.0,127.6,128.19,128.78,129.37,129.95,130.53,131.11,131.69,132.26,132.83,133.4,133.97,134.53,135.1,135.66,136.22,136.78,137.33,137.89,138.44,139.0,139.55,140.1,140.65,141.2,141.74,142.29,142.84,143.38,143.93,144.48,145.02,145.56,146.11,146.65,147.2,147.74,148.28,148.83,149.37,149.92,150.46,151.0,151.55,152.1,152.64,153.19,153.73,154.28,154.83,155.38,155.93,156.48,157.03,157.58,158.14,158.69,159.25,159.8,160.36,160.92,161.48,162.04,162.6,163.16,163.72,164.29,164.85,165.42,165.99,166.56,167.13,167.7,168.28,168.85,169.43,170.0,170.58,171.16,171.74,172.32,172.91,173.49,174.08,174.66,175.25,175.84,176.43,177.02,177.61,178.2,178.8,179.39,179.99,180.58,181.18,181.78,182.37,182.97,183.57,184.17,184.77,185.37,185.97,186.57,187.17,187.77,188.38,188.98,189.58,190.18,190.78,191.38,191.98,192.58,193.17,193.77,194.37,194.97,195.56,196.16,196.75,197.35,197.94,198.53,199.12,199.71,200.3,200.89,201.48,202.06,202.65,203.23,203.81,204.39,204.97,205.55,206.13,206.7,207.28,207.85,208.43,209.0,209.57,210.14,210.7,211.27,211.83,212.4,212.96,213.52,214.08,214.64,215.2,215.76,216.31,216.87,217.42,217.98,218.53,219.08,219.63,220.18,220.73,221.28,221.83,222.37,222.92,223.47,224.01,224.56,225.1,225.65,226.19,226.74,227.28,227.82,228.37,228.91,229.46,230.0,230.54,231.09,231.63,232.18,232.73,233.27,233.82,234.37,234.92,235.47,236.02,236.57,237.12,237.67,238.23,238.79,239.34,239.9,240.47,241.03,241.59,242.16,242.73,243.3,243.87,244.45,245.03,245.61,246.19,246.78,247.37,247.96,248.55,249.15,249.75,250.36,250.97,251.58,252.2,252.82,253.44,254.07,254.7,255.34,255.98,256.63,257.28,257.94,258.61,259.27,259.95,260.63,261.32,262.01,262.71,263.41,264.13,264.85,265.57,266.31,267.05,267.8,268.56,269.32,270.1,270.88,271.67,272.48,273.29,274.11,274.94,275.79,276.64,277.5,278.38,279.27,280.17,281.08,282.01,282.95,283.9,284.86,285.85,286.84,287.85,288.88,289.92,290.98,292.06,293.16,294.27,295.4,296.55,297.73,298.92,300.14,301.37,302.63,303.92,305.22,306.56,307.92,309.3,310.72,312.16,313.63,315.14,316.67,318.24,319.85,321.49,323.16,},
{48.923,50.684,52.405,54.088,55.733,57.343,58.918,60.459,61.968,63.446,64.894,66.313,67.703,69.067,70.404,71.715,73.002,74.265,75.505,76.723,77.919,79.094,80.248,81.383,82.499,83.596,84.675,85.737,86.781,87.81,88.822,89.819,90.801,91.768,92.721,93.661,94.587,95.5,96.4,97.288,98.164,99.029,99.882,100.72,101.56,102.38,103.19,103.99,104.78,105.57,106.34,107.11,107.86,108.61,109.35,110.09,110.81,111.53,112.24,112.94,113.64,114.33,115.02,115.7,116.37,117.03,117.7,118.35,119.0,119.65,120.29,120.92,121.55,122.18,122.8,123.42,124.03,124.64,125.25,125.85,126.45,127.05,127.64,128.23,128.81,129.39,129.97,130.55,131.13,131.7,132.27,132.83,133.4,133.96,134.52,135.08,135.64,136.19,136.75,137.3,137.85,138.4,138.95,139.5,140.04,140.59,141.13,141.67,142.22,142.76,143.3,143.84,144.38,144.92,145.46,146.0,146.53,147.07,147.61,148.15,148.69,149.23,149.76,150.3,150.84,151.38,151.92,152.46,153.0,153.54,154.08,154.63,155.17,155.71,156.26,156.8,157.35,157.89,158.44,158.99,159.54,160.09,160.64,161.19,161.75,162.3,162.86,163.41,163.97,164.53,165.09,165.65,166.21,166.78,167.34,167.91,168.48,169.05,169.62,170.19,170.76,171.33,171.91,172.48,173.06,173.64,174.22,174.8,175.38,175.96,176.55,177.13,177.72,178.3,178.89,179.48,180.07,180.66,181.25,181.84,182.43,183.03,183.62,184.21,184.81,185.4,185.99,186.59,187.18,187.78,188.37,188.97,189.56,190.16,190.75,191.35,191.94,192.53,193.12,193.72,194.31,194.9,195.49,196.08,196.67,197.25,197.84,198.43,199.01,199.6,200.18,200.76,201.34,201.92,202.5,203.08,203.65,204.23,204.8,205.38,205.95,206.52,207.09,207.65,208.22,208.79,209.35,209.91,210.48,211.04,211.6,212.15,212.71,213.27,213.82,214.37,214.93,215.48,216.03,216.58,217.13,217.68,218.22,218.77,219.31,219.86,220.4,220.94,221.49,222.03,222.57,223.11,223.65,224.19,224.73,225.27,225.81,226.35,226.88,227.42,227.96,228.5,229.04,229.58,230.12,230.65,231.19,231.73,232.27,232.81,233.36,233.9,234.44,234.99,235.53,236.08,236.62,237.17,237.72,238.27,238.82,239.38,239.93,240.49,241.05,241.61,242.17,242.74,243.3,243.87,244.44,245.02,245.59,246.17,246.76,247.34,247.93,248.52,249.11,249.71,250.31,250.92,251.53,252.14,252.76,253.38,254.01,254.64,255.27,255.91,256.55,257.2,257.86,258.52,259.18,259.85,260.53,261.22,261.91,262.6,263.3,264.01,264.73,265.46,266.19,266.93,267.67,268.43,269.19,269.97,270.75,271.54,272.34,273.15,273.97,274.8,275.64,276.49,277.35,278.23,279.11,280.01,280.92,281.84,282.78,283.73,284.7,285.67,286.67,287.68,288.7,289.75,290.8,291.88,292.97,294.09,295.22,296.37,297.54,298.73,299.95,301.18,302.44,303.72,305.03,306.36,307.72,309.11,310.52,311.96,313.43,314.94,316.47,318.04,319.65,321.28,},
{50.876,52.597,54.28,55.925,57.535,59.109,60.65,62.159,63.637,65.084,66.502,67.892,69.255,70.591,71.902,73.188,74.45,75.689,76.906,78.101,79.275,80.428,81.562,82.676,83.772,84.85,85.91,86.953,87.98,88.991,89.986,90.966,91.932,92.883,93.821,94.745,95.656,96.555,97.441,98.315,99.178,100.03,100.87,101.7,102.52,103.33,104.13,104.92,105.7,106.47,107.23,107.99,108.73,109.47,110.2,110.93,111.64,112.35,113.05,113.75,114.43,115.12,115.79,116.46,117.13,117.78,118.44,119.08,119.73,120.36,121.0,121.62,122.25,122.86,123.48,124.09,124.7,125.3,125.9,126.49,127.08,127.67,128.26,128.84,129.42,129.99,130.57,131.14,131.71,132.27,132.84,133.4,133.95,134.51,135.07,135.62,136.17,136.72,137.27,137.81,138.36,138.9,139.45,139.99,140.53,141.07,141.6,142.14,142.68,143.21,143.75,144.28,144.82,145.35,145.89,146.42,146.95,147.49,148.02,148.55,149.08,149.62,150.15,150.68,151.22,151.75,152.28,152.82,153.35,153.89,154.43,154.96,155.5,156.04,156.58,157.12,157.66,158.2,158.74,159.28,159.83,160.37,160.92,161.46,162.01,162.56,163.11,163.66,164.21,164.77,165.32,165.88,166.44,166.99,167.55,168.11,168.68,169.24,169.8,170.37,170.93,171.5,172.07,172.64,173.21,173.79,174.36,174.93,175.51,176.09,176.66,177.24,177.82,178.4,178.99,179.57,180.15,180.74,181.32,181.91,182.49,183.08,183.67,184.25,184.84,185.43,186.02,186.61,187.19,187.78,188.37,188.96,189.55,190.14,190.73,191.31,191.9,192.49,193.07,193.66,194.25,194.83,195.42,196.0,196.58,197.16,197.74,198.32,198.9,199.48,200.06,200.63,201.21,201.78,202.36,202.93,203.5,204.07,204.64,205.2,205.77,206.33,206.9,207.46,208.02,208.58,209.14,209.7,210.25,210.81,211.36,211.91,212.46,213.01,213.56,214.11,214.66,215.21,215.75,216.29,216.84,217.38,217.92,218.46,219.0,219.54,220.08,220.62,221.15,221.69,222.23,222.76,223.3,223.83,224.36,224.9,225.43,225.96,226.5,227.03,227.56,228.09,228.63,229.16,229.69,230.23,230.76,231.3,231.83,232.37,232.9,233.44,233.98,234.51,235.05,235.59,236.13,236.68,237.22,237.76,238.31,238.86,239.41,239.96,240.51,241.07,241.62,242.18,242.74,243.3,243.87,244.44,245.01,245.58,246.16,246.73,247.32,247.9,248.49,249.08,249.67,250.27,250.87,251.48,252.09,252.7,253.32,253.94,254.57,255.2,255.84,256.48,257.13,257.78,258.44,259.1,259.77,260.44,261.12,261.81,262.5,263.2,263.91,264.62,265.35,266.07,266.81,267.56,268.31,269.07,269.84,270.62,271.41,272.21,273.01,273.83,274.66,275.5,276.35,277.21,278.08,278.96,279.86,280.77,281.69,282.63,283.57,284.54,285.52,286.51,287.52,288.54,289.58,290.64,291.71,292.8,293.92,295.05,296.2,297.37,298.56,299.77,301.0,302.26,303.54,304.85,306.18,307.54,308.92,310.34,311.78,313.25,314.75,316.29,317.86,319.46,},
{52.769,54.452,56.098,57.708,59.283,60.824,62.333,63.811,65.258,66.676,68.066,69.428,70.764,72.074,73.36,74.621,75.859,77.075,78.269,79.442,80.595,81.727,82.841,83.935,85.012,86.071,87.113,88.139,89.148,90.142,91.121,92.085,93.035,93.971,94.893,95.803,96.7,97.584,98.457,99.317,100.17,101.01,101.83,102.65,103.46,104.26,105.04,105.82,106.59,107.35,108.1,108.85,109.59,110.31,111.03,111.75,112.45,113.15,113.84,114.53,115.21,115.88,116.55,117.21,117.87,118.52,119.16,119.8,120.43,121.06,121.69,122.31,122.92,123.53,124.14,124.74,125.34,125.94,126.53,127.12,127.7,128.29,128.86,129.44,130.01,130.58,131.15,131.71,132.28,132.83,133.39,133.95,134.5,135.05,135.6,136.15,136.69,137.24,137.78,138.32,138.86,139.4,139.93,140.47,141.0,141.54,142.07,142.6,143.13,143.66,144.19,144.72,145.25,145.78,146.31,146.83,147.36,147.89,148.42,148.94,149.47,150.0,150.53,151.06,151.58,152.11,152.64,153.17,153.7,154.23,154.76,155.29,155.82,156.36,156.89,157.42,157.96,158.5,159.03,159.57,160.11,160.65,161.19,161.73,162.27,162.82,163.36,163.91,164.45,165.0,165.55,166.1,166.65,167.2,167.76,168.31,168.87,169.43,169.99,170.55,171.11,171.67,172.23,172.8,173.36,173.93,174.5,175.07,175.64,176.21,176.78,177.35,177.93,178.5,179.08,179.65,180.23,180.81,181.39,181.97,182.55,183.13,183.71,184.29,184.87,185.46,186.04,186.62,187.2,187.79,188.37,188.95,189.54,190.12,190.7,191.28,191.86,192.45,193.03,193.61,194.19,194.77,195.34,195.92,196.5,197.07,197.65,198.22,198.8,199.37,199.94,200.51,201.08,201.65,202.22,202.78,203.35,203.91,204.47,205.03,205.59,206.15,206.71,207.27,207.82,208.38,208.93,209.48,210.03,210.58,211.13,211.68,212.22,212.77,213.31,213.85,214.4,214.94,215.48,216.01,216.55,217.09,217.63,218.16,218.7,219.23,219.76,220.29,220.83,221.36,221.89,222.42,222.95,223.48,224.0,224.53,225.06,225.59,226.12,226.64,227.17,227.7,228.23,228.75,229.28,229.81,230.34,230.87,231.4,231.93,232.46,232.99,233.52,234.05,234.59,235.12,235.66,236.19,236.73,237.27,237.81,238.35,238.89,239.44,239.99,240.54,241.09,241.64,242.19,242.75,243.31,243.87,244.43,245.0,245.57,246.14,246.72,247.29,247.88,248.46,249.05,249.64,250.23,250.83,251.43,252.04,252.65,253.27,253.89,254.51,255.14,255.77,256.41,257.05,257.7,258.36,259.02,259.68,260.36,261.03,261.72,262.41,263.11,263.81,264.52,265.24,265.97,266.7,267.45,268.2,268.96,269.72,270.5,271.29,272.08,272.89,273.71,274.53,275.37,276.22,277.07,277.94,278.83,279.72,280.63,281.55,282.48,283.43,284.39,285.37,286.36,287.36,288.39,289.43,290.48,291.56,292.65,293.76,294.89,296.04,297.2,298.39,299.61,300.84,302.1,303.38,304.69,306.02,307.37,308.76,310.17,311.61,313.09,314.59,316.12,317.69,},
{54.605,56.252,57.863,59.438,60.98,62.489,63.967,65.415,66.833,68.223,69.585,70.921,72.231,73.516,74.777,76.015,77.231,78.424,79.596,80.748,81.88,82.993,84.086,85.162,86.22,87.261,88.286,89.294,90.287,91.264,92.227,93.176,94.11,95.032,95.94,96.835,97.718,98.589,99.448,100.3,101.13,101.96,102.77,103.58,104.38,105.16,105.94,106.71,107.46,108.22,108.96,109.69,110.42,111.14,111.85,112.55,113.25,113.94,114.62,115.3,115.97,116.63,117.29,117.94,118.59,119.23,119.87,120.5,121.13,121.75,122.37,122.98,123.59,124.19,124.79,125.39,125.98,126.57,127.15,127.73,128.31,128.89,129.46,130.03,130.59,131.16,131.72,132.28,132.83,133.39,133.94,134.49,135.03,135.58,136.12,136.66,137.2,137.74,138.28,138.81,139.35,139.88,140.41,140.94,141.47,142.0,142.52,143.05,143.58,144.1,144.63,145.15,145.67,146.2,146.72,147.24,147.76,148.29,148.81,149.33,149.85,150.38,150.9,151.42,151.94,152.47,152.99,153.52,154.04,154.56,155.09,155.62,156.14,156.67,157.2,157.73,158.26,158.79,159.32,159.85,160.39,160.92,161.45,161.99,162.53,163.07,163.61,164.15,164.69,165.23,165.77,166.32,166.86,167.41,167.96,168.51,169.06,169.61,170.17,170.72,171.28,171.83,172.39,172.95,173.51,174.07,174.63,175.2,175.76,176.33,176.89,177.46,178.03,178.6,179.17,179.74,180.31,180.88,181.46,182.03,182.6,183.18,183.75,184.33,184.91,185.48,186.06,186.64,187.21,187.79,188.37,188.95,189.52,190.1,190.68,191.25,191.83,192.4,192.98,193.55,194.13,194.7,195.27,195.84,196.42,196.99,197.56,198.12,198.69,199.26,199.82,200.39,200.95,201.51,202.08,202.64,203.2,203.75,204.31,204.87,205.42,205.97,206.53,207.08,207.63,208.18,208.72,209.27,209.82,210.36,210.9,211.44,211.99,212.52,213.06,213.6,214.14,214.67,215.21,215.74,216.27,216.8,217.34,217.87,218.39,218.92,219.45,219.98,220.5,221.03,221.55,222.08,222.6,223.13,223.65,224.17,224.7,225.22,225.74,226.26,226.79,227.31,227.83,228.35,228.88,229.4,229.92,230.45,230.97,231.49,232.02,232.55,233.07,233.6,234.13,234.66,235.19,235.72,236.25,236.78,237.32,237.85,238.39,238.93,239.47,240.02,240.56,241.11,241.66,242.21,242.76,243.31,243.87,244.43,245.0,245.56,246.13,246.7,247.28,247.85,248.43,249.02,249.61,250.2,250.79,251.39,252.0,252.6,253.22,253.83,254.45,255.08,255.71,256.35,256.99,257.63,258.29,258.94,259.61,260.28,260.95,261.63,262.32,263.02,263.72,264.43,265.15,265.87,266.6,267.34,268.09,268.85,269.62,270.39,271.18,271.97,272.77,273.59,274.41,275.25,276.09,276.95,277.82,278.7,279.59,280.5,281.42,282.35,283.29,284.25,285.23,286.22,287.23,288.25,289.28,290.34,291.41,292.5,293.61,294.74,295.89,297.06,298.25,299.46,300.69,301.95,303.23,304.54,305.87,307.22,308.61,310.02,311.47,312.94,314.44,315.98,},
{56.387,57.999,59.576,61.119,62.629,64.107,65.555,66.974,68.364,69.727,71.063,72.373,73.658,74.919,76.157,77.372,78.565,79.737,80.889,82.02,83.132,84.225,85.3,86.358,87.398,88.422,89.429,90.421,91.397,92.359,93.307,94.24,95.16,96.067,96.961,97.842,98.712,99.57,100.42,101.25,102.08,102.89,103.69,104.49,105.27,106.05,106.81,107.57,108.32,109.06,109.79,110.51,111.23,111.94,112.64,113.33,114.02,114.7,115.38,116.05,116.71,117.36,118.01,118.66,119.3,119.93,120.56,121.19,121.8,122.42,123.03,123.63,124.24,124.83,125.43,126.02,126.6,127.18,127.76,128.34,128.91,129.48,130.04,130.61,131.17,131.72,132.28,132.83,133.38,133.93,134.47,135.01,135.56,136.1,136.63,137.17,137.7,138.23,138.77,139.3,139.82,140.35,140.88,141.4,141.93,142.45,142.97,143.49,144.01,144.53,145.05,145.57,146.09,146.61,147.12,147.64,148.16,148.68,149.19,149.71,150.23,150.75,151.26,151.78,152.3,152.82,153.33,153.85,154.37,154.89,155.41,155.93,156.46,156.98,157.5,158.03,158.55,159.08,159.6,160.13,160.66,161.19,161.72,162.25,162.78,163.31,163.85,164.38,164.92,165.46,165.99,166.53,167.07,167.62,168.16,168.7,169.25,169.8,170.34,170.89,171.44,171.99,172.55,173.1,173.65,174.21,174.77,175.32,175.88,176.44,177.0,177.57,178.13,178.69,179.26,179.82,180.39,180.95,181.52,182.09,182.66,183.23,183.8,184.37,184.94,185.51,186.08,186.65,187.22,187.8,188.37,188.94,189.51,190.08,190.65,191.22,191.79,192.36,192.93,193.5,194.07,194.64,195.2,195.77,196.34,196.9,197.46,198.03,198.59,199.15,199.71,200.27,200.83,201.38,201.94,202.49,203.05,203.6,204.15,204.7,205.25,205.8,206.35,206.89,207.44,207.98,208.52,209.06,209.6,210.14,210.68,211.22,211.75,212.29,212.82,213.35,213.88,214.41,214.94,215.47,216.0,216.52,217.05,217.57,218.1,218.62,219.14,219.67,220.19,220.71,221.23,221.75,222.27,222.79,223.3,223.82,224.34,224.86,225.38,225.89,226.41,226.93,227.44,227.96,228.48,229.0,229.51,230.03,230.55,231.07,231.59,232.11,232.63,233.15,233.68,234.2,234.73,235.25,235.78,236.31,236.84,237.37,237.9,238.43,238.97,239.51,240.04,240.59,241.13,241.67,242.22,242.77,243.32,243.88,244.43,244.99,245.55,246.12,246.69,247.26,247.83,248.41,248.99,249.58,250.17,250.76,251.36,251.96,252.56,253.17,253.78,254.4,255.03,255.65,256.29,256.92,257.57,258.22,258.87,259.53,260.2,260.87,261.55,262.24,262.93,263.63,264.34,265.06,265.78,266.51,267.25,267.99,268.75,269.51,270.29,271.07,271.86,272.66,273.48,274.3,275.13,275.98,276.83,277.7,278.58,279.47,280.38,281.29,282.22,283.17,284.13,285.1,286.09,287.1,288.12,289.15,290.21,291.28,292.37,293.48,294.61,295.76,296.92,298.11,299.32,300.56,301.82,303.1,304.4,305.73,307.09,308.48,309.89,311.33,312.81,314.31,},
{58.118,59.696,61.24,62.751,64.231,65.68,67.099,68.49,69.853,71.19,72.5,73.786,75.047,76.285,77.5,78.693,79.865,81.016,82.148,83.259,84.352,85.427,86.484,87.523,88.546,89.553,90.544,91.52,92.481,93.427,94.36,95.279,96.184,97.077,97.958,98.826,99.682,100.53,101.36,102.18,103.0,103.8,104.59,105.37,106.15,106.91,107.67,108.41,109.15,109.88,110.6,111.32,112.03,112.72,113.42,114.1,114.78,115.45,116.12,116.78,117.43,118.08,118.72,119.36,119.99,120.62,121.24,121.86,122.47,123.08,123.68,124.28,124.87,125.46,126.05,126.63,127.21,127.79,128.36,128.93,129.49,130.05,130.61,131.17,131.72,132.28,132.82,133.37,133.91,134.46,135.0,135.53,136.07,136.6,137.13,137.66,138.19,138.72,139.25,139.77,140.29,140.81,141.34,141.86,142.37,142.89,143.41,143.92,144.44,144.95,145.47,145.98,146.5,147.01,147.52,148.03,148.55,149.06,149.57,150.08,150.6,151.11,151.62,152.13,152.65,153.16,153.67,154.19,154.7,155.22,155.73,156.25,156.76,157.28,157.8,158.32,158.84,159.36,159.88,160.4,160.92,161.45,161.97,162.5,163.03,163.55,164.08,164.61,165.14,165.68,166.21,166.74,167.28,167.82,168.35,168.89,169.43,169.97,170.52,171.06,171.61,172.15,172.7,173.25,173.8,174.35,174.9,175.45,176.0,176.56,177.11,177.67,178.23,178.78,179.34,179.9,180.46,181.03,181.59,182.15,182.71,183.28,183.84,184.41,184.97,185.54,186.1,186.67,187.23,187.8,188.36,188.93,189.5,190.06,190.63,191.19,191.76,192.32,192.89,193.45,194.01,194.57,195.13,195.7,196.26,196.81,197.37,197.93,198.49,199.04,199.6,200.15,200.7,201.26,201.81,202.36,202.9,203.45,204.0,204.54,205.09,205.63,206.17,206.71,207.25,207.79,208.32,208.86,209.4,209.93,210.46,210.99,211.52,212.05,212.58,213.11,213.63,214.16,214.68,215.21,215.73,216.25,216.77,217.29,217.81,218.33,218.84,219.36,219.88,220.39,220.91,221.42,221.94,222.45,222.96,223.48,223.99,224.5,225.02,225.53,226.04,226.55,227.06,227.58,228.09,228.6,229.11,229.63,230.14,230.66,231.17,231.69,232.2,232.72,233.24,233.76,234.27,234.8,235.32,235.84,236.36,236.89,237.42,237.94,238.47,239.01,239.54,240.07,240.61,241.15,241.69,242.24,242.78,243.33,243.88,244.43,244.99,245.55,246.11,246.68,247.25,247.82,248.39,248.97,249.55,250.14,250.73,251.32,251.92,252.52,253.13,253.74,254.35,254.97,255.6,256.23,256.87,257.51,258.16,258.81,259.47,260.13,260.8,261.48,262.17,262.86,263.55,264.26,264.97,265.69,266.42,267.16,267.9,268.66,269.42,270.19,270.97,271.76,272.56,273.38,274.2,275.03,275.87,276.73,277.59,278.47,279.36,280.26,281.18,282.11,283.06,284.01,284.99,285.98,286.98,288.0,289.04,290.09,291.16,292.25,293.36,294.49,295.63,296.8,297.99,299.2,300.44,301.69,302.98,304.28,305.61,306.97,308.36,309.77,311.22,312.69,},
{59.799,61.344,62.857,64.338,65.788,67.209,68.601,69.965,71.302,72.613,73.9,75.161,76.4,77.615,78.808,79.98,81.132,82.263,83.374,84.467,85.541,86.598,87.637,88.66,89.666,90.656,91.632,92.592,93.538,94.469,95.387,96.292,97.184,98.064,98.931,99.786,100.63,101.46,102.28,103.1,103.9,104.69,105.47,106.24,107.0,107.76,108.5,109.24,109.97,110.69,111.4,112.11,112.8,113.49,114.18,114.85,115.52,116.19,116.85,117.5,118.14,118.78,119.42,120.05,120.67,121.29,121.9,122.51,123.12,123.72,124.31,124.91,125.49,126.08,126.66,127.23,127.81,128.38,128.94,129.5,130.06,130.62,131.17,131.72,132.27,132.82,133.36,133.9,134.44,134.98,135.51,136.04,136.57,137.1,137.63,138.15,138.67,139.2,139.72,140.24,140.75,141.27,141.79,142.3,142.81,143.33,143.84,144.35,144.86,145.37,145.88,146.39,146.9,147.4,147.91,148.42,148.93,149.43,149.94,150.45,150.96,151.46,151.97,152.48,152.99,153.49,154.0,154.51,155.02,155.53,156.04,156.55,157.07,157.58,158.09,158.61,159.12,159.64,160.15,160.67,161.19,161.71,162.23,162.75,163.27,163.79,164.32,164.84,165.37,165.89,166.42,166.95,167.48,168.01,168.55,169.08,169.61,170.15,170.69,171.23,171.77,172.31,172.85,173.39,173.93,174.48,175.03,175.57,176.12,176.67,177.22,177.77,178.32,178.88,179.43,179.98,180.54,181.09,181.65,182.21,182.77,183.32,183.88,184.44,185.0,185.56,186.12,186.68,187.24,187.8,188.36,188.92,189.48,190.04,190.6,191.16,191.72,192.28,192.84,193.4,193.96,194.51,195.07,195.62,196.18,196.73,197.28,197.84,198.39,198.94,199.49,200.04,200.58,201.13,201.67,202.22,202.76,203.3,203.84,204.38,204.92,205.46,206.0,206.53,207.07,207.6,208.13,208.66,209.19,209.72,210.25,210.77,211.3,211.82,212.34,212.87,213.39,213.91,214.43,214.95,215.46,215.98,216.5,217.01,217.52,218.04,218.55,219.06,219.57,220.08,220.59,221.1,221.61,222.12,222.63,223.14,223.65,224.15,224.66,225.17,225.68,226.18,226.69,227.2,227.71,228.21,228.72,229.23,229.74,230.25,230.76,231.27,231.78,232.29,232.8,233.32,233.83,234.35,234.86,235.38,235.9,236.42,236.94,237.46,237.99,238.52,239.04,239.57,240.11,240.64,241.17,241.71,242.25,242.8,243.34,243.89,244.44,244.99,245.55,246.11,246.67,247.23,247.8,248.37,248.95,249.53,250.11,250.7,251.29,251.89,252.48,253.09,253.7,254.31,254.93,255.55,256.18,256.81,257.45,258.1,258.75,259.41,260.07,260.74,261.41,262.1,262.78,263.48,264.18,264.9,265.62,266.34,267.08,267.82,268.57,269.33,270.1,270.88,271.67,272.47,273.28,274.1,274.93,275.77,276.63,277.49,278.37,279.26,280.16,281.08,282.01,282.95,283.91,284.88,285.87,286.87,287.89,288.93,289.98,291.05,292.14,293.25,294.38,295.53,296.7,297.88,299.1,300.33,301.59,302.87,304.18,305.51,306.87,308.26,309.67,311.12,},
{61.432,62.947,64.429,65.881,67.303,68.696,70.062,71.4,72.712,73.999,75.262,76.501,77.717,78.911,80.083,81.234,82.366,83.477,84.57,85.645,86.701,87.74,88.762,89.768,90.759,91.733,92.693,93.638,94.569,95.487,96.391,97.282,98.161,99.027,99.881,100.72,101.56,102.38,103.19,103.99,104.78,105.56,106.33,107.09,107.84,108.58,109.32,110.05,110.77,111.48,112.18,112.88,113.56,114.25,114.92,115.59,116.25,116.91,117.56,118.2,118.84,119.47,120.1,120.72,121.34,121.95,122.56,123.16,123.76,124.35,124.94,125.52,126.1,126.68,127.25,127.82,128.39,128.95,129.51,130.07,130.62,131.17,131.72,132.27,132.81,133.35,133.89,134.42,134.95,135.48,136.01,136.54,137.06,137.59,138.11,138.63,139.15,139.66,140.18,140.69,141.2,141.72,142.23,142.74,143.25,143.75,144.26,144.77,145.27,145.78,146.28,146.78,147.29,147.79,148.29,148.8,149.3,149.8,150.3,150.81,151.31,151.81,152.32,152.82,153.32,153.82,154.33,154.83,155.34,155.84,156.35,156.86,157.36,157.87,158.38,158.89,159.4,159.91,160.42,160.93,161.45,161.96,162.47,162.99,163.51,164.03,164.54,165.06,165.59,166.11,166.63,167.15,167.68,168.21,168.73,169.26,169.79,170.32,170.86,171.39,171.92,172.46,173.0,173.53,174.07,174.61,175.15,175.69,176.24,176.78,177.33,177.87,178.42,178.97,179.51,180.06,180.61,181.16,181.71,182.27,182.82,183.37,183.92,184.48,185.03,185.59,186.14,186.7,187.25,187.81,188.36,188.92,189.47,190.03,190.58,191.13,191.69,192.24,192.8,193.35,193.9,194.45,195.0,195.55,196.1,196.65,197.2,197.74,198.29,198.83,199.38,199.92,200.46,201.0,201.54,202.08,202.62,203.16,203.69,204.23,204.76,205.29,205.83,206.36,206.88,207.41,207.94,208.46,208.99,209.51,210.03,210.56,211.08,211.6,212.11,212.63,213.15,213.66,214.18,214.69,215.2,215.71,216.22,216.73,217.24,217.75,218.26,218.77,219.27,219.78,220.29,220.79,221.3,221.8,222.3,222.81,223.31,223.81,224.31,224.82,225.32,225.82,226.33,226.83,227.33,227.83,228.34,228.84,229.34,229.85,230.35,230.86,231.36,231.87,232.38,232.89,233.4,233.91,234.42,234.93,235.45,235.96,236.48,236.99,237.51,238.03,238.56,239.08,239.61,240.14,240.67,241.2,241.73,242.27,242.81,243.35,243.9,244.44,244.99,245.55,246.1,246.66,247.23,247.79,248.36,248.93,249.51,250.09,250.67,251.26,251.86,252.45,253.05,253.66,254.27,254.89,255.51,256.13,256.77,257.4,258.05,258.69,259.35,260.01,260.68,261.35,262.03,262.72,263.41,264.12,264.83,265.54,266.27,267.0,267.74,268.49,269.25,270.02,270.8,271.59,272.39,273.2,274.02,274.85,275.69,276.54,277.4,278.28,279.17,280.07,280.99,281.91,282.86,283.81,284.79,285.77,286.78,287.8,288.83,289.89,290.96,292.05,293.16,294.28,295.43,296.6,297.79,299.0,300.24,301.5,302.78,304.09,305.42,306.78,308.17,309.59,},
{63.02,64.505,65.958,67.382,68.777,70.144,71.483,72.797,74.085,75.349,76.588,77.805,79.0,80.173,81.325,82.457,83.569,84.662,85.736,86.793,87.832,88.854,89.86,90.85,91.825,92.784,93.729,94.66,95.577,96.48,97.371,98.249,99.114,99.968,100.81,101.64,102.46,103.27,104.07,104.86,105.64,106.41,107.17,107.92,108.66,109.39,110.12,110.84,111.55,112.25,112.94,113.63,114.31,114.98,115.65,116.31,116.96,117.61,118.25,118.89,119.52,120.14,120.76,121.38,121.99,122.59,123.19,123.79,124.38,124.97,125.55,126.13,126.7,127.27,127.84,128.4,128.96,129.52,130.07,130.63,131.17,131.72,132.26,132.8,133.34,133.87,134.4,134.93,135.46,135.98,136.51,137.03,137.55,138.07,138.58,139.1,139.61,140.12,140.63,141.14,141.65,142.15,142.66,143.16,143.67,144.17,144.67,145.17,145.68,146.18,146.68,147.17,147.67,148.17,148.67,149.17,149.67,150.16,150.66,151.16,151.66,152.16,152.65,153.15,153.65,154.15,154.65,155.15,155.65,156.15,156.65,157.15,157.65,158.16,158.66,159.17,159.67,160.18,160.68,161.19,161.7,162.21,162.72,163.23,163.74,164.25,164.77,165.28,165.8,166.32,166.84,167.35,167.88,168.4,168.92,169.44,169.97,170.49,171.02,171.55,172.08,172.61,173.14,173.67,174.21,174.74,175.28,175.81,176.35,176.89,177.43,177.97,178.51,179.05,179.6,180.14,180.68,181.23,181.78,182.32,182.87,183.42,183.97,184.51,185.06,185.61,186.16,186.71,187.26,187.81,188.36,188.91,189.46,190.01,190.56,191.11,191.66,192.2,192.75,193.3,193.85,194.39,194.94,195.48,196.03,196.57,197.11,197.65,198.19,198.73,199.27,199.81,200.35,200.88,201.42,201.95,202.48,203.01,203.55,204.08,204.6,205.13,205.66,206.18,206.71,207.23,207.75,208.27,208.79,209.31,209.83,210.34,210.86,211.37,211.89,212.4,212.91,213.42,213.93,214.44,214.95,215.45,215.96,216.46,216.97,217.47,217.98,218.48,218.98,219.48,219.98,220.48,220.98,221.48,221.98,222.48,222.98,223.48,223.97,224.47,224.97,225.47,225.97,226.46,226.96,227.46,227.96,228.46,228.96,229.46,229.96,230.46,230.96,231.46,231.96,232.47,232.97,233.48,233.98,234.49,235.0,235.51,236.02,236.53,237.05,237.56,238.08,238.6,239.12,239.64,240.17,240.7,241.23,241.76,242.29,242.83,243.37,243.91,244.45,245.0,245.55,246.1,246.66,247.22,247.78,248.35,248.92,249.49,250.07,250.65,251.24,251.83,252.42,253.02,253.63,254.24,254.85,255.47,256.09,256.72,257.36,258.0,258.64,259.3,259.96,260.62,261.29,261.97,262.66,263.35,264.05,264.76,265.48,266.2,266.93,267.67,268.42,269.18,269.95,270.73,271.51,272.31,273.12,273.94,274.77,275.61,276.46,277.32,278.2,279.09,279.99,280.9,281.83,282.77,283.73,284.7,285.69,286.69,287.71,288.75,289.8,290.87,291.96,293.07,294.2,295.35,296.52,297.71,298.92,300.16,301.42,302.7,304.01,305.35,306.71,308.1,},
{64.564,66.02,67.446,68.842,70.211,71.552,72.867,74.157,75.422,76.663,77.881,79.076,80.25,81.403,82.536,83.648,84.742,85.817,86.874,87.913,88.936,89.942,90.932,91.906,92.865,93.81,94.741,95.657,96.561,97.451,98.328,99.193,100.05,100.89,101.72,102.54,103.35,104.14,104.93,105.71,106.48,107.24,107.99,108.73,109.46,110.18,110.9,111.61,112.31,113.0,113.69,114.37,115.04,115.7,116.36,117.01,117.66,118.3,118.93,119.56,120.19,120.8,121.42,122.02,122.63,123.22,123.82,124.41,124.99,125.57,126.15,126.72,127.29,127.85,128.41,128.97,129.53,130.08,130.62,131.17,131.71,132.25,132.79,133.32,133.85,134.38,134.91,135.43,135.95,136.47,136.99,137.51,138.02,138.54,139.05,139.56,140.06,140.57,141.08,141.58,142.08,142.58,143.09,143.59,144.08,144.58,145.08,145.58,146.07,146.57,147.06,147.56,148.05,148.55,149.04,149.53,150.03,150.52,151.01,151.51,152.0,152.49,152.99,153.48,153.97,154.47,154.96,155.46,155.95,156.45,156.95,157.44,157.94,158.44,158.94,159.44,159.94,160.44,160.94,161.44,161.95,162.45,162.96,163.46,163.97,164.48,164.99,165.5,166.01,166.52,167.04,167.55,168.07,168.58,169.1,169.62,170.14,170.66,171.18,171.71,172.23,172.76,173.28,173.81,174.34,174.87,175.4,175.93,176.46,177.0,177.53,178.07,178.6,179.14,179.68,180.22,180.76,181.3,181.84,182.38,182.92,183.46,184.01,184.55,185.09,185.64,186.18,186.72,187.27,187.81,188.36,188.9,189.45,189.99,190.54,191.08,191.62,192.17,192.71,193.25,193.79,194.33,194.87,195.41,195.95,196.49,197.03,197.56,198.1,198.63,199.17,199.7,200.23,200.76,201.29,201.82,202.35,202.87,203.4,203.92,204.45,204.97,205.49,206.01,206.53,207.05,207.57,208.08,208.6,209.11,209.62,210.13,210.64,211.15,211.66,212.17,212.68,213.18,213.69,214.19,214.69,215.2,215.7,216.2,216.7,217.2,217.7,218.19,218.69,219.19,219.68,220.18,220.68,221.17,221.66,222.16,222.65,223.15,223.64,224.13,224.63,225.12,225.61,226.11,226.6,227.09,227.59,228.08,228.58,229.07,229.57,230.06,230.56,231.06,231.55,232.05,232.55,233.05,233.55,234.06,234.56,235.07,235.57,236.08,236.59,237.1,237.61,238.13,238.64,239.16,239.68,240.2,240.73,241.25,241.78,242.31,242.85,243.38,243.92,244.46,245.01,245.55,246.1,246.66,247.22,247.78,248.34,248.91,249.48,250.05,250.63,251.22,251.81,252.4,253.0,253.6,254.2,254.82,255.43,256.06,256.68,257.32,257.96,258.6,259.25,259.91,260.57,261.24,261.92,262.61,263.3,264.0,264.7,265.42,266.14,266.87,267.61,268.36,269.12,269.88,270.66,271.45,272.24,273.05,273.87,274.69,275.53,276.39,277.25,278.12,279.01,279.91,280.83,281.76,282.7,283.65,284.63,285.61,286.62,287.64,288.67,289.73,290.8,291.89,293.0,294.13,295.28,296.45,297.64,298.85,300.09,301.35,302.64,303.95,305.29,306.65,},
{66.066,67.494,68.893,70.264,71.607,72.924,74.215,75.482,76.724,77.944,79.141,80.315,81.469,82.603,83.716,84.811,85.886,86.944,87.984,89.006,90.013,91.003,91.978,92.937,93.882,94.812,95.729,96.632,97.522,98.399,99.264,100.12,100.96,101.79,102.61,103.41,104.21,105.0,105.77,106.54,107.3,108.05,108.79,109.52,110.24,110.96,111.67,112.36,113.06,113.74,114.42,115.09,115.75,116.41,117.06,117.7,118.34,118.97,119.6,120.22,120.84,121.45,122.05,122.66,123.25,123.84,124.43,125.01,125.59,126.16,126.73,127.3,127.86,128.42,128.98,129.53,130.08,130.62,131.16,131.7,132.24,132.77,133.3,133.83,134.36,134.88,135.4,135.92,136.44,136.96,137.47,137.98,138.49,139.0,139.5,140.01,140.51,141.01,141.51,142.01,142.51,143.01,143.5,144.0,144.49,144.99,145.48,145.97,146.46,146.95,147.44,147.93,148.42,148.91,149.4,149.89,150.38,150.87,151.36,151.85,152.33,152.82,153.31,153.8,154.29,154.78,155.27,155.76,156.25,156.74,157.24,157.73,158.22,158.72,159.21,159.71,160.2,160.7,161.2,161.69,162.19,162.69,163.19,163.7,164.2,164.7,165.21,165.71,166.22,166.73,167.24,167.75,168.26,168.77,169.28,169.8,170.31,170.83,171.34,171.86,172.38,172.9,173.42,173.95,174.47,174.99,175.52,176.05,176.57,177.1,177.63,178.16,178.69,179.23,179.76,180.29,180.83,181.36,181.9,182.43,182.97,183.51,184.04,184.58,185.12,185.66,186.2,186.74,187.28,187.82,188.36,188.9,189.44,189.97,190.51,191.05,191.59,192.13,192.67,193.2,193.74,194.27,194.81,195.34,195.88,196.41,196.94,197.47,198.0,198.53,199.06,199.59,200.12,200.64,201.17,201.69,202.21,202.74,203.26,203.78,204.3,204.81,205.33,205.84,206.36,206.87,207.38,207.89,208.4,208.91,209.42,209.93,210.43,210.94,211.44,211.95,212.45,212.95,213.45,213.95,214.45,214.94,215.44,215.94,216.43,216.93,217.42,217.91,218.41,218.9,219.39,219.88,220.37,220.86,221.35,221.84,222.33,222.82,223.31,223.8,224.29,224.78,225.27,225.75,226.24,226.73,227.22,227.71,228.2,228.69,229.18,229.67,230.17,230.66,231.15,231.65,232.14,232.64,233.13,233.63,234.13,234.63,235.13,235.64,236.14,236.65,237.15,237.66,238.17,238.69,239.2,239.72,240.24,240.76,241.28,241.81,242.33,242.87,243.4,243.93,244.47,245.02,245.56,246.11,246.66,247.21,247.77,248.33,248.9,249.47,250.04,250.62,251.2,251.79,252.38,252.97,253.57,254.18,254.79,255.4,256.02,256.65,257.28,257.92,258.56,259.21,259.87,260.53,261.2,261.87,262.56,263.25,263.95,264.65,265.36,266.09,266.82,267.56,268.3,269.06,269.83,270.6,271.39,272.18,272.99,273.8,274.63,275.47,276.32,277.18,278.06,278.95,279.85,280.76,281.69,282.63,283.59,284.56,285.55,286.55,287.57,288.61,289.66,290.74,291.83,292.94,294.07,295.22,296.39,297.58,298.8,300.04,301.3,302.59,303.9,305.24,},
{67.528,68.93,70.303,71.648,72.967,74.261,75.529,76.773,77.994,79.192,80.369,81.524,82.658,83.773,84.868,85.944,87.003,88.043,89.067,90.074,91.064,92.039,92.999,93.944,94.874,95.791,96.694,97.584,98.461,99.325,100.18,101.02,101.85,102.67,103.47,104.27,105.06,105.83,106.6,107.36,108.1,108.84,109.57,110.3,111.01,111.72,112.41,113.1,113.79,114.46,115.13,115.79,116.45,117.1,117.74,118.38,119.01,119.64,120.26,120.87,121.48,122.08,122.68,123.27,123.86,124.45,125.03,125.61,126.18,126.75,127.31,127.87,128.43,128.98,129.53,130.07,130.62,131.16,131.69,132.23,132.76,133.29,133.81,134.34,134.86,135.37,135.89,136.41,136.92,137.43,137.94,138.44,138.95,139.45,139.95,140.45,140.95,141.45,141.94,142.44,142.93,143.42,143.91,144.4,144.89,145.38,145.87,146.36,146.85,147.33,147.82,148.3,148.79,149.27,149.76,150.24,150.73,151.21,151.7,152.18,152.66,153.15,153.63,154.12,154.6,155.09,155.57,156.06,156.55,157.03,157.52,158.01,158.5,158.99,159.48,159.97,160.46,160.95,161.45,161.94,162.43,162.93,163.43,163.92,164.42,164.92,165.42,165.92,166.42,166.93,167.43,167.94,168.44,168.95,169.46,169.97,170.48,170.99,171.5,172.01,172.53,173.04,173.56,174.08,174.6,175.12,175.64,176.16,176.68,177.21,177.73,178.26,178.78,179.31,179.84,180.37,180.9,181.43,181.96,182.49,183.02,183.55,184.08,184.62,185.15,185.68,186.22,186.75,187.29,187.82,188.36,188.89,189.42,189.96,190.49,191.03,191.56,192.09,192.62,193.16,193.69,194.22,194.75,195.28,195.81,196.33,196.86,197.39,197.91,198.44,198.96,199.48,200.01,200.53,201.05,201.57,202.08,202.6,203.12,203.63,204.14,204.66,205.17,205.68,206.19,206.7,207.2,207.71,208.22,208.72,209.22,209.73,210.23,210.73,211.23,211.73,212.22,212.72,213.22,213.71,214.2,214.7,215.19,215.68,216.17,216.66,217.15,217.64,218.13,218.62,219.1,219.59,220.08,220.56,221.05,221.53,222.02,222.5,222.99,223.47,223.96,224.44,224.92,225.41,225.89,226.38,226.86,227.35,227.83,228.32,228.81,229.29,229.78,230.27,230.76,231.25,231.74,232.23,232.72,233.21,233.71,234.2,234.7,235.2,235.7,236.2,236.7,237.21,237.71,238.22,238.73,239.24,239.76,240.27,240.79,241.31,241.83,242.36,242.89,243.42,243.95,244.49,245.03,245.57,246.11,246.66,247.22,247.77,248.33,248.89,249.46,250.03,250.61,251.19,251.77,252.36,252.95,253.55,254.15,254.76,255.38,255.99,256.62,257.25,257.88,258.53,259.18,259.83,260.49,261.16,261.83,262.52,263.2,263.9,264.61,265.32,266.04,266.77,267.51,268.25,269.01,269.77,270.55,271.33,272.13,272.93,273.75,274.58,275.42,276.27,277.13,278.0,278.89,279.79,280.71,281.63,282.58,283.53,284.51,285.5,286.5,287.52,288.56,289.61,290.69,291.78,292.89,294.02,295.17,296.35,297.54,298.76,300.0,301.26,302.55,303.87,},
{68.952,70.327,71.675,72.997,74.292,75.563,76.809,78.032,79.232,80.409,81.566,82.702,83.818,84.914,85.992,87.051,88.092,89.117,90.124,91.115,92.091,93.051,93.996,94.927,95.844,96.747,97.637,98.514,99.379,100.23,101.07,101.9,102.72,103.53,104.32,105.11,105.88,106.65,107.41,108.15,108.89,109.62,110.34,111.06,111.76,112.46,113.15,113.83,114.5,115.17,115.83,116.49,117.14,117.78,118.41,119.04,119.67,120.28,120.9,121.5,122.11,122.7,123.29,123.88,124.47,125.04,125.62,126.19,126.75,127.32,127.87,128.43,128.98,129.53,130.07,130.61,131.15,131.68,132.21,132.74,133.27,133.79,134.31,134.83,135.34,135.86,136.37,136.88,137.39,137.89,138.39,138.89,139.39,139.89,140.39,140.88,141.38,141.87,142.36,142.85,143.34,143.83,144.32,144.8,145.29,145.77,146.26,146.74,147.22,147.7,148.19,148.67,149.15,149.63,150.11,150.59,151.07,151.55,152.03,152.51,152.99,153.47,153.95,154.43,154.91,155.39,155.87,156.35,156.84,157.32,157.8,158.29,158.77,159.26,159.74,160.23,160.72,161.2,161.69,162.18,162.67,163.16,163.65,164.15,164.64,165.13,165.63,166.13,166.62,167.12,167.62,168.12,168.62,169.13,169.63,170.14,170.64,171.15,171.66,172.16,172.67,173.19,173.7,174.21,174.72,175.24,175.76,176.27,176.79,177.31,177.83,178.35,178.87,179.39,179.92,180.44,180.96,181.49,182.01,182.54,183.07,183.59,184.12,184.65,185.18,185.71,186.24,186.77,187.29,187.82,188.35,188.88,189.41,189.94,190.47,191.0,191.53,192.05,192.58,193.11,193.64,194.16,194.69,195.21,195.73,196.26,196.78,197.3,197.82,198.34,198.86,199.38,199.9,200.41,200.93,201.44,201.95,202.47,202.98,203.49,204.0,204.5,205.01,205.52,206.02,206.53,207.03,207.53,208.03,208.53,209.03,209.53,210.02,210.52,211.01,211.51,212.0,212.49,212.98,213.48,213.96,214.45,214.94,215.43,215.91,216.4,216.89,217.37,217.85,218.34,218.82,219.3,219.78,220.27,220.75,221.23,221.71,222.19,222.67,223.15,223.63,224.11,224.59,225.07,225.55,226.03,226.51,226.99,227.47,227.95,228.44,228.92,229.4,229.89,230.37,230.86,231.34,231.83,232.32,232.8,233.29,233.79,234.28,234.77,235.27,235.76,236.26,236.76,237.26,237.76,238.27,238.78,239.29,239.8,240.31,240.82,241.34,241.86,242.38,242.91,243.44,243.97,244.5,245.04,245.58,246.12,246.67,247.22,247.77,248.33,248.89,249.46,250.03,250.6,251.18,251.76,252.35,252.94,253.53,254.14,254.74,255.35,255.97,256.59,257.22,257.86,258.5,259.14,259.8,260.46,261.12,261.8,262.48,263.17,263.86,264.57,265.28,266.0,266.73,267.46,268.21,268.96,269.73,270.5,271.29,272.08,272.89,273.7,274.53,275.37,276.22,277.08,277.96,278.84,279.75,280.66,281.59,282.53,283.49,284.46,285.45,286.46,287.48,288.52,289.57,290.65,291.74,292.85,293.98,295.14,296.31,297.51,298.73,299.97,301.24,302.53,},
{70.338,71.689,73.013,74.311,75.584,76.832,78.057,79.259,80.438,81.597,82.734,83.852,84.949,86.028,87.089,88.131,89.156,90.165,91.157,92.133,93.094,94.04,94.971,95.888,96.792,97.682,98.559,99.424,100.28,101.12,101.95,102.76,103.57,104.37,105.15,105.93,106.69,107.45,108.2,108.93,109.66,110.38,111.1,111.8,112.5,113.18,113.87,114.54,115.21,115.87,116.52,117.17,117.81,118.44,119.07,119.69,120.31,120.92,121.52,122.12,122.72,123.31,123.9,124.48,125.05,125.63,126.19,126.76,127.32,127.87,128.43,128.98,129.52,130.06,130.6,131.14,131.67,132.2,132.72,133.25,133.77,134.28,134.8,135.31,135.82,136.33,136.84,137.34,137.84,138.35,138.84,139.34,139.84,140.33,140.82,141.31,141.8,142.29,142.78,143.26,143.75,144.23,144.71,145.19,145.67,146.15,146.63,147.11,147.59,148.07,148.55,149.02,149.5,149.98,150.45,150.93,151.4,151.88,152.36,152.83,153.31,153.78,154.26,154.74,155.21,155.69,156.17,156.64,157.12,157.6,158.08,158.56,159.04,159.52,160.0,160.48,160.97,161.45,161.93,162.42,162.9,163.39,163.88,164.37,164.86,165.35,165.84,166.33,166.82,167.32,167.81,168.31,168.8,169.3,169.8,170.3,170.8,171.31,171.81,172.31,172.82,173.32,173.83,174.34,174.85,175.36,175.87,176.38,176.9,177.41,177.92,178.44,178.96,179.47,179.99,180.51,181.03,181.55,182.07,182.59,183.11,183.64,184.16,184.68,185.21,185.73,186.25,186.78,187.3,187.83,188.35,188.88,189.4,189.92,190.45,190.97,191.5,192.02,192.54,193.06,193.58,194.11,194.63,195.15,195.66,196.18,196.7,197.22,197.73,198.25,198.76,199.27,199.79,200.3,200.81,201.32,201.83,202.33,202.84,203.35,203.85,204.35,204.86,205.36,205.86,206.36,206.86,207.35,207.85,208.34,208.84,209.33,209.82,210.32,210.81,211.29,211.78,212.27,212.76,213.24,213.73,214.21,214.7,215.18,215.66,216.14,216.62,217.1,217.58,218.06,218.54,219.02,219.5,219.98,220.45,220.93,221.41,221.88,222.36,222.83,223.31,223.78,224.26,224.74,225.21,225.69,226.16,226.64,227.12,227.6,228.07,228.55,229.03,229.51,229.99,230.47,230.95,231.43,231.92,232.4,232.89,233.37,233.86,234.35,234.84,235.33,235.83,236.32,236.82,237.32,237.82,238.32,238.82,239.33,239.84,240.35,240.86,241.37,241.89,242.41,242.94,243.46,243.99,244.52,245.06,245.59,246.13,246.68,247.23,247.78,248.33,248.89,249.46,250.02,250.6,251.17,251.75,252.34,252.93,253.52,254.12,254.73,255.34,255.95,256.57,257.2,257.83,258.47,259.12,259.77,260.43,261.09,261.77,262.45,263.13,263.83,264.53,265.24,265.96,266.69,267.43,268.17,268.93,269.69,270.46,271.25,272.04,272.85,273.66,274.49,275.33,276.18,277.04,277.92,278.81,279.71,280.62,281.55,282.49,283.45,284.43,285.42,286.42,287.44,288.48,289.54,290.62,291.71,292.83,293.96,295.12,296.29,297.49,298.71,299.96,301.22,},
{71.688,73.015,74.316,75.592,76.842,78.07,79.274,80.456,81.616,82.755,83.874,84.974,86.054,87.116,88.16,89.186,90.195,91.189,92.166,93.127,94.074,95.006,95.924,96.828,97.718,98.596,99.461,100.31,101.15,101.98,102.8,103.61,104.4,105.19,105.96,106.73,107.49,108.23,108.97,109.7,110.42,111.13,111.83,112.53,113.22,113.9,114.57,115.23,115.89,116.55,117.19,117.83,118.46,119.09,119.71,120.33,120.94,121.54,122.14,122.73,123.32,123.91,124.49,125.06,125.63,126.2,126.76,127.32,127.87,128.42,128.97,129.51,130.05,130.59,131.12,131.65,132.18,132.7,133.22,133.74,134.26,134.77,135.28,135.79,136.29,136.8,137.3,137.8,138.3,138.79,139.29,139.78,140.27,140.76,141.24,141.73,142.22,142.7,143.18,143.66,144.14,144.62,145.1,145.58,146.05,146.53,147.01,147.48,147.95,148.43,148.9,149.37,149.85,150.32,150.79,151.26,151.73,152.21,152.68,153.15,153.62,154.09,154.56,155.04,155.51,155.98,156.45,156.93,157.4,157.88,158.35,158.83,159.3,159.78,160.26,160.73,161.21,161.69,162.17,162.65,163.13,163.62,164.1,164.58,165.07,165.55,166.04,166.53,167.02,167.51,168.0,168.49,168.98,169.48,169.97,170.47,170.96,171.46,171.96,172.46,172.96,173.46,173.96,174.47,174.97,175.48,175.98,176.49,177.0,177.51,178.02,178.53,179.04,179.55,180.07,180.58,181.1,181.61,182.13,182.64,183.16,183.68,184.2,184.72,185.23,185.75,186.27,186.79,187.31,187.83,188.35,188.87,189.39,189.91,190.43,190.95,191.47,191.98,192.5,193.02,193.53,194.05,194.57,195.08,195.6,196.11,196.62,197.13,197.64,198.15,198.66,199.17,199.68,200.19,200.69,201.2,201.7,202.2,202.71,203.21,203.71,204.21,204.7,205.2,205.7,206.19,206.68,207.18,207.67,208.16,208.65,209.14,209.63,210.11,210.6,211.08,211.57,212.05,212.54,213.02,213.5,213.98,214.46,214.94,215.41,215.89,216.37,216.84,217.32,217.79,218.27,218.74,219.22,219.69,220.16,220.63,221.11,221.58,222.05,222.52,222.99,223.47,223.94,224.41,224.88,225.35,225.82,226.3,226.77,227.24,227.72,228.19,228.66,229.14,229.62,230.09,230.57,231.05,231.53,232.01,232.49,232.97,233.45,233.94,234.42,234.91,235.4,235.89,236.38,236.88,237.37,237.87,238.37,238.87,239.37,239.88,240.39,240.9,241.41,241.92,242.44,242.96,243.49,244.01,244.54,245.07,245.61,246.15,246.69,247.24,247.79,248.34,248.9,249.46,250.02,250.59,251.17,251.75,252.33,252.92,253.51,254.11,254.71,255.32,255.94,256.56,257.18,257.82,258.45,259.1,259.75,260.41,261.07,261.74,262.42,263.11,263.8,264.5,265.22,265.93,266.66,267.4,268.14,268.9,269.66,270.43,271.22,272.01,272.82,273.63,274.46,275.3,276.15,277.01,277.89,278.78,279.68,280.59,281.52,282.47,283.43,284.4,285.39,286.4,287.42,288.46,289.52,290.6,291.7,292.81,293.95,295.1,296.28,297.48,298.71,299.95,},
{73.005,74.308,75.587,76.84,78.07,79.277,80.461,81.623,82.765,83.886,84.987,86.069,87.132,88.178,89.205,90.216,91.21,92.189,93.151,94.099,95.032,95.95,96.855,97.746,98.624,99.489,100.34,101.18,102.01,102.83,103.64,104.43,105.22,105.99,106.76,107.51,108.26,109.0,109.73,110.45,111.16,111.86,112.55,113.24,113.92,114.59,115.26,115.92,116.57,117.21,117.85,118.48,119.11,119.73,120.34,120.95,121.55,122.15,122.74,123.33,123.91,124.49,125.07,125.63,126.2,126.76,127.32,127.87,128.42,128.96,129.5,130.04,130.57,131.1,131.63,132.16,132.68,133.2,133.71,134.23,134.74,135.25,135.75,136.25,136.76,137.25,137.75,138.25,138.74,139.23,139.72,140.21,140.69,141.18,141.66,142.14,142.62,143.1,143.58,144.06,144.53,145.01,145.48,145.96,146.43,146.9,147.37,147.84,148.31,148.78,149.25,149.72,150.19,150.65,151.12,151.59,152.06,152.53,152.99,153.46,153.93,154.4,154.86,155.33,155.8,156.27,156.74,157.21,157.68,158.15,158.62,159.09,159.56,160.03,160.51,160.98,161.45,161.93,162.41,162.88,163.36,163.84,164.32,164.8,165.28,165.76,166.24,166.72,167.21,167.69,168.18,168.67,169.16,169.64,170.14,170.63,171.12,171.61,172.11,172.6,173.1,173.59,174.09,174.59,175.09,175.59,176.09,176.6,177.1,177.61,178.11,178.62,179.12,179.63,180.14,180.65,181.16,181.67,182.18,182.69,183.21,183.72,184.23,184.75,185.26,185.78,186.29,186.8,187.32,187.83,188.35,188.86,189.38,189.89,190.41,190.92,191.44,191.95,192.46,192.97,193.49,194.0,194.51,195.02,195.53,196.04,196.54,197.05,197.56,198.06,198.57,199.07,199.58,200.08,200.58,201.08,201.58,202.08,202.57,203.07,203.57,204.06,204.55,205.05,205.54,206.03,206.52,207.01,207.49,207.98,208.46,208.95,209.43,209.92,210.4,210.88,211.36,211.84,212.32,212.79,213.27,213.75,214.22,214.7,215.17,215.64,216.11,216.59,217.06,217.53,218.0,218.47,218.94,219.41,219.88,220.34,220.81,221.28,221.75,222.22,222.68,223.15,223.62,224.09,224.55,225.02,225.49,225.96,226.43,226.9,227.37,227.83,228.31,228.78,229.25,229.72,230.19,230.67,231.14,231.62,232.09,232.57,233.05,233.53,234.01,234.5,234.98,235.47,235.95,236.44,236.93,237.43,237.92,238.42,238.92,239.42,239.92,240.43,240.93,241.44,241.96,242.47,242.99,243.51,244.04,244.56,245.09,245.63,246.16,246.7,247.25,247.8,248.35,248.9,249.46,250.03,250.6,251.17,251.75,252.33,252.91,253.51,254.1,254.71,255.31,255.93,256.55,257.17,257.8,258.44,259.08,259.73,260.39,261.05,261.72,262.4,263.09,263.78,264.48,265.19,265.91,266.64,267.37,268.12,268.87,269.64,270.41,271.19,271.99,272.79,273.61,274.44,275.28,276.13,276.99,277.87,278.75,279.66,280.57,281.5,282.45,283.41,284.39,285.38,286.39,287.41,288.45,289.51,290.59,291.69,292.81,293.95,295.11,296.29,297.49,298.72,},
{74.288,75.569,76.826,78.058,79.268,80.454,81.619,82.763,83.886,84.989,86.073,87.138,88.185,89.215,90.227,91.223,92.202,93.166,94.115,95.048,95.968,96.873,97.765,98.644,99.51,100.36,101.2,102.03,102.85,103.66,104.46,105.24,106.02,106.78,107.54,108.28,109.02,109.75,110.47,111.18,111.88,112.57,113.26,113.94,114.61,115.28,115.93,116.58,117.23,117.86,118.5,119.12,119.74,120.35,120.96,121.56,122.16,122.75,123.34,123.92,124.49,125.07,125.63,126.2,126.75,127.31,127.86,128.41,128.95,129.49,130.02,130.56,131.09,131.61,132.13,132.65,133.17,133.68,134.2,134.7,135.21,135.71,136.21,136.71,137.21,137.7,138.2,138.69,139.17,139.66,140.15,140.63,141.11,141.59,142.07,142.55,143.02,143.5,143.97,144.45,144.92,145.39,145.86,146.33,146.8,147.26,147.73,148.2,148.66,149.13,149.59,150.06,150.52,150.99,151.45,151.91,152.38,152.84,153.3,153.77,154.23,154.69,155.16,155.62,156.09,156.55,157.02,157.48,157.95,158.41,158.88,159.35,159.82,160.28,160.75,161.22,161.69,162.16,162.64,163.11,163.58,164.05,164.53,165.01,165.48,165.96,166.44,166.92,167.4,167.88,168.36,168.84,169.33,169.81,170.3,170.78,171.27,171.76,172.25,172.74,173.23,173.73,174.22,174.72,175.21,175.71,176.2,176.7,177.2,177.7,178.2,178.7,179.21,179.71,180.21,180.72,181.22,181.73,182.24,182.74,183.25,183.76,184.27,184.78,185.29,185.8,186.31,186.82,187.33,187.84,188.35,188.86,189.37,189.88,190.39,190.9,191.41,191.91,192.42,192.93,193.44,193.94,194.45,194.96,195.46,195.96,196.47,196.97,197.47,197.97,198.47,198.97,199.47,199.97,200.47,200.96,201.46,201.95,202.44,202.94,203.43,203.92,204.41,204.89,205.38,205.87,206.35,206.84,207.32,207.8,208.28,208.76,209.24,209.72,210.2,210.67,211.15,211.63,212.1,212.57,213.05,213.52,213.99,214.46,214.93,215.4,215.87,216.33,216.8,217.27,217.73,218.2,218.67,219.13,219.6,220.06,220.52,220.99,221.45,221.92,222.38,222.84,223.31,223.77,224.23,224.7,225.16,225.63,226.09,226.55,227.02,227.49,227.95,228.42,228.89,229.35,229.82,230.29,230.76,231.24,231.71,232.18,232.66,233.13,233.61,234.09,234.57,235.05,235.53,236.02,236.5,236.99,237.48,237.98,238.47,238.97,239.46,239.96,240.47,240.97,241.48,241.99,242.5,243.02,243.54,244.06,244.59,245.12,245.65,246.18,246.72,247.26,247.81,248.36,248.91,249.47,250.03,250.6,251.17,251.75,252.33,252.91,253.51,254.1,254.7,255.31,255.92,256.54,257.16,257.79,258.43,259.07,259.72,260.38,261.04,261.71,262.39,263.07,263.77,264.47,265.18,265.89,266.62,267.36,268.1,268.86,269.62,270.39,271.18,271.97,272.78,273.59,274.42,275.26,276.11,276.98,277.85,278.74,279.65,280.56,281.49,282.44,283.4,284.38,285.37,286.38,287.41,288.45,289.51,290.6,291.7,292.82,293.96,295.12,296.3,297.51,},
{75.539,76.799,78.034,79.247,80.436,81.604,82.75,83.875,84.981,86.067,87.134,88.183,89.214,90.228,91.225,92.206,93.171,94.121,95.056,95.977,96.883,97.776,98.656,99.522,100.38,101.22,102.05,102.87,103.67,104.47,105.26,106.03,106.8,107.55,108.3,109.04,109.76,110.48,111.19,111.9,112.59,113.28,113.95,114.62,115.29,115.94,116.59,117.24,117.87,118.5,119.13,119.75,120.36,120.96,121.57,122.16,122.75,123.34,123.92,124.49,125.06,125.63,126.19,126.75,127.3,127.85,128.39,128.94,129.47,130.01,130.54,131.06,131.59,132.11,132.63,133.14,133.65,134.16,134.67,135.17,135.67,136.17,136.67,137.16,137.65,138.14,138.63,139.12,139.6,140.08,140.56,141.04,141.52,142.0,142.47,142.95,143.42,143.89,144.36,144.83,145.29,145.76,146.23,146.69,147.16,147.62,148.08,148.55,149.01,149.47,149.93,150.39,150.85,151.31,151.77,152.23,152.69,153.15,153.61,154.07,154.53,154.99,155.45,155.91,156.37,156.83,157.29,157.75,158.21,158.68,159.14,159.6,160.07,160.53,161.0,161.46,161.93,162.39,162.86,163.33,163.8,164.27,164.74,165.21,165.68,166.16,166.63,167.11,167.58,168.06,168.54,169.02,169.5,169.98,170.46,170.94,171.42,171.91,172.39,172.88,173.37,173.86,174.35,174.84,175.33,175.82,176.31,176.81,177.3,177.8,178.29,178.79,179.29,179.79,180.29,180.79,181.29,181.79,182.29,182.79,183.3,183.8,184.3,184.81,185.31,185.82,186.32,186.83,187.33,187.84,188.35,188.85,189.36,189.86,190.37,190.87,191.38,191.88,192.38,192.89,193.39,193.89,194.39,194.89,195.39,195.89,196.39,196.89,197.39,197.89,198.38,198.88,199.37,199.86,200.36,200.85,201.34,201.83,202.32,202.8,203.29,203.78,204.26,204.74,205.23,205.71,206.19,206.67,207.15,207.63,208.1,208.58,209.05,209.53,210.0,210.47,210.95,211.42,211.89,212.36,212.83,213.29,213.76,214.23,214.69,215.16,215.62,216.09,216.55,217.01,217.47,217.94,218.4,218.86,219.32,219.78,220.24,220.7,221.16,221.62,222.08,222.54,223.0,223.46,223.92,224.38,224.84,225.3,225.76,226.22,226.68,227.14,227.61,228.07,228.53,229.0,229.46,229.93,230.39,230.86,231.33,231.8,232.27,232.74,233.21,233.69,234.16,234.64,235.12,235.6,236.08,236.57,237.05,237.54,238.03,238.52,239.02,239.51,240.01,240.51,241.01,241.52,242.03,242.54,243.05,243.57,244.09,244.61,245.14,245.67,246.2,246.74,247.28,247.83,248.37,248.93,249.48,250.04,250.61,251.18,251.75,252.33,252.92,253.51,254.1,254.7,255.31,255.92,256.54,257.16,257.79,258.42,259.07,259.71,260.37,261.03,261.7,262.38,263.06,263.76,264.46,265.17,265.88,266.61,267.35,268.09,268.85,269.61,270.38,271.17,271.96,272.77,273.58,274.41,275.25,276.1,276.97,277.85,278.74,279.64,280.56,281.49,282.44,283.4,284.38,285.38,286.39,287.42,288.46,289.53,290.61,291.71,292.83,293.98,295.14,296.33,},
{76.759,77.998,79.214,80.406,81.577,82.726,83.854,84.962,86.05,87.119,88.17,89.204,90.219,91.218,92.201,93.168,94.119,95.055,95.977,96.885,97.779,98.659,99.527,100.38,101.22,102.06,102.87,103.68,104.48,105.27,106.04,106.81,107.56,108.31,109.05,109.77,110.49,111.2,111.9,112.6,113.28,113.96,114.63,115.3,115.95,116.6,117.24,117.88,118.51,119.13,119.75,120.36,120.97,121.57,122.16,122.75,123.33,123.91,124.49,125.06,125.62,126.18,126.74,127.29,127.84,128.38,128.92,129.45,129.99,130.52,131.04,131.56,132.08,132.6,133.11,133.62,134.13,134.63,135.13,135.63,136.13,136.62,137.11,137.6,138.09,138.58,139.06,139.54,140.02,140.5,140.98,141.45,141.92,142.4,142.87,143.34,143.8,144.27,144.74,145.2,145.67,146.13,146.59,147.05,147.51,147.97,148.43,148.89,149.35,149.8,150.26,150.72,151.17,151.63,152.09,152.54,153.0,153.45,153.91,154.37,154.82,155.28,155.73,156.19,156.65,157.1,157.56,158.02,158.48,158.93,159.39,159.85,160.31,160.77,161.23,161.7,162.16,162.62,163.08,163.55,164.01,164.48,164.95,165.41,165.88,166.35,166.82,167.29,167.77,168.24,168.71,169.19,169.66,170.14,170.62,171.09,171.57,172.05,172.54,173.02,173.5,173.98,174.47,174.96,175.44,175.93,176.42,176.91,177.4,177.89,178.38,178.88,179.37,179.86,180.36,180.85,181.35,181.85,182.34,182.84,183.34,183.84,184.34,184.84,185.34,185.84,186.34,186.84,187.34,187.84,188.34,188.85,189.35,189.85,190.35,190.85,191.35,191.85,192.35,192.84,193.34,193.84,194.34,194.83,195.33,195.82,196.32,196.81,197.31,197.8,198.29,198.78,199.27,199.76,200.25,200.73,201.22,201.7,202.19,202.67,203.15,203.64,204.12,204.6,205.07,205.55,206.03,206.5,206.98,207.45,207.93,208.4,208.87,209.34,209.81,210.28,210.75,211.21,211.68,212.14,212.61,213.07,213.53,214.0,214.46,214.92,215.38,215.84,216.3,216.76,217.22,217.68,218.13,218.59,219.05,219.5,219.96,220.42,220.87,221.33,221.78,222.24,222.7,223.15,223.61,224.06,224.52,224.98,225.43,225.89,226.35,226.81,227.26,227.72,228.18,228.64,229.1,229.57,230.03,230.49,230.96,231.42,231.89,232.36,232.83,233.3,233.77,234.24,234.71,235.19,235.67,236.15,236.63,237.11,237.6,238.09,238.57,239.07,239.56,240.06,240.55,241.06,241.56,242.07,242.58,243.09,243.6,244.12,244.64,245.17,245.7,246.23,246.76,247.3,247.85,248.39,248.94,249.5,250.06,250.62,251.19,251.76,252.34,252.93,253.51,254.11,254.71,255.31,255.92,256.54,257.16,257.79,258.42,259.06,259.71,260.37,261.03,261.7,262.38,263.06,263.75,264.45,265.16,265.88,266.61,267.34,268.09,268.84,269.61,270.38,271.16,271.96,272.77,273.58,274.41,275.25,276.11,276.97,277.85,278.74,279.65,280.57,281.5,282.45,283.41,284.39,285.39,286.4,287.43,288.48,289.55,290.63,291.74,292.86,294.01,295.18,},
{77.95,79.169,80.365,81.538,82.69,83.821,84.932,86.023,87.095,88.148,89.183,90.201,91.202,92.186,93.155,94.108,95.046,95.969,96.878,97.773,98.655,99.523,100.38,101.22,102.05,102.87,103.68,104.48,105.27,106.04,106.81,107.57,108.31,109.05,109.78,110.5,111.21,111.91,112.6,113.29,113.96,114.64,115.3,115.95,116.6,117.24,117.88,118.51,119.13,119.75,120.36,120.96,121.56,122.15,122.74,123.33,123.9,124.48,125.05,125.61,126.17,126.72,127.27,127.82,128.36,128.9,129.43,129.96,130.49,131.02,131.54,132.05,132.57,133.08,133.59,134.09,134.59,135.09,135.59,136.08,136.58,137.07,137.55,138.04,138.52,139.0,139.48,139.96,140.44,140.91,141.38,141.85,142.32,142.79,143.26,143.72,144.18,144.65,145.11,145.57,146.03,146.49,146.95,147.4,147.86,148.32,148.77,149.23,149.68,150.13,150.59,151.04,151.49,151.95,152.4,152.85,153.3,153.75,154.21,154.66,155.11,155.56,156.01,156.47,156.92,157.37,157.83,158.28,158.73,159.19,159.64,160.1,160.56,161.01,161.47,161.93,162.39,162.84,163.3,163.76,164.23,164.69,165.15,165.61,166.08,166.54,167.01,167.48,167.95,168.41,168.88,169.35,169.83,170.3,170.77,171.25,171.72,172.2,172.67,173.15,173.63,174.11,174.59,175.07,175.56,176.04,176.52,177.01,177.5,177.98,178.47,178.96,179.45,179.94,180.43,180.92,181.41,181.9,182.4,182.89,183.38,183.88,184.37,184.87,185.37,185.86,186.36,186.85,187.35,187.85,188.34,188.84,189.34,189.83,190.33,190.82,191.32,191.81,192.31,192.8,193.3,193.79,194.28,194.77,195.27,195.76,196.25,196.74,197.22,197.71,198.2,198.69,199.17,199.66,200.14,200.62,201.1,201.58,202.06,202.54,203.02,203.5,203.97,204.45,204.92,205.4,205.87,206.34,206.81,207.28,207.75,208.22,208.69,209.15,209.62,210.08,210.55,211.01,211.47,211.93,212.39,212.85,213.31,213.77,214.23,214.69,215.14,215.6,216.06,216.51,216.97,217.42,217.87,218.33,218.78,219.23,219.69,220.14,220.59,221.04,221.49,221.95,222.4,222.85,223.3,223.75,224.21,224.66,225.11,225.57,226.02,226.47,226.93,227.38,227.84,228.3,228.75,229.21,229.67,230.13,230.59,231.05,231.51,231.98,232.44,232.91,233.38,233.85,234.32,234.79,235.26,235.74,236.21,236.69,237.17,237.66,238.14,238.63,239.12,239.61,240.1,240.6,241.1,241.6,242.11,242.61,243.12,243.64,244.15,244.67,245.2,245.72,246.25,246.79,247.33,247.87,248.41,248.96,249.52,250.07,250.64,251.21,251.78,252.35,252.94,253.52,254.12,254.72,255.32,255.93,256.54,257.17,257.79,258.43,259.07,259.72,260.37,261.03,261.7,262.38,263.06,263.76,264.46,265.16,265.88,266.61,267.34,268.09,268.84,269.61,270.38,271.17,271.96,272.77,273.59,274.42,275.26,276.11,276.98,277.86,278.75,279.66,280.58,281.52,282.47,283.43,284.42,285.41,286.43,287.46,288.51,289.58,290.67,291.78,292.91,294.05,},
{79.113,80.312,81.489,82.644,83.778,84.891,85.985,87.059,88.115,89.153,90.173,91.176,92.162,93.133,94.087,95.027,95.952,96.862,97.759,98.642,99.512,100.37,101.21,102.05,102.87,103.68,104.47,105.26,106.04,106.8,107.56,108.31,109.05,109.77,110.49,111.2,111.91,112.6,113.28,113.96,114.63,115.29,115.95,116.6,117.24,117.87,118.5,119.13,119.74,120.35,120.95,121.55,122.15,122.73,123.32,123.89,124.46,125.03,125.59,126.15,126.71,127.25,127.8,128.34,128.88,129.41,129.94,130.47,130.99,131.51,132.02,132.53,133.04,133.55,134.05,134.55,135.05,135.55,136.04,136.53,137.02,137.5,137.98,138.47,138.94,139.42,139.9,140.37,140.84,141.31,141.78,142.25,142.71,143.17,143.64,144.1,144.56,145.02,145.48,145.93,146.39,146.84,147.3,147.75,148.2,148.66,149.11,149.56,150.01,150.46,150.91,151.36,151.81,152.25,152.7,153.15,153.6,154.05,154.5,154.94,155.39,155.84,156.29,156.74,157.19,157.64,158.09,158.54,158.99,159.44,159.89,160.34,160.79,161.25,161.7,162.15,162.61,163.06,163.52,163.98,164.43,164.89,165.35,165.81,166.27,166.73,167.2,167.66,168.12,168.59,169.05,169.52,169.99,170.46,170.92,171.4,171.87,172.34,172.81,173.29,173.76,174.24,174.71,175.19,175.67,176.15,176.63,177.11,177.59,178.07,178.56,179.04,179.53,180.01,180.5,180.98,181.47,181.96,182.45,182.94,183.43,183.92,184.41,184.9,185.39,185.88,186.37,186.87,187.36,187.85,188.34,188.83,189.33,189.82,190.31,190.8,191.29,191.78,192.27,192.76,193.25,193.74,194.23,194.72,195.2,195.69,196.17,196.66,197.14,197.63,198.11,198.59,199.07,199.55,200.03,200.51,200.99,201.47,201.94,202.42,202.89,203.36,203.84,204.31,204.78,205.25,205.72,206.18,206.65,207.12,207.58,208.04,208.51,208.97,209.43,209.89,210.35,210.81,211.27,211.73,212.18,212.64,213.1,213.55,214.0,214.46,214.91,215.36,215.81,216.27,216.72,217.17,217.62,218.07,218.52,218.97,219.41,219.86,220.31,220.76,221.21,221.66,222.11,222.55,223.0,223.45,223.9,224.35,224.8,225.25,225.7,226.15,226.6,227.05,227.5,227.95,228.41,228.86,229.32,229.77,230.23,230.69,231.15,231.61,232.07,232.53,232.99,233.46,233.92,234.39,234.86,235.33,235.81,236.28,236.76,237.24,237.72,238.2,238.68,239.17,239.66,240.15,240.65,241.15,241.65,242.15,242.65,243.16,243.67,244.19,244.71,245.23,245.75,246.28,246.82,247.35,247.89,248.44,248.99,249.54,250.1,250.66,251.22,251.79,252.37,252.95,253.54,254.13,254.73,255.33,255.94,256.55,257.18,257.8,258.44,259.08,259.72,260.38,261.04,261.71,262.39,263.07,263.76,264.46,265.17,265.89,266.62,267.35,268.1,268.85,269.62,270.39,271.18,271.98,272.78,273.6,274.43,275.28,276.13,277.0,277.88,278.78,279.68,280.61,281.54,282.5,283.46,284.45,285.45,286.47,287.5,288.55,289.63,290.72,291.83,292.96,},
{80.247,81.428,82.586,83.724,84.84,85.937,87.014,88.072,89.113,90.135,91.141,92.129,93.102,94.058,95.0,95.926,96.838,97.737,98.621,99.492,100.35,101.2,102.03,102.85,103.66,104.46,105.25,106.03,106.79,107.55,108.3,109.04,109.76,110.48,111.19,111.9,112.59,113.28,113.95,114.62,115.29,115.94,116.59,117.23,117.87,118.49,119.12,119.73,120.34,120.94,121.54,122.13,122.72,123.3,123.88,124.45,125.01,125.58,126.13,126.68,127.23,127.78,128.32,128.85,129.38,129.91,130.44,130.96,131.47,131.99,132.5,133.01,133.51,134.01,134.51,135.01,135.5,135.99,136.48,136.96,137.45,137.93,138.41,138.88,139.36,139.83,140.3,140.77,141.24,141.71,142.17,142.63,143.09,143.55,144.01,144.47,144.93,145.38,145.84,146.29,146.74,147.19,147.64,148.09,148.54,148.99,149.44,149.88,150.33,150.78,151.22,151.67,152.11,152.56,153.0,153.45,153.89,154.34,154.78,155.23,155.67,156.12,156.56,157.01,157.45,157.9,158.34,158.79,159.24,159.69,160.13,160.58,161.03,161.48,161.93,162.38,162.83,163.28,163.73,164.19,164.64,165.09,165.55,166.01,166.46,166.92,167.38,167.84,168.3,168.76,169.22,169.68,170.15,170.61,171.08,171.54,172.01,172.48,172.95,173.42,173.89,174.36,174.83,175.3,175.78,176.25,176.73,177.21,177.68,178.16,178.64,179.12,179.6,180.08,180.57,181.05,181.53,182.01,182.5,182.98,183.47,183.96,184.44,184.93,185.41,185.9,186.39,186.88,187.36,187.85,188.34,188.83,189.32,189.8,190.29,190.78,191.26,191.75,192.24,192.72,193.21,193.69,194.17,194.66,195.14,195.62,196.1,196.58,197.06,197.54,198.02,198.5,198.98,199.45,199.93,200.4,200.88,201.35,201.82,202.29,202.76,203.23,203.7,204.17,204.63,205.1,205.56,206.03,206.49,206.95,207.41,207.87,208.33,208.79,209.25,209.7,210.16,210.62,211.07,211.52,211.98,212.43,212.88,213.33,213.78,214.23,214.68,215.13,215.58,216.03,216.47,216.92,217.37,217.81,218.26,218.7,219.15,219.59,220.04,220.48,220.93,221.37,221.82,222.26,222.71,223.15,223.6,224.04,224.49,224.93,225.38,225.83,226.27,226.72,227.17,227.62,228.07,228.52,228.97,229.42,229.87,230.33,230.78,231.24,231.7,232.15,232.61,233.08,233.54,234.0,234.47,234.94,235.4,235.87,236.35,236.82,237.3,237.78,238.26,238.74,239.23,239.71,240.2,240.7,241.19,241.69,242.19,242.7,243.2,243.71,244.23,244.74,245.26,245.79,246.31,246.85,247.38,247.92,248.46,249.01,249.56,250.12,250.68,251.24,251.82,252.39,252.97,253.56,254.15,254.74,255.35,255.96,256.57,257.19,257.82,258.45,259.09,259.74,260.39,261.05,261.72,262.4,263.08,263.78,264.48,265.19,265.91,266.63,267.37,268.11,268.87,269.64,270.41,271.2,272.0,272.8,273.62,274.46,275.3,276.16,277.03,277.91,278.8,279.71,280.64,281.58,282.53,283.5,284.49,285.49,286.51,287.55,288.6,289.68,290.77,291.89,},
{81.356,82.518,83.658,84.778,85.878,86.958,88.02,89.063,90.088,91.096,92.087,93.061,94.02,94.964,95.892,96.806,97.706,98.592,99.465,100.32,101.17,102.01,102.83,103.64,104.44,105.23,106.01,106.78,107.53,108.28,109.02,109.75,110.47,111.18,111.88,112.58,113.26,113.94,114.61,115.27,115.93,116.58,117.22,117.85,118.48,119.1,119.72,120.32,120.93,121.52,122.12,122.7,123.28,123.86,124.43,124.99,125.55,126.11,126.66,127.21,127.75,128.29,128.82,129.35,129.88,130.4,130.92,131.44,131.95,132.46,132.97,133.47,133.97,134.47,134.96,135.45,135.94,136.43,136.91,137.39,137.87,138.35,138.82,139.3,139.77,140.24,140.7,141.17,141.63,142.09,142.55,143.01,143.47,143.93,144.38,144.84,145.29,145.74,146.19,146.64,147.09,147.53,147.98,148.43,148.87,149.32,149.76,150.21,150.65,151.09,151.53,151.98,152.42,152.86,153.3,153.74,154.18,154.62,155.06,155.51,155.95,156.39,156.83,157.27,157.71,158.16,158.6,159.04,159.48,159.93,160.37,160.82,161.26,161.71,162.15,162.6,163.05,163.49,163.94,164.39,164.84,165.29,165.74,166.2,166.65,167.1,167.56,168.01,168.47,168.93,169.38,169.84,170.3,170.76,171.22,171.69,172.15,172.61,173.08,173.54,174.01,174.48,174.95,175.42,175.89,176.36,176.83,177.3,177.78,178.25,178.73,179.2,179.68,180.15,180.63,181.11,181.59,182.07,182.55,183.03,183.51,183.99,184.47,184.96,185.44,185.92,186.41,186.89,187.37,187.86,188.34,188.82,189.31,189.79,190.27,190.75,191.24,191.72,192.2,192.68,193.16,193.64,194.12,194.6,195.08,195.56,196.03,196.51,196.99,197.46,197.94,198.41,198.88,199.35,199.83,200.3,200.76,201.23,201.7,202.17,202.63,203.1,203.56,204.03,204.49,204.95,205.41,205.87,206.33,206.79,207.25,207.7,208.16,208.61,209.07,209.52,209.97,210.42,210.87,211.32,211.77,212.22,212.67,213.12,213.56,214.01,214.45,214.9,215.34,215.79,216.23,216.68,217.12,217.56,218.0,218.44,218.89,219.33,219.77,220.21,220.65,221.09,221.53,221.97,222.42,222.86,223.3,223.74,224.18,224.62,225.07,225.51,225.95,226.4,226.84,227.29,227.73,228.18,228.63,229.08,229.53,229.98,230.43,230.88,231.33,231.79,232.24,232.7,233.16,233.62,234.08,234.54,235.01,235.48,235.94,236.41,236.89,237.36,237.84,238.32,238.8,239.28,239.77,240.26,240.75,241.24,241.74,242.24,242.74,243.25,243.75,244.27,244.78,245.3,245.82,246.35,246.88,247.41,247.95,248.49,249.04,249.59,250.15,250.71,251.27,251.84,252.41,252.99,253.58,254.17,254.77,255.37,255.98,256.59,257.21,257.84,258.47,259.11,259.76,260.41,261.07,261.74,262.42,263.1,263.8,264.5,265.21,265.93,266.65,267.39,268.14,268.89,269.66,270.44,271.22,272.02,272.83,273.65,274.49,275.33,276.19,277.06,277.94,278.84,279.75,280.68,281.62,282.58,283.55,284.54,285.54,286.57,287.61,288.67,289.74,290.84,},
{82.438,83.583,84.706,85.809,86.893,87.957,89.003,90.031,91.041,92.035,93.012,93.973,94.919,95.85,96.766,97.667,98.555,99.43,100.29,101.14,101.98,102.8,103.61,104.41,105.2,105.98,106.75,107.51,108.26,109.0,109.73,110.45,111.16,111.86,112.56,113.24,113.92,114.59,115.25,115.91,116.56,117.2,117.83,118.46,119.08,119.7,120.3,120.91,121.5,122.09,122.68,123.26,123.83,124.4,124.97,125.53,126.08,126.63,127.18,127.72,128.26,128.79,129.32,129.85,130.37,130.89,131.4,131.91,132.42,132.93,133.43,133.93,134.42,134.91,135.4,135.89,136.38,136.86,137.34,137.81,138.29,138.76,139.23,139.7,140.17,140.63,141.1,141.56,142.02,142.48,142.93,143.39,143.84,144.29,144.74,145.19,145.64,146.09,146.54,146.98,147.43,147.87,148.32,148.76,149.2,149.64,150.08,150.52,150.96,151.4,151.84,152.28,152.72,153.15,153.59,154.03,154.47,154.9,155.34,155.78,156.22,156.66,157.09,157.53,157.97,158.41,158.85,159.29,159.73,160.17,160.61,161.05,161.49,161.93,162.37,162.82,163.26,163.7,164.15,164.59,165.04,165.49,165.94,166.38,166.83,167.28,167.73,168.19,168.64,169.09,169.55,170.0,170.46,170.91,171.37,171.83,172.29,172.75,173.21,173.67,174.13,174.6,175.06,175.53,175.99,176.46,176.93,177.4,177.87,178.34,178.81,179.28,179.75,180.22,180.7,181.17,181.65,182.12,182.6,183.08,183.55,184.03,184.51,184.99,185.46,185.94,186.42,186.9,187.38,187.86,188.34,188.82,189.3,189.77,190.25,190.73,191.21,191.69,192.16,192.64,193.12,193.59,194.07,194.54,195.02,195.49,195.97,196.44,196.91,197.38,197.85,198.32,198.79,199.26,199.72,200.19,200.66,201.12,201.58,202.05,202.51,202.97,203.43,203.89,204.35,204.81,205.26,205.72,206.17,206.63,207.08,207.53,207.99,208.44,208.89,209.34,209.78,210.23,210.68,211.13,211.57,212.02,212.46,212.9,213.35,213.79,214.23,214.67,215.11,215.56,216.0,216.43,216.87,217.31,217.75,218.19,218.63,219.07,219.5,219.94,220.38,220.82,221.25,221.69,222.13,222.57,223.01,223.44,223.88,224.32,224.76,225.2,225.64,226.08,226.52,226.96,227.41,227.85,228.29,228.74,229.18,229.63,230.08,230.53,230.98,231.43,231.88,232.33,232.79,233.24,233.7,234.16,234.62,235.08,235.55,236.01,236.48,236.95,237.43,237.9,238.38,238.86,239.34,239.82,240.31,240.8,241.29,241.79,242.28,242.79,243.29,243.8,244.31,244.82,245.34,245.86,246.39,246.91,247.45,247.98,248.53,249.07,249.62,250.18,250.73,251.3,251.87,252.44,253.02,253.61,254.2,254.79,255.39,256.0,256.61,257.23,257.86,258.49,259.13,259.78,260.43,261.1,261.77,262.44,263.13,263.82,264.52,265.23,265.95,266.68,267.42,268.16,268.92,269.69,270.47,271.26,272.06,272.87,273.69,274.52,275.37,276.23,277.1,277.99,278.89,279.8,280.73,281.67,282.63,283.61,284.6,285.61,286.63,287.67,288.74,289.82,},
{83.496,84.623,85.73,86.817,87.885,88.934,89.965,90.978,91.974,92.954,93.918,94.866,95.798,96.717,97.62,98.51,99.386,100.25,101.1,101.94,102.76,103.58,104.38,105.17,105.95,106.72,107.48,108.23,108.97,109.7,110.42,111.13,111.84,112.53,113.22,113.9,114.57,115.23,115.89,116.53,117.18,117.81,118.44,119.06,119.67,120.28,120.88,121.48,122.07,122.65,123.23,123.81,124.38,124.94,125.5,126.05,126.6,127.15,127.69,128.23,128.76,129.29,129.81,130.33,130.85,131.36,131.87,132.38,132.88,133.38,133.88,134.37,134.87,135.35,135.84,136.32,136.8,137.28,137.76,138.23,138.7,139.17,139.64,140.1,140.56,141.02,141.48,141.94,142.4,142.85,143.3,143.76,144.21,144.65,145.1,145.55,145.99,146.44,146.88,147.32,147.76,148.2,148.64,149.08,149.52,149.96,150.4,150.83,151.27,151.7,152.14,152.57,153.01,153.44,153.88,154.31,154.75,155.18,155.62,156.05,156.48,156.92,157.35,157.79,158.22,158.66,159.09,159.53,159.96,160.4,160.84,161.28,161.71,162.15,162.59,163.03,163.47,163.91,164.35,164.79,165.24,165.68,166.12,166.57,167.02,167.46,167.91,168.36,168.81,169.25,169.71,170.16,170.61,171.06,171.52,171.97,172.43,172.88,173.34,173.8,174.26,174.72,175.18,175.64,176.1,176.56,177.03,177.49,177.96,178.42,178.89,179.36,179.83,180.29,180.76,181.23,181.7,182.18,182.65,183.12,183.59,184.07,184.54,185.01,185.49,185.96,186.44,186.91,187.39,187.86,188.34,188.81,189.29,189.76,190.23,190.71,191.18,191.66,192.13,192.6,193.07,193.55,194.02,194.49,194.96,195.43,195.9,196.37,196.83,197.3,197.77,198.23,198.7,199.16,199.62,200.09,200.55,201.01,201.47,201.93,202.39,202.84,203.3,203.75,204.21,204.66,205.12,205.57,206.02,206.47,206.92,207.37,207.82,208.26,208.71,209.16,209.6,210.04,210.49,210.93,211.37,211.81,212.26,212.7,213.14,213.57,214.01,214.45,214.89,215.33,215.76,216.2,216.63,217.07,217.5,217.94,218.37,218.81,219.24,219.68,220.11,220.55,220.98,221.41,221.85,222.28,222.72,223.15,223.59,224.02,224.46,224.89,225.33,225.77,226.21,226.64,227.08,227.52,227.96,228.4,228.85,229.29,229.73,230.18,230.62,231.07,231.52,231.97,232.42,232.87,233.33,233.78,234.24,234.7,235.16,235.62,236.09,236.55,237.02,237.49,237.96,238.44,238.92,239.4,239.88,240.37,240.85,241.34,241.84,242.33,242.83,243.34,243.84,244.35,244.86,245.38,245.9,246.43,246.95,247.49,248.02,248.56,249.11,249.66,250.21,250.77,251.33,251.9,252.47,253.05,253.64,254.23,254.82,255.42,256.03,256.64,257.26,257.89,258.52,259.16,259.81,260.46,261.13,261.79,262.47,263.16,263.85,264.55,265.26,265.98,266.71,267.45,268.2,268.96,269.73,270.51,271.29,272.1,272.91,273.73,274.57,275.42,276.28,277.15,278.04,278.94,279.86,280.79,281.73,282.7,283.67,284.67,285.68,286.71,287.75,288.82,},
{84.529,85.64,86.731,87.802,88.854,89.889,90.905,91.904,92.887,93.853,94.804,95.739,96.659,97.565,98.457,99.335,100.2,101.05,101.89,102.72,103.53,104.34,105.13,105.91,106.68,107.44,108.2,108.94,109.67,110.39,111.1,111.81,112.5,113.19,113.87,114.54,115.2,115.86,116.51,117.15,117.78,118.41,119.03,119.64,120.25,120.85,121.45,122.04,122.62,123.2,123.78,124.35,124.91,125.47,126.02,126.57,127.12,127.66,128.19,128.72,129.25,129.77,130.29,130.81,131.32,131.83,132.34,132.84,133.34,133.83,134.33,134.82,135.3,135.79,136.27,136.75,137.22,137.7,138.17,138.64,139.1,139.57,140.03,140.49,140.95,141.41,141.86,142.32,142.77,143.22,143.67,144.12,144.56,145.01,145.45,145.9,146.34,146.78,147.22,147.66,148.09,148.53,148.97,149.4,149.84,150.27,150.71,151.14,151.57,152.0,152.44,152.87,153.3,153.73,154.16,154.59,155.02,155.45,155.88,156.31,156.75,157.18,157.61,158.04,158.47,158.9,159.33,159.77,160.2,160.63,161.07,161.5,161.93,162.37,162.81,163.24,163.68,164.11,164.55,164.99,165.43,165.87,166.31,166.75,167.19,167.64,168.08,168.52,168.97,169.42,169.86,170.31,170.76,171.21,171.66,172.11,172.56,173.01,173.47,173.92,174.38,174.83,175.29,175.75,176.2,176.66,177.12,177.58,178.04,178.51,178.97,179.43,179.9,180.36,180.83,181.29,181.76,182.23,182.7,183.16,183.63,184.1,184.57,185.04,185.51,185.98,186.45,186.92,187.39,187.86,188.33,188.8,189.28,189.75,190.22,190.69,191.16,191.63,192.09,192.56,193.03,193.5,193.97,194.43,194.9,195.37,195.83,196.29,196.76,197.22,197.68,198.14,198.61,199.07,199.52,199.98,200.44,200.9,201.35,201.81,202.26,202.72,203.17,203.62,204.07,204.52,204.97,205.42,205.87,206.31,206.76,207.21,207.65,208.09,208.54,208.98,209.42,209.86,210.3,210.74,211.18,211.62,212.05,212.49,212.93,213.36,213.8,214.23,214.67,215.1,215.53,215.96,216.4,216.83,217.26,217.69,218.12,218.56,218.99,219.42,219.85,220.28,220.71,221.14,221.57,222.0,222.43,222.86,223.3,223.73,224.16,224.59,225.03,225.46,225.89,226.33,226.76,227.2,227.64,228.07,228.51,228.95,229.39,229.83,230.28,230.72,231.17,231.61,232.06,232.51,232.96,233.41,233.86,234.32,234.78,235.23,235.7,236.16,236.62,237.09,237.56,238.03,238.5,238.98,239.46,239.94,240.42,240.91,241.4,241.89,242.39,242.88,243.38,243.89,244.4,244.91,245.43,245.94,246.47,246.99,247.53,248.06,248.6,249.14,249.69,250.25,250.8,251.37,251.93,252.51,253.09,253.67,254.26,254.85,255.46,256.06,256.68,257.3,257.92,258.56,259.2,259.84,260.5,261.16,261.83,262.51,263.19,263.89,264.59,265.3,266.02,266.75,267.49,268.24,269.0,269.77,270.55,271.34,272.14,272.96,273.78,274.62,275.47,276.33,277.21,278.1,279.0,279.92,280.86,281.8,282.77,283.75,284.74,285.76,286.79,287.84,},
{85.54,86.634,87.709,88.765,89.803,90.823,91.825,92.81,93.78,94.733,95.671,96.594,97.502,98.396,99.276,100.14,101.0,101.84,102.67,103.49,104.29,105.08,105.87,106.64,107.4,108.15,108.9,109.63,110.35,111.06,111.77,112.47,113.15,113.83,114.5,115.17,115.82,116.47,117.11,117.75,118.38,119.0,119.61,120.22,120.82,121.42,122.01,122.59,123.17,123.74,124.31,124.87,125.43,125.99,126.53,127.08,127.62,128.15,128.68,129.21,129.73,130.25,130.77,131.28,131.79,132.29,132.79,133.29,133.78,134.27,134.76,135.25,135.73,136.21,136.69,137.16,137.63,138.1,138.57,139.04,139.5,139.96,140.42,140.88,141.33,141.79,142.24,142.69,143.14,143.58,144.03,144.47,144.92,145.36,145.8,146.24,146.68,147.11,147.55,147.98,148.42,148.85,149.29,149.72,150.15,150.58,151.01,151.44,151.87,152.3,152.73,153.16,153.58,154.01,154.44,154.87,155.29,155.72,156.15,156.58,157.0,157.43,157.86,158.29,158.72,159.14,159.57,160.0,160.43,160.86,161.29,161.72,162.15,162.58,163.02,163.45,163.88,164.32,164.75,165.19,165.62,166.06,166.49,166.93,167.37,167.81,168.25,168.69,169.13,169.57,170.02,170.46,170.91,171.35,171.8,172.24,172.69,173.14,173.59,174.04,174.49,174.94,175.4,175.85,176.31,176.76,177.22,177.67,178.13,178.59,179.05,179.51,179.97,180.43,180.89,181.35,181.82,182.28,182.74,183.21,183.67,184.14,184.6,185.07,185.53,186.0,186.47,186.93,187.4,187.87,188.33,188.8,189.27,189.73,190.2,190.66,191.13,191.6,192.06,192.53,192.99,193.45,193.92,194.38,194.84,195.3,195.76,196.22,196.68,197.14,197.6,198.06,198.52,198.97,199.43,199.88,200.34,200.79,201.24,201.69,202.14,202.59,203.04,203.49,203.94,204.38,204.83,205.27,205.72,206.16,206.6,207.05,207.49,207.93,208.37,208.8,209.24,209.68,210.12,210.55,210.99,211.42,211.85,212.29,212.72,213.15,213.58,214.02,214.45,214.88,215.31,215.74,216.16,216.59,217.02,217.45,217.88,218.31,218.73,219.16,219.59,220.02,220.44,220.87,221.3,221.73,222.15,222.58,223.01,223.44,223.87,224.3,224.73,225.16,225.59,226.02,226.45,226.88,227.32,227.75,228.19,228.62,229.06,229.5,229.94,230.38,230.82,231.26,231.7,232.15,232.6,233.04,233.49,233.95,234.4,234.85,235.31,235.77,236.23,236.69,237.16,237.63,238.1,238.57,239.04,239.52,240.0,240.48,240.97,241.45,241.94,242.44,242.94,243.44,243.94,244.45,244.96,245.47,245.99,246.51,247.04,247.57,248.1,248.64,249.19,249.73,250.29,250.84,251.41,251.97,252.55,253.12,253.71,254.3,254.89,255.49,256.1,256.71,257.33,257.96,258.59,259.23,259.88,260.54,261.2,261.87,262.55,263.23,263.93,264.63,265.35,266.07,266.8,267.54,268.29,269.05,269.82,270.6,271.39,272.2,273.01,273.84,274.68,275.53,276.4,277.28,278.17,279.07,280.0,280.93,281.88,282.85,283.83,284.83,285.85,286.88,},
{86.528,87.607,88.667,89.708,90.731,91.737,92.725,93.697,94.654,95.594,96.52,97.431,98.327,99.21,100.08,100.94,101.78,102.61,103.43,104.24,105.03,105.82,106.59,107.35,108.11,108.85,109.58,110.31,111.02,111.73,112.42,113.11,113.79,114.46,115.13,115.78,116.43,117.08,117.71,118.34,118.96,119.57,120.18,120.78,121.38,121.97,122.55,123.13,123.71,124.27,124.84,125.39,125.95,126.49,127.04,127.58,128.11,128.64,129.17,129.69,130.21,130.72,131.23,131.74,132.24,132.74,133.24,133.73,134.22,134.71,135.19,135.67,136.15,136.63,137.1,137.57,138.04,138.51,138.97,139.43,139.89,140.35,140.8,141.26,141.71,142.16,142.61,143.05,143.5,143.94,144.38,144.82,145.26,145.7,146.14,146.57,147.01,147.44,147.88,148.31,148.74,149.17,149.6,150.03,150.46,150.88,151.31,151.74,152.16,152.59,153.01,153.44,153.86,154.29,154.71,155.14,155.56,155.99,156.41,156.83,157.26,157.68,158.11,158.53,158.96,159.38,159.81,160.23,160.66,161.09,161.51,161.94,162.37,162.8,163.22,163.65,164.08,164.51,164.94,165.38,165.81,166.24,166.67,167.11,167.54,167.98,168.42,168.85,169.29,169.73,170.17,170.61,171.05,171.49,171.94,172.38,172.82,173.27,173.71,174.16,174.61,175.06,175.51,175.96,176.41,176.86,177.31,177.76,178.22,178.67,179.13,179.58,180.04,180.5,180.95,181.41,181.87,182.33,182.79,183.25,183.71,184.17,184.63,185.09,185.56,186.02,186.48,186.94,187.41,187.87,188.33,188.79,189.26,189.72,190.18,190.64,191.1,191.57,192.03,192.49,192.95,193.41,193.87,194.33,194.78,195.24,195.7,196.16,196.61,197.07,197.52,197.97,198.43,198.88,199.33,199.78,200.23,200.68,201.13,201.58,202.02,202.47,202.92,203.36,203.8,204.25,204.69,205.13,205.57,206.01,206.45,206.89,207.32,207.76,208.2,208.63,209.07,209.5,209.93,210.37,210.8,211.23,211.66,212.09,212.52,212.95,213.37,213.8,214.23,214.66,215.08,215.51,215.93,216.36,216.79,217.21,217.63,218.06,218.48,218.91,219.33,219.76,220.18,220.6,221.03,221.45,221.88,222.3,222.73,223.15,223.58,224.0,224.43,224.86,225.29,225.71,226.14,226.57,227.0,227.43,227.86,228.3,228.73,229.17,229.6,230.04,230.48,230.92,231.36,231.8,232.24,232.69,233.13,233.58,234.03,234.48,234.93,235.39,235.85,236.3,236.77,237.23,237.69,238.16,238.63,239.11,239.58,240.06,240.54,241.02,241.51,242.0,242.49,242.99,243.49,243.99,244.5,245.01,245.52,246.04,246.56,247.09,247.62,248.15,248.69,249.23,249.78,250.33,250.89,251.45,252.02,252.59,253.17,253.75,254.34,254.93,255.53,256.14,256.76,257.38,258.0,258.64,259.28,259.93,260.58,261.24,261.91,262.59,263.28,263.98,264.68,265.39,266.12,266.85,267.59,268.34,269.1,269.88,270.66,271.45,272.26,273.08,273.91,274.75,275.6,276.47,277.35,278.24,279.15,280.08,281.02,281.97,282.94,283.93,284.93,285.95,},
{87.494,88.558,89.603,90.63,91.639,92.631,93.606,94.566,95.509,96.437,97.351,98.25,99.135,100.01,100.87,101.71,102.54,103.36,104.17,104.97,105.76,106.53,107.3,108.05,108.8,109.53,110.26,110.97,111.68,112.38,113.06,113.75,114.42,115.08,115.74,116.39,117.03,117.67,118.3,118.92,119.53,120.14,120.74,121.34,121.93,122.51,123.09,123.66,124.23,124.79,125.35,125.9,126.45,126.99,127.53,128.07,128.6,129.12,129.64,130.16,130.67,131.18,131.69,132.19,132.69,133.18,133.68,134.17,134.65,135.13,135.62,136.09,136.57,137.04,137.51,137.97,138.44,138.9,139.36,139.82,140.27,140.73,141.18,141.63,142.08,142.52,142.97,143.41,143.85,144.29,144.73,145.17,145.61,146.04,146.47,146.91,147.34,147.77,148.2,148.63,149.05,149.48,149.91,150.33,150.76,151.18,151.61,152.03,152.45,152.87,153.3,153.72,154.14,154.56,154.98,155.4,155.82,156.25,156.67,157.09,157.51,157.93,158.35,158.77,159.19,159.62,160.04,160.46,160.88,161.31,161.73,162.15,162.58,163.0,163.43,163.85,164.28,164.71,165.14,165.56,165.99,166.42,166.85,167.28,167.72,168.15,168.58,169.01,169.45,169.88,170.32,170.76,171.19,171.63,172.07,172.51,172.95,173.39,173.84,174.28,174.72,175.17,175.61,176.06,176.51,176.95,177.4,177.85,178.3,178.75,179.2,179.66,180.11,180.56,181.02,181.47,181.92,182.38,182.84,183.29,183.75,184.21,184.66,185.12,185.58,186.04,186.5,186.95,187.41,187.87,188.33,188.79,189.25,189.71,190.16,190.62,191.08,191.54,191.99,192.45,192.91,193.36,193.82,194.27,194.73,195.18,195.63,196.09,196.54,196.99,197.44,197.89,198.34,198.79,199.24,199.68,200.13,200.58,201.02,201.46,201.91,202.35,202.79,203.23,203.67,204.11,204.55,204.99,205.43,205.86,206.3,206.73,207.17,207.6,208.03,208.46,208.89,209.32,209.75,210.18,210.61,211.04,211.47,211.89,212.32,212.74,213.17,213.59,214.02,214.44,214.86,215.29,215.71,216.13,216.55,216.97,217.4,217.82,218.24,218.66,219.08,219.5,219.92,220.34,220.76,221.19,221.61,222.03,222.45,222.87,223.29,223.72,224.14,224.56,224.99,225.41,225.84,226.27,226.69,227.12,227.55,227.98,228.41,228.84,229.27,229.7,230.14,230.57,231.01,231.45,231.89,232.33,232.77,233.22,233.66,234.11,234.56,235.01,235.47,235.92,236.38,236.84,237.3,237.77,238.23,238.7,239.17,239.65,240.12,240.6,241.09,241.57,242.06,242.55,243.05,243.54,244.05,244.55,245.06,245.57,246.09,246.61,247.14,247.66,248.2,248.74,249.28,249.82,250.38,250.93,251.5,252.06,252.63,253.21,253.8,254.38,254.98,255.58,256.19,256.8,257.42,258.05,258.68,259.33,259.97,260.63,261.29,261.97,262.65,263.33,264.03,264.74,265.45,266.17,266.91,267.65,268.4,269.17,269.94,270.72,271.52,272.33,273.15,273.98,274.82,275.68,276.55,277.43,278.33,279.24,280.17,281.11,282.07,283.04,284.03,285.03,},
{88.44,89.489,90.519,91.532,92.528,93.506,94.469,95.415,96.347,97.263,98.165,99.053,99.927,100.79,101.64,102.47,103.29,104.1,104.9,105.69,106.47,107.23,107.99,108.74,109.47,110.2,110.92,111.62,112.32,113.01,113.69,114.37,115.03,115.69,116.34,116.98,117.62,118.25,118.87,119.49,120.09,120.7,121.29,121.88,122.47,123.05,123.62,124.19,124.75,125.3,125.86,126.4,126.95,127.48,128.02,128.55,129.07,129.59,130.11,130.62,131.13,131.64,132.14,132.63,133.13,133.62,134.11,134.59,135.08,135.55,136.03,136.5,136.97,137.44,137.91,138.37,138.83,139.29,139.75,140.2,140.65,141.1,141.55,142.0,142.44,142.88,143.33,143.76,144.2,144.64,145.07,145.51,145.94,146.37,146.8,147.23,147.66,148.09,148.51,148.94,149.36,149.79,150.21,150.63,151.05,151.48,151.9,152.32,152.74,153.16,153.57,153.99,154.41,154.83,155.25,155.67,156.08,156.5,156.92,157.34,157.75,158.17,158.59,159.01,159.43,159.85,160.27,160.68,161.1,161.52,161.94,162.37,162.79,163.21,163.63,164.05,164.48,164.9,165.32,165.75,166.18,166.6,167.03,167.46,167.88,168.31,168.74,169.17,169.6,170.04,170.47,170.9,171.34,171.77,172.21,172.64,173.08,173.52,173.96,174.4,174.84,175.28,175.72,176.16,176.61,177.05,177.49,177.94,178.39,178.83,179.28,179.73,180.18,180.63,181.08,181.53,181.98,182.43,182.88,183.33,183.79,184.24,184.69,185.15,185.6,186.06,186.51,186.96,187.42,187.87,188.33,188.78,189.24,189.69,190.15,190.6,191.05,191.51,191.96,192.41,192.87,193.32,193.77,194.22,194.67,195.12,195.57,196.02,196.47,196.92,197.36,197.81,198.25,198.7,199.14,199.59,200.03,200.47,200.91,201.35,201.79,202.23,202.67,203.11,203.54,203.98,204.41,204.85,205.28,205.71,206.15,206.58,207.01,207.44,207.87,208.3,208.72,209.15,209.58,210.0,210.43,210.85,211.27,211.7,212.12,212.54,212.96,213.39,213.81,214.23,214.65,215.07,215.49,215.91,216.32,216.74,217.16,217.58,218.0,218.41,218.83,219.25,219.67,220.09,220.5,220.92,221.34,221.76,222.18,222.6,223.02,223.43,223.86,224.28,224.7,225.12,225.54,225.96,226.39,226.81,227.24,227.66,228.09,228.52,228.95,229.38,229.81,230.24,230.67,231.11,231.55,231.98,232.42,232.86,233.31,233.75,234.2,234.64,235.09,235.55,236.0,236.46,236.91,237.37,237.84,238.3,238.77,239.24,239.71,240.19,240.67,241.15,241.63,242.12,242.61,243.11,243.6,244.1,244.61,245.12,245.63,246.14,246.66,247.19,247.72,248.25,248.79,249.33,249.88,250.43,250.98,251.55,252.11,252.68,253.26,253.85,254.43,255.03,255.63,256.24,256.85,257.47,258.1,258.74,259.38,260.03,260.68,261.35,262.02,262.7,263.39,264.09,264.8,265.51,266.24,266.97,267.71,268.47,269.23,270.01,270.8,271.59,272.4,273.22,274.06,274.9,275.76,276.64,277.52,278.42,279.34,280.26,281.21,282.17,283.15,284.14,},
{89.365,90.399,91.416,92.415,93.398,94.363,95.313,96.248,97.167,98.072,98.962,99.839,100.7,101.55,102.39,103.22,104.03,104.83,105.62,106.4,107.17,107.92,108.67,109.41,110.14,110.85,111.56,112.26,112.95,113.64,114.31,114.98,115.64,116.29,116.93,117.57,118.2,118.82,119.43,120.04,120.65,121.24,121.83,122.42,123.0,123.57,124.14,124.7,125.26,125.81,126.35,126.9,127.43,127.97,128.5,129.02,129.54,130.06,130.57,131.08,131.58,132.08,132.58,133.07,133.56,134.05,134.53,135.01,135.49,135.97,136.44,136.91,137.38,137.84,138.3,138.76,139.22,139.67,140.13,140.58,141.02,141.47,141.92,142.36,142.8,143.24,143.68,144.11,144.55,144.98,145.41,145.84,146.27,146.7,147.13,147.55,147.98,148.4,148.82,149.25,149.67,150.09,150.51,150.93,151.35,151.76,152.18,152.6,153.02,153.43,153.85,154.26,154.68,155.09,155.51,155.92,156.34,156.75,157.17,157.58,158.0,158.41,158.83,159.24,159.66,160.07,160.49,160.91,161.32,161.74,162.16,162.57,162.99,163.41,163.83,164.25,164.67,165.09,165.51,165.93,166.35,166.78,167.2,167.63,168.05,168.48,168.9,169.33,169.76,170.19,170.61,171.04,171.47,171.91,172.34,172.77,173.21,173.64,174.07,174.51,174.95,175.38,175.82,176.26,176.7,177.14,177.58,178.03,178.47,178.91,179.35,179.8,180.24,180.69,181.14,181.58,182.03,182.48,182.93,183.37,183.82,184.27,184.72,185.17,185.62,186.07,186.52,186.97,187.43,187.88,188.33,188.78,189.23,189.68,190.13,190.58,191.03,191.48,191.93,192.38,192.83,193.28,193.72,194.17,194.62,195.06,195.51,195.95,196.4,196.84,197.29,197.73,198.17,198.61,199.05,199.49,199.93,200.37,200.81,201.24,201.68,202.11,202.55,202.98,203.42,203.85,204.28,204.71,205.14,205.57,206.0,206.43,206.85,207.28,207.71,208.13,208.55,208.98,209.4,209.82,210.25,210.67,211.09,211.51,211.93,212.35,212.76,213.18,213.6,214.02,214.43,214.85,215.27,215.68,216.1,216.51,216.93,217.34,217.76,218.17,218.59,219.0,219.42,219.83,220.25,220.66,221.08,221.49,221.91,222.32,222.74,223.16,223.57,223.99,224.41,224.83,225.25,225.67,226.09,226.51,226.93,227.35,227.78,228.2,228.63,229.05,229.48,229.91,230.34,230.77,231.21,231.64,232.08,232.51,232.95,233.39,233.84,234.28,234.73,235.18,235.63,236.08,236.53,236.99,237.45,237.91,238.37,238.84,239.31,239.78,240.25,240.73,241.21,241.7,242.18,242.67,243.17,243.66,244.16,244.67,245.17,245.69,246.2,246.72,247.24,247.77,248.31,248.84,249.38,249.93,250.48,251.04,251.6,252.17,252.74,253.32,253.9,254.49,255.08,255.69,256.29,256.91,257.53,258.16,258.79,259.44,260.09,260.74,261.41,262.08,262.76,263.45,264.15,264.86,265.58,266.3,267.04,267.79,268.54,269.31,270.09,270.88,271.67,272.49,273.31,274.15,274.99,275.86,276.73,277.62,278.52,279.44,280.37,281.32,282.28,283.26,},
{90.27,91.291,92.294,93.28,94.249,95.203,96.141,97.063,97.971,98.864,99.744,100.61,101.46,102.3,103.13,103.95,104.75,105.54,106.32,107.09,107.85,108.6,109.34,110.07,110.79,111.5,112.2,112.89,113.58,114.25,114.92,115.58,116.23,116.87,117.51,118.14,118.76,119.38,119.99,120.59,121.19,121.78,122.36,122.94,123.52,124.08,124.65,125.2,125.75,126.3,126.84,127.38,127.91,128.44,128.97,129.48,130.0,130.51,131.02,131.52,132.02,132.52,133.01,133.5,133.99,134.47,134.95,135.43,135.9,136.37,136.84,137.31,137.77,138.23,138.69,139.14,139.6,140.05,140.5,140.94,141.39,141.83,142.27,142.71,143.15,143.59,144.02,144.45,144.89,145.32,145.74,146.17,146.6,147.02,147.45,147.87,148.29,148.71,149.13,149.55,149.97,150.39,150.8,151.22,151.63,152.05,152.46,152.88,153.29,153.7,154.12,154.53,154.94,155.35,155.77,156.18,156.59,157.0,157.41,157.83,158.24,158.65,159.06,159.47,159.89,160.3,160.71,161.12,161.54,161.95,162.36,162.78,163.19,163.61,164.03,164.44,164.86,165.28,165.69,166.11,166.53,166.95,167.37,167.79,168.21,168.64,169.06,169.48,169.91,170.33,170.76,171.18,171.61,172.04,172.47,172.9,173.33,173.76,174.19,174.62,175.06,175.49,175.93,176.36,176.8,177.23,177.67,178.11,178.55,178.99,179.43,179.87,180.31,180.75,181.2,181.64,182.08,182.53,182.97,183.42,183.86,184.31,184.75,185.2,185.64,186.09,186.54,186.98,187.43,187.88,188.33,188.77,189.22,189.67,190.11,190.56,191.01,191.45,191.9,192.34,192.79,193.23,193.68,194.12,194.56,195.01,195.45,195.89,196.33,196.77,197.21,197.65,198.09,198.52,198.96,199.4,199.83,200.27,200.7,201.14,201.57,202.0,202.43,202.86,203.29,203.72,204.15,204.57,205.0,205.43,205.85,206.28,206.7,207.12,207.55,207.97,208.39,208.81,209.23,209.65,210.07,210.48,210.9,211.32,211.74,212.15,212.57,212.98,213.4,213.81,214.22,214.64,215.05,215.46,215.88,216.29,216.7,217.11,217.52,217.94,218.35,218.76,219.17,219.58,219.99,220.41,220.82,221.23,221.64,222.06,222.47,222.88,223.3,223.71,224.13,224.54,224.96,225.37,225.79,226.21,226.63,227.05,227.47,227.89,228.31,228.74,229.16,229.59,230.01,230.44,230.87,231.3,231.74,232.17,232.61,233.04,233.48,233.92,234.37,234.81,235.26,235.71,236.16,236.61,237.07,237.52,237.98,238.45,238.91,239.38,239.85,240.32,240.8,241.28,241.76,242.25,242.74,243.23,243.73,244.23,244.73,245.24,245.75,246.26,246.78,247.3,247.83,248.36,248.9,249.44,249.99,250.54,251.1,251.66,252.22,252.8,253.37,253.96,254.55,255.14,255.75,256.35,256.97,257.59,258.22,258.86,259.5,260.15,260.81,261.47,262.15,262.83,263.52,264.22,264.93,265.65,266.38,267.12,267.86,268.62,269.39,270.17,270.96,271.76,272.58,273.4,274.24,275.09,275.96,276.83,277.72,278.63,279.55,280.49,281.44,282.41,},
{91.156,92.163,93.153,94.127,95.084,96.025,96.951,97.862,98.758,99.641,100.51,101.36,102.21,103.04,103.86,104.66,105.45,106.24,107.01,107.77,108.52,109.26,109.99,110.71,111.43,112.13,112.82,113.51,114.18,114.85,115.51,116.17,116.81,117.45,118.08,118.7,119.32,119.93,120.53,121.13,121.72,122.31,122.89,123.46,124.03,124.59,125.15,125.7,126.24,126.79,127.32,127.86,128.38,128.91,129.43,129.94,130.45,130.96,131.46,131.96,132.46,132.95,133.44,133.92,134.41,134.89,135.36,135.84,136.31,136.77,137.24,137.7,138.16,138.62,139.07,139.52,139.97,140.42,140.86,141.31,141.75,142.19,142.63,143.06,143.5,143.93,144.36,144.79,145.22,145.65,146.07,146.5,146.92,147.34,147.76,148.18,148.6,149.02,149.43,149.85,150.26,150.68,151.09,151.51,151.92,152.33,152.74,153.15,153.56,153.97,154.38,154.79,155.2,155.61,156.02,156.43,156.84,157.25,157.66,158.06,158.47,158.88,159.29,159.7,160.11,160.52,160.93,161.34,161.75,162.16,162.57,162.98,163.39,163.81,164.22,164.63,165.05,165.46,165.87,166.29,166.71,167.12,167.54,167.96,168.38,168.79,169.21,169.63,170.06,170.48,170.9,171.32,171.75,172.17,172.6,173.02,173.45,173.88,174.31,174.74,175.17,175.6,176.03,176.46,176.89,177.32,177.76,178.19,178.63,179.06,179.5,179.94,180.38,180.81,181.25,181.69,182.13,182.57,183.01,183.45,183.9,184.34,184.78,185.22,185.67,186.11,186.55,186.99,187.44,187.88,188.32,188.77,189.21,189.65,190.1,190.54,190.98,191.42,191.87,192.31,192.75,193.19,193.63,194.07,194.51,194.95,195.39,195.82,196.26,196.7,197.13,197.57,198.0,198.44,198.87,199.3,199.74,200.17,200.6,201.03,201.46,201.89,202.31,202.74,203.17,203.59,204.02,204.44,204.86,205.29,205.71,206.13,206.55,206.97,207.39,207.81,208.23,208.64,209.06,209.48,209.89,210.31,210.72,211.13,211.55,211.96,212.37,212.78,213.2,213.61,214.02,214.43,214.84,215.25,215.66,216.07,216.47,216.88,217.29,217.7,218.11,218.52,218.93,219.34,219.74,220.15,220.56,220.97,221.38,221.79,222.2,222.61,223.02,223.43,223.85,224.26,224.67,225.09,225.5,225.91,226.33,226.75,227.16,227.58,228.0,228.42,228.84,229.27,229.69,230.12,230.54,230.97,231.4,231.83,232.26,232.7,233.13,233.57,234.01,234.45,234.9,235.34,235.79,236.24,236.69,237.14,237.6,238.06,238.52,238.98,239.45,239.92,240.39,240.87,241.35,241.83,242.31,242.8,243.3,243.79,244.29,244.79,245.3,245.81,246.32,246.84,247.37,247.89,248.42,248.96,249.5,250.05,250.6,251.16,251.72,252.28,252.86,253.44,254.02,254.61,255.21,255.81,256.42,257.03,257.66,258.29,258.92,259.57,260.22,260.88,261.55,262.22,262.91,263.6,264.3,265.01,265.73,266.46,267.2,267.95,268.71,269.48,270.26,271.05,271.86,272.67,273.5,274.34,275.2,276.06,276.94,277.84,278.75,279.67,280.61,281.57,},
{92.024,93.018,93.995,94.956,95.901,96.83,97.745,98.644,99.53,100.4,101.26,102.11,102.94,103.76,104.57,105.36,106.15,106.92,107.68,108.44,109.18,109.91,110.64,111.35,112.05,112.75,113.43,114.11,114.78,115.44,116.1,116.74,117.38,118.01,118.64,119.26,119.87,120.47,121.07,121.66,122.24,122.82,123.4,123.97,124.53,125.09,125.64,126.18,126.73,127.26,127.8,128.32,128.85,129.37,129.88,130.39,130.9,131.4,131.9,132.39,132.89,133.37,133.86,134.34,134.82,135.29,135.77,136.24,136.7,137.17,137.63,138.08,138.54,138.99,139.44,139.89,140.34,140.78,141.23,141.67,142.1,142.54,142.97,143.41,143.84,144.27,144.7,145.12,145.55,145.97,146.39,146.81,147.23,147.65,148.07,148.49,148.9,149.32,149.73,150.14,150.56,150.97,151.38,151.79,152.2,152.61,153.02,153.42,153.83,154.24,154.65,155.05,155.46,155.86,156.27,156.68,157.08,157.49,157.89,158.3,158.71,159.11,159.52,159.92,160.33,160.74,161.14,161.55,161.96,162.36,162.77,163.18,163.59,164.0,164.41,164.82,165.23,165.64,166.05,166.46,166.88,167.29,167.7,168.12,168.53,168.95,169.37,169.78,170.2,170.62,171.04,171.46,171.88,172.3,172.72,173.15,173.57,173.99,174.42,174.85,175.27,175.7,176.13,176.56,176.98,177.41,177.84,178.28,178.71,179.14,179.57,180.01,180.44,180.88,181.31,181.75,182.18,182.62,183.06,183.49,183.93,184.37,184.81,185.25,185.69,186.13,186.57,187.0,187.44,187.88,188.32,188.76,189.2,189.64,190.08,190.52,190.96,191.4,191.84,192.27,192.71,193.15,193.58,194.02,194.46,194.89,195.33,195.76,196.19,196.63,197.06,197.49,197.92,198.35,198.78,199.21,199.64,200.07,200.5,200.92,201.35,201.77,202.2,202.62,203.04,203.47,203.89,204.31,204.73,205.15,205.57,205.98,206.4,206.82,207.23,207.65,208.06,208.48,208.89,209.3,209.72,210.13,210.54,210.95,211.36,211.77,212.18,212.59,213.0,213.41,213.81,214.22,214.63,215.03,215.44,215.85,216.25,216.66,217.06,217.47,217.88,218.28,218.69,219.09,219.5,219.91,220.31,220.72,221.12,221.53,221.94,222.35,222.75,223.16,223.57,223.98,224.39,224.8,225.21,225.62,226.04,226.45,226.87,227.28,227.7,228.11,228.53,228.95,229.37,229.8,230.22,230.64,231.07,231.5,231.93,232.36,232.79,233.23,233.66,234.1,234.54,234.98,235.42,235.87,236.32,236.77,237.22,237.68,238.14,238.6,239.06,239.53,239.99,240.47,240.94,241.42,241.9,242.38,242.87,243.36,243.86,244.36,244.86,245.36,245.87,246.39,246.91,247.43,247.96,248.49,249.03,249.57,250.11,250.66,251.22,251.78,252.35,252.92,253.5,254.09,254.68,255.27,255.88,256.49,257.1,257.73,258.36,258.99,259.64,260.29,260.95,261.62,262.3,262.98,263.68,264.38,265.09,265.81,266.55,267.29,268.04,268.8,269.57,270.36,271.15,271.96,272.78,273.61,274.45,275.31,276.18,277.06,277.96,278.87,279.8,280.74,},
{92.873,93.855,94.82,95.768,96.701,97.619,98.522,99.411,100.29,101.15,102.0,102.83,103.65,104.46,105.26,106.05,106.83,107.59,108.35,109.09,109.83,110.55,111.27,111.97,112.67,113.36,114.04,114.71,115.37,116.02,116.67,117.31,117.94,118.57,119.19,119.8,120.4,121.0,121.59,122.18,122.76,123.33,123.9,124.46,125.02,125.57,126.12,126.66,127.2,127.73,128.26,128.78,129.3,129.82,130.33,130.83,131.34,131.83,132.33,132.82,133.31,133.79,134.27,134.75,135.22,135.7,136.16,136.63,137.09,137.55,138.01,138.46,138.92,139.37,139.81,140.26,140.7,141.14,141.58,142.02,142.45,142.89,143.32,143.75,144.17,144.6,145.03,145.45,145.87,146.29,146.71,147.13,147.54,147.96,148.38,148.79,149.2,149.61,150.02,150.43,150.84,151.25,151.66,152.07,152.47,152.88,153.28,153.69,154.09,154.5,154.9,155.31,155.71,156.11,156.52,156.92,157.32,157.73,158.13,158.53,158.93,159.34,159.74,160.14,160.55,160.95,161.35,161.76,162.16,162.57,162.97,163.38,163.78,164.19,164.6,165.0,165.41,165.82,166.23,166.64,167.05,167.46,167.87,168.28,168.69,169.1,169.52,169.93,170.35,170.76,171.18,171.59,172.01,172.43,172.85,173.27,173.69,174.11,174.53,174.95,175.38,175.8,176.23,176.65,177.08,177.5,177.93,178.36,178.79,179.21,179.64,180.07,180.5,180.94,181.37,181.8,182.23,182.67,183.1,183.53,183.97,184.4,184.84,185.27,185.71,186.14,186.58,187.01,187.45,187.89,188.32,188.76,189.19,189.63,190.06,190.5,190.94,191.37,191.8,192.24,192.67,193.11,193.54,193.97,194.4,194.84,195.27,195.7,196.13,196.56,196.99,197.42,197.84,198.27,198.7,199.12,199.55,199.97,200.4,200.82,201.24,201.66,202.08,202.5,202.92,203.34,203.76,204.18,204.6,205.01,205.43,205.84,206.26,206.67,207.08,207.49,207.91,208.32,208.73,209.14,209.55,209.95,210.36,210.77,211.18,211.58,211.99,212.4,212.8,213.21,213.61,214.02,214.42,214.82,215.23,215.63,216.03,216.44,216.84,217.24,217.65,218.05,218.45,218.85,219.26,219.66,220.06,220.47,220.87,221.27,221.68,222.08,222.49,222.89,223.3,223.71,224.11,224.52,224.93,225.34,225.75,226.16,226.57,226.98,227.4,227.81,228.23,228.64,229.06,229.48,229.9,230.32,230.75,231.17,231.6,232.02,232.45,232.88,233.32,233.75,234.19,234.63,235.07,235.51,235.95,236.4,236.85,237.3,237.76,238.21,238.67,239.14,239.6,240.07,240.54,241.01,241.49,241.97,242.46,242.94,243.43,243.93,244.43,244.93,245.43,245.94,246.46,246.98,247.5,248.03,248.56,249.09,249.63,250.18,250.73,251.29,251.85,252.42,252.99,253.57,254.16,254.75,255.34,255.95,256.56,257.18,257.8,258.43,259.07,259.72,260.37,261.03,261.7,262.38,263.07,263.76,264.47,265.18,265.91,266.64,267.38,268.14,268.9,269.67,270.46,271.26,272.07,272.89,273.72,274.57,275.43,276.3,277.19,278.09,279.01,279.94,},
{93.706,94.675,95.627,96.564,97.486,98.393,99.285,100.16,101.03,101.88,102.72,103.54,104.36,105.16,105.95,106.73,107.49,108.25,109.0,109.73,110.46,111.18,111.88,112.58,113.27,113.95,114.63,115.29,115.95,116.59,117.24,117.87,118.49,119.11,119.73,120.33,120.93,121.52,122.11,122.69,123.26,123.83,124.4,124.95,125.51,126.05,126.6,127.13,127.66,128.19,128.72,129.23,129.75,130.26,130.77,131.27,131.77,132.26,132.75,133.24,133.72,134.2,134.68,135.15,135.62,136.09,136.56,137.02,137.48,137.93,138.39,138.84,139.29,139.73,140.18,140.62,141.06,141.5,141.93,142.36,142.8,143.23,143.65,144.08,144.5,144.93,145.35,145.77,146.19,146.61,147.02,147.44,147.85,148.26,148.68,149.09,149.5,149.9,150.31,150.72,151.13,151.53,151.94,152.34,152.74,153.15,153.55,153.95,154.35,154.76,155.16,155.56,155.96,156.36,156.76,157.16,157.56,157.96,158.36,158.76,159.16,159.56,159.96,160.36,160.76,161.16,161.56,161.96,162.37,162.77,163.17,163.57,163.97,164.38,164.78,165.19,165.59,166.0,166.4,166.81,167.21,167.62,168.03,168.44,168.85,169.26,169.67,170.08,170.49,170.9,171.31,171.73,172.14,172.56,172.97,173.39,173.81,174.22,174.64,175.06,175.48,175.9,176.32,176.74,177.17,177.59,178.01,178.44,178.86,179.29,179.71,180.14,180.57,181.0,181.42,181.85,182.28,182.71,183.14,183.57,184.0,184.43,184.86,185.3,185.73,186.16,186.59,187.02,187.46,187.89,188.32,188.75,189.18,189.62,190.05,190.48,190.91,191.34,191.77,192.21,192.64,193.07,193.5,193.92,194.35,194.78,195.21,195.64,196.06,196.49,196.91,197.34,197.76,198.19,198.61,199.03,199.46,199.88,200.3,200.72,201.14,201.55,201.97,202.39,202.81,203.22,203.64,204.05,204.46,204.88,205.29,205.7,206.11,206.52,206.93,207.34,207.75,208.16,208.56,208.97,209.38,209.78,210.19,210.59,211.0,211.4,211.8,212.21,212.61,213.01,213.41,213.82,214.22,214.62,215.02,215.42,215.82,216.22,216.62,217.02,217.42,217.82,218.22,218.62,219.02,219.42,219.82,220.22,220.62,221.02,221.42,221.83,222.23,222.63,223.03,223.44,223.84,224.25,224.65,225.06,225.46,225.87,226.28,226.69,227.1,227.51,227.93,228.34,228.75,229.17,229.59,230.01,230.43,230.85,231.27,231.69,232.12,232.55,232.98,233.41,233.84,234.28,234.72,235.15,235.6,236.04,236.49,236.93,237.39,237.84,238.29,238.75,239.21,239.68,240.15,240.62,241.09,241.57,242.05,242.53,243.02,243.51,244.0,244.5,245.0,245.5,246.01,246.53,247.05,247.57,248.1,248.63,249.16,249.71,250.25,250.8,251.36,251.92,252.49,253.07,253.64,254.23,254.82,255.42,256.03,256.64,257.25,257.88,258.51,259.15,259.8,260.45,261.12,261.79,262.47,263.16,263.85,264.56,265.28,266.0,266.74,267.48,268.24,269.0,269.78,270.57,271.37,272.18,273.01,273.84,274.69,275.56,276.43,277.32,278.23,279.15,},
{94.521,95.478,96.419,97.344,98.255,99.151,100.03,100.9,101.75,102.6,103.42,104.24,105.04,105.84,106.62,107.39,108.15,108.9,109.64,110.36,111.08,111.79,112.49,113.18,113.87,114.54,115.21,115.86,116.51,117.15,117.79,118.42,119.04,119.65,120.26,120.86,121.45,122.04,122.62,123.19,123.76,124.32,124.88,125.44,125.98,126.53,127.06,127.59,128.12,128.65,129.16,129.68,130.19,130.69,131.2,131.69,132.19,132.68,133.17,133.65,134.13,134.61,135.08,135.55,136.02,136.48,136.94,137.4,137.85,138.31,138.76,139.2,139.65,140.09,140.53,140.97,141.41,141.84,142.27,142.71,143.13,143.56,143.99,144.41,144.83,145.25,145.67,146.09,146.5,146.92,147.33,147.74,148.15,148.56,148.97,149.38,149.79,150.19,150.6,151.0,151.4,151.81,152.21,152.61,153.01,153.41,153.81,154.21,154.61,155.01,155.41,155.81,156.2,156.6,157.0,157.4,157.79,158.19,158.59,158.98,159.38,159.78,160.18,160.57,160.97,161.37,161.77,162.17,162.56,162.96,163.36,163.76,164.16,164.56,164.96,165.37,165.77,166.17,166.57,166.97,167.38,167.78,168.19,168.59,169.0,169.41,169.81,170.22,170.63,171.04,171.45,171.86,172.27,172.68,173.09,173.51,173.92,174.34,174.75,175.17,175.58,176.0,176.42,176.84,177.26,177.68,178.1,178.52,178.94,179.36,179.78,180.21,180.63,181.05,181.48,181.9,182.33,182.76,183.18,183.61,184.04,184.46,184.89,185.32,185.75,186.18,186.6,187.03,187.46,187.89,188.32,188.75,189.18,189.61,190.03,190.46,190.89,191.32,191.74,192.17,192.6,193.03,193.45,193.88,194.3,194.73,195.15,195.58,196.0,196.42,196.84,197.27,197.69,198.11,198.53,198.95,199.36,199.78,200.2,200.62,201.03,201.45,201.86,202.27,202.69,203.1,203.51,203.92,204.33,204.74,205.15,205.56,205.97,206.38,206.78,207.19,207.6,208.0,208.4,208.81,209.21,209.61,210.02,210.42,210.82,211.22,211.62,212.02,212.42,212.82,213.22,213.62,214.02,214.41,214.81,215.21,215.61,216.0,216.4,216.8,217.2,217.59,217.99,218.39,218.78,219.18,219.58,219.98,220.38,220.77,221.17,221.57,221.97,222.37,222.77,223.17,223.57,223.97,224.38,224.78,225.18,225.59,226.0,226.4,226.81,227.22,227.63,228.04,228.45,228.86,229.28,229.69,230.11,230.53,230.95,231.37,231.79,232.22,232.64,233.07,233.5,233.93,234.37,234.8,235.24,235.68,236.13,236.57,237.02,237.47,237.92,238.38,238.83,239.29,239.76,240.22,240.69,241.17,241.64,242.12,242.61,243.09,243.58,244.07,244.57,245.07,245.58,246.09,246.6,247.12,247.64,248.17,248.7,249.24,249.78,250.33,250.88,251.44,252.0,252.57,253.14,253.72,254.31,254.9,255.5,256.11,256.72,257.34,257.96,258.6,259.24,259.89,260.54,261.21,261.88,262.56,263.25,263.95,264.66,265.38,266.11,266.84,267.59,268.35,269.12,269.9,270.69,271.49,272.31,273.13,273.97,274.82,275.69,276.57,277.46,278.37,},
{95.32,96.265,97.195,98.109,99.008,99.894,100.76,101.62,102.47,103.3,104.12,104.93,105.72,106.5,107.28,108.04,108.79,109.53,110.26,110.98,111.69,112.4,113.09,113.77,114.45,115.12,115.77,116.43,117.07,117.7,118.33,118.95,119.57,120.18,120.78,121.37,121.96,122.54,123.12,123.69,124.25,124.81,125.36,125.91,126.45,126.99,127.52,128.05,128.57,129.09,129.61,130.12,130.62,131.12,131.62,132.11,132.6,133.09,133.57,134.05,134.53,135.0,135.47,135.94,136.4,136.86,137.32,137.77,138.23,138.68,139.12,139.57,140.01,140.45,140.89,141.32,141.75,142.18,142.61,143.04,143.47,143.89,144.31,144.73,145.15,145.57,145.98,146.4,146.81,147.22,147.63,148.04,148.45,148.86,149.26,149.67,150.07,150.47,150.88,151.28,151.68,152.08,152.48,152.88,153.27,153.67,154.07,154.47,154.86,155.26,155.65,156.05,156.44,156.84,157.23,157.63,158.02,158.42,158.81,159.21,159.6,160.0,160.39,160.79,161.18,161.58,161.97,162.37,162.76,163.16,163.55,163.95,164.35,164.75,165.14,165.54,165.94,166.34,166.74,167.14,167.54,167.94,168.34,168.75,169.15,169.55,169.96,170.36,170.77,171.17,171.58,171.99,172.4,172.8,173.21,173.62,174.03,174.45,174.86,175.27,175.68,176.1,176.51,176.93,177.34,177.76,178.18,178.59,179.01,179.43,179.85,180.27,180.69,181.11,181.53,181.95,182.38,182.8,183.22,183.65,184.07,184.49,184.92,185.34,185.77,186.19,186.62,187.04,187.47,187.89,188.32,188.74,189.17,189.59,190.02,190.44,190.87,191.29,191.72,192.14,192.56,192.99,193.41,193.83,194.25,194.67,195.09,195.52,195.94,196.35,196.77,197.19,197.61,198.03,198.44,198.86,199.27,199.69,200.1,200.52,200.93,201.34,201.75,202.16,202.57,202.98,203.39,203.8,204.21,204.61,205.02,205.42,205.83,206.23,206.64,207.04,207.44,207.84,208.25,208.65,209.05,209.45,209.85,210.25,210.64,211.04,211.44,211.84,212.23,212.63,213.03,213.42,213.82,214.21,214.61,215.0,215.4,215.79,216.19,216.58,216.98,217.37,217.76,218.16,218.55,218.95,219.34,219.74,220.13,220.53,220.92,221.32,221.72,222.11,222.51,222.91,223.31,223.71,224.11,224.51,224.91,225.31,225.71,226.12,226.52,226.93,227.34,227.74,228.15,228.56,228.97,229.39,229.8,230.22,230.63,231.05,231.47,231.89,232.32,232.74,233.17,233.6,234.03,234.46,234.9,235.33,235.77,236.21,236.66,237.1,237.55,238.0,238.46,238.92,239.38,239.84,240.31,240.77,241.25,241.72,242.2,242.68,243.17,243.66,244.15,244.65,245.15,245.66,246.17,246.68,247.2,247.72,248.25,248.78,249.32,249.86,250.41,250.96,251.52,252.08,252.65,253.22,253.8,254.39,254.99,255.59,256.19,256.8,257.43,258.05,258.69,259.33,259.98,260.64,261.3,261.98,262.66,263.35,264.05,264.76,265.48,266.21,266.95,267.7,268.46,269.24,270.02,270.81,271.62,272.43,273.26,274.11,274.96,275.83,276.72,277.61,},
{96.103,97.036,97.955,98.858,99.747,100.62,101.48,102.33,103.17,103.99,104.8,105.6,106.38,107.16,107.92,108.68,109.42,110.15,110.88,111.59,112.29,112.99,113.67,114.35,115.02,115.68,116.33,116.98,117.61,118.24,118.87,119.48,120.09,120.69,121.29,121.88,122.46,123.03,123.61,124.17,124.73,125.28,125.83,126.37,126.91,127.45,127.97,128.5,129.02,129.53,130.04,130.55,131.05,131.54,132.04,132.53,133.01,133.5,133.98,134.45,134.92,135.39,135.86,136.32,136.78,137.24,137.69,138.14,138.59,139.04,139.48,139.92,140.36,140.8,141.23,141.66,142.09,142.52,142.95,143.37,143.79,144.21,144.63,145.05,145.47,145.88,146.29,146.7,147.11,147.52,147.93,148.34,148.74,149.15,149.55,149.95,150.35,150.75,151.15,151.55,151.95,152.35,152.74,153.14,153.53,153.93,154.32,154.72,155.11,155.5,155.9,156.29,156.68,157.07,157.47,157.86,158.25,158.64,159.03,159.43,159.82,160.21,160.6,160.99,161.39,161.78,162.17,162.56,162.96,163.35,163.74,164.14,164.53,164.93,165.32,165.72,166.11,166.51,166.91,167.3,167.7,168.1,168.5,168.9,169.3,169.7,170.1,170.5,170.9,171.31,171.71,172.12,172.52,172.93,173.33,173.74,174.15,174.55,174.96,175.37,175.78,176.19,176.61,177.02,177.43,177.84,178.26,178.67,179.09,179.5,179.92,180.33,180.75,181.17,181.59,182.01,182.42,182.84,183.26,183.68,184.1,184.52,184.94,185.37,185.79,186.21,186.63,187.05,187.47,187.89,188.32,188.74,189.16,189.58,190.0,190.42,190.85,191.27,191.69,192.11,192.53,192.95,193.37,193.78,194.2,194.62,195.04,195.46,195.87,196.29,196.7,197.12,197.53,197.95,198.36,198.77,199.19,199.6,200.01,200.42,200.83,201.24,201.64,202.05,202.46,202.86,203.27,203.68,204.08,204.48,204.89,205.29,205.69,206.09,206.49,206.89,207.29,207.69,208.09,208.49,208.89,209.28,209.68,210.08,210.47,210.87,211.26,211.65,212.05,212.44,212.84,213.23,213.62,214.01,214.41,214.8,215.19,215.58,215.97,216.37,216.76,217.15,217.54,217.93,218.32,218.72,219.11,219.5,219.89,220.29,220.68,221.07,221.47,221.86,222.26,222.65,223.05,223.44,223.84,224.24,224.64,225.04,225.44,225.84,226.24,226.64,227.05,227.45,227.86,228.26,228.67,229.08,229.49,229.91,230.32,230.74,231.15,231.57,231.99,232.41,232.84,233.26,233.69,234.12,234.55,234.99,235.42,235.86,236.3,236.75,237.19,237.64,238.09,238.54,239.0,239.46,239.92,240.39,240.86,241.33,241.8,242.28,242.76,243.25,243.74,244.23,244.73,245.23,245.74,246.25,246.76,247.28,247.8,248.33,248.86,249.4,249.94,250.49,251.04,251.6,252.16,252.73,253.31,253.89,254.48,255.07,255.67,256.28,256.9,257.52,258.15,258.78,259.43,260.08,260.74,261.41,262.08,262.77,263.46,264.16,264.88,265.6,266.33,267.07,267.82,268.59,269.36,270.15,270.94,271.75,272.57,273.4,274.25,275.11,275.98,276.87,},
{96.87,97.793,98.7,99.593,100.47,101.34,102.19,103.03,103.85,104.67,105.47,106.26,107.03,107.8,108.56,109.3,110.04,110.76,111.48,112.18,112.88,113.57,114.25,114.92,115.58,116.24,116.88,117.52,118.15,118.78,119.39,120.0,120.6,121.2,121.79,122.37,122.95,123.52,124.09,124.65,125.2,125.75,126.29,126.83,127.37,127.89,128.42,128.94,129.45,129.96,130.47,130.97,131.47,131.96,132.45,132.94,133.42,133.9,134.37,134.84,135.31,135.78,136.24,136.7,137.16,137.61,138.06,138.51,138.95,139.4,139.84,140.27,140.71,141.14,141.57,142.0,142.43,142.85,143.28,143.7,144.12,144.53,144.95,145.36,145.78,146.19,146.6,147.01,147.41,147.82,148.22,148.63,149.03,149.43,149.83,150.23,150.63,151.03,151.42,151.82,152.22,152.61,153.0,153.4,153.79,154.18,154.57,154.97,155.36,155.75,156.14,156.53,156.92,157.31,157.7,158.08,158.47,158.86,159.25,159.64,160.03,160.42,160.81,161.2,161.59,161.98,162.37,162.76,163.15,163.54,163.93,164.32,164.71,165.1,165.5,165.89,166.28,166.68,167.07,167.46,167.86,168.25,168.65,169.05,169.44,169.84,170.24,170.64,171.04,171.44,171.84,172.24,172.64,173.05,173.45,173.85,174.26,174.66,175.07,175.47,175.88,176.29,176.7,177.11,177.52,177.93,178.34,178.75,179.16,179.57,179.98,180.4,180.81,181.23,181.64,182.05,182.47,182.89,183.3,183.72,184.14,184.55,184.97,185.39,185.81,186.22,186.64,187.06,187.48,187.9,188.32,188.73,189.15,189.57,189.99,190.41,190.82,191.24,191.66,192.08,192.49,192.91,193.32,193.74,194.15,194.57,194.98,195.4,195.81,196.22,196.64,197.05,197.46,197.87,198.28,198.69,199.1,199.51,199.91,200.32,200.73,201.13,201.54,201.94,202.35,202.75,203.15,203.55,203.96,204.36,204.76,205.16,205.55,205.95,206.35,206.75,207.14,207.54,207.94,208.33,208.73,209.12,209.51,209.91,210.3,210.69,211.08,211.48,211.87,212.26,212.65,213.04,213.43,213.82,214.21,214.6,214.99,215.38,215.77,216.15,216.54,216.93,217.32,217.71,218.1,218.49,218.88,219.27,219.66,220.05,220.44,220.83,221.22,221.61,222.0,222.4,222.79,223.18,223.58,223.97,224.37,224.77,225.16,225.56,225.96,226.36,226.76,227.16,227.57,227.97,228.38,228.78,229.19,229.6,230.01,230.43,230.84,231.26,231.67,232.09,232.51,232.94,233.36,233.79,234.22,234.65,235.08,235.52,235.95,236.39,236.84,237.28,237.73,238.18,238.63,239.09,239.55,240.01,240.47,240.94,241.41,241.89,242.37,242.85,243.33,243.82,244.32,244.81,245.31,245.82,246.33,246.84,247.36,247.88,248.41,248.94,249.48,250.03,250.57,251.13,251.69,252.25,252.82,253.4,253.98,254.57,255.17,255.77,256.38,256.99,257.61,258.24,258.88,259.53,260.18,260.84,261.51,262.19,262.88,263.57,264.28,264.99,265.72,266.45,267.19,267.95,268.71,269.49,270.28,271.08,271.89,272.72,273.55,274.4,275.27,276.14,},
{97.623,98.534,99.431,100.31,101.18,102.04,102.88,103.71,104.53,105.33,106.12,106.9,107.67,108.43,109.18,109.92,110.65,111.36,112.07,112.77,113.46,114.14,114.81,115.48,116.13,116.78,117.42,118.05,118.68,119.3,119.91,120.51,121.11,121.7,122.28,122.86,123.43,124.0,124.56,125.12,125.67,126.21,126.75,127.28,127.81,128.33,128.85,129.37,129.88,130.39,130.89,131.38,131.88,132.37,132.85,133.34,133.81,134.29,134.76,135.23,135.69,136.16,136.61,137.07,137.52,137.97,138.42,138.87,139.31,139.75,140.18,140.62,141.05,141.48,141.91,142.33,142.76,143.18,143.6,144.02,144.44,144.85,145.26,145.67,146.08,146.49,146.9,147.31,147.71,148.11,148.51,148.92,149.31,149.71,150.11,150.51,150.9,151.3,151.69,152.09,152.48,152.87,153.26,153.65,154.04,154.43,154.82,155.21,155.6,155.99,156.37,156.76,157.15,157.53,157.92,158.31,158.69,159.08,159.47,159.85,160.24,160.63,161.01,161.4,161.79,162.17,162.56,162.95,163.34,163.72,164.11,164.5,164.89,165.28,165.67,166.06,166.45,166.84,167.23,167.62,168.01,168.41,168.8,169.19,169.59,169.98,170.38,170.78,171.17,171.57,171.97,172.37,172.76,173.16,173.56,173.96,174.37,174.77,175.17,175.57,175.98,176.38,176.79,177.19,177.6,178.01,178.41,178.82,179.23,179.64,180.05,180.46,180.87,181.28,181.69,182.1,182.52,182.93,183.34,183.75,184.17,184.58,185.0,185.41,185.82,186.24,186.65,187.07,187.48,187.9,188.31,188.73,189.14,189.56,189.97,190.39,190.8,191.22,191.63,192.04,192.46,192.87,193.28,193.69,194.11,194.52,194.93,195.34,195.75,196.16,196.57,196.98,197.38,197.79,198.2,198.61,199.01,199.42,199.82,200.22,200.63,201.03,201.43,201.83,202.24,202.64,203.04,203.43,203.83,204.23,204.63,205.02,205.42,205.82,206.21,206.61,207.0,207.39,207.79,208.18,208.57,208.96,209.35,209.74,210.13,210.52,210.91,211.3,211.69,212.08,212.46,212.85,213.24,213.63,214.01,214.4,214.79,215.17,215.56,215.95,216.33,216.72,217.1,217.49,217.88,218.26,218.65,219.04,219.43,219.81,220.2,220.59,220.98,221.37,221.76,222.15,222.54,222.93,223.32,223.71,224.11,224.5,224.89,225.29,225.69,226.08,226.48,226.88,227.28,227.68,228.09,228.49,228.9,229.3,229.71,230.12,230.53,230.95,231.36,231.78,232.19,232.61,233.04,233.46,233.88,234.31,234.74,235.17,235.61,236.05,236.48,236.93,237.37,237.82,238.27,238.72,239.17,239.63,240.09,240.56,241.03,241.5,241.97,242.45,242.93,243.42,243.91,244.4,244.9,245.4,245.9,246.41,246.93,247.45,247.97,248.5,249.03,249.57,250.11,250.66,251.22,251.78,252.34,252.91,253.49,254.08,254.67,255.26,255.86,256.47,257.09,257.72,258.35,258.99,259.63,260.29,260.95,261.62,262.3,262.99,263.69,264.4,265.11,265.84,266.58,267.32,268.08,268.85,269.63,270.42,271.22,272.04,272.87,273.71,274.56,275.43,},
{98.36,99.262,100.15,101.02,101.88,102.73,103.56,104.38,105.19,105.98,106.77,107.54,108.3,109.05,109.79,110.52,111.24,111.95,112.65,113.35,114.03,114.7,115.37,116.03,116.68,117.32,117.95,118.58,119.2,119.81,120.41,121.01,121.6,122.19,122.77,123.34,123.91,124.47,125.03,125.58,126.12,126.66,127.2,127.72,128.25,128.77,129.28,129.79,130.3,130.8,131.3,131.79,132.28,132.77,133.25,133.73,134.2,134.68,135.14,135.61,136.07,136.53,136.98,137.44,137.89,138.33,138.78,139.22,139.66,140.09,140.53,140.96,141.39,141.81,142.24,142.66,143.08,143.5,143.92,144.33,144.75,145.16,145.57,145.98,146.39,146.79,147.2,147.6,148.0,148.4,148.8,149.2,149.59,149.99,150.39,150.78,151.17,151.56,151.96,152.35,152.74,153.13,153.51,153.9,154.29,154.68,155.06,155.45,155.84,156.22,156.61,156.99,157.38,157.76,158.14,158.53,158.91,159.3,159.68,160.06,160.45,160.83,161.21,161.6,161.98,162.37,162.75,163.14,163.52,163.91,164.29,164.68,165.06,165.45,165.84,166.23,166.61,167.0,167.39,167.78,168.17,168.56,168.95,169.34,169.73,170.12,170.52,170.91,171.3,171.7,172.09,172.49,172.88,173.28,173.68,174.08,174.47,174.87,175.27,175.67,176.07,176.48,176.88,177.28,177.68,178.09,178.49,178.9,179.3,179.71,180.11,180.52,180.93,181.34,181.74,182.15,182.56,182.97,183.38,183.79,184.2,184.61,185.02,185.43,185.84,186.25,186.67,187.08,187.49,187.9,188.31,188.72,189.14,189.55,189.96,190.37,190.78,191.19,191.6,192.01,192.42,192.83,193.24,193.65,194.06,194.47,194.88,195.28,195.69,196.1,196.5,196.91,197.31,197.72,198.12,198.52,198.93,199.33,199.73,200.13,200.53,200.93,201.33,201.73,202.13,202.52,202.92,203.32,203.71,204.11,204.5,204.89,205.29,205.68,206.07,206.46,206.86,207.25,207.64,208.03,208.41,208.8,209.19,209.58,209.97,210.35,210.74,211.13,211.51,211.9,212.28,212.67,213.05,213.44,213.82,214.2,214.59,214.97,215.36,215.74,216.12,216.51,216.89,217.28,217.66,218.04,218.43,218.81,219.2,219.58,219.97,220.35,220.74,221.13,221.51,221.9,222.29,222.68,223.07,223.46,223.85,224.24,224.63,225.02,225.42,225.81,226.21,226.6,227.0,227.4,227.8,228.2,228.6,229.01,229.41,229.82,230.23,230.64,231.05,231.46,231.88,232.3,232.71,233.14,233.56,233.98,234.41,234.84,235.27,235.7,236.14,236.58,237.02,237.46,237.91,238.36,238.81,239.26,239.72,240.18,240.65,241.12,241.59,242.06,242.54,243.02,243.51,244.0,244.49,244.99,245.49,245.99,246.5,247.02,247.54,248.06,248.59,249.12,249.66,250.21,250.76,251.31,251.87,252.44,253.01,253.59,254.17,254.76,255.36,255.97,256.58,257.2,257.82,258.46,259.1,259.74,260.4,261.07,261.74,262.42,263.11,263.81,264.52,265.24,265.97,266.71,267.46,268.22,268.99,269.77,270.57,271.37,272.19,273.02,273.87,274.73,},
{99.084,99.975,100.85,101.71,102.56,103.4,104.22,105.03,105.83,106.62,107.4,108.16,108.91,109.66,110.39,111.11,111.83,112.53,113.22,113.91,114.59,115.25,115.91,116.56,117.21,117.84,118.47,119.09,119.71,120.31,120.91,121.51,122.09,122.67,123.25,123.82,124.38,124.93,125.48,126.03,126.57,127.11,127.64,128.16,128.68,129.2,129.71,130.21,130.72,131.21,131.71,132.2,132.68,133.16,133.64,134.12,134.59,135.06,135.52,135.98,136.44,136.9,137.35,137.8,138.24,138.69,139.13,139.57,140.0,140.43,140.86,141.29,141.72,142.14,142.57,142.99,143.4,143.82,144.23,144.65,145.06,145.47,145.87,146.28,146.68,147.09,147.49,147.89,148.29,148.68,149.08,149.48,149.87,150.26,150.66,151.05,151.44,151.83,152.22,152.6,152.99,153.38,153.76,154.15,154.54,154.92,155.3,155.69,156.07,156.45,156.84,157.22,157.6,157.98,158.36,158.74,159.13,159.51,159.89,160.27,160.65,161.03,161.41,161.8,162.18,162.56,162.94,163.32,163.71,164.09,164.47,164.85,165.24,165.62,166.01,166.39,166.78,167.16,167.55,167.93,168.32,168.71,169.09,169.48,169.87,170.26,170.65,171.04,171.43,171.82,172.22,172.61,173.0,173.4,173.79,174.18,174.58,174.98,175.37,175.77,176.17,176.57,176.97,177.36,177.76,178.17,178.57,178.97,179.37,179.77,180.18,180.58,180.98,181.39,181.79,182.2,182.61,183.01,183.42,183.82,184.23,184.64,185.05,185.45,185.86,186.27,186.68,187.09,187.49,187.9,188.31,188.72,189.13,189.54,189.94,190.35,190.76,191.17,191.57,191.98,192.39,192.8,193.2,193.61,194.01,194.42,194.82,195.23,195.63,196.03,196.44,196.84,197.24,197.64,198.04,198.44,198.84,199.24,199.64,200.04,200.43,200.83,201.23,201.62,202.02,202.41,202.81,203.2,203.59,203.98,204.38,204.77,205.16,205.55,205.94,206.32,206.71,207.1,207.49,207.87,208.26,208.65,209.03,209.42,209.8,210.19,210.57,210.95,211.34,211.72,212.1,212.48,212.87,213.25,213.63,214.01,214.39,214.77,215.16,215.54,215.92,216.3,216.68,217.06,217.44,217.83,218.21,218.59,218.97,219.35,219.74,220.12,220.5,220.89,221.27,221.66,222.04,222.43,222.81,223.2,223.59,223.98,224.37,224.76,225.15,225.54,225.93,226.33,226.72,227.12,227.52,227.92,228.32,228.72,229.12,229.52,229.93,230.34,230.75,231.16,231.57,231.98,232.4,232.82,233.24,233.66,234.08,234.51,234.94,235.37,235.8,236.23,236.67,237.11,237.56,238.0,238.45,238.9,239.36,239.81,240.27,240.74,241.21,241.68,242.15,242.63,243.11,243.6,244.09,244.58,245.08,245.58,246.08,246.59,247.11,247.63,248.15,248.68,249.22,249.76,250.3,250.85,251.41,251.97,252.54,253.11,253.69,254.28,254.87,255.47,256.07,256.69,257.31,257.93,258.57,259.21,259.86,260.52,261.19,261.86,262.55,263.24,263.94,264.65,265.38,266.11,266.85,267.6,268.37,269.14,269.93,270.72,271.53,272.36,273.19,274.04,},
{99.793,100.67,101.54,102.39,103.23,104.06,104.88,105.68,106.47,107.25,108.02,108.77,109.52,110.25,110.98,111.7,112.4,113.1,113.79,114.46,115.13,115.8,116.45,117.09,117.73,118.36,118.98,119.6,120.21,120.81,121.4,121.99,122.57,123.15,123.72,124.28,124.84,125.39,125.94,126.48,127.01,127.54,128.07,128.59,129.1,129.62,130.12,130.63,131.12,131.62,132.11,132.59,133.08,133.55,134.03,134.5,134.97,135.43,135.89,136.35,136.81,137.26,137.71,138.15,138.59,139.03,139.47,139.91,140.34,140.77,141.2,141.62,142.05,142.47,142.89,143.3,143.72,144.13,144.54,144.95,145.36,145.77,146.17,146.57,146.98,147.38,147.78,148.17,148.57,148.96,149.36,149.75,150.14,150.53,150.92,151.31,151.7,152.09,152.47,152.86,153.24,153.63,154.01,154.39,154.78,155.16,155.54,155.92,156.3,156.68,157.06,157.44,157.82,158.2,158.58,158.96,159.34,159.72,160.1,160.47,160.85,161.23,161.61,161.99,162.37,162.75,163.13,163.51,163.89,164.27,164.65,165.03,165.41,165.79,166.17,166.55,166.94,167.32,167.7,168.08,168.47,168.85,169.24,169.62,170.01,170.4,170.78,171.17,171.56,171.95,172.34,172.73,173.12,173.51,173.9,174.29,174.68,175.08,175.47,175.87,176.26,176.66,177.05,177.45,177.85,178.24,178.64,179.04,179.44,179.84,180.24,180.64,181.04,181.44,181.84,182.25,182.65,183.05,183.46,183.86,184.26,184.67,185.07,185.48,185.88,186.29,186.69,187.09,187.5,187.91,188.31,188.72,189.12,189.53,189.93,190.33,190.74,191.14,191.55,191.95,192.36,192.76,193.16,193.56,193.97,194.37,194.77,195.17,195.57,195.97,196.37,196.77,197.17,197.57,197.97,198.36,198.76,199.15,199.55,199.95,200.34,200.73,201.13,201.52,201.91,202.3,202.69,203.08,203.47,203.86,204.25,204.64,205.03,205.41,205.8,206.19,206.57,206.96,207.34,207.73,208.11,208.49,208.88,209.26,209.64,210.02,210.4,210.78,211.17,211.55,211.93,212.31,212.68,213.06,213.44,213.82,214.2,214.58,214.96,215.34,215.72,216.09,216.47,216.85,217.23,217.61,217.99,218.37,218.75,219.13,219.51,219.89,220.27,220.65,221.03,221.42,221.8,222.18,222.57,222.95,223.34,223.72,224.11,224.5,224.89,225.28,225.67,226.06,226.45,226.84,227.24,227.64,228.03,228.43,228.83,229.23,229.64,230.04,230.45,230.85,231.26,231.67,232.09,232.5,232.92,233.34,233.76,234.18,234.61,235.03,235.46,235.9,236.33,236.77,237.21,237.65,238.1,238.54,239.0,239.45,239.91,240.37,240.83,241.3,241.77,242.24,242.72,243.2,243.69,244.18,244.67,245.17,245.67,246.18,246.69,247.21,247.73,248.25,248.78,249.32,249.86,250.4,250.95,251.51,252.07,252.64,253.22,253.8,254.38,254.98,255.58,256.18,256.8,257.42,258.05,258.69,259.33,259.98,260.64,261.31,261.99,262.68,263.37,264.08,264.79,265.52,266.25,267.0,267.75,268.52,269.3,270.08,270.89,271.7,272.52,273.36,},
{100.49,101.36,102.22,103.06,103.89,104.71,105.52,106.31,107.09,107.86,108.62,109.37,110.11,110.84,111.56,112.27,112.97,113.66,114.34,115.01,115.67,116.33,116.98,117.61,118.25,118.87,119.49,120.1,120.7,121.3,121.88,122.47,123.04,123.61,124.18,124.74,125.29,125.84,126.38,126.91,127.45,127.97,128.49,129.01,129.52,130.03,130.53,131.03,131.53,132.02,132.5,132.98,133.46,133.94,134.41,134.88,135.34,135.8,136.26,136.71,137.16,137.61,138.06,138.5,138.94,139.38,139.81,140.24,140.67,141.1,141.53,141.95,142.37,142.79,143.2,143.62,144.03,144.44,144.85,145.26,145.66,146.06,146.47,146.87,147.27,147.66,148.06,148.45,148.85,149.24,149.63,150.02,150.41,150.8,151.19,151.57,151.96,152.34,152.73,153.11,153.49,153.87,154.25,154.63,155.01,155.39,155.77,156.15,156.53,156.91,157.29,157.66,158.04,158.42,158.79,159.17,159.55,159.92,160.3,160.67,161.05,161.43,161.8,162.18,162.56,162.93,163.31,163.69,164.06,164.44,164.82,165.2,165.58,165.95,166.33,166.71,167.09,167.47,167.85,168.23,168.62,169.0,169.38,169.76,170.15,170.53,170.91,171.3,171.68,172.07,172.46,172.84,173.23,173.62,174.01,174.4,174.79,175.18,175.57,175.96,176.35,176.74,177.14,177.53,177.93,178.32,178.72,179.11,179.51,179.9,180.3,180.7,181.1,181.49,181.89,182.29,182.69,183.09,183.49,183.89,184.29,184.69,185.1,185.5,185.9,186.3,186.7,187.1,187.51,187.91,188.31,188.71,189.11,189.51,189.92,190.32,190.72,191.12,191.52,191.92,192.32,192.72,193.12,193.52,193.92,194.32,194.72,195.12,195.51,195.91,196.31,196.7,197.1,197.49,197.89,198.28,198.68,199.07,199.46,199.85,200.25,200.64,201.03,201.42,201.81,202.2,202.58,202.97,203.36,203.74,204.13,204.52,204.9,205.28,205.67,206.05,206.43,206.82,207.2,207.58,207.96,208.34,208.72,209.1,209.48,209.86,210.24,210.62,211.0,211.37,211.75,212.13,212.51,212.88,213.26,213.64,214.01,214.39,214.76,215.14,215.52,215.89,216.27,216.65,217.02,217.4,217.78,218.15,218.53,218.91,219.28,219.66,220.04,220.42,220.8,221.18,221.56,221.94,222.32,222.7,223.09,223.47,223.86,224.24,224.63,225.01,225.4,225.79,226.18,226.57,226.96,227.36,227.75,228.15,228.55,228.94,229.35,229.75,230.15,230.56,230.96,231.37,231.78,232.19,232.61,233.02,233.44,233.86,234.28,234.71,235.13,235.56,236.0,236.43,236.87,237.31,237.75,238.19,238.64,239.09,239.55,240.0,240.46,240.93,241.39,241.87,242.34,242.82,243.3,243.79,244.28,244.77,245.27,245.77,246.28,246.79,247.3,247.82,248.35,248.88,249.42,249.96,250.5,251.06,251.61,252.18,252.75,253.32,253.91,254.49,255.09,255.69,256.3,256.92,257.54,258.17,258.81,259.45,260.11,260.77,261.44,262.12,262.81,263.51,264.22,264.93,265.66,266.4,267.15,267.91,268.68,269.46,270.25,271.05,271.87,272.7,},
{101.17,102.03,102.88,103.72,104.54,105.35,106.15,106.93,107.71,108.47,109.22,109.96,110.7,111.42,112.13,112.83,113.52,114.2,114.88,115.55,116.2,116.85,117.49,118.13,118.75,119.37,119.98,120.59,121.18,121.77,122.36,122.94,123.51,124.07,124.63,125.19,125.73,126.28,126.81,127.35,127.87,128.4,128.91,129.43,129.93,130.44,130.94,131.43,131.92,132.41,132.89,133.37,133.84,134.31,134.78,135.25,135.71,136.16,136.62,137.07,137.52,137.96,138.41,138.84,139.28,139.72,140.15,140.58,141.0,141.43,141.85,142.27,142.69,143.1,143.51,143.93,144.34,144.74,145.15,145.55,145.96,146.36,146.76,147.15,147.55,147.94,148.34,148.73,149.12,149.51,149.9,150.29,150.67,151.06,151.45,151.83,152.21,152.59,152.98,153.36,153.74,154.11,154.49,154.87,155.25,155.63,156.0,156.38,156.75,157.13,157.51,157.88,158.25,158.63,159.0,159.38,159.75,160.13,160.5,160.87,161.25,161.62,161.99,162.37,162.74,163.12,163.49,163.87,164.24,164.62,164.99,165.37,165.74,166.12,166.49,166.87,167.25,167.63,168.0,168.38,168.76,169.14,169.52,169.9,170.28,170.66,171.04,171.43,171.81,172.19,172.58,172.96,173.34,173.73,174.12,174.5,174.89,175.28,175.66,176.05,176.44,176.83,177.22,177.61,178.0,178.4,178.79,179.18,179.57,179.97,180.36,180.76,181.15,181.55,181.94,182.34,182.73,183.13,183.53,183.93,184.32,184.72,185.12,185.52,185.92,186.31,186.71,187.11,187.51,187.91,188.31,188.71,189.11,189.5,189.9,190.3,190.7,191.1,191.5,191.89,192.29,192.69,193.08,193.48,193.88,194.27,194.67,195.06,195.46,195.85,196.24,196.64,197.03,197.42,197.81,198.21,198.6,198.99,199.38,199.77,200.15,200.54,200.93,201.32,201.7,202.09,202.47,202.86,203.24,203.63,204.01,204.39,204.77,205.16,205.54,205.92,206.3,206.68,207.06,207.44,207.81,208.19,208.57,208.95,209.32,209.7,210.08,210.45,210.83,211.2,211.58,211.95,212.33,212.7,213.08,213.45,213.82,214.2,214.57,214.95,215.32,215.69,216.07,216.44,216.82,217.19,217.56,217.94,218.31,218.69,219.06,219.44,219.82,220.19,220.57,220.95,221.32,221.7,222.08,222.46,222.84,223.22,223.61,223.99,224.37,224.76,225.14,225.53,225.92,226.3,226.69,227.08,227.48,227.87,228.27,228.66,229.06,229.46,229.86,230.26,230.67,231.07,231.48,231.89,232.3,232.71,233.13,233.54,233.96,234.39,234.81,235.24,235.66,236.1,236.53,236.97,237.4,237.85,238.29,238.74,239.19,239.64,240.1,240.56,241.03,241.49,241.96,242.44,242.92,243.4,243.88,244.37,244.87,245.37,245.87,246.38,246.89,247.41,247.93,248.45,248.99,249.52,250.06,250.61,251.16,251.72,252.29,252.86,253.44,254.02,254.61,255.21,255.81,256.42,257.04,257.66,258.3,258.94,259.58,260.24,260.91,261.58,262.26,262.95,263.65,264.36,265.08,265.81,266.55,267.31,268.07,268.84,269.62,270.42,271.23,272.05,},
{101.84,102.7,103.53,104.36,105.17,105.98,106.77,107.54,108.31,109.06,109.81,110.54,111.27,111.98,112.69,113.38,114.07,114.74,115.41,116.07,116.72,117.37,118.0,118.63,119.25,119.86,120.47,121.07,121.66,122.25,122.82,123.4,123.96,124.52,125.08,125.63,126.17,126.71,127.24,127.77,128.29,128.81,129.33,129.83,130.34,130.84,131.33,131.82,132.31,132.79,133.27,133.75,134.22,134.69,135.15,135.61,136.07,136.52,136.97,137.42,137.87,138.31,138.75,139.18,139.62,140.05,140.48,140.9,141.33,141.75,142.17,142.58,143.0,143.41,143.82,144.23,144.64,145.04,145.45,145.85,146.25,146.64,147.04,147.44,147.83,148.22,148.61,149.0,149.39,149.78,150.17,150.55,150.94,151.32,151.7,152.08,152.46,152.84,153.22,153.6,153.98,154.35,154.73,155.11,155.48,155.86,156.23,156.6,156.98,157.35,157.72,158.09,158.47,158.84,159.21,159.58,159.95,160.33,160.7,161.07,161.44,161.81,162.18,162.55,162.93,163.3,163.67,164.04,164.41,164.79,165.16,165.53,165.91,166.28,166.65,167.03,167.4,167.78,168.15,168.53,168.9,169.28,169.66,170.04,170.41,170.79,171.17,171.55,171.93,172.31,172.69,173.07,173.46,173.84,174.22,174.61,174.99,175.37,175.76,176.15,176.53,176.92,177.31,177.69,178.08,178.47,178.86,179.25,179.64,180.03,180.42,180.81,181.21,181.6,181.99,182.38,182.78,183.17,183.56,183.96,184.35,184.75,185.14,185.54,185.93,186.33,186.72,187.12,187.52,187.91,188.31,188.7,189.1,189.49,189.89,190.28,190.68,191.07,191.47,191.86,192.26,192.65,193.05,193.44,193.83,194.22,194.62,195.01,195.4,195.79,196.18,196.57,196.96,197.35,197.74,198.13,198.52,198.9,199.29,199.68,200.06,200.45,200.83,201.22,201.6,201.98,202.37,202.75,203.13,203.51,203.89,204.27,204.65,205.03,205.41,205.79,206.16,206.54,206.92,207.29,207.67,208.05,208.42,208.8,209.17,209.54,209.92,210.29,210.66,211.04,211.41,211.78,212.15,212.52,212.9,213.27,213.64,214.01,214.38,214.75,215.13,215.5,215.87,216.24,216.61,216.98,217.35,217.73,218.1,218.47,218.85,219.22,219.59,219.97,220.34,220.72,221.09,221.47,221.84,222.22,222.6,222.98,223.36,223.74,224.12,224.5,224.88,225.27,225.65,226.04,226.43,226.82,227.21,227.6,227.99,228.38,228.78,229.17,229.57,229.97,230.37,230.78,231.18,231.59,232.0,232.41,232.82,233.23,233.65,234.07,234.49,234.91,235.34,235.77,236.2,236.63,237.07,237.51,237.95,238.39,238.84,239.29,239.74,240.2,240.66,241.12,241.59,242.06,242.54,243.02,243.5,243.99,244.48,244.97,245.47,245.97,246.48,246.99,247.51,248.03,248.56,249.09,249.63,250.17,250.72,251.28,251.84,252.4,252.97,253.55,254.14,254.73,255.33,255.93,256.54,257.16,257.79,258.43,259.07,259.72,260.38,261.05,261.72,262.41,263.1,263.8,264.52,265.24,265.97,266.72,267.47,268.24,269.01,269.8,270.6,271.41,},
{102.5,103.34,104.17,104.99,105.8,106.59,107.37,108.14,108.9,109.65,110.39,111.11,111.83,112.54,113.23,113.92,114.6,115.27,115.94,116.59,117.23,117.87,118.5,119.12,119.74,120.35,120.95,121.54,122.13,122.71,123.28,123.85,124.41,124.97,125.52,126.06,126.6,127.14,127.67,128.19,128.71,129.22,129.73,130.24,130.74,131.23,131.72,132.21,132.69,133.17,133.65,134.12,134.59,135.05,135.51,135.97,136.42,136.87,137.32,137.77,138.21,138.65,139.08,139.52,139.95,140.38,140.8,141.22,141.65,142.06,142.48,142.89,143.31,143.72,144.12,144.53,144.93,145.34,145.74,146.14,146.53,146.93,147.32,147.72,148.11,148.5,148.89,149.27,149.66,150.04,150.43,150.81,151.19,151.57,151.95,152.33,152.71,153.09,153.46,153.84,154.21,154.59,154.96,155.34,155.71,156.08,156.45,156.82,157.2,157.57,157.94,158.31,158.68,159.05,159.42,159.78,160.15,160.52,160.89,161.26,161.63,162.0,162.37,162.74,163.11,163.48,163.85,164.22,164.59,164.96,165.33,165.7,166.07,166.44,166.81,167.18,167.55,167.93,168.3,168.67,169.05,169.42,169.79,170.17,170.55,170.92,171.3,171.67,172.05,172.43,172.81,173.19,173.57,173.95,174.33,174.71,175.09,175.47,175.85,176.24,176.62,177.0,177.39,177.77,178.16,178.54,178.93,179.32,179.7,180.09,180.48,180.87,181.26,181.65,182.04,182.43,182.82,183.21,183.6,183.99,184.38,184.77,185.17,185.56,185.95,186.34,186.74,187.13,187.52,187.91,188.31,188.7,189.09,189.48,189.88,190.27,190.66,191.05,191.44,191.84,192.23,192.62,193.01,193.4,193.79,194.18,194.57,194.96,195.35,195.73,196.12,196.51,196.9,197.28,197.67,198.05,198.44,198.82,199.21,199.59,199.97,200.36,200.74,201.12,201.5,201.88,202.26,202.64,203.02,203.4,203.77,204.15,204.53,204.91,205.28,205.66,206.03,206.41,206.78,207.15,207.53,207.9,208.27,208.64,209.02,209.39,209.76,210.13,210.5,210.87,211.24,211.61,211.98,212.35,212.72,213.09,213.46,213.83,214.2,214.56,214.93,215.3,215.67,216.04,216.41,216.78,217.15,217.52,217.89,218.26,218.63,219.0,219.37,219.74,220.12,220.49,220.86,221.24,221.61,221.99,222.36,222.74,223.11,223.49,223.87,224.25,224.63,225.01,225.4,225.78,226.16,226.55,226.94,227.33,227.72,228.11,228.5,228.89,229.29,229.69,230.08,230.48,230.89,231.29,231.7,232.1,232.51,232.93,233.34,233.76,234.17,234.59,235.02,235.44,235.87,236.3,236.73,237.17,237.61,238.05,238.49,238.94,239.39,239.85,240.3,240.76,241.23,241.69,242.17,242.64,243.12,243.6,244.09,244.58,245.08,245.57,246.08,246.59,247.1,247.62,248.14,248.67,249.2,249.74,250.29,250.84,251.39,251.95,252.52,253.09,253.67,254.26,254.85,255.45,256.06,256.67,257.3,257.92,258.56,259.21,259.86,260.52,261.19,261.87,262.56,263.25,263.96,264.67,265.4,266.14,266.88,267.64,268.41,269.19,269.98,270.79,},
{103.15,103.98,104.8,105.61,106.41,107.19,107.97,108.73,109.48,110.22,110.95,111.67,112.38,113.08,113.77,114.46,115.13,115.79,116.45,117.1,117.74,118.37,118.99,119.61,120.22,120.82,121.42,122.01,122.59,123.16,123.73,124.3,124.85,125.41,125.95,126.49,127.03,127.56,128.08,128.6,129.12,129.63,130.13,130.63,131.13,131.62,132.11,132.59,133.07,133.55,134.02,134.49,134.95,135.41,135.87,136.32,136.77,137.22,137.67,138.11,138.55,138.98,139.42,139.85,140.27,140.7,141.12,141.54,141.96,142.38,142.79,143.2,143.61,144.02,144.42,144.83,145.23,145.63,146.02,146.42,146.82,147.21,147.6,147.99,148.38,148.77,149.15,149.54,149.92,150.3,150.69,151.07,151.45,151.82,152.2,152.58,152.95,153.33,153.7,154.08,154.45,154.82,155.19,155.56,155.93,156.3,156.67,157.04,157.41,157.78,158.15,158.52,158.88,159.25,159.62,159.98,160.35,160.72,161.08,161.45,161.82,162.18,162.55,162.92,163.29,163.65,164.02,164.39,164.75,165.12,165.49,165.86,166.23,166.6,166.96,167.33,167.7,168.07,168.44,168.81,169.19,169.56,169.93,170.3,170.67,171.05,171.42,171.8,172.17,172.55,172.92,173.3,173.67,174.05,174.43,174.81,175.19,175.57,175.95,176.33,176.71,177.09,177.47,177.85,178.23,178.62,179.0,179.38,179.77,180.15,180.54,180.92,181.31,181.7,182.08,182.47,182.86,183.25,183.63,184.02,184.41,184.8,185.19,185.58,185.97,186.36,186.75,187.14,187.53,187.91,188.3,188.69,189.08,189.47,189.86,190.25,190.64,191.03,191.42,191.81,192.2,192.58,192.97,193.36,193.75,194.13,194.52,194.9,195.29,195.68,196.06,196.45,196.83,197.21,197.6,197.98,198.36,198.74,199.12,199.5,199.88,200.26,200.64,201.02,201.4,201.78,202.16,202.53,202.91,203.28,203.66,204.03,204.41,204.78,205.16,205.53,205.9,206.27,206.64,207.02,207.39,207.76,208.13,208.5,208.87,209.23,209.6,209.97,210.34,210.71,211.08,211.44,211.81,212.18,212.54,212.91,213.28,213.64,214.01,214.38,214.74,215.11,215.48,215.85,216.21,216.58,216.95,217.31,217.68,218.05,218.42,218.79,219.16,219.53,219.89,220.27,220.64,221.01,221.38,221.75,222.13,222.5,222.87,223.25,223.63,224.0,224.38,224.76,225.14,225.52,225.91,226.29,226.67,227.06,227.45,227.84,228.23,228.62,229.01,229.4,229.8,230.2,230.6,231.0,231.4,231.81,232.21,232.62,233.03,233.45,233.86,234.28,234.7,235.12,235.55,235.98,236.41,236.84,237.27,237.71,238.15,238.6,239.05,239.5,239.95,240.41,240.87,241.33,241.8,242.27,242.75,243.23,243.71,244.2,244.69,245.18,245.68,246.19,246.7,247.21,247.73,248.25,248.78,249.32,249.86,250.4,250.95,251.51,252.07,252.64,253.22,253.8,254.39,254.98,255.58,256.19,256.81,257.43,258.06,258.7,259.35,260.0,260.67,261.34,262.02,262.71,263.41,264.12,264.84,265.57,266.31,267.06,267.82,268.59,269.38,270.17,},
{103.78,104.61,105.42,106.22,107.01,107.79,108.55,109.31,110.05,110.79,111.51,112.22,112.93,113.62,114.3,114.98,115.65,116.31,116.96,117.6,118.23,118.86,119.48,120.09,120.69,121.29,121.88,122.46,123.04,123.61,124.18,124.74,125.29,125.84,126.38,126.91,127.44,127.97,128.49,129.01,129.52,130.02,130.52,131.02,131.51,132.0,132.49,132.97,133.44,133.91,134.38,134.85,135.31,135.77,136.22,136.67,137.12,137.56,138.01,138.44,138.88,139.31,139.74,140.17,140.6,141.02,141.44,141.85,142.27,142.68,143.09,143.5,143.91,144.31,144.72,145.12,145.52,145.91,146.31,146.7,147.09,147.48,147.87,148.26,148.65,149.03,149.42,149.8,150.18,150.56,150.94,151.32,151.69,152.07,152.45,152.82,153.19,153.57,153.94,154.31,154.68,155.05,155.42,155.79,156.16,156.52,156.89,157.26,157.62,157.99,158.36,158.72,159.09,159.45,159.82,160.18,160.55,160.91,161.27,161.64,162.0,162.37,162.73,163.1,163.46,163.83,164.19,164.56,164.92,165.29,165.65,166.02,166.38,166.75,167.12,167.48,167.85,168.22,168.59,168.95,169.32,169.69,170.06,170.43,170.8,171.17,171.54,171.92,172.29,172.66,173.03,173.41,173.78,174.16,174.53,174.91,175.28,175.66,176.04,176.41,176.79,177.17,177.55,177.93,178.31,178.69,179.07,179.45,179.83,180.21,180.6,180.98,181.36,181.75,182.13,182.51,182.9,183.28,183.67,184.05,184.44,184.83,185.21,185.6,185.98,186.37,186.76,187.14,187.53,187.92,188.3,188.69,189.08,189.46,189.85,190.24,190.62,191.01,191.39,191.78,192.16,192.55,192.93,193.32,193.7,194.09,194.47,194.85,195.24,195.62,196.0,196.38,196.76,197.14,197.53,197.9,198.28,198.66,199.04,199.42,199.8,200.17,200.55,200.93,201.3,201.68,202.05,202.43,202.8,203.17,203.55,203.92,204.29,204.66,205.03,205.4,205.77,206.14,206.51,206.88,207.25,207.62,207.98,208.35,208.72,209.08,209.45,209.82,210.18,210.55,210.91,211.28,211.64,212.01,212.37,212.74,213.1,213.47,213.83,214.19,214.56,214.92,215.29,215.65,216.02,216.38,216.75,217.11,217.48,217.84,218.21,218.58,218.94,219.31,219.68,220.04,220.41,220.78,221.15,221.52,221.89,222.27,222.64,223.01,223.39,223.76,224.14,224.51,224.89,225.27,225.65,226.03,226.41,226.8,227.18,227.57,227.96,228.34,228.73,229.13,229.52,229.92,230.31,230.71,231.11,231.51,231.92,232.32,232.73,233.14,233.56,233.97,234.39,234.81,235.23,235.65,236.08,236.51,236.94,237.38,237.82,238.26,238.7,239.15,239.6,240.06,240.51,240.97,241.44,241.91,242.38,242.85,243.33,243.82,244.31,244.8,245.29,245.79,246.3,246.81,247.33,247.85,248.37,248.9,249.44,249.98,250.52,251.08,251.63,252.2,252.77,253.35,253.93,254.52,255.11,255.72,256.33,256.95,257.57,258.21,258.85,259.5,260.15,260.82,261.5,262.18,262.87,263.57,264.29,265.01,265.74,266.48,267.24,268.0,268.78,269.57,},
{104.4,105.22,106.03,106.82,107.6,108.37,109.13,109.88,110.61,111.34,112.06,112.76,113.46,114.15,114.83,115.5,116.16,116.81,117.45,118.09,118.72,119.34,119.95,120.56,121.16,121.75,122.34,122.91,123.49,124.05,124.61,125.17,125.72,126.26,126.8,127.33,127.85,128.38,128.89,129.4,129.91,130.41,130.91,131.4,131.89,132.38,132.86,133.33,133.81,134.28,134.74,135.2,135.66,136.12,136.57,137.01,137.46,137.9,138.34,138.77,139.21,139.64,140.06,140.49,140.91,141.33,141.75,142.16,142.58,142.99,143.39,143.8,144.2,144.61,145.01,145.4,145.8,146.19,146.59,146.98,147.37,147.76,148.14,148.53,148.91,149.3,149.68,150.06,150.44,150.81,151.19,151.57,151.94,152.31,152.69,153.06,153.43,153.8,154.17,154.54,154.91,155.28,155.64,156.01,156.37,156.74,157.1,157.47,157.83,158.2,158.56,158.92,159.29,159.65,160.01,160.38,160.74,161.1,161.46,161.82,162.19,162.55,162.91,163.27,163.63,164.0,164.36,164.72,165.09,165.45,165.81,166.17,166.54,166.9,167.27,167.63,168.0,168.36,168.73,169.09,169.46,169.83,170.19,170.56,170.93,171.3,171.67,172.03,172.4,172.77,173.14,173.52,173.89,174.26,174.63,175.0,175.38,175.75,176.13,176.5,176.88,177.25,177.63,178.0,178.38,178.76,179.14,179.52,179.89,180.27,180.65,181.03,181.41,181.79,182.18,182.56,182.94,183.32,183.7,184.09,184.47,184.85,185.23,185.62,186.0,186.38,186.77,187.15,187.53,187.92,188.3,188.69,189.07,189.45,189.84,190.22,190.6,190.99,191.37,191.75,192.13,192.52,192.9,193.28,193.66,194.04,194.42,194.8,195.18,195.56,195.94,196.32,196.7,197.08,197.46,197.83,198.21,198.59,198.96,199.34,199.71,200.09,200.46,200.83,201.21,201.58,201.95,202.32,202.69,203.06,203.43,203.8,204.17,204.54,204.91,205.28,205.64,206.01,206.38,206.74,207.11,207.48,207.84,208.21,208.57,208.93,209.3,209.66,210.03,210.39,210.75,211.11,211.48,211.84,212.2,212.56,212.93,213.29,213.65,214.01,214.37,214.74,215.1,215.46,215.82,216.19,216.55,216.91,217.28,217.64,218.0,218.37,218.73,219.1,219.46,219.83,220.19,220.56,220.93,221.3,221.66,222.03,222.4,222.78,223.15,223.52,223.89,224.27,224.64,225.02,225.4,225.78,226.16,226.54,226.92,227.3,227.69,228.08,228.46,228.85,229.24,229.64,230.03,230.43,230.83,231.23,231.63,232.03,232.44,232.84,233.25,233.67,234.08,234.5,234.92,235.34,235.76,236.19,236.62,237.05,237.49,237.93,238.37,238.81,239.26,239.71,240.16,240.62,241.08,241.55,242.02,242.49,242.97,243.45,243.93,244.42,244.91,245.41,245.91,246.42,246.93,247.44,247.96,248.49,249.02,249.56,250.1,250.65,251.2,251.76,252.33,252.9,253.48,254.06,254.65,255.25,255.86,256.47,257.09,257.72,258.35,259.0,259.65,260.31,260.98,261.66,262.34,263.04,263.74,264.46,265.19,265.92,266.67,267.42,268.19,268.97,},
{105.02,105.82,106.62,107.41,108.18,108.94,109.69,110.43,111.16,111.88,112.59,113.29,113.98,114.67,115.34,116.0,116.66,117.3,117.94,118.57,119.2,119.81,120.42,121.02,121.62,122.2,122.78,123.36,123.93,124.49,125.04,125.59,126.14,126.68,127.21,127.74,128.26,128.78,129.29,129.8,130.3,130.8,131.29,131.78,132.27,132.75,133.23,133.7,134.17,134.63,135.09,135.55,136.01,136.46,136.91,137.35,137.79,138.23,138.67,139.1,139.53,139.96,140.38,140.8,141.22,141.64,142.05,142.47,142.88,143.28,143.69,144.09,144.49,144.89,145.29,145.69,146.08,146.47,146.86,147.25,147.64,148.03,148.41,148.79,149.17,149.55,149.93,150.31,150.69,151.06,151.44,151.81,152.18,152.56,152.93,153.3,153.66,154.03,154.4,154.77,155.13,155.5,155.86,156.23,156.59,156.95,157.32,157.68,158.04,158.4,158.76,159.12,159.49,159.85,160.21,160.57,160.93,161.29,161.65,162.01,162.37,162.73,163.09,163.45,163.81,164.17,164.53,164.89,165.25,165.61,165.97,166.33,166.69,167.05,167.42,167.78,168.14,168.5,168.87,169.23,169.59,169.96,170.32,170.69,171.05,171.42,171.78,172.15,172.52,172.89,173.25,173.62,173.99,174.36,174.73,175.1,175.47,175.84,176.21,176.59,176.96,177.33,177.71,178.08,178.45,178.83,179.2,179.58,179.96,180.33,180.71,181.09,181.46,181.84,182.22,182.6,182.98,183.36,183.74,184.12,184.5,184.88,185.26,185.64,186.02,186.4,186.78,187.16,187.54,187.92,188.3,188.68,189.06,189.44,189.82,190.2,190.58,190.96,191.34,191.72,192.1,192.48,192.86,193.24,193.62,194.0,194.38,194.75,195.13,195.51,195.88,196.26,196.64,197.01,197.39,197.76,198.13,198.51,198.88,199.25,199.63,200.0,200.37,200.74,201.11,201.48,201.85,202.22,202.59,202.95,203.32,203.69,204.06,204.42,204.79,205.15,205.52,205.88,206.25,206.61,206.97,207.34,207.7,208.06,208.43,208.79,209.15,209.51,209.87,210.23,210.59,210.95,211.31,211.67,212.03,212.39,212.75,213.11,213.47,213.83,214.19,214.55,214.91,215.27,215.63,215.99,216.35,216.71,217.08,217.44,217.8,218.16,218.52,218.89,219.25,219.61,219.98,220.34,220.71,221.07,221.44,221.81,222.17,222.54,222.91,223.28,223.65,224.03,224.4,224.77,225.15,225.53,225.9,226.28,226.66,227.04,227.43,227.81,228.2,228.58,228.97,229.36,229.75,230.15,230.54,230.94,231.34,231.74,232.14,232.55,232.96,233.37,233.78,234.19,234.61,235.03,235.45,235.87,236.3,236.73,237.16,237.6,238.04,238.48,238.92,239.37,239.82,240.28,240.73,241.19,241.66,242.13,242.6,243.08,243.56,244.04,244.53,245.03,245.52,246.03,246.53,247.05,247.56,248.09,248.61,249.15,249.68,250.23,250.78,251.33,251.89,252.46,253.03,253.61,254.2,254.79,255.39,256.0,256.62,257.24,257.87,258.51,259.15,259.81,260.47,261.14,261.82,262.51,263.21,263.92,264.64,265.37,266.11,266.86,267.62,268.39,},
{105.62,106.42,107.21,107.98,108.75,109.51,110.25,110.98,111.71,112.42,113.12,113.82,114.5,115.18,115.84,116.5,117.15,117.79,118.42,119.05,119.67,120.28,120.88,121.48,122.07,122.65,123.22,123.79,124.36,124.91,125.47,126.01,126.55,127.09,127.61,128.14,128.66,129.17,129.68,130.18,130.68,131.18,131.67,132.15,132.64,133.11,133.59,134.06,134.52,134.98,135.44,135.9,136.35,136.8,137.24,137.69,138.12,138.56,138.99,139.42,139.85,140.27,140.7,141.11,141.53,141.94,142.36,142.77,143.17,143.58,143.98,144.38,144.78,145.18,145.57,145.97,146.36,146.75,147.14,147.52,147.91,148.29,148.67,149.05,149.43,149.81,150.19,150.56,150.94,151.31,151.68,152.05,152.42,152.79,153.16,153.53,153.89,154.26,154.63,154.99,155.35,155.72,156.08,156.44,156.8,157.16,157.52,157.89,158.24,158.6,158.96,159.32,159.68,160.04,160.4,160.76,161.11,161.47,161.83,162.19,162.54,162.9,163.26,163.62,163.98,164.33,164.69,165.05,165.41,165.77,166.12,166.48,166.84,167.2,167.56,167.92,168.28,168.64,169.0,169.36,169.73,170.09,170.45,170.81,171.17,171.54,171.9,172.27,172.63,173.0,173.36,173.73,174.09,174.46,174.83,175.2,175.56,175.93,176.3,176.67,177.04,177.41,177.78,178.15,178.53,178.9,179.27,179.64,180.02,180.39,180.76,181.14,181.51,181.89,182.26,182.64,183.02,183.39,183.77,184.15,184.52,184.9,185.28,185.66,186.03,186.41,186.79,187.17,187.54,187.92,188.3,188.68,189.06,189.43,189.81,190.19,190.57,190.94,191.32,191.7,192.07,192.45,192.83,193.2,193.58,193.95,194.33,194.7,195.08,195.45,195.83,196.2,196.57,196.95,197.32,197.69,198.06,198.43,198.8,199.17,199.54,199.91,200.28,200.65,201.02,201.38,201.75,202.12,202.48,202.85,203.21,203.58,203.94,204.31,204.67,205.03,205.39,205.76,206.12,206.48,206.84,207.2,207.56,207.92,208.28,208.64,209.0,209.36,209.72,210.08,210.44,210.79,211.15,211.51,211.87,212.23,212.58,212.94,213.3,213.66,214.01,214.37,214.73,215.09,215.45,215.8,216.16,216.52,216.88,217.24,217.6,217.96,218.32,218.68,219.04,219.4,219.76,220.13,220.49,220.85,221.22,221.58,221.95,222.31,222.68,223.05,223.42,223.79,224.16,224.53,224.9,225.28,225.65,226.03,226.41,226.79,227.17,227.55,227.93,228.32,228.7,229.09,229.48,229.87,230.27,230.66,231.06,231.46,231.86,232.26,232.66,233.07,233.48,233.89,234.31,234.72,235.14,235.56,235.99,236.41,236.84,237.27,237.71,238.15,238.59,239.03,239.48,239.93,240.39,240.85,241.31,241.77,242.24,242.72,243.19,243.68,244.16,244.65,245.15,245.64,246.15,246.66,247.17,247.69,248.21,248.74,249.27,249.81,250.36,250.91,251.47,252.03,252.6,253.17,253.75,254.34,254.94,255.54,256.15,256.77,257.39,258.02,258.67,259.31,259.97,260.64,261.31,261.99,262.69,263.39,264.1,264.82,265.56,266.3,267.05,267.82,},
{106.21,107.0,107.78,108.55,109.31,110.06,110.79,111.52,112.24,112.94,113.64,114.33,115.01,115.68,116.34,116.99,117.63,118.27,118.9,119.52,120.13,120.73,121.33,121.92,122.51,123.09,123.66,124.22,124.78,125.33,125.88,126.42,126.96,127.49,128.01,128.53,129.05,129.56,130.06,130.56,131.06,131.55,132.04,132.52,133.0,133.47,133.94,134.41,134.87,135.33,135.79,136.24,136.69,137.13,137.57,138.01,138.45,138.88,139.31,139.74,140.16,140.58,141.0,141.42,141.83,142.25,142.65,143.06,143.47,143.87,144.27,144.67,145.06,145.46,145.85,146.24,146.63,147.02,147.4,147.79,148.17,148.55,148.93,149.31,149.69,150.06,150.44,150.81,151.18,151.55,151.92,152.29,152.66,153.03,153.39,153.76,154.12,154.49,154.85,155.21,155.57,155.93,156.29,156.65,157.01,157.37,157.73,158.09,158.45,158.8,159.16,159.52,159.87,160.23,160.59,160.94,161.3,161.65,162.01,162.36,162.72,163.08,163.43,163.79,164.14,164.5,164.85,165.21,165.57,165.92,166.28,166.63,166.99,167.35,167.71,168.06,168.42,168.78,169.14,169.5,169.86,170.22,170.58,170.94,171.3,171.66,172.02,172.38,172.74,173.1,173.47,173.83,174.2,174.56,174.92,175.29,175.66,176.02,176.39,176.76,177.12,177.49,177.86,178.23,178.6,178.97,179.34,179.71,180.08,180.45,180.82,181.19,181.56,181.94,182.31,182.68,183.05,183.43,183.8,184.18,184.55,184.92,185.3,185.67,186.05,186.42,186.8,187.17,187.55,187.92,188.3,188.67,189.05,189.42,189.8,190.17,190.55,190.92,191.3,191.67,192.05,192.42,192.79,193.17,193.54,193.91,194.28,194.66,195.03,195.4,195.77,196.14,196.51,196.88,197.25,197.62,197.99,198.36,198.72,199.09,199.46,199.83,200.19,200.56,200.92,201.29,201.65,202.02,202.38,202.74,203.11,203.47,203.83,204.19,204.55,204.91,205.27,205.63,205.99,206.35,206.71,207.07,207.43,207.78,208.14,208.5,208.86,209.21,209.57,209.93,210.28,210.64,210.99,211.35,211.71,212.06,212.42,212.77,213.13,213.48,213.84,214.19,214.55,214.9,215.26,215.62,215.97,216.33,216.69,217.04,217.4,217.76,218.12,218.47,218.83,219.19,219.55,219.91,220.27,220.63,221.0,221.36,221.72,222.09,222.45,222.82,223.19,223.55,223.92,224.29,224.66,225.03,225.41,225.78,226.16,226.53,226.91,227.29,227.67,228.06,228.44,228.82,229.21,229.6,229.99,230.38,230.78,231.17,231.57,231.97,232.37,232.78,233.19,233.59,234.01,234.42,234.84,235.25,235.68,236.1,236.53,236.96,237.39,237.82,238.26,238.7,239.15,239.6,240.05,240.5,240.96,241.43,241.89,242.36,242.84,243.31,243.8,244.28,244.77,245.27,245.77,246.27,246.78,247.3,247.82,248.34,248.87,249.4,249.95,250.49,251.04,251.6,252.17,252.74,253.32,253.9,254.49,255.09,255.69,256.3,256.92,257.55,258.19,258.83,259.48,260.14,260.81,261.49,262.17,262.87,263.57,264.29,265.02,265.75,266.5,267.26,},
{106.79,107.57,108.35,109.11,109.86,110.6,111.33,112.05,112.76,113.46,114.15,114.83,115.51,116.17,116.82,117.47,118.11,118.74,119.36,119.98,120.58,121.18,121.78,122.36,122.94,123.52,124.08,124.65,125.2,125.75,126.29,126.83,127.36,127.89,128.41,128.92,129.43,129.94,130.44,130.94,131.43,131.92,132.4,132.88,133.36,133.83,134.29,134.76,135.22,135.67,136.12,136.57,137.02,137.46,137.9,138.34,138.77,139.2,139.63,140.05,140.47,140.89,141.31,141.72,142.13,142.54,142.95,143.35,143.75,144.15,144.55,144.95,145.34,145.73,146.12,146.51,146.9,147.28,147.67,148.05,148.43,148.81,149.19,149.56,149.94,150.31,150.68,151.05,151.42,151.79,152.16,152.53,152.89,153.26,153.62,153.98,154.35,154.71,155.07,155.43,155.79,156.15,156.51,156.86,157.22,157.58,157.93,158.29,158.65,159.0,159.36,159.71,160.06,160.42,160.77,161.13,161.48,161.83,162.19,162.54,162.89,163.25,163.6,163.95,164.31,164.66,165.01,165.37,165.72,166.08,166.43,166.78,167.14,167.49,167.85,168.2,168.56,168.91,169.27,169.63,169.98,170.34,170.7,171.06,171.42,171.77,172.13,172.49,172.85,173.21,173.57,173.93,174.3,174.66,175.02,175.38,175.75,176.11,176.47,176.84,177.2,177.57,177.93,178.3,178.67,179.03,179.4,179.77,180.14,180.5,180.87,181.24,181.61,181.98,182.35,182.72,183.09,183.46,183.83,184.21,184.58,184.95,185.32,185.69,186.06,186.44,186.81,187.18,187.55,187.93,188.3,188.67,189.04,189.41,189.79,190.16,190.53,190.9,191.27,191.65,192.02,192.39,192.76,193.13,193.5,193.87,194.24,194.61,194.98,195.35,195.71,196.08,196.45,196.82,197.18,197.55,197.92,198.28,198.65,199.01,199.38,199.74,200.11,200.47,200.83,201.19,201.56,201.92,202.28,202.64,203.0,203.36,203.72,204.08,204.44,204.79,205.15,205.51,205.87,206.22,206.58,206.94,207.29,207.65,208.0,208.36,208.71,209.07,209.42,209.78,210.13,210.48,210.84,211.19,211.54,211.9,212.25,212.6,212.96,213.31,213.66,214.02,214.37,214.72,215.08,215.43,215.79,216.14,216.49,216.85,217.2,217.56,217.92,218.27,218.63,218.99,219.34,219.7,220.06,220.42,220.78,221.14,221.5,221.86,222.23,222.59,222.96,223.32,223.69,224.06,224.42,224.79,225.17,225.54,225.91,226.29,226.66,227.04,227.42,227.8,228.18,228.56,228.95,229.33,229.72,230.11,230.5,230.9,231.29,231.69,232.09,232.49,232.9,233.3,233.71,234.12,234.54,234.95,235.37,235.79,236.22,236.64,237.07,237.5,237.94,238.38,238.82,239.27,239.71,240.17,240.62,241.08,241.54,242.01,242.48,242.96,243.44,243.92,244.41,244.9,245.39,245.89,246.4,246.91,247.43,247.95,248.47,249.0,249.54,250.08,250.63,251.18,251.74,252.31,252.88,253.46,254.05,254.64,255.24,255.85,256.46,257.08,257.71,258.35,259.0,259.65,260.31,260.99,261.67,262.36,263.06,263.76,264.48,265.21,265.95,266.7,},
{107.35,108.13,108.9,109.66,110.4,111.13,111.86,112.57,113.28,113.97,114.65,115.33,116.0,116.65,117.3,117.94,118.58,119.2,119.82,120.43,121.03,121.63,122.22,122.8,123.37,123.94,124.5,125.06,125.61,126.16,126.69,127.23,127.76,128.28,128.79,129.31,129.81,130.32,130.81,131.31,131.8,132.28,132.76,133.24,133.71,134.18,134.64,135.1,135.56,136.01,136.46,136.9,137.35,137.79,138.22,138.65,139.08,139.51,139.94,140.36,140.78,141.19,141.61,142.02,142.43,142.83,143.24,143.64,144.04,144.44,144.83,145.22,145.62,146.01,146.39,146.78,147.16,147.55,147.93,148.31,148.69,149.06,149.44,149.81,150.18,150.55,150.92,151.29,151.66,152.03,152.39,152.76,153.12,153.48,153.85,154.21,154.57,154.93,155.29,155.64,156.0,156.36,156.71,157.07,157.43,157.78,158.13,158.49,158.84,159.19,159.55,159.9,160.25,160.6,160.96,161.31,161.66,162.01,162.36,162.71,163.06,163.42,163.77,164.12,164.47,164.82,165.17,165.52,165.87,166.23,166.58,166.93,167.28,167.64,167.99,168.34,168.69,169.05,169.4,169.76,170.11,170.47,170.82,171.18,171.53,171.89,172.25,172.6,172.96,173.32,173.68,174.04,174.39,174.75,175.11,175.47,175.83,176.2,176.56,176.92,177.28,177.64,178.01,178.37,178.73,179.1,179.46,179.83,180.19,180.56,180.93,181.29,181.66,182.03,182.39,182.76,183.13,183.5,183.87,184.23,184.6,184.97,185.34,185.71,186.08,186.45,186.82,187.19,187.56,187.93,188.3,188.67,189.04,189.41,189.77,190.14,190.51,190.88,191.25,191.62,191.99,192.36,192.72,193.09,193.46,193.83,194.19,194.56,194.93,195.29,195.66,196.03,196.39,196.75,197.12,197.48,197.85,198.21,198.57,198.94,199.3,199.66,200.02,200.38,200.74,201.1,201.46,201.82,202.18,202.54,202.89,203.25,203.61,203.97,204.32,204.68,205.03,205.39,205.74,206.1,206.45,206.81,207.16,207.51,207.87,208.22,208.57,208.92,209.28,209.63,209.98,210.33,210.68,211.03,211.38,211.74,212.09,212.44,212.79,213.14,213.49,213.84,214.19,214.55,214.9,215.25,215.6,215.95,216.31,216.66,217.01,217.36,217.72,218.07,218.43,218.78,219.14,219.49,219.85,220.21,220.57,220.92,221.28,221.64,222.01,222.37,222.73,223.09,223.46,223.82,224.19,224.56,224.93,225.3,225.67,226.04,226.41,226.79,227.16,227.54,227.92,228.3,228.68,229.07,229.45,229.84,230.23,230.62,231.02,231.41,231.81,232.21,232.61,233.01,233.42,233.83,234.24,234.65,235.07,235.49,235.91,236.33,236.76,237.19,237.62,238.06,238.5,238.94,239.39,239.83,240.29,240.74,241.2,241.67,242.13,242.6,243.08,243.56,244.04,244.53,245.02,245.52,246.02,246.53,247.04,247.56,248.08,248.61,249.14,249.68,250.22,250.77,251.33,251.89,252.46,253.03,253.61,254.2,254.8,255.4,256.01,256.63,257.25,257.88,258.52,259.17,259.83,260.49,261.17,261.85,262.55,263.25,263.96,264.68,265.42,266.16,},
{107.91,108.69,109.45,110.19,110.93,111.66,112.38,113.08,113.78,114.47,115.15,115.82,116.48,117.13,117.77,118.41,119.04,119.66,120.27,120.88,121.47,122.06,122.65,123.22,123.8,124.36,124.92,125.47,126.02,126.56,127.09,127.62,128.14,128.66,129.18,129.68,130.19,130.69,131.18,131.67,132.16,132.64,133.11,133.59,134.05,134.52,134.98,135.44,135.89,136.34,136.79,137.23,137.67,138.11,138.54,138.97,139.4,139.82,140.24,140.66,141.08,141.49,141.9,142.31,142.72,143.12,143.52,143.92,144.32,144.71,145.11,145.5,145.89,146.27,146.66,147.04,147.43,147.81,148.18,148.56,148.94,149.31,149.69,150.06,150.43,150.8,151.16,151.53,151.9,152.26,152.62,152.99,153.35,153.71,154.07,154.43,154.79,155.14,155.5,155.86,156.21,156.57,156.92,157.27,157.63,157.98,158.33,158.68,159.03,159.39,159.74,160.09,160.44,160.79,161.14,161.49,161.84,162.19,162.53,162.88,163.23,163.58,163.93,164.28,164.63,164.98,165.33,165.68,166.03,166.38,166.73,167.08,167.43,167.78,168.13,168.48,168.83,169.18,169.53,169.88,170.24,170.59,170.94,171.3,171.65,172.0,172.36,172.71,173.07,173.42,173.78,174.13,174.49,174.85,175.21,175.56,175.92,176.28,176.64,177.0,177.36,177.72,178.08,178.44,178.8,179.16,179.53,179.89,180.25,180.62,180.98,181.34,181.71,182.07,182.44,182.8,183.17,183.53,183.9,184.26,184.63,185.0,185.36,185.73,186.09,186.46,186.83,187.19,187.56,187.93,188.3,188.66,189.03,189.4,189.76,190.13,190.5,190.86,191.23,191.59,191.96,192.33,192.69,193.06,193.42,193.79,194.15,194.51,194.88,195.24,195.61,195.97,196.33,196.69,197.05,197.42,197.78,198.14,198.5,198.86,199.22,199.58,199.94,200.29,200.65,201.01,201.37,201.72,202.08,202.43,202.79,203.15,203.5,203.85,204.21,204.56,204.92,205.27,205.62,205.97,206.33,206.68,207.03,207.38,207.73,208.08,208.43,208.78,209.13,209.48,209.83,210.18,210.53,210.88,211.23,211.58,211.93,212.27,212.62,212.97,213.32,213.67,214.02,214.37,214.72,215.07,215.42,215.77,216.12,216.47,216.82,217.17,217.52,217.88,218.23,218.58,218.94,219.29,219.64,220.0,220.36,220.71,221.07,221.43,221.79,222.15,222.51,222.87,223.23,223.59,223.96,224.32,224.69,225.06,225.43,225.8,226.17,226.54,226.92,227.29,227.67,228.05,228.43,228.81,229.19,229.58,229.96,230.35,230.74,231.14,231.53,231.93,232.33,232.73,233.13,233.54,233.95,234.36,234.77,235.19,235.61,236.03,236.45,236.88,237.31,237.74,238.18,238.62,239.06,239.51,239.96,240.41,240.87,241.33,241.79,242.26,242.73,243.21,243.69,244.17,244.66,245.15,245.65,246.16,246.66,247.18,247.7,248.22,248.75,249.28,249.82,250.37,250.92,251.48,252.04,252.61,253.19,253.77,254.36,254.96,255.56,256.17,256.79,257.42,258.05,258.7,259.35,260.01,260.68,261.36,262.04,262.74,263.45,264.16,264.89,265.63,},
{108.46,109.23,109.98,110.72,111.45,112.18,112.89,113.59,114.28,114.96,115.63,116.3,116.95,117.6,118.24,118.87,119.49,120.11,120.71,121.31,121.91,122.49,123.07,123.64,124.21,124.77,125.33,125.87,126.41,126.95,127.48,128.01,128.53,129.04,129.55,130.06,130.56,131.05,131.54,132.03,132.51,132.99,133.46,133.93,134.4,134.86,135.31,135.77,136.22,136.67,137.11,137.55,137.99,138.42,138.85,139.28,139.7,140.12,140.54,140.96,141.37,141.78,142.19,142.6,143.0,143.4,143.8,144.2,144.59,144.99,145.38,145.77,146.15,146.54,146.92,147.3,147.68,148.06,148.44,148.81,149.19,149.56,149.93,150.3,150.67,151.03,151.4,151.76,152.13,152.49,152.85,153.21,153.57,153.93,154.29,154.64,155.0,155.36,155.71,156.06,156.42,156.77,157.12,157.47,157.83,158.18,158.53,158.88,159.23,159.57,159.92,160.27,160.62,160.97,161.32,161.66,162.01,162.36,162.71,163.05,163.4,163.75,164.09,164.44,164.79,165.13,165.48,165.83,166.18,166.52,166.87,167.22,167.57,167.92,168.26,168.61,168.96,169.31,169.66,170.01,170.36,170.71,171.06,171.41,171.76,172.12,172.47,172.82,173.17,173.53,173.88,174.23,174.59,174.94,175.3,175.65,176.01,176.36,176.72,177.08,177.44,177.79,178.15,178.51,178.87,179.23,179.59,179.95,180.31,180.67,181.03,181.39,181.75,182.11,182.48,182.84,183.2,183.56,183.93,184.29,184.65,185.02,185.38,185.75,186.11,186.47,186.84,187.2,187.57,187.93,188.29,188.66,189.02,189.39,189.75,190.12,190.48,190.84,191.21,191.57,191.93,192.3,192.66,193.02,193.38,193.75,194.11,194.47,194.83,195.19,195.55,195.91,196.27,196.63,196.99,197.35,197.71,198.07,198.42,198.78,199.14,199.5,199.85,200.21,200.56,200.92,201.27,201.63,201.98,202.33,202.69,203.04,203.39,203.75,204.1,204.45,204.8,205.15,205.5,205.85,206.2,206.55,206.9,207.25,207.6,207.94,208.29,208.64,208.99,209.34,209.68,210.03,210.38,210.73,211.07,211.42,211.77,212.11,212.46,212.81,213.15,213.5,213.85,214.2,214.54,214.89,215.24,215.59,215.94,216.28,216.63,216.98,217.33,217.68,218.03,218.38,218.74,219.09,219.44,219.79,220.15,220.5,220.86,221.21,221.57,221.93,222.29,222.65,223.01,223.37,223.73,224.09,224.46,224.82,225.19,225.56,225.93,226.3,226.67,227.04,227.42,227.79,228.17,228.55,228.93,229.32,229.7,230.09,230.48,230.87,231.26,231.65,232.05,232.45,232.85,233.25,233.66,234.07,234.48,234.89,235.31,235.73,236.15,236.57,237.0,237.43,237.86,238.3,238.74,239.18,239.63,240.08,240.53,240.99,241.45,241.92,242.39,242.86,243.34,243.82,244.3,244.79,245.29,245.79,246.29,246.8,247.32,247.84,248.36,248.89,249.43,249.97,250.52,251.07,251.63,252.19,252.77,253.34,253.93,254.52,255.12,255.73,256.34,256.97,257.6,258.23,258.88,259.53,260.2,260.87,261.55,262.24,262.94,263.65,264.37,265.1,},
{109.0,109.76,110.51,111.24,111.97,112.68,113.39,114.08,114.77,115.44,116.11,116.77,117.42,118.06,118.69,119.32,119.94,120.55,121.15,121.75,122.33,122.92,123.49,124.06,124.62,125.18,125.73,126.27,126.81,127.34,127.87,128.39,128.9,129.42,129.92,130.42,130.92,131.41,131.9,132.38,132.86,133.33,133.8,134.27,134.73,135.19,135.65,136.1,136.54,136.99,137.43,137.87,138.3,138.73,139.16,139.58,140.01,140.42,140.84,141.25,141.67,142.07,142.48,142.88,143.28,143.68,144.08,144.47,144.87,145.26,145.65,146.03,146.42,146.8,147.18,147.56,147.94,148.31,148.69,149.06,149.43,149.8,150.17,150.54,150.9,151.27,151.63,152.0,152.36,152.72,153.08,153.43,153.79,154.15,154.5,154.86,155.21,155.57,155.92,156.27,156.62,156.97,157.32,157.67,158.02,158.37,158.72,159.07,159.41,159.76,160.11,160.45,160.8,161.15,161.49,161.84,162.18,162.53,162.87,163.22,163.56,163.91,164.25,164.6,164.94,165.29,165.63,165.98,166.32,166.67,167.01,167.36,167.71,168.05,168.4,168.75,169.09,169.44,169.79,170.13,170.48,170.83,171.18,171.53,171.88,172.23,172.58,172.93,173.28,173.63,173.98,174.33,174.68,175.03,175.39,175.74,176.09,176.45,176.8,177.16,177.51,177.87,178.22,178.58,178.94,179.29,179.65,180.01,180.36,180.72,181.08,181.44,181.8,182.16,182.52,182.88,183.24,183.6,183.96,184.32,184.68,185.04,185.4,185.76,186.12,186.49,186.85,187.21,187.57,187.93,188.29,188.66,189.02,189.38,189.74,190.1,190.46,190.82,191.18,191.54,191.91,192.27,192.63,192.99,193.35,193.71,194.06,194.42,194.78,195.14,195.5,195.86,196.21,196.57,196.93,197.28,197.64,198.0,198.35,198.71,199.06,199.42,199.77,200.12,200.48,200.83,201.18,201.53,201.88,202.24,202.59,202.94,203.29,203.64,203.99,204.34,204.68,205.03,205.38,205.73,206.08,206.42,206.77,207.12,207.46,207.81,208.16,208.5,208.85,209.19,209.54,209.88,210.23,210.57,210.92,211.26,211.61,211.95,212.3,212.64,212.99,213.33,213.68,214.03,214.37,214.72,215.06,215.41,215.75,216.1,216.45,216.8,217.14,217.49,217.84,218.19,218.54,218.89,219.24,219.59,219.94,220.29,220.65,221.0,221.36,221.71,222.07,222.43,222.78,223.14,223.5,223.86,224.23,224.59,224.96,225.32,225.69,226.06,226.43,226.8,227.17,227.55,227.92,228.3,228.68,229.06,229.44,229.83,230.21,230.6,230.99,231.38,231.78,232.17,232.57,232.97,233.38,233.78,234.19,234.6,235.01,235.43,235.85,236.27,236.7,237.12,237.55,237.99,238.42,238.87,239.31,239.76,240.21,240.66,241.12,241.58,242.05,242.52,242.99,243.47,243.95,244.44,244.93,245.43,245.93,246.43,246.94,247.46,247.98,248.51,249.04,249.58,250.12,250.67,251.22,251.78,252.35,252.93,253.51,254.1,254.69,255.29,255.9,256.52,257.14,257.78,258.42,259.07,259.72,260.39,261.07,261.75,262.44,263.15,263.86,264.59,},
{109.54,110.29,111.03,111.75,112.47,113.18,113.88,114.57,115.25,115.92,116.58,117.23,117.88,118.51,119.14,119.76,120.38,120.98,121.58,122.17,122.75,123.33,123.9,124.47,125.02,125.57,126.12,126.66,127.19,127.72,128.25,128.76,129.28,129.78,130.29,130.78,131.28,131.76,132.25,132.73,133.2,133.67,134.14,134.6,135.06,135.52,135.97,136.42,136.86,137.3,137.74,138.18,138.61,139.04,139.46,139.88,140.3,140.72,141.13,141.54,141.95,142.36,142.76,143.16,143.56,143.96,144.35,144.75,145.14,145.52,145.91,146.29,146.68,147.06,147.44,147.81,148.19,148.56,148.93,149.31,149.67,150.04,150.41,150.77,151.14,151.5,151.86,152.22,152.58,152.94,153.3,153.65,154.01,154.36,154.72,155.07,155.42,155.77,156.12,156.47,156.82,157.17,157.52,157.87,158.22,158.56,158.91,159.25,159.6,159.95,160.29,160.63,160.98,161.32,161.67,162.01,162.35,162.7,163.04,163.38,163.73,164.07,164.41,164.75,165.1,165.44,165.78,166.13,166.47,166.81,167.16,167.5,167.84,168.19,168.53,168.88,169.22,169.57,169.91,170.26,170.6,170.95,171.29,171.64,171.99,172.34,172.68,173.03,173.38,173.73,174.08,174.43,174.78,175.13,175.48,175.83,176.18,176.53,176.88,177.23,177.59,177.94,178.29,178.65,179.0,179.35,179.71,180.06,180.42,180.78,181.13,181.49,181.84,182.2,182.56,182.92,183.27,183.63,183.99,184.35,184.7,185.06,185.42,185.78,186.14,186.5,186.86,187.22,187.57,187.93,188.29,188.65,189.01,189.37,189.73,190.09,190.45,190.8,191.16,191.52,191.88,192.24,192.59,192.95,193.31,193.67,194.02,194.38,194.74,195.09,195.45,195.8,196.16,196.51,196.87,197.22,197.57,197.93,198.28,198.63,198.99,199.34,199.69,200.04,200.39,200.74,201.09,201.44,201.79,202.14,202.49,202.84,203.18,203.53,203.88,204.23,204.57,204.92,205.26,205.61,205.96,206.3,206.65,206.99,207.33,207.68,208.02,208.37,208.71,209.05,209.4,209.74,210.08,210.43,210.77,211.11,211.45,211.8,212.14,212.48,212.83,213.17,213.51,213.86,214.2,214.54,214.89,215.23,215.58,215.92,216.27,216.61,216.96,217.3,217.65,218.0,218.34,218.69,219.04,219.39,219.74,220.09,220.44,220.79,221.15,221.5,221.85,222.21,222.57,222.92,223.28,223.64,224.0,224.36,224.72,225.09,225.45,225.82,226.19,226.56,226.93,227.3,227.67,228.05,228.43,228.8,229.18,229.57,229.95,230.34,230.72,231.11,231.51,231.9,232.3,232.7,233.1,233.5,233.91,234.31,234.72,235.14,235.55,235.97,236.4,236.82,237.25,237.68,238.11,238.55,238.99,239.44,239.88,240.34,240.79,241.25,241.71,242.18,242.65,243.12,243.6,244.09,244.58,245.07,245.57,246.07,246.57,247.09,247.6,248.13,248.65,249.19,249.73,250.27,250.82,251.38,251.94,252.51,253.09,253.67,254.26,254.86,255.47,256.08,256.7,257.33,257.96,258.61,259.26,259.92,260.59,261.27,261.96,262.65,263.36,264.08,},
{110.06,110.8,111.53,112.26,112.97,113.67,114.36,115.05,115.72,116.39,117.04,117.69,118.33,118.96,119.58,120.2,120.81,121.41,122.0,122.59,123.17,123.74,124.31,124.87,125.42,125.97,126.51,127.04,127.57,128.1,128.62,129.13,129.64,130.15,130.64,131.14,131.63,132.11,132.59,133.07,133.54,134.01,134.47,134.93,135.39,135.84,136.29,136.74,137.18,137.62,138.05,138.48,138.91,139.34,139.76,140.18,140.6,141.01,141.42,141.83,142.24,142.64,143.04,143.44,143.84,144.23,144.62,145.01,145.4,145.79,146.17,146.55,146.93,147.31,147.69,148.06,148.44,148.81,149.18,149.55,149.91,150.28,150.64,151.01,151.37,151.73,152.09,152.45,152.81,153.16,153.52,153.87,154.22,154.58,154.93,155.28,155.63,155.98,156.33,156.68,157.02,157.37,157.72,158.06,158.41,158.75,159.1,159.44,159.78,160.13,160.47,160.81,161.15,161.5,161.84,162.18,162.52,162.86,163.2,163.54,163.89,164.23,164.57,164.91,165.25,165.59,165.93,166.27,166.61,166.95,167.3,167.64,167.98,168.32,168.66,169.01,169.35,169.69,170.03,170.38,170.72,171.07,171.41,171.75,172.1,172.44,172.79,173.13,173.48,173.83,174.17,174.52,174.87,175.22,175.56,175.91,176.26,176.61,176.96,177.31,177.66,178.01,178.36,178.71,179.06,179.42,179.77,180.12,180.47,180.83,181.18,181.53,181.89,182.24,182.6,182.95,183.31,183.66,184.02,184.37,184.73,185.08,185.44,185.8,186.15,186.51,186.87,187.22,187.58,187.94,188.29,188.65,189.0,189.36,189.72,190.07,190.43,190.79,191.14,191.5,191.85,192.21,192.56,192.92,193.27,193.63,193.98,194.34,194.69,195.04,195.4,195.75,196.1,196.45,196.81,197.16,197.51,197.86,198.21,198.56,198.91,199.26,199.61,199.96,200.31,200.65,201.0,201.35,201.7,202.04,202.39,202.74,203.08,203.43,203.77,204.12,204.46,204.8,205.15,205.49,205.84,206.18,206.52,206.86,207.21,207.55,207.89,208.23,208.57,208.91,209.26,209.6,209.94,210.28,210.62,210.96,211.3,211.64,211.98,212.32,212.67,213.01,213.35,213.69,214.03,214.37,214.71,215.06,215.4,215.74,216.08,216.43,216.77,217.12,217.46,217.81,218.15,218.5,218.84,219.19,219.54,219.89,220.24,220.59,220.94,221.29,221.64,222.0,222.35,222.71,223.06,223.42,223.78,224.14,224.5,224.86,225.22,225.59,225.95,226.32,226.69,227.06,227.43,227.8,228.18,228.55,228.93,229.31,229.69,230.08,230.46,230.85,231.24,231.63,232.03,232.42,232.82,233.22,233.63,234.03,234.44,234.85,235.26,235.68,236.1,236.52,236.95,237.38,237.81,238.24,238.68,239.12,239.57,240.02,240.47,240.92,241.38,241.85,242.31,242.79,243.26,243.74,244.23,244.72,245.21,245.71,246.21,246.72,247.23,247.75,248.28,248.81,249.34,249.88,250.43,250.98,251.54,252.11,252.68,253.26,253.85,254.44,255.04,255.65,256.26,256.88,257.51,258.15,258.8,259.45,260.12,260.79,261.47,262.17,262.87,263.58,},
{110.57,111.31,112.04,112.75,113.46,114.15,114.84,115.52,116.19,116.85,117.5,118.14,118.77,119.4,120.02,120.63,121.23,121.83,122.42,123.0,123.57,124.14,124.7,125.26,125.81,126.35,126.89,127.42,127.95,128.47,128.99,129.5,130.0,130.5,131.0,131.49,131.98,132.46,132.93,133.41,133.88,134.34,134.8,135.26,135.71,136.16,136.61,137.05,137.49,137.93,138.36,138.79,139.21,139.64,140.06,140.47,140.89,141.3,141.71,142.11,142.52,142.92,143.32,143.71,144.11,144.5,144.89,145.28,145.66,146.05,146.43,146.81,147.19,147.56,147.94,148.31,148.68,149.05,149.42,149.78,150.15,150.51,150.88,151.24,151.6,151.96,152.31,152.67,153.02,153.38,153.73,154.08,154.44,154.79,155.14,155.49,155.83,156.18,156.53,156.87,157.22,157.56,157.91,158.25,158.6,158.94,159.28,159.62,159.96,160.31,160.65,160.99,161.33,161.67,162.01,162.35,162.69,163.03,163.37,163.7,164.04,164.38,164.72,165.06,165.4,165.74,166.08,166.42,166.76,167.09,167.43,167.77,168.11,168.45,168.79,169.13,169.47,169.82,170.16,170.5,170.84,171.18,171.52,171.86,172.21,172.55,172.89,173.24,173.58,173.92,174.27,174.61,174.96,175.3,175.65,176.0,176.34,176.69,177.04,177.39,177.73,178.08,178.43,178.78,179.13,179.48,179.83,180.18,180.53,180.88,181.23,181.58,181.93,182.28,182.64,182.99,183.34,183.69,184.05,184.4,184.75,185.11,185.46,185.81,186.17,186.52,186.87,187.23,187.58,187.94,188.29,188.64,189.0,189.35,189.71,190.06,190.41,190.77,191.12,191.47,191.83,192.18,192.53,192.88,193.24,193.59,193.94,194.29,194.64,194.99,195.34,195.7,196.05,196.4,196.75,197.09,197.44,197.79,198.14,198.49,198.84,199.18,199.53,199.88,200.22,200.57,200.91,201.26,201.6,201.95,202.29,202.64,202.98,203.32,203.67,204.01,204.35,204.69,205.03,205.38,205.72,206.06,206.4,206.74,207.08,207.42,207.76,208.1,208.44,208.78,209.12,209.46,209.8,210.13,210.47,210.81,211.15,211.49,211.83,212.17,212.51,212.85,213.19,213.52,213.86,214.2,214.54,214.88,215.22,215.57,215.91,216.25,216.59,216.93,217.28,217.62,217.96,218.31,218.65,219.0,219.34,219.69,220.04,220.38,220.73,221.08,221.43,221.78,222.14,222.49,222.84,223.2,223.56,223.91,224.27,224.63,224.99,225.36,225.72,226.08,226.45,226.82,227.19,227.56,227.93,228.31,228.68,229.06,229.44,229.82,230.2,230.59,230.98,231.37,231.76,232.15,232.55,232.95,233.35,233.75,234.16,234.57,234.98,235.39,235.81,236.23,236.65,237.08,237.51,237.94,238.37,238.81,239.25,239.7,240.15,240.6,241.06,241.52,241.98,242.45,242.92,243.4,243.88,244.37,244.86,245.36,245.86,246.36,246.87,247.39,247.91,248.43,248.96,249.5,250.04,250.59,251.15,251.71,252.28,252.85,253.43,254.02,254.62,255.22,255.83,256.45,257.07,257.71,258.35,259.0,259.66,260.33,261.0,261.69,262.38,263.09,},
{111.08,111.81,112.53,113.24,113.94,114.63,115.31,115.98,116.65,117.3,117.95,118.58,119.21,119.83,120.45,121.05,121.65,122.24,122.83,123.4,123.97,124.54,125.1,125.65,126.19,126.73,127.27,127.8,128.32,128.84,129.35,129.86,130.36,130.85,131.35,131.83,132.32,132.8,133.27,133.74,134.21,134.67,135.13,135.58,136.03,136.48,136.92,137.36,137.8,138.23,138.66,139.08,139.51,139.93,140.35,140.76,141.17,141.58,141.99,142.39,142.79,143.19,143.59,143.98,144.37,144.76,145.15,145.54,145.92,146.3,146.68,147.06,147.43,147.81,148.18,148.55,148.92,149.29,149.65,150.02,150.38,150.74,151.1,151.46,151.82,152.18,152.53,152.89,153.24,153.59,153.95,154.3,154.65,154.99,155.34,155.69,156.04,156.38,156.73,157.07,157.41,157.76,158.1,158.44,158.78,159.12,159.46,159.8,160.14,160.48,160.82,161.16,161.5,161.84,162.17,162.51,162.85,163.19,163.52,163.86,164.2,164.54,164.87,165.21,165.55,165.88,166.22,166.56,166.9,167.23,167.57,167.91,168.25,168.58,168.92,169.26,169.6,169.94,170.28,170.61,170.95,171.29,171.63,171.97,172.31,172.66,173.0,173.34,173.68,174.02,174.36,174.71,175.05,175.39,175.74,176.08,176.42,176.77,177.11,177.46,177.8,178.15,178.5,178.84,179.19,179.54,179.89,180.23,180.58,180.93,181.28,181.63,181.98,182.33,182.68,183.03,183.38,183.73,184.08,184.43,184.78,185.13,185.48,185.83,186.18,186.53,186.88,187.24,187.59,187.94,188.29,188.64,188.99,189.34,189.69,190.05,190.4,190.75,191.1,191.45,191.8,192.15,192.5,192.85,193.2,193.55,193.9,194.25,194.6,194.95,195.29,195.64,195.99,196.34,196.69,197.03,197.38,197.73,198.07,198.42,198.76,199.11,199.45,199.8,200.14,200.48,200.83,201.17,201.51,201.85,202.2,202.54,202.88,203.22,203.56,203.9,204.24,204.58,204.92,205.26,205.6,205.94,206.28,206.62,206.95,207.29,207.63,207.97,208.31,208.64,208.98,209.32,209.65,209.99,210.33,210.67,211.0,211.34,211.68,212.01,212.35,212.69,213.02,213.36,213.7,214.04,214.38,214.71,215.05,215.39,215.73,216.07,216.41,216.75,217.09,217.43,217.78,218.12,218.46,218.8,219.15,219.49,219.84,220.18,220.53,220.88,221.23,221.58,221.93,222.28,222.63,222.98,223.34,223.69,224.05,224.41,224.77,225.13,225.49,225.85,226.22,226.58,226.95,227.32,227.69,228.06,228.44,228.81,229.19,229.57,229.95,230.33,230.72,231.11,231.5,231.89,232.28,232.68,233.08,233.48,233.88,234.29,234.7,235.11,235.52,235.94,236.36,236.78,237.21,237.64,238.07,238.51,238.94,239.39,239.83,240.28,240.74,241.2,241.66,242.12,242.59,243.07,243.54,244.03,244.51,245.01,245.5,246.01,246.51,247.02,247.54,248.06,248.59,249.12,249.66,250.21,250.76,251.32,251.88,252.45,253.03,253.61,254.2,254.8,255.41,256.02,256.64,257.27,257.9,258.55,259.2,259.87,260.54,261.22,261.91,262.61,},
{111.57,112.3,113.01,113.72,114.41,115.1,115.77,116.44,117.1,117.75,118.39,119.02,119.64,120.26,120.87,121.47,122.06,122.65,123.23,123.8,124.37,124.93,125.48,126.03,126.57,127.11,127.64,128.16,128.68,129.2,129.71,130.21,130.71,131.2,131.69,132.17,132.65,133.13,133.6,134.07,134.53,134.99,135.44,135.9,136.34,136.79,137.23,137.66,138.1,138.53,138.96,139.38,139.8,140.22,140.63,141.04,141.45,141.86,142.26,142.67,143.06,143.46,143.86,144.25,144.64,145.02,145.41,145.79,146.17,146.55,146.93,147.31,147.68,148.05,148.42,148.79,149.16,149.52,149.89,150.25,150.61,150.97,151.33,151.69,152.04,152.4,152.75,153.1,153.46,153.81,154.16,154.5,154.85,155.2,155.54,155.89,156.23,156.58,156.92,157.26,157.6,157.95,158.29,158.63,158.97,159.3,159.64,159.98,160.32,160.66,160.99,161.33,161.67,162.0,162.34,162.68,163.01,163.35,163.68,164.02,164.35,164.69,165.02,165.36,165.69,166.03,166.36,166.7,167.03,167.37,167.7,168.04,168.38,168.71,169.05,169.38,169.72,170.06,170.39,170.73,171.07,171.41,171.74,172.08,172.42,172.76,173.1,173.44,173.78,174.12,174.46,174.8,175.14,175.48,175.82,176.16,176.5,176.85,177.19,177.53,177.88,178.22,178.56,178.91,179.25,179.6,179.94,180.29,180.63,180.98,181.33,181.67,182.02,182.37,182.71,183.06,183.41,183.76,184.1,184.45,184.8,185.15,185.5,185.85,186.19,186.54,186.89,187.24,187.59,187.94,188.29,188.64,188.99,189.34,189.68,190.03,190.38,190.73,191.08,191.43,191.77,192.12,192.47,192.82,193.17,193.51,193.86,194.21,194.55,194.9,195.25,195.59,195.94,196.28,196.63,196.97,197.32,197.66,198.0,198.35,198.69,199.03,199.37,199.72,200.06,200.4,200.74,201.08,201.42,201.76,202.1,202.44,202.78,203.12,203.46,203.8,204.13,204.47,204.81,205.15,205.48,205.82,206.16,206.49,206.83,207.17,207.5,207.84,208.17,208.51,208.84,209.18,209.51,209.85,210.18,210.52,210.86,211.19,211.53,211.86,212.2,212.53,212.87,213.2,213.54,213.87,214.21,214.55,214.88,215.22,215.56,215.9,216.23,216.57,216.91,217.25,217.59,217.93,218.27,218.61,218.96,219.3,219.64,219.99,220.33,220.68,221.02,221.37,221.72,222.07,222.42,222.77,223.12,223.48,223.83,224.19,224.55,224.9,225.26,225.62,225.99,226.35,226.72,227.08,227.45,227.82,228.19,228.57,228.94,229.32,229.7,230.08,230.46,230.85,231.24,231.62,232.02,232.41,232.81,233.21,233.61,234.01,234.42,234.83,235.24,235.65,236.07,236.49,236.91,237.34,237.77,238.2,238.64,239.08,239.52,239.97,240.42,240.88,241.34,241.8,242.27,242.74,243.21,243.69,244.17,244.66,245.16,245.66,246.16,246.67,247.18,247.7,248.22,248.75,249.29,249.83,250.38,250.93,251.49,252.06,252.63,253.21,253.79,254.39,254.99,255.6,256.21,256.84,257.47,258.11,258.76,259.41,260.08,260.75,261.44,262.13,},
{112.06,112.78,113.49,114.19,114.88,115.56,116.23,116.89,117.54,118.18,118.82,119.45,120.07,120.68,121.28,121.88,122.47,123.05,123.63,124.2,124.76,125.31,125.86,126.41,126.95,127.48,128.0,128.53,129.04,129.55,130.06,130.56,131.05,131.54,132.03,132.51,132.99,133.46,133.93,134.39,134.85,135.31,135.76,136.21,136.65,137.09,137.53,137.96,138.4,138.82,139.25,139.67,140.09,140.5,140.91,141.32,141.73,142.14,142.54,142.94,143.33,143.73,144.12,144.51,144.9,145.28,145.66,146.05,146.42,146.8,147.18,147.55,147.92,148.29,148.66,149.03,149.39,149.76,150.12,150.48,150.84,151.2,151.55,151.91,152.26,152.61,152.97,153.32,153.67,154.02,154.36,154.71,155.06,155.4,155.74,156.09,156.43,156.77,157.11,157.45,157.79,158.13,158.47,158.81,159.15,159.48,159.82,160.16,160.49,160.83,161.16,161.5,161.83,162.17,162.5,162.84,163.17,163.5,163.84,164.17,164.5,164.84,165.17,165.5,165.84,166.17,166.5,166.84,167.17,167.5,167.84,168.17,168.5,168.84,169.17,169.51,169.84,170.18,170.51,170.85,171.18,171.52,171.85,172.19,172.52,172.86,173.2,173.54,173.87,174.21,174.55,174.89,175.23,175.56,175.9,176.24,176.58,176.92,177.26,177.6,177.95,178.29,178.63,178.97,179.31,179.66,180.0,180.34,180.69,181.03,181.37,181.72,182.06,182.41,182.75,183.1,183.44,183.79,184.13,184.48,184.82,185.17,185.52,185.86,186.21,186.55,186.9,187.25,187.59,187.94,188.29,188.63,188.98,189.33,189.67,190.02,190.37,190.71,191.06,191.4,191.75,192.1,192.44,192.79,193.13,193.48,193.82,194.17,194.51,194.85,195.2,195.54,195.88,196.23,196.57,196.91,197.25,197.59,197.94,198.28,198.62,198.96,199.3,199.64,199.98,200.32,200.66,201.0,201.33,201.67,202.01,202.35,202.68,203.02,203.36,203.69,204.03,204.36,204.7,205.04,205.37,205.71,206.04,206.37,206.71,207.04,207.38,207.71,208.04,208.38,208.71,209.04,209.38,209.71,210.04,210.38,210.71,211.04,211.38,211.71,212.04,212.38,212.71,213.04,213.38,213.71,214.05,214.38,214.72,215.05,215.39,215.72,216.06,216.4,216.73,217.07,217.41,217.75,218.09,218.43,218.77,219.11,219.45,219.79,220.13,220.48,220.82,221.17,221.52,221.86,222.21,222.56,222.91,223.26,223.62,223.97,224.33,224.68,225.04,225.4,225.76,226.12,226.48,226.85,227.22,227.58,227.95,228.33,228.7,229.07,229.45,229.83,230.21,230.59,230.98,231.37,231.76,232.15,232.54,232.94,233.34,233.74,234.14,234.55,234.96,235.37,235.79,236.2,236.62,237.05,237.48,237.91,238.34,238.78,239.22,239.66,240.11,240.56,241.02,241.48,241.94,242.41,242.88,243.36,243.84,244.33,244.82,245.31,245.81,246.32,246.83,247.34,247.86,248.39,248.92,249.46,250.0,250.55,251.1,251.67,252.24,252.81,253.39,253.98,254.58,255.18,255.79,256.41,257.04,257.67,258.32,258.97,259.63,260.3,260.98,261.67,},
{112.54,113.25,113.96,114.65,115.33,116.01,116.67,117.33,117.98,118.62,119.25,119.87,120.48,121.09,121.69,122.28,122.87,123.45,124.02,124.58,125.14,125.69,126.24,126.78,127.31,127.84,128.36,128.88,129.39,129.9,130.4,130.9,131.39,131.88,132.36,132.84,133.31,133.78,134.25,134.71,135.17,135.62,136.07,136.51,136.96,137.39,137.83,138.26,138.69,139.11,139.54,139.95,140.37,140.78,141.19,141.6,142.01,142.41,142.81,143.2,143.6,143.99,144.38,144.77,145.15,145.54,145.92,146.3,146.67,147.05,147.42,147.79,148.16,148.53,148.9,149.26,149.62,149.99,150.35,150.7,151.06,151.42,151.77,152.13,152.48,152.83,153.18,153.53,153.87,154.22,154.57,154.91,155.26,155.6,155.94,156.28,156.62,156.96,157.3,157.64,157.98,158.32,158.65,158.99,159.33,159.66,160.0,160.33,160.67,161.0,161.33,161.67,162.0,162.33,162.66,163.0,163.33,163.66,163.99,164.32,164.65,164.99,165.32,165.65,165.98,166.31,166.64,166.97,167.31,167.64,167.97,168.3,168.63,168.96,169.3,169.63,169.96,170.29,170.63,170.96,171.29,171.63,171.96,172.29,172.63,172.96,173.3,173.63,173.97,174.3,174.64,174.98,175.31,175.65,175.99,176.32,176.66,177.0,177.34,177.68,178.01,178.35,178.69,179.03,179.37,179.71,180.05,180.39,180.74,181.08,181.42,181.76,182.1,182.45,182.79,183.13,183.47,183.82,184.16,184.5,184.85,185.19,185.53,185.88,186.22,186.57,186.91,187.25,187.6,187.94,188.29,188.63,188.97,189.32,189.66,190.01,190.35,190.69,191.04,191.38,191.73,192.07,192.41,192.75,193.1,193.44,193.78,194.12,194.47,194.81,195.15,195.49,195.83,196.17,196.51,196.85,197.19,197.53,197.87,198.21,198.55,198.89,199.22,199.56,199.9,200.24,200.57,200.91,201.25,201.58,201.92,202.25,202.59,202.92,203.26,203.59,203.92,204.26,204.59,204.93,205.26,205.59,205.92,206.26,206.59,206.92,207.25,207.58,207.92,208.25,208.58,208.91,209.24,209.57,209.9,210.24,210.57,210.9,211.23,211.56,211.89,212.22,212.56,212.89,213.22,213.55,213.88,214.22,214.55,214.88,215.22,215.55,215.89,216.22,216.56,216.89,217.23,217.57,217.9,218.24,218.58,218.92,219.26,219.6,219.94,220.28,220.63,220.97,221.31,221.66,222.01,222.35,222.7,223.05,223.4,223.76,224.11,224.46,224.82,225.18,225.53,225.89,226.26,226.62,226.98,227.35,227.72,228.09,228.46,228.83,229.21,229.58,229.96,230.34,230.73,231.11,231.5,231.89,232.28,232.67,233.07,233.47,233.87,234.28,234.68,235.09,235.51,235.92,236.34,236.76,237.19,237.61,238.05,238.48,238.92,239.36,239.81,240.25,240.71,241.16,241.62,242.09,242.56,243.03,243.51,243.99,244.48,244.97,245.47,245.97,246.48,246.99,247.5,248.03,248.55,249.09,249.63,250.17,250.73,251.28,251.85,252.42,253.0,253.58,254.17,254.77,255.38,255.99,256.62,257.25,257.88,258.53,259.19,259.85,260.52,261.21,},
{113.01,113.72,114.42,115.11,115.78,116.45,117.11,117.76,118.41,119.04,119.67,120.28,120.89,121.5,122.09,122.68,123.26,123.83,124.4,124.96,125.52,126.07,126.61,127.14,127.68,128.2,128.72,129.23,129.74,130.25,130.74,131.24,131.73,132.21,132.69,133.16,133.64,134.1,134.56,135.02,135.48,135.93,136.37,136.82,137.26,137.69,138.12,138.55,138.98,139.4,139.82,140.24,140.65,141.06,141.47,141.87,142.28,142.68,143.07,143.47,143.86,144.25,144.64,145.02,145.4,145.79,146.16,146.54,146.92,147.29,147.66,148.03,148.4,148.76,149.13,149.49,149.85,150.21,150.57,150.93,151.28,151.64,151.99,152.34,152.69,153.04,153.39,153.73,154.08,154.43,154.77,155.11,155.45,155.8,156.14,156.48,156.81,157.15,157.49,157.83,158.16,158.5,158.83,159.17,159.5,159.84,160.17,160.5,160.83,161.17,161.5,161.83,162.16,162.49,162.82,163.15,163.48,163.81,164.14,164.47,164.8,165.13,165.46,165.79,166.12,166.45,166.78,167.11,167.44,167.77,168.1,168.43,168.76,169.09,169.42,169.75,170.08,170.41,170.74,171.07,171.4,171.73,172.07,172.4,172.73,173.06,173.39,173.73,174.06,174.39,174.73,175.06,175.4,175.73,176.07,176.4,176.74,177.07,177.41,177.75,178.08,178.42,178.76,179.09,179.43,179.77,180.11,180.45,180.79,181.13,181.46,181.8,182.14,182.48,182.82,183.16,183.51,183.85,184.19,184.53,184.87,185.21,185.55,185.89,186.24,186.58,186.92,187.26,187.6,187.94,188.29,188.63,188.97,189.31,189.65,189.99,190.34,190.68,191.02,191.36,191.7,192.04,192.38,192.72,193.06,193.4,193.74,194.08,194.42,194.76,195.1,195.44,195.78,196.12,196.46,196.79,197.13,197.47,197.8,198.14,198.48,198.81,199.15,199.49,199.82,200.16,200.49,200.82,201.16,201.49,201.83,202.16,202.49,202.83,203.16,203.49,203.82,204.15,204.48,204.82,205.15,205.48,205.81,206.14,206.47,206.8,207.13,207.46,207.79,208.12,208.45,208.78,209.11,209.44,209.77,210.1,210.43,210.75,211.08,211.41,211.74,212.07,212.4,212.73,213.06,213.39,213.73,214.06,214.39,214.72,215.05,215.38,215.72,216.05,216.38,216.72,217.05,217.39,217.72,218.06,218.39,218.73,219.07,219.41,219.75,220.09,220.43,220.77,221.12,221.46,221.8,222.15,222.5,222.84,223.19,223.54,223.9,224.25,224.6,224.96,225.31,225.67,226.03,226.39,226.75,227.12,227.48,227.85,228.22,228.59,228.97,229.34,229.72,230.1,230.48,230.86,231.24,231.63,232.02,232.41,232.81,233.2,233.6,234.01,234.41,234.82,235.23,235.64,236.06,236.48,236.9,237.33,237.75,238.19,238.62,239.06,239.5,239.95,240.4,240.85,241.31,241.77,242.24,242.71,243.19,243.66,244.15,244.64,245.13,245.63,246.13,246.64,247.15,247.67,248.2,248.73,249.26,249.8,250.35,250.91,251.47,252.03,252.61,253.19,253.78,254.37,254.97,255.58,256.2,256.82,257.46,258.1,258.75,259.41,260.08,260.75,},
{113.48,114.18,114.87,115.55,116.23,116.89,117.55,118.19,118.83,119.46,120.08,120.69,121.3,121.9,122.49,123.07,123.65,124.22,124.78,125.34,125.89,126.43,126.97,127.5,128.03,128.55,129.07,129.58,130.08,130.58,131.08,131.57,132.06,132.54,133.01,133.49,133.95,134.42,134.88,135.33,135.78,136.23,136.67,137.11,137.55,137.98,138.41,138.84,139.26,139.68,140.1,140.51,140.93,141.33,141.74,142.14,142.54,142.94,143.33,143.73,144.12,144.5,144.89,145.27,145.65,146.03,146.41,146.78,147.16,147.53,147.9,148.26,148.63,148.99,149.36,149.72,150.08,150.43,150.79,151.15,151.5,151.85,152.2,152.55,152.9,153.25,153.59,153.94,154.28,154.63,154.97,155.31,155.65,155.99,156.33,156.67,157.0,157.34,157.68,158.01,158.35,158.68,159.01,159.35,159.68,160.01,160.34,160.67,161.0,161.33,161.66,161.99,162.32,162.65,162.98,163.31,163.64,163.96,164.29,164.62,164.95,165.28,165.6,165.93,166.26,166.59,166.91,167.24,167.57,167.9,168.23,168.55,168.88,169.21,169.54,169.87,170.19,170.52,170.85,171.18,171.51,171.84,172.17,172.5,172.83,173.16,173.49,173.82,174.15,174.49,174.82,175.15,175.48,175.81,176.15,176.48,176.81,177.15,177.48,177.82,178.15,178.48,178.82,179.16,179.49,179.83,180.16,180.5,180.84,181.17,181.51,181.85,182.18,182.52,182.86,183.2,183.54,183.88,184.21,184.55,184.89,185.23,185.57,185.91,186.25,186.59,186.93,187.27,187.61,187.95,188.28,188.62,188.96,189.3,189.64,189.98,190.32,190.66,191.0,191.34,191.68,192.02,192.35,192.69,193.03,193.37,193.71,194.04,194.38,194.72,195.05,195.39,195.73,196.06,196.4,196.74,197.07,197.41,197.74,198.08,198.41,198.74,199.08,199.41,199.74,200.08,200.41,200.74,201.07,201.41,201.74,202.07,202.4,202.73,203.06,203.39,203.72,204.05,204.38,204.71,205.04,205.37,205.7,206.02,206.35,206.68,207.01,207.34,207.66,207.99,208.32,208.65,208.98,209.3,209.63,209.96,210.29,210.61,210.94,211.27,211.6,211.92,212.25,212.58,212.91,213.24,213.57,213.9,214.23,214.56,214.89,215.22,215.55,215.88,216.21,216.54,216.88,217.21,217.54,217.88,218.21,218.55,218.88,219.22,219.56,219.9,220.24,220.58,220.92,221.26,221.6,221.95,222.29,222.64,222.99,223.33,223.68,224.03,224.39,224.74,225.1,225.45,225.81,226.17,226.53,226.89,227.25,227.62,227.99,228.36,228.73,229.1,229.47,229.85,230.23,230.61,230.99,231.38,231.77,232.16,232.55,232.94,233.34,233.74,234.14,234.55,234.96,235.37,235.78,236.2,236.62,237.04,237.47,237.9,238.33,238.77,239.21,239.65,240.1,240.55,241.0,241.46,241.93,242.39,242.86,243.34,243.82,244.31,244.8,245.29,245.79,246.3,246.81,247.32,247.84,248.37,248.9,249.44,249.98,250.53,251.09,251.65,252.22,252.8,253.38,253.97,254.57,255.18,255.79,256.41,257.04,257.68,258.32,258.98,259.64,260.31,},
{113.94,114.63,115.32,116.0,116.66,117.32,117.97,118.61,119.24,119.87,120.49,121.09,121.7,122.29,122.88,123.46,124.03,124.59,125.15,125.71,126.25,126.8,127.33,127.86,128.38,128.9,129.41,129.92,130.42,130.92,131.41,131.9,132.38,132.86,133.33,133.8,134.27,134.73,135.18,135.64,136.08,136.53,136.97,137.41,137.84,138.27,138.7,139.12,139.55,139.96,140.38,140.79,141.2,141.6,142.01,142.41,142.8,143.2,143.59,143.98,144.37,144.76,145.14,145.52,145.9,146.28,146.65,147.02,147.39,147.76,148.13,148.5,148.86,149.22,149.58,149.94,150.3,150.65,151.01,151.36,151.71,152.06,152.41,152.76,153.11,153.45,153.8,154.14,154.48,154.82,155.17,155.5,155.84,156.18,156.52,156.85,157.19,157.52,157.86,158.19,158.52,158.86,159.19,159.52,159.85,160.18,160.51,160.84,161.17,161.5,161.82,162.15,162.48,162.81,163.13,163.46,163.79,164.11,164.44,164.77,165.09,165.42,165.74,166.07,166.4,166.72,167.05,167.37,167.7,168.03,168.35,168.68,169.0,169.33,169.66,169.98,170.31,170.64,170.96,171.29,171.62,171.95,172.27,172.6,172.93,173.26,173.59,173.92,174.24,174.57,174.9,175.23,175.56,175.89,176.23,176.56,176.89,177.22,177.55,177.88,178.22,178.55,178.88,179.21,179.55,179.88,180.22,180.55,180.88,181.22,181.55,181.89,182.22,182.56,182.9,183.23,183.57,183.9,184.24,184.58,184.91,185.25,185.59,185.92,186.26,186.6,186.94,187.27,187.61,187.95,188.28,188.62,188.96,189.3,189.63,189.97,190.31,190.64,190.98,191.32,191.65,191.99,192.33,192.66,193.0,193.33,193.67,194.0,194.34,194.67,195.01,195.34,195.68,196.01,196.34,196.68,197.01,197.34,197.68,198.01,198.34,198.67,199.01,199.34,199.67,200.0,200.33,200.66,200.99,201.32,201.65,201.98,202.31,202.64,202.96,203.29,203.62,203.95,204.28,204.6,204.93,205.26,205.58,205.91,206.24,206.56,206.89,207.22,207.54,207.87,208.19,208.52,208.84,209.17,209.5,209.82,210.15,210.47,210.8,211.13,211.45,211.78,212.1,212.43,212.76,213.08,213.41,213.74,214.07,214.4,214.72,215.05,215.38,215.71,216.04,216.37,216.7,217.03,217.37,217.7,218.03,218.37,218.7,219.04,219.37,219.71,220.05,220.39,220.72,221.07,221.41,221.75,222.09,222.44,222.78,223.13,223.48,223.82,224.18,224.53,224.88,225.23,225.59,225.95,226.31,226.67,227.03,227.39,227.76,228.12,228.49,228.86,229.24,229.61,229.99,230.37,230.75,231.13,231.52,231.9,232.29,232.69,233.08,233.48,233.88,234.28,234.69,235.1,235.51,235.92,236.34,236.76,237.18,237.61,238.04,238.47,238.91,239.35,239.8,240.25,240.7,241.15,241.62,242.08,242.55,243.02,243.5,243.98,244.47,244.96,245.46,245.96,246.47,246.98,247.5,248.02,248.55,249.08,249.62,250.17,250.72,251.28,251.85,252.42,253.0,253.58,254.18,254.78,255.39,256.0,256.63,257.26,257.9,258.55,259.21,259.87,},
{114.39,115.08,115.76,116.43,117.09,117.75,118.39,119.03,119.65,120.27,120.89,121.49,122.09,122.68,123.26,123.84,124.4,124.97,125.52,126.07,126.61,127.15,127.68,128.21,128.73,129.24,129.75,130.26,130.75,131.25,131.74,132.22,132.7,133.18,133.65,134.11,134.57,135.03,135.49,135.94,136.38,136.82,137.26,137.7,138.13,138.56,138.98,139.4,139.82,140.24,140.65,141.06,141.47,141.87,142.27,142.67,143.06,143.46,143.85,144.24,144.62,145.0,145.39,145.76,146.14,146.52,146.89,147.26,147.63,148.0,148.36,148.73,149.09,149.45,149.81,150.16,150.52,150.87,151.22,151.58,151.93,152.27,152.62,152.97,153.31,153.66,154.0,154.34,154.68,155.02,155.36,155.7,156.03,156.37,156.71,157.04,157.37,157.71,158.04,158.37,158.7,159.03,159.36,159.69,160.02,160.35,160.68,161.0,161.33,161.66,161.98,162.31,162.64,162.96,163.29,163.61,163.94,164.26,164.59,164.91,165.23,165.56,165.88,166.21,166.53,166.85,167.18,167.5,167.83,168.15,168.48,168.8,169.12,169.45,169.77,170.1,170.42,170.75,171.07,171.4,171.72,172.05,172.37,172.7,173.03,173.35,173.68,174.01,174.33,174.66,174.99,175.32,175.65,175.97,176.3,176.63,176.96,177.29,177.62,177.95,178.28,178.61,178.94,179.27,179.61,179.94,180.27,180.6,180.93,181.27,181.6,181.93,182.26,182.6,182.93,183.26,183.6,183.93,184.27,184.6,184.94,185.27,185.6,185.94,186.27,186.61,186.94,187.28,187.61,187.95,188.28,188.62,188.95,189.29,189.62,189.96,190.29,190.63,190.96,191.3,191.63,191.96,192.3,192.63,192.96,193.3,193.63,193.96,194.3,194.63,194.96,195.3,195.63,195.96,196.29,196.62,196.95,197.28,197.61,197.94,198.27,198.6,198.93,199.26,199.59,199.92,200.25,200.58,200.91,201.23,201.56,201.89,202.22,202.54,202.87,203.19,203.52,203.85,204.17,204.5,204.82,205.15,205.47,205.8,206.12,206.45,206.77,207.1,207.42,207.74,208.07,208.39,208.72,209.04,209.36,209.69,210.01,210.34,210.66,210.98,211.31,211.63,211.96,212.28,212.61,212.93,213.26,213.58,213.91,214.24,214.56,214.89,215.22,215.55,215.87,216.2,216.53,216.86,217.19,217.52,217.85,218.19,218.52,218.85,219.19,219.52,219.86,220.2,220.53,220.87,221.21,221.55,221.89,222.24,222.58,222.92,223.27,223.62,223.97,224.32,224.67,225.02,225.37,225.73,226.09,226.44,226.8,227.17,227.53,227.89,228.26,228.63,229.0,229.37,229.75,230.12,230.5,230.88,231.27,231.65,232.04,232.43,232.82,233.22,233.62,234.02,234.42,234.83,235.24,235.65,236.06,236.48,236.9,237.33,237.76,238.19,238.62,239.06,239.5,239.95,240.4,240.85,241.31,241.77,242.24,242.71,243.18,243.66,244.15,244.63,245.13,245.63,246.13,246.64,247.15,247.67,248.2,248.73,249.27,249.81,250.36,250.91,251.47,252.04,252.62,253.2,253.79,254.39,254.99,255.6,256.22,256.85,257.48,258.13,258.78,259.44,},
{114.83,115.51,116.19,116.86,117.51,118.16,118.8,119.43,120.06,120.67,121.28,121.88,122.47,123.06,123.64,124.21,124.77,125.33,125.88,126.43,126.97,127.5,128.03,128.55,129.07,129.58,130.09,130.59,131.08,131.57,132.06,132.54,133.02,133.49,133.96,134.42,134.88,135.33,135.79,136.23,136.68,137.12,137.55,137.98,138.41,138.84,139.26,139.68,140.1,140.51,140.92,141.33,141.73,142.13,142.53,142.93,143.32,143.71,144.1,144.48,144.87,145.25,145.63,146.01,146.38,146.75,147.12,147.49,147.86,148.23,148.59,148.95,149.31,149.67,150.03,150.38,150.73,151.09,151.44,151.79,152.13,152.48,152.83,153.17,153.51,153.86,154.2,154.54,154.88,155.21,155.55,155.89,156.22,156.56,156.89,157.22,157.55,157.89,158.22,158.55,158.88,159.2,159.53,159.86,160.19,160.51,160.84,161.17,161.49,161.82,162.14,162.47,162.79,163.11,163.44,163.76,164.08,164.41,164.73,165.05,165.37,165.7,166.02,166.34,166.66,166.99,167.31,167.63,167.95,168.28,168.6,168.92,169.24,169.57,169.89,170.21,170.53,170.86,171.18,171.5,171.83,172.15,172.48,172.8,173.12,173.45,173.77,174.1,174.42,174.75,175.07,175.4,175.73,176.05,176.38,176.71,177.03,177.36,177.69,178.02,178.35,178.67,179.0,179.33,179.66,179.99,180.32,180.65,180.98,181.31,181.64,181.97,182.3,182.63,182.97,183.3,183.63,183.96,184.29,184.62,184.96,185.29,185.62,185.95,186.29,186.62,186.95,187.28,187.62,187.95,188.28,188.61,188.95,189.28,189.61,189.95,190.28,190.61,190.94,191.27,191.61,191.94,192.27,192.6,192.93,193.26,193.6,193.93,194.26,194.59,194.92,195.25,195.58,195.91,196.24,196.57,196.9,197.22,197.55,197.88,198.21,198.54,198.86,199.19,199.52,199.84,200.17,200.5,200.82,201.15,201.47,201.8,202.13,202.45,202.77,203.1,203.42,203.75,204.07,204.39,204.72,205.04,205.36,205.69,206.01,206.33,206.65,206.98,207.3,207.62,207.94,208.27,208.59,208.91,209.23,209.56,209.88,210.2,210.52,210.84,211.17,211.49,211.81,212.14,212.46,212.78,213.11,213.43,213.76,214.08,214.41,214.73,215.06,215.38,215.71,216.04,216.36,216.69,217.02,217.35,217.68,218.01,218.34,218.67,219.01,219.34,219.67,220.01,220.34,220.68,221.02,221.36,221.7,222.04,222.38,222.72,223.07,223.41,223.76,224.11,224.46,224.81,225.16,225.51,225.87,226.22,226.58,226.94,227.3,227.67,228.03,228.4,228.77,229.14,229.51,229.89,230.26,230.64,231.02,231.41,231.79,232.18,232.57,232.96,233.36,233.76,234.16,234.56,234.97,235.38,235.79,236.21,236.63,237.05,237.48,237.9,238.34,238.77,239.21,239.66,240.1,240.55,241.01,241.47,241.93,242.4,242.87,243.35,243.83,244.31,244.8,245.3,245.8,246.3,246.81,247.33,247.85,248.38,248.91,249.45,250.0,250.55,251.11,251.67,252.24,252.82,253.41,254.0,254.6,255.21,255.82,256.44,257.07,257.71,258.36,259.02,},
{115.27,115.95,116.62,117.28,117.93,118.57,119.21,119.84,120.45,121.07,121.67,122.27,122.85,123.44,124.01,124.58,125.14,125.69,126.24,126.78,127.32,127.85,128.37,128.89,129.41,129.91,130.42,130.91,131.41,131.89,132.38,132.85,133.33,133.8,134.26,134.72,135.18,135.63,136.08,136.52,136.97,137.4,137.84,138.27,138.69,139.12,139.54,139.95,140.37,140.78,141.18,141.59,141.99,142.39,142.79,143.18,143.57,143.96,144.35,144.73,145.11,145.49,145.87,146.24,146.62,146.99,147.36,147.72,148.09,148.45,148.81,149.17,149.53,149.89,150.24,150.6,150.95,151.3,151.65,151.99,152.34,152.69,153.03,153.37,153.71,154.05,154.39,154.73,155.07,155.4,155.74,156.07,156.41,156.74,157.07,157.4,157.73,158.06,158.39,158.72,159.05,159.38,159.7,160.03,160.35,160.68,161.0,161.33,161.65,161.97,162.3,162.62,162.94,163.26,163.59,163.91,164.23,164.55,164.87,165.19,165.51,165.83,166.15,166.48,166.8,167.12,167.44,167.76,168.08,168.4,168.72,169.04,169.36,169.68,170.0,170.32,170.64,170.97,171.29,171.61,171.93,172.25,172.57,172.9,173.22,173.54,173.86,174.19,174.51,174.83,175.16,175.48,175.81,176.13,176.46,176.78,177.11,177.43,177.76,178.08,178.41,178.74,179.06,179.39,179.72,180.04,180.37,180.7,181.03,181.36,181.68,182.01,182.34,182.67,183.0,183.33,183.66,183.99,184.32,184.65,184.98,185.31,185.64,185.97,186.3,186.63,186.96,187.29,187.62,187.95,188.28,188.61,188.94,189.27,189.6,189.93,190.26,190.59,190.92,191.25,191.58,191.91,192.24,192.57,192.9,193.23,193.56,193.89,194.22,194.55,194.87,195.2,195.53,195.86,196.18,196.51,196.84,197.17,197.49,197.82,198.14,198.47,198.79,199.12,199.45,199.77,200.09,200.42,200.74,201.07,201.39,201.71,202.04,202.36,202.68,203.0,203.33,203.65,203.97,204.29,204.61,204.94,205.26,205.58,205.9,206.22,206.54,206.86,207.18,207.5,207.82,208.14,208.46,208.78,209.1,209.42,209.75,210.07,210.39,210.71,211.03,211.35,211.67,211.99,212.31,212.64,212.96,213.28,213.6,213.93,214.25,214.57,214.9,215.22,215.55,215.87,216.2,216.52,216.85,217.18,217.51,217.84,218.16,218.5,218.83,219.16,219.49,219.82,220.16,220.49,220.83,221.17,221.5,221.84,222.18,222.52,222.87,223.21,223.56,223.9,224.25,224.6,224.95,225.3,225.65,226.01,226.36,226.72,227.08,227.44,227.81,228.17,228.54,228.91,229.28,229.65,230.03,230.4,230.78,231.16,231.55,231.93,232.32,232.71,233.11,233.5,233.9,234.3,234.71,235.12,235.53,235.94,236.36,236.78,237.2,237.63,238.06,238.49,238.93,239.37,239.81,240.26,240.71,241.17,241.63,242.09,242.56,243.03,243.51,244.0,244.48,244.97,245.47,245.97,246.48,246.99,247.51,248.04,248.57,249.1,249.64,250.19,250.75,251.31,251.87,252.45,253.03,253.62,254.21,254.82,255.43,256.05,256.67,257.31,257.95,258.6,},
{115.69,116.37,117.03,117.69,118.34,118.98,119.61,120.23,120.85,121.45,122.05,122.64,123.23,123.81,124.38,124.94,125.5,126.05,126.59,127.13,127.66,128.19,128.71,129.23,129.74,130.24,130.74,131.23,131.72,132.21,132.69,133.16,133.63,134.1,134.56,135.02,135.48,135.92,136.37,136.81,137.25,137.69,138.12,138.54,138.97,139.39,139.81,140.22,140.63,141.04,141.45,141.85,142.25,142.65,143.04,143.43,143.82,144.21,144.59,144.97,145.35,145.73,146.11,146.48,146.85,147.22,147.59,147.95,148.31,148.68,149.04,149.39,149.75,150.1,150.46,150.81,151.16,151.51,151.85,152.2,152.54,152.89,153.23,153.57,153.91,154.25,154.59,154.92,155.26,155.59,155.93,156.26,156.59,156.92,157.25,157.58,157.91,158.24,158.57,158.89,159.22,159.54,159.87,160.19,160.52,160.84,161.16,161.49,161.81,162.13,162.45,162.77,163.09,163.41,163.73,164.05,164.37,164.69,165.01,165.33,165.65,165.97,166.29,166.61,166.93,167.24,167.56,167.88,168.2,168.52,168.84,169.16,169.48,169.8,170.11,170.43,170.75,171.07,171.39,171.71,172.03,172.35,172.67,172.99,173.31,173.63,173.96,174.28,174.6,174.92,175.24,175.56,175.89,176.21,176.53,176.85,177.18,177.5,177.82,178.15,178.47,178.8,179.12,179.45,179.77,180.1,180.42,180.75,181.07,181.4,181.73,182.05,182.38,182.71,183.03,183.36,183.69,184.02,184.34,184.67,185.0,185.33,185.65,185.98,186.31,186.64,186.97,187.3,187.62,187.95,188.28,188.61,188.94,189.27,189.59,189.92,190.25,190.58,190.91,191.23,191.56,191.89,192.22,192.54,192.87,193.2,193.52,193.85,194.18,194.5,194.83,195.16,195.48,195.81,196.13,196.46,196.78,197.11,197.43,197.76,198.08,198.4,198.73,199.05,199.37,199.7,200.02,200.34,200.66,200.98,201.31,201.63,201.95,202.27,202.59,202.91,203.23,203.55,203.87,204.19,204.51,204.83,205.15,205.47,205.79,206.11,206.43,206.75,207.06,207.38,207.7,208.02,208.34,208.66,208.98,209.3,209.61,209.93,210.25,210.57,210.89,211.21,211.53,211.85,212.17,212.49,212.81,213.13,213.45,213.77,214.09,214.42,214.74,215.06,215.39,215.71,216.03,216.36,216.68,217.01,217.34,217.66,217.99,218.32,218.65,218.98,219.31,219.64,219.97,220.31,220.64,220.98,221.31,221.65,221.99,222.33,222.67,223.01,223.35,223.7,224.05,224.39,224.74,225.09,225.44,225.8,226.15,226.51,226.86,227.22,227.58,227.95,228.31,228.68,229.05,229.42,229.79,230.17,230.54,230.92,231.31,231.69,232.08,232.47,232.86,233.25,233.65,234.05,234.45,234.86,235.26,235.67,236.09,236.51,236.93,237.35,237.78,238.21,238.64,239.08,239.52,239.97,240.42,240.87,241.33,241.79,242.26,242.73,243.2,243.68,244.17,244.66,245.15,245.65,246.15,246.66,247.18,247.7,248.23,248.76,249.3,249.84,250.39,250.95,251.51,252.08,252.66,253.24,253.83,254.43,255.04,255.65,256.28,256.91,257.54,258.19,},
{116.12,116.79,117.45,118.1,118.74,119.38,120.0,120.62,121.23,121.83,122.43,123.02,123.6,124.17,124.74,125.3,125.85,126.4,126.94,127.47,128.0,128.53,129.04,129.56,130.06,130.56,131.06,131.55,132.04,132.52,133.0,133.47,133.94,134.4,134.86,135.32,135.77,136.21,136.66,137.1,137.53,137.96,138.39,138.82,139.24,139.66,140.07,140.49,140.9,141.3,141.7,142.1,142.5,142.9,143.29,143.68,144.07,144.45,144.83,145.21,145.59,145.97,146.34,146.71,147.08,147.45,147.81,148.17,148.54,148.9,149.25,149.61,149.96,150.32,150.67,151.02,151.37,151.71,152.06,152.4,152.75,153.09,153.43,153.77,154.11,154.44,154.78,155.11,155.45,155.78,156.11,156.44,156.77,157.1,157.43,157.76,158.08,158.41,158.74,159.06,159.39,159.71,160.03,160.36,160.68,161.0,161.32,161.64,161.96,162.28,162.6,162.92,163.24,163.56,163.88,164.2,164.51,164.83,165.15,165.47,165.79,166.1,166.42,166.74,167.05,167.37,167.69,168.01,168.32,168.64,168.96,169.27,169.59,169.91,170.23,170.54,170.86,171.18,171.5,171.81,172.13,172.45,172.77,173.09,173.41,173.73,174.04,174.36,174.68,175.0,175.32,175.64,175.96,176.28,176.6,176.93,177.25,177.57,177.89,178.21,178.53,178.86,179.18,179.5,179.83,180.15,180.47,180.8,181.12,181.44,181.77,182.09,182.42,182.74,183.07,183.39,183.72,184.04,184.37,184.69,185.02,185.34,185.67,186.0,186.32,186.65,186.97,187.3,187.63,187.95,188.28,188.61,188.93,189.26,189.58,189.91,190.24,190.56,190.89,191.21,191.54,191.86,192.19,192.51,192.84,193.16,193.49,193.81,194.14,194.46,194.79,195.11,195.43,195.76,196.08,196.4,196.73,197.05,197.37,197.69,198.02,198.34,198.66,198.98,199.3,199.62,199.94,200.26,200.58,200.9,201.22,201.54,201.86,202.18,202.5,202.82,203.14,203.46,203.77,204.09,204.41,204.73,205.05,205.36,205.68,206.0,206.31,206.63,206.95,207.27,207.58,207.9,208.22,208.53,208.85,209.17,209.49,209.8,210.12,210.44,210.75,211.07,211.39,211.71,212.03,212.35,212.66,212.98,213.3,213.62,213.94,214.26,214.58,214.9,215.23,215.55,215.87,216.19,216.52,216.84,217.17,217.49,217.82,218.15,218.47,218.8,219.13,219.46,219.79,220.12,220.46,220.79,221.13,221.46,221.8,222.14,222.47,222.82,223.16,223.5,223.84,224.19,224.54,224.88,225.23,225.58,225.94,226.29,226.65,227.01,227.36,227.73,228.09,228.45,228.82,229.19,229.56,229.93,230.31,230.69,231.07,231.45,231.83,232.22,232.61,233.0,233.4,233.79,234.19,234.6,235.0,235.41,235.82,236.24,236.66,237.08,237.5,237.93,238.37,238.8,239.24,239.68,240.13,240.58,241.04,241.49,241.96,242.43,242.9,243.37,243.86,244.34,244.83,245.33,245.83,246.34,246.85,247.37,247.89,248.42,248.95,249.49,250.04,250.59,251.15,251.72,252.29,252.87,253.46,254.06,254.66,255.27,255.88,256.51,257.14,257.79,},
{116.53,117.2,117.85,118.5,119.14,119.77,120.39,121.0,121.61,122.21,122.8,123.38,123.96,124.53,125.09,125.65,126.2,126.74,127.28,127.81,128.34,128.86,129.37,129.88,130.38,130.88,131.38,131.86,132.35,132.83,133.3,133.77,134.24,134.7,135.15,135.61,136.05,136.5,136.94,137.38,137.81,138.24,138.67,139.09,139.51,139.92,140.34,140.75,141.15,141.56,141.96,142.36,142.75,143.15,143.54,143.92,144.31,144.69,145.07,145.45,145.83,146.2,146.57,146.94,147.31,147.67,148.03,148.4,148.76,149.11,149.47,149.82,150.18,150.53,150.88,151.23,151.57,151.92,152.26,152.6,152.94,153.28,153.62,153.96,154.3,154.63,154.97,155.3,155.63,155.96,156.29,156.62,156.95,157.28,157.61,157.93,158.26,158.58,158.91,159.23,159.55,159.87,160.2,160.52,160.84,161.16,161.48,161.8,162.12,162.43,162.75,163.07,163.39,163.7,164.02,164.34,164.65,164.97,165.29,165.6,165.92,166.23,166.55,166.87,167.18,167.5,167.81,168.13,168.44,168.76,169.07,169.39,169.7,170.02,170.34,170.65,170.97,171.28,171.6,171.91,172.23,172.55,172.86,173.18,173.5,173.81,174.13,174.45,174.77,175.09,175.4,175.72,176.04,176.36,176.68,177.0,177.32,177.64,177.96,178.28,178.6,178.92,179.24,179.56,179.88,180.2,180.52,180.84,181.16,181.49,181.81,182.13,182.45,182.78,183.1,183.42,183.75,184.07,184.39,184.72,185.04,185.36,185.69,186.01,186.33,186.66,186.98,187.31,187.63,187.95,188.28,188.6,188.93,189.25,189.57,189.9,190.22,190.55,190.87,191.19,191.52,191.84,192.16,192.49,192.81,193.13,193.46,193.78,194.1,194.42,194.74,195.07,195.39,195.71,196.03,196.35,196.67,196.99,197.31,197.63,197.95,198.27,198.59,198.91,199.23,199.55,199.87,200.19,200.51,200.82,201.14,201.46,201.78,202.09,202.41,202.73,203.04,203.36,203.68,203.99,204.31,204.63,204.94,205.26,205.57,205.89,206.2,206.52,206.83,207.15,207.47,207.78,208.1,208.41,208.73,209.04,209.36,209.67,209.99,210.3,210.62,210.94,211.25,211.57,211.89,212.2,212.52,212.84,213.16,213.47,213.79,214.11,214.43,214.75,215.07,215.39,215.71,216.03,216.35,216.68,217.0,217.32,217.65,217.97,218.3,218.63,218.96,219.28,219.61,219.94,220.27,220.61,220.94,221.27,221.61,221.94,222.28,222.62,222.96,223.3,223.64,223.99,224.33,224.68,225.03,225.38,225.73,226.08,226.43,226.79,227.15,227.51,227.87,228.23,228.6,228.96,229.33,229.7,230.08,230.45,230.83,231.21,231.59,231.98,232.37,232.76,233.15,233.54,233.94,234.34,234.75,235.15,235.56,235.98,236.39,236.81,237.23,237.66,238.09,238.52,238.96,239.4,239.85,240.29,240.75,241.2,241.66,242.13,242.6,243.07,243.55,244.03,244.52,245.01,245.51,246.02,246.52,247.04,247.56,248.08,248.61,249.15,249.7,250.25,250.8,251.36,251.93,252.51,253.09,253.68,254.28,254.89,255.5,256.12,256.75,257.39,},
{116.94,117.6,118.25,118.9,119.53,120.15,120.77,121.38,121.98,122.58,123.17,123.75,124.32,124.88,125.44,126.0,126.54,127.08,127.62,128.14,128.67,129.18,129.69,130.2,130.7,131.2,131.69,132.17,132.65,133.13,133.6,134.07,134.53,134.99,135.44,135.89,136.34,136.78,137.22,137.65,138.08,138.51,138.93,139.36,139.77,140.19,140.6,141.01,141.41,141.81,142.21,142.61,143.0,143.39,143.78,144.16,144.55,144.93,145.31,145.68,146.06,146.43,146.8,147.16,147.53,147.89,148.25,148.61,148.97,149.33,149.68,150.04,150.39,150.74,151.08,151.43,151.77,152.12,152.46,152.8,153.14,153.48,153.82,154.15,154.49,154.82,155.15,155.48,155.81,156.14,156.47,156.8,157.13,157.45,157.78,158.1,158.43,158.75,159.07,159.39,159.72,160.04,160.36,160.68,161.0,161.31,161.63,161.95,162.27,162.58,162.9,163.22,163.53,163.85,164.16,164.48,164.79,165.11,165.42,165.74,166.05,166.36,166.68,166.99,167.31,167.62,167.93,168.25,168.56,168.87,169.19,169.5,169.82,170.13,170.44,170.76,171.07,171.39,171.7,172.01,172.33,172.64,172.96,173.27,173.59,173.9,174.22,174.53,174.85,175.17,175.48,175.8,176.12,176.43,176.75,177.07,177.38,177.7,178.02,178.34,178.66,178.97,179.29,179.61,179.93,180.25,180.57,180.89,181.21,181.53,181.85,182.17,182.49,182.81,183.13,183.45,183.77,184.1,184.42,184.74,185.06,185.38,185.7,186.02,186.35,186.67,186.99,187.31,187.63,187.96,188.28,188.6,188.92,189.24,189.57,189.89,190.21,190.53,190.85,191.17,191.5,191.82,192.14,192.46,192.78,193.1,193.42,193.74,194.06,194.38,194.7,195.02,195.34,195.66,195.98,196.3,196.62,196.94,197.26,197.57,197.89,198.21,198.53,198.84,199.16,199.48,199.8,200.11,200.43,200.74,201.06,201.38,201.69,202.01,202.32,202.64,202.95,203.27,203.58,203.9,204.21,204.53,204.84,205.15,205.47,205.78,206.1,206.41,206.72,207.04,207.35,207.66,207.98,208.29,208.6,208.92,209.23,209.55,209.86,210.17,210.49,210.8,211.12,211.43,211.75,212.06,212.38,212.69,213.01,213.33,213.64,213.96,214.28,214.6,214.91,215.23,215.55,215.87,216.19,216.51,216.84,217.16,217.48,217.81,218.13,218.46,218.78,219.11,219.44,219.76,220.09,220.42,220.76,221.09,221.42,221.76,222.09,222.43,222.77,223.11,223.45,223.79,224.13,224.48,224.82,225.17,225.52,225.87,226.22,226.58,226.93,227.29,227.65,228.01,228.38,228.74,229.11,229.48,229.85,230.22,230.6,230.98,231.36,231.74,232.13,232.51,232.9,233.3,233.69,234.09,234.49,234.9,235.31,235.72,236.13,236.55,236.97,237.39,237.82,238.25,238.68,239.12,239.56,240.01,240.46,240.91,241.37,241.83,242.3,242.77,243.25,243.73,244.21,244.7,245.2,245.7,246.2,246.72,247.23,247.75,248.28,248.82,249.36,249.9,250.45,251.01,251.58,252.15,252.73,253.32,253.91,254.51,255.12,255.74,256.36,257.0,},
{117.34,118.0,118.65,119.28,119.91,120.54,121.15,121.75,122.35,122.94,123.53,124.1,124.67,125.23,125.79,126.34,126.88,127.42,127.95,128.47,128.99,129.51,130.01,130.52,131.01,131.51,131.99,132.48,132.95,133.43,133.9,134.36,134.82,135.28,135.73,136.17,136.62,137.06,137.49,137.93,138.35,138.78,139.2,139.62,140.03,140.45,140.85,141.26,141.66,142.06,142.46,142.85,143.24,143.63,144.02,144.4,144.78,145.16,145.54,145.91,146.28,146.65,147.02,147.39,147.75,148.11,148.47,148.83,149.19,149.54,149.89,150.24,150.59,150.94,151.29,151.63,151.97,152.32,152.66,153.0,153.33,153.67,154.01,154.34,154.67,155.01,155.34,155.67,156.0,156.32,156.65,156.98,157.3,157.63,157.95,158.27,158.6,158.92,159.24,159.56,159.88,160.2,160.52,160.83,161.15,161.47,161.78,162.1,162.42,162.73,163.05,163.36,163.67,163.99,164.3,164.62,164.93,165.24,165.56,165.87,166.18,166.49,166.81,167.12,167.43,167.74,168.05,168.37,168.68,168.99,169.3,169.61,169.93,170.24,170.55,170.86,171.17,171.49,171.8,172.11,172.43,172.74,173.05,173.36,173.68,173.99,174.3,174.62,174.93,175.25,175.56,175.88,176.19,176.51,176.82,177.14,177.45,177.77,178.08,178.4,178.72,179.03,179.35,179.67,179.98,180.3,180.62,180.94,181.25,181.57,181.89,182.21,182.53,182.85,183.16,183.48,183.8,184.12,184.44,184.76,185.08,185.4,185.72,186.04,186.36,186.68,187.0,187.32,187.64,187.96,188.28,188.6,188.92,189.24,189.56,189.88,190.2,190.52,190.83,191.15,191.47,191.79,192.11,192.43,192.75,193.07,193.39,193.71,194.02,194.34,194.66,194.98,195.3,195.61,195.93,196.25,196.56,196.88,197.2,197.51,197.83,198.15,198.46,198.78,199.09,199.41,199.72,200.04,200.35,200.67,200.98,201.3,201.61,201.92,202.24,202.55,202.86,203.18,203.49,203.8,204.11,204.43,204.74,205.05,205.36,205.68,205.99,206.3,206.61,206.92,207.24,207.55,207.86,208.17,208.48,208.8,209.11,209.42,209.73,210.04,210.36,210.67,210.98,211.3,211.61,211.92,212.24,212.55,212.87,213.18,213.5,213.81,214.13,214.44,214.76,215.08,215.4,215.72,216.03,216.35,216.67,216.99,217.32,217.64,217.96,218.29,218.61,218.93,219.26,219.59,219.92,220.24,220.57,220.91,221.24,221.57,221.9,222.24,222.58,222.91,223.25,223.59,223.94,224.28,224.62,224.97,225.32,225.67,226.02,226.37,226.72,227.08,227.44,227.8,228.16,228.52,228.89,229.25,229.62,230.0,230.37,230.75,231.12,231.51,231.89,232.28,232.66,233.05,233.45,233.85,234.25,234.65,235.05,235.46,235.87,236.29,236.71,237.13,237.55,237.98,238.41,238.85,239.29,239.73,240.18,240.63,241.08,241.54,242.01,242.48,242.95,243.43,243.91,244.4,244.89,245.39,245.89,246.4,246.91,247.43,247.95,248.48,249.02,249.56,250.11,250.67,251.23,251.8,252.37,252.96,253.55,254.14,254.75,255.36,255.98,256.61,},
{117.74,118.39,119.03,119.67,120.29,120.91,121.52,122.12,122.71,123.3,123.88,124.45,125.02,125.58,126.13,126.67,127.21,127.75,128.27,128.8,129.31,129.82,130.33,130.83,131.32,131.81,132.3,132.78,133.25,133.72,134.19,134.65,135.11,135.56,136.01,136.45,136.89,137.33,137.76,138.19,138.62,139.04,139.46,139.88,140.29,140.7,141.11,141.51,141.91,142.31,142.7,143.1,143.48,143.87,144.26,144.64,145.02,145.39,145.77,146.14,146.51,146.88,147.24,147.61,147.97,148.33,148.69,149.04,149.4,149.75,150.1,150.45,150.8,151.14,151.49,151.83,152.17,152.51,152.85,153.19,153.52,153.86,154.19,154.53,154.86,155.19,155.52,155.85,156.17,156.5,156.83,157.15,157.47,157.8,158.12,158.44,158.76,159.08,159.4,159.72,160.04,160.35,160.67,160.99,161.3,161.62,161.93,162.25,162.56,162.88,163.19,163.5,163.82,164.13,164.44,164.75,165.06,165.38,165.69,166.0,166.31,166.62,166.93,167.24,167.55,167.86,168.17,168.48,168.79,169.1,169.41,169.72,170.03,170.35,170.66,170.97,171.28,171.59,171.9,172.21,172.52,172.83,173.14,173.45,173.77,174.08,174.39,174.7,175.01,175.33,175.64,175.95,176.26,176.58,176.89,177.2,177.52,177.83,178.15,178.46,178.77,179.09,179.4,179.72,180.03,180.35,180.67,180.98,181.3,181.61,181.93,182.25,182.56,182.88,183.2,183.51,183.83,184.15,184.46,184.78,185.1,185.42,185.73,186.05,186.37,186.69,187.0,187.32,187.64,187.96,188.28,188.59,188.91,189.23,189.55,189.87,190.18,190.5,190.82,191.14,191.45,191.77,192.09,192.4,192.72,193.04,193.35,193.67,193.99,194.3,194.62,194.94,195.25,195.57,195.88,196.2,196.51,196.83,197.14,197.46,197.77,198.08,198.4,198.71,199.03,199.34,199.65,199.96,200.28,200.59,200.9,201.21,201.53,201.84,202.15,202.46,202.77,203.08,203.4,203.71,204.02,204.33,204.64,204.95,205.26,205.57,205.88,206.19,206.5,206.81,207.12,207.43,207.74,208.05,208.36,208.67,208.98,209.3,209.61,209.92,210.23,210.54,210.85,211.16,211.47,211.79,212.1,212.41,212.72,213.04,213.35,213.67,213.98,214.3,214.61,214.93,215.24,215.56,215.88,216.2,216.51,216.83,217.15,217.47,217.8,218.12,218.44,218.76,219.09,219.41,219.74,220.07,220.4,220.73,221.06,221.39,221.72,222.05,222.39,222.72,223.06,223.4,223.74,224.08,224.42,224.77,225.12,225.46,225.81,226.16,226.51,226.87,227.23,227.58,227.94,228.3,228.67,229.03,229.4,229.77,230.14,230.52,230.89,231.27,231.66,232.04,232.43,232.82,233.21,233.6,234.0,234.4,234.8,235.21,235.62,236.03,236.45,236.87,237.29,237.71,238.14,238.58,239.01,239.46,239.9,240.35,240.8,241.26,241.72,242.19,242.66,243.13,243.61,244.09,244.58,245.08,245.58,246.08,246.59,247.11,247.63,248.16,248.69,249.23,249.78,250.33,250.89,251.45,252.02,252.6,253.19,253.78,254.38,254.99,255.61,256.23,},
{118.13,118.78,119.42,120.05,120.67,121.28,121.88,122.48,123.07,123.65,124.23,124.8,125.36,125.91,126.46,127.01,127.54,128.07,128.6,129.11,129.63,130.13,130.64,131.13,131.63,132.11,132.59,133.07,133.54,134.01,134.47,134.93,135.39,135.84,136.28,136.73,137.17,137.6,138.03,138.46,138.88,139.3,139.72,140.13,140.54,140.95,141.36,141.76,142.16,142.55,142.94,143.33,143.72,144.11,144.49,144.87,145.25,145.62,145.99,146.36,146.73,147.1,147.46,147.82,148.18,148.54,148.9,149.25,149.61,149.96,150.31,150.65,151.0,151.34,151.69,152.03,152.37,152.71,153.04,153.38,153.71,154.05,154.38,154.71,155.04,155.37,155.7,156.02,156.35,156.67,157.0,157.32,157.64,157.96,158.29,158.61,158.92,159.24,159.56,159.88,160.19,160.51,160.83,161.14,161.46,161.77,162.08,162.4,162.71,163.02,163.33,163.64,163.96,164.27,164.58,164.89,165.2,165.51,165.82,166.13,166.44,166.75,167.05,167.36,167.67,167.98,168.29,168.6,168.91,169.22,169.52,169.83,170.14,170.45,170.76,171.07,171.38,171.69,172.0,172.31,172.61,172.92,173.23,173.54,173.85,174.16,174.47,174.78,175.09,175.4,175.72,176.03,176.34,176.65,176.96,177.27,177.58,177.9,178.21,178.52,178.83,179.15,179.46,179.77,180.08,180.4,180.71,181.03,181.34,181.65,181.97,182.28,182.6,182.91,183.23,183.54,183.86,184.17,184.49,184.8,185.12,185.43,185.75,186.06,186.38,186.7,187.01,187.33,187.64,187.96,188.28,188.59,188.91,189.22,189.54,189.85,190.17,190.49,190.8,191.12,191.43,191.75,192.06,192.38,192.69,193.01,193.32,193.64,193.95,194.27,194.58,194.89,195.21,195.52,195.83,196.15,196.46,196.77,197.09,197.4,197.71,198.02,198.34,198.65,198.96,199.27,199.58,199.89,200.2,200.51,200.82,201.14,201.45,201.76,202.07,202.38,202.69,202.99,203.3,203.61,203.92,204.23,204.54,204.85,205.16,205.47,205.78,206.08,206.39,206.7,207.01,207.32,207.63,207.94,208.25,208.55,208.86,209.17,209.48,209.79,210.1,210.41,210.72,211.03,211.34,211.65,211.96,212.27,212.58,212.9,213.21,213.52,213.83,214.15,214.46,214.78,215.09,215.41,215.72,216.04,216.36,216.67,216.99,217.31,217.63,217.95,218.27,218.59,218.92,219.24,219.57,219.89,220.22,220.55,220.88,221.21,221.54,221.87,222.2,222.54,222.87,223.21,223.55,223.89,224.23,224.57,224.92,225.26,225.61,225.96,226.31,226.66,227.02,227.37,227.73,228.09,228.45,228.82,229.18,229.55,229.92,230.29,230.67,231.04,231.42,231.81,232.19,232.58,232.97,233.36,233.76,234.15,234.56,234.96,235.37,235.78,236.19,236.61,237.03,237.45,237.88,238.31,238.75,239.18,239.63,240.07,240.52,240.98,241.44,241.9,242.37,242.84,243.32,243.8,244.28,244.77,245.27,245.77,246.28,246.79,247.31,247.84,248.37,248.9,249.44,249.99,250.55,251.11,251.68,252.25,252.83,253.42,254.02,254.62,255.24,255.86,},
{118.52,119.16,119.79,120.42,121.03,121.64,122.24,122.84,123.42,124.0,124.57,125.14,125.7,126.25,126.79,127.33,127.87,128.39,128.91,129.43,129.94,130.44,130.94,131.44,131.92,132.41,132.89,133.36,133.83,134.3,134.76,135.21,135.67,136.11,136.56,137.0,137.43,137.87,138.29,138.72,139.14,139.56,139.97,140.39,140.79,141.2,141.6,142.0,142.4,142.79,143.18,143.57,143.96,144.34,144.72,145.1,145.47,145.85,146.22,146.58,146.95,147.32,147.68,148.04,148.4,148.75,149.11,149.46,149.81,150.16,150.51,150.85,151.2,151.54,151.88,152.22,152.56,152.9,153.23,153.57,153.9,154.23,154.56,154.89,155.22,155.55,155.87,156.2,156.52,156.85,157.17,157.49,157.81,158.13,158.45,158.77,159.09,159.4,159.72,160.04,160.35,160.66,160.98,161.29,161.61,161.92,162.23,162.54,162.85,163.16,163.47,163.78,164.09,164.4,164.71,165.02,165.33,165.64,165.95,166.25,166.56,166.87,167.18,167.48,167.79,168.1,168.41,168.71,169.02,169.33,169.63,169.94,170.25,170.56,170.86,171.17,171.48,171.78,172.09,172.4,172.71,173.01,173.32,173.63,173.94,174.25,174.56,174.86,175.17,175.48,175.79,176.1,176.41,176.72,177.03,177.34,177.65,177.96,178.27,178.58,178.89,179.2,179.51,179.82,180.13,180.45,180.76,181.07,181.38,181.69,182.01,182.32,182.63,182.94,183.26,183.57,183.88,184.2,184.51,184.82,185.14,185.45,185.76,186.08,186.39,186.71,187.02,187.33,187.65,187.96,188.27,188.59,188.9,189.22,189.53,189.84,190.16,190.47,190.78,191.1,191.41,191.72,192.04,192.35,192.66,192.98,193.29,193.6,193.91,194.23,194.54,194.85,195.16,195.48,195.79,196.1,196.41,196.72,197.03,197.34,197.65,197.96,198.27,198.58,198.89,199.2,199.51,199.82,200.13,200.44,200.75,201.06,201.37,201.67,201.98,202.29,202.6,202.91,203.21,203.52,203.83,204.14,204.44,204.75,205.06,205.37,205.67,205.98,206.29,206.59,206.9,207.21,207.51,207.82,208.13,208.44,208.74,209.05,209.36,209.67,209.97,210.28,210.59,210.9,211.21,211.52,211.83,212.14,212.45,212.76,213.07,213.38,213.69,214.0,214.31,214.63,214.94,215.25,215.57,215.88,216.2,216.52,216.83,217.15,217.47,217.79,218.11,218.43,218.75,219.07,219.4,219.72,220.04,220.37,220.7,221.03,221.36,221.69,222.02,222.35,222.69,223.02,223.36,223.7,224.04,224.38,224.72,225.06,225.41,225.76,226.11,226.46,226.81,227.16,227.52,227.88,228.24,228.6,228.96,229.33,229.7,230.07,230.44,230.82,231.2,231.58,231.96,232.34,232.73,233.12,233.52,233.91,234.31,234.71,235.12,235.53,235.94,236.35,236.77,237.19,237.62,238.05,238.48,238.92,239.36,239.8,240.25,240.7,241.16,241.62,242.08,242.55,243.02,243.5,243.99,244.48,244.97,245.47,245.97,246.48,247.0,247.52,248.04,248.58,249.12,249.66,250.21,250.77,251.33,251.91,252.48,253.07,253.66,254.26,254.87,255.49,},
{118.9,119.53,120.16,120.78,121.4,122.0,122.6,123.19,123.77,124.34,124.91,125.47,126.03,126.58,127.12,127.65,128.18,128.71,129.23,129.74,130.25,130.75,131.24,131.73,132.22,132.7,133.18,133.65,134.12,134.58,135.04,135.49,135.94,136.39,136.83,137.26,137.7,138.13,138.55,138.98,139.4,139.81,140.23,140.64,141.04,141.45,141.85,142.24,142.64,143.03,143.42,143.8,144.19,144.57,144.95,145.32,145.7,146.07,146.44,146.8,147.17,147.53,147.89,148.25,148.61,148.96,149.31,149.66,150.01,150.36,150.71,151.05,151.39,151.73,152.07,152.41,152.75,153.08,153.42,153.75,154.08,154.41,154.74,155.07,155.4,155.72,156.05,156.37,156.69,157.02,157.34,157.66,157.98,158.3,158.61,158.93,159.25,159.56,159.88,160.19,160.5,160.82,161.13,161.44,161.75,162.06,162.37,162.68,162.99,163.3,163.61,163.92,164.23,164.54,164.84,165.15,165.46,165.77,166.07,166.38,166.68,166.99,167.3,167.6,167.91,168.21,168.52,168.83,169.13,169.44,169.74,170.05,170.35,170.66,170.96,171.27,171.58,171.88,172.19,172.49,172.8,173.1,173.41,173.72,174.02,174.33,174.64,174.94,175.25,175.56,175.87,176.17,176.48,176.79,177.1,177.4,177.71,178.02,178.33,178.64,178.95,179.26,179.56,179.87,180.18,180.49,180.8,181.11,181.42,181.73,182.04,182.36,182.67,182.98,183.29,183.6,183.91,184.22,184.53,184.84,185.16,185.47,185.78,186.09,186.4,186.71,187.03,187.34,187.65,187.96,188.27,188.59,188.9,189.21,189.52,189.83,190.14,190.46,190.77,191.08,191.39,191.7,192.01,192.33,192.64,192.95,193.26,193.57,193.88,194.19,194.5,194.81,195.12,195.43,195.74,196.05,196.36,196.67,196.98,197.29,197.59,197.9,198.21,198.52,198.83,199.14,199.44,199.75,200.06,200.37,200.67,200.98,201.29,201.59,201.9,202.21,202.51,202.82,203.12,203.43,203.74,204.04,204.35,204.65,204.96,205.26,205.57,205.88,206.18,206.49,206.79,207.1,207.4,207.71,208.01,208.32,208.63,208.93,209.24,209.54,209.85,210.16,210.46,210.77,211.08,211.39,211.69,212.0,212.31,212.62,212.93,213.24,213.55,213.86,214.17,214.48,214.79,215.1,215.42,215.73,216.05,216.36,216.68,216.99,217.31,217.63,217.94,218.26,218.58,218.9,219.23,219.55,219.87,220.2,220.52,220.85,221.18,221.51,221.84,222.17,222.5,222.84,223.17,223.51,223.85,224.19,224.53,224.87,225.21,225.56,225.91,226.26,226.61,226.96,227.31,227.67,228.03,228.39,228.75,229.12,229.48,229.85,230.22,230.6,230.97,231.35,231.73,232.11,232.5,232.89,233.28,233.67,234.07,234.47,234.88,235.28,235.69,236.1,236.52,236.94,237.36,237.79,238.22,238.65,239.09,239.53,239.98,240.43,240.88,241.34,241.8,242.27,242.74,243.21,243.69,244.18,244.67,245.17,245.67,246.18,246.69,247.2,247.73,248.26,248.79,249.33,249.88,250.44,251.0,251.57,252.14,252.72,253.31,253.91,254.51,255.13,},
{119.27,119.9,120.53,121.14,121.75,122.35,122.95,123.53,124.11,124.68,125.25,125.81,126.36,126.9,127.44,127.97,128.5,129.02,129.53,130.04,130.55,131.05,131.54,132.03,132.51,132.99,133.46,133.93,134.4,134.86,135.31,135.76,136.21,136.65,137.09,137.53,137.96,138.39,138.81,139.23,139.65,140.06,140.47,140.88,141.29,141.69,142.09,142.48,142.87,143.26,143.65,144.03,144.42,144.79,145.17,145.55,145.92,146.29,146.65,147.02,147.38,147.74,148.1,148.46,148.81,149.17,149.52,149.87,150.21,150.56,150.9,151.25,151.59,151.93,152.27,152.6,152.94,153.27,153.6,153.93,154.26,154.59,154.92,155.25,155.57,155.9,156.22,156.54,156.86,157.18,157.5,157.82,158.14,158.46,158.77,159.09,159.4,159.72,160.03,160.34,160.66,160.97,161.28,161.59,161.9,162.21,162.52,162.83,163.13,163.44,163.75,164.06,164.36,164.67,164.98,165.28,165.59,165.89,166.2,166.5,166.81,167.11,167.42,167.72,168.02,168.33,168.63,168.94,169.24,169.54,169.85,170.15,170.46,170.76,171.06,171.37,171.67,171.98,172.28,172.58,172.89,173.19,173.5,173.8,174.11,174.41,174.72,175.02,175.33,175.63,175.94,176.24,176.55,176.86,177.16,177.47,177.78,178.08,178.39,178.7,179.0,179.31,179.62,179.92,180.23,180.54,180.85,181.16,181.46,181.77,182.08,182.39,182.7,183.01,183.32,183.63,183.94,184.25,184.55,184.86,185.17,185.48,185.79,186.1,186.41,186.72,187.03,187.34,187.65,187.96,188.27,188.58,188.89,189.2,189.51,189.82,190.13,190.44,190.75,191.06,191.37,191.68,191.99,192.3,192.61,192.92,193.23,193.54,193.84,194.15,194.46,194.77,195.08,195.39,195.69,196.0,196.31,196.62,196.92,197.23,197.54,197.84,198.15,198.46,198.76,199.07,199.38,199.68,199.99,200.29,200.6,200.9,201.21,201.51,201.82,202.12,202.43,202.73,203.04,203.34,203.64,203.95,204.25,204.56,204.86,205.16,205.47,205.77,206.08,206.38,206.68,206.99,207.29,207.6,207.9,208.2,208.51,208.81,209.12,209.42,209.73,210.03,210.34,210.64,210.95,211.26,211.56,211.87,212.18,212.48,212.79,213.1,213.41,213.72,214.03,214.34,214.65,214.96,215.27,215.58,215.89,216.21,216.52,216.83,217.15,217.47,217.78,218.1,218.42,218.74,219.06,219.38,219.7,220.03,220.35,220.68,221.0,221.33,221.66,221.99,222.32,222.65,222.99,223.32,223.66,224.0,224.33,224.68,225.02,225.36,225.71,226.06,226.41,226.76,227.11,227.46,227.82,228.18,228.54,228.9,229.27,229.63,230.0,230.38,230.75,231.13,231.51,231.89,232.27,232.66,233.05,233.44,233.84,234.23,234.63,235.04,235.45,235.86,236.27,236.69,237.11,237.53,237.96,238.39,238.83,239.27,239.71,240.16,240.61,241.06,241.52,241.99,242.46,242.93,243.41,243.89,244.38,244.87,245.37,245.87,246.38,246.9,247.42,247.94,248.48,249.01,249.56,250.11,250.67,251.23,251.8,252.38,252.97,253.56,254.16,254.77,},
{119.64,120.26,120.89,121.5,122.1,122.7,123.29,123.87,124.45,125.02,125.58,126.13,126.68,127.22,127.76,128.29,128.81,129.33,129.84,130.34,130.85,131.34,131.83,132.32,132.8,133.27,133.74,134.21,134.67,135.13,135.58,136.03,136.48,136.92,137.35,137.79,138.22,138.64,139.06,139.48,139.9,140.31,140.72,141.12,141.53,141.93,142.32,142.72,143.11,143.49,143.88,144.26,144.64,145.02,145.39,145.76,146.13,146.5,146.87,147.23,147.59,147.95,148.31,148.66,149.02,149.37,149.72,150.07,150.41,150.76,151.1,151.44,151.78,152.12,152.45,152.79,153.12,153.45,153.79,154.12,154.44,154.77,155.1,155.42,155.75,156.07,156.39,156.71,157.03,157.35,157.67,157.99,158.3,158.62,158.93,159.25,159.56,159.87,160.18,160.5,160.81,161.12,161.43,161.73,162.04,162.35,162.66,162.97,163.27,163.58,163.88,164.19,164.49,164.8,165.1,165.41,165.71,166.02,166.32,166.62,166.93,167.23,167.53,167.84,168.14,168.44,168.74,169.05,169.35,169.65,169.95,170.26,170.56,170.86,171.16,171.47,171.77,172.07,172.37,172.68,172.98,173.28,173.58,173.89,174.19,174.49,174.8,175.1,175.4,175.71,176.01,176.32,176.62,176.92,177.23,177.53,177.84,178.14,178.45,178.75,179.06,179.36,179.67,179.97,180.28,180.59,180.89,181.2,181.51,181.81,182.12,182.43,182.73,183.04,183.35,183.65,183.96,184.27,184.58,184.88,185.19,185.5,185.81,186.12,186.42,186.73,187.04,187.35,187.66,187.96,188.27,188.58,188.89,189.2,189.5,189.81,190.12,190.43,190.74,191.04,191.35,191.66,191.97,192.27,192.58,192.89,193.2,193.5,193.81,194.12,194.42,194.73,195.04,195.34,195.65,195.95,196.26,196.57,196.87,197.18,197.48,197.79,198.09,198.4,198.7,199.0,199.31,199.61,199.92,200.22,200.52,200.83,201.13,201.43,201.74,202.04,202.34,202.65,202.95,203.25,203.55,203.86,204.16,204.46,204.76,205.07,205.37,205.67,205.97,206.28,206.58,206.88,207.18,207.49,207.79,208.09,208.39,208.7,209.0,209.3,209.61,209.91,210.21,210.52,210.82,211.13,211.43,211.74,212.04,212.35,212.65,212.96,213.27,213.58,213.88,214.19,214.5,214.81,215.12,215.43,215.74,216.05,216.37,216.68,216.99,217.31,217.62,217.94,218.26,218.58,218.89,219.21,219.53,219.86,220.18,220.5,220.83,221.15,221.48,221.81,222.14,222.47,222.8,223.14,223.47,223.81,224.15,224.49,224.83,225.17,225.51,225.86,226.21,226.56,226.91,227.26,227.62,227.97,228.33,228.69,229.06,229.42,229.79,230.16,230.53,230.91,231.28,231.66,232.04,232.43,232.82,233.21,233.6,234.0,234.4,234.8,235.2,235.61,236.02,236.44,236.86,237.28,237.7,238.13,238.57,239.0,239.44,239.89,240.34,240.79,241.25,241.71,242.18,242.65,243.12,243.6,244.09,244.58,245.07,245.57,246.08,246.59,247.11,247.63,248.16,248.7,249.24,249.79,250.34,250.9,251.47,252.04,252.63,253.22,253.81,254.42,},
{120.0,120.62,121.24,121.85,122.45,123.04,123.63,124.21,124.78,125.34,125.9,126.45,127.0,127.54,128.07,128.59,129.11,129.63,130.14,130.64,131.14,131.63,132.12,132.6,133.08,133.55,134.02,134.49,134.94,135.4,135.85,136.3,136.74,137.18,137.61,138.04,138.47,138.89,139.31,139.73,140.14,140.55,140.96,141.36,141.76,142.16,142.56,142.95,143.34,143.72,144.1,144.48,144.86,145.24,145.61,145.98,146.35,146.72,147.08,147.44,147.8,148.16,148.51,148.87,149.22,149.57,149.92,150.26,150.61,150.95,151.29,151.63,151.97,152.3,152.64,152.97,153.31,153.64,153.97,154.29,154.62,154.95,155.27,155.59,155.92,156.24,156.56,156.88,157.2,157.51,157.83,158.15,158.46,158.78,159.09,159.4,159.71,160.02,160.33,160.64,160.95,161.26,161.57,161.88,162.19,162.49,162.8,163.1,163.41,163.71,164.02,164.32,164.63,164.93,165.23,165.54,165.84,166.14,166.44,166.74,167.05,167.35,167.65,167.95,168.25,168.55,168.85,169.16,169.46,169.76,170.06,170.36,170.66,170.96,171.26,171.56,171.86,172.16,172.46,172.77,173.07,173.37,173.67,173.97,174.27,174.57,174.88,175.18,175.48,175.78,176.08,176.39,176.69,176.99,177.29,177.6,177.9,178.2,178.51,178.81,179.11,179.42,179.72,180.02,180.33,180.63,180.94,181.24,181.55,181.85,182.16,182.46,182.77,183.07,183.38,183.68,183.99,184.29,184.6,184.9,185.21,185.52,185.82,186.13,186.43,186.74,187.05,187.35,187.66,187.97,188.27,188.58,188.88,189.19,189.5,189.8,190.11,190.41,190.72,191.03,191.33,191.64,191.94,192.25,192.55,192.86,193.17,193.47,193.78,194.08,194.39,194.69,194.99,195.3,195.6,195.91,196.21,196.51,196.82,197.12,197.43,197.73,198.03,198.33,198.64,198.94,199.24,199.55,199.85,200.15,200.45,200.75,201.06,201.36,201.66,201.96,202.26,202.56,202.86,203.16,203.47,203.77,204.07,204.37,204.67,204.97,205.27,205.57,205.87,206.17,206.47,206.77,207.08,207.38,207.68,207.98,208.28,208.58,208.88,209.18,209.49,209.79,210.09,210.39,210.7,211.0,211.3,211.61,211.91,212.22,212.52,212.83,213.13,213.44,213.74,214.05,214.36,214.67,214.98,215.28,215.59,215.9,216.22,216.53,216.84,217.15,217.47,217.78,218.1,218.41,218.73,219.05,219.37,219.69,220.01,220.33,220.66,220.98,221.31,221.63,221.96,222.29,222.62,222.95,223.29,223.62,223.96,224.3,224.64,224.98,225.32,225.66,226.01,226.36,226.71,227.06,227.41,227.77,228.13,228.49,228.85,229.21,229.58,229.94,230.32,230.69,231.06,231.44,231.82,232.2,232.59,232.98,233.37,233.76,234.16,234.56,234.97,235.37,235.78,236.19,236.61,237.03,237.45,237.88,238.31,238.75,239.18,239.63,240.07,240.52,240.98,241.44,241.9,242.37,242.84,243.32,243.8,244.29,244.78,245.28,245.78,246.29,246.81,247.33,247.85,248.39,248.92,249.47,250.02,250.58,251.14,251.71,252.29,252.88,253.47,254.07,},
{120.35,120.97,121.59,122.19,122.79,123.38,123.96,124.54,125.11,125.67,126.22,126.77,127.31,127.85,128.37,128.9,129.42,129.93,130.43,130.93,131.43,131.92,132.4,132.88,133.36,133.83,134.3,134.76,135.21,135.67,136.11,136.56,137.0,137.44,137.87,138.3,138.72,139.14,139.56,139.97,140.39,140.79,141.2,141.6,142.0,142.39,142.79,143.17,143.56,143.95,144.33,144.71,145.08,145.46,145.83,146.2,146.56,146.93,147.29,147.65,148.01,148.36,148.72,149.07,149.42,149.77,150.11,150.46,150.8,151.14,151.48,151.82,152.15,152.49,152.82,153.15,153.49,153.81,154.14,154.47,154.8,155.12,155.44,155.76,156.09,156.41,156.72,157.04,157.36,157.68,157.99,158.31,158.62,158.93,159.24,159.55,159.86,160.17,160.48,160.79,161.1,161.41,161.71,162.02,162.33,162.63,162.94,163.24,163.54,163.85,164.15,164.45,164.75,165.06,165.36,165.66,165.96,166.26,166.56,166.86,167.16,167.46,167.76,168.06,168.36,168.66,168.96,169.26,169.56,169.86,170.16,170.46,170.76,171.06,171.36,171.66,171.96,172.26,172.55,172.85,173.15,173.45,173.75,174.05,174.35,174.65,174.95,175.25,175.55,175.85,176.15,176.45,176.75,177.06,177.36,177.66,177.96,178.26,178.56,178.86,179.17,179.47,179.77,180.07,180.37,180.68,180.98,181.28,181.59,181.89,182.19,182.49,182.8,183.1,183.4,183.71,184.01,184.32,184.62,184.92,185.23,185.53,185.84,186.14,186.44,186.75,187.05,187.36,187.66,187.97,188.27,188.58,188.88,189.18,189.49,189.79,190.1,190.4,190.7,191.01,191.31,191.62,191.92,192.22,192.53,192.83,193.14,193.44,193.74,194.04,194.35,194.65,194.95,195.26,195.56,195.86,196.16,196.47,196.77,197.07,197.37,197.67,197.97,198.27,198.58,198.88,199.18,199.48,199.78,200.08,200.38,200.68,200.98,201.28,201.58,201.88,202.18,202.48,202.78,203.08,203.38,203.68,203.98,204.28,204.57,204.87,205.17,205.47,205.77,206.07,206.37,206.67,206.97,207.27,207.57,207.87,208.17,208.47,208.77,209.07,209.37,209.67,209.97,210.27,210.57,210.87,211.18,211.48,211.78,212.08,212.39,212.69,213.0,213.3,213.61,213.91,214.22,214.52,214.83,215.14,215.45,215.76,216.07,216.38,216.69,217.0,217.31,217.63,217.94,218.25,218.57,218.89,219.21,219.52,219.84,220.17,220.49,220.81,221.13,221.46,221.79,222.11,222.44,222.77,223.11,223.44,223.78,224.11,224.45,224.79,225.13,225.47,225.82,226.16,226.51,226.86,227.21,227.57,227.92,228.28,228.64,229.0,229.37,229.73,230.1,230.47,230.85,231.22,231.6,231.98,232.37,232.75,233.14,233.53,233.93,234.33,234.73,235.13,235.54,235.95,236.37,236.78,237.21,237.63,238.06,238.49,238.93,239.37,239.81,240.26,240.71,241.17,241.63,242.1,242.57,243.04,243.52,244.01,244.5,244.99,245.49,246.0,246.51,247.03,247.55,248.08,248.61,249.15,249.7,250.26,250.82,251.39,251.96,252.54,253.13,253.73,},
{120.7,121.32,121.93,122.53,123.13,123.71,124.29,124.86,125.43,125.99,126.54,127.08,127.62,128.15,128.68,129.2,129.71,130.22,130.72,131.22,131.71,132.2,132.68,133.16,133.63,134.1,134.57,135.02,135.48,135.93,136.38,136.82,137.26,137.69,138.12,138.55,138.97,139.39,139.8,140.22,140.62,141.03,141.43,141.83,142.23,142.62,143.01,143.4,143.79,144.17,144.55,144.92,145.3,145.67,146.04,146.41,146.77,147.13,147.49,147.85,148.21,148.56,148.92,149.27,149.61,149.96,150.31,150.65,150.99,151.33,151.67,152.0,152.34,152.67,153.0,153.33,153.66,153.99,154.32,154.64,154.97,155.29,155.61,155.93,156.25,156.57,156.89,157.21,157.52,157.84,158.15,158.46,158.77,159.09,159.4,159.71,160.01,160.32,160.63,160.94,161.24,161.55,161.86,162.16,162.46,162.77,163.07,163.37,163.68,163.98,164.28,164.58,164.88,165.18,165.48,165.78,166.08,166.38,166.68,166.98,167.28,167.58,167.88,168.18,168.47,168.77,169.07,169.37,169.67,169.96,170.26,170.56,170.86,171.15,171.45,171.75,172.05,172.35,172.64,172.94,173.24,173.54,173.84,174.13,174.43,174.73,175.03,175.33,175.63,175.92,176.22,176.52,176.82,177.12,177.42,177.72,178.02,178.32,178.62,178.92,179.22,179.52,179.82,180.12,180.42,180.72,181.02,181.32,181.62,181.93,182.23,182.53,182.83,183.13,183.43,183.74,184.04,184.34,184.64,184.94,185.25,185.55,185.85,186.15,186.46,186.76,187.06,187.36,187.67,187.97,188.27,188.57,188.88,189.18,189.48,189.78,190.09,190.39,190.69,190.99,191.29,191.6,191.9,192.2,192.5,192.8,193.11,193.41,193.71,194.01,194.31,194.61,194.91,195.21,195.51,195.82,196.12,196.42,196.72,197.02,197.32,197.62,197.92,198.22,198.52,198.81,199.11,199.41,199.71,200.01,200.31,200.61,200.91,201.2,201.5,201.8,202.1,202.4,202.7,202.99,203.29,203.59,203.89,204.18,204.48,204.78,205.08,205.37,205.67,205.97,206.27,206.57,206.86,207.16,207.46,207.76,208.06,208.36,208.65,208.95,209.25,209.55,209.85,210.15,210.45,210.75,211.05,211.35,211.65,211.96,212.26,212.56,212.86,213.17,213.47,213.77,214.08,214.38,214.69,215.0,215.3,215.61,215.92,216.23,216.54,216.85,217.16,217.47,217.78,218.1,218.41,218.73,219.04,219.36,219.68,220.0,220.32,220.64,220.96,221.29,221.61,221.94,222.27,222.6,222.93,223.26,223.59,223.93,224.26,224.6,224.94,225.28,225.63,225.97,226.32,226.67,227.02,227.37,227.72,228.08,228.44,228.8,229.16,229.52,229.89,230.26,230.63,231.01,231.38,231.76,232.15,232.53,232.92,233.31,233.7,234.1,234.5,234.9,235.31,235.71,236.13,236.54,236.96,237.38,237.81,238.24,238.67,239.11,239.55,240.0,240.45,240.9,241.36,241.83,242.29,242.77,243.24,243.73,244.21,244.71,245.2,245.71,246.22,246.73,247.25,247.78,248.31,248.85,249.39,249.94,250.5,251.06,251.63,252.21,252.8,253.39,},
{121.05,121.66,122.27,122.87,123.46,124.04,124.61,125.18,125.74,126.3,126.85,127.39,127.92,128.45,128.98,129.49,130.0,130.51,131.01,131.51,132.0,132.48,132.96,133.44,133.91,134.37,134.83,135.29,135.74,136.19,136.63,137.07,137.51,137.94,138.37,138.79,139.21,139.63,140.04,140.45,140.86,141.26,141.66,142.06,142.46,142.85,143.24,143.62,144.01,144.39,144.76,145.14,145.51,145.88,146.25,146.62,146.98,147.34,147.7,148.05,148.41,148.76,149.11,149.46,149.81,150.15,150.5,150.84,151.18,151.52,151.85,152.19,152.52,152.85,153.18,153.51,153.84,154.17,154.49,154.82,155.14,155.46,155.78,156.1,156.42,156.73,157.05,157.37,157.68,157.99,158.31,158.62,158.93,159.24,159.55,159.86,160.16,160.47,160.78,161.08,161.39,161.69,162.0,162.3,162.6,162.9,163.21,163.51,163.81,164.11,164.41,164.71,165.01,165.31,165.61,165.91,166.2,166.5,166.8,167.1,167.39,167.69,167.99,168.29,168.58,168.88,169.18,169.47,169.77,170.07,170.36,170.66,170.95,171.25,171.55,171.84,172.14,172.44,172.73,173.03,173.32,173.62,173.92,174.21,174.51,174.81,175.1,175.4,175.7,176.0,176.29,176.59,176.89,177.18,177.48,177.78,178.08,178.38,178.67,178.97,179.27,179.57,179.87,180.17,180.47,180.77,181.06,181.36,181.66,181.96,182.26,182.56,182.86,183.16,183.46,183.76,184.06,184.36,184.66,184.96,185.26,185.56,185.86,186.16,186.47,186.77,187.07,187.37,187.67,187.97,188.27,188.57,188.87,189.17,189.47,189.77,190.07,190.37,190.67,190.98,191.28,191.58,191.88,192.18,192.48,192.78,193.08,193.38,193.68,193.98,194.27,194.57,194.87,195.17,195.47,195.77,196.07,196.37,196.67,196.96,197.26,197.56,197.86,198.16,198.45,198.75,199.05,199.35,199.64,199.94,200.24,200.54,200.83,201.13,201.43,201.72,202.02,202.32,202.61,202.91,203.21,203.5,203.8,204.09,204.39,204.69,204.98,205.28,205.57,205.87,206.17,206.46,206.76,207.06,207.35,207.65,207.95,208.24,208.54,208.84,209.14,209.43,209.73,210.03,210.33,210.63,210.93,211.23,211.53,211.83,212.13,212.43,212.73,213.03,213.33,213.64,213.94,214.24,214.55,214.85,215.16,215.47,215.77,216.08,216.39,216.7,217.01,217.32,217.63,217.94,218.26,218.57,218.88,219.2,219.52,219.84,220.15,220.48,220.8,221.12,221.44,221.77,222.09,222.42,222.75,223.08,223.41,223.75,224.08,224.42,224.76,225.1,225.44,225.78,226.13,226.47,226.82,227.17,227.52,227.88,228.24,228.59,228.96,229.32,229.68,230.05,230.42,230.79,231.17,231.55,231.93,232.31,232.7,233.08,233.48,233.87,234.27,234.67,235.07,235.48,235.89,236.3,236.72,237.14,237.56,237.99,238.42,238.86,239.3,239.74,240.19,240.64,241.1,241.56,242.03,242.5,242.97,243.45,243.93,244.42,244.92,245.42,245.93,246.44,246.95,247.48,248.01,248.54,249.08,249.63,250.18,250.75,251.31,251.89,252.47,253.06,},
{121.39,122.0,122.6,123.2,123.78,124.36,124.93,125.5,126.06,126.61,127.15,127.69,128.22,128.75,129.27,129.78,130.29,130.8,131.29,131.79,132.27,132.76,133.23,133.71,134.17,134.64,135.09,135.55,136.0,136.44,136.89,137.32,137.76,138.19,138.61,139.03,139.45,139.87,140.28,140.69,141.09,141.5,141.89,142.29,142.68,143.07,143.46,143.84,144.22,144.6,144.98,145.35,145.72,146.09,146.46,146.82,147.18,147.54,147.9,148.25,148.61,148.96,149.31,149.65,150.0,150.34,150.68,151.02,151.36,151.7,152.03,152.37,152.7,153.03,153.36,153.69,154.01,154.34,154.66,154.98,155.31,155.63,155.95,156.26,156.58,156.9,157.21,157.52,157.84,158.15,158.46,158.77,159.08,159.39,159.7,160.0,160.31,160.61,160.92,161.22,161.53,161.83,162.13,162.44,162.74,163.04,163.34,163.64,163.94,164.24,164.54,164.83,165.13,165.43,165.73,166.03,166.32,166.62,166.92,167.21,167.51,167.8,168.1,168.39,168.69,168.99,169.28,169.58,169.87,170.17,170.46,170.76,171.05,171.34,171.64,171.93,172.23,172.52,172.82,173.11,173.41,173.7,174.0,174.29,174.59,174.88,175.18,175.47,175.77,176.06,176.36,176.66,176.95,177.25,177.54,177.84,178.14,178.43,178.73,179.03,179.32,179.62,179.92,180.21,180.51,180.81,181.11,181.4,181.7,182.0,182.3,182.59,182.89,183.19,183.49,183.79,184.09,184.38,184.68,184.98,185.28,185.58,185.88,186.18,186.48,186.77,187.07,187.37,187.67,187.97,188.27,188.57,188.87,189.17,189.46,189.76,190.06,190.36,190.66,190.96,191.26,191.56,191.85,192.15,192.45,192.75,193.05,193.35,193.64,193.94,194.24,194.54,194.83,195.13,195.43,195.73,196.02,196.32,196.62,196.91,197.21,197.51,197.8,198.1,198.4,198.69,198.99,199.28,199.58,199.87,200.17,200.47,200.76,201.06,201.35,201.65,201.94,202.24,202.53,202.83,203.12,203.42,203.71,204.0,204.3,204.59,204.89,205.18,205.48,205.77,206.07,206.36,206.66,206.95,207.25,207.54,207.84,208.13,208.43,208.73,209.02,209.32,209.62,209.91,210.21,210.51,210.81,211.1,211.4,211.7,212.0,212.3,212.6,212.9,213.2,213.5,213.8,214.11,214.41,214.71,215.02,215.32,215.63,215.94,216.24,216.55,216.86,217.17,217.48,217.79,218.1,218.41,218.73,219.04,219.36,219.67,219.99,220.31,220.63,220.95,221.27,221.6,221.92,222.25,222.58,222.91,223.24,223.57,223.9,224.24,224.57,224.91,225.25,225.59,225.94,226.28,226.63,226.98,227.33,227.68,228.04,228.39,228.75,229.11,229.48,229.84,230.21,230.58,230.96,231.33,231.71,232.09,232.48,232.86,233.25,233.65,234.04,234.44,234.84,235.25,235.66,236.07,236.48,236.9,237.32,237.75,238.18,238.61,239.05,239.49,239.94,240.39,240.84,241.3,241.76,242.23,242.7,243.18,243.66,244.15,244.64,245.14,245.64,246.15,246.66,247.18,247.71,248.24,248.78,249.32,249.87,250.43,251.0,251.57,252.15,252.73,},
{121.73,122.33,122.93,123.52,124.1,124.68,125.25,125.81,126.37,126.91,127.46,127.99,128.52,129.04,129.56,130.07,130.58,131.08,131.57,132.06,132.55,133.03,133.5,133.97,134.44,134.9,135.35,135.81,136.25,136.7,137.14,137.57,138.0,138.43,138.85,139.27,139.69,140.1,140.51,140.92,141.32,141.72,142.12,142.51,142.9,143.29,143.68,144.06,144.44,144.82,145.19,145.56,145.93,146.3,146.66,147.02,147.38,147.74,148.1,148.45,148.8,149.15,149.5,149.84,150.19,150.53,150.87,151.21,151.55,151.88,152.21,152.55,152.88,153.21,153.53,153.86,154.19,154.51,154.83,155.15,155.47,155.79,156.11,156.43,156.74,157.05,157.37,157.68,157.99,158.3,158.61,158.92,159.23,159.54,159.84,160.15,160.45,160.76,161.06,161.36,161.67,161.97,162.27,162.57,162.87,163.17,163.47,163.77,164.07,164.36,164.66,164.96,165.26,165.55,165.85,166.14,166.44,166.73,167.03,167.32,167.62,167.91,168.21,168.5,168.8,169.09,169.38,169.68,169.97,170.26,170.56,170.85,171.14,171.44,171.73,172.02,172.32,172.61,172.9,173.2,173.49,173.78,174.08,174.37,174.66,174.96,175.25,175.55,175.84,176.13,176.43,176.72,177.02,177.31,177.6,177.9,178.19,178.49,178.78,179.08,179.37,179.67,179.96,180.26,180.56,180.85,181.15,181.44,181.74,182.03,182.33,182.63,182.92,183.22,183.52,183.81,184.11,184.41,184.7,185.0,185.3,185.59,185.89,186.19,186.49,186.78,187.08,187.38,187.67,187.97,188.27,188.57,188.86,189.16,189.46,189.75,190.05,190.35,190.64,190.94,191.24,191.54,191.83,192.13,192.43,192.72,193.02,193.31,193.61,193.91,194.2,194.5,194.8,195.09,195.39,195.68,195.98,196.27,196.57,196.86,197.16,197.45,197.75,198.04,198.34,198.63,198.93,199.22,199.51,199.81,200.1,200.4,200.69,200.98,201.28,201.57,201.86,202.16,202.45,202.74,203.04,203.33,203.62,203.92,204.21,204.5,204.8,205.09,205.38,205.68,205.97,206.26,206.56,206.85,207.14,207.44,207.73,208.03,208.32,208.62,208.91,209.21,209.5,209.8,210.09,210.39,210.68,210.98,211.28,211.58,211.87,212.17,212.47,212.77,213.07,213.37,213.67,213.97,214.27,214.58,214.88,215.18,215.49,215.79,216.1,216.4,216.71,217.02,217.33,217.64,217.95,218.26,218.57,218.88,219.2,219.51,219.83,220.15,220.47,220.79,221.11,221.43,221.75,222.08,222.4,222.73,223.06,223.39,223.72,224.06,224.39,224.73,225.07,225.41,225.75,226.09,226.44,226.79,227.14,227.49,227.84,228.2,228.55,228.91,229.28,229.64,230.01,230.38,230.75,231.12,231.5,231.88,232.26,232.65,233.03,233.42,233.82,234.21,234.61,235.02,235.42,235.83,236.25,236.66,237.08,237.51,237.93,238.37,238.8,239.24,239.68,240.13,240.58,241.04,241.5,241.96,242.43,242.91,243.39,243.87,244.36,244.86,245.36,245.86,246.38,246.89,247.42,247.94,248.48,249.02,249.57,250.12,250.69,251.25,251.83,252.41,},
{122.06,122.66,123.25,123.84,124.42,124.99,125.56,126.12,126.67,127.21,127.75,128.29,128.81,129.33,129.85,130.35,130.86,131.36,131.85,132.34,132.82,133.29,133.77,134.23,134.7,135.16,135.61,136.06,136.5,136.95,137.38,137.82,138.25,138.67,139.09,139.51,139.92,140.34,140.74,141.15,141.55,141.95,142.34,142.73,143.12,143.51,143.89,144.27,144.65,145.03,145.4,145.77,146.14,146.5,146.86,147.22,147.58,147.94,148.29,148.65,149.0,149.34,149.69,150.03,150.38,150.72,151.05,151.39,151.73,152.06,152.39,152.72,153.05,153.38,153.71,154.03,154.35,154.68,155.0,155.32,155.64,155.95,156.27,156.59,156.9,157.21,157.52,157.84,158.15,158.45,158.76,159.07,159.38,159.68,159.99,160.29,160.6,160.9,161.2,161.5,161.8,162.1,162.4,162.7,163.0,163.3,163.6,163.9,164.19,164.49,164.79,165.08,165.38,165.67,165.97,166.26,166.56,166.85,167.14,167.44,167.73,168.02,168.32,168.61,168.9,169.19,169.49,169.78,170.07,170.36,170.65,170.95,171.24,171.53,171.82,172.11,172.41,172.7,172.99,173.28,173.57,173.86,174.16,174.45,174.74,175.03,175.32,175.62,175.91,176.2,176.49,176.79,177.08,177.37,177.66,177.96,178.25,178.54,178.84,179.13,179.42,179.72,180.01,180.31,180.6,180.89,181.19,181.48,181.78,182.07,182.36,182.66,182.95,183.25,183.54,183.84,184.13,184.43,184.72,185.02,185.31,185.61,185.9,186.2,186.49,186.79,187.09,187.38,187.68,187.97,188.27,188.56,188.86,189.15,189.45,189.74,190.04,190.34,190.63,190.93,191.22,191.52,191.81,192.11,192.4,192.7,192.99,193.29,193.58,193.87,194.17,194.46,194.76,195.05,195.34,195.64,195.93,196.23,196.52,196.81,197.11,197.4,197.69,197.99,198.28,198.57,198.86,199.16,199.45,199.74,200.03,200.33,200.62,200.91,201.2,201.5,201.79,202.08,202.37,202.66,202.95,203.25,203.54,203.83,204.12,204.41,204.71,205.0,205.29,205.58,205.87,206.16,206.46,206.75,207.04,207.33,207.63,207.92,208.21,208.51,208.8,209.09,209.39,209.68,209.98,210.27,210.57,210.86,211.16,211.45,211.75,212.05,212.34,212.64,212.94,213.24,213.54,213.84,214.14,214.44,214.74,215.04,215.35,215.65,215.95,216.26,216.57,216.87,217.18,217.49,217.8,218.11,218.42,218.73,219.04,219.36,219.67,219.99,220.31,220.62,220.94,221.26,221.59,221.91,222.23,222.56,222.89,223.22,223.55,223.88,224.21,224.55,224.89,225.23,225.57,225.91,226.25,226.6,226.95,227.3,227.65,228.0,228.36,228.72,229.08,229.44,229.8,230.17,230.54,230.91,231.29,231.67,232.05,232.43,232.82,233.21,233.6,233.99,234.39,234.79,235.2,235.6,236.01,236.43,236.85,237.27,237.69,238.12,238.56,238.99,239.44,239.88,240.33,240.78,241.24,241.7,242.17,242.64,243.12,243.6,244.09,244.58,245.08,245.58,246.09,246.61,247.13,247.65,248.19,248.72,249.27,249.82,250.38,250.94,251.52,252.09,},
{122.38,122.98,123.57,124.16,124.73,125.3,125.86,126.42,126.97,127.51,128.05,128.58,129.1,129.62,130.13,130.63,131.13,131.63,132.12,132.6,133.08,133.56,134.03,134.49,134.95,135.41,135.86,136.31,136.75,137.19,137.63,138.06,138.48,138.91,139.33,139.74,140.16,140.57,140.97,141.37,141.77,142.17,142.56,142.95,143.34,143.72,144.11,144.48,144.86,145.23,145.6,145.97,146.34,146.7,147.06,147.42,147.78,148.13,148.49,148.84,149.19,149.53,149.88,150.22,150.56,150.9,151.24,151.57,151.91,152.24,152.57,152.9,153.23,153.55,153.88,154.2,154.52,154.84,155.16,155.48,155.8,156.11,156.43,156.74,157.06,157.37,157.68,157.99,158.3,158.6,158.91,159.22,159.52,159.83,160.13,160.43,160.74,161.04,161.34,161.64,161.94,162.24,162.54,162.84,163.13,163.43,163.73,164.02,164.32,164.61,164.91,165.2,165.5,165.79,166.08,166.38,166.67,166.96,167.25,167.55,167.84,168.13,168.42,168.71,169.0,169.3,169.59,169.88,170.17,170.46,170.75,171.04,171.33,171.62,171.91,172.2,172.49,172.78,173.07,173.36,173.65,173.94,174.23,174.52,174.82,175.11,175.4,175.69,175.98,176.27,176.56,176.85,177.14,177.43,177.72,178.02,178.31,178.6,178.89,179.18,179.47,179.77,180.06,180.35,180.64,180.93,181.23,181.52,181.81,182.1,182.4,182.69,182.98,183.28,183.57,183.86,184.16,184.45,184.74,185.04,185.33,185.62,185.92,186.21,186.5,186.8,187.09,187.39,187.68,187.97,188.27,188.56,188.85,189.15,189.44,189.74,190.03,190.32,190.62,190.91,191.2,191.5,191.79,192.08,192.38,192.67,192.96,193.26,193.55,193.84,194.13,194.43,194.72,195.01,195.3,195.6,195.89,196.18,196.47,196.76,197.06,197.35,197.64,197.93,198.22,198.51,198.8,199.1,199.39,199.68,199.97,200.26,200.55,200.84,201.13,201.42,201.71,202.0,202.29,202.58,202.87,203.16,203.45,203.74,204.03,204.32,204.61,204.91,205.2,205.49,205.78,206.07,206.36,206.65,206.94,207.23,207.52,207.81,208.11,208.4,208.69,208.98,209.28,209.57,209.86,210.15,210.45,210.74,211.04,211.33,211.63,211.92,212.22,212.51,212.81,213.11,213.41,213.71,214.01,214.3,214.61,214.91,215.21,215.51,215.81,216.12,216.42,216.73,217.03,217.34,217.65,217.96,218.27,218.58,218.89,219.2,219.51,219.83,220.15,220.46,220.78,221.1,221.42,221.74,222.07,222.39,222.72,223.05,223.38,223.71,224.04,224.37,224.71,225.04,225.38,225.72,226.07,226.41,226.76,227.11,227.46,227.81,228.16,228.52,228.88,229.24,229.6,229.97,230.34,230.71,231.08,231.46,231.84,232.22,232.6,232.99,233.38,233.77,234.17,234.57,234.97,235.38,235.79,236.2,236.61,237.03,237.46,237.89,238.32,238.75,239.19,239.63,240.08,240.53,240.99,241.45,241.91,242.38,242.86,243.34,243.82,244.31,244.81,245.31,245.81,246.32,246.84,247.37,247.89,248.43,248.97,249.52,250.08,250.64,251.21,251.78,},
{122.7,123.3,123.89,124.47,125.04,125.61,126.17,126.72,127.26,127.8,128.34,128.86,129.38,129.9,130.41,130.91,131.41,131.9,132.39,132.87,133.35,133.82,134.29,134.75,135.21,135.66,136.11,136.56,137.0,137.43,137.87,138.3,138.72,139.14,139.56,139.97,140.38,140.79,141.2,141.6,141.99,142.39,142.78,143.17,143.55,143.94,144.32,144.69,145.07,145.44,145.81,146.17,146.54,146.9,147.26,147.62,147.97,148.33,148.68,149.03,149.37,149.72,150.06,150.4,150.74,151.08,151.42,151.75,152.08,152.41,152.74,153.07,153.4,153.72,154.04,154.37,154.69,155.01,155.33,155.64,155.96,156.27,156.59,156.9,157.21,157.52,157.83,158.14,158.45,158.75,159.06,159.36,159.67,159.97,160.27,160.57,160.88,161.18,161.48,161.77,162.07,162.37,162.67,162.97,163.26,163.56,163.85,164.15,164.44,164.74,165.03,165.32,165.61,165.91,166.2,166.49,166.78,167.07,167.37,167.66,167.95,168.24,168.53,168.82,169.11,169.4,169.69,169.98,170.27,170.55,170.84,171.13,171.42,171.71,172.0,172.29,172.58,172.87,173.16,173.44,173.73,174.02,174.31,174.6,174.89,175.18,175.47,175.76,176.05,176.33,176.62,176.91,177.2,177.49,177.78,178.07,178.36,178.65,178.94,179.23,179.52,179.81,180.1,180.39,180.68,180.98,181.27,181.56,181.85,182.14,182.43,182.72,183.01,183.3,183.6,183.89,184.18,184.47,184.76,185.05,185.35,185.64,185.93,186.22,186.51,186.81,187.1,187.39,187.68,187.97,188.27,188.56,188.85,189.14,189.43,189.73,190.02,190.31,190.6,190.89,191.19,191.48,191.77,192.06,192.35,192.64,192.94,193.23,193.52,193.81,194.1,194.39,194.68,194.97,195.26,195.55,195.84,196.14,196.43,196.72,197.01,197.3,197.59,197.88,198.17,198.46,198.74,199.03,199.32,199.61,199.9,200.19,200.48,200.77,201.06,201.35,201.64,201.93,202.21,202.5,202.79,203.08,203.37,203.66,203.95,204.24,204.53,204.81,205.1,205.39,205.68,205.97,206.26,206.55,206.84,207.13,207.42,207.71,208.0,208.29,208.58,208.87,209.16,209.46,209.75,210.04,210.33,210.62,210.92,211.21,211.51,211.8,212.09,212.39,212.69,212.98,213.28,213.58,213.87,214.17,214.47,214.77,215.07,215.37,215.67,215.98,216.28,216.58,216.89,217.19,217.5,217.81,218.12,218.43,218.74,219.05,219.36,219.67,219.99,220.3,220.62,220.94,221.26,221.58,221.9,222.22,222.55,222.88,223.2,223.53,223.86,224.2,224.53,224.87,225.2,225.54,225.88,226.23,226.57,226.92,227.27,227.62,227.97,228.33,228.68,229.04,229.41,229.77,230.14,230.51,230.88,231.25,231.63,232.01,232.39,232.78,233.17,233.56,233.95,234.35,234.75,235.15,235.56,235.97,236.39,236.8,237.22,237.65,238.08,238.51,238.95,239.39,239.83,240.28,240.74,241.2,241.66,242.13,242.6,243.07,243.56,244.04,244.54,245.03,245.54,246.05,246.56,247.08,247.61,248.14,248.68,249.23,249.78,250.34,250.9,251.47,},
{123.02,123.61,124.2,124.77,125.34,125.91,126.46,127.01,127.55,128.09,128.62,129.14,129.66,130.17,130.68,131.18,131.68,132.17,132.65,133.13,133.61,134.08,134.54,135.0,135.46,135.91,136.36,136.8,137.24,137.67,138.1,138.53,138.95,139.37,139.79,140.2,140.61,141.01,141.42,141.82,142.21,142.6,142.99,143.38,143.76,144.14,144.52,144.9,145.27,145.64,146.01,146.37,146.74,147.1,147.46,147.81,148.16,148.52,148.87,149.21,149.56,149.9,150.24,150.58,150.92,151.26,151.59,151.92,152.26,152.59,152.91,153.24,153.56,153.89,154.21,154.53,154.85,155.17,155.49,155.8,156.12,156.43,156.74,157.05,157.36,157.67,157.98,158.29,158.59,158.9,159.2,159.51,159.81,160.11,160.41,160.71,161.01,161.31,161.61,161.91,162.21,162.5,162.8,163.09,163.39,163.68,163.98,164.27,164.56,164.86,165.15,165.44,165.73,166.02,166.31,166.6,166.89,167.18,167.47,167.76,168.05,168.34,168.63,168.92,169.21,169.5,169.78,170.07,170.36,170.65,170.94,171.22,171.51,171.8,172.09,172.37,172.66,172.95,173.24,173.52,173.81,174.1,174.39,174.67,174.96,175.25,175.54,175.82,176.11,176.4,176.69,176.98,177.26,177.55,177.84,178.13,178.42,178.71,178.99,179.28,179.57,179.86,180.15,180.44,180.73,181.02,181.31,181.59,181.88,182.17,182.46,182.75,183.04,183.33,183.62,183.91,184.2,184.49,184.78,185.07,185.36,185.65,185.94,186.23,186.52,186.81,187.1,187.39,187.68,187.98,188.27,188.56,188.85,189.14,189.43,189.72,190.01,190.3,190.59,190.88,191.17,191.46,191.75,192.04,192.33,192.62,192.91,193.2,193.49,193.78,194.07,194.36,194.65,194.93,195.22,195.51,195.8,196.09,196.38,196.67,196.96,197.24,197.53,197.82,198.11,198.4,198.69,198.97,199.26,199.55,199.84,200.13,200.41,200.7,200.99,201.28,201.56,201.85,202.14,202.43,202.71,203.0,203.29,203.58,203.86,204.15,204.44,204.73,205.01,205.3,205.59,205.88,206.16,206.45,206.74,207.03,207.32,207.61,207.9,208.19,208.48,208.76,209.05,209.34,209.64,209.93,210.22,210.51,210.8,211.09,211.39,211.68,211.97,212.27,212.56,212.86,213.15,213.45,213.74,214.04,214.34,214.64,214.94,215.24,215.54,215.84,216.14,216.44,216.75,217.05,217.35,217.66,217.97,218.28,218.59,218.9,219.21,219.52,219.83,220.15,220.46,220.78,221.1,221.42,221.74,222.06,222.38,222.71,223.03,223.36,223.69,224.02,224.36,224.69,225.03,225.36,225.7,226.05,226.39,226.73,227.08,227.43,227.78,228.14,228.49,228.85,229.21,229.57,229.94,230.31,230.68,231.05,231.42,231.8,232.18,232.57,232.95,233.34,233.74,234.13,234.53,234.93,235.34,235.75,236.16,236.57,236.99,237.42,237.84,238.27,238.71,239.15,239.59,240.04,240.49,240.95,241.41,241.87,242.34,242.82,243.3,243.78,244.27,244.77,245.27,245.77,246.28,246.8,247.33,247.86,248.39,248.93,249.48,250.04,250.6,251.17,},
{123.33,123.92,124.5,125.08,125.64,126.2,126.76,127.3,127.84,128.37,128.9,129.42,129.94,130.45,130.95,131.45,131.94,132.43,132.91,133.39,133.86,134.33,134.79,135.25,135.7,136.15,136.6,137.04,137.48,137.91,138.34,138.76,139.18,139.6,140.01,140.42,140.83,141.24,141.64,142.03,142.43,142.82,143.2,143.59,143.97,144.35,144.73,145.1,145.47,145.84,146.21,146.57,146.93,147.29,147.65,148.0,148.35,148.7,149.05,149.4,149.74,150.08,150.42,150.76,151.1,151.43,151.77,152.1,152.43,152.76,153.08,153.41,153.73,154.05,154.37,154.69,155.01,155.33,155.64,155.96,156.27,156.58,156.9,157.21,157.51,157.82,158.13,158.43,158.74,159.04,159.35,159.65,159.95,160.25,160.55,160.85,161.15,161.45,161.74,162.04,162.34,162.63,162.93,163.22,163.51,163.81,164.1,164.39,164.68,164.98,165.27,165.56,165.85,166.14,166.43,166.72,167.0,167.29,167.58,167.87,168.16,168.45,168.73,169.02,169.31,169.59,169.88,170.17,170.45,170.74,171.03,171.31,171.6,171.89,172.17,172.46,172.74,173.03,173.32,173.6,173.89,174.18,174.46,174.75,175.03,175.32,175.61,175.89,176.18,176.46,176.75,177.04,177.32,177.61,177.9,178.18,178.47,178.76,179.04,179.33,179.62,179.91,180.19,180.48,180.77,181.06,181.34,181.63,181.92,182.21,182.49,182.78,183.07,183.36,183.65,183.94,184.22,184.51,184.8,185.09,185.38,185.67,185.96,186.24,186.53,186.82,187.11,187.4,187.69,187.98,188.26,188.55,188.84,189.13,189.42,189.71,190.0,190.29,190.57,190.86,191.15,191.44,191.73,192.02,192.3,192.59,192.88,193.17,193.46,193.75,194.03,194.32,194.61,194.9,195.18,195.47,195.76,196.05,196.33,196.62,196.91,197.19,197.48,197.77,198.05,198.34,198.63,198.91,199.2,199.49,199.77,200.06,200.35,200.63,200.92,201.2,201.49,201.78,202.06,202.35,202.63,202.92,203.21,203.49,203.78,204.07,204.35,204.64,204.92,205.21,205.5,205.78,206.07,206.36,206.64,206.93,207.22,207.51,207.79,208.08,208.37,208.66,208.95,209.24,209.52,209.81,210.1,210.39,210.68,210.98,211.27,211.56,211.85,212.14,212.44,212.73,213.02,213.32,213.61,213.91,214.21,214.5,214.8,215.1,215.4,215.7,216.0,216.3,216.6,216.91,217.21,217.52,217.82,218.13,218.44,218.75,219.06,219.37,219.68,219.99,220.31,220.62,220.94,221.26,221.58,221.9,222.22,222.54,222.87,223.19,223.52,223.85,224.18,224.52,224.85,225.19,225.53,225.87,226.21,226.55,226.9,227.25,227.6,227.95,228.3,228.66,229.02,229.38,229.74,230.11,230.48,230.85,231.22,231.6,231.98,232.36,232.75,233.13,233.52,233.92,234.31,234.71,235.12,235.53,235.94,236.35,236.77,237.19,237.61,238.04,238.47,238.91,239.35,239.8,240.25,240.7,241.16,241.62,242.09,242.56,243.04,243.52,244.01,244.5,245.0,245.5,246.01,246.53,247.05,247.57,248.11,248.65,249.19,249.75,250.31,250.87,},
{123.64,124.23,124.8,125.37,125.94,126.49,127.04,127.59,128.12,128.65,129.18,129.7,130.21,130.72,131.22,131.71,132.2,132.69,133.17,133.64,134.11,134.58,135.04,135.49,135.95,136.39,136.84,137.28,137.71,138.14,138.57,138.99,139.41,139.83,140.24,140.65,141.05,141.45,141.85,142.25,142.64,143.03,143.41,143.8,144.18,144.55,144.93,145.3,145.67,146.04,146.4,146.76,147.12,147.48,147.84,148.19,148.54,148.89,149.24,149.58,149.92,150.26,150.6,150.94,151.27,151.61,151.94,152.27,152.6,152.92,153.25,153.57,153.9,154.22,154.54,154.85,155.17,155.49,155.8,156.11,156.43,156.74,157.05,157.36,157.66,157.97,158.28,158.58,158.88,159.19,159.49,159.79,160.09,160.39,160.69,160.99,161.28,161.58,161.88,162.17,162.47,162.76,163.05,163.35,163.64,163.93,164.22,164.51,164.8,165.09,165.38,165.67,165.96,166.25,166.54,166.83,167.11,167.4,167.69,167.97,168.26,168.55,168.83,169.12,169.41,169.69,169.98,170.26,170.55,170.83,171.12,171.4,171.69,171.97,172.26,172.54,172.83,173.11,173.4,173.68,173.97,174.25,174.54,174.82,175.1,175.39,175.67,175.96,176.24,176.53,176.81,177.1,177.38,177.67,177.95,178.24,178.52,178.81,179.09,179.38,179.67,179.95,180.24,180.52,180.81,181.1,181.38,181.67,181.95,182.24,182.53,182.81,183.1,183.39,183.67,183.96,184.25,184.53,184.82,185.11,185.39,185.68,185.97,186.25,186.54,186.83,187.12,187.4,187.69,187.98,188.26,188.55,188.84,189.13,189.41,189.7,189.99,190.27,190.56,190.85,191.13,191.42,191.71,192.0,192.28,192.57,192.85,193.14,193.43,193.71,194.0,194.29,194.57,194.86,195.14,195.43,195.72,196.0,196.29,196.57,196.86,197.14,197.43,197.72,198.0,198.29,198.57,198.86,199.14,199.43,199.71,200.0,200.28,200.56,200.85,201.13,201.42,201.7,201.99,202.27,202.56,202.84,203.13,203.41,203.7,203.98,204.27,204.55,204.84,205.12,205.41,205.69,205.98,206.26,206.55,206.83,207.12,207.41,207.69,207.98,208.27,208.55,208.84,209.13,209.42,209.7,209.99,210.28,210.57,210.86,211.15,211.44,211.73,212.02,212.31,212.61,212.9,213.19,213.49,213.78,214.08,214.37,214.67,214.97,215.27,215.56,215.86,216.16,216.46,216.77,217.07,217.37,217.68,217.98,218.29,218.6,218.91,219.22,219.53,219.84,220.15,220.47,220.78,221.1,221.42,221.74,222.06,222.38,222.7,223.03,223.35,223.68,224.01,224.35,224.68,225.01,225.35,225.69,226.03,226.37,226.72,227.06,227.41,227.76,228.12,228.47,228.83,229.19,229.55,229.91,230.28,230.65,231.02,231.4,231.78,232.16,232.54,232.92,233.31,233.71,234.1,234.5,234.9,235.31,235.72,236.13,236.54,236.96,237.38,237.81,238.24,238.68,239.12,239.56,240.01,240.46,240.91,241.37,241.84,242.31,242.78,243.26,243.75,244.24,244.73,245.24,245.74,246.25,246.77,247.3,247.83,248.36,248.91,249.46,250.01,250.58,},
{123.94,124.53,125.1,125.67,126.23,126.78,127.33,127.87,128.4,128.93,129.45,129.97,130.48,130.98,131.48,131.97,132.46,132.94,133.42,133.89,134.36,134.82,135.28,135.74,136.19,136.63,137.07,137.51,137.94,138.37,138.79,139.22,139.63,140.05,140.46,140.86,141.27,141.67,142.06,142.46,142.85,143.23,143.62,144.0,144.38,144.76,145.13,145.5,145.87,146.23,146.6,146.96,147.31,147.67,148.02,148.38,148.72,149.07,149.42,149.76,150.1,150.44,150.78,151.11,151.45,151.78,152.11,152.44,152.77,153.09,153.41,153.74,154.06,154.38,154.7,155.01,155.33,155.64,155.96,156.27,156.58,156.89,157.2,157.5,157.81,158.12,158.42,158.72,159.03,159.33,159.63,159.93,160.23,160.53,160.82,161.12,161.42,161.71,162.01,162.3,162.59,162.89,163.18,163.47,163.76,164.05,164.34,164.63,164.92,165.21,165.5,165.79,166.07,166.36,166.65,166.93,167.22,167.51,167.79,168.08,168.36,168.65,168.93,169.22,169.5,169.79,170.07,170.36,170.64,170.92,171.21,171.49,171.77,172.06,172.34,172.63,172.91,173.19,173.47,173.76,174.04,174.32,174.61,174.89,175.17,175.46,175.74,176.02,176.31,176.59,176.87,177.16,177.44,177.73,178.01,178.29,178.58,178.86,179.14,179.43,179.71,180.0,180.28,180.57,180.85,181.13,181.42,181.7,181.99,182.27,182.56,182.84,183.13,183.41,183.7,183.98,184.27,184.55,184.84,185.12,185.41,185.69,185.98,186.27,186.55,186.84,187.12,187.41,187.69,187.98,188.26,188.55,188.83,189.12,189.41,189.69,189.98,190.26,190.55,190.83,191.12,191.4,191.69,191.97,192.26,192.54,192.83,193.11,193.4,193.68,193.97,194.25,194.54,194.82,195.11,195.39,195.68,195.96,196.24,196.53,196.81,197.1,197.38,197.66,197.95,198.23,198.51,198.8,199.08,199.36,199.65,199.93,200.22,200.5,200.78,201.06,201.35,201.63,201.91,202.2,202.48,202.76,203.05,203.33,203.61,203.9,204.18,204.46,204.75,205.03,205.32,205.6,205.88,206.17,206.45,206.74,207.02,207.31,207.59,207.88,208.16,208.45,208.73,209.02,209.31,209.59,209.88,210.17,210.46,210.75,211.03,211.32,211.61,211.9,212.19,212.49,212.78,213.07,213.36,213.66,213.95,214.24,214.54,214.84,215.13,215.43,215.73,216.03,216.33,216.63,216.93,217.23,217.54,217.84,218.14,218.45,218.76,219.07,219.38,219.69,220.0,220.31,220.63,220.94,221.26,221.58,221.9,222.22,222.54,222.86,223.19,223.52,223.85,224.18,224.51,224.84,225.18,225.51,225.85,226.19,226.54,226.88,227.23,227.58,227.93,228.28,228.64,229.0,229.36,229.72,230.09,230.46,230.83,231.2,231.57,231.95,232.34,232.72,233.11,233.5,233.89,234.29,234.69,235.09,235.5,235.91,236.32,236.74,237.16,237.58,238.01,238.45,238.88,239.32,239.77,240.22,240.67,241.13,241.59,242.06,242.53,243.01,243.49,243.98,244.47,244.97,245.48,245.99,246.5,247.02,247.55,248.09,248.63,249.17,249.73,250.29,},
{124.24,124.82,125.39,125.96,126.51,127.06,127.61,128.15,128.68,129.2,129.72,130.23,130.74,131.24,131.74,132.23,132.72,133.2,133.67,134.14,134.61,135.07,135.52,135.98,136.42,136.87,137.3,137.74,138.17,138.6,139.02,139.44,139.85,140.27,140.67,141.08,141.48,141.88,142.27,142.67,143.05,143.44,143.82,144.2,144.58,144.95,145.33,145.69,146.06,146.42,146.79,147.15,147.5,147.86,148.21,148.56,148.91,149.25,149.6,149.94,150.28,150.62,150.95,151.29,151.62,151.95,152.28,152.6,152.93,153.25,153.58,153.9,154.22,154.54,154.85,155.17,155.48,155.8,156.11,156.42,156.73,157.04,157.34,157.65,157.96,158.26,158.56,158.86,159.17,159.47,159.77,160.06,160.36,160.66,160.96,161.25,161.55,161.84,162.13,162.43,162.72,163.01,163.3,163.59,163.88,164.17,164.46,164.75,165.04,165.32,165.61,165.9,166.18,166.47,166.76,167.04,167.33,167.61,167.9,168.18,168.47,168.75,169.03,169.32,169.6,169.88,170.17,170.45,170.73,171.01,171.3,171.58,171.86,172.14,172.42,172.71,172.99,173.27,173.55,173.83,174.12,174.4,174.68,174.96,175.24,175.53,175.81,176.09,176.37,176.65,176.94,177.22,177.5,177.78,178.06,178.35,178.63,178.91,179.19,179.48,179.76,180.04,180.32,180.61,180.89,181.17,181.46,181.74,182.02,182.31,182.59,182.87,183.16,183.44,183.72,184.01,184.29,184.57,184.86,185.14,185.42,185.71,185.99,186.28,186.56,186.84,187.13,187.41,187.7,187.98,188.26,188.55,188.83,189.11,189.4,189.68,189.97,190.25,190.53,190.82,191.1,191.39,191.67,191.95,192.24,192.52,192.8,193.09,193.37,193.65,193.94,194.22,194.5,194.79,195.07,195.35,195.63,195.92,196.2,196.48,196.76,197.05,197.33,197.61,197.89,198.18,198.46,198.74,199.02,199.3,199.59,199.87,200.15,200.43,200.71,201.0,201.28,201.56,201.84,202.12,202.41,202.69,202.97,203.25,203.53,203.82,204.1,204.38,204.66,204.94,205.23,205.51,205.79,206.08,206.36,206.64,206.92,207.21,207.49,207.78,208.06,208.35,208.63,208.92,209.2,209.49,209.77,210.06,210.35,210.63,210.92,211.21,211.5,211.79,212.08,212.37,212.66,212.95,213.24,213.53,213.82,214.12,214.41,214.71,215.0,215.3,215.59,215.89,216.19,216.49,216.79,217.09,217.39,217.7,218.0,218.31,218.61,218.92,219.23,219.54,219.85,220.16,220.47,220.79,221.1,221.42,221.74,222.06,222.38,222.7,223.03,223.35,223.68,224.01,224.34,224.67,225.01,225.34,225.68,226.02,226.36,226.7,227.05,227.4,227.75,228.1,228.45,228.81,229.17,229.53,229.9,230.26,230.63,231.0,231.38,231.75,232.13,232.52,232.9,233.29,233.68,234.08,234.48,234.88,235.28,235.69,236.1,236.52,236.94,237.36,237.79,238.22,238.65,239.09,239.53,239.98,240.43,240.89,241.35,241.82,242.29,242.76,243.24,243.73,244.22,244.71,245.22,245.72,246.24,246.75,247.28,247.81,248.35,248.89,249.44,250.0,},
{124.54,125.11,125.68,126.24,126.8,127.34,127.88,128.42,128.95,129.47,129.99,130.5,131.0,131.5,131.99,132.48,132.97,133.44,133.92,134.39,134.85,135.31,135.76,136.21,136.66,137.1,137.53,137.97,138.4,138.82,139.24,139.66,140.07,140.48,140.89,141.29,141.69,142.09,142.48,142.87,143.26,143.64,144.02,144.4,144.78,145.15,145.52,145.89,146.25,146.61,146.97,147.33,147.69,148.04,148.39,148.74,149.09,149.43,149.77,150.11,150.45,150.79,151.12,151.46,151.79,152.12,152.44,152.77,153.09,153.42,153.74,154.06,154.38,154.69,155.01,155.32,155.64,155.95,156.26,156.57,156.88,157.18,157.49,157.8,158.1,158.4,158.7,159.0,159.3,159.6,159.9,160.2,160.5,160.79,161.09,161.38,161.68,161.97,162.26,162.55,162.84,163.13,163.42,163.71,164.0,164.29,164.58,164.86,165.15,165.44,165.72,166.01,166.29,166.58,166.86,167.15,167.43,167.72,168.0,168.28,168.57,168.85,169.13,169.41,169.69,169.98,170.26,170.54,170.82,171.1,171.38,171.66,171.94,172.23,172.51,172.79,173.07,173.35,173.63,173.91,174.19,174.47,174.75,175.03,175.31,175.59,175.87,176.15,176.43,176.71,177.0,177.28,177.56,177.84,178.12,178.4,178.68,178.96,179.24,179.52,179.8,180.09,180.37,180.65,180.93,181.21,181.49,181.77,182.06,182.34,182.62,182.9,183.18,183.46,183.75,184.03,184.31,184.59,184.87,185.16,185.44,185.72,186.0,186.29,186.57,186.85,187.13,187.42,187.7,187.98,188.26,188.54,188.83,189.11,189.39,189.67,189.96,190.24,190.52,190.8,191.09,191.37,191.65,191.93,192.21,192.5,192.78,193.06,193.34,193.62,193.9,194.19,194.47,194.75,195.03,195.31,195.59,195.88,196.16,196.44,196.72,197.0,197.28,197.56,197.84,198.12,198.4,198.68,198.96,199.25,199.53,199.81,200.09,200.37,200.65,200.93,201.21,201.49,201.77,202.05,202.33,202.61,202.89,203.17,203.45,203.73,204.01,204.3,204.58,204.86,205.14,205.42,205.7,205.98,206.27,206.55,206.83,207.11,207.39,207.68,207.96,208.24,208.53,208.81,209.1,209.38,209.66,209.95,210.24,210.52,210.81,211.09,211.38,211.67,211.96,212.25,212.54,212.83,213.12,213.41,213.7,213.99,214.28,214.58,214.87,215.17,215.46,215.76,216.06,216.36,216.65,216.95,217.26,217.56,217.86,218.16,218.47,218.77,219.08,219.39,219.7,220.01,220.32,220.63,220.95,221.27,221.58,221.9,222.22,222.54,222.86,223.19,223.52,223.84,224.17,224.5,224.84,225.17,225.51,225.85,226.19,226.53,226.87,227.22,227.57,227.92,228.27,228.63,228.98,229.34,229.71,230.07,230.44,230.81,231.18,231.56,231.94,232.32,232.7,233.09,233.48,233.87,234.27,234.67,235.07,235.48,235.89,236.3,236.72,237.14,237.56,237.99,238.43,238.86,239.3,239.75,240.2,240.65,241.11,241.57,242.04,242.52,242.99,243.48,243.96,244.46,244.96,245.46,245.97,246.49,247.01,247.54,248.07,248.62,249.16,249.72,},
{124.83,125.4,125.96,126.52,127.07,127.62,128.16,128.69,129.22,129.74,130.25,130.76,131.26,131.76,132.25,132.73,133.21,133.69,134.16,134.63,135.09,135.54,136.0,136.44,136.89,137.33,137.76,138.19,138.62,139.04,139.46,139.88,140.29,140.69,141.1,141.5,141.9,142.29,142.69,143.07,143.46,143.84,144.22,144.6,144.97,145.34,145.71,146.08,146.44,146.8,147.16,147.52,147.87,148.22,148.57,148.92,149.26,149.61,149.95,150.29,150.62,150.96,151.29,151.62,151.95,152.28,152.61,152.93,153.26,153.58,153.9,154.22,154.53,154.85,155.16,155.48,155.79,156.1,156.41,156.72,157.02,157.33,157.63,157.94,158.24,158.54,158.84,159.14,159.44,159.74,160.04,160.33,160.63,160.92,161.22,161.51,161.8,162.09,162.39,162.68,162.97,163.26,163.54,163.83,164.12,164.41,164.69,164.98,165.26,165.55,165.83,166.12,166.4,166.69,166.97,167.25,167.54,167.82,168.1,168.38,168.66,168.95,169.23,169.51,169.79,170.07,170.35,170.63,170.91,171.19,171.47,171.75,172.03,172.31,172.59,172.87,173.15,173.43,173.7,173.98,174.26,174.54,174.82,175.1,175.38,175.66,175.94,176.22,176.5,176.78,177.05,177.33,177.61,177.89,178.17,178.45,178.73,179.01,179.29,179.57,179.85,180.13,180.41,180.69,180.97,181.25,181.53,181.81,182.09,182.37,182.65,182.93,183.21,183.49,183.77,184.05,184.33,184.61,184.89,185.17,185.45,185.73,186.02,186.3,186.58,186.86,187.14,187.42,187.7,187.98,188.26,188.54,188.82,189.1,189.39,189.67,189.95,190.23,190.51,190.79,191.07,191.35,191.63,191.91,192.19,192.47,192.75,193.03,193.31,193.59,193.87,194.15,194.43,194.71,194.99,195.27,195.55,195.83,196.11,196.39,196.67,196.95,197.23,197.51,197.79,198.07,198.35,198.63,198.91,199.19,199.47,199.75,200.02,200.3,200.58,200.86,201.14,201.42,201.7,201.98,202.26,202.54,202.82,203.1,203.37,203.65,203.93,204.21,204.49,204.77,205.05,205.33,205.61,205.89,206.17,206.45,206.74,207.02,207.3,207.58,207.86,208.14,208.43,208.71,208.99,209.27,209.56,209.84,210.13,210.41,210.7,210.98,211.27,211.55,211.84,212.13,212.42,212.71,213.0,213.29,213.58,213.87,214.16,214.45,214.74,215.04,215.33,215.63,215.92,216.22,216.52,216.82,217.12,217.42,217.72,218.02,218.33,218.63,218.94,219.24,219.55,219.86,220.17,220.48,220.8,221.11,221.43,221.75,222.06,222.38,222.71,223.03,223.35,223.68,224.01,224.34,224.67,225.0,225.34,225.67,226.01,226.35,226.7,227.04,227.39,227.74,228.09,228.44,228.8,229.16,229.52,229.88,230.25,230.62,230.99,231.36,231.74,232.12,232.5,232.89,233.28,233.67,234.06,234.46,234.86,235.27,235.67,236.09,236.5,236.92,237.34,237.77,238.2,238.64,239.08,239.52,239.97,240.42,240.87,241.34,241.8,242.27,242.75,243.23,243.72,244.21,244.7,245.21,245.71,246.23,246.75,247.27,247.8,248.34,248.89,249.44,},
{125.11,125.68,126.24,126.8,127.35,127.89,128.43,128.96,129.48,130.0,130.51,131.01,131.51,132.01,132.5,132.98,133.46,133.93,134.4,134.86,135.32,135.78,136.23,136.67,137.11,137.55,137.98,138.41,138.84,139.26,139.68,140.09,140.5,140.91,141.31,141.71,142.1,142.5,142.89,143.27,143.66,144.04,144.42,144.79,145.16,145.53,145.9,146.27,146.63,146.99,147.34,147.7,148.05,148.4,148.75,149.09,149.44,149.78,150.12,150.46,150.79,151.13,151.46,151.79,152.12,152.44,152.77,153.09,153.42,153.74,154.05,154.37,154.69,155.0,155.32,155.63,155.94,156.25,156.56,156.86,157.17,157.47,157.78,158.08,158.38,158.68,158.98,159.28,159.58,159.87,160.17,160.46,160.76,161.05,161.35,161.64,161.93,162.22,162.51,162.8,163.09,163.38,163.66,163.95,164.24,164.52,164.81,165.09,165.38,165.66,165.94,166.23,166.51,166.79,167.07,167.36,167.64,167.92,168.2,168.48,168.76,169.04,169.32,169.6,169.88,170.16,170.44,170.72,171.0,171.28,171.55,171.83,172.11,172.39,172.67,172.95,173.22,173.5,173.78,174.06,174.33,174.61,174.89,175.17,175.45,175.72,176.0,176.28,176.56,176.83,177.11,177.39,177.67,177.95,178.22,178.5,178.78,179.06,179.34,179.61,179.89,180.17,180.45,180.73,181.01,181.29,181.56,181.84,182.12,182.4,182.68,182.96,183.24,183.52,183.79,184.07,184.35,184.63,184.91,185.19,185.47,185.75,186.03,186.31,186.59,186.86,187.14,187.42,187.7,187.98,188.26,188.54,188.82,189.1,189.38,189.66,189.94,190.22,190.5,190.77,191.05,191.33,191.61,191.89,192.17,192.45,192.73,193.01,193.29,193.56,193.84,194.12,194.4,194.68,194.96,195.24,195.51,195.79,196.07,196.35,196.63,196.91,197.18,197.46,197.74,198.02,198.3,198.57,198.85,199.13,199.41,199.68,199.96,200.24,200.52,200.8,201.07,201.35,201.63,201.91,202.18,202.46,202.74,203.02,203.3,203.57,203.85,204.13,204.41,204.69,204.97,205.25,205.52,205.8,206.08,206.36,206.64,206.92,207.2,207.48,207.76,208.04,208.33,208.61,208.89,209.17,209.45,209.74,210.02,210.3,210.59,210.87,211.16,211.44,211.73,212.01,212.3,212.59,212.88,213.16,213.45,213.74,214.03,214.33,214.62,214.91,215.2,215.5,215.79,216.09,216.39,216.68,216.98,217.28,217.58,217.88,218.19,218.49,218.79,219.1,219.41,219.72,220.03,220.34,220.65,220.96,221.28,221.59,221.91,222.23,222.55,222.87,223.19,223.52,223.85,224.17,224.5,224.84,225.17,225.51,225.84,226.18,226.52,226.87,227.21,227.56,227.91,228.26,228.62,228.98,229.34,229.7,230.06,230.43,230.8,231.17,231.55,231.92,232.31,232.69,233.08,233.47,233.86,234.26,234.66,235.06,235.47,235.88,236.29,236.71,237.13,237.55,237.98,238.41,238.85,239.29,239.74,240.19,240.64,241.1,241.56,242.03,242.51,242.99,243.47,243.96,244.45,244.95,245.46,245.97,246.49,247.01,247.54,248.07,248.62,249.17,},
{125.39,125.96,126.52,127.07,127.62,128.16,128.69,129.22,129.74,130.25,130.76,131.26,131.76,132.25,132.74,133.22,133.7,134.17,134.64,135.1,135.55,136.01,136.45,136.9,137.34,137.77,138.2,138.63,139.05,139.47,139.89,140.3,140.71,141.11,141.51,141.91,142.31,142.7,143.09,143.47,143.85,144.23,144.61,144.98,145.35,145.72,146.09,146.45,146.81,147.17,147.53,147.88,148.23,148.58,148.92,149.27,149.61,149.95,150.29,150.63,150.96,151.29,151.62,151.95,152.28,152.61,152.93,153.25,153.57,153.89,154.21,154.53,154.84,155.15,155.47,155.78,156.09,156.39,156.7,157.01,157.31,157.62,157.92,158.22,158.52,158.82,159.12,159.41,159.71,160.01,160.3,160.6,160.89,161.18,161.47,161.76,162.05,162.34,162.63,162.92,163.21,163.49,163.78,164.07,164.35,164.64,164.92,165.2,165.49,165.77,166.05,166.33,166.62,166.9,167.18,167.46,167.74,168.02,168.3,168.58,168.86,169.14,169.42,169.69,169.97,170.25,170.53,170.81,171.08,171.36,171.64,171.91,172.19,172.47,172.75,173.02,173.3,173.58,173.85,174.13,174.41,174.68,174.96,175.24,175.51,175.79,176.06,176.34,176.62,176.89,177.17,177.45,177.72,178.0,178.28,178.55,178.83,179.11,179.38,179.66,179.94,180.21,180.49,180.77,181.04,181.32,181.6,181.88,182.15,182.43,182.71,182.99,183.26,183.54,183.82,184.09,184.37,184.65,184.93,185.21,185.48,185.76,186.04,186.32,186.59,186.87,187.15,187.43,187.71,187.98,188.26,188.54,188.82,189.09,189.37,189.65,189.93,190.21,190.48,190.76,191.04,191.32,191.59,191.87,192.15,192.43,192.7,192.98,193.26,193.54,193.81,194.09,194.37,194.64,194.92,195.2,195.48,195.75,196.03,196.31,196.58,196.86,197.14,197.41,197.69,197.97,198.24,198.52,198.8,199.07,199.35,199.62,199.9,200.18,200.45,200.73,201.01,201.28,201.56,201.84,202.11,202.39,202.67,202.94,203.22,203.5,203.77,204.05,204.33,204.61,204.88,205.16,205.44,205.72,205.99,206.27,206.55,206.83,207.11,207.39,207.67,207.95,208.23,208.51,208.79,209.07,209.35,209.63,209.91,210.2,210.48,210.76,211.05,211.33,211.61,211.9,212.19,212.47,212.76,213.05,213.33,213.62,213.91,214.2,214.49,214.78,215.08,215.37,215.66,215.96,216.25,216.55,216.85,217.15,217.45,217.75,218.05,218.35,218.65,218.96,219.26,219.57,219.88,220.19,220.5,220.81,221.13,221.44,221.76,222.07,222.39,222.71,223.04,223.36,223.69,224.01,224.34,224.67,225.0,225.34,225.68,226.01,226.35,226.7,227.04,227.39,227.74,228.09,228.44,228.8,229.15,229.51,229.88,230.24,230.61,230.98,231.36,231.73,232.11,232.49,232.88,233.27,233.66,234.05,234.45,234.85,235.26,235.67,236.08,236.49,236.91,237.34,237.76,238.19,238.63,239.07,239.51,239.96,240.41,240.87,241.33,241.8,242.27,242.74,243.23,243.71,244.2,244.7,245.21,245.71,246.23,246.75,247.28,247.81,248.35,248.89,},
{125.67,126.23,126.79,127.34,127.88,128.42,128.95,129.48,129.99,130.51,131.01,131.51,132.01,132.5,132.98,133.46,133.94,134.4,134.87,135.33,135.78,136.23,136.68,137.12,137.56,137.99,138.42,138.85,139.27,139.68,140.1,140.51,140.91,141.32,141.72,142.11,142.51,142.9,143.28,143.67,144.05,144.43,144.8,145.17,145.54,145.91,146.27,146.63,146.99,147.35,147.7,148.06,148.41,148.75,149.1,149.44,149.78,150.12,150.46,150.79,151.13,151.46,151.79,152.11,152.44,152.76,153.09,153.41,153.73,154.05,154.36,154.68,154.99,155.3,155.61,155.92,156.23,156.54,156.84,157.15,157.45,157.76,158.06,158.36,158.66,158.95,159.25,159.55,159.84,160.14,160.43,160.72,161.02,161.31,161.6,161.89,162.18,162.46,162.75,163.04,163.33,163.61,163.9,164.18,164.46,164.75,165.03,165.31,165.6,165.88,166.16,166.44,166.72,167.0,167.28,167.56,167.84,168.12,168.4,168.67,168.95,169.23,169.51,169.78,170.06,170.34,170.62,170.89,171.17,171.44,171.72,172.0,172.27,172.55,172.82,173.1,173.37,173.65,173.93,174.2,174.48,174.75,175.03,175.3,175.58,175.85,176.13,176.4,176.68,176.95,177.23,177.5,177.78,178.05,178.33,178.6,178.88,179.15,179.43,179.7,179.98,180.26,180.53,180.81,181.08,181.36,181.63,181.91,182.18,182.46,182.74,183.01,183.29,183.56,183.84,184.12,184.39,184.67,184.94,185.22,185.5,185.77,186.05,186.33,186.6,186.88,187.16,187.43,187.71,187.98,188.26,188.54,188.81,189.09,189.37,189.64,189.92,190.19,190.47,190.75,191.02,191.3,191.58,191.85,192.13,192.4,192.68,192.96,193.23,193.51,193.78,194.06,194.33,194.61,194.89,195.16,195.44,195.71,195.99,196.26,196.54,196.81,197.09,197.36,197.64,197.92,198.19,198.47,198.74,199.02,199.29,199.57,199.84,200.12,200.39,200.67,200.94,201.22,201.49,201.77,202.04,202.32,202.59,202.87,203.14,203.42,203.7,203.97,204.25,204.52,204.8,205.08,205.35,205.63,205.91,206.18,206.46,206.74,207.01,207.29,207.57,207.85,208.13,208.41,208.69,208.97,209.25,209.53,209.81,210.09,210.37,210.65,210.94,211.22,211.5,211.79,212.07,212.36,212.64,212.93,213.22,213.5,213.79,214.08,214.37,214.66,214.95,215.24,215.54,215.83,216.12,216.42,216.72,217.01,217.31,217.61,217.91,218.21,218.51,218.82,219.12,219.43,219.74,220.04,220.35,220.66,220.98,221.29,221.61,221.92,222.24,222.56,222.88,223.2,223.53,223.85,224.18,224.51,224.84,225.17,225.51,225.85,226.19,226.53,226.87,227.21,227.56,227.91,228.26,228.62,228.97,229.33,229.7,230.06,230.43,230.8,231.17,231.54,231.92,232.3,232.69,233.07,233.46,233.85,234.25,234.65,235.05,235.46,235.87,236.28,236.7,237.12,237.55,237.98,238.41,238.85,239.29,239.74,240.19,240.64,241.1,241.56,242.03,242.51,242.99,243.47,243.96,244.46,244.96,245.46,245.98,246.49,247.02,247.55,248.08,248.63,},
{125.94,126.51,127.06,127.61,128.15,128.68,129.21,129.73,130.25,130.76,131.26,131.76,132.25,132.74,133.22,133.7,134.17,134.64,135.1,135.56,136.01,136.46,136.9,137.34,137.78,138.21,138.64,139.06,139.48,139.89,140.31,140.71,141.12,141.52,141.92,142.31,142.7,143.09,143.48,143.86,144.24,144.61,144.99,145.36,145.73,146.09,146.45,146.81,147.17,147.53,147.88,148.23,148.58,148.93,149.27,149.61,149.95,150.29,150.62,150.96,151.29,151.62,151.95,152.27,152.6,152.92,153.24,153.56,153.88,154.2,154.51,154.83,155.14,155.45,155.76,156.07,156.38,156.68,156.99,157.29,157.59,157.89,158.19,158.49,158.79,159.09,159.38,159.68,159.97,160.27,160.56,160.85,161.14,161.43,161.72,162.01,162.3,162.58,162.87,163.16,163.44,163.73,164.01,164.29,164.58,164.86,165.14,165.42,165.7,165.98,166.26,166.54,166.82,167.1,167.38,167.66,167.94,168.22,168.49,168.77,169.05,169.32,169.6,169.88,170.15,170.43,170.7,170.98,171.25,171.53,171.8,172.08,172.35,172.63,172.9,173.17,173.45,173.72,174.0,174.27,174.55,174.82,175.09,175.37,175.64,175.91,176.19,176.46,176.74,177.01,177.28,177.56,177.83,178.1,178.38,178.65,178.93,179.2,179.47,179.75,180.02,180.3,180.57,180.84,181.12,181.39,181.67,181.94,182.22,182.49,182.77,183.04,183.31,183.59,183.86,184.14,184.41,184.69,184.96,185.24,185.51,185.79,186.06,186.34,186.61,186.89,187.16,187.44,187.71,187.98,188.26,188.53,188.81,189.08,189.36,189.63,189.91,190.18,190.46,190.73,191.01,191.28,191.56,191.83,192.11,192.38,192.66,192.93,193.2,193.48,193.75,194.03,194.3,194.58,194.85,195.13,195.4,195.67,195.95,196.22,196.5,196.77,197.04,197.32,197.59,197.86,198.14,198.41,198.69,198.96,199.23,199.51,199.78,200.06,200.33,200.6,200.88,201.15,201.42,201.7,201.97,202.25,202.52,202.79,203.07,203.34,203.62,203.89,204.17,204.44,204.72,204.99,205.27,205.54,205.82,206.09,206.37,206.65,206.92,207.2,207.48,207.75,208.03,208.31,208.59,208.87,209.15,209.42,209.7,209.98,210.27,210.55,210.83,211.11,211.39,211.67,211.96,212.24,212.53,212.81,213.1,213.38,213.67,213.96,214.25,214.54,214.83,215.12,215.41,215.7,216.0,216.29,216.59,216.88,217.18,217.48,217.78,218.08,218.38,218.68,218.98,219.29,219.59,219.9,220.21,220.52,220.83,221.14,221.46,221.77,222.09,222.41,222.73,223.05,223.37,223.7,224.02,224.35,224.68,225.01,225.35,225.68,226.02,226.36,226.7,227.04,227.39,227.74,228.09,228.44,228.8,229.16,229.52,229.88,230.24,230.61,230.98,231.36,231.73,232.11,232.49,232.88,233.27,233.66,234.05,234.45,234.85,235.26,235.67,236.08,236.49,236.91,237.34,237.76,238.19,238.63,239.07,239.51,239.96,240.42,240.87,241.33,241.8,242.27,242.75,243.23,243.72,244.21,244.71,245.22,245.73,246.24,246.76,247.29,247.82,248.37,},
{126.21,126.77,127.32,127.87,128.41,128.94,129.46,129.98,130.5,131.0,131.5,132.0,132.49,132.98,133.46,133.93,134.4,134.87,135.33,135.78,136.23,136.68,137.12,137.56,137.99,138.42,138.85,139.27,139.69,140.1,140.51,140.92,141.32,141.72,142.12,142.51,142.9,143.29,143.67,144.05,144.43,144.8,145.17,145.54,145.91,146.27,146.63,146.99,147.35,147.7,148.06,148.4,148.75,149.1,149.44,149.78,150.12,150.45,150.79,151.12,151.45,151.78,152.11,152.43,152.76,153.08,153.4,153.72,154.03,154.35,154.66,154.98,155.29,155.6,155.91,156.21,156.52,156.82,157.13,157.43,157.73,158.03,158.33,158.63,158.92,159.22,159.52,159.81,160.1,160.39,160.69,160.98,161.27,161.56,161.84,162.13,162.42,162.7,162.99,163.27,163.56,163.84,164.12,164.41,164.69,164.97,165.25,165.53,165.81,166.09,166.37,166.65,166.93,167.2,167.48,167.76,168.04,168.31,168.59,168.86,169.14,169.41,169.69,169.96,170.24,170.51,170.79,171.06,171.34,171.61,171.88,172.16,172.43,172.7,172.98,173.25,173.52,173.8,174.07,174.34,174.61,174.89,175.16,175.43,175.7,175.98,176.25,176.52,176.79,177.07,177.34,177.61,177.88,178.16,178.43,178.7,178.97,179.25,179.52,179.79,180.06,180.34,180.61,180.88,181.16,181.43,181.7,181.97,182.25,182.52,182.79,183.07,183.34,183.61,183.89,184.16,184.43,184.71,184.98,185.25,185.53,185.8,186.07,186.35,186.62,186.89,187.17,187.44,187.71,187.99,188.26,188.53,188.81,189.08,189.35,189.63,189.9,190.17,190.45,190.72,190.99,191.27,191.54,191.81,192.09,192.36,192.63,192.91,193.18,193.45,193.72,194.0,194.27,194.54,194.82,195.09,195.36,195.63,195.91,196.18,196.45,196.73,197.0,197.27,197.54,197.82,198.09,198.36,198.63,198.91,199.18,199.45,199.72,200.0,200.27,200.54,200.81,201.09,201.36,201.63,201.9,202.18,202.45,202.72,202.99,203.27,203.54,203.81,204.09,204.36,204.64,204.91,205.18,205.46,205.73,206.01,206.28,206.56,206.83,207.11,207.38,207.66,207.94,208.21,208.49,208.77,209.05,209.32,209.6,209.88,210.16,210.44,210.72,211.0,211.28,211.56,211.85,212.13,212.41,212.7,212.98,213.27,213.55,213.84,214.13,214.42,214.71,214.99,215.29,215.58,215.87,216.16,216.46,216.75,217.05,217.34,217.64,217.94,218.24,218.54,218.84,219.15,219.45,219.76,220.07,220.37,220.68,221.0,221.31,221.62,221.94,222.26,222.57,222.89,223.22,223.54,223.87,224.19,224.52,224.85,225.18,225.52,225.85,226.19,226.53,226.88,227.22,227.57,227.92,228.27,228.62,228.98,229.34,229.7,230.06,230.43,230.8,231.17,231.55,231.92,232.3,232.69,233.07,233.46,233.86,234.25,234.65,235.06,235.46,235.87,236.29,236.71,237.13,237.55,237.98,238.42,238.85,239.3,239.74,240.19,240.65,241.11,241.57,242.04,242.52,243.0,243.48,243.97,244.47,244.97,245.48,245.99,246.51,247.04,247.57,248.11,},
{126.48,127.04,127.58,128.13,128.66,129.19,129.71,130.23,130.74,131.25,131.75,132.24,132.73,133.21,133.69,134.16,134.63,135.09,135.55,136.0,136.45,136.9,137.34,137.77,138.2,138.63,139.06,139.48,139.89,140.3,140.71,141.12,141.52,141.92,142.31,142.7,143.09,143.48,143.86,144.24,144.61,144.99,145.36,145.72,146.09,146.45,146.81,147.17,147.52,147.88,148.23,148.58,148.92,149.26,149.61,149.94,150.28,150.62,150.95,151.28,151.61,151.94,152.26,152.59,152.91,153.23,153.55,153.87,154.18,154.5,154.81,155.12,155.43,155.74,156.05,156.35,156.66,156.96,157.26,157.57,157.87,158.17,158.46,158.76,159.06,159.35,159.64,159.94,160.23,160.52,160.81,161.1,161.39,161.68,161.96,162.25,162.54,162.82,163.11,163.39,163.67,163.95,164.24,164.52,164.8,165.08,165.36,165.64,165.92,166.19,166.47,166.75,167.03,167.3,167.58,167.86,168.13,168.41,168.68,168.96,169.23,169.5,169.78,170.05,170.33,170.6,170.87,171.15,171.42,171.69,171.96,172.24,172.51,172.78,173.05,173.32,173.6,173.87,174.14,174.41,174.68,174.95,175.22,175.5,175.77,176.04,176.31,176.58,176.85,177.12,177.39,177.66,177.94,178.21,178.48,178.75,179.02,179.29,179.56,179.83,180.11,180.38,180.65,180.92,181.19,181.46,181.73,182.01,182.28,182.55,182.82,183.09,183.36,183.64,183.91,184.18,184.45,184.72,185.0,185.27,185.54,185.81,186.08,186.35,186.63,186.9,187.17,187.44,187.71,187.99,188.26,188.53,188.8,189.07,189.35,189.62,189.89,190.16,190.43,190.71,190.98,191.25,191.52,191.79,192.07,192.34,192.61,192.88,193.15,193.42,193.7,193.97,194.24,194.51,194.78,195.05,195.32,195.6,195.87,196.14,196.41,196.68,196.95,197.22,197.5,197.77,198.04,198.31,198.58,198.85,199.12,199.39,199.66,199.94,200.21,200.48,200.75,201.02,201.29,201.56,201.84,202.11,202.38,202.65,202.92,203.19,203.47,203.74,204.01,204.28,204.56,204.83,205.1,205.37,205.65,205.92,206.19,206.47,206.74,207.02,207.29,207.57,207.84,208.12,208.39,208.67,208.95,209.22,209.5,209.78,210.06,210.34,210.62,210.89,211.18,211.46,211.74,212.02,212.3,212.58,212.87,213.15,213.44,213.72,214.01,214.3,214.58,214.87,215.16,215.45,215.74,216.04,216.33,216.62,216.92,217.21,217.51,217.81,218.11,218.41,218.71,219.01,219.31,219.62,219.93,220.23,220.54,220.85,221.16,221.48,221.79,222.11,222.42,222.74,223.06,223.39,223.71,224.04,224.36,224.69,225.02,225.36,225.69,226.03,226.37,226.71,227.05,227.4,227.75,228.1,228.45,228.81,229.16,229.52,229.88,230.25,230.62,230.99,231.36,231.74,232.12,232.5,232.88,233.27,233.66,234.06,234.46,234.86,235.26,235.67,236.08,236.5,236.92,237.34,237.77,238.2,238.64,239.08,239.52,239.97,240.43,240.89,241.35,241.82,242.29,242.77,243.25,243.74,244.23,244.73,245.24,245.75,246.26,246.79,247.32,247.85,},
{126.74,127.3,127.84,128.38,128.91,129.44,129.96,130.48,130.98,131.49,131.98,132.47,132.96,133.44,133.92,134.39,134.85,135.31,135.77,136.22,136.67,137.11,137.55,137.98,138.41,138.84,139.26,139.68,140.09,140.5,140.91,141.31,141.71,142.11,142.5,142.89,143.28,143.66,144.04,144.42,144.8,145.17,145.54,145.9,146.27,146.63,146.99,147.34,147.7,148.05,148.4,148.74,149.09,149.43,149.77,150.11,150.44,150.78,151.11,151.44,151.77,152.09,152.42,152.74,153.06,153.38,153.7,154.02,154.33,154.64,154.96,155.27,155.58,155.88,156.19,156.49,156.8,157.1,157.4,157.7,158.0,158.3,158.6,158.89,159.19,159.48,159.77,160.06,160.36,160.65,160.93,161.22,161.51,161.8,162.08,162.37,162.65,162.94,163.22,163.5,163.78,164.07,164.35,164.63,164.91,165.19,165.46,165.74,166.02,166.3,166.57,166.85,167.13,167.4,167.68,167.95,168.23,168.5,168.77,169.05,169.32,169.59,169.87,170.14,170.41,170.68,170.96,171.23,171.5,171.77,172.04,172.31,172.58,172.85,173.13,173.4,173.67,173.94,174.21,174.48,174.75,175.02,175.29,175.56,175.83,176.1,176.37,176.64,176.91,177.18,177.45,177.72,177.99,178.26,178.53,178.8,179.07,179.34,179.61,179.88,180.15,180.42,180.69,180.96,181.23,181.5,181.77,182.04,182.31,182.58,182.85,183.12,183.39,183.66,183.93,184.2,184.47,184.74,185.01,185.28,185.55,185.82,186.09,186.36,186.63,186.91,187.18,187.45,187.72,187.99,188.26,188.53,188.8,189.07,189.34,189.61,189.88,190.15,190.42,190.69,190.96,191.23,191.5,191.78,192.05,192.32,192.59,192.86,193.13,193.4,193.67,193.94,194.21,194.48,194.75,195.02,195.29,195.56,195.83,196.1,196.37,196.64,196.91,197.18,197.45,197.72,197.99,198.26,198.53,198.8,199.07,199.34,199.61,199.88,200.15,200.42,200.69,200.96,201.23,201.5,201.77,202.04,202.31,202.58,202.85,203.12,203.39,203.66,203.93,204.2,204.48,204.75,205.02,205.29,205.56,205.84,206.11,206.38,206.65,206.93,207.2,207.47,207.75,208.02,208.3,208.57,208.85,209.12,209.4,209.68,209.96,210.23,210.51,210.79,211.07,211.35,211.63,211.91,212.19,212.47,212.76,213.04,213.32,213.61,213.89,214.18,214.46,214.75,215.04,215.33,215.62,215.91,216.2,216.5,216.79,217.08,217.38,217.68,217.97,218.27,218.57,218.88,219.18,219.48,219.79,220.09,220.4,220.71,221.02,221.33,221.64,221.96,222.28,222.59,222.91,223.23,223.56,223.88,224.21,224.54,224.87,225.2,225.53,225.87,226.21,226.55,226.89,227.23,227.58,227.93,228.28,228.63,228.99,229.35,229.71,230.07,230.44,230.81,231.18,231.55,231.93,232.31,232.7,233.08,233.47,233.87,234.26,234.66,235.07,235.47,235.88,236.3,236.72,237.14,237.56,237.99,238.43,238.87,239.31,239.76,240.21,240.66,241.13,241.59,242.06,242.54,243.02,243.5,244.0,244.49,245.0,245.5,246.02,246.54,247.07,247.6,},
{127.0,127.55,128.09,128.63,129.16,129.69,130.2,130.72,131.22,131.72,132.22,132.71,133.19,133.67,134.14,134.61,135.08,135.53,135.99,136.44,136.88,137.32,137.76,138.19,138.62,139.04,139.46,139.88,140.29,140.7,141.11,141.51,141.91,142.3,142.69,143.08,143.47,143.85,144.23,144.61,144.98,145.35,145.72,146.08,146.44,146.8,147.16,147.52,147.87,148.22,148.56,148.91,149.25,149.59,149.93,150.27,150.6,150.94,151.27,151.6,151.92,152.25,152.57,152.89,153.21,153.53,153.85,154.16,154.48,154.79,155.1,155.41,155.72,156.02,156.33,156.63,156.93,157.24,157.54,157.84,158.13,158.43,158.73,159.02,159.31,159.61,159.9,160.19,160.48,160.77,161.06,161.34,161.63,161.92,162.2,162.49,162.77,163.05,163.33,163.61,163.9,164.18,164.46,164.73,165.01,165.29,165.57,165.85,166.12,166.4,166.67,166.95,167.22,167.5,167.77,168.05,168.32,168.59,168.87,169.14,169.41,169.68,169.95,170.23,170.5,170.77,171.04,171.31,171.58,171.85,172.12,172.39,172.66,172.93,173.2,173.47,173.74,174.01,174.28,174.54,174.81,175.08,175.35,175.62,175.89,176.16,176.43,176.7,176.96,177.23,177.5,177.77,178.04,178.31,178.58,178.84,179.11,179.38,179.65,179.92,180.19,180.46,180.72,180.99,181.26,181.53,181.8,182.07,182.34,182.61,182.88,183.14,183.41,183.68,183.95,184.22,184.49,184.76,185.03,185.3,185.57,185.84,186.1,186.37,186.64,186.91,187.18,187.45,187.72,187.99,188.26,188.53,188.8,189.07,189.33,189.6,189.87,190.14,190.41,190.68,190.95,191.22,191.49,191.76,192.03,192.29,192.56,192.83,193.1,193.37,193.64,193.91,194.18,194.45,194.71,194.98,195.25,195.52,195.79,196.06,196.33,196.6,196.86,197.13,197.4,197.67,197.94,198.21,198.48,198.74,199.01,199.28,199.55,199.82,200.09,200.36,200.63,200.89,201.16,201.43,201.7,201.97,202.24,202.51,202.78,203.05,203.32,203.59,203.86,204.13,204.4,204.67,204.94,205.21,205.48,205.75,206.02,206.29,206.57,206.84,207.11,207.38,207.66,207.93,208.2,208.48,208.75,209.03,209.3,209.58,209.85,210.13,210.41,210.69,210.96,211.24,211.52,211.8,212.08,212.36,212.64,212.93,213.21,213.49,213.78,214.06,214.35,214.63,214.92,215.21,215.5,215.79,216.08,216.37,216.66,216.96,217.25,217.55,217.84,218.14,218.44,218.74,219.04,219.35,219.65,219.95,220.26,220.57,220.88,221.19,221.5,221.81,222.13,222.45,222.76,223.08,223.41,223.73,224.05,224.38,224.71,225.04,225.37,225.71,226.05,226.38,226.73,227.07,227.41,227.76,228.11,228.46,228.82,229.18,229.54,229.9,230.26,230.63,231.0,231.37,231.75,232.13,232.51,232.9,233.29,233.68,234.07,234.47,234.87,235.28,235.69,236.1,236.52,236.94,237.36,237.79,238.22,238.66,239.1,239.54,239.99,240.45,240.91,241.37,241.84,242.31,242.79,243.28,243.76,244.26,244.76,245.27,245.78,246.3,246.82,247.35,},
{127.26,127.8,128.34,128.88,129.41,129.93,130.44,130.95,131.46,131.96,132.45,132.94,133.42,133.89,134.37,134.83,135.29,135.75,136.2,136.65,137.09,137.53,137.97,138.4,138.82,139.25,139.67,140.08,140.49,140.9,141.3,141.7,142.1,142.49,142.88,143.27,143.65,144.03,144.41,144.79,145.16,145.53,145.89,146.26,146.62,146.98,147.33,147.68,148.04,148.38,148.73,149.07,149.42,149.76,150.09,150.43,150.76,151.09,151.42,151.75,152.08,152.4,152.72,153.04,153.36,153.68,153.99,154.31,154.62,154.93,155.24,155.55,155.86,156.16,156.47,156.77,157.07,157.37,157.67,157.97,158.26,158.56,158.86,159.15,159.44,159.73,160.02,160.31,160.6,160.89,161.18,161.46,161.75,162.03,162.32,162.6,162.88,163.16,163.45,163.73,164.01,164.28,164.56,164.84,165.12,165.4,165.67,165.95,166.22,166.5,166.77,167.05,167.32,167.59,167.87,168.14,168.41,168.68,168.96,169.23,169.5,169.77,170.04,170.31,170.58,170.85,171.12,171.39,171.66,171.93,172.2,172.47,172.73,173.0,173.27,173.54,173.81,174.08,174.34,174.61,174.88,175.15,175.41,175.68,175.95,176.22,176.48,176.75,177.02,177.29,177.55,177.82,178.09,178.36,178.62,178.89,179.16,179.43,179.69,179.96,180.23,180.49,180.76,181.03,181.3,181.56,181.83,182.1,182.37,182.63,182.9,183.17,183.44,183.7,183.97,184.24,184.51,184.78,185.04,185.31,185.58,185.85,186.11,186.38,186.65,186.92,187.19,187.45,187.72,187.99,188.26,188.53,188.79,189.06,189.33,189.6,189.86,190.13,190.4,190.67,190.94,191.2,191.47,191.74,192.01,192.27,192.54,192.81,193.08,193.34,193.61,193.88,194.15,194.41,194.68,194.95,195.22,195.48,195.75,196.02,196.29,196.55,196.82,197.09,197.36,197.62,197.89,198.16,198.43,198.69,198.96,199.23,199.49,199.76,200.03,200.3,200.56,200.83,201.1,201.37,201.64,201.9,202.17,202.44,202.71,202.98,203.24,203.51,203.78,204.05,204.32,204.59,204.86,205.13,205.4,205.67,205.94,206.21,206.48,206.75,207.02,207.29,207.57,207.84,208.11,208.38,208.66,208.93,209.21,209.48,209.75,210.03,210.31,210.58,210.86,211.14,211.42,211.69,211.97,212.25,212.53,212.81,213.1,213.38,213.66,213.95,214.23,214.52,214.8,215.09,215.38,215.67,215.96,216.25,216.54,216.83,217.12,217.42,217.71,218.01,218.31,218.61,218.91,219.21,219.51,219.82,220.12,220.43,220.74,221.05,221.36,221.67,221.98,222.3,222.62,222.94,223.26,223.58,223.9,224.23,224.56,224.89,225.22,225.55,225.89,226.22,226.56,226.91,227.25,227.6,227.95,228.3,228.65,229.01,229.36,229.72,230.09,230.45,230.82,231.2,231.57,231.95,232.33,232.71,233.1,233.49,233.88,234.28,234.68,235.08,235.49,235.9,236.32,236.74,237.16,237.59,238.02,238.45,238.89,239.33,239.78,240.23,240.69,241.15,241.62,242.09,242.57,243.05,243.54,244.03,244.53,245.03,245.54,246.06,246.58,247.11,},
{127.51,128.05,128.59,129.12,129.65,130.17,130.68,131.19,131.69,132.19,132.68,133.16,133.64,134.12,134.59,135.05,135.51,135.96,136.42,136.86,137.3,137.74,138.17,138.6,139.03,139.45,139.86,140.28,140.69,141.09,141.49,141.89,142.29,142.68,143.07,143.45,143.84,144.21,144.59,144.96,145.33,145.7,146.07,146.43,146.79,147.15,147.5,147.85,148.2,148.55,148.89,149.24,149.58,149.92,150.25,150.59,150.92,151.25,151.58,151.9,152.23,152.55,152.87,153.19,153.51,153.83,154.14,154.45,154.76,155.07,155.38,155.69,155.99,156.3,156.6,156.9,157.2,157.5,157.8,158.1,158.39,158.69,158.98,159.27,159.57,159.86,160.15,160.44,160.72,161.01,161.3,161.58,161.87,162.15,162.43,162.71,163.0,163.28,163.56,163.84,164.11,164.39,164.67,164.95,165.22,165.5,165.77,166.05,166.32,166.6,166.87,167.14,167.42,167.69,167.96,168.23,168.5,168.78,169.05,169.32,169.59,169.86,170.13,170.39,170.66,170.93,171.2,171.47,171.74,172.0,172.27,172.54,172.81,173.08,173.34,173.61,173.88,174.14,174.41,174.68,174.94,175.21,175.48,175.74,176.01,176.28,176.54,176.81,177.07,177.34,177.61,177.87,178.14,178.4,178.67,178.94,179.2,179.47,179.73,180.0,180.27,180.53,180.8,181.07,181.33,181.6,181.86,182.13,182.4,182.66,182.93,183.19,183.46,183.73,183.99,184.26,184.53,184.79,185.06,185.33,185.59,185.86,186.12,186.39,186.66,186.92,187.19,187.46,187.72,187.99,188.26,188.52,188.79,189.06,189.32,189.59,189.86,190.12,190.39,190.66,190.92,191.19,191.45,191.72,191.99,192.25,192.52,192.79,193.05,193.32,193.58,193.85,194.12,194.38,194.65,194.92,195.18,195.45,195.71,195.98,196.25,196.51,196.78,197.04,197.31,197.58,197.84,198.11,198.37,198.64,198.91,199.17,199.44,199.71,199.97,200.24,200.5,200.77,201.04,201.3,201.57,201.84,202.1,202.37,202.64,202.91,203.17,203.44,203.71,203.98,204.24,204.51,204.78,205.05,205.32,205.59,205.86,206.12,206.39,206.66,206.93,207.21,207.48,207.75,208.02,208.29,208.56,208.84,209.11,209.38,209.66,209.93,210.21,210.48,210.76,211.03,211.31,211.59,211.87,212.15,212.42,212.7,212.99,213.27,213.55,213.83,214.12,214.4,214.68,214.97,215.26,215.55,215.83,216.12,216.41,216.71,217.0,217.29,217.59,217.88,218.18,218.48,218.78,219.08,219.38,219.68,219.99,220.29,220.6,220.91,221.22,221.53,221.84,222.16,222.47,222.79,223.11,223.43,223.75,224.08,224.41,224.73,225.06,225.4,225.73,226.07,226.41,226.75,227.09,227.43,227.78,228.13,228.48,228.84,229.19,229.55,229.92,230.28,230.65,231.02,231.39,231.77,232.15,232.53,232.92,233.31,233.7,234.09,234.49,234.89,235.3,235.71,236.12,236.54,236.96,237.38,237.81,238.25,238.68,239.12,239.57,240.02,240.48,240.94,241.4,241.87,242.35,242.83,243.31,243.8,244.3,244.8,245.31,245.82,246.34,246.87,},
{127.75,128.3,128.83,129.36,129.89,130.4,130.91,131.42,131.92,132.41,132.9,133.38,133.86,134.33,134.8,135.26,135.72,136.18,136.62,137.07,137.51,137.94,138.37,138.8,139.22,139.64,140.06,140.47,140.88,141.28,141.68,142.08,142.47,142.86,143.25,143.63,144.02,144.39,144.77,145.14,145.51,145.88,146.24,146.6,146.96,147.31,147.67,148.02,148.37,148.71,149.06,149.4,149.74,150.07,150.41,150.74,151.07,151.4,151.73,152.05,152.38,152.7,153.02,153.34,153.65,153.97,154.28,154.59,154.9,155.21,155.52,155.83,156.13,156.43,156.74,157.04,157.34,157.63,157.93,158.23,158.52,158.82,159.11,159.4,159.69,159.98,160.27,160.56,160.84,161.13,161.41,161.7,161.98,162.26,162.55,162.83,163.11,163.39,163.67,163.94,164.22,164.5,164.78,165.05,165.33,165.6,165.88,166.15,166.42,166.7,166.97,167.24,167.51,167.78,168.05,168.32,168.59,168.86,169.13,169.4,169.67,169.94,170.21,170.48,170.74,171.01,171.28,171.55,171.81,172.08,172.35,172.61,172.88,173.15,173.41,173.68,173.94,174.21,174.48,174.74,175.01,175.27,175.54,175.8,176.07,176.33,176.6,176.86,177.13,177.39,177.66,177.92,178.19,178.45,178.72,178.98,179.25,179.51,179.78,180.04,180.31,180.57,180.84,181.1,181.37,181.63,181.89,182.16,182.42,182.69,182.95,183.22,183.48,183.75,184.01,184.28,184.54,184.81,185.07,185.34,185.6,185.87,186.14,186.4,186.67,186.93,187.2,187.46,187.73,187.99,188.26,188.52,188.79,189.05,189.32,189.58,189.85,190.11,190.38,190.64,190.91,191.17,191.44,191.7,191.97,192.23,192.5,192.76,193.03,193.29,193.56,193.82,194.09,194.35,194.62,194.88,195.15,195.41,195.68,195.94,196.21,196.47,196.74,197.0,197.27,197.53,197.8,198.06,198.33,198.59,198.85,199.12,199.38,199.65,199.91,200.18,200.45,200.71,200.98,201.24,201.51,201.77,202.04,202.3,202.57,202.84,203.1,203.37,203.63,203.9,204.17,204.44,204.7,204.97,205.24,205.51,205.77,206.04,206.31,206.58,206.85,207.12,207.39,207.66,207.93,208.2,208.47,208.74,209.01,209.29,209.56,209.83,210.11,210.38,210.66,210.93,211.21,211.48,211.76,212.04,212.32,212.6,212.88,213.16,213.44,213.72,214.0,214.29,214.57,214.85,215.14,215.43,215.71,216.0,216.29,216.58,216.87,217.17,217.46,217.76,218.05,218.35,218.65,218.95,219.25,219.55,219.85,220.16,220.46,220.77,221.08,221.39,221.7,222.01,222.33,222.65,222.96,223.28,223.61,223.93,224.26,224.58,224.91,225.24,225.58,225.91,226.25,226.59,226.93,227.27,227.62,227.97,228.32,228.67,229.03,229.39,229.75,230.11,230.48,230.85,231.22,231.59,231.97,232.35,232.74,233.12,233.51,233.91,234.3,234.71,235.11,235.52,235.93,236.34,236.76,237.19,237.61,238.04,238.48,238.92,239.36,239.81,240.27,240.72,241.19,241.65,242.13,242.61,243.09,243.58,244.07,244.57,245.08,245.59,246.1,246.63,},
{128.0,128.54,129.07,129.6,130.12,130.64,131.14,131.65,132.14,132.64,133.12,133.6,134.08,134.55,135.02,135.48,135.93,136.38,136.83,137.27,137.71,138.14,138.57,139.0,139.42,139.84,140.25,140.66,141.07,141.47,141.87,142.26,142.66,143.05,143.43,143.81,144.19,144.57,144.94,145.31,145.68,146.05,146.41,146.77,147.12,147.48,147.83,148.18,148.53,148.87,149.22,149.56,149.89,150.23,150.56,150.9,151.23,151.55,151.88,152.2,152.53,152.85,153.17,153.48,153.8,154.11,154.42,154.73,155.04,155.35,155.66,155.96,156.27,156.57,156.87,157.17,157.47,157.76,158.06,158.35,158.65,158.94,159.23,159.52,159.81,160.1,160.39,160.68,160.96,161.25,161.53,161.81,162.1,162.38,162.66,162.94,163.22,163.5,163.77,164.05,164.33,164.6,164.88,165.15,165.43,165.7,165.98,166.25,166.52,166.79,167.06,167.33,167.61,167.88,168.15,168.41,168.68,168.95,169.22,169.49,169.76,170.02,170.29,170.56,170.83,171.09,171.36,171.62,171.89,172.16,172.42,172.69,172.95,173.22,173.48,173.75,174.01,174.28,174.54,174.8,175.07,175.33,175.6,175.86,176.13,176.39,176.65,176.92,177.18,177.44,177.71,177.97,178.24,178.5,178.76,179.03,179.29,179.55,179.82,180.08,180.34,180.61,180.87,181.13,181.4,181.66,181.93,182.19,182.45,182.72,182.98,183.24,183.51,183.77,184.04,184.3,184.56,184.83,185.09,185.35,185.62,185.88,186.15,186.41,186.67,186.94,187.2,187.46,187.73,187.99,188.26,188.52,188.78,189.05,189.31,189.58,189.84,190.1,190.37,190.63,190.89,191.16,191.42,191.69,191.95,192.21,192.48,192.74,193.0,193.27,193.53,193.8,194.06,194.32,194.59,194.85,195.11,195.38,195.64,195.9,196.17,196.43,196.69,196.96,197.22,197.49,197.75,198.01,198.28,198.54,198.8,199.07,199.33,199.59,199.86,200.12,200.39,200.65,200.91,201.18,201.44,201.71,201.97,202.24,202.5,202.77,203.03,203.3,203.56,203.83,204.09,204.36,204.63,204.89,205.16,205.43,205.69,205.96,206.23,206.49,206.76,207.03,207.3,207.57,207.84,208.11,208.38,208.65,208.92,209.19,209.46,209.74,210.01,210.28,210.56,210.83,211.11,211.38,211.66,211.93,212.21,212.49,212.77,213.05,213.33,213.61,213.89,214.17,214.45,214.74,215.02,215.31,215.6,215.88,216.17,216.46,216.75,217.04,217.34,217.63,217.93,218.22,218.52,218.82,219.12,219.42,219.72,220.02,220.33,220.63,220.94,221.25,221.56,221.87,222.19,222.5,222.82,223.14,223.46,223.78,224.11,224.43,224.76,225.09,225.42,225.76,226.09,226.43,226.77,227.11,227.46,227.81,228.16,228.51,228.86,229.22,229.58,229.94,230.31,230.67,231.05,231.42,231.8,232.17,232.56,232.94,233.33,233.72,234.12,234.52,234.92,235.33,235.74,236.15,236.57,236.99,237.42,237.85,238.28,238.72,239.16,239.61,240.06,240.51,240.98,241.44,241.91,242.39,242.87,243.36,243.85,244.34,244.85,245.36,245.87,246.39,},
{128.24,128.78,129.31,129.83,130.35,130.86,131.37,131.87,132.37,132.86,133.34,133.82,134.29,134.76,135.23,135.69,136.14,136.59,137.03,137.47,137.91,138.34,138.77,139.19,139.61,140.03,140.44,140.85,141.25,141.66,142.05,142.45,142.84,143.23,143.61,143.99,144.37,144.74,145.12,145.48,145.85,146.21,146.58,146.93,147.29,147.64,147.99,148.34,148.69,149.03,149.37,149.71,150.05,150.38,150.72,151.05,151.38,151.7,152.03,152.35,152.67,152.99,153.31,153.62,153.94,154.25,154.56,154.87,155.18,155.49,155.79,156.1,156.4,156.7,157.0,157.3,157.6,157.89,158.19,158.48,158.77,159.06,159.36,159.64,159.93,160.22,160.51,160.79,161.08,161.36,161.64,161.93,162.21,162.49,162.77,163.05,163.33,163.6,163.88,164.16,164.43,164.71,164.98,165.26,165.53,165.8,166.07,166.35,166.62,166.89,167.16,167.43,167.7,167.97,168.24,168.5,168.77,169.04,169.31,169.57,169.84,170.11,170.37,170.64,170.91,171.17,171.44,171.7,171.97,172.23,172.49,172.76,173.02,173.29,173.55,173.81,174.08,174.34,174.6,174.87,175.13,175.39,175.66,175.92,176.18,176.45,176.71,176.97,177.23,177.5,177.76,178.02,178.28,178.55,178.81,179.07,179.33,179.6,179.86,180.12,180.38,180.64,180.91,181.17,181.43,181.69,181.96,182.22,182.48,182.74,183.01,183.27,183.53,183.79,184.06,184.32,184.58,184.84,185.11,185.37,185.63,185.89,186.16,186.42,186.68,186.94,187.21,187.47,187.73,187.99,188.26,188.52,188.78,189.04,189.31,189.57,189.83,190.09,190.36,190.62,190.88,191.14,191.41,191.67,191.93,192.19,192.46,192.72,192.98,193.24,193.51,193.77,194.03,194.29,194.55,194.82,195.08,195.34,195.6,195.87,196.13,196.39,196.65,196.92,197.18,197.44,197.7,197.97,198.23,198.49,198.75,199.02,199.28,199.54,199.8,200.07,200.33,200.59,200.85,201.12,201.38,201.64,201.91,202.17,202.44,202.7,202.96,203.23,203.49,203.76,204.02,204.28,204.55,204.82,205.08,205.35,205.61,205.88,206.14,206.41,206.68,206.95,207.21,207.48,207.75,208.02,208.29,208.56,208.83,209.1,209.37,209.64,209.91,210.18,210.46,210.73,211.0,211.28,211.55,211.83,212.11,212.38,212.66,212.94,213.22,213.5,213.78,214.06,214.34,214.63,214.91,215.19,215.48,215.77,216.05,216.34,216.63,216.92,217.21,217.51,217.8,218.1,218.39,218.69,218.99,219.29,219.59,219.89,220.19,220.5,220.81,221.11,221.42,221.74,222.05,222.36,222.68,223.0,223.32,223.64,223.96,224.29,224.61,224.94,225.27,225.61,225.94,226.28,226.62,226.96,227.3,227.65,228.0,228.35,228.7,229.06,229.41,229.78,230.14,230.51,230.87,231.25,231.62,232.0,232.38,232.77,233.15,233.54,233.94,234.34,234.74,235.14,235.55,235.96,236.38,236.8,237.22,237.65,238.08,238.52,238.96,239.4,239.85,240.31,240.77,241.23,241.7,242.17,242.65,243.14,243.63,244.12,244.62,245.13,245.64,246.16,},
{128.48,129.01,129.54,130.06,130.58,131.09,131.59,132.09,132.59,133.07,133.56,134.03,134.51,134.97,135.43,135.89,136.34,136.79,137.23,137.67,138.11,138.54,138.96,139.39,139.8,140.22,140.63,141.04,141.44,141.84,142.23,142.63,143.02,143.4,143.79,144.17,144.54,144.92,145.29,145.65,146.02,146.38,146.74,147.1,147.45,147.8,148.15,148.5,148.85,149.19,149.53,149.87,150.2,150.54,150.87,151.2,151.52,151.85,152.17,152.5,152.82,153.13,153.45,153.77,154.08,154.39,154.7,155.01,155.32,155.62,155.93,156.23,156.53,156.83,157.13,157.43,157.72,158.02,158.31,158.61,158.9,159.19,159.48,159.77,160.05,160.34,160.62,160.91,161.19,161.48,161.76,162.04,162.32,162.6,162.88,163.16,163.43,163.71,163.99,164.26,164.54,164.81,165.08,165.36,165.63,165.9,166.17,166.44,166.71,166.98,167.25,167.52,167.79,168.06,168.33,168.59,168.86,169.13,169.39,169.66,169.92,170.19,170.45,170.72,170.98,171.25,171.51,171.78,172.04,172.3,172.57,172.83,173.09,173.36,173.62,173.88,174.14,174.41,174.67,174.93,175.19,175.45,175.72,175.98,176.24,176.5,176.76,177.02,177.29,177.55,177.81,178.07,178.33,178.59,178.85,179.11,179.38,179.64,179.9,180.16,180.42,180.68,180.94,181.2,181.46,181.73,181.99,182.25,182.51,182.77,183.03,183.29,183.55,183.81,184.08,184.34,184.6,184.86,185.12,185.38,185.64,185.9,186.17,186.43,186.69,186.95,187.21,187.47,187.73,187.99,188.26,188.52,188.78,189.04,189.3,189.56,189.82,190.08,190.35,190.61,190.87,191.13,191.39,191.65,191.91,192.17,192.43,192.7,192.96,193.22,193.48,193.74,194.0,194.26,194.52,194.78,195.05,195.31,195.57,195.83,196.09,196.35,196.61,196.87,197.14,197.4,197.66,197.92,198.18,198.44,198.7,198.96,199.23,199.49,199.75,200.01,200.27,200.53,200.8,201.06,201.32,201.58,201.84,202.11,202.37,202.63,202.89,203.16,203.42,203.68,203.95,204.21,204.48,204.74,205.0,205.27,205.53,205.8,206.06,206.33,206.6,206.86,207.13,207.4,207.66,207.93,208.2,208.47,208.74,209.01,209.28,209.55,209.82,210.09,210.36,210.63,210.9,211.18,211.45,211.73,212.0,212.28,212.56,212.83,213.11,213.39,213.67,213.95,214.23,214.51,214.8,215.08,215.36,215.65,215.94,216.22,216.51,216.8,217.09,217.38,217.68,217.97,218.27,218.56,218.86,219.16,219.46,219.76,220.06,220.37,220.67,220.98,221.29,221.6,221.91,222.22,222.54,222.86,223.17,223.49,223.82,224.14,224.47,224.79,225.12,225.46,225.79,226.12,226.46,226.8,227.15,227.49,227.84,228.19,228.54,228.89,229.25,229.61,229.97,230.34,230.71,231.08,231.45,231.83,232.21,232.59,232.98,233.37,233.76,234.16,234.55,234.96,235.36,235.78,236.19,236.61,237.03,237.46,237.89,238.32,238.76,239.2,239.65,240.1,240.56,241.02,241.49,241.96,242.44,242.92,243.41,243.9,244.4,244.91,245.42,245.93,},
{128.71,129.24,129.77,130.29,130.8,131.31,131.82,132.31,132.8,133.29,133.77,134.24,134.71,135.18,135.64,136.09,136.55,136.99,137.43,137.87,138.3,138.73,139.16,139.58,139.99,140.41,140.81,141.22,141.62,142.02,142.41,142.8,143.19,143.58,143.96,144.34,144.71,145.09,145.45,145.82,146.18,146.55,146.9,147.26,147.61,147.96,148.31,148.66,149.0,149.34,149.68,150.02,150.35,150.69,151.02,151.34,151.67,152.0,152.32,152.64,152.96,153.28,153.59,153.9,154.22,154.53,154.84,155.14,155.45,155.76,156.06,156.36,156.66,156.96,157.26,157.55,157.85,158.14,158.44,158.73,159.02,159.31,159.6,159.88,160.17,160.46,160.74,161.02,161.31,161.59,161.87,162.15,162.43,162.71,162.99,163.26,163.54,163.81,164.09,164.36,164.64,164.91,165.18,165.46,165.73,166.0,166.27,166.54,166.81,167.08,167.34,167.61,167.88,168.15,168.41,168.68,168.95,169.21,169.48,169.74,170.01,170.27,170.53,170.8,171.06,171.33,171.59,171.85,172.11,172.38,172.64,172.9,173.16,173.42,173.69,173.95,174.21,174.47,174.73,174.99,175.25,175.51,175.77,176.03,176.3,176.56,176.82,177.08,177.34,177.6,177.86,178.12,178.38,178.64,178.9,179.16,179.42,179.68,179.94,180.2,180.46,180.72,180.98,181.24,181.5,181.76,182.02,182.28,182.54,182.8,183.06,183.32,183.58,183.84,184.1,184.36,184.61,184.87,185.13,185.39,185.65,185.91,186.17,186.43,186.69,186.95,187.21,187.47,187.73,187.99,188.25,188.51,188.77,189.03,189.29,189.55,189.81,190.07,190.33,190.59,190.85,191.11,191.37,191.63,191.89,192.15,192.41,192.67,192.93,193.19,193.45,193.71,193.97,194.23,194.49,194.75,195.01,195.27,195.53,195.79,196.05,196.31,196.57,196.83,197.09,197.35,197.61,197.87,198.13,198.39,198.65,198.91,199.17,199.43,199.69,199.95,200.22,200.48,200.74,201.0,201.26,201.52,201.78,202.04,202.3,202.57,202.83,203.09,203.35,203.61,203.88,204.14,204.4,204.66,204.93,205.19,205.46,205.72,205.98,206.25,206.51,206.78,207.04,207.31,207.58,207.84,208.11,208.38,208.65,208.91,209.18,209.45,209.72,209.99,210.26,210.53,210.81,211.08,211.35,211.63,211.9,212.18,212.45,212.73,213.0,213.28,213.56,213.84,214.12,214.4,214.68,214.97,215.25,215.53,215.82,216.11,216.39,216.68,216.97,217.26,217.55,217.85,218.14,218.44,218.73,219.03,219.33,219.63,219.93,220.24,220.54,220.85,221.15,221.46,221.77,222.09,222.4,222.72,223.03,223.35,223.67,224.0,224.32,224.65,224.98,225.31,225.64,225.97,226.31,226.65,226.99,227.34,227.68,228.03,228.38,228.73,229.09,229.45,229.81,230.17,230.54,230.91,231.28,231.66,232.04,232.42,232.8,233.19,233.58,233.98,234.37,234.78,235.18,235.59,236.0,236.42,236.84,237.27,237.69,238.13,238.56,239.01,239.45,239.9,240.36,240.82,241.28,241.75,242.23,242.71,243.2,243.69,244.18,244.69,245.2,245.71,},
{128.94,129.47,130.0,130.51,131.03,131.53,132.03,132.53,133.02,133.5,133.98,134.45,134.92,135.38,135.84,136.3,136.74,137.19,137.63,138.06,138.49,138.92,139.34,139.76,140.18,140.59,141.0,141.4,141.8,142.2,142.59,142.98,143.37,143.75,144.13,144.51,144.88,145.25,145.62,145.99,146.35,146.71,147.07,147.42,147.77,148.12,148.47,148.81,149.16,149.5,149.83,150.17,150.5,150.83,151.16,151.49,151.82,152.14,152.46,152.78,153.1,153.42,153.73,154.04,154.35,154.66,154.97,155.28,155.58,155.89,156.19,156.49,156.79,157.09,157.38,157.68,157.97,158.27,158.56,158.85,159.14,159.43,159.71,160.0,160.29,160.57,160.86,161.14,161.42,161.7,161.98,162.26,162.54,162.82,163.09,163.37,163.64,163.92,164.19,164.47,164.74,165.01,165.28,165.55,165.82,166.09,166.36,166.63,166.9,167.17,167.43,167.7,167.97,168.23,168.5,168.77,169.03,169.3,169.56,169.82,170.09,170.35,170.61,170.88,171.14,171.4,171.66,171.92,172.19,172.45,172.71,172.97,173.23,173.49,173.75,174.01,174.27,174.53,174.79,175.05,175.31,175.57,175.83,176.09,176.35,176.61,176.87,177.13,177.39,177.65,177.9,178.16,178.42,178.68,178.94,179.2,179.46,179.72,179.98,180.23,180.49,180.75,181.01,181.27,181.53,181.79,182.05,182.3,182.56,182.82,183.08,183.34,183.6,183.86,184.11,184.37,184.63,184.89,185.15,185.41,185.67,185.93,186.18,186.44,186.7,186.96,187.22,187.48,187.74,188.0,188.25,188.51,188.77,189.03,189.29,189.55,189.81,190.07,190.32,190.58,190.84,191.1,191.36,191.62,191.88,192.14,192.39,192.65,192.91,193.17,193.43,193.69,193.95,194.2,194.46,194.72,194.98,195.24,195.5,195.76,196.02,196.27,196.53,196.79,197.05,197.31,197.57,197.83,198.09,198.35,198.6,198.86,199.12,199.38,199.64,199.9,200.16,200.42,200.68,200.94,201.2,201.46,201.72,201.98,202.24,202.5,202.76,203.02,203.28,203.54,203.8,204.07,204.33,204.59,204.85,205.12,205.38,205.64,205.9,206.17,206.43,206.7,206.96,207.23,207.49,207.76,208.02,208.29,208.56,208.82,209.09,209.36,209.63,209.9,210.17,210.44,210.71,210.98,211.25,211.53,211.8,212.07,212.35,212.62,212.9,213.18,213.45,213.73,214.01,214.29,214.57,214.85,215.14,215.42,215.71,215.99,216.28,216.57,216.85,217.14,217.43,217.73,218.02,218.31,218.61,218.91,219.2,219.5,219.8,220.11,220.41,220.72,221.02,221.33,221.64,221.95,222.26,222.58,222.9,223.21,223.53,223.85,224.18,224.5,224.83,225.16,225.49,225.83,226.16,226.5,226.84,227.18,227.53,227.87,228.22,228.58,228.93,229.29,229.65,230.01,230.38,230.74,231.12,231.49,231.87,232.25,232.63,233.02,233.41,233.8,234.2,234.6,235.0,235.41,235.82,236.24,236.65,237.08,237.5,237.94,238.37,238.81,239.26,239.7,240.16,240.62,241.08,241.55,242.02,242.5,242.98,243.47,243.97,244.47,244.98,245.49,},
{129.17,129.7,130.22,130.73,131.24,131.75,132.25,132.74,133.23,133.71,134.19,134.66,135.12,135.58,136.04,136.49,136.94,137.38,137.82,138.25,138.68,139.11,139.53,139.95,140.36,140.77,141.18,141.58,141.98,142.37,142.77,143.15,143.54,143.92,144.3,144.68,145.05,145.42,145.78,146.15,146.51,146.87,147.22,147.58,147.93,148.28,148.62,148.97,149.31,149.65,149.98,150.32,150.65,150.98,151.31,151.63,151.96,152.28,152.6,152.92,153.24,153.55,153.87,154.18,154.49,154.8,155.1,155.41,155.71,156.02,156.32,156.62,156.92,157.21,157.51,157.8,158.1,158.39,158.68,158.97,159.26,159.55,159.83,160.12,160.4,160.69,160.97,161.25,161.53,161.81,162.09,162.37,162.65,162.92,163.2,163.47,163.75,164.02,164.29,164.57,164.84,165.11,165.38,165.65,165.92,166.19,166.46,166.72,166.99,167.26,167.52,167.79,168.06,168.32,168.59,168.85,169.11,169.38,169.64,169.9,170.17,170.43,170.69,170.95,171.21,171.48,171.74,172.0,172.26,172.52,172.78,173.04,173.3,173.56,173.82,174.08,174.34,174.59,174.85,175.11,175.37,175.63,175.89,176.15,176.4,176.66,176.92,177.18,177.44,177.69,177.95,178.21,178.47,178.73,178.98,179.24,179.5,179.76,180.01,180.27,180.53,180.79,181.04,181.3,181.56,181.82,182.07,182.33,182.59,182.85,183.1,183.36,183.62,183.88,184.13,184.39,184.65,184.91,185.16,185.42,185.68,185.94,186.19,186.45,186.71,186.97,187.22,187.48,187.74,188.0,188.25,188.51,188.77,189.03,189.28,189.54,189.8,190.06,190.31,190.57,190.83,191.09,191.34,191.6,191.86,192.12,192.37,192.63,192.89,193.15,193.4,193.66,193.92,194.18,194.43,194.69,194.95,195.21,195.46,195.72,195.98,196.24,196.49,196.75,197.01,197.27,197.52,197.78,198.04,198.3,198.56,198.81,199.07,199.33,199.59,199.85,200.1,200.36,200.62,200.88,201.14,201.4,201.66,201.92,202.18,202.44,202.69,202.95,203.21,203.47,203.73,204.0,204.26,204.52,204.78,205.04,205.3,205.56,205.83,206.09,206.35,206.62,206.88,207.14,207.41,207.67,207.94,208.2,208.47,208.73,209.0,209.27,209.54,209.81,210.07,210.34,210.61,210.88,211.16,211.43,211.7,211.97,212.25,212.52,212.8,213.07,213.35,213.63,213.9,214.18,214.46,214.74,215.03,215.31,215.59,215.88,216.16,216.45,216.74,217.03,217.32,217.61,217.9,218.19,218.49,218.78,219.08,219.38,219.68,219.98,220.28,220.59,220.89,221.2,221.51,221.82,222.13,222.44,222.76,223.08,223.39,223.71,224.04,224.36,224.69,225.02,225.35,225.68,226.01,226.35,226.69,227.03,227.37,227.72,228.07,228.42,228.77,229.13,229.49,229.85,230.21,230.58,230.95,231.32,231.7,232.08,232.46,232.85,233.23,233.63,234.02,234.42,234.82,235.23,235.64,236.05,236.47,236.89,237.32,237.75,238.18,238.62,239.06,239.51,239.96,240.42,240.88,241.35,241.82,242.29,242.78,243.26,243.76,244.26,244.76,245.27,},
{129.39,129.92,130.44,130.95,131.46,131.96,132.46,132.95,133.44,133.92,134.39,134.86,135.32,135.78,136.24,136.69,137.13,137.57,138.01,138.44,138.87,139.3,139.71,140.13,140.54,140.95,141.36,141.76,142.15,142.55,142.94,143.32,143.71,144.09,144.47,144.84,145.21,145.58,145.95,146.31,146.67,147.03,147.38,147.73,148.08,148.43,148.78,149.12,149.46,149.8,150.13,150.46,150.8,151.12,151.45,151.78,152.1,152.42,152.74,153.06,153.37,153.69,154.0,154.31,154.62,154.93,155.23,155.54,155.84,156.14,156.44,156.74,157.04,157.34,157.63,157.92,158.22,158.51,158.8,159.09,159.38,159.66,159.95,160.23,160.52,160.8,161.08,161.36,161.64,161.92,162.2,162.47,162.75,163.03,163.3,163.58,163.85,164.12,164.39,164.67,164.94,165.21,165.48,165.75,166.01,166.28,166.55,166.82,167.08,167.35,167.61,167.88,168.14,168.41,168.67,168.93,169.2,169.46,169.72,169.98,170.25,170.51,170.77,171.03,171.29,171.55,171.81,172.07,172.33,172.59,172.85,173.11,173.36,173.62,173.88,174.14,174.4,174.66,174.91,175.17,175.43,175.69,175.94,176.2,176.46,176.72,176.97,177.23,177.49,177.74,178.0,178.26,178.51,178.77,179.03,179.28,179.54,179.8,180.05,180.31,180.56,180.82,181.08,181.33,181.59,181.85,182.1,182.36,182.62,182.87,183.13,183.38,183.64,183.9,184.15,184.41,184.67,184.92,185.18,185.43,185.69,185.95,186.2,186.46,186.72,186.97,187.23,187.48,187.74,188.0,188.25,188.51,188.77,189.02,189.28,189.54,189.79,190.05,190.3,190.56,190.82,191.07,191.33,191.59,191.84,192.1,192.35,192.61,192.87,193.12,193.38,193.64,193.89,194.15,194.4,194.66,194.92,195.17,195.43,195.69,195.94,196.2,196.46,196.71,196.97,197.22,197.48,197.74,197.99,198.25,198.51,198.77,199.02,199.28,199.54,199.79,200.05,200.31,200.57,200.82,201.08,201.34,201.6,201.85,202.11,202.37,202.63,202.89,203.15,203.41,203.67,203.93,204.19,204.45,204.71,204.97,205.23,205.49,205.75,206.01,206.27,206.53,206.8,207.06,207.32,207.59,207.85,208.12,208.38,208.65,208.91,209.18,209.45,209.71,209.98,210.25,210.52,210.79,211.06,211.33,211.6,211.87,212.15,212.42,212.69,212.97,213.24,213.52,213.8,214.08,214.36,214.64,214.92,215.2,215.48,215.76,216.05,216.33,216.62,216.91,217.2,217.49,217.78,218.07,218.37,218.66,218.96,219.25,219.55,219.85,220.15,220.46,220.76,221.07,221.38,221.69,222.0,222.31,222.62,222.94,223.26,223.58,223.9,224.22,224.55,224.87,225.2,225.53,225.87,226.2,226.54,226.88,227.22,227.57,227.92,228.27,228.62,228.97,229.33,229.69,230.05,230.42,230.79,231.16,231.53,231.91,232.29,232.68,233.06,233.45,233.85,234.25,234.65,235.05,235.46,235.87,236.29,236.71,237.13,237.56,237.99,238.43,238.87,239.32,239.77,240.22,240.68,241.15,241.62,242.09,242.57,243.06,243.55,244.04,244.55,245.05,},
{129.61,130.14,130.65,131.17,131.67,132.17,132.67,133.16,133.64,134.12,134.59,135.06,135.52,135.98,136.43,136.88,137.32,137.76,138.2,138.63,139.06,139.48,139.9,140.31,140.72,141.13,141.53,141.93,142.33,142.72,143.11,143.49,143.88,144.26,144.63,145.0,145.37,145.74,146.11,146.47,146.83,147.18,147.54,147.89,148.24,148.58,148.93,149.27,149.61,149.94,150.28,150.61,150.94,151.27,151.59,151.92,152.24,152.56,152.88,153.2,153.51,153.82,154.13,154.44,154.75,155.06,155.36,155.67,155.97,156.27,156.57,156.87,157.16,157.46,157.75,158.05,158.34,158.63,158.92,159.2,159.49,159.78,160.06,160.35,160.63,160.91,161.19,161.47,161.75,162.03,162.3,162.58,162.86,163.13,163.4,163.68,163.95,164.22,164.49,164.76,165.03,165.3,165.57,165.84,166.11,166.37,166.64,166.91,167.17,167.44,167.7,167.97,168.23,168.49,168.75,169.02,169.28,169.54,169.8,170.06,170.32,170.58,170.84,171.1,171.36,171.62,171.88,172.14,172.4,172.66,172.92,173.17,173.43,173.69,173.95,174.2,174.46,174.72,174.97,175.23,175.49,175.74,176.0,176.26,176.51,176.77,177.02,177.28,177.53,177.79,178.05,178.3,178.56,178.81,179.07,179.32,179.58,179.83,180.09,180.34,180.6,180.86,181.11,181.37,181.62,181.88,182.13,182.39,182.64,182.9,183.15,183.41,183.66,183.92,184.17,184.43,184.68,184.94,185.19,185.45,185.7,185.96,186.21,186.47,186.72,186.98,187.23,187.49,187.74,188.0,188.25,188.51,188.76,189.02,189.27,189.53,189.78,190.04,190.29,190.55,190.8,191.06,191.31,191.57,191.82,192.08,192.33,192.59,192.84,193.1,193.36,193.61,193.87,194.12,194.38,194.63,194.89,195.14,195.4,195.65,195.91,196.16,196.42,196.67,196.93,197.18,197.44,197.69,197.95,198.21,198.46,198.72,198.97,199.23,199.48,199.74,200.0,200.25,200.51,200.77,201.02,201.28,201.54,201.79,202.05,202.31,202.57,202.82,203.08,203.34,203.6,203.86,204.11,204.37,204.63,204.89,205.15,205.41,205.67,205.93,206.19,206.46,206.72,206.98,207.24,207.5,207.77,208.03,208.3,208.56,208.82,209.09,209.36,209.62,209.89,210.16,210.43,210.69,210.96,211.23,211.5,211.77,212.05,212.32,212.59,212.87,213.14,213.42,213.69,213.97,214.25,214.53,214.81,215.09,215.37,215.65,215.94,216.22,216.51,216.79,217.08,217.37,217.66,217.95,218.25,218.54,218.83,219.13,219.43,219.73,220.03,220.33,220.64,220.94,221.25,221.56,221.87,222.18,222.49,222.8,223.12,223.44,223.76,224.08,224.41,224.73,225.06,225.39,225.72,226.06,226.4,226.73,227.08,227.42,227.77,228.11,228.47,228.82,229.18,229.53,229.9,230.26,230.63,231.0,231.37,231.75,232.13,232.51,232.9,233.29,233.68,234.07,234.47,234.88,235.28,235.69,236.11,236.53,236.95,237.38,237.81,238.24,238.68,239.13,239.57,240.03,240.49,240.95,241.42,241.89,242.37,242.85,243.34,243.84,244.34,244.84,},
{129.83,130.35,130.87,131.38,131.88,132.38,132.87,133.36,133.84,134.32,134.79,135.26,135.72,136.17,136.62,137.07,137.51,137.95,138.38,138.81,139.24,139.66,140.08,140.49,140.9,141.3,141.7,142.1,142.5,142.89,143.28,143.66,144.04,144.42,144.79,145.17,145.53,145.9,146.26,146.62,146.98,147.34,147.69,148.04,148.39,148.73,149.07,149.41,149.75,150.09,150.42,150.75,151.08,151.41,151.73,152.06,152.38,152.7,153.01,153.33,153.64,153.96,154.27,154.58,154.88,155.19,155.49,155.79,156.1,156.4,156.69,156.99,157.29,157.58,157.87,158.16,158.46,158.74,159.03,159.32,159.61,159.89,160.17,160.46,160.74,161.02,161.3,161.58,161.86,162.13,162.41,162.68,162.96,163.23,163.51,163.78,164.05,164.32,164.59,164.86,165.13,165.4,165.67,165.93,166.2,166.47,166.73,167.0,167.26,167.52,167.79,168.05,168.31,168.58,168.84,169.1,169.36,169.62,169.88,170.14,170.4,170.66,170.92,171.18,171.44,171.69,171.95,172.21,172.47,172.73,172.98,173.24,173.5,173.75,174.01,174.26,174.52,174.78,175.03,175.29,175.54,175.8,176.05,176.31,176.56,176.82,177.07,177.33,177.58,177.84,178.09,178.35,178.6,178.86,179.11,179.36,179.62,179.87,180.13,180.38,180.63,180.89,181.14,181.4,181.65,181.9,182.16,182.41,182.67,182.92,183.17,183.43,183.68,183.94,184.19,184.44,184.7,184.95,185.21,185.46,185.71,185.97,186.22,186.48,186.73,186.98,187.24,187.49,187.75,188.0,188.25,188.51,188.76,189.01,189.27,189.52,189.78,190.03,190.28,190.54,190.79,191.05,191.3,191.55,191.81,192.06,192.32,192.57,192.82,193.08,193.33,193.59,193.84,194.09,194.35,194.6,194.86,195.11,195.36,195.62,195.87,196.13,196.38,196.63,196.89,197.14,197.4,197.65,197.91,198.16,198.42,198.67,198.92,199.18,199.43,199.69,199.94,200.2,200.45,200.71,200.97,201.22,201.48,201.73,201.99,202.25,202.5,202.76,203.02,203.27,203.53,203.79,204.05,204.3,204.56,204.82,205.08,205.34,205.6,205.86,206.12,206.38,206.64,206.9,207.16,207.42,207.68,207.95,208.21,208.47,208.74,209.0,209.27,209.53,209.8,210.07,210.33,210.6,210.87,211.14,211.41,211.68,211.95,212.22,212.49,212.77,213.04,213.31,213.59,213.87,214.14,214.42,214.7,214.98,215.26,215.54,215.83,216.11,216.39,216.68,216.97,217.26,217.55,217.84,218.13,218.42,218.71,219.01,219.31,219.61,219.91,220.21,220.51,220.81,221.12,221.43,221.74,222.05,222.36,222.67,222.99,223.31,223.62,223.95,224.27,224.59,224.92,225.25,225.58,225.92,226.25,226.59,226.93,227.27,227.62,227.96,228.31,228.67,229.02,229.38,229.74,230.1,230.47,230.84,231.21,231.59,231.96,232.35,232.73,233.12,233.51,233.9,234.3,234.7,235.11,235.52,235.93,236.35,236.77,237.2,237.62,238.06,238.5,238.94,239.39,239.84,240.29,240.75,241.22,241.69,242.17,242.65,243.14,243.63,244.13,244.63,},
{130.04,130.57,131.08,131.59,132.09,132.59,133.08,133.56,134.04,134.52,134.99,135.45,135.91,136.36,136.81,137.26,137.7,138.13,138.57,138.99,139.42,139.84,140.25,140.66,141.07,141.47,141.88,142.27,142.66,143.05,143.44,143.82,144.2,144.58,144.95,145.33,145.69,146.06,146.42,146.78,147.14,147.49,147.84,148.19,148.54,148.88,149.22,149.56,149.9,150.23,150.56,150.89,151.22,151.55,151.87,152.19,152.51,152.83,153.15,153.46,153.78,154.09,154.4,154.7,155.01,155.32,155.62,155.92,156.22,156.52,156.82,157.11,157.41,157.7,157.99,158.28,158.57,158.86,159.15,159.43,159.72,160.0,160.29,160.57,160.85,161.13,161.41,161.68,161.96,162.24,162.51,162.79,163.06,163.33,163.61,163.88,164.15,164.42,164.69,164.96,165.22,165.49,165.76,166.03,166.29,166.56,166.82,167.08,167.35,167.61,167.87,168.14,168.4,168.66,168.92,169.18,169.44,169.7,169.96,170.22,170.48,170.74,170.99,171.25,171.51,171.77,172.02,172.28,172.54,172.79,173.05,173.3,173.56,173.82,174.07,174.33,174.58,174.84,175.09,175.34,175.6,175.85,176.11,176.36,176.62,176.87,177.12,177.38,177.63,177.88,178.14,178.39,178.64,178.9,179.15,179.4,179.66,179.91,180.16,180.42,180.67,180.92,181.17,181.43,181.68,181.93,182.19,182.44,182.69,182.94,183.2,183.45,183.7,183.96,184.21,184.46,184.71,184.97,185.22,185.47,185.73,185.98,186.23,186.48,186.74,186.99,187.24,187.49,187.75,188.0,188.25,188.51,188.76,189.01,189.26,189.52,189.77,190.02,190.27,190.53,190.78,191.03,191.29,191.54,191.79,192.04,192.3,192.55,192.8,193.05,193.31,193.56,193.81,194.07,194.32,194.57,194.82,195.08,195.33,195.58,195.84,196.09,196.34,196.6,196.85,197.1,197.36,197.61,197.86,198.12,198.37,198.62,198.88,199.13,199.38,199.64,199.89,200.15,200.4,200.65,200.91,201.16,201.42,201.67,201.93,202.18,202.44,202.7,202.95,203.21,203.46,203.72,203.98,204.23,204.49,204.75,205.01,205.26,205.52,205.78,206.04,206.3,206.56,206.82,207.08,207.34,207.6,207.86,208.13,208.39,208.65,208.92,209.18,209.44,209.71,209.98,210.24,210.51,210.78,211.04,211.31,211.58,211.85,212.12,212.39,212.67,212.94,213.21,213.49,213.76,214.04,214.32,214.59,214.87,215.15,215.43,215.72,216.0,216.28,216.57,216.85,217.14,217.43,217.72,218.01,218.3,218.6,218.89,219.19,219.48,219.78,220.08,220.38,220.69,220.99,221.3,221.61,221.92,222.23,222.54,222.86,223.17,223.49,223.81,224.13,224.46,224.78,225.11,225.44,225.77,226.11,226.45,226.79,227.13,227.47,227.82,228.17,228.52,228.87,229.23,229.59,229.95,230.31,230.68,231.05,231.43,231.8,232.18,232.57,232.95,233.34,233.74,234.13,234.53,234.94,235.35,235.76,236.17,236.59,237.02,237.44,237.88,238.31,238.75,239.2,239.65,240.1,240.56,241.03,241.5,241.97,242.45,242.94,243.43,243.92,244.43,},
{130.26,130.77,131.29,131.79,132.29,132.79,133.28,133.76,134.24,134.71,135.18,135.64,136.1,136.55,137.0,137.44,137.88,138.32,138.75,139.17,139.59,140.01,140.43,140.84,141.24,141.64,142.04,142.44,142.83,143.22,143.6,143.99,144.37,144.74,145.11,145.48,145.85,146.21,146.57,146.93,147.29,147.64,147.99,148.34,148.68,149.02,149.37,149.7,150.04,150.37,150.7,151.03,151.36,151.68,152.01,152.33,152.65,152.97,153.28,153.59,153.91,154.22,154.52,154.83,155.14,155.44,155.74,156.04,156.34,156.64,156.94,157.23,157.53,157.82,158.11,158.4,158.69,158.97,159.26,159.55,159.83,160.11,160.4,160.68,160.96,161.23,161.51,161.79,162.07,162.34,162.62,162.89,163.16,163.43,163.71,163.98,164.25,164.52,164.78,165.05,165.32,165.58,165.85,166.12,166.38,166.64,166.91,167.17,167.43,167.7,167.96,168.22,168.48,168.74,169.0,169.26,169.52,169.78,170.04,170.29,170.55,170.81,171.07,171.32,171.58,171.84,172.09,172.35,172.6,172.86,173.11,173.37,173.62,173.88,174.13,174.39,174.64,174.89,175.15,175.4,175.65,175.91,176.16,176.41,176.67,176.92,177.17,177.42,177.68,177.93,178.18,178.43,178.69,178.94,179.19,179.44,179.7,179.95,180.2,180.45,180.7,180.95,181.21,181.46,181.71,181.96,182.21,182.47,182.72,182.97,183.22,183.47,183.72,183.98,184.23,184.48,184.73,184.98,185.23,185.48,185.74,185.99,186.24,186.49,186.74,186.99,187.25,187.5,187.75,188.0,188.25,188.5,188.76,189.01,189.26,189.51,189.76,190.01,190.26,190.52,190.77,191.02,191.27,191.52,191.77,192.03,192.28,192.53,192.78,193.03,193.28,193.54,193.79,194.04,194.29,194.54,194.79,195.05,195.3,195.55,195.8,196.05,196.31,196.56,196.81,197.06,197.31,197.57,197.82,198.07,198.32,198.58,198.83,199.08,199.33,199.59,199.84,200.09,200.35,200.6,200.85,201.11,201.36,201.62,201.87,202.12,202.38,202.63,202.89,203.14,203.4,203.65,203.91,204.17,204.42,204.68,204.94,205.19,205.45,205.71,205.97,206.22,206.48,206.74,207.0,207.26,207.52,207.78,208.04,208.31,208.57,208.83,209.09,209.36,209.62,209.89,210.15,210.42,210.68,210.95,211.22,211.49,211.76,212.03,212.3,212.57,212.84,213.11,213.39,213.66,213.94,214.21,214.49,214.77,215.05,215.33,215.61,215.89,216.17,216.46,216.74,217.03,217.32,217.61,217.9,218.19,218.48,218.77,219.07,219.36,219.66,219.96,220.26,220.56,220.87,221.17,221.48,221.79,222.1,222.41,222.73,223.04,223.36,223.68,224.0,224.32,224.65,224.97,225.3,225.63,225.97,226.3,226.64,226.98,227.33,227.67,228.02,228.37,228.72,229.08,229.44,229.8,230.16,230.53,230.9,231.27,231.64,232.02,232.41,232.79,233.18,233.57,233.97,234.37,234.77,235.18,235.59,236.0,236.42,236.84,237.27,237.7,238.13,238.57,239.01,239.46,239.92,240.37,240.84,241.3,241.78,242.26,242.74,243.23,243.72,244.22,},
{130.46,130.98,131.49,132.0,132.49,132.99,133.47,133.96,134.43,134.9,135.37,135.83,136.29,136.74,137.18,137.62,138.06,138.5,138.92,139.35,139.77,140.19,140.6,141.01,141.41,141.81,142.21,142.6,142.99,143.38,143.77,144.15,144.52,144.9,145.27,145.64,146.0,146.37,146.72,147.08,147.44,147.79,148.14,148.48,148.83,149.17,149.51,149.84,150.18,150.51,150.84,151.17,151.5,151.82,152.14,152.46,152.78,153.1,153.41,153.72,154.03,154.34,154.65,154.96,155.26,155.56,155.87,156.17,156.46,156.76,157.06,157.35,157.64,157.93,158.22,158.51,158.8,159.09,159.37,159.66,159.94,160.22,160.5,160.78,161.06,161.34,161.62,161.89,162.17,162.44,162.72,162.99,163.26,163.53,163.8,164.07,164.34,164.61,164.88,165.14,165.41,165.68,165.94,166.21,166.47,166.73,167.0,167.26,167.52,167.78,168.04,168.3,168.56,168.82,169.08,169.34,169.6,169.85,170.11,170.37,170.63,170.88,171.14,171.39,171.65,171.91,172.16,172.42,172.67,172.92,173.18,173.43,173.69,173.94,174.19,174.45,174.7,174.95,175.2,175.46,175.71,175.96,176.21,176.47,176.72,176.97,177.22,177.47,177.72,177.97,178.23,178.48,178.73,178.98,179.23,179.48,179.73,179.98,180.23,180.49,180.74,180.99,181.24,181.49,181.74,181.99,182.24,182.49,182.74,182.99,183.24,183.49,183.74,183.99,184.24,184.5,184.75,185.0,185.25,185.5,185.75,186.0,186.25,186.5,186.75,187.0,187.25,187.5,187.75,188.0,188.25,188.5,188.75,189.0,189.25,189.5,189.75,190.0,190.26,190.51,190.76,191.01,191.26,191.51,191.76,192.01,192.26,192.51,192.76,193.01,193.26,193.51,193.76,194.01,194.26,194.51,194.77,195.02,195.27,195.52,195.77,196.02,196.27,196.52,196.77,197.02,197.27,197.53,197.78,198.03,198.28,198.53,198.78,199.03,199.29,199.54,199.79,200.04,200.29,200.55,200.8,201.05,201.3,201.56,201.81,202.06,202.32,202.57,202.82,203.08,203.33,203.59,203.84,204.1,204.35,204.61,204.86,205.12,205.38,205.63,205.89,206.15,206.41,206.66,206.92,207.18,207.44,207.7,207.96,208.22,208.48,208.75,209.01,209.27,209.53,209.8,210.06,210.33,210.59,210.86,211.13,211.39,211.66,211.93,212.2,212.47,212.74,213.01,213.29,213.56,213.84,214.11,214.39,214.66,214.94,215.22,215.5,215.78,216.06,216.35,216.63,216.92,217.2,217.49,217.78,218.07,218.36,218.66,218.95,219.25,219.54,219.84,220.14,220.44,220.75,221.05,221.36,221.66,221.97,222.28,222.6,222.91,223.23,223.55,223.87,224.19,224.51,224.84,225.17,225.5,225.83,226.16,226.5,226.84,227.18,227.53,227.87,228.22,228.57,228.93,229.29,229.65,230.01,230.37,230.74,231.11,231.49,231.87,232.25,232.63,233.02,233.41,233.8,234.2,234.6,235.01,235.42,235.83,236.25,236.67,237.09,237.52,237.95,238.39,238.83,239.28,239.73,240.19,240.65,241.11,241.59,242.06,242.54,243.03,243.52,244.02,},
{130.67,131.18,131.69,132.2,132.69,133.18,133.67,134.15,134.62,135.09,135.56,136.02,136.47,136.92,137.36,137.8,138.24,138.67,139.1,139.52,139.94,140.36,140.77,141.17,141.58,141.98,142.37,142.77,143.16,143.54,143.93,144.3,144.68,145.05,145.42,145.79,146.15,146.52,146.87,147.23,147.58,147.93,148.28,148.63,148.97,149.31,149.65,149.98,150.32,150.65,150.98,151.31,151.63,151.95,152.28,152.59,152.91,153.23,153.54,153.85,154.16,154.47,154.78,155.08,155.39,155.69,155.99,156.29,156.58,156.88,157.17,157.47,157.76,158.05,158.34,158.63,158.91,159.2,159.48,159.77,160.05,160.33,160.61,160.89,161.17,161.45,161.72,162.0,162.27,162.54,162.82,163.09,163.36,163.63,163.9,164.17,164.44,164.7,164.97,165.24,165.5,165.77,166.03,166.29,166.56,166.82,167.08,167.34,167.6,167.86,168.12,168.38,168.64,168.9,169.16,169.42,169.67,169.93,170.19,170.44,170.7,170.95,171.21,171.47,171.72,171.97,172.23,172.48,172.74,172.99,173.24,173.49,173.75,174.0,174.25,174.5,174.76,175.01,175.26,175.51,175.76,176.01,176.27,176.52,176.77,177.02,177.27,177.52,177.77,178.02,178.27,178.52,178.77,179.02,179.27,179.52,179.77,180.02,180.27,180.52,180.77,181.02,181.27,181.52,181.77,182.02,182.27,182.52,182.77,183.02,183.26,183.51,183.76,184.01,184.26,184.51,184.76,185.01,185.26,185.51,185.76,186.01,186.26,186.51,186.76,187.0,187.25,187.5,187.75,188.0,188.25,188.5,188.75,189.0,189.25,189.5,189.75,190.0,190.25,190.5,190.74,190.99,191.24,191.49,191.74,191.99,192.24,192.49,192.74,192.99,193.24,193.49,193.74,193.99,194.24,194.49,194.74,194.99,195.24,195.48,195.73,195.98,196.23,196.48,196.73,196.98,197.23,197.48,197.73,197.98,198.24,198.49,198.74,198.99,199.24,199.49,199.74,199.99,200.24,200.49,200.74,201.0,201.25,201.5,201.75,202.0,202.26,202.51,202.76,203.02,203.27,203.52,203.78,204.03,204.29,204.54,204.79,205.05,205.31,205.56,205.82,206.07,206.33,206.59,206.85,207.1,207.36,207.62,207.88,208.14,208.4,208.66,208.92,209.19,209.45,209.71,209.97,210.24,210.5,210.77,211.03,211.3,211.57,211.84,212.11,212.38,212.65,212.92,213.19,213.46,213.74,214.01,214.29,214.56,214.84,215.12,215.4,215.68,215.96,216.24,216.52,216.81,217.09,217.38,217.67,217.96,218.25,218.54,218.83,219.13,219.42,219.72,220.02,220.32,220.62,220.93,221.23,221.54,221.85,222.16,222.47,222.78,223.1,223.42,223.73,224.06,224.38,224.7,225.03,225.36,225.69,226.03,226.36,226.7,227.04,227.38,227.73,228.08,228.43,228.78,229.14,229.5,229.86,230.22,230.59,230.96,231.33,231.71,232.09,232.47,232.86,233.25,233.64,234.04,234.44,234.84,235.25,235.66,236.08,236.49,236.92,237.35,237.78,238.21,238.65,239.1,239.55,240.0,240.46,240.93,241.4,241.87,242.35,242.84,243.33,243.83,},
{130.87,131.39,131.89,132.39,132.89,133.38,133.86,134.34,134.81,135.28,135.74,136.2,136.65,137.1,137.54,137.98,138.42,138.85,139.27,139.69,140.11,140.53,140.94,141.34,141.74,142.14,142.54,142.93,143.32,143.7,144.08,144.46,144.84,145.21,145.58,145.94,146.3,146.67,147.02,147.38,147.73,148.08,148.43,148.77,149.11,149.45,149.79,150.12,150.46,150.79,151.11,151.44,151.76,152.09,152.41,152.72,153.04,153.36,153.67,153.98,154.29,154.59,154.9,155.2,155.51,155.81,156.11,156.41,156.7,157.0,157.29,157.58,157.87,158.16,158.45,158.74,159.02,159.31,159.59,159.88,160.16,160.44,160.72,161.0,161.27,161.55,161.82,162.1,162.37,162.64,162.92,163.19,163.46,163.73,164.0,164.26,164.53,164.8,165.06,165.33,165.59,165.86,166.12,166.38,166.64,166.91,167.17,167.43,167.69,167.95,168.21,168.46,168.72,168.98,169.24,169.49,169.75,170.01,170.26,170.52,170.77,171.03,171.28,171.53,171.79,172.04,172.29,172.55,172.8,173.05,173.31,173.56,173.81,174.06,174.31,174.56,174.81,175.06,175.32,175.57,175.82,176.07,176.32,176.57,176.82,177.07,177.32,177.56,177.81,178.06,178.31,178.56,178.81,179.06,179.31,179.56,179.81,180.06,180.3,180.55,180.8,181.05,181.3,181.55,181.8,182.04,182.29,182.54,182.79,183.04,183.29,183.53,183.78,184.03,184.28,184.53,184.78,185.02,185.27,185.52,185.77,186.02,186.27,186.51,186.76,187.01,187.26,187.51,187.75,188.0,188.25,188.5,188.75,189.0,189.24,189.49,189.74,189.99,190.24,190.49,190.73,190.98,191.23,191.48,191.73,191.97,192.22,192.47,192.72,192.97,193.22,193.46,193.71,193.96,194.21,194.46,194.71,194.96,195.2,195.45,195.7,195.95,196.2,196.45,196.7,196.95,197.19,197.44,197.69,197.94,198.19,198.44,198.69,198.94,199.19,199.44,199.69,199.94,200.19,200.44,200.69,200.94,201.19,201.44,201.69,201.95,202.2,202.45,202.7,202.95,203.21,203.46,203.71,203.96,204.22,204.47,204.73,204.98,205.23,205.49,205.75,206.0,206.26,206.51,206.77,207.03,207.28,207.54,207.8,208.06,208.32,208.58,208.84,209.1,209.36,209.63,209.89,210.15,210.41,210.68,210.94,211.21,211.48,211.74,212.01,212.28,212.55,212.82,213.09,213.36,213.64,213.91,214.18,214.46,214.74,215.01,215.29,215.57,215.85,216.13,216.42,216.7,216.98,217.27,217.56,217.85,218.14,218.43,218.72,219.01,219.31,219.61,219.9,220.2,220.5,220.81,221.11,221.42,221.72,222.03,222.34,222.66,222.97,223.29,223.61,223.93,224.25,224.57,224.9,225.23,225.56,225.89,226.23,226.56,226.9,227.24,227.59,227.94,228.29,228.64,228.99,229.35,229.71,230.07,230.44,230.81,231.18,231.56,231.93,232.32,232.7,233.09,233.48,233.88,234.27,234.68,235.08,235.49,235.91,236.33,236.75,237.17,237.6,238.04,238.48,238.92,239.37,239.82,240.28,240.74,241.21,241.68,242.16,242.65,243.14,243.63,},
{131.07,131.58,132.09,132.59,133.08,133.57,134.05,134.53,135.0,135.46,135.92,136.38,136.83,137.28,137.72,138.16,138.59,139.02,139.44,139.86,140.28,140.69,141.1,141.5,141.91,142.3,142.7,143.09,143.47,143.86,144.24,144.61,144.99,145.36,145.73,146.09,146.45,146.81,147.17,147.52,147.87,148.22,148.57,148.91,149.25,149.59,149.93,150.26,150.59,150.92,151.25,151.57,151.9,152.22,152.54,152.85,153.17,153.48,153.79,154.1,154.41,154.72,155.02,155.33,155.63,155.93,156.23,156.52,156.82,157.11,157.41,157.7,157.99,158.28,158.56,158.85,159.13,159.42,159.7,159.98,160.26,160.54,160.82,161.1,161.38,161.65,161.93,162.2,162.47,162.74,163.01,163.28,163.55,163.82,164.09,164.36,164.62,164.89,165.15,165.42,165.68,165.94,166.21,166.47,166.73,166.99,167.25,167.51,167.77,168.03,168.29,168.54,168.8,169.06,169.31,169.57,169.82,170.08,170.33,170.59,170.84,171.1,171.35,171.6,171.86,172.11,172.36,172.61,172.86,173.12,173.37,173.62,173.87,174.12,174.37,174.62,174.87,175.12,175.37,175.62,175.87,176.12,176.37,176.62,176.86,177.11,177.36,177.61,177.86,178.11,178.36,178.6,178.85,179.1,179.35,179.6,179.84,180.09,180.34,180.59,180.83,181.08,181.33,181.58,181.82,182.07,182.32,182.57,182.81,183.06,183.31,183.56,183.8,184.05,184.3,184.54,184.79,185.04,185.29,185.53,185.78,186.03,186.27,186.52,186.77,187.02,187.26,187.51,187.76,188.0,188.25,188.5,188.75,188.99,189.24,189.49,189.73,189.98,190.23,190.47,190.72,190.97,191.22,191.46,191.71,191.96,192.21,192.45,192.7,192.95,193.19,193.44,193.69,193.94,194.18,194.43,194.68,194.93,195.17,195.42,195.67,195.92,196.16,196.41,196.66,196.91,197.16,197.4,197.65,197.9,198.15,198.4,198.65,198.89,199.14,199.39,199.64,199.89,200.14,200.39,200.64,200.89,201.14,201.39,201.64,201.89,202.14,202.39,202.64,202.89,203.14,203.4,203.65,203.9,204.15,204.4,204.66,204.91,205.17,205.42,205.67,205.93,206.18,206.44,206.69,206.95,207.21,207.47,207.72,207.98,208.24,208.5,208.76,209.02,209.28,209.54,209.8,210.06,210.33,210.59,210.86,211.12,211.39,211.65,211.92,212.19,212.46,212.73,213.0,213.27,213.54,213.81,214.08,214.36,214.64,214.91,215.19,215.47,215.75,216.03,216.31,216.59,216.88,217.16,217.45,217.74,218.02,218.31,218.61,218.9,219.19,219.49,219.79,220.08,220.39,220.69,220.99,221.3,221.6,221.91,222.22,222.53,222.85,223.16,223.48,223.8,224.12,224.44,224.77,225.09,225.42,225.76,226.09,226.43,226.76,227.11,227.45,227.8,228.14,228.49,228.85,229.21,229.56,229.93,230.29,230.66,231.03,231.4,231.78,232.16,232.55,232.93,233.32,233.72,234.11,234.52,234.92,235.33,235.74,236.16,236.58,237.0,237.43,237.87,238.3,238.75,239.19,239.64,240.1,240.56,241.03,241.5,241.98,242.46,242.95,243.44,},
{131.27,131.78,132.28,132.78,133.27,133.76,134.24,134.71,135.18,135.64,136.1,136.56,137.01,137.45,137.89,138.33,138.76,139.19,139.61,140.03,140.44,140.86,141.26,141.67,142.07,142.46,142.85,143.24,143.63,144.01,144.39,144.77,145.14,145.51,145.87,146.24,146.6,146.96,147.31,147.66,148.01,148.36,148.71,149.05,149.39,149.73,150.06,150.39,150.72,151.05,151.38,151.7,152.03,152.35,152.66,152.98,153.29,153.61,153.92,154.23,154.53,154.84,155.14,155.45,155.75,156.05,156.34,156.64,156.93,157.23,157.52,157.81,158.1,158.39,158.67,158.96,159.24,159.53,159.81,160.09,160.37,160.65,160.92,161.2,161.48,161.75,162.03,162.3,162.57,162.84,163.11,163.38,163.65,163.92,164.18,164.45,164.71,164.98,165.24,165.51,165.77,166.03,166.29,166.55,166.81,167.07,167.33,167.59,167.85,168.11,168.37,168.62,168.88,169.13,169.39,169.64,169.9,170.15,170.41,170.66,170.91,171.17,171.42,171.67,171.92,172.17,172.43,172.68,172.93,173.18,173.43,173.68,173.93,174.18,174.43,174.68,174.93,175.17,175.42,175.67,175.92,176.17,176.42,176.66,176.91,177.16,177.41,177.66,177.9,178.15,178.4,178.64,178.89,179.14,179.39,179.63,179.88,180.13,180.37,180.62,180.87,181.11,181.36,181.61,181.85,182.1,182.34,182.59,182.84,183.08,183.33,183.58,183.82,184.07,184.31,184.56,184.81,185.05,185.3,185.54,185.79,186.04,186.28,186.53,186.77,187.02,187.27,187.51,187.76,188.0,188.25,188.5,188.74,188.99,189.23,189.48,189.73,189.97,190.22,190.46,190.71,190.96,191.2,191.45,191.7,191.94,192.19,192.43,192.68,192.93,193.17,193.42,193.66,193.91,194.16,194.4,194.65,194.9,195.14,195.39,195.64,195.88,196.13,196.38,196.62,196.87,197.12,197.36,197.61,197.86,198.11,198.35,198.6,198.85,199.1,199.34,199.59,199.84,200.09,200.34,200.59,200.83,201.08,201.33,201.58,201.83,202.08,202.33,202.58,202.83,203.08,203.33,203.58,203.84,204.09,204.34,204.59,204.84,205.1,205.35,205.6,205.86,206.11,206.37,206.62,206.88,207.13,207.39,207.64,207.9,208.16,208.42,208.68,208.94,209.2,209.46,209.72,209.98,210.24,210.5,210.77,211.03,211.3,211.56,211.83,212.1,212.36,212.63,212.9,213.17,213.44,213.71,213.99,214.26,214.54,214.81,215.09,215.37,215.64,215.92,216.2,216.49,216.77,217.05,217.34,217.63,217.91,218.2,218.49,218.79,219.08,219.37,219.67,219.97,220.27,220.57,220.87,221.18,221.48,221.79,222.1,222.41,222.72,223.04,223.35,223.67,223.99,224.31,224.64,224.96,225.29,225.62,225.96,226.29,226.63,226.97,227.31,227.66,228.0,228.35,228.71,229.06,229.42,229.78,230.15,230.51,230.88,231.25,231.63,232.01,232.39,232.78,233.17,233.56,233.96,234.36,234.76,235.17,235.58,235.99,236.41,236.84,237.26,237.7,238.13,238.57,239.02,239.47,239.92,240.38,240.85,241.32,241.79,242.27,242.76,243.25,},
{131.46,131.97,132.47,132.97,133.46,133.94,134.42,134.89,135.36,135.82,136.28,136.73,137.18,137.63,138.06,138.5,138.93,139.36,139.78,140.19,140.61,141.02,141.42,141.83,142.22,142.62,143.01,143.4,143.78,144.16,144.54,144.92,145.29,145.66,146.02,146.38,146.74,147.1,147.45,147.81,148.15,148.5,148.84,149.19,149.52,149.86,150.2,150.53,150.86,151.18,151.51,151.83,152.15,152.47,152.79,153.11,153.42,153.73,154.04,154.35,154.65,154.96,155.26,155.56,155.86,156.16,156.46,156.75,157.05,157.34,157.63,157.92,158.21,158.5,158.78,159.07,159.35,159.63,159.91,160.19,160.47,160.75,161.03,161.3,161.58,161.85,162.12,162.4,162.67,162.94,163.21,163.47,163.74,164.01,164.28,164.54,164.81,165.07,165.33,165.59,165.86,166.12,166.38,166.64,166.9,167.16,167.42,167.67,167.93,168.19,168.44,168.7,168.96,169.21,169.46,169.72,169.97,170.23,170.48,170.73,170.98,171.24,171.49,171.74,171.99,172.24,172.49,172.74,172.99,173.24,173.49,173.74,173.99,174.24,174.48,174.73,174.98,175.23,175.48,175.72,175.97,176.22,176.47,176.71,176.96,177.21,177.45,177.7,177.95,178.19,178.44,178.69,178.93,179.18,179.42,179.67,179.91,180.16,180.41,180.65,180.9,181.14,181.39,181.63,181.88,182.12,182.37,182.61,182.86,183.1,183.35,183.6,183.84,184.09,184.33,184.58,184.82,185.07,185.31,185.56,185.8,186.05,186.29,186.54,186.78,187.03,187.27,187.52,187.76,188.01,188.25,188.5,188.74,188.99,189.23,189.48,189.72,189.97,190.21,190.45,190.7,190.95,191.19,191.44,191.68,191.93,192.17,192.42,192.66,192.91,193.15,193.4,193.64,193.89,194.13,194.38,194.62,194.87,195.11,195.36,195.6,195.85,196.1,196.34,196.59,196.83,197.08,197.33,197.57,197.82,198.06,198.31,198.56,198.8,199.05,199.3,199.54,199.79,200.04,200.29,200.53,200.78,201.03,201.28,201.53,201.78,202.02,202.27,202.52,202.77,203.02,203.27,203.52,203.77,204.02,204.27,204.52,204.78,205.03,205.28,205.53,205.79,206.04,206.29,206.55,206.8,207.06,207.31,207.57,207.82,208.08,208.34,208.6,208.86,209.11,209.37,209.63,209.89,210.16,210.42,210.68,210.94,211.21,211.47,211.74,212.0,212.27,212.54,212.81,213.08,213.35,213.62,213.89,214.16,214.44,214.71,214.99,215.26,215.54,215.82,216.1,216.38,216.66,216.95,217.23,217.52,217.81,218.09,218.38,218.68,218.97,219.26,219.56,219.85,220.15,220.45,220.75,221.06,221.36,221.67,221.98,222.29,222.6,222.91,223.23,223.54,223.86,224.19,224.51,224.83,225.16,225.49,225.82,226.16,226.49,226.83,227.18,227.52,227.87,228.21,228.57,228.92,229.28,229.64,230.0,230.37,230.74,231.11,231.48,231.86,232.24,232.63,233.01,233.41,233.8,234.2,234.6,235.01,235.42,235.83,236.25,236.67,237.1,237.53,237.96,238.4,238.85,239.29,239.75,240.21,240.67,241.14,241.61,242.09,242.57,243.06,},
{131.66,132.16,132.66,133.15,133.64,134.12,134.6,135.07,135.54,136.0,136.46,136.91,137.35,137.8,138.23,138.67,139.1,139.52,139.94,140.36,140.77,141.18,141.58,141.98,142.38,142.77,143.16,143.55,143.93,144.31,144.69,145.06,145.43,145.8,146.17,146.53,146.89,147.24,147.59,147.94,148.29,148.64,148.98,149.32,149.66,149.99,150.33,150.66,150.99,151.31,151.64,151.96,152.28,152.6,152.91,153.23,153.54,153.85,154.16,154.47,154.77,155.08,155.38,155.68,155.98,156.28,156.57,156.87,157.16,157.45,157.74,158.03,158.32,158.6,158.89,159.17,159.46,159.74,160.02,160.3,160.57,160.85,161.13,161.4,161.68,161.95,162.22,162.49,162.76,163.03,163.3,163.57,163.83,164.1,164.37,164.63,164.89,165.16,165.42,165.68,165.94,166.2,166.46,166.72,166.98,167.24,167.5,167.75,168.01,168.27,168.52,168.78,169.03,169.28,169.54,169.79,170.04,170.3,170.55,170.8,171.05,171.3,171.55,171.8,172.05,172.3,172.55,172.8,173.05,173.3,173.55,173.8,174.05,174.29,174.54,174.79,175.04,175.28,175.53,175.78,176.02,176.27,176.51,176.76,177.01,177.25,177.5,177.74,177.99,178.23,178.48,178.73,178.97,179.22,179.46,179.7,179.95,180.19,180.44,180.68,180.93,181.17,181.42,181.66,181.91,182.15,182.39,182.64,182.88,183.13,183.37,183.61,183.86,184.1,184.35,184.59,184.84,185.08,185.32,185.57,185.81,186.05,186.3,186.54,186.79,187.03,187.27,187.52,187.76,188.01,188.25,188.49,188.74,188.98,189.23,189.47,189.71,189.96,190.2,190.45,190.69,190.93,191.18,191.42,191.67,191.91,192.15,192.4,192.64,192.89,193.13,193.37,193.62,193.86,194.11,194.35,194.6,194.84,195.08,195.33,195.57,195.82,196.06,196.31,196.55,196.8,197.04,197.29,197.53,197.78,198.02,198.27,198.51,198.76,199.01,199.25,199.5,199.74,199.99,200.24,200.48,200.73,200.98,201.22,201.47,201.72,201.97,202.22,202.46,202.71,202.96,203.21,203.46,203.71,203.96,204.21,204.46,204.71,204.96,205.21,205.46,205.72,205.97,206.22,206.47,206.73,206.98,207.24,207.49,207.75,208.0,208.26,208.52,208.78,209.03,209.29,209.55,209.81,210.07,210.33,210.59,210.86,211.12,211.38,211.65,211.91,212.18,212.45,212.71,212.98,213.25,213.52,213.79,214.07,214.34,214.61,214.89,215.16,215.44,215.72,216.0,216.28,216.56,216.84,217.13,217.41,217.7,217.99,218.28,218.57,218.86,219.15,219.45,219.74,220.04,220.34,220.64,220.94,221.24,221.55,221.86,222.17,222.48,222.79,223.1,223.42,223.74,224.06,224.38,224.71,225.03,225.36,225.69,226.03,226.36,226.7,227.04,227.38,227.73,228.08,228.43,228.78,229.14,229.5,229.86,230.22,230.59,230.96,231.33,231.71,232.09,232.48,232.86,233.25,233.65,234.04,234.44,234.85,235.26,235.67,236.09,236.51,236.93,237.36,237.8,238.23,238.68,239.12,239.57,240.03,240.49,240.96,241.43,241.91,242.39,242.88,},
{131.84,132.35,132.85,133.34,133.82,134.3,134.78,135.25,135.71,136.17,136.63,137.08,137.52,137.96,138.4,138.83,139.26,139.68,140.1,140.52,140.93,141.34,141.74,142.14,142.53,142.93,143.32,143.7,144.08,144.46,144.84,145.21,145.58,145.94,146.31,146.67,147.03,147.38,147.73,148.08,148.43,148.77,149.12,149.45,149.79,150.13,150.46,150.79,151.12,151.44,151.76,152.09,152.41,152.72,153.04,153.35,153.66,153.97,154.28,154.59,154.89,155.19,155.5,155.8,156.09,156.39,156.69,156.98,157.27,157.56,157.85,158.14,158.43,158.71,159.0,159.28,159.56,159.84,160.12,160.4,160.68,160.95,161.23,161.5,161.77,162.05,162.32,162.59,162.86,163.13,163.39,163.66,163.93,164.19,164.46,164.72,164.98,165.24,165.51,165.77,166.03,166.29,166.55,166.8,167.06,167.32,167.58,167.83,168.09,168.34,168.6,168.85,169.11,169.36,169.61,169.86,170.12,170.37,170.62,170.87,171.12,171.37,171.62,171.87,172.12,172.37,172.62,172.86,173.11,173.36,173.61,173.86,174.1,174.35,174.6,174.84,175.09,175.34,175.58,175.83,176.07,176.32,176.56,176.81,177.05,177.3,177.54,177.79,178.03,178.28,178.52,178.76,179.01,179.25,179.5,179.74,179.98,180.23,180.47,180.72,180.96,181.2,181.45,181.69,181.93,182.18,182.42,182.66,182.91,183.15,183.39,183.63,183.88,184.12,184.36,184.61,184.85,185.09,185.34,185.58,185.82,186.06,186.31,186.55,186.79,187.04,187.28,187.52,187.76,188.01,188.25,188.49,188.74,188.98,189.22,189.46,189.71,189.95,190.19,190.44,190.68,190.92,191.16,191.41,191.65,191.89,192.14,192.38,192.62,192.87,193.11,193.35,193.6,193.84,194.08,194.32,194.57,194.81,195.06,195.3,195.54,195.79,196.03,196.27,196.52,196.76,197.01,197.25,197.49,197.74,197.98,198.23,198.47,198.72,198.96,199.21,199.45,199.7,199.94,200.19,200.43,200.68,200.93,201.17,201.42,201.66,201.91,202.16,202.41,202.65,202.9,203.15,203.4,203.65,203.9,204.14,204.39,204.64,204.89,205.14,205.4,205.65,205.9,206.15,206.4,206.66,206.91,207.16,207.42,207.67,207.93,208.18,208.44,208.7,208.95,209.21,209.47,209.73,209.99,210.25,210.51,210.77,211.03,211.3,211.56,211.83,212.09,212.36,212.62,212.89,213.16,213.43,213.7,213.97,214.24,214.52,214.79,215.07,215.34,215.62,215.9,216.18,216.46,216.74,217.02,217.31,217.59,217.88,218.17,218.46,218.75,219.04,219.33,219.63,219.93,220.22,220.52,220.83,221.13,221.43,221.74,222.05,222.36,222.67,222.98,223.3,223.62,223.94,224.26,224.58,224.91,225.23,225.57,225.9,226.23,226.57,226.91,227.25,227.6,227.94,228.29,228.64,229.0,229.36,229.72,230.08,230.45,230.82,231.19,231.57,231.94,232.33,232.71,233.1,233.49,233.89,234.29,234.69,235.1,235.51,235.93,236.35,236.77,237.2,237.63,238.07,238.51,238.95,239.4,239.86,240.32,240.78,241.25,241.73,242.21,242.7,},
{132.03,132.53,133.03,133.52,134.0,134.48,134.96,135.42,135.89,136.35,136.8,137.25,137.69,138.13,138.57,139.0,139.42,139.84,140.26,140.68,141.08,141.49,141.89,142.29,142.69,143.08,143.46,143.85,144.23,144.61,144.98,145.35,145.72,146.09,146.45,146.81,147.16,147.52,147.87,148.22,148.56,148.91,149.25,149.59,149.92,150.26,150.59,150.92,151.24,151.57,151.89,152.21,152.53,152.84,153.16,153.47,153.78,154.09,154.4,154.7,155.01,155.31,155.61,155.91,156.21,156.5,156.8,157.09,157.38,157.67,157.96,158.25,158.53,158.82,159.1,159.38,159.66,159.94,160.22,160.5,160.78,161.05,161.33,161.6,161.87,162.14,162.41,162.68,162.95,163.22,163.49,163.75,164.02,164.28,164.54,164.81,165.07,165.33,165.59,165.85,166.11,166.37,166.63,166.89,167.14,167.4,167.66,167.91,168.17,168.42,168.67,168.93,169.18,169.43,169.68,169.94,170.19,170.44,170.69,170.94,171.19,171.44,171.69,171.93,172.18,172.43,172.68,172.93,173.17,173.42,173.67,173.91,174.16,174.41,174.65,174.9,175.14,175.39,175.63,175.88,176.12,176.37,176.61,176.85,177.1,177.34,177.59,177.83,178.07,178.32,178.56,178.8,179.05,179.29,179.53,179.78,180.02,180.26,180.5,180.75,180.99,181.23,181.47,181.72,181.96,182.2,182.44,182.69,182.93,183.17,183.41,183.65,183.9,184.14,184.38,184.62,184.86,185.11,185.35,185.59,185.83,186.07,186.31,186.56,186.8,187.04,187.28,187.52,187.77,188.01,188.25,188.49,188.73,188.97,189.22,189.46,189.7,189.94,190.18,190.43,190.67,190.91,191.15,191.39,191.64,191.88,192.12,192.36,192.6,192.85,193.09,193.33,193.57,193.81,194.06,194.3,194.54,194.78,195.03,195.27,195.51,195.75,196.0,196.24,196.48,196.73,196.97,197.21,197.46,197.7,197.94,198.19,198.43,198.67,198.92,199.16,199.41,199.65,199.89,200.14,200.38,200.63,200.87,201.12,201.36,201.61,201.86,202.1,202.35,202.6,202.84,203.09,203.34,203.59,203.83,204.08,204.33,204.58,204.83,205.08,205.33,205.58,205.83,206.08,206.33,206.58,206.84,207.09,207.34,207.6,207.85,208.11,208.36,208.62,208.87,209.13,209.39,209.65,209.91,210.17,210.43,210.69,210.95,211.21,211.47,211.74,212.0,212.27,212.53,212.8,213.07,213.34,213.61,213.88,214.15,214.42,214.69,214.97,215.24,215.52,215.8,216.08,216.36,216.64,216.92,217.2,217.49,217.77,218.06,218.35,218.64,218.93,219.22,219.52,219.81,220.11,220.41,220.71,221.01,221.32,221.62,221.93,222.24,222.55,222.86,223.18,223.5,223.81,224.13,224.46,224.78,225.11,225.44,225.77,226.1,226.44,226.78,227.12,227.46,227.81,228.16,228.51,228.86,229.22,229.58,229.94,230.31,230.68,231.05,231.42,231.8,232.18,232.57,232.95,233.34,233.74,234.14,234.54,234.95,235.36,235.77,236.19,236.61,237.04,237.47,237.9,238.34,238.79,239.24,239.69,240.15,240.61,241.08,241.56,242.03,242.52,},
{132.21,132.71,133.21,133.7,134.18,134.66,135.13,135.6,136.06,136.51,136.97,137.41,137.86,138.29,138.73,139.16,139.58,140.0,140.42,140.83,141.24,141.64,142.04,142.44,142.84,143.23,143.61,144.0,144.38,144.75,145.12,145.5,145.86,146.23,146.59,146.95,147.3,147.65,148.0,148.35,148.7,149.04,149.38,149.72,150.05,150.38,150.71,151.04,151.37,151.69,152.01,152.33,152.65,152.97,153.28,153.59,153.9,154.21,154.52,154.82,155.12,155.42,155.72,156.02,156.32,156.61,156.91,157.2,157.49,157.78,158.07,158.35,158.64,158.92,159.2,159.48,159.76,160.04,160.32,160.6,160.87,161.15,161.42,161.69,161.97,162.24,162.51,162.78,163.04,163.31,163.58,163.84,164.11,164.37,164.63,164.89,165.16,165.42,165.68,165.94,166.19,166.45,166.71,166.97,167.22,167.48,167.73,167.99,168.24,168.5,168.75,169.0,169.25,169.5,169.76,170.01,170.26,170.51,170.76,171.0,171.25,171.5,171.75,172.0,172.25,172.49,172.74,172.99,173.23,173.48,173.72,173.97,174.22,174.46,174.71,174.95,175.19,175.44,175.68,175.93,176.17,176.41,176.66,176.9,177.14,177.39,177.63,177.87,178.11,178.36,178.6,178.84,179.08,179.33,179.57,179.81,180.05,180.29,180.54,180.78,181.02,181.26,181.5,181.74,181.98,182.23,182.47,182.71,182.95,183.19,183.43,183.67,183.91,184.15,184.4,184.64,184.88,185.12,185.36,185.6,185.84,186.08,186.32,186.56,186.8,187.05,187.29,187.53,187.77,188.01,188.25,188.49,188.73,188.97,189.21,189.45,189.69,189.93,190.18,190.42,190.66,190.9,191.14,191.38,191.62,191.86,192.1,192.34,192.59,192.83,193.07,193.31,193.55,193.79,194.03,194.27,194.52,194.76,195.0,195.24,195.48,195.72,195.96,196.21,196.45,196.69,196.93,197.18,197.42,197.66,197.9,198.14,198.39,198.63,198.87,199.12,199.36,199.6,199.85,200.09,200.33,200.58,200.82,201.07,201.31,201.56,201.8,202.05,202.29,202.54,202.79,203.03,203.28,203.53,203.77,204.02,204.27,204.52,204.76,205.01,205.26,205.51,205.76,206.01,206.26,206.51,206.77,207.02,207.27,207.52,207.78,208.03,208.29,208.54,208.8,209.05,209.31,209.57,209.83,210.08,210.34,210.6,210.86,211.13,211.39,211.65,211.91,212.18,212.44,212.71,212.98,213.25,213.51,213.78,214.05,214.33,214.6,214.87,215.15,215.42,215.7,215.98,216.26,216.54,216.82,217.1,217.39,217.67,217.96,218.24,218.53,218.82,219.12,219.41,219.71,220.0,220.3,220.6,220.9,221.2,221.51,221.82,222.12,222.43,222.75,223.06,223.38,223.69,224.01,224.33,224.66,224.98,225.31,225.64,225.98,226.31,226.65,226.99,227.33,227.68,228.02,228.37,228.73,229.08,229.44,229.8,230.17,230.54,230.91,231.28,231.66,232.04,232.42,232.81,233.2,233.59,233.99,234.39,234.79,235.2,235.62,236.03,236.45,236.88,237.31,237.74,238.18,238.62,239.07,239.52,239.98,240.44,240.91,241.38,241.86,242.34,},
{132.39,132.89,133.38,133.87,134.35,134.83,135.3,135.77,136.23,136.68,137.13,137.58,138.02,138.46,138.89,139.32,139.74,140.16,140.57,140.98,141.39,141.8,142.19,142.59,142.98,143.37,143.76,144.14,144.52,144.89,145.27,145.64,146.0,146.36,146.72,147.08,147.44,147.79,148.14,148.48,148.83,149.17,149.51,149.84,150.18,150.51,150.84,151.17,151.49,151.81,152.14,152.45,152.77,153.09,153.4,153.71,154.02,154.33,154.63,154.93,155.24,155.54,155.84,156.13,156.43,156.72,157.01,157.31,157.6,157.88,158.17,158.46,158.74,159.02,159.31,159.59,159.87,160.14,160.42,160.7,160.97,161.25,161.52,161.79,162.06,162.33,162.6,162.87,163.13,163.4,163.67,163.93,164.19,164.46,164.72,164.98,165.24,165.5,165.76,166.02,166.28,166.53,166.79,167.05,167.3,167.56,167.81,168.06,168.32,168.57,168.82,169.07,169.32,169.58,169.83,170.08,170.33,170.57,170.82,171.07,171.32,171.57,171.81,172.06,172.31,172.55,172.8,173.05,173.29,173.54,173.78,174.03,174.27,174.51,174.76,175.0,175.25,175.49,175.73,175.98,176.22,176.46,176.7,176.95,177.19,177.43,177.67,177.91,178.16,178.4,178.64,178.88,179.12,179.36,179.6,179.84,180.09,180.33,180.57,180.81,181.05,181.29,181.53,181.77,182.01,182.25,182.49,182.73,182.97,183.21,183.45,183.69,183.93,184.17,184.41,184.65,184.89,185.13,185.37,185.61,185.85,186.09,186.33,186.57,186.81,187.05,187.29,187.53,187.77,188.01,188.25,188.49,188.73,188.97,189.21,189.45,189.69,189.93,190.17,190.41,190.65,190.89,191.13,191.37,191.61,191.85,192.09,192.33,192.57,192.81,193.05,193.29,193.53,193.77,194.01,194.25,194.49,194.73,194.97,195.21,195.45,195.69,195.93,196.17,196.42,196.66,196.9,197.14,197.38,197.62,197.86,198.1,198.35,198.59,198.83,199.07,199.32,199.56,199.8,200.04,200.29,200.53,200.77,201.02,201.26,201.5,201.75,201.99,202.24,202.48,202.73,202.97,203.22,203.47,203.71,203.96,204.21,204.45,204.7,204.95,205.2,205.45,205.69,205.94,206.19,206.44,206.7,206.95,207.2,207.45,207.7,207.96,208.21,208.46,208.72,208.98,209.23,209.49,209.75,210.0,210.26,210.52,210.78,211.04,211.3,211.57,211.83,212.09,212.36,212.62,212.89,213.16,213.42,213.69,213.96,214.23,214.5,214.78,215.05,215.33,215.6,215.88,216.16,216.44,216.72,217.0,217.28,217.57,217.85,218.14,218.43,218.72,219.01,219.3,219.6,219.89,220.19,220.49,220.79,221.09,221.4,221.7,222.01,222.32,222.63,222.94,223.26,223.57,223.89,224.21,224.54,224.86,225.19,225.52,225.85,226.19,226.52,226.86,227.2,227.55,227.89,228.24,228.59,228.95,229.31,229.67,230.03,230.4,230.77,231.14,231.51,231.89,232.28,232.66,233.05,233.44,233.84,234.24,234.64,235.05,235.46,235.88,236.3,236.72,237.15,237.58,238.02,238.46,238.91,239.36,239.81,240.27,240.74,241.21,241.69,242.17,},
{132.57,133.07,133.56,134.04,134.52,135.0,135.47,135.93,136.39,136.85,137.29,137.74,138.18,138.61,139.05,139.47,139.89,140.31,140.73,141.14,141.54,141.94,142.34,142.74,143.13,143.52,143.9,144.28,144.66,145.03,145.41,145.77,146.14,146.5,146.86,147.22,147.57,147.92,148.27,148.61,148.96,149.3,149.64,149.97,150.3,150.63,150.96,151.29,151.61,151.94,152.26,152.57,152.89,153.2,153.51,153.82,154.13,154.44,154.74,155.05,155.35,155.65,155.95,156.24,156.54,156.83,157.12,157.41,157.7,157.99,158.27,158.56,158.84,159.13,159.41,159.69,159.96,160.24,160.52,160.79,161.07,161.34,161.61,161.88,162.15,162.42,162.69,162.96,163.22,163.49,163.75,164.02,164.28,164.54,164.8,165.06,165.32,165.58,165.84,166.1,166.36,166.61,166.87,167.12,167.38,167.63,167.89,168.14,168.39,168.64,168.89,169.15,169.4,169.65,169.9,170.14,170.39,170.64,170.89,171.14,171.38,171.63,171.88,172.12,172.37,172.61,172.86,173.1,173.35,173.59,173.84,174.08,174.32,174.57,174.81,175.05,175.3,175.54,175.78,176.02,176.27,176.51,176.75,176.99,177.23,177.47,177.71,177.96,178.2,178.44,178.68,178.92,179.16,179.4,179.64,179.88,180.12,180.36,180.6,180.84,181.08,181.32,181.56,181.8,182.04,182.27,182.51,182.75,182.99,183.23,183.47,183.71,183.95,184.19,184.43,184.67,184.9,185.14,185.38,185.62,185.86,186.1,186.34,186.58,186.82,187.05,187.29,187.53,187.77,188.01,188.25,188.49,188.73,188.97,189.2,189.44,189.68,189.92,190.16,190.4,190.64,190.88,191.12,191.35,191.59,191.83,192.07,192.31,192.55,192.79,193.03,193.27,193.51,193.75,193.98,194.22,194.46,194.7,194.94,195.18,195.42,195.66,195.9,196.14,196.38,196.62,196.86,197.1,197.34,197.58,197.82,198.07,198.31,198.55,198.79,199.03,199.27,199.51,199.75,200.0,200.24,200.48,200.72,200.97,201.21,201.45,201.7,201.94,202.18,202.43,202.67,202.92,203.16,203.41,203.65,203.9,204.14,204.39,204.64,204.88,205.13,205.38,205.63,205.88,206.13,206.38,206.63,206.88,207.13,207.38,207.63,207.88,208.14,208.39,208.64,208.9,209.15,209.41,209.67,209.92,210.18,210.44,210.7,210.96,211.22,211.48,211.74,212.01,212.27,212.53,212.8,213.07,213.33,213.6,213.87,214.14,214.41,214.68,214.96,215.23,215.51,215.78,216.06,216.34,216.62,216.9,217.18,217.47,217.75,218.04,218.33,218.61,218.9,219.2,219.49,219.78,220.08,220.38,220.68,220.98,221.28,221.59,221.9,222.2,222.51,222.83,223.14,223.46,223.77,224.09,224.42,224.74,225.07,225.4,225.73,226.06,226.4,226.73,227.07,227.42,227.76,228.11,228.46,228.82,229.17,229.53,229.9,230.26,230.63,231.0,231.38,231.75,232.13,232.52,232.91,233.3,233.69,234.09,234.5,234.9,235.31,235.73,236.14,236.57,236.99,237.43,237.86,238.3,238.75,239.2,239.65,240.11,240.57,241.04,241.52,242.0,},
{132.75,133.24,133.73,134.22,134.69,135.17,135.63,136.1,136.56,137.01,137.46,137.9,138.34,138.77,139.2,139.63,140.05,140.46,140.88,141.29,141.69,142.09,142.49,142.88,143.27,143.66,144.04,144.42,144.8,145.17,145.54,145.91,146.27,146.63,146.99,147.35,147.7,148.05,148.4,148.74,149.08,149.42,149.76,150.1,150.43,150.76,151.09,151.41,151.73,152.06,152.37,152.69,153.01,153.32,153.63,153.94,154.25,154.55,154.86,155.16,155.46,155.76,156.05,156.35,156.64,156.94,157.23,157.52,157.81,158.09,158.38,158.66,158.94,159.23,159.51,159.78,160.06,160.34,160.61,160.89,161.16,161.43,161.71,161.98,162.25,162.51,162.78,163.05,163.31,163.58,163.84,164.1,164.37,164.63,164.89,165.15,165.41,165.67,165.92,166.18,166.44,166.69,166.95,167.2,167.46,167.71,167.96,168.21,168.46,168.72,168.97,169.22,169.47,169.72,169.96,170.21,170.46,170.71,170.95,171.2,171.45,171.69,171.94,172.18,172.43,172.67,172.92,173.16,173.41,173.65,173.89,174.14,174.38,174.62,174.86,175.11,175.35,175.59,175.83,176.07,176.31,176.55,176.79,177.04,177.28,177.52,177.76,178.0,178.24,178.48,178.72,178.95,179.19,179.43,179.67,179.91,180.15,180.39,180.63,180.87,181.11,181.34,181.58,181.82,182.06,182.3,182.54,182.78,183.01,183.25,183.49,183.73,183.97,184.2,184.44,184.68,184.92,185.16,185.39,185.63,185.87,186.11,186.35,186.58,186.82,187.06,187.3,187.54,187.77,188.01,188.25,188.49,188.72,188.96,189.2,189.44,189.68,189.91,190.15,190.39,190.63,190.87,191.1,191.34,191.58,191.82,192.06,192.29,192.53,192.77,193.01,193.25,193.48,193.72,193.96,194.2,194.44,194.68,194.92,195.15,195.39,195.63,195.87,196.11,196.35,196.59,196.83,197.07,197.31,197.55,197.79,198.03,198.27,198.51,198.75,198.99,199.23,199.47,199.71,199.95,200.19,200.43,200.67,200.92,201.16,201.4,201.64,201.89,202.13,202.37,202.62,202.86,203.1,203.35,203.59,203.84,204.08,204.33,204.57,204.82,205.07,205.32,205.56,205.81,206.06,206.31,206.56,206.81,207.06,207.31,207.56,207.81,208.06,208.32,208.57,208.82,209.08,209.33,209.59,209.84,210.1,210.36,210.62,210.88,211.14,211.4,211.66,211.92,212.18,212.45,212.71,212.98,213.24,213.51,213.78,214.05,214.32,214.59,214.86,215.14,215.41,215.69,215.96,216.24,216.52,216.8,217.08,217.37,217.65,217.94,218.22,218.51,218.8,219.09,219.38,219.68,219.97,220.27,220.57,220.87,221.17,221.48,221.78,222.09,222.4,222.71,223.02,223.34,223.66,223.98,224.3,224.62,224.95,225.27,225.6,225.94,226.27,226.61,226.95,227.29,227.64,227.98,228.33,228.69,229.04,229.4,229.76,230.13,230.49,230.86,231.24,231.61,231.99,232.38,232.77,233.16,233.55,233.95,234.35,234.75,235.16,235.58,235.99,236.42,236.84,237.27,237.71,238.14,238.59,239.04,239.49,239.95,240.41,240.88,241.35,241.83,},
{132.92,133.41,133.9,134.38,134.86,135.33,135.8,136.26,136.72,137.17,137.61,138.06,138.49,138.93,139.35,139.78,140.2,140.61,141.03,141.43,141.84,142.24,142.63,143.03,143.41,143.8,144.18,144.56,144.94,145.31,145.68,146.04,146.41,146.77,147.12,147.48,147.83,148.18,148.53,148.87,149.21,149.55,149.89,150.22,150.55,150.88,151.21,151.53,151.85,152.17,152.49,152.81,153.12,153.43,153.74,154.05,154.36,154.66,154.97,155.27,155.57,155.87,156.16,156.46,156.75,157.04,157.33,157.62,157.91,158.19,158.48,158.76,159.04,159.32,159.6,159.88,160.16,160.44,160.71,160.98,161.26,161.53,161.8,162.07,162.34,162.6,162.87,163.14,163.4,163.66,163.93,164.19,164.45,164.71,164.97,165.23,165.49,165.75,166.0,166.26,166.51,166.77,167.02,167.28,167.53,167.78,168.04,168.29,168.54,168.79,169.04,169.29,169.54,169.78,170.03,170.28,170.53,170.77,171.02,171.27,171.51,171.76,172.0,172.25,172.49,172.73,172.98,173.22,173.46,173.71,173.95,174.19,174.43,174.67,174.92,175.16,175.4,175.64,175.88,176.12,176.36,176.6,176.84,177.08,177.32,177.56,177.8,178.04,178.27,178.51,178.75,178.99,179.23,179.47,179.71,179.94,180.18,180.42,180.66,180.9,181.13,181.37,181.61,181.85,182.08,182.32,182.56,182.8,183.03,183.27,183.51,183.75,183.98,184.22,184.46,184.69,184.93,185.17,185.41,185.64,185.88,186.12,186.35,186.59,186.83,187.06,187.3,187.54,187.77,188.01,188.25,188.49,188.72,188.96,189.2,189.43,189.67,189.91,190.14,190.38,190.62,190.85,191.09,191.33,191.57,191.8,192.04,192.28,192.51,192.75,192.99,193.23,193.46,193.7,193.94,194.18,194.41,194.65,194.89,195.13,195.36,195.6,195.84,196.08,196.32,196.56,196.79,197.03,197.27,197.51,197.75,197.99,198.23,198.47,198.71,198.94,199.18,199.42,199.66,199.9,200.15,200.39,200.63,200.87,201.11,201.35,201.59,201.83,202.08,202.32,202.56,202.8,203.05,203.29,203.53,203.78,204.02,204.27,204.51,204.76,205.0,205.25,205.5,205.75,205.99,206.24,206.49,206.74,206.99,207.24,207.49,207.74,207.99,208.24,208.49,208.75,209.0,209.26,209.51,209.77,210.02,210.28,210.54,210.8,211.05,211.31,211.58,211.84,212.1,212.36,212.63,212.89,213.16,213.42,213.69,213.96,214.23,214.5,214.77,215.04,215.32,215.59,215.87,216.15,216.42,216.7,216.99,217.27,217.55,217.84,218.12,218.41,218.7,218.99,219.28,219.57,219.87,220.17,220.46,220.76,221.06,221.37,221.67,221.98,222.29,222.6,222.91,223.23,223.54,223.86,224.18,224.5,224.83,225.16,225.48,225.82,226.15,226.49,226.83,227.17,227.51,227.86,228.21,228.56,228.91,229.27,229.63,229.99,230.36,230.73,231.1,231.48,231.86,232.24,232.63,233.02,233.41,233.8,234.2,234.61,235.02,235.43,235.85,236.27,236.69,237.12,237.55,237.99,238.43,238.88,239.33,239.79,240.25,240.71,241.19,241.66,},
{133.09,133.58,134.07,134.55,135.03,135.5,135.96,136.42,136.88,137.33,137.77,138.21,138.65,139.08,139.51,139.93,140.35,140.76,141.17,141.58,141.98,142.38,142.77,143.17,143.55,143.94,144.32,144.7,145.07,145.44,145.81,146.18,146.54,146.9,147.25,147.61,147.96,148.31,148.65,148.99,149.33,149.67,150.01,150.34,150.67,151.0,151.33,151.65,151.97,152.29,152.61,152.92,153.24,153.55,153.86,154.16,154.47,154.77,155.08,155.38,155.68,155.97,156.27,156.56,156.85,157.15,157.44,157.72,158.01,158.29,158.58,158.86,159.14,159.42,159.7,159.98,160.25,160.53,160.8,161.08,161.35,161.62,161.89,162.16,162.43,162.69,162.96,163.22,163.49,163.75,164.01,164.27,164.53,164.79,165.05,165.31,165.57,165.83,166.08,166.34,166.59,166.85,167.1,167.35,167.61,167.86,168.11,168.36,168.61,168.86,169.11,169.36,169.6,169.85,170.1,170.35,170.59,170.84,171.08,171.33,171.57,171.82,172.06,172.31,172.55,172.79,173.03,173.28,173.52,173.76,174.0,174.24,174.48,174.73,174.97,175.21,175.45,175.69,175.93,176.17,176.4,176.64,176.88,177.12,177.36,177.6,177.84,178.08,178.31,178.55,178.79,179.03,179.26,179.5,179.74,179.98,180.21,180.45,180.69,180.93,181.16,181.4,181.64,181.87,182.11,182.35,182.58,182.82,183.05,183.29,183.53,183.76,184.0,184.24,184.47,184.71,184.94,185.18,185.42,185.65,185.89,186.12,186.36,186.6,186.83,187.07,187.3,187.54,187.78,188.01,188.25,188.48,188.72,188.96,189.19,189.43,189.66,189.9,190.14,190.37,190.61,190.84,191.08,191.32,191.55,191.79,192.02,192.26,192.5,192.73,192.97,193.21,193.44,193.68,193.92,194.15,194.39,194.63,194.86,195.1,195.34,195.57,195.81,196.05,196.28,196.52,196.76,197.0,197.24,197.47,197.71,197.95,198.19,198.43,198.66,198.9,199.14,199.38,199.62,199.86,200.1,200.34,200.58,200.82,201.06,201.3,201.54,201.78,202.02,202.26,202.51,202.75,202.99,203.23,203.48,203.72,203.96,204.21,204.45,204.7,204.94,205.19,205.43,205.68,205.93,206.17,206.42,206.67,206.92,207.17,207.42,207.67,207.92,208.17,208.42,208.67,208.93,209.18,209.43,209.69,209.95,210.2,210.46,210.72,210.97,211.23,211.49,211.75,212.02,212.28,212.54,212.81,213.07,213.34,213.6,213.87,214.14,214.41,214.68,214.95,215.23,215.5,215.78,216.05,216.33,216.61,216.89,217.17,217.45,217.74,218.02,218.31,218.6,218.89,219.18,219.47,219.76,220.06,220.36,220.66,220.96,221.26,221.56,221.87,222.18,222.49,222.8,223.11,223.43,223.75,224.07,224.39,224.71,225.04,225.37,225.7,226.03,226.36,226.7,227.04,227.39,227.73,228.08,228.43,228.78,229.14,229.5,229.86,230.23,230.6,230.97,231.34,231.72,232.1,232.49,232.88,233.27,233.66,234.06,234.47,234.87,235.28,235.7,236.12,236.54,236.97,237.4,237.84,238.28,238.72,239.17,239.63,240.09,240.55,241.02,241.5,},
{133.26,133.75,134.23,134.71,135.19,135.66,136.12,136.58,137.03,137.48,137.92,138.36,138.8,139.23,139.65,140.08,140.49,140.91,141.32,141.72,142.12,142.52,142.92,143.31,143.69,144.08,144.46,144.83,145.21,145.58,145.94,146.31,146.67,147.03,147.38,147.74,148.08,148.43,148.78,149.12,149.46,149.79,150.13,150.46,150.79,151.12,151.44,151.77,152.09,152.4,152.72,153.04,153.35,153.66,153.97,154.27,154.58,154.88,155.18,155.48,155.78,156.08,156.37,156.67,156.96,157.25,157.54,157.82,158.11,158.39,158.68,158.96,159.24,159.52,159.8,160.07,160.35,160.62,160.9,161.17,161.44,161.71,161.98,162.25,162.51,162.78,163.05,163.31,163.57,163.84,164.1,164.36,164.62,164.88,165.13,165.39,165.65,165.91,166.16,166.42,166.67,166.92,167.18,167.43,167.68,167.93,168.18,168.43,168.68,168.93,169.18,169.42,169.67,169.92,170.17,170.41,170.66,170.9,171.15,171.39,171.63,171.88,172.12,172.36,172.61,172.85,173.09,173.33,173.57,173.81,174.06,174.3,174.54,174.78,175.02,175.26,175.49,175.73,175.97,176.21,176.45,176.69,176.93,177.16,177.4,177.64,177.88,178.11,178.35,178.59,178.83,179.06,179.3,179.54,179.77,180.01,180.25,180.48,180.72,180.95,181.19,181.43,181.66,181.9,182.13,182.37,182.6,182.84,183.08,183.31,183.55,183.78,184.02,184.25,184.49,184.72,184.96,185.19,185.43,185.66,185.9,186.13,186.37,186.6,186.84,187.07,187.31,187.54,187.78,188.01,188.25,188.48,188.72,188.95,189.19,189.42,189.66,189.89,190.13,190.36,190.6,190.83,191.07,191.3,191.54,191.77,192.01,192.24,192.48,192.72,192.95,193.19,193.42,193.66,193.89,194.13,194.36,194.6,194.84,195.07,195.31,195.54,195.78,196.02,196.25,196.49,196.73,196.96,197.2,197.44,197.67,197.91,198.15,198.39,198.62,198.86,199.1,199.34,199.58,199.82,200.05,200.29,200.53,200.77,201.01,201.25,201.49,201.73,201.97,202.21,202.45,202.69,202.94,203.18,203.42,203.66,203.91,204.15,204.39,204.64,204.88,205.13,205.37,205.62,205.86,206.11,206.36,206.6,206.85,207.1,207.35,207.6,207.85,208.1,208.35,208.6,208.85,209.11,209.36,209.61,209.87,210.12,210.38,210.64,210.89,211.15,211.41,211.67,211.93,212.19,212.46,212.72,212.99,213.25,213.52,213.78,214.05,214.32,214.59,214.86,215.13,215.41,215.68,215.96,216.24,216.51,216.79,217.07,217.36,217.64,217.92,218.21,218.5,218.79,219.08,219.37,219.66,219.96,220.25,220.55,220.85,221.15,221.46,221.76,222.07,222.38,222.69,223.0,223.32,223.63,223.95,224.27,224.6,224.92,225.25,225.58,225.91,226.24,226.58,226.92,227.26,227.61,227.96,228.31,228.66,229.01,229.37,229.73,230.1,230.47,230.84,231.21,231.59,231.97,232.35,232.74,233.13,233.52,233.92,234.32,234.73,235.14,235.55,235.97,236.39,236.82,237.25,237.69,238.13,238.57,239.02,239.47,239.93,240.4,240.86,241.34,},
{133.42,133.91,134.4,134.87,135.35,135.81,136.28,136.73,137.19,137.63,138.08,138.51,138.95,139.38,139.8,140.22,140.64,141.05,141.46,141.86,142.26,142.66,143.05,143.44,143.83,144.21,144.59,144.97,145.34,145.71,146.07,146.44,146.8,147.15,147.51,147.86,148.21,148.56,148.9,149.24,149.58,149.91,150.25,150.58,150.91,151.23,151.56,151.88,152.2,152.52,152.83,153.15,153.46,153.77,154.08,154.38,154.69,154.99,155.29,155.59,155.89,156.18,156.48,156.77,157.06,157.35,157.64,157.92,158.21,158.49,158.77,159.06,159.34,159.61,159.89,160.17,160.44,160.72,160.99,161.26,161.53,161.8,162.07,162.34,162.6,162.87,163.13,163.39,163.66,163.92,164.18,164.44,164.7,164.96,165.21,165.47,165.73,165.98,166.24,166.49,166.75,167.0,167.25,167.5,167.75,168.0,168.25,168.5,168.75,169.0,169.25,169.49,169.74,169.98,170.23,170.48,170.72,170.96,171.21,171.45,171.7,171.94,172.18,172.42,172.66,172.91,173.15,173.39,173.63,173.87,174.11,174.35,174.59,174.83,175.07,175.3,175.54,175.78,176.02,176.26,176.49,176.73,176.97,177.21,177.44,177.68,177.92,178.15,178.39,178.63,178.86,179.1,179.33,179.57,179.81,180.04,180.28,180.51,180.75,180.98,181.22,181.45,181.69,181.92,182.16,182.39,182.63,182.86,183.1,183.33,183.56,183.8,184.03,184.27,184.5,184.74,184.97,185.2,185.44,185.67,185.91,186.14,186.38,186.61,186.84,187.08,187.31,187.55,187.78,188.01,188.25,188.48,188.72,188.95,189.18,189.42,189.65,189.89,190.12,190.35,190.59,190.82,191.06,191.29,191.53,191.76,191.99,192.23,192.46,192.7,192.93,193.17,193.4,193.64,193.87,194.11,194.34,194.58,194.81,195.05,195.28,195.52,195.75,195.99,196.22,196.46,196.69,196.93,197.17,197.4,197.64,197.87,198.11,198.35,198.58,198.82,199.06,199.3,199.53,199.77,200.01,200.25,200.49,200.72,200.96,201.2,201.44,201.68,201.92,202.16,202.4,202.64,202.88,203.12,203.36,203.61,203.85,204.09,204.33,204.58,204.82,205.06,205.31,205.55,205.8,206.04,206.29,206.54,206.78,207.03,207.28,207.53,207.78,208.03,208.28,208.53,208.78,209.03,209.29,209.54,209.79,210.05,210.3,210.56,210.82,211.07,211.33,211.59,211.85,212.11,212.37,212.64,212.9,213.17,213.43,213.7,213.96,214.23,214.5,214.77,215.04,215.32,215.59,215.87,216.14,216.42,216.7,216.98,217.26,217.54,217.83,218.11,218.4,218.69,218.98,219.27,219.56,219.85,220.15,220.45,220.75,221.05,221.35,221.65,221.96,222.27,222.58,222.89,223.2,223.52,223.84,224.16,224.48,224.81,225.13,225.46,225.79,226.13,226.46,226.8,227.14,227.49,227.83,228.18,228.53,228.89,229.25,229.61,229.97,230.34,230.71,231.08,231.46,231.83,232.22,232.6,232.99,233.39,233.78,234.19,234.59,235.0,235.41,235.83,236.25,236.67,237.1,237.54,237.98,238.42,238.87,239.32,239.78,240.24,240.71,241.18,},
{133.59,134.07,134.56,135.03,135.5,135.97,136.43,136.89,137.34,137.78,138.23,138.66,139.09,139.52,139.95,140.37,140.78,141.19,141.6,142.0,142.4,142.8,143.19,143.58,143.96,144.34,144.72,145.1,145.47,145.84,146.2,146.56,146.92,147.28,147.63,147.98,148.33,148.68,149.02,149.36,149.7,150.03,150.37,150.7,151.02,151.35,151.67,151.99,152.31,152.63,152.95,153.26,153.57,153.88,154.19,154.49,154.79,155.1,155.4,155.69,155.99,156.29,156.58,156.87,157.16,157.45,157.74,158.02,158.31,158.59,158.87,159.15,159.43,159.71,159.98,160.26,160.53,160.81,161.08,161.35,161.62,161.89,162.16,162.42,162.69,162.95,163.22,163.48,163.74,164.0,164.26,164.52,164.78,165.04,165.29,165.55,165.81,166.06,166.31,166.57,166.82,167.07,167.32,167.57,167.82,168.07,168.32,168.57,168.82,169.07,169.31,169.56,169.8,170.05,170.29,170.54,170.78,171.03,171.27,171.51,171.76,172.0,172.24,172.48,172.72,172.96,173.2,173.44,173.68,173.92,174.16,174.4,174.64,174.88,175.11,175.35,175.59,175.83,176.06,176.3,176.54,176.78,177.01,177.25,177.48,177.72,177.96,178.19,178.43,178.66,178.9,179.13,179.37,179.6,179.84,180.07,180.31,180.54,180.78,181.01,181.24,181.48,181.71,181.95,182.18,182.41,182.65,182.88,183.12,183.35,183.58,183.82,184.05,184.28,184.52,184.75,184.98,185.22,185.45,185.68,185.92,186.15,186.38,186.62,186.85,187.08,187.31,187.55,187.78,188.01,188.25,188.48,188.71,188.95,189.18,189.41,189.65,189.88,190.11,190.35,190.58,190.81,191.05,191.28,191.51,191.75,191.98,192.21,192.45,192.68,192.91,193.15,193.38,193.62,193.85,194.08,194.32,194.55,194.79,195.02,195.25,195.49,195.72,195.96,196.19,196.43,196.66,196.9,197.13,197.37,197.6,197.84,198.07,198.31,198.55,198.78,199.02,199.25,199.49,199.73,199.96,200.2,200.44,200.68,200.92,201.15,201.39,201.63,201.87,202.11,202.35,202.59,202.83,203.07,203.31,203.55,203.79,204.03,204.28,204.52,204.76,205.0,205.25,205.49,205.74,205.98,206.23,206.47,206.72,206.97,207.21,207.46,207.71,207.96,208.21,208.46,208.71,208.96,209.21,209.46,209.72,209.97,210.23,210.48,210.74,211.0,211.25,211.51,211.77,212.03,212.29,212.55,212.82,213.08,213.35,213.61,213.88,214.15,214.42,214.68,214.96,215.23,215.5,215.78,216.05,216.33,216.61,216.88,217.17,217.45,217.73,218.01,218.3,218.59,218.88,219.17,219.46,219.75,220.05,220.34,220.64,220.94,221.25,221.55,221.85,222.16,222.47,222.78,223.1,223.41,223.73,224.05,224.37,224.69,225.02,225.35,225.68,226.01,226.35,226.68,227.02,227.37,227.71,228.06,228.41,228.77,229.12,229.48,229.84,230.21,230.58,230.95,231.33,231.7,232.09,232.47,232.86,233.25,233.65,234.05,234.45,234.86,235.27,235.69,236.11,236.53,236.96,237.39,237.83,238.27,238.72,239.17,239.62,240.09,240.55,241.02,},
{133.75,134.23,134.71,135.19,135.66,136.12,136.58,137.04,137.49,137.93,138.37,138.81,139.24,139.67,140.09,140.51,140.92,141.33,141.74,142.14,142.54,142.93,143.32,143.71,144.09,144.48,144.85,145.23,145.6,145.96,146.33,146.69,147.05,147.4,147.76,148.11,148.45,148.8,149.14,149.48,149.82,150.15,150.48,150.81,151.14,151.46,151.79,152.11,152.42,152.74,153.05,153.37,153.68,153.99,154.29,154.6,154.9,155.2,155.5,155.8,156.09,156.39,156.68,156.97,157.26,157.55,157.83,158.12,158.4,158.69,158.97,159.25,159.52,159.8,160.08,160.35,160.63,160.9,161.17,161.44,161.71,161.98,162.24,162.51,162.77,163.04,163.3,163.56,163.82,164.08,164.34,164.6,164.86,165.12,165.37,165.63,165.88,166.14,166.39,166.64,166.89,167.14,167.4,167.65,167.89,168.14,168.39,168.64,168.89,169.13,169.38,169.62,169.87,170.11,170.36,170.6,170.85,171.09,171.33,171.57,171.81,172.06,172.3,172.54,172.78,173.02,173.26,173.5,173.73,173.97,174.21,174.45,174.69,174.93,175.16,175.4,175.64,175.87,176.11,176.35,176.58,176.82,177.05,177.29,177.52,177.76,177.99,178.23,178.46,178.7,178.93,179.17,179.4,179.64,179.87,180.1,180.34,180.57,180.8,181.04,181.27,181.5,181.74,181.97,182.2,182.44,182.67,182.9,183.13,183.37,183.6,183.83,184.07,184.3,184.53,184.76,185.0,185.23,185.46,185.69,185.92,186.16,186.39,186.62,186.85,187.09,187.32,187.55,187.78,188.02,188.25,188.48,188.71,188.94,189.18,189.41,189.64,189.87,190.11,190.34,190.57,190.8,191.04,191.27,191.5,191.73,191.97,192.2,192.43,192.66,192.9,193.13,193.36,193.59,193.83,194.06,194.29,194.53,194.76,194.99,195.23,195.46,195.69,195.93,196.16,196.4,196.63,196.86,197.1,197.33,197.57,197.8,198.04,198.27,198.51,198.74,198.98,199.21,199.45,199.69,199.92,200.16,200.39,200.63,200.87,201.11,201.34,201.58,201.82,202.06,202.3,202.54,202.77,203.01,203.25,203.49,203.74,203.98,204.22,204.46,204.7,204.94,205.19,205.43,205.67,205.92,206.16,206.41,206.65,206.9,207.15,207.39,207.64,207.89,208.14,208.39,208.64,208.89,209.14,209.39,209.64,209.9,210.15,210.41,210.66,210.92,211.18,211.43,211.69,211.95,212.21,212.47,212.74,213.0,213.26,213.53,213.79,214.06,214.33,214.6,214.87,215.14,215.41,215.69,215.96,216.24,216.51,216.79,217.07,217.35,217.64,217.92,218.2,218.49,218.78,219.07,219.36,219.65,219.95,220.24,220.54,220.84,221.14,221.44,221.75,222.06,222.36,222.67,222.99,223.3,223.62,223.94,224.26,224.58,224.91,225.23,225.56,225.89,226.23,226.57,226.91,227.25,227.59,227.94,228.29,228.64,229.0,229.36,229.72,230.08,230.45,230.82,231.2,231.57,231.96,232.34,232.73,233.12,233.51,233.91,234.31,234.72,235.13,235.55,235.96,236.39,236.81,237.25,237.68,238.12,238.57,239.02,239.47,239.93,240.4,240.87,},
{133.9,134.39,134.87,135.34,135.81,136.28,136.73,137.19,137.64,138.08,138.52,138.95,139.38,139.81,140.23,140.65,141.06,141.47,141.87,142.28,142.67,143.07,143.46,143.84,144.23,144.6,144.98,145.35,145.72,146.09,146.45,146.81,147.17,147.53,147.88,148.23,148.57,148.92,149.26,149.6,149.93,150.27,150.6,150.92,151.25,151.58,151.9,152.22,152.53,152.85,153.16,153.47,153.78,154.09,154.4,154.7,155.0,155.3,155.6,155.9,156.19,156.49,156.78,157.07,157.36,157.65,157.93,158.22,158.5,158.78,159.06,159.34,159.62,159.89,160.17,160.44,160.71,160.99,161.26,161.53,161.79,162.06,162.33,162.59,162.86,163.12,163.38,163.64,163.9,164.16,164.42,164.68,164.94,165.19,165.45,165.7,165.96,166.21,166.46,166.72,166.97,167.22,167.47,167.72,167.96,168.21,168.46,168.71,168.95,169.2,169.45,169.69,169.93,170.18,170.42,170.66,170.91,171.15,171.39,171.63,171.87,172.11,172.35,172.59,172.83,173.07,173.31,173.55,173.79,174.03,174.26,174.5,174.74,174.97,175.21,175.45,175.68,175.92,176.15,176.39,176.62,176.86,177.09,177.33,177.56,177.8,178.03,178.27,178.5,178.73,178.97,179.2,179.43,179.67,179.9,180.13,180.37,180.6,180.83,181.06,181.3,181.53,181.76,181.99,182.23,182.46,182.69,182.92,183.15,183.39,183.62,183.85,184.08,184.31,184.54,184.78,185.01,185.24,185.47,185.7,185.93,186.16,186.4,186.63,186.86,187.09,187.32,187.55,187.78,188.02,188.25,188.48,188.71,188.94,189.17,189.4,189.64,189.87,190.1,190.33,190.56,190.79,191.02,191.26,191.49,191.72,191.95,192.18,192.41,192.65,192.88,193.11,193.34,193.57,193.81,194.04,194.27,194.5,194.74,194.97,195.2,195.43,195.67,195.9,196.13,196.36,196.6,196.83,197.06,197.3,197.53,197.77,198.0,198.23,198.47,198.7,198.94,199.17,199.41,199.64,199.88,200.11,200.35,200.59,200.82,201.06,201.3,201.53,201.77,202.01,202.25,202.48,202.72,202.96,203.2,203.44,203.68,203.92,204.16,204.4,204.64,204.88,205.13,205.37,205.61,205.86,206.1,206.34,206.59,206.83,207.08,207.33,207.57,207.82,208.07,208.32,208.57,208.82,209.07,209.32,209.57,209.82,210.08,210.33,210.59,210.84,211.1,211.36,211.61,211.87,212.13,212.39,212.65,212.92,213.18,213.44,213.71,213.98,214.24,214.51,214.78,215.05,215.32,215.6,215.87,216.15,216.42,216.7,216.98,217.26,217.54,217.82,218.11,218.4,218.68,218.97,219.26,219.55,219.85,220.14,220.44,220.74,221.04,221.34,221.65,221.95,222.26,222.57,222.88,223.19,223.51,223.83,224.15,224.47,224.79,225.12,225.45,225.78,226.11,226.45,226.79,227.13,227.47,227.82,228.17,228.52,228.88,229.24,229.6,229.96,230.33,230.7,231.07,231.45,231.83,232.21,232.6,232.99,233.38,233.78,234.18,234.59,235.0,235.41,235.83,236.25,236.67,237.1,237.54,237.98,238.42,238.87,239.33,239.78,240.25,240.72,},
{134.06,134.54,135.02,135.5,135.96,136.42,136.88,137.33,137.78,138.22,138.66,139.1,139.52,139.95,140.37,140.78,141.2,141.6,142.01,142.41,142.8,143.2,143.59,143.97,144.35,144.73,145.11,145.48,145.85,146.21,146.58,146.94,147.29,147.65,148.0,148.35,148.69,149.03,149.37,149.71,150.05,150.38,150.71,151.04,151.36,151.69,152.01,152.33,152.64,152.96,153.27,153.58,153.89,154.2,154.5,154.8,155.11,155.4,155.7,156.0,156.29,156.59,156.88,157.17,157.45,157.74,158.03,158.31,158.59,158.87,159.15,159.43,159.71,159.98,160.26,160.53,160.8,161.07,161.34,161.61,161.88,162.15,162.41,162.68,162.94,163.2,163.46,163.72,163.98,164.24,164.5,164.76,165.02,165.27,165.53,165.78,166.03,166.29,166.54,166.79,167.04,167.29,167.54,167.79,168.03,168.28,168.53,168.77,169.02,169.27,169.51,169.75,170.0,170.24,170.48,170.73,170.97,171.21,171.45,171.69,171.93,172.17,172.41,172.65,172.89,173.13,173.36,173.6,173.84,174.08,174.31,174.55,174.79,175.02,175.26,175.49,175.73,175.96,176.2,176.43,176.67,176.9,177.14,177.37,177.6,177.84,178.07,178.3,178.54,178.77,179.0,179.23,179.47,179.7,179.93,180.16,180.4,180.63,180.86,181.09,181.32,181.55,181.79,182.02,182.25,182.48,182.71,182.94,183.17,183.4,183.63,183.87,184.1,184.33,184.56,184.79,185.02,185.25,185.48,185.71,185.94,186.17,186.4,186.63,186.86,187.09,187.33,187.56,187.79,188.02,188.25,188.48,188.71,188.94,189.17,189.4,189.63,189.86,190.09,190.32,190.55,190.78,191.01,191.24,191.47,191.71,191.94,192.17,192.4,192.63,192.86,193.09,193.32,193.55,193.78,194.02,194.25,194.48,194.71,194.94,195.17,195.41,195.64,195.87,196.1,196.33,196.57,196.8,197.03,197.26,197.5,197.73,197.96,198.2,198.43,198.66,198.9,199.13,199.37,199.6,199.84,200.07,200.31,200.54,200.78,201.01,201.25,201.49,201.72,201.96,202.2,202.43,202.67,202.91,203.15,203.39,203.63,203.86,204.1,204.34,204.59,204.83,205.07,205.31,205.55,205.79,206.04,206.28,206.53,206.77,207.02,207.26,207.51,207.75,208.0,208.25,208.5,208.75,209.0,209.25,209.5,209.75,210.0,210.26,210.51,210.77,211.02,211.28,211.54,211.79,212.05,212.31,212.57,212.84,213.1,213.36,213.63,213.89,214.16,214.43,214.7,214.97,215.24,215.51,215.78,216.06,216.33,216.61,216.89,217.17,217.45,217.73,218.02,218.3,218.59,218.88,219.17,219.46,219.75,220.04,220.34,220.64,220.94,221.24,221.54,221.85,222.16,222.46,222.78,223.09,223.4,223.72,224.04,224.36,224.68,225.01,225.34,225.67,226.0,226.34,226.68,227.02,227.36,227.7,228.05,228.4,228.76,229.12,229.48,229.84,230.2,230.57,230.95,231.32,231.7,232.08,232.47,232.86,233.25,233.65,234.05,234.45,234.86,235.27,235.69,236.11,236.53,236.96,237.4,237.84,238.28,238.73,239.18,239.64,240.1,240.57,},
{134.21,134.7,135.17,135.64,136.11,136.57,137.03,137.48,137.92,138.37,138.8,139.24,139.66,140.09,140.51,140.92,141.33,141.74,142.14,142.54,142.94,143.33,143.72,144.1,144.48,144.86,145.23,145.6,145.97,146.34,146.7,147.06,147.41,147.77,148.12,148.46,148.81,149.15,149.49,149.83,150.16,150.49,150.82,151.15,151.47,151.8,152.12,152.43,152.75,153.06,153.38,153.69,153.99,154.3,154.6,154.91,155.21,155.51,155.8,156.1,156.39,156.68,156.97,157.26,157.55,157.84,158.12,158.4,158.68,158.97,159.24,159.52,159.8,160.07,160.35,160.62,160.89,161.16,161.43,161.7,161.96,162.23,162.5,162.76,163.02,163.28,163.54,163.8,164.06,164.32,164.58,164.84,165.09,165.35,165.6,165.85,166.11,166.36,166.61,166.86,167.11,167.36,167.61,167.86,168.1,168.35,168.6,168.84,169.09,169.33,169.57,169.82,170.06,170.3,170.54,170.79,171.03,171.27,171.51,171.75,171.99,172.23,172.47,172.7,172.94,173.18,173.42,173.65,173.89,174.13,174.36,174.6,174.83,175.07,175.3,175.54,175.77,176.01,176.24,176.48,176.71,176.94,177.18,177.41,177.64,177.87,178.11,178.34,178.57,178.8,179.04,179.27,179.5,179.73,179.96,180.19,180.42,180.66,180.89,181.12,181.35,181.58,181.81,182.04,182.27,182.5,182.73,182.96,183.19,183.42,183.65,183.88,184.11,184.34,184.57,184.8,185.03,185.26,185.49,185.72,185.95,186.18,186.41,186.64,186.87,187.1,187.33,187.56,187.79,188.02,188.25,188.48,188.71,188.94,189.17,189.39,189.62,189.85,190.08,190.31,190.54,190.77,191.0,191.23,191.46,191.69,191.92,192.15,192.38,192.61,192.84,193.07,193.3,193.53,193.76,193.99,194.23,194.46,194.69,194.92,195.15,195.38,195.61,195.84,196.07,196.3,196.54,196.77,197.0,197.23,197.46,197.7,197.93,198.16,198.39,198.63,198.86,199.09,199.33,199.56,199.79,200.03,200.26,200.5,200.73,200.97,201.2,201.44,201.67,201.91,202.15,202.38,202.62,202.86,203.09,203.33,203.57,203.81,204.05,204.29,204.53,204.77,205.01,205.25,205.49,205.73,205.98,206.22,206.46,206.71,206.95,207.2,207.44,207.69,207.94,208.18,208.43,208.68,208.93,209.18,209.43,209.68,209.93,210.19,210.44,210.69,210.95,211.2,211.46,211.72,211.98,212.24,212.5,212.76,213.02,213.28,213.55,213.81,214.08,214.34,214.61,214.88,215.15,215.42,215.7,215.97,216.24,216.52,216.8,217.08,217.36,217.64,217.92,218.21,218.49,218.78,219.07,219.36,219.65,219.95,220.24,220.54,220.84,221.14,221.44,221.75,222.05,222.36,222.67,222.98,223.3,223.61,223.93,224.25,224.58,224.9,225.23,225.56,225.89,226.23,226.56,226.9,227.24,227.59,227.94,228.29,228.64,229.0,229.36,229.72,230.08,230.45,230.82,231.2,231.58,231.96,232.34,232.73,233.12,233.52,233.92,234.32,234.73,235.14,235.55,235.97,236.4,236.83,237.26,237.7,238.14,238.58,239.04,239.49,239.95,240.42,},
{134.36,134.85,135.32,135.79,136.26,136.72,137.17,137.62,138.07,138.51,138.94,139.37,139.8,140.22,140.64,141.05,141.46,141.87,142.27,142.67,143.06,143.46,143.84,144.23,144.61,144.98,145.36,145.73,146.09,146.46,146.82,147.18,147.53,147.88,148.23,148.58,148.92,149.26,149.6,149.94,150.27,150.6,150.93,151.26,151.58,151.9,152.22,152.54,152.86,153.17,153.48,153.79,154.1,154.4,154.7,155.01,155.31,155.6,155.9,156.2,156.49,156.78,157.07,157.36,157.64,157.93,158.21,158.5,158.78,159.06,159.33,159.61,159.89,160.16,160.43,160.71,160.98,161.25,161.51,161.78,162.05,162.31,162.58,162.84,163.1,163.36,163.62,163.88,164.14,164.4,164.66,164.91,165.17,165.42,165.67,165.93,166.18,166.43,166.68,166.93,167.18,167.43,167.68,167.92,168.17,168.42,168.66,168.91,169.15,169.39,169.64,169.88,170.12,170.36,170.61,170.85,171.09,171.33,171.57,171.81,172.04,172.28,172.52,172.76,172.99,173.23,173.47,173.7,173.94,174.18,174.41,174.65,174.88,175.12,175.35,175.58,175.82,176.05,176.28,176.52,176.75,176.98,177.22,177.45,177.68,177.91,178.14,178.38,178.61,178.84,179.07,179.3,179.53,179.76,179.99,180.22,180.45,180.68,180.91,181.14,181.37,181.6,181.83,182.06,182.29,182.52,182.75,182.98,183.21,183.44,183.67,183.9,184.13,184.36,184.59,184.81,185.04,185.27,185.5,185.73,185.96,186.19,186.42,186.65,186.87,187.1,187.33,187.56,187.79,188.02,188.25,188.48,188.7,188.93,189.16,189.39,189.62,189.85,190.08,190.31,190.53,190.76,190.99,191.22,191.45,191.68,191.91,192.14,192.37,192.6,192.83,193.06,193.28,193.51,193.74,193.97,194.2,194.43,194.66,194.89,195.12,195.35,195.58,195.81,196.04,196.27,196.51,196.74,196.97,197.2,197.43,197.66,197.89,198.12,198.36,198.59,198.82,199.05,199.29,199.52,199.75,199.99,200.22,200.45,200.69,200.92,201.16,201.39,201.63,201.86,202.1,202.33,202.57,202.81,203.04,203.28,203.52,203.76,203.99,204.23,204.47,204.71,204.95,205.19,205.43,205.67,205.92,206.16,206.4,206.64,206.89,207.13,207.38,207.62,207.87,208.12,208.36,208.61,208.86,209.11,209.36,209.61,209.86,210.11,210.37,210.62,210.87,211.13,211.39,211.64,211.9,212.16,212.42,212.68,212.94,213.2,213.46,213.73,213.99,214.26,214.53,214.8,215.07,215.34,215.61,215.88,216.16,216.43,216.71,216.99,217.27,217.55,217.83,218.12,218.4,218.69,218.98,219.27,219.56,219.85,220.15,220.44,220.74,221.04,221.34,221.65,221.95,222.26,222.57,222.88,223.19,223.51,223.83,224.15,224.47,224.79,225.12,225.45,225.78,226.11,226.45,226.79,227.13,227.48,227.82,228.17,228.52,228.88,229.24,229.6,229.96,230.33,230.7,231.08,231.45,231.83,232.22,232.6,233.0,233.39,233.79,234.19,234.6,235.01,235.42,235.84,236.26,236.69,237.12,237.56,238.0,238.44,238.89,239.35,239.81,240.28,},
{134.51,134.99,135.47,135.94,136.4,136.86,137.31,137.76,138.21,138.64,139.08,139.51,139.93,140.36,140.77,141.19,141.59,142.0,142.4,142.8,143.19,143.58,143.97,144.35,144.73,145.1,145.48,145.85,146.21,146.58,146.94,147.29,147.65,148.0,148.35,148.69,149.04,149.38,149.71,150.05,150.38,150.71,151.04,151.36,151.69,152.01,152.33,152.64,152.96,153.27,153.58,153.89,154.2,154.5,154.8,155.11,155.4,155.7,156.0,156.29,156.58,156.87,157.16,157.45,157.74,158.02,158.3,158.59,158.87,159.15,159.42,159.7,159.97,160.25,160.52,160.79,161.06,161.33,161.6,161.87,162.13,162.4,162.66,162.92,163.18,163.44,163.7,163.96,164.22,164.48,164.73,164.99,165.24,165.5,165.75,166.0,166.25,166.5,166.75,167.0,167.25,167.5,167.74,167.99,168.24,168.48,168.73,168.97,169.21,169.46,169.7,169.94,170.18,170.42,170.67,170.91,171.14,171.38,171.62,171.86,172.1,172.34,172.57,172.81,173.05,173.28,173.52,173.75,173.99,174.22,174.46,174.69,174.93,175.16,175.4,175.63,175.86,176.09,176.33,176.56,176.79,177.02,177.25,177.49,177.72,177.95,178.18,178.41,178.64,178.87,179.1,179.33,179.56,179.79,180.02,180.25,180.48,180.71,180.94,181.17,181.4,181.63,181.86,182.09,182.31,182.54,182.77,183.0,183.23,183.46,183.69,183.91,184.14,184.37,184.6,184.83,185.06,185.28,185.51,185.74,185.97,186.2,186.42,186.65,186.88,187.11,187.34,187.56,187.79,188.02,188.25,188.47,188.7,188.93,189.16,189.39,189.61,189.84,190.07,190.3,190.53,190.75,190.98,191.21,191.44,191.67,191.9,192.12,192.35,192.58,192.81,193.04,193.27,193.49,193.72,193.95,194.18,194.41,194.64,194.87,195.1,195.33,195.56,195.79,196.02,196.25,196.48,196.71,196.94,197.17,197.4,197.63,197.86,198.09,198.32,198.55,198.78,199.02,199.25,199.48,199.71,199.94,200.18,200.41,200.64,200.88,201.11,201.35,201.58,201.81,202.05,202.28,202.52,202.76,202.99,203.23,203.47,203.7,203.94,204.18,204.42,204.66,204.9,205.13,205.38,205.62,205.86,206.1,206.34,206.58,206.83,207.07,207.31,207.56,207.8,208.05,208.3,208.54,208.79,209.04,209.29,209.54,209.79,210.04,210.29,210.55,210.8,211.06,211.31,211.57,211.82,212.08,212.34,212.6,212.86,213.12,213.39,213.65,213.91,214.18,214.45,214.71,214.98,215.25,215.53,215.8,216.07,216.35,216.62,216.9,217.18,217.46,217.74,218.03,218.31,218.6,218.88,219.17,219.46,219.76,220.05,220.35,220.64,220.94,221.25,221.55,221.85,222.16,222.47,222.78,223.09,223.41,223.72,224.04,224.36,224.69,225.01,225.34,225.67,226.01,226.34,226.68,227.02,227.36,227.71,228.06,228.41,228.76,229.12,229.48,229.85,230.21,230.58,230.95,231.33,231.71,232.09,232.48,232.87,233.26,233.66,234.06,234.47,234.88,235.29,235.71,236.13,236.56,236.99,237.42,237.86,238.31,238.76,239.21,239.67,240.13,},
{134.66,135.14,135.61,136.08,136.54,137.0,137.45,137.9,138.34,138.78,139.21,139.64,140.07,140.49,140.9,141.32,141.72,142.13,142.53,142.92,143.32,143.71,144.09,144.47,144.85,145.23,145.6,145.97,146.33,146.69,147.05,147.41,147.76,148.11,148.46,148.8,149.15,149.49,149.82,150.16,150.49,150.82,151.15,151.47,151.79,152.11,152.43,152.75,153.06,153.37,153.68,153.99,154.3,154.6,154.9,155.2,155.5,155.8,156.09,156.39,156.68,156.97,157.26,157.54,157.83,158.11,158.4,158.68,158.96,159.23,159.51,159.79,160.06,160.33,160.61,160.88,161.15,161.41,161.68,161.95,162.21,162.48,162.74,163.0,163.26,163.52,163.78,164.04,164.3,164.55,164.81,165.06,165.32,165.57,165.82,166.07,166.32,166.57,166.82,167.07,167.32,167.56,167.81,168.06,168.3,168.55,168.79,169.03,169.28,169.52,169.76,170.0,170.24,170.48,170.72,170.96,171.2,171.44,171.68,171.92,172.15,172.39,172.63,172.86,173.1,173.33,173.57,173.8,174.04,174.27,174.51,174.74,174.97,175.21,175.44,175.67,175.9,176.14,176.37,176.6,176.83,177.06,177.29,177.52,177.75,177.99,178.22,178.45,178.68,178.9,179.13,179.36,179.59,179.82,180.05,180.28,180.51,180.74,180.97,181.19,181.42,181.65,181.88,182.11,182.34,182.56,182.79,183.02,183.25,183.47,183.7,183.93,184.16,184.38,184.61,184.84,185.07,185.29,185.52,185.75,185.98,186.2,186.43,186.66,186.88,187.11,187.34,187.57,187.79,188.02,188.25,188.47,188.7,188.93,189.15,189.38,189.61,189.84,190.06,190.29,190.52,190.75,190.97,191.2,191.43,191.65,191.88,192.11,192.34,192.56,192.79,193.02,193.25,193.48,193.7,193.93,194.16,194.39,194.62,194.84,195.07,195.3,195.53,195.76,195.99,196.22,196.45,196.68,196.91,197.13,197.36,197.59,197.82,198.05,198.29,198.52,198.75,198.98,199.21,199.44,199.67,199.9,200.14,200.37,200.6,200.83,201.07,201.3,201.53,201.77,202.0,202.24,202.47,202.71,202.94,203.18,203.41,203.65,203.89,204.12,204.36,204.6,204.84,205.08,205.32,205.56,205.8,206.04,206.28,206.52,206.76,207.01,207.25,207.5,207.74,207.99,208.23,208.48,208.73,208.97,209.22,209.47,209.72,209.97,210.22,210.48,210.73,210.98,211.24,211.49,211.75,212.01,212.26,212.52,212.78,213.04,213.31,213.57,213.83,214.1,214.37,214.63,214.9,215.17,215.44,215.71,215.99,216.26,216.54,216.81,217.09,217.37,217.65,217.94,218.22,218.51,218.79,219.08,219.37,219.66,219.96,220.25,220.55,220.85,221.15,221.45,221.76,222.06,222.37,222.68,222.99,223.31,223.62,223.94,224.26,224.58,224.91,225.24,225.57,225.9,226.23,226.57,226.91,227.25,227.6,227.95,228.3,228.65,229.01,229.37,229.73,230.09,230.46,230.84,231.21,231.59,231.97,232.36,232.75,233.14,233.54,233.94,234.34,234.75,235.16,235.58,236.0,236.42,236.85,237.29,237.73,238.17,238.62,239.07,239.53,239.99,},
{134.8,135.28,135.75,136.22,136.68,137.14,137.59,138.04,138.48,138.91,139.35,139.78,140.2,140.62,141.03,141.44,141.85,142.25,142.65,143.05,143.44,143.83,144.21,144.59,144.97,145.34,145.72,146.08,146.45,146.81,147.17,147.52,147.87,148.22,148.57,148.92,149.26,149.6,149.93,150.27,150.6,150.93,151.25,151.58,151.9,152.22,152.53,152.85,153.16,153.47,153.78,154.09,154.4,154.7,155.0,155.3,155.6,155.89,156.19,156.48,156.77,157.06,157.35,157.63,157.92,158.2,158.48,158.76,159.04,159.32,159.6,159.87,160.15,160.42,160.69,160.96,161.23,161.5,161.76,162.03,162.29,162.56,162.82,163.08,163.34,163.6,163.86,164.11,164.37,164.63,164.88,165.13,165.39,165.64,165.89,166.14,166.39,166.64,166.89,167.14,167.39,167.63,167.88,168.12,168.37,168.61,168.85,169.1,169.34,169.58,169.82,170.06,170.3,170.54,170.78,171.02,171.26,171.5,171.73,171.97,172.21,172.44,172.68,172.92,173.15,173.39,173.62,173.85,174.09,174.32,174.55,174.79,175.02,175.25,175.48,175.72,175.95,176.18,176.41,176.64,176.87,177.1,177.33,177.56,177.79,178.02,178.25,178.48,178.71,178.94,179.17,179.4,179.62,179.85,180.08,180.31,180.54,180.76,180.99,181.22,181.45,181.67,181.9,182.13,182.36,182.58,182.81,183.04,183.26,183.49,183.72,183.95,184.17,184.4,184.63,184.85,185.08,185.3,185.53,185.76,185.98,186.21,186.44,186.66,186.89,187.12,187.34,187.57,187.79,188.02,188.25,188.47,188.7,188.93,189.15,189.38,189.6,189.83,190.06,190.28,190.51,190.74,190.96,191.19,191.42,191.64,191.87,192.1,192.32,192.55,192.78,193.0,193.23,193.46,193.68,193.91,194.14,194.37,194.59,194.82,195.05,195.28,195.5,195.73,195.96,196.19,196.42,196.65,196.87,197.1,197.33,197.56,197.79,198.02,198.25,198.48,198.71,198.94,199.17,199.4,199.63,199.86,200.09,200.33,200.56,200.79,201.02,201.25,201.49,201.72,201.95,202.19,202.42,202.66,202.89,203.13,203.36,203.6,203.83,204.07,204.31,204.55,204.78,205.02,205.26,205.5,205.74,205.98,206.22,206.46,206.7,206.95,207.19,207.43,207.68,207.92,208.17,208.41,208.66,208.91,209.15,209.4,209.65,209.9,210.15,210.41,210.66,210.91,211.17,211.42,211.68,211.93,212.19,212.45,212.71,212.97,213.23,213.49,213.76,214.02,214.29,214.55,214.82,215.09,215.36,215.63,215.9,216.18,216.45,216.73,217.01,217.29,217.57,217.85,218.13,218.42,218.7,218.99,219.28,219.57,219.86,220.16,220.46,220.75,221.05,221.35,221.66,221.96,222.27,222.58,222.89,223.21,223.52,223.84,224.16,224.48,224.81,225.13,225.46,225.79,226.13,226.46,226.8,227.14,227.49,227.84,228.19,228.54,228.89,229.25,229.61,229.98,230.35,230.72,231.09,231.47,231.85,232.24,232.63,233.02,233.41,233.81,234.22,234.62,235.04,235.45,235.87,236.29,236.72,237.16,237.59,238.04,238.48,238.93,239.39,239.85,},
{134.95,135.42,135.89,136.36,136.82,137.27,137.72,138.17,138.61,139.05,139.48,139.91,140.33,140.75,141.16,141.57,141.98,142.38,142.78,143.17,143.56,143.95,144.33,144.71,145.09,145.46,145.83,146.2,146.56,146.92,147.28,147.63,147.99,148.34,148.68,149.02,149.37,149.7,150.04,150.37,150.7,151.03,151.36,151.68,152.0,152.32,152.64,152.95,153.26,153.57,153.88,154.19,154.49,154.8,155.1,155.4,155.69,155.99,156.28,156.57,156.86,157.15,157.44,157.72,158.01,158.29,158.57,158.85,159.13,159.41,159.68,159.96,160.23,160.5,160.77,161.04,161.31,161.58,161.84,162.11,162.37,162.63,162.9,163.16,163.42,163.67,163.93,164.19,164.44,164.7,164.95,165.21,165.46,165.71,165.96,166.21,166.46,166.71,166.96,167.21,167.45,167.7,167.94,168.19,168.43,168.67,168.92,169.16,169.4,169.64,169.88,170.12,170.36,170.6,170.84,171.08,171.32,171.55,171.79,172.03,172.26,172.5,172.73,172.97,173.2,173.44,173.67,173.9,174.14,174.37,174.6,174.83,175.06,175.3,175.53,175.76,175.99,176.22,176.45,176.68,176.91,177.14,177.37,177.6,177.83,178.06,178.29,178.51,178.74,178.97,179.2,179.43,179.65,179.88,180.11,180.34,180.56,180.79,181.02,181.24,181.47,181.7,181.92,182.15,182.38,182.6,182.83,183.06,183.28,183.51,183.73,183.96,184.19,184.41,184.64,184.86,185.09,185.31,185.54,185.77,185.99,186.22,186.44,186.67,186.89,187.12,187.34,187.57,187.8,188.02,188.25,188.47,188.7,188.92,189.15,189.37,189.6,189.82,190.05,190.28,190.5,190.73,190.95,191.18,191.4,191.63,191.86,192.08,192.31,192.53,192.76,192.99,193.21,193.44,193.66,193.89,194.12,194.34,194.57,194.8,195.02,195.25,195.48,195.71,195.93,196.16,196.39,196.62,196.84,197.07,197.3,197.53,197.76,197.99,198.22,198.44,198.67,198.9,199.13,199.36,199.59,199.82,200.05,200.28,200.52,200.75,200.98,201.21,201.44,201.68,201.91,202.14,202.37,202.61,202.84,203.08,203.31,203.55,203.78,204.02,204.26,204.49,204.73,204.97,205.21,205.44,205.68,205.92,206.16,206.4,206.64,206.89,207.13,207.37,207.61,207.86,208.1,208.35,208.59,208.84,209.09,209.34,209.59,209.83,210.08,210.34,210.59,210.84,211.09,211.35,211.6,211.86,212.12,212.37,212.63,212.89,213.15,213.41,213.68,213.94,214.21,214.47,214.74,215.01,215.28,215.55,215.82,216.09,216.37,216.64,216.92,217.2,217.48,217.76,218.04,218.33,218.61,218.9,219.19,219.48,219.77,220.07,220.36,220.66,220.96,221.26,221.56,221.87,222.17,222.48,222.79,223.11,223.42,223.74,224.06,224.38,224.7,225.03,225.36,225.69,226.02,226.36,226.7,227.04,227.38,227.73,228.08,228.43,228.78,229.14,229.5,229.87,230.23,230.6,230.98,231.35,231.73,232.12,232.51,232.9,233.29,233.69,234.09,234.5,234.91,235.32,235.74,236.17,236.59,237.03,237.46,237.9,238.35,238.8,239.26,239.72,},
{135.09,135.56,136.03,136.5,136.95,137.41,137.86,138.3,138.74,139.18,139.61,140.03,140.45,140.87,141.29,141.69,142.1,142.5,142.9,143.29,143.68,144.07,144.45,144.83,145.2,145.58,145.95,146.31,146.68,147.04,147.39,147.75,148.1,148.44,148.79,149.13,149.47,149.81,150.14,150.48,150.81,151.13,151.46,151.78,152.1,152.42,152.74,153.05,153.36,153.67,153.98,154.28,154.59,154.89,155.19,155.49,155.79,156.08,156.37,156.66,156.95,157.24,157.53,157.81,158.1,158.38,158.66,158.94,159.22,159.49,159.77,160.04,160.31,160.58,160.85,161.12,161.39,161.66,161.92,162.19,162.45,162.71,162.97,163.23,163.49,163.75,164.01,164.26,164.52,164.77,165.03,165.28,165.53,165.78,166.03,166.28,166.53,166.78,167.03,167.27,167.52,167.76,168.01,168.25,168.49,168.74,168.98,169.22,169.46,169.7,169.94,170.18,170.42,170.66,170.9,171.13,171.37,171.61,171.84,172.08,172.31,172.55,172.78,173.02,173.25,173.48,173.72,173.95,174.18,174.41,174.65,174.88,175.11,175.34,175.57,175.8,176.03,176.26,176.49,176.72,176.95,177.18,177.41,177.64,177.86,178.09,178.32,178.55,178.77,179.0,179.23,179.46,179.68,179.91,180.14,180.36,180.59,180.82,181.04,181.27,181.5,181.72,181.95,182.17,182.4,182.62,182.85,183.07,183.3,183.53,183.75,183.98,184.2,184.43,184.65,184.88,185.1,185.33,185.55,185.77,186.0,186.22,186.45,186.67,186.9,187.12,187.35,187.57,187.8,188.02,188.25,188.47,188.7,188.92,189.14,189.37,189.59,189.82,190.04,190.27,190.49,190.72,190.94,191.17,191.39,191.62,191.84,192.07,192.29,192.52,192.74,192.97,193.19,193.42,193.65,193.87,194.1,194.32,194.55,194.77,195.0,195.23,195.45,195.68,195.91,196.13,196.36,196.59,196.81,197.04,197.27,197.5,197.72,197.95,198.18,198.41,198.64,198.87,199.1,199.32,199.55,199.78,200.01,200.24,200.47,200.7,200.94,201.17,201.4,201.63,201.86,202.09,202.33,202.56,202.79,203.03,203.26,203.5,203.73,203.97,204.2,204.44,204.68,204.91,205.15,205.39,205.63,205.87,206.1,206.34,206.59,206.83,207.07,207.31,207.55,207.8,208.04,208.28,208.53,208.78,209.02,209.27,209.52,209.77,210.02,210.27,210.52,210.77,211.02,211.28,211.53,211.79,212.04,212.3,212.56,212.82,213.08,213.34,213.6,213.86,214.13,214.39,214.66,214.93,215.2,215.47,215.74,216.01,216.29,216.56,216.84,217.12,217.39,217.68,217.96,218.24,218.53,218.81,219.1,219.39,219.68,219.98,220.27,220.57,220.87,221.17,221.47,221.77,222.08,222.39,222.7,223.01,223.32,223.64,223.96,224.28,224.6,224.93,225.25,225.59,225.92,226.25,226.59,226.93,227.27,227.62,227.97,228.32,228.67,229.03,229.39,229.75,230.12,230.49,230.86,231.24,231.62,232.0,232.39,232.78,233.17,233.57,233.97,234.38,234.79,235.2,235.62,236.04,236.47,236.9,237.33,237.77,238.22,238.67,239.12,239.58,},
{135.22,135.7,136.17,136.63,137.09,137.54,137.99,138.43,138.87,139.31,139.73,140.16,140.58,141.0,141.41,141.82,142.22,142.62,143.02,143.41,143.8,144.18,144.57,144.94,145.32,145.69,146.06,146.42,146.79,147.15,147.5,147.85,148.2,148.55,148.9,149.24,149.58,149.91,150.25,150.58,150.91,151.24,151.56,151.88,152.2,152.52,152.83,153.15,153.46,153.77,154.08,154.38,154.68,154.98,155.28,155.58,155.88,156.17,156.46,156.75,157.04,157.33,157.62,157.9,158.18,158.47,158.75,159.02,159.3,159.58,159.85,160.12,160.4,160.67,160.94,161.2,161.47,161.74,162.0,162.26,162.53,162.79,163.05,163.31,163.57,163.82,164.08,164.34,164.59,164.84,165.1,165.35,165.6,165.85,166.1,166.35,166.6,166.84,167.09,167.34,167.58,167.83,168.07,168.31,168.56,168.8,169.04,169.28,169.52,169.76,170.0,170.24,170.48,170.72,170.95,171.19,171.43,171.66,171.9,172.13,172.37,172.6,172.83,173.07,173.3,173.53,173.77,174.0,174.23,174.46,174.69,174.92,175.15,175.38,175.61,175.84,176.07,176.3,176.53,176.76,176.99,177.22,177.44,177.67,177.9,178.13,178.35,178.58,178.81,179.03,179.26,179.49,179.71,179.94,180.17,180.39,180.62,180.84,181.07,181.29,181.52,181.74,181.97,182.19,182.42,182.64,182.87,183.09,183.32,183.54,183.77,183.99,184.21,184.44,184.66,184.89,185.11,185.34,185.56,185.78,186.01,186.23,186.46,186.68,186.9,187.13,187.35,187.57,187.8,188.02,188.25,188.47,188.69,188.92,189.14,189.37,189.59,189.81,190.04,190.26,190.49,190.71,190.93,191.16,191.38,191.61,191.83,192.05,192.28,192.5,192.73,192.95,193.18,193.4,193.63,193.85,194.08,194.3,194.53,194.75,194.98,195.2,195.43,195.65,195.88,196.11,196.33,196.56,196.78,197.01,197.24,197.47,197.69,197.92,198.15,198.37,198.6,198.83,199.06,199.29,199.52,199.74,199.97,200.2,200.43,200.66,200.89,201.12,201.35,201.59,201.82,202.05,202.28,202.51,202.75,202.98,203.21,203.45,203.68,203.92,204.15,204.39,204.62,204.86,205.1,205.33,205.57,205.81,206.05,206.29,206.53,206.77,207.01,207.25,207.49,207.73,207.98,208.22,208.47,208.71,208.96,209.21,209.45,209.7,209.95,210.2,210.45,210.7,210.95,211.21,211.46,211.72,211.97,212.23,212.49,212.74,213.0,213.26,213.53,213.79,214.05,214.32,214.58,214.85,215.12,215.39,215.66,215.93,216.2,216.48,216.75,217.03,217.31,217.59,217.87,218.16,218.44,218.73,219.01,219.3,219.59,219.89,220.18,220.48,220.77,221.07,221.38,221.68,221.98,222.29,222.6,222.91,223.23,223.54,223.86,224.18,224.5,224.83,225.15,225.48,225.82,226.15,226.49,226.83,227.17,227.51,227.86,228.21,228.57,228.92,229.28,229.64,230.01,230.38,230.75,231.13,231.5,231.89,232.27,232.66,233.05,233.45,233.85,234.26,234.67,235.08,235.5,235.92,236.34,236.77,237.21,237.65,238.09,238.54,238.99,239.45,},
{135.36,135.83,136.3,136.76,137.22,137.67,138.12,138.56,139.0,139.43,139.86,140.28,140.7,141.12,141.53,141.94,142.34,142.74,143.14,143.53,143.92,144.3,144.68,145.06,145.43,145.8,146.17,146.54,146.9,147.25,147.61,147.96,148.31,148.66,149.0,149.34,149.68,150.02,150.35,150.68,151.01,151.34,151.66,151.98,152.3,152.62,152.93,153.24,153.55,153.86,154.17,154.47,154.78,155.08,155.38,155.67,155.97,156.26,156.55,156.84,157.13,157.42,157.7,157.99,158.27,158.55,158.83,159.11,159.38,159.66,159.93,160.21,160.48,160.75,161.02,161.28,161.55,161.81,162.08,162.34,162.6,162.86,163.12,163.38,163.64,163.9,164.15,164.41,164.66,164.92,165.17,165.42,165.67,165.92,166.17,166.42,166.66,166.91,167.16,167.4,167.65,167.89,168.13,168.38,168.62,168.86,169.1,169.34,169.58,169.82,170.06,170.3,170.53,170.77,171.01,171.24,171.48,171.71,171.95,172.18,172.42,172.65,172.88,173.12,173.35,173.58,173.81,174.04,174.28,174.51,174.74,174.97,175.2,175.43,175.65,175.88,176.11,176.34,176.57,176.8,177.02,177.25,177.48,177.71,177.93,178.16,178.39,178.61,178.84,179.07,179.29,179.52,179.74,179.97,180.19,180.42,180.64,180.87,181.09,181.32,181.54,181.77,181.99,182.21,182.44,182.66,182.89,183.11,183.33,183.56,183.78,184.01,184.23,184.45,184.68,184.9,185.12,185.35,185.57,185.79,186.02,186.24,186.46,186.68,186.91,187.13,187.35,187.58,187.8,188.02,188.25,188.47,188.69,188.92,189.14,189.36,189.58,189.81,190.03,190.25,190.48,190.7,190.92,191.15,191.37,191.59,191.82,192.04,192.26,192.49,192.71,192.94,193.16,193.38,193.61,193.83,194.06,194.28,194.5,194.73,194.95,195.18,195.4,195.63,195.85,196.08,196.3,196.53,196.76,196.98,197.21,197.43,197.66,197.89,198.11,198.34,198.57,198.79,199.02,199.25,199.48,199.71,199.93,200.16,200.39,200.62,200.85,201.08,201.31,201.54,201.77,202.0,202.24,202.47,202.7,202.93,203.16,203.4,203.63,203.87,204.1,204.33,204.57,204.81,205.04,205.28,205.52,205.75,205.99,206.23,206.47,206.71,206.95,207.19,207.43,207.67,207.92,208.16,208.4,208.65,208.89,209.14,209.39,209.64,209.88,210.13,210.38,210.63,210.88,211.14,211.39,211.64,211.9,212.16,212.41,212.67,212.93,213.19,213.45,213.71,213.98,214.24,214.51,214.77,215.04,215.31,215.58,215.85,216.12,216.4,216.67,216.95,217.23,217.51,217.79,218.07,218.35,218.64,218.93,219.22,219.51,219.8,220.09,220.39,220.68,220.98,221.28,221.59,221.89,222.2,222.51,222.82,223.13,223.45,223.76,224.08,224.4,224.73,225.05,225.38,225.71,226.05,226.38,226.72,227.07,227.41,227.76,228.11,228.46,228.81,229.17,229.53,229.9,230.27,230.64,231.01,231.39,231.77,232.16,232.55,232.94,233.33,233.73,234.14,234.55,234.96,235.37,235.79,236.22,236.65,237.08,237.52,237.96,238.41,238.86,239.32,},
{135.49,135.96,136.43,136.89,137.35,137.8,138.25,138.69,139.12,139.56,139.98,140.41,140.82,141.24,141.65,142.06,142.46,142.86,143.25,143.64,144.03,144.41,144.79,145.17,145.54,145.91,146.28,146.64,147.0,147.36,147.72,148.07,148.42,148.76,149.11,149.45,149.78,150.12,150.45,150.78,151.11,151.44,151.76,152.08,152.4,152.71,153.03,153.34,153.65,153.96,154.26,154.57,154.87,155.17,155.47,155.76,156.06,156.35,156.64,156.93,157.22,157.51,157.79,158.07,158.35,158.63,158.91,159.19,159.47,159.74,160.01,160.29,160.56,160.83,161.09,161.36,161.63,161.89,162.15,162.42,162.68,162.94,163.2,163.46,163.71,163.97,164.22,164.48,164.73,164.98,165.24,165.49,165.74,165.99,166.24,166.48,166.73,166.98,167.22,167.47,167.71,167.95,168.2,168.44,168.68,168.92,169.16,169.4,169.64,169.88,170.12,170.35,170.59,170.83,171.06,171.3,171.53,171.77,172.0,172.24,172.47,172.7,172.93,173.17,173.4,173.63,173.86,174.09,174.32,174.55,174.78,175.01,175.24,175.47,175.7,175.92,176.15,176.38,176.61,176.83,177.06,177.29,177.52,177.74,177.97,178.19,178.42,178.65,178.87,179.1,179.32,179.55,179.77,180.0,180.22,180.44,180.67,180.89,181.12,181.34,181.56,181.79,182.01,182.23,182.46,182.68,182.9,183.13,183.35,183.57,183.8,184.02,184.24,184.47,184.69,184.91,185.13,185.36,185.58,185.8,186.02,186.25,186.47,186.69,186.91,187.13,187.36,187.58,187.8,188.02,188.25,188.47,188.69,188.91,189.14,189.36,189.58,189.8,190.02,190.25,190.47,190.69,190.91,191.14,191.36,191.58,191.81,192.03,192.25,192.47,192.7,192.92,193.14,193.37,193.59,193.81,194.04,194.26,194.48,194.71,194.93,195.16,195.38,195.6,195.83,196.05,196.28,196.5,196.73,196.95,197.18,197.4,197.63,197.85,198.08,198.31,198.53,198.76,198.99,199.21,199.44,199.67,199.9,200.12,200.35,200.58,200.81,201.04,201.27,201.5,201.73,201.96,202.19,202.42,202.65,202.88,203.12,203.35,203.58,203.82,204.05,204.28,204.52,204.75,204.99,205.22,205.46,205.7,205.94,206.17,206.41,206.65,206.89,207.13,207.37,207.61,207.86,208.1,208.34,208.59,208.83,209.08,209.32,209.57,209.82,210.07,210.32,210.57,210.82,211.07,211.32,211.58,211.83,212.09,212.34,212.6,212.86,213.12,213.38,213.64,213.9,214.17,214.43,214.7,214.96,215.23,215.5,215.77,216.04,216.32,216.59,216.87,217.15,217.42,217.7,217.99,218.27,218.56,218.84,219.13,219.42,219.71,220.0,220.3,220.6,220.89,221.19,221.5,221.8,222.11,222.41,222.72,223.04,223.35,223.67,223.99,224.31,224.63,224.96,225.28,225.62,225.95,226.28,226.62,226.96,227.31,227.65,228.0,228.35,228.71,229.07,229.43,229.79,230.16,230.53,230.9,231.28,231.66,232.05,232.43,232.82,233.22,233.62,234.02,234.43,234.84,235.25,235.67,236.1,236.53,236.96,237.4,237.84,238.28,238.74,239.19,},
{135.62,136.09,136.56,137.02,137.48,137.93,138.37,138.81,139.25,139.68,140.1,140.53,140.94,141.36,141.77,142.17,142.57,142.97,143.37,143.76,144.14,144.53,144.91,145.28,145.65,146.02,146.39,146.75,147.11,147.47,147.82,148.17,148.52,148.87,149.21,149.55,149.89,150.22,150.55,150.88,151.21,151.53,151.86,152.18,152.49,152.81,153.12,153.43,153.74,154.05,154.35,154.66,154.96,155.26,155.56,155.85,156.15,156.44,156.73,157.02,157.3,157.59,157.87,158.16,158.44,158.72,159.0,159.27,159.55,159.82,160.09,160.37,160.64,160.9,161.17,161.44,161.7,161.97,162.23,162.49,162.75,163.01,163.27,163.53,163.79,164.04,164.3,164.55,164.8,165.05,165.3,165.56,165.8,166.05,166.3,166.55,166.79,167.04,167.28,167.53,167.77,168.01,168.26,168.5,168.74,168.98,169.22,169.46,169.7,169.93,170.17,170.41,170.64,170.88,171.12,171.35,171.59,171.82,172.05,172.29,172.52,172.75,172.98,173.21,173.44,173.68,173.91,174.14,174.37,174.59,174.82,175.05,175.28,175.51,175.74,175.96,176.19,176.42,176.65,176.87,177.1,177.32,177.55,177.78,178.0,178.23,178.45,178.68,178.9,179.13,179.35,179.58,179.8,180.02,180.25,180.47,180.69,180.92,181.14,181.36,181.59,181.81,182.03,182.26,182.48,182.7,182.92,183.15,183.37,183.59,183.81,184.03,184.26,184.48,184.7,184.92,185.14,185.37,185.59,185.81,186.03,186.25,186.47,186.7,186.92,187.14,187.36,187.58,187.8,188.02,188.25,188.47,188.69,188.91,189.13,189.35,189.58,189.8,190.02,190.24,190.46,190.68,190.91,191.13,191.35,191.57,191.79,192.02,192.24,192.46,192.68,192.9,193.13,193.35,193.57,193.79,194.02,194.24,194.46,194.69,194.91,195.13,195.36,195.58,195.8,196.03,196.25,196.47,196.7,196.92,197.15,197.37,197.6,197.82,198.05,198.27,198.5,198.73,198.95,199.18,199.4,199.63,199.86,200.09,200.31,200.54,200.77,201.0,201.23,201.46,201.69,201.92,202.15,202.38,202.61,202.84,203.07,203.3,203.53,203.77,204.0,204.23,204.47,204.7,204.94,205.17,205.41,205.64,205.88,206.12,206.36,206.59,206.83,207.07,207.31,207.56,207.8,208.04,208.28,208.53,208.77,209.01,209.26,209.51,209.75,210.0,210.25,210.5,210.75,211.0,211.25,211.51,211.76,212.02,212.27,212.53,212.79,213.04,213.3,213.57,213.83,214.09,214.35,214.62,214.89,215.15,215.42,215.69,215.97,216.24,216.51,216.79,217.06,217.34,217.62,217.9,218.19,218.47,218.76,219.04,219.33,219.62,219.92,220.21,220.51,220.81,221.11,221.41,221.71,222.02,222.32,222.63,222.94,223.26,223.57,223.89,224.21,224.54,224.86,225.19,225.52,225.85,226.18,226.52,226.86,227.21,227.55,227.9,228.25,228.6,228.96,229.32,229.69,230.05,230.42,230.79,231.17,231.55,231.93,232.32,232.71,233.11,233.5,233.91,234.31,234.72,235.14,235.56,235.98,236.41,236.84,237.27,237.71,238.16,238.61,239.07,},
};
// 打表变换(原图y->俯视y)
AT_SDRAM_SECTION_ALIGN_INIT(float mapy[240][376], 64) = {
{463.61,469.76,476.12,482.71,489.54,496.61,503.94,511.54,519.43,527.63,536.14,544.99,554.19,563.77,573.75,584.15,595.0,606.32,618.14,630.5,643.44,656.98,671.18,686.07,701.72,718.16,735.47,753.7,772.94,793.26,814.75,837.51,861.66,887.32,914.62,943.74,974.84,1008.1,1043.8,1082.2,1123.6,1168.4,1216.9,1269.6,1327.1,1390.1,1459.4,1536.0,1621.0,1715.9,1822.4,1943.0,2080.3,2238.3,2421.9,2637.7,2895.0,3207.0,3592.9,4082.7,4724.2,5600.8,6870.3,8872.2,12495.0,21046.0,65896.0,-58902.0,-20435.0,-12393.0,-8910.0,-6966.0,-5725.8,-4866.1,-4235.3,-3752.8,-3372.0,-3063.9,-2809.6,-2596.2,-2414.6,-2258.3,-2122.4,-2003.2,-1897.8,-1804.0,-1720.0,-1644.5,-1576.1,-1514.0,-1457.3,-1405.5,-1357.9,-1314.0,-1273.5,-1236.0,-1201.2,-1168.8,-1138.6,-1110.5,-1084.1,-1059.4,-1036.2,-1014.5,-993.98,-974.69,-956.49,-939.32,-923.09,-907.74,-893.21,-879.45,-866.4,-854.02,-842.27,-831.11,-820.5,-810.41,-800.82,-791.68,-782.99,-774.71,-766.81,-759.29,-752.13,-745.29,-738.77,-732.55,-726.62,-720.96,-715.56,-710.4,-705.49,-700.79,-696.31,-692.03,-687.95,-684.06,-680.34,-676.8,-673.41,-670.19,-667.11,-664.18,-661.38,-658.71,-656.17,-653.75,-651.45,-649.26,-647.17,-645.18,-643.29,-641.5,-639.79,-638.18,-636.64,-635.18,-633.8,-632.49,-631.25,-630.08,-628.97,-627.92,-626.94,-626.0,-625.13,-624.31,-623.53,-622.81,-622.13,-621.5,-620.91,-620.36,-619.85,-619.38,-618.95,-618.55,-618.2,-617.87,-617.58,-617.32,-617.09,-616.9,-616.73,-616.6,-616.49,-616.42,-616.37,-616.35,-616.37,-616.41,-616.48,-616.58,-616.71,-616.87,-617.06,-617.28,-617.54,-617.82,-618.14,-618.5,-618.89,-619.31,-619.78,-620.28,-620.82,-621.41,-622.03,-622.7,-623.42,-624.19,-625.0,-625.87,-626.79,-627.77,-628.81,-629.91,-631.07,-632.3,-633.6,-634.97,-636.42,-637.94,-639.55,-641.24,-643.02,-644.9,-646.87,-648.94,-651.12,-653.4,-655.81,-658.33,-660.97,-663.75,-666.66,-669.72,-672.92,-676.28,-679.8,-683.49,-687.36,-691.41,-695.66,-700.11,-704.77,-709.66,-714.78,-720.14,-725.76,-731.65,-737.83,-744.3,-751.09,-758.21,-765.67,-773.51,-781.73,-790.36,-799.43,-808.96,-818.97,-829.5,-840.57,-852.24,-864.52,-877.47,-891.12,-905.53,-920.75,-936.85,-953.88,-971.92,-991.04,-1011.3,-1032.9,-1055.9,-1080.3,-1106.4,-1134.3,-1164.2,-1196.2,-1230.7,-1267.8,-1307.8,-1351.1,-1398.2,-1449.3,-1505.2,-1566.5,-1633.9,-1708.3,-1790.9,-1883.2,-1986.7,-2103.7,-2236.9,-2389.9,-2567.4,-2775.6,-3023.1,-3322.2,-3690.7,-4155.6,-4760.4,-5578.9,-6748.1,-8554.2,-11711.0,-18633.0,-46001.0,96287.0,23421.0,13300.0,9272.6,7109.2,5759.3,4836.9,4166.9,3658.2,3259.1,2937.5,2673.0,2451.7,2263.8,2102.4,1962.2,1839.4,1730.9,1634.4,1548.1,1470.3,1400.0,1336.1,1277.8,1224.4,1175.3,1130.0,1088.2,1049.4,1013.3,979.64,948.23,918.83,891.27,865.37,841.01,818.05,796.37,775.89,756.49,738.12,720.68,704.11,688.35,673.35,659.05,645.41,632.39,619.94,608.04,596.65,585.73,575.27,565.23,555.59,546.33,537.43,528.87,520.63,512.7,505.05,497.68,490.57,483.71,},
{473.74,480.41,487.32,494.49,501.93,509.65,517.68,526.03,534.71,543.74,553.16,562.97,573.21,583.89,595.06,606.73,618.95,631.74,645.16,659.23,674.02,689.57,705.95,723.2,741.42,760.66,781.03,802.61,825.51,849.86,875.79,903.46,933.03,964.71,998.72,1035.3,1074.8,1117.5,1163.9,1214.4,1269.6,1330.1,1396.8,1470.6,1552.6,1644.5,1747.9,1865.3,1999.4,2154.4,2335.2,2549.0,2805.5,3118.9,3510.3,4013.0,4681.9,5615.6,7009.5,9314.3,13854.0,26934.0,451120.0,-30727.0,-14893.0,-9844.7,-7362.2,-5886.1,-4907.9,-4212.2,-3692.2,-3288.9,-2967.2,-2704.6,-2486.3,-2302.0,-2144.4,-2008.1,-1889.2,-1784.5,-1691.7,-1608.9,-1534.6,-1467.5,-1406.8,-1351.5,-1300.9,-1254.6,-1212.0,-1172.8,-1136.4,-1102.8,-1071.5,-1042.3,-1015.1,-989.73,-965.94,-943.64,-922.69,-902.99,-884.44,-866.95,-850.45,-834.87,-820.13,-806.17,-792.96,-780.43,-768.55,-757.26,-746.55,-736.36,-726.67,-717.45,-708.68,-700.32,-692.36,-684.77,-677.54,-670.64,-664.06,-657.78,-651.79,-646.07,-640.61,-635.39,-630.42,-625.66,-621.12,-616.79,-612.65,-608.69,-604.92,-601.31,-597.87,-594.58,-591.44,-588.45,-585.59,-582.86,-580.25,-577.77,-575.4,-573.15,-571.0,-568.95,-566.99,-565.13,-563.36,-561.68,-560.08,-558.56,-557.11,-555.74,-554.43,-553.19,-552.02,-550.91,-549.86,-548.86,-547.92,-547.03,-546.18,-545.39,-544.64,-543.94,-543.28,-542.66,-542.08,-541.53,-541.02,-540.54,-540.1,-539.69,-539.31,-538.96,-538.64,-538.35,-538.08,-537.84,-537.62,-537.43,-537.26,-537.11,-536.99,-536.89,-536.81,-536.76,-536.72,-536.71,-536.72,-536.75,-536.8,-536.88,-536.98,-537.09,-537.24,-537.4,-537.59,-537.8,-538.04,-538.3,-538.59,-538.91,-539.26,-539.63,-540.04,-540.48,-540.95,-541.45,-541.99,-542.57,-543.18,-543.84,-544.54,-545.28,-546.06,-546.9,-547.78,-548.72,-549.7,-550.75,-551.85,-553.02,-554.24,-555.54,-556.9,-558.34,-559.85,-561.44,-563.11,-564.87,-566.71,-568.65,-570.68,-572.82,-575.06,-577.41,-579.88,-582.46,-585.17,-588.01,-590.99,-594.1,-597.37,-600.79,-604.37,-608.12,-612.05,-616.16,-620.47,-624.98,-629.7,-634.64,-639.82,-645.24,-650.92,-656.87,-663.11,-669.64,-676.49,-683.67,-691.21,-699.11,-707.41,-716.12,-725.27,-734.89,-745.0,-755.64,-766.83,-778.63,-791.06,-804.17,-818.0,-832.62,-848.08,-864.44,-881.78,-900.16,-919.68,-940.44,-962.54,-986.1,-1011.3,-1038.2,-1067.0,-1098.0,-1131.3,-1167.2,-1206.0,-1248.1,-1293.8,-1343.7,-1398.2,-1458.1,-1524.2,-1597.3,-1678.8,-1770.0,-1872.8,-1989.4,-2122.9,-2277.0,-2457.0,-2669.6,-2924.9,-3236.6,-3625.9,-4125.6,-4790.0,-5716.4,-7097.1,-9373.9,-13836.0,-26527.0,-338000.0,31317.0,14934.0,9791.9,7277.5,5786.8,4800.7,4100.1,3577.0,3171.5,2848.0,2584.1,2364.7,2179.5,2021.1,1884.0,1764.4,1659.1,1565.6,1482.2,1407.3,1339.6,1278.2,1222.3,1171.1,1124.2,1080.9,1041.0,1004.0,969.61,937.6,907.73,879.79,853.61,829.04,805.92,784.15,763.62,744.21,725.85,708.45,691.95,676.28,661.39,647.21,633.7,620.81,608.51,596.76,585.52,574.77,564.47,554.59,545.12,536.03,527.29,518.9,510.83,503.06,495.58,},
{484.83,492.08,499.61,507.45,515.6,524.08,532.91,542.12,551.73,561.76,572.24,583.19,594.65,606.66,619.25,632.46,646.34,660.94,676.31,692.51,709.6,727.67,746.79,767.05,788.56,811.43,835.79,861.78,889.57,919.35,951.32,985.74,1022.9,1063.1,1106.8,1154.3,1206.3,1263.3,1326.2,1395.8,1473.3,1560.1,1658.0,1769.1,1896.3,2043.4,2215.3,2419.0,2663.9,2964.0,3340.1,3825.3,4474.7,5388.5,6768.8,9094.5,13841.0,28877.0,-345310.0,-24804.0,-12884.0,-8711.3,-6586.3,-5298.9,-4435.7,-3816.8,-3351.5,-2989.1,-2698.8,-2461.3,-2263.3,-2095.9,-1952.4,-1828.2,-1719.6,-1624.0,-1539.1,-1463.2,-1395.1,-1333.6,-1277.9,-1227.1,-1180.6,-1138.0,-1098.8,-1062.7,-1029.2,-998.17,-969.31,-942.42,-917.33,-893.86,-871.88,-851.26,-831.88,-813.66,-796.49,-780.3,-765.01,-750.56,-736.89,-723.95,-711.69,-700.06,-689.02,-678.53,-668.56,-659.09,-650.07,-641.49,-633.31,-625.53,-618.1,-611.02,-604.27,-597.83,-591.68,-585.81,-580.2,-574.85,-569.74,-564.85,-560.18,-555.73,-551.46,-547.39,-543.5,-539.78,-536.23,-532.83,-529.59,-526.49,-523.53,-520.7,-518.0,-515.42,-512.96,-510.61,-508.37,-506.23,-504.19,-502.24,-500.39,-498.62,-496.93,-495.33,-493.8,-492.35,-490.97,-489.66,-488.41,-487.22,-486.1,-485.03,-484.02,-483.06,-482.15,-481.29,-480.48,-479.71,-478.98,-478.3,-477.65,-477.04,-476.47,-475.93,-475.43,-474.96,-474.51,-474.1,-473.71,-473.35,-473.02,-472.71,-472.42,-472.16,-471.92,-471.69,-471.49,-471.31,-471.15,-471.01,-470.88,-470.77,-470.68,-470.61,-470.55,-470.51,-470.48,-470.47,-470.48,-470.5,-470.54,-470.6,-470.67,-470.76,-470.86,-470.99,-471.13,-471.29,-471.47,-471.66,-471.88,-472.12,-472.38,-472.66,-472.97,-473.3,-473.66,-474.04,-474.45,-474.89,-475.36,-475.86,-476.39,-476.96,-477.56,-478.2,-478.88,-479.6,-480.36,-481.17,-482.02,-482.92,-483.87,-484.88,-485.94,-487.05,-488.23,-489.47,-490.77,-492.14,-493.58,-495.1,-496.69,-498.36,-500.12,-501.96,-503.89,-505.92,-508.04,-510.27,-512.6,-515.05,-517.61,-520.29,-523.1,-526.04,-529.12,-532.34,-535.72,-539.24,-542.94,-546.8,-550.85,-555.08,-559.51,-564.14,-569.0,-574.07,-579.39,-584.96,-590.79,-596.89,-603.29,-610.0,-617.03,-624.4,-632.13,-640.25,-648.77,-657.72,-667.13,-677.02,-687.42,-698.38,-709.92,-722.09,-734.93,-748.48,-762.81,-777.97,-794.02,-811.04,-829.1,-848.3,-868.73,-890.5,-913.74,-938.58,-965.19,-993.75,-1024.4,-1057.5,-1093.3,-1132.0,-1174.1,-1219.9,-1270.0,-1325.0,-1385.6,-1452.7,-1527.3,-1610.7,-1704.7,-1811.2,-1932.8,-2073.2,-2236.7,-2429.6,-2660.6,-2941.9,-3292.1,-3739.5,-4331.1,-5149.7,-6356.4,-8312.1,-12026.0,-21802.0,-118150.0,34427.0,15003.0,9583.2,7036.4,5557.0,4590.5,3909.7,3404.3,3014.5,2704.6,2452.5,2243.4,2067.2,1916.8,1786.9,1673.6,1573.9,1485.6,1406.8,1336.1,1272.3,1214.4,1161.7,1113.6,1069.4,1028.7,991.08,956.28,923.95,893.87,865.8,839.55,814.96,791.87,770.17,749.73,730.44,712.22,694.99,678.66,663.17,648.47,634.48,621.17,608.5,596.4,584.86,573.83,563.29,553.19,543.52,534.26,525.37,516.84,508.64,},
{497.0,504.93,513.18,521.78,530.75,540.12,549.9,560.12,570.82,582.02,593.77,606.09,619.03,632.64,646.96,662.06,677.99,694.82,712.63,731.49,751.52,772.8,795.46,819.64,845.48,873.16,902.87,934.85,969.36,1006.7,1047.2,1091.3,1139.5,1192.4,1250.7,1315.1,1386.9,1467.2,1557.6,1660.3,1777.7,1913.3,2071.7,2259.0,2484.0,2759.1,3103.2,3545.7,4135.8,4961.8,6200.3,8262.0,12375.0,24622.0,2164300.0,-25229.0,-12552.0,-8359.2,-6269.7,-5018.4,-4185.5,-3591.2,-3146.1,-2800.3,-2524.0,-2298.3,-2110.4,-1951.6,-1815.8,-1698.3,-1595.6,-1505.2,-1425.0,-1353.4,-1289.1,-1231.1,-1178.5,-1130.6,-1086.9,-1046.7,-1009.8,-975.68,-944.14,-914.89,-887.7,-862.36,-838.71,-816.6,-795.88,-776.45,-758.19,-741.0,-724.82,-709.55,-695.13,-681.5,-668.6,-656.39,-644.81,-633.83,-623.4,-613.5,-604.08,-595.13,-586.6,-578.48,-570.75,-563.38,-556.35,-549.64,-543.24,-537.13,-531.3,-525.73,-520.41,-515.33,-510.47,-505.83,-501.39,-497.15,-493.09,-489.21,-485.5,-481.96,-478.57,-475.32,-472.23,-469.26,-466.43,-463.72,-461.14,-458.67,-456.31,-454.05,-451.9,-449.84,-447.88,-446.01,-444.22,-442.52,-440.89,-439.35,-437.87,-436.47,-435.13,-433.86,-432.65,-431.5,-430.41,-429.37,-428.39,-427.45,-426.57,-425.73,-424.94,-424.18,-423.47,-422.8,-422.17,-421.57,-421.01,-420.47,-419.97,-419.5,-419.06,-418.65,-418.26,-417.9,-417.56,-417.24,-416.95,-416.68,-416.42,-416.19,-415.97,-415.77,-415.59,-415.42,-415.27,-415.14,-415.02,-414.91,-414.81,-414.73,-414.67,-414.61,-414.57,-414.54,-414.52,-414.51,-414.52,-414.53,-414.56,-414.6,-414.66,-414.72,-414.8,-414.89,-415.0,-415.12,-415.25,-415.4,-415.56,-415.74,-415.94,-416.15,-416.39,-416.64,-416.91,-417.2,-417.51,-417.85,-418.21,-418.59,-419.0,-419.44,-419.9,-420.4,-420.93,-421.48,-422.08,-422.71,-423.37,-424.08,-424.82,-425.61,-426.44,-427.32,-428.25,-429.22,-430.25,-431.34,-432.48,-433.68,-434.94,-436.26,-437.66,-439.12,-440.66,-442.27,-443.96,-445.73,-447.59,-449.54,-451.58,-453.72,-455.96,-458.31,-460.76,-463.33,-466.02,-468.83,-471.78,-474.86,-478.08,-481.44,-484.97,-488.65,-492.5,-496.53,-500.75,-505.16,-509.77,-514.59,-519.64,-524.93,-530.46,-536.25,-542.32,-548.67,-555.33,-562.31,-569.63,-577.31,-585.37,-593.83,-602.72,-612.07,-621.9,-632.25,-643.14,-654.63,-666.75,-679.54,-693.06,-707.35,-722.49,-738.54,-755.57,-773.66,-792.92,-813.43,-835.33,-858.74,-883.82,-910.72,-939.66,-970.84,-1004.5,-1041.0,-1080.7,-1123.9,-1171.1,-1223.0,-1280.2,-1343.4,-1413.9,-1492.7,-1581.5,-1682.1,-1797.3,-1930.1,-2085.1,-2268.2,-2487.6,-2755.4,-3089.3,-3517.2,-4084.9,-4874.1,-6045.5,-7964.4,-11680.0,-21934.0,-181810.0,28864.0,13363.0,8691.4,6439.1,5113.6,4240.7,3622.5,3161.8,2805.3,2521.3,2289.8,2097.5,1935.3,1796.6,1676.7,1572.1,1479.9,1398.2,1325.3,1259.8,1200.7,1147.1,1098.2,1053.5,1012.5,974.72,939.81,907.48,877.44,849.47,823.37,798.95,776.08,754.6,734.39,715.36,697.4,680.43,664.37,649.16,634.72,621.01,607.97,595.56,583.73,572.45,561.68,551.39,541.54,532.12,523.09,},
{510.43,519.13,528.22,537.72,547.66,558.06,568.95,580.38,592.38,605.0,618.27,632.25,646.99,662.56,679.03,696.47,714.96,734.61,755.52,777.81,801.62,827.11,854.46,883.86,915.55,949.82,986.97,1027.4,1071.5,1119.8,1173.0,1231.7,1297.0,1369.9,1451.9,1544.7,1650.6,1772.6,1914.5,2081.8,2281.7,2524.7,2826.6,3211.5,3718.8,4417.9,5442.6,7088.9,10167.0,17981.0,77789.0,-33432.0,-13760.0,-8664.1,-6323.7,-4979.8,-4107.9,-3496.6,-3044.5,-2696.5,-2420.5,-2196.4,-2010.7,-1854.5,-1721.3,-1606.4,-1506.3,-1418.3,-1340.4,-1271.0,-1208.7,-1152.7,-1101.8,-1055.6,-1013.4,-974.78,-939.23,-906.45,-876.14,-848.05,-821.94,-797.63,-774.94,-753.73,-733.87,-715.25,-697.75,-681.29,-665.78,-651.15,-637.35,-624.29,-611.94,-600.25,-589.16,-578.64,-568.65,-559.16,-550.14,-541.56,-533.39,-525.61,-518.19,-511.12,-504.38,-497.95,-491.81,-485.94,-480.34,-474.99,-469.88,-464.99,-460.32,-455.85,-451.58,-447.49,-443.58,-439.84,-436.27,-432.84,-429.57,-426.44,-423.44,-420.58,-417.84,-415.22,-412.71,-410.31,-408.02,-405.83,-403.74,-401.74,-399.84,-398.01,-396.27,-394.61,-393.03,-391.52,-390.08,-388.71,-387.4,-386.15,-384.97,-383.84,-382.77,-381.75,-380.78,-379.87,-378.99,-378.17,-377.38,-376.64,-375.94,-375.28,-374.65,-374.05,-373.49,-372.97,-372.47,-372.0,-371.56,-371.15,-370.76,-370.39,-370.05,-369.73,-369.43,-369.15,-368.9,-368.65,-368.43,-368.22,-368.03,-367.85,-367.69,-367.54,-367.4,-367.28,-367.16,-367.06,-366.97,-366.89,-366.82,-366.76,-366.71,-366.67,-366.64,-366.62,-366.6,-366.6,-366.6,-366.62,-366.64,-366.67,-366.71,-366.76,-366.81,-366.88,-366.96,-367.05,-367.15,-367.26,-367.38,-367.52,-367.66,-367.83,-368.0,-368.19,-368.4,-368.62,-368.86,-369.12,-369.39,-369.69,-370.0,-370.34,-370.7,-371.09,-371.5,-371.93,-372.4,-372.89,-373.41,-373.97,-374.56,-375.18,-375.84,-376.54,-377.27,-378.05,-378.87,-379.73,-380.64,-381.6,-382.62,-383.68,-384.8,-385.97,-387.21,-388.51,-389.87,-391.3,-392.8,-394.37,-396.02,-397.75,-399.56,-401.46,-403.44,-405.52,-407.69,-409.97,-412.35,-414.84,-417.44,-420.16,-423.01,-425.99,-429.1,-432.35,-435.75,-439.3,-443.02,-446.9,-450.96,-455.2,-459.64,-464.28,-469.14,-474.22,-479.53,-485.09,-490.92,-497.02,-503.41,-510.1,-517.12,-524.48,-532.21,-540.32,-548.84,-557.8,-567.21,-577.12,-587.56,-598.56,-610.16,-622.41,-635.36,-649.05,-663.55,-678.92,-695.24,-712.58,-731.03,-750.7,-771.7,-794.16,-818.22,-844.05,-871.84,-901.8,-934.2,-969.31,-1007.5,-1049.1,-1094.7,-1144.8,-1200.0,-1261.3,-1329.6,-1406.1,-1492.5,-1590.7,-1703.2,-1833.4,-1985.9,-2166.6,-2384.3,-2651.5,-2987.1,-3421.1,-4003.8,-4827.5,-6079.8,-8212.3,-12654.0,-27574.0,153840.0,20300.0,10869.0,7422.7,5637.1,4545.0,3808.3,3277.9,2877.8,2565.4,2314.7,2109.2,1937.6,1792.3,1667.6,1559.5,1464.9,1381.5,1307.3,1241.0,1181.3,1127.4,1078.4,1033.7,992.76,955.15,920.48,888.42,858.69,831.05,805.3,781.25,758.74,737.63,717.81,699.14,681.55,664.95,649.25,634.39,620.3,606.93,594.22,582.13,570.62,559.64,549.17,539.17,},
{525.33,534.94,545.01,555.56,566.63,578.26,590.49,603.37,616.94,631.26,646.39,662.41,679.38,697.4,716.56,736.96,758.73,782.01,806.96,833.75,862.6,893.74,927.46,964.07,1004.0,1047.6,1095.5,1148.3,1206.9,1272.1,1345.2,1427.6,1521.4,1628.8,1753.3,1899.0,2072.0,2280.5,2536.9,2859.5,3277.7,3841.2,4641.7,5867.6,7980.7,12488.0,28761.0,-94187.0,-17835.0,-9845.3,-6797.4,-5189.8,-4196.9,-3522.9,-3035.5,-2666.8,-2378.1,-2146.1,-1955.6,-1796.4,-1661.5,-1545.6,-1445.1,-1357.2,-1279.5,-1210.6,-1148.9,-1093.4,-1043.3,-997.79,-956.3,-918.34,-883.49,-851.4,-821.75,-794.3,-768.81,-745.1,-722.99,-702.34,-683.01,-664.89,-647.87,-631.88,-616.81,-602.61,-589.21,-576.54,-564.56,-553.21,-542.46,-532.25,-522.57,-513.37,-504.62,-496.3,-488.38,-480.83,-473.64,-466.78,-460.24,-454.0,-448.04,-442.35,-436.91,-431.72,-426.75,-422.0,-417.46,-413.11,-408.96,-404.98,-401.18,-397.54,-394.05,-390.71,-387.52,-384.47,-381.54,-378.74,-376.07,-373.5,-371.05,-368.7,-366.46,-364.31,-362.26,-360.3,-358.42,-356.63,-354.92,-353.29,-351.73,-350.24,-348.82,-347.46,-346.17,-344.94,-343.77,-342.65,-341.59,-340.58,-339.62,-338.7,-337.84,-337.01,-336.23,-335.49,-334.79,-334.13,-333.5,-332.91,-332.35,-331.82,-331.32,-330.85,-330.41,-329.99,-329.6,-329.23,-328.89,-328.56,-328.26,-327.98,-327.71,-327.47,-327.24,-327.02,-326.83,-326.64,-326.47,-326.32,-326.17,-326.04,-325.91,-325.8,-325.7,-325.61,-325.53,-325.45,-325.39,-325.33,-325.28,-325.23,-325.2,-325.17,-325.14,-325.13,-325.12,-325.11,-325.12,-325.12,-325.14,-325.16,-325.19,-325.23,-325.27,-325.32,-325.38,-325.44,-325.51,-325.6,-325.69,-325.79,-325.9,-326.02,-326.15,-326.29,-326.45,-326.62,-326.8,-326.99,-327.21,-327.43,-327.68,-327.94,-328.22,-328.52,-328.84,-329.18,-329.54,-329.93,-330.34,-330.78,-331.25,-331.74,-332.27,-332.82,-333.41,-334.03,-334.69,-335.39,-336.12,-336.89,-337.71,-338.57,-339.48,-340.43,-341.43,-342.49,-343.6,-344.76,-345.98,-347.26,-348.61,-350.02,-351.5,-353.05,-354.67,-356.37,-358.15,-360.02,-361.96,-364.0,-366.13,-368.36,-370.69,-373.13,-375.68,-378.34,-381.12,-384.02,-387.06,-390.23,-393.55,-397.01,-400.63,-404.41,-408.36,-412.48,-416.8,-421.31,-426.03,-430.96,-436.12,-441.52,-447.18,-453.1,-459.3,-465.79,-472.6,-479.74,-487.23,-495.1,-503.36,-512.04,-521.17,-530.78,-540.91,-551.58,-562.83,-574.72,-587.28,-600.57,-614.65,-629.58,-645.44,-662.29,-680.24,-699.38,-719.83,-741.72,-765.18,-790.39,-817.54,-846.84,-878.56,-912.98,-950.45,-991.38,-1036.3,-1085.7,-1140.3,-1201.0,-1268.8,-1345.0,-1431.3,-1529.8,-1643.1,-1775.0,-1930.2,-2115.5,-2340.5,-2619.5,-2974.4,-3440.8,-4080.9,-5013.6,-6498.4,-9230.5,-15917.0,-57579.0,35677.0,13633.0,8432.5,6107.7,4790.2,3942.1,3350.6,2914.6,2580.1,2315.2,2100.5,1922.8,1773.5,1646.2,1536.4,1440.8,1356.8,1282.4,1216.1,1156.6,1103.0,1054.4,1010.2,969.78,932.71,898.58,867.08,837.91,810.82,785.61,762.09,740.11,719.51,700.17,681.99,664.87,648.72,633.46,619.02,605.34,592.36,580.04,568.32,557.17,},
{541.95,552.63,563.85,575.65,588.09,601.19,615.03,629.66,645.16,661.58,679.03,697.58,717.36,738.49,761.09,785.32,811.38,839.45,869.79,902.67,938.42,977.43,1020.1,1067.1,1119.0,1176.6,1240.9,1313.2,1394.9,1488.1,1595.4,1720.0,1866.7,2041.8,2254.4,2517.8,2852.8,3292.8,3896.5,4775.6,6174.2,8744.2,15017.0,53556.0,-34025.0,-12890.0,-7943.4,-5737.1,-4488.1,-3684.7,-3124.5,-2711.9,-2395.2,-2144.7,-1941.6,-1773.6,-1632.5,-1512.2,-1408.5,-1318.3,-1239.0,-1168.9,-1106.4,-1050.4,-999.92,-954.23,-912.68,-874.75,-839.99,-808.03,-778.57,-751.32,-726.06,-702.59,-680.73,-660.33,-641.26,-623.4,-606.64,-590.89,-576.07,-562.11,-548.94,-536.5,-524.73,-513.6,-503.05,-493.04,-483.55,-474.53,-465.96,-457.8,-450.04,-442.65,-435.6,-428.89,-422.48,-416.36,-410.52,-404.95,-399.62,-394.53,-389.66,-385.0,-380.54,-376.28,-372.2,-368.3,-364.56,-360.98,-357.56,-354.28,-351.14,-348.13,-345.25,-342.5,-339.86,-337.33,-334.91,-332.59,-330.37,-328.25,-326.22,-324.28,-322.42,-320.65,-318.95,-317.33,-315.77,-314.29,-312.88,-311.53,-310.24,-309.01,-307.84,-306.73,-305.67,-304.65,-303.69,-302.78,-301.91,-301.08,-300.3,-299.55,-298.85,-298.18,-297.55,-296.95,-296.38,-295.85,-295.34,-294.86,-294.42,-293.99,-293.6,-293.22,-292.87,-292.54,-292.24,-291.95,-291.68,-291.43,-291.19,-290.97,-290.77,-290.58,-290.41,-290.24,-290.09,-289.95,-289.83,-289.71,-289.6,-289.5,-289.41,-289.33,-289.26,-289.19,-289.13,-289.08,-289.03,-288.99,-288.95,-288.92,-288.89,-288.87,-288.86,-288.84,-288.84,-288.83,-288.84,-288.84,-288.85,-288.87,-288.89,-288.92,-288.95,-288.98,-289.02,-289.07,-289.12,-289.18,-289.25,-289.32,-289.4,-289.49,-289.59,-289.69,-289.81,-289.93,-290.07,-290.22,-290.38,-290.55,-290.74,-290.94,-291.16,-291.39,-291.64,-291.91,-292.19,-292.5,-292.82,-293.17,-293.54,-293.93,-294.35,-294.8,-295.27,-295.77,-296.3,-296.86,-297.45,-298.08,-298.75,-299.45,-300.18,-300.96,-301.78,-302.65,-303.55,-304.51,-305.51,-306.57,-307.68,-308.84,-310.06,-311.34,-312.68,-314.08,-315.55,-317.09,-318.7,-320.39,-322.15,-324.0,-325.93,-327.94,-330.05,-332.26,-334.56,-336.96,-339.47,-342.1,-344.84,-347.7,-350.68,-353.8,-357.06,-360.47,-364.02,-367.73,-371.61,-375.66,-379.9,-384.32,-388.95,-393.79,-398.85,-404.14,-409.68,-415.48,-421.55,-427.92,-434.59,-441.58,-448.92,-456.63,-464.72,-473.23,-482.18,-491.6,-501.53,-511.99,-523.04,-534.71,-547.04,-560.1,-573.94,-588.63,-604.23,-620.84,-638.53,-657.42,-677.61,-699.25,-722.47,-747.45,-774.39,-803.51,-835.07,-869.39,-906.83,-947.81,-992.85,-1042.6,-1097.7,-1159.1,-1228.1,-1305.8,-1394.3,-1495.8,-1613.4,-1751.1,-1914.6,-2111.9,-2354.4,-2659.6,-3055.5,-3589.1,-4347.3,-5509.4,-7514.4,-11799.0,-27365.0,86666.0,16812.0,9322.0,6455.7,4941.7,4005.9,3370.3,2910.4,2562.4,2289.9,2070.8,1890.8,1740.3,1612.7,1503.1,1408.0,1324.7,1251.1,1185.7,1127.2,1074.5,1026.8,983.53,944.0,907.8,874.51,843.81,815.42,789.08,764.58,741.75,720.41,700.44,681.71,664.11,647.54,631.91,617.16,603.2,589.99,577.46,},
{560.61,572.56,585.16,598.47,612.54,627.45,643.25,660.05,677.92,696.98,717.34,739.13,762.52,787.67,814.78,844.11,875.91,910.5,948.28,989.69,1035.3,1085.7,1141.7,1204.4,1274.9,1354.7,1446.0,1551.2,1673.9,1818.7,1992.2,2203.7,2467.4,2804.9,3252.4,3873.9,4795.2,6301.5,9208.2,17162.0,129630.0,-23226.0,-10635.0,-6887.6,-5088.3,-4031.7,-3336.7,-2845.0,-2478.8,-2195.5,-1970.0,-1786.2,-1633.7,-1505.0,-1395.0,-1299.9,-1217.0,-1144.1,-1079.4,-1021.7,-969.88,-923.16,-880.8,-842.24,-807.0,-774.68,-744.94,-717.5,-692.11,-668.55,-646.64,-626.23,-607.17,-589.34,-572.63,-556.94,-542.2,-528.31,-515.23,-502.88,-491.2,-480.16,-469.71,-459.8,-450.4,-441.47,-432.99,-424.92,-417.25,-409.94,-402.97,-396.33,-390.0,-383.96,-378.19,-372.67,-367.41,-362.37,-357.56,-352.96,-348.55,-344.34,-340.3,-336.44,-332.74,-329.2,-325.81,-322.56,-319.44,-316.46,-313.61,-310.87,-308.25,-305.74,-303.33,-301.03,-298.82,-296.71,-294.69,-292.75,-290.9,-289.12,-287.43,-285.8,-284.25,-282.77,-281.35,-280.0,-278.71,-277.47,-276.29,-275.17,-274.1,-273.08,-272.11,-271.18,-270.31,-269.47,-268.67,-267.92,-267.2,-266.52,-265.88,-265.27,-264.69,-264.15,-263.63,-263.15,-262.69,-262.26,-261.85,-261.47,-261.11,-260.77,-260.45,-260.16,-259.88,-259.62,-259.38,-259.15,-258.94,-258.75,-258.57,-258.4,-258.25,-258.1,-257.97,-257.85,-257.74,-257.63,-257.54,-257.45,-257.38,-257.3,-257.24,-257.18,-257.13,-257.08,-257.04,-257.0,-256.97,-256.94,-256.92,-256.9,-256.88,-256.86,-256.85,-256.85,-256.84,-256.84,-256.84,-256.84,-256.85,-256.86,-256.88,-256.89,-256.91,-256.94,-256.97,-257.0,-257.03,-257.08,-257.12,-257.17,-257.23,-257.29,-257.36,-257.44,-257.53,-257.62,-257.72,-257.83,-257.95,-258.08,-258.22,-258.38,-258.54,-258.72,-258.91,-259.12,-259.34,-259.58,-259.84,-260.11,-260.41,-260.72,-261.05,-261.41,-261.79,-262.19,-262.62,-263.08,-263.56,-264.07,-264.61,-265.18,-265.79,-266.43,-267.1,-267.81,-268.56,-269.35,-270.18,-271.05,-271.97,-272.93,-273.95,-275.01,-276.12,-277.29,-278.52,-279.8,-281.15,-282.55,-284.03,-285.57,-287.18,-288.87,-290.63,-292.47,-294.39,-296.4,-298.5,-300.69,-302.98,-305.37,-307.87,-310.47,-313.19,-316.03,-318.99,-322.09,-325.31,-328.69,-332.2,-335.88,-339.72,-343.73,-347.91,-352.29,-356.86,-361.64,-366.65,-371.88,-377.35,-383.08,-389.08,-395.37,-401.97,-408.88,-416.14,-423.76,-431.76,-440.18,-449.04,-458.37,-468.2,-478.57,-489.53,-501.1,-513.35,-526.32,-540.08,-554.69,-570.23,-586.79,-604.45,-623.32,-643.52,-665.19,-688.5,-713.6,-740.73,-770.1,-802.02,-836.8,-874.84,-916.6,-962.64,-1013.6,-1070.4,-1134.0,-1205.6,-1286.9,-1380.0,-1487.5,-1613.2,-1761.8,-1940.4,-2158.8,-2432.2,-2783.9,-3253.2,-3910.8,-4897.8,-6544.2,-9840.9,-19757.0,5455300.0,19696.0,9887.8,6610.9,4971.4,3987.5,3331.7,2863.3,2512.2,2239.2,2020.9,1842.5,1693.9,1568.3,1460.7,1367.5,1286.1,1214.3,1150.6,1093.6,1042.4,996.19,954.19,915.91,880.86,848.67,819.0,791.57,766.14,742.5,720.48,699.92,680.68,662.63,645.69,629.74,614.7,600.51,},
{581.71,595.19,609.46,624.59,640.68,657.8,676.05,695.56,716.45,738.86,762.97,788.97,817.1,847.61,880.81,917.09,956.86,1000.7,1049.1,1103.0,1163.3,1231.2,1308.2,1396.3,1497.9,1616.6,1756.9,1925.2,2130.9,2387.9,2718.1,3157.8,3772.1,4690.8,6213.8,9228.7,18028.0,439230.0,-19527.0,-9525.4,-6288.3,-4687.5,-3732.9,-3099.0,-2647.6,-2309.8,-2047.7,-1838.3,-1667.4,-1525.1,-1405.0,-1302.2,-1213.2,-1135.5,-1067.1,-1006.4,-952.19,-903.51,-859.57,-819.71,-783.41,-750.22,-719.76,-691.73,-665.85,-641.89,-619.66,-598.97,-579.69,-561.68,-544.83,-529.03,-514.2,-500.25,-487.11,-474.72,-463.03,-451.97,-441.51,-431.61,-422.21,-413.3,-404.83,-396.78,-389.12,-381.84,-374.9,-368.28,-361.97,-355.95,-350.2,-344.71,-339.47,-334.46,-329.66,-325.08,-320.69,-316.49,-312.48,-308.63,-304.94,-301.41,-298.03,-294.79,-291.68,-288.71,-285.86,-283.12,-280.5,-277.99,-275.59,-273.28,-271.07,-268.95,-266.93,-264.98,-263.12,-261.34,-259.64,-258.0,-256.44,-254.95,-253.52,-252.15,-250.85,-249.6,-248.41,-247.27,-246.18,-245.15,-244.16,-243.22,-242.33,-241.47,-240.66,-239.89,-239.16,-238.47,-237.81,-237.18,-236.59,-236.03,-235.5,-235.0,-234.52,-234.08,-233.66,-233.26,-232.89,-232.54,-232.21,-231.91,-231.62,-231.35,-231.1,-230.86,-230.65,-230.44,-230.25,-230.08,-229.92,-229.77,-229.63,-229.51,-229.39,-229.28,-229.18,-229.1,-229.01,-228.94,-228.87,-228.81,-228.76,-228.71,-228.67,-228.63,-228.59,-228.56,-228.53,-228.51,-228.49,-228.47,-228.45,-228.44,-228.43,-228.42,-228.41,-228.41,-228.41,-228.41,-228.41,-228.41,-228.41,-228.42,-228.43,-228.44,-228.45,-228.47,-228.48,-228.5,-228.53,-228.56,-228.59,-228.62,-228.66,-228.7,-228.75,-228.8,-228.86,-228.93,-229.0,-229.08,-229.17,-229.27,-229.37,-229.49,-229.61,-229.75,-229.9,-230.05,-230.23,-230.41,-230.61,-230.83,-231.06,-231.31,-231.58,-231.86,-232.17,-232.49,-232.84,-233.21,-233.6,-234.01,-234.46,-234.93,-235.42,-235.95,-236.5,-237.09,-237.71,-238.37,-239.06,-239.78,-240.55,-241.35,-242.2,-243.09,-244.02,-245.0,-246.03,-247.11,-248.23,-249.42,-250.66,-251.95,-253.31,-254.73,-256.22,-257.77,-259.39,-261.08,-262.85,-264.7,-266.63,-268.65,-270.75,-272.95,-275.24,-277.63,-280.12,-282.73,-285.44,-288.28,-291.23,-294.32,-297.54,-300.9,-304.41,-308.07,-311.89,-315.89,-320.06,-324.42,-328.97,-333.73,-338.71,-343.92,-349.37,-355.08,-361.06,-367.32,-373.89,-380.78,-388.02,-395.62,-403.61,-412.01,-420.86,-430.18,-440.01,-450.38,-461.35,-472.94,-485.22,-498.25,-512.07,-526.77,-542.42,-559.11,-576.94,-596.02,-616.49,-638.48,-662.17,-687.75,-715.45,-745.53,-778.29,-814.1,-853.4,-896.7,-944.63,-997.95,-1057.6,-1124.8,-1201.0,-1288.1,-1388.7,-1506.0,-1644.6,-1810.8,-2013.7,-2266.8,-2591.4,-3022.6,-3623.0,-4516.2,-5985.1,-8849.9,-16897.0,-176890.0,21015.0,9948.5,6530.0,4867.6,3884.9,3235.9,2775.3,2431.6,2165.4,1953.1,1779.9,1635.9,1514.4,1410.5,1320.6,1242.0,1172.9,1111.6,1056.8,1007.6,963.1,922.76,886.0,852.36,821.47,793.01,766.71,742.33,719.68,698.57,678.87,660.44,643.16,626.92,},
{605.78,621.11,637.42,654.82,673.4,693.3,714.65,737.62,762.39,789.18,818.24,849.86,884.41,922.28,963.99,1010.1,1061.5,1118.9,1183.5,1256.8,1340.6,1437.3,1550.2,1683.7,1843.8,2039.5,2283.9,2597.9,3015.9,3599.8,4472.4,5917.8,8775.2,17084.0,367600.0,-18700.0,-9087.0,-5988.7,-4458.9,-3547.4,-2942.4,-2511.7,-2189.5,-1939.5,-1739.8,-1576.8,-1441.2,-1326.6,-1228.6,-1143.8,-1069.7,-1004.5,-946.61,-894.93,-848.52,-806.62,-768.62,-734.0,-702.35,-673.31,-646.57,-621.88,-599.03,-577.82,-558.09,-539.69,-522.51,-506.42,-491.34,-477.18,-463.87,-451.32,-439.49,-428.32,-417.76,-407.77,-398.3,-389.32,-380.8,-372.71,-365.01,-357.69,-350.72,-344.07,-337.74,-331.7,-325.94,-320.43,-315.18,-310.15,-305.35,-300.75,-296.35,-292.15,-288.12,-284.26,-280.56,-277.02,-273.63,-270.38,-267.26,-264.28,-261.41,-258.67,-256.03,-253.51,-251.09,-248.77,-246.55,-244.41,-242.37,-240.41,-238.53,-236.73,-235.01,-233.36,-231.78,-230.27,-228.82,-227.43,-226.11,-224.84,-223.63,-222.47,-221.36,-220.31,-219.3,-218.34,-217.42,-216.55,-215.72,-214.92,-214.17,-213.46,-212.78,-212.13,-211.52,-210.94,-210.39,-209.87,-209.38,-208.92,-208.48,-208.07,-207.68,-207.31,-206.97,-206.65,-206.35,-206.06,-205.8,-205.55,-205.33,-205.11,-204.91,-204.73,-204.56,-204.4,-204.26,-204.13,-204.0,-203.89,-203.79,-203.7,-203.61,-203.53,-203.46,-203.4,-203.34,-203.29,-203.25,-203.21,-203.17,-203.14,-203.11,-203.09,-203.07,-203.05,-203.03,-203.02,-203.01,-203.0,-202.99,-202.99,-202.98,-202.98,-202.97,-202.97,-202.97,-202.97,-202.97,-202.97,-202.97,-202.97,-202.98,-202.98,-202.99,-203.0,-203.01,-203.02,-203.03,-203.05,-203.07,-203.09,-203.11,-203.14,-203.17,-203.2,-203.24,-203.29,-203.34,-203.39,-203.45,-203.52,-203.6,-203.68,-203.77,-203.88,-203.99,-204.11,-204.24,-204.38,-204.54,-204.7,-204.89,-205.08,-205.29,-205.52,-205.76,-206.02,-206.3,-206.6,-206.92,-207.26,-207.62,-208.01,-208.42,-208.85,-209.31,-209.8,-210.31,-210.86,-211.43,-212.04,-212.68,-213.35,-214.06,-214.81,-215.6,-216.42,-217.29,-218.2,-219.15,-220.15,-221.2,-222.3,-223.45,-224.65,-225.91,-227.23,-228.61,-230.05,-231.55,-233.12,-234.76,-236.47,-238.26,-240.13,-242.07,-244.1,-246.22,-248.43,-250.74,-253.14,-255.65,-258.27,-261.0,-263.84,-266.81,-269.91,-273.14,-276.51,-280.03,-283.7,-287.53,-291.54,-295.72,-300.08,-304.65,-309.42,-314.42,-319.64,-325.1,-330.83,-336.83,-343.11,-349.71,-356.63,-363.9,-371.54,-379.57,-388.03,-396.94,-406.33,-416.24,-426.72,-437.79,-449.52,-461.95,-475.15,-489.18,-504.12,-520.05,-537.06,-555.27,-574.8,-595.78,-618.38,-642.78,-669.19,-697.88,-729.12,-763.27,-800.74,-842.03,-887.72,-938.56,-995.45,-1059.5,-1132.1,-1215.2,-1311.1,-1422.9,-1555.1,-1713.5,-1907.0,-2148.4,-2458.0,-2869.4,-3442.5,-4295.3,-5698.9,-8439.9,-16166.0,-178360.0,19895.0,9456.6,6217.8,4640.2,3706.9,3090.1,2652.3,2325.5,2072.3,1870.4,1705.6,1568.6,1453.0,1354.1,1268.5,1193.8,1128.0,1069.6,1017.4,970.55,928.22,889.81,854.8,822.77,793.35,766.24,741.18,717.96,696.38,676.27,657.5,},
{633.49,651.1,669.96,690.19,711.94,735.39,760.74,788.23,818.14,850.79,886.57,925.95,969.5,1017.9,1072.0,1132.9,1201.8,1280.6,1371.4,1477.3,1602.2,1751.8,1934.2,2161.5,2452.4,2838.0,3373.3,4166.2,5461.3,7956.2,14754.0,106600.0,-20205.0,-9188.0,-5929.6,-4368.6,-3452.9,-2851.0,-2425.3,-2108.4,-1863.3,-1668.2,-1509.2,-1377.2,-1265.9,-1170.7,-1088.5,-1016.8,-953.66,-897.69,-847.74,-802.91,-762.46,-725.78,-692.39,-661.86,-633.86,-608.1,-584.31,-562.29,-541.86,-522.86,-505.14,-488.6,-473.11,-458.6,-444.97,-432.15,-420.07,-408.69,-397.93,-387.77,-378.15,-369.03,-360.39,-352.19,-344.39,-336.98,-329.93,-323.21,-316.81,-310.71,-304.89,-299.34,-294.03,-288.96,-284.12,-279.48,-275.05,-270.8,-266.74,-262.85,-259.13,-255.56,-252.13,-248.86,-245.71,-242.7,-239.81,-237.04,-234.38,-231.83,-229.38,-227.04,-224.79,-222.63,-220.56,-218.57,-216.67,-214.85,-213.1,-211.42,-209.81,-208.27,-206.8,-205.39,-204.04,-202.74,-201.5,-200.32,-199.19,-198.11,-197.07,-196.09,-195.14,-194.24,-193.39,-192.57,-191.79,-191.05,-190.35,-189.68,-189.05,-188.44,-187.87,-187.33,-186.82,-186.33,-185.87,-185.44,-185.03,-184.65,-184.29,-183.95,-183.63,-183.33,-183.05,-182.79,-182.55,-182.32,-182.11,-181.91,-181.73,-181.57,-181.41,-181.27,-181.14,-181.02,-180.91,-180.81,-180.72,-180.64,-180.56,-180.5,-180.44,-180.39,-180.34,-180.3,-180.26,-180.23,-180.2,-180.18,-180.16,-180.14,-180.13,-180.12,-180.11,-180.1,-180.09,-180.09,-180.08,-180.08,-180.08,-180.08,-180.08,-180.07,-180.07,-180.07,-180.07,-180.07,-180.07,-180.07,-180.07,-180.07,-180.08,-180.08,-180.08,-180.08,-180.08,-180.09,-180.09,-180.1,-180.1,-180.11,-180.13,-180.14,-180.16,-180.18,-180.2,-180.23,-180.26,-180.29,-180.33,-180.38,-180.43,-180.49,-180.55,-180.63,-180.71,-180.8,-180.89,-181.0,-181.12,-181.25,-181.39,-181.54,-181.71,-181.89,-182.08,-182.29,-182.51,-182.75,-183.01,-183.29,-183.59,-183.9,-184.24,-184.6,-184.98,-185.38,-185.81,-186.26,-186.74,-187.25,-187.79,-188.36,-188.95,-189.59,-190.25,-190.95,-191.68,-192.45,-193.26,-194.11,-195.01,-195.94,-196.92,-197.95,-199.02,-200.15,-201.32,-202.55,-203.84,-205.18,-206.59,-208.05,-209.58,-211.18,-212.84,-214.58,-216.4,-218.29,-220.26,-222.32,-224.46,-226.7,-229.03,-231.46,-233.99,-236.63,-239.39,-242.26,-245.26,-248.38,-251.64,-255.04,-258.59,-262.29,-266.15,-270.19,-274.4,-278.81,-283.41,-288.23,-293.26,-298.53,-304.05,-309.83,-315.89,-322.24,-328.91,-335.91,-343.27,-351.0,-359.14,-367.72,-376.76,-386.31,-396.39,-407.05,-418.34,-430.31,-443.01,-456.52,-470.9,-486.23,-502.61,-520.15,-538.95,-559.16,-580.93,-604.44,-629.9,-657.55,-687.68,-720.62,-756.78,-796.64,-840.78,-889.91,-944.92,-1006.9,-1077.3,-1157.8,-1250.8,-1359.5,-1488.1,-1642.6,-1831.6,-2068.1,-2372.5,-2778.8,-3348.2,-4203.5,-5631.6,-8496.5,-17158.0,1510300.0,16912.0,8538.8,5727.2,4317.8,3471.1,2906.3,2502.8,2200.1,1964.8,1776.6,1622.7,1494.5,1386.1,1293.3,1212.8,1142.5,1080.6,1025.5,976.36,932.14,892.18,855.9,822.81,792.52,764.69,739.03,715.31,693.32,},
{665.73,686.22,708.29,732.15,758.0,786.09,816.74,850.31,887.21,927.97,973.23,1023.7,1080.5,1144.7,1217.9,1302.2,1400.1,1515.4,1653.0,1820.0,2027.2,2290.7,2637.2,3112.9,3806.8,4913.0,6954.0,11980.0,44326.0,-25685.0,-9900.8,-6111.0,-4408.4,-3441.2,-2817.7,-2382.4,-2061.4,-1814.9,-1619.7,-1461.3,-1330.3,-1220.1,-1126.2,-1045.3,-974.75,-912.79,-857.94,-809.05,-765.22,-725.71,-689.92,-657.36,-627.62,-600.35,-575.27,-552.14,-530.73,-510.88,-492.42,-475.21,-459.15,-444.12,-430.04,-416.81,-404.38,-392.67,-381.63,-371.21,-361.36,-352.03,-343.2,-334.82,-326.87,-319.32,-312.13,-305.3,-298.79,-292.59,-286.67,-281.03,-275.65,-270.5,-265.58,-260.88,-256.39,-252.09,-247.97,-244.03,-240.25,-236.63,-233.16,-229.84,-226.65,-223.6,-220.67,-217.86,-215.16,-212.57,-210.09,-207.71,-205.42,-203.23,-201.13,-199.11,-197.17,-195.31,-193.53,-191.82,-190.18,-188.61,-187.1,-185.66,-184.28,-182.95,-181.68,-180.47,-179.3,-178.19,-177.13,-176.11,-175.14,-174.21,-173.32,-172.48,-171.67,-170.91,-170.17,-169.48,-168.82,-168.19,-167.59,-167.02,-166.48,-165.98,-165.49,-165.04,-164.61,-164.2,-163.82,-163.46,-163.12,-162.8,-162.5,-162.22,-161.96,-161.72,-161.49,-161.28,-161.09,-160.91,-160.74,-160.59,-160.44,-160.31,-160.2,-160.09,-159.99,-159.9,-159.82,-159.75,-159.68,-159.63,-159.58,-159.53,-159.5,-159.46,-159.43,-159.41,-159.39,-159.37,-159.36,-159.35,-159.34,-159.34,-159.34,-159.33,-159.33,-159.33,-159.33,-159.34,-159.34,-159.34,-159.34,-159.35,-159.35,-159.35,-159.35,-159.35,-159.36,-159.36,-159.36,-159.36,-159.35,-159.35,-159.35,-159.35,-159.34,-159.34,-159.34,-159.34,-159.33,-159.33,-159.33,-159.33,-159.33,-159.34,-159.34,-159.35,-159.36,-159.37,-159.39,-159.41,-159.43,-159.46,-159.49,-159.53,-159.57,-159.62,-159.68,-159.74,-159.81,-159.89,-159.98,-160.07,-160.18,-160.3,-160.42,-160.56,-160.72,-160.88,-161.06,-161.25,-161.46,-161.69,-161.93,-162.18,-162.46,-162.76,-163.07,-163.41,-163.76,-164.14,-164.55,-164.97,-165.42,-165.9,-166.41,-166.94,-167.5,-168.1,-168.72,-169.38,-170.07,-170.79,-171.56,-172.36,-173.2,-174.08,-175.0,-175.96,-176.97,-178.03,-179.13,-180.29,-181.5,-182.76,-184.07,-185.45,-186.88,-188.38,-189.94,-191.57,-193.27,-195.04,-196.89,-198.81,-200.82,-202.91,-205.09,-207.36,-209.73,-212.2,-214.77,-217.45,-220.24,-223.16,-226.19,-229.36,-232.66,-236.11,-239.7,-243.45,-247.37,-251.46,-255.74,-260.2,-264.87,-269.76,-274.87,-280.22,-285.82,-291.69,-297.85,-304.31,-311.1,-318.22,-325.72,-333.61,-341.93,-350.69,-359.94,-369.71,-380.05,-390.99,-402.6,-414.92,-428.02,-441.97,-456.86,-472.76,-489.78,-508.05,-527.69,-548.85,-571.72,-596.49,-623.42,-652.77,-684.89,-720.17,-759.09,-802.24,-850.32,-904.22,-965.04,-1034.2,-1113.5,-1205.3,-1312.7,-1440.3,-1594.1,-1783.0,-2020.7,-2328.7,-2743.5,-3332.1,-4232.3,-5780.5,-9068.3,-20781.0,74302.0,13430.0,7414.3,5136.0,3938.0,3199.2,2698.2,2336.1,2062.3,1848.0,1675.7,1534.2,1416.0,1315.8,1229.7,1155.0,1089.5,1031.8,980.38,934.4,893.01,855.57,821.54,790.48,762.02,735.86,},
{703.71,727.88,754.13,782.73,814.01,848.36,886.25,928.25,975.05,1027.5,1086.7,1154.1,1231.4,1321.0,1426.0,1550.8,1701.5,1887.2,2121.4,2426.0,2838.3,3427.7,4338.9,5934.2,9446.3,23518.0,-46490.0,-11598.0,-6595.3,-4593.5,-3515.6,-2842.0,-2381.2,-2046.3,-1791.8,-1592.0,-1431.0,-1298.5,-1187.6,-1093.5,-1012.5,-942.21,-880.59,-826.15,-777.73,-734.38,-695.37,-660.07,-628.0,-598.74,-571.94,-547.31,-524.61,-503.62,-484.17,-466.09,-449.25,-433.54,-418.84,-405.08,-392.16,-380.01,-368.58,-357.81,-347.64,-338.02,-328.93,-320.31,-312.14,-304.39,-297.03,-290.02,-283.36,-277.02,-270.97,-265.21,-259.71,-254.46,-249.44,-244.65,-240.07,-235.68,-231.49,-227.47,-223.63,-219.94,-216.41,-213.03,-209.78,-206.67,-203.69,-200.83,-198.08,-195.44,-192.91,-190.49,-188.16,-185.92,-183.77,-181.71,-179.73,-177.83,-176.01,-174.26,-172.59,-170.98,-169.43,-167.95,-166.53,-165.17,-163.86,-162.61,-161.41,-160.27,-159.17,-158.12,-157.11,-156.15,-155.23,-154.36,-153.52,-152.72,-151.96,-151.23,-150.54,-149.88,-149.26,-148.66,-148.09,-147.56,-147.05,-146.57,-146.11,-145.68,-145.27,-144.89,-144.53,-144.19,-143.87,-143.57,-143.29,-143.02,-142.78,-142.55,-142.34,-142.14,-141.96,-141.79,-141.63,-141.49,-141.36,-141.24,-141.13,-141.03,-140.95,-140.87,-140.79,-140.73,-140.68,-140.63,-140.58,-140.55,-140.52,-140.49,-140.47,-140.45,-140.44,-140.43,-140.43,-140.42,-140.42,-140.42,-140.43,-140.43,-140.44,-140.44,-140.45,-140.46,-140.46,-140.47,-140.48,-140.49,-140.49,-140.5,-140.5,-140.51,-140.51,-140.51,-140.52,-140.52,-140.52,-140.52,-140.51,-140.51,-140.5,-140.5,-140.49,-140.49,-140.48,-140.47,-140.46,-140.46,-140.45,-140.44,-140.44,-140.43,-140.43,-140.42,-140.42,-140.42,-140.43,-140.43,-140.44,-140.45,-140.47,-140.49,-140.51,-140.54,-140.58,-140.62,-140.67,-140.72,-140.78,-140.85,-140.93,-141.02,-141.12,-141.22,-141.34,-141.47,-141.61,-141.77,-141.93,-142.11,-142.31,-142.52,-142.74,-142.99,-143.25,-143.53,-143.82,-144.14,-144.48,-144.83,-145.21,-145.62,-146.05,-146.5,-146.98,-147.48,-148.01,-148.57,-149.16,-149.79,-150.44,-151.13,-151.85,-152.61,-153.4,-154.23,-155.1,-156.01,-156.97,-157.97,-159.01,-160.1,-161.24,-162.43,-163.67,-164.97,-166.32,-167.73,-169.21,-170.74,-172.34,-174.01,-175.75,-177.56,-179.45,-181.41,-183.46,-185.59,-187.82,-190.13,-192.55,-195.06,-197.68,-200.41,-203.26,-206.22,-209.31,-212.54,-215.9,-219.41,-223.07,-226.89,-230.88,-235.05,-239.4,-243.96,-248.72,-253.7,-258.91,-264.37,-270.1,-276.1,-282.4,-289.01,-295.96,-303.27,-310.97,-319.07,-327.62,-336.64,-346.17,-356.26,-366.94,-378.27,-390.31,-403.11,-416.74,-431.29,-446.85,-463.51,-481.4,-500.64,-521.39,-543.82,-568.15,-594.61,-623.48,-655.11,-689.9,-728.33,-770.98,-818.6,-872.07,-932.54,-1001.4,-1080.7,-1172.7,-1280.8,-1409.7,-1566.0,-1759.2,-2004.2,-2324.9,-2762.9,-3396.5,-4394.2,-6195.8,-10428.0,-32171.0,30259.0,10363.0,6279.5,4518.5,3537.5,2912.4,2479.2,2161.5,1918.5,1726.6,1571.4,1443.2,1335.5,1243.9,1164.9,1096.2,1035.9,982.46,934.88,892.22,853.76,818.91,787.2,},
{749.15,778.14,809.92,844.91,883.63,926.68,974.83,1029.0,1090.5,1160.8,1241.9,1336.6,1448.5,1582.7,1746.8,1951.7,2215.0,2565.5,3055.2,3787.2,5000.4,7400.3,14394.0,331330.0,-15567.0,-7558.7,-4971.2,-3692.5,-2930.2,-2424.0,-2063.6,-1794.0,-1584.6,-1417.5,-1281.0,-1167.4,-1071.4,-989.29,-918.23,-856.15,-801.47,-752.94,-709.61,-670.68,-635.52,-603.63,-574.57,-547.99,-523.6,-501.14,-480.39,-461.18,-443.34,-426.74,-411.26,-396.79,-383.24,-370.54,-358.6,-347.37,-336.78,-326.8,-317.36,-308.44,-299.99,-291.98,-284.38,-277.16,-270.29,-263.76,-257.55,-251.63,-245.98,-240.59,-235.45,-230.54,-225.84,-221.35,-217.06,-212.95,-209.01,-205.24,-201.63,-198.17,-194.86,-191.67,-188.62,-185.7,-182.89,-180.19,-177.6,-175.12,-172.74,-170.45,-168.25,-166.14,-164.11,-162.17,-160.3,-158.5,-156.78,-155.13,-153.54,-152.02,-150.55,-149.15,-147.81,-146.52,-145.28,-144.09,-142.96,-141.87,-140.83,-139.83,-138.88,-137.97,-137.09,-136.26,-135.46,-134.7,-133.98,-133.29,-132.63,-132.0,-131.41,-130.84,-130.3,-129.79,-129.31,-128.85,-128.42,-128.01,-127.62,-127.25,-126.91,-126.59,-126.28,-126.0,-125.73,-125.48,-125.25,-125.04,-124.83,-124.65,-124.48,-124.32,-124.17,-124.04,-123.92,-123.81,-123.71,-123.62,-123.53,-123.46,-123.4,-123.34,-123.29,-123.25,-123.22,-123.19,-123.16,-123.14,-123.13,-123.12,-123.11,-123.11,-123.11,-123.11,-123.12,-123.12,-123.13,-123.14,-123.15,-123.17,-123.18,-123.19,-123.2,-123.22,-123.23,-123.24,-123.25,-123.26,-123.27,-123.28,-123.29,-123.3,-123.3,-123.31,-123.31,-123.31,-123.31,-123.31,-123.3,-123.3,-123.29,-123.28,-123.28,-123.27,-123.26,-123.24,-123.23,-123.22,-123.21,-123.19,-123.18,-123.17,-123.15,-123.14,-123.13,-123.12,-123.12,-123.11,-123.11,-123.11,-123.11,-123.12,-123.13,-123.14,-123.16,-123.18,-123.21,-123.25,-123.29,-123.33,-123.39,-123.45,-123.52,-123.6,-123.69,-123.79,-123.9,-124.02,-124.15,-124.3,-124.45,-124.62,-124.81,-125.0,-125.22,-125.45,-125.69,-125.96,-126.24,-126.54,-126.86,-127.2,-127.56,-127.95,-128.35,-128.78,-129.24,-129.72,-130.23,-130.76,-131.32,-131.91,-132.54,-133.19,-133.88,-134.59,-135.35,-136.14,-136.97,-137.83,-138.74,-139.69,-140.68,-141.71,-142.79,-143.92,-145.1,-146.33,-147.61,-148.95,-150.34,-151.8,-153.31,-154.89,-156.53,-158.24,-160.03,-161.88,-163.82,-165.83,-167.93,-170.11,-172.39,-174.76,-177.23,-179.8,-182.48,-185.27,-188.18,-191.21,-194.37,-197.67,-201.11,-204.7,-208.44,-212.35,-216.43,-220.7,-225.16,-229.82,-234.7,-239.81,-245.16,-250.77,-256.65,-262.82,-269.3,-276.11,-283.28,-290.82,-298.77,-307.15,-316.01,-325.36,-335.26,-345.76,-356.89,-368.72,-381.31,-394.72,-409.05,-424.37,-440.8,-458.45,-477.44,-497.95,-520.15,-544.24,-570.47,-599.14,-630.59,-665.23,-703.56,-746.2,-793.89,-847.59,-908.48,-978.09,-1058.4,-1152.1,-1262.8,-1395.5,-1557.5,-1759.6,-2018.7,-2363.0,-2842.4,-3555.7,-4729.1,-7018.6,-13459.0,-144390.0,16765.0,7973.0,5252.1,3928.1,3145.1,2627.8,2260.7,1986.6,1774.3,1605.0,1466.9,1352.0,1255.0,1172.1,1100.3,1037.7,982.47,933.49,889.73,850.42,},
{804.45,839.94,879.3,923.21,972.48,1028.2,1091.6,1164.5,1249.1,1348.4,1466.8,1610.2,1787.5,2012.1,2305.9,2706.7,3285.8,4195.9,5834.0,9654.2,28704.0,-28713.0,-9485.9,-5651.6,-4009.7,-3098.1,-2518.2,-2116.9,-1822.9,-1598.1,-1420.8,-1277.4,-1159.0,-1059.6,-975.07,-902.26,-838.92,-783.32,-734.14,-690.35,-651.1,-615.75,-583.73,-554.62,-528.04,-503.68,-481.27,-460.61,-441.5,-423.77,-407.28,-391.93,-377.59,-364.17,-351.59,-339.79,-328.68,-318.22,-308.36,-299.05,-290.25,-281.91,-274.01,-266.52,-259.41,-252.65,-246.22,-240.1,-234.27,-228.71,-223.41,-218.34,-213.51,-208.89,-204.47,-200.25,-196.2,-192.33,-188.62,-185.07,-181.66,-178.4,-175.27,-172.26,-169.38,-166.62,-163.96,-161.41,-158.96,-156.61,-154.36,-152.19,-150.1,-148.1,-146.18,-144.34,-142.56,-140.86,-139.23,-137.66,-136.15,-134.7,-133.31,-131.98,-130.7,-129.47,-128.29,-127.16,-126.08,-125.05,-124.05,-123.1,-122.19,-121.32,-120.49,-119.7,-118.94,-118.21,-117.52,-116.86,-116.23,-115.63,-115.06,-114.52,-114.0,-113.52,-113.05,-112.61,-112.2,-111.81,-111.44,-111.09,-110.76,-110.45,-110.16,-109.89,-109.63,-109.4,-109.17,-108.97,-108.78,-108.6,-108.44,-108.29,-108.15,-108.02,-107.91,-107.81,-107.71,-107.63,-107.55,-107.49,-107.43,-107.38,-107.34,-107.3,-107.27,-107.25,-107.23,-107.21,-107.2,-107.2,-107.2,-107.2,-107.21,-107.21,-107.22,-107.24,-107.25,-107.27,-107.28,-107.3,-107.32,-107.34,-107.36,-107.38,-107.39,-107.41,-107.43,-107.44,-107.46,-107.47,-107.49,-107.5,-107.51,-107.51,-107.52,-107.53,-107.53,-107.53,-107.53,-107.53,-107.52,-107.52,-107.51,-107.5,-107.49,-107.47,-107.46,-107.45,-107.43,-107.41,-107.4,-107.38,-107.36,-107.34,-107.32,-107.3,-107.29,-107.27,-107.25,-107.24,-107.23,-107.22,-107.21,-107.2,-107.2,-107.2,-107.2,-107.21,-107.22,-107.24,-107.27,-107.29,-107.33,-107.37,-107.42,-107.48,-107.54,-107.62,-107.7,-107.79,-107.89,-108.01,-108.13,-108.27,-108.41,-108.58,-108.75,-108.94,-109.14,-109.36,-109.6,-109.85,-110.12,-110.41,-110.71,-111.04,-111.38,-111.75,-112.14,-112.55,-112.99,-113.45,-113.93,-114.44,-114.98,-115.54,-116.14,-116.76,-117.42,-118.11,-118.83,-119.58,-120.37,-121.2,-122.06,-122.97,-123.91,-124.9,-125.93,-127.0,-128.12,-129.29,-130.51,-131.78,-133.11,-134.49,-135.93,-137.43,-138.99,-140.61,-142.31,-144.07,-145.9,-147.81,-149.8,-151.87,-154.03,-156.27,-158.61,-161.04,-163.57,-166.21,-168.96,-171.83,-174.81,-177.93,-181.17,-184.55,-188.09,-191.77,-195.62,-199.63,-203.83,-208.22,-212.81,-217.61,-222.64,-227.9,-233.42,-239.21,-245.29,-251.67,-258.38,-265.44,-272.87,-280.71,-288.98,-297.71,-306.95,-316.72,-327.09,-338.09,-349.79,-362.25,-375.54,-389.73,-404.93,-421.24,-438.78,-457.68,-478.1,-500.23,-524.28,-550.52,-579.23,-610.79,-645.62,-684.24,-727.32,-775.63,-830.2,-892.3,-963.57,-1046.2,-1143.1,-1258.4,-1397.6,-1569.2,-1785.7,-2067.6,-2449.6,-2996.1,-3842.6,-5329.1,-8621.6,-22095.0,40744.0,10704.0,6196.2,4377.5,3394.6,2779.1,2357.5,2050.7,1817.5,1634.2,1486.4,1364.7,1262.8,1176.2,1101.8,1037.1,980.33,930.17,},
{873.26,917.81,967.96,1024.8,1089.9,1164.9,1252.6,1356.1,1480.5,1632.4,1822.3,2066.3,2391.4,2845.9,3526.3,4656.0,6899.2,13500.0,462530.0,-14123.0,-6904.6,-4546.9,-3377.2,-2678.3,-2213.8,-1882.6,-1634.7,-1442.2,-1288.4,-1162.7,-1058.1,-969.74,-894.08,-828.6,-771.39,-720.98,-676.25,-636.28,-600.38,-567.95,-538.53,-511.72,-487.19,-464.67,-443.94,-424.78,-407.04,-390.56,-375.23,-360.92,-347.55,-335.03,-323.28,-312.24,-301.85,-292.06,-282.82,-274.09,-265.82,-258.0,-250.58,-243.53,-236.84,-230.48,-224.43,-218.66,-213.17,-207.92,-202.92,-198.14,-193.58,-189.22,-185.04,-181.05,-177.22,-173.56,-170.05,-166.68,-163.46,-160.36,-157.4,-154.55,-151.81,-149.19,-146.67,-144.25,-141.92,-139.69,-137.54,-135.48,-133.5,-131.6,-129.77,-128.01,-126.32,-124.7,-123.14,-121.64,-120.21,-118.83,-117.5,-116.23,-115.0,-113.83,-112.71,-111.63,-110.59,-109.6,-108.65,-107.74,-106.87,-106.04,-105.24,-104.48,-103.75,-103.05,-102.39,-101.76,-101.15,-100.58,-100.03,-99.511,-99.017,-98.548,-98.103,-97.681,-97.282,-96.905,-96.549,-96.213,-95.897,-95.6,-95.321,-95.059,-94.815,-94.587,-94.374,-94.176,-93.993,-93.824,-93.668,-93.524,-93.393,-93.273,-93.165,-93.066,-92.978,-92.9,-92.83,-92.769,-92.716,-92.67,-92.632,-92.6,-92.575,-92.555,-92.541,-92.532,-92.528,-92.527,-92.531,-92.538,-92.548,-92.561,-92.576,-92.593,-92.613,-92.633,-92.655,-92.678,-92.701,-92.725,-92.749,-92.773,-92.797,-92.82,-92.842,-92.864,-92.884,-92.903,-92.921,-92.938,-92.952,-92.965,-92.976,-92.986,-92.993,-92.998,-93.002,-93.003,-93.002,-92.999,-92.994,-92.987,-92.978,-92.967,-92.954,-92.94,-92.924,-92.906,-92.887,-92.867,-92.846,-92.823,-92.8,-92.777,-92.753,-92.729,-92.705,-92.681,-92.659,-92.636,-92.616,-92.596,-92.578,-92.563,-92.55,-92.539,-92.532,-92.528,-92.527,-92.531,-92.54,-92.553,-92.572,-92.596,-92.627,-92.664,-92.709,-92.76,-92.82,-92.889,-92.966,-93.053,-93.149,-93.256,-93.374,-93.504,-93.646,-93.8,-93.967,-94.148,-94.344,-94.554,-94.78,-95.022,-95.281,-95.557,-95.852,-96.165,-96.498,-96.851,-97.225,-97.62,-98.039,-98.48,-98.946,-99.436,-99.953,-100.5,-101.07,-101.67,-102.29,-102.95,-103.64,-104.37,-105.13,-105.92,-106.75,-107.61,-108.51,-109.46,-110.44,-111.47,-112.54,-113.66,-114.83,-116.04,-117.31,-118.62,-120.0,-121.43,-122.91,-124.46,-126.08,-127.76,-129.5,-131.32,-133.21,-135.18,-137.23,-139.36,-141.58,-143.9,-146.3,-148.81,-151.42,-154.13,-156.97,-159.92,-162.99,-166.2,-169.54,-173.03,-176.67,-180.47,-184.44,-188.58,-192.92,-197.45,-202.2,-207.17,-212.37,-217.83,-223.55,-229.56,-235.88,-242.52,-249.51,-256.87,-264.63,-272.83,-281.49,-290.65,-300.36,-310.66,-321.6,-333.23,-345.64,-358.88,-373.04,-388.21,-404.51,-422.06,-440.99,-461.48,-483.72,-507.93,-534.39,-563.4,-595.35,-630.71,-670.03,-714.0,-763.5,-819.62,-883.76,-957.76,-1044.1,-1146.0,-1268.1,-1417.2,-1603.1,-1841.4,-2157.7,-2597.8,-3251.8,-4325.6,-6413.4,-12234.0,-116090.0,15759.0,7436.2,4890.8,3657.3,2929.4,2449.2,2108.6,1854.6,1657.9,1501.1,1373.2,1266.8,1177.1,1100.3,1033.9,},
{961.22,1019.0,1085.2,1162.0,1252.1,1359.3,1488.7,1648.3,1849.8,2112.3,2468.3,2978.4,3770.1,5165.5,8278.8,21359.0,-35291.0,-9552.4,-5487.1,-3831.0,-2932.1,-2367.9,-1980.8,-1698.8,-1484.2,-1315.6,-1179.5,-1067.4,-973.56,-893.8,-825.2,-765.58,-713.31,-667.12,-626.01,-589.19,-556.04,-526.04,-498.77,-473.88,-451.08,-430.12,-410.78,-392.91,-376.33,-360.92,-346.56,-333.15,-320.61,-308.86,-297.82,-287.44,-277.67,-268.45,-259.75,-251.52,-243.72,-236.34,-229.34,-222.68,-216.36,-210.35,-204.62,-199.16,-193.96,-189.0,-184.26,-179.73,-175.4,-171.26,-167.3,-163.51,-159.88,-156.4,-153.06,-149.86,-146.79,-143.85,-141.03,-138.32,-135.71,-133.21,-130.81,-128.5,-126.29,-124.16,-122.11,-120.14,-118.25,-116.43,-114.69,-113.01,-111.39,-109.84,-108.35,-106.92,-105.54,-104.22,-102.95,-101.73,-100.56,-99.435,-98.356,-97.321,-96.329,-95.377,-94.465,-93.591,-92.753,-91.952,-91.185,-90.452,-89.751,-89.082,-88.442,-87.832,-87.251,-86.697,-86.169,-85.667,-85.19,-84.737,-84.308,-83.901,-83.515,-83.151,-82.807,-82.482,-82.177,-81.889,-81.62,-81.367,-81.131,-80.91,-80.705,-80.514,-80.337,-80.174,-80.023,-79.885,-79.759,-79.644,-79.54,-79.446,-79.362,-79.288,-79.222,-79.165,-79.115,-79.073,-79.039,-79.011,-78.989,-78.973,-78.962,-78.957,-78.956,-78.959,-78.967,-78.978,-78.992,-79.009,-79.028,-79.05,-79.073,-79.099,-79.125,-79.153,-79.181,-79.21,-79.239,-79.268,-79.296,-79.325,-79.352,-79.379,-79.405,-79.43,-79.453,-79.475,-79.495,-79.513,-79.529,-79.544,-79.556,-79.567,-79.575,-79.581,-79.584,-79.585,-79.585,-79.581,-79.576,-79.568,-79.558,-79.546,-79.532,-79.515,-79.497,-79.478,-79.456,-79.433,-79.409,-79.383,-79.356,-79.329,-79.301,-79.272,-79.243,-79.214,-79.185,-79.157,-79.129,-79.102,-79.077,-79.053,-79.031,-79.011,-78.994,-78.979,-78.968,-78.96,-78.956,-78.956,-78.961,-78.971,-78.986,-79.007,-79.034,-79.068,-79.109,-79.157,-79.213,-79.277,-79.35,-79.433,-79.525,-79.628,-79.741,-79.866,-80.002,-80.15,-80.312,-80.487,-80.675,-80.879,-81.097,-81.331,-81.581,-81.848,-82.133,-82.436,-82.757,-83.098,-83.46,-83.842,-84.246,-84.672,-85.121,-85.595,-86.093,-86.617,-87.167,-87.744,-88.35,-88.985,-89.65,-90.346,-91.074,-91.836,-92.632,-93.464,-94.332,-95.239,-96.185,-97.171,-98.2,-99.272,-100.39,-101.55,-102.77,-104.03,-105.34,-106.71,-108.13,-109.62,-111.16,-112.76,-114.43,-116.17,-117.98,-119.86,-121.81,-123.85,-125.96,-128.17,-130.46,-132.85,-135.33,-137.92,-140.62,-143.42,-146.35,-149.4,-152.58,-155.89,-159.35,-162.96,-166.73,-170.66,-174.77,-179.07,-183.57,-188.28,-193.21,-198.37,-203.79,-209.48,-215.45,-221.72,-228.33,-235.28,-242.6,-250.33,-258.49,-267.13,-276.27,-285.95,-296.24,-307.17,-318.82,-331.24,-344.51,-358.72,-373.97,-390.36,-408.04,-427.14,-447.85,-470.37,-494.93,-521.83,-551.4,-584.05,-620.28,-660.71,-706.09,-757.39,-815.81,-882.96,-960.9,-1052.5,-1161.5,-1293.5,-1456.7,-1663.3,-1933.4,-2301.5,-2832.5,-3665.1,-5157.9,-8610.7,-25249.0,27991.0,9101.5,5469.0,3926.7,3073.7,2532.3,2158.3,1884.4,1675.2,1510.3,1376.9,1266.9,1174.5,},
{1077.6,1155.7,1247.6,1357.5,1491.2,1657.2,1868.9,2148.2,2533.3,3098.4,4008.1,5715.2,10085.0,45394.0,-17721.0,-7340.0,-4599.4,-3333.4,-2604.4,-2130.5,-1797.8,-1551.4,-1361.7,-1211.1,-1088.7,-987.27,-901.86,-828.97,-766.04,-711.18,-662.94,-620.2,-582.08,-547.87,-517.02,-489.05,-463.59,-440.31,-418.97,-399.32,-381.18,-364.39,-348.81,-334.31,-320.79,-308.15,-296.33,-285.24,-274.82,-265.01,-255.77,-247.05,-238.82,-231.02,-223.64,-216.64,-210.0,-203.69,-197.69,-191.98,-186.54,-181.36,-176.41,-171.69,-167.18,-162.87,-158.76,-154.81,-151.04,-147.43,-143.97,-140.65,-137.47,-134.42,-131.49,-128.68,-125.98,-123.39,-120.9,-118.51,-116.22,-114.01,-111.89,-109.85,-107.89,-106.01,-104.2,-102.46,-100.78,-99.173,-97.625,-96.137,-94.706,-93.331,-92.01,-90.739,-89.519,-88.347,-87.221,-86.14,-85.102,-84.105,-83.15,-82.233,-81.354,-80.511,-79.704,-78.931,-78.191,-77.483,-76.807,-76.16,-75.542,-74.952,-74.39,-73.854,-73.343,-72.857,-72.395,-71.956,-71.54,-71.145,-70.771,-70.418,-70.084,-69.769,-69.472,-69.193,-68.931,-68.685,-68.456,-68.241,-68.042,-67.856,-67.684,-67.526,-67.38,-67.246,-67.123,-67.012,-66.911,-66.821,-66.74,-66.669,-66.606,-66.551,-66.505,-66.466,-66.434,-66.408,-66.389,-66.376,-66.368,-66.365,-66.367,-66.374,-66.384,-66.398,-66.415,-66.436,-66.459,-66.484,-66.511,-66.54,-66.571,-66.603,-66.635,-66.668,-66.702,-66.735,-66.769,-66.802,-66.835,-66.867,-66.898,-66.928,-66.956,-66.983,-67.009,-67.033,-67.055,-67.075,-67.093,-67.108,-67.122,-67.133,-67.142,-67.148,-67.152,-67.153,-67.152,-67.149,-67.143,-67.134,-67.124,-67.11,-67.095,-67.077,-67.058,-67.036,-67.013,-66.987,-66.96,-66.932,-66.902,-66.872,-66.84,-66.807,-66.774,-66.74,-66.707,-66.673,-66.64,-66.607,-66.576,-66.545,-66.516,-66.488,-66.462,-66.439,-66.418,-66.401,-66.386,-66.375,-66.368,-66.365,-66.367,-66.374,-66.387,-66.405,-66.429,-66.46,-66.498,-66.544,-66.597,-66.659,-66.729,-66.808,-66.897,-66.996,-67.106,-67.227,-67.359,-67.503,-67.66,-67.83,-68.013,-68.211,-68.423,-68.65,-68.893,-69.153,-69.429,-69.723,-70.036,-70.367,-70.717,-71.088,-71.48,-71.893,-72.328,-72.787,-73.269,-73.776,-74.308,-74.867,-75.452,-76.066,-76.709,-77.381,-78.084,-78.819,-79.587,-80.389,-81.226,-82.1,-83.011,-83.961,-84.951,-85.983,-87.057,-88.177,-89.342,-90.555,-91.818,-93.131,-94.498,-95.921,-97.4,-98.939,-100.54,-102.2,-103.94,-105.74,-107.61,-109.56,-111.58,-113.69,-115.89,-118.17,-120.54,-123.02,-125.59,-128.27,-131.06,-133.97,-137.01,-140.17,-143.46,-146.9,-150.49,-154.24,-158.16,-162.25,-166.53,-171.01,-175.7,-180.61,-185.75,-191.15,-196.82,-202.78,-209.04,-215.63,-222.58,-229.9,-237.63,-245.8,-254.44,-263.6,-273.32,-283.65,-294.63,-306.35,-318.86,-332.24,-346.59,-362.0,-378.6,-396.53,-415.94,-437.03,-460.0,-485.11,-512.69,-543.09,-576.76,-614.26,-656.27,-703.62,-757.42,-819.04,-890.31,-973.67,-1072.5,-1191.4,-1337.2,-1520.2,-1756.6,-2073.8,-2521.6,-3201.2,-4355.3,-6746.9,-14662.0,95651.0,11392.0,6105.4,4192.8,3205.7,2603.3,2197.4,1905.5,1685.4,1513.5,1375.7,},
{1238.9,1350.7,1487.5,1658.5,1878.4,2171.9,2582.8,3199.5,4227.6,6284.6,12460.0,-14159000.0,-12212.0,-6052.4,-3998.3,-2971.3,-2355.1,-1944.5,-1651.2,-1431.4,-1260.5,-1123.9,-1012.2,-919.15,-840.5,-773.15,-714.83,-663.86,-618.94,-579.06,-543.42,-511.39,-482.46,-456.2,-432.27,-410.37,-390.26,-371.73,-354.62,-338.76,-324.03,-310.31,-297.52,-285.55,-274.35,-263.83,-253.94,-244.64,-235.86,-227.58,-219.75,-212.34,-205.32,-198.66,-192.33,-186.32,-180.61,-175.17,-169.98,-165.04,-160.32,-155.81,-151.51,-147.4,-143.46,-139.7,-136.09,-132.63,-129.32,-126.15,-123.11,-120.19,-117.38,-114.69,-112.11,-109.63,-107.24,-104.95,-102.75,-100.63,-98.598,-96.642,-94.76,-92.951,-91.21,-89.537,-87.927,-86.379,-84.89,-83.458,-82.081,-80.757,-79.485,-78.261,-77.085,-75.955,-74.869,-73.826,-72.824,-71.862,-70.939,-70.053,-69.204,-68.389,-67.608,-66.86,-66.144,-65.458,-64.803,-64.176,-63.577,-63.005,-62.459,-61.938,-61.443,-60.97,-60.521,-60.095,-59.689,-59.305,-58.941,-58.597,-58.271,-57.964,-57.675,-57.403,-57.147,-56.907,-56.683,-56.473,-56.278,-56.097,-55.929,-55.774,-55.631,-55.5,-55.381,-55.272,-55.174,-55.086,-55.007,-54.937,-54.877,-54.824,-54.779,-54.742,-54.712,-54.688,-54.671,-54.66,-54.654,-54.653,-54.657,-54.666,-54.679,-54.695,-54.715,-54.738,-54.764,-54.792,-54.822,-54.855,-54.889,-54.924,-54.96,-54.997,-55.035,-55.072,-55.11,-55.148,-55.185,-55.222,-55.258,-55.293,-55.327,-55.359,-55.39,-55.419,-55.446,-55.472,-55.495,-55.517,-55.536,-55.552,-55.567,-55.579,-55.588,-55.595,-55.599,-55.6,-55.599,-55.595,-55.589,-55.58,-55.569,-55.555,-55.538,-55.52,-55.499,-55.476,-55.45,-55.423,-55.394,-55.364,-55.332,-55.298,-55.263,-55.228,-55.191,-55.154,-55.116,-55.078,-55.04,-55.003,-54.965,-54.929,-54.894,-54.86,-54.827,-54.796,-54.768,-54.742,-54.718,-54.698,-54.681,-54.668,-54.658,-54.654,-54.654,-54.659,-54.669,-54.686,-54.708,-54.737,-54.773,-54.817,-54.868,-54.928,-54.996,-55.073,-55.16,-55.257,-55.364,-55.482,-55.611,-55.752,-55.905,-56.071,-56.25,-56.443,-56.651,-56.873,-57.11,-57.363,-57.633,-57.92,-58.225,-58.547,-58.889,-59.25,-59.631,-60.033,-60.457,-60.902,-61.371,-61.863,-62.38,-62.922,-63.49,-64.085,-64.708,-65.359,-66.04,-66.752,-67.495,-68.271,-69.08,-69.925,-70.805,-71.722,-72.678,-73.674,-74.711,-75.79,-76.914,-78.083,-79.3,-80.565,-81.881,-83.25,-84.674,-86.154,-87.693,-89.294,-90.957,-92.688,-94.487,-96.357,-98.303,-100.33,-102.43,-104.62,-106.9,-109.27,-111.73,-114.3,-116.98,-119.76,-122.67,-125.69,-128.84,-132.13,-135.57,-139.15,-142.89,-146.8,-150.89,-155.16,-159.64,-164.32,-169.23,-174.38,-179.78,-185.46,-191.42,-197.7,-204.31,-211.27,-218.62,-226.39,-234.6,-243.3,-252.52,-262.32,-272.74,-283.84,-295.69,-308.36,-321.93,-336.5,-352.18,-369.1,-387.41,-407.27,-428.89,-452.51,-478.4,-506.91,-538.45,-573.51,-612.71,-656.83,-706.83,-763.96,-829.84,-906.64,-997.3,-1105.9,-1238.3,-1403.4,-1614.7,-1894.9,-2284.0,-2860.9,-3804.4,-5626.2,-10618.0,-82413.0,14617.0,6780.0,4441.9,3318.4,2658.4,2224.0,1916.6,1687.6,},
{1477.4,1651.7,1877.6,2181.9,2613.8,3275.0,4413.7,6838.4,15551.0,-51936.0,-9571.7,-5224.9,-3571.0,-2699.4,-2161.4,-1796.3,-1532.2,-1332.5,-1176.1,-1050.4,-947.12,-860.81,-787.61,-724.76,-670.21,-622.44,-580.27,-542.77,-509.21,-479.02,-451.71,-426.89,-404.26,-383.52,-364.47,-346.91,-330.67,-315.61,-301.62,-288.59,-276.42,-265.03,-254.37,-244.35,-234.93,-226.06,-217.69,-209.79,-202.32,-195.25,-188.54,-182.18,-176.14,-170.39,-164.93,-159.72,-154.76,-150.03,-145.51,-141.2,-137.08,-133.14,-129.37,-125.76,-122.3,-118.98,-115.81,-112.76,-109.84,-107.04,-104.35,-101.76,-99.28,-96.895,-94.603,-92.399,-90.281,-88.245,-86.286,-84.403,-82.591,-80.848,-79.172,-77.559,-76.007,-74.514,-73.078,-71.697,-70.368,-69.089,-67.86,-66.678,-65.541,-64.449,-63.399,-62.389,-61.42,-60.489,-59.595,-58.737,-57.913,-57.123,-56.366,-55.64,-54.945,-54.279,-53.642,-53.033,-52.45,-51.894,-51.362,-50.855,-50.372,-49.912,-49.474,-49.058,-48.662,-48.287,-47.931,-47.595,-47.276,-46.976,-46.692,-46.425,-46.175,-45.94,-45.719,-45.514,-45.322,-45.144,-44.979,-44.827,-44.686,-44.557,-44.44,-44.333,-44.236,-44.149,-44.072,-44.004,-43.944,-43.893,-43.849,-43.813,-43.784,-43.761,-43.745,-43.735,-43.73,-43.731,-43.737,-43.747,-43.761,-43.779,-43.801,-43.826,-43.853,-43.884,-43.917,-43.952,-43.988,-44.027,-44.066,-44.106,-44.147,-44.189,-44.231,-44.272,-44.314,-44.355,-44.395,-44.435,-44.473,-44.511,-44.547,-44.581,-44.614,-44.645,-44.674,-44.7,-44.725,-44.747,-44.767,-44.785,-44.8,-44.812,-44.822,-44.829,-44.833,-44.835,-44.833,-44.83,-44.823,-44.814,-44.802,-44.787,-44.77,-44.75,-44.728,-44.704,-44.678,-44.649,-44.618,-44.586,-44.552,-44.516,-44.479,-44.441,-44.401,-44.361,-44.32,-44.278,-44.237,-44.195,-44.153,-44.112,-44.072,-44.032,-43.994,-43.957,-43.922,-43.889,-43.858,-43.83,-43.804,-43.782,-43.763,-43.748,-43.738,-43.732,-43.73,-43.734,-43.743,-43.759,-43.78,-43.808,-43.843,-43.886,-43.936,-43.994,-44.061,-44.137,-44.223,-44.318,-44.423,-44.539,-44.666,-44.805,-44.956,-45.119,-45.295,-45.485,-45.688,-45.906,-46.139,-46.387,-46.651,-46.932,-47.23,-47.546,-47.88,-48.233,-48.605,-48.998,-49.411,-49.846,-50.302,-50.782,-51.285,-51.813,-52.366,-52.944,-53.55,-54.183,-54.844,-55.535,-56.256,-57.009,-57.794,-58.612,-59.465,-60.354,-61.279,-62.243,-63.246,-64.29,-65.376,-66.506,-67.681,-68.904,-70.175,-71.496,-72.869,-74.297,-75.782,-77.324,-78.928,-80.595,-82.328,-84.129,-86.002,-87.949,-89.974,-92.079,-94.27,-96.548,-98.919,-101.39,-103.96,-106.63,-109.42,-112.32,-115.35,-118.5,-121.8,-125.23,-128.82,-132.57,-136.48,-140.58,-144.86,-149.34,-154.04,-158.97,-164.14,-169.56,-175.27,-181.26,-187.57,-194.23,-201.24,-208.66,-216.49,-224.79,-233.58,-242.91,-252.84,-263.41,-274.68,-286.73,-299.63,-313.47,-328.36,-344.42,-361.77,-380.59,-401.06,-423.4,-447.87,-474.78,-504.52,-537.55,-574.42,-615.85,-662.72,-716.17,-777.67,-849.18,-933.33,-1033.8,-1155.7,-1306.9,-1499.1,-1751.8,-2098.5,-2603.9,-3408.8,-4891.1,-8526.5,-31434.0,19234.0,7453.8,4657.0,3404.5,2694.0,2236.3,},
{1865.9,2177.0,2623.7,3319.0,4550.3,7325.0,19412.0,-28334.0,-8068.1,-4662.4,-3257.9,-2491.3,-2008.6,-1676.8,-1434.6,-1250.2,-1105.1,-987.98,-891.44,-810.53,-741.75,-682.58,-631.14,-586.01,-546.12,-510.61,-478.8,-450.15,-424.21,-400.63,-379.1,-359.37,-341.22,-324.49,-309.0,-294.64,-281.29,-268.84,-257.22,-246.34,-236.14,-226.56,-217.55,-209.07,-201.06,-193.49,-186.34,-179.56,-173.13,-167.03,-161.24,-155.73,-150.49,-145.49,-140.73,-136.19,-131.85,-127.71,-123.75,-119.96,-116.34,-112.86,-109.54,-106.35,-103.3,-100.37,-97.555,-94.856,-92.264,-89.774,-87.383,-85.084,-82.875,-80.75,-78.708,-76.743,-74.854,-73.036,-71.287,-69.604,-67.984,-66.426,-64.926,-63.483,-62.094,-60.758,-59.472,-58.234,-57.044,-55.899,-54.798,-53.739,-52.721,-51.742,-50.801,-49.898,-49.03,-48.196,-47.396,-46.628,-45.892,-45.185,-44.509,-43.86,-43.24,-42.646,-42.078,-41.535,-41.016,-40.521,-40.049,-39.599,-39.171,-38.764,-38.376,-38.009,-37.66,-37.33,-37.017,-36.722,-36.443,-36.181,-35.934,-35.703,-35.486,-35.283,-35.094,-34.918,-34.755,-34.605,-34.466,-34.338,-34.222,-34.116,-34.02,-33.934,-33.857,-33.789,-33.73,-33.679,-33.636,-33.6,-33.571,-33.549,-33.533,-33.524,-33.519,-33.521,-33.527,-33.538,-33.553,-33.572,-33.595,-33.621,-33.651,-33.683,-33.717,-33.754,-33.793,-33.834,-33.875,-33.919,-33.962,-34.007,-34.052,-34.097,-34.142,-34.187,-34.232,-34.276,-34.319,-34.36,-34.401,-34.44,-34.478,-34.514,-34.548,-34.581,-34.611,-34.639,-34.664,-34.687,-34.708,-34.726,-34.742,-34.754,-34.764,-34.772,-34.776,-34.778,-34.777,-34.772,-34.766,-34.756,-34.744,-34.729,-34.711,-34.691,-34.668,-34.643,-34.615,-34.585,-34.553,-34.519,-34.484,-34.446,-34.407,-34.367,-34.325,-34.282,-34.238,-34.194,-34.149,-34.104,-34.059,-34.014,-33.969,-33.925,-33.882,-33.84,-33.799,-33.76,-33.723,-33.688,-33.655,-33.625,-33.599,-33.575,-33.555,-33.54,-33.528,-33.521,-33.519,-33.523,-33.531,-33.546,-33.567,-33.595,-33.63,-33.672,-33.722,-33.78,-33.846,-33.922,-34.006,-34.101,-34.205,-34.32,-34.446,-34.583,-34.732,-34.893,-35.067,-35.254,-35.455,-35.67,-35.899,-36.143,-36.403,-36.679,-36.972,-37.282,-37.61,-37.956,-38.32,-38.705,-39.109,-39.534,-39.981,-40.45,-40.941,-41.456,-41.995,-42.56,-43.15,-43.766,-44.411,-45.083,-45.785,-46.517,-47.28,-48.075,-48.904,-49.766,-50.665,-51.6,-52.573,-53.585,-54.638,-55.733,-56.871,-58.055,-59.285,-60.563,-61.892,-63.273,-64.708,-66.199,-67.749,-69.359,-71.032,-72.771,-74.579,-76.458,-78.411,-80.442,-82.554,-84.75,-87.035,-89.413,-91.888,-94.464,-97.147,-99.942,-102.85,-105.89,-109.06,-112.36,-115.81,-119.41,-123.17,-127.11,-131.22,-135.53,-140.04,-144.77,-149.73,-154.94,-160.4,-166.15,-172.21,-178.58,-185.31,-192.4,-199.91,-207.85,-216.26,-225.19,-234.68,-244.78,-255.56,-267.06,-279.38,-292.6,-306.8,-322.11,-338.65,-356.57,-376.06,-397.31,-420.57,-446.13,-474.35,-505.66,-540.59,-579.78,-624.06,-674.48,-732.4,-799.62,-878.53,-972.47,-1086.2,-1226.5,-1404.1,-1636.1,-1951.7,-2406.2,-3116.7,-4384.1,-7284.5,-20683.0,25821.0,8064.5,4819.2,3456.8,},
{2610.9,3326.9,4622.7,7681.8,23752.0,-20851.0,-7140.1,-4269.1,-3025.1,-2330.5,-1887.2,-1579.8,-1354.2,-1181.5,-1045.2,-934.77,-843.59,-767.02,-701.83,-645.66,-596.77,-553.84,-515.85,-482.0,-451.66,-424.32,-399.54,-377.01,-356.42,-337.55,-320.18,-304.16,-289.33,-275.57,-262.77,-250.84,-239.69,-229.26,-219.47,-210.28,-201.62,-193.47,-185.78,-178.51,-171.63,-165.12,-158.94,-153.07,-147.5,-142.2,-137.15,-132.34,-127.76,-123.39,-119.21,-115.22,-111.4,-107.75,-104.26,-100.91,-97.707,-94.634,-91.686,-88.859,-86.145,-83.539,-81.037,-78.632,-76.322,-74.101,-71.966,-69.913,-67.938,-66.039,-64.211,-62.452,-60.759,-59.13,-57.562,-56.053,-54.6,-53.201,-51.855,-50.559,-49.312,-48.112,-46.957,-45.845,-44.776,-43.747,-42.757,-41.806,-40.891,-40.012,-39.167,-38.356,-37.576,-36.828,-36.11,-35.422,-34.761,-34.128,-33.522,-32.942,-32.387,-31.856,-31.348,-30.864,-30.401,-29.96,-29.54,-29.14,-28.76,-28.399,-28.056,-27.731,-27.424,-27.133,-26.858,-26.599,-26.356,-26.127,-25.912,-25.712,-25.525,-25.35,-25.188,-25.039,-24.9,-24.773,-24.657,-24.552,-24.456,-24.37,-24.293,-24.225,-24.166,-24.114,-24.071,-24.035,-24.006,-23.983,-23.967,-23.957,-23.953,-23.954,-23.961,-23.972,-23.987,-24.007,-24.03,-24.057,-24.087,-24.121,-24.157,-24.195,-24.235,-24.277,-24.321,-24.366,-24.413,-24.46,-24.508,-24.556,-24.604,-24.652,-24.7,-24.748,-24.795,-24.841,-24.886,-24.929,-24.972,-25.013,-25.052,-25.089,-25.125,-25.158,-25.189,-25.218,-25.244,-25.268,-25.289,-25.308,-25.323,-25.337,-25.347,-25.354,-25.359,-25.361,-25.359,-25.355,-25.348,-25.338,-25.326,-25.31,-25.292,-25.271,-25.248,-25.222,-25.193,-25.163,-25.13,-25.095,-25.058,-25.019,-24.978,-24.936,-24.892,-24.847,-24.802,-24.755,-24.707,-24.659,-24.611,-24.563,-24.515,-24.467,-24.42,-24.373,-24.328,-24.284,-24.241,-24.201,-24.162,-24.126,-24.092,-24.062,-24.034,-24.01,-23.99,-23.974,-23.962,-23.955,-23.953,-23.956,-23.966,-23.981,-24.002,-24.03,-24.065,-24.107,-24.158,-24.216,-24.282,-24.358,-24.443,-24.537,-24.641,-24.756,-24.881,-25.017,-25.165,-25.325,-25.498,-25.683,-25.882,-26.094,-26.321,-26.562,-26.819,-27.091,-27.379,-27.684,-28.007,-28.347,-28.705,-29.083,-29.48,-29.897,-30.334,-30.794,-31.275,-31.779,-32.306,-32.858,-33.434,-34.037,-34.666,-35.322,-36.006,-36.72,-37.463,-38.238,-39.045,-39.884,-40.758,-41.668,-42.614,-43.597,-44.62,-45.684,-46.789,-47.937,-49.131,-50.371,-51.66,-52.998,-54.389,-55.833,-57.334,-58.893,-60.513,-62.196,-63.945,-65.763,-67.651,-69.615,-71.656,-73.779,-75.987,-78.283,-80.673,-83.161,-85.751,-88.448,-91.259,-94.188,-97.242,-100.43,-103.75,-107.22,-110.85,-114.64,-118.61,-122.75,-127.1,-131.65,-136.42,-141.43,-146.7,-152.23,-158.05,-164.18,-170.64,-177.46,-184.67,-192.3,-200.38,-208.96,-218.07,-227.76,-238.1,-249.14,-260.95,-273.61,-287.22,-301.88,-317.72,-334.88,-353.51,-373.83,-396.06,-420.48,-447.42,-477.29,-510.57,-547.9,-590.04,-637.97,-692.96,-756.68,-831.38,-920.13,-1027.3,-1159.3,-1325.7,-1542.0,-1834.7,-2252.6,-2898.0,-4025.5,-6497.0,-16256.0,34668.0,8531.4,},
{4620.7,7848.9,27563.0,-17537.0,-6554.7,-3993.6,-2852.1,-2206.2,-1790.8,-1501.1,-1287.7,-1124.0,-994.39,-889.29,-802.35,-729.26,-666.96,-613.24,-566.45,-525.34,-488.93,-456.48,-427.37,-401.13,-377.35,-355.7,-335.92,-317.78,-301.09,-285.68,-271.42,-258.18,-245.86,-234.38,-223.65,-213.6,-204.17,-195.31,-186.98,-179.12,-171.71,-164.7,-158.07,-151.79,-145.83,-140.17,-134.79,-129.68,-124.81,-120.17,-115.74,-111.52,-107.48,-103.63,-99.943,-96.416,-93.039,-89.805,-86.705,-83.734,-80.883,-78.148,-75.523,-73.001,-70.579,-68.252,-66.015,-63.865,-61.797,-59.808,-57.894,-56.053,-54.281,-52.575,-50.934,-49.353,-47.832,-46.367,-44.956,-43.598,-42.29,-41.031,-39.819,-38.652,-37.528,-36.447,-35.406,-34.404,-33.441,-32.514,-31.622,-30.765,-29.941,-29.149,-28.389,-27.658,-26.957,-26.284,-25.638,-25.019,-24.426,-23.857,-23.313,-22.793,-22.295,-21.82,-21.366,-20.932,-20.519,-20.126,-19.752,-19.396,-19.058,-18.737,-18.434,-18.146,-17.875,-17.619,-17.378,-17.151,-16.938,-16.739,-16.552,-16.379,-16.218,-16.068,-15.93,-15.803,-15.687,-15.581,-15.485,-15.398,-15.321,-15.252,-15.192,-15.14,-15.095,-15.058,-15.028,-15.005,-14.988,-14.978,-14.973,-14.973,-14.979,-14.99,-15.005,-15.024,-15.048,-15.075,-15.105,-15.139,-15.176,-15.215,-15.256,-15.299,-15.345,-15.391,-15.439,-15.488,-15.538,-15.589,-15.64,-15.691,-15.742,-15.793,-15.843,-15.893,-15.941,-15.989,-16.036,-16.081,-16.125,-16.167,-16.207,-16.246,-16.282,-16.316,-16.348,-16.377,-16.404,-16.428,-16.45,-16.469,-16.485,-16.498,-16.509,-16.516,-16.521,-16.523,-16.522,-16.517,-16.51,-16.5,-16.487,-16.472,-16.453,-16.432,-16.408,-16.381,-16.352,-16.321,-16.287,-16.251,-16.213,-16.173,-16.131,-16.088,-16.043,-15.996,-15.949,-15.9,-15.85,-15.8,-15.749,-15.698,-15.647,-15.596,-15.546,-15.496,-15.447,-15.398,-15.351,-15.306,-15.262,-15.221,-15.181,-15.144,-15.11,-15.079,-15.052,-15.028,-15.008,-14.992,-14.981,-14.974,-14.973,-14.977,-14.986,-15.002,-15.024,-15.053,-15.089,-15.132,-15.183,-15.242,-15.31,-15.386,-15.471,-15.566,-15.67,-15.785,-15.911,-16.047,-16.195,-16.354,-16.526,-16.71,-16.907,-17.118,-17.343,-17.582,-17.836,-18.105,-18.39,-18.691,-19.009,-19.345,-19.698,-20.069,-20.46,-20.87,-21.3,-21.751,-22.223,-22.717,-23.235,-23.775,-24.34,-24.929,-25.544,-26.186,-26.855,-27.552,-28.278,-29.034,-29.821,-30.64,-31.493,-32.379,-33.301,-34.259,-35.255,-36.289,-37.365,-38.482,-39.642,-40.848,-42.1,-43.4,-44.751,-46.154,-47.61,-49.123,-50.695,-52.327,-54.023,-55.785,-57.616,-59.519,-61.496,-63.553,-65.691,-67.914,-70.228,-72.635,-75.141,-77.751,-80.47,-83.303,-86.256,-89.336,-92.55,-95.905,-99.409,-103.07,-106.9,-110.91,-115.1,-119.5,-124.1,-128.94,-134.02,-139.35,-144.97,-150.88,-157.11,-163.69,-170.64,-178.0,-185.78,-194.04,-202.82,-212.16,-222.11,-232.74,-244.11,-256.29,-269.39,-283.49,-298.72,-315.22,-333.13,-352.65,-374.0,-397.45,-423.3,-451.95,-483.87,-519.65,-560.01,-605.89,-658.48,-719.38,-790.7,-875.34,-977.4,-1102.8,-1260.7,-1465.4,-1741.4,-2133.4,-2734.4,-3771.5,-5989.7,-14069.0,},
{29191.0,-16062.0,-6202.6,-3806.4,-2726.2,-2111.5,-1714.8,-1437.6,-1233.1,-1075.9,-951.45,-850.42,-766.8,-696.46,-636.49,-584.74,-539.66,-500.04,-464.94,-433.65,-405.58,-380.26,-357.32,-336.43,-317.34,-299.83,-283.72,-268.84,-255.07,-242.28,-230.38,-219.29,-208.92,-199.21,-190.1,-181.54,-173.48,-165.89,-158.72,-151.94,-145.53,-139.45,-133.69,-128.22,-123.01,-118.06,-113.35,-108.86,-104.58,-100.49,-96.581,-92.848,-89.278,-85.862,-82.591,-79.457,-76.453,-73.573,-70.81,-68.159,-65.613,-63.168,-60.818,-58.561,-56.39,-54.303,-52.296,-50.365,-48.506,-46.718,-44.996,-43.339,-41.743,-40.207,-38.727,-37.303,-35.93,-34.608,-33.336,-32.11,-30.929,-29.792,-28.697,-27.643,-26.628,-25.651,-24.711,-23.806,-22.935,-22.098,-21.293,-20.519,-19.775,-19.06,-18.373,-17.714,-17.082,-16.475,-15.893,-15.335,-14.801,-14.29,-13.801,-13.333,-12.887,-12.46,-12.053,-11.665,-11.296,-10.945,-10.611,-10.294,-9.9935,-9.7089,-9.4398,-9.1856,-8.9461,-8.7206,-8.5088,-8.3102,-8.1245,-7.9512,-7.7899,-7.6402,-7.5018,-7.3743,-7.2572,-7.1503,-7.0532,-6.9655,-6.8868,-6.8169,-6.7554,-6.7019,-6.6562,-6.6178,-6.5866,-6.5621,-6.5441,-6.5322,-6.5261,-6.5256,-6.5304,-6.5401,-6.5544,-6.5732,-6.596,-6.6227,-6.6529,-6.6864,-6.7229,-6.7622,-6.804,-6.848,-6.894,-6.9417,-6.9909,-7.0414,-7.093,-7.1454,-7.1983,-7.2517,-7.3051,-7.3586,-7.4118,-7.4646,-7.5167,-7.5681,-7.6184,-7.6677,-7.7155,-7.762,-7.8068,-7.8498,-7.8909,-7.9301,-7.967,-8.0017,-8.0341,-8.064,-8.0913,-8.116,-8.138,-8.1572,-8.1736,-8.1871,-8.1977,-8.2054,-8.2101,-8.2118,-8.2105,-8.2062,-8.199,-8.1889,-8.1758,-8.1598,-8.141,-8.1194,-8.0951,-8.0682,-8.0387,-8.0067,-7.9723,-7.9357,-7.8969,-7.856,-7.8133,-7.7687,-7.7225,-7.6749,-7.6258,-7.5756,-7.5244,-7.4724,-7.4197,-7.3665,-7.3131,-7.2596,-7.2062,-7.1532,-7.1007,-7.0491,-6.9984,-6.9489,-6.9009,-6.8547,-6.8104,-6.7683,-6.7286,-6.6917,-6.6577,-6.627,-6.5998,-6.5763,-6.557,-6.5419,-6.5315,-6.526,-6.5257,-6.5309,-6.5419,-6.559,-6.5825,-6.6127,-6.65,-6.6946,-6.7469,-6.8072,-6.8759,-6.9532,-7.0396,-7.1353,-7.2407,-7.3562,-7.4822,-7.619,-7.7669,-7.9265,-8.098,-8.2818,-8.4785,-8.6883,-8.9117,-9.1491,-9.4011,-9.6679,-9.9502,-10.248,-10.563,-10.894,-11.243,-11.609,-11.994,-12.398,-12.822,-13.266,-13.73,-14.216,-14.724,-15.255,-15.809,-16.387,-16.99,-17.618,-18.274,-18.956,-19.667,-20.406,-21.176,-21.976,-22.809,-23.674,-24.574,-25.509,-26.48,-27.489,-28.538,-29.627,-30.757,-31.931,-33.15,-34.416,-35.731,-37.095,-38.512,-39.984,-41.511,-43.098,-44.746,-46.458,-48.236,-50.084,-52.004,-54.0,-56.075,-58.233,-60.477,-62.813,-65.243,-67.774,-70.409,-73.155,-76.018,-79.003,-82.116,-85.367,-88.761,-92.308,-96.016,-99.895,-103.96,-108.21,-112.67,-117.35,-122.26,-127.43,-132.86,-138.58,-144.61,-150.97,-157.69,-164.8,-172.33,-180.31,-188.79,-197.82,-207.44,-217.7,-228.69,-240.46,-253.11,-266.73,-281.43,-297.36,-314.65,-333.49,-354.09,-376.71,-401.66,-429.29,-460.07,-494.56,-533.45,-577.66,-628.32,-686.95,-755.59,-837.01,-935.12,-1055.6,-1207.2,-1403.4,-1667.5,-2042.1,-2614.3,-3596.9,},
{-6031.4,-3691.2,-2639.4,-2041.6,-1656.2,-1387.1,-1188.5,-1036.1,-915.29,-817.3,-736.21,-668.0,-609.85,-559.68,-515.98,-477.56,-443.54,-413.21,-386.0,-361.46,-339.22,-318.98,-300.47,-283.5,-267.88,-253.46,-240.11,-227.71,-216.18,-205.42,-195.37,-185.96,-177.13,-168.83,-161.02,-153.65,-146.7,-140.13,-133.91,-128.02,-122.43,-117.12,-112.07,-107.27,-102.7,-98.338,-94.181,-90.213,-86.422,-82.799,-79.333,-76.017,-72.84,-69.797,-66.88,-64.083,-61.399,-58.822,-56.348,-53.972,-51.689,-49.494,-47.383,-45.354,-43.401,-41.522,-39.714,-37.974,-36.298,-34.684,-33.131,-31.634,-30.193,-28.804,-27.466,-26.178,-24.936,-23.741,-22.588,-21.479,-20.41,-19.38,-18.389,-17.434,-16.515,-15.63,-14.778,-13.959,-13.171,-12.413,-11.684,-10.983,-10.31,-9.6631,-9.0422,-8.4464,-7.8748,-7.3267,-6.8014,-6.2983,-5.8167,-5.356,-4.9156,-4.4948,-4.0932,-3.7101,-3.345,-2.9975,-2.6669,-2.3528,-2.0548,-1.7723,-1.5049,-1.2522,-1.0137,-0.789,-0.57766,-0.37931,-0.19353,-0.019941,0.14184,0.29219,0.43147,0.56005,0.67828,0.78651,0.88507,0.97432,1.0546,1.1262,1.1894,1.2447,1.2922,1.3324,1.3654,1.3917,1.4115,1.4251,1.4328,1.4349,1.4316,1.4233,1.4103,1.3927,1.3709,1.3452,1.3157,1.2829,1.2468,1.2078,1.1662,1.1221,1.0759,1.0277,0.97781,0.92644,0.87381,0.82016,0.76571,0.71066,0.65522,0.5996,0.54401,0.48863,0.43365,0.37926,0.32564,0.27296,0.22138,0.17107,0.12219,0.074871,0.029269,-0.014486,-0.056265,-0.095945,-0.13341,-0.16856,-0.20129,-0.23151,-0.25913,-0.28408,-0.30628,-0.32568,-0.34222,-0.35585,-0.36655,-0.37427,-0.37901,-0.38073,-0.37945,-0.37517,-0.36788,-0.35763,-0.34443,-0.32832,-0.30934,-0.28755,-0.26301,-0.23578,-0.20594,-0.17358,-0.13879,-0.10166,-0.062297,-0.020822,0.022647,0.067983,0.11505,0.16371,0.21382,0.26522,0.31775,0.37124,0.42553,0.48043,0.53576,0.59134,0.64696,0.70244,0.75756,0.81212,0.8659,0.91869,0.97026,1.0204,1.0689,1.1154,1.1598,1.2018,1.2412,1.2777,1.3111,1.341,1.3673,1.3897,1.4079,1.4217,1.4307,1.4347,1.4334,1.4266,1.4139,1.3951,1.3698,1.3377,1.2987,1.2522,1.1982,1.1361,1.0658,0.98681,0.89892,0.80176,0.69499,0.57827,0.45125,0.31358,0.1649,0.0048379,-0.16697,-0.35092,-0.54738,-0.75676,-0.97945,-1.2159,-1.4665,-1.7317,-2.0119,-2.3076,-2.6192,-2.9473,-3.2923,-3.6547,-4.0351,-4.4339,-4.8518,-5.2893,-5.7469,-6.2254,-6.7253,-7.2472,-7.7918,-8.3599,-8.9521,-9.5692,-10.212,-10.881,-11.578,-12.302,-13.056,-13.84,-14.655,-15.501,-16.381,-17.295,-18.245,-19.231,-20.254,-21.317,-22.421,-23.567,-24.756,-25.99,-27.272,-28.602,-29.983,-31.416,-32.905,-34.45,-36.054,-37.721,-39.451,-41.249,-43.117,-45.059,-47.077,-49.175,-51.357,-53.627,-55.989,-58.448,-61.009,-63.677,-66.457,-69.356,-72.38,-75.536,-78.831,-82.274,-85.874,-89.639,-93.58,-97.708,-102.04,-106.58,-111.34,-116.35,-121.62,-127.17,-133.01,-139.18,-145.7,-152.59,-159.89,-167.64,-175.86,-184.61,-193.93,-203.89,-214.53,-225.95,-238.21,-251.41,-265.66,-281.1,-297.86,-316.12,-336.09,-358.02,-382.2,-408.98,-438.82,-472.25,-509.96,-552.81,-601.93,-658.78,-725.34,-804.29,-899.46,-1016.4,-1163.4,-1353.9,-1610.3,-1974.1,},
{-2587.0,-1993.7,-1613.0,-1348.0,-1152.9,-1003.4,-885.13,-789.27,-710.0,-643.38,-586.61,-537.67,-495.05,-457.6,-424.45,-394.9,-368.39,-344.5,-322.85,-303.14,-285.13,-268.62,-253.42,-239.39,-226.4,-214.34,-203.12,-192.66,-182.89,-173.73,-165.15,-157.08,-149.48,-142.32,-135.56,-129.17,-123.12,-117.39,-111.95,-106.79,-101.88,-97.214,-92.767,-88.529,-84.485,-80.626,-76.938,-73.413,-70.042,-66.814,-63.724,-60.763,-57.924,-55.201,-52.588,-50.08,-47.671,-45.357,-43.133,-40.995,-38.939,-36.961,-35.059,-33.227,-31.465,-29.768,-28.134,-26.56,-25.044,-23.584,-22.177,-20.821,-19.515,-18.257,-17.044,-15.875,-14.749,-13.664,-12.619,-11.612,-10.642,-9.707,-8.8069,-7.9402,-7.1057,-6.3025,-5.5295,-4.7858,-4.0704,-3.3825,-2.7212,-2.0858,-1.4754,-0.88929,-0.32675,0.21292,0.7304,1.2263,1.7013,2.156,2.5909,3.0067,3.4039,3.783,4.1445,4.4889,4.8168,5.1286,5.4247,5.7057,5.9718,6.2237,6.4616,6.6861,6.8974,7.096,7.2823,7.4566,7.6193,7.7707,7.9113,8.0413,8.1611,8.271,8.3714,8.4626,8.5448,8.6185,8.6839,8.7413,8.791,8.8334,8.8686,8.8971,8.919,8.9347,8.9445,8.9486,8.9473,8.9408,8.9295,8.9136,8.8933,8.8689,8.8408,8.809,8.7739,8.7357,8.6947,8.6511,8.6051,8.557,8.5069,8.4552,8.4021,8.3477,8.2922,8.236,8.1791,8.1219,8.0644,8.007,7.9497,7.8928,7.8364,7.7807,7.726,7.6723,7.6198,7.5686,7.519,7.471,7.4249,7.3806,7.3384,7.2983,7.2605,7.225,7.1921,7.1616,7.1338,7.1087,7.0864,7.0669,7.0502,7.0365,7.0258,7.018,7.0133,7.0115,7.0128,7.0171,7.0245,7.0348,7.048,7.0642,7.0833,7.1052,7.1299,7.1573,7.1874,7.22,7.2551,7.2925,7.3323,7.3742,7.4182,7.4641,7.5118,7.5612,7.6121,7.6644,7.7179,7.7726,7.8281,7.8844,7.9412,7.9984,8.0559,8.1134,8.1706,8.2276,8.2839,8.3395,8.394,8.4474,8.4994,8.5496,8.5981,8.6444,8.6884,8.7298,8.7684,8.804,8.8363,8.865,8.8899,8.9108,8.9274,8.9394,8.9466,8.9487,8.9455,8.9366,8.9217,8.9007,8.8733,8.839,8.7978,8.7492,8.6929,8.6287,8.5563,8.4754,8.3855,8.2865,8.178,8.0597,7.9313,7.7923,7.6425,7.4815,7.3089,7.1244,6.9277,6.7183,6.4958,6.2599,6.0102,5.7461,5.4674,5.1736,4.8642,4.5387,4.1967,3.8378,3.4614,3.0669,2.6539,2.2219,1.7701,1.2982,0.80544,0.29121,-0.24512,-0.80422,-1.3868,-1.9935,-2.6252,-3.2826,-3.9665,-4.6777,-5.4172,-6.1857,-6.9844,-7.8142,-8.676,-9.5711,-10.5,-11.465,-12.467,-13.507,-14.586,-15.705,-16.868,-18.074,-19.325,-20.624,-21.972,-23.371,-24.823,-26.331,-27.896,-29.521,-31.208,-32.961,-34.782,-36.674,-38.64,-40.684,-42.81,-45.021,-47.321,-49.715,-52.209,-54.806,-57.512,-60.333,-63.276,-66.347,-69.553,-72.903,-76.404,-80.067,-83.9,-87.916,-92.125,-96.54,-101.18,-106.05,-111.17,-116.56,-122.25,-128.25,-134.59,-141.29,-148.39,-155.92,-163.91,-172.42,-181.49,-191.17,-201.52,-212.62,-224.55,-237.39,-251.26,-266.28,-282.59,-300.36,-319.8,-341.15,-364.69,-390.78,-419.84,-452.42,-489.18,-530.97,-578.89,-634.38,-699.38,-776.55,-869.64,-984.11,-1128.3,-1315.3,},
{-1583.8,-1319.3,-1125.4,-977.27,-860.38,-765.81,-687.75,-622.22,-566.44,-518.4,-476.6,-439.89,-407.42,-378.49,-352.56,-329.19,-308.02,-288.76,-271.17,-255.03,-240.19,-226.49,-213.82,-202.05,-191.11,-180.9,-171.36,-162.43,-154.06,-146.19,-138.78,-131.8,-125.21,-118.98,-113.09,-107.5,-102.2,-97.168,-92.385,-87.833,-83.498,-79.366,-75.425,-71.662,-68.068,-64.632,-61.344,-58.198,-55.185,-52.297,-49.528,-46.873,-44.325,-41.878,-39.528,-37.271,-35.101,-33.014,-31.008,-29.077,-27.22,-25.432,-23.711,-22.053,-20.457,-18.919,-17.438,-16.011,-14.635,-13.31,-12.033,-10.801,-9.6148,-8.4711,-7.3688,-6.3063,-5.2823,-4.2955,-3.3446,-2.4284,-1.5457,-0.69537,0.12354,0.9121,1.6713,2.402,3.1051,3.7815,4.432,5.0574,5.6584,6.2358,6.7902,7.3224,7.833,8.3226,8.7918,9.2412,9.6714,10.083,10.476,10.852,11.211,11.552,11.878,12.188,12.483,12.763,13.028,13.28,13.517,13.742,13.954,14.153,14.34,14.515,14.679,14.832,14.975,15.106,15.228,15.34,15.443,15.536,15.621,15.697,15.764,15.824,15.877,15.921,15.959,15.99,16.015,16.033,16.045,16.052,16.053,16.048,16.039,16.025,16.007,15.984,15.958,15.928,15.894,15.857,15.817,15.774,15.729,15.682,15.632,15.58,15.527,15.473,15.417,15.36,15.302,15.244,15.185,15.126,15.067,15.008,14.949,14.891,14.834,14.777,14.721,14.667,14.614,14.562,14.512,14.463,14.417,14.372,14.33,14.289,14.251,14.216,14.183,14.152,14.124,14.099,14.077,14.057,14.041,14.027,14.016,14.008,14.003,14.002,14.003,14.007,14.015,14.025,14.038,14.055,14.074,14.096,14.12,14.148,14.178,14.211,14.246,14.284,14.324,14.366,14.41,14.456,14.505,14.554,14.606,14.659,14.713,14.769,14.825,14.883,14.941,14.999,15.058,15.117,15.176,15.235,15.293,15.351,15.408,15.464,15.519,15.573,15.624,15.674,15.722,15.768,15.811,15.851,15.889,15.923,15.954,15.981,16.004,16.023,16.037,16.047,16.052,16.052,16.046,16.035,16.018,15.994,15.964,15.928,15.884,15.833,15.774,15.707,15.632,15.549,15.457,15.356,15.245,15.125,14.995,14.854,14.703,14.541,14.367,14.182,13.984,13.774,13.552,13.316,13.066,12.803,12.525,12.233,11.925,11.602,11.262,10.906,10.533,10.142,9.7337,9.3063,8.8598,8.3936,7.907,7.3996,6.8707,6.3196,5.7457,5.1482,4.5265,3.8798,3.2073,2.5082,1.7816,1.0268,0.24262,-0.57172,-1.4173,-2.2951,-3.2063,-4.152,-5.1334,-6.1517,-7.2084,-8.3047,-9.4422,-10.622,-11.847,-13.117,-14.435,-15.803,-17.223,-18.696,-20.225,-21.812,-23.46,-25.172,-26.95,-28.797,-30.716,-32.711,-34.785,-36.943,-39.187,-41.523,-43.955,-46.488,-49.127,-51.878,-54.748,-57.742,-60.868,-64.134,-67.547,-71.118,-74.855,-78.769,-82.872,-87.175,-91.694,-96.442,-101.44,-106.69,-112.24,-118.09,-124.26,-130.8,-137.72,-145.06,-152.86,-161.16,-170.0,-179.44,-189.54,-200.37,-212.01,-224.55,-238.09,-252.75,-268.68,-286.05,-305.04,-325.91,-348.93,-374.46,-402.91,-434.82,-470.84,-511.82,-558.85,-613.37,-677.29,-753.28,-845.08,-958.19,},
{-1105.5,-957.18,-840.6,-746.56,-669.1,-604.21,-549.06,-501.62,-460.39,-424.24,-392.27,-363.82,-338.34,-315.38,-294.6,-275.7,-258.45,-242.63,-228.09,-214.67,-202.26,-190.74,-180.03,-170.04,-160.71,-151.98,-143.79,-136.09,-128.85,-122.03,-115.59,-109.5,-103.74,-98.278,-93.101,-88.184,-83.511,-79.064,-74.83,-70.794,-66.944,-63.269,-59.757,-56.401,-53.19,-50.116,-47.172,-44.351,-41.646,-39.052,-36.562,-34.171,-31.875,-29.668,-27.547,-25.508,-23.546,-21.659,-19.843,-18.094,-16.41,-14.789,-13.227,-11.723,-10.273,-8.8755,-7.5288,-6.2309,-4.9796,-3.7735,-2.6106,-1.4896,-0.40881,0.63313,1.6376,2.6059,3.5392,4.4387,5.3056,6.141,6.9458,7.721,8.4677,9.1866,9.8786,10.545,11.185,11.802,12.394,12.964,13.511,14.037,14.541,15.025,15.489,15.934,16.36,16.768,17.158,17.531,17.887,18.227,18.551,18.86,19.153,19.433,19.698,19.949,20.187,20.412,20.625,20.825,21.013,21.19,21.356,21.51,21.654,21.788,21.912,22.026,22.131,22.227,22.314,22.393,22.464,22.526,22.581,22.629,22.67,22.704,22.731,22.752,22.767,22.776,22.78,22.778,22.771,22.76,22.744,22.724,22.699,22.671,22.639,22.604,22.565,22.524,22.48,22.433,22.385,22.334,22.281,22.226,22.171,22.113,22.055,21.996,21.937,21.877,21.816,21.756,21.696,21.636,21.576,21.517,21.459,21.401,21.345,21.29,21.236,21.184,21.134,21.085,21.038,20.994,20.951,20.91,20.872,20.837,20.803,20.773,20.745,20.72,20.697,20.678,20.661,20.648,20.637,20.629,20.624,20.623,20.624,20.628,20.635,20.646,20.659,20.675,20.694,20.716,20.741,20.769,20.799,20.832,20.867,20.905,20.945,20.987,21.032,21.078,21.126,21.177,21.229,21.282,21.337,21.393,21.45,21.508,21.567,21.627,21.687,21.747,21.807,21.868,21.928,21.988,22.047,22.105,22.162,22.218,22.273,22.326,22.377,22.426,22.473,22.518,22.559,22.598,22.634,22.666,22.695,22.72,22.741,22.758,22.77,22.777,22.78,22.777,22.769,22.755,22.734,22.708,22.675,22.636,22.589,22.535,22.474,22.404,22.327,22.241,22.146,22.043,21.93,21.807,21.675,21.532,21.379,21.215,21.04,20.854,20.655,20.445,20.221,19.985,19.736,19.473,19.196,18.904,18.598,18.276,17.939,17.585,17.214,16.827,16.422,15.998,15.556,15.095,14.614,14.113,13.591,13.047,12.48,11.891,11.279,10.641,9.9792,9.2911,8.5762,7.8338,7.0628,6.2625,5.4318,4.5696,3.675,2.7467,1.7837,0.78473,-0.25155,-1.3265,-2.4414,-3.598,-4.7976,-6.042,-7.3329,-8.6722,-10.062,-11.504,-13.0,-14.553,-16.166,-17.84,-19.579,-21.385,-23.261,-25.212,-27.239,-29.348,-31.541,-33.824,-36.2,-38.675,-41.254,-43.942,-46.745,-49.671,-52.724,-55.914,-59.249,-62.737,-66.387,-70.21,-74.218,-78.422,-82.836,-87.475,-92.354,-97.492,-102.91,-108.62,-114.66,-121.05,-127.81,-134.99,-142.61,-150.73,-159.38,-168.61,-178.5,-189.1,-200.49,-212.77,-226.03,-240.4,-256.01,-273.04,-291.68,-312.16,-334.77,-359.86,-387.84,-419.24,-454.72,-495.13,-541.56,-595.45,-658.74,-734.11,},
{-825.51,-731.23,-653.81,-589.11,-534.25,-487.14,-446.26,-410.46,-378.85,-350.74,-325.58,-302.94,-282.46,-263.85,-246.87,-231.31,-217.01,-203.83,-191.63,-180.32,-169.81,-160.01,-150.85,-142.29,-134.26,-126.71,-119.62,-112.93,-106.62,-100.66,-95.014,-89.668,-84.599,-79.785,-75.209,-70.857,-66.712,-62.761,-58.993,-55.396,-51.959,-48.674,-45.532,-42.524,-39.643,-36.882,-34.235,-31.695,-29.258,-26.918,-24.67,-22.51,-20.434,-18.437,-16.516,-14.668,-12.889,-11.176,-9.5268,-7.9382,-6.4077,-4.9331,-3.5119,-2.1422,-0.82177,0.45119,1.6785,2.8619,4.003,5.1034,6.1644,7.1876,8.1743,9.1256,10.043,10.927,11.78,12.602,13.394,14.157,14.892,15.6,16.282,16.939,17.571,18.179,18.764,19.326,19.867,20.387,20.886,21.365,21.824,22.265,22.688,23.092,23.48,23.85,24.205,24.543,24.866,25.173,25.467,25.746,26.011,26.262,26.501,26.727,26.94,27.142,27.331,27.51,27.677,27.834,27.98,28.116,28.243,28.359,28.467,28.566,28.656,28.737,28.811,28.877,28.935,28.986,29.029,29.066,29.097,29.121,29.139,29.151,29.158,29.159,29.155,29.146,29.133,29.115,29.093,29.067,29.037,29.004,28.968,28.928,28.886,28.84,28.793,28.743,28.691,28.637,28.582,28.525,28.467,28.408,28.348,28.288,28.226,28.165,28.103,28.042,27.981,27.92,27.859,27.8,27.741,27.683,27.626,27.571,27.517,27.465,27.414,27.365,27.318,27.274,27.231,27.19,27.152,27.117,27.084,27.053,27.025,27.0,26.978,26.958,26.942,26.928,26.917,26.91,26.905,26.903,26.904,26.909,26.916,26.926,26.94,26.956,26.975,26.997,27.021,27.049,27.079,27.112,27.147,27.185,27.225,27.267,27.312,27.358,27.407,27.457,27.509,27.563,27.618,27.675,27.732,27.791,27.85,27.911,27.972,28.033,28.094,28.156,28.217,28.278,28.339,28.399,28.459,28.517,28.574,28.629,28.683,28.735,28.786,28.834,28.879,28.922,28.962,28.999,29.033,29.063,29.089,29.112,29.13,29.145,29.154,29.159,29.158,29.152,29.141,29.124,29.101,29.071,29.035,28.993,28.943,28.886,28.821,28.749,28.668,28.58,28.482,28.376,28.261,28.136,28.001,27.856,27.701,27.535,27.359,27.17,26.971,26.759,26.535,26.299,26.049,25.786,25.509,25.218,24.912,24.592,24.256,23.904,23.536,23.151,22.749,22.329,21.891,21.434,20.958,20.462,19.946,19.408,18.849,18.267,17.663,17.034,16.381,15.703,14.999,14.268,13.509,12.721,11.904,11.056,10.176,9.2641,8.3179,7.3365,6.3188,5.2635,4.1691,3.0341,1.8571,0.63641,-0.62965,-1.9429,-3.3052,-4.7186,-6.1851,-7.7071,-9.2869,-10.927,-12.63,-14.399,-16.237,-18.147,-20.132,-22.196,-24.344,-26.578,-28.904,-31.327,-33.851,-36.481,-39.225,-42.088,-45.076,-48.198,-51.462,-54.875,-58.448,-62.19,-66.113,-70.228,-74.549,-79.09,-83.867,-88.898,-94.201,-99.798,-105.71,-111.97,-118.6,-125.63,-133.11,-141.06,-149.55,-158.61,-168.31,-178.71,-189.9,-201.96,-214.99,-229.11,-244.47,-261.23,-279.59,-299.77,-322.07,-346.82,-374.46,-405.52,-440.65,-480.7,-526.8,-580.39,},
{-641.7,-576.77,-521.85,-474.8,-434.06,-398.43,-367.02,-339.12,-314.19,-291.77,-271.51,-253.11,-236.34,-220.98,-206.88,-193.88,-181.86,-170.72,-160.37,-150.73,-141.73,-133.3,-125.41,-118.0,-111.02,-104.46,-98.259,-92.404,-86.865,-81.619,-76.644,-71.921,-67.433,-63.163,-59.098,-55.224,-51.528,-48.001,-44.632,-41.411,-38.33,-35.381,-32.557,-29.85,-27.255,-24.765,-22.376,-20.082,-17.878,-15.76,-13.724,-11.766,-9.8821,-8.0694,-6.3245,-4.6444,-3.0264,-1.4677,0.034076,1.4813,2.8763,4.221,5.5174,6.7675,7.973,9.1356,10.257,11.338,12.381,13.387,14.358,15.294,16.196,17.067,17.906,18.716,19.496,20.248,20.973,21.671,22.344,22.992,23.616,24.217,24.795,25.352,25.887,26.401,26.895,27.37,27.825,28.263,28.682,29.084,29.469,29.838,30.19,30.527,30.849,31.157,31.449,31.728,31.994,32.246,32.485,32.712,32.927,33.13,33.321,33.502,33.671,33.83,33.978,34.117,34.246,34.366,34.476,34.578,34.671,34.756,34.832,34.901,34.963,35.017,35.064,35.104,35.138,35.165,35.187,35.202,35.212,35.216,35.215,35.21,35.199,35.184,35.165,35.142,35.115,35.084,35.05,35.012,34.972,34.928,34.882,34.834,34.783,34.731,34.676,34.62,34.563,34.504,34.444,34.384,34.322,34.26,34.198,34.135,34.073,34.011,33.949,33.887,33.826,33.766,33.707,33.649,33.592,33.537,33.482,33.43,33.379,33.331,33.284,33.239,33.196,33.156,33.118,33.082,33.049,33.019,32.991,32.966,32.944,32.925,32.908,32.895,32.884,32.876,32.871,32.87,32.871,32.875,32.883,32.893,32.906,32.922,32.941,32.963,32.987,33.015,33.045,33.077,33.113,33.15,33.19,33.232,33.277,33.323,33.372,33.422,33.475,33.528,33.584,33.64,33.698,33.757,33.817,33.878,33.939,34.001,34.064,34.126,34.189,34.251,34.313,34.374,34.435,34.495,34.554,34.612,34.668,34.723,34.776,34.827,34.875,34.922,34.965,35.006,35.044,35.079,35.11,35.138,35.162,35.182,35.197,35.209,35.215,35.216,35.213,35.204,35.189,35.169,35.142,35.11,35.07,35.024,34.971,34.911,34.843,34.768,34.684,34.592,34.492,34.383,34.264,34.137,34.0,33.853,33.695,33.527,33.349,33.159,32.958,32.745,32.52,32.282,32.032,31.769,31.492,31.201,30.896,30.576,30.241,29.891,29.525,29.142,28.743,28.326,27.892,27.439,26.967,26.475,25.964,25.432,24.879,24.305,23.707,23.087,22.442,21.773,21.078,20.357,19.609,18.833,18.028,17.193,16.328,15.43,14.499,13.534,12.533,11.496,10.42,9.3048,8.1484,6.9494,5.7061,4.4166,3.0792,1.6919,0.25253,-1.241,-2.7911,-4.4001,-6.0708,-7.8059,-9.6083,-11.481,-13.428,-15.452,-17.558,-19.749,-22.029,-24.404,-26.878,-29.457,-32.147,-34.954,-37.884,-40.945,-44.144,-47.491,-50.994,-54.663,-58.51,-62.546,-66.785,-71.24,-75.927,-80.863,-86.068,-91.562,-97.368,-103.51,-110.02,-116.93,-124.28,-132.1,-140.44,-149.35,-158.9,-169.14,-180.15,-192.03,-204.88,-218.81,-233.97,-250.52,-268.66,-288.63,-310.7,-335.24,-362.66,-393.51,-428.46,-468.38,},
{-511.74,-464.49,-423.66,-388.03,-356.67,-328.87,-304.05,-281.77,-261.65,-243.4,-226.78,-211.57,-197.61,-184.76,-172.88,-161.88,-151.66,-142.15,-133.27,-124.97,-117.19,-109.88,-103.02,-96.553,-90.454,-84.693,-79.245,-74.085,-69.194,-64.55,-60.139,-55.943,-51.948,-48.142,-44.511,-41.047,-37.737,-34.574,-31.548,-28.652,-25.879,-23.221,-20.673,-18.228,-15.882,-13.629,-11.465,-9.3858,-7.3864,-5.4635,-3.6136,-1.8332,-0.11938,1.5309,3.1205,4.6518,6.1275,7.5497,8.9207,10.243,11.517,12.746,13.932,15.075,16.178,17.243,18.269,19.26,20.215,21.137,22.026,22.884,23.711,24.509,25.279,26.021,26.736,27.426,28.091,28.731,29.348,29.942,30.514,31.065,31.594,32.104,32.594,33.065,33.517,33.951,34.368,34.768,35.151,35.518,35.869,36.205,36.527,36.834,37.127,37.406,37.672,37.925,38.165,38.393,38.609,38.814,39.007,39.189,39.361,39.522,39.673,39.815,39.947,40.069,40.183,40.287,40.384,40.472,40.552,40.624,40.689,40.746,40.797,40.841,40.878,40.909,40.934,40.953,40.966,40.974,40.976,40.974,40.967,40.955,40.939,40.918,40.894,40.866,40.834,40.799,40.761,40.72,40.676,40.629,40.58,40.529,40.476,40.421,40.365,40.307,40.248,40.187,40.126,40.064,40.002,39.939,39.875,39.812,39.749,39.686,39.624,39.562,39.501,39.44,39.381,39.323,39.266,39.21,39.156,39.104,39.053,39.005,38.958,38.913,38.871,38.831,38.793,38.757,38.725,38.694,38.667,38.642,38.62,38.601,38.584,38.571,38.56,38.552,38.548,38.546,38.547,38.552,38.559,38.569,38.582,38.598,38.617,38.638,38.663,38.69,38.72,38.752,38.787,38.825,38.865,38.907,38.951,38.997,39.046,39.096,39.148,39.202,39.257,39.314,39.372,39.431,39.492,39.553,39.614,39.677,39.74,39.803,39.866,39.929,39.992,40.055,40.117,40.178,40.239,40.298,40.356,40.413,40.468,40.522,40.573,40.622,40.669,40.713,40.755,40.794,40.829,40.861,40.89,40.915,40.936,40.953,40.965,40.973,40.976,40.974,40.967,40.955,40.937,40.913,40.883,40.847,40.804,40.754,40.698,40.634,40.563,40.484,40.397,40.302,40.199,40.086,39.965,39.835,39.695,39.545,39.386,39.216,39.035,38.843,38.64,38.426,38.2,37.961,37.71,37.446,37.169,36.878,36.573,36.254,35.92,35.571,35.206,34.826,34.428,34.014,33.583,33.133,32.665,32.178,31.671,31.145,30.597,30.029,29.438,28.824,28.187,27.526,26.841,26.129,25.391,24.625,23.832,23.009,22.156,21.271,20.354,19.404,18.419,17.397,16.339,15.242,14.104,12.925,11.703,10.435,9.1202,7.7566,6.3422,4.8746,3.3517,1.7709,0.12981,-1.5744,-3.3447,-5.1841,-7.0959,-9.0837,-11.151,-13.302,-15.542,-17.874,-20.303,-22.836,-25.477,-28.233,-31.11,-34.116,-37.258,-40.545,-43.986,-47.591,-51.371,-55.337,-59.502,-63.881,-68.488,-73.342,-78.46,-83.864,-89.577,-95.624,-102.03,-108.84,-116.07,-123.78,-132.0,-140.79,-150.21,-160.31,-171.19,-182.93,-195.64,-209.42,-224.43,-240.83,-258.82,-278.65,-300.59,-325.0,-352.33,-383.12,},
{-414.99,-379.19,-347.74,-319.91,-295.1,-272.86,-252.81,-234.65,-218.11,-203.01,-189.15,-176.4,-164.63,-153.74,-143.62,-134.21,-125.43,-117.23,-109.54,-102.33,-95.557,-89.177,-83.162,-77.482,-72.112,-67.027,-62.208,-57.635,-53.29,-49.159,-45.226,-41.48,-37.908,-34.498,-31.242,-28.13,-25.154,-22.306,-19.578,-16.964,-14.458,-12.054,-9.7472,-7.532,-5.404,-3.359,-1.3929,0.49805,2.3173,4.0682,5.7538,7.377,8.9406,10.447,11.899,13.298,14.647,15.948,17.203,18.413,19.58,20.706,21.793,22.841,23.853,24.829,25.771,26.679,27.556,28.403,29.219,30.007,30.767,31.499,32.206,32.888,33.545,34.178,34.789,35.377,35.943,36.489,37.014,37.519,38.005,38.473,38.922,39.353,39.768,40.166,40.547,40.913,41.263,41.599,41.92,42.227,42.52,42.8,43.066,43.32,43.562,43.791,44.009,44.215,44.411,44.595,44.769,44.933,45.087,45.231,45.365,45.491,45.608,45.716,45.815,45.907,45.99,46.066,46.135,46.196,46.25,46.297,46.338,46.373,46.401,46.424,46.441,46.452,46.458,46.459,46.456,46.447,46.434,46.417,46.396,46.371,46.342,46.31,46.274,46.235,46.194,46.15,46.103,46.054,46.002,45.949,45.894,45.837,45.779,45.719,45.658,45.597,45.534,45.472,45.408,45.344,45.281,45.217,45.153,45.09,45.027,44.965,44.904,44.843,44.784,44.726,44.669,44.614,44.56,44.507,44.457,44.409,44.362,44.318,44.275,44.236,44.198,44.163,44.13,44.1,44.073,44.048,44.026,44.007,43.991,43.978,43.967,43.959,43.955,43.953,43.954,43.959,43.966,43.976,43.989,44.005,44.023,44.045,44.069,44.096,44.126,44.158,44.193,44.23,44.269,44.311,44.355,44.402,44.45,44.5,44.552,44.605,44.661,44.717,44.775,44.834,44.895,44.956,45.018,45.081,45.144,45.207,45.271,45.335,45.399,45.462,45.525,45.588,45.649,45.71,45.77,45.828,45.885,45.941,45.994,46.046,46.096,46.143,46.187,46.229,46.269,46.305,46.337,46.367,46.392,46.414,46.432,46.446,46.455,46.459,46.459,46.453,46.443,46.427,46.405,46.378,46.344,46.304,46.257,46.204,46.144,46.077,46.002,45.92,45.829,45.731,45.624,45.509,45.385,45.251,45.109,44.956,44.794,44.622,44.439,44.245,44.04,43.824,43.596,43.357,43.105,42.84,42.562,42.271,41.966,41.648,41.314,40.966,40.603,40.223,39.828,39.416,38.987,38.54,38.076,37.593,37.09,36.568,36.026,35.462,34.877,34.27,33.641,32.987,32.309,31.606,30.877,30.121,29.338,28.526,27.684,26.812,25.908,24.971,24.0,22.994,21.951,20.87,19.75,18.589,17.385,16.138,14.844,13.502,12.11,10.666,9.168,7.6131,5.9989,4.3227,2.5817,0.77285,-1.1072,-3.0619,-5.095,-7.2104,-9.4123,-11.705,-14.095,-16.585,-19.182,-21.893,-24.723,-27.68,-30.771,-34.005,-37.391,-40.938,-44.658,-48.562,-52.663,-56.975,-61.513,-66.295,-71.339,-76.665,-82.297,-88.261,-94.585,-101.3,-108.44,-116.05,-124.18,-132.87,-142.18,-152.19,-162.96,-174.59,-187.19,-200.87,-215.78,-232.09,-250.0,-269.75,-291.64,-316.04,},
{-340.15,-312.17,-287.28,-265.0,-244.94,-226.79,-210.3,-195.24,-181.45,-168.76,-157.07,-146.24,-136.21,-126.87,-118.17,-110.04,-102.44,-95.302,-88.599,-82.291,-76.346,-70.734,-65.43,-60.41,-55.653,-51.14,-46.854,-42.779,-38.901,-35.207,-31.686,-28.326,-25.117,-22.051,-19.119,-16.313,-13.626,-11.051,-8.5833,-6.216,-3.9441,-1.7628,0.3326,2.3463,4.2822,6.1442,7.9356,9.6597,11.32,12.918,14.458,15.942,17.372,18.75,20.08,21.361,22.598,23.79,24.941,26.051,27.122,28.156,29.154,30.117,31.046,31.943,32.809,33.644,34.451,35.229,35.98,36.704,37.403,38.078,38.728,39.355,39.959,40.542,41.103,41.644,42.165,42.667,43.149,43.614,44.06,44.49,44.902,45.298,45.679,46.043,46.393,46.728,47.049,47.356,47.65,47.93,48.197,48.452,48.695,48.926,49.146,49.354,49.552,49.738,49.915,50.081,50.238,50.385,50.522,50.651,50.771,50.882,50.985,51.08,51.168,51.247,51.319,51.384,51.442,51.493,51.538,51.576,51.609,51.635,51.656,51.671,51.681,51.685,51.685,51.68,51.671,51.657,51.639,51.617,51.592,51.563,51.53,51.494,51.455,51.413,51.369,51.322,51.273,51.221,51.168,51.113,51.056,50.997,50.938,50.877,50.815,50.753,50.689,50.626,50.562,50.497,50.433,50.369,50.305,50.242,50.179,50.117,50.055,49.995,49.936,49.878,49.821,49.766,49.712,49.66,49.61,49.562,49.516,49.472,49.43,49.39,49.353,49.318,49.286,49.256,49.229,49.205,49.183,49.164,49.148,49.135,49.124,49.117,49.112,49.11,49.112,49.116,49.123,49.133,49.146,49.161,49.18,49.201,49.225,49.252,49.281,49.313,49.348,49.385,49.424,49.465,49.509,49.555,49.603,49.653,49.704,49.758,49.813,49.869,49.927,49.986,50.046,50.108,50.17,50.232,50.296,50.359,50.424,50.488,50.552,50.616,50.68,50.743,50.806,50.868,50.929,50.988,51.047,51.104,51.16,51.213,51.265,51.315,51.362,51.407,51.449,51.488,51.525,51.558,51.588,51.614,51.636,51.655,51.669,51.679,51.685,51.686,51.682,51.673,51.658,51.638,51.613,51.582,51.544,51.5,51.45,51.393,51.329,51.258,51.18,51.094,51.0,50.898,50.788,50.67,50.542,50.406,50.26,50.105,49.94,49.765,49.58,49.384,49.178,48.96,48.73,48.489,48.236,47.97,47.692,47.401,47.096,46.777,46.444,46.096,45.734,45.356,44.962,44.552,44.125,43.681,43.22,42.74,42.241,41.723,41.185,40.627,40.047,39.446,38.823,38.176,37.505,36.81,36.089,35.342,34.568,33.766,32.935,32.074,31.181,30.257,29.299,28.306,27.278,26.212,25.108,23.964,22.777,21.548,20.273,18.951,17.58,16.158,14.682,13.151,11.561,9.9104,8.196,6.4148,4.5635,2.6388,0.6369,-1.4461,-3.6144,-5.8725,-8.2253,-10.678,-13.236,-15.906,-18.694,-21.607,-24.653,-27.839,-31.176,-34.673,-38.341,-42.19,-46.235,-50.489,-54.967,-59.687,-64.666,-69.927,-75.491,-81.385,-87.637,-94.279,-101.35,-108.88,-116.93,-125.54,-134.78,-144.71,-155.4,-166.97,-179.49,-193.11,-207.97,-224.24,-242.13,-261.88,},
{-280.53,-258.12,-237.98,-219.79,-203.28,-188.22,-174.45,-161.8,-150.14,-139.36,-129.37,-120.09,-111.45,-103.38,-95.829,-88.753,-82.109,-75.859,-69.971,-64.416,-59.167,-54.201,-49.497,-45.036,-40.8,-36.774,-32.943,-29.295,-25.818,-22.501,-19.334,-16.309,-13.416,-10.647,-7.9969,-5.4577,-3.0237,-0.68916,1.5511,3.7019,5.768,7.7533,9.662,11.498,13.264,14.964,16.6,18.176,19.695,21.158,22.568,23.928,25.238,26.503,27.722,28.899,30.034,31.13,32.187,33.208,34.193,35.144,36.062,36.948,37.803,38.629,39.426,40.196,40.939,41.656,42.347,43.015,43.659,44.28,44.879,45.457,46.014,46.55,47.068,47.566,48.045,48.507,48.951,49.379,49.789,50.184,50.563,50.927,51.277,51.612,51.932,52.24,52.534,52.815,53.083,53.34,53.584,53.817,54.038,54.249,54.448,54.637,54.816,54.985,55.145,55.295,55.435,55.567,55.691,55.805,55.912,56.01,56.101,56.184,56.26,56.329,56.391,56.446,56.495,56.537,56.573,56.603,56.628,56.647,56.661,56.669,56.673,56.672,56.666,56.656,56.641,56.623,56.601,56.575,56.545,56.512,56.476,56.438,56.396,56.351,56.304,56.255,56.204,56.15,56.095,56.038,55.98,55.921,55.86,55.798,55.736,55.672,55.608,55.544,55.48,55.415,55.351,55.287,55.223,55.159,55.096,55.034,54.973,54.913,54.854,54.796,54.74,54.685,54.632,54.58,54.53,54.483,54.437,54.393,54.352,54.312,54.275,54.241,54.209,54.179,54.153,54.128,54.107,54.088,54.072,54.059,54.049,54.041,54.037,54.035,54.036,54.041,54.048,54.057,54.07,54.086,54.104,54.125,54.149,54.175,54.204,54.236,54.27,54.307,54.346,54.387,54.43,54.476,54.523,54.573,54.624,54.677,54.732,54.788,54.845,54.904,54.964,55.025,55.087,55.15,55.213,55.277,55.341,55.406,55.47,55.535,55.599,55.663,55.726,55.789,55.851,55.912,55.971,56.03,56.087,56.142,56.196,56.248,56.297,56.344,56.389,56.431,56.471,56.507,56.541,56.571,56.597,56.62,56.639,56.654,56.665,56.671,56.673,56.67,56.662,56.649,56.631,56.607,56.578,56.543,56.501,56.454,56.399,56.339,56.271,56.196,56.114,56.024,55.927,55.822,55.708,55.586,55.456,55.316,55.168,55.01,54.842,54.665,54.477,54.279,54.07,53.85,53.619,53.377,53.122,52.856,52.576,52.284,51.979,51.66,51.327,50.98,50.618,50.242,49.849,49.441,49.016,48.574,48.115,47.638,47.143,46.628,46.095,45.541,44.966,44.37,43.753,43.112,42.448,41.76,41.047,40.308,39.542,38.749,37.928,37.077,36.195,35.282,34.336,33.356,32.341,31.289,30.199,29.07,27.9,26.687,25.429,24.125,22.773,21.371,19.916,18.406,16.838,15.211,13.521,11.765,9.9394,8.0417,6.068,4.0142,1.8763,-0.35041,-2.6706,-5.0895,-7.6126,-10.246,-12.996,-15.871,-18.876,-22.021,-25.316,-28.768,-32.39,-36.192,-40.189,-44.392,-48.819,-53.486,-58.412,-63.617,-69.125,-74.962,-81.156,-87.739,-94.749,-102.23,-110.21,-118.77,-127.95,-137.83,-148.48,-160.0,-172.5,-186.1,-200.95,-217.24,},
{-231.91,-213.61,-197.02,-181.92,-168.12,-155.46,-143.81,-133.05,-123.09,-113.84,-105.23,-97.198,-89.69,-82.657,-76.056,-69.851,-64.009,-58.499,-53.295,-48.373,-43.713,-39.295,-35.101,-31.117,-27.327,-23.719,-20.28,-17.001,-13.871,-10.88,-8.0215,-5.2866,-2.6685,-0.16066,2.2431,4.5483,6.7602,8.8837,10.923,12.883,14.767,16.579,18.323,20.001,21.616,23.172,24.67,26.115,27.507,28.849,30.143,31.392,32.596,33.758,34.879,35.961,37.006,38.014,38.988,39.928,40.835,41.711,42.558,43.374,44.163,44.925,45.66,46.37,47.055,47.717,48.355,48.971,49.565,50.138,50.691,51.224,51.738,52.233,52.71,53.169,53.611,54.037,54.446,54.84,55.218,55.582,55.931,56.266,56.587,56.894,57.189,57.471,57.741,57.998,58.244,58.479,58.702,58.915,59.116,59.308,59.49,59.661,59.824,59.977,60.121,60.256,60.382,60.5,60.61,60.713,60.807,60.894,60.974,61.046,61.112,61.171,61.224,61.27,61.31,61.345,61.373,61.396,61.414,61.427,61.434,61.437,61.435,61.429,61.418,61.403,61.384,61.362,61.336,61.306,61.273,61.237,61.199,61.157,61.113,61.066,61.017,60.966,60.913,60.858,60.801,60.743,60.684,60.623,60.562,60.499,60.436,60.372,60.308,60.244,60.179,60.114,60.05,59.986,59.922,59.858,59.796,59.734,59.673,59.613,59.555,59.497,59.441,59.387,59.334,59.283,59.233,59.186,59.141,59.097,59.056,59.017,58.981,58.947,58.915,58.886,58.859,58.835,58.814,58.796,58.78,58.767,58.757,58.75,58.745,58.743,58.745,58.749,58.756,58.765,58.778,58.793,58.811,58.832,58.856,58.882,58.911,58.942,58.976,59.012,59.05,59.091,59.134,59.179,59.226,59.275,59.326,59.379,59.433,59.489,59.546,59.604,59.664,59.725,59.787,59.849,59.912,59.976,60.04,60.105,60.169,60.234,60.299,60.363,60.427,60.49,60.553,60.614,60.675,60.735,60.793,60.85,60.905,60.958,61.01,61.059,61.106,61.15,61.193,61.232,61.268,61.301,61.332,61.358,61.381,61.401,61.416,61.427,61.434,61.437,61.435,61.428,61.416,61.399,61.377,61.349,61.316,61.276,61.231,61.179,61.121,61.057,60.985,60.906,60.82,60.727,60.626,60.517,60.4,60.275,60.141,59.999,59.847,59.686,59.516,59.336,59.146,58.945,58.734,58.513,58.28,58.036,57.78,57.512,57.232,56.939,56.633,56.314,55.981,55.635,55.273,54.897,54.506,54.099,53.676,53.236,52.779,52.305,51.813,51.302,50.771,50.222,49.652,49.061,48.448,47.813,47.155,46.473,45.767,45.036,44.278,43.493,42.681,41.839,40.967,40.065,39.13,38.161,37.158,36.119,35.042,33.927,32.771,31.573,30.332,29.044,27.709,26.325,24.888,23.398,21.851,20.244,18.576,16.843,15.041,13.168,11.22,9.192,7.0813,4.8828,2.5917,0.20298,-2.289,-4.8904,-7.6074,-10.447,-13.418,-16.527,-19.783,-23.197,-26.78,-30.542,-34.497,-38.658,-43.042,-47.665,-52.546,-57.707,-63.17,-68.961,-75.11,-81.649,-88.616,-96.05,-104.0,-112.52,-121.67,-131.52,-142.16,-153.67,-166.17,-179.79,},
{-191.5,-176.3,-162.44,-149.74,-138.06,-127.29,-117.32,-108.08,-99.485,-91.474,-83.99,-76.984,-70.414,-64.241,-58.432,-52.956,-47.787,-42.901,-38.277,-33.894,-29.735,-25.785,-22.03,-18.455,-15.05,-11.802,-8.7037,-5.7441,-2.9154,-0.20975,2.3799,4.8601,7.2371,9.5163,11.703,13.802,15.818,17.755,19.617,21.408,23.131,24.789,26.385,27.922,29.403,30.83,32.206,33.532,34.811,36.045,37.235,38.384,39.493,40.563,41.595,42.593,43.556,44.485,45.383,46.251,47.088,47.897,48.678,49.432,50.161,50.864,51.543,52.199,52.832,53.443,54.033,54.602,55.151,55.681,56.192,56.684,57.158,57.616,58.056,58.48,58.888,59.281,59.659,60.022,60.371,60.706,61.027,61.335,61.631,61.914,62.185,62.444,62.691,62.928,63.153,63.367,63.572,63.766,63.95,64.124,64.29,64.446,64.593,64.731,64.861,64.983,65.096,65.202,65.3,65.391,65.475,65.551,65.621,65.684,65.74,65.791,65.835,65.874,65.906,65.933,65.955,65.972,65.983,65.99,65.992,65.99,65.983,65.972,65.957,65.938,65.915,65.889,65.86,65.827,65.791,65.753,65.711,65.668,65.621,65.573,65.522,65.469,65.415,65.359,65.301,65.242,65.182,65.12,65.058,64.995,64.932,64.868,64.803,64.739,64.674,64.609,64.545,64.481,64.417,64.354,64.292,64.23,64.17,64.11,64.052,63.995,63.94,63.886,63.833,63.783,63.734,63.687,63.642,63.599,63.558,63.52,63.484,63.45,63.419,63.39,63.364,63.34,63.319,63.301,63.286,63.273,63.263,63.255,63.251,63.249,63.251,63.255,63.261,63.271,63.283,63.299,63.316,63.337,63.36,63.386,63.415,63.445,63.479,63.515,63.553,63.593,63.635,63.68,63.727,63.775,63.826,63.878,63.931,63.987,64.044,64.102,64.161,64.221,64.283,64.345,64.408,64.471,64.535,64.6,64.664,64.729,64.794,64.858,64.922,64.986,65.049,65.111,65.173,65.233,65.292,65.35,65.407,65.461,65.514,65.565,65.614,65.661,65.705,65.747,65.786,65.822,65.855,65.885,65.912,65.935,65.954,65.97,65.981,65.989,65.992,65.991,65.985,65.974,65.958,65.937,65.911,65.879,65.841,65.798,65.748,65.693,65.631,65.562,65.486,65.404,65.314,65.217,65.112,65.0,64.88,64.751,64.614,64.468,64.313,64.15,63.976,63.794,63.601,63.398,63.185,62.962,62.727,62.481,62.224,61.955,61.674,61.38,61.074,60.754,60.421,60.075,59.714,59.338,58.948,58.542,58.12,57.682,57.227,56.756,56.266,55.758,55.231,54.685,54.119,53.532,52.924,52.295,51.642,50.967,50.267,49.542,48.792,48.015,47.21,46.377,45.514,44.621,43.696,42.738,41.746,40.718,39.654,38.551,37.409,36.225,34.998,33.725,32.406,31.038,29.619,28.146,26.617,25.03,23.381,21.668,19.888,18.036,16.111,14.107,12.02,9.8469,7.5818,5.2198,2.7552,0.18224,-2.5057,-5.3157,-8.2553,-11.333,-14.557,-17.939,-21.487,-25.215,-29.135,-33.262,-37.61,-42.198,-47.044,-52.169,-57.598,-63.356,-69.472,-75.981,-82.919,-90.329,-98.259,-106.76,-115.9,-125.76,-136.4,-147.94,},
{-157.37,-144.59,-132.85,-122.04,-112.05,-102.79,-94.19,-86.18,-78.704,-71.711,-65.158,-59.005,-53.218,-47.766,-42.622,-37.763,-33.165,-28.81,-24.68,-20.758,-17.03,-13.484,-10.106,-6.8859,-3.814,-0.88088,1.922,4.6023,7.1671,9.6232,11.977,14.233,16.397,18.475,20.47,22.386,24.229,26.0,27.704,29.344,30.923,32.444,33.909,35.321,36.681,37.993,39.259,40.479,41.657,42.793,43.89,44.949,45.971,46.958,47.912,48.832,49.721,50.58,51.41,52.211,52.985,53.733,54.455,55.152,55.826,56.477,57.105,57.712,58.298,58.863,59.409,59.935,60.443,60.933,61.405,61.861,62.3,62.722,63.13,63.522,63.899,64.262,64.61,64.945,65.267,65.576,65.873,66.157,66.429,66.689,66.939,67.177,67.404,67.621,67.827,68.024,68.211,68.388,68.556,68.715,68.865,69.007,69.14,69.265,69.383,69.492,69.594,69.688,69.776,69.856,69.93,69.997,70.058,70.112,70.161,70.203,70.24,70.271,70.297,70.318,70.334,70.344,70.35,70.352,70.349,70.342,70.331,70.316,70.297,70.275,70.249,70.219,70.187,70.152,70.114,70.073,70.029,69.983,69.935,69.885,69.833,69.779,69.723,69.666,69.608,69.548,69.487,69.425,69.363,69.3,69.236,69.172,69.107,69.043,68.978,68.913,68.849,68.785,68.722,68.659,68.598,68.537,68.476,68.417,68.36,68.303,68.248,68.195,68.143,68.093,68.045,67.998,67.954,67.912,67.871,67.834,67.798,67.765,67.734,67.705,67.679,67.656,67.635,67.617,67.602,67.589,67.58,67.572,67.568,67.566,67.568,67.572,67.578,67.588,67.6,67.615,67.633,67.653,67.676,67.701,67.729,67.76,67.793,67.828,67.866,67.906,67.948,67.992,68.038,68.086,68.136,68.187,68.24,68.295,68.351,68.409,68.468,68.528,68.588,68.65,68.713,68.776,68.84,68.904,68.968,69.033,69.098,69.162,69.226,69.29,69.354,69.416,69.478,69.539,69.599,69.658,69.715,69.771,69.825,69.878,69.928,69.976,70.023,70.066,70.108,70.146,70.182,70.215,70.245,70.271,70.294,70.313,70.329,70.341,70.348,70.352,70.351,70.346,70.335,70.321,70.301,70.275,70.245,70.209,70.167,70.12,70.066,70.007,69.94,69.868,69.788,69.702,69.608,69.508,69.399,69.283,69.159,69.027,68.887,68.738,68.58,68.414,68.238,68.052,67.857,67.652,67.437,67.211,66.975,66.727,66.468,66.198,65.916,65.621,65.314,64.994,64.661,64.314,63.954,63.579,63.189,62.784,62.363,61.927,61.474,61.004,60.517,60.012,59.488,58.945,58.383,57.8,57.197,56.572,55.924,55.254,54.56,53.842,53.098,52.328,51.53,50.705,49.851,48.966,48.05,47.102,46.12,45.103,44.05,42.959,41.828,40.657,39.443,38.184,36.879,35.526,34.122,32.665,31.153,29.583,27.952,26.258,24.496,22.665,20.759,18.776,16.711,14.56,12.318,9.9793,7.5388,4.9905,2.3278,-0.45632,-3.3696,-6.4203,-9.6175,-12.971,-16.492,-20.192,-24.084,-28.183,-32.503,-37.064,-41.883,-46.983,-52.387,-58.122,-64.219,-70.711,-77.635,-85.037,-92.963,-101.47,-110.63,-120.5,},
{-128.17,-117.29,-107.24,-97.948,-89.322,-81.296,-73.811,-66.817,-60.266,-54.121,-48.345,-42.907,-37.78,-32.938,-28.36,-24.025,-19.916,-16.016,-12.31,-8.786,-5.4307,-2.2334,0.8161,3.727,6.5079,9.1665,11.71,14.145,16.478,18.714,20.859,22.918,24.894,26.793,28.617,30.372,32.059,33.683,35.247,36.753,38.203,39.601,40.948,42.247,43.5,44.708,45.874,47.0,48.086,49.135,50.147,51.125,52.069,52.981,53.862,54.714,55.536,56.33,57.098,57.84,58.556,59.248,59.917,60.563,61.187,61.79,62.372,62.934,63.476,64.0,64.505,64.993,65.464,65.917,66.355,66.777,67.183,67.574,67.951,68.314,68.663,68.998,69.32,69.63,69.927,70.213,70.486,70.748,70.999,71.239,71.468,71.687,71.896,72.095,72.285,72.465,72.636,72.798,72.951,73.096,73.233,73.361,73.482,73.595,73.701,73.799,73.89,73.975,74.052,74.123,74.188,74.247,74.299,74.346,74.387,74.422,74.452,74.477,74.497,74.512,74.522,74.528,74.529,74.526,74.519,74.508,74.493,74.474,74.452,74.426,74.397,74.365,74.331,74.293,74.253,74.21,74.165,74.117,74.068,74.016,73.963,73.908,73.851,73.794,73.734,73.674,73.613,73.551,73.488,73.425,73.361,73.297,73.232,73.168,73.103,73.039,72.975,72.912,72.849,72.787,72.725,72.665,72.605,72.547,72.49,72.434,72.38,72.327,72.276,72.226,72.178,72.133,72.089,72.047,72.007,71.97,71.935,71.902,71.871,71.843,71.818,71.795,71.775,71.757,71.742,71.729,71.719,71.712,71.708,71.707,71.708,71.712,71.718,71.728,71.74,71.754,71.772,71.792,71.814,71.839,71.867,71.897,71.93,71.964,72.002,72.041,72.082,72.126,72.171,72.219,72.268,72.319,72.372,72.426,72.481,72.538,72.597,72.656,72.716,72.778,72.84,72.903,72.966,73.03,73.094,73.158,73.223,73.287,73.351,73.415,73.479,73.542,73.604,73.665,73.726,73.785,73.843,73.9,73.955,74.008,74.06,74.11,74.158,74.203,74.246,74.287,74.325,74.36,74.393,74.422,74.448,74.471,74.49,74.506,74.517,74.525,74.529,74.528,74.523,74.514,74.5,74.48,74.456,74.427,74.392,74.352,74.306,74.255,74.197,74.133,74.063,73.987,73.903,73.813,73.716,73.611,73.499,73.38,73.252,73.117,72.973,72.821,72.66,72.491,72.312,72.124,71.926,71.719,71.501,71.274,71.035,70.786,70.526,70.254,69.971,69.675,69.367,69.047,68.713,68.366,68.006,67.631,67.242,66.838,66.419,65.983,65.532,65.064,64.579,64.076,63.555,63.016,62.456,61.877,61.278,60.657,60.014,59.349,58.66,57.948,57.21,56.446,55.656,54.838,53.991,53.114,52.207,51.267,50.295,49.287,48.244,47.164,46.044,44.884,43.682,42.436,41.144,39.804,38.414,36.972,35.474,33.92,32.305,30.627,28.882,27.068,25.181,23.216,21.17,19.039,16.816,14.498,12.079,9.5516,6.9105,4.1483,1.2572,-1.7711,-4.9458,-8.2769,-11.775,-15.453,-19.323,-23.4,-27.701,-32.241,-37.043,-42.126,-47.516,-53.24,-59.329,-65.816,-72.742,-80.151,-88.093,-96.626,},
{-102.89,-93.537,-84.864,-76.803,-69.294,-62.282,-55.722,-49.571,-43.795,-38.361,-33.241,-28.409,-23.842,-19.521,-15.426,-11.542,-7.8527,-4.3456,-1.0079,2.1714,5.2028,8.0955,10.858,13.499,16.024,18.442,20.757,22.976,25.104,27.145,29.106,30.988,32.797,34.537,36.21,37.82,39.369,40.861,42.299,43.684,45.019,46.306,47.548,48.746,49.901,51.016,52.093,53.132,54.136,55.105,56.042,56.946,57.82,58.664,59.48,60.268,61.029,61.765,62.477,63.164,63.828,64.47,65.09,65.689,66.267,66.826,67.366,67.887,68.391,68.876,69.345,69.797,70.234,70.654,71.06,71.451,71.827,72.19,72.539,72.875,73.198,73.508,73.807,74.093,74.368,74.631,74.884,75.126,75.357,75.578,75.79,75.991,76.183,76.366,76.54,76.705,76.861,77.009,77.149,77.281,77.406,77.522,77.632,77.734,77.829,77.917,77.999,78.074,78.143,78.205,78.262,78.313,78.358,78.397,78.432,78.461,78.485,78.504,78.518,78.528,78.533,78.535,78.531,78.524,78.513,78.498,78.48,78.458,78.433,78.405,78.373,78.339,78.302,78.263,78.22,78.176,78.129,78.081,78.03,77.977,77.923,77.867,77.81,77.752,77.692,77.632,77.57,77.508,77.445,77.382,77.318,77.254,77.19,77.126,77.062,76.998,76.934,76.871,76.809,76.747,76.687,76.627,76.568,76.51,76.453,76.398,76.344,76.292,76.242,76.193,76.146,76.101,76.057,76.016,75.977,75.94,75.905,75.873,75.843,75.815,75.79,75.768,75.748,75.73,75.715,75.703,75.693,75.686,75.682,75.681,75.682,75.686,75.692,75.701,75.713,75.728,75.745,75.765,75.787,75.812,75.839,75.868,75.9,75.935,75.971,76.01,76.051,76.094,76.139,76.186,76.234,76.285,76.337,76.39,76.445,76.501,76.559,76.618,76.678,76.738,76.8,76.862,76.925,76.988,77.052,77.116,77.18,77.244,77.308,77.372,77.436,77.499,77.561,77.623,77.683,77.743,77.802,77.859,77.915,77.969,78.022,78.073,78.122,78.169,78.214,78.256,78.296,78.334,78.368,78.4,78.429,78.455,78.477,78.496,78.511,78.523,78.531,78.534,78.534,78.529,78.52,78.506,78.488,78.465,78.436,78.403,78.364,78.32,78.27,78.214,78.152,78.084,78.01,77.93,77.842,77.748,77.647,77.539,77.423,77.3,77.17,77.031,76.884,76.729,76.565,76.392,76.211,76.02,75.82,75.61,75.391,75.161,74.921,74.67,74.408,74.135,73.85,73.553,73.245,72.924,72.59,72.243,71.882,71.508,71.119,70.716,70.297,69.863,69.413,68.947,68.464,67.963,67.445,66.908,66.352,65.776,65.18,64.563,63.925,63.264,62.58,61.873,61.14,60.383,59.598,58.787,57.947,57.078,56.178,55.247,54.282,53.284,52.25,51.179,50.069,48.92,47.729,46.494,45.213,43.886,42.508,41.078,39.595,38.054,36.453,34.79,33.06,31.262,29.39,27.442,25.413,23.298,21.093,18.792,16.39,13.881,11.258,8.5141,5.6412,2.631,-0.52574,-3.8392,-7.3204,-10.981,-14.836,-18.898,-23.185,-27.714,-32.505,-37.581,-42.967,-48.69,-54.783,-61.28,-68.221,-75.654,},
{-80.799,-72.685,-65.134,-58.091,-51.507,-45.34,-39.553,-34.113,-28.991,-24.16,-19.597,-15.282,-11.195,-7.3205,-3.6426,-0.14745,3.1773,6.3432,9.3606,12.239,14.987,17.613,20.124,22.526,24.827,27.031,29.144,31.172,33.118,34.987,36.782,38.508,40.168,41.766,43.303,44.783,46.209,47.583,48.907,50.184,51.415,52.603,53.749,54.855,55.923,56.954,57.95,58.911,59.84,60.738,61.605,62.442,63.252,64.034,64.791,65.522,66.228,66.911,67.571,68.209,68.825,69.421,69.996,70.552,71.089,71.608,72.11,72.594,73.061,73.512,73.947,74.367,74.772,75.162,75.539,75.901,76.251,76.587,76.911,77.222,77.521,77.809,78.085,78.35,78.604,78.848,79.081,79.305,79.518,79.722,79.917,80.102,80.279,80.447,80.607,80.758,80.901,81.037,81.164,81.285,81.397,81.503,81.602,81.694,81.78,81.859,81.932,81.998,82.059,82.114,82.163,82.207,82.246,82.279,82.307,82.331,82.349,82.363,82.373,82.378,82.379,82.376,82.369,82.358,82.343,82.325,82.304,82.28,82.252,82.221,82.188,82.151,82.113,82.071,82.028,81.982,81.934,81.884,81.832,81.779,81.724,81.668,81.61,81.552,81.492,81.431,81.369,81.307,81.244,81.181,81.118,81.054,80.99,80.926,80.863,80.799,80.737,80.674,80.612,80.551,80.491,80.432,80.374,80.317,80.261,80.206,80.153,80.102,80.052,80.004,79.957,79.913,79.87,79.829,79.791,79.754,79.72,79.688,79.659,79.632,79.607,79.585,79.565,79.548,79.533,79.521,79.512,79.505,79.501,79.499,79.5,79.504,79.51,79.519,79.531,79.545,79.562,79.582,79.604,79.628,79.655,79.684,79.715,79.749,79.785,79.823,79.864,79.906,79.95,79.997,80.044,80.094,80.145,80.198,80.253,80.308,80.365,80.423,80.482,80.542,80.603,80.665,80.727,80.79,80.853,80.917,80.981,81.044,81.108,81.172,81.235,81.298,81.36,81.422,81.483,81.543,81.602,81.659,81.716,81.771,81.825,81.876,81.927,81.975,82.021,82.065,82.107,82.146,82.182,82.216,82.247,82.276,82.301,82.322,82.341,82.356,82.367,82.375,82.379,82.378,82.374,82.365,82.351,82.334,82.311,82.283,82.251,82.213,82.17,82.122,82.068,82.008,81.942,81.87,81.792,81.707,81.616,81.518,81.414,81.302,81.183,81.056,80.922,80.78,80.63,80.471,80.305,80.129,79.945,79.752,79.549,79.337,79.115,78.883,78.641,78.389,78.125,77.851,77.565,77.267,76.958,76.636,76.302,75.954,75.594,75.219,74.831,74.428,74.01,73.578,73.129,72.664,72.183,71.684,71.168,70.633,70.08,69.507,68.915,68.301,67.667,67.01,66.331,65.628,64.901,64.148,63.37,62.564,61.731,60.868,59.975,59.051,58.095,57.104,56.079,55.016,53.916,52.776,51.594,50.37,49.1,47.783,46.416,44.999,43.527,41.998,40.41,38.759,37.043,35.258,33.4,31.466,29.451,27.351,25.16,22.874,20.487,17.993,15.385,12.655,9.7969,6.8007,3.6576,0.3571,-3.1119,-6.7619,-10.606,-14.66,-18.94,-23.465,-28.255,-33.332,-38.724,-44.457,-50.565,-57.085,},
{-61.321,-54.23,-47.609,-41.414,-35.605,-30.148,-25.014,-20.176,-15.61,-11.294,-7.2092,-3.3385,0.33392,3.822,7.1386,10.295,13.303,16.17,18.907,21.522,24.021,26.411,28.7,30.892,32.993,35.009,36.943,38.8,40.584,42.298,43.947,45.533,47.06,48.529,49.945,51.309,52.623,53.891,55.113,56.292,57.429,58.527,59.587,60.611,61.599,62.554,63.476,64.367,65.228,66.06,66.864,67.641,68.392,69.118,69.821,70.499,71.155,71.789,72.403,72.995,73.568,74.121,74.656,75.173,75.673,76.155,76.621,77.071,77.505,77.924,78.329,78.719,79.095,79.458,79.808,80.144,80.469,80.781,81.081,81.37,81.647,81.914,82.17,82.416,82.651,82.876,83.092,83.299,83.496,83.684,83.863,84.034,84.197,84.351,84.498,84.636,84.768,84.891,85.008,85.117,85.22,85.316,85.405,85.488,85.565,85.636,85.701,85.76,85.813,85.861,85.904,85.941,85.974,86.001,86.024,86.042,86.056,86.065,86.07,86.071,86.068,86.062,86.051,86.037,86.02,85.999,85.975,85.948,85.918,85.885,85.85,85.812,85.772,85.729,85.684,85.637,85.588,85.538,85.485,85.431,85.376,85.319,85.261,85.202,85.142,85.082,85.02,84.958,84.895,84.833,84.769,84.706,84.643,84.579,84.516,84.454,84.391,84.33,84.269,84.208,84.149,84.09,84.033,83.976,83.921,83.867,83.815,83.764,83.715,83.668,83.622,83.578,83.536,83.496,83.458,83.422,83.389,83.357,83.328,83.301,83.277,83.255,83.236,83.219,83.204,83.192,83.183,83.176,83.172,83.171,83.172,83.176,83.182,83.191,83.202,83.216,83.233,83.252,83.274,83.298,83.324,83.353,83.384,83.417,83.453,83.49,83.53,83.572,83.615,83.661,83.708,83.757,83.807,83.859,83.913,83.968,84.024,84.081,84.14,84.199,84.259,84.32,84.382,84.444,84.507,84.57,84.633,84.697,84.76,84.823,84.886,84.949,85.011,85.073,85.133,85.193,85.253,85.311,85.368,85.423,85.477,85.53,85.581,85.63,85.677,85.722,85.765,85.806,85.844,85.88,85.913,85.944,85.971,85.996,86.017,86.035,86.049,86.06,86.068,86.071,86.071,86.066,86.057,86.044,86.027,86.005,85.978,85.946,85.91,85.868,85.82,85.768,85.71,85.646,85.576,85.5,85.418,85.33,85.235,85.133,85.025,84.909,84.786,84.656,84.519,84.374,84.22,84.059,83.889,83.711,83.524,83.328,83.123,82.909,82.685,82.451,82.207,81.953,81.688,81.412,81.125,80.826,80.516,80.193,79.858,79.511,79.15,78.776,78.388,77.985,77.568,77.136,76.689,76.225,75.745,75.249,74.734,74.202,73.651,73.081,72.492,71.882,71.251,70.598,69.923,69.224,68.502,67.754,66.981,66.181,65.353,64.496,63.61,62.693,61.743,60.76,59.742,58.687,57.595,56.464,55.291,54.075,52.815,51.507,50.151,48.743,47.282,45.764,44.187,42.547,40.843,39.069,37.223,35.301,33.298,31.21,29.031,26.758,24.383,21.9,19.303,16.585,13.737,10.751,7.6175,4.3254,0.86359,-2.7805,-6.6209,-10.673,-14.953,-19.481,-24.277,-29.366,-34.772,-40.527,},
{-44.016,-37.779,-31.937,-26.454,-21.3,-16.446,-11.869,-7.5452,-3.4559,0.41681,4.089,7.575,10.888,14.04,17.041,19.902,22.631,25.237,27.727,30.109,32.388,34.57,36.662,38.667,40.591,42.438,44.213,45.917,47.556,49.133,50.65,52.111,53.517,54.872,56.178,57.437,58.651,59.822,60.952,62.043,63.096,64.112,65.094,66.042,66.958,67.843,68.699,69.525,70.325,71.097,71.844,72.566,73.264,73.939,74.591,75.222,75.832,76.422,76.992,77.543,78.076,78.591,79.089,79.57,80.035,80.483,80.917,81.336,81.74,82.13,82.506,82.869,83.219,83.556,83.881,84.194,84.495,84.785,85.064,85.332,85.59,85.837,86.075,86.302,86.52,86.729,86.929,87.12,87.302,87.475,87.641,87.798,87.948,88.09,88.224,88.352,88.472,88.585,88.691,88.791,88.884,88.971,89.051,89.126,89.195,89.258,89.316,89.368,89.414,89.456,89.493,89.524,89.551,89.574,89.592,89.605,89.615,89.62,89.621,89.618,89.612,89.602,89.588,89.572,89.551,89.528,89.502,89.473,89.441,89.407,89.37,89.33,89.289,89.245,89.199,89.151,89.101,89.05,88.997,88.943,88.887,88.83,88.772,88.713,88.653,88.593,88.531,88.469,88.407,88.345,88.282,88.219,88.156,88.094,88.031,87.969,87.908,87.846,87.786,87.726,87.668,87.61,87.553,87.498,87.443,87.39,87.339,87.289,87.24,87.193,87.148,87.105,87.064,87.025,86.987,86.952,86.919,86.888,86.859,86.833,86.809,86.788,86.769,86.752,86.738,86.726,86.717,86.71,86.706,86.705,86.706,86.71,86.716,86.725,86.736,86.75,86.766,86.785,86.806,86.829,86.855,86.884,86.914,86.947,86.982,87.019,87.058,87.099,87.142,87.187,87.233,87.281,87.331,87.383,87.435,87.489,87.545,87.601,87.659,87.718,87.777,87.837,87.898,87.96,88.022,88.084,88.147,88.21,88.273,88.335,88.398,88.46,88.522,88.584,88.644,88.704,88.763,88.822,88.879,88.935,88.989,89.042,89.094,89.144,89.192,89.238,89.282,89.324,89.364,89.401,89.436,89.468,89.498,89.525,89.548,89.569,89.586,89.6,89.611,89.618,89.621,89.62,89.616,89.607,89.594,89.577,89.555,89.529,89.498,89.462,89.421,89.375,89.324,89.267,89.205,89.137,89.063,88.983,88.897,88.805,88.706,88.601,88.489,88.37,88.244,88.11,87.97,87.821,87.665,87.501,87.328,87.147,86.958,86.759,86.552,86.335,86.109,85.873,85.627,85.371,85.105,84.828,84.539,84.24,83.928,83.605,83.27,82.922,82.561,82.186,81.798,81.396,80.98,80.549,80.102,79.64,79.162,78.666,78.154,77.624,77.075,76.508,75.921,75.314,74.686,74.037,73.366,72.671,71.953,71.21,70.441,69.646,68.823,67.972,67.092,66.18,65.237,64.26,63.249,62.202,61.117,59.993,58.828,57.62,56.368,55.069,53.722,52.323,50.871,49.362,47.795,46.165,44.47,42.707,40.871,38.958,36.965,34.887,32.718,30.454,28.088,25.614,23.026,20.316,17.475,14.495,11.366,8.078,4.6184,0.97482,-2.8671,-6.9232,-11.211,-15.749,-20.56,-25.668,},
{-28.54,-23.021,-17.837,-12.959,-8.3626,-4.0244,0.075803,3.9564,7.6337,11.123,14.436,17.587,20.587,23.444,26.169,28.77,31.254,33.629,35.901,38.077,40.16,42.158,44.074,45.913,47.679,49.376,51.007,52.575,54.084,55.537,56.935,58.283,59.581,60.833,62.04,63.204,64.327,65.411,66.457,67.468,68.444,69.386,70.297,71.177,72.027,72.849,73.643,74.412,75.154,75.872,76.567,77.238,77.888,78.516,79.123,79.71,80.278,80.827,81.358,81.871,82.368,82.847,83.311,83.759,84.191,84.609,85.013,85.403,85.779,86.142,86.493,86.831,87.156,87.47,87.773,88.064,88.344,88.614,88.873,89.122,89.361,89.591,89.811,90.022,90.224,90.418,90.602,90.779,90.947,91.108,91.26,91.406,91.543,91.674,91.797,91.914,92.024,92.127,92.224,92.315,92.399,92.478,92.551,92.618,92.679,92.735,92.786,92.832,92.873,92.909,92.94,92.966,92.989,93.006,93.02,93.029,93.034,93.036,93.033,93.028,93.018,93.005,92.989,92.97,92.947,92.922,92.894,92.863,92.829,92.793,92.755,92.714,92.672,92.627,92.58,92.532,92.482,92.43,92.376,92.322,92.266,92.209,92.151,92.092,92.032,91.972,91.911,91.85,91.788,91.726,91.663,91.601,91.539,91.477,91.415,91.354,91.293,91.233,91.173,91.114,91.056,90.999,90.943,90.889,90.835,90.783,90.732,90.683,90.635,90.589,90.545,90.502,90.462,90.423,90.386,90.352,90.319,90.289,90.261,90.235,90.211,90.19,90.171,90.155,90.141,90.13,90.121,90.114,90.11,90.109,90.11,90.113,90.12,90.128,90.139,90.153,90.169,90.187,90.208,90.231,90.257,90.285,90.315,90.347,90.381,90.417,90.456,90.496,90.538,90.582,90.628,90.676,90.725,90.775,90.827,90.881,90.935,90.991,91.048,91.106,91.164,91.224,91.284,91.345,91.406,91.468,91.53,91.592,91.654,91.716,91.779,91.84,91.902,91.963,92.023,92.083,92.142,92.2,92.258,92.314,92.368,92.422,92.474,92.524,92.573,92.62,92.665,92.708,92.749,92.788,92.824,92.858,92.889,92.918,92.944,92.967,92.986,93.003,93.016,93.026,93.033,93.036,93.035,93.03,93.021,93.008,92.991,92.97,92.944,92.914,92.878,92.838,92.793,92.743,92.688,92.627,92.561,92.489,92.411,92.328,92.238,92.142,92.04,91.931,91.815,91.693,91.563,91.427,91.282,91.131,90.972,90.804,90.629,90.446,90.254,90.053,89.843,89.624,89.396,89.158,88.911,88.653,88.385,88.106,87.817,87.516,87.204,86.88,86.544,86.195,85.834,85.46,85.072,84.67,84.254,83.824,83.378,82.917,82.44,81.946,81.435,80.907,80.361,79.796,79.211,78.607,77.982,77.336,76.668,75.977,75.262,74.523,73.759,72.969,72.151,71.305,70.429,69.523,68.586,67.615,66.61,65.569,64.491,63.373,62.215,61.015,59.77,58.479,57.139,55.748,54.304,52.803,51.244,49.622,47.935,46.18,44.352,42.448,40.463,38.392,36.231,33.973,31.614,29.146,26.563,23.857,21.02,18.043,14.915,11.626,8.1637,4.5153,0.66594,-3.4005,-7.7021,-12.259,},
{-14.615,-9.7049,-5.0817,-0.72183,3.3958,7.2901,10.978,14.475,17.794,20.948,23.949,26.807,29.531,32.13,34.611,36.982,39.25,41.42,43.498,45.49,47.4,49.233,50.992,52.682,54.307,55.868,57.371,58.817,60.209,61.549,62.841,64.086,65.287,66.445,67.562,68.64,69.681,70.686,71.657,72.594,73.5,74.375,75.221,76.038,76.829,77.593,78.332,79.046,79.738,80.406,81.052,81.678,82.282,82.867,83.433,83.98,84.509,85.021,85.516,85.995,86.457,86.904,87.336,87.754,88.157,88.547,88.924,89.287,89.638,89.976,90.302,90.617,90.921,91.213,91.495,91.766,92.027,92.277,92.518,92.75,92.972,93.186,93.39,93.586,93.773,93.953,94.124,94.287,94.443,94.591,94.732,94.866,94.993,95.113,95.226,95.333,95.433,95.528,95.616,95.698,95.775,95.846,95.912,95.972,96.027,96.077,96.121,96.161,96.197,96.227,96.254,96.276,96.293,96.307,96.316,96.322,96.323,96.322,96.316,96.307,96.295,96.28,96.261,96.24,96.215,96.188,96.158,96.126,96.091,96.053,96.014,95.972,95.929,95.883,95.836,95.787,95.736,95.684,95.631,95.576,95.52,95.463,95.406,95.347,95.287,95.227,95.167,95.106,95.044,94.983,94.921,94.86,94.798,94.737,94.676,94.615,94.555,94.496,94.437,94.379,94.322,94.266,94.211,94.157,94.104,94.053,94.003,93.954,93.907,93.862,93.818,93.777,93.737,93.699,93.663,93.629,93.597,93.567,93.539,93.514,93.491,93.47,93.452,93.436,93.422,93.411,93.402,93.395,93.392,93.39,93.391,93.395,93.401,93.409,93.42,93.433,93.449,93.467,93.488,93.51,93.535,93.563,93.592,93.624,93.658,93.693,93.731,93.771,93.812,93.855,93.9,93.947,93.995,94.045,94.096,94.149,94.203,94.257,94.313,94.37,94.428,94.487,94.546,94.606,94.667,94.728,94.789,94.851,94.912,94.974,95.035,95.097,95.158,95.218,95.278,95.338,95.397,95.455,95.512,95.568,95.623,95.676,95.729,95.78,95.829,95.876,95.922,95.966,96.008,96.048,96.085,96.121,96.153,96.184,96.211,96.236,96.258,96.277,96.293,96.306,96.315,96.321,96.323,96.322,96.317,96.308,96.295,96.278,96.257,96.232,96.202,96.167,96.128,96.084,96.034,95.98,95.921,95.856,95.786,95.71,95.629,95.541,95.448,95.348,95.242,95.13,95.011,94.885,94.752,94.612,94.465,94.311,94.148,93.978,93.8,93.614,93.42,93.217,93.005,92.784,92.553,92.314,92.064,91.805,91.536,91.256,90.965,90.663,90.35,90.025,89.689,89.34,88.978,88.604,88.216,87.815,87.399,86.969,86.525,86.064,85.588,85.096,84.587,84.06,83.516,82.953,82.371,81.769,81.147,80.503,79.838,79.151,78.44,77.704,76.944,76.157,75.344,74.502,73.632,72.731,71.798,70.832,69.833,68.797,67.725,66.614,65.462,64.268,63.029,61.744,60.411,59.027,57.589,56.095,54.543,52.928,51.248,49.499,47.677,45.779,43.8,41.734,39.578,37.325,34.97,32.506,29.925,27.22,24.383,21.404,18.273,14.979,11.509,7.8508,3.9882,-0.095102,},
{-2.0177,2.3711,6.5127,10.427,14.131,17.64,20.969,24.131,27.138,30.0,32.726,35.325,37.806,40.176,42.442,44.609,46.685,48.673,50.578,52.406,54.161,55.846,57.465,59.021,60.518,61.958,63.345,64.68,65.966,67.206,68.401,69.554,70.666,71.739,72.775,73.775,74.741,75.674,76.575,77.446,78.288,79.102,79.888,80.649,81.384,82.096,82.784,83.449,84.093,84.716,85.319,85.901,86.465,87.011,87.538,88.049,88.542,89.02,89.481,89.928,90.359,90.777,91.18,91.569,91.946,92.31,92.661,93.0,93.327,93.642,93.947,94.24,94.523,94.796,95.058,95.311,95.553,95.787,96.011,96.227,96.434,96.632,96.822,97.003,97.177,97.344,97.502,97.653,97.797,97.934,98.064,98.188,98.305,98.415,98.519,98.617,98.709,98.795,98.876,98.95,99.02,99.084,99.143,99.197,99.246,99.29,99.329,99.364,99.394,99.42,99.442,99.459,99.473,99.483,99.489,99.491,99.489,99.484,99.476,99.465,99.45,99.433,99.412,99.388,99.362,99.333,99.302,99.268,99.232,99.194,99.154,99.111,99.067,99.021,98.973,98.924,98.873,98.821,98.767,98.713,98.657,98.6,98.543,98.484,98.425,98.366,98.305,98.245,98.184,98.123,98.063,98.002,97.941,97.88,97.82,97.76,97.701,97.643,97.585,97.527,97.471,97.416,97.362,97.309,97.257,97.206,97.157,97.11,97.063,97.019,96.976,96.935,96.896,96.859,96.823,96.79,96.758,96.729,96.702,96.677,96.654,96.634,96.616,96.6,96.587,96.576,96.567,96.561,96.557,96.556,96.557,96.56,96.566,96.574,96.585,96.598,96.613,96.631,96.651,96.674,96.698,96.725,96.754,96.785,96.818,96.853,96.89,96.929,96.97,97.012,97.057,97.103,97.15,97.199,97.249,97.301,97.354,97.408,97.463,97.519,97.576,97.634,97.692,97.752,97.811,97.871,97.932,97.993,98.053,98.114,98.175,98.236,98.296,98.357,98.416,98.475,98.534,98.592,98.649,98.704,98.759,98.813,98.865,98.916,98.966,99.014,99.06,99.105,99.148,99.188,99.227,99.263,99.297,99.329,99.358,99.385,99.409,99.43,99.448,99.463,99.475,99.483,99.489,99.491,99.489,99.484,99.475,99.462,99.445,99.424,99.398,99.369,99.335,99.296,99.252,99.204,99.151,99.093,99.03,98.961,98.887,98.807,98.722,98.631,98.534,98.431,98.321,98.206,98.083,97.954,97.818,97.675,97.525,97.368,97.203,97.03,96.849,96.661,96.464,96.258,96.044,95.821,95.589,95.347,95.096,94.835,94.564,94.283,93.991,93.688,93.374,93.049,92.712,92.363,92.001,91.626,91.239,90.837,90.422,89.993,89.549,89.089,88.614,88.123,87.615,87.09,86.547,85.986,85.406,84.807,84.187,83.546,82.884,82.2,81.492,80.76,80.003,79.22,78.41,77.573,76.706,75.81,74.882,73.921,72.926,71.895,70.828,69.722,68.575,67.387,66.154,64.874,63.546,62.168,60.736,59.247,57.7,56.091,54.416,52.672,50.855,48.961,46.985,44.924,42.77,40.519,38.165,35.701,33.12,30.413,27.572,24.588,21.45,18.146,14.664,10.99,},
{9.4342,13.374,17.099,20.627,23.971,27.145,30.161,33.03,35.761,38.365,40.849,43.22,45.486,47.653,49.727,51.713,53.616,55.441,57.193,58.874,60.489,62.041,63.534,64.97,66.352,67.683,68.965,70.2,71.39,72.539,73.646,74.715,75.746,76.742,77.704,78.633,79.53,80.397,81.235,82.046,82.829,83.586,84.319,85.028,85.713,86.376,87.017,87.638,88.238,88.819,89.381,89.925,90.451,90.96,91.453,91.929,92.39,92.836,93.267,93.684,94.087,94.477,94.853,95.217,95.569,95.908,96.236,96.553,96.858,97.153,97.437,97.711,97.974,98.229,98.473,98.709,98.935,99.152,99.361,99.562,99.754,99.939,100.12,100.28,100.45,100.6,100.75,100.89,101.02,101.15,101.27,101.38,101.49,101.59,101.68,101.77,101.86,101.94,102.01,102.08,102.14,102.2,102.25,102.3,102.34,102.38,102.42,102.45,102.47,102.49,102.51,102.53,102.54,102.54,102.54,102.54,102.54,102.53,102.52,102.51,102.49,102.47,102.45,102.42,102.4,102.37,102.33,102.3,102.26,102.22,102.18,102.14,102.09,102.05,102.0,101.95,101.9,101.85,101.79,101.74,101.68,101.63,101.57,101.51,101.45,101.39,101.33,101.27,101.21,101.15,101.09,101.03,100.97,100.91,100.85,100.8,100.74,100.68,100.62,100.57,100.51,100.46,100.4,100.35,100.3,100.25,100.2,100.16,100.11,100.07,100.02,99.984,99.945,99.909,99.874,99.841,99.81,99.782,99.755,99.731,99.708,99.688,99.671,99.655,99.642,99.631,99.623,99.616,99.613,99.611,99.612,99.616,99.622,99.63,99.64,99.653,99.668,99.686,99.705,99.727,99.751,99.778,99.806,99.836,99.869,99.903,99.94,99.978,100.02,100.06,100.1,100.15,100.19,100.24,100.29,100.34,100.4,100.45,100.5,100.56,100.61,100.67,100.73,100.79,100.85,100.9,100.96,101.02,101.08,101.14,101.2,101.26,101.32,101.38,101.44,101.5,101.56,101.62,101.67,101.73,101.78,101.84,101.89,101.94,101.99,102.04,102.09,102.13,102.17,102.22,102.26,102.29,102.33,102.36,102.39,102.42,102.44,102.47,102.49,102.5,102.52,102.53,102.54,102.54,102.54,102.54,102.54,102.53,102.51,102.5,102.48,102.45,102.42,102.39,102.35,102.31,102.26,102.21,102.15,102.09,102.02,101.95,101.87,101.79,101.7,101.6,101.5,101.4,101.28,101.16,101.04,100.91,100.77,100.62,100.47,100.31,100.14,99.965,99.782,99.591,99.392,99.184,98.968,98.743,98.509,98.265,98.013,97.75,97.478,97.195,96.902,96.599,96.284,95.958,95.62,95.27,94.908,94.534,94.146,93.745,93.33,92.901,92.457,91.999,91.525,91.035,90.528,90.004,89.463,88.904,88.326,87.728,87.111,86.473,85.813,85.131,84.426,83.697,82.943,82.164,81.358,80.524,79.661,78.768,77.844,76.887,75.896,74.87,73.807,72.706,71.564,70.379,69.151,67.876,66.553,65.179,63.751,62.267,60.724,59.118,57.447,55.706,53.892,52.001,50.027,47.967,45.814,43.563,41.208,38.741,36.156,33.444,30.596,27.603,24.453,21.135,},
{19.891,23.442,26.805,29.995,33.025,35.905,38.645,41.256,43.745,46.12,48.389,50.558,52.633,54.619,56.522,58.345,60.095,61.774,63.387,64.936,66.426,67.858,69.237,70.564,71.842,73.074,74.261,75.405,76.509,77.574,78.602,79.594,80.552,81.477,82.371,83.235,84.07,84.877,85.658,86.412,87.142,87.848,88.531,89.192,89.831,90.45,91.048,91.627,92.188,92.73,93.255,93.763,94.255,94.73,95.19,95.636,96.066,96.483,96.886,97.275,97.652,98.016,98.368,98.708,99.037,99.354,99.66,99.956,100.24,100.52,100.78,101.04,101.28,101.52,101.75,101.97,102.18,102.38,102.58,102.76,102.94,103.11,103.28,103.44,103.59,103.73,103.86,103.99,104.12,104.23,104.35,104.45,104.55,104.64,104.73,104.81,104.89,104.96,105.03,105.09,105.15,105.2,105.25,105.29,105.33,105.36,105.39,105.42,105.44,105.46,105.47,105.48,105.49,105.49,105.49,105.49,105.48,105.47,105.46,105.44,105.42,105.4,105.38,105.35,105.32,105.29,105.26,105.22,105.18,105.14,105.1,105.06,105.01,104.97,104.92,104.87,104.82,104.77,104.71,104.66,104.6,104.55,104.49,104.43,104.37,104.32,104.26,104.2,104.14,104.08,104.02,103.96,103.9,103.84,103.78,103.73,103.67,103.61,103.56,103.5,103.45,103.39,103.34,103.29,103.24,103.19,103.14,103.1,103.05,103.01,102.97,102.93,102.89,102.85,102.82,102.79,102.76,102.73,102.7,102.68,102.66,102.64,102.62,102.61,102.59,102.58,102.57,102.57,102.56,102.56,102.56,102.57,102.57,102.58,102.59,102.6,102.62,102.64,102.66,102.68,102.7,102.73,102.75,102.78,102.82,102.85,102.89,102.92,102.96,103.0,103.05,103.09,103.14,103.18,103.23,103.28,103.33,103.38,103.44,103.49,103.55,103.6,103.66,103.72,103.78,103.83,103.89,103.95,104.01,104.07,104.13,104.19,104.25,104.31,104.37,104.42,104.48,104.54,104.59,104.65,104.7,104.76,104.81,104.86,104.91,104.96,105.01,105.05,105.1,105.14,105.18,105.22,105.25,105.29,105.32,105.35,105.37,105.4,105.42,105.44,105.45,105.47,105.48,105.49,105.49,105.49,105.49,105.48,105.47,105.46,105.44,105.42,105.39,105.37,105.33,105.29,105.25,105.21,105.15,105.1,105.04,104.97,104.9,104.82,104.74,104.66,104.56,104.47,104.36,104.25,104.14,104.01,103.88,103.75,103.61,103.46,103.3,103.14,102.97,102.79,102.61,102.41,102.21,102.0,101.78,101.56,101.32,101.07,100.82,100.56,100.28,99.999,99.705,99.4,99.085,98.758,98.42,98.069,97.707,97.332,96.945,96.544,96.129,95.7,95.257,94.799,94.326,93.837,93.332,92.809,92.27,91.712,91.135,90.54,89.924,89.288,88.631,87.951,87.249,86.522,85.772,84.995,84.192,83.361,82.502,81.612,80.691,79.738,78.751,77.729,76.67,75.572,74.433,73.253,72.028,70.757,69.437,68.067,66.642,65.161,63.621,62.018,60.349,58.61,56.797,54.907,52.933,50.872,48.718,46.464,44.105,41.633,39.041,36.32,33.462,30.455,},
{29.479,32.69,35.737,38.631,41.384,44.005,46.502,48.884,51.158,53.331,55.409,57.397,59.301,61.125,62.874,64.553,66.164,67.712,69.2,70.63,72.006,73.331,74.606,75.835,77.019,78.16,79.261,80.323,81.348,82.337,83.292,84.214,85.105,85.966,86.799,87.603,88.381,89.133,89.86,90.564,91.245,91.903,92.541,93.157,93.754,94.332,94.891,95.432,95.956,96.463,96.953,97.428,97.888,98.332,98.763,99.179,99.582,99.971,100.35,100.71,101.07,101.41,101.73,102.05,102.36,102.66,102.94,103.22,103.49,103.74,103.99,104.23,104.46,104.68,104.89,105.1,105.3,105.49,105.67,105.84,106.01,106.17,106.32,106.47,106.61,106.74,106.86,106.98,107.1,107.21,107.31,107.41,107.5,107.58,107.66,107.74,107.81,107.87,107.93,107.99,108.04,108.09,108.13,108.17,108.2,108.23,108.26,108.28,108.3,108.31,108.32,108.33,108.33,108.33,108.33,108.32,108.32,108.3,108.29,108.27,108.25,108.23,108.2,108.18,108.15,108.11,108.08,108.04,108.0,107.96,107.92,107.88,107.83,107.79,107.74,107.69,107.64,107.59,107.53,107.48,107.42,107.37,107.31,107.25,107.2,107.14,107.08,107.02,106.96,106.91,106.85,106.79,106.73,106.67,106.62,106.56,106.5,106.45,106.39,106.34,106.28,106.23,106.18,106.13,106.08,106.03,105.99,105.94,105.9,105.85,105.81,105.78,105.74,105.7,105.67,105.64,105.61,105.58,105.56,105.53,105.51,105.49,105.47,105.46,105.45,105.44,105.43,105.42,105.42,105.42,105.42,105.42,105.43,105.43,105.44,105.46,105.47,105.49,105.51,105.53,105.55,105.58,105.6,105.63,105.66,105.7,105.73,105.77,105.81,105.85,105.89,105.93,105.98,106.02,106.07,106.12,106.17,106.22,106.28,106.33,106.38,106.44,106.49,106.55,106.61,106.66,106.72,106.78,106.84,106.9,106.96,107.01,107.07,107.13,107.19,107.25,107.3,107.36,107.42,107.47,107.52,107.58,107.63,107.68,107.73,107.78,107.83,107.87,107.91,107.96,108.0,108.04,108.07,108.11,108.14,108.17,108.2,108.22,108.25,108.27,108.29,108.3,108.31,108.32,108.33,108.33,108.33,108.33,108.32,108.31,108.3,108.28,108.26,108.24,108.21,108.17,108.14,108.1,108.05,108.0,107.94,107.88,107.82,107.75,107.68,107.6,107.51,107.42,107.32,107.22,107.12,107.0,106.88,106.76,106.63,106.49,106.34,106.19,106.03,105.87,105.69,105.51,105.33,105.13,104.93,104.71,104.49,104.27,104.03,103.78,103.53,103.26,102.98,102.7,102.4,102.1,101.78,101.46,101.12,100.77,100.4,100.03,99.64,99.24,98.825,98.397,97.955,97.497,97.025,96.536,96.032,95.511,94.972,94.416,93.841,93.247,92.634,91.999,91.344,90.667,89.966,89.243,88.494,87.72,86.92,86.092,85.235,84.349,83.431,82.481,81.497,80.478,79.421,78.326,77.191,76.014,74.792,73.524,72.207,70.838,69.416,67.937,66.398,64.797,63.128,61.39,59.577,57.685,55.71,53.646,51.487,49.229,46.863,44.384,41.782,39.049,},
{38.302,41.215,43.984,46.618,49.126,51.518,53.8,55.979,58.061,60.053,61.96,63.786,65.537,67.216,68.828,70.375,71.862,73.292,74.667,75.989,77.263,78.489,79.671,80.81,81.909,82.968,83.99,84.977,85.929,86.849,87.738,88.596,89.426,90.228,91.004,91.754,92.479,93.181,93.859,94.516,95.152,95.767,96.362,96.938,97.496,98.036,98.559,99.065,99.554,100.03,100.49,100.93,101.36,101.78,102.18,102.57,102.95,103.31,103.66,104.01,104.34,104.65,104.96,105.26,105.55,105.83,106.09,106.35,106.6,106.84,107.07,107.3,107.51,107.72,107.92,108.11,108.29,108.47,108.64,108.8,108.96,109.1,109.25,109.38,109.51,109.63,109.75,109.86,109.97,110.07,110.16,110.25,110.34,110.42,110.49,110.56,110.62,110.68,110.74,110.79,110.83,110.88,110.91,110.95,110.98,111.0,111.02,111.04,111.06,111.07,111.08,111.08,111.08,111.08,111.07,111.07,111.05,111.04,111.02,111.0,110.98,110.96,110.93,110.9,110.87,110.84,110.8,110.77,110.73,110.69,110.65,110.6,110.56,110.51,110.46,110.41,110.36,110.31,110.26,110.2,110.15,110.09,110.04,109.98,109.93,109.87,109.81,109.75,109.7,109.64,109.58,109.52,109.47,109.41,109.35,109.3,109.24,109.19,109.13,109.08,109.03,108.97,108.92,108.87,108.83,108.78,108.73,108.69,108.65,108.61,108.57,108.53,108.49,108.46,108.42,108.39,108.36,108.34,108.31,108.29,108.27,108.25,108.23,108.22,108.21,108.2,108.19,108.18,108.18,108.18,108.18,108.18,108.19,108.19,108.2,108.22,108.23,108.25,108.27,108.29,108.31,108.33,108.36,108.39,108.42,108.45,108.49,108.52,108.56,108.6,108.64,108.68,108.73,108.77,108.82,108.87,108.92,108.97,109.02,109.07,109.12,109.18,109.23,109.29,109.34,109.4,109.46,109.52,109.57,109.63,109.69,109.75,109.8,109.86,109.92,109.97,110.03,110.09,110.14,110.2,110.25,110.3,110.35,110.4,110.45,110.5,110.55,110.6,110.64,110.68,110.72,110.76,110.8,110.83,110.87,110.9,110.93,110.96,110.98,111.0,111.02,111.04,111.05,111.06,111.07,111.08,111.08,111.08,111.08,111.07,111.06,111.04,111.03,111.01,110.98,110.95,110.92,110.88,110.84,110.79,110.74,110.69,110.63,110.57,110.5,110.43,110.35,110.27,110.18,110.08,109.98,109.88,109.77,109.65,109.53,109.4,109.27,109.13,108.98,108.82,108.66,108.49,108.32,108.14,107.95,107.75,107.54,107.33,107.11,106.88,106.64,106.39,106.13,105.87,105.59,105.3,105.01,104.7,104.38,104.06,103.72,103.37,103.0,102.63,102.24,101.84,101.42,101.0,100.55,100.1,99.626,99.138,98.635,98.115,97.577,97.022,96.449,95.857,95.244,94.612,93.958,93.283,92.585,91.863,91.117,90.345,89.547,88.722,87.867,86.983,86.068,85.12,84.139,83.122,82.068,80.976,79.843,78.668,77.448,76.182,74.866,73.499,72.078,70.6,69.062,67.46,65.791,64.051,62.236,60.342,58.363,56.294,54.13,51.864,49.489,46.998,},
{46.45,49.101,51.623,54.027,56.319,58.506,60.596,62.594,64.505,66.335,68.089,69.77,71.383,72.932,74.419,75.848,77.223,78.545,79.817,81.043,82.223,83.36,84.457,85.515,86.535,87.519,88.47,89.388,90.274,91.131,91.959,92.759,93.532,94.28,95.004,95.704,96.381,97.036,97.67,98.283,98.877,99.452,100.01,100.55,101.07,101.57,102.06,102.54,103.0,103.44,103.87,104.28,104.69,105.08,105.45,105.82,106.17,106.51,106.84,107.16,107.47,107.77,108.06,108.34,108.61,108.87,109.12,109.36,109.59,109.82,110.04,110.25,110.45,110.64,110.83,111.0,111.18,111.34,111.5,111.65,111.79,111.93,112.06,112.19,112.31,112.43,112.53,112.64,112.74,112.83,112.92,113.0,113.08,113.15,113.22,113.28,113.34,113.39,113.44,113.49,113.53,113.56,113.6,113.63,113.65,113.68,113.69,113.71,113.72,113.73,113.73,113.74,113.73,113.73,113.72,113.71,113.7,113.68,113.67,113.65,113.62,113.6,113.57,113.54,113.51,113.48,113.44,113.4,113.36,113.32,113.28,113.24,113.19,113.14,113.1,113.05,113.0,112.95,112.89,112.84,112.79,112.73,112.68,112.62,112.57,112.51,112.45,112.4,112.34,112.28,112.23,112.17,112.11,112.06,112.0,111.95,111.89,111.84,111.78,111.73,111.68,111.63,111.58,111.53,111.49,111.44,111.39,111.35,111.31,111.27,111.23,111.19,111.16,111.12,111.09,111.06,111.03,111.01,110.98,110.96,110.94,110.92,110.9,110.89,110.88,110.87,110.86,110.85,110.85,110.85,110.85,110.85,110.86,110.87,110.88,110.89,110.9,110.92,110.94,110.96,110.98,111.0,111.03,111.06,111.09,111.12,111.15,111.19,111.22,111.26,111.3,111.34,111.39,111.43,111.48,111.53,111.57,111.62,111.67,111.72,111.78,111.83,111.88,111.94,111.99,112.05,112.1,112.16,112.22,112.27,112.33,112.39,112.44,112.5,112.56,112.61,112.67,112.72,112.78,112.83,112.89,112.94,112.99,113.04,113.09,113.14,113.18,113.23,113.27,113.32,113.36,113.4,113.43,113.47,113.5,113.54,113.57,113.59,113.62,113.64,113.66,113.68,113.7,113.71,113.72,113.73,113.73,113.74,113.73,113.73,113.72,113.71,113.7,113.68,113.66,113.63,113.6,113.57,113.53,113.49,113.45,113.4,113.35,113.29,113.22,113.16,113.09,113.01,112.93,112.84,112.75,112.65,112.55,112.44,112.33,112.21,112.08,111.95,111.82,111.67,111.52,111.36,111.2,111.03,110.85,110.67,110.48,110.28,110.07,109.85,109.63,109.4,109.16,108.91,108.65,108.38,108.1,107.82,107.52,107.21,106.89,106.56,106.22,105.87,105.51,105.13,104.75,104.35,103.93,103.5,103.06,102.61,102.13,101.65,101.15,100.63,100.09,99.536,98.964,98.373,97.762,97.131,96.479,95.806,95.109,94.389,93.645,92.875,92.079,91.256,90.403,89.521,88.608,87.663,86.683,85.668,84.617,83.526,82.395,81.221,80.002,78.737,77.422,76.056,74.635,73.157,71.617,70.014,68.343,66.601,64.782,62.883,60.898,58.823,56.65,54.374,},
{53.998,56.416,58.72,60.919,63.018,65.023,66.941,68.777,70.535,72.22,73.836,75.386,76.875,78.306,79.68,81.003,82.275,83.5,84.68,85.816,86.912,87.968,88.987,89.97,90.919,91.835,92.72,93.575,94.401,95.199,95.971,96.718,97.439,98.138,98.813,99.467,100.1,100.71,101.3,101.88,102.43,102.97,103.49,104.0,104.49,104.96,105.42,105.86,106.29,106.71,107.11,107.5,107.87,108.24,108.59,108.94,109.27,109.59,109.9,110.2,110.49,110.76,111.04,111.3,111.55,111.79,112.03,112.25,112.47,112.68,112.89,113.08,113.27,113.45,113.62,113.79,113.95,114.11,114.25,114.39,114.53,114.66,114.78,114.9,115.01,115.12,115.22,115.31,115.4,115.49,115.57,115.65,115.72,115.78,115.85,115.9,115.96,116.01,116.05,116.09,116.13,116.16,116.19,116.22,116.24,116.26,116.27,116.29,116.29,116.3,116.3,116.3,116.3,116.29,116.28,116.27,116.26,116.24,116.22,116.2,116.18,116.15,116.12,116.09,116.06,116.02,115.99,115.95,115.91,115.87,115.83,115.78,115.74,115.69,115.64,115.6,115.55,115.5,115.44,115.39,115.34,115.28,115.23,115.18,115.12,115.06,115.01,114.95,114.9,114.84,114.79,114.73,114.68,114.62,114.57,114.51,114.46,114.41,114.35,114.3,114.25,114.2,114.15,114.11,114.06,114.01,113.97,113.93,113.89,113.85,113.81,113.77,113.74,113.7,113.67,113.64,113.62,113.59,113.57,113.54,113.52,113.51,113.49,113.48,113.46,113.45,113.45,113.44,113.44,113.44,113.44,113.44,113.45,113.45,113.46,113.47,113.49,113.5,113.52,113.54,113.56,113.59,113.61,113.64,113.67,113.7,113.73,113.77,113.8,113.84,113.88,113.92,113.96,114.01,114.05,114.1,114.15,114.19,114.24,114.29,114.35,114.4,114.45,114.5,114.56,114.61,114.67,114.72,114.78,114.83,114.89,114.95,115.0,115.06,115.11,115.17,115.22,115.28,115.33,115.38,115.44,115.49,115.54,115.59,115.64,115.69,115.73,115.78,115.82,115.86,115.91,115.94,115.98,116.02,116.05,116.09,116.12,116.15,116.17,116.2,116.22,116.24,116.25,116.27,116.28,116.29,116.3,116.3,116.3,116.3,116.3,116.29,116.28,116.26,116.24,116.22,116.2,116.17,116.13,116.1,116.06,116.01,115.96,115.91,115.85,115.79,115.73,115.66,115.58,115.5,115.42,115.33,115.23,115.13,115.03,114.92,114.8,114.68,114.55,114.41,114.27,114.13,113.97,113.82,113.65,113.48,113.3,113.11,112.92,112.71,112.5,112.29,112.06,111.83,111.59,111.33,111.07,110.81,110.53,110.24,109.94,109.63,109.31,108.99,108.64,108.29,107.93,107.55,107.17,106.77,106.35,105.92,105.48,105.03,104.56,104.07,103.57,103.05,102.52,101.96,101.39,100.8,100.19,99.562,98.912,98.24,97.545,96.826,96.084,95.316,94.521,93.699,92.849,91.968,91.057,90.113,89.135,88.122,87.071,85.981,84.851,83.678,82.46,81.195,79.88,78.513,77.091,75.611,74.07,72.464,70.79,69.043,67.219,65.314,63.322,61.237,},
{61.01,63.221,65.332,67.347,69.274,71.116,72.88,74.57,76.19,77.744,79.236,80.668,82.045,83.368,84.641,85.866,87.046,88.182,89.277,90.333,91.351,92.333,93.281,94.196,95.079,95.933,96.758,97.555,98.325,99.07,99.791,100.49,101.16,101.81,102.45,103.06,103.65,104.22,104.78,105.31,105.83,106.34,106.82,107.3,107.75,108.2,108.63,109.04,109.45,109.84,110.21,110.58,110.93,111.27,111.61,111.93,112.24,112.54,112.83,113.11,113.38,113.64,113.9,114.14,114.38,114.61,114.83,115.04,115.24,115.44,115.63,115.81,115.99,116.16,116.32,116.48,116.63,116.77,116.91,117.04,117.17,117.29,117.4,117.51,117.61,117.71,117.81,117.89,117.98,118.06,118.13,118.2,118.27,118.33,118.39,118.44,118.49,118.53,118.57,118.61,118.64,118.67,118.7,118.72,118.74,118.75,118.77,118.78,118.78,118.79,118.79,118.78,118.78,118.77,118.76,118.75,118.73,118.71,118.69,118.67,118.64,118.62,118.59,118.56,118.53,118.49,118.45,118.42,118.38,118.34,118.29,118.25,118.21,118.16,118.11,118.06,118.01,117.96,117.91,117.86,117.81,117.76,117.7,117.65,117.59,117.54,117.49,117.43,117.38,117.32,117.27,117.21,117.16,117.1,117.05,117.0,116.94,116.89,116.84,116.79,116.74,116.69,116.65,116.6,116.55,116.51,116.47,116.42,116.38,116.35,116.31,116.27,116.24,116.21,116.18,116.15,116.12,116.09,116.07,116.05,116.03,116.01,116.0,115.98,115.97,115.96,115.95,115.95,115.94,115.94,115.94,115.95,115.95,115.96,115.97,115.98,115.99,116.01,116.03,116.05,116.07,116.09,116.12,116.14,116.17,116.2,116.23,116.27,116.3,116.34,116.38,116.42,116.46,116.5,116.55,116.59,116.64,116.69,116.73,116.78,116.83,116.88,116.94,116.99,117.04,117.09,117.15,117.2,117.26,117.31,117.37,117.42,117.48,117.53,117.59,117.64,117.69,117.75,117.8,117.85,117.91,117.96,118.01,118.06,118.1,118.15,118.2,118.24,118.29,118.33,118.37,118.41,118.45,118.49,118.52,118.55,118.58,118.61,118.64,118.67,118.69,118.71,118.73,118.74,118.76,118.77,118.78,118.78,118.79,118.79,118.78,118.78,118.77,118.76,118.74,118.72,118.7,118.68,118.65,118.61,118.58,118.54,118.49,118.45,118.39,118.34,118.28,118.21,118.14,118.07,117.99,117.91,117.82,117.73,117.63,117.53,117.42,117.3,117.18,117.06,116.93,116.79,116.65,116.5,116.34,116.18,116.01,115.84,115.66,115.47,115.27,115.07,114.86,114.64,114.41,114.18,113.93,113.68,113.42,113.15,112.87,112.58,112.28,111.97,111.65,111.32,110.98,110.63,110.27,109.89,109.5,109.1,108.69,108.26,107.82,107.37,106.9,106.41,105.91,105.39,104.86,104.31,103.74,103.15,102.54,101.91,101.26,100.59,99.896,99.179,98.438,97.671,96.878,96.057,95.208,94.329,93.419,92.476,91.499,90.486,89.436,88.347,87.217,86.044,84.826,83.56,82.245,80.876,79.452,77.97,76.425,74.815,73.136,71.383,69.553,67.639,},
{67.542,69.57,71.506,73.358,75.13,76.826,78.451,80.01,81.505,82.941,84.32,85.645,86.92,88.146,89.326,90.463,91.558,92.613,93.631,94.613,95.56,96.474,97.357,98.21,99.034,99.83,100.6,101.34,102.06,102.76,103.43,104.08,104.71,105.32,105.91,106.49,107.04,107.58,108.1,108.6,109.09,109.56,110.02,110.46,110.89,111.3,111.7,112.09,112.47,112.84,113.19,113.53,113.87,114.19,114.5,114.8,115.09,115.37,115.65,115.91,116.16,116.41,116.65,116.88,117.1,117.31,117.52,117.72,117.91,118.1,118.27,118.44,118.61,118.77,118.92,119.07,119.21,119.34,119.47,119.59,119.71,119.82,119.93,120.03,120.13,120.22,120.31,120.39,120.47,120.54,120.61,120.67,120.73,120.79,120.84,120.89,120.93,120.97,121.01,121.04,121.07,121.1,121.12,121.14,121.16,121.17,121.18,121.19,121.19,121.19,121.19,121.18,121.18,121.17,121.16,121.14,121.13,121.11,121.08,121.06,121.04,121.01,120.98,120.95,120.91,120.88,120.84,120.81,120.77,120.73,120.68,120.64,120.59,120.55,120.5,120.45,120.41,120.36,120.31,120.25,120.2,120.15,120.1,120.04,119.99,119.94,119.88,119.83,119.78,119.72,119.67,119.62,119.56,119.51,119.46,119.4,119.35,119.3,119.25,119.2,119.15,119.11,119.06,119.02,118.97,118.93,118.89,118.84,118.81,118.77,118.73,118.7,118.66,118.63,118.6,118.57,118.55,118.52,118.5,118.48,118.46,118.44,118.43,118.41,118.4,118.39,118.38,118.38,118.38,118.37,118.37,118.38,118.38,118.39,118.4,118.41,118.42,118.44,118.46,118.47,118.49,118.52,118.54,118.57,118.6,118.63,118.66,118.69,118.73,118.76,118.8,118.84,118.88,118.92,118.96,119.01,119.05,119.1,119.15,119.2,119.25,119.3,119.35,119.4,119.45,119.5,119.55,119.61,119.66,119.71,119.77,119.82,119.88,119.93,119.98,120.04,120.09,120.14,120.2,120.25,120.3,120.35,120.4,120.45,120.5,120.54,120.59,120.63,120.68,120.72,120.76,120.8,120.84,120.87,120.91,120.94,120.97,121.0,121.03,121.06,121.08,121.1,121.12,121.14,121.15,121.17,121.18,121.18,121.19,121.19,121.19,121.19,121.18,121.17,121.16,121.14,121.12,121.1,121.08,121.05,121.01,120.98,120.94,120.89,120.85,120.8,120.74,120.68,120.62,120.55,120.48,120.4,120.32,120.23,120.14,120.04,119.94,119.84,119.73,119.61,119.49,119.36,119.23,119.09,118.94,118.79,118.63,118.47,118.3,118.12,117.94,117.75,117.55,117.34,117.13,116.91,116.68,116.45,116.2,115.95,115.69,115.41,115.13,114.84,114.54,114.23,113.92,113.58,113.24,112.89,112.53,112.15,111.76,111.36,110.95,110.52,110.08,109.63,109.16,108.67,108.17,107.65,107.12,106.57,106.0,105.41,104.81,104.18,103.53,102.86,102.17,101.45,100.71,99.946,99.154,98.334,97.486,96.607,95.698,94.756,93.779,92.767,91.717,90.628,89.498,88.324,87.105,85.838,84.52,83.149,81.722,80.236,78.687,77.072,75.386,73.626,},
{73.644,75.506,77.287,78.991,80.623,82.187,83.688,85.127,86.51,87.838,89.115,90.343,91.525,92.663,93.759,94.815,95.833,96.814,97.761,98.675,99.558,100.41,101.23,102.03,102.8,103.54,104.26,104.95,105.63,106.28,106.91,107.52,108.11,108.68,109.23,109.77,110.28,110.79,111.27,111.74,112.2,112.64,113.07,113.49,113.89,114.28,114.66,115.02,115.38,115.72,116.05,116.38,116.69,116.99,117.28,117.56,117.84,118.1,118.36,118.6,118.84,119.07,119.3,119.51,119.72,119.92,120.12,120.3,120.48,120.66,120.82,120.98,121.14,121.29,121.43,121.56,121.7,121.82,121.94,122.06,122.17,122.27,122.37,122.46,122.55,122.64,122.72,122.8,122.87,122.94,123.0,123.06,123.11,123.17,123.21,123.26,123.3,123.33,123.37,123.4,123.42,123.45,123.47,123.48,123.5,123.51,123.51,123.52,123.52,123.52,123.52,123.51,123.5,123.49,123.48,123.46,123.44,123.42,123.4,123.38,123.35,123.32,123.29,123.26,123.23,123.19,123.16,123.12,123.08,123.04,123.0,122.95,122.91,122.87,122.82,122.77,122.72,122.67,122.62,122.57,122.52,122.47,122.42,122.37,122.32,122.26,122.21,122.16,122.1,122.05,122.0,121.95,121.89,121.84,121.79,121.74,121.69,121.64,121.59,121.54,121.5,121.45,121.4,121.36,121.32,121.27,121.23,121.19,121.15,121.12,121.08,121.05,121.01,120.98,120.95,120.93,120.9,120.88,120.85,120.83,120.81,120.8,120.78,120.77,120.76,120.75,120.74,120.74,120.73,120.73,120.73,120.74,120.74,120.75,120.76,120.77,120.78,120.79,120.81,120.83,120.85,120.87,120.9,120.92,120.95,120.98,121.01,121.04,121.08,121.11,121.15,121.19,121.23,121.27,121.31,121.35,121.4,121.44,121.49,121.54,121.58,121.63,121.68,121.73,121.78,121.83,121.89,121.94,121.99,122.04,122.1,122.15,122.2,122.26,122.31,122.36,122.41,122.46,122.52,122.57,122.62,122.67,122.72,122.76,122.81,122.86,122.9,122.95,122.99,123.03,123.07,123.11,123.15,123.19,123.22,123.26,123.29,123.32,123.35,123.37,123.4,123.42,123.44,123.46,123.47,123.49,123.5,123.51,123.52,123.52,123.52,123.52,123.51,123.51,123.5,123.48,123.47,123.45,123.43,123.4,123.37,123.34,123.3,123.26,123.22,123.17,123.12,123.07,123.01,122.95,122.88,122.81,122.73,122.65,122.57,122.48,122.38,122.29,122.18,122.07,121.96,121.84,121.71,121.58,121.45,121.31,121.16,121.01,120.85,120.68,120.51,120.33,120.14,119.95,119.75,119.54,119.33,119.11,118.88,118.64,118.39,118.14,117.88,117.6,117.32,117.03,116.73,116.42,116.1,115.77,115.43,115.08,114.71,114.34,113.95,113.55,113.14,112.71,112.27,111.81,111.34,110.86,110.36,109.84,109.31,108.76,108.19,107.6,107.0,106.37,105.72,105.05,104.36,103.65,102.91,102.14,101.35,100.53,99.686,98.808,97.899,96.957,95.981,94.968,93.918,92.828,91.697,90.522,89.301,88.031,86.711,85.336,83.905,82.414,80.86,79.238,},
{79.355,81.069,82.71,84.281,85.787,87.232,88.619,89.952,91.232,92.462,93.646,94.786,95.883,96.94,97.959,98.941,99.888,100.8,101.68,102.54,103.36,104.15,104.92,105.66,106.38,107.08,107.75,108.4,109.03,109.64,110.23,110.8,111.35,111.88,112.4,112.9,113.39,113.86,114.32,114.76,115.19,115.6,116.01,116.4,116.77,117.14,117.49,117.84,118.17,118.49,118.8,119.11,119.4,119.68,119.96,120.22,120.48,120.73,120.97,121.2,121.42,121.64,121.85,122.05,122.25,122.44,122.62,122.79,122.96,123.13,123.28,123.43,123.58,123.72,123.85,123.98,124.1,124.22,124.33,124.44,124.54,124.64,124.73,124.82,124.9,124.98,125.05,125.13,125.19,125.25,125.31,125.37,125.42,125.47,125.51,125.55,125.59,125.62,125.65,125.67,125.7,125.72,125.74,125.75,125.76,125.77,125.77,125.78,125.78,125.77,125.77,125.76,125.75,125.74,125.73,125.71,125.69,125.67,125.65,125.62,125.6,125.57,125.54,125.51,125.47,125.44,125.4,125.36,125.32,125.28,125.24,125.2,125.16,125.11,125.07,125.02,124.97,124.92,124.87,124.82,124.77,124.72,124.67,124.62,124.57,124.52,124.47,124.41,124.36,124.31,124.26,124.21,124.16,124.11,124.06,124.01,123.96,123.91,123.86,123.81,123.77,123.72,123.68,123.63,123.59,123.55,123.51,123.47,123.43,123.4,123.36,123.33,123.3,123.27,123.24,123.21,123.18,123.16,123.14,123.12,123.1,123.08,123.07,123.06,123.05,123.04,123.03,123.02,123.02,123.02,123.02,123.02,123.03,123.04,123.04,123.05,123.07,123.08,123.1,123.12,123.14,123.16,123.18,123.21,123.23,123.26,123.29,123.32,123.36,123.39,123.43,123.46,123.5,123.54,123.58,123.63,123.67,123.71,123.76,123.81,123.85,123.9,123.95,124.0,124.05,124.1,124.15,124.2,124.25,124.3,124.36,124.41,124.46,124.51,124.56,124.61,124.67,124.72,124.77,124.82,124.87,124.92,124.96,125.01,125.06,125.1,125.15,125.19,125.24,125.28,125.32,125.36,125.4,125.43,125.47,125.5,125.53,125.56,125.59,125.62,125.64,125.67,125.69,125.71,125.72,125.74,125.75,125.76,125.77,125.77,125.78,125.78,125.77,125.77,125.76,125.75,125.74,125.72,125.7,125.68,125.65,125.62,125.59,125.55,125.52,125.47,125.43,125.38,125.32,125.26,125.2,125.14,125.07,124.99,124.91,124.83,124.74,124.65,124.55,124.45,124.35,124.23,124.12,124.0,123.87,123.74,123.6,123.45,123.3,123.15,122.99,122.82,122.65,122.46,122.28,122.08,121.88,121.67,121.46,121.23,121.0,120.76,120.52,120.26,120.0,119.72,119.44,119.15,118.85,118.54,118.22,117.89,117.55,117.19,116.83,116.45,116.06,115.66,115.25,114.82,114.38,113.93,113.46,112.98,112.48,111.96,111.43,110.88,110.31,109.73,109.12,108.49,107.85,107.18,106.49,105.77,105.03,104.27,103.48,102.66,101.81,100.94,100.03,99.084,98.107,97.094,96.043,94.951,93.818,92.641,91.418,90.145,88.821,87.442,86.006,84.509,},
{84.714,86.294,87.808,89.259,90.652,91.989,93.273,94.507,95.694,96.836,97.935,98.994,100.01,101.0,101.94,102.86,103.74,104.59,105.42,106.21,106.98,107.72,108.44,109.13,109.8,110.45,111.08,111.69,112.28,112.85,113.4,113.94,114.45,114.95,115.44,115.91,116.37,116.81,117.24,117.65,118.05,118.44,118.82,119.19,119.54,119.89,120.22,120.54,120.86,121.16,121.45,121.74,122.01,122.28,122.53,122.78,123.03,123.26,123.48,123.7,123.91,124.12,124.31,124.5,124.69,124.86,125.04,125.2,125.36,125.51,125.66,125.8,125.93,126.06,126.19,126.31,126.42,126.53,126.64,126.74,126.83,126.92,127.01,127.09,127.17,127.24,127.31,127.38,127.44,127.5,127.55,127.6,127.65,127.69,127.73,127.77,127.8,127.83,127.86,127.88,127.9,127.92,127.93,127.95,127.95,127.96,127.96,127.97,127.96,127.96,127.95,127.95,127.93,127.92,127.91,127.89,127.87,127.85,127.82,127.8,127.77,127.74,127.71,127.68,127.65,127.61,127.58,127.54,127.5,127.46,127.42,127.38,127.33,127.29,127.24,127.2,127.15,127.1,127.06,127.01,126.96,126.91,126.86,126.81,126.76,126.71,126.66,126.61,126.56,126.5,126.45,126.4,126.35,126.3,126.25,126.21,126.16,126.11,126.06,126.02,125.97,125.93,125.88,125.84,125.8,125.76,125.72,125.68,125.65,125.61,125.58,125.54,125.51,125.48,125.45,125.43,125.4,125.38,125.36,125.34,125.32,125.3,125.29,125.28,125.27,125.26,125.25,125.25,125.24,125.24,125.24,125.25,125.25,125.26,125.27,125.28,125.29,125.3,125.32,125.34,125.36,125.38,125.4,125.42,125.45,125.48,125.51,125.54,125.57,125.6,125.64,125.68,125.71,125.75,125.79,125.84,125.88,125.92,125.97,126.01,126.06,126.1,126.15,126.2,126.25,126.3,126.35,126.4,126.45,126.5,126.55,126.6,126.65,126.7,126.75,126.8,126.85,126.9,126.95,127.0,127.05,127.1,127.14,127.19,127.24,127.28,127.33,127.37,127.41,127.45,127.49,127.53,127.57,127.61,127.64,127.68,127.71,127.74,127.77,127.8,127.82,127.84,127.87,127.89,127.9,127.92,127.93,127.94,127.95,127.96,127.96,127.97,127.96,127.96,127.96,127.95,127.94,127.92,127.9,127.88,127.86,127.84,127.81,127.77,127.74,127.7,127.66,127.61,127.56,127.51,127.45,127.39,127.32,127.25,127.18,127.1,127.02,126.94,126.85,126.75,126.65,126.55,126.44,126.33,126.21,126.08,125.95,125.82,125.68,125.53,125.38,125.22,125.06,124.89,124.71,124.53,124.34,124.15,123.94,123.73,123.52,123.29,123.06,122.82,122.57,122.32,122.05,121.78,121.49,121.2,120.9,120.59,120.27,119.94,119.59,119.24,118.88,118.5,118.11,117.71,117.3,116.87,116.43,115.98,115.51,115.03,114.53,114.01,113.48,112.93,112.36,111.78,111.17,110.55,109.9,109.23,108.54,107.83,107.09,106.33,105.54,104.72,103.87,102.99,102.08,101.14,100.16,99.148,98.095,97.002,95.866,94.686,93.459,92.183,90.854,89.47,},
{89.753,91.212,92.611,93.953,95.242,96.481,97.671,98.816,99.918,100.98,102.0,102.99,103.93,104.85,105.73,106.59,107.41,108.2,108.97,109.71,110.43,111.12,111.8,112.44,113.07,113.68,114.27,114.84,115.39,115.92,116.44,116.94,117.43,117.9,118.35,118.8,119.22,119.64,120.04,120.43,120.81,121.17,121.53,121.87,122.21,122.53,122.84,123.15,123.44,123.72,124.0,124.27,124.53,124.78,125.02,125.25,125.48,125.7,125.91,126.12,126.31,126.51,126.69,126.87,127.04,127.21,127.37,127.52,127.67,127.81,127.95,128.08,128.21,128.33,128.45,128.56,128.67,128.77,128.87,128.96,129.05,129.14,129.22,129.29,129.37,129.44,129.5,129.56,129.62,129.67,129.72,129.77,129.81,129.85,129.89,129.92,129.95,129.98,130.0,130.02,130.04,130.05,130.07,130.07,130.08,130.09,130.09,130.09,130.08,130.08,130.07,130.06,130.05,130.04,130.02,130.0,129.98,129.96,129.94,129.91,129.88,129.85,129.82,129.79,129.76,129.72,129.69,129.65,129.61,129.57,129.53,129.49,129.45,129.4,129.36,129.32,129.27,129.22,129.18,129.13,129.08,129.03,128.98,128.93,128.88,128.83,128.78,128.73,128.68,128.63,128.58,128.54,128.49,128.44,128.39,128.34,128.3,128.25,128.2,128.16,128.11,128.07,128.03,127.99,127.95,127.91,127.87,127.83,127.79,127.76,127.73,127.7,127.66,127.64,127.61,127.58,127.56,127.54,127.51,127.5,127.48,127.46,127.45,127.44,127.43,127.42,127.41,127.41,127.4,127.4,127.4,127.41,127.41,127.42,127.42,127.43,127.45,127.46,127.48,127.49,127.51,127.53,127.55,127.58,127.6,127.63,127.66,127.69,127.72,127.76,127.79,127.83,127.86,127.9,127.94,127.98,128.02,128.06,128.11,128.15,128.2,128.24,128.29,128.34,128.38,128.43,128.48,128.53,128.58,128.63,128.68,128.73,128.78,128.83,128.88,128.92,128.97,129.02,129.07,129.12,129.17,129.22,129.26,129.31,129.35,129.4,129.44,129.48,129.53,129.57,129.61,129.65,129.68,129.72,129.75,129.79,129.82,129.85,129.88,129.91,129.93,129.96,129.98,130.0,130.02,130.03,130.05,130.06,130.07,130.08,130.08,130.09,130.09,130.09,130.08,130.08,130.07,130.06,130.04,130.02,130.0,129.98,129.95,129.92,129.89,129.86,129.82,129.77,129.73,129.68,129.63,129.57,129.51,129.45,129.38,129.31,129.23,129.15,129.07,128.98,128.88,128.79,128.69,128.58,128.47,128.35,128.23,128.1,127.97,127.84,127.69,127.55,127.39,127.23,127.07,126.9,126.72,126.53,126.34,126.15,125.94,125.73,125.51,125.29,125.05,124.81,124.56,124.31,124.04,123.77,123.48,123.19,122.89,122.58,122.25,121.92,121.58,121.23,120.86,120.49,120.1,119.7,119.29,118.86,118.42,117.97,117.5,117.01,116.52,116.0,115.47,114.92,114.35,113.77,113.16,112.54,111.89,111.23,110.54,109.82,109.08,108.32,107.53,106.71,105.86,104.98,104.07,103.13,102.15,101.13,100.08,98.983,97.844,96.661,95.429,94.148,},
{94.499,95.848,97.143,98.387,99.582,100.73,101.84,102.9,103.92,104.91,105.86,106.78,107.66,108.51,109.34,110.13,110.9,111.64,112.36,113.05,113.73,114.37,115.0,115.61,116.2,116.77,117.32,117.85,118.37,118.87,119.35,119.82,120.28,120.72,121.15,121.56,121.97,122.36,122.73,123.1,123.45,123.8,124.13,124.46,124.77,125.07,125.37,125.65,125.93,126.2,126.46,126.71,126.95,127.19,127.41,127.63,127.85,128.05,128.25,128.45,128.63,128.81,128.99,129.15,129.32,129.47,129.62,129.77,129.91,130.04,130.17,130.29,130.41,130.53,130.64,130.74,130.84,130.94,131.03,131.12,131.2,131.28,131.36,131.43,131.49,131.56,131.62,131.67,131.73,131.78,131.82,131.86,131.9,131.94,131.97,132.0,132.03,132.05,132.08,132.09,132.11,132.12,132.13,132.14,132.15,132.15,132.15,132.15,132.14,132.14,132.13,132.12,132.1,132.09,132.07,132.05,132.03,132.01,131.99,131.96,131.93,131.9,131.87,131.84,131.81,131.77,131.74,131.7,131.66,131.63,131.58,131.54,131.5,131.46,131.41,131.37,131.33,131.28,131.23,131.19,131.14,131.09,131.04,131.0,130.95,130.9,130.85,130.8,130.75,130.7,130.66,130.61,130.56,130.51,130.46,130.42,130.37,130.33,130.28,130.24,130.19,130.15,130.11,130.07,130.03,129.99,129.95,129.92,129.88,129.85,129.82,129.79,129.76,129.73,129.7,129.68,129.65,129.63,129.61,129.59,129.57,129.56,129.55,129.53,129.52,129.52,129.51,129.5,129.5,129.5,129.5,129.5,129.51,129.51,129.52,129.53,129.54,129.56,129.57,129.59,129.61,129.63,129.65,129.67,129.7,129.72,129.75,129.78,129.81,129.84,129.88,129.91,129.95,129.99,130.02,130.06,130.1,130.15,130.19,130.23,130.28,130.32,130.37,130.41,130.46,130.5,130.55,130.6,130.65,130.7,130.74,130.79,130.84,130.89,130.94,130.99,131.04,131.08,131.13,131.18,131.23,131.27,131.32,131.36,131.41,131.45,131.5,131.54,131.58,131.62,131.66,131.7,131.73,131.77,131.8,131.84,131.87,131.9,131.93,131.96,131.98,132.01,132.03,132.05,132.07,132.09,132.1,132.11,132.13,132.13,132.14,132.15,132.15,132.15,132.15,132.14,132.13,132.12,132.11,132.1,132.08,132.06,132.03,132.01,131.98,131.95,131.91,131.87,131.83,131.78,131.73,131.68,131.63,131.57,131.5,131.44,131.37,131.29,131.21,131.13,131.04,130.95,130.86,130.76,130.65,130.54,130.43,130.31,130.19,130.06,129.93,129.79,129.64,129.49,129.34,129.18,129.01,128.84,128.66,128.47,128.28,128.08,127.88,127.67,127.45,127.22,126.99,126.74,126.49,126.24,125.97,125.69,125.41,125.12,124.81,124.5,124.18,123.85,123.51,123.15,122.79,122.41,122.02,121.62,121.21,120.79,120.35,119.89,119.42,118.94,118.44,117.93,117.4,116.85,116.28,115.7,115.09,114.47,113.82,113.16,112.47,111.75,111.01,110.25,109.46,108.64,107.79,106.91,106.0,105.05,104.07,103.05,102.0,100.9,99.755,98.567,},
{98.979,100.23,101.43,102.58,103.69,104.76,105.78,106.77,107.73,108.64,109.53,110.38,111.21,112.0,112.77,113.52,114.23,114.93,115.6,116.25,116.87,117.48,118.07,118.64,119.19,119.72,120.24,120.74,121.22,121.69,122.15,122.59,123.02,123.43,123.83,124.22,124.6,124.97,125.32,125.67,126.0,126.32,126.64,126.94,127.24,127.52,127.8,128.07,128.33,128.58,128.82,129.06,129.29,129.51,129.72,129.93,130.13,130.33,130.51,130.7,130.87,131.04,131.2,131.36,131.51,131.66,131.8,131.94,132.07,132.2,132.32,132.43,132.55,132.65,132.76,132.85,132.95,133.04,133.12,133.2,133.28,133.36,133.43,133.49,133.56,133.61,133.67,133.72,133.77,133.82,133.86,133.9,133.93,133.97,134.0,134.02,134.05,134.07,134.09,134.1,134.12,134.13,134.14,134.14,134.15,134.15,134.15,134.14,134.14,134.13,134.12,134.11,134.1,134.08,134.06,134.04,134.02,134.0,133.98,133.95,133.92,133.89,133.86,133.83,133.8,133.77,133.73,133.69,133.66,133.62,133.58,133.54,133.5,133.45,133.41,133.37,133.32,133.28,133.23,133.19,133.14,133.09,133.05,133.0,132.95,132.9,132.86,132.81,132.76,132.71,132.67,132.62,132.57,132.53,132.48,132.44,132.39,132.35,132.3,132.26,132.22,132.18,132.14,132.1,132.06,132.02,131.98,131.95,131.91,131.88,131.85,131.82,131.79,131.76,131.74,131.71,131.69,131.67,131.65,131.63,131.61,131.6,131.58,131.57,131.56,131.56,131.55,131.54,131.54,131.54,131.54,131.54,131.55,131.55,131.56,131.57,131.58,131.6,131.61,131.63,131.65,131.66,131.69,131.71,131.73,131.76,131.79,131.82,131.85,131.88,131.91,131.94,131.98,132.02,132.05,132.09,132.13,132.17,132.21,132.25,132.3,132.34,132.38,132.43,132.47,132.52,132.57,132.61,132.66,132.71,132.76,132.8,132.85,132.9,132.95,132.99,133.04,133.09,133.13,133.18,133.23,133.27,133.32,133.36,133.4,133.45,133.49,133.53,133.57,133.61,133.65,133.69,133.73,133.76,133.8,133.83,133.86,133.89,133.92,133.95,133.97,134.0,134.02,134.04,134.06,134.08,134.09,134.11,134.12,134.13,134.14,134.14,134.15,134.15,134.15,134.14,134.14,134.13,134.12,134.11,134.09,134.07,134.05,134.03,134.0,133.97,133.94,133.9,133.86,133.82,133.78,133.73,133.68,133.62,133.56,133.5,133.44,133.37,133.29,133.22,133.14,133.05,132.96,132.87,132.77,132.67,132.56,132.45,132.33,132.21,132.09,131.96,131.82,131.68,131.54,131.39,131.23,131.07,130.9,130.72,130.54,130.36,130.16,129.96,129.76,129.54,129.32,129.09,128.86,128.62,128.37,128.11,127.84,127.56,127.28,126.99,126.68,126.37,126.05,125.72,125.37,125.02,124.66,124.28,123.89,123.49,123.08,122.65,122.22,121.76,121.29,120.81,120.31,119.8,119.27,118.72,118.15,117.57,116.97,116.34,115.7,115.03,114.34,113.62,112.89,112.12,111.33,110.51,109.66,108.78,107.86,106.92,105.93,104.91,103.85,102.75,},
{103.21,104.37,105.49,106.56,107.59,108.58,109.53,110.45,111.34,112.2,113.02,113.82,114.59,115.33,116.05,116.74,117.42,118.06,118.69,119.3,119.89,120.46,121.01,121.54,122.06,122.56,123.04,123.51,123.96,124.41,124.83,125.25,125.65,126.04,126.42,126.78,127.14,127.48,127.82,128.14,128.45,128.76,129.05,129.34,129.62,129.88,130.15,130.4,130.64,130.88,131.11,131.33,131.55,131.76,131.96,132.15,132.34,132.52,132.7,132.87,133.04,133.2,133.35,133.5,133.64,133.78,133.91,134.04,134.16,134.28,134.39,134.5,134.61,134.71,134.81,134.9,134.99,135.07,135.15,135.23,135.3,135.37,135.43,135.49,135.55,135.61,135.66,135.71,135.75,135.8,135.83,135.87,135.9,135.93,135.96,135.99,136.01,136.03,136.04,136.06,136.07,136.08,136.08,136.09,136.09,136.09,136.09,136.08,136.08,136.07,136.06,136.05,136.03,136.02,136.0,135.98,135.96,135.93,135.91,135.88,135.86,135.83,135.8,135.77,135.73,135.7,135.67,135.63,135.59,135.56,135.52,135.48,135.44,135.39,135.35,135.31,135.27,135.22,135.18,135.13,135.09,135.04,135.0,134.95,134.9,134.86,134.81,134.76,134.72,134.67,134.62,134.58,134.53,134.49,134.44,134.4,134.35,134.31,134.27,134.23,134.19,134.15,134.11,134.07,134.03,133.99,133.96,133.92,133.89,133.86,133.83,133.8,133.77,133.74,133.72,133.69,133.67,133.65,133.63,133.61,133.6,133.58,133.57,133.56,133.55,133.54,133.53,133.53,133.53,133.53,133.53,133.53,133.53,133.54,133.55,133.56,133.57,133.58,133.59,133.61,133.63,133.65,133.67,133.69,133.71,133.74,133.77,133.79,133.82,133.85,133.89,133.92,133.95,133.99,134.02,134.06,134.1,134.14,134.18,134.22,134.26,134.31,134.35,134.39,134.44,134.48,134.53,134.57,134.62,134.66,134.71,134.76,134.8,134.85,134.9,134.94,134.99,135.03,135.08,135.13,135.17,135.22,135.26,135.3,135.35,135.39,135.43,135.47,135.51,135.55,135.59,135.62,135.66,135.7,135.73,135.76,135.79,135.82,135.85,135.88,135.91,135.93,135.95,135.98,136.0,136.01,136.03,136.04,136.06,136.07,136.08,136.08,136.09,136.09,136.09,136.09,136.08,136.08,136.07,136.06,136.04,136.03,136.01,135.99,135.96,135.94,135.91,135.88,135.84,135.8,135.76,135.72,135.67,135.62,135.56,135.5,135.44,135.38,135.31,135.24,135.16,135.08,135.0,134.91,134.82,134.72,134.62,134.52,134.41,134.3,134.18,134.06,133.93,133.8,133.66,133.52,133.37,133.22,133.06,132.9,132.73,132.55,132.37,132.18,131.99,131.79,131.58,131.36,131.14,130.91,130.68,130.43,130.18,129.92,129.66,129.38,129.1,128.8,128.5,128.19,127.86,127.53,127.19,126.84,126.47,126.1,125.71,125.31,124.9,124.47,124.03,123.58,123.11,122.63,122.13,121.62,121.09,120.54,119.97,119.39,118.78,118.16,117.51,116.85,116.16,115.44,114.7,113.94,113.14,112.32,111.47,110.59,109.67,108.72,107.74,106.71,},
{107.22,108.3,109.33,110.33,111.29,112.21,113.1,113.96,114.78,115.58,116.35,117.1,117.82,118.51,119.18,119.83,120.46,121.07,121.65,122.22,122.77,123.3,123.82,124.32,124.81,125.27,125.73,126.17,126.6,127.01,127.41,127.8,128.18,128.55,128.9,129.25,129.58,129.9,130.22,130.52,130.82,131.1,131.38,131.65,131.91,132.16,132.41,132.65,132.88,133.1,133.32,133.53,133.73,133.92,134.11,134.3,134.48,134.65,134.81,134.98,135.13,135.28,135.42,135.56,135.7,135.83,135.95,136.07,136.19,136.3,136.41,136.51,136.61,136.7,136.79,136.88,136.96,137.04,137.12,137.19,137.25,137.32,137.38,137.44,137.49,137.54,137.59,137.63,137.68,137.72,137.75,137.78,137.81,137.84,137.87,137.89,137.91,137.93,137.94,137.95,137.96,137.97,137.97,137.98,137.98,137.98,137.97,137.97,137.96,137.95,137.94,137.93,137.91,137.9,137.88,137.86,137.84,137.81,137.79,137.76,137.74,137.71,137.68,137.65,137.62,137.58,137.55,137.51,137.48,137.44,137.4,137.36,137.32,137.28,137.24,137.2,137.15,137.11,137.07,137.02,136.98,136.94,136.89,136.85,136.8,136.75,136.71,136.66,136.62,136.57,136.53,136.48,136.44,136.4,136.35,136.31,136.27,136.22,136.18,136.14,136.1,136.06,136.02,135.99,135.95,135.91,135.88,135.84,135.81,135.78,135.75,135.72,135.69,135.67,135.64,135.62,135.6,135.58,135.56,135.54,135.53,135.51,135.5,135.49,135.48,135.47,135.46,135.46,135.46,135.46,135.46,135.46,135.46,135.47,135.48,135.49,135.5,135.51,135.52,135.54,135.56,135.58,135.6,135.62,135.64,135.66,135.69,135.72,135.75,135.78,135.81,135.84,135.87,135.91,135.94,135.98,136.02,136.06,136.09,136.13,136.18,136.22,136.26,136.3,136.34,136.39,136.43,136.48,136.52,136.57,136.61,136.66,136.7,136.75,136.79,136.84,136.88,136.93,136.97,137.02,137.06,137.11,137.15,137.19,137.23,137.27,137.32,137.36,137.39,137.43,137.47,137.51,137.54,137.58,137.61,137.64,137.67,137.7,137.73,137.76,137.79,137.81,137.83,137.86,137.88,137.89,137.91,137.93,137.94,137.95,137.96,137.97,137.97,137.98,137.98,137.98,137.98,137.97,137.96,137.95,137.94,137.93,137.91,137.89,137.87,137.85,137.82,137.79,137.76,137.72,137.68,137.64,137.6,137.55,137.5,137.45,137.39,137.33,137.26,137.2,137.13,137.05,136.97,136.89,136.81,136.72,136.62,136.52,136.42,136.32,136.21,136.09,135.97,135.85,135.72,135.58,135.45,135.3,135.15,135.0,134.84,134.67,134.5,134.33,134.14,133.95,133.76,133.56,133.35,133.13,132.91,132.68,132.44,132.2,131.95,131.69,131.42,131.14,130.86,130.57,130.26,129.95,129.63,129.3,128.95,128.6,128.23,127.86,127.47,127.07,126.66,126.23,125.8,125.34,124.88,124.39,123.9,123.38,122.85,122.3,121.74,121.15,120.55,119.92,119.28,118.61,117.92,117.21,116.47,115.7,114.9,114.08,113.23,112.34,111.43,110.47,},
{111.03,112.03,112.99,113.91,114.81,115.67,116.5,117.29,118.07,118.81,119.53,120.23,120.9,121.55,122.17,122.78,123.37,123.94,124.49,125.02,125.54,126.04,126.52,126.99,127.44,127.89,128.31,128.73,129.13,129.52,129.89,130.26,130.62,130.96,131.29,131.62,131.93,132.24,132.53,132.82,133.1,133.37,133.63,133.88,134.13,134.36,134.59,134.82,135.04,135.25,135.45,135.65,135.84,136.02,136.2,136.37,136.54,136.7,136.86,137.01,137.16,137.3,137.43,137.57,137.69,137.81,137.93,138.04,138.15,138.26,138.36,138.45,138.55,138.63,138.72,138.8,138.88,138.95,139.02,139.09,139.15,139.21,139.27,139.32,139.37,139.42,139.46,139.51,139.54,139.58,139.61,139.64,139.67,139.7,139.72,139.74,139.76,139.77,139.78,139.79,139.8,139.81,139.81,139.81,139.81,139.81,139.81,139.8,139.79,139.78,139.77,139.76,139.74,139.73,139.71,139.69,139.67,139.64,139.62,139.59,139.57,139.54,139.51,139.48,139.45,139.41,139.38,139.34,139.31,139.27,139.23,139.19,139.16,139.12,139.08,139.03,138.99,138.95,138.91,138.86,138.82,138.78,138.73,138.69,138.65,138.6,138.56,138.51,138.47,138.43,138.38,138.34,138.29,138.25,138.21,138.17,138.13,138.08,138.04,138.0,137.96,137.93,137.89,137.85,137.82,137.78,137.75,137.72,137.68,137.65,137.62,137.6,137.57,137.54,137.52,137.5,137.48,137.46,137.44,137.42,137.4,137.39,137.38,137.37,137.36,137.35,137.35,137.34,137.34,137.34,137.34,137.34,137.34,137.35,137.36,137.37,137.38,137.39,137.4,137.42,137.43,137.45,137.47,137.49,137.52,137.54,137.57,137.59,137.62,137.65,137.68,137.71,137.74,137.78,137.81,137.85,137.88,137.92,137.96,138.0,138.04,138.08,138.12,138.16,138.2,138.25,138.29,138.33,138.37,138.42,138.46,138.51,138.55,138.6,138.64,138.68,138.73,138.77,138.82,138.86,138.9,138.94,138.99,139.03,139.07,139.11,139.15,139.19,139.23,139.27,139.3,139.34,139.37,139.41,139.44,139.47,139.5,139.53,139.56,139.59,139.61,139.64,139.66,139.68,139.7,139.72,139.74,139.75,139.77,139.78,139.79,139.8,139.81,139.81,139.81,139.81,139.81,139.81,139.8,139.8,139.78,139.77,139.76,139.74,139.72,139.7,139.67,139.65,139.62,139.58,139.55,139.51,139.47,139.43,139.38,139.33,139.28,139.22,139.16,139.1,139.03,138.96,138.89,138.81,138.73,138.65,138.56,138.47,138.37,138.27,138.17,138.06,137.95,137.83,137.71,137.58,137.45,137.32,137.18,137.03,136.88,136.73,136.57,136.4,136.23,136.05,135.87,135.68,135.48,135.28,135.07,134.85,134.63,134.4,134.16,133.92,133.66,133.4,133.14,132.86,132.57,132.28,131.98,131.66,131.34,131.01,130.67,130.31,129.95,129.57,129.19,128.79,128.37,127.95,127.51,127.06,126.59,126.11,125.61,125.1,124.57,124.02,123.46,122.87,122.27,121.64,121.0,120.33,119.64,118.92,118.18,117.41,116.62,115.79,114.94,114.05,},
{114.64,115.57,116.46,117.33,118.16,118.96,119.73,120.48,121.2,121.9,122.57,123.22,123.85,124.45,125.04,125.61,126.16,126.69,127.21,127.71,128.19,128.66,129.11,129.56,129.98,130.4,130.8,131.19,131.56,131.93,132.28,132.63,132.96,133.28,133.6,133.9,134.2,134.49,134.76,135.03,135.3,135.55,135.8,136.03,136.27,136.49,136.71,136.92,137.12,137.32,137.51,137.7,137.88,138.05,138.22,138.38,138.54,138.69,138.84,138.98,139.12,139.25,139.38,139.5,139.62,139.74,139.85,139.95,140.06,140.15,140.25,140.34,140.43,140.51,140.59,140.66,140.74,140.81,140.87,140.93,140.99,141.05,141.1,141.15,141.2,141.24,141.28,141.32,141.36,141.39,141.42,141.45,141.47,141.5,141.52,141.53,141.55,141.56,141.57,141.58,141.59,141.59,141.6,141.6,141.6,141.59,141.59,141.58,141.57,141.56,141.55,141.54,141.52,141.5,141.48,141.46,141.44,141.42,141.4,141.37,141.34,141.32,141.29,141.26,141.23,141.19,141.16,141.13,141.09,141.05,141.02,140.98,140.94,140.9,140.86,140.82,140.78,140.74,140.7,140.66,140.61,140.57,140.53,140.49,140.44,140.4,140.36,140.31,140.27,140.23,140.19,140.14,140.1,140.06,140.02,139.98,139.94,139.9,139.86,139.82,139.78,139.74,139.71,139.67,139.64,139.6,139.57,139.54,139.51,139.48,139.45,139.42,139.39,139.37,139.35,139.32,139.3,139.28,139.27,139.25,139.23,139.22,139.21,139.2,139.19,139.18,139.18,139.17,139.17,139.17,139.17,139.17,139.18,139.18,139.19,139.2,139.21,139.22,139.23,139.25,139.26,139.28,139.3,139.32,139.34,139.37,139.39,139.42,139.44,139.47,139.5,139.53,139.56,139.6,139.63,139.67,139.7,139.74,139.77,139.81,139.85,139.89,139.93,139.97,140.01,140.05,140.09,140.14,140.18,140.22,140.26,140.31,140.35,140.39,140.44,140.48,140.52,140.57,140.61,140.65,140.69,140.73,140.78,140.82,140.86,140.9,140.94,140.97,141.01,141.05,141.08,141.12,141.15,141.19,141.22,141.25,141.28,141.31,141.34,141.37,141.39,141.42,141.44,141.46,141.48,141.5,141.52,141.53,141.55,141.56,141.57,141.58,141.59,141.59,141.6,141.6,141.6,141.6,141.59,141.58,141.58,141.57,141.55,141.54,141.52,141.5,141.48,141.45,141.42,141.39,141.36,141.33,141.29,141.25,141.2,141.16,141.11,141.06,141.0,140.94,140.88,140.82,140.75,140.67,140.6,140.52,140.44,140.35,140.26,140.17,140.07,139.97,139.86,139.75,139.64,139.52,139.4,139.27,139.14,139.0,138.86,138.71,138.56,138.41,138.24,138.08,137.9,137.72,137.54,137.35,137.15,136.95,136.74,136.52,136.3,136.07,135.83,135.59,135.33,135.07,134.8,134.53,134.24,133.95,133.64,133.33,133.01,132.68,132.33,131.98,131.62,131.24,130.86,130.46,130.04,129.62,129.18,128.73,128.26,127.78,127.28,126.77,126.24,125.69,125.13,124.54,123.94,123.31,122.67,122.0,121.3,120.59,119.85,119.08,118.28,117.45,},
{118.08,118.94,119.77,120.58,121.35,122.1,122.82,123.52,124.19,124.84,125.47,126.08,126.67,127.24,127.79,128.32,128.84,129.33,129.82,130.29,130.74,131.18,131.61,132.02,132.42,132.81,133.19,133.55,133.91,134.25,134.58,134.91,135.22,135.53,135.82,136.11,136.39,136.66,136.92,137.17,137.42,137.66,137.89,138.11,138.33,138.54,138.75,138.95,139.14,139.33,139.51,139.68,139.85,140.02,140.17,140.33,140.48,140.62,140.76,140.89,141.02,141.15,141.27,141.38,141.5,141.6,141.71,141.81,141.9,142.0,142.08,142.17,142.25,142.33,142.4,142.47,142.54,142.61,142.67,142.72,142.78,142.83,142.88,142.93,142.97,143.01,143.05,143.09,143.12,143.15,143.18,143.2,143.23,143.25,143.26,143.28,143.29,143.31,143.32,143.32,143.33,143.33,143.33,143.33,143.33,143.33,143.32,143.31,143.3,143.29,143.28,143.27,143.25,143.23,143.21,143.19,143.17,143.15,143.13,143.1,143.07,143.05,143.02,142.99,142.96,142.93,142.89,142.86,142.82,142.79,142.75,142.72,142.68,142.64,142.6,142.56,142.52,142.48,142.44,142.4,142.36,142.32,142.28,142.24,142.19,142.15,142.11,142.07,142.03,141.98,141.94,141.9,141.86,141.82,141.78,141.74,141.7,141.66,141.62,141.58,141.55,141.51,141.48,141.44,141.41,141.37,141.34,141.31,141.28,141.25,141.23,141.2,141.17,141.15,141.13,141.1,141.08,141.07,141.05,141.03,141.02,141.0,140.99,140.98,140.97,140.97,140.96,140.96,140.95,140.95,140.95,140.96,140.96,140.97,140.97,140.98,140.99,141.0,141.02,141.03,141.05,141.06,141.08,141.1,141.12,141.15,141.17,141.19,141.22,141.25,141.28,141.31,141.34,141.37,141.4,141.44,141.47,141.51,141.54,141.58,141.62,141.66,141.69,141.73,141.77,141.81,141.85,141.9,141.94,141.98,142.02,142.06,142.1,142.15,142.19,142.23,142.27,142.31,142.35,142.4,142.44,142.48,142.52,142.56,142.6,142.64,142.67,142.71,142.75,142.78,142.82,142.85,142.89,142.92,142.95,142.98,143.01,143.04,143.07,143.1,143.12,143.15,143.17,143.19,143.21,143.23,143.25,143.26,143.28,143.29,143.3,143.31,143.32,143.33,143.33,143.33,143.33,143.33,143.33,143.32,143.32,143.31,143.3,143.28,143.27,143.25,143.23,143.21,143.18,143.15,143.12,143.09,143.06,143.02,142.98,142.93,142.89,142.84,142.79,142.73,142.68,142.61,142.55,142.48,142.41,142.34,142.26,142.18,142.1,142.01,141.92,141.82,141.72,141.62,141.51,141.4,141.28,141.16,141.04,140.91,140.78,140.64,140.5,140.35,140.2,140.04,139.88,139.71,139.53,139.35,139.17,138.98,138.78,138.58,138.36,138.15,137.92,137.69,137.46,137.21,136.96,136.7,136.43,136.15,135.87,135.57,135.27,134.96,134.63,134.3,133.96,133.61,133.24,132.87,132.48,132.08,131.67,131.25,130.81,130.36,129.89,129.41,128.91,128.4,127.87,127.32,126.75,126.17,125.56,124.94,124.29,123.62,122.93,122.21,121.47,120.7,},
{121.35,122.15,122.93,123.68,124.4,125.1,125.78,126.43,127.06,127.67,128.25,128.82,129.37,129.91,130.42,130.92,131.4,131.87,132.33,132.77,133.19,133.6,134.01,134.39,134.77,135.14,135.49,135.83,136.17,136.49,136.8,137.11,137.4,137.69,137.97,138.24,138.5,138.75,139.0,139.24,139.47,139.7,139.92,140.13,140.33,140.53,140.72,140.91,141.09,141.27,141.44,141.6,141.76,141.92,142.07,142.21,142.35,142.49,142.62,142.74,142.87,142.98,143.1,143.21,143.31,143.41,143.51,143.6,143.69,143.78,143.86,143.94,144.02,144.09,144.16,144.23,144.29,144.35,144.41,144.47,144.52,144.57,144.61,144.66,144.7,144.73,144.77,144.8,144.83,144.86,144.89,144.91,144.93,144.95,144.97,144.98,144.99,145.0,145.01,145.02,145.02,145.02,145.02,145.02,145.02,145.01,145.01,145.0,144.99,144.98,144.97,144.95,144.93,144.92,144.9,144.88,144.86,144.83,144.81,144.79,144.76,144.73,144.7,144.68,144.64,144.61,144.58,144.55,144.51,144.48,144.44,144.41,144.37,144.33,144.3,144.26,144.22,144.18,144.14,144.1,144.06,144.02,143.98,143.94,143.9,143.86,143.82,143.78,143.74,143.69,143.65,143.61,143.57,143.53,143.5,143.46,143.42,143.38,143.34,143.31,143.27,143.24,143.2,143.17,143.13,143.1,143.07,143.04,143.01,142.98,142.96,142.93,142.91,142.88,142.86,142.84,142.82,142.8,142.79,142.77,142.76,142.74,142.73,142.72,142.71,142.71,142.7,142.7,142.69,142.69,142.69,142.7,142.7,142.71,142.71,142.72,142.73,142.74,142.75,142.77,142.78,142.8,142.82,142.84,142.86,142.88,142.9,142.93,142.95,142.98,143.01,143.04,143.07,143.1,143.13,143.16,143.2,143.23,143.27,143.3,143.34,143.38,143.41,143.45,143.49,143.53,143.57,143.61,143.65,143.69,143.73,143.77,143.81,143.85,143.89,143.93,143.97,144.02,144.06,144.1,144.14,144.18,144.21,144.25,144.29,144.33,144.37,144.4,144.44,144.47,144.51,144.54,144.58,144.61,144.64,144.67,144.7,144.73,144.76,144.78,144.81,144.83,144.85,144.88,144.9,144.91,144.93,144.95,144.96,144.98,144.99,145.0,145.01,145.01,145.02,145.02,145.02,145.02,145.02,145.02,145.01,145.0,144.99,144.98,144.97,144.95,144.93,144.91,144.89,144.86,144.84,144.81,144.77,144.74,144.7,144.66,144.62,144.57,144.52,144.47,144.42,144.36,144.3,144.24,144.17,144.1,144.03,143.96,143.88,143.79,143.71,143.62,143.52,143.43,143.33,143.22,143.11,143.0,142.88,142.76,142.64,142.51,142.37,142.23,142.09,141.94,141.79,141.63,141.46,141.29,141.12,140.94,140.75,140.56,140.36,140.16,139.95,139.73,139.51,139.28,139.04,138.79,138.54,138.28,138.01,137.73,137.45,137.15,136.85,136.54,136.22,135.88,135.54,135.19,134.83,134.45,134.06,133.67,133.25,132.83,132.39,131.94,131.47,130.99,130.5,129.98,129.45,128.91,128.34,127.75,127.15,126.52,125.87,125.2,124.51,123.79,},
{124.47,125.22,125.95,126.64,127.32,127.97,128.6,129.21,129.8,130.37,130.92,131.45,131.97,132.47,132.95,133.42,133.87,134.31,134.74,135.15,135.55,135.94,136.31,136.68,137.03,137.38,137.71,138.03,138.35,138.65,138.95,139.23,139.51,139.78,140.04,140.3,140.54,140.78,141.01,141.24,141.46,141.67,141.88,142.07,142.27,142.46,142.64,142.81,142.98,143.15,143.31,143.47,143.62,143.76,143.9,144.04,144.17,144.3,144.42,144.54,144.65,144.77,144.87,144.97,145.07,145.17,145.26,145.35,145.43,145.52,145.59,145.67,145.74,145.81,145.87,145.94,146.0,146.05,146.11,146.16,146.21,146.25,146.29,146.33,146.37,146.41,146.44,146.47,146.5,146.52,146.55,146.57,146.59,146.6,146.62,146.63,146.64,146.65,146.66,146.66,146.67,146.67,146.67,146.67,146.66,146.66,146.65,146.64,146.63,146.62,146.61,146.59,146.58,146.56,146.54,146.52,146.5,146.48,146.45,146.43,146.4,146.37,146.35,146.32,146.29,146.26,146.23,146.19,146.16,146.13,146.09,146.06,146.02,145.99,145.95,145.91,145.87,145.84,145.8,145.76,145.72,145.68,145.64,145.6,145.56,145.52,145.48,145.44,145.4,145.36,145.32,145.28,145.25,145.21,145.17,145.13,145.09,145.06,145.02,144.99,144.95,144.92,144.88,144.85,144.82,144.79,144.76,144.73,144.7,144.67,144.65,144.62,144.6,144.57,144.55,144.53,144.51,144.5,144.48,144.46,144.45,144.44,144.43,144.42,144.41,144.4,144.4,144.39,144.39,144.39,144.39,144.39,144.4,144.4,144.41,144.42,144.42,144.44,144.45,144.46,144.48,144.49,144.51,144.53,144.55,144.57,144.59,144.62,144.64,144.67,144.7,144.72,144.75,144.78,144.81,144.85,144.88,144.91,144.95,144.98,145.02,145.05,145.09,145.13,145.16,145.2,145.24,145.28,145.32,145.36,145.4,145.44,145.48,145.52,145.56,145.59,145.63,145.67,145.71,145.75,145.79,145.83,145.87,145.91,145.94,145.98,146.02,146.05,146.09,146.12,146.16,146.19,146.22,146.25,146.28,146.31,146.34,146.37,146.4,146.42,146.45,146.47,146.49,146.52,146.54,146.55,146.57,146.59,146.6,146.62,146.63,146.64,146.65,146.66,146.66,146.67,146.67,146.67,146.67,146.66,146.66,146.65,146.64,146.63,146.62,146.61,146.59,146.57,146.55,146.53,146.5,146.47,146.44,146.41,146.38,146.34,146.3,146.26,146.21,146.16,146.11,146.06,146.0,145.95,145.88,145.82,145.75,145.68,145.61,145.53,145.45,145.36,145.27,145.18,145.09,144.99,144.89,144.78,144.67,144.56,144.44,144.32,144.19,144.06,143.92,143.78,143.64,143.49,143.33,143.17,143.01,142.84,142.66,142.48,142.3,142.1,141.91,141.7,141.49,141.27,141.05,140.82,140.58,140.33,140.08,139.82,139.55,139.27,138.99,138.69,138.39,138.08,137.76,137.43,137.08,136.73,136.37,135.99,135.61,135.21,134.8,134.37,133.94,133.49,133.02,132.54,132.04,131.53,131.0,130.45,129.89,129.3,128.69,128.07,127.42,126.75,},
{127.45,128.15,128.83,129.48,130.11,130.72,131.31,131.88,132.43,132.96,133.48,133.98,134.46,134.93,135.38,135.82,136.24,136.66,137.06,137.44,137.82,138.18,138.54,138.88,139.21,139.54,139.85,140.15,140.45,140.73,141.01,141.28,141.54,141.8,142.04,142.28,142.52,142.74,142.96,143.17,143.38,143.58,143.77,143.96,144.14,144.32,144.49,144.66,144.82,144.97,145.12,145.27,145.41,145.55,145.68,145.81,145.93,146.05,146.17,146.28,146.39,146.49,146.6,146.69,146.79,146.88,146.96,147.04,147.12,147.2,147.27,147.34,147.41,147.48,147.54,147.6,147.65,147.7,147.75,147.8,147.85,147.89,147.93,147.97,148.0,148.03,148.06,148.09,148.12,148.14,148.16,148.18,148.2,148.22,148.23,148.24,148.25,148.26,148.26,148.27,148.27,148.27,148.27,148.27,148.26,148.26,148.25,148.24,148.23,148.22,148.2,148.19,148.17,148.16,148.14,148.12,148.1,148.07,148.05,148.03,148.0,147.97,147.95,147.92,147.89,147.86,147.83,147.8,147.77,147.73,147.7,147.66,147.63,147.59,147.56,147.52,147.49,147.45,147.41,147.37,147.34,147.3,147.26,147.22,147.18,147.14,147.1,147.07,147.03,146.99,146.95,146.91,146.87,146.84,146.8,146.76,146.73,146.69,146.66,146.62,146.59,146.56,146.52,146.49,146.46,146.43,146.4,146.37,146.34,146.32,146.29,146.27,146.25,146.22,146.2,146.18,146.16,146.15,146.13,146.12,146.1,146.09,146.08,146.07,146.06,146.06,146.05,146.05,146.04,146.04,146.04,146.05,146.05,146.05,146.06,146.07,146.08,146.09,146.1,146.11,146.13,146.14,146.16,146.18,146.2,146.22,146.24,146.27,146.29,146.31,146.34,146.37,146.4,146.43,146.46,146.49,146.52,146.55,146.58,146.62,146.65,146.69,146.72,146.76,146.8,146.83,146.87,146.91,146.94,146.98,147.02,147.06,147.1,147.14,147.18,147.21,147.25,147.29,147.33,147.37,147.41,147.44,147.48,147.52,147.55,147.59,147.62,147.66,147.69,147.73,147.76,147.79,147.82,147.86,147.89,147.91,147.94,147.97,148.0,148.02,148.05,148.07,148.09,148.11,148.13,148.15,148.17,148.19,148.2,148.21,148.23,148.24,148.25,148.25,148.26,148.27,148.27,148.27,148.27,148.27,148.26,148.26,148.25,148.24,148.23,148.22,148.2,148.19,148.17,148.15,148.12,148.1,148.07,148.04,148.01,147.97,147.94,147.9,147.85,147.81,147.76,147.71,147.66,147.6,147.55,147.49,147.42,147.35,147.28,147.21,147.14,147.06,146.97,146.89,146.8,146.71,146.61,146.51,146.41,146.3,146.19,146.07,145.95,145.83,145.7,145.57,145.43,145.29,145.15,145.0,144.84,144.68,144.52,144.34,144.17,143.99,143.8,143.61,143.41,143.2,142.99,142.77,142.55,142.32,142.08,141.84,141.58,141.32,141.05,140.78,140.49,140.2,139.9,139.58,139.26,138.93,138.59,138.24,137.87,137.5,137.12,136.72,136.31,135.88,135.45,135.0,134.53,134.05,133.55,133.04,132.51,131.96,131.39,130.81,130.2,129.57,},
{130.3,130.95,131.58,132.19,132.78,133.35,133.9,134.44,134.95,135.45,135.93,136.4,136.85,137.29,137.72,138.13,138.53,138.92,139.29,139.66,140.01,140.35,140.68,141.01,141.32,141.62,141.92,142.2,142.48,142.75,143.01,143.26,143.51,143.75,143.98,144.21,144.43,144.64,144.84,145.04,145.24,145.43,145.61,145.79,145.96,146.12,146.29,146.44,146.59,146.74,146.88,147.02,147.16,147.28,147.41,147.53,147.65,147.76,147.87,147.97,148.08,148.17,148.27,148.36,148.45,148.53,148.61,148.69,148.77,148.84,148.91,148.97,149.04,149.1,149.15,149.21,149.26,149.31,149.36,149.4,149.44,149.48,149.52,149.56,149.59,149.62,149.65,149.67,149.7,149.72,149.74,149.76,149.77,149.79,149.8,149.81,149.82,149.82,149.83,149.83,149.83,149.83,149.83,149.83,149.82,149.81,149.81,149.8,149.79,149.77,149.76,149.75,149.73,149.71,149.69,149.67,149.65,149.63,149.61,149.58,149.56,149.53,149.51,149.48,149.45,149.42,149.39,149.36,149.33,149.3,149.26,149.23,149.2,149.16,149.13,149.09,149.06,149.02,148.98,148.95,148.91,148.87,148.84,148.8,148.76,148.72,148.69,148.65,148.61,148.57,148.54,148.5,148.46,148.43,148.39,148.36,148.32,148.29,148.25,148.22,148.19,148.15,148.12,148.09,148.06,148.03,148.0,147.98,147.95,147.92,147.9,147.88,147.85,147.83,147.81,147.79,147.77,147.76,147.74,147.73,147.71,147.7,147.69,147.68,147.68,147.67,147.66,147.66,147.66,147.66,147.66,147.66,147.66,147.67,147.67,147.68,147.69,147.7,147.71,147.73,147.74,147.76,147.77,147.79,147.81,147.83,147.85,147.87,147.9,147.92,147.95,147.97,148.0,148.03,148.06,148.09,148.12,148.15,148.18,148.21,148.25,148.28,148.32,148.35,148.39,148.42,148.46,148.5,148.53,148.57,148.61,148.64,148.68,148.72,148.76,148.79,148.83,148.87,148.91,148.94,148.98,149.02,149.05,149.09,149.12,149.16,149.19,149.23,149.26,149.29,149.32,149.36,149.39,149.42,149.45,149.48,149.5,149.53,149.56,149.58,149.61,149.63,149.65,149.67,149.69,149.71,149.73,149.74,149.76,149.77,149.78,149.8,149.8,149.81,149.82,149.82,149.83,149.83,149.83,149.83,149.83,149.82,149.82,149.81,149.8,149.79,149.77,149.76,149.74,149.72,149.7,149.68,149.65,149.62,149.59,149.56,149.53,149.49,149.45,149.41,149.36,149.32,149.27,149.22,149.16,149.11,149.05,148.98,148.92,148.85,148.78,148.7,148.63,148.54,148.46,148.37,148.28,148.19,148.09,147.99,147.89,147.78,147.66,147.55,147.43,147.3,147.17,147.04,146.9,146.76,146.62,146.47,146.31,146.15,145.98,145.81,145.64,145.45,145.27,145.07,144.87,144.67,144.46,144.24,144.02,143.78,143.55,143.3,143.05,142.79,142.52,142.24,141.96,141.67,141.36,141.05,140.73,140.4,140.06,139.71,139.35,138.97,138.59,138.19,137.78,137.36,136.92,136.47,136.0,135.52,135.03,134.51,133.98,133.44,132.87,132.28,},
{133.02,133.63,134.22,134.79,135.34,135.88,136.39,136.89,137.37,137.84,138.29,138.73,139.16,139.57,139.97,140.35,140.73,141.09,141.44,141.79,142.12,142.44,142.75,143.06,143.35,143.64,143.91,144.18,144.44,144.7,144.94,145.18,145.41,145.64,145.86,146.07,146.27,146.47,146.67,146.86,147.04,147.22,147.39,147.56,147.72,147.88,148.03,148.17,148.32,148.46,148.59,148.72,148.85,148.97,149.09,149.2,149.31,149.42,149.52,149.62,149.71,149.81,149.9,149.98,150.06,150.14,150.22,150.29,150.36,150.43,150.5,150.56,150.62,150.67,150.73,150.78,150.83,150.87,150.92,150.96,151.0,151.04,151.07,151.1,151.13,151.16,151.19,151.21,151.23,151.25,151.27,151.29,151.3,151.31,151.32,151.33,151.34,151.35,151.35,151.35,151.35,151.35,151.35,151.34,151.34,151.33,151.32,151.31,151.3,151.29,151.28,151.26,151.25,151.23,151.21,151.19,151.17,151.15,151.13,151.1,151.08,151.05,151.03,151.0,150.97,150.95,150.92,150.89,150.86,150.82,150.79,150.76,150.73,150.69,150.66,150.62,150.59,150.56,150.52,150.48,150.45,150.41,150.38,150.34,150.3,150.27,150.23,150.19,150.16,150.12,150.09,150.05,150.02,149.98,149.95,149.91,149.88,149.84,149.81,149.78,149.75,149.71,149.68,149.65,149.63,149.6,149.57,149.54,149.52,149.49,149.47,149.44,149.42,149.4,149.38,149.36,149.35,149.33,149.31,149.3,149.29,149.28,149.27,149.26,149.25,149.24,149.24,149.24,149.23,149.23,149.23,149.24,149.24,149.24,149.25,149.26,149.27,149.28,149.29,149.3,149.31,149.33,149.34,149.36,149.38,149.4,149.42,149.44,149.46,149.49,149.51,149.54,149.57,149.59,149.62,149.65,149.68,149.71,149.74,149.77,149.81,149.84,149.87,149.91,149.94,149.97,150.01,150.05,150.08,150.12,150.15,150.19,150.23,150.26,150.3,150.33,150.37,150.41,150.44,150.48,150.51,150.55,150.58,150.62,150.65,150.69,150.72,150.75,150.79,150.82,150.85,150.88,150.91,150.94,150.97,151.0,151.02,151.05,151.08,151.1,151.12,151.15,151.17,151.19,151.21,151.23,151.24,151.26,151.28,151.29,151.3,151.31,151.32,151.33,151.34,151.34,151.35,151.35,151.35,151.35,151.35,151.35,151.34,151.33,151.33,151.32,151.3,151.29,151.27,151.26,151.24,151.21,151.19,151.16,151.14,151.11,151.07,151.04,151.0,150.97,150.92,150.88,150.83,150.79,150.74,150.68,150.63,150.57,150.51,150.44,150.37,150.3,150.23,150.15,150.08,149.99,149.91,149.82,149.73,149.63,149.53,149.43,149.33,149.22,149.1,148.99,148.86,148.74,148.61,148.48,148.34,148.2,148.05,147.9,147.74,147.58,147.41,147.24,147.07,146.88,146.7,146.5,146.31,146.1,145.89,145.67,145.45,145.22,144.98,144.73,144.48,144.22,143.95,143.68,143.39,143.1,142.8,142.49,142.17,141.84,141.5,141.15,140.78,140.41,140.03,139.63,139.22,138.8,138.36,137.91,137.44,136.96,136.47,135.96,135.42,134.88,},
{135.63,136.2,136.76,137.29,137.8,138.3,138.78,139.25,139.7,140.14,140.57,140.98,141.37,141.76,142.13,142.5,142.85,143.19,143.52,143.84,144.15,144.46,144.75,145.04,145.31,145.58,145.84,146.09,146.34,146.58,146.81,147.04,147.25,147.47,147.67,147.87,148.07,148.25,148.44,148.61,148.79,148.95,149.12,149.27,149.43,149.57,149.72,149.86,149.99,150.12,150.25,150.37,150.49,150.6,150.71,150.82,150.93,151.03,151.12,151.22,151.31,151.39,151.48,151.56,151.63,151.71,151.78,151.85,151.92,151.98,152.04,152.1,152.15,152.21,152.26,152.31,152.35,152.4,152.44,152.48,152.51,152.55,152.58,152.61,152.64,152.66,152.69,152.71,152.73,152.75,152.76,152.78,152.79,152.8,152.81,152.82,152.83,152.83,152.83,152.83,152.83,152.83,152.83,152.83,152.82,152.81,152.8,152.79,152.78,152.77,152.76,152.74,152.73,152.71,152.69,152.67,152.65,152.63,152.61,152.59,152.56,152.54,152.51,152.49,152.46,152.43,152.4,152.37,152.34,152.31,152.28,152.25,152.22,152.19,152.15,152.12,152.09,152.05,152.02,151.98,151.95,151.91,151.88,151.84,151.81,151.77,151.74,151.7,151.67,151.63,151.6,151.56,151.53,151.49,151.46,151.43,151.39,151.36,151.33,151.3,151.27,151.24,151.21,151.18,151.15,151.12,151.1,151.07,151.05,151.02,151.0,150.98,150.96,150.94,150.92,150.9,150.88,150.87,150.85,150.84,150.82,150.81,150.8,150.8,150.79,150.78,150.78,150.77,150.77,150.77,150.77,150.77,150.78,150.78,150.79,150.79,150.8,150.81,150.82,150.84,150.85,150.86,150.88,150.9,150.91,150.93,150.95,150.97,151.0,151.02,151.04,151.07,151.09,151.12,151.15,151.17,151.2,151.23,151.26,151.29,151.33,151.36,151.39,151.42,151.46,151.49,151.52,151.56,151.59,151.63,151.66,151.7,151.73,151.77,151.8,151.84,151.87,151.91,151.94,151.98,152.01,152.05,152.08,152.11,152.15,152.18,152.21,152.25,152.28,152.31,152.34,152.37,152.4,152.43,152.45,152.48,152.51,152.53,152.56,152.58,152.61,152.63,152.65,152.67,152.69,152.71,152.72,152.74,152.76,152.77,152.78,152.79,152.8,152.81,152.82,152.82,152.83,152.83,152.83,152.84,152.83,152.83,152.83,152.82,152.81,152.8,152.79,152.78,152.77,152.75,152.73,152.71,152.69,152.67,152.64,152.61,152.58,152.55,152.52,152.48,152.44,152.4,152.36,152.31,152.27,152.22,152.16,152.11,152.05,151.99,151.93,151.86,151.79,151.72,151.65,151.57,151.49,151.41,151.32,151.23,151.14,151.04,150.94,150.84,150.73,150.62,150.51,150.39,150.27,150.14,150.01,149.88,149.74,149.6,149.45,149.3,149.14,148.98,148.81,148.64,148.46,148.28,148.09,147.9,147.7,147.5,147.29,147.07,146.84,146.61,146.38,146.13,145.88,145.62,145.35,145.08,144.79,144.5,144.2,143.89,143.57,143.24,142.9,142.55,142.19,141.82,141.43,141.04,140.63,140.21,139.77,139.32,138.86,138.37,137.88,137.37,},
{138.14,138.67,139.18,139.68,140.17,140.63,141.08,141.52,141.94,142.36,142.75,143.14,143.51,143.87,144.22,144.57,144.9,145.22,145.53,145.83,146.12,146.41,146.68,146.95,147.21,147.46,147.71,147.95,148.18,148.4,148.62,148.83,149.04,149.24,149.43,149.62,149.8,149.98,150.15,150.32,150.48,150.64,150.79,150.94,151.08,151.22,151.36,151.49,151.61,151.74,151.86,151.97,152.08,152.19,152.3,152.4,152.5,152.59,152.68,152.77,152.85,152.94,153.01,153.09,153.16,153.23,153.3,153.37,153.43,153.49,153.54,153.6,153.65,153.7,153.75,153.79,153.84,153.88,153.92,153.95,153.99,154.02,154.05,154.08,154.1,154.13,154.15,154.17,154.19,154.2,154.22,154.23,154.24,154.25,154.26,154.27,154.27,154.28,154.28,154.28,154.28,154.28,154.27,154.27,154.26,154.26,154.25,154.24,154.23,154.21,154.2,154.19,154.17,154.15,154.14,154.12,154.1,154.08,154.06,154.03,154.01,153.99,153.96,153.93,153.91,153.88,153.85,153.83,153.8,153.77,153.74,153.71,153.67,153.64,153.61,153.58,153.55,153.51,153.48,153.45,153.41,153.38,153.35,153.31,153.28,153.24,153.21,153.17,153.14,153.11,153.07,153.04,153.01,152.97,152.94,152.91,152.88,152.85,152.81,152.78,152.75,152.73,152.7,152.67,152.64,152.61,152.59,152.56,152.54,152.52,152.49,152.47,152.45,152.43,152.41,152.4,152.38,152.36,152.35,152.34,152.33,152.31,152.31,152.3,152.29,152.28,152.28,152.28,152.27,152.27,152.27,152.28,152.28,152.28,152.29,152.3,152.3,152.31,152.32,152.34,152.35,152.36,152.38,152.39,152.41,152.43,152.45,152.47,152.49,152.51,152.54,152.56,152.58,152.61,152.64,152.66,152.69,152.72,152.75,152.78,152.81,152.84,152.87,152.9,152.94,152.97,153.0,153.03,153.07,153.1,153.14,153.17,153.2,153.24,153.27,153.31,153.34,153.37,153.41,153.44,153.48,153.51,153.54,153.57,153.61,153.64,153.67,153.7,153.73,153.76,153.79,153.82,153.85,153.88,153.9,153.93,153.96,153.98,154.01,154.03,154.05,154.07,154.09,154.11,154.13,154.15,154.17,154.18,154.2,154.21,154.22,154.24,154.25,154.26,154.26,154.27,154.27,154.28,154.28,154.28,154.28,154.28,154.28,154.27,154.26,154.26,154.25,154.23,154.22,154.21,154.19,154.17,154.15,154.13,154.11,154.08,154.05,154.02,153.99,153.96,153.92,153.88,153.84,153.8,153.76,153.71,153.66,153.61,153.55,153.5,153.44,153.38,153.31,153.24,153.17,153.1,153.03,152.95,152.87,152.78,152.69,152.6,152.51,152.41,152.31,152.21,152.1,151.99,151.87,151.76,151.63,151.51,151.38,151.24,151.1,150.96,150.81,150.66,150.5,150.34,150.18,150.0,149.83,149.65,149.46,149.27,149.07,148.86,148.65,148.43,148.21,147.98,147.74,147.5,147.25,146.99,146.72,146.45,146.16,145.87,145.57,145.26,144.94,144.62,144.28,143.93,143.57,143.19,142.81,142.42,142.01,141.59,141.15,140.7,140.24,139.76,},
{140.54,141.04,141.52,141.99,142.44,142.87,143.3,143.71,144.1,144.49,144.86,145.22,145.57,145.91,146.24,146.56,146.87,147.17,147.46,147.75,148.02,148.29,148.55,148.8,149.05,149.28,149.51,149.74,149.96,150.17,150.37,150.57,150.76,150.95,151.14,151.31,151.48,151.65,151.81,151.97,152.12,152.27,152.42,152.56,152.69,152.82,152.95,153.07,153.19,153.31,153.42,153.53,153.63,153.74,153.83,153.93,154.02,154.11,154.2,154.28,154.36,154.44,154.51,154.58,154.65,154.72,154.78,154.84,154.9,154.96,155.01,155.06,155.11,155.16,155.2,155.24,155.28,155.32,155.36,155.39,155.42,155.45,155.48,155.51,155.53,155.55,155.57,155.59,155.61,155.62,155.64,155.65,155.66,155.67,155.68,155.68,155.69,155.69,155.69,155.69,155.69,155.69,155.68,155.68,155.67,155.66,155.66,155.65,155.63,155.62,155.61,155.59,155.58,155.56,155.55,155.53,155.51,155.49,155.47,155.44,155.42,155.4,155.37,155.35,155.32,155.3,155.27,155.24,155.21,155.19,155.16,155.13,155.1,155.07,155.03,155.0,154.97,154.94,154.91,154.88,154.84,154.81,154.78,154.74,154.71,154.68,154.65,154.61,154.58,154.55,154.51,154.48,154.45,154.42,154.39,154.36,154.32,154.29,154.26,154.23,154.21,154.18,154.15,154.12,154.1,154.07,154.05,154.02,154.0,153.98,153.95,153.93,153.91,153.89,153.88,153.86,153.84,153.83,153.81,153.8,153.79,153.78,153.77,153.76,153.76,153.75,153.75,153.74,153.74,153.74,153.74,153.74,153.75,153.75,153.76,153.76,153.77,153.78,153.79,153.8,153.81,153.83,153.84,153.86,153.87,153.89,153.91,153.93,153.95,153.97,153.99,154.02,154.04,154.07,154.09,154.12,154.15,154.17,154.2,154.23,154.26,154.29,154.32,154.35,154.38,154.41,154.45,154.48,154.51,154.54,154.57,154.61,154.64,154.67,154.71,154.74,154.77,154.81,154.84,154.87,154.9,154.94,154.97,155.0,155.03,155.06,155.09,155.12,155.15,155.18,155.21,155.24,155.27,155.29,155.32,155.34,155.37,155.39,155.42,155.44,155.46,155.48,155.5,155.52,155.54,155.56,155.58,155.59,155.61,155.62,155.63,155.64,155.65,155.66,155.67,155.68,155.68,155.69,155.69,155.69,155.69,155.69,155.69,155.68,155.68,155.67,155.66,155.65,155.64,155.63,155.61,155.59,155.58,155.56,155.53,155.51,155.48,155.46,155.43,155.39,155.36,155.33,155.29,155.25,155.21,155.16,155.12,155.07,155.02,154.96,154.91,154.85,154.79,154.73,154.66,154.59,154.52,154.45,154.37,154.29,154.21,154.12,154.04,153.94,153.85,153.75,153.65,153.55,153.44,153.33,153.21,153.09,152.97,152.84,152.71,152.58,152.44,152.29,152.15,151.99,151.84,151.68,151.51,151.34,151.16,150.98,150.79,150.6,150.4,150.2,149.99,149.77,149.55,149.32,149.08,148.84,148.59,148.33,148.06,147.79,147.51,147.22,146.92,146.61,146.29,145.96,145.62,145.27,144.91,144.54,144.16,143.77,143.36,142.94,142.5,142.05,},
{142.85,143.31,143.76,144.2,144.62,145.03,145.43,145.81,146.18,146.54,146.89,147.23,147.56,147.88,148.19,148.49,148.78,149.06,149.34,149.6,149.86,150.11,150.36,150.59,150.82,151.05,151.26,151.47,151.68,151.88,152.07,152.26,152.44,152.62,152.79,152.96,153.12,153.27,153.43,153.58,153.72,153.86,153.99,154.13,154.25,154.38,154.5,154.61,154.73,154.84,154.94,155.04,155.14,155.24,155.33,155.42,155.51,155.59,155.67,155.75,155.82,155.9,155.97,156.03,156.1,156.16,156.22,156.28,156.33,156.39,156.44,156.48,156.53,156.57,156.61,156.65,156.69,156.73,156.76,156.79,156.82,156.85,156.88,156.9,156.92,156.94,156.96,156.98,157.0,157.01,157.02,157.03,157.04,157.05,157.06,157.06,157.07,157.07,157.07,157.07,157.07,157.06,157.06,157.05,157.05,157.04,157.03,157.02,157.01,157.0,156.98,156.97,156.95,156.94,156.92,156.9,156.88,156.86,156.84,156.82,156.8,156.78,156.75,156.73,156.7,156.68,156.65,156.63,156.6,156.57,156.54,156.51,156.48,156.45,156.43,156.39,156.36,156.33,156.3,156.27,156.24,156.21,156.18,156.14,156.11,156.08,156.05,156.02,155.99,155.95,155.92,155.89,155.86,155.83,155.8,155.77,155.74,155.71,155.68,155.65,155.62,155.6,155.57,155.54,155.52,155.49,155.47,155.45,155.42,155.4,155.38,155.36,155.34,155.32,155.31,155.29,155.27,155.26,155.25,155.23,155.22,155.21,155.2,155.2,155.19,155.18,155.18,155.18,155.18,155.17,155.18,155.18,155.18,155.18,155.19,155.2,155.2,155.21,155.22,155.23,155.24,155.26,155.27,155.29,155.3,155.32,155.34,155.36,155.38,155.4,155.42,155.44,155.47,155.49,155.51,155.54,155.57,155.59,155.62,155.65,155.68,155.71,155.73,155.76,155.79,155.82,155.86,155.89,155.92,155.95,155.98,156.01,156.04,156.08,156.11,156.14,156.17,156.2,156.23,156.27,156.3,156.33,156.36,156.39,156.42,156.45,156.48,156.51,156.54,156.57,156.59,156.62,156.65,156.67,156.7,156.73,156.75,156.77,156.8,156.82,156.84,156.86,156.88,156.9,156.92,156.94,156.95,156.97,156.98,156.99,157.01,157.02,157.03,157.04,157.05,157.05,157.06,157.06,157.07,157.07,157.07,157.07,157.07,157.06,157.06,157.05,157.04,157.03,157.02,157.01,157.0,156.98,156.96,156.95,156.93,156.9,156.88,156.85,156.83,156.8,156.77,156.73,156.7,156.66,156.62,156.58,156.54,156.49,156.44,156.39,156.34,156.29,156.23,156.17,156.11,156.04,155.98,155.91,155.84,155.76,155.68,155.6,155.52,155.43,155.34,155.25,155.16,155.06,154.96,154.85,154.74,154.63,154.51,154.4,154.27,154.15,154.01,153.88,153.74,153.6,153.45,153.3,153.14,152.98,152.81,152.64,152.47,152.29,152.1,151.91,151.71,151.5,151.29,151.08,150.86,150.63,150.39,150.15,149.9,149.64,149.38,149.1,148.82,148.53,148.23,147.93,147.61,147.28,146.94,146.6,146.24,145.87,145.48,145.09,144.68,144.26,},
{145.07,145.5,145.92,146.33,146.73,147.11,147.48,147.84,148.19,148.53,148.85,149.17,149.48,149.78,150.07,150.35,150.62,150.89,151.15,151.4,151.64,151.88,152.1,152.33,152.54,152.75,152.96,153.16,153.35,153.54,153.72,153.89,154.07,154.23,154.39,154.55,154.7,154.85,154.99,155.13,155.27,155.4,155.53,155.65,155.77,155.89,156.0,156.11,156.22,156.32,156.42,156.52,156.61,156.7,156.79,156.87,156.95,157.03,157.11,157.18,157.25,157.32,157.39,157.45,157.51,157.57,157.62,157.68,157.73,157.78,157.83,157.87,157.91,157.95,157.99,158.03,158.07,158.1,158.13,158.16,158.19,158.21,158.24,158.26,158.28,158.3,158.32,158.33,158.35,158.36,158.37,158.38,158.39,158.4,158.4,158.41,158.41,158.41,158.41,158.41,158.41,158.41,158.4,158.4,158.39,158.38,158.37,158.36,158.35,158.34,158.33,158.31,158.3,158.28,158.26,158.25,158.23,158.21,158.19,158.17,158.15,158.12,158.1,158.08,158.05,158.03,158.0,157.98,157.95,157.92,157.9,157.87,157.84,157.81,157.78,157.75,157.72,157.69,157.66,157.63,157.6,157.57,157.54,157.51,157.48,157.45,157.42,157.39,157.36,157.33,157.3,157.27,157.24,157.21,157.18,157.15,157.12,157.09,157.06,157.04,157.01,156.98,156.96,156.93,156.91,156.88,156.86,156.84,156.82,156.8,156.77,156.76,156.74,156.72,156.7,156.69,156.67,156.66,156.65,156.63,156.62,156.61,156.6,156.6,156.59,156.59,156.58,156.58,156.58,156.58,156.58,156.58,156.58,156.58,156.59,156.6,156.6,156.61,156.62,156.63,156.64,156.66,156.67,156.68,156.7,156.72,156.73,156.75,156.77,156.79,156.81,156.83,156.86,156.88,156.9,156.93,156.95,156.98,157.01,157.03,157.06,157.09,157.12,157.15,157.17,157.2,157.23,157.26,157.29,157.32,157.35,157.38,157.42,157.45,157.48,157.51,157.54,157.57,157.6,157.63,157.66,157.69,157.72,157.75,157.78,157.81,157.84,157.86,157.89,157.92,157.95,157.97,158.0,158.02,158.05,158.07,158.1,158.12,158.14,158.16,158.19,158.21,158.23,158.24,158.26,158.28,158.29,158.31,158.32,158.34,158.35,158.36,158.37,158.38,158.39,158.39,158.4,158.41,158.41,158.41,158.41,158.41,158.41,158.41,158.4,158.4,158.39,158.38,158.37,158.36,158.35,158.34,158.32,158.3,158.28,158.26,158.24,158.22,158.19,158.16,158.13,158.1,158.07,158.04,158.0,157.96,157.92,157.88,157.83,157.79,157.74,157.69,157.63,157.58,157.52,157.46,157.39,157.33,157.26,157.19,157.12,157.04,156.96,156.88,156.8,156.71,156.62,156.53,156.43,156.34,156.23,156.13,156.02,155.91,155.79,155.67,155.55,155.42,155.29,155.15,155.02,154.87,154.73,154.57,154.42,154.26,154.09,153.92,153.74,153.56,153.38,153.18,152.99,152.78,152.58,152.36,152.14,151.91,151.68,151.43,151.18,150.93,150.66,150.39,150.11,149.82,149.52,149.22,148.9,148.58,148.24,147.89,147.53,147.17,146.78,146.39,},
{147.2,147.61,148.0,148.39,148.76,149.11,149.46,149.8,150.12,150.44,150.75,151.05,151.33,151.61,151.89,152.15,152.41,152.66,152.9,153.13,153.36,153.58,153.8,154.01,154.21,154.41,154.6,154.79,154.97,155.14,155.32,155.48,155.64,155.8,155.95,156.1,156.24,156.38,156.52,156.65,156.78,156.9,157.02,157.14,157.25,157.36,157.47,157.57,157.67,157.76,157.86,157.95,158.04,158.12,158.2,158.28,158.36,158.43,158.51,158.57,158.64,158.71,158.77,158.83,158.88,158.94,158.99,159.04,159.09,159.14,159.18,159.22,159.26,159.3,159.34,159.37,159.4,159.44,159.47,159.49,159.52,159.54,159.56,159.59,159.61,159.62,159.64,159.65,159.67,159.68,159.69,159.7,159.71,159.71,159.72,159.72,159.72,159.72,159.72,159.72,159.72,159.72,159.71,159.71,159.7,159.69,159.68,159.67,159.66,159.65,159.64,159.62,159.61,159.59,159.58,159.56,159.54,159.52,159.5,159.48,159.46,159.44,159.42,159.4,159.37,159.35,159.32,159.3,159.27,159.25,159.22,159.19,159.17,159.14,159.11,159.08,159.05,159.02,159.0,158.97,158.94,158.91,158.88,158.85,158.82,158.79,158.76,158.73,158.7,158.67,158.64,158.61,158.58,158.56,158.53,158.5,158.47,158.44,158.42,158.39,158.36,158.34,158.31,158.29,158.27,158.24,158.22,158.2,158.18,158.16,158.14,158.12,158.1,158.08,158.07,158.05,158.04,158.03,158.01,158.0,157.99,157.98,157.97,157.97,157.96,157.96,157.95,157.95,157.95,157.95,157.95,157.95,157.95,157.95,157.96,157.97,157.97,157.98,157.99,158.0,158.01,158.02,158.04,158.05,158.07,158.08,158.1,158.12,158.14,158.15,158.17,158.2,158.22,158.24,158.26,158.29,158.31,158.34,158.36,158.39,158.41,158.44,158.47,158.5,158.52,158.55,158.58,158.61,158.64,158.67,158.7,158.73,158.76,158.79,158.81,158.84,158.87,158.9,158.93,158.96,158.99,159.02,159.05,159.08,159.11,159.13,159.16,159.19,159.22,159.24,159.27,159.29,159.32,159.34,159.37,159.39,159.41,159.44,159.46,159.48,159.5,159.52,159.54,159.56,159.57,159.59,159.61,159.62,159.63,159.65,159.66,159.67,159.68,159.69,159.7,159.71,159.71,159.72,159.72,159.72,159.72,159.72,159.72,159.72,159.72,159.71,159.71,159.7,159.69,159.68,159.67,159.66,159.64,159.63,159.61,159.59,159.57,159.55,159.52,159.5,159.47,159.44,159.41,159.38,159.34,159.31,159.27,159.23,159.19,159.14,159.1,159.05,159.0,158.95,158.89,158.83,158.78,158.71,158.65,158.58,158.52,158.44,158.37,158.29,158.22,158.13,158.05,157.96,157.87,157.78,157.68,157.58,157.48,157.38,157.27,157.15,157.04,156.92,156.79,156.67,156.54,156.4,156.26,156.12,155.97,155.82,155.67,155.51,155.34,155.17,154.99,154.81,154.63,154.44,154.24,154.04,153.83,153.62,153.4,153.17,152.93,152.69,152.45,152.19,151.93,151.66,151.38,151.09,150.79,150.49,150.17,149.85,149.51,149.17,148.81,148.44,},
{149.26,149.64,150.01,150.37,150.71,151.05,151.37,151.69,151.99,152.29,152.58,152.86,153.13,153.39,153.65,153.89,154.14,154.37,154.6,154.82,155.03,155.24,155.44,155.64,155.83,156.01,156.19,156.37,156.54,156.71,156.87,157.02,157.17,157.32,157.46,157.6,157.74,157.87,158.0,158.12,158.24,158.36,158.47,158.58,158.69,158.79,158.89,158.99,159.08,159.17,159.26,159.34,159.43,159.51,159.58,159.66,159.73,159.8,159.87,159.93,160.0,160.06,160.11,160.17,160.22,160.27,160.32,160.37,160.42,160.46,160.5,160.54,160.58,160.61,160.65,160.68,160.71,160.74,160.77,160.79,160.82,160.84,160.86,160.88,160.9,160.91,160.93,160.94,160.96,160.97,160.98,160.98,160.99,161.0,161.0,161.0,161.0,161.01,161.0,161.0,161.0,161.0,160.99,160.99,160.98,160.97,160.96,160.95,160.94,160.93,160.92,160.9,160.89,160.87,160.86,160.84,160.82,160.81,160.79,160.77,160.75,160.73,160.7,160.68,160.66,160.64,160.61,160.59,160.56,160.54,160.51,160.49,160.46,160.43,160.41,160.38,160.35,160.33,160.3,160.27,160.24,160.21,160.18,160.16,160.13,160.1,160.07,160.04,160.01,159.98,159.96,159.93,159.9,159.87,159.85,159.82,159.79,159.77,159.74,159.71,159.69,159.67,159.64,159.62,159.59,159.57,159.55,159.53,159.51,159.49,159.47,159.45,159.44,159.42,159.4,159.39,159.38,159.36,159.35,159.34,159.33,159.32,159.31,159.31,159.3,159.29,159.29,159.29,159.29,159.29,159.29,159.29,159.29,159.29,159.3,159.3,159.31,159.32,159.33,159.34,159.35,159.36,159.37,159.39,159.4,159.42,159.43,159.45,159.47,159.49,159.51,159.53,159.55,159.57,159.59,159.61,159.64,159.66,159.69,159.71,159.74,159.76,159.79,159.81,159.84,159.87,159.9,159.92,159.95,159.98,160.01,160.04,160.07,160.09,160.12,160.15,160.18,160.21,160.24,160.26,160.29,160.32,160.35,160.38,160.4,160.43,160.46,160.48,160.51,160.54,160.56,160.58,160.61,160.63,160.66,160.68,160.7,160.72,160.74,160.76,160.78,160.8,160.82,160.84,160.86,160.87,160.89,160.9,160.91,160.93,160.94,160.95,160.96,160.97,160.98,160.98,160.99,161.0,161.0,161.0,161.0,161.01,161.0,161.0,161.0,161.0,160.99,160.98,160.98,160.97,160.96,160.94,160.93,160.92,160.9,160.88,160.86,160.84,160.82,160.8,160.77,160.74,160.72,160.69,160.65,160.62,160.58,160.55,160.51,160.47,160.42,160.38,160.33,160.28,160.23,160.18,160.12,160.06,160.0,159.94,159.88,159.81,159.74,159.67,159.6,159.52,159.44,159.36,159.27,159.18,159.09,159.0,158.9,158.8,158.7,158.6,158.49,158.37,158.26,158.14,158.02,157.89,157.76,157.62,157.49,157.34,157.2,157.05,156.89,156.73,156.57,156.4,156.22,156.04,155.86,155.67,155.47,155.27,155.06,154.85,154.63,154.4,154.17,153.93,153.68,153.43,153.17,152.9,152.62,152.33,152.04,151.73,151.42,151.1,150.76,150.42,},
{151.24,151.6,151.94,152.28,152.6,152.91,153.22,153.51,153.8,154.08,154.35,154.61,154.86,155.11,155.35,155.58,155.81,156.03,156.24,156.45,156.65,156.84,157.03,157.22,157.4,157.57,157.74,157.91,158.07,158.22,158.37,158.52,158.66,158.8,158.94,159.07,159.19,159.32,159.44,159.55,159.67,159.77,159.88,159.98,160.08,160.18,160.28,160.37,160.45,160.54,160.62,160.7,160.78,160.86,160.93,161.0,161.07,161.13,161.2,161.26,161.31,161.37,161.43,161.48,161.53,161.58,161.62,161.67,161.71,161.75,161.79,161.83,161.86,161.9,161.93,161.96,161.99,162.01,162.04,162.06,162.09,162.11,162.13,162.14,162.16,162.18,162.19,162.2,162.21,162.22,162.23,162.24,162.24,162.25,162.25,162.26,162.26,162.26,162.26,162.25,162.25,162.25,162.24,162.24,162.23,162.22,162.21,162.2,162.19,162.18,162.17,162.16,162.14,162.13,162.11,162.09,162.08,162.06,162.04,162.02,162.0,161.98,161.96,161.94,161.92,161.9,161.87,161.85,161.83,161.8,161.78,161.75,161.73,161.7,161.68,161.65,161.62,161.6,161.57,161.54,161.52,161.49,161.46,161.43,161.41,161.38,161.35,161.32,161.3,161.27,161.24,161.21,161.19,161.16,161.14,161.11,161.08,161.06,161.03,161.01,160.99,160.96,160.94,160.92,160.89,160.87,160.85,160.83,160.81,160.79,160.77,160.76,160.74,160.72,160.71,160.7,160.68,160.67,160.66,160.65,160.64,160.63,160.62,160.62,160.61,160.6,160.6,160.6,160.6,160.6,160.6,160.6,160.6,160.6,160.61,160.61,160.62,160.63,160.64,160.65,160.66,160.67,160.68,160.69,160.71,160.72,160.74,160.75,160.77,160.79,160.81,160.83,160.85,160.87,160.89,160.91,160.93,160.96,160.98,161.01,161.03,161.05,161.08,161.11,161.13,161.16,161.18,161.21,161.24,161.26,161.29,161.32,161.35,161.37,161.4,161.43,161.46,161.48,161.51,161.54,161.57,161.59,161.62,161.65,161.67,161.7,161.72,161.75,161.77,161.8,161.82,161.85,161.87,161.89,161.92,161.94,161.96,161.98,162.0,162.02,162.04,162.06,162.07,162.09,162.11,162.12,162.14,162.15,162.17,162.18,162.19,162.2,162.21,162.22,162.23,162.24,162.24,162.25,162.25,162.25,162.26,162.26,162.26,162.26,162.25,162.25,162.25,162.24,162.23,162.22,162.21,162.2,162.19,162.18,162.16,162.15,162.13,162.11,162.09,162.07,162.04,162.02,161.99,161.96,161.93,161.9,161.87,161.83,161.8,161.76,161.72,161.67,161.63,161.58,161.54,161.49,161.43,161.38,161.32,161.27,161.2,161.14,161.08,161.01,160.94,160.87,160.79,160.71,160.64,160.55,160.47,160.38,160.29,160.2,160.1,160.0,159.9,159.79,159.68,159.57,159.45,159.33,159.21,159.09,158.95,158.82,158.68,158.54,158.39,158.24,158.09,157.93,157.77,157.6,157.42,157.25,157.06,156.87,156.68,156.48,156.27,156.06,155.84,155.62,155.38,155.15,154.9,154.65,154.39,154.12,153.84,153.56,153.26,152.96,152.65,152.33,},
{153.16,153.49,153.81,154.12,154.43,154.72,155.0,155.28,155.55,155.81,156.06,156.31,156.54,156.77,157.0,157.22,157.43,157.63,157.83,158.03,158.22,158.4,158.58,158.75,158.92,159.08,159.24,159.4,159.55,159.69,159.84,159.97,160.11,160.24,160.37,160.49,160.61,160.72,160.84,160.95,161.05,161.15,161.25,161.35,161.45,161.54,161.62,161.71,161.79,161.87,161.95,162.03,162.1,162.17,162.24,162.3,162.37,162.43,162.49,162.55,162.6,162.66,162.71,162.76,162.8,162.85,162.89,162.93,162.97,163.01,163.05,163.08,163.12,163.15,163.18,163.21,163.23,163.26,163.28,163.3,163.32,163.34,163.36,163.38,163.39,163.41,163.42,163.43,163.44,163.45,163.46,163.46,163.47,163.47,163.48,163.48,163.48,163.48,163.48,163.48,163.47,163.47,163.46,163.46,163.45,163.44,163.43,163.43,163.41,163.4,163.39,163.38,163.36,163.35,163.34,163.32,163.3,163.29,163.27,163.25,163.23,163.21,163.19,163.17,163.15,163.13,163.11,163.08,163.06,163.04,163.01,162.99,162.97,162.94,162.92,162.89,162.87,162.84,162.81,162.79,162.76,162.74,162.71,162.68,162.66,162.63,162.6,162.58,162.55,162.53,162.5,162.47,162.45,162.42,162.4,162.37,162.35,162.32,162.3,162.28,162.25,162.23,162.21,162.19,162.16,162.14,162.12,162.1,162.09,162.07,162.05,162.03,162.02,162.0,161.99,161.97,161.96,161.95,161.94,161.93,161.92,161.91,161.9,161.9,161.89,161.89,161.88,161.88,161.88,161.88,161.88,161.88,161.88,161.89,161.89,161.9,161.9,161.91,161.92,161.93,161.94,161.95,161.96,161.97,161.99,162.0,162.01,162.03,162.05,162.06,162.08,162.1,162.12,162.14,162.16,162.18,162.2,162.23,162.25,162.27,162.3,162.32,162.34,162.37,162.39,162.42,162.44,162.47,162.5,162.52,162.55,162.57,162.6,162.63,162.65,162.68,162.71,162.73,162.76,162.78,162.81,162.84,162.86,162.89,162.91,162.94,162.96,162.99,163.01,163.03,163.06,163.08,163.1,163.13,163.15,163.17,163.19,163.21,163.23,163.25,163.27,163.28,163.3,163.32,163.33,163.35,163.36,163.38,163.39,163.4,163.41,163.42,163.43,163.44,163.45,163.46,163.46,163.47,163.47,163.48,163.48,163.48,163.48,163.48,163.48,163.47,163.47,163.47,163.46,163.45,163.44,163.43,163.42,163.41,163.4,163.38,163.36,163.35,163.33,163.31,163.28,163.26,163.24,163.21,163.18,163.15,163.12,163.09,163.05,163.02,162.98,162.94,162.9,162.85,162.81,162.76,162.71,162.66,162.61,162.56,162.5,162.44,162.38,162.31,162.25,162.18,162.11,162.04,161.96,161.89,161.81,161.72,161.64,161.55,161.46,161.37,161.27,161.17,161.07,160.96,160.85,160.74,160.62,160.51,160.38,160.26,160.13,159.99,159.86,159.72,159.57,159.42,159.27,159.11,158.95,158.78,158.61,158.43,158.25,158.06,157.86,157.66,157.46,157.25,157.03,156.81,156.58,156.34,156.1,155.85,155.59,155.32,155.04,154.76,154.47,154.17,},
{155.0,155.31,155.61,155.91,156.19,156.46,156.73,156.99,157.24,157.48,157.72,157.95,158.17,158.39,158.6,158.8,159.0,159.19,159.38,159.56,159.74,159.91,160.08,160.24,160.4,160.55,160.7,160.85,160.99,161.13,161.26,161.39,161.52,161.64,161.76,161.87,161.98,162.09,162.2,162.3,162.4,162.5,162.59,162.68,162.77,162.86,162.94,163.02,163.1,163.17,163.25,163.32,163.39,163.45,163.52,163.58,163.64,163.7,163.75,163.81,163.86,163.91,163.96,164.0,164.05,164.09,164.13,164.17,164.21,164.24,164.28,164.31,164.34,164.37,164.4,164.42,164.45,164.47,164.49,164.51,164.53,164.55,164.57,164.58,164.6,164.61,164.62,164.63,164.64,164.65,164.66,164.66,164.67,164.67,164.67,164.68,164.68,164.68,164.67,164.67,164.67,164.66,164.66,164.65,164.65,164.64,164.63,164.62,164.61,164.6,164.59,164.57,164.56,164.55,164.53,164.52,164.5,164.49,164.47,164.45,164.43,164.41,164.39,164.37,164.35,164.33,164.31,164.29,164.27,164.25,164.22,164.2,164.18,164.15,164.13,164.1,164.08,164.06,164.03,164.01,163.98,163.96,163.93,163.91,163.88,163.85,163.83,163.8,163.78,163.75,163.73,163.7,163.68,163.66,163.63,163.61,163.58,163.56,163.54,163.51,163.49,163.47,163.45,163.43,163.41,163.39,163.37,163.35,163.33,163.31,163.3,163.28,163.27,163.25,163.24,163.22,163.21,163.2,163.19,163.18,163.17,163.16,163.16,163.15,163.15,163.14,163.14,163.13,163.13,163.13,163.13,163.13,163.14,163.14,163.14,163.15,163.16,163.16,163.17,163.18,163.19,163.2,163.21,163.22,163.24,163.25,163.26,163.28,163.3,163.31,163.33,163.35,163.37,163.39,163.41,163.43,163.45,163.47,163.49,163.51,163.53,163.56,163.58,163.6,163.63,163.65,163.68,163.7,163.73,163.75,163.78,163.8,163.83,163.85,163.88,163.9,163.93,163.95,163.98,164.0,164.03,164.05,164.08,164.1,164.13,164.15,164.17,164.2,164.22,164.24,164.27,164.29,164.31,164.33,164.35,164.37,164.39,164.41,164.43,164.45,164.47,164.48,164.5,164.52,164.53,164.55,164.56,164.57,164.59,164.6,164.61,164.62,164.63,164.64,164.64,164.65,164.66,164.66,164.67,164.67,164.67,164.68,164.68,164.68,164.67,164.67,164.67,164.66,164.66,164.65,164.64,164.63,164.62,164.61,164.6,164.59,164.57,164.55,164.54,164.52,164.5,164.47,164.45,164.43,164.4,164.37,164.34,164.31,164.28,164.25,164.21,164.17,164.13,164.09,164.05,164.01,163.96,163.91,163.86,163.81,163.76,163.7,163.65,163.59,163.53,163.46,163.4,163.33,163.26,163.18,163.11,163.03,162.95,162.87,162.78,162.7,162.61,162.51,162.42,162.32,162.21,162.11,162.0,161.89,161.77,161.66,161.53,161.41,161.28,161.15,161.01,160.87,160.73,160.58,160.42,160.27,160.1,159.94,159.77,159.59,159.41,159.22,159.03,158.83,158.63,158.42,158.2,157.98,157.75,157.52,157.28,157.03,156.77,156.5,156.23,155.95,},
{156.79,157.08,157.36,157.63,157.89,158.15,158.4,158.64,158.88,159.1,159.33,159.54,159.75,159.95,160.15,160.34,160.53,160.71,160.88,161.05,161.22,161.38,161.54,161.69,161.84,161.98,162.12,162.26,162.39,162.52,162.64,162.77,162.88,163.0,163.11,163.22,163.32,163.43,163.52,163.62,163.71,163.81,163.89,163.98,164.06,164.14,164.22,164.3,164.37,164.44,164.51,164.58,164.64,164.7,164.76,164.82,164.88,164.93,164.98,165.03,165.08,165.13,165.17,165.22,165.26,165.3,165.34,165.37,165.41,165.44,165.47,165.5,165.53,165.56,165.59,165.61,165.63,165.66,165.68,165.7,165.71,165.73,165.75,165.76,165.77,165.79,165.8,165.81,165.81,165.82,165.83,165.83,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.83,165.83,165.82,165.81,165.81,165.8,165.79,165.78,165.77,165.76,165.74,165.73,165.72,165.7,165.69,165.67,165.66,165.64,165.62,165.61,165.59,165.57,165.55,165.53,165.51,165.49,165.47,165.45,165.43,165.41,165.38,165.36,165.34,165.32,165.29,165.27,165.25,165.22,165.2,165.17,165.15,165.13,165.1,165.08,165.05,165.03,165.0,164.98,164.96,164.93,164.91,164.89,164.86,164.84,164.82,164.79,164.77,164.75,164.73,164.71,164.68,164.66,164.64,164.62,164.61,164.59,164.57,164.55,164.54,164.52,164.5,164.49,164.48,164.46,164.45,164.44,164.43,164.42,164.41,164.4,164.39,164.38,164.38,164.37,164.37,164.37,164.36,164.36,164.36,164.36,164.36,164.36,164.37,164.37,164.38,164.38,164.39,164.4,164.41,164.41,164.42,164.44,164.45,164.46,164.47,164.49,164.5,164.52,164.53,164.55,164.57,164.58,164.6,164.62,164.64,164.66,164.68,164.7,164.72,164.75,164.77,164.79,164.81,164.84,164.86,164.88,164.91,164.93,164.95,164.98,165.0,165.03,165.05,165.07,165.1,165.12,165.15,165.17,165.19,165.22,165.24,165.27,165.29,165.31,165.34,165.36,165.38,165.4,165.42,165.45,165.47,165.49,165.51,165.53,165.55,165.57,165.59,165.6,165.62,165.64,165.66,165.67,165.69,165.7,165.72,165.73,165.74,165.75,165.77,165.78,165.79,165.8,165.81,165.81,165.82,165.83,165.83,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.84,165.83,165.83,165.82,165.82,165.81,165.8,165.79,165.78,165.76,165.75,165.73,165.72,165.7,165.68,165.66,165.64,165.62,165.59,165.56,165.54,165.51,165.48,165.45,165.41,165.38,165.34,165.3,165.27,165.22,165.18,165.14,165.09,165.04,164.99,164.94,164.89,164.83,164.77,164.71,164.65,164.59,164.52,164.45,164.38,164.31,164.23,164.15,164.07,163.99,163.91,163.82,163.73,163.64,163.54,163.44,163.34,163.23,163.13,163.02,162.9,162.78,162.66,162.54,162.41,162.28,162.14,162.0,161.86,161.71,161.56,161.4,161.24,161.08,160.91,160.73,160.55,160.37,160.18,159.98,159.78,159.57,159.36,159.14,158.91,158.68,158.44,158.19,157.93,157.67,},
{158.51,158.78,159.04,159.3,159.55,159.78,160.02,160.24,160.46,160.68,160.88,161.08,161.28,161.47,161.65,161.83,162.01,162.18,162.34,162.5,162.66,162.81,162.95,163.1,163.24,163.37,163.5,163.63,163.75,163.87,163.99,164.1,164.22,164.32,164.43,164.53,164.63,164.72,164.82,164.91,165.0,165.08,165.16,165.24,165.32,165.4,165.47,165.54,165.61,165.68,165.74,165.8,165.86,165.92,165.98,166.03,166.09,166.14,166.19,166.23,166.28,166.32,166.36,166.4,166.44,166.48,166.52,166.55,166.58,166.62,166.64,166.67,166.7,166.73,166.75,166.77,166.8,166.82,166.83,166.85,166.87,166.88,166.9,166.91,166.92,166.94,166.95,166.95,166.96,166.97,166.97,166.98,166.98,166.99,166.99,166.99,166.99,166.99,166.99,166.98,166.98,166.97,166.97,166.96,166.96,166.95,166.94,166.93,166.92,166.91,166.9,166.89,166.88,166.86,166.85,166.84,166.82,166.81,166.79,166.77,166.76,166.74,166.72,166.7,166.68,166.67,166.65,166.63,166.61,166.59,166.56,166.54,166.52,166.5,166.48,166.46,166.43,166.41,166.39,166.36,166.34,166.32,166.3,166.27,166.25,166.23,166.2,166.18,166.16,166.13,166.11,166.09,166.07,166.04,166.02,166.0,165.98,165.96,165.93,165.91,165.89,165.87,165.85,165.83,165.82,165.8,165.78,165.76,165.75,165.73,165.72,165.7,165.69,165.67,165.66,165.65,165.64,165.63,165.62,165.61,165.6,165.59,165.59,165.58,165.57,165.57,165.57,165.56,165.56,165.56,165.56,165.56,165.57,165.57,165.57,165.58,165.58,165.59,165.6,165.61,165.61,165.62,165.63,165.65,165.66,165.67,165.68,165.7,165.71,165.73,165.74,165.76,165.78,165.8,165.81,165.83,165.85,165.87,165.89,165.91,165.93,165.95,165.97,166.0,166.02,166.04,166.06,166.08,166.11,166.13,166.15,166.18,166.2,166.22,166.25,166.27,166.29,166.32,166.34,166.36,166.38,166.41,166.43,166.45,166.47,166.5,166.52,166.54,166.56,166.58,166.6,166.62,166.64,166.66,166.68,166.7,166.72,166.74,166.75,166.77,166.79,166.8,166.82,166.83,166.85,166.86,166.87,166.89,166.9,166.91,166.92,166.93,166.94,166.95,166.96,166.96,166.97,166.97,166.98,166.98,166.98,166.99,166.99,166.99,166.99,166.99,166.98,166.98,166.97,166.97,166.96,166.96,166.95,166.94,166.93,166.91,166.9,166.89,166.87,166.86,166.84,166.82,166.8,166.78,166.75,166.73,166.7,166.68,166.65,166.62,166.59,166.56,166.52,166.49,166.45,166.41,166.37,166.33,166.28,166.24,166.19,166.14,166.09,166.04,165.99,165.93,165.87,165.81,165.75,165.69,165.62,165.55,165.48,165.41,165.33,165.26,165.18,165.09,165.01,164.92,164.83,164.74,164.64,164.54,164.44,164.34,164.23,164.12,164.01,163.89,163.77,163.65,163.52,163.39,163.26,163.12,162.97,162.83,162.68,162.52,162.36,162.2,162.03,161.86,161.68,161.5,161.31,161.11,160.91,160.71,160.49,160.28,160.05,159.82,159.58,159.34,},
{160.18,160.43,160.68,160.91,161.14,161.37,161.59,161.8,162.0,162.2,162.39,162.58,162.76,162.94,163.11,163.28,163.44,163.6,163.76,163.91,164.05,164.19,164.33,164.46,164.59,164.72,164.84,164.96,165.08,165.19,165.3,165.41,165.51,165.61,165.71,165.81,165.9,165.99,166.08,166.16,166.24,166.32,166.4,166.48,166.55,166.62,166.69,166.76,166.82,166.88,166.94,167.0,167.06,167.11,167.17,167.22,167.27,167.31,167.36,167.4,167.45,167.49,167.53,167.56,167.6,167.64,167.67,167.7,167.73,167.76,167.79,167.82,167.84,167.86,167.89,167.91,167.93,167.95,167.97,167.98,168.0,168.01,168.03,168.04,168.05,168.06,168.07,168.08,168.08,168.09,168.09,168.1,168.1,168.1,168.11,168.11,168.11,168.1,168.1,168.1,168.1,168.09,168.09,168.08,168.07,168.07,168.06,168.05,168.04,168.03,168.02,168.01,168.0,167.98,167.97,167.96,167.94,167.93,167.91,167.9,167.88,167.86,167.85,167.83,167.81,167.79,167.78,167.76,167.74,167.72,167.7,167.68,167.66,167.64,167.61,167.59,167.57,167.55,167.53,167.51,167.48,167.46,167.44,167.42,167.4,167.37,167.35,167.33,167.31,167.29,167.26,167.24,167.22,167.2,167.18,167.16,167.14,167.12,167.1,167.08,167.06,167.04,167.02,167.0,166.98,166.97,166.95,166.93,166.92,166.9,166.89,166.87,166.86,166.85,166.83,166.82,166.81,166.8,166.79,166.78,166.77,166.77,166.76,166.76,166.75,166.75,166.74,166.74,166.74,166.74,166.74,166.74,166.74,166.75,166.75,166.76,166.76,166.77,166.77,166.78,166.79,166.8,166.81,166.82,166.83,166.84,166.86,166.87,166.88,166.9,166.91,166.93,166.95,166.96,166.98,167.0,167.02,167.03,167.05,167.07,167.09,167.11,167.13,167.15,167.18,167.2,167.22,167.24,167.26,167.28,167.3,167.33,167.35,167.37,167.39,167.42,167.44,167.46,167.48,167.5,167.53,167.55,167.57,167.59,167.61,167.63,167.65,167.67,167.69,167.71,167.73,167.75,167.77,167.79,167.81,167.83,167.85,167.86,167.88,167.9,167.91,167.93,167.94,167.96,167.97,167.98,168.0,168.01,168.02,168.03,168.04,168.05,168.06,168.07,168.07,168.08,168.09,168.09,168.1,168.1,168.1,168.1,168.11,168.11,168.11,168.1,168.1,168.1,168.1,168.09,168.08,168.08,168.07,168.06,168.05,168.04,168.03,168.01,168.0,167.98,167.97,167.95,167.93,167.91,167.89,167.87,167.84,167.82,167.79,167.77,167.74,167.71,167.67,167.64,167.61,167.57,167.53,167.49,167.45,167.41,167.37,167.32,167.27,167.22,167.17,167.12,167.07,167.01,166.95,166.89,166.83,166.76,166.7,166.63,166.56,166.49,166.41,166.34,166.26,166.17,166.09,166.0,165.91,165.82,165.73,165.63,165.53,165.42,165.32,165.21,165.1,164.98,164.86,164.74,164.61,164.48,164.35,164.21,164.07,163.93,163.78,163.63,163.47,163.31,163.14,162.97,162.79,162.61,162.42,162.23,162.03,161.83,161.62,161.4,161.18,160.95,},
{161.79,162.03,162.26,162.48,162.69,162.9,163.1,163.3,163.49,163.68,163.86,164.03,164.21,164.37,164.53,164.69,164.84,164.99,165.13,165.27,165.41,165.54,165.67,165.79,165.92,166.03,166.15,166.26,166.37,166.48,166.58,166.68,166.78,166.87,166.96,167.05,167.14,167.22,167.3,167.38,167.46,167.54,167.61,167.68,167.75,167.81,167.88,167.94,168.0,168.06,168.12,168.17,168.22,168.27,168.32,168.37,168.42,168.46,168.51,168.55,168.59,168.62,168.66,168.7,168.73,168.76,168.8,168.83,168.85,168.88,168.91,168.93,168.96,168.98,169.0,169.02,169.04,169.06,169.07,169.09,169.1,169.12,169.13,169.14,169.15,169.16,169.17,169.17,169.18,169.19,169.19,169.19,169.2,169.2,169.2,169.2,169.2,169.2,169.2,169.19,169.19,169.19,169.18,169.17,169.17,169.16,169.15,169.14,169.14,169.13,169.12,169.1,169.09,169.08,169.07,169.06,169.04,169.03,169.01,169.0,168.98,168.97,168.95,168.93,168.92,168.9,168.88,168.86,168.84,168.83,168.81,168.79,168.77,168.75,168.73,168.71,168.69,168.67,168.65,168.62,168.6,168.58,168.56,168.54,168.52,168.5,168.48,168.46,168.44,168.41,168.39,168.37,168.35,168.33,168.31,168.29,168.27,168.25,168.23,168.21,168.2,168.18,168.16,168.14,168.12,168.11,168.09,168.08,168.06,168.05,168.03,168.02,168.01,167.99,167.98,167.97,167.96,167.95,167.94,167.93,167.93,167.92,167.91,167.91,167.9,167.9,167.9,167.9,167.89,167.89,167.89,167.89,167.9,167.9,167.9,167.91,167.91,167.92,167.93,167.93,167.94,167.95,167.96,167.97,167.98,167.99,168.0,168.02,168.03,168.04,168.06,168.07,168.09,168.11,168.12,168.14,168.16,168.17,168.19,168.21,168.23,168.25,168.27,168.29,168.31,168.33,168.35,168.37,168.39,168.41,168.43,168.45,168.47,168.5,168.52,168.54,168.56,168.58,168.6,168.62,168.64,168.66,168.68,168.7,168.72,168.74,168.76,168.78,168.8,168.82,168.84,168.86,168.88,168.9,168.91,168.93,168.95,168.96,168.98,169.0,169.01,169.03,169.04,169.05,169.07,169.08,169.09,169.1,169.11,169.12,169.13,169.14,169.15,169.16,169.17,169.17,169.18,169.18,169.19,169.19,169.2,169.2,169.2,169.2,169.2,169.2,169.2,169.19,169.19,169.19,169.18,169.17,169.17,169.16,169.15,169.14,169.13,169.12,169.1,169.09,169.07,169.06,169.04,169.02,169.0,168.98,168.96,168.94,168.91,168.89,168.86,168.83,168.8,168.77,168.74,168.7,168.67,168.63,168.59,168.55,168.51,168.47,168.42,168.38,168.33,168.28,168.23,168.18,168.12,168.07,168.01,167.95,167.89,167.82,167.76,167.69,167.62,167.55,167.47,167.4,167.32,167.23,167.15,167.06,166.98,166.88,166.79,166.69,166.59,166.49,166.39,166.28,166.17,166.05,165.93,165.81,165.69,165.56,165.43,165.29,165.15,165.01,164.86,164.71,164.56,164.39,164.23,164.06,163.89,163.71,163.52,163.33,163.13,162.93,162.72,162.51,},
{163.36,163.58,163.79,164.0,164.2,164.39,164.58,164.76,164.94,165.11,165.28,165.45,165.61,165.76,165.91,166.06,166.2,166.34,166.47,166.6,166.73,166.85,166.97,167.09,167.2,167.31,167.42,167.53,167.63,167.73,167.82,167.92,168.01,168.1,168.18,168.27,168.35,168.42,168.5,168.58,168.65,168.72,168.79,168.85,168.92,168.98,169.04,169.1,169.15,169.21,169.26,169.31,169.36,169.41,169.46,169.5,169.54,169.58,169.62,169.66,169.7,169.74,169.77,169.8,169.84,169.87,169.9,169.92,169.95,169.98,170.0,170.02,170.05,170.07,170.09,170.1,170.12,170.14,170.15,170.17,170.18,170.19,170.21,170.22,170.22,170.23,170.24,170.25,170.25,170.26,170.26,170.27,170.27,170.27,170.27,170.27,170.27,170.27,170.27,170.26,170.26,170.26,170.25,170.25,170.24,170.23,170.22,170.22,170.21,170.2,170.19,170.18,170.17,170.16,170.14,170.13,170.12,170.1,170.09,170.08,170.06,170.05,170.03,170.01,170.0,169.98,169.96,169.95,169.93,169.91,169.89,169.87,169.86,169.84,169.82,169.8,169.78,169.76,169.74,169.72,169.7,169.68,169.66,169.64,169.62,169.6,169.58,169.56,169.54,169.52,169.5,169.48,169.46,169.44,169.42,169.4,169.38,169.37,169.35,169.33,169.31,169.29,169.28,169.26,169.24,169.23,169.21,169.2,169.18,169.17,169.16,169.14,169.13,169.12,169.11,169.1,169.09,169.08,169.07,169.06,169.05,169.05,169.04,169.04,169.03,169.03,169.03,169.02,169.02,169.02,169.02,169.02,169.03,169.03,169.03,169.04,169.04,169.05,169.05,169.06,169.07,169.08,169.09,169.1,169.11,169.12,169.13,169.14,169.15,169.17,169.18,169.2,169.21,169.23,169.24,169.26,169.27,169.29,169.31,169.33,169.34,169.36,169.38,169.4,169.42,169.44,169.46,169.48,169.5,169.52,169.54,169.56,169.58,169.6,169.62,169.64,169.66,169.68,169.7,169.72,169.74,169.76,169.78,169.8,169.81,169.83,169.85,169.87,169.89,169.91,169.93,169.94,169.96,169.98,170.0,170.01,170.03,170.04,170.06,170.07,170.09,170.1,170.12,170.13,170.14,170.15,170.17,170.18,170.19,170.2,170.21,170.22,170.22,170.23,170.24,170.24,170.25,170.26,170.26,170.26,170.27,170.27,170.27,170.27,170.27,170.27,170.27,170.27,170.26,170.26,170.25,170.25,170.24,170.23,170.23,170.22,170.21,170.2,170.18,170.17,170.16,170.14,170.12,170.11,170.09,170.07,170.05,170.03,170.0,169.98,169.95,169.93,169.9,169.87,169.84,169.81,169.78,169.74,169.71,169.67,169.63,169.59,169.55,169.51,169.46,169.42,169.37,169.32,169.27,169.22,169.16,169.1,169.05,168.99,168.93,168.86,168.8,168.73,168.66,168.59,168.51,168.44,168.36,168.28,168.19,168.11,168.02,167.93,167.84,167.74,167.64,167.54,167.44,167.33,167.22,167.11,166.99,166.87,166.75,166.62,166.49,166.36,166.22,166.08,165.93,165.78,165.63,165.47,165.31,165.14,164.97,164.79,164.61,164.42,164.22,164.03,},
{164.87,165.08,165.27,165.47,165.65,165.83,166.01,166.18,166.35,166.51,166.67,166.82,166.97,167.11,167.25,167.39,167.52,167.65,167.77,167.9,168.01,168.13,168.24,168.35,168.46,168.56,168.66,168.76,168.85,168.95,169.04,169.12,169.21,169.29,169.37,169.45,169.52,169.6,169.67,169.74,169.81,169.87,169.94,170.0,170.06,170.11,170.17,170.23,170.28,170.33,170.38,170.43,170.47,170.52,170.56,170.6,170.64,170.68,170.72,170.76,170.79,170.82,170.86,170.89,170.92,170.94,170.97,171.0,171.02,171.05,171.07,171.09,171.11,171.13,171.15,171.17,171.18,171.2,171.21,171.23,171.24,171.25,171.26,171.27,171.28,171.29,171.29,171.3,171.3,171.31,171.31,171.32,171.32,171.32,171.32,171.32,171.32,171.32,171.31,171.31,171.31,171.3,171.3,171.29,171.29,171.28,171.27,171.27,171.26,171.25,171.24,171.23,171.22,171.21,171.2,171.18,171.17,171.16,171.14,171.13,171.12,171.1,171.09,171.07,171.06,171.04,171.02,171.01,170.99,170.97,170.96,170.94,170.92,170.9,170.89,170.87,170.85,170.83,170.81,170.79,170.77,170.75,170.74,170.72,170.7,170.68,170.66,170.64,170.62,170.6,170.58,170.56,170.55,170.53,170.51,170.49,170.47,170.46,170.44,170.42,170.4,170.39,170.37,170.36,170.34,170.32,170.31,170.3,170.28,170.27,170.26,170.24,170.23,170.22,170.21,170.2,170.19,170.18,170.17,170.17,170.16,170.15,170.15,170.14,170.14,170.14,170.13,170.13,170.13,170.13,170.13,170.13,170.13,170.13,170.14,170.14,170.15,170.15,170.16,170.17,170.17,170.18,170.19,170.2,170.21,170.22,170.23,170.24,170.25,170.27,170.28,170.29,170.31,170.32,170.34,170.35,170.37,170.38,170.4,170.42,170.44,170.45,170.47,170.49,170.51,170.52,170.54,170.56,170.58,170.6,170.62,170.64,170.66,170.68,170.69,170.71,170.73,170.75,170.77,170.79,170.81,170.83,170.85,170.86,170.88,170.9,170.92,170.94,170.95,170.97,170.99,171.01,171.02,171.04,171.05,171.07,171.09,171.1,171.11,171.13,171.14,171.16,171.17,171.18,171.19,171.21,171.22,171.23,171.24,171.25,171.26,171.26,171.27,171.28,171.29,171.29,171.3,171.3,171.31,171.31,171.31,171.32,171.32,171.32,171.32,171.32,171.32,171.32,171.31,171.31,171.3,171.3,171.29,171.29,171.28,171.27,171.26,171.25,171.24,171.23,171.21,171.2,171.18,171.17,171.15,171.13,171.11,171.09,171.07,171.05,171.03,171.0,170.98,170.95,170.92,170.89,170.86,170.83,170.8,170.76,170.72,170.69,170.65,170.61,170.57,170.52,170.48,170.43,170.39,170.34,170.29,170.23,170.18,170.12,170.07,170.01,169.94,169.88,169.82,169.75,169.68,169.61,169.54,169.46,169.38,169.3,169.22,169.14,169.05,168.96,168.87,168.77,168.68,168.58,168.47,168.37,168.26,168.15,168.03,167.91,167.79,167.67,167.54,167.41,167.27,167.13,166.99,166.84,166.69,166.53,166.37,166.21,166.04,165.86,165.68,165.49,},
{166.34,166.53,166.72,166.89,167.07,167.24,167.4,167.56,167.71,167.86,168.01,168.15,168.29,168.42,168.55,168.68,168.8,168.92,169.04,169.16,169.27,169.37,169.48,169.58,169.68,169.77,169.87,169.96,170.05,170.13,170.22,170.3,170.38,170.46,170.53,170.6,170.67,170.74,170.81,170.87,170.94,171.0,171.06,171.11,171.17,171.22,171.28,171.33,171.38,171.42,171.47,171.52,171.56,171.6,171.64,171.68,171.72,171.75,171.79,171.82,171.86,171.89,171.92,171.95,171.97,172.0,172.02,172.05,172.07,172.09,172.12,172.14,172.15,172.17,172.19,172.21,172.22,172.23,172.25,172.26,172.27,172.28,172.29,172.3,172.31,172.32,172.32,172.33,172.33,172.34,172.34,172.34,172.34,172.34,172.35,172.35,172.34,172.34,172.34,172.34,172.33,172.33,172.32,172.32,172.31,172.31,172.3,172.29,172.28,172.28,172.27,172.26,172.25,172.24,172.23,172.21,172.2,172.19,172.18,172.16,172.15,172.14,172.12,172.11,172.09,172.08,172.06,172.05,172.03,172.02,172.0,171.98,171.97,171.95,171.93,171.91,171.9,171.88,171.86,171.84,171.83,171.81,171.79,171.77,171.75,171.73,171.72,171.7,171.68,171.66,171.64,171.63,171.61,171.59,171.57,171.56,171.54,171.52,171.51,171.49,171.47,171.46,171.44,171.43,171.41,171.4,171.39,171.37,171.36,171.35,171.33,171.32,171.31,171.3,171.29,171.28,171.27,171.26,171.26,171.25,171.24,171.24,171.23,171.23,171.22,171.22,171.22,171.22,171.21,171.21,171.21,171.21,171.22,171.22,171.22,171.23,171.23,171.24,171.24,171.25,171.25,171.26,171.27,171.28,171.29,171.3,171.31,171.32,171.33,171.34,171.36,171.37,171.38,171.4,171.41,171.43,171.44,171.46,171.47,171.49,171.5,171.52,171.54,171.55,171.57,171.59,171.61,171.62,171.64,171.66,171.68,171.7,171.71,171.73,171.75,171.77,171.79,171.8,171.82,171.84,171.86,171.88,171.89,171.91,171.93,171.95,171.96,171.98,172.0,172.01,172.03,172.05,172.06,172.08,172.09,172.11,172.12,172.14,172.15,172.16,172.18,172.19,172.2,172.21,172.22,172.24,172.25,172.26,172.27,172.27,172.28,172.29,172.3,172.31,172.31,172.32,172.32,172.33,172.33,172.34,172.34,172.34,172.34,172.34,172.35,172.35,172.34,172.34,172.34,172.34,172.33,172.33,172.32,172.32,172.31,172.3,172.29,172.28,172.27,172.26,172.25,172.24,172.22,172.21,172.19,172.17,172.16,172.14,172.12,172.1,172.08,172.05,172.03,172.0,171.98,171.95,171.92,171.89,171.86,171.83,171.79,171.76,171.72,171.69,171.65,171.61,171.57,171.52,171.48,171.43,171.38,171.34,171.28,171.23,171.18,171.12,171.07,171.01,170.95,170.88,170.82,170.75,170.68,170.61,170.54,170.47,170.39,170.31,170.23,170.15,170.06,169.97,169.88,169.79,169.69,169.59,169.49,169.39,169.28,169.17,169.06,168.94,168.82,168.7,168.57,168.44,168.31,168.17,168.03,167.89,167.74,167.58,167.42,167.26,167.09,166.92,},
{167.77,167.94,168.12,168.28,168.44,168.6,168.75,168.9,169.04,169.18,169.32,169.45,169.58,169.7,169.82,169.94,170.06,170.17,170.28,170.38,170.48,170.58,170.68,170.78,170.87,170.96,171.05,171.13,171.21,171.29,171.37,171.45,171.52,171.59,171.66,171.73,171.8,171.86,171.92,171.98,172.04,172.1,172.15,172.21,172.26,172.31,172.36,172.41,172.45,172.5,172.54,172.58,172.62,172.66,172.7,172.73,172.77,172.8,172.83,172.87,172.9,172.93,172.95,172.98,173.01,173.03,173.05,173.08,173.1,173.12,173.14,173.16,173.17,173.19,173.21,173.22,173.24,173.25,173.26,173.27,173.28,173.29,173.3,173.31,173.32,173.32,173.33,173.33,173.34,173.34,173.35,173.35,173.35,173.35,173.35,173.35,173.35,173.35,173.34,173.34,173.34,173.33,173.33,173.32,173.32,173.31,173.31,173.3,173.29,173.28,173.27,173.27,173.26,173.25,173.24,173.22,173.21,173.2,173.19,173.18,173.16,173.15,173.14,173.12,173.11,173.1,173.08,173.07,173.05,173.04,173.02,173.0,172.99,172.97,172.96,172.94,172.92,172.91,172.89,172.87,172.86,172.84,172.82,172.8,172.79,172.77,172.75,172.74,172.72,172.7,172.68,172.67,172.65,172.63,172.62,172.6,172.59,172.57,172.55,172.54,172.52,172.51,172.49,172.48,172.47,172.45,172.44,172.43,172.41,172.4,172.39,172.38,172.37,172.36,172.35,172.34,172.33,172.32,172.32,172.31,172.3,172.3,172.29,172.29,172.28,172.28,172.28,172.28,172.28,172.28,172.28,172.28,172.28,172.28,172.28,172.29,172.29,172.3,172.3,172.31,172.32,172.32,172.33,172.34,172.35,172.36,172.37,172.38,172.39,172.4,172.41,172.42,172.44,172.45,172.46,172.48,172.49,172.51,172.52,172.54,172.55,172.57,172.58,172.6,172.62,172.63,172.65,172.67,172.68,172.7,172.72,172.73,172.75,172.77,172.78,172.8,172.82,172.84,172.85,172.87,172.89,172.9,172.92,172.94,172.95,172.97,172.99,173.0,173.02,173.03,173.05,173.06,173.08,173.09,173.11,173.12,173.14,173.15,173.16,173.18,173.19,173.2,173.21,173.22,173.23,173.24,173.25,173.26,173.27,173.28,173.29,173.3,173.31,173.31,173.32,173.32,173.33,173.33,173.34,173.34,173.34,173.35,173.35,173.35,173.35,173.35,173.35,173.35,173.35,173.34,173.34,173.34,173.33,173.32,173.32,173.31,173.3,173.29,173.28,173.27,173.26,173.25,173.24,173.22,173.21,173.19,173.18,173.16,173.14,173.12,173.1,173.08,173.06,173.03,173.01,172.98,172.96,172.93,172.9,172.87,172.84,172.81,172.77,172.74,172.7,172.67,172.63,172.59,172.54,172.5,172.46,172.41,172.37,172.32,172.27,172.21,172.16,172.11,172.05,171.99,171.93,171.87,171.81,171.74,171.67,171.6,171.53,171.46,171.38,171.31,171.23,171.14,171.06,170.97,170.88,170.79,170.7,170.6,170.5,170.4,170.29,170.18,170.07,169.96,169.84,169.72,169.6,169.47,169.34,169.2,169.06,168.92,168.77,168.62,168.47,168.3,},
{169.15,169.32,169.47,169.63,169.78,169.92,170.06,170.2,170.33,170.46,170.59,170.71,170.83,170.95,171.06,171.17,171.27,171.38,171.48,171.58,171.67,171.77,171.86,171.94,172.03,172.11,172.19,172.27,172.35,172.42,172.5,172.57,172.64,172.7,172.77,172.83,172.89,172.95,173.01,173.07,173.12,173.17,173.22,173.27,173.32,173.37,173.41,173.46,173.5,173.54,173.58,173.62,173.66,173.69,173.73,173.76,173.8,173.83,173.86,173.89,173.92,173.94,173.97,173.99,174.02,174.04,174.06,174.08,174.1,174.12,174.14,174.16,174.17,174.19,174.2,174.22,174.23,174.24,174.25,174.26,174.27,174.28,174.29,174.3,174.3,174.31,174.32,174.32,174.32,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.32,174.32,174.31,174.31,174.3,174.3,174.29,174.28,174.28,174.27,174.26,174.25,174.24,174.23,174.22,174.21,174.2,174.19,174.18,174.17,174.16,174.14,174.13,174.12,174.11,174.09,174.08,174.06,174.05,174.04,174.02,174.01,173.99,173.98,173.96,173.94,173.93,173.91,173.9,173.88,173.87,173.85,173.83,173.82,173.8,173.78,173.77,173.75,173.74,173.72,173.7,173.69,173.67,173.66,173.64,173.63,173.61,173.6,173.58,173.57,173.55,173.54,173.52,173.51,173.5,173.49,173.47,173.46,173.45,173.44,173.43,173.42,173.41,173.4,173.39,173.38,173.37,173.36,173.36,173.35,173.34,173.34,173.33,173.33,173.33,173.32,173.32,173.32,173.32,173.32,173.32,173.32,173.32,173.32,173.33,173.33,173.33,173.34,173.34,173.35,173.36,173.36,173.37,173.38,173.39,173.4,173.4,173.41,173.42,173.44,173.45,173.46,173.47,173.48,173.5,173.51,173.52,173.54,173.55,173.56,173.58,173.59,173.61,173.62,173.64,173.65,173.67,173.69,173.7,173.72,173.73,173.75,173.77,173.78,173.8,173.81,173.83,173.85,173.86,173.88,173.9,173.91,173.93,173.94,173.96,173.97,173.99,174.0,174.02,174.03,174.05,174.06,174.08,174.09,174.1,174.12,174.13,174.14,174.16,174.17,174.18,174.19,174.2,174.21,174.22,174.23,174.24,174.25,174.26,174.27,174.28,174.28,174.29,174.3,174.3,174.31,174.31,174.32,174.32,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.33,174.32,174.32,174.31,174.31,174.3,174.29,174.28,174.27,174.27,174.25,174.24,174.23,174.22,174.21,174.19,174.18,174.16,174.14,174.12,174.11,174.09,174.06,174.04,174.02,174.0,173.97,173.95,173.92,173.89,173.86,173.83,173.8,173.77,173.73,173.7,173.66,173.63,173.59,173.55,173.51,173.46,173.42,173.38,173.33,173.28,173.23,173.18,173.13,173.07,173.02,172.96,172.9,172.84,172.78,172.71,172.65,172.58,172.51,172.44,172.36,172.28,172.21,172.13,172.04,171.96,171.87,171.78,171.69,171.59,171.49,171.39,171.29,171.18,171.07,170.96,170.85,170.73,170.61,170.48,170.35,170.22,170.08,169.94,169.8,169.65,},
{170.5,170.65,170.79,170.94,171.07,171.21,171.34,171.47,171.59,171.71,171.83,171.94,172.05,172.16,172.26,172.36,172.46,172.56,172.65,172.74,172.83,172.92,173.0,173.08,173.16,173.24,173.31,173.39,173.46,173.53,173.6,173.66,173.72,173.79,173.85,173.91,173.96,174.02,174.07,174.12,174.17,174.22,174.27,174.32,174.36,174.41,174.45,174.49,174.53,174.57,174.6,174.64,174.67,174.71,174.74,174.77,174.8,174.83,174.86,174.89,174.91,174.94,174.96,174.98,175.01,175.03,175.05,175.07,175.09,175.1,175.12,175.14,175.15,175.17,175.18,175.19,175.2,175.21,175.23,175.23,175.24,175.25,175.26,175.27,175.27,175.28,175.28,175.29,175.29,175.29,175.3,175.3,175.3,175.3,175.3,175.3,175.3,175.3,175.29,175.29,175.29,175.28,175.28,175.27,175.27,175.26,175.26,175.25,175.24,175.24,175.23,175.22,175.21,175.2,175.19,175.18,175.17,175.16,175.15,175.14,175.13,175.12,175.11,175.09,175.08,175.07,175.06,175.04,175.03,175.02,175.0,174.99,174.97,174.96,174.94,174.93,174.92,174.9,174.89,174.87,174.86,174.84,174.82,174.81,174.79,174.78,174.76,174.75,174.73,174.72,174.7,174.69,174.67,174.66,174.64,174.63,174.62,174.6,174.59,174.57,174.56,174.55,174.53,174.52,174.51,174.5,174.49,174.47,174.46,174.45,174.44,174.43,174.42,174.41,174.4,174.4,174.39,174.38,174.38,174.37,174.36,174.36,174.35,174.35,174.35,174.34,174.34,174.34,174.34,174.34,174.34,174.34,174.34,174.34,174.35,174.35,174.35,174.36,174.36,174.37,174.37,174.38,174.39,174.4,174.4,174.41,174.42,174.43,174.44,174.45,174.46,174.47,174.48,174.5,174.51,174.52,174.53,174.55,174.56,174.57,174.59,174.6,174.61,174.63,174.64,174.66,174.67,174.69,174.7,174.72,174.73,174.75,174.76,174.78,174.79,174.81,174.82,174.84,174.85,174.87,174.88,174.9,174.91,174.93,174.94,174.96,174.97,174.99,175.0,175.01,175.03,175.04,175.05,175.07,175.08,175.09,175.1,175.12,175.13,175.14,175.15,175.16,175.17,175.18,175.19,175.2,175.21,175.22,175.23,175.24,175.24,175.25,175.26,175.26,175.27,175.27,175.28,175.28,175.29,175.29,175.29,175.3,175.3,175.3,175.3,175.3,175.3,175.3,175.3,175.29,175.29,175.29,175.28,175.28,175.27,175.27,175.26,175.25,175.24,175.24,175.23,175.22,175.21,175.19,175.18,175.17,175.15,175.14,175.12,175.11,175.09,175.07,175.05,175.03,175.01,174.99,174.96,174.94,174.92,174.89,174.86,174.83,174.81,174.78,174.74,174.71,174.68,174.64,174.61,174.57,174.53,174.49,174.45,174.41,174.37,174.32,174.28,174.23,174.18,174.13,174.08,174.03,173.97,173.91,173.86,173.8,173.73,173.67,173.61,173.54,173.47,173.4,173.33,173.25,173.17,173.09,173.01,172.93,172.84,172.76,172.66,172.57,172.48,172.38,172.28,172.17,172.07,171.96,171.84,171.73,171.61,171.48,171.36,171.23,171.09,170.96,},
{171.8,171.94,172.08,172.21,172.34,172.46,172.58,172.7,172.81,172.92,173.03,173.14,173.24,173.34,173.43,173.53,173.62,173.71,173.79,173.88,173.96,174.04,174.12,174.19,174.27,174.34,174.41,174.48,174.54,174.61,174.67,174.73,174.79,174.84,174.9,174.95,175.01,175.06,175.11,175.16,175.2,175.25,175.29,175.34,175.38,175.42,175.46,175.49,175.53,175.57,175.6,175.63,175.67,175.7,175.73,175.76,175.79,175.81,175.84,175.86,175.89,175.91,175.93,175.95,175.97,175.99,176.01,176.03,176.05,176.06,176.08,176.09,176.11,176.12,176.13,176.15,176.16,176.17,176.18,176.19,176.19,176.2,176.21,176.21,176.22,176.23,176.23,176.23,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.23,176.23,176.22,176.22,176.22,176.21,176.2,176.2,176.19,176.18,176.18,176.17,176.16,176.15,176.14,176.13,176.12,176.12,176.11,176.09,176.08,176.07,176.06,176.05,176.04,176.03,176.01,176.0,175.99,175.98,175.96,175.95,175.94,175.92,175.91,175.9,175.88,175.87,175.85,175.84,175.83,175.81,175.8,175.78,175.77,175.75,175.74,175.73,175.71,175.7,175.68,175.67,175.66,175.64,175.63,175.61,175.6,175.59,175.57,175.56,175.55,175.54,175.52,175.51,175.5,175.49,175.48,175.47,175.46,175.45,175.44,175.43,175.42,175.41,175.4,175.39,175.39,175.38,175.37,175.37,175.36,175.36,175.35,175.35,175.35,175.35,175.34,175.34,175.34,175.34,175.34,175.34,175.34,175.35,175.35,175.35,175.35,175.36,175.36,175.37,175.37,175.38,175.39,175.39,175.4,175.41,175.42,175.43,175.44,175.45,175.46,175.47,175.48,175.49,175.5,175.51,175.52,175.53,175.55,175.56,175.57,175.59,175.6,175.61,175.63,175.64,175.65,175.67,175.68,175.7,175.71,175.72,175.74,175.75,175.77,175.78,175.8,175.81,175.82,175.84,175.85,175.87,175.88,175.89,175.91,175.92,175.93,175.95,175.96,175.97,175.99,176.0,176.01,176.02,176.04,176.05,176.06,176.07,176.08,176.09,176.1,176.11,176.12,176.13,176.14,176.15,176.16,176.17,176.18,176.18,176.19,176.2,176.2,176.21,176.21,176.22,176.22,176.23,176.23,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.24,176.23,176.23,176.23,176.22,176.22,176.21,176.2,176.2,176.19,176.18,176.17,176.16,176.15,176.14,176.12,176.11,176.1,176.08,176.07,176.05,176.03,176.02,176.0,175.98,175.96,175.94,175.91,175.89,175.87,175.84,175.82,175.79,175.76,175.73,175.7,175.67,175.64,175.61,175.57,175.54,175.5,175.46,175.42,175.38,175.34,175.3,175.26,175.21,175.16,175.12,175.07,175.02,174.96,174.91,174.85,174.8,174.74,174.68,174.61,174.55,174.49,174.42,174.35,174.28,174.2,174.13,174.05,173.97,173.89,173.81,173.72,173.63,173.54,173.45,173.35,173.25,173.15,173.05,172.94,172.83,172.71,172.6,172.48,172.36,172.23,},
{173.08,173.2,173.33,173.45,173.56,173.68,173.79,173.9,174.0,174.1,174.2,174.3,174.39,174.49,174.58,174.66,174.75,174.83,174.91,174.99,175.06,175.14,175.21,175.28,175.35,175.41,175.48,175.54,175.6,175.66,175.72,175.77,175.83,175.88,175.93,175.98,176.03,176.08,176.12,176.17,176.21,176.25,176.29,176.33,176.37,176.41,176.44,176.48,176.51,176.55,176.58,176.61,176.64,176.67,176.7,176.72,176.75,176.77,176.8,176.82,176.84,176.86,176.88,176.9,176.92,176.94,176.96,176.98,176.99,177.01,177.02,177.03,177.05,177.06,177.07,177.08,177.09,177.1,177.11,177.12,177.13,177.13,177.14,177.14,177.15,177.15,177.16,177.16,177.16,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.16,177.16,177.16,177.16,177.15,177.15,177.14,177.14,177.13,177.13,177.12,177.11,177.11,177.1,177.09,177.08,177.08,177.07,177.06,177.05,177.04,177.03,177.02,177.01,177.0,176.99,176.98,176.97,176.95,176.94,176.93,176.92,176.91,176.89,176.88,176.87,176.86,176.84,176.83,176.82,176.8,176.79,176.78,176.76,176.75,176.74,176.72,176.71,176.7,176.68,176.67,176.66,176.64,176.63,176.62,176.6,176.59,176.58,176.57,176.55,176.54,176.53,176.52,176.51,176.5,176.48,176.47,176.46,176.45,176.44,176.43,176.42,176.41,176.4,176.4,176.39,176.38,176.37,176.37,176.36,176.35,176.35,176.34,176.34,176.34,176.33,176.33,176.33,176.33,176.32,176.32,176.32,176.32,176.32,176.33,176.33,176.33,176.33,176.34,176.34,176.34,176.35,176.35,176.36,176.37,176.37,176.38,176.39,176.4,176.4,176.41,176.42,176.43,176.44,176.45,176.46,176.47,176.48,176.49,176.5,176.52,176.53,176.54,176.55,176.56,176.58,176.59,176.6,176.62,176.63,176.64,176.66,176.67,176.68,176.7,176.71,176.72,176.74,176.75,176.76,176.78,176.79,176.8,176.82,176.83,176.84,176.85,176.87,176.88,176.89,176.9,176.92,176.93,176.94,176.95,176.96,176.97,176.99,177.0,177.01,177.02,177.03,177.04,177.05,177.06,177.07,177.07,177.08,177.09,177.1,177.11,177.11,177.12,177.13,177.13,177.14,177.14,177.15,177.15,177.16,177.16,177.16,177.16,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.17,177.16,177.16,177.16,177.15,177.15,177.14,177.14,177.13,177.13,177.12,177.11,177.1,177.09,177.08,177.07,177.06,177.05,177.04,177.02,177.01,176.99,176.98,176.96,176.94,176.93,176.91,176.89,176.87,176.85,176.82,176.8,176.78,176.75,176.73,176.7,176.67,176.64,176.61,176.58,176.55,176.52,176.49,176.45,176.41,176.38,176.34,176.3,176.26,176.22,176.17,176.13,176.08,176.04,175.99,175.94,175.89,175.83,175.78,175.72,175.67,175.61,175.55,175.48,175.42,175.36,175.29,175.22,175.15,175.07,175.0,174.92,174.84,174.76,174.67,174.59,174.5,174.41,174.31,174.22,174.12,174.02,173.91,173.81,173.7,173.58,173.47,},
{174.31,174.43,174.54,174.65,174.76,174.87,174.97,175.07,175.16,175.26,175.35,175.44,175.52,175.61,175.69,175.77,175.85,175.92,176.0,176.07,176.14,176.21,176.27,176.34,176.4,176.46,176.52,176.58,176.63,176.69,176.74,176.79,176.84,176.89,176.94,176.98,177.03,177.07,177.11,177.16,177.2,177.23,177.27,177.31,177.34,177.38,177.41,177.44,177.48,177.51,177.53,177.56,177.59,177.62,177.64,177.67,177.69,177.71,177.74,177.76,177.78,177.8,177.82,177.83,177.85,177.87,177.88,177.9,177.91,177.93,177.94,177.95,177.97,177.98,177.99,178.0,178.01,178.02,178.02,178.03,178.04,178.04,178.05,178.06,178.06,178.06,178.07,178.07,178.07,178.08,178.08,178.08,178.08,178.08,178.08,178.08,178.08,178.07,178.07,178.07,178.07,178.06,178.06,178.06,178.05,178.05,178.04,178.04,178.03,178.02,178.02,178.01,178.0,178.0,177.99,177.98,177.97,177.96,177.95,177.95,177.94,177.93,177.92,177.91,177.9,177.89,177.88,177.86,177.85,177.84,177.83,177.82,177.81,177.8,177.78,177.77,177.76,177.75,177.74,177.72,177.71,177.7,177.69,177.67,177.66,177.65,177.64,177.62,177.61,177.6,177.59,177.57,177.56,177.55,177.54,177.53,177.51,177.5,177.49,177.48,177.47,177.46,177.45,177.44,177.43,177.42,177.41,177.4,177.39,177.38,177.37,177.36,177.36,177.35,177.34,177.33,177.33,177.32,177.32,177.31,177.31,177.3,177.3,177.3,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.29,177.3,177.3,177.31,177.31,177.32,177.32,177.33,177.33,177.34,177.35,177.35,177.36,177.37,177.38,177.39,177.4,177.41,177.42,177.43,177.44,177.45,177.46,177.47,177.48,177.49,177.5,177.51,177.52,177.54,177.55,177.56,177.57,177.58,177.6,177.61,177.62,177.63,177.65,177.66,177.67,177.68,177.7,177.71,177.72,177.73,177.75,177.76,177.77,177.78,177.79,177.81,177.82,177.83,177.84,177.85,177.86,177.87,177.88,177.89,177.91,177.92,177.93,177.93,177.94,177.95,177.96,177.97,177.98,177.99,178.0,178.0,178.01,178.02,178.02,178.03,178.04,178.04,178.05,178.05,178.06,178.06,178.06,178.07,178.07,178.07,178.07,178.08,178.08,178.08,178.08,178.08,178.08,178.08,178.08,178.07,178.07,178.07,178.06,178.06,178.06,178.05,178.04,178.04,178.03,178.02,178.02,178.01,178.0,177.99,177.98,177.97,177.96,177.94,177.93,177.92,177.9,177.89,177.87,177.85,177.84,177.82,177.8,177.78,177.76,177.74,177.72,177.69,177.67,177.65,177.62,177.59,177.57,177.54,177.51,177.48,177.45,177.42,177.38,177.35,177.31,177.28,177.24,177.2,177.16,177.12,177.08,177.04,176.99,176.94,176.9,176.85,176.8,176.75,176.69,176.64,176.58,176.53,176.47,176.41,176.35,176.28,176.22,176.15,176.08,176.01,175.93,175.86,175.78,175.7,175.62,175.54,175.45,175.36,175.27,175.18,175.08,174.98,174.88,174.78,174.67,},
{175.51,175.62,175.73,175.83,175.93,176.02,176.11,176.21,176.29,176.38,176.46,176.55,176.62,176.7,176.78,176.85,176.92,176.99,177.06,177.12,177.19,177.25,177.31,177.37,177.43,177.48,177.54,177.59,177.64,177.69,177.74,177.79,177.83,177.88,177.92,177.96,178.01,178.05,178.08,178.12,178.16,178.19,178.23,178.26,178.3,178.33,178.36,178.39,178.42,178.44,178.47,178.5,178.52,178.55,178.57,178.59,178.61,178.64,178.66,178.68,178.69,178.71,178.73,178.75,178.76,178.78,178.79,178.81,178.82,178.83,178.84,178.86,178.87,178.88,178.89,178.9,178.9,178.91,178.92,178.93,178.93,178.94,178.94,178.95,178.95,178.96,178.96,178.96,178.96,178.97,178.97,178.97,178.97,178.97,178.97,178.97,178.97,178.97,178.96,178.96,178.96,178.96,178.95,178.95,178.94,178.94,178.93,178.93,178.92,178.92,178.91,178.91,178.9,178.89,178.88,178.88,178.87,178.86,178.85,178.84,178.84,178.83,178.82,178.81,178.8,178.79,178.78,178.77,178.76,178.75,178.74,178.73,178.72,178.71,178.69,178.68,178.67,178.66,178.65,178.64,178.63,178.61,178.6,178.59,178.58,178.57,178.56,178.54,178.53,178.52,178.51,178.5,178.49,178.48,178.47,178.45,178.44,178.43,178.42,178.41,178.4,178.39,178.38,178.37,178.36,178.35,178.34,178.33,178.33,178.32,178.31,178.3,178.3,178.29,178.28,178.28,178.27,178.26,178.26,178.25,178.25,178.25,178.24,178.24,178.24,178.23,178.23,178.23,178.23,178.23,178.23,178.23,178.23,178.23,178.24,178.24,178.24,178.25,178.25,178.25,178.26,178.26,178.27,178.27,178.28,178.29,178.29,178.3,178.31,178.32,178.33,178.33,178.34,178.35,178.36,178.37,178.38,178.39,178.4,178.41,178.42,178.43,178.44,178.45,178.46,178.47,178.49,178.5,178.51,178.52,178.53,178.54,178.55,178.57,178.58,178.59,178.6,178.61,178.62,178.64,178.65,178.66,178.67,178.68,178.69,178.7,178.71,178.73,178.74,178.75,178.76,178.77,178.78,178.79,178.8,178.81,178.82,178.83,178.83,178.84,178.85,178.86,178.87,178.88,178.88,178.89,178.9,178.9,178.91,178.92,178.92,178.93,178.93,178.94,178.94,178.95,178.95,178.95,178.96,178.96,178.96,178.96,178.97,178.97,178.97,178.97,178.97,178.97,178.97,178.97,178.96,178.96,178.96,178.96,178.95,178.95,178.94,178.94,178.93,178.93,178.92,178.91,178.91,178.9,178.89,178.88,178.87,178.86,178.85,178.83,178.82,178.81,178.79,178.78,178.76,178.75,178.73,178.71,178.7,178.68,178.66,178.64,178.62,178.6,178.57,178.55,178.53,178.5,178.47,178.45,178.42,178.39,178.36,178.33,178.3,178.27,178.23,178.2,178.16,178.13,178.09,178.05,178.01,177.97,177.93,177.89,177.84,177.79,177.75,177.7,177.65,177.6,177.55,177.49,177.44,177.38,177.32,177.26,177.2,177.13,177.07,177.0,176.93,176.86,176.79,176.71,176.64,176.56,176.48,176.39,176.31,176.22,176.13,176.04,175.94,175.84,},
{176.68,176.78,176.88,176.97,177.06,177.15,177.23,177.32,177.4,177.48,177.55,177.63,177.7,177.77,177.84,177.9,177.97,178.03,178.09,178.15,178.21,178.27,178.33,178.38,178.43,178.48,178.53,178.58,178.63,178.67,178.72,178.76,178.8,178.85,178.89,178.92,178.96,179.0,179.03,179.07,179.1,179.13,179.17,179.2,179.23,179.26,179.28,179.31,179.34,179.36,179.39,179.41,179.43,179.46,179.48,179.5,179.52,179.54,179.56,179.57,179.59,179.61,179.62,179.64,179.65,179.67,179.68,179.69,179.71,179.72,179.73,179.74,179.75,179.76,179.77,179.78,179.78,179.79,179.8,179.8,179.81,179.81,179.82,179.82,179.83,179.83,179.83,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.83,179.83,179.83,179.83,179.82,179.82,179.81,179.81,179.8,179.8,179.79,179.79,179.78,179.78,179.77,179.76,179.76,179.75,179.74,179.73,179.73,179.72,179.71,179.7,179.69,179.68,179.67,179.67,179.66,179.65,179.64,179.63,179.62,179.61,179.6,179.59,179.58,179.57,179.56,179.55,179.53,179.52,179.51,179.5,179.49,179.48,179.47,179.46,179.45,179.44,179.43,179.42,179.41,179.4,179.39,179.38,179.36,179.35,179.34,179.34,179.33,179.32,179.31,179.3,179.29,179.28,179.27,179.26,179.25,179.25,179.24,179.23,179.22,179.22,179.21,179.21,179.2,179.19,179.19,179.18,179.18,179.18,179.17,179.17,179.17,179.16,179.16,179.16,179.16,179.16,179.16,179.16,179.16,179.16,179.16,179.16,179.17,179.17,179.17,179.18,179.18,179.18,179.19,179.19,179.2,179.2,179.21,179.22,179.22,179.23,179.24,179.25,179.25,179.26,179.27,179.28,179.29,179.3,179.31,179.31,179.32,179.33,179.34,179.35,179.36,179.37,179.38,179.39,179.4,179.42,179.43,179.44,179.45,179.46,179.47,179.48,179.49,179.5,179.51,179.52,179.53,179.54,179.55,179.56,179.57,179.59,179.6,179.61,179.62,179.63,179.64,179.65,179.65,179.66,179.67,179.68,179.69,179.7,179.71,179.72,179.72,179.73,179.74,179.75,179.76,179.76,179.77,179.78,179.78,179.79,179.79,179.8,179.8,179.81,179.81,179.82,179.82,179.83,179.83,179.83,179.83,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.84,179.83,179.83,179.83,179.82,179.82,179.82,179.81,179.8,179.8,179.79,179.78,179.78,179.77,179.76,179.75,179.74,179.73,179.72,179.71,179.7,179.68,179.67,179.66,179.64,179.63,179.61,179.59,179.58,179.56,179.54,179.52,179.5,179.48,179.46,179.44,179.41,179.39,179.37,179.34,179.31,179.29,179.26,179.23,179.2,179.17,179.14,179.11,179.07,179.04,179.0,178.97,178.93,178.89,178.85,178.81,178.77,178.73,178.68,178.64,178.59,178.54,178.49,178.44,178.39,178.33,178.28,178.22,178.16,178.1,178.04,177.98,177.91,177.85,177.78,177.71,177.64,177.56,177.49,177.41,177.33,177.25,177.16,177.07,176.98,},
{177.82,177.91,178.0,178.08,178.17,178.25,178.32,178.4,178.47,178.54,178.61,178.68,178.75,178.81,178.87,178.93,178.99,179.05,179.11,179.16,179.22,179.27,179.32,179.37,179.41,179.46,179.51,179.55,179.59,179.64,179.68,179.72,179.75,179.79,179.83,179.86,179.9,179.93,179.96,179.99,180.03,180.05,180.08,180.11,180.14,180.17,180.19,180.22,180.24,180.26,180.29,180.31,180.33,180.35,180.37,180.39,180.4,180.42,180.44,180.46,180.47,180.49,180.5,180.51,180.53,180.54,180.55,180.56,180.58,180.59,180.6,180.61,180.61,180.62,180.63,180.64,180.65,180.65,180.66,180.66,180.67,180.67,180.68,180.68,180.69,180.69,180.69,180.69,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.69,180.69,180.69,180.69,180.68,180.68,180.68,180.67,180.67,180.66,180.66,180.65,180.65,180.64,180.64,180.63,180.63,180.62,180.61,180.61,180.6,180.59,180.58,180.58,180.57,180.56,180.55,180.54,180.54,180.53,180.52,180.51,180.5,180.49,180.48,180.47,180.46,180.45,180.44,180.43,180.42,180.41,180.4,180.39,180.39,180.38,180.37,180.36,180.35,180.34,180.33,180.32,180.31,180.3,180.29,180.28,180.27,180.26,180.25,180.24,180.23,180.22,180.21,180.2,180.2,180.19,180.18,180.17,180.16,180.16,180.15,180.14,180.14,180.13,180.12,180.12,180.11,180.11,180.1,180.1,180.09,180.09,180.08,180.08,180.08,180.08,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.07,180.08,180.08,180.08,180.09,180.09,180.1,180.1,180.11,180.11,180.12,180.12,180.13,180.13,180.14,180.15,180.16,180.16,180.17,180.18,180.19,180.19,180.2,180.21,180.22,180.23,180.24,180.25,180.26,180.27,180.28,180.29,180.3,180.3,180.31,180.32,180.33,180.34,180.35,180.36,180.37,180.38,180.39,180.4,180.41,180.42,180.43,180.44,180.45,180.46,180.47,180.48,180.49,180.5,180.51,180.52,180.53,180.53,180.54,180.55,180.56,180.57,180.57,180.58,180.59,180.6,180.6,180.61,180.62,180.62,180.63,180.64,180.64,180.65,180.65,180.66,180.66,180.67,180.67,180.68,180.68,180.68,180.69,180.69,180.69,180.69,180.69,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.7,180.69,180.69,180.69,180.69,180.68,180.68,180.67,180.67,180.66,180.66,180.65,180.65,180.64,180.63,180.62,180.62,180.61,180.6,180.59,180.58,180.57,180.55,180.54,180.53,180.52,180.5,180.49,180.47,180.46,180.44,180.43,180.41,180.39,180.37,180.35,180.33,180.31,180.29,180.27,180.24,180.22,180.19,180.17,180.14,180.12,180.09,180.06,180.03,180.0,179.97,179.94,179.9,179.87,179.83,179.8,179.76,179.72,179.68,179.64,179.6,179.56,179.51,179.47,179.42,179.37,179.32,179.27,179.22,179.17,179.12,179.06,179.0,178.94,178.88,178.82,178.76,178.69,178.62,178.55,178.48,178.41,178.33,178.26,178.18,178.1,},
{178.94,179.02,179.09,179.17,179.24,179.32,179.39,179.46,179.52,179.59,179.65,179.71,179.77,179.83,179.89,179.94,179.99,180.05,180.1,180.15,180.19,180.24,180.29,180.33,180.38,180.42,180.46,180.5,180.54,180.58,180.61,180.65,180.68,180.72,180.75,180.78,180.81,180.84,180.87,180.9,180.93,180.96,180.98,181.01,181.03,181.06,181.08,181.1,181.12,181.14,181.16,181.18,181.2,181.22,181.24,181.26,181.27,181.29,181.3,181.32,181.33,181.35,181.36,181.37,181.39,181.4,181.41,181.42,181.43,181.44,181.45,181.46,181.46,181.47,181.48,181.49,181.49,181.5,181.5,181.51,181.51,181.52,181.52,181.52,181.53,181.53,181.53,181.53,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.53,181.53,181.53,181.53,181.52,181.52,181.52,181.51,181.51,181.51,181.5,181.5,181.49,181.49,181.48,181.48,181.47,181.47,181.46,181.45,181.45,181.44,181.43,181.43,181.42,181.41,181.4,181.4,181.39,181.38,181.37,181.36,181.36,181.35,181.34,181.33,181.32,181.31,181.3,181.3,181.29,181.28,181.27,181.26,181.25,181.24,181.23,181.22,181.21,181.21,181.2,181.19,181.18,181.17,181.16,181.15,181.14,181.14,181.13,181.12,181.11,181.1,181.09,181.09,181.08,181.07,181.06,181.06,181.05,181.04,181.04,181.03,181.02,181.02,181.01,181.01,181.0,181.0,180.99,180.99,180.98,180.98,180.98,180.97,180.97,180.97,180.96,180.96,180.96,180.96,180.96,180.96,180.96,180.96,180.96,180.96,180.96,180.97,180.97,180.97,180.97,180.98,180.98,180.99,180.99,180.99,181.0,181.0,181.01,181.02,181.02,181.03,181.03,181.04,181.05,181.05,181.06,181.07,181.08,181.08,181.09,181.1,181.11,181.12,181.13,181.13,181.14,181.15,181.16,181.17,181.18,181.19,181.2,181.2,181.21,181.22,181.23,181.24,181.25,181.26,181.27,181.28,181.29,181.29,181.3,181.31,181.32,181.33,181.34,181.35,181.35,181.36,181.37,181.38,181.39,181.4,181.4,181.41,181.42,181.42,181.43,181.44,181.45,181.45,181.46,181.46,181.47,181.48,181.48,181.49,181.49,181.5,181.5,181.51,181.51,181.51,181.52,181.52,181.52,181.53,181.53,181.53,181.53,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.54,181.53,181.53,181.53,181.53,181.52,181.52,181.52,181.51,181.51,181.5,181.5,181.49,181.49,181.48,181.47,181.46,181.46,181.45,181.44,181.43,181.42,181.41,181.4,181.39,181.38,181.36,181.35,181.34,181.32,181.31,181.29,181.28,181.26,181.24,181.22,181.21,181.19,181.17,181.15,181.13,181.1,181.08,181.06,181.04,181.01,180.99,180.96,180.93,180.91,180.88,180.85,180.82,180.79,180.75,180.72,180.69,180.65,180.62,180.58,180.54,180.5,180.46,180.42,180.38,180.34,180.29,180.25,180.2,180.15,180.1,180.05,180.0,179.95,179.89,179.84,179.78,179.72,179.66,179.6,179.53,179.47,179.4,179.33,179.26,179.18,},
{180.02,180.09,180.16,180.23,180.3,180.36,180.43,180.49,180.55,180.6,180.66,180.72,180.77,180.82,180.87,180.92,180.97,181.02,181.06,181.11,181.15,181.19,181.24,181.28,181.31,181.35,181.39,181.43,181.46,181.5,181.53,181.56,181.59,181.62,181.65,181.68,181.71,181.74,181.76,181.79,181.81,181.84,181.86,181.88,181.91,181.93,181.95,181.97,181.99,182.01,182.03,182.04,182.06,182.08,182.09,182.11,182.12,182.14,182.15,182.17,182.18,182.19,182.2,182.21,182.23,182.24,182.25,182.26,182.26,182.27,182.28,182.29,182.3,182.3,182.31,182.32,182.32,182.33,182.33,182.34,182.34,182.34,182.35,182.35,182.35,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.35,182.35,182.35,182.35,182.34,182.34,182.34,182.33,182.33,182.33,182.32,182.32,182.31,182.31,182.3,182.3,182.29,182.28,182.28,182.27,182.27,182.26,182.25,182.25,182.24,182.23,182.23,182.22,182.21,182.2,182.2,182.19,182.18,182.17,182.17,182.16,182.15,182.14,182.13,182.13,182.12,182.11,182.1,182.09,182.08,182.08,182.07,182.06,182.05,182.04,182.04,182.03,182.02,182.01,182.0,182.0,181.99,181.98,181.97,181.97,181.96,181.95,181.94,181.94,181.93,181.92,181.92,181.91,181.9,181.9,181.89,181.89,181.88,181.88,181.87,181.87,181.86,181.86,181.86,181.85,181.85,181.85,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.84,181.85,181.85,181.85,181.86,181.86,181.86,181.87,181.87,181.88,181.88,181.89,181.89,181.9,181.9,181.91,181.92,181.92,181.93,181.94,181.94,181.95,181.96,181.96,181.97,181.98,181.99,181.99,182.0,182.01,182.02,182.03,182.03,182.04,182.05,182.06,182.07,182.08,182.08,182.09,182.1,182.11,182.12,182.12,182.13,182.14,182.15,182.16,182.16,182.17,182.18,182.19,182.2,182.2,182.21,182.22,182.23,182.23,182.24,182.25,182.25,182.26,182.27,182.27,182.28,182.28,182.29,182.3,182.3,182.31,182.31,182.32,182.32,182.32,182.33,182.33,182.34,182.34,182.34,182.35,182.35,182.35,182.35,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.36,182.35,182.35,182.35,182.34,182.34,182.34,182.33,182.33,182.32,182.32,182.31,182.3,182.3,182.29,182.28,182.27,182.27,182.26,182.25,182.24,182.23,182.22,182.21,182.19,182.18,182.17,182.16,182.14,182.13,182.11,182.1,182.08,182.06,182.05,182.03,182.01,181.99,181.97,181.95,181.93,181.91,181.89,181.87,181.84,181.82,181.79,181.77,181.74,181.71,181.69,181.66,181.63,181.6,181.57,181.53,181.5,181.47,181.43,181.4,181.36,181.32,181.28,181.24,181.2,181.16,181.12,181.07,181.03,180.98,180.93,180.88,180.83,180.78,180.72,180.67,180.61,180.56,180.5,180.43,180.37,180.31,180.24,},
{181.08,181.14,181.2,181.27,181.32,181.38,181.44,181.49,181.55,181.6,181.65,181.7,181.75,181.79,181.84,181.88,181.93,181.97,182.01,182.05,182.09,182.13,182.16,182.2,182.23,182.27,182.3,182.33,182.36,182.4,182.43,182.45,182.48,182.51,182.54,182.56,182.59,182.61,182.64,182.66,182.68,182.7,182.72,182.74,182.76,182.78,182.8,182.82,182.84,182.86,182.87,182.89,182.9,182.92,182.93,182.95,182.96,182.97,182.98,183.0,183.01,183.02,183.03,183.04,183.05,183.06,183.07,183.08,183.08,183.09,183.1,183.11,183.11,183.12,183.12,183.13,183.14,183.14,183.14,183.15,183.15,183.16,183.16,183.16,183.16,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.16,183.16,183.16,183.16,183.16,183.15,183.15,183.15,183.14,183.14,183.13,183.13,183.13,183.12,183.12,183.11,183.11,183.1,183.1,183.09,183.08,183.08,183.07,183.07,183.06,183.05,183.05,183.04,183.04,183.03,183.02,183.01,183.01,183.0,182.99,182.99,182.98,182.97,182.96,182.96,182.95,182.94,182.94,182.93,182.92,182.91,182.91,182.9,182.89,182.88,182.88,182.87,182.86,182.85,182.85,182.84,182.83,182.83,182.82,182.81,182.81,182.8,182.79,182.79,182.78,182.77,182.77,182.76,182.76,182.75,182.75,182.74,182.74,182.73,182.73,182.72,182.72,182.72,182.71,182.71,182.71,182.71,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.7,182.71,182.71,182.71,182.71,182.72,182.72,182.72,182.73,182.73,182.74,182.74,182.75,182.75,182.76,182.76,182.77,182.77,182.78,182.79,182.79,182.8,182.81,182.81,182.82,182.83,182.83,182.84,182.85,182.85,182.86,182.87,182.88,182.88,182.89,182.9,182.9,182.91,182.92,182.93,182.93,182.94,182.95,182.96,182.96,182.97,182.98,182.99,182.99,183.0,183.01,183.01,183.02,183.03,183.03,183.04,183.05,183.05,183.06,183.07,183.07,183.08,183.08,183.09,183.1,183.1,183.11,183.11,183.12,183.12,183.12,183.13,183.13,183.14,183.14,183.14,183.15,183.15,183.15,183.16,183.16,183.16,183.16,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.17,183.16,183.16,183.16,183.16,183.15,183.15,183.15,183.14,183.14,183.13,183.13,183.12,183.11,183.11,183.1,183.09,183.09,183.08,183.07,183.06,183.05,183.04,183.03,183.02,183.01,183.0,182.99,182.97,182.96,182.95,182.93,182.92,182.91,182.89,182.87,182.86,182.84,182.82,182.81,182.79,182.77,182.75,182.73,182.71,182.68,182.66,182.64,182.62,182.59,182.57,182.54,182.51,182.49,182.46,182.43,182.4,182.37,182.34,182.31,182.27,182.24,182.2,182.17,182.13,182.09,182.06,182.02,181.97,181.93,181.89,181.85,181.8,181.75,181.71,181.66,181.61,181.55,181.5,181.45,181.39,181.33,181.27,},
{182.11,182.16,182.22,182.27,182.33,182.38,182.43,182.48,182.52,182.57,182.62,182.66,182.7,182.74,182.78,182.82,182.86,182.9,182.93,182.97,183.0,183.04,183.07,183.1,183.13,183.16,183.19,183.22,183.25,183.28,183.3,183.33,183.35,183.38,183.4,183.43,183.45,183.47,183.49,183.51,183.53,183.55,183.57,183.59,183.6,183.62,183.64,183.65,183.67,183.69,183.7,183.71,183.73,183.74,183.75,183.77,183.78,183.79,183.8,183.81,183.82,183.83,183.84,183.85,183.86,183.87,183.87,183.88,183.89,183.9,183.9,183.91,183.91,183.92,183.92,183.93,183.93,183.94,183.94,183.95,183.95,183.95,183.95,183.96,183.96,183.96,183.96,183.96,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.96,183.96,183.96,183.96,183.96,183.96,183.95,183.95,183.95,183.95,183.94,183.94,183.94,183.93,183.93,183.92,183.92,183.92,183.91,183.91,183.9,183.9,183.89,183.89,183.88,183.88,183.87,183.87,183.86,183.86,183.85,183.84,183.84,183.83,183.83,183.82,183.81,183.81,183.8,183.79,183.79,183.78,183.77,183.77,183.76,183.75,183.75,183.74,183.73,183.73,183.72,183.71,183.71,183.7,183.69,183.69,183.68,183.68,183.67,183.66,183.66,183.65,183.64,183.64,183.63,183.63,183.62,183.62,183.61,183.61,183.6,183.6,183.59,183.59,183.58,183.58,183.57,183.57,183.57,183.56,183.56,183.56,183.55,183.55,183.55,183.55,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.54,183.55,183.55,183.55,183.55,183.56,183.56,183.56,183.57,183.57,183.57,183.58,183.58,183.59,183.59,183.59,183.6,183.6,183.61,183.62,183.62,183.63,183.63,183.64,183.64,183.65,183.66,183.66,183.67,183.67,183.68,183.69,183.69,183.7,183.71,183.71,183.72,183.73,183.73,183.74,183.75,183.75,183.76,183.77,183.77,183.78,183.79,183.79,183.8,183.81,183.81,183.82,183.82,183.83,183.84,183.84,183.85,183.85,183.86,183.87,183.87,183.88,183.88,183.89,183.89,183.9,183.9,183.91,183.91,183.92,183.92,183.92,183.93,183.93,183.94,183.94,183.94,183.95,183.95,183.95,183.95,183.96,183.96,183.96,183.96,183.96,183.96,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.97,183.96,183.96,183.96,183.96,183.96,183.96,183.95,183.95,183.95,183.94,183.94,183.93,183.93,183.93,183.92,183.92,183.91,183.9,183.9,183.89,183.88,183.88,183.87,183.86,183.85,183.84,183.83,183.82,183.81,183.8,183.79,183.78,183.77,183.76,183.74,183.73,183.72,183.7,183.69,183.67,183.66,183.64,183.62,183.61,183.59,183.57,183.55,183.53,183.51,183.49,183.47,183.45,183.43,183.41,183.38,183.36,183.33,183.31,183.28,183.25,183.23,183.2,183.17,183.14,183.11,183.08,183.04,183.01,182.98,182.94,182.9,182.87,182.83,182.79,182.75,182.71,182.67,182.62,182.58,182.53,182.48,182.44,182.39,182.33,182.28,},
{183.11,183.16,183.21,183.26,183.31,183.35,183.4,183.44,183.48,183.52,183.56,183.6,183.64,183.67,183.71,183.74,183.78,183.81,183.84,183.87,183.9,183.93,183.96,183.99,184.01,184.04,184.07,184.09,184.12,184.14,184.16,184.19,184.21,184.23,184.25,184.27,184.29,184.31,184.33,184.35,184.36,184.38,184.4,184.41,184.43,184.44,184.46,184.47,184.49,184.5,184.51,184.53,184.54,184.55,184.56,184.57,184.58,184.59,184.6,184.61,184.62,184.63,184.64,184.64,184.65,184.66,184.67,184.67,184.68,184.68,184.69,184.7,184.7,184.71,184.71,184.71,184.72,184.72,184.73,184.73,184.73,184.73,184.74,184.74,184.74,184.74,184.74,184.74,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.74,184.74,184.74,184.74,184.74,184.74,184.73,184.73,184.73,184.73,184.72,184.72,184.72,184.72,184.71,184.71,184.71,184.7,184.7,184.69,184.69,184.69,184.68,184.68,184.67,184.67,184.66,184.66,184.65,184.65,184.64,184.64,184.63,184.63,184.62,184.62,184.61,184.6,184.6,184.59,184.59,184.58,184.58,184.57,184.56,184.56,184.55,184.55,184.54,184.53,184.53,184.52,184.52,184.51,184.51,184.5,184.49,184.49,184.48,184.48,184.47,184.47,184.46,184.46,184.45,184.45,184.44,184.44,184.43,184.43,184.42,184.42,184.41,184.41,184.41,184.4,184.4,184.39,184.39,184.39,184.39,184.38,184.38,184.38,184.38,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.37,184.38,184.38,184.38,184.38,184.39,184.39,184.39,184.39,184.4,184.4,184.4,184.41,184.41,184.42,184.42,184.43,184.43,184.44,184.44,184.44,184.45,184.46,184.46,184.47,184.47,184.48,184.48,184.49,184.49,184.5,184.5,184.51,184.52,184.52,184.53,184.53,184.54,184.55,184.55,184.56,184.56,184.57,184.58,184.58,184.59,184.59,184.6,184.6,184.61,184.61,184.62,184.63,184.63,184.64,184.64,184.65,184.65,184.66,184.66,184.67,184.67,184.68,184.68,184.68,184.69,184.69,184.7,184.7,184.7,184.71,184.71,184.72,184.72,184.72,184.72,184.73,184.73,184.73,184.73,184.74,184.74,184.74,184.74,184.74,184.74,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.75,184.74,184.74,184.74,184.74,184.74,184.74,184.73,184.73,184.73,184.73,184.72,184.72,184.72,184.71,184.71,184.7,184.7,184.69,184.69,184.68,184.67,184.67,184.66,184.65,184.65,184.64,184.63,184.62,184.61,184.6,184.59,184.58,184.57,184.56,184.55,184.54,184.53,184.51,184.5,184.49,184.47,184.46,184.45,184.43,184.42,184.4,184.38,184.37,184.35,184.33,184.31,184.29,184.27,184.25,184.23,184.21,184.19,184.17,184.14,184.12,184.1,184.07,184.05,184.02,183.99,183.96,183.94,183.91,183.88,183.84,183.81,183.78,183.75,183.71,183.68,183.64,183.6,183.57,183.53,183.49,183.44,183.4,183.36,183.31,183.27,},
{184.1,184.14,184.18,184.22,184.26,184.3,184.34,184.38,184.41,184.45,184.48,184.52,184.55,184.58,184.61,184.64,184.67,184.7,184.73,184.75,184.78,184.8,184.83,184.85,184.88,184.9,184.92,184.94,184.97,184.99,185.01,185.03,185.05,185.06,185.08,185.1,185.12,185.13,185.15,185.17,185.18,185.2,185.21,185.22,185.24,185.25,185.26,185.27,185.29,185.3,185.31,185.32,185.33,185.34,185.35,185.36,185.37,185.38,185.39,185.39,185.4,185.41,185.42,185.42,185.43,185.44,185.44,185.45,185.45,185.46,185.46,185.47,185.47,185.48,185.48,185.48,185.49,185.49,185.49,185.5,185.5,185.5,185.5,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.5,185.5,185.5,185.5,185.5,185.49,185.49,185.49,185.49,185.48,185.48,185.48,185.47,185.47,185.47,185.46,185.46,185.46,185.45,185.45,185.44,185.44,185.43,185.43,185.43,185.42,185.42,185.41,185.41,185.4,185.4,185.39,185.39,185.38,185.38,185.37,185.37,185.36,185.36,185.35,185.35,185.34,185.34,185.33,185.33,185.32,185.32,185.31,185.31,185.3,185.3,185.29,185.29,185.28,185.28,185.27,185.27,185.26,185.26,185.25,185.25,185.25,185.24,185.24,185.23,185.23,185.22,185.22,185.22,185.21,185.21,185.21,185.2,185.2,185.2,185.2,185.19,185.19,185.19,185.19,185.19,185.19,185.18,185.18,185.18,185.18,185.18,185.18,185.18,185.18,185.18,185.18,185.18,185.19,185.19,185.19,185.19,185.19,185.19,185.2,185.2,185.2,185.2,185.21,185.21,185.21,185.22,185.22,185.22,185.23,185.23,185.24,185.24,185.24,185.25,185.25,185.26,185.26,185.27,185.27,185.28,185.28,185.29,185.29,185.3,185.3,185.31,185.31,185.32,185.32,185.33,185.33,185.34,185.34,185.35,185.35,185.36,185.36,185.37,185.37,185.38,185.38,185.39,185.39,185.4,185.4,185.41,185.41,185.42,185.42,185.43,185.43,185.43,185.44,185.44,185.45,185.45,185.45,185.46,185.46,185.47,185.47,185.47,185.48,185.48,185.48,185.48,185.49,185.49,185.49,185.5,185.5,185.5,185.5,185.5,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.51,185.5,185.5,185.5,185.5,185.49,185.49,185.49,185.49,185.48,185.48,185.47,185.47,185.46,185.46,185.45,185.45,185.44,185.44,185.43,185.42,185.42,185.41,185.4,185.4,185.39,185.38,185.37,185.36,185.35,185.34,185.33,185.32,185.31,185.3,185.29,185.28,185.26,185.25,185.24,185.23,185.21,185.2,185.18,185.17,185.15,185.14,185.12,185.1,185.08,185.07,185.05,185.03,185.01,184.99,184.97,184.95,184.93,184.9,184.88,184.86,184.83,184.81,184.78,184.76,184.73,184.7,184.67,184.64,184.61,184.58,184.55,184.52,184.49,184.45,184.42,184.38,184.35,184.31,184.27,184.23,},
{185.06,185.09,185.13,185.16,185.2,185.23,185.26,185.3,185.33,185.36,185.39,185.41,185.44,185.47,185.49,185.52,185.54,185.57,185.59,185.62,185.64,185.66,185.68,185.7,185.72,185.74,185.76,185.78,185.8,185.82,185.83,185.85,185.87,185.88,185.9,185.91,185.93,185.94,185.95,185.97,185.98,185.99,186.01,186.02,186.03,186.04,186.05,186.06,186.07,186.08,186.09,186.1,186.11,186.12,186.13,186.13,186.14,186.15,186.16,186.16,186.17,186.18,186.18,186.19,186.19,186.2,186.21,186.21,186.21,186.22,186.22,186.23,186.23,186.23,186.24,186.24,186.24,186.25,186.25,186.25,186.25,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.27,186.27,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.25,186.25,186.25,186.25,186.25,186.24,186.24,186.24,186.24,186.23,186.23,186.23,186.22,186.22,186.22,186.22,186.21,186.21,186.2,186.2,186.2,186.19,186.19,186.19,186.18,186.18,186.17,186.17,186.17,186.16,186.16,186.15,186.15,186.14,186.14,186.14,186.13,186.13,186.12,186.12,186.11,186.11,186.11,186.1,186.1,186.09,186.09,186.08,186.08,186.07,186.07,186.07,186.06,186.06,186.05,186.05,186.05,186.04,186.04,186.03,186.03,186.03,186.02,186.02,186.02,186.01,186.01,186.01,186.01,186.0,186.0,186.0,186.0,185.99,185.99,185.99,185.99,185.99,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.98,185.99,185.99,185.99,185.99,185.99,185.99,186.0,186.0,186.0,186.0,186.01,186.01,186.01,186.02,186.02,186.02,186.03,186.03,186.03,186.04,186.04,186.05,186.05,186.05,186.06,186.06,186.07,186.07,186.07,186.08,186.08,186.09,186.09,186.1,186.1,186.1,186.11,186.11,186.12,186.12,186.13,186.13,186.14,186.14,186.14,186.15,186.15,186.16,186.16,186.17,186.17,186.17,186.18,186.18,186.19,186.19,186.19,186.2,186.2,186.2,186.21,186.21,186.21,186.22,186.22,186.22,186.23,186.23,186.23,186.24,186.24,186.24,186.24,186.25,186.25,186.25,186.25,186.25,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.27,186.27,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.26,186.25,186.25,186.25,186.25,186.24,186.24,186.24,186.24,186.23,186.23,186.22,186.22,186.22,186.21,186.21,186.2,186.2,186.19,186.18,186.18,186.17,186.16,186.16,186.15,186.14,186.14,186.13,186.12,186.11,186.1,186.09,186.08,186.07,186.06,186.05,186.04,186.03,186.02,186.01,186.0,185.98,185.97,185.96,185.94,185.93,185.91,185.9,185.88,185.87,185.85,185.84,185.82,185.8,185.78,185.76,185.74,185.73,185.71,185.68,185.66,185.64,185.62,185.6,185.57,185.55,185.52,185.5,185.47,185.45,185.42,185.39,185.36,185.33,185.3,185.27,185.24,185.2,185.17,},
{186.0,186.03,186.06,186.08,186.11,186.14,186.17,186.19,186.22,186.24,186.27,186.29,186.32,186.34,186.36,186.38,186.4,186.42,186.44,186.46,186.48,186.5,186.52,186.53,186.55,186.57,186.58,186.6,186.61,186.63,186.64,186.66,186.67,186.68,186.7,186.71,186.72,186.73,186.74,186.76,186.77,186.78,186.79,186.8,186.81,186.82,186.83,186.83,186.84,186.85,186.86,186.87,186.87,186.88,186.89,186.89,186.9,186.91,186.91,186.92,186.92,186.93,186.94,186.94,186.95,186.95,186.95,186.96,186.96,186.97,186.97,186.97,186.98,186.98,186.98,186.98,186.99,186.99,186.99,186.99,186.99,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,186.99,186.99,186.99,186.99,186.99,186.99,186.98,186.98,186.98,186.98,186.97,186.97,186.97,186.97,186.96,186.96,186.96,186.96,186.95,186.95,186.95,186.94,186.94,186.94,186.93,186.93,186.93,186.92,186.92,186.92,186.91,186.91,186.91,186.9,186.9,186.9,186.89,186.89,186.88,186.88,186.88,186.87,186.87,186.87,186.86,186.86,186.85,186.85,186.85,186.84,186.84,186.84,186.83,186.83,186.83,186.82,186.82,186.82,186.81,186.81,186.81,186.8,186.8,186.8,186.8,186.79,186.79,186.79,186.79,186.78,186.78,186.78,186.78,186.78,186.77,186.77,186.77,186.77,186.77,186.77,186.77,186.77,186.76,186.76,186.76,186.76,186.76,186.76,186.76,186.77,186.77,186.77,186.77,186.77,186.77,186.77,186.77,186.77,186.78,186.78,186.78,186.78,186.79,186.79,186.79,186.79,186.8,186.8,186.8,186.8,186.81,186.81,186.81,186.82,186.82,186.82,186.83,186.83,186.83,186.84,186.84,186.84,186.85,186.85,186.85,186.86,186.86,186.87,186.87,186.87,186.88,186.88,186.88,186.89,186.89,186.89,186.9,186.9,186.91,186.91,186.91,186.92,186.92,186.92,186.93,186.93,186.93,186.94,186.94,186.94,186.95,186.95,186.95,186.96,186.96,186.96,186.96,186.97,186.97,186.97,186.97,186.98,186.98,186.98,186.98,186.99,186.99,186.99,186.99,186.99,186.99,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,187.0,186.99,186.99,186.99,186.99,186.99,186.98,186.98,186.98,186.98,186.97,186.97,186.97,186.96,186.96,186.95,186.95,186.95,186.94,186.94,186.93,186.93,186.92,186.91,186.91,186.9,186.9,186.89,186.88,186.87,186.87,186.86,186.85,186.84,186.84,186.83,186.82,186.81,186.8,186.79,186.78,186.77,186.76,186.75,186.73,186.72,186.71,186.7,186.69,186.67,186.66,186.64,186.63,186.62,186.6,186.58,186.57,186.55,186.54,186.52,186.5,186.48,186.46,186.44,186.43,186.41,186.38,186.36,186.34,186.32,186.3,186.27,186.25,186.22,186.2,186.17,186.15,186.12,186.09,},
{186.91,186.94,186.96,186.98,187.01,187.03,187.05,187.07,187.09,187.11,187.13,187.15,187.17,187.19,187.21,187.22,187.24,187.26,187.27,187.29,187.3,187.32,187.33,187.35,187.36,187.37,187.39,187.4,187.41,187.42,187.44,187.45,187.46,187.47,187.48,187.49,187.5,187.51,187.52,187.53,187.54,187.55,187.55,187.56,187.57,187.58,187.58,187.59,187.6,187.61,187.61,187.62,187.62,187.63,187.64,187.64,187.65,187.65,187.66,187.66,187.67,187.67,187.67,187.68,187.68,187.69,187.69,187.69,187.7,187.7,187.7,187.7,187.71,187.71,187.71,187.71,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.71,187.71,187.71,187.71,187.71,187.71,187.7,187.7,187.7,187.7,187.7,187.69,187.69,187.69,187.69,187.68,187.68,187.68,187.68,187.67,187.67,187.67,187.66,187.66,187.66,187.66,187.65,187.65,187.65,187.64,187.64,187.64,187.64,187.63,187.63,187.63,187.62,187.62,187.62,187.61,187.61,187.61,187.61,187.6,187.6,187.6,187.59,187.59,187.59,187.58,187.58,187.58,187.58,187.57,187.57,187.57,187.57,187.56,187.56,187.56,187.56,187.56,187.55,187.55,187.55,187.55,187.55,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.53,187.53,187.53,187.53,187.53,187.53,187.53,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.54,187.55,187.55,187.55,187.55,187.55,187.56,187.56,187.56,187.56,187.56,187.57,187.57,187.57,187.57,187.58,187.58,187.58,187.58,187.59,187.59,187.59,187.6,187.6,187.6,187.6,187.61,187.61,187.61,187.62,187.62,187.62,187.63,187.63,187.63,187.63,187.64,187.64,187.64,187.65,187.65,187.65,187.66,187.66,187.66,187.66,187.67,187.67,187.67,187.67,187.68,187.68,187.68,187.69,187.69,187.69,187.69,187.69,187.7,187.7,187.7,187.7,187.71,187.71,187.71,187.71,187.71,187.71,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.73,187.72,187.72,187.72,187.72,187.72,187.72,187.72,187.71,187.71,187.71,187.71,187.7,187.7,187.7,187.7,187.69,187.69,187.69,187.68,187.68,187.67,187.67,187.67,187.66,187.66,187.65,187.65,187.64,187.64,187.63,187.63,187.62,187.61,187.61,187.6,187.59,187.59,187.58,187.57,187.56,187.56,187.55,187.54,187.53,187.52,187.51,187.5,187.49,187.48,187.47,187.46,187.45,187.44,187.43,187.41,187.4,187.39,187.38,187.36,187.35,187.34,187.32,187.31,187.29,187.28,187.26,187.24,187.23,187.21,187.19,187.17,187.16,187.14,187.12,187.1,187.08,187.06,187.03,187.01,186.99,},
{187.81,187.83,187.85,187.86,187.88,187.9,187.92,187.93,187.95,187.97,187.98,188.0,188.01,188.02,188.04,188.05,188.06,188.08,188.09,188.1,188.11,188.12,188.14,188.15,188.16,188.17,188.18,188.19,188.2,188.21,188.22,188.22,188.23,188.24,188.25,188.26,188.26,188.27,188.28,188.29,188.29,188.3,188.31,188.31,188.32,188.32,188.33,188.34,188.34,188.35,188.35,188.36,188.36,188.37,188.37,188.37,188.38,188.38,188.39,188.39,188.39,188.4,188.4,188.4,188.41,188.41,188.41,188.41,188.42,188.42,188.42,188.42,188.42,188.43,188.43,188.43,188.43,188.43,188.43,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.43,188.43,188.43,188.43,188.43,188.43,188.43,188.43,188.42,188.42,188.42,188.42,188.42,188.42,188.41,188.41,188.41,188.41,188.41,188.4,188.4,188.4,188.4,188.4,188.39,188.39,188.39,188.39,188.39,188.38,188.38,188.38,188.38,188.37,188.37,188.37,188.37,188.36,188.36,188.36,188.36,188.35,188.35,188.35,188.35,188.35,188.34,188.34,188.34,188.34,188.33,188.33,188.33,188.33,188.33,188.32,188.32,188.32,188.32,188.32,188.31,188.31,188.31,188.31,188.31,188.31,188.3,188.3,188.3,188.3,188.3,188.3,188.3,188.3,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.29,188.3,188.3,188.3,188.3,188.3,188.3,188.3,188.3,188.31,188.31,188.31,188.31,188.31,188.31,188.32,188.32,188.32,188.32,188.32,188.33,188.33,188.33,188.33,188.33,188.34,188.34,188.34,188.34,188.35,188.35,188.35,188.35,188.35,188.36,188.36,188.36,188.36,188.37,188.37,188.37,188.37,188.38,188.38,188.38,188.38,188.38,188.39,188.39,188.39,188.39,188.4,188.4,188.4,188.4,188.4,188.41,188.41,188.41,188.41,188.41,188.42,188.42,188.42,188.42,188.42,188.42,188.43,188.43,188.43,188.43,188.43,188.43,188.43,188.43,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.44,188.43,188.43,188.43,188.43,188.43,188.43,188.43,188.42,188.42,188.42,188.42,188.41,188.41,188.41,188.41,188.4,188.4,188.4,188.39,188.39,188.39,188.38,188.38,188.37,188.37,188.37,188.36,188.36,188.35,188.35,188.34,188.34,188.33,188.33,188.32,188.31,188.31,188.3,188.29,188.29,188.28,188.27,188.27,188.26,188.25,188.24,188.23,188.23,188.22,188.21,188.2,188.19,188.18,188.17,188.16,188.15,188.14,188.13,188.11,188.1,188.09,188.08,188.07,188.05,188.04,188.03,188.01,188.0,187.98,187.97,187.95,187.94,187.92,187.9,187.89,187.87,},
{188.69,188.7,188.71,188.73,188.74,188.75,188.76,188.78,188.79,188.8,188.81,188.82,188.83,188.84,188.85,188.86,188.87,188.88,188.89,188.9,188.91,188.91,188.92,188.93,188.94,188.94,188.95,188.96,188.97,188.97,188.98,188.99,188.99,189.0,189.0,189.01,189.01,189.02,189.03,189.03,189.04,189.04,189.04,189.05,189.05,189.06,189.06,189.07,189.07,189.07,189.08,189.08,189.08,189.09,189.09,189.09,189.1,189.1,189.1,189.1,189.11,189.11,189.11,189.11,189.12,189.12,189.12,189.12,189.12,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.12,189.12,189.12,189.12,189.12,189.12,189.12,189.11,189.11,189.11,189.11,189.11,189.11,189.1,189.1,189.1,189.1,189.1,189.1,189.1,189.09,189.09,189.09,189.09,189.09,189.08,189.08,189.08,189.08,189.08,189.08,189.07,189.07,189.07,189.07,189.07,189.07,189.06,189.06,189.06,189.06,189.06,189.06,189.06,189.05,189.05,189.05,189.05,189.05,189.05,189.05,189.05,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.03,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.04,189.05,189.05,189.05,189.05,189.05,189.05,189.05,189.06,189.06,189.06,189.06,189.06,189.06,189.06,189.07,189.07,189.07,189.07,189.07,189.07,189.08,189.08,189.08,189.08,189.08,189.08,189.09,189.09,189.09,189.09,189.09,189.09,189.1,189.1,189.1,189.1,189.1,189.1,189.11,189.11,189.11,189.11,189.11,189.11,189.12,189.12,189.12,189.12,189.12,189.12,189.12,189.12,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.14,189.13,189.13,189.13,189.13,189.13,189.13,189.13,189.12,189.12,189.12,189.12,189.12,189.11,189.11,189.11,189.11,189.11,189.1,189.1,189.1,189.09,189.09,189.09,189.08,189.08,189.08,189.07,189.07,189.07,189.06,189.06,189.05,189.05,189.05,189.04,189.04,189.03,189.03,189.02,189.02,189.01,189.0,189.0,188.99,188.99,188.98,188.97,188.97,188.96,188.95,188.95,188.94,188.93,188.92,188.91,188.91,188.9,188.89,188.88,188.87,188.86,188.85,188.84,188.83,188.82,188.81,188.8,188.79,188.78,188.77,188.75,188.74,188.73,},
{189.54,189.55,189.56,189.57,189.58,189.59,189.59,189.6,189.61,189.61,189.62,189.63,189.64,189.64,189.65,189.65,189.66,189.67,189.67,189.68,189.68,189.69,189.69,189.7,189.7,189.71,189.71,189.72,189.72,189.72,189.73,189.73,189.74,189.74,189.74,189.75,189.75,189.75,189.76,189.76,189.76,189.77,189.77,189.77,189.78,189.78,189.78,189.78,189.79,189.79,189.79,189.79,189.79,189.8,189.8,189.8,189.8,189.8,189.81,189.81,189.81,189.81,189.81,189.81,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.76,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.77,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.78,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.79,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.8,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.81,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.83,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.82,189.81,189.81,189.81,189.81,189.81,189.81,189.8,189.8,189.8,189.8,189.8,189.8,189.79,189.79,189.79,189.79,189.78,189.78,189.78,189.78,189.77,189.77,189.77,189.76,189.76,189.76,189.75,189.75,189.75,189.74,189.74,189.74,189.73,189.73,189.72,189.72,189.72,189.71,189.71,189.7,189.7,189.69,189.69,189.68,189.68,189.67,189.67,189.66,189.65,189.65,189.64,189.64,189.63,189.62,189.62,189.61,189.6,189.59,189.59,189.58,189.57,},
{190.38,190.39,190.39,190.4,190.4,190.4,190.41,190.41,190.41,190.41,190.42,190.42,190.42,190.43,190.43,190.43,190.43,190.44,190.44,190.44,190.44,190.45,190.45,190.45,190.45,190.45,190.46,190.46,190.46,190.46,190.46,190.47,190.47,190.47,190.47,190.47,190.47,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.51,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.5,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.49,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.48,190.47,190.47,190.47,190.47,190.47,190.47,190.46,190.46,190.46,190.46,190.46,190.45,190.45,190.45,190.45,190.45,190.44,190.44,190.44,190.44,190.43,190.43,190.43,190.43,190.42,190.42,190.42,190.42,190.41,190.41,190.41,190.4,190.4,190.4,},
{191.21,191.21,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.17,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.18,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.19,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,191.2,},
{192.01,192.01,192.0,192.0,191.99,191.99,191.98,191.98,191.97,191.97,191.96,191.96,191.95,191.95,191.95,191.94,191.94,191.94,191.93,191.93,191.92,191.92,191.92,191.92,191.91,191.91,191.91,191.9,191.9,191.9,191.9,191.89,191.89,191.89,191.89,191.88,191.88,191.88,191.88,191.87,191.87,191.87,191.87,191.87,191.87,191.86,191.86,191.86,191.86,191.86,191.86,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.87,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.86,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.83,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.84,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.85,191.86,191.86,191.86,191.86,191.86,191.86,191.87,191.87,191.87,191.87,191.87,191.87,191.88,191.88,191.88,191.88,191.89,191.89,191.89,191.89,191.89,191.9,191.9,191.9,191.91,191.91,191.91,191.91,191.92,191.92,191.92,191.93,191.93,191.93,191.94,191.94,191.95,191.95,191.95,191.96,191.96,191.97,191.97,191.98,191.98,191.99,191.99,192.0,},
{192.8,192.79,192.78,192.77,192.76,192.75,192.75,192.74,192.73,192.72,192.71,192.71,192.7,192.69,192.68,192.68,192.67,192.66,192.66,192.65,192.64,192.64,192.63,192.63,192.62,192.62,192.61,192.61,192.6,192.6,192.59,192.59,192.58,192.58,192.57,192.57,192.57,192.56,192.56,192.55,192.55,192.55,192.54,192.54,192.54,192.53,192.53,192.53,192.53,192.52,192.52,192.52,192.52,192.51,192.51,192.51,192.51,192.5,192.5,192.5,192.5,192.5,192.5,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.51,192.51,192.51,192.51,192.51,192.51,192.51,192.51,192.52,192.52,192.52,192.52,192.52,192.52,192.52,192.52,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.55,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.54,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.53,192.52,192.52,192.52,192.52,192.52,192.52,192.52,192.52,192.51,192.51,192.51,192.51,192.51,192.51,192.51,192.51,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.5,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.47,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.48,192.49,192.49,192.49,192.49,192.49,192.49,192.49,192.5,192.5,192.5,192.5,192.5,192.5,192.51,192.51,192.51,192.51,192.52,192.52,192.52,192.52,192.53,192.53,192.53,192.53,192.54,192.54,192.54,192.55,192.55,192.55,192.56,192.56,192.57,192.57,192.57,192.58,192.58,192.59,192.59,192.6,192.6,192.61,192.61,192.62,192.62,192.63,192.63,192.64,192.64,192.65,192.66,192.66,192.67,192.68,192.68,192.69,192.7,192.7,192.71,192.72,192.73,192.74,192.74,192.75,192.76,192.77,},
{193.57,193.56,193.55,193.53,193.52,193.51,193.5,193.48,193.47,193.46,193.45,193.44,193.43,193.42,193.41,193.4,193.39,193.38,193.37,193.36,193.35,193.34,193.33,193.33,193.32,193.31,193.3,193.3,193.29,193.28,193.28,193.27,193.26,193.26,193.25,193.24,193.24,193.23,193.23,193.22,193.22,193.21,193.21,193.2,193.2,193.19,193.19,193.19,193.18,193.18,193.17,193.17,193.17,193.16,193.16,193.16,193.15,193.15,193.15,193.15,193.14,193.14,193.14,193.14,193.13,193.13,193.13,193.13,193.13,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.13,193.13,193.13,193.13,193.13,193.13,193.13,193.14,193.14,193.14,193.14,193.14,193.14,193.15,193.15,193.15,193.15,193.15,193.15,193.16,193.16,193.16,193.16,193.16,193.16,193.17,193.17,193.17,193.17,193.17,193.18,193.18,193.18,193.18,193.18,193.18,193.19,193.19,193.19,193.19,193.19,193.19,193.2,193.2,193.2,193.2,193.2,193.2,193.2,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.22,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.21,193.2,193.2,193.2,193.2,193.2,193.2,193.2,193.19,193.19,193.19,193.19,193.19,193.19,193.18,193.18,193.18,193.18,193.18,193.18,193.17,193.17,193.17,193.17,193.17,193.17,193.16,193.16,193.16,193.16,193.16,193.15,193.15,193.15,193.15,193.15,193.15,193.14,193.14,193.14,193.14,193.14,193.14,193.13,193.13,193.13,193.13,193.13,193.13,193.13,193.13,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.11,193.12,193.12,193.12,193.12,193.12,193.12,193.12,193.13,193.13,193.13,193.13,193.13,193.14,193.14,193.14,193.14,193.15,193.15,193.15,193.15,193.16,193.16,193.16,193.17,193.17,193.17,193.18,193.18,193.19,193.19,193.19,193.2,193.2,193.21,193.21,193.22,193.22,193.23,193.23,193.24,193.24,193.25,193.26,193.26,193.27,193.27,193.28,193.29,193.3,193.3,193.31,193.32,193.33,193.33,193.34,193.35,193.36,193.37,193.38,193.39,193.4,193.41,193.42,193.43,193.44,193.45,193.46,193.47,193.48,193.49,193.51,193.52,193.53,},
{194.33,194.32,194.3,194.28,194.26,194.25,194.23,194.22,194.2,194.19,194.17,194.16,194.14,194.13,194.12,194.1,194.09,194.08,194.07,194.06,194.05,194.03,194.02,194.01,194.0,193.99,193.98,193.97,193.97,193.96,193.95,193.94,193.93,193.92,193.92,193.91,193.9,193.89,193.89,193.88,193.87,193.87,193.86,193.85,193.85,193.84,193.84,193.83,193.83,193.82,193.82,193.81,193.81,193.8,193.8,193.8,193.79,193.79,193.78,193.78,193.78,193.77,193.77,193.77,193.76,193.76,193.76,193.76,193.75,193.75,193.75,193.75,193.75,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.75,193.75,193.75,193.75,193.75,193.75,193.75,193.76,193.76,193.76,193.76,193.76,193.77,193.77,193.77,193.77,193.77,193.78,193.78,193.78,193.78,193.78,193.79,193.79,193.79,193.79,193.8,193.8,193.8,193.8,193.8,193.81,193.81,193.81,193.81,193.82,193.82,193.82,193.82,193.82,193.83,193.83,193.83,193.83,193.84,193.84,193.84,193.84,193.84,193.85,193.85,193.85,193.85,193.85,193.85,193.86,193.86,193.86,193.86,193.86,193.86,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.88,193.88,193.88,193.88,193.88,193.88,193.88,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.87,193.86,193.86,193.86,193.86,193.86,193.86,193.85,193.85,193.85,193.85,193.85,193.85,193.84,193.84,193.84,193.84,193.84,193.83,193.83,193.83,193.83,193.82,193.82,193.82,193.82,193.82,193.81,193.81,193.81,193.81,193.8,193.8,193.8,193.8,193.8,193.79,193.79,193.79,193.79,193.78,193.78,193.78,193.78,193.78,193.77,193.77,193.77,193.77,193.77,193.76,193.76,193.76,193.76,193.76,193.75,193.75,193.75,193.75,193.75,193.75,193.75,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.73,193.74,193.74,193.74,193.74,193.74,193.74,193.74,193.75,193.75,193.75,193.75,193.75,193.76,193.76,193.76,193.76,193.77,193.77,193.77,193.78,193.78,193.78,193.79,193.79,193.79,193.8,193.8,193.81,193.81,193.82,193.82,193.83,193.83,193.84,193.84,193.85,193.85,193.86,193.87,193.87,193.88,193.89,193.89,193.9,193.91,193.91,193.92,193.93,193.94,193.95,193.96,193.96,193.97,193.98,193.99,194.0,194.01,194.02,194.03,194.04,194.06,194.07,194.08,194.09,194.1,194.12,194.13,194.14,194.16,194.17,194.18,194.2,194.21,194.23,194.24,194.26,194.28,},
{195.08,195.05,195.03,195.01,194.99,194.97,194.95,194.93,194.92,194.9,194.88,194.86,194.85,194.83,194.81,194.8,194.78,194.77,194.75,194.74,194.73,194.71,194.7,194.69,194.68,194.66,194.65,194.64,194.63,194.62,194.61,194.6,194.59,194.58,194.57,194.56,194.55,194.54,194.53,194.53,194.52,194.51,194.5,194.49,194.49,194.48,194.47,194.47,194.46,194.46,194.45,194.44,194.44,194.43,194.43,194.42,194.42,194.41,194.41,194.4,194.4,194.4,194.39,194.39,194.39,194.38,194.38,194.38,194.37,194.37,194.37,194.36,194.36,194.36,194.36,194.36,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.36,194.36,194.36,194.36,194.36,194.36,194.37,194.37,194.37,194.37,194.37,194.38,194.38,194.38,194.38,194.39,194.39,194.39,194.39,194.4,194.4,194.4,194.4,194.41,194.41,194.41,194.41,194.42,194.42,194.42,194.42,194.43,194.43,194.43,194.44,194.44,194.44,194.44,194.45,194.45,194.45,194.46,194.46,194.46,194.46,194.47,194.47,194.47,194.47,194.48,194.48,194.48,194.48,194.49,194.49,194.49,194.49,194.49,194.5,194.5,194.5,194.5,194.5,194.51,194.51,194.51,194.51,194.51,194.51,194.51,194.51,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.52,194.51,194.51,194.51,194.51,194.51,194.51,194.51,194.5,194.5,194.5,194.5,194.5,194.49,194.49,194.49,194.49,194.49,194.48,194.48,194.48,194.48,194.47,194.47,194.47,194.47,194.46,194.46,194.46,194.46,194.45,194.45,194.45,194.44,194.44,194.44,194.44,194.43,194.43,194.43,194.43,194.42,194.42,194.42,194.41,194.41,194.41,194.41,194.4,194.4,194.4,194.4,194.39,194.39,194.39,194.39,194.38,194.38,194.38,194.38,194.38,194.37,194.37,194.37,194.37,194.37,194.36,194.36,194.36,194.36,194.36,194.36,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.34,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.35,194.36,194.36,194.36,194.36,194.36,194.37,194.37,194.37,194.38,194.38,194.38,194.38,194.39,194.39,194.4,194.4,194.4,194.41,194.41,194.42,194.42,194.43,194.43,194.44,194.44,194.45,194.45,194.46,194.47,194.47,194.48,194.49,194.49,194.5,194.51,194.52,194.52,194.53,194.54,194.55,194.56,194.57,194.58,194.59,194.6,194.61,194.62,194.63,194.64,194.65,194.66,194.67,194.69,194.7,194.71,194.73,194.74,194.75,194.77,194.78,194.8,194.81,194.83,194.84,194.86,194.88,194.9,194.91,194.93,194.95,194.97,194.99,195.01,},
{195.81,195.78,195.76,195.73,195.71,195.68,195.66,195.64,195.62,195.6,195.58,195.56,195.54,195.52,195.5,195.48,195.46,195.45,195.43,195.41,195.4,195.38,195.37,195.35,195.34,195.32,195.31,195.3,195.28,195.27,195.26,195.25,195.23,195.22,195.21,195.2,195.19,195.18,195.17,195.16,195.15,195.14,195.13,195.12,195.12,195.11,195.1,195.09,195.08,195.08,195.07,195.06,195.06,195.05,195.05,195.04,195.03,195.03,195.02,195.02,195.01,195.01,195.0,195.0,195.0,194.99,194.99,194.98,194.98,194.98,194.97,194.97,194.97,194.97,194.96,194.96,194.96,194.96,194.96,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.94,194.94,194.94,194.94,194.94,194.94,194.94,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.96,194.96,194.96,194.96,194.96,194.96,194.97,194.97,194.97,194.97,194.97,194.98,194.98,194.98,194.98,194.99,194.99,194.99,194.99,195.0,195.0,195.0,195.01,195.01,195.01,195.01,195.02,195.02,195.02,195.03,195.03,195.03,195.04,195.04,195.04,195.05,195.05,195.05,195.05,195.06,195.06,195.06,195.07,195.07,195.07,195.08,195.08,195.08,195.09,195.09,195.09,195.1,195.1,195.1,195.1,195.11,195.11,195.11,195.12,195.12,195.12,195.12,195.13,195.13,195.13,195.13,195.13,195.14,195.14,195.14,195.14,195.14,195.14,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.15,195.14,195.14,195.14,195.14,195.14,195.14,195.13,195.13,195.13,195.13,195.13,195.12,195.12,195.12,195.12,195.11,195.11,195.11,195.1,195.1,195.1,195.1,195.09,195.09,195.09,195.08,195.08,195.08,195.07,195.07,195.07,195.06,195.06,195.06,195.06,195.05,195.05,195.05,195.04,195.04,195.04,195.03,195.03,195.03,195.02,195.02,195.02,195.01,195.01,195.01,195.01,195.0,195.0,195.0,194.99,194.99,194.99,194.99,194.98,194.98,194.98,194.98,194.97,194.97,194.97,194.97,194.97,194.96,194.96,194.96,194.96,194.96,194.96,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.94,194.94,194.94,194.94,194.94,194.94,194.94,194.94,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.95,194.96,194.96,194.96,194.96,194.96,194.97,194.97,194.97,194.97,194.98,194.98,194.98,194.99,194.99,195.0,195.0,195.0,195.01,195.01,195.02,195.02,195.03,195.03,195.04,195.04,195.05,195.06,195.06,195.07,195.08,195.08,195.09,195.1,195.11,195.11,195.12,195.13,195.14,195.15,195.16,195.17,195.18,195.19,195.2,195.21,195.22,195.23,195.24,195.26,195.27,195.28,195.29,195.31,195.32,195.33,195.35,195.36,195.38,195.39,195.41,195.43,195.44,195.46,195.48,195.5,195.51,195.53,195.55,195.57,195.59,195.61,195.64,195.66,195.68,195.7,195.73,},
{196.52,196.49,196.46,196.44,196.41,196.38,196.36,196.33,196.31,196.28,196.26,196.24,196.21,196.19,196.17,196.15,196.13,196.11,196.09,196.07,196.06,196.04,196.02,196.0,195.99,195.97,195.95,195.94,195.92,195.91,195.9,195.88,195.87,195.86,195.84,195.83,195.82,195.81,195.8,195.78,195.77,195.76,195.75,195.74,195.73,195.72,195.72,195.71,195.7,195.69,195.68,195.67,195.67,195.66,195.65,195.65,195.64,195.63,195.63,195.62,195.62,195.61,195.61,195.6,195.6,195.59,195.59,195.58,195.58,195.58,195.57,195.57,195.57,195.56,195.56,195.56,195.56,195.55,195.55,195.55,195.55,195.55,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.55,195.55,195.55,195.55,195.55,195.55,195.56,195.56,195.56,195.56,195.56,195.57,195.57,195.57,195.57,195.58,195.58,195.58,195.58,195.59,195.59,195.59,195.6,195.6,195.6,195.61,195.61,195.61,195.62,195.62,195.62,195.63,195.63,195.63,195.64,195.64,195.64,195.65,195.65,195.66,195.66,195.66,195.67,195.67,195.67,195.68,195.68,195.69,195.69,195.69,195.7,195.7,195.7,195.71,195.71,195.71,195.72,195.72,195.72,195.73,195.73,195.73,195.73,195.74,195.74,195.74,195.75,195.75,195.75,195.75,195.76,195.76,195.76,195.76,195.76,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.77,195.76,195.76,195.76,195.76,195.76,195.75,195.75,195.75,195.75,195.74,195.74,195.74,195.74,195.73,195.73,195.73,195.72,195.72,195.72,195.71,195.71,195.71,195.7,195.7,195.7,195.69,195.69,195.69,195.68,195.68,195.67,195.67,195.67,195.66,195.66,195.66,195.65,195.65,195.65,195.64,195.64,195.63,195.63,195.63,195.62,195.62,195.62,195.61,195.61,195.61,195.6,195.6,195.6,195.59,195.59,195.59,195.59,195.58,195.58,195.58,195.57,195.57,195.57,195.57,195.56,195.56,195.56,195.56,195.56,195.55,195.55,195.55,195.55,195.55,195.55,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.54,195.55,195.55,195.55,195.55,195.55,195.55,195.56,195.56,195.56,195.57,195.57,195.57,195.58,195.58,195.58,195.59,195.59,195.6,195.6,195.61,195.61,195.62,195.62,195.63,195.63,195.64,195.65,195.65,195.66,195.67,195.67,195.68,195.69,195.7,195.71,195.71,195.72,195.73,195.74,195.75,195.76,195.77,195.78,195.79,195.81,195.82,195.83,195.84,195.85,195.87,195.88,195.89,195.91,195.92,195.94,195.95,195.97,195.98,196.0,196.02,196.03,196.05,196.07,196.09,196.11,196.13,196.15,196.17,196.19,196.21,196.23,196.26,196.28,196.3,196.33,196.35,196.38,196.41,196.43,},
{197.22,197.19,197.16,197.13,197.1,197.07,197.04,197.01,196.98,196.96,196.93,196.91,196.88,196.86,196.83,196.81,196.79,196.76,196.74,196.72,196.7,196.68,196.66,196.64,196.63,196.61,196.59,196.57,196.56,196.54,196.52,196.51,196.49,196.48,196.46,196.45,196.44,196.42,196.41,196.4,196.39,196.38,196.36,196.35,196.34,196.33,196.32,196.31,196.3,196.29,196.28,196.28,196.27,196.26,196.25,196.24,196.24,196.23,196.22,196.22,196.21,196.2,196.2,196.19,196.19,196.18,196.18,196.17,196.17,196.16,196.16,196.16,196.15,196.15,196.15,196.14,196.14,196.14,196.14,196.13,196.13,196.13,196.13,196.13,196.13,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.13,196.13,196.13,196.13,196.13,196.13,196.13,196.14,196.14,196.14,196.14,196.14,196.15,196.15,196.15,196.15,196.16,196.16,196.16,196.16,196.17,196.17,196.17,196.18,196.18,196.18,196.19,196.19,196.19,196.2,196.2,196.21,196.21,196.21,196.22,196.22,196.23,196.23,196.23,196.24,196.24,196.25,196.25,196.25,196.26,196.26,196.27,196.27,196.27,196.28,196.28,196.29,196.29,196.29,196.3,196.3,196.31,196.31,196.31,196.32,196.32,196.32,196.33,196.33,196.33,196.34,196.34,196.34,196.35,196.35,196.35,196.36,196.36,196.36,196.36,196.37,196.37,196.37,196.37,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.39,196.39,196.39,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.38,196.37,196.37,196.37,196.37,196.36,196.36,196.36,196.36,196.35,196.35,196.35,196.35,196.34,196.34,196.34,196.33,196.33,196.33,196.32,196.32,196.31,196.31,196.31,196.3,196.3,196.29,196.29,196.29,196.28,196.28,196.27,196.27,196.27,196.26,196.26,196.25,196.25,196.25,196.24,196.24,196.23,196.23,196.23,196.22,196.22,196.21,196.21,196.21,196.2,196.2,196.2,196.19,196.19,196.18,196.18,196.18,196.17,196.17,196.17,196.17,196.16,196.16,196.16,196.15,196.15,196.15,196.15,196.14,196.14,196.14,196.14,196.14,196.13,196.13,196.13,196.13,196.13,196.13,196.13,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.12,196.13,196.13,196.13,196.13,196.13,196.13,196.14,196.14,196.14,196.14,196.15,196.15,196.15,196.16,196.16,196.16,196.17,196.17,196.18,196.18,196.19,196.19,196.2,196.2,196.21,196.22,196.22,196.23,196.24,196.24,196.25,196.26,196.27,196.27,196.28,196.29,196.3,196.31,196.32,196.33,196.34,196.35,196.36,196.37,196.39,196.4,196.41,196.42,196.44,196.45,196.46,196.48,196.49,196.51,196.52,196.54,196.55,196.57,196.59,196.6,196.62,196.64,196.66,196.68,196.7,196.72,196.74,196.76,196.78,196.81,196.83,196.85,196.88,196.9,196.93,196.95,196.98,197.01,197.04,197.06,197.09,197.12,},
{197.91,197.88,197.84,197.81,197.77,197.74,197.71,197.68,197.65,197.62,197.59,197.56,197.53,197.51,197.48,197.46,197.43,197.41,197.38,197.36,197.34,197.32,197.29,197.27,197.25,197.23,197.21,197.2,197.18,197.16,197.14,197.12,197.11,197.09,197.08,197.06,197.05,197.03,197.02,197.0,196.99,196.98,196.96,196.95,196.94,196.93,196.92,196.91,196.9,196.89,196.88,196.87,196.86,196.85,196.84,196.83,196.82,196.82,196.81,196.8,196.79,196.79,196.78,196.78,196.77,196.76,196.76,196.75,196.75,196.74,196.74,196.74,196.73,196.73,196.72,196.72,196.72,196.72,196.71,196.71,196.71,196.71,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.71,196.71,196.71,196.71,196.71,196.72,196.72,196.72,196.72,196.73,196.73,196.73,196.73,196.74,196.74,196.74,196.75,196.75,196.75,196.76,196.76,196.76,196.77,196.77,196.78,196.78,196.78,196.79,196.79,196.8,196.8,196.81,196.81,196.81,196.82,196.82,196.83,196.83,196.84,196.84,196.85,196.85,196.85,196.86,196.86,196.87,196.87,196.88,196.88,196.89,196.89,196.89,196.9,196.9,196.91,196.91,196.92,196.92,196.92,196.93,196.93,196.93,196.94,196.94,196.94,196.95,196.95,196.95,196.96,196.96,196.96,196.97,196.97,196.97,196.97,196.97,196.98,196.98,196.98,196.98,196.98,196.98,196.98,196.98,196.99,196.99,196.99,196.99,196.99,196.98,196.98,196.98,196.98,196.98,196.98,196.98,196.98,196.97,196.97,196.97,196.97,196.97,196.96,196.96,196.96,196.95,196.95,196.95,196.95,196.94,196.94,196.93,196.93,196.93,196.92,196.92,196.92,196.91,196.91,196.9,196.9,196.89,196.89,196.89,196.88,196.88,196.87,196.87,196.86,196.86,196.86,196.85,196.85,196.84,196.84,196.83,196.83,196.82,196.82,196.82,196.81,196.81,196.8,196.8,196.79,196.79,196.79,196.78,196.78,196.77,196.77,196.77,196.76,196.76,196.75,196.75,196.75,196.74,196.74,196.74,196.73,196.73,196.73,196.73,196.72,196.72,196.72,196.72,196.71,196.71,196.71,196.71,196.71,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.7,196.71,196.71,196.71,196.71,196.72,196.72,196.72,196.72,196.73,196.73,196.74,196.74,196.74,196.75,196.75,196.76,196.76,196.77,196.77,196.78,196.79,196.79,196.8,196.81,196.82,196.82,196.83,196.84,196.85,196.86,196.87,196.88,196.89,196.9,196.91,196.92,196.93,196.94,196.95,196.96,196.98,196.99,197.0,197.02,197.03,197.04,197.06,197.07,197.09,197.11,197.12,197.14,197.16,197.17,197.19,197.21,197.23,197.25,197.27,197.29,197.31,197.33,197.36,197.38,197.4,197.43,197.45,197.48,197.5,197.53,197.56,197.59,197.61,197.64,197.67,197.71,197.74,197.77,197.8,},
{198.59,198.55,198.51,198.48,198.44,198.4,198.37,198.34,198.3,198.27,198.24,198.21,198.18,198.15,198.12,198.09,198.07,198.04,198.01,197.99,197.96,197.94,197.92,197.89,197.87,197.85,197.83,197.81,197.79,197.77,197.75,197.73,197.71,197.69,197.68,197.66,197.64,197.63,197.61,197.6,197.58,197.57,197.56,197.54,197.53,197.52,197.5,197.49,197.48,197.47,197.46,197.45,197.44,197.43,197.42,197.41,197.4,197.39,197.39,197.38,197.37,197.36,197.36,197.35,197.34,197.34,197.33,197.33,197.32,197.32,197.31,197.31,197.3,197.3,197.29,197.29,197.29,197.28,197.28,197.28,197.28,197.27,197.27,197.27,197.27,197.27,197.27,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.27,197.27,197.27,197.27,197.27,197.27,197.27,197.28,197.28,197.28,197.28,197.29,197.29,197.29,197.29,197.3,197.3,197.3,197.31,197.31,197.31,197.32,197.32,197.32,197.33,197.33,197.34,197.34,197.34,197.35,197.35,197.36,197.36,197.37,197.37,197.38,197.38,197.39,197.39,197.39,197.4,197.4,197.41,197.41,197.42,197.42,197.43,197.43,197.44,197.44,197.45,197.45,197.46,197.46,197.47,197.47,197.48,197.48,197.49,197.49,197.5,197.5,197.5,197.51,197.51,197.52,197.52,197.52,197.53,197.53,197.54,197.54,197.54,197.55,197.55,197.55,197.55,197.56,197.56,197.56,197.56,197.57,197.57,197.57,197.57,197.57,197.57,197.57,197.58,197.58,197.58,197.58,197.58,197.58,197.58,197.57,197.57,197.57,197.57,197.57,197.57,197.57,197.56,197.56,197.56,197.56,197.55,197.55,197.55,197.55,197.54,197.54,197.54,197.53,197.53,197.52,197.52,197.52,197.51,197.51,197.5,197.5,197.5,197.49,197.49,197.48,197.48,197.47,197.47,197.46,197.46,197.45,197.45,197.44,197.44,197.43,197.43,197.42,197.42,197.41,197.41,197.41,197.4,197.4,197.39,197.39,197.38,197.38,197.37,197.37,197.36,197.36,197.35,197.35,197.35,197.34,197.34,197.33,197.33,197.32,197.32,197.32,197.31,197.31,197.31,197.3,197.3,197.3,197.29,197.29,197.29,197.29,197.28,197.28,197.28,197.28,197.27,197.27,197.27,197.27,197.27,197.27,197.27,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.26,197.27,197.27,197.27,197.27,197.27,197.28,197.28,197.28,197.28,197.29,197.29,197.29,197.3,197.3,197.31,197.31,197.31,197.32,197.32,197.33,197.34,197.34,197.35,197.36,197.36,197.37,197.38,197.38,197.39,197.4,197.41,197.42,197.43,197.44,197.45,197.46,197.47,197.48,197.49,197.5,197.52,197.53,197.54,197.55,197.57,197.58,197.6,197.61,197.63,197.64,197.66,197.67,197.69,197.71,197.73,197.75,197.76,197.78,197.8,197.82,197.85,197.87,197.89,197.91,197.94,197.96,197.98,198.01,198.03,198.06,198.09,198.12,198.14,198.17,198.2,198.23,198.27,198.3,198.33,198.36,198.4,198.43,198.47,},
{199.26,199.21,199.17,199.13,199.09,199.05,199.02,198.98,198.94,198.91,198.88,198.84,198.81,198.78,198.75,198.72,198.69,198.66,198.63,198.6,198.58,198.55,198.53,198.5,198.48,198.45,198.43,198.41,198.39,198.37,198.35,198.33,198.31,198.29,198.27,198.25,198.23,198.22,198.2,198.18,198.17,198.15,198.14,198.12,198.11,198.1,198.08,198.07,198.06,198.05,198.03,198.02,198.01,198.0,197.99,197.98,197.97,197.96,197.95,197.94,197.94,197.93,197.92,197.91,197.91,197.9,197.89,197.89,197.88,197.88,197.87,197.87,197.86,197.86,197.85,197.85,197.85,197.84,197.84,197.84,197.83,197.83,197.83,197.83,197.83,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.83,197.83,197.83,197.83,197.83,197.84,197.84,197.84,197.84,197.85,197.85,197.85,197.86,197.86,197.86,197.87,197.87,197.87,197.88,197.88,197.89,197.89,197.89,197.9,197.9,197.91,197.91,197.92,197.92,197.93,197.93,197.94,197.94,197.95,197.95,197.96,197.96,197.97,197.97,197.98,197.98,197.99,197.99,198.0,198.0,198.01,198.01,198.02,198.02,198.03,198.03,198.04,198.04,198.05,198.05,198.06,198.06,198.07,198.07,198.08,198.08,198.09,198.09,198.1,198.1,198.1,198.11,198.11,198.12,198.12,198.12,198.13,198.13,198.13,198.14,198.14,198.14,198.14,198.15,198.15,198.15,198.15,198.15,198.15,198.15,198.16,198.16,198.16,198.16,198.16,198.16,198.16,198.15,198.15,198.15,198.15,198.15,198.15,198.15,198.14,198.14,198.14,198.14,198.13,198.13,198.13,198.12,198.12,198.12,198.11,198.11,198.11,198.1,198.1,198.09,198.09,198.08,198.08,198.07,198.07,198.07,198.06,198.06,198.05,198.05,198.04,198.04,198.03,198.03,198.02,198.01,198.01,198.0,198.0,197.99,197.99,197.98,197.98,197.97,197.97,197.96,197.96,197.95,197.95,197.94,197.94,197.93,197.93,197.92,197.92,197.91,197.91,197.9,197.9,197.9,197.89,197.89,197.88,197.88,197.87,197.87,197.87,197.86,197.86,197.86,197.85,197.85,197.85,197.84,197.84,197.84,197.84,197.83,197.83,197.83,197.83,197.83,197.83,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.82,197.83,197.83,197.83,197.83,197.83,197.84,197.84,197.84,197.85,197.85,197.85,197.86,197.86,197.87,197.87,197.88,197.88,197.89,197.89,197.9,197.91,197.91,197.92,197.93,197.94,197.94,197.95,197.96,197.97,197.98,197.99,198.0,198.01,198.02,198.03,198.04,198.06,198.07,198.08,198.09,198.11,198.12,198.14,198.15,198.17,198.18,198.2,198.21,198.23,198.25,198.27,198.28,198.3,198.32,198.34,198.36,198.38,198.41,198.43,198.45,198.47,198.5,198.52,198.55,198.57,198.6,198.63,198.66,198.68,198.71,198.74,198.77,198.81,198.84,198.87,198.9,198.94,198.97,199.01,199.05,199.09,199.13,},
{199.91,199.86,199.82,199.78,199.73,199.69,199.65,199.61,199.58,199.54,199.5,199.47,199.43,199.4,199.36,199.33,199.3,199.27,199.24,199.21,199.18,199.16,199.13,199.1,199.08,199.05,199.03,199.0,198.98,198.96,198.93,198.91,198.89,198.87,198.85,198.83,198.81,198.79,198.78,198.76,198.74,198.73,198.71,198.7,198.68,198.67,198.65,198.64,198.62,198.61,198.6,198.59,198.57,198.56,198.55,198.54,198.53,198.52,198.51,198.5,198.49,198.49,198.48,198.47,198.46,198.46,198.45,198.44,198.44,198.43,198.42,198.42,198.41,198.41,198.41,198.4,198.4,198.39,198.39,198.39,198.38,198.38,198.38,198.38,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.38,198.38,198.38,198.38,198.38,198.39,198.39,198.39,198.39,198.4,198.4,198.4,198.41,198.41,198.41,198.42,198.42,198.43,198.43,198.43,198.44,198.44,198.45,198.45,198.46,198.46,198.47,198.47,198.48,198.48,198.49,198.49,198.5,198.5,198.51,198.51,198.52,198.52,198.53,198.54,198.54,198.55,198.55,198.56,198.56,198.57,198.58,198.58,198.59,198.59,198.6,198.6,198.61,198.61,198.62,198.62,198.63,198.63,198.64,198.64,198.65,198.65,198.66,198.66,198.67,198.67,198.68,198.68,198.68,198.69,198.69,198.7,198.7,198.7,198.7,198.71,198.71,198.71,198.71,198.72,198.72,198.72,198.72,198.72,198.72,198.73,198.73,198.73,198.73,198.73,198.73,198.73,198.72,198.72,198.72,198.72,198.72,198.72,198.72,198.71,198.71,198.71,198.71,198.7,198.7,198.7,198.69,198.69,198.68,198.68,198.68,198.67,198.67,198.66,198.66,198.65,198.65,198.64,198.64,198.63,198.63,198.62,198.62,198.61,198.61,198.6,198.6,198.59,198.59,198.58,198.58,198.57,198.56,198.56,198.55,198.55,198.54,198.54,198.53,198.53,198.52,198.51,198.51,198.5,198.5,198.49,198.49,198.48,198.48,198.47,198.47,198.46,198.46,198.45,198.45,198.44,198.44,198.43,198.43,198.43,198.42,198.42,198.41,198.41,198.41,198.4,198.4,198.4,198.39,198.39,198.39,198.39,198.38,198.38,198.38,198.38,198.38,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.37,198.38,198.38,198.38,198.38,198.39,198.39,198.39,198.4,198.4,198.4,198.41,198.41,198.42,198.42,198.43,198.44,198.44,198.45,198.45,198.46,198.47,198.48,198.48,198.49,198.5,198.51,198.52,198.53,198.54,198.55,198.56,198.57,198.58,198.6,198.61,198.62,198.64,198.65,198.66,198.68,198.69,198.71,198.72,198.74,198.76,198.77,198.79,198.81,198.83,198.85,198.87,198.89,198.91,198.93,198.95,198.98,199.0,199.02,199.05,199.07,199.1,199.12,199.15,199.18,199.21,199.24,199.27,199.3,199.33,199.36,199.39,199.43,199.46,199.5,199.53,199.57,199.61,199.65,199.69,199.73,199.77,},
{200.55,200.5,200.46,200.41,200.36,200.32,200.28,200.24,200.2,200.16,200.12,200.08,200.04,200.01,199.97,199.94,199.9,199.87,199.84,199.81,199.78,199.75,199.72,199.69,199.66,199.64,199.61,199.59,199.56,199.54,199.51,199.49,199.47,199.45,199.42,199.4,199.38,199.36,199.35,199.33,199.31,199.29,199.27,199.26,199.24,199.23,199.21,199.2,199.18,199.17,199.16,199.14,199.13,199.12,199.11,199.09,199.08,199.07,199.06,199.05,199.04,199.04,199.03,199.02,199.01,199.0,199.0,198.99,198.98,198.98,198.97,198.96,198.96,198.95,198.95,198.94,198.94,198.94,198.93,198.93,198.93,198.92,198.92,198.92,198.92,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.92,198.92,198.92,198.92,198.92,198.93,198.93,198.93,198.94,198.94,198.94,198.95,198.95,198.95,198.96,198.96,198.96,198.97,198.97,198.98,198.98,198.99,198.99,199.0,199.0,199.01,199.01,199.02,199.02,199.03,199.03,199.04,199.05,199.05,199.06,199.06,199.07,199.07,199.08,199.09,199.09,199.1,199.1,199.11,199.12,199.12,199.13,199.13,199.14,199.14,199.15,199.16,199.16,199.17,199.17,199.18,199.18,199.19,199.19,199.2,199.21,199.21,199.22,199.22,199.22,199.23,199.23,199.24,199.24,199.25,199.25,199.25,199.26,199.26,199.26,199.27,199.27,199.27,199.27,199.28,199.28,199.28,199.28,199.28,199.28,199.29,199.29,199.29,199.29,199.29,199.29,199.29,199.28,199.28,199.28,199.28,199.28,199.28,199.28,199.27,199.27,199.27,199.26,199.26,199.26,199.25,199.25,199.25,199.24,199.24,199.23,199.23,199.23,199.22,199.22,199.21,199.21,199.2,199.2,199.19,199.18,199.18,199.17,199.17,199.16,199.16,199.15,199.15,199.14,199.13,199.13,199.12,199.12,199.11,199.1,199.1,199.09,199.09,199.08,199.07,199.07,199.06,199.06,199.05,199.05,199.04,199.03,199.03,199.02,199.02,199.01,199.01,199.0,199.0,198.99,198.99,198.98,198.98,198.97,198.97,198.97,198.96,198.96,198.95,198.95,198.95,198.94,198.94,198.94,198.93,198.93,198.93,198.92,198.92,198.92,198.92,198.92,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.91,198.92,198.92,198.92,198.92,198.93,198.93,198.93,198.94,198.94,198.94,198.95,198.95,198.96,198.96,198.97,198.97,198.98,198.99,198.99,199.0,199.01,199.02,199.03,199.03,199.04,199.05,199.06,199.07,199.08,199.09,199.1,199.12,199.13,199.14,199.15,199.17,199.18,199.19,199.21,199.22,199.24,199.26,199.27,199.29,199.31,199.32,199.34,199.36,199.38,199.4,199.42,199.44,199.46,199.49,199.51,199.53,199.56,199.58,199.61,199.63,199.66,199.69,199.72,199.74,199.77,199.8,199.83,199.87,199.9,199.93,199.97,200.0,200.04,200.07,200.11,200.15,200.19,200.23,200.27,200.31,200.36,200.4,},
{201.18,201.13,201.08,201.03,200.98,200.94,200.89,200.85,200.81,200.76,200.72,200.68,200.64,200.61,200.57,200.53,200.5,200.46,200.43,200.4,200.36,200.33,200.3,200.27,200.24,200.21,200.19,200.16,200.13,200.11,200.08,200.06,200.04,200.01,199.99,199.97,199.95,199.93,199.91,199.89,199.87,199.85,199.83,199.81,199.8,199.78,199.76,199.75,199.73,199.72,199.7,199.69,199.68,199.66,199.65,199.64,199.63,199.62,199.61,199.6,199.59,199.58,199.57,199.56,199.55,199.54,199.53,199.53,199.52,199.51,199.51,199.5,199.49,199.49,199.48,199.48,199.47,199.47,199.47,199.46,199.46,199.46,199.45,199.45,199.45,199.45,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.45,199.45,199.45,199.45,199.45,199.46,199.46,199.46,199.47,199.47,199.47,199.48,199.48,199.48,199.49,199.49,199.49,199.5,199.5,199.51,199.51,199.52,199.52,199.53,199.53,199.54,199.54,199.55,199.56,199.56,199.57,199.57,199.58,199.58,199.59,199.6,199.6,199.61,199.61,199.62,199.63,199.63,199.64,199.65,199.65,199.66,199.66,199.67,199.68,199.68,199.69,199.69,199.7,199.71,199.71,199.72,199.72,199.73,199.74,199.74,199.75,199.75,199.76,199.76,199.77,199.77,199.78,199.78,199.79,199.79,199.8,199.8,199.8,199.81,199.81,199.81,199.82,199.82,199.82,199.83,199.83,199.83,199.83,199.83,199.83,199.84,199.84,199.84,199.84,199.84,199.84,199.84,199.84,199.84,199.83,199.83,199.83,199.83,199.83,199.83,199.82,199.82,199.82,199.81,199.81,199.81,199.8,199.8,199.8,199.79,199.79,199.78,199.78,199.77,199.77,199.76,199.76,199.75,199.75,199.74,199.74,199.73,199.73,199.72,199.71,199.71,199.7,199.7,199.69,199.68,199.68,199.67,199.66,199.66,199.65,199.65,199.64,199.63,199.63,199.62,199.62,199.61,199.6,199.6,199.59,199.58,199.58,199.57,199.57,199.56,199.56,199.55,199.54,199.54,199.53,199.53,199.52,199.52,199.51,199.51,199.5,199.5,199.5,199.49,199.49,199.48,199.48,199.48,199.47,199.47,199.47,199.46,199.46,199.46,199.45,199.45,199.45,199.45,199.45,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.44,199.45,199.45,199.45,199.45,199.46,199.46,199.46,199.47,199.47,199.47,199.48,199.48,199.49,199.49,199.5,199.5,199.51,199.52,199.52,199.53,199.54,199.55,199.56,199.57,199.57,199.58,199.59,199.6,199.61,199.63,199.64,199.65,199.66,199.67,199.69,199.7,199.72,199.73,199.75,199.76,199.78,199.79,199.81,199.83,199.85,199.86,199.88,199.9,199.92,199.94,199.96,199.99,200.01,200.03,200.06,200.08,200.1,200.13,200.16,200.18,200.21,200.24,200.27,200.3,200.33,200.36,200.39,200.42,200.46,200.49,200.53,200.56,200.6,200.64,200.68,200.72,200.76,200.8,200.84,200.89,200.93,200.98,201.03,},
{201.8,201.75,201.7,201.64,201.59,201.55,201.5,201.45,201.41,201.36,201.32,201.28,201.24,201.2,201.16,201.12,201.08,201.04,201.01,200.97,200.94,200.91,200.88,200.84,200.81,200.78,200.75,200.73,200.7,200.67,200.64,200.62,200.59,200.57,200.55,200.52,200.5,200.48,200.46,200.44,200.42,200.4,200.38,200.36,200.34,200.32,200.31,200.29,200.27,200.26,200.24,200.23,200.21,200.2,200.19,200.18,200.16,200.15,200.14,200.13,200.12,200.11,200.1,200.09,200.08,200.07,200.06,200.06,200.05,200.04,200.03,200.03,200.02,200.02,200.01,200.01,200.0,200.0,199.99,199.99,199.98,199.98,199.98,199.98,199.97,199.97,199.97,199.97,199.97,199.97,199.96,199.96,199.96,199.96,199.96,199.96,199.97,199.97,199.97,199.97,199.97,199.97,199.97,199.98,199.98,199.98,199.98,199.99,199.99,199.99,200.0,200.0,200.0,200.01,200.01,200.02,200.02,200.03,200.03,200.04,200.04,200.05,200.05,200.06,200.06,200.07,200.07,200.08,200.08,200.09,200.1,200.1,200.11,200.11,200.12,200.13,200.13,200.14,200.15,200.15,200.16,200.17,200.17,200.18,200.18,200.19,200.2,200.2,200.21,200.22,200.22,200.23,200.24,200.24,200.25,200.26,200.26,200.27,200.27,200.28,200.28,200.29,200.3,200.3,200.31,200.31,200.32,200.32,200.33,200.33,200.34,200.34,200.34,200.35,200.35,200.35,200.36,200.36,200.36,200.37,200.37,200.37,200.37,200.37,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.38,200.37,200.37,200.37,200.37,200.36,200.36,200.36,200.36,200.35,200.35,200.34,200.34,200.34,200.33,200.33,200.32,200.32,200.31,200.31,200.3,200.3,200.29,200.29,200.28,200.27,200.27,200.26,200.26,200.25,200.24,200.24,200.23,200.22,200.22,200.21,200.21,200.2,200.19,200.19,200.18,200.17,200.17,200.16,200.15,200.15,200.14,200.13,200.13,200.12,200.12,200.11,200.1,200.1,200.09,200.08,200.08,200.07,200.07,200.06,200.06,200.05,200.05,200.04,200.04,200.03,200.03,200.02,200.02,200.01,200.01,200.0,200.0,200.0,199.99,199.99,199.99,199.98,199.98,199.98,199.98,199.97,199.97,199.97,199.97,199.97,199.97,199.97,199.96,199.96,199.96,199.96,199.96,199.96,199.97,199.97,199.97,199.97,199.97,199.97,199.98,199.98,199.98,199.98,199.99,199.99,200.0,200.0,200.0,200.01,200.02,200.02,200.03,200.03,200.04,200.05,200.05,200.06,200.07,200.08,200.09,200.1,200.11,200.12,200.13,200.14,200.15,200.16,200.17,200.19,200.2,200.21,200.23,200.24,200.26,200.27,200.29,200.3,200.32,200.34,200.36,200.37,200.39,200.41,200.43,200.45,200.47,200.5,200.52,200.54,200.57,200.59,200.61,200.64,200.67,200.69,200.72,200.75,200.78,200.81,200.84,200.87,200.9,200.94,200.97,201.0,201.04,201.08,201.11,201.15,201.19,201.23,201.27,201.31,201.36,201.4,201.45,201.49,201.54,201.59,201.64,},
{202.41,202.36,202.3,202.25,202.19,202.14,202.09,202.05,202.0,201.95,201.91,201.86,201.82,201.78,201.74,201.69,201.66,201.62,201.58,201.54,201.51,201.47,201.44,201.41,201.37,201.34,201.31,201.28,201.25,201.22,201.2,201.17,201.14,201.12,201.09,201.07,201.05,201.02,201.0,200.98,200.96,200.94,200.92,200.9,200.88,200.86,200.84,200.82,200.81,200.79,200.78,200.76,200.75,200.73,200.72,200.7,200.69,200.68,200.67,200.66,200.64,200.63,200.62,200.61,200.6,200.59,200.59,200.58,200.57,200.56,200.55,200.55,200.54,200.54,200.53,200.52,200.52,200.51,200.51,200.51,200.5,200.5,200.5,200.49,200.49,200.49,200.49,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.49,200.49,200.49,200.49,200.49,200.5,200.5,200.5,200.5,200.51,200.51,200.51,200.52,200.52,200.53,200.53,200.53,200.54,200.54,200.55,200.55,200.56,200.56,200.57,200.58,200.58,200.59,200.59,200.6,200.6,200.61,200.62,200.62,200.63,200.64,200.64,200.65,200.66,200.66,200.67,200.68,200.68,200.69,200.7,200.7,200.71,200.72,200.72,200.73,200.74,200.74,200.75,200.76,200.76,200.77,200.78,200.78,200.79,200.8,200.8,200.81,200.81,200.82,200.83,200.83,200.84,200.84,200.85,200.85,200.86,200.86,200.87,200.87,200.88,200.88,200.88,200.89,200.89,200.89,200.9,200.9,200.9,200.9,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.91,200.9,200.9,200.9,200.9,200.89,200.89,200.89,200.88,200.88,200.88,200.87,200.87,200.86,200.86,200.85,200.85,200.84,200.84,200.83,200.83,200.82,200.81,200.81,200.8,200.8,200.79,200.78,200.78,200.77,200.76,200.76,200.75,200.74,200.74,200.73,200.72,200.72,200.71,200.7,200.7,200.69,200.68,200.68,200.67,200.66,200.66,200.65,200.64,200.64,200.63,200.62,200.62,200.61,200.61,200.6,200.59,200.59,200.58,200.58,200.57,200.57,200.56,200.55,200.55,200.54,200.54,200.54,200.53,200.53,200.52,200.52,200.51,200.51,200.51,200.5,200.5,200.5,200.5,200.49,200.49,200.49,200.49,200.49,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.48,200.49,200.49,200.49,200.49,200.5,200.5,200.5,200.51,200.51,200.51,200.52,200.52,200.53,200.53,200.54,200.55,200.55,200.56,200.57,200.58,200.58,200.59,200.6,200.61,200.62,200.63,200.64,200.65,200.66,200.68,200.69,200.7,200.72,200.73,200.74,200.76,200.77,200.79,200.8,200.82,200.84,200.86,200.87,200.89,200.91,200.93,200.95,200.97,201.0,201.02,201.04,201.07,201.09,201.11,201.14,201.17,201.19,201.22,201.25,201.28,201.31,201.34,201.37,201.4,201.43,201.47,201.5,201.54,201.57,201.61,201.65,201.69,201.73,201.77,201.81,201.86,201.9,201.94,201.99,202.04,202.09,202.14,202.19,202.24,},
{203.01,202.95,202.9,202.84,202.78,202.73,202.68,202.63,202.58,202.53,202.48,202.44,202.39,202.35,202.3,202.26,202.22,202.18,202.14,202.1,202.07,202.03,202.0,201.96,201.93,201.89,201.86,201.83,201.8,201.77,201.74,201.71,201.69,201.66,201.63,201.61,201.58,201.56,201.53,201.51,201.49,201.47,201.45,201.43,201.41,201.39,201.37,201.35,201.33,201.32,201.3,201.28,201.27,201.25,201.24,201.22,201.21,201.2,201.19,201.17,201.16,201.15,201.14,201.13,201.12,201.11,201.1,201.09,201.08,201.08,201.07,201.06,201.05,201.05,201.04,201.04,201.03,201.03,201.02,201.02,201.01,201.01,201.01,201.0,201.0,201.0,201.0,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,201.0,201.0,201.0,201.0,201.0,201.01,201.01,201.01,201.02,201.02,201.02,201.03,201.03,201.04,201.04,201.04,201.05,201.05,201.06,201.06,201.07,201.08,201.08,201.09,201.09,201.1,201.1,201.11,201.12,201.12,201.13,201.14,201.14,201.15,201.16,201.16,201.17,201.18,201.18,201.19,201.2,201.21,201.21,201.22,201.23,201.23,201.24,201.25,201.25,201.26,201.27,201.28,201.28,201.29,201.3,201.3,201.31,201.32,201.32,201.33,201.33,201.34,201.35,201.35,201.36,201.36,201.37,201.37,201.38,201.38,201.39,201.39,201.4,201.4,201.41,201.41,201.41,201.42,201.42,201.42,201.42,201.43,201.43,201.43,201.43,201.43,201.43,201.44,201.44,201.44,201.44,201.44,201.43,201.43,201.43,201.43,201.43,201.43,201.43,201.42,201.42,201.42,201.41,201.41,201.41,201.4,201.4,201.39,201.39,201.38,201.38,201.37,201.37,201.36,201.36,201.35,201.35,201.34,201.34,201.33,201.32,201.32,201.31,201.3,201.3,201.29,201.28,201.28,201.27,201.26,201.26,201.25,201.24,201.23,201.23,201.22,201.21,201.21,201.2,201.19,201.19,201.18,201.17,201.16,201.16,201.15,201.14,201.14,201.13,201.12,201.12,201.11,201.11,201.1,201.09,201.09,201.08,201.08,201.07,201.07,201.06,201.06,201.05,201.05,201.04,201.04,201.03,201.03,201.02,201.02,201.02,201.01,201.01,201.01,201.0,201.0,201.0,201.0,201.0,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,200.99,201.0,201.0,201.0,201.0,201.01,201.01,201.01,201.02,201.02,201.03,201.03,201.04,201.04,201.05,201.05,201.06,201.07,201.07,201.08,201.09,201.1,201.11,201.12,201.13,201.14,201.15,201.16,201.17,201.18,201.2,201.21,201.22,201.24,201.25,201.27,201.28,201.3,201.31,201.33,201.35,201.37,201.38,201.4,201.42,201.44,201.46,201.49,201.51,201.53,201.55,201.58,201.6,201.63,201.65,201.68,201.71,201.74,201.77,201.8,201.83,201.86,201.89,201.92,201.96,201.99,202.03,202.06,202.1,202.14,202.18,202.22,202.26,202.3,202.34,202.38,202.43,202.48,202.52,202.57,202.62,202.67,202.72,202.78,202.83,},
{203.6,203.54,203.48,203.42,203.37,203.31,203.26,203.2,203.15,203.1,203.05,203.0,202.96,202.91,202.87,202.82,202.78,202.74,202.7,202.66,202.62,202.58,202.54,202.51,202.47,202.44,202.4,202.37,202.34,202.31,202.28,202.25,202.22,202.19,202.16,202.14,202.11,202.09,202.06,202.04,202.01,201.99,201.97,201.95,201.93,201.91,201.89,201.87,201.85,201.83,201.82,201.8,201.78,201.77,201.75,201.74,201.72,201.71,201.7,201.68,201.67,201.66,201.65,201.64,201.63,201.62,201.61,201.6,201.59,201.58,201.57,201.57,201.56,201.55,201.55,201.54,201.53,201.53,201.52,201.52,201.52,201.51,201.51,201.51,201.5,201.5,201.5,201.5,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.5,201.5,201.5,201.5,201.51,201.51,201.51,201.51,201.52,201.52,201.53,201.53,201.53,201.54,201.54,201.55,201.55,201.56,201.56,201.57,201.57,201.58,201.59,201.59,201.6,201.6,201.61,201.62,201.62,201.63,201.64,201.64,201.65,201.66,201.66,201.67,201.68,201.68,201.69,201.7,201.71,201.71,201.72,201.73,201.73,201.74,201.75,201.76,201.76,201.77,201.78,201.79,201.79,201.8,201.81,201.81,201.82,201.83,201.83,201.84,201.85,201.85,201.86,201.86,201.87,201.88,201.88,201.89,201.89,201.9,201.9,201.91,201.91,201.92,201.92,201.92,201.93,201.93,201.93,201.94,201.94,201.94,201.94,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.95,201.94,201.94,201.94,201.94,201.93,201.93,201.93,201.92,201.92,201.92,201.91,201.91,201.9,201.9,201.89,201.89,201.88,201.88,201.87,201.87,201.86,201.85,201.85,201.84,201.83,201.83,201.82,201.81,201.81,201.8,201.79,201.79,201.78,201.77,201.77,201.76,201.75,201.74,201.74,201.73,201.72,201.71,201.71,201.7,201.69,201.69,201.68,201.67,201.66,201.66,201.65,201.64,201.64,201.63,201.62,201.62,201.61,201.6,201.6,201.59,201.59,201.58,201.57,201.57,201.56,201.56,201.55,201.55,201.54,201.54,201.53,201.53,201.53,201.52,201.52,201.52,201.51,201.51,201.51,201.5,201.5,201.5,201.5,201.5,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.49,201.5,201.5,201.5,201.5,201.5,201.51,201.51,201.52,201.52,201.52,201.53,201.53,201.54,201.55,201.55,201.56,201.57,201.57,201.58,201.59,201.6,201.61,201.62,201.63,201.64,201.65,201.66,201.67,201.68,201.69,201.71,201.72,201.74,201.75,201.77,201.78,201.8,201.81,201.83,201.85,201.87,201.89,201.91,201.93,201.95,201.97,201.99,202.01,202.03,202.06,202.08,202.11,202.13,202.16,202.19,202.22,202.24,202.27,202.3,202.33,202.37,202.4,202.43,202.47,202.5,202.54,202.57,202.61,202.65,202.69,202.73,202.77,202.81,202.86,202.9,202.95,203.0,203.04,203.09,203.14,203.2,203.25,203.3,203.36,203.41,},
{204.18,204.12,204.06,204.0,203.94,203.88,203.82,203.77,203.71,203.66,203.61,203.56,203.51,203.46,203.42,203.37,203.33,203.28,203.24,203.2,203.16,203.12,203.08,203.04,203.01,202.97,202.94,202.9,202.87,202.84,202.81,202.78,202.75,202.72,202.69,202.66,202.63,202.61,202.58,202.56,202.53,202.51,202.49,202.46,202.44,202.42,202.4,202.38,202.36,202.34,202.33,202.31,202.29,202.27,202.26,202.24,202.23,202.21,202.2,202.19,202.17,202.16,202.15,202.14,202.13,202.12,202.11,202.1,202.09,202.08,202.07,202.06,202.06,202.05,202.04,202.04,202.03,202.03,202.02,202.02,202.01,202.01,202.0,202.0,202.0,201.99,201.99,201.99,201.99,201.99,201.99,201.99,201.98,201.98,201.98,201.98,201.99,201.99,201.99,201.99,201.99,201.99,201.99,202.0,202.0,202.0,202.01,202.01,202.01,202.02,202.02,202.02,202.03,202.03,202.04,202.04,202.05,202.05,202.06,202.06,202.07,202.08,202.08,202.09,202.09,202.1,202.11,202.11,202.12,202.13,202.13,202.14,202.15,202.15,202.16,202.17,202.18,202.18,202.19,202.2,202.21,202.21,202.22,202.23,202.24,202.24,202.25,202.26,202.27,202.27,202.28,202.29,202.29,202.3,202.31,202.32,202.32,202.33,202.34,202.34,202.35,202.36,202.36,202.37,202.38,202.38,202.39,202.39,202.4,202.4,202.41,202.41,202.42,202.42,202.43,202.43,202.43,202.44,202.44,202.44,202.45,202.45,202.45,202.45,202.45,202.46,202.46,202.46,202.46,202.46,202.46,202.46,202.46,202.46,202.45,202.45,202.45,202.45,202.45,202.44,202.44,202.44,202.43,202.43,202.43,202.42,202.42,202.41,202.41,202.4,202.4,202.39,202.39,202.38,202.38,202.37,202.36,202.36,202.35,202.34,202.34,202.33,202.32,202.32,202.31,202.3,202.3,202.29,202.28,202.27,202.27,202.26,202.25,202.24,202.24,202.23,202.22,202.21,202.21,202.2,202.19,202.18,202.18,202.17,202.16,202.16,202.15,202.14,202.13,202.13,202.12,202.11,202.11,202.1,202.09,202.09,202.08,202.08,202.07,202.06,202.06,202.05,202.05,202.04,202.04,202.03,202.03,202.02,202.02,202.02,202.01,202.01,202.01,202.0,202.0,202.0,201.99,201.99,201.99,201.99,201.99,201.99,201.99,201.98,201.98,201.98,201.98,201.98,201.99,201.99,201.99,201.99,201.99,201.99,202.0,202.0,202.0,202.01,202.01,202.02,202.02,202.03,202.03,202.04,202.04,202.05,202.06,202.06,202.07,202.08,202.09,202.1,202.11,202.12,202.13,202.14,202.15,202.16,202.17,202.19,202.2,202.21,202.23,202.24,202.26,202.27,202.29,202.31,202.32,202.34,202.36,202.38,202.4,202.42,202.44,202.46,202.48,202.51,202.53,202.55,202.58,202.6,202.63,202.66,202.68,202.71,202.74,202.77,202.8,202.83,202.86,202.9,202.93,202.97,203.0,203.04,203.08,203.11,203.15,203.19,203.24,203.28,203.32,203.36,203.41,203.46,203.5,203.55,203.6,203.65,203.71,203.76,203.82,203.87,203.93,203.99,},
{204.75,204.69,204.62,204.56,204.5,204.44,204.38,204.32,204.27,204.21,204.16,204.11,204.06,204.01,203.96,203.91,203.87,203.82,203.78,203.74,203.69,203.65,203.61,203.57,203.54,203.5,203.46,203.43,203.39,203.36,203.33,203.29,203.26,203.23,203.2,203.18,203.15,203.12,203.09,203.07,203.04,203.02,202.99,202.97,202.95,202.93,202.91,202.89,202.87,202.85,202.83,202.81,202.79,202.77,202.76,202.74,202.73,202.71,202.7,202.68,202.67,202.66,202.65,202.63,202.62,202.61,202.6,202.59,202.58,202.57,202.56,202.56,202.55,202.54,202.53,202.53,202.52,202.52,202.51,202.5,202.5,202.5,202.49,202.49,202.49,202.48,202.48,202.48,202.48,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.48,202.48,202.48,202.48,202.48,202.49,202.49,202.49,202.5,202.5,202.5,202.51,202.51,202.52,202.52,202.53,202.53,202.54,202.54,202.55,202.55,202.56,202.56,202.57,202.58,202.58,202.59,202.6,202.6,202.61,202.62,202.62,202.63,202.64,202.64,202.65,202.66,202.67,202.67,202.68,202.69,202.7,202.71,202.71,202.72,202.73,202.74,202.74,202.75,202.76,202.77,202.77,202.78,202.79,202.8,202.8,202.81,202.82,202.83,202.83,202.84,202.85,202.85,202.86,202.87,202.87,202.88,202.88,202.89,202.89,202.9,202.91,202.91,202.91,202.92,202.92,202.93,202.93,202.93,202.94,202.94,202.94,202.95,202.95,202.95,202.95,202.95,202.95,202.96,202.96,202.96,202.96,202.96,202.95,202.95,202.95,202.95,202.95,202.95,202.94,202.94,202.94,202.94,202.93,202.93,202.92,202.92,202.92,202.91,202.91,202.9,202.9,202.89,202.88,202.88,202.87,202.87,202.86,202.85,202.85,202.84,202.83,202.83,202.82,202.81,202.8,202.8,202.79,202.78,202.78,202.77,202.76,202.75,202.74,202.74,202.73,202.72,202.71,202.71,202.7,202.69,202.68,202.68,202.67,202.66,202.65,202.65,202.64,202.63,202.62,202.62,202.61,202.6,202.6,202.59,202.58,202.58,202.57,202.56,202.56,202.55,202.55,202.54,202.54,202.53,202.53,202.52,202.52,202.51,202.51,202.5,202.5,202.5,202.49,202.49,202.49,202.48,202.48,202.48,202.48,202.48,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.47,202.48,202.48,202.48,202.48,202.48,202.49,202.49,202.5,202.5,202.5,202.51,202.51,202.52,202.53,202.53,202.54,202.55,202.55,202.56,202.57,202.58,202.59,202.6,202.61,202.62,202.63,202.64,202.66,202.67,202.68,202.7,202.71,202.72,202.74,202.76,202.77,202.79,202.81,202.82,202.84,202.86,202.88,202.9,202.92,202.95,202.97,202.99,203.01,203.04,203.06,203.09,203.12,203.14,203.17,203.2,203.23,203.26,203.29,203.32,203.35,203.39,203.42,203.46,203.49,203.53,203.57,203.61,203.65,203.69,203.73,203.77,203.82,203.86,203.91,203.95,204.0,204.05,204.1,204.15,204.21,204.26,204.32,204.37,204.43,204.49,204.55,},
{205.32,205.25,205.18,205.12,205.05,204.99,204.93,204.87,204.82,204.76,204.7,204.65,204.6,204.55,204.5,204.45,204.4,204.35,204.31,204.26,204.22,204.18,204.14,204.1,204.06,204.02,203.98,203.94,203.91,203.87,203.84,203.81,203.77,203.74,203.71,203.68,203.65,203.63,203.6,203.57,203.55,203.52,203.5,203.47,203.45,203.43,203.4,203.38,203.36,203.34,203.32,203.3,203.29,203.27,203.25,203.23,203.22,203.2,203.19,203.17,203.16,203.15,203.13,203.12,203.11,203.1,203.09,203.08,203.07,203.06,203.05,203.04,203.03,203.02,203.02,203.01,203.0,203.0,202.99,202.99,202.98,202.98,202.97,202.97,202.97,202.96,202.96,202.96,202.96,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.96,202.96,202.96,202.96,202.96,202.97,202.97,202.97,202.98,202.98,202.98,202.99,202.99,203.0,203.0,203.01,203.01,203.02,203.02,203.03,203.03,203.04,203.04,203.05,203.06,203.06,203.07,203.08,203.08,203.09,203.1,203.11,203.11,203.12,203.13,203.14,203.14,203.15,203.16,203.17,203.17,203.18,203.19,203.2,203.21,203.21,203.22,203.23,203.24,203.24,203.25,203.26,203.27,203.28,203.28,203.29,203.3,203.31,203.31,203.32,203.33,203.33,203.34,203.35,203.35,203.36,203.37,203.37,203.38,203.38,203.39,203.39,203.4,203.4,203.41,203.41,203.42,203.42,203.42,203.43,203.43,203.43,203.44,203.44,203.44,203.44,203.44,203.44,203.45,203.45,203.45,203.45,203.45,203.45,203.44,203.44,203.44,203.44,203.44,203.43,203.43,203.43,203.43,203.42,203.42,203.41,203.41,203.4,203.4,203.4,203.39,203.38,203.38,203.37,203.37,203.36,203.35,203.35,203.34,203.33,203.33,203.32,203.31,203.31,203.3,203.29,203.28,203.28,203.27,203.26,203.25,203.25,203.24,203.23,203.22,203.21,203.21,203.2,203.19,203.18,203.18,203.17,203.16,203.15,203.14,203.14,203.13,203.12,203.11,203.11,203.1,203.09,203.09,203.08,203.07,203.06,203.06,203.05,203.05,203.04,203.03,203.03,203.02,203.02,203.01,203.01,203.0,203.0,202.99,202.99,202.98,202.98,202.98,202.97,202.97,202.97,202.96,202.96,202.96,202.96,202.96,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.95,202.96,202.96,202.96,202.96,202.97,202.97,202.97,202.98,202.98,202.99,202.99,203.0,203.0,203.01,203.02,203.02,203.03,203.04,203.05,203.06,203.07,203.08,203.09,203.1,203.11,203.12,203.13,203.14,203.16,203.17,203.19,203.2,203.22,203.23,203.25,203.27,203.28,203.3,203.32,203.34,203.36,203.38,203.4,203.42,203.44,203.47,203.49,203.52,203.54,203.57,203.59,203.62,203.65,203.68,203.71,203.74,203.77,203.8,203.84,203.87,203.9,203.94,203.98,204.01,204.05,204.09,204.13,204.17,204.21,204.26,204.3,204.35,204.39,204.44,204.49,204.54,204.59,204.64,204.7,204.75,204.81,204.86,204.92,204.98,205.05,205.11,},
{205.87,205.8,205.73,205.67,205.6,205.54,205.47,205.41,205.35,205.3,205.24,205.18,205.13,205.08,205.02,204.97,204.92,204.88,204.83,204.78,204.74,204.7,204.65,204.61,204.57,204.53,204.49,204.45,204.42,204.38,204.35,204.31,204.28,204.25,204.21,204.18,204.15,204.12,204.1,204.07,204.04,204.02,203.99,203.96,203.94,203.92,203.89,203.87,203.85,203.83,203.81,203.79,203.77,203.75,203.74,203.72,203.7,203.69,203.67,203.66,203.64,203.63,203.61,203.6,203.59,203.58,203.57,203.56,203.55,203.54,203.53,203.52,203.51,203.5,203.49,203.49,203.48,203.47,203.47,203.46,203.46,203.45,203.45,203.44,203.44,203.44,203.43,203.43,203.43,203.43,203.43,203.43,203.42,203.42,203.42,203.42,203.42,203.43,203.43,203.43,203.43,203.43,203.43,203.44,203.44,203.44,203.45,203.45,203.45,203.46,203.46,203.46,203.47,203.47,203.48,203.48,203.49,203.49,203.5,203.51,203.51,203.52,203.53,203.53,203.54,203.55,203.55,203.56,203.57,203.57,203.58,203.59,203.6,203.6,203.61,203.62,203.63,203.63,203.64,203.65,203.66,203.67,203.67,203.68,203.69,203.7,203.71,203.72,203.72,203.73,203.74,203.75,203.75,203.76,203.77,203.78,203.79,203.79,203.8,203.81,203.81,203.82,203.83,203.83,203.84,203.85,203.85,203.86,203.86,203.87,203.88,203.88,203.89,203.89,203.89,203.9,203.9,203.91,203.91,203.91,203.92,203.92,203.92,203.92,203.92,203.93,203.93,203.93,203.93,203.93,203.93,203.93,203.93,203.93,203.92,203.92,203.92,203.92,203.92,203.91,203.91,203.91,203.9,203.9,203.9,203.89,203.89,203.88,203.88,203.87,203.87,203.86,203.85,203.85,203.84,203.84,203.83,203.82,203.82,203.81,203.8,203.79,203.79,203.78,203.77,203.76,203.76,203.75,203.74,203.73,203.72,203.72,203.71,203.7,203.69,203.68,203.68,203.67,203.66,203.65,203.64,203.64,203.63,203.62,203.61,203.6,203.6,203.59,203.58,203.57,203.57,203.56,203.55,203.55,203.54,203.53,203.53,203.52,203.51,203.51,203.5,203.5,203.49,203.48,203.48,203.47,203.47,203.47,203.46,203.46,203.45,203.45,203.45,203.44,203.44,203.44,203.43,203.43,203.43,203.43,203.43,203.43,203.42,203.42,203.42,203.42,203.42,203.43,203.43,203.43,203.43,203.43,203.43,203.44,203.44,203.44,203.45,203.45,203.46,203.46,203.47,203.47,203.48,203.49,203.49,203.5,203.51,203.52,203.53,203.53,203.54,203.55,203.57,203.58,203.59,203.6,203.61,203.63,203.64,203.65,203.67,203.68,203.7,203.72,203.73,203.75,203.77,203.79,203.81,203.83,203.85,203.87,203.89,203.91,203.94,203.96,203.99,204.01,204.04,204.06,204.09,204.12,204.15,204.18,204.21,204.24,204.27,204.31,204.34,204.38,204.41,204.45,204.49,204.52,204.56,204.6,204.65,204.69,204.73,204.78,204.82,204.87,204.92,204.97,205.02,205.07,205.12,205.18,205.23,205.29,205.35,205.4,205.47,205.53,205.59,205.66,},
{206.42,206.35,206.27,206.21,206.14,206.07,206.01,205.95,205.88,205.82,205.77,205.71,205.65,205.6,205.54,205.49,205.44,205.39,205.34,205.3,205.25,205.21,205.16,205.12,205.08,205.04,205.0,204.96,204.92,204.88,204.85,204.81,204.78,204.74,204.71,204.68,204.65,204.62,204.59,204.56,204.53,204.5,204.48,204.45,204.43,204.4,204.38,204.36,204.33,204.31,204.29,204.27,204.25,204.23,204.21,204.2,204.18,204.16,204.15,204.13,204.12,204.1,204.09,204.08,204.06,204.05,204.04,204.03,204.02,204.01,204.0,203.99,203.98,203.97,203.96,203.96,203.95,203.94,203.94,203.93,203.93,203.92,203.92,203.91,203.91,203.9,203.9,203.9,203.9,203.9,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.9,203.9,203.9,203.9,203.9,203.91,203.91,203.91,203.92,203.92,203.93,203.93,203.94,203.94,203.95,203.95,203.96,203.96,203.97,203.97,203.98,203.99,203.99,204.0,204.01,204.01,204.02,204.03,204.03,204.04,204.05,204.06,204.06,204.07,204.08,204.09,204.1,204.1,204.11,204.12,204.13,204.14,204.14,204.15,204.16,204.17,204.18,204.19,204.19,204.2,204.21,204.22,204.23,204.23,204.24,204.25,204.26,204.26,204.27,204.28,204.29,204.29,204.3,204.31,204.31,204.32,204.33,204.33,204.34,204.34,204.35,204.35,204.36,204.36,204.37,204.37,204.38,204.38,204.38,204.39,204.39,204.39,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.4,204.39,204.39,204.39,204.38,204.38,204.38,204.37,204.37,204.36,204.36,204.36,204.35,204.34,204.34,204.33,204.33,204.32,204.31,204.31,204.3,204.29,204.29,204.28,204.27,204.27,204.26,204.25,204.24,204.24,204.23,204.22,204.21,204.2,204.2,204.19,204.18,204.17,204.16,204.15,204.15,204.14,204.13,204.12,204.11,204.11,204.1,204.09,204.08,204.07,204.07,204.06,204.05,204.04,204.04,204.03,204.02,204.01,204.01,204.0,203.99,203.99,203.98,203.97,203.97,203.96,203.96,203.95,203.95,203.94,203.94,203.93,203.93,203.92,203.92,203.92,203.91,203.91,203.91,203.9,203.9,203.9,203.9,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.89,203.9,203.9,203.9,203.9,203.91,203.91,203.92,203.92,203.92,203.93,203.94,203.94,203.95,203.96,203.96,203.97,203.98,203.99,204.0,204.01,204.02,204.03,204.04,204.05,204.06,204.07,204.09,204.1,204.12,204.13,204.15,204.16,204.18,204.19,204.21,204.23,204.25,204.27,204.29,204.31,204.33,204.35,204.38,204.4,204.42,204.45,204.47,204.5,204.53,204.55,204.58,204.61,204.64,204.67,204.7,204.74,204.77,204.8,204.84,204.88,204.91,204.95,204.99,205.03,205.07,205.11,205.15,205.2,205.24,205.29,205.34,205.39,205.43,205.49,205.54,205.59,205.64,205.7,205.76,205.82,205.88,205.94,206.0,206.06,206.13,206.2,},
{206.96,206.88,206.81,206.74,206.67,206.6,206.53,206.47,206.41,206.35,206.28,206.23,206.17,206.11,206.06,206.0,205.95,205.9,205.85,205.8,205.75,205.71,205.66,205.62,205.58,205.53,205.49,205.45,205.41,205.37,205.34,205.3,205.27,205.23,205.2,205.16,205.13,205.1,205.07,205.04,205.01,204.99,204.96,204.93,204.91,204.88,204.86,204.83,204.81,204.79,204.77,204.75,204.73,204.71,204.69,204.67,204.65,204.63,204.62,204.6,204.59,204.57,204.56,204.54,204.53,204.52,204.51,204.49,204.48,204.47,204.46,204.45,204.44,204.44,204.43,204.42,204.41,204.41,204.4,204.39,204.39,204.38,204.38,204.37,204.37,204.37,204.36,204.36,204.36,204.36,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.36,204.36,204.36,204.36,204.36,204.37,204.37,204.37,204.38,204.38,204.39,204.39,204.4,204.4,204.41,204.41,204.42,204.42,204.43,204.43,204.44,204.45,204.45,204.46,204.47,204.47,204.48,204.49,204.5,204.5,204.51,204.52,204.53,204.53,204.54,204.55,204.56,204.57,204.57,204.58,204.59,204.6,204.61,204.62,204.62,204.63,204.64,204.65,204.66,204.67,204.67,204.68,204.69,204.7,204.71,204.71,204.72,204.73,204.74,204.74,204.75,204.76,204.77,204.77,204.78,204.79,204.79,204.8,204.8,204.81,204.82,204.82,204.83,204.83,204.84,204.84,204.84,204.85,204.85,204.85,204.86,204.86,204.86,204.86,204.87,204.87,204.87,204.87,204.87,204.87,204.87,204.87,204.87,204.87,204.87,204.86,204.86,204.86,204.86,204.85,204.85,204.85,204.84,204.84,204.84,204.83,204.83,204.82,204.82,204.81,204.81,204.8,204.79,204.79,204.78,204.77,204.77,204.76,204.75,204.75,204.74,204.73,204.72,204.72,204.71,204.7,204.69,204.68,204.68,204.67,204.66,204.65,204.64,204.63,204.63,204.62,204.61,204.6,204.59,204.58,204.58,204.57,204.56,204.55,204.54,204.54,204.53,204.52,204.51,204.5,204.5,204.49,204.48,204.47,204.47,204.46,204.45,204.45,204.44,204.43,204.43,204.42,204.42,204.41,204.41,204.4,204.4,204.39,204.39,204.38,204.38,204.37,204.37,204.37,204.36,204.36,204.36,204.36,204.36,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.35,204.36,204.36,204.36,204.36,204.37,204.37,204.37,204.38,204.38,204.39,204.39,204.4,204.4,204.41,204.42,204.43,204.43,204.44,204.45,204.46,204.47,204.48,204.49,204.5,204.52,204.53,204.54,204.56,204.57,204.58,204.6,204.62,204.63,204.65,204.67,204.68,204.7,204.72,204.74,204.76,204.78,204.81,204.83,204.85,204.88,204.9,204.93,204.95,204.98,205.01,205.04,205.07,205.1,205.13,205.16,205.19,205.23,205.26,205.3,205.33,205.37,205.41,205.45,205.49,205.53,205.57,205.61,205.66,205.7,205.75,205.79,205.84,205.89,205.94,206.0,206.05,206.1,206.16,206.22,206.28,206.34,206.4,206.46,206.52,206.59,206.66,206.73,},
{207.49,207.41,207.33,207.26,207.19,207.12,207.05,206.99,206.92,206.86,206.8,206.74,206.68,206.62,206.56,206.51,206.45,206.4,206.35,206.3,206.25,206.2,206.16,206.11,206.07,206.02,205.98,205.94,205.9,205.86,205.82,205.79,205.75,205.71,205.68,205.64,205.61,205.58,205.55,205.52,205.49,205.46,205.43,205.4,205.38,205.35,205.33,205.3,205.28,205.26,205.24,205.21,205.19,205.17,205.15,205.13,205.12,205.1,205.08,205.06,205.05,205.03,205.02,205.01,204.99,204.98,204.97,204.95,204.94,204.93,204.92,204.91,204.9,204.89,204.88,204.88,204.87,204.86,204.86,204.85,204.84,204.84,204.83,204.83,204.82,204.82,204.82,204.81,204.81,204.81,204.81,204.81,204.81,204.8,204.8,204.8,204.8,204.8,204.81,204.81,204.81,204.81,204.81,204.81,204.82,204.82,204.82,204.83,204.83,204.83,204.84,204.84,204.85,204.85,204.86,204.86,204.87,204.87,204.88,204.89,204.89,204.9,204.91,204.91,204.92,204.93,204.93,204.94,204.95,204.96,204.96,204.97,204.98,204.99,205.0,205.0,205.01,205.02,205.03,205.04,205.05,205.06,205.06,205.07,205.08,205.09,205.1,205.11,205.11,205.12,205.13,205.14,205.15,205.16,205.16,205.17,205.18,205.19,205.19,205.2,205.21,205.22,205.22,205.23,205.24,205.24,205.25,205.26,205.26,205.27,205.27,205.28,205.28,205.29,205.29,205.3,205.3,205.31,205.31,205.31,205.32,205.32,205.32,205.32,205.32,205.33,205.33,205.33,205.33,205.33,205.33,205.33,205.33,205.33,205.33,205.32,205.32,205.32,205.32,205.31,205.31,205.31,205.3,205.3,205.29,205.29,205.29,205.28,205.27,205.27,205.26,205.26,205.25,205.25,205.24,205.23,205.22,205.22,205.21,205.2,205.2,205.19,205.18,205.17,205.16,205.16,205.15,205.14,205.13,205.12,205.12,205.11,205.1,205.09,205.08,205.07,205.06,205.06,205.05,205.04,205.03,205.02,205.01,205.01,205.0,204.99,204.98,204.97,204.97,204.96,204.95,204.94,204.94,204.93,204.92,204.91,204.91,204.9,204.89,204.89,204.88,204.88,204.87,204.86,204.86,204.85,204.85,204.84,204.84,204.84,204.83,204.83,204.82,204.82,204.82,204.82,204.81,204.81,204.81,204.81,204.81,204.8,204.8,204.8,204.8,204.8,204.81,204.81,204.81,204.81,204.81,204.81,204.82,204.82,204.82,204.83,204.83,204.84,204.84,204.85,204.85,204.86,204.87,204.88,204.88,204.89,204.9,204.91,204.92,204.93,204.94,204.95,204.96,204.98,204.99,205.0,205.02,205.03,205.05,205.06,205.08,205.1,205.11,205.13,205.15,205.17,205.19,205.21,205.23,205.25,205.28,205.3,205.32,205.35,205.37,205.4,205.43,205.46,205.48,205.51,205.54,205.58,205.61,205.64,205.67,205.71,205.74,205.78,205.82,205.86,205.89,205.93,205.98,206.02,206.06,206.11,206.15,206.2,206.24,206.29,206.34,206.39,206.45,206.5,206.56,206.61,206.67,206.73,206.79,206.85,206.91,206.98,207.04,207.11,207.18,207.25,},
{208.01,207.93,207.85,207.78,207.71,207.63,207.56,207.5,207.43,207.36,207.3,207.24,207.18,207.12,207.06,207.01,206.95,206.9,206.84,206.79,206.74,206.69,206.65,206.6,206.55,206.51,206.46,206.42,206.38,206.34,206.3,206.26,206.23,206.19,206.15,206.12,206.08,206.05,206.02,205.99,205.96,205.93,205.9,205.87,205.84,205.82,205.79,205.77,205.74,205.72,205.7,205.68,205.65,205.63,205.61,205.59,205.57,205.56,205.54,205.52,205.51,205.49,205.47,205.46,205.45,205.43,205.42,205.41,205.4,205.38,205.37,205.36,205.35,205.34,205.34,205.33,205.32,205.31,205.31,205.3,205.29,205.29,205.28,205.28,205.27,205.27,205.27,205.26,205.26,205.26,205.26,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.26,205.26,205.26,205.26,205.26,205.27,205.27,205.27,205.28,205.28,205.29,205.29,205.29,205.3,205.31,205.31,205.32,205.32,205.33,205.33,205.34,205.35,205.35,205.36,205.37,205.37,205.38,205.39,205.4,205.4,205.41,205.42,205.43,205.44,205.44,205.45,205.46,205.47,205.48,205.49,205.5,205.5,205.51,205.52,205.53,205.54,205.55,205.56,205.56,205.57,205.58,205.59,205.6,205.61,205.61,205.62,205.63,205.64,205.65,205.65,205.66,205.67,205.67,205.68,205.69,205.7,205.7,205.71,205.71,205.72,205.73,205.73,205.74,205.74,205.75,205.75,205.75,205.76,205.76,205.76,205.77,205.77,205.77,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.78,205.77,205.77,205.77,205.77,205.76,205.76,205.75,205.75,205.75,205.74,205.74,205.73,205.73,205.72,205.72,205.71,205.7,205.7,205.69,205.68,205.68,205.67,205.66,205.65,205.65,205.64,205.63,205.62,205.61,205.61,205.6,205.59,205.58,205.57,205.57,205.56,205.55,205.54,205.53,205.52,205.51,205.51,205.5,205.49,205.48,205.47,205.46,205.45,205.45,205.44,205.43,205.42,205.41,205.41,205.4,205.39,205.38,205.38,205.37,205.36,205.35,205.35,205.34,205.33,205.33,205.32,205.32,205.31,205.31,205.3,205.3,205.29,205.29,205.28,205.28,205.27,205.27,205.27,205.26,205.26,205.26,205.26,205.26,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.25,205.26,205.26,205.26,205.26,205.27,205.27,205.27,205.28,205.28,205.29,205.29,205.3,205.3,205.31,205.32,205.33,205.33,205.34,205.35,205.36,205.37,205.38,205.39,205.41,205.42,205.43,205.44,205.46,205.47,205.49,205.5,205.52,205.54,205.55,205.57,205.59,205.61,205.63,205.65,205.67,205.69,205.72,205.74,205.76,205.79,205.81,205.84,205.87,205.9,205.92,205.95,205.98,206.02,206.05,206.08,206.11,206.15,206.18,206.22,206.26,206.3,206.33,206.37,206.42,206.46,206.5,206.55,206.59,206.64,206.69,206.73,206.78,206.84,206.89,206.94,207.0,207.05,207.11,207.17,207.23,207.29,207.36,207.42,207.49,207.55,207.62,207.69,207.77,},
{208.52,208.44,208.36,208.29,208.21,208.14,208.07,208.0,207.93,207.86,207.8,207.74,207.67,207.61,207.55,207.5,207.44,207.38,207.33,207.28,207.23,207.18,207.13,207.08,207.03,206.99,206.94,206.9,206.86,206.81,206.77,206.73,206.7,206.66,206.62,206.59,206.55,206.52,206.48,206.45,206.42,206.39,206.36,206.33,206.3,206.28,206.25,206.23,206.2,206.18,206.15,206.13,206.11,206.09,206.07,206.05,206.03,206.01,205.99,205.97,205.96,205.94,205.92,205.91,205.89,205.88,205.87,205.86,205.84,205.83,205.82,205.81,205.8,205.79,205.78,205.77,205.76,205.76,205.75,205.74,205.74,205.73,205.73,205.72,205.72,205.71,205.71,205.7,205.7,205.7,205.7,205.7,205.69,205.69,205.69,205.69,205.69,205.69,205.69,205.69,205.7,205.7,205.7,205.7,205.7,205.71,205.71,205.71,205.72,205.72,205.73,205.73,205.74,205.74,205.75,205.75,205.76,205.76,205.77,205.77,205.78,205.79,205.79,205.8,205.81,205.82,205.82,205.83,205.84,205.85,205.85,205.86,205.87,205.88,205.89,205.89,205.9,205.91,205.92,205.93,205.94,205.95,205.95,205.96,205.97,205.98,205.99,206.0,206.01,206.02,206.02,206.03,206.04,206.05,206.06,206.07,206.07,206.08,206.09,206.1,206.1,206.11,206.12,206.13,206.13,206.14,206.15,206.15,206.16,206.16,206.17,206.18,206.18,206.19,206.19,206.19,206.2,206.2,206.21,206.21,206.21,206.22,206.22,206.22,206.22,206.22,206.22,206.23,206.23,206.23,206.23,206.23,206.22,206.22,206.22,206.22,206.22,206.22,206.21,206.21,206.21,206.2,206.2,206.2,206.19,206.19,206.18,206.18,206.17,206.17,206.16,206.15,206.15,206.14,206.13,206.13,206.12,206.11,206.11,206.1,206.09,206.08,206.07,206.07,206.06,206.05,206.04,206.03,206.03,206.02,206.01,206.0,205.99,205.98,205.97,205.96,205.96,205.95,205.94,205.93,205.92,205.91,205.9,205.9,205.89,205.88,205.87,205.86,205.86,205.85,205.84,205.83,205.82,205.82,205.81,205.8,205.8,205.79,205.78,205.78,205.77,205.76,205.76,205.75,205.75,205.74,205.74,205.73,205.73,205.72,205.72,205.71,205.71,205.71,205.7,205.7,205.7,205.7,205.7,205.69,205.69,205.69,205.69,205.69,205.69,205.69,205.69,205.7,205.7,205.7,205.7,205.7,205.71,205.71,205.71,205.72,205.72,205.73,205.74,205.74,205.75,205.76,205.76,205.77,205.78,205.79,205.8,205.81,205.82,205.83,205.84,205.85,205.87,205.88,205.89,205.91,205.92,205.94,205.95,205.97,205.99,206.01,206.02,206.04,206.06,206.08,206.11,206.13,206.15,206.17,206.2,206.22,206.25,206.27,206.3,206.33,206.36,206.39,206.42,206.45,206.48,206.51,206.55,206.58,206.62,206.65,206.69,206.73,206.77,206.81,206.85,206.89,206.93,206.98,207.02,207.07,207.12,207.17,207.22,207.27,207.32,207.38,207.43,207.49,207.54,207.6,207.66,207.73,207.79,207.85,207.92,207.99,208.06,208.13,208.2,208.28,},
{209.03,208.95,208.87,208.79,208.71,208.64,208.57,208.49,208.42,208.36,208.29,208.22,208.16,208.1,208.04,207.98,207.92,207.86,207.81,207.76,207.7,207.65,207.6,207.55,207.5,207.46,207.41,207.37,207.32,207.28,207.24,207.2,207.16,207.12,207.08,207.05,207.01,206.98,206.94,206.91,206.88,206.85,206.82,206.79,206.76,206.73,206.7,206.68,206.65,206.63,206.6,206.58,206.56,206.54,206.51,206.49,206.47,206.45,206.44,206.42,206.4,206.38,206.37,206.35,206.34,206.32,206.31,206.3,206.28,206.27,206.26,206.25,206.24,206.23,206.22,206.21,206.2,206.19,206.19,206.18,206.17,206.17,206.16,206.16,206.15,206.15,206.14,206.14,206.14,206.14,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.14,206.14,206.14,206.15,206.15,206.15,206.16,206.16,206.16,206.17,206.17,206.18,206.19,206.19,206.2,206.2,206.21,206.22,206.22,206.23,206.24,206.24,206.25,206.26,206.27,206.27,206.28,206.29,206.3,206.31,206.31,206.32,206.33,206.34,206.35,206.36,206.36,206.37,206.38,206.39,206.4,206.41,206.42,206.43,206.43,206.44,206.45,206.46,206.47,206.48,206.49,206.49,206.5,206.51,206.52,206.53,206.53,206.54,206.55,206.56,206.56,206.57,206.58,206.58,206.59,206.6,206.6,206.61,206.61,206.62,206.62,206.63,206.63,206.64,206.64,206.64,206.65,206.65,206.65,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.66,206.65,206.65,206.65,206.64,206.64,206.64,206.63,206.63,206.62,206.62,206.61,206.61,206.6,206.6,206.59,206.58,206.58,206.57,206.56,206.56,206.55,206.54,206.53,206.53,206.52,206.51,206.5,206.5,206.49,206.48,206.47,206.46,206.45,206.44,206.44,206.43,206.42,206.41,206.4,206.39,206.38,206.37,206.37,206.36,206.35,206.34,206.33,206.32,206.31,206.31,206.3,206.29,206.28,206.27,206.27,206.26,206.25,206.24,206.24,206.23,206.22,206.22,206.21,206.2,206.2,206.19,206.19,206.18,206.18,206.17,206.17,206.16,206.16,206.15,206.15,206.15,206.14,206.14,206.14,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.13,206.14,206.14,206.14,206.15,206.15,206.16,206.16,206.17,206.17,206.18,206.19,206.19,206.2,206.21,206.22,206.23,206.24,206.25,206.26,206.27,206.28,206.29,206.31,206.32,206.34,206.35,206.37,206.38,206.4,206.42,206.43,206.45,206.47,206.49,206.51,206.53,206.55,206.58,206.6,206.62,206.65,206.67,206.7,206.73,206.75,206.78,206.81,206.84,206.87,206.91,206.94,206.97,207.01,207.04,207.08,207.12,207.15,207.19,207.23,207.27,207.32,207.36,207.4,207.45,207.5,207.54,207.59,207.64,207.7,207.75,207.8,207.86,207.91,207.97,208.03,208.09,208.15,208.22,208.28,208.35,208.41,208.48,208.56,208.63,208.7,208.78,},
{209.53,209.45,209.36,209.29,209.21,209.13,209.06,208.98,208.91,208.84,208.77,208.71,208.64,208.58,208.52,208.46,208.4,208.34,208.28,208.23,208.17,208.12,208.07,208.02,207.97,207.92,207.88,207.83,207.79,207.74,207.7,207.66,207.62,207.58,207.54,207.5,207.47,207.43,207.4,207.36,207.33,207.3,207.27,207.24,207.21,207.18,207.15,207.12,207.1,207.07,207.05,207.02,207.0,206.98,206.96,206.94,206.91,206.89,206.88,206.86,206.84,206.82,206.81,206.79,206.77,206.76,206.75,206.73,206.72,206.71,206.7,206.68,206.67,206.66,206.65,206.64,206.64,206.63,206.62,206.61,206.61,206.6,206.59,206.59,206.58,206.58,206.57,206.57,206.57,206.57,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.57,206.57,206.57,206.58,206.58,206.58,206.59,206.59,206.6,206.6,206.61,206.61,206.62,206.62,206.63,206.64,206.64,206.65,206.66,206.66,206.67,206.68,206.69,206.69,206.7,206.71,206.72,206.73,206.73,206.74,206.75,206.76,206.77,206.78,206.78,206.79,206.8,206.81,206.82,206.83,206.84,206.85,206.86,206.86,206.87,206.88,206.89,206.9,206.91,206.92,206.92,206.93,206.94,206.95,206.96,206.96,206.97,206.98,206.99,206.99,207.0,207.01,207.01,207.02,207.03,207.03,207.04,207.04,207.05,207.05,207.06,207.06,207.07,207.07,207.08,207.08,207.08,207.08,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.09,207.08,207.08,207.08,207.08,207.07,207.07,207.06,207.06,207.05,207.05,207.04,207.04,207.03,207.03,207.02,207.02,207.01,207.0,206.99,206.99,206.98,206.97,206.97,206.96,206.95,206.94,206.93,206.93,206.92,206.91,206.9,206.89,206.88,206.87,206.87,206.86,206.85,206.84,206.83,206.82,206.81,206.8,206.79,206.79,206.78,206.77,206.76,206.75,206.74,206.74,206.73,206.72,206.71,206.7,206.7,206.69,206.68,206.67,206.67,206.66,206.65,206.64,206.64,206.63,206.63,206.62,206.61,206.61,206.6,206.6,206.59,206.59,206.59,206.58,206.58,206.57,206.57,206.57,206.57,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.56,206.57,206.57,206.57,206.58,206.58,206.59,206.59,206.6,206.6,206.61,206.62,206.63,206.63,206.64,206.65,206.66,206.67,206.68,206.69,206.71,206.72,206.73,206.74,206.76,206.77,206.79,206.8,206.82,206.84,206.85,206.87,206.89,206.91,206.93,206.95,206.97,207.0,207.02,207.04,207.07,207.09,207.12,207.15,207.17,207.2,207.23,207.26,207.29,207.33,207.36,207.39,207.43,207.46,207.5,207.53,207.57,207.61,207.65,207.69,207.74,207.78,207.82,207.87,207.92,207.96,208.01,208.06,208.11,208.17,208.22,208.27,208.33,208.39,208.45,208.51,208.57,208.63,208.7,208.76,208.83,208.9,208.97,209.05,209.12,209.2,209.27,},
{210.02,209.94,209.86,209.77,209.69,209.62,209.54,209.47,209.39,209.32,209.25,209.18,209.12,209.05,208.99,208.93,208.87,208.81,208.75,208.69,208.64,208.58,208.53,208.48,208.43,208.38,208.33,208.29,208.24,208.2,208.15,208.11,208.07,208.03,207.99,207.95,207.92,207.88,207.84,207.81,207.78,207.74,207.71,207.68,207.65,207.62,207.59,207.56,207.54,207.51,207.49,207.46,207.44,207.41,207.39,207.37,207.35,207.33,207.31,207.29,207.27,207.26,207.24,207.22,207.21,207.19,207.18,207.16,207.15,207.14,207.12,207.11,207.1,207.09,207.08,207.07,207.06,207.05,207.05,207.04,207.03,207.03,207.02,207.01,207.01,207.0,207.0,207.0,206.99,206.99,206.99,206.98,206.98,206.98,206.98,206.98,206.98,206.98,206.98,206.98,206.98,206.98,206.99,206.99,206.99,206.99,207.0,207.0,207.0,207.01,207.01,207.02,207.02,207.03,207.03,207.04,207.04,207.05,207.05,207.06,207.07,207.07,207.08,207.09,207.09,207.1,207.11,207.12,207.12,207.13,207.14,207.15,207.16,207.16,207.17,207.18,207.19,207.2,207.21,207.22,207.23,207.23,207.24,207.25,207.26,207.27,207.28,207.29,207.3,207.3,207.31,207.32,207.33,207.34,207.35,207.36,207.36,207.37,207.38,207.39,207.4,207.4,207.41,207.42,207.42,207.43,207.44,207.44,207.45,207.46,207.46,207.47,207.47,207.48,207.48,207.49,207.49,207.5,207.5,207.5,207.51,207.51,207.51,207.51,207.52,207.52,207.52,207.52,207.52,207.52,207.52,207.52,207.52,207.52,207.52,207.51,207.51,207.51,207.51,207.5,207.5,207.5,207.49,207.49,207.48,207.48,207.47,207.47,207.46,207.46,207.45,207.45,207.44,207.43,207.43,207.42,207.41,207.4,207.4,207.39,207.38,207.37,207.37,207.36,207.35,207.34,207.33,207.32,207.31,207.31,207.3,207.29,207.28,20