/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.CommandTooLongException;
import org.jackhuang.hmcl.launch.ExecutionPolicyLimitException;
import org.jackhuang.hmcl.launch.ExitWaiter;
import org.jackhuang.hmcl.launch.Launcher;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class DefaultLauncher
extends Launcher {
    private final Map<String, Supplier<Boolean>> forbiddens = Lang.mapOf(Pair.pair("-Xincgc", () -> this.options.getJava().getParsedVersion() >= 9));

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options) {
        this(repository, version, authInfo, options, null);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener) {
        this(repository, version, authInfo, options, listener, true);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener, boolean daemon) {
        super(repository, version, authInfo, options, listener, daemon);
    }

    private Command generateCommandLine(File nativeFolder) throws IOException {
        InetSocketAddress address;
        InetSocketAddress address2;
        CommandBuilder res = new CommandBuilder();
        switch (this.options.getProcessPriority()) {
            case HIGH: {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.OSX) break;
                res.add("nice", "-n", "-5");
                break;
            }
            case ABOVE_NORMAL: {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.OSX) break;
                res.add("nice", "-n", "-1");
                break;
            }
            case NORMAL: {
                break;
            }
            case BELOW_NORMAL: {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.OSX) break;
                res.add("nice", "-n", "1");
                break;
            }
            case LOW: {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.OSX) break;
                res.add("nice", "-n", "5");
            }
        }
        if (StringUtils.isNotBlank(this.options.getWrapper())) {
            res.addAllWithoutParsing(StringUtils.tokenize(this.options.getWrapper(), this.getEnvVars()));
        }
        res.add(this.options.getJava().getBinary().toString());
        res.addAllWithoutParsing(this.options.getOverrideJavaArguments());
        Proxy proxy = this.options.getProxy();
        if (proxy != null && StringUtils.isBlank(this.options.getProxyUser()) && StringUtils.isBlank(this.options.getProxyPass()) && (address2 = (InetSocketAddress)this.options.getProxy().address()) != null) {
            String host = address2.getHostString();
            int port = address2.getPort();
            if (proxy.type() == Proxy.Type.HTTP) {
                res.addDefault("-Dhttp.proxyHost=", host);
                res.addDefault("-Dhttp.proxyPort=", String.valueOf(port));
                res.addDefault("-Dhttps.proxyHost=", host);
                res.addDefault("-Dhttps.proxyPort=", String.valueOf(port));
            } else if (proxy.type() == Proxy.Type.SOCKS) {
                res.addDefault("-DsocksProxyHost=", host);
                res.addDefault("-DsocksProxyPort=", String.valueOf(port));
            }
        }
        if (this.options.getMaxMemory() != null && this.options.getMaxMemory() > 0) {
            res.addDefault("-Xmx", this.options.getMaxMemory() + "m");
        }
        if (this.options.getMinMemory() != null && this.options.getMinMemory() > 0 && (this.options.getMaxMemory() == null || this.options.getMinMemory() <= this.options.getMaxMemory())) {
            res.addDefault("-Xms", this.options.getMinMemory() + "m");
        }
        if (this.options.getMetaspace() != null && this.options.getMetaspace() > 0) {
            if (this.options.getJava().getParsedVersion() < 8) {
                res.addDefault("-XX:PermSize=", this.options.getMetaspace() + "m");
            } else {
                res.addDefault("-XX:MetaspaceSize=", this.options.getMetaspace() + "m");
            }
        }
        res.addAllDefaultWithoutParsing(this.options.getJavaArguments());
        Charset encoding = OperatingSystem.NATIVE_CHARSET;
        String fileEncoding = res.addDefault("-Dfile.encoding=", encoding.name());
        if (fileEncoding != null && !"-Dfile.encoding=COMPAT".equals(fileEncoding)) {
            try {
                encoding = Charset.forName(fileEncoding.substring("-Dfile.encoding=".length()));
            }
            catch (Throwable ex) {
                Logger.LOG.warning("Bad file encoding", ex);
            }
        }
        if (this.options.getJava().getParsedVersion() < 19) {
            res.addDefault("-Dsun.stdout.encoding=", encoding.name());
            res.addDefault("-Dsun.stderr.encoding=", encoding.name());
        } else {
            res.addDefault("-Dstdout.encoding=", encoding.name());
            res.addDefault("-Dstderr.encoding=", encoding.name());
        }
        res.addDefault("-Djava.rmi.server.useCodebaseOnly=", "true");
        res.addDefault("-Dcom.sun.jndi.rmi.object.trustURLCodebase=", "false");
        res.addDefault("-Dcom.sun.jndi.cosnaming.object.trustURLCodebase=", "false");
        String formatMsgNoLookups = res.addDefault("-Dlog4j2.formatMsgNoLookups=", "true");
        if (!"-Dlog4j2.formatMsgNoLookups=false".equals(formatMsgNoLookups) && this.isUsingLog4j()) {
            res.addDefault("-Dlog4j.configurationFile=", this.getLog4jConfigurationFile().getAbsolutePath());
        }
        if (!this.options.isNoGeneratedJVMArgs()) {
            this.appendJvmArgs(res);
            res.addDefault("-Dminecraft.client.jar=", this.repository.getVersionJar(this.version).toString());
            if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                res.addDefault("-Xdock:name=", "Minecraft " + this.version.getId());
                this.repository.getAssetObject(this.version.getId(), this.version.getAssetIndex().getId(), "icons/minecraft.icns").ifPresent(minecraftIcns -> res.addDefault("-Xdock:icon=", minecraftIcns.toAbsolutePath().toString()));
            }
            if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
                res.addDefault("-Duser.home=", this.options.getGameDir().getParent());
            }
            if (this.options.getJava().getParsedVersion() >= 8 && res.noneMatch(arg -> "-XX:-UseG1GC".equals(arg) || arg.startsWith("-XX:+Use") && arg.endsWith("GC"))) {
                res.addUnstableDefault("UnlockExperimentalVMOptions", true);
                res.addUnstableDefault("UseG1GC", true);
                res.addUnstableDefault("G1NewSizePercent", "20");
                res.addUnstableDefault("G1ReservePercent", "20");
                res.addUnstableDefault("MaxGCPauseMillis", "50");
                res.addUnstableDefault("G1HeapRegionSize", "32m");
            }
            res.addUnstableDefault("UseAdaptiveSizePolicy", false);
            res.addUnstableDefault("OmitStackTraceInFastThrow", false);
            res.addUnstableDefault("DontCompileHugeMethods", false);
            if (this.options.getJava().getBits() == Bits.BIT_32) {
                res.addDefault("-Xss", "1m");
            }
            if (this.options.getJava().getParsedVersion() == 16) {
                res.addDefault("--illegal-access=", "permit");
            }
            res.addDefault("-Dfml.ignoreInvalidMinecraftCertificates=", "true");
            res.addDefault("-Dfml.ignorePatchDiscrepancies=", "true");
        }
        Set<String> classpath = this.repository.getClasspath(this.version);
        File jar = this.repository.getVersionJar(this.version);
        if (!jar.exists() || !jar.isFile()) {
            throw new IOException("Minecraft jar does not exist");
        }
        classpath.add(jar.getAbsolutePath());
        Path gameAssets = this.repository.getActualAssetDirectory(this.version.getId(), this.version.getAssetIndex().getId());
        Map<String, String> configuration = this.getConfigurations();
        configuration.put("${classpath}", String.join((CharSequence)OperatingSystem.PATH_SEPARATOR, classpath));
        configuration.put("${game_assets}", gameAssets.toAbsolutePath().toString());
        configuration.put("${assets_root}", gameAssets.toAbsolutePath().toString());
        Optional<String> gameVersion = this.repository.getGameVersion(this.version);
        String nativeFolderPath = nativeFolder.getAbsolutePath();
        Path tempNativeFolder = null;
        if ((OperatingSystem.CURRENT_OS == OperatingSystem.LINUX || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) && !StringUtils.isASCII(nativeFolderPath) && gameVersion.isPresent() && GameVersionNumber.compare(gameVersion.get(), "1.19") < 0) {
            tempNativeFolder = Paths.get("/", "tmp", "hmcl-natives-" + UUID.randomUUID());
            nativeFolderPath = tempNativeFolder + File.pathSeparator + nativeFolderPath;
        }
        configuration.put("${natives_directory}", nativeFolderPath);
        res.addAll(Arguments.parseArguments(this.version.getArguments().map(Arguments::getJvm).orElseGet(this::getDefaultJVMArguments), configuration));
        Arguments argumentsFromAuthInfo = this.authInfo.getLaunchArguments(this.options);
        if (argumentsFromAuthInfo != null && argumentsFromAuthInfo.getJvm() != null && !argumentsFromAuthInfo.getJvm().isEmpty()) {
            res.addAll(Arguments.parseArguments(argumentsFromAuthInfo.getJvm(), configuration));
        }
        for (String javaAgent : this.options.getJavaAgents()) {
            res.add("-javaagent:" + javaAgent);
        }
        res.add(this.version.getMainClass());
        res.addAll(Arguments.parseStringArguments(this.version.getMinecraftArguments().map(StringUtils::tokenize).orElseGet(ArrayList::new), configuration));
        Map<String, Boolean> features = this.getFeatures();
        this.version.getArguments().map(Arguments::getGame).ifPresent(arguments -> res.addAll(Arguments.parseArguments(arguments, configuration, features)));
        if (this.version.getMinecraftArguments().isPresent()) {
            res.addAll(Arguments.parseArguments(this.getDefaultGameArguments(), configuration, features));
        }
        if (argumentsFromAuthInfo != null && argumentsFromAuthInfo.getGame() != null && !argumentsFromAuthInfo.getGame().isEmpty()) {
            res.addAll(Arguments.parseArguments(argumentsFromAuthInfo.getGame(), configuration, features));
        }
        if (StringUtils.isNotBlank(this.options.getServerIp())) {
            String[] args = this.options.getServerIp().split(":");
            if (GameVersionNumber.asGameVersion(gameVersion).compareTo("1.20") < 0) {
                res.add("--server");
                res.add(args[0]);
                res.add("--port");
                res.add(args.length > 1 ? args[1] : "25565");
            } else {
                res.add("--quickPlayMultiplayer");
                res.add(args[0] + ":" + (args.length > 1 ? args[1] : "25565"));
            }
        }
        if (this.options.isFullscreen()) {
            res.add("--fullscreen");
        }
        if (this.options.getProxy() != null && this.options.getProxy().type() == Proxy.Type.SOCKS && (address = (InetSocketAddress)this.options.getProxy().address()) != null) {
            res.add("--proxyHost");
            res.add(address.getHostString());
            res.add("--proxyPort");
            res.add(String.valueOf(address.getPort()));
            if (StringUtils.isNotBlank(this.options.getProxyUser()) && StringUtils.isNotBlank(this.options.getProxyPass())) {
                res.add("--proxyUser");
                res.add(this.options.getProxyUser());
                res.add("--proxyPass");
                res.add(this.options.getProxyPass());
            }
        }
        res.addAllWithoutParsing(Arguments.parseStringArguments(this.options.getGameArguments(), configuration));
        res.removeIf(it -> this.getForbiddens().containsKey(it) && this.getForbiddens().get(it).get() != false);
        return new Command(res, tempNativeFolder, encoding);
    }

    public Map<String, Boolean> getFeatures() {
        return Collections.singletonMap("has_custom_resolution", this.options.getHeight() != null && this.options.getHeight() != 0 && this.options.getWidth() != null && this.options.getWidth() != 0);
    }

    protected Map<String, Supplier<Boolean>> getForbiddens() {
        return this.forbiddens;
    }

    protected List<Argument> getDefaultJVMArguments() {
        return Arguments.DEFAULT_JVM_ARGUMENTS;
    }

    protected List<Argument> getDefaultGameArguments() {
        return Arguments.DEFAULT_GAME_ARGUMENTS;
    }

    protected void appendJvmArgs(CommandBuilder result) {
    }

    public void decompressNatives(File destination) throws NotDecompressingNativesException {
        try {
            FileUtils.cleanDirectoryQuietly(destination);
            for (Library library : this.version.getLibraries()) {
                if (!library.isNative()) continue;
                new Unzipper(this.repository.getLibraryFile(this.version, library), destination).setFilter((zipEntry, isDirectory, destFile, path) -> {
                    if (!isDirectory && Files.isRegularFile(destFile, new LinkOption[0]) && Files.size(destFile) == Files.size(zipEntry)) {
                        return false;
                    }
                    String ext = FileUtils.getExtension(destFile);
                    if (ext.equals("sha1") || ext.equals("git")) {
                        return false;
                    }
                    if (this.options.isUseNativeGLFW() && FileUtils.getName(destFile).toLowerCase(Locale.ROOT).contains("glfw")) {
                        return false;
                    }
                    if (this.options.isUseNativeOpenAL() && FileUtils.getName(destFile).toLowerCase(Locale.ROOT).contains("openal")) {
                        return false;
                    }
                    return library.getExtract().shouldExtract(path);
                }).setReplaceExistentFile(false).unzip();
            }
        }
        catch (IOException e) {
            throw new NotDecompressingNativesException(e);
        }
    }

    private boolean isUsingLog4j() {
        return GameVersionNumber.compare(this.repository.getGameVersion(this.version).orElse("1.7"), "1.7") >= 0;
    }

    public File getLog4jConfigurationFile() {
        return new File(this.repository.getVersionRoot(this.version.getId()), "log4j2.xml");
    }

    public void extractLog4jConfigurationFile() throws IOException {
        File targetFile = this.getLog4jConfigurationFile();
        InputStream source = GameVersionNumber.asGameVersion(this.repository.getGameVersion(this.version)).compareTo("1.12") < 0 ? DefaultLauncher.class.getResourceAsStream("/assets/game/log4j2-1.7.xml") : DefaultLauncher.class.getResourceAsStream("/assets/game/log4j2-1.12.xml");
        try (InputStream input = source;
             FileOutputStream output = new FileOutputStream(targetFile);){
            IOUtils.copyTo(input, output);
        }
    }

    protected Map<String, String> getConfigurations() {
        return Lang.mapOf(Pair.pair("${auth_player_name}", this.authInfo.getUsername()), Pair.pair("${auth_session}", this.authInfo.getAccessToken()), Pair.pair("${auth_access_token}", this.authInfo.getAccessToken()), Pair.pair("${auth_uuid}", UUIDTypeAdapter.fromUUID(this.authInfo.getUUID())), Pair.pair("${version_name}", Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId())), Pair.pair("${profile_name}", Optional.ofNullable(this.options.getProfileName()).orElse("Minecraft")), Pair.pair("${version_type}", Optional.ofNullable(this.options.getVersionType()).orElse(this.version.getType().getId())), Pair.pair("${game_directory}", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()), Pair.pair("${user_type}", this.authInfo.getUserType()), Pair.pair("${assets_index_name}", this.version.getAssetIndex().getId()), Pair.pair("${user_properties}", this.authInfo.getUserProperties()), Pair.pair("${resolution_width}", this.options.getWidth().toString()), Pair.pair("${resolution_height}", this.options.getHeight().toString()), Pair.pair("${library_directory}", this.repository.getLibrariesDirectory(this.version).getAbsolutePath()), Pair.pair("${classpath_separator}", OperatingSystem.PATH_SEPARATOR), Pair.pair("${primary_jar}", this.repository.getVersionJar(this.version).getAbsolutePath()), Pair.pair("${language}", Locale.getDefault().toString()), Pair.pair("${libraries_directory}", this.repository.getLibrariesDirectory(this.version).getAbsolutePath()), Pair.pair("${file_separator}", OperatingSystem.FILE_SEPARATOR), Pair.pair("${primary_jar_name}", FileUtils.getName(this.repository.getVersionJar(this.version).toPath())));
    }

    @Override
    public ManagedProcess launch() throws IOException, InterruptedException {
        Process process;
        File nativeFolder = this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER ? this.repository.getNativeDirectory(this.version.getId(), this.options.getJava().getPlatform()) : new File(this.options.getNativesDir());
        Command command = this.generateCommandLine(nativeFolder);
        List<String> rawCommandLine = command.commandLine.asList();
        if (command.tempNativeFolder != null) {
            Files.deleteIfExists(command.tempNativeFolder);
            Files.createSymbolicLink(command.tempNativeFolder, nativeFolder.toPath().toAbsolutePath(), new FileAttribute[0]);
        }
        if (rawCommandLine.stream().anyMatch(StringUtils::isBlank)) {
            throw new IllegalStateException("Illegal command line " + rawCommandLine);
        }
        if (this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER) {
            this.decompressNatives(nativeFolder);
        }
        if (this.isUsingLog4j()) {
            this.extractLog4jConfigurationFile();
        }
        File runDirectory = this.repository.getRunDirectory(this.version.getId());
        if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
            ProcessBuilder builder = new ProcessBuilder(StringUtils.tokenize(this.options.getPreLaunchCommand(), this.getEnvVars())).directory(runDirectory);
            builder.environment().putAll(this.getEnvVars());
            SystemUtils.callExternalProcess(builder);
        }
        try {
            String appdata;
            ProcessBuilder builder = new ProcessBuilder(rawCommandLine).directory(runDirectory);
            if (this.listener == null) {
                builder.inheritIO();
            }
            if ((appdata = this.options.getGameDir().getAbsoluteFile().getParent()) != null) {
                builder.environment().put("APPDATA", appdata);
            }
            builder.environment().putAll(this.getEnvVars());
            process = builder.start();
        }
        catch (IOException e) {
            throw new ProcessCreationException(e);
        }
        ManagedProcess p = new ManagedProcess(process, rawCommandLine);
        if (this.listener != null) {
            this.startMonitors(p, this.listener, command.encoding, this.daemon);
        }
        return p;
    }

    private Map<String, String> getEnvVars() {
        LibraryAnalyzer analyzer;
        String versionName = Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId());
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        env.put("INST_NAME", versionName);
        env.put("INST_ID", versionName);
        env.put("INST_DIR", this.repository.getVersionRoot(this.version.getId()).getAbsolutePath());
        env.put("INST_MC_DIR", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath());
        env.put("INST_JAVA", this.options.getJava().getBinary().toString());
        Renderer renderer = this.options.getRenderer();
        if (renderer != Renderer.DEFAULT) {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                if (renderer != Renderer.LLVMPIPE) {
                    env.put("GALLIUM_DRIVER", renderer.name().toLowerCase(Locale.ROOT));
                }
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX) {
                env.put("__GLX_VENDOR_LIBRARY_NAME", "mesa");
                switch (renderer) {
                    case LLVMPIPE: {
                        env.put("LIBGL_ALWAYS_SOFTWARE", "1");
                        break;
                    }
                    case ZINK: {
                        env.put("MESA_LOADER_DRIVER_OVERRIDE", "zink");
                    }
                }
            }
        }
        if ((analyzer = LibraryAnalyzer.analyze(this.version, this.repository.getGameVersion(this.version).orElse(null))).has(LibraryAnalyzer.LibraryType.FORGE)) {
            env.put("INST_FORGE", "1");
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE)) {
            env.put("INST_NEOFORGE", "1");
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.LITELOADER)) {
            env.put("INST_LITELOADER", "1");
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.FABRIC)) {
            env.put("INST_FABRIC", "1");
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            env.put("INST_OPTIFINE", "1");
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.QUILT)) {
            env.put("INST_QUILT", "1");
        }
        env.putAll(this.options.getEnvironmentVariables());
        return env;
    }

    @Override
    public void makeLaunchScript(File scriptFile) throws IOException {
        String scriptExtension;
        boolean usePowerShell;
        boolean isWindows = OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS;
        File nativeFolder = this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER ? this.repository.getNativeDirectory(this.version.getId(), this.options.getJava().getPlatform()) : new File(this.options.getNativesDir());
        if (this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER) {
            this.decompressNatives(nativeFolder);
        }
        if (this.isUsingLog4j()) {
            this.extractLog4jConfigurationFile();
        }
        if (!(usePowerShell = "ps1".equals(scriptExtension = FileUtils.getExtension(scriptFile)))) {
            if (isWindows && !scriptExtension.equals("bat")) {
                throw new IllegalArgumentException("The extension of " + scriptFile + " is not 'bat' or 'ps1' in Windows");
            }
            if (!isWindows && !scriptExtension.equals("sh")) {
                throw new IllegalArgumentException("The extension of " + scriptFile + " is not 'sh' or 'ps1' in macOS/Linux");
            }
        }
        Command commandLine = this.generateCommandLine(nativeFolder);
        String command = usePowerShell ? null : commandLine.commandLine.toString();
        Map<String, String> envVars = this.getEnvVars();
        if (!usePowerShell && isWindows && command.length() > 8192) {
            throw new CommandTooLongException();
        }
        if (!FileUtils.makeFile(scriptFile)) {
            throw new IOException("Script file: " + scriptFile + " cannot be created.");
        }
        try (OutputStream outputStream = Files.newOutputStream(scriptFile.toPath(), new OpenOption[0]);){
            Charset charset = StandardCharsets.UTF_8;
            if (isWindows) {
                if (usePowerShell) {
                    try {
                        outputStream.write(239);
                        outputStream.write(187);
                        outputStream.write(191);
                    }
                    catch (IOException e) {
                        outputStream.close();
                        throw e;
                    }
                } else {
                    charset = OperatingSystem.NATIVE_CHARSET;
                }
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
                if (usePowerShell) {
                    if (isWindows) {
                        writer.write("$Env:APPDATA=");
                        writer.write(CommandBuilder.pwshString(this.options.getGameDir().getAbsoluteFile().getParent()));
                        writer.newLine();
                    }
                    for (Map.Entry<String, String> entry : envVars.entrySet()) {
                        writer.write("$Env:" + entry.getKey() + "=");
                        writer.write(CommandBuilder.pwshString(entry.getValue()));
                        writer.newLine();
                    }
                    writer.write("Set-Location -Path ");
                    writer.write(CommandBuilder.pwshString(this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()));
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
                        writer.write(38);
                        for (String rawCommand : StringUtils.tokenize(this.options.getPreLaunchCommand(), envVars)) {
                            writer.write(32);
                            writer.write(CommandBuilder.pwshString(rawCommand));
                        }
                        writer.newLine();
                    }
                    writer.write(38);
                    for (String rawCommand : commandLine.commandLine.asList()) {
                        writer.write(32);
                        writer.write(CommandBuilder.pwshString(rawCommand));
                    }
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                        writer.write(38);
                        for (String rawCommand : StringUtils.tokenize(this.options.getPostExitCommand(), envVars)) {
                            writer.write(32);
                            writer.write(CommandBuilder.pwshString(rawCommand));
                        }
                        writer.newLine();
                    }
                } else {
                    if (isWindows) {
                        writer.write("@echo off");
                        writer.newLine();
                        writer.write("set APPDATA=" + this.options.getGameDir().getAbsoluteFile().getParent());
                        writer.newLine();
                        for (Map.Entry<String, String> entry : envVars.entrySet()) {
                            writer.write("set " + entry.getKey() + "=" + CommandBuilder.toBatchStringLiteral(entry.getValue()));
                            writer.newLine();
                        }
                        writer.newLine();
                        writer.write(new CommandBuilder().add("cd", "/D", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()).toString());
                    } else {
                        writer.write("#!/usr/bin/env bash");
                        writer.newLine();
                        for (Map.Entry<String, String> entry : envVars.entrySet()) {
                            writer.write("export " + entry.getKey() + "=" + CommandBuilder.toShellStringLiteral(entry.getValue()));
                            writer.newLine();
                        }
                        if (commandLine.tempNativeFolder != null) {
                            writer.write(new CommandBuilder().add("ln", "-s", nativeFolder.getAbsolutePath(), commandLine.tempNativeFolder.toString()).toString());
                            writer.newLine();
                        }
                        writer.write(new CommandBuilder().add("cd", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()).toString());
                    }
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
                        writer.write(new CommandBuilder().addAll(StringUtils.tokenize(this.options.getPreLaunchCommand(), envVars)).toString());
                        writer.newLine();
                    }
                    writer.write(command);
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                        writer.write(new CommandBuilder().addAll(StringUtils.tokenize(this.options.getPostExitCommand(), envVars)).toString());
                        writer.newLine();
                    }
                    if (isWindows) {
                        writer.write("pause");
                        writer.newLine();
                    }
                    if (commandLine.tempNativeFolder != null) {
                        writer.write(new CommandBuilder().add("rm", commandLine.tempNativeFolder.toString()).toString());
                        writer.newLine();
                    }
                }
            }
        }
        if (!scriptFile.setExecutable(true)) {
            throw new PermissionException();
        }
        if (usePowerShell && !CommandBuilder.hasExecutionPolicy()) {
            throw new ExecutionPolicyLimitException();
        }
    }

    private void startMonitors(ManagedProcess managedProcess, ProcessListener processListener, Charset encoding, boolean isDaemon) {
        processListener.setProcess(managedProcess);
        Thread stdout = Lang.thread(new StreamPump(managedProcess.getProcess().getInputStream(), it -> {
            processListener.onLog((String)it, false);
            managedProcess.addLine((String)it);
        }, encoding), "stdout-pump", isDaemon);
        managedProcess.addRelatedThread(stdout);
        Thread stderr = Lang.thread(new StreamPump(managedProcess.getProcess().getErrorStream(), it -> {
            processListener.onLog((String)it, true);
            managedProcess.addLine((String)it);
        }, encoding), "stderr-pump", isDaemon);
        managedProcess.addRelatedThread(stderr);
        managedProcess.addRelatedThread(Lang.thread(new ExitWaiter(managedProcess, Arrays.asList(stdout, stderr), (exitCode, exitType) -> {
            processListener.onExit((int)exitCode, (ProcessListener.ExitType)((Object)exitType));
            if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                try {
                    ProcessBuilder builder = new ProcessBuilder(StringUtils.tokenize(this.options.getPostExitCommand(), this.getEnvVars())).directory(this.options.getGameDir());
                    builder.environment().putAll(this.getEnvVars());
                    SystemUtils.callExternalProcess(builder);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("An Exception happened while running exit command.", e);
                }
            }
        }), "exit-waiter", isDaemon));
    }

    private static final class Command {
        final CommandBuilder commandLine;
        final Path tempNativeFolder;
        final Charset encoding;

        Command(CommandBuilder commandBuilder, Path tempNativeFolder, Charset encoding) {
            this.commandLine = commandBuilder;
            this.tempNativeFolder = tempNativeFolder;
            this.encoding = encoding;
        }
    }
}

