/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.StringUtils;

public class PromptDialogPane
extends DialogPane {
    private final CompletableFuture<List<Builder.Question<?>>> future = new CompletableFuture();
    private final Builder builder;

    public PromptDialogPane(Builder builder) {
        this.builder = builder;
        this.setTitle(builder.title);
        GridPane body = new GridPane();
        body.setVgap(8.0);
        body.setHgap(16.0);
        body.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
        this.setBody(new Node[]{body});
        ArrayList<BooleanBinding> bindings = new ArrayList<BooleanBinding>();
        int rowIndex = 0;
        for (Builder.Question question : builder.questions) {
            if (question instanceof Builder.StringQuestion) {
                Builder.StringQuestion stringQuestion = (Builder.StringQuestion)question;
                JFXTextField textField = new JFXTextField();
                textField.textProperty().addListener((a, b, newValue) -> {
                    stringQuestion.value = textField.getText();
                });
                textField.setText((String)stringQuestion.value);
                textField.setValidators(((Builder.StringQuestion)question).validators.toArray(new ValidatorBase[0]));
                if (stringQuestion.promptText != null) {
                    textField.setPromptText(stringQuestion.promptText);
                }
                bindings.add(Bindings.createBooleanBinding(textField::validate, (Observable[])new Observable[]{textField.textProperty()}));
                if (StringUtils.isNotBlank((String)question.question.get())) {
                    body.addRow(rowIndex++, new Node[]{new Label((String)question.question.get()), textField});
                } else {
                    GridPane.setColumnSpan((Node)textField, (Integer)2);
                    body.addRow(rowIndex++, new Node[]{textField});
                }
                GridPane.setMargin((Node)textField, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
                continue;
            }
            if (question instanceof Builder.BooleanQuestion) {
                HBox hBox = new HBox();
                GridPane.setColumnSpan((Node)hBox, (Integer)2);
                JFXCheckBox checkBox = new JFXCheckBox();
                hBox.getChildren().setAll((Object[])new Node[]{checkBox});
                HBox.setMargin((Node)checkBox, (Insets)new Insets(0.0, 0.0, 0.0, -10.0));
                checkBox.setSelected((Boolean)((Builder.BooleanQuestion)question).value);
                checkBox.selectedProperty().addListener((a, b, newValue) -> {
                    ((Builder.BooleanQuestion)question).value = newValue;
                });
                checkBox.setText((String)question.question.get());
                body.addRow(rowIndex++, new Node[]{hBox});
                continue;
            }
            if (question instanceof Builder.CandidatesQuestion) {
                JFXComboBox comboBox = new JFXComboBox();
                comboBox.getItems().setAll(((Builder.CandidatesQuestion)question).candidates);
                comboBox.getSelectionModel().selectedIndexProperty().addListener((a, b, newValue) -> {
                    ((Builder.CandidatesQuestion)question).value = newValue.intValue();
                });
                comboBox.getSelectionModel().select(0);
                if (StringUtils.isNotBlank((String)question.question.get())) {
                    body.addRow(rowIndex++, new Node[]{new Label((String)question.question.get()), comboBox});
                    continue;
                }
                GridPane.setColumnSpan(comboBox, (Integer)2);
                body.addRow(rowIndex++, new Node[]{comboBox});
                continue;
            }
            if (!(question instanceof Builder.HintQuestion)) continue;
            HintPane pane = new HintPane();
            GridPane.setColumnSpan((Node)pane, (Integer)2);
            pane.textProperty().bind((ObservableValue)question.question);
            body.addRow(rowIndex++, new Node[]{pane});
        }
        this.validProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> bindings.stream().allMatch(BooleanBinding::get), (Observable[])((Observable[])bindings.toArray(new BooleanBinding[0]))));
    }

    @Override
    protected void onAccept() {
        this.setLoading();
        this.builder.callback.call(this.builder.questions, () -> {
            this.future.complete(this.builder.questions);
            FXUtils.runInFX(this::onSuccess);
        }, msg -> FXUtils.runInFX(() -> this.onFailure((String)msg)));
    }

    public CompletableFuture<List<Builder.Question<?>>> getCompletableFuture() {
        return this.future;
    }

    public static class Builder {
        private final List<Question<?>> questions = new ArrayList();
        private final String title;
        private final FutureCallback<List<Question<?>>> callback;

        public Builder(String title, FutureCallback<List<Question<?>>> callback) {
            this.title = title;
            this.callback = callback;
        }

        public <T> Builder addQuestion(Question<T> question) {
            this.questions.add(question);
            return this;
        }

        public static class BooleanQuestion
        extends Question<Boolean> {
            public BooleanQuestion(String question, boolean defaultValue) {
                super(question);
                this.value = defaultValue;
            }
        }

        public static class CandidatesQuestion
        extends Question<Integer> {
            protected final List<String> candidates;

            public CandidatesQuestion(String question, String ... candidates) {
                super(question);
                this.value = null;
                if (candidates == null || candidates.length == 0) {
                    throw new IllegalArgumentException("At least one candidate required");
                }
                this.candidates = new ArrayList<String>(Arrays.asList(candidates));
            }
        }

        public static class StringQuestion
        extends Question<String> {
            protected final List<ValidatorBase> validators;
            protected String promptText;

            public StringQuestion(String question, String defaultValue, ValidatorBase ... validators) {
                super(question);
                this.value = defaultValue;
                this.validators = Arrays.asList(validators);
            }

            public StringQuestion setPromptText(String promptText) {
                this.promptText = promptText;
                return this;
            }
        }

        public static class HintQuestion
        extends Question<Void> {
            public HintQuestion(String hint) {
                super(hint);
            }
        }

        public static class Question<T> {
            public final StringProperty question = new SimpleStringProperty();
            protected T value;

            public Question(String question) {
                this.question.set((Object)question);
            }

            public T getValue() {
                return this.value;
            }

            public String getQuestion() {
                return (String)this.question.get();
            }

            public StringProperty questionProperty() {
                return this.question;
            }

            public void setQuestion(String question) {
                this.question.set((Object)question);
            }
        }
    }
}

