/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.svg.SVGGlyph;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.util.Lang;

public class DecoratorSkin
extends SkinBase<Decorator> {
    private static final PseudoClass TRANSPARENT = PseudoClass.getPseudoClass((String)"transparent");
    private static final SVGGlyph minus = Lang.apply(new SVGGlyph(0, "MINUS", "M804.571 420.571v109.714q0 22.857-16 38.857t-38.857 16h-694.857q-22.857 0-38.857-16t-16-38.857v-109.714q0-22.857 16-38.857t38.857-16h694.857q22.857 0 38.857 16t16 38.857z", (Paint)Color.WHITE), glyph -> {
        glyph.setSize(12.0, 2.0);
        glyph.setTranslateY(4.0);
    });
    private final StackPane root;
    private final StackPane parent;
    private final StackPane titleContainer;
    private final Stage primaryStage;
    private final TransitionPane navBarPane;
    private double xOffset;
    private double yOffset;
    private double newX;
    private double newY;
    private double initX;
    private double initY;
    private boolean titleBarTransparent = true;

    public DecoratorSkin(Decorator control) {
        super((Control)control);
        this.primaryStage = control.getPrimaryStage();
        minus.fillProperty().bind(Theme.foregroundFillBinding());
        Decorator skinnable = (Decorator)this.getSkinnable();
        this.root = new StackPane();
        this.root.getStyleClass().add((Object)"window");
        StackPane shadowContainer = new StackPane();
        shadowContainer.getStyleClass().add((Object)"body");
        this.parent = new StackPane();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.parent.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.parent.heightProperty());
        clip.setArcWidth(8.0);
        clip.setArcHeight(8.0);
        this.parent.setClip((Node)clip);
        skinnable.getSnackbar().registerSnackbarContainer((Pane)this.parent);
        this.root.addEventFilter(MouseEvent.MOUSE_RELEASED, this::onMouseReleased);
        this.root.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::onMouseDragged);
        this.root.addEventFilter(MouseEvent.MOUSE_MOVED, this::onMouseMoved);
        shadowContainer.getChildren().setAll((Object[])new Node[]{this.parent});
        this.root.getChildren().setAll((Object[])new Node[]{shadowContainer});
        StackPane wrapper = new StackPane();
        BorderPane frame = new BorderPane();
        frame.getStyleClass().addAll((Object[])new String[]{"jfx-decorator"});
        wrapper.getChildren().setAll((Object[])new Node[]{frame});
        skinnable.setDrawerWrapper(wrapper);
        this.parent.getChildren().add((Object)wrapper);
        StackPane container = new StackPane();
        FXUtils.setOverflowHidden((Region)container);
        StackPane contentPlaceHolder = new StackPane();
        contentPlaceHolder.getStyleClass().add((Object)"jfx-decorator-content-container");
        Bindings.bindContent((List)contentPlaceHolder.getChildren(), skinnable.contentProperty());
        container.getChildren().add((Object)contentPlaceHolder);
        StackPane floatLayer = new StackPane();
        Bindings.bindContent((List)floatLayer.getChildren(), skinnable.containerProperty());
        ListChangeListener listener = c -> {
            if (skinnable.getContainer().isEmpty()) {
                floatLayer.setMouseTransparent(true);
                floatLayer.setVisible(false);
            } else {
                floatLayer.setMouseTransparent(false);
                floatLayer.setVisible(true);
            }
        };
        skinnable.containerProperty().addListener(listener);
        listener.onChanged(null);
        container.getChildren().add((Object)floatLayer);
        frame.setCenter((Node)container);
        this.titleContainer = new StackPane();
        this.titleContainer.setPickOnBounds(false);
        this.titleContainer.getStyleClass().addAll((Object[])new String[]{"jfx-tool-bar"});
        FXUtils.onChangeAndOperate(skinnable.titleTransparentProperty(), titleTransparent -> {
            if (titleTransparent.booleanValue()) {
                wrapper.backgroundProperty().bind(skinnable.contentBackgroundProperty());
                container.backgroundProperty().unbind();
                container.setBackground(null);
                this.titleContainer.getStyleClass().remove((Object)"background");
                this.titleContainer.getStyleClass().add((Object)"gray-background");
            } else {
                container.backgroundProperty().bind(skinnable.contentBackgroundProperty());
                wrapper.backgroundProperty().unbind();
                wrapper.setBackground(null);
                this.titleContainer.getStyleClass().add((Object)"background");
                this.titleContainer.getStyleClass().remove((Object)"gray-background");
            }
        });
        control.capableDraggingWindow((Node)this.titleContainer);
        BorderPane titleBar = new BorderPane();
        this.titleContainer.getChildren().add((Object)titleBar);
        Rectangle buttonsContainerPlaceHolder = new Rectangle();
        this.navBarPane = new TransitionPane();
        this.navBarPane.setId("decoratorTitleTransitionPane");
        FXUtils.onChangeAndOperate(skinnable.stateProperty(), s -> {
            if (s == null) {
                return;
            }
            Node node = this.createNavBar(skinnable, s.getLeftPaneWidth(), s.isBackable(), skinnable.canCloseProperty().get(), skinnable.showCloseAsHomeProperty().get(), s.isRefreshable(), s.getTitle(), s.getTitleNode());
            if (s.isAnimate()) {
                ContainerAnimations animation = skinnable.getNavigationDirection() == Navigation.NavigationDirection.NEXT ? ContainerAnimations.SWIPE_LEFT_FADE_SHORT : (skinnable.getNavigationDirection() == Navigation.NavigationDirection.PREVIOUS ? ContainerAnimations.SWIPE_RIGHT_FADE_SHORT : ContainerAnimations.FADE);
                skinnable.setNavigationDirection(Navigation.NavigationDirection.START);
                this.navBarPane.setContent(node, animation);
            } else {
                this.navBarPane.getChildren().setAll((Object[])new Node[]{node});
            }
        });
        titleBar.setCenter((Node)this.navBarPane);
        titleBar.setRight((Node)buttonsContainerPlaceHolder);
        frame.setTop((Node)this.titleContainer);
        HBox buttonsContainer = new HBox();
        buttonsContainer.setAlignment(Pos.TOP_RIGHT);
        buttonsContainer.setMaxHeight(40.0);
        JFXButton btnHelp = new JFXButton();
        btnHelp.setGraphic(SVG.HELP_CIRCLE_OUTLINE.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
        btnHelp.getStyleClass().add((Object)"jfx-decorator-button");
        btnHelp.setOnAction(e -> FXUtils.openLink("https://docs.hmcl.net/help.html"));
        JFXButton btnMin = new JFXButton();
        StackPane pane = new StackPane(new Node[]{minus});
        pane.setAlignment(Pos.CENTER);
        btnMin.setGraphic((Node)pane);
        btnMin.getStyleClass().add((Object)"jfx-decorator-button");
        btnMin.setOnAction(e -> skinnable.minimize());
        JFXButton btnClose = new JFXButton();
        btnClose.setGraphic(SVG.CLOSE.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
        btnClose.getStyleClass().add((Object)"jfx-decorator-button");
        btnClose.setOnAction(e -> skinnable.close());
        buttonsContainer.getChildren().setAll((Object[])new Node[]{btnHelp, btnMin, btnClose});
        AnchorPane layer = new AnchorPane();
        layer.setPickOnBounds(false);
        layer.getChildren().add((Object)buttonsContainer);
        AnchorPane.setTopAnchor((Node)buttonsContainer, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsContainer, (Double)0.0);
        buttonsContainerPlaceHolder.widthProperty().bind((ObservableValue)buttonsContainer.widthProperty());
        this.parent.getChildren().add((Object)layer);
        this.getChildren().add((Object)this.root);
    }

    private Node createNavBar(Decorator skinnable, double leftPaneWidth, boolean canBack, boolean canClose, boolean showCloseAsHome, boolean canRefresh, String title, Node titleNode) {
        BorderPane navBar = new BorderPane();
        HBox navLeft = new HBox();
        navLeft.setAlignment(Pos.CENTER_LEFT);
        navLeft.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        if (canBack) {
            JFXButton backNavButton = new JFXButton();
            backNavButton.setGraphic(SVG.BACK.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
            backNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            backNavButton.ripplerFillProperty().set((Object)Theme.whiteFill());
            backNavButton.onActionProperty().bind(skinnable.onBackNavButtonActionProperty());
            backNavButton.visibleProperty().set(canBack);
            navLeft.getChildren().add((Object)backNavButton);
        }
        if (canClose) {
            JFXButton closeNavButton = new JFXButton();
            closeNavButton.setGraphic(SVG.CLOSE.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
            closeNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            closeNavButton.ripplerFillProperty().set((Object)Theme.whiteFill());
            closeNavButton.onActionProperty().bind(skinnable.onCloseNavButtonActionProperty());
            if (showCloseAsHome) {
                closeNavButton.setGraphic(SVG.HOME.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
            } else {
                closeNavButton.setGraphic(SVG.CLOSE.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
            }
            navLeft.getChildren().add((Object)closeNavButton);
        }
        if (canBack || canClose) {
            navBar.setLeft((Node)navLeft);
        }
        BorderPane center = new BorderPane();
        if (title != null) {
            Label titleLabel = new Label();
            BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
            titleLabel.getStyleClass().add((Object)"jfx-decorator-title");
            if (titleNode == null) {
                titleLabel.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> skinnable.getWidth() - 100.0 - navLeft.getWidth(), (Observable[])new Observable[]{skinnable.widthProperty(), navLeft.widthProperty()}));
            } else {
                titleLabel.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> leftPaneWidth - 8.0 - navLeft.getWidth(), (Observable[])new Observable[]{navLeft.widthProperty()}));
            }
            titleLabel.setText(title);
            center.setLeft((Node)titleLabel);
            BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
        }
        if (titleNode != null) {
            center.setCenter(titleNode);
            BorderPane.setAlignment((Node)titleNode, (Pos)Pos.CENTER_LEFT);
            BorderPane.setMargin((Node)titleNode, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        }
        navBar.setCenter((Node)center);
        if (canRefresh) {
            HBox navRight = new HBox();
            navRight.setAlignment(Pos.CENTER_RIGHT);
            JFXButton refreshNavButton = new JFXButton();
            refreshNavButton.setGraphic(SVG.REFRESH.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), -1.0, -1.0));
            refreshNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            refreshNavButton.ripplerFillProperty().set((Object)Theme.whiteFill());
            refreshNavButton.onActionProperty().bind(skinnable.onRefreshNavButtonActionProperty());
            Rectangle separator = new Rectangle();
            separator.visibleProperty().bind((ObservableValue)refreshNavButton.visibleProperty());
            separator.heightProperty().bind((ObservableValue)navBar.heightProperty());
            separator.setFill((Paint)Color.GRAY);
            navRight.getChildren().setAll((Object[])new Node[]{refreshNavButton, separator});
            navBar.setRight((Node)navRight);
        }
        return navBar;
    }

    private void updateInitMouseValues(MouseEvent mouseEvent) {
        this.initX = mouseEvent.getScreenX();
        this.initY = mouseEvent.getScreenY();
        this.xOffset = mouseEvent.getSceneX();
        this.yOffset = mouseEvent.getSceneY();
    }

    private boolean isRightEdge(double x, double y, Bounds boundsInParent) {
        return x < this.root.getWidth() && x >= this.root.getWidth() - this.root.snappedLeftInset();
    }

    private boolean isTopEdge(double x, double y, Bounds boundsInParent) {
        return y >= 0.0 && y <= this.root.snappedTopInset();
    }

    private boolean isBottomEdge(double x, double y, Bounds boundsInParent) {
        return y < this.root.getHeight() && y >= this.root.getHeight() - this.root.snappedLeftInset();
    }

    private boolean isLeftEdge(double x, double y, Bounds boundsInParent) {
        return x >= 0.0 && x <= this.root.snappedLeftInset();
    }

    private boolean setStageWidth(double width) {
        if (width >= this.primaryStage.getMinWidth() && width >= this.titleContainer.getMinWidth()) {
            this.primaryStage.setWidth(width);
            this.initX = this.newX;
            return true;
        }
        if (width >= this.primaryStage.getMinWidth() && width <= this.titleContainer.getMinWidth()) {
            this.primaryStage.setWidth(this.titleContainer.getMinWidth());
        }
        return false;
    }

    private boolean setStageHeight(double height) {
        if (height >= this.primaryStage.getMinHeight() && height >= this.titleContainer.getHeight()) {
            this.primaryStage.setHeight(height);
            this.initY = this.newY;
            return true;
        }
        if (height >= this.primaryStage.getMinHeight() && height <= this.titleContainer.getHeight()) {
            this.primaryStage.setHeight(this.titleContainer.getHeight());
        }
        return false;
    }

    protected void onMouseMoved(MouseEvent mouseEvent) {
        if (!this.primaryStage.isFullScreen()) {
            this.updateInitMouseValues(mouseEvent);
            if (this.primaryStage.isResizable()) {
                double x = mouseEvent.getX();
                double y = mouseEvent.getY();
                Bounds boundsInParent = this.root.getBoundsInParent();
                double diagonalSize = this.root.snappedLeftInset() + 10.0;
                if (this.isRightEdge(x, y, boundsInParent)) {
                    if (y < diagonalSize) {
                        this.root.setCursor(Cursor.NE_RESIZE);
                    } else if (y > this.root.getHeight() - diagonalSize) {
                        this.root.setCursor(Cursor.SE_RESIZE);
                    } else {
                        this.root.setCursor(Cursor.E_RESIZE);
                    }
                } else if (this.isLeftEdge(x, y, boundsInParent)) {
                    if (y < diagonalSize) {
                        this.root.setCursor(Cursor.NW_RESIZE);
                    } else if (y > this.root.getHeight() - diagonalSize) {
                        this.root.setCursor(Cursor.SW_RESIZE);
                    } else {
                        this.root.setCursor(Cursor.W_RESIZE);
                    }
                } else if (this.isTopEdge(x, y, boundsInParent)) {
                    if (x < diagonalSize) {
                        this.root.setCursor(Cursor.NW_RESIZE);
                    } else if (x > this.root.getWidth() - diagonalSize) {
                        this.root.setCursor(Cursor.NE_RESIZE);
                    } else {
                        this.root.setCursor(Cursor.N_RESIZE);
                    }
                } else if (this.isBottomEdge(x, y, boundsInParent)) {
                    if (x < diagonalSize) {
                        this.root.setCursor(Cursor.SW_RESIZE);
                    } else if (x > this.root.getWidth() - diagonalSize) {
                        this.root.setCursor(Cursor.SE_RESIZE);
                    } else {
                        this.root.setCursor(Cursor.S_RESIZE);
                    }
                } else {
                    this.root.setCursor(Cursor.DEFAULT);
                }
            }
        } else {
            this.root.setCursor(Cursor.DEFAULT);
        }
    }

    protected void onMouseReleased(MouseEvent mouseEvent) {
        ((Decorator)this.getSkinnable()).setDragging(false);
    }

    protected void onMouseDragged(MouseEvent mouseEvent) {
        ((Decorator)this.getSkinnable()).setDragging(true);
        if (!(!mouseEvent.isPrimaryButtonDown() || this.xOffset == -1.0 && this.yOffset == -1.0 || this.primaryStage.isFullScreen() || mouseEvent.isStillSincePress())) {
            this.newX = mouseEvent.getScreenX();
            this.newY = mouseEvent.getScreenY();
            double deltaX = this.newX - this.initX;
            double deltaY = this.newY - this.initY;
            Cursor cursor = this.root.getCursor();
            if (Cursor.E_RESIZE == cursor) {
                this.setStageWidth(this.primaryStage.getWidth() + deltaX);
                mouseEvent.consume();
            } else if (Cursor.NE_RESIZE == cursor) {
                if (this.setStageHeight(this.primaryStage.getHeight() - deltaY)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltaY);
                }
                this.setStageWidth(this.primaryStage.getWidth() + deltaX);
                mouseEvent.consume();
            } else if (Cursor.SE_RESIZE == cursor) {
                this.setStageWidth(this.primaryStage.getWidth() + deltaX);
                this.setStageHeight(this.primaryStage.getHeight() + deltaY);
                mouseEvent.consume();
            } else if (Cursor.S_RESIZE == cursor) {
                this.setStageHeight(this.primaryStage.getHeight() + deltaY);
                mouseEvent.consume();
            } else if (Cursor.W_RESIZE == cursor) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltaX)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltaX);
                }
                mouseEvent.consume();
            } else if (Cursor.SW_RESIZE == cursor) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltaX)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltaX);
                }
                this.setStageHeight(this.primaryStage.getHeight() + deltaY);
                mouseEvent.consume();
            } else if (Cursor.NW_RESIZE == cursor) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltaX)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltaX);
                }
                if (this.setStageHeight(this.primaryStage.getHeight() - deltaY)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltaY);
                }
                mouseEvent.consume();
            } else if (Cursor.N_RESIZE == cursor) {
                if (this.setStageHeight(this.primaryStage.getHeight() - deltaY)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltaY);
                }
                mouseEvent.consume();
            } else if (((Decorator)this.getSkinnable()).isAllowMove()) {
                this.primaryStage.setX(mouseEvent.getScreenX() - this.xOffset);
                this.primaryStage.setY(mouseEvent.getScreenY() - this.yOffset);
                mouseEvent.consume();
            }
        }
    }
}

