/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javafx.scene.Node;
import org.jackhuang.hmcl.game.ManuallyCreatedModpackException;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.MismatchedModpackTypeException;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.UnsupportedModpackException;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.download.LocalModpackPage;
import org.jackhuang.hmcl.ui.download.ModpackSelectionPage;
import org.jackhuang.hmcl.ui.download.RemoteModpackPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;

public class ModpackInstallWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final File file;
    private final String updateVersion;
    public static final String PROFILE = "PROFILE";

    public ModpackInstallWizardProvider(Profile profile) {
        this(profile, null, null);
    }

    public ModpackInstallWizardProvider(Profile profile, File modpackFile) {
        this(profile, modpackFile, null);
    }

    public ModpackInstallWizardProvider(Profile profile, String updateVersion) {
        this(profile, null, updateVersion);
    }

    public ModpackInstallWizardProvider(Profile profile, File modpackFile, String updateVersion) {
        this.profile = profile;
        this.file = modpackFile;
        this.updateVersion = updateVersion;
    }

    @Override
    public void start(Map<String, Object> settings) {
        if (this.file != null) {
            settings.put("MODPACK_FILE", this.file);
        }
        if (this.updateVersion != null) {
            settings.put("MODPACK_NAME", this.updateVersion);
        }
        settings.put(PROFILE, this.profile);
    }

    private Task<?> finishModpackInstallingAsync(Map<String, Object> settings) {
        File selected = Lang.tryCast(settings.get("MODPACK_FILE"), File.class).orElse(null);
        ServerModpackManifest serverModpackManifest = Lang.tryCast(settings.get("MODPACK_SERVER_MANIFEST"), ServerModpackManifest.class).orElse(null);
        Modpack modpack = Lang.tryCast(settings.get("MODPACK_MANIFEST"), Modpack.class).orElse(null);
        String name = Lang.tryCast(settings.get("MODPACK_NAME"), String.class).orElse(null);
        Charset charset = Lang.tryCast(settings.get("MODPACK_CHARSET"), Charset.class).orElse(null);
        boolean isManuallyCreated = Lang.tryCast(settings.get("MODPACK_MANUALLY_CREATED"), Boolean.class).orElse(false);
        if (isManuallyCreated) {
            return ModpackHelper.getInstallManuallyCreatedModpackTask(this.profile, selected, name, charset);
        }
        if (selected == null && serverModpackManifest == null || modpack == null || name == null) {
            return null;
        }
        if (this.updateVersion != null) {
            if (selected == null) {
                Controllers.dialog(I18n.i18n("modpack.unsupported"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                return null;
            }
            try {
                if (serverModpackManifest != null) {
                    return ModpackHelper.getUpdateTask(this.profile, serverModpackManifest, modpack.getEncoding(), name, ModpackHelper.readModpackConfiguration(this.profile.getRepository().getModpackConfiguration(name)));
                }
                return ModpackHelper.getUpdateTask(this.profile, selected, modpack.getEncoding(), name, ModpackHelper.readModpackConfiguration(this.profile.getRepository().getModpackConfiguration(name)));
            }
            catch (ManuallyCreatedModpackException | UnsupportedModpackException e) {
                Controllers.dialog(I18n.i18n("modpack.unsupported"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            catch (MismatchedModpackTypeException e) {
                Controllers.dialog(I18n.i18n("modpack.mismatched_type"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            catch (IOException e) {
                Controllers.dialog(I18n.i18n("modpack.invalid"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            return null;
        }
        if (serverModpackManifest != null) {
            return ModpackHelper.getInstallTask(this.profile, serverModpackManifest, name, modpack).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
        }
        return ModpackHelper.getInstallTask(this.profile, selected, name, modpack).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
    }

    @Override
    public Object finish(Map<String, Object> settings) {
        settings.put("title", I18n.i18n("install.modpack"));
        settings.put("success_message", I18n.i18n("install.success"));
        settings.put("failure_callback", new WizardProvider.FailureCallback(){

            @Override
            public void onFail(Map<String, Object> settings, Exception exception, Runnable next) {
                if (exception instanceof ModpackCompletionException) {
                    if (exception.getCause() instanceof FileNotFoundException) {
                        Controllers.dialog(I18n.i18n("modpack.type.curse.not_found"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
                    } else {
                        Controllers.dialog(I18n.i18n("install.success"), I18n.i18n("install.success"), MessageDialogPane.MessageType.SUCCESS, next);
                    }
                } else {
                    UpdateInstallerWizardProvider.alertFailureMessage(exception, next);
                }
            }
        });
        return this.finishModpackInstallingAsync(settings);
    }

    @Override
    public Node createPage(WizardController controller, int step, Map<String, Object> settings) {
        switch (step) {
            case 0: {
                return new ModpackSelectionPage(controller);
            }
            case 1: {
                if (controller.getSettings().containsKey("MODPACK_FILE")) {
                    return new LocalModpackPage(controller);
                }
                if (controller.getSettings().containsKey("MODPACK_SERVER_MANIFEST")) {
                    return new RemoteModpackPage(controller);
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalStateException("error step " + step + ", settings: " + settings + ", pages: " + controller.getPages());
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

