/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.util.Map;
import javafx.scene.Node;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.download.InstallersPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class VanillaInstallWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final DefaultDependencyManager dependencyManager;
    private final DownloadProvider downloadProvider;
    public static final String PROFILE = "PROFILE";

    public VanillaInstallWizardProvider(Profile profile) {
        this.profile = profile;
        this.downloadProvider = DownloadProviders.getDownloadProvider();
        this.dependencyManager = profile.getDependency(this.downloadProvider);
    }

    @Override
    public void start(Map<String, Object> settings) {
        settings.put(PROFILE, this.profile);
    }

    private Task<Void> finishVersionDownloadingAsync(Map<String, Object> settings) {
        GameBuilder builder = this.dependencyManager.gameBuilder();
        String name = (String)settings.get("name");
        builder.name(name);
        builder.gameVersion(((RemoteVersion)settings.get("game")).getGameVersion());
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            if ("game".equals(entry.getKey()) || !(entry.getValue() instanceof RemoteVersion)) continue;
            builder.version((RemoteVersion)entry.getValue());
        }
        return builder.buildAsync().whenComplete(any -> this.profile.getRepository().refreshVersions()).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
    }

    @Override
    public Object finish(Map<String, Object> settings) {
        settings.put("title", I18n.i18n("install.new_game"));
        settings.put("success_message", I18n.i18n("install.success"));
        settings.put("failure_callback", (settings1, exception, next) -> UpdateInstallerWizardProvider.alertFailureMessage(exception, next));
        return this.finishVersionDownloadingAsync(settings);
    }

    @Override
    public Node createPage(WizardController controller, int step, Map<String, Object> settings) {
        switch (step) {
            case 0: {
                return new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer.game")), "", this.downloadProvider, "game", () -> controller.onNext((Node)new InstallersPage(controller, this.profile.getRepository(), ((RemoteVersion)controller.getSettings().get("game")).getGameVersion(), this.downloadProvider)));
            }
        }
        throw new IllegalStateException("error step " + step + ", settings: " + settings + ", pages: " + controller.getPages());
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

