/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.nbt;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.nbt.NBTFileType;
import org.jackhuang.hmcl.ui.nbt.NBTTreeView;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class NBTEditorPage
extends BorderPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state;
    private final File file;
    private final NBTFileType type;

    public NBTEditorPage(File file) throws IOException {
        this.getStyleClass().add((Object)"gray-background");
        this.state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("nbt.title", file.getAbsolutePath())));
        this.file = file;
        this.type = NBTFileType.ofFile(file);
        if (this.type == null) {
            throw new IOException("Unknown type of file " + file);
        }
        this.setCenter((Node)new ProgressIndicator());
        HBox actions = new HBox(8.0);
        actions.setPadding(new Insets(8.0));
        actions.setAlignment(Pos.CENTER_RIGHT);
        JFXButton saveButton = new JFXButton(I18n.i18n("button.save"));
        saveButton.getStyleClass().add((Object)"jfx-button-raised");
        saveButton.setButtonType(JFXButton.ButtonType.RAISED);
        saveButton.setOnAction(e -> {
            try {
                this.save();
            }
            catch (IOException ex) {
                Logger.LOG.warning("Failed to save NBT file", ex);
                Controllers.dialog(I18n.i18n("nbt.save.failed") + "\n\n" + StringUtils.getStackTrace(ex));
            }
        });
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"jfx-button-raised");
        cancelButton.setButtonType(JFXButton.ButtonType.RAISED);
        cancelButton.setOnAction(e -> this.fireEvent(new PageCloseEvent()));
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        actions.getChildren().setAll((Object[])new Node[]{saveButton, cancelButton});
        ((CompletableFuture)CompletableFuture.supplyAsync(Lang.wrap(() -> this.type.readAsTree(file))).thenAcceptAsync(tree -> this.setCenter((Node)new NBTTreeView((NBTTreeView.Item)((Object)tree))), Schedulers.javafx())).handleAsync((result, e) -> {
            if (e != null) {
                Logger.LOG.warning("Fail to open nbt file", (Throwable)e);
                Controllers.dialog(I18n.i18n("nbt.open.failed") + "\n\n" + StringUtils.getStackTrace(e), null, MessageDialogPane.MessageType.WARNING, () -> ((JFXButton)cancelButton).fire());
            }
            return null;
        }, Schedulers.javafx());
    }

    public void save() throws IOException {
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }
}

