/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.WorldListItem;
import org.jackhuang.hmcl.util.i18n.I18n;

public class WorldListItemSkin
extends SkinBase<WorldListItem> {
    public WorldListItemSkin(WorldListItem skinnable) {
        super((Control)skinnable);
        BorderPane root = new BorderPane();
        HBox center = new HBox();
        center.setMouseTransparent(true);
        center.setSpacing(8.0);
        center.setAlignment(Pos.CENTER_LEFT);
        StackPane imageViewContainer = new StackPane();
        FXUtils.setLimitWidth((Region)imageViewContainer, 32.0);
        FXUtils.setLimitHeight((Region)imageViewContainer, 32.0);
        ImageView imageView = new ImageView();
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.imageProperty().bind(skinnable.imageProperty());
        imageViewContainer.getChildren().setAll((Object[])new Node[]{imageView});
        TwoLineListItem item = new TwoLineListItem();
        item.titleProperty().bind((ObservableValue)skinnable.titleProperty());
        item.subtitleProperty().bind((ObservableValue)skinnable.subtitleProperty());
        BorderPane.setAlignment((Node)item, (Pos)Pos.CENTER);
        center.getChildren().setAll((Object[])new Node[]{imageView, item});
        root.setCenter((Node)center);
        PopupMenu menu = new PopupMenu();
        JFXPopup popup = new JFXPopup((Region)menu);
        Object[] objectArray = new Node[3];
        objectArray[0] = new IconedMenuItem(SVG.GEAR_OUTLINE, I18n.i18n("world.datapack"), skinnable::manageDatapacks, popup);
        objectArray[1] = new IconedMenuItem(SVG.EXPORT, I18n.i18n("world.export"), skinnable::export, popup);
        objectArray[2] = new IconedMenuItem(SVG.FOLDER_OUTLINE, I18n.i18n("world.reveal"), skinnable::reveal, popup);
        menu.getContent().setAll(objectArray);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnManage = new JFXButton();
        btnManage.setOnAction(e -> popup.show((Node)root, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, root.getHeight()));
        btnManage.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)btnManage, (Pos)Pos.CENTER);
        btnManage.setGraphic(SVG.DOTS_VERTICAL.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
        right.getChildren().add((Object)btnManage);
        root.setRight((Node)right);
        root.getStyleClass().add((Object)"md-list-cell");
        root.setPadding(new Insets(8.0));
        this.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)root)});
    }
}

