/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jackhuang.hmcl.util.Holder;

public final class InvocationDispatcher<T>
implements Consumer<T> {
    private final Executor executor;
    private final Consumer<T> action;
    private final AtomicReference<Holder<T>> pendingArg = new AtomicReference();

    public static <T> InvocationDispatcher<T> runOn(Executor executor, Consumer<T> action) {
        return new InvocationDispatcher<T>(executor, action);
    }

    private InvocationDispatcher(Executor executor, Consumer<T> action) {
        this.executor = executor;
        this.action = action;
    }

    @Override
    public void accept(T t) {
        if (this.pendingArg.getAndSet(new Holder<T>(t)) == null) {
            this.executor.execute(() -> {
                InvocationDispatcher invocationDispatcher = this;
                synchronized (invocationDispatcher) {
                    this.action.accept(((Holder)this.pendingArg.getAndSet(null)).value);
                }
            });
        }
    }
}

