/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jackhuang.hmcl.util.i18n.Locales;
import org.jackhuang.hmcl.util.logging.Logger;

public final class I18n {
    private static volatile Locales.SupportedLocale locale = Locales.DEFAULT;
    private static volatile ResourceBundle resourceBundle = locale.getResourceBundle();
    private static volatile DateTimeFormatter dateTimeFormatter;

    private I18n() {
    }

    public static void setLocale(Locales.SupportedLocale locale) {
        I18n.locale = locale;
        resourceBundle = locale.getResourceBundle();
        dateTimeFormatter = null;
    }

    public static boolean isUseChinese() {
        return locale.getLocale() == Locale.CHINA;
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String getName(Locales.SupportedLocale locale) {
        return locale == Locales.DEFAULT ? resourceBundle.getString("lang.default") : locale.getResourceBundle().getString("lang");
    }

    public static String i18n(String key, Object ... formatArgs) {
        try {
            return String.format(I18n.getResourceBundle().getString(key), formatArgs);
        }
        catch (MissingResourceException e) {
            Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
        }
        catch (IllegalFormatException e) {
            Logger.LOG.error("Illegal format string, key=" + key + ", args=" + Arrays.toString(formatArgs), e);
        }
        return key + Arrays.toString(formatArgs);
    }

    public static String i18n(String key) {
        try {
            return I18n.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
            return key;
        }
    }

    public static String formatDateTime(Instant instant) {
        DateTimeFormatter formatter = dateTimeFormatter;
        if (formatter == null) {
            formatter = dateTimeFormatter = DateTimeFormatter.ofPattern(I18n.getResourceBundle().getString("world.time")).withZone(ZoneId.systemDefault());
        }
        return formatter.format(instant);
    }

    public static boolean hasKey(String key) {
        return I18n.getResourceBundle().containsKey(key);
    }
}

