#ifndef _ARDUINO_ST77916_H_
#define _ARDUINO_ST77916_H_

#include "../Arduino_GFX.h"
#include "../Arduino_TFT.h"

#define ST77916_TFTWIDTH 360
#define ST77916_TFTHEIGHT 360

#define ST77916_RST_DELAY 120    ///< delay ms wait for reset finish
#define ST77916_SLPIN_DELAY 120  ///< delay ms wait for sleep in finish
#define ST77916_SLPOUT_DELAY 120 ///< delay ms wait for sleep out finish

#define ST77916_NOP 0x00
#define ST77916_SWRESET 0x01
#define ST77916_RDDID 0x04
#define ST77916_RDDST 0x09

#define ST77916_SLPIN 0x10
#define ST77916_SLPOUT 0x11
#define ST77916_PTLON 0x12
#define ST77916_NORON 0x13

#define ST77916_INVOFF 0x20
#define ST77916_INVON 0x21
#define ST77916_DISPOFF 0x28
#define ST77916_DISPON 0x29

#define ST77916_CASET 0x2A
#define ST77916_RASET 0x2B
#define ST77916_RAMWR 0x2C
#define ST77916_RAMRD 0x2E

#define ST77916_PTLAR 0x30
#define ST77916_COLMOD 0x3A
#define ST77916_MADCTL 0x36

#define ST77916_MADCTL_MY 0x80
#define ST77916_MADCTL_MX 0x40
#define ST77916_MADCTL_MV 0x20
#define ST77916_MADCTL_ML 0x10
#define ST77916_MADCTL_RGB 0x00
#define ST77916_MADCTL_BGR 0x08
#define ST77916_MADCTL_MH 0x04

#define ST77916_RDID1 0xDA
#define ST77916_RDID2 0xDB
#define ST77916_RDID3 0xDC
#define ST77916_RDID4 0xDD

static const uint8_t st77916_150_init_operations[] = {
    BEGIN_WRITE,
    WRITE_C8_D8, 0xF0, 0x28,
    WRITE_C8_D8, 0xF2, 0x28,
    WRITE_C8_D8, 0x73, 0xF0,
    WRITE_C8_D8, 0x7C, 0xD1,
    WRITE_C8_D8, 0x83, 0xE0,
    WRITE_C8_D8, 0x84, 0x61,
    WRITE_C8_D8, 0xF2, 0x82,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_C8_D8, 0xF0, 0x01,
    WRITE_C8_D8, 0xF1, 0x01,
    WRITE_C8_D8, 0xB0, 0x69,
    WRITE_C8_D8, 0xB1, 0x4A,
    WRITE_C8_D8, 0xB2, 0x2F,
    WRITE_C8_D8, 0xB3, 0x01,
    WRITE_C8_D8, 0xB4, 0x69,
    WRITE_C8_D8, 0xB5, 0x45,
    WRITE_C8_D8, 0xB6, 0xAB,
    WRITE_C8_D8, 0xB7, 0x41,
    WRITE_C8_D8, 0xB8, 0x86,
    WRITE_C8_D8, 0xB9, 0x15,
    WRITE_C8_D8, 0xBA, 0x00,
    WRITE_C8_D8, 0xBB, 0x08,
    WRITE_C8_D8, 0xBC, 0x08,
    WRITE_C8_D8, 0xBD, 0x00,
    WRITE_C8_D8, 0xBE, 0x00,
    WRITE_C8_D8, 0xBF, 0x07,
    WRITE_C8_D8, 0xC0, 0x80,
    WRITE_C8_D8, 0xC1, 0x10,
    WRITE_C8_D8, 0xC2, 0x37,
    WRITE_C8_D8, 0xC3, 0x80,
    WRITE_C8_D8, 0xC4, 0x10,
    WRITE_C8_D8, 0xC5, 0x37,
    WRITE_C8_D8, 0xC6, 0xA9,
    WRITE_C8_D8, 0xC7, 0x41,
    WRITE_C8_D8, 0xC8, 0x01,
    WRITE_C8_D8, 0xC9, 0xA9,
    WRITE_C8_D8, 0xCA, 0x41,
    WRITE_C8_D8, 0xCB, 0x01,
    WRITE_C8_D8, 0xCC, 0x7F,
    WRITE_C8_D8, 0xCD, 0x7F,
    WRITE_C8_D8, 0xCE, 0xFF,
    WRITE_C8_D8, 0xD0, 0x91,
    WRITE_C8_D8, 0xD1, 0x68,
    WRITE_C8_D8, 0xD2, 0x68,
    WRITE_C8_D16, 0xF5, 0x00, 0xA5,
    WRITE_C8_D8, 0xF1, 0x10,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_C8_D8, 0xF0, 0x02,

    WRITE_COMMAND_8, 0xE0,
    WRITE_BYTES, 14,
    0xF0, 0x10, 0x18, 0x0D,
    0x0C, 0x38, 0x3E, 0x44,
    0x51, 0x39, 0x15, 0x15,
    0x30, 0x34,

    WRITE_COMMAND_8, 0xE1,
    WRITE_BYTES, 14,
    0xF0, 0x0F, 0x17, 0x0D,
    0x0B, 0x07, 0x3E, 0x33,
    0x51, 0x39, 0x15, 0x15,
    0x30, 0x34,

    WRITE_C8_D8, 0xF0, 0x10,
    WRITE_C8_D8, 0xF3, 0x10,
    WRITE_C8_D8, 0xE0, 0x08,
    WRITE_C8_D8, 0xE1, 0x00,
    WRITE_C8_D8, 0xE2, 0x00,
    WRITE_C8_D8, 0xE3, 0x00,
    WRITE_C8_D8, 0xE4, 0xE0,
    WRITE_C8_D8, 0xE5, 0x06,
    WRITE_C8_D8, 0xE6, 0x21,
    WRITE_C8_D8, 0xE7, 0x03,
    WRITE_C8_D8, 0xE8, 0x05,
    WRITE_C8_D8, 0xE9, 0x02,
    WRITE_C8_D8, 0xEA, 0xE9,
    WRITE_C8_D8, 0xEB, 0x00,
    WRITE_C8_D8, 0xEC, 0x00,
    WRITE_C8_D8, 0xED, 0x14,
    WRITE_C8_D8, 0xEE, 0xFF,
    WRITE_C8_D8, 0xEF, 0x00,
    WRITE_C8_D8, 0xF8, 0xFF,
    WRITE_C8_D8, 0xF9, 0x00,
    WRITE_C8_D8, 0xFA, 0x00,
    WRITE_C8_D8, 0xFB, 0x30,
    WRITE_C8_D8, 0xFC, 0x00,
    WRITE_C8_D8, 0xFD, 0x00,
    WRITE_C8_D8, 0xFE, 0x00,
    WRITE_C8_D8, 0xFF, 0x00,
    WRITE_C8_D8, 0x60, 0x40,
    WRITE_C8_D8, 0x61, 0x05,
    WRITE_C8_D8, 0x62, 0x00,
    WRITE_C8_D8, 0x63, 0x42,
    WRITE_C8_D8, 0x64, 0xDA,
    WRITE_C8_D8, 0x65, 0x00,
    WRITE_C8_D8, 0x66, 0x00,
    WRITE_C8_D8, 0x67, 0x00,
    WRITE_C8_D8, 0x68, 0x00,
    WRITE_C8_D8, 0x69, 0x00,
    WRITE_C8_D8, 0x6A, 0x00,
    WRITE_C8_D8, 0x6B, 0x00,
    WRITE_C8_D8, 0x70, 0x40,
    WRITE_C8_D8, 0x71, 0x04,
    WRITE_C8_D8, 0x72, 0x00,
    WRITE_C8_D8, 0x73, 0x42,
    WRITE_C8_D8, 0x74, 0xD9,
    WRITE_C8_D8, 0x75, 0x00,
    WRITE_C8_D8, 0x76, 0x00,
    WRITE_C8_D8, 0x77, 0x00,
    WRITE_C8_D8, 0x78, 0x00,
    WRITE_C8_D8, 0x79, 0x00,
    WRITE_C8_D8, 0x7A, 0x00,
    WRITE_C8_D8, 0x7B, 0x00,
    WRITE_C8_D8, 0x80, 0x48,
    WRITE_C8_D8, 0x81, 0x00,
    WRITE_C8_D8, 0x82, 0x07,
    WRITE_C8_D8, 0x83, 0x02,
    WRITE_C8_D8, 0x84, 0xD7,
    WRITE_C8_D8, 0x85, 0x04,
    WRITE_C8_D8, 0x86, 0x00,
    WRITE_C8_D8, 0x87, 0x00,
    WRITE_C8_D8, 0x88, 0x48,
    WRITE_C8_D8, 0x89, 0x00,
    WRITE_C8_D8, 0x8A, 0x09,
    WRITE_C8_D8, 0x8B, 0x02,
    WRITE_C8_D8, 0x8C, 0xD9,
    WRITE_C8_D8, 0x8D, 0x04,
    WRITE_C8_D8, 0x8E, 0x00,
    WRITE_C8_D8, 0x8F, 0x00,
    WRITE_C8_D8, 0x90, 0x48,
    WRITE_C8_D8, 0x91, 0x00,
    WRITE_C8_D8, 0x92, 0x0B,
    WRITE_C8_D8, 0x93, 0x02,
    WRITE_C8_D8, 0x94, 0xDB,
    WRITE_C8_D8, 0x95, 0x04,
    WRITE_C8_D8, 0x96, 0x00,
    WRITE_C8_D8, 0x97, 0x00,
    WRITE_C8_D8, 0x98, 0x48,
    WRITE_C8_D8, 0x99, 0x00,
    WRITE_C8_D8, 0x9A, 0x0D,
    WRITE_C8_D8, 0x9B, 0x02,
    WRITE_C8_D8, 0x9C, 0xDD,
    WRITE_C8_D8, 0x9D, 0x04,
    WRITE_C8_D8, 0x9E, 0x00,
    WRITE_C8_D8, 0x9F, 0x00,
    WRITE_C8_D8, 0xA0, 0x48,
    WRITE_C8_D8, 0xA1, 0x00,
    WRITE_C8_D8, 0xA2, 0x06,
    WRITE_C8_D8, 0xA3, 0x02,
    WRITE_C8_D8, 0xA4, 0xD6,
    WRITE_C8_D8, 0xA5, 0x04,
    WRITE_C8_D8, 0xA6, 0x00,
    WRITE_C8_D8, 0xA7, 0x00,
    WRITE_C8_D8, 0xA8, 0x48,
    WRITE_C8_D8, 0xA9, 0x00,
    WRITE_C8_D8, 0xAA, 0x08,
    WRITE_C8_D8, 0xAB, 0x02,
    WRITE_C8_D8, 0xAC, 0xD8,
    WRITE_C8_D8, 0xAD, 0x04,
    WRITE_C8_D8, 0xAE, 0x00,
    WRITE_C8_D8, 0xAF, 0x00,
    WRITE_C8_D8, 0xB0, 0x48,
    WRITE_C8_D8, 0xB1, 0x00,
    WRITE_C8_D8, 0xB2, 0x0A,
    WRITE_C8_D8, 0xB3, 0x02,
    WRITE_C8_D8, 0xB4, 0xDA,
    WRITE_C8_D8, 0xB5, 0x04,
    WRITE_C8_D8, 0xB6, 0x00,
    WRITE_C8_D8, 0xB7, 0x00,
    WRITE_C8_D8, 0xB8, 0x48,
    WRITE_C8_D8, 0xB9, 0x00,
    WRITE_C8_D8, 0xBA, 0x0C,
    WRITE_C8_D8, 0xBB, 0x02,
    WRITE_C8_D8, 0xBC, 0xDC,
    WRITE_C8_D8, 0xBD, 0x04,
    WRITE_C8_D8, 0xBE, 0x00,
    WRITE_C8_D8, 0xBF, 0x00,
    WRITE_C8_D8, 0xC0, 0x10,
    WRITE_C8_D8, 0xC1, 0x47,
    WRITE_C8_D8, 0xC2, 0x56,
    WRITE_C8_D8, 0xC3, 0x65,
    WRITE_C8_D8, 0xC4, 0x74,
    WRITE_C8_D8, 0xC5, 0x88,
    WRITE_C8_D8, 0xC6, 0x99,
    WRITE_C8_D8, 0xC7, 0x01,
    WRITE_C8_D8, 0xC8, 0xBB,
    WRITE_C8_D8, 0xC9, 0xAA,
    WRITE_C8_D8, 0xD0, 0x10,
    WRITE_C8_D8, 0xD1, 0x47,
    WRITE_C8_D8, 0xD2, 0x56,
    WRITE_C8_D8, 0xD3, 0x65,
    WRITE_C8_D8, 0xD4, 0x74,
    WRITE_C8_D8, 0xD5, 0x88,
    WRITE_C8_D8, 0xD6, 0x99,
    WRITE_C8_D8, 0xD7, 0x01,
    WRITE_C8_D8, 0xD8, 0xBB,
    WRITE_C8_D8, 0xD9, 0xAA,
    WRITE_C8_D8, 0xF3, 0x01,
    WRITE_C8_D8, 0xF0, 0x00,

    WRITE_C8_D8, 0x3A, 0x05,
    WRITE_C8_D8, 0x35, 0x00,
    WRITE_COMMAND_8, 0x21,
    WRITE_COMMAND_8, 0x11,
    END_WRITE,

    DELAY, ST77916_SLPOUT_DELAY,

    BEGIN_WRITE,
    WRITE_COMMAND_8, 0x29,
    WRITE_COMMAND_8, 0x2c,
    END_WRITE};

static const uint8_t st77916_180_init_operations[] = {
    BEGIN_WRITE,
    WRITE_C8_D8, 0xF0, 0x08,
    WRITE_C8_D8, 0xF2, 0x08,
    WRITE_C8_D8, 0x9B, 0x51,
    WRITE_C8_D8, 0x86, 0x53,
    WRITE_C8_D8, 0xF2, 0x80,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_C8_D8, 0xF0, 0x01,
    WRITE_C8_D8, 0xF1, 0x01,
    WRITE_C8_D8, 0xB0, 0x54,
    WRITE_C8_D8, 0xB1, 0x3F,
    WRITE_C8_D8, 0xB2, 0x2A,
    WRITE_C8_D8, 0xB4, 0x46,
    WRITE_C8_D8, 0xB5, 0x34,
    WRITE_C8_D8, 0xB6, 0xD5,
    WRITE_C8_D8, 0xB7, 0x30,
    WRITE_C8_D8, 0xBA, 0x00,
    WRITE_C8_D8, 0xBB, 0x08,
    WRITE_C8_D8, 0xBC, 0x08,
    WRITE_C8_D8, 0xBD, 0x00,
    WRITE_C8_D8, 0xC0, 0x80,
    WRITE_C8_D8, 0xC1, 0x10,
    WRITE_C8_D8, 0xC2, 0x37,
    WRITE_C8_D8, 0xC3, 0x80,
    WRITE_C8_D8, 0xC4, 0x10,
    WRITE_C8_D8, 0xC5, 0x37,
    WRITE_C8_D8, 0xC6, 0xA9,
    WRITE_C8_D8, 0xC7, 0x41,
    WRITE_C8_D8, 0xC8, 0x51,
    WRITE_C8_D8, 0xC9, 0xA9,
    WRITE_C8_D8, 0xCA, 0x41,
    WRITE_C8_D8, 0xCB, 0x51,
    WRITE_C8_D8, 0xD0, 0x91,
    WRITE_C8_D8, 0xD1, 0x68,
    WRITE_C8_D8, 0xD2, 0x69,
    WRITE_C8_D16, 0xF5, 0x00, 0xA5,
    WRITE_C8_D8, 0xDD, 0x3F,
    WRITE_C8_D8, 0xDE, 0x3F,
    WRITE_C8_D8, 0xF1, 0x10,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_C8_D8, 0xF0, 0x02,
    WRITE_COMMAND_8, 0xE0,
    WRITE_BYTES, 14,
    0x70, 0x09, 0x12, 0x0C,
    0x0B, 0x27, 0x38, 0x54,
    0x4E, 0x19, 0x15, 0x15,
    0x2C, 0x2F,
    WRITE_COMMAND_8, 0xE1,
    WRITE_BYTES, 14,
    0x70, 0x08, 0x11, 0x0C,
    0x0B, 0x27, 0x38, 0x43,
    0x4C, 0x18, 0x14, 0x14,
    0x2B, 0x2D,
    WRITE_C8_D8, 0xF0, 0x10,
    WRITE_C8_D8, 0xF3, 0x10,
    WRITE_C8_D8, 0xE0, 0x08,
    WRITE_C8_D8, 0xE1, 0x00,
    WRITE_C8_D8, 0xE2, 0x00,
    WRITE_C8_D8, 0xE3, 0x00,
    WRITE_C8_D8, 0xE4, 0xE0,
    WRITE_C8_D8, 0xE5, 0x06,
    WRITE_C8_D8, 0xE6, 0x21,
    WRITE_C8_D8, 0xE7, 0x00,
    WRITE_C8_D8, 0xE8, 0x05,
    WRITE_C8_D8, 0xE9, 0x82,
    WRITE_C8_D8, 0xEA, 0xDF,
    WRITE_C8_D8, 0xEB, 0x89,
    WRITE_C8_D8, 0xEC, 0x20,
    WRITE_C8_D8, 0xED, 0x14,
    WRITE_C8_D8, 0xEE, 0xFF,
    WRITE_C8_D8, 0xEF, 0x00,
    WRITE_C8_D8, 0xF8, 0xFF,
    WRITE_C8_D8, 0xF9, 0x00,
    WRITE_C8_D8, 0xFA, 0x00,
    WRITE_C8_D8, 0xFB, 0x30,
    WRITE_C8_D8, 0xFC, 0x00,
    WRITE_C8_D8, 0xFD, 0x00,
    WRITE_C8_D8, 0xFE, 0x00,
    WRITE_C8_D8, 0xFF, 0x00,
    WRITE_C8_D8, 0x60, 0x42,
    WRITE_C8_D8, 0x61, 0xE0,
    WRITE_C8_D8, 0x62, 0x40,
    WRITE_C8_D8, 0x63, 0x40,
    WRITE_C8_D8, 0x64, 0x02,
    WRITE_C8_D8, 0x65, 0x00,
    WRITE_C8_D8, 0x66, 0x40,
    WRITE_C8_D8, 0x67, 0x03,
    WRITE_C8_D8, 0x68, 0x00,
    WRITE_C8_D8, 0x69, 0x00,
    WRITE_C8_D8, 0x6A, 0x00,
    WRITE_C8_D8, 0x6B, 0x00,
    WRITE_C8_D8, 0x70, 0x42,
    WRITE_C8_D8, 0x71, 0xE0,
    WRITE_C8_D8, 0x72, 0x40,
    WRITE_C8_D8, 0x73, 0x40,
    WRITE_C8_D8, 0x74, 0x02,
    WRITE_C8_D8, 0x75, 0x00,
    WRITE_C8_D8, 0x76, 0x40,
    WRITE_C8_D8, 0x77, 0x03,
    WRITE_C8_D8, 0x78, 0x00,
    WRITE_C8_D8, 0x79, 0x00,
    WRITE_C8_D8, 0x7A, 0x00,
    WRITE_C8_D8, 0x7B, 0x00,
    WRITE_C8_D8, 0x80, 0x48,
    WRITE_C8_D8, 0x81, 0x00,
    WRITE_C8_D8, 0x82, 0x05,
    WRITE_C8_D8, 0x83, 0x02,
    WRITE_C8_D8, 0x84, 0xDD,
    WRITE_C8_D8, 0x85, 0x00,
    WRITE_C8_D8, 0x86, 0x00,
    WRITE_C8_D8, 0x87, 0x00,
    WRITE_C8_D8, 0x88, 0x48,
    WRITE_C8_D8, 0x89, 0x00,
    WRITE_C8_D8, 0x8A, 0x07,
    WRITE_C8_D8, 0x8B, 0x02,
    WRITE_C8_D8, 0x8C, 0xDF,
    WRITE_C8_D8, 0x8D, 0x00,
    WRITE_C8_D8, 0x8E, 0x00,
    WRITE_C8_D8, 0x8F, 0x00,
    WRITE_C8_D8, 0x90, 0x48,
    WRITE_C8_D8, 0x91, 0x00,
    WRITE_C8_D8, 0x92, 0x09,
    WRITE_C8_D8, 0x93, 0x02,
    WRITE_C8_D8, 0x94, 0xE1,
    WRITE_C8_D8, 0x95, 0x00,
    WRITE_C8_D8, 0x96, 0x00,
    WRITE_C8_D8, 0x97, 0x00,
    WRITE_C8_D8, 0x98, 0x48,
    WRITE_C8_D8, 0x99, 0x00,
    WRITE_C8_D8, 0x9A, 0x0B,
    WRITE_C8_D8, 0x9B, 0x02,
    WRITE_C8_D8, 0x9C, 0xE3,
    WRITE_C8_D8, 0x9D, 0x00,
    WRITE_C8_D8, 0x9E, 0x00,
    WRITE_C8_D8, 0x9F, 0x00,
    WRITE_C8_D8, 0xA0, 0x48,
    WRITE_C8_D8, 0xA1, 0x00,
    WRITE_C8_D8, 0xA2, 0x04,
    WRITE_C8_D8, 0xA3, 0x02,
    WRITE_C8_D8, 0xA4, 0xDC,
    WRITE_C8_D8, 0xA5, 0x00,
    WRITE_C8_D8, 0xA6, 0x00,
    WRITE_C8_D8, 0xA7, 0x00,
    WRITE_C8_D8, 0xA8, 0x48,
    WRITE_C8_D8, 0xA9, 0x00,
    WRITE_C8_D8, 0xAA, 0x06,
    WRITE_C8_D8, 0xAB, 0x02,
    WRITE_C8_D8, 0xAC, 0xDE,
    WRITE_C8_D8, 0xAD, 0x00,
    WRITE_C8_D8, 0xAE, 0x00,
    WRITE_C8_D8, 0xAF, 0x00,
    WRITE_C8_D8, 0xB0, 0x48,
    WRITE_C8_D8, 0xB1, 0x00,
    WRITE_C8_D8, 0xB2, 0x08,
    WRITE_C8_D8, 0xB3, 0x02,
    WRITE_C8_D8, 0xB4, 0xE0,
    WRITE_C8_D8, 0xB5, 0x00,
    WRITE_C8_D8, 0xB6, 0x00,
    WRITE_C8_D8, 0xB7, 0x00,
    WRITE_C8_D8, 0xB8, 0x48,
    WRITE_C8_D8, 0xB9, 0x00,
    WRITE_C8_D8, 0xBA, 0x0A,
    WRITE_C8_D8, 0xBB, 0x02,
    WRITE_C8_D8, 0xBC, 0xE2,
    WRITE_C8_D8, 0xBD, 0x00,
    WRITE_C8_D8, 0xBE, 0x00,
    WRITE_C8_D8, 0xBF, 0x00,
    WRITE_C8_D8, 0xC0, 0x12,
    WRITE_C8_D8, 0xC1, 0xAA,
    WRITE_C8_D8, 0xC2, 0x65,
    WRITE_C8_D8, 0xC3, 0x74,
    WRITE_C8_D8, 0xC4, 0x47,
    WRITE_C8_D8, 0xC5, 0x56,
    WRITE_C8_D8, 0xC6, 0x00,
    WRITE_C8_D8, 0xC7, 0x88,
    WRITE_C8_D8, 0xC8, 0x99,
    WRITE_C8_D8, 0xC9, 0x33,
    WRITE_C8_D8, 0xD0, 0x21,
    WRITE_C8_D8, 0xD1, 0xAA,
    WRITE_C8_D8, 0xD2, 0x65,
    WRITE_C8_D8, 0xD3, 0x74,
    WRITE_C8_D8, 0xD4, 0x47,
    WRITE_C8_D8, 0xD5, 0x56,
    WRITE_C8_D8, 0xD6, 0x00,
    WRITE_C8_D8, 0xD7, 0x88,
    WRITE_C8_D8, 0xD8, 0x99,
    WRITE_C8_D8, 0xD9, 0x33,
    WRITE_C8_D8, 0xF3, 0x01,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_C8_D8, 0xF0, 0x01,
    WRITE_C8_D8, 0xF1, 0x01,
    WRITE_C8_D8, 0xA0, 0x0B,
    WRITE_C8_D8, 0xA3, 0x2A,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x2B,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x2C,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x2D,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x2E,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x2F,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x30,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x31,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x32,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA3, 0x33,
    WRITE_C8_D8, 0xA5, 0xC3,
    END_WRITE,
    DELAY, 1,
    BEGIN_WRITE,
    WRITE_C8_D8, 0xA0, 0x09,
    WRITE_C8_D8, 0xF1, 0x10,
    WRITE_C8_D8, 0xF0, 0x00,
    WRITE_COMMAND_8, 0x2A,
    WRITE_BYTES, 4,
    0x00, 0x00, 0x01, 0x67,
    WRITE_COMMAND_8, 0x2B,
    WRITE_BYTES, 4,
    0x01, 0x68, 0x01, 0x68,
    WRITE_C8_D8, 0x4D, 0x00,
    WRITE_C8_D8, 0x4E, 0x00,
    WRITE_C8_D8, 0x4F, 0x00,
    WRITE_C8_D8, 0x4C, 0x01,
    END_WRITE,
    DELAY, 10,
    BEGIN_WRITE,
    WRITE_C8_D8, 0x4C, 0x00,
    WRITE_COMMAND_8, 0x2A,
    WRITE_BYTES, 4,
    0x00, 0x00, 0x01, 0x67,
    WRITE_C8_D8, 0x4C, 0x00,
    WRITE_COMMAND_8, 0x2B,
    WRITE_BYTES, 4,
    0x00, 0x00, 0x01, 0x67,
    WRITE_C8_D8, 0x21, 0x00,
    WRITE_C8_D8, 0x3A, 0x55, // color=16
    WRITE_C8_D8, 0x11, 0x00,
    END_WRITE,
    DELAY, ST77916_SLPOUT_DELAY,
    BEGIN_WRITE,
    WRITE_C8_D8, 0x29, 0x00,
    END_WRITE};

class Arduino_ST77916 : public Arduino_TFT
{
public:
  Arduino_ST77916(
      Arduino_DataBus *bus, int8_t rst = GFX_NOT_DEFINED, uint8_t r = 0,
      bool ips = false, int16_t w = ST77916_TFTWIDTH, int16_t h = ST77916_TFTHEIGHT,
      uint8_t col_offset1 = 0, uint8_t row_offset1 = 0, uint8_t col_offset2 = 0, uint8_t row_offset2 = 0,
      const uint8_t *init_operations = st77916_180_init_operations, size_t init_operations_len = sizeof(st77916_180_init_operations));

  bool begin(int32_t speed = GFX_NOT_DEFINED) override;

  void setRotation(uint8_t r) override;

  void writeAddrWindow(int16_t x, int16_t y, uint16_t w, uint16_t h) override;

  void invertDisplay(bool) override;
  void displayOn() override;
  void displayOff() override;

protected:
  void tftInit() override;

private:
  const uint8_t *_init_operations;
  size_t _init_operations_len;
};

#endif
