/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.config.CraftingMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.parts.IPart;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.core.AELog;
import appeng.crafting.v2.CraftingJobV2;
import appeng.helpers.ICustomNameObject;
import appeng.me.Grid;
import appeng.me.GridStorage;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.Constants;
import com.asdflj.ae2thing.api.CraftingDebugCardObject;
import com.asdflj.ae2thing.api.LimitedSizeLinkedList;
import com.asdflj.ae2thing.util.Ae2Reflect;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraftingDebugHelper
implements ICraftingCallback {
    private static final HashMap<Long, LimitedSizeLinkedList<CraftingInfo>> history = new HashMap();
    private final CraftingInfo info;
    private final ICraftingCallback callback;

    public CraftingDebugHelper(World world, IGrid meGrid, BaseActionSource actionSource, IAEItemStack what, CraftingMode craftingMode, ICraftingCallback callback) {
        long id = AE2ThingAPI.instance().getStorageMyID((Grid)meGrid);
        history.putIfAbsent(id, new LimitedSizeLinkedList());
        this.info = new CraftingInfo(actionSource, what, AE2ThingAPI.instance().getStorageMyID((Grid)meGrid), craftingMode);
        this.info.setStartTime(System.currentTimeMillis());
        history.get(id).add(this.info);
        this.callback = callback;
    }

    public static void craftingHelper(CraftingJobV2 jobV2, World world, IGrid meGrid, BaseActionSource actionSource, IAEItemStack what, CraftingMode craftingMode, ICraftingCallback callback) {
        Ae2Reflect.setCallback(jobV2, new CraftingDebugHelper(world, meGrid, actionSource, what, craftingMode, callback));
    }

    public static void remove(GridStorage gridStorage) {
        history.remove(gridStorage.getID());
    }

    public void calculationComplete(ICraftingJob job) {
        this.info.setEndTime(System.currentTimeMillis());
        this.info.setSimulation(job.isSimulation());
        if (job instanceof CraftingJobV2) {
            CraftingJobV2 v2 = (CraftingJobV2)job;
            this.info.setErrorMessage(v2.getErrorMessage());
            if (v2.isCancelled()) {
                this.info.setState(Constants.State.CANCELLED);
            } else if (v2.isDone()) {
                this.info.setState(Constants.State.FINISHED);
            } else {
                this.info.setState(Constants.State.RUNNING);
            }
        }
        if (this.callback != null) {
            this.callback.calculationComplete(job);
        }
    }

    public static HashMap<Long, LimitedSizeLinkedList<CraftingInfo>> getHistory() {
        return history;
    }

    public static CraftingDebugCardObject getObject(ItemStack itemStack) {
        return new CraftingDebugCardObject(itemStack);
    }

    public static Gson getGson() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).setPrettyPrinting().registerTypeAdapter(ForgeDirection.class, (Object)new ForgeDirectionSerializer()).registerTypeAdapter(DimensionalCoord.class, (Object)new DimensionalCoordSerializer()).registerTypeAdapter(Constants.State.class, (Object)new StateSerializer()).create();
    }

    public static class CraftingInfo {
        @Expose
        public String name = "";
        @Expose
        public DimensionalCoord pos;
        @Expose
        public long startTime = 0L;
        @Expose
        public long endTime = 0L;
        @Expose
        public final String itemName;
        public final long id;
        public final CraftingMode mode;
        @Expose
        public boolean isPlayer;
        @Expose
        public long requestSize;
        @Expose
        public ForgeDirection direction = ForgeDirection.UNKNOWN;
        @Expose
        public String errorMessage = "";
        @Expose
        @SerializedName(value="simulationState")
        public Constants.State state = Constants.State.RUNNING;
        @Expose
        @SerializedName(value="missingItems")
        public boolean simulation = false;

        private String getName(IActionHost via, String name) {
            if (via instanceof ICustomNameObject) {
                ICustomNameObject o = (ICustomNameObject)via;
                return o.hasCustomName() ? o.getCustomName() : name;
            }
            return name;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getName() {
            return this.name;
        }

        public CraftingInfo(BaseActionSource actionSource, IAEItemStack item, long id, CraftingMode mode) {
            if (actionSource instanceof PlayerSource) {
                PlayerSource ps = (PlayerSource)actionSource;
                this.name = ps.player.getDisplayName();
                this.isPlayer = true;
            } else if (actionSource instanceof MachineSource) {
                MachineSource ms = (MachineSource)actionSource;
                IActionHost iActionHost = ms.via;
                if (iActionHost instanceof AEBasePart) {
                    AEBasePart part = (AEBasePart)iActionHost;
                    this.pos = part.getLocation();
                    this.name = this.getName(ms.via, part.getItemStack().func_82833_r());
                    this.direction = part.getSide();
                } else {
                    iActionHost = ms.via;
                    if (iActionHost instanceof IPart) {
                        IPart part = (IPart)iActionHost;
                        if (part instanceof IGridProxyable) {
                            IGridProxyable p = (IGridProxyable)part;
                            this.pos = p.getLocation();
                        } else {
                            this.pos = null;
                        }
                        this.name = this.getName(ms.via, Platform.getItemDisplayName((Object)part.getItemStack(PartItemStack.Pick)));
                    } else {
                        iActionHost = ms.via;
                        if (iActionHost instanceof TileEntity) {
                            TileEntity te = (TileEntity)iActionHost;
                            this.pos = new DimensionalCoord(te);
                            this.name = this.getName(ms.via, te.func_145838_q().func_149732_F());
                        } else {
                            AELog.error((String)"Unknown action source", (Object[])new Object[0]);
                            this.pos = null;
                        }
                    }
                }
            } else {
                AELog.error((String)"Unknown action source", (Object[])new Object[0]);
                this.pos = null;
            }
            this.id = id;
            this.mode = mode;
            this.itemName = Platform.getItemDisplayName((Object)item);
            this.requestSize = item.getStackSize();
        }

        public CraftingInfo(long id, String name, long startTime, long endTime, String itemName, byte mode, long requestSize, byte direction, boolean isPlayer, DimensionalCoord pos, String errorMessage, Constants.State state, boolean simulation) {
            this.id = id;
            this.name = name;
            this.startTime = startTime;
            this.endTime = endTime;
            this.itemName = itemName;
            this.requestSize = requestSize;
            this.mode = CraftingMode.values()[mode];
            this.direction = ForgeDirection.getOrientation((int)direction);
            this.isPlayer = isPlayer;
            this.pos = pos;
            this.errorMessage = errorMessage;
            this.state = state;
            this.simulation = simulation;
        }

        public boolean isPart() {
            return this.direction != ForgeDirection.UNKNOWN;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74772_a("nid", this.id);
            tag.func_74778_a("name", this.name);
            tag.func_74772_a("startTime", this.startTime);
            tag.func_74772_a("endTime", this.endTime);
            tag.func_74778_a("itemName", this.itemName);
            tag.func_74774_a("mode", (byte)this.mode.ordinal());
            tag.func_74772_a("requestSize", this.requestSize);
            tag.func_74774_a("direction", (byte)this.direction.ordinal());
            tag.func_74757_a("isPlayer", this.isPlayer);
            tag.func_74778_a("errorMsg", this.errorMessage);
            tag.func_74774_a("state", (byte)this.state.ordinal());
            tag.func_74757_a("simulation", this.simulation);
            if (!this.isPlayer && this.pos != null) {
                this.pos.writeToNBT(tag);
            }
        }

        public static void writeToNBTList(List<CraftingInfo> infos, NBTTagCompound tag, long networkID) {
            NBTTagList list = new NBTTagList();
            for (CraftingInfo info : infos) {
                NBTTagCompound data = new NBTTagCompound();
                info.writeToNBT(data);
                list.func_74742_a((NBTBase)data);
            }
            tag.func_74782_a("infos", (NBTBase)list);
            tag.func_74768_a("size", infos.size());
            tag.func_74772_a("networkID", networkID);
        }

        public static LimitedSizeLinkedList<CraftingInfo> readFromNBTList(NBTTagCompound tag) {
            LimitedSizeLinkedList<CraftingInfo> infos = new LimitedSizeLinkedList<CraftingInfo>();
            NBTTagList list = tag.func_150295_c("infos", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                infos.add(CraftingInfo.readFromNBT(data));
            }
            return infos;
        }

        public static CraftingInfo readFromNBT(NBTTagCompound tag) {
            long id = tag.func_74763_f("nid");
            String name = tag.func_74779_i("name");
            long startTime = tag.func_74763_f("startTime");
            long endTime = tag.func_74763_f("endTime");
            String itemName = tag.func_74779_i("itemName");
            byte mode = tag.func_74771_c("mode");
            long requestSize = tag.func_74763_f("requestSize");
            byte direction = tag.func_74771_c("direction");
            boolean isPlayer = tag.func_74767_n("isPlayer");
            String msg = tag.func_74779_i("errorMsg");
            boolean simulation = tag.func_74767_n("simulation");
            Constants.State state = Constants.State.values()[tag.func_74771_c("state")];
            DimensionalCoord pos = null;
            if (!isPlayer && tag.func_74764_b("dim")) {
                pos = DimensionalCoord.readFromNBT((NBTTagCompound)tag);
            }
            return new CraftingInfo(id, name, startTime, endTime, itemName, mode, requestSize, direction, isPlayer, pos, msg, state, simulation);
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public boolean isFinish() {
            return this.endTime != 0L;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String getNetworkID() {
            return Long.toString(this.id);
        }

        public String getFormatStartTime() {
            Date date = new Date(this.startTime);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(date);
        }

        public String getUsageTime() {
            return String.format("%s ms", this.endTime - this.startTime);
        }

        public void setErrorMessage(String message) {
            this.errorMessage = message;
        }

        public void setState(Constants.State state) {
            this.state = state;
        }

        public Constants.State getState() {
            return this.state;
        }

        public void setSimulation(boolean simulation) {
            this.simulation = simulation;
        }

        public boolean isSimulation() {
            return this.simulation;
        }
    }

    private static class ForgeDirectionSerializer
    implements JsonSerializer<ForgeDirection> {
        private ForgeDirectionSerializer() {
        }

        public JsonElement serialize(ForgeDirection src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }

    private static class DimensionalCoordSerializer
    implements JsonSerializer<DimensionalCoord> {
        private DimensionalCoordSerializer() {
        }

        public JsonElement serialize(DimensionalCoord src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return null;
            }
            JsonObject o = new JsonObject();
            o.addProperty("X", (Number)src.x);
            o.addProperty("Y", (Number)src.y);
            o.addProperty("Z", (Number)src.z);
            o.addProperty("Dim", (Number)src.getDimension());
            return o;
        }
    }

    private static class StateSerializer
    implements JsonSerializer<Constants.State> {
        private StateSerializer() {
        }

        public JsonElement serialize(Constants.State src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }
}

