/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api.adapter.findit;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.item.AEFluidStack;
import codechicken.nei.recipe.StackInfo;
import com.asdflj.ae2thing.util.StorageProvider;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IFindItAdapter {
    public Class<? extends IGridHost> getCls();

    public boolean supportFluid();

    default public boolean isFluid(ItemStack item) {
        return this.supportFluid() && StackInfo.getFluid((ItemStack)item) != null;
    }

    default public List<StorageProvider> getStorageProviders(IGrid grid, IAEItemStack item) {
        boolean isFluid = this.isFluid(item.getItemStack());
        ArrayList<StorageProvider> list = new ArrayList<StorageProvider>();
        for (IGridNode node : grid.getMachines(this.getCls())) {
            List<StorageProvider> results = this.getStorageProver(grid, node, item, isFluid);
            if (results == null) continue;
            list.addAll(results);
        }
        return list;
    }

    public List<StorageProvider> getStorageProver(IGrid var1, IGridNode var2, IAEItemStack var3, boolean var4);

    default public boolean findStack(IMEInventory inv, boolean isFluid, IAEItemStack request) {
        if (inv == null) {
            return false;
        }
        boolean result = false;
        if (isFluid && inv.getChannel() == StorageChannel.FLUIDS) {
            FluidStack fs = Util.getFluidFromItem((ItemStack)request.getItemStack());
            result = inv.getAvailableItem((IAEStack)AEFluidStack.create((Object)fs)) != null;
        } else if (inv.getChannel() == StorageChannel.ITEMS) {
            result = inv.getAvailableItem((IAEStack)request) != null;
        }
        return result;
    }

    default public boolean findStack(ItemStack cell, boolean isFluid, IAEItemStack request) {
        IMEInventory inv = this.getInv(cell, isFluid ? StorageChannel.FLUIDS : StorageChannel.ITEMS);
        return this.findStack(inv, isFluid, request);
    }

    default public IMEInventory getInv(ItemStack is, StorageChannel channel) {
        if (channel == StorageChannel.ITEMS) {
            return AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        }
        if (channel == StorageChannel.FLUIDS) {
            return AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.FLUIDS);
        }
        return null;
    }
}

