/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container.BaseMonitor;

import appeng.api.AEApi;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.container.BaseMonitor.IProcessItemList;
import com.asdflj.ae2thing.network.SPacketMEFluidInvUpdate;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.asdflj.ae2thing.util.TheUtil;
import com.glodblock.github.common.item.ItemFluidDrop;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;

public class FluidMonitor
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IProcessItemList {
    private IMEMonitor<IAEFluidStack> fluidMonitor;
    private IMEMonitor<IAEItemStack> itemMonitor;
    private final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();
    private final Set<IAEItemStack> craftingAspects = new HashSet<IAEItemStack>();
    private final Set<IAEItemStack> craftingFluids = new HashSet<IAEItemStack>();
    private final List<ICrafting> crafters;
    private final List<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();

    public FluidMonitor(IStorageGrid storageGrid, List<ICrafting> crafters) {
        this.fluidMonitor = storageGrid.getFluidInventory();
        this.itemMonitor = storageGrid.getItemInventory();
        this.crafters = crafters;
    }

    public FluidMonitor(List<ICrafting> crafters) {
        this.crafters = crafters;
    }

    public boolean isValid(Object verificationToken) {
        return this.fluidMonitor != null;
    }

    public void addItemCraftingAspect(IAEItemStack is) {
        this.craftingAspects.add(is);
    }

    public void addItemCraftingFluid(IAEItemStack is) {
        this.craftingFluids.add(is);
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (ICrafting c : this.crafters) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = c;
            this.queueInventory(cr);
        }
    }

    @Override
    public void addListener() {
        this.fluidMonitor.addListener((IMEMonitorHandlerReceiver)this, null);
    }

    @Override
    public void removeListener() {
        if (this.fluidMonitor != null) {
            this.fluidMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public IMEMonitor<IAEFluidStack> getMonitor() {
        return this.fluidMonitor;
    }

    @Override
    public void processItemList() {
        IAEFluidStack fs;
        IAEFluidStack send;
        IItemList monitorCache;
        SPacketMEFluidInvUpdate piu = new SPacketMEFluidInvUpdate();
        if (!this.fluids.isEmpty()) {
            monitorCache = this.fluidMonitor.getStorageList();
            IItemList itemMonitorCache = this.itemMonitor.getStorageList();
            for (IAEFluidStack is : this.fluids) {
                send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    IAEItemStack item = ModAndClassUtil.THE && TheUtil.isGaseousEssentia(is) ? (IAEItemStack)itemMonitorCache.findPrecise((IAEStack)TheUtil.essentia2CraftingAspect(is)) : (IAEItemStack)itemMonitorCache.findPrecise((IAEStack)ItemFluidDrop.newAeStack((IAEFluidStack)send));
                    if (item != null) {
                        send = send.copy();
                        send.setCraftable(item.isCraftable());
                    }
                    this.toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                this.toSend.add(is);
            }
            piu.addAll(this.toSend);
            this.fluids.resetStatus();
        }
        if (!this.craftingAspects.isEmpty() && ModAndClassUtil.THE) {
            monitorCache = this.fluidMonitor.getStorageList();
            for (IAEItemStack is : this.craftingAspects) {
                fs = TheUtil.itemCraftingAspect2IAEFluidStack(is);
                send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)fs);
                if (send != null) {
                    send.setCraftable(is.isCraftable());
                    this.toSend.add(send);
                    continue;
                }
                fs.setStackSize(0L);
                fs.setCraftable(is.isCraftable());
                this.toSend.add(fs);
            }
            piu.addAll(this.toSend);
            this.craftingAspects.clear();
        }
        if (!this.craftingFluids.isEmpty()) {
            monitorCache = this.fluidMonitor.getStorageList();
            for (IAEItemStack is : this.craftingFluids) {
                is.setStackSize(1L);
                fs = ItemFluidDrop.getAeFluidStack((IAEItemStack)is);
                if (fs == null || monitorCache.findPrecise((IAEStack)fs) != null) continue;
                fs.setStackSize(0L);
                fs.setCraftable(is.isCraftable());
                this.toSend.add(fs);
            }
            piu.addAll(this.toSend);
            this.craftingFluids.clear();
        }
        if (!piu.isEmpty()) {
            for (ICrafting c : this.crafters) {
                if (!(c instanceof EntityPlayer)) continue;
                AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
            }
        }
        this.toSend.clear();
    }

    @Override
    public void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.fluidMonitor != null && this.itemMonitor != null) {
            IItemList monitorCache = this.fluidMonitor.getStorageList();
            IItemList itemMonitorCache = this.itemMonitor.getStorageList();
            ArrayList<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();
            for (IAEFluidStack is : monitorCache) {
                IAEFluidStack send = is.copy();
                IAEItemStack fluidDrop = (IAEItemStack)itemMonitorCache.findPrecise((IAEStack)ItemFluidDrop.newAeStack((IAEFluidStack)is));
                if (fluidDrop != null) {
                    send.setCraftable(fluidDrop.isCraftable());
                }
                toSend.add(send);
            }
            SPacketMEFluidInvUpdate piu = new SPacketMEFluidInvUpdate();
            piu.addAll(toSend);
            AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
        }
    }

    @Override
    public void removeCraftingFromCrafters(ICrafting c) {
        if (this.crafters.isEmpty() && this.fluidMonitor != null) {
            this.fluidMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void setMonitor(IMEMonitor<IAEFluidStack> fluidMonitor, IMEMonitor<IAEItemStack> itemMonitor) {
        this.fluidMonitor = fluidMonitor;
        this.itemMonitor = itemMonitor;
    }
}

