/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container.BaseMonitor;

import appeng.api.AEApi;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.container.BaseMonitor.FluidMonitor;
import com.asdflj.ae2thing.client.gui.container.BaseMonitor.IProcessItemList;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.asdflj.ae2thing.util.TheUtil;
import com.glodblock.github.common.item.ItemFluidDrop;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;

public class ItemMonitor
implements IMEMonitorHandlerReceiver<IAEItemStack>,
IProcessItemList {
    private IMEMonitor<IAEItemStack> itemMonitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final List<ICrafting> crafters;
    private FluidMonitor fluidMonitorObject = null;

    public ItemMonitor(List<ICrafting> crafters) {
        this.crafters = crafters;
    }

    public void setMonitor(IMEMonitor<IAEItemStack> itemMonitor) {
        this.itemMonitor = itemMonitor;
    }

    public void setFluidMonitorObject(FluidMonitor objectMonitor) {
        this.fluidMonitorObject = objectMonitor;
    }

    @Override
    public void addListener() {
        this.itemMonitor.addListener((IMEMonitorHandlerReceiver)this, null);
    }

    public boolean isValid(Object verificationToken) {
        return this.itemMonitor != null;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (ICrafting c : this.crafters) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = c;
            this.queueInventory(cr);
        }
    }

    private void fluidHandler(IAEItemStack send) {
        if (this.fluidMonitorObject != null && ModAndClassUtil.THE && TheUtil.isItemCraftingAspect(send)) {
            this.fluidMonitorObject.addItemCraftingAspect(send);
        } else if (this.fluidMonitorObject != null && send.getStackSize() == 0L && send.getItem() instanceof ItemFluidDrop) {
            this.fluidMonitorObject.addItemCraftingFluid(send);
        }
    }

    @Override
    public void processItemList() {
        if (!this.items.isEmpty()) {
            IItemList monitorCache = this.itemMonitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : this.items) {
                IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    this.fluidHandler(send.copy());
                    toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                toSend.add(is);
            }
            SPacketMEItemInvUpdate piu = new SPacketMEItemInvUpdate();
            piu.addAll(toSend);
            for (ICrafting c : this.crafters) {
                if (!(c instanceof EntityPlayer)) continue;
                AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
            }
            this.items.resetStatus();
        }
    }

    @Override
    public void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.itemMonitor != null) {
            IItemList monitorCache = this.itemMonitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : monitorCache) {
                this.fluidHandler(is.copy());
                toSend.add(is);
            }
            SPacketMEItemInvUpdate piu = new SPacketMEItemInvUpdate();
            piu.addAll(toSend);
            AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
        }
    }

    @Override
    public void removeCraftingFromCrafters(ICrafting c) {
        if (this.crafters.isEmpty() && this.itemMonitor != null) {
            this.itemMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    @Override
    public void removeListener() {
        if (this.itemMonitor != null) {
            this.itemMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public IMEMonitor<IAEItemStack> getMonitor() {
        return this.itemMonitor;
    }
}

