/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.storage.ITerminalHost;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.Platform;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.client.gui.container.widget.IWidgetPatternContainer;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BaseNetworkContainer
extends AEBaseContainer {
    protected final EntityPlayer player;
    protected WirelessTerminal terminal;
    protected int ticks;
    protected final double powerMultiplier = 0.5;
    @GuiSync(value=1)
    public boolean hasPower = false;

    public BaseNetworkContainer(InventoryPlayer ip, ITerminalHost host) {
        super(ip, (Object)host);
        this.player = ip.field_70458_d;
        if (Platform.isClient()) {
            return;
        }
        if (host instanceof WirelessTerminal) {
            this.terminal = (WirelessTerminal)host;
            this.setPowerSource(this.terminal);
        } else {
            BaseNetworkContainer baseNetworkContainer = this;
            if (baseNetworkContainer instanceof INetworkTerminal) {
                INetworkTerminal it = (INetworkTerminal)((Object)baseNetworkContainer);
                this.setPowerSource((IEnergySource)new ChannelPowerSrc(it.getGridNode(), (IEnergySource)it.getGrid().getCache(IEnergyGrid.class)));
            }
        }
    }

    private boolean transferPatternToSlot(EntityPlayer p, int idx, IPatternContainer container) {
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        ItemStack is = clickSlot.func_75211_c();
        if (is != null && !container.getPatternOutputSlot().func_75216_d() && is.field_77994_a == 1 && is.func_77973_b() instanceof ItemEncodedPattern) {
            ItemStack output = is.func_77946_l();
            container.getPatternOutputSlot().func_75215_d(output);
            p.field_71071_by.func_70299_a(clickSlot.getSlotIndex(), null);
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        boolean didSomething = false;
        BaseNetworkContainer baseNetworkContainer = this;
        if (baseNetworkContainer instanceof IPatternContainer) {
            IPatternContainer patternContainer = (IPatternContainer)((Object)baseNetworkContainer);
            didSomething = this.transferPatternToSlot(p, idx, patternContainer);
        } else {
            baseNetworkContainer = this;
            if (baseNetworkContainer instanceof IWidgetPatternContainer) {
                IWidgetPatternContainer w = (IWidgetPatternContainer)((Object)baseNetworkContainer);
                didSomething = this.transferPatternToSlot(p, idx, w.getContainer());
            }
        }
        if (didSomething) {
            return null;
        }
        return super.func_82846_b(p, idx);
    }

    public BaseNetworkContainer(InventoryPlayer ip, Object anchor) {
        super(ip, anchor);
        this.player = ip.field_70458_d;
    }

    protected void updatePowerStatus() {
        try {
            if (this.getNetworkNode() != null) {
                this.setPowered(this.getNetworkNode().isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private IGridNode getNetworkNode() {
        if (this.terminal == null) {
            return null;
        }
        return this.terminal.getGridNode();
    }

    public void func_75132_a(ICrafting crafting) {
        this.updatePowerStatus();
        super.func_75132_a(crafting);
    }

    protected void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    public void func_75142_b() {
        if (Platform.isServer() && this.terminal != null && this.hasPower) {
            this.ticks = this.terminal.getWirelessObject().extractPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG, this.ticks);
        }
        super.func_75142_b();
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }
}

