/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigurableObject;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.util.IConfigManagerHost;
import com.asdflj.ae2thing.client.gui.container.ContainerMonitor;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BasePatternContainerMonitor
extends ContainerMonitor
implements IConfigurableObject,
IConfigManagerHost,
IAEAppEngInventory,
IContainerCraftingPacket,
IPatternContainer {
    protected SlotRestrictedInput patternSlotIN;
    protected SlotRestrictedInput patternSlotOUT;
    protected SlotRestrictedInput patternRefiller;
    protected final IInventory crafting;
    protected final IInventory output;
    protected final IInventory patternInv;
    @GuiSync(value=99)
    public boolean canAccessViewCells;
    @GuiSync(value=95)
    public boolean combine = false;
    @GuiSync(value=92)
    public int activePage = 0;
    @GuiSync(value=100)
    public boolean craftingMode = true;
    protected final IPatternTerminal it;

    public BasePatternContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.it = (IPatternTerminal)monitorable;
        this.canAccessViewCells = false;
        this.crafting = this.it.getInventoryByName("crafting");
        this.output = this.it.getInventoryByName("output");
        this.patternInv = this.it.getInventoryByName("pattern");
    }

    @Override
    void setMonitor() {
        if (this.host instanceof INetworkTerminal) {
            IGridNode node = ((IGridHost)this.host).getGridNode(ForgeDirection.UNKNOWN);
            if (node != null) {
                this.networkNode = node;
                IGrid g = node.getGrid();
                if (g != null) {
                    this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                    this.monitor.setMonitor((IMEMonitor<IAEItemStack>)storageGrid.getItemInventory());
                    this.fluidMonitor.setMonitor((IMEMonitor<IAEFluidStack>)storageGrid.getFluidInventory(), (IMEMonitor<IAEItemStack>)storageGrid.getItemInventory());
                    this.monitor.setFluidMonitorObject(this.fluidMonitor);
                    if (this.monitor.getMonitor() == null) {
                        this.setValidContainer(false);
                    } else {
                        this.monitor.addListener();
                        this.fluidMonitor.addListener();
                        this.setCellInventory((IMEInventoryHandler)this.monitor.getMonitor());
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    @Override
    public Slot getPatternOutputSlot() {
        return this.patternSlotOUT;
    }
}

