/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.ContainerNull;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.asdflj.ae2thing.client.gui.container.ContainerMonitor;
import com.asdflj.ae2thing.client.gui.container.slot.SlotTicCraftingTerm;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.inventory.item.BackpackTerminalInventory;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.asdflj.ae2thing.util.TicUtil;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.common.item.ItemFluidDrop;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerCraftingTerminal
extends ContainerMonitor {
    private final SlotCraftingMatrix[] craftingSlots = new SlotCraftingMatrix[9];
    private final SlotTicCraftingTerm outputSlot;
    private final BackpackTerminalInventory it;

    public ContainerCraftingTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.it = (BackpackTerminalInventory)monitorable;
        this.lockSlot();
        IInventory crafting = this.it.getInventoryByName("crafting");
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotCraftingMatrix slotCraftingMatrix = new SlotCraftingMatrix((Container)this, crafting, x + y * 3, 37 + x * 18, -72 + y * 18);
                this.craftingSlots[x + y * 3] = slotCraftingMatrix;
                this.func_75146_a((Slot)slotCraftingMatrix);
            }
        }
        AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
        this.outputSlot = new SlotTicCraftingTerm(this.getPlayerInv().field_70458_d, this.getActionSource(), this.getPowerSource(), (IStorageMonitorable)monitorable, crafting, crafting, (IInventory)output, 131, -54, this);
        this.func_75146_a((Slot)this.outputSlot);
        this.bindPlayerInventory(ip, 0, 0);
        this.func_75130_a(crafting);
    }

    @Override
    void setMonitor() {
        this.monitor.setMonitor((IMEMonitor<IAEItemStack>)this.host.getItemInventory());
        this.monitor.addListener();
        this.setCellInventory((IMEInventoryHandler)this.monitor.getMonitor());
        this.setPowerSource((IEnergySource)this.host);
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.it.getInventoryByName(name);
    }

    private void lockSlot() {
        this.lockPlayerInventorySlot(this.it.getInventorySlot());
        for (int s : Util.getBackpackSlot(this.getInventoryPlayer().field_70458_d)) {
            this.lockPlayerInventorySlot(s);
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        int x;
        ContainerNull cn = new ContainerNull();
        InventoryCrafting ic = new InventoryCrafting((Container)cn, 3, 3);
        if (ModAndClassUtil.TIC && Config.backpackTerminalAddTicSupport) {
            for (x = 0; x < 9; ++x) {
                if (!TicUtil.isTool(this.craftingSlots[x].func_75211_c())) continue;
                ItemStack tool = this.craftingSlots[x].func_75211_c();
                ItemStack result = TicUtil.canModifyItem(tool, (ItemStack[])Arrays.stream(this.craftingSlots).filter(Objects::nonNull).map(AppEngSlot::func_75211_c).filter(stack -> stack != tool).toArray(ItemStack[]::new));
                this.outputSlot.func_75215_d(result);
                return;
            }
        }
        for (x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftingSlots[x].func_75211_c());
        }
        this.outputSlot.func_75215_d(CraftingManager.func_77594_a().func_82787_a(ic, this.getPlayerInv().field_70458_d.field_70170_p));
    }

    public IGridNode getNetworkNode() {
        return null;
    }

    public boolean useRealItems() {
        return true;
    }

    public ItemStack[] getViewCells() {
        return new ItemStack[0];
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    protected IAEFluidStack extractFluids(IAEFluidStack ifs, Actionable mode) {
        if (ifs.getStackSize() == 0L) {
            return ifs;
        }
        IAEItemStack extracted = (IAEItemStack)this.host.getItemInventory().extractItems((IAEStack)ItemFluidDrop.newAeStack((IAEFluidStack)ifs), mode, this.getActionSource());
        return ItemFluidDrop.getAeFluidStack((IAEItemStack)extracted);
    }

    @Override
    protected IAEFluidStack injectFluids(IAEFluidStack ifs, Actionable mode) {
        IAEItemStack injected = (IAEItemStack)this.host.getItemInventory().injectItems((IAEStack)ItemFluidDrop.newAeStack((IAEFluidStack)ifs), mode, this.getActionSource());
        return ItemFluidDrop.getAeFluidStack((IAEItemStack)injected);
    }
}

