/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.client.gui.container.BasePatternContainerMonitor;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.client.gui.container.slot.InfusionTerminalSlotPatternFake;
import com.asdflj.ae2thing.client.gui.container.widget.IWidgetPatternContainer;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.asdflj.ae2thing.common.parts.PartInfusionPatternTerminal;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ScanManager;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.items.ItemEnum;

public class ContainerInfusionPatternTerminal
extends BasePatternContainerMonitor
implements IOptionalSlotHost,
IWidgetPatternContainer {
    private static final int CRAFTING_GRID_PAGES = 2;
    private static final int CRAFTING_GRID_WIDTH = 4;
    private static final int CRAFTING_GRID_HEIGHT = 4;
    private static final int CRAFTING_GRID_SLOTS = 16;
    protected IGridNode networkNode;
    protected final SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    protected SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[1];
    protected InfusionTerminalSlotPatternFake[] outputSlots = new InfusionTerminalSlotPatternFake[32];
    private final PartInfusionPatternTerminal it;
    private ItemStack lastScanItem = null;

    public ContainerInfusionPatternTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.it = (PartInfusionPatternTerminal)monitorable;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, this.patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, this.patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.craftingSlots[0] = new SlotFakeCraftingMatrix(this.crafting, 0, 12, -56);
        this.func_75146_a((Slot)this.craftingSlots[0]);
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    InfusionTerminalSlotPatternFake infusionTerminalSlotPatternFake = new InfusionTerminalSlotPatternFake(this.output, this, x + y * 4 + page * 16, 58, -83, x, y, x + 4);
                    this.outputSlots[x + y * 4 + page * 16] = infusionTerminalSlotPatternFake;
                    this.func_75146_a((Slot)infusionTerminalSlotPatternFake);
                }
            }
        }
        if (this.isPatternTerminal()) {
            this.patternRefiller = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, ((IUpgradeableHost)monitorable).getInventoryByName("upgrades"), 0, 206, 101, this.getInventoryPlayer());
            this.func_75146_a((Slot)this.patternRefiller);
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
        this.bindPlayerInventory(ip, 0, 0);
    }

    private void offsetSlots() {
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    this.outputSlots[x + y * 4 + page * 16].setHidden(page != this.activePage);
                }
            }
        }
    }

    @Override
    public void refillBlankPatterns(Slot slot) {
        if (Platform.isServer()) {
            ItemStack blanks = slot.func_75211_c();
            int blanksToRefill = 64;
            if (blanks != null) {
                blanksToRefill -= blanks.field_77994_a;
            }
            if (blanksToRefill <= 0) {
                return;
            }
            AEItemStack request = AEItemStack.create((ItemStack)((ItemStack)AEApi.instance().definitions().materials().blankPattern().maybeStack(blanksToRefill).get()));
            IAEItemStack extracted = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)request, (BaseActionSource)this.getActionSource());
            if (extracted != null) {
                if (blanks != null) {
                    blanks.field_77994_a = (int)((long)blanks.field_77994_a + extracted.getStackSize());
                } else {
                    blanks = extracted.getItemStack();
                }
                slot.func_75215_d(blanks);
            }
        }
    }

    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT || s == this.craftingSlots[0] && Platform.isServer()) {
            if (s != null && s == this.patternSlotOUT && s.func_75211_c() != null) {
                ItemStack is = s.func_75211_c();
                NBTTagCompound data = Platform.openNbtData((ItemStack)is);
                this.setCrafting(data.func_74767_n("tc_crafting"));
            }
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.field_75151_b) {
                    if (!(g instanceof OptionalSlotFake) && !(g instanceof SlotFakeCraftingMatrix)) continue;
                    Slot sri = (Slot)g;
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                    if (!(g instanceof SlotFakeCraftingMatrix) || this.isCraftingMode()) continue;
                    this.scanSourceItem();
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }

    @Override
    public IPatternTerminal getPatternTerminal() {
        return this.it;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.combine = this.getPatternTerminal().shouldCombine();
            if (this.activePage != this.getPatternTerminal().getActivePage()) {
                this.activePage = this.getPatternTerminal().getActivePage();
                this.offsetSlots();
            }
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
            }
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            this.canAccessViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
        }
    }

    private void updateOrderOfOutputSlots() {
        for (InfusionTerminalSlotPatternFake s : this.outputSlots) {
            s.func_75215_d(null);
        }
        this.lastScanItem = null;
    }

    private void setCraftingMode(boolean craftingRecipe) {
        this.craftingMode = craftingRecipe;
    }

    public void scanSourceItem() {
        boolean playerScanned;
        ItemStack is = this.craftingSlots[0].func_75211_c();
        if (this.lastScanItem != null && Platform.isSameItemPrecise((ItemStack)is, (ItemStack)this.lastScanItem)) {
            return;
        }
        this.clearAspectSlots();
        if (is == null) {
            return;
        }
        this.lastScanItem = is;
        AspectList itemAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)is);
        itemAspects = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)is, (AspectList)itemAspects);
        Aspect[] sortedAspects = null;
        if (itemAspects == null || itemAspects.size() == 0) {
            return;
        }
        int hash = ScanManager.generateItemHash((Item)is.func_77973_b(), (int)is.func_77960_j());
        List list = (List)Thaumcraft.proxy.getScannedObjects().get(this.getPlayerInv().field_70458_d.func_70005_c_());
        int numOfAspects = this.outputSlots.length;
        boolean bl = playerScanned = list != null && (list.contains("@" + hash) || list.contains("#" + hash));
        if (playerScanned) {
            sortedAspects = itemAspects.getAspectsSortedAmount();
            numOfAspects = Math.min(numOfAspects, sortedAspects.length);
        }
        this.newItemPhial(sortedAspects, numOfAspects, itemAspects);
        if (this.canDouble((SlotFake[])this.outputSlots, is.field_77994_a)) {
            this.doubleStacksInternal((SlotFake[])this.outputSlots, is.field_77994_a);
        }
    }

    private void newItemPhial(Aspect[] sortedAspects, int numOfAspects, AspectList itemAspects) {
        for (int i = 0; i < numOfAspects; ++i) {
            Aspect aspect;
            if (sortedAspects == null || (aspect = sortedAspects[i]) == null) continue;
            this.outputSlots[i].func_75215_d(ItemPhial.newStack(aspect, itemAspects.getAmount(aspect)));
        }
    }

    private void newCraftingAspect(Aspect[] sortedAspects, int numOfAspects, AspectList itemAspects) {
        for (int i = 0; i < numOfAspects; ++i) {
            ItemStack aspectItem = ItemEnum.CRAFTING_ASPECT.getStack();
            if (sortedAspects != null) {
                Aspect aspect = sortedAspects[i];
                ItemCraftingAspect.setAspect((ItemStack)aspectItem, (Aspect)aspect);
                aspectItem.field_77994_a = itemAspects.getAmount(aspect);
            }
            this.outputSlots[i].func_75215_d(aspectItem);
        }
    }

    private void clearAspectSlots() {
        for (InfusionTerminalSlotPatternFake slot : this.outputSlots) {
            slot.func_75215_d(null);
        }
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    public boolean useRealItems() {
        return false;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        if (field.equals("activePage")) {
            this.offsetSlots();
        }
        super.onUpdate(field, oldValue, newValue);
    }

    @Override
    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void processItemList() {
        super.processItemList();
        this.fluidMonitor.processItemList();
    }

    @Override
    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        this.fluidMonitor.removeCraftingFromCrafters(c);
    }

    @Override
    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.fluidMonitor.queueInventory(c);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.fluidMonitor.getMonitor() != null) {
            this.fluidMonitor.removeListener();
        }
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    protected ItemStack[] getInputs() {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (SlotFakeCraftingMatrix craftingSlot : this.craftingSlots) {
            input.add(craftingSlot.func_75211_c());
        }
        if (input.stream().anyMatch(Objects::nonNull)) {
            return input.toArray(new ItemStack[0]);
        }
        return null;
    }

    protected ItemStack[] getOutputs() {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (InfusionTerminalSlotPatternFake outputSlot : this.outputSlots) {
            output.add(outputSlot.func_75211_c());
        }
        if (output.stream().anyMatch(Objects::nonNull)) {
            return output.toArray(new ItemStack[0]);
        }
        return null;
    }

    protected boolean notPattern(ItemStack output) {
        if (output == null) {
            return true;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return !(isPattern |= definitions.materials().blankPattern().isSameAs(output));
    }

    protected NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            Util.writeItemStackToNBT((ItemStack)i, (NBTTagCompound)c);
        }
        return c;
    }

    @Override
    public void encode() {
        ItemStack encodedPatternStack;
        Iterator iterator;
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && this.notPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (this.notPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        } else if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)(this.isCraftingMode() ? tagOut : tagIn));
        encodedValue.func_74782_a("out", (NBTBase)(this.isCraftingMode() ? tagIn : tagOut));
        encodedValue.func_74757_a("crafting", false);
        encodedValue.func_74757_a("tc_crafting", this.isCraftingMode());
        output.func_77982_d(encodedValue);
        this.stampAuthor(output);
        this.patternSlotOUT.func_75215_d(output);
    }

    protected ItemStack stampAuthor(ItemStack patternStack) {
        if (patternStack.field_77990_d == null) {
            patternStack.field_77990_d = new NBTTagCompound();
        }
        patternStack.field_77990_d.func_74778_a("author", this.getPlayerInv().field_70458_d.func_70005_c_());
        return patternStack;
    }

    @Override
    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.func_75215_d(null);
        }
        for (InfusionTerminalSlotPatternFake infusionTerminalSlotPatternFake : this.outputSlots) {
            infusionTerminalSlotPatternFake.func_75215_d(null);
        }
        this.lastScanItem = null;
        this.func_75142_b();
    }

    @Override
    public void doubleStacks(int val) {
        if (this.isCraftingMode()) {
            return;
        }
        boolean isShift = (val & 1) != 0;
        boolean backwards = (val & 2) != 0;
        int multi = isShift ? 8 : 2;
        int n = multi = backwards ? Math.negateExact(multi) : multi;
        if (this.canDouble((SlotFake[])this.craftingSlots, multi) && this.canDouble((SlotFake[])this.outputSlots, multi)) {
            this.doubleStacksInternal((SlotFake[])this.craftingSlots, multi);
            this.doubleStacksInternal((SlotFake[])this.outputSlots, multi);
        }
        this.func_75142_b();
    }

    @Override
    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.dropItem(output);
            }
            this.patternSlotOUT.func_75215_d(null);
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
    }

    @Override
    public void encodeAllItemAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (this.patternSlotIN.func_75211_c() != null) {
                output.field_77994_a += this.patternSlotIN.func_75211_c().field_77994_a;
            }
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.dropItem(output);
            }
            this.patternSlotOUT.func_75215_d(null);
            this.patternSlotIN.func_75215_d(null);
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
    }

    public boolean isSlotEnabled(int idx) {
        return true;
    }

    @Override
    public boolean isPatternTerminal() {
        return true;
    }

    @Override
    public boolean hasRefillerUpgrade() {
        return this.getPatternTerminal().hasRefillerUpgrade();
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    public void setCrafting(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.it.setCraftingRecipe(craftingMode);
    }

    @Override
    public IPatternContainer getContainer() {
        return this;
    }
}

