/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotRestrictedInput;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import codechicken.nei.recipe.StackInfo;
import com.asdflj.ae2thing.client.gui.container.IPatternValueContainer;
import com.asdflj.ae2thing.client.gui.container.slot.SlotEncodedPatternInput;
import com.asdflj.ae2thing.client.gui.container.slot.SlotReplaceFake;
import com.asdflj.ae2thing.inventory.item.PatternModifierInventory;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class ContainerPatternModifier
extends AEBaseContainer
implements IPatternValueContainer {
    private final PatternModifierInventory it;
    private final SlotRestrictedInput[] pattern = new SlotRestrictedInput[36];
    private final SlotFake replaceSource;
    private final SlotFake replaceTarget;
    private static final ItemStack encodePattern = (ItemStack)AEApi.instance().definitions().items().encodedPattern().maybeStack(1).get();
    private final IInventory patterns;
    private final IInventory replace;

    public ContainerPatternModifier(InventoryPlayer ip, ITerminalHost host) {
        super(ip, (Object)host);
        this.it = (PatternModifierInventory)host;
        this.patterns = this.it.getInventoryByName("pattern");
        this.replace = this.it.getInventoryByName("replace");
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            int x = i % 9 * 18 + 8;
            int y = i / 9 * 18 + 19;
            this.pattern[i] = new SlotEncodedPatternInput(this.patterns, i, x, y, ip);
            this.func_75146_a((Slot)this.pattern[i]);
        }
        this.replaceSource = new SlotReplaceFake(this.replace, 0, 8, 93);
        this.func_75146_a((Slot)this.replaceSource);
        this.replaceTarget = new SlotReplaceFake(this.replace, 1, 50, 93);
        this.func_75146_a((Slot)this.replaceTarget);
        this.lockPlayerInventorySlot(this.it.getInventorySlot());
        this.bindPlayerInventory(ip, 0, 125);
    }

    public ItemStack getSource() {
        return this.replaceSource.func_75211_c();
    }

    public void clearPattern() {
        int blankPattern = 0;
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            ItemStack itemStack = this.patterns.func_70301_a(i);
            if (itemStack == null) continue;
            ++blankPattern;
            this.patterns.func_70299_a(i, null);
        }
        if (blankPattern <= 0) {
            return;
        }
        ItemStack pattern = (ItemStack)AEApi.instance().definitions().materials().blankPattern().maybeStack(blankPattern).get();
        if (!this.getPlayerInv().func_70441_a(pattern)) {
            this.dropItem(pattern);
        }
    }

    public Slot getTargetSlot() {
        return this.replaceTarget;
    }

    public Slot getSourceSlot() {
        return this.replaceSource;
    }

    protected void dropItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return;
        }
        ItemStack itemStack = is.func_77946_l();
        int i = itemStack.func_77976_d();
        while (itemStack.field_77994_a > 0) {
            if (i > itemStack.field_77994_a) {
                if (this.getPlayerInv().func_70441_a(itemStack.func_77946_l())) break;
                this.getPlayerInv().field_70458_d.func_70099_a(itemStack.func_77946_l(), 0.0f);
                break;
            }
            itemStack.field_77994_a -= i;
            ItemStack item = itemStack.func_77946_l();
            item.field_77994_a = i;
            if (this.getPlayerInv().func_70441_a(item)) continue;
            this.getPlayerInv().field_70458_d.func_70099_a(item, 0.0f);
        }
    }

    protected boolean checkHasFluidPattern(IAEItemStack[] in, IAEItemStack[] out) {
        return Arrays.stream(in).filter(Objects::nonNull).anyMatch(x -> ItemFluidDrop.isFluidStack((ItemStack)x.getItemStack())) || Arrays.stream(out).filter(Objects::nonNull).anyMatch(x -> ItemFluidDrop.isFluidStack((ItemStack)x.getItemStack()));
    }

    public void replacePattern() {
        if (!this.replaceSource.func_75216_d()) {
            return;
        }
        ItemStack source = this.replaceSource.func_75211_c();
        ItemStack target = this.replaceTarget.func_75211_c();
        try {
            for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
                ICraftingPatternDetails details;
                Item item;
                ItemStack stack = this.patterns.func_70301_a(i);
                if (stack == null || !((item = stack.func_77973_b()) instanceof ICraftingPatternItem)) continue;
                ICraftingPatternItem cpi = (ICraftingPatternItem)item;
                Item item2 = stack.func_77973_b();
                if (item2 instanceof ItemFluidEncodedPattern) {
                    ItemFluidEncodedPattern fluidEncodedPattern = (ItemFluidEncodedPattern)item2;
                    details = fluidEncodedPattern.getPatternForItem(stack, this.getInventoryPlayer().field_70458_d.field_70170_p);
                } else {
                    details = cpi.getPatternForItem(stack, this.getInventoryPlayer().field_70458_d.field_70170_p);
                }
                IAEItemStack[] in = this.replacePattern(details.getInputs(), source, target, details);
                IAEItemStack[] out = this.replacePattern(details.getOutputs(), source, target, details);
                if (this.checkHasFluidPattern(in, out)) {
                    this.encodeFluidPattern(details, in, out, i, stack);
                    continue;
                }
                this.encode(details, in, out, i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void encodeFluidPattern(ICraftingPatternDetails details, IAEItemStack[] in, IAEItemStack[] out, int slot, ItemStack stack) {
        FluidPatternDetails fluidDetails;
        if (details instanceof FluidPatternDetails) {
            fluidDetails = (FluidPatternDetails)details;
        } else {
            ItemStack cp = ItemAndBlockHolder.PATTERN.stack();
            cp.func_77982_d(stack.func_77978_p());
            fluidDetails = (FluidPatternDetails)ItemAndBlockHolder.PATTERN.getPatternForItem(cp, this.getInventoryPlayer().field_70458_d.field_70170_p);
        }
        fluidDetails.setInputs(in);
        fluidDetails.setOutputs(out);
        ItemStack pattern = fluidDetails.writeToStack();
        this.patterns.func_70299_a(slot, this.stampAuthor(pattern));
    }

    protected ItemStack stampAuthor(ItemStack patternStack) {
        if (patternStack.field_77990_d == null) {
            patternStack.field_77990_d = new NBTTagCompound();
        }
        patternStack.field_77990_d.func_74778_a("author", this.getPlayerInv().field_70458_d.func_70005_c_());
        return patternStack;
    }

    private void encode(ICraftingPatternDetails cpi, IAEItemStack[] in, IAEItemStack[] out, int slot) {
        NBTTagList inList = this.list2tagList(in);
        NBTTagList outList = this.list2tagList(out);
        NBTTagCompound tag = (NBTTagCompound)Platform.openNbtData((ItemStack)cpi.getPattern()).func_74737_b();
        tag.func_74782_a("in", (NBTBase)inList);
        tag.func_74782_a("out", (NBTBase)outList);
        ItemStack cp = encodePattern.func_77946_l();
        cp.func_77982_d(tag);
        this.patterns.func_70299_a(slot, cp);
    }

    private NBTTagList list2tagList(IAEItemStack[] list) {
        NBTTagList nbtTagList = new NBTTagList();
        for (IAEItemStack is : list) {
            if (is == null) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            nbtTagList.func_74742_a(this.createItemTag(is.getItemStack()));
        }
        return nbtTagList;
    }

    private boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        if (Util.isFluidPacket((ItemStack)stack1) || Util.isFluidPacket((ItemStack)stack2)) {
            FluidStack fs1 = StackInfo.getFluid((ItemStack)stack1);
            FluidStack fs2 = StackInfo.getFluid((ItemStack)stack2);
            if (fs1 != null && fs2 != null) {
                return fs1.getFluid().equals(fs2.getFluid());
            }
            return false;
        }
        return Platform.isSameItemPrecise((ItemStack)stack1, (ItemStack)stack2);
    }

    private IAEItemStack[] replacePattern(IAEItemStack[] list, ItemStack source, ItemStack target, ICraftingPatternDetails details) {
        IAEItemStack[] results = new IAEItemStack[list.length];
        for (int i = 0; i < list.length; ++i) {
            IAEItemStack item = list[i];
            if (item == null) {
                results[i] = null;
                continue;
            }
            if (this.isSameItem(item.getItemStack(), source)) {
                if (details.isCraftable() && target != null && details.isValidItemForSlot(i, target, this.getPlayerInv().field_70458_d.field_70170_p) || !details.isCraftable() && target != null) {
                    if (Util.isFluidPacket((ItemStack)target)) {
                        IAEItemStack fluidDrop = ItemFluidDrop.newAeStack((FluidStack)ItemFluidPacket.getFluidStack((ItemStack)target));
                        if (fluidDrop != null) {
                            fluidDrop.setStackSize(item.getStackSize());
                        }
                        results[i] = fluidDrop;
                        continue;
                    }
                    AEItemStack t = AEItemStack.create((ItemStack)target);
                    t.setStackSize(item.getStackSize());
                    results[i] = t;
                    continue;
                }
                if (target == null && !details.isCraftable()) {
                    results[i] = null;
                    continue;
                }
                results[i] = item;
                continue;
            }
            results[i] = item;
        }
        return results;
    }

    protected NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            Util.writeItemStackToNBT((ItemStack)i, (NBTTagCompound)c);
        }
        return c;
    }

    public boolean isValidContainer() {
        return true;
    }
}

