/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container.widget;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.client.gui.container.ContainerWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.client.gui.container.slot.SlotPattern;
import com.asdflj.ae2thing.client.gui.container.slot.SlotPatternFake;
import com.asdflj.ae2thing.client.gui.container.widget.IWidgetSlot;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class PatternContainer
implements IPatternContainer,
IOptionalSlotHost,
IWidgetSlot {
    protected final IInventory crafting;
    protected final IInventory craftingEx;
    protected final IInventory outputEx;
    protected final IInventory patternInv;
    protected final SlotPattern patternSlotIN;
    protected final SlotPattern patternSlotOUT;
    protected SlotPattern patternRefiller;
    protected SlotPatternFake[] craftingExSlots;
    protected SlotPatternFake[] outputExSlots;
    protected SlotFake[] craftingSlots;
    protected SlotPatternTerm craftSlot;
    private static final int CRAFTING_GRID_PAGES = 2;
    private static final int CRAFTING_GRID_WIDTH = 4;
    private static final int CRAFTING_GRID_HEIGHT = 4;
    private static final int CRAFTING_GRID_SLOTS = 16;
    protected final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    private final IPatternTerminal it;
    private final ContainerWirelessDualInterfaceTerminal container;
    private final List<Slot> slots = new ArrayList<Slot>();
    private final ITerminalHost host;
    private final ItemStack[] recipeCache = new ItemStack[10];

    public PatternContainer(InventoryPlayer ip, ITerminalHost host, ContainerWirelessDualInterfaceTerminal container) {
        int x;
        this.container = container;
        this.it = (IPatternTerminal)host;
        this.host = host;
        this.crafting = this.it.getInventoryByName("crafting");
        this.craftingEx = this.it.getInventoryByName("crafting_ex");
        this.outputEx = this.it.getInventoryByName("output_ex");
        this.patternInv = this.it.getInventoryByName("pattern");
        this.craftingSlots = new SlotFakeCraftingMatrix[9];
        this.craftingExSlots = new SlotPatternFake[32];
        this.outputExSlots = new SlotPatternFake[32];
        this.patternSlotIN = new SlotPattern(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, this.patternInv, 0, 220, 31, ip);
        this.addMESlotToContainer((AppEngSlot)this.patternSlotIN);
        this.slots.add((Slot)this.patternSlotIN);
        this.patternSlotOUT = new SlotPattern(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, this.patternInv, 1, 220, 74, ip);
        this.addMESlotToContainer((AppEngSlot)this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.slots.add((Slot)this.patternSlotOUT);
        if (this.isPatternTerminal()) {
            this.patternRefiller = new SlotPattern(SlotRestrictedInput.PlacableItemType.UPGRADES, this.it.getInventoryByName("upgrades"), 0, 217, 110, this.container.getInventoryPlayer());
            this.addMESlotToContainer((AppEngSlot)this.patternRefiller);
            this.slots.add((Slot)this.patternRefiller);
        }
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x2 = 0; x2 < 4; ++x2) {
                    SlotPatternFake slotPatternFake = new SlotPatternFake(this.craftingEx, this, x2 + y * 4 + page * 16, 224, -59, x2, y, x2 + 4);
                    this.craftingExSlots[x2 + y * 4 + page * 16] = slotPatternFake;
                    this.addMESlotToContainer((AppEngSlot)slotPatternFake);
                    this.slots.add((Slot)this.craftingExSlots[x2 + y * 4 + page * 16]);
                }
            }
            for (x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    SlotPatternFake slotPatternFake = new SlotPatternFake(this.outputEx, this, x * 4 + y + page * 16, 321, -59, -x, y, x);
                    this.outputExSlots[x * 4 + y + page * 16] = slotPatternFake;
                    this.addMESlotToContainer((AppEngSlot)slotPatternFake);
                    this.slots.add((Slot)this.outputExSlots[x * 4 + y + page * 16]);
                }
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.field_70458_d, this.container.getActionSource(), this.container.getPowerSource(), (IStorageMonitorable)this.host, this.crafting, this.patternInv, (IInventory)this.cOut, 316, -32, (IOptionalSlotHost)this, 0, (IContainerCraftingPacket)this.container);
        this.addMESlotToContainer((AppEngSlot)this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 224 + x * 18, -50 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.addMESlotToContainer((AppEngSlot)slotFakeCraftingMatrix);
            }
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
    }

    public void detectAndSendChanges() {
        if (Platform.isServer()) {
            this.container.substitute = this.it.isSubstitution();
            this.container.combine = this.it.shouldCombine();
            this.container.beSubstitute = this.it.canBeSubstitute();
            this.container.prioritize = this.it.isPrioritize();
            this.container.craftingMode = this.it.isCraftingRecipe();
            if (this.container.inverted != this.it.isInverted() || this.container.activePage != this.it.getActivePage()) {
                this.container.inverted = this.it.isInverted();
                this.container.activePage = this.it.getActivePage();
                this.updateOrderOfOutputSlots();
            }
            if (this.container.isCraftingMode() != this.it.isCraftingRecipe()) {
                this.container.setCraftingMode(this.it.isCraftingRecipe());
                this.updateOrderOfOutputSlots();
            }
        }
    }

    private void updateOrderOfOutputSlots() {
        if (this.container.isCraftingMode()) {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            Arrays.stream(this.craftingSlots).forEach(s -> {
                s.field_75223_e = s.getX();
            });
            Arrays.stream(this.outputExSlots).forEach(s -> s.setHidden(true));
            Arrays.stream(this.craftingExSlots).forEach(s -> s.setHidden(true));
        } else {
            this.craftSlot.field_75223_e = -9000;
            Arrays.stream(this.craftingSlots).forEach(s -> {
                s.field_75223_e = -9000;
            });
            Arrays.stream(this.outputExSlots).forEach(s -> s.setHidden(false));
            Arrays.stream(this.craftingExSlots).forEach(s -> s.setHidden(false));
            this.offsetSlots();
        }
    }

    private void offsetSlots() {
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    this.craftingExSlots[x + y * 4 + page * 16].setHidden(page != this.container.activePage || x > 0 && this.container.inverted);
                    this.outputExSlots[x * 4 + y + page * 16].setHidden(page != this.container.activePage || x > 0 && !this.container.inverted);
                }
            }
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("inverted") || field.equals("activePage")) {
            this.updateOrderOfOutputSlots();
        }
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    public ItemStack getAndUpdateOutput() {
        if (!this.container.isCraftingMode()) {
            return null;
        }
        boolean sameRecipe = true;
        for (int i = 0; i < this.crafting.func_70302_i_(); ++i) {
            if (this.recipeCache[i] == null && this.crafting.func_70301_a(i) == null || Platform.isSameItemPrecise((ItemStack)this.recipeCache[i], (ItemStack)this.crafting.func_70301_a(i))) continue;
            sameRecipe = false;
            break;
        }
        if (!sameRecipe) {
            InventoryCrafting ic = new InventoryCrafting((Container)this.container, 3, 3);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                ic.func_70299_a(x, this.crafting.func_70301_a(x));
            }
            ItemStack is = CraftingManager.func_77594_a().func_82787_a(ic, this.container.getPlayerInv().field_70458_d.field_70170_p);
            this.cOut.func_70299_a(0, is);
            for (int i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.recipeCache[i] = this.crafting.func_70301_a(i);
            }
            this.recipeCache[9] = is;
            return is;
        }
        if (this.recipeCache[9] != null) {
            return this.recipeCache[9];
        }
        return null;
    }

    protected void addMESlotToContainer(AppEngSlot newSlot) {
        this.container.addMESlotToContainer(newSlot);
    }

    @Override
    public IPatternTerminal getPatternTerminal() {
        return this.it;
    }

    @Override
    public void clear() {
        for (SlotPatternFake slotPatternFake : this.craftingExSlots) {
            slotPatternFake.func_75215_d(null);
        }
        for (SlotPatternFake slotPatternFake : this.outputExSlots) {
            slotPatternFake.func_75215_d(null);
        }
        for (SlotPatternFake slotPatternFake : this.craftingSlots) {
            slotPatternFake.func_75215_d(null);
        }
        this.getAndUpdateOutput();
        this.detectAndSendChanges();
    }

    @Override
    public void doubleStacks(int val) {
        if (this.container.isCraftingMode()) {
            return;
        }
        boolean isShift = (val & 1) != 0;
        boolean backwards = (val & 2) != 0;
        int multi = isShift ? 8 : 2;
        int n = multi = backwards ? Math.negateExact(multi) : multi;
        if (this.canDouble((SlotFake[])this.craftingExSlots, multi) && this.canDouble((SlotFake[])this.outputExSlots, multi)) {
            this.doubleStacksInternal((SlotFake[])this.craftingExSlots, multi);
            this.doubleStacksInternal((SlotFake[])this.outputExSlots, multi);
        }
        this.detectAndSendChanges();
    }

    @Override
    public Slot getPatternOutputSlot() {
        return this.patternSlotOUT;
    }

    @Override
    public boolean isPatternTerminal() {
        return true;
    }

    @Override
    public boolean hasRefillerUpgrade() {
        return this.getPatternTerminal().hasRefillerUpgrade();
    }

    @Override
    public void refillBlankPatterns(Slot slot) {
        IPatternTerminal iPatternTerminal;
        if (Platform.isServer() && (iPatternTerminal = this.it) instanceof WirelessTerminal) {
            WirelessTerminal wt = (WirelessTerminal)((Object)iPatternTerminal);
            ItemStack blanks = slot.func_75211_c();
            int blanksToRefill = 64;
            if (blanks != null) {
                blanksToRefill -= blanks.field_77994_a;
            }
            if (blanksToRefill <= 0) {
                return;
            }
            AEItemStack request = AEItemStack.create((ItemStack)((ItemStack)AEApi.instance().definitions().materials().blankPattern().maybeStack(blanksToRefill).get()));
            IAEItemStack extracted = (IAEItemStack)Platform.poweredExtraction((IEnergySource)wt, wt.getItemInventory(), (IAEStack)request, (BaseActionSource)wt.getActionSource());
            if (extracted != null) {
                if (blanks != null) {
                    blanks.field_77994_a = (int)((long)blanks.field_77994_a + extracted.getStackSize());
                } else {
                    blanks = extracted.getItemStack();
                }
                slot.func_75215_d(blanks);
            }
        }
    }

    protected static boolean containsFluid(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long fluid = enabledSlots.stream().filter(s -> Util.isFluidPacket((ItemStack)s.func_75211_c())).count();
        return fluid > 0L;
    }

    protected static boolean nonNullSlot(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long object = enabledSlots.stream().filter(s -> s.func_75211_c() != null).count();
        return object > 0L;
    }

    protected ItemStack[] getInputs() {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        if (this.container.isCraftingMode()) {
            for (SlotFake craftingSlot : this.craftingSlots) {
                input.add(craftingSlot.func_75211_c());
            }
            if (input.stream().anyMatch(Objects::nonNull)) {
                return input.toArray(new ItemStack[0]);
            }
        } else {
            for (SlotPatternFake craftingSlot : this.craftingExSlots) {
                input.add(craftingSlot.func_75211_c());
            }
            if (input.stream().anyMatch(Objects::nonNull)) {
                return input.toArray(new ItemStack[0]);
            }
        }
        return null;
    }

    protected ItemStack[] getOutputs() {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        if (this.container.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (out != null && out.field_77994_a > 0) {
                return new ItemStack[]{out};
            }
        } else {
            for (SlotPatternFake outputSlot : this.outputExSlots) {
                output.add(outputSlot.func_75211_c());
            }
            if (output.stream().anyMatch(Objects::nonNull)) {
                return output.toArray(new ItemStack[0]);
            }
        }
        return null;
    }

    protected boolean notPattern(ItemStack output) {
        if (output == null) {
            return true;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return !(isPattern |= definitions.materials().blankPattern().isSameAs(output));
    }

    protected boolean checkHasFluidPattern() {
        if (this.container.craftingMode) {
            return false;
        }
        boolean hasFluid = PatternContainer.containsFluid((SlotFake[])this.craftingExSlots);
        boolean search = PatternContainer.nonNullSlot((SlotFake[])this.craftingExSlots);
        if (!search) {
            return false;
        }
        search = PatternContainer.nonNullSlot((SlotFake[])this.outputExSlots);
        return (hasFluid |= PatternContainer.containsFluid((SlotFake[])this.outputExSlots)) && search;
    }

    public void encodeItemPattern() {
        ItemStack encodedPatternStack;
        Iterator iterator;
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && this.notPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (this.notPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        } else if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.container.craftingMode);
        encodedValue.func_74757_a("substitute", this.container.substitute);
        encodedValue.func_74757_a("beSubstitute", this.container.beSubstitute);
        encodedValue.func_74757_a("prioritize", this.container.prioritize);
        output.func_77982_d(encodedValue);
        this.stampAuthor(output);
        this.patternSlotOUT.func_75215_d(output);
    }

    protected ItemStack stampAuthor(ItemStack patternStack) {
        if (patternStack.field_77990_d == null) {
            patternStack.field_77990_d = new NBTTagCompound();
        }
        patternStack.field_77990_d.func_74778_a("author", this.container.getPlayerInv().field_70458_d.func_70005_c_());
        return patternStack;
    }

    protected NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            Util.writeItemStackToNBT((ItemStack)i, (NBTTagCompound)c);
        }
        return c;
    }

    @Override
    public void encode() {
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
        if (!this.checkHasFluidPattern()) {
            this.encodeItemPattern();
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack == null) {
            stack = this.patternSlotIN.func_75211_c();
            if (this.notPattern(stack)) {
                return;
            }
            if (stack.field_77994_a == 1) {
                this.patternSlotIN.func_75215_d(null);
            } else {
                --stack.field_77994_a;
            }
            this.encodeFluidPattern();
        } else if (!this.notPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    protected static IAEItemStack[] collectInventory(Slot[] slots) {
        IAEItemStack[] stacks = new IAEItemStack[slots.length];
        for (int i = 0; i < stacks.length; ++i) {
            IAEItemStack dropStack;
            ItemStack stack = slots[i].func_75211_c();
            if (stack != null && stack.func_77973_b() instanceof ItemFluidPacket && (dropStack = ItemFluidDrop.newAeStack((FluidStack)ItemFluidPacket.getFluidStack((ItemStack)stack))) != null) {
                stacks[i] = dropStack;
                continue;
            }
            AEItemStack aeStack = AEItemStack.create((ItemStack)stack);
            stacks[i] = aeStack;
        }
        return stacks;
    }

    protected void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)ItemAndBlockHolder.PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(PatternContainer.collectInventory((Slot[])this.craftingExSlots));
        pattern.setOutputs(PatternContainer.collectInventory((Slot[])this.outputExSlots));
        pattern.setCanBeSubstitute(this.container.beSubstitute ? 1 : 0);
        this.patternSlotOUT.func_75215_d(this.stampAuthor(pattern.writeToStack()));
    }

    @Override
    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (!this.container.getPlayerInv().func_70441_a(output)) {
                this.container.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
    }

    @Override
    public void encodeAllItemAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (this.patternSlotIN.func_75211_c() != null) {
                output.field_77994_a += this.patternSlotIN.func_75211_c().field_77994_a;
            }
            if (!this.container.getPlayerInv().func_70441_a(output)) {
                this.container.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
            this.patternSlotIN.func_75215_d(null);
        }
        if (this.hasRefillerUpgrade()) {
            this.refillBlankPatterns((Slot)this.patternSlotIN);
        }
    }

    public boolean isSlotEnabled(int idx) {
        if (idx < 4) {
            return this.container.inverted || idx == 0;
        }
        return !this.container.inverted || idx == 4;
    }

    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            this.container.setInverted(this.it.isInverted());
            Iterator<ICrafting> iterator = this.container.getCrafters().iterator();
            while (iterator.hasNext()) {
                ICrafting crafter;
                ICrafting icrafting = crafter = iterator.next();
                for (Object g : this.container.field_75151_b) {
                    if (!(g instanceof SlotFake)) continue;
                    SlotFake sri = (SlotFake)g;
                    icrafting.func_71111_a((Container)this.container, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.detectAndSendChanges();
        }
    }

    @Override
    public List<Slot> getSlot() {
        return this.slots;
    }
}

