/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.widget;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.util.IConfigManager;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotPatternTerm;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import codechicken.nei.LayoutManager;
import codechicken.nei.util.TextHistory;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.BaseMEGui;
import com.asdflj.ae2thing.client.gui.IGuiMonitorTerminal;
import com.asdflj.ae2thing.client.gui.IWidgetGui;
import com.asdflj.ae2thing.client.gui.container.ContainerWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.client.gui.widget.IAEBasePanel;
import com.asdflj.ae2thing.client.gui.widget.IDraggable;
import com.asdflj.ae2thing.client.gui.widget.THGuiTextField;
import com.asdflj.ae2thing.client.me.AdvItemRepo;
import com.asdflj.ae2thing.network.CPacketInventoryAction;
import com.asdflj.ae2thing.util.Ae2ReflectClient;
import com.asdflj.ae2thing.util.GTUtil;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ItemPanel
implements IAEBasePanel,
IGuiMonitorTerminal,
IConfigManagerHost,
IDropToFillTextField {
    private final BaseMEGui parent;
    private final IWidgetGui gui;
    private final ContainerWirelessDualInterfaceTerminal container;
    private final int perRow;
    private final int rows;
    protected THGuiTextField searchField;
    private final AEBaseContainer inventorySlots;
    private final AdvItemRepo repo;
    private final IConfigManager configSrc;
    private final GuiScrollbar scrollbar;
    private int absX;
    private int absY;
    private final int w;
    private final int h;
    private int offsetY;
    private final boolean showViewBtn = true;
    private GuiImgButton SortByBox;
    private GuiImgButton ViewBox;
    private GuiImgButton typeFilter;
    private GuiImgButton SortDirBox;
    private GuiImgButton searchBoxSettings;
    private static String memoryText = "";
    private final TextHistory history;

    public ItemPanel(IWidgetGui gui, ContainerWirelessDualInterfaceTerminal container, IConfigManager configSrc, ISortSource source) {
        this.gui = gui;
        this.container = container;
        this.parent = gui.getGui();
        this.inventorySlots = this.container;
        this.configSrc = configSrc;
        this.scrollbar = new GuiScrollbar();
        this.repo = new AdvItemRepo((IScrollSource)this.scrollbar, source);
        this.repo.setCache(this);
        this.repo.setPowered(true);
        this.w = 101;
        this.h = 96;
        this.repo.setRowSize(4);
        this.rows = 4;
        this.perRow = 4;
        this.history = Ae2ReflectClient.getHistory(LayoutManager.searchField);
    }

    public void saveSearchString() {
        if (ModAndClassUtil.NEI && this.isNEISearch() && !this.searchField.func_146179_b().isEmpty()) {
            this.history.add(this.searchField.func_146179_b());
        }
    }

    protected boolean isNEISearch() {
        Enum s = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        return s == SearchBoxMode.NEI_MANUAL_SEARCH || s == SearchBoxMode.NEI_AUTOSEARCH;
    }

    @Override
    public String getBackground() {
        return "gui/widget/items.png";
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        this.scrollbar.draw((AEBaseGui)this.parent);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        if (AEConfig.instance.preserveSearchBar && this.searchField != null && this.searchField.isMouseIn(mouseX, mouseY)) {
            this.parent.drawTooltip(this.absX - offsetX, this.absY - 20, 0, this.searchField.getMessage());
        }
        if (ModAndClassUtil.NEI && this.searchField != null && this.searchField.isMouseIn(mouseX, mouseY) && this.isNEISearch() && this.parent != null) {
            List<String> list = Ae2ReflectClient.getHistoryList(this.history);
            this.parent.drawHistorySelection(this.searchField.field_146209_f - offsetX, this.searchField.field_146210_g - this.parent.getGuiTop(), this.searchField.func_146179_b(), this.searchField.field_146218_h, list);
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTextureBack(this.getBackground());
        this.parent.func_73729_b(this.absX, this.absY, 0, 0, 101, 96);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float btn) {
    }

    @Override
    public void initGui() {
        this.absX = this.parent.getGuiLeft() - 101;
        this.absY = this.parent.getGuiTop() + this.parent.getYSize() - 96;
        this.searchField = new THGuiTextField(this.parent.getFontRenderer(), this.absX + 3, this.absY + 4, 72, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        this.searchField.setMessage(ButtonToolTips.SearchStringTooltip.getLocal());
        this.gui.getMeSlots().clear();
        List<Slot> slots = this.getInventorySlots();
        slots.removeIf(slot -> slot instanceof SlotME);
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                InternalSlotME s = new InternalSlotME((IDisplayRepo)this.repo, x + y * this.perRow, this.absX - this.parent.getGuiLeft() + 5 + x * 18, this.absY + 18 - this.parent.getGuiTop() + y * 18);
                this.gui.getMeSlots().add(s);
                this.getInventorySlots().add((Slot)new SlotME(s));
            }
        }
        this.offsetY = this.absY;
        this.SortByBox = new GuiImgButton(this.absX - 18, this.offsetY, (Enum)Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
        this.gui.getButtonList().add((GuiButton)this.SortByBox);
        this.offsetY += 20;
        Objects.requireNonNull(this);
        this.ViewBox = new GuiImgButton(this.absX - 18, this.offsetY, (Enum)Settings.VIEW_MODE, this.configSrc.getSetting(Settings.VIEW_MODE));
        this.gui.getButtonList().add((GuiButton)this.ViewBox);
        this.offsetY += 20;
        if (ModAndClassUtil.isTypeFilter) {
            this.typeFilter = new GuiImgButton(this.absX - 18, this.offsetY, (Enum)Settings.TYPE_FILTER, this.configSrc.getSetting(Settings.TYPE_FILTER));
            this.gui.getButtonList().add((GuiButton)this.typeFilter);
            this.offsetY += 20;
        }
        this.SortDirBox = new GuiImgButton(this.absX - 18, this.offsetY, (Enum)Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.gui.getButtonList().add((GuiButton)this.SortDirBox);
        this.offsetY += 20;
        this.searchBoxSettings = new GuiImgButton(this.absX - 18, this.offsetY, (Enum)Settings.SEARCH_MODE, AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE));
        this.gui.getButtonList().add((GuiButton)this.searchBoxSettings);
        this.offsetY += 20;
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.AUTOSEARCH || searchMode == SearchBoxMode.NEI_AUTOSEARCH) {
            this.searchField.func_146195_b(true);
        }
        if (AEConfig.instance.preserveSearchBar || this.parent.isSubGui()) {
            this.setSearchString(memoryText, false);
        }
        if (this.parent.isSubGui()) {
            this.repo.updateView();
        }
        this.setScrollBar();
    }

    private List<Slot> getInventorySlots() {
        return this.parent.field_147002_h.field_75151_b;
    }

    @Override
    public boolean hideItemPanelSlot(int tx, int ty, int tw, int th) {
        int rw = 101;
        int rh = 96;
        if (tw <= 0 || th <= 0) {
            return false;
        }
        int rx = this.absX;
        int ry = this.absY;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    @Override
    public void mouseClicked(int xCoord, int yCoord, int btn) {
        this.saveSearchString();
        this.searchField.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.setSearchString("", true);
        }
        this.scrollbar.click((AEBaseGui)this.parent, xCoord - this.parent.getGuiLeft(), yCoord - this.parent.getGuiTop());
        if (ModAndClassUtil.CORE_MOD && GTUtil.compareVersion(GTUtil.CoreModVersion) == 1) {
            return;
        }
        boolean flag = btn == this.parent.field_146297_k.field_71474_y.field_74322_I.func_151463_i() + 100;
        Slot slot = this.getSlotAtPosition(xCoord, yCoord);
        if (slot != null && (btn == 0 || btn == 1 || flag)) {
            if (btn == this.parent.field_146297_k.field_71474_y.field_74322_I.func_151463_i() + 100) {
                this.handleMouseClick(slot, slot.getSlotIndex(), btn, 3);
            } else if (GuiScreen.func_146272_n()) {
                this.handleMouseClick(slot, slot.getSlotIndex(), btn, 1);
            } else {
                this.handleMouseClick(slot, slot.getSlotIndex(), btn, 0);
            }
        }
    }

    private Slot getSlotAtPosition(int mouseX, int mouseY) {
        Optional<Slot> slot = this.getInventorySlots().stream().filter(s -> s instanceof SlotME).filter(x -> this.isMouseOverSlot((Slot)x, mouseX, mouseY)).findFirst();
        return slot.orElse(null);
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    private boolean func_146978_c(int left, int top, int right, int bottom, int pointX, int pointY) {
        int k1 = this.parent.getGuiLeft();
        int l1 = this.parent.getGuiTop();
        return (pointX -= k1) >= left - 1 && pointX < left + right + 1 && (pointY -= l1) >= top - 1 && pointY < top + bottom + 1;
    }

    public void setSearchString(String memoryText, boolean updateView) {
        this.searchField.func_146180_a(memoryText);
        this.repo.setSearchString(memoryText);
        if (updateView) {
            this.repo.updateView();
            this.setScrollBar();
        }
        this.updateSuggestion();
    }

    @Override
    public void setScrollBar() {
        this.scrollbar.setTop(this.absY - this.parent.getGuiTop() + 18).setLeft(this.absX - this.parent.getGuiLeft() + this.w - 20).setHeight(this.rows * 18 - 2);
        this.scrollbar.setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    public boolean isOverTextField(int mousex, int mousey) {
        return this.searchField.isMouseIn(mousex, mousey);
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (!this.searchField.isMouseIn(mousex, mousey)) {
            return;
        }
        if (ModAndClassUtil.THE && AspectUtil.getAspectFromJar((ItemStack)stack) != null) {
            this.setSearchString(Objects.requireNonNull(AspectUtil.getAspectFromJar((ItemStack)stack)).getName(), true);
        } else {
            this.setSearchString(displayName, true);
        }
        this.saveSearchString();
    }

    @Override
    public boolean handleMouseClick(Slot slot, int slotIdx, int ctrlDown, int mouseButton) {
        if (slotIdx < 0) {
            return false;
        }
        this.saveSearchString();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.parent.updateFluidContainer(slot, slotIdx, ctrlDown, mouseButton)) {
            return true;
        }
        if (Keyboard.isKeyDown((int)57) && !(slot instanceof SlotPatternTerm)) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = Ae2ReflectClient.getInventorySlots((AEBaseGui)this.parent).size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            this.inventorySlots.setTargetStack(stack);
            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.MOVE_REGION, slotNum, -2L);
            NetworkHandler.instance.sendToServer((AppEngPacket)p);
            return true;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (mouseButton) {
                case 0: {
                    action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || player.field_71071_by.func_70445_o() != null) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case 3: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                }
            }
            if (action == InventoryAction.AUTO_CRAFT) {
                this.inventorySlots.setTargetStack(stack);
                AE2Thing.proxy.netHandler.sendToServer(new CPacketInventoryAction(action, Ae2ReflectClient.getInventorySlots((AEBaseGui)this.parent).size(), -2, stack));
            } else if (action != null) {
                if (stack != null && stack.getItem() instanceof ItemFluidDrop) {
                    stack = null;
                }
                this.inventorySlots.setTargetStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, Ae2ReflectClient.getInventorySlots((AEBaseGui)this.parent).size(), -2L);
                NetworkHandler.instance.sendToServer((AppEngPacket)p);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean actionPerformed(GuiButton btn) {
        if (btn instanceof GuiImgButton) {
            GuiImgButton iBtn = (GuiImgButton)btn;
            boolean backwards = Mouse.isButtonDown((int)1);
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                if (btn == this.searchBoxSettings) {
                    AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                } else if (btn == this.SortByBox || btn == this.SortDirBox || btn == this.ViewBox || btn == this.typeFilter) {
                    try {
                        NetworkHandler.instance.sendToServer((AppEngPacket)new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                    iBtn.set(next);
                    if (next.getClass() == SearchBoxMode.class || next.getClass() == TerminalStyle.class) {
                        this.reInitalize();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void reInitalize() {
        this.gui.getButtonList().clear();
        this.initGui();
    }

    @Override
    public void mouseClickMove(int x, int y, int c, long d) {
        this.scrollbar.click((AEBaseGui)this.parent, x - this.parent.getGuiLeft(), y - this.parent.getGuiTop());
    }

    @Override
    public boolean mouseWheelEvent(int mouseX, int mouseY, int wheel) {
        if (ModAndClassUtil.NEI && this.searchField.isMouseIn(mouseX, mouseY) && this.isNEISearch()) {
            TextHistory.Direction direction;
            switch (wheel) {
                case -1: {
                    direction = TextHistory.Direction.PREVIOUS;
                    break;
                }
                case 1: {
                    direction = TextHistory.Direction.NEXT;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.history.get(direction, this.searchField.func_146179_b()).ifPresent(t -> this.setSearchString((String)t, true));
            return true;
        }
        if (this.scrollbar.contains(mouseX - this.parent.getGuiLeft(), mouseY - this.parent.getGuiTop()) || mouseX > this.absX && mouseX < this.absX + this.w && mouseY > this.absY + 18 && mouseY < this.absY + this.h) {
            this.saveSearchString();
            int currentScroll = this.scrollbar.getCurrentScroll();
            this.scrollbar.wheel(wheel);
            return currentScroll != this.scrollbar.getCurrentScroll();
        }
        return mouseX > this.absX && mouseX < this.absX + this.w && mouseY > this.absY && mouseY < this.absY + this.h;
    }

    private void updateSuggestion() {
        if (ModAndClassUtil.NEI && this.isNEISearch()) {
            if (this.searchField.func_146179_b().isEmpty()) {
                this.setSuggestion("");
                return;
            }
            Optional<String> history = Ae2ReflectClient.getHistoryList(this.history).stream().filter(s -> s.startsWith(this.searchField.func_146179_b())).findFirst();
            if (history.isPresent()) {
                this.setSuggestion(history.get());
            } else {
                this.setSuggestion("");
            }
        }
    }

    private void setSuggestion(String suggestion) {
        this.searchField.setSuggestion(suggestion);
    }

    @Override
    public boolean keyTyped(char character, int key) {
        if (ModAndClassUtil.NEI && this.isNEISearch()) {
            if (key == 15 && this.searchField.func_146206_l()) {
                Optional<String> history = Ae2ReflectClient.getHistoryList(this.history).stream().filter(s -> s.startsWith(this.searchField.func_146179_b())).findFirst();
                history.ifPresent(s -> this.setSearchString((String)s, true));
                return true;
            }
            if (key == 211) {
                String next = this.history.getNext(this.searchField.func_146179_b()).orElse("");
                Ae2ReflectClient.getHistoryList(this.history).removeIf(s -> s.equals(this.searchField.func_146179_b()));
                this.setSearchString(next, true);
                return true;
            }
        }
        if (this.searchField.func_146206_l()) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return false;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
                this.updateSuggestion();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean draggable() {
        return false;
    }

    @Override
    public IDraggable.Rectangle getRectangle() {
        return new IDraggable.Rectangle(this.absX, this.absY, this.w, this.h);
    }

    @Override
    public void setRectangle(int x, int y) {
        this.absX = x;
        this.absY = y;
    }

    @Override
    public void postFluidUpdate(List<IAEFluidStack> list) {
        for (IAEFluidStack is : list) {
            AEItemStack stack = AEItemStack.create((ItemStack)ItemFluidDrop.newDisplayStack((FluidStack)is.getFluidStack()));
            stack.setStackSize(is.getStackSize());
            stack.setCraftable(is.isCraftable());
            this.repo.postUpdate((IAEItemStack)stack);
        }
        this.repo.updateView();
        if (!this.repo.hasCache()) {
            this.setScrollBar();
        }
    }

    @Override
    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack ias : list) {
            if (ias.getItem() instanceof ItemFluidDrop) continue;
            this.repo.postUpdate(ias);
        }
        this.repo.updateView();
        if (!this.repo.hasCache()) {
            this.setScrollBar();
        }
    }

    public Enum<?> getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    public Enum<?> getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    public Enum<?> getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    public Enum<?> getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    @Override
    public void onGuiClosed() {
        memoryText = this.searchField.func_146179_b();
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.SortByBox != null) {
            this.SortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.SortDirBox != null) {
            this.SortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        if (this.ViewBox != null) {
            this.ViewBox.set(this.configSrc.getSetting(Settings.VIEW_MODE));
        }
        if (this.typeFilter != null) {
            this.typeFilter.set(this.configSrc.getSetting(Settings.TYPE_FILTER));
        }
        this.repo.updateView();
    }

    @Override
    public AdvItemRepo getRepo() {
        return this.repo;
    }

    @Override
    public void handleKeyboardInput() {
        this.getRepo().setPaused(this.parent.hasShiftDown());
    }

    @Override
    public void setPlayerInv(ItemStack is) {
        this.container.getPlayerInv().func_70437_b(is);
    }

    @Override
    public THGuiTextField getSearchField() {
        return this.searchField;
    }
}

