/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.widget;

import appeng.api.util.AEColor;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.client.gui.widget.BaseGuiButton;
import com.asdflj.ae2thing.client.gui.widget.Component;
import com.asdflj.ae2thing.client.gui.widget.IScrollable;
import com.asdflj.ae2thing.network.CPacketTerminalBtns;
import com.asdflj.ae2thing.util.Info;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class THGuiSelection
extends BaseGuiButton
implements IScrollable {
    private boolean display = false;

    public THGuiSelection(int xPos, int yPos, int width, int height, int offsetX, int offsetY, Component component, String packetName) {
        super(xPos, yPos, width, height, offsetX, offsetY, component, packetName);
        this.field_146125_m = true;
    }

    public boolean isDisplay() {
        return this.display;
    }

    @Override
    public void onClick() {
        if (this.display) {
            this.unfocused();
        } else {
            this.display = true;
        }
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        Info info = this.component.getInfo();
        if (this.display && info != null && this.field_146125_m) {
            List<String> list = Arrays.stream(AEColor.values()).map(AEColor::toString).collect(Collectors.toList());
            this.drawHistorySelection(this.component.getX() + this.component.getRender().func_78256_a(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.color", (Object[])new Object[0]) + ": "), this.component.getY() - 1, info.getColor(), 50, list);
        }
    }

    @Override
    public int getIndex() {
        return 2;
    }

    @Override
    public void unfocused() {
        if (this.display) {
            this.display = false;
            Info info = this.component.getInfo();
            if (info == null) {
                return;
            }
            this.updateColor(info);
        }
    }

    private NBTTagCompound writeToNBT(Info info) {
        NBTTagCompound data = new NBTTagCompound();
        info.a.writeToNBT(data);
        data.func_74777_a("color", (short)info.getAEColor().ordinal());
        return data;
    }

    private void updateColor(Info info) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("#0", (NBTBase)this.writeToNBT(info));
        AE2Thing.proxy.netHandler.sendToServer(new CPacketTerminalBtns(this.packetName, info.getName(), tag));
    }

    private void drawHistorySelection(int x, int y, String text, int width, List<String> searchHistory) {
        int maxRows = AE2ThingAPI.maxSelectionRows;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        String[] var4 = null;
        ArrayList<String> history = new ArrayList<String>(searchHistory);
        Collections.reverse(history);
        if (history.size() > maxRows) {
            for (int i = 1; i < history.size(); ++i) {
                if (!text.equals(history.get(i))) continue;
                int max = Math.min(history.size(), i + maxRows - 1);
                int min = Math.max(0, max - maxRows);
                var4 = history.subList(min, max).toArray(new String[0]);
                break;
            }
        }
        if (var4 == null) {
            var4 = history.subList(0, Math.min(history.size(), 5)).toArray(new String[0]);
        }
        if (var4.length > 0) {
            int var7;
            int var6;
            int var5 = width;
            for (var6 = 0; var6 < var4.length; ++var6) {
                var7 = this.component.getGui().getFontRenderer().func_78256_a(var4[var6]) + 8;
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 3;
            var7 = y + 15;
            int var9 = 8;
            if (var4.length > 1) {
                var9 += 2 + (var4.length - 1) * 10;
            }
            if (this.component.getGui().getGuiTop() + var7 + var9 + 6 > this.component.getGui().field_146295_m) {
                var7 = this.component.getGui().field_146295_m - var9 - this.component.getGui().getGuiTop() - 6;
            }
            this.field_73735_i = 300.0f;
            int var10 = -267386864;
            this.func_73733_a(var6 - 3, var7 - 4, var6 + var5 + 3, var7 - 3, -267386864, -267386864);
            this.func_73733_a(var6 - 3, var7 + var9 + 3, var6 + var5 + 3, var7 + var9 + 4, -267386864, -267386864);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 + var9 + 3, -267386864, -267386864);
            this.func_73733_a(var6 - 4, var7 - 3, var6 - 3, var7 + var9 + 3, -267386864, -267386864);
            this.func_73733_a(var6 + var5 + 3, var7 - 3, var6 + var5 + 4, var7 + var9 + 3, -267386864, -267386864);
            int var11 = 0x505000FF;
            int var12 = 1344798847;
            this.func_73733_a(var6 - 3, var7 - 3 + 1, var6 - 3 + 1, var7 + var9 + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(var6 + var5 + 2, var7 - 3 + 1, var6 + var5 + 3, var7 + var9 + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(var6 - 3, var7 + var9 + 2, var6 + var5 + 3, var7 + var9 + 3, 1344798847, 1344798847);
            for (int var13 = 0; var13 < var4.length; ++var13) {
                String var14 = var4[var13];
                if (var14.equals(text)) {
                    var14 = "> " + var14;
                    var14 = '\u00a7' + Integer.toHexString(15) + var14;
                } else {
                    var14 = "\u00a77" + var14;
                }
                this.component.getGui().getFontRenderer().func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            this.field_73735_i = 0.0f;
        }
        GL11.glPopAttrib();
    }

    @Override
    public boolean scroll(int x, int y, int wheel) {
        AEColor color;
        Info info = this.component.getInfo();
        if (!this.isDisplay() || info == null) {
            return false;
        }
        switch (wheel) {
            case -1: {
                AEColor aEColor = AEColor.values()[Math.max(0, info.getAEColor().ordinal() - 1)];
                break;
            }
            case 1: {
                AEColor aEColor = AEColor.values()[Math.min(AEColor.values().length - 1, info.getAEColor().ordinal() + 1)];
                break;
            }
            default: {
                AEColor aEColor = color = null;
            }
        }
        if (color != null) {
            info.setAEColor(color);
        }
        return true;
    }
}

