/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.render;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class Shader {
    public boolean isLoader = false;
    private int program;
    public final int mode;
    public String name;
    public String domain;
    public String vertShaderFilename;
    public String fragShaderFilename;
    public static ArrayList<Shader> allShaderProgram = new ArrayList();

    public Shader(String name, String vertShaderFilename, String fragShaderFilename) {
        int program;
        this.name = name;
        this.domain = name;
        try {
            this.vertShaderFilename = vertShaderFilename;
            this.fragShaderFilename = fragShaderFilename;
            program = Shader.createProgram(this, this.domain, vertShaderFilename, fragShaderFilename);
        }
        catch (Exception e) {
            this.isLoader = false;
            program = 0;
        }
        allShaderProgram.add(this);
        this.mode = 0;
        this.program = program;
    }

    private static int createProgram(Shader shaderProgram, String domain, String vertShaderFilename, String fragShaderFilename) {
        if (!OpenGlHelper.field_148824_g) {
            return 0;
        }
        int program = GL20.glCreateProgram();
        int vertShader = Shader.loadAndCompileShader(shaderProgram, program, domain, vertShaderFilename, 35633);
        int fragShader = Shader.loadAndCompileShader(shaderProgram, program, domain, fragShaderFilename, 35632);
        if (vertShader != 0) {
            GL20.glAttachShader((int)program, (int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glAttachShader((int)program, (int)fragShader);
        }
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            shaderProgram.isLoader = false;
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            shaderProgram.isLoader = false;
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        shaderProgram.isLoader = vertShader != 0 && fragShader != 0;
        GL20.glDeleteShader((int)vertShader);
        GL20.glDeleteShader((int)fragShader);
        return program;
    }

    private static int loadAndCompileShader(Shader shaderProgram, int program, String domain, String filename, int shaderType) {
        if (filename == null) {
            return 0;
        }
        int shader = GL20.glCreateShader((int)shaderType);
        if (shader == 0) {
            shaderProgram.isLoader = false;
            return 0;
        }
        String code = Shader.loadFile(shaderProgram, new ResourceLocation(domain, filename));
        if (code == null) {
            GL20.glDeleteShader((int)shader);
            shaderProgram.isLoader = false;
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)code);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            shaderProgram.isLoader = false;
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private static String loadFile(Shader shaderProgram, ResourceLocation resourceLocation) {
        try {
            String line;
            StringBuilder code = new StringBuilder();
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                code.append(line);
                code.append('\n');
            }
            reader.close();
            return code.toString();
        }
        catch (Exception e) {
            shaderProgram.isLoader = false;
            return null;
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void use() {
        GL20.glUseProgram((int)this.program);
    }

    public void clear() {
        GL20.glUseProgram((int)0);
    }
}

