/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.features.AEFeature;
import appeng.items.contents.CellUpgrades;
import appeng.tile.inventory.AppEngInternalInventory;
import codechicken.nei.recipe.StackInfo;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.FluidCellInventoryHandler;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventory;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventoryHandler;
import com.asdflj.ae2thing.common.storage.infinityCell.CreativeFluidCellInventory;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.IStorageFluidCell;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class ItemCreativeFluidCell
extends BaseCellItem
implements IStorageFluidCell {
    public static final ItemStack water_bucket = new ItemStack(Items.field_151131_as, 1);
    public static final ItemStack lava_bucket = new ItemStack(Items.field_151129_at, 1);
    private final int perType = 1;
    private final double idleDrain = 2000.0;
    private final ItemStack is;
    private final String name;

    public IMEInventoryHandler<IAEFluidStack> getInventoryHandler(ItemStack o, ISaveProvider container, EntityPlayer player) throws AppEngException {
        return new FluidCellInventoryHandler((IMEInventory<IAEFluidStack>)new CreativeFluidCellInventory(o, container, player));
    }

    public ItemCreativeFluidCell(String name, ItemStack is) {
        this.is = is;
        this.name = name;
        FluidStack fs = StackInfo.getFluid((ItemStack)is);
        this.func_77655_b(this.name);
        this.func_111206_d(AE2Thing.resource(String.format("%s_%s", "creative_fluid_cell", fs.getFluid().getName())).toString());
        this.func_77625_d(1);
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
    }

    public ItemCreativeFluidCell register() {
        GameRegistry.registerItem((Item)this, (String)this.name, (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public long getBytes(ItemStack cellItem) {
        return Integer.MAX_VALUE;
    }

    public int getBytesPerType(ItemStack cellItem) {
        return 1;
    }

    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(ItemStack i) {
        return false;
    }

    public double getIdleDrain(ItemStack is) {
        return 2000.0;
    }

    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    public boolean isEditable(ItemStack is) {
        return false;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new InfinityConfig(this.is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return null;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof ITFluidCellInventoryHandler) {
            ITFluidCellInventoryHandler handler = (ITFluidCellInventoryHandler)inventory;
            ITFluidCellInventory cellInventory = handler.getCellInv();
            if (GuiScreen.func_146271_m()) {
                if (!cellInventory.getContents().isEmpty()) {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_contents"));
                    for (IAEFluidStack fluid : cellInventory.getContents()) {
                        if (fluid == null) continue;
                        lines.add(String.format("  %s", fluid.getFluidStack().getLocalizedName()));
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_empty"));
                }
            } else {
                lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.ctrl_for_more"));
            }
        }
    }

    protected static class InfinityConfig
    extends AppEngInternalInventory {
        public InfinityConfig(ItemStack is) {
            super(null, 1);
            this.func_70299_a(0, is);
        }

        public void func_70296_d() {
        }
    }
}

