/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.parts;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.BiggerAppEngInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.asdflj.ae2thing.common.parts.THPart;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.glodblock.github.client.textures.FCPartsTexture;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartInfusionPatternTerminal
extends THPart
implements IPatternTerminal {
    private static final FCPartsTexture FRONT_BRIGHT_ICON = FCPartsTexture.PartFluidPatternTerminal_Bright;
    private static final FCPartsTexture FRONT_DARK_ICON = FCPartsTexture.PartFluidPatternTerminal_Colored;
    private static final FCPartsTexture FRONT_COLORED_ICON = FCPartsTexture.PartFluidPatternTerminal_Dark;
    protected final AppEngInternalInventory pattern = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    protected AppEngInternalInventory crafting = new BiggerAppEngInventory((IAEAppEngInventory)this, 1);
    protected AppEngInternalInventory output = new BiggerAppEngInventory((IAEAppEngInventory)this, 32);
    private final AppEngInternalInventory upgrades = new RefillerInventory(this);
    protected boolean craftingMode = true;
    protected int activePage = 0;
    protected boolean combine = false;

    public PartInfusionPatternTerminal(ItemStack is) {
        super(is, true);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void setActivePage(int value) {
        this.activePage = value;
    }

    @Override
    public int getActivePage() {
        return this.activePage;
    }

    @Override
    public boolean shouldCombine() {
        return this.combine;
    }

    @Override
    public void setCombineMode(boolean shouldCombine) {
        this.combine = shouldCombine;
    }

    @Override
    public void setPrioritization(boolean canPrioritize) {
    }

    @Override
    public void setInverted(boolean inverted) {
    }

    @Override
    public boolean hasRefillerUpgrade() {
        return this.upgrades.func_70301_a(0) != null;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public IGrid getGrid() {
        try {
            return this.proxy.getGrid();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public GuiType getGui() {
        return GuiType.INFUSION_PATTERN_TERMINAL;
    }

    @Override
    public FCPartsTexture getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public FCPartsTexture getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem craftingPatternItem;
        ICraftingPatternDetails details;
        Item item;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && (item = is.func_77973_b()) instanceof ICraftingPatternItem && (details = (craftingPatternItem = (ICraftingPatternItem)item).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
            IAEItemStack item2;
            int i;
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            this.craftingMode = data.func_74767_n("tc_crafting");
            IAEItemStack[] inItems = this.isCraftingRecipe() ? details.getOutputs() : details.getInputs();
            IAEItemStack[] outItems = this.isCraftingRecipe() ? details.getInputs() : details.getOutputs();
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.output.func_70302_i_(); ++i) {
                this.output.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_() && i < inItems.length; ++i) {
                if (inItems[i] == null) continue;
                item2 = inItems[i];
                this.crafting.func_70299_a(i, item2 == null ? null : item2.getItemStack());
            }
            for (i = 0; i < this.output.func_70302_i_() && i < outItems.length; ++i) {
                if (outItems[i] == null) continue;
                item2 = outItems[i];
                this.output.func_70299_a(i, item2 == null ? null : item2.getItemStack());
            }
        }
        this.getHost().markForSave();
    }

    @Override
    public FCPartsTexture getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public boolean isLightSource() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
        this.upgrades.readFromNBT(data, "upgrades");
        this.craftingMode = data.func_74767_n("craftingMode");
        this.activePage = data.func_74762_e("activePage");
        this.combine = data.func_74767_n("combine");
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    @Override
    public void setSubstitution(boolean canSubstitute) {
    }

    @Override
    public void setBeSubstitute(boolean canBeSubstitute) {
    }

    @Override
    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public boolean isInverted() {
        return false;
    }

    @Override
    public boolean canBeSubstitute() {
        return false;
    }

    @Override
    public boolean isPrioritize() {
        return false;
    }

    @Override
    public boolean isSubstitution() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
        this.upgrades.writeToNBT(data, "upgrades");
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74768_a("activePage", this.activePage);
        data.func_74757_a("combine", this.combine);
    }

    public static class RefillerInventory
    extends AppEngInternalInventory {
        public RefillerInventory(IAEAppEngInventory parent) {
            super(parent, 1, 1);
            this.setTileEntity(parent);
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return i == 0 && this.func_70301_a(0) == null && AEApi.instance().definitions().materials().cardPatternRefiller().isSameAs(itemstack);
        }
    }
}

