/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.AEApi;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.AEFluidStack;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.PrecisePriorityList;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventory;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventoryHandler;
import com.asdflj.ae2thing.util.Ae2Reflect;
import com.asdflj.ae2thing.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class FluidCellInventoryHandler
extends MEInventoryHandler<IAEFluidStack>
implements ITFluidCellInventoryHandler,
ICellCacheRegistry {
    public FluidCellInventoryHandler(IMEInventory<IAEFluidStack> c) {
        super(c, StorageChannel.FLUIDS);
        ITFluidCellInventory ci = this.getCellInv();
        if (ci != null) {
            IInventory config = ci.getConfigInventory();
            IItemList priorityList = AEApi.instance().storage().createFluidList();
            for (int x = 0; x < config.func_70302_i_(); ++x) {
                ItemStack is = config.func_70301_a(x);
                if (Util.getFluidFromItem(is) == null) continue;
                priorityList.add((IAEStack)AEFluidStack.create((Object)Util.getFluidFromItem(is)));
            }
            if (!priorityList.isEmpty()) {
                this.setPartitionList((IPartitionList)new PrecisePriorityList(priorityList));
            }
        }
    }

    @Override
    public ITFluidCellInventory getCellInv() {
        IMEInventory<?> o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = Ae2Reflect.getInternal((MEPassThrough)o);
        }
        return (ITFluidCellInventory)(o instanceof ITFluidCellInventory ? o : null);
    }

    public Iterable<IAEFluidStack> getPartitionInv() {
        return Ae2Reflect.getPartitionList(this).getItems();
    }

    public boolean isPreformatted() {
        return !Ae2Reflect.getPartitionList(this).isEmpty();
    }

    public IncludeExclude getIncludeExcludeMode() {
        return IncludeExclude.WHITELIST;
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }

    public boolean canGetInv() {
        return true;
    }

    public long getTotalBytes() {
        return this.getCellInv().getTotalBytes();
    }

    public long getFreeBytes() {
        return this.getCellInv().getFreeBytes();
    }

    public long getUsedBytes() {
        return this.getCellInv().getUsedBytes();
    }

    public long getTotalTypes() {
        return this.getCellInv().getTotalFluidTypes();
    }

    public long getFreeTypes() {
        return this.getCellInv().getRemainingFluidTypes();
    }

    public long getUsedTypes() {
        return this.getCellInv().getStoredFluidTypes();
    }

    public int getCellStatus() {
        return this.getStatusForCell();
    }

    public ICellCacheRegistry.TYPE getCellType() {
        return ICellCacheRegistry.TYPE.FLUID;
    }
}

