/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage.infinityCell;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.ITCellInventory;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CreativeCellInventory
implements ITCellInventory {
    private IItemList<IAEItemStack> itemListCache = null;
    private final ItemStack cellItem;
    private final IStorageCell cellType;

    public CreativeCellInventory(ItemStack o) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellItem = o;
        this.cellType = (IStorageCell)this.cellItem.func_77973_b();
    }

    protected IItemList<IAEItemStack> getCellItems() {
        if (this.itemListCache == null) {
            this.loadCellItems();
        }
        return this.itemListCache;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return this.cellType.getIdleDrain(is);
    }

    @Override
    public void loadCellItems() {
        if (this.itemListCache == null) {
            this.itemListCache = AEApi.instance().storage().createPrimitiveItemList();
        }
        this.itemListCache.resetStatus();
        IInventory inv = this.cellType.getConfigInventory(this.cellItem);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            AEItemStack is = AEItemStack.create((ItemStack)inv.func_70301_a(i));
            if (is == null) continue;
            is.setStackSize(2147483647000L);
            this.itemListCache.add((IAEStack)is);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.cellItem);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    @Override
    public boolean canHoldNewItem(ItemStack is) {
        return false;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    @Override
    public long getFreeBytes() {
        return 0L;
    }

    @Override
    public long getUsedBytes() {
        return 0L;
    }

    @Override
    public long getTotalItemTypes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    @Override
    public long getStoredItemCount() {
        return 2147483647000L;
    }

    @Override
    public long getStoredItemTypes() {
        return 1L;
    }

    @Override
    public long getRemainingItemTypes() {
        return 0L;
    }

    @Override
    public long getRemainingItemCount() {
        return 0L;
    }

    @Override
    public int getUnusedItemCount() {
        return 0;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem(this.cellItem)) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    @Override
    public String getOreFilter() {
        return this.cellType.getOreFilter(this.cellItem);
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        if (this.getCellItems().findPrecise((IAEStack)input) != null) {
            return null;
        }
        return input;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        if (this.getCellItems().findPrecise((IAEStack)request) != null) {
            return request.copy();
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        for (IAEItemStack ais : this.getCellItems()) {
            out.add((IAEStack)ais);
        }
        return out;
    }

    public IAEItemStack getAvailableItem(@Nonnull IAEItemStack request, int iteration) {
        IAEItemStack local = (IAEItemStack)this.getCellItems().findPrecise((IAEStack)request);
        if (local == null) {
            return null;
        }
        return request.copy();
    }

    public StorageChannel getChannel() {
        return ((BaseCellItem)Objects.requireNonNull(this.cellItem.func_77973_b())).getChannel();
    }
}

