/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.coremod;

import com.asdflj.ae2thing.coremod.transform.CraftingJobV2Transformer;
import com.asdflj.ae2thing.coremod.transform.FluidConvertingInventoryAdaptorTransformer;
import com.asdflj.ae2thing.coremod.transform.GuiDualInterfaceTransformer;
import com.asdflj.ae2thing.coremod.transform.PlatformTransformer;
import com.asdflj.ae2thing.coremod.transform.TileThaumatoriumTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] code) {
        ClassMapper tform;
        switch (transformedName) {
            case "appeng.client.me.ItemRepo": {
                tform = PlatformTransformer.INSTANCE;
                break;
            }
            case "com.glodblock.github.inventory.FluidConvertingInventoryAdaptor": {
                tform = FluidConvertingInventoryAdaptorTransformer.INSTANCE;
                break;
            }
            case "thaumcraft.common.tiles.TileThaumatorium": {
                tform = TileThaumatoriumTransformer.INSTANCE;
                break;
            }
            case "com.glodblock.github.client.gui.GuiDualInterface": {
                tform = GuiDualInterfaceTransformer.INSTANCE;
                break;
            }
            case "appeng.crafting.v2.CraftingJobV2": 
            case "appeng.me.GridStorage": {
                tform = CraftingJobV2Transformer.INSTANCE;
                break;
            }
            default: {
                return code;
            }
        }
        System.out.println("[AE2TH] Transforming class: " + transformedName);
        return tform.transformClass(code);
    }

    public static interface Transform {
        public byte[] transformClass(byte[] var1);
    }

    public static abstract class ClassMapper
    implements Transform {
        @Override
        public byte[] transformClass(byte[] code) {
            ClassReader reader = new ClassReader(code);
            ClassWriter writer = new ClassWriter(reader, this.getWriteFlags());
            reader.accept(this.getClassMapper((ClassVisitor)writer), 8);
            return writer.toByteArray();
        }

        protected int getWriteFlags() {
            return 0;
        }

        protected abstract ClassVisitor getClassMapper(ClassVisitor var1);
    }
}

