/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.coremod.hooker;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.Platform;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.asdflj.ae2thing.util.TheUtil;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.client.gui.GuiDualInterface;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.items.ItemCraftingAspect;

@SideOnly(value=Side.CLIENT)
public class CoreModHooksClient {
    private static final HashMap<IAEItemStack, ItemInfo> cache = new HashMap();

    public static String getModId(IAEItemStack is) {
        if (cache.containsKey(is) && CoreModHooksClient.cache.get((Object)is).modId != null) {
            return CoreModHooksClient.cache.get((Object)is).modId;
        }
        if (is.getItem() instanceof ItemFluidDrop) {
            String id = Util.getModId(is);
            CoreModHooksClient.putCache(is, id, null, null);
            return id;
        }
        return Platform.getModId((IAEItemStack)is);
    }

    public static String getItemDisplayName(Object o) {
        if (o instanceof IAEItemStack) {
            IAEItemStack is = (IAEItemStack)o;
            if (cache.containsKey(is) && CoreModHooksClient.cache.get((Object)is).name != null) {
                return CoreModHooksClient.cache.get((Object)is).name;
            }
            if (is.getItem() instanceof ItemFluidDrop) {
                String name = Util.getDisplayName(is);
                CoreModHooksClient.putCache(is, null, name, null);
                return name;
            }
        }
        return Platform.getItemDisplayName((Object)o);
    }

    private static void putCache(IAEItemStack is, String modId, String name, List<String> tooltip) {
        if (!cache.containsKey(is)) {
            cache.putIfAbsent(is, new ItemInfo(modId, name, tooltip));
        } else {
            ItemInfo info = cache.get(is);
            if (info.modId == null) {
                info.modId = modId;
            }
            if (info.name == null) {
                info.name = name;
            }
            if (info.tooltip == null) {
                info.tooltip = tooltip;
            }
        }
    }

    public static List<String> getTooltip(Object o) {
        if (o instanceof IAEItemStack) {
            IAEItemStack is = (IAEItemStack)o;
            if (cache.containsKey(is) && CoreModHooksClient.cache.get((Object)is).tooltip != null) {
                return CoreModHooksClient.cache.get((Object)is).tooltip;
            }
            if (is.getItem() instanceof ItemFluidDrop) {
                FluidStack fs = ItemFluidDrop.getFluidStack((ItemStack)is.getItemStack());
                if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((FluidStack)fs)) {
                    Aspect aspect = AspectUtil.getAspectFromGas((FluidStack)fs);
                    List tooltip = ItemCraftingAspect.createStackForAspect((Aspect)aspect, (int)1).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                    CoreModHooksClient.putCache(is, null, null, tooltip);
                    return tooltip;
                }
            }
        }
        return Platform.getTooltip((Object)o);
    }

    public static String translateToLocal(String displayName, GuiDualInterface dualInterface) {
        if (ModAndClassUtil.THE) {
            return TheUtil.getGuiDualInterfaceDisplayName(displayName, dualInterface);
        }
        return I18n.func_135052_a((String)displayName, (Object[])new Object[0]);
    }

    private static class ItemInfo {
        public String name;
        public String modId;
        public List<String> tooltip;

        public ItemInfo(String modId, String name, List<String> tooltip) {
            this.name = name;
            this.modId = modId;
            this.tooltip = tooltip;
        }
    }
}

