/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.coremod.mixin.ae;

import appeng.api.features.INetworkEncodable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.crafting.CraftBranchFailure;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.misc.TileSecurity;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.Constants;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import com.asdflj.ae2thing.util.BaublesUtil;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingCPUCluster.class})
public abstract class MixinCraftingCPUCluster {
    @Unique
    private EntityPlayer player;
    private IAEItemStack output;
    private long networkKey = 0L;

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"submitJob"}, at={@At(value="RETURN")}, remap=false)
    private void submitJob(IGrid g, ICraftingJob job, BaseActionSource src, ICraftingRequester requestingMachine, CallbackInfoReturnable<ICraftingLink> cir) {
        if (src instanceof PlayerSource) {
            PlayerSource ps = (PlayerSource)src;
            if (cir.getReturnValue() != null) {
                Iterator iterator = g.getMachines(TileSecurity.class).iterator();
                if (iterator.hasNext()) {
                    this.networkKey = ((TileSecurity)((IGridNode)iterator.next()).getMachine()).getLocatableSerial();
                    this.player = ps.player;
                    this.output = job.getOutput().copy();
                    return;
                }
                this.setAsNull();
                return;
            }
        }
        this.setAsNull();
    }

    private void setAsNull() {
        this.player = null;
        this.output = null;
        this.networkKey = 0L;
    }

    @Inject(method={"handleCraftBranchFailure"}, at={@At(value="TAIL")}, remap=false)
    private void handleCraftBranchFailure(CraftBranchFailure e, BaseActionSource src, CallbackInfo ci) {
        this.setAsNull();
    }

    @Inject(method={"completeJob"}, at={@At(value="TAIL")}, remap=false)
    private void completeJob(CallbackInfo ci) {
        if (this.player != null && this.output != null && this.networkKey != 0L) {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = this.player.field_71071_by.field_70462_a[i];
                if (!this.isSameNetworkKey(stack)) continue;
                return;
            }
            if (ModAndClassUtil.BAUBLES) {
                IInventory inv = BaublesUtil.getBaublesInv(this.player);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!this.isSameNetworkKey(stack)) continue;
                    return;
                }
            }
        }
    }

    private boolean isSameNetworkKey(ItemStack item) {
        INetworkEncodable encodable;
        String key;
        Item item2;
        if (item != null && (item2 = item.func_77973_b()) instanceof INetworkEncodable && (key = (encodable = (INetworkEncodable)item2).getEncryptionKey(item)) != null && key.equals(Long.toString(this.networkKey))) {
            SPacketMEItemInvUpdate piu = new SPacketMEItemInvUpdate(Constants.MessageType.NOTIFICATION);
            piu.appendItem(this.output);
            AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)this.player);
            this.setAsNull();
            return true;
        }
        return false;
    }
}

