/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.crossmod.waila;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.localization.GuiText;
import appeng.helpers.PatternHelper;
import appeng.items.misc.ItemEncodedPattern;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.common.item.ItemFluidDrop;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mcp.mobius.waila.handlers.nei.TooltipHandlerWaila;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;

public class EncodedPattern
extends TooltipHandlerWaila {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int x, int y, List<String> lines) {
        Item item;
        if (stack != null && stack.func_77973_b() != null && (item = stack.func_77973_b()) instanceof ItemEncodedPattern) {
            IAEItemStack[] outItems;
            IAEItemStack[] inItems;
            ItemEncodedPattern pattern = (ItemEncodedPattern)item;
            String lastLine = lines.get(lines.size() - 1);
            String firstLine = lines.get(0);
            lines.clear();
            lines.add(firstLine);
            EntityClientPlayerMP player = EncodedPattern.mc.field_71439_g;
            NBTTagCompound encodedValue = stack.func_77978_p();
            if (encodedValue == null) {
                lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
                lines.add(lastLine);
                return lines;
            }
            ICraftingPatternDetails details = pattern.getPatternForItem(stack, player.field_70170_p);
            boolean substitute = encodedValue.func_74767_n("substitute");
            boolean beSubstitute = encodedValue.func_74767_n("beSubstitute");
            String author = encodedValue.func_74779_i("author");
            boolean isCrafting = encodedValue.func_74767_n("crafting");
            if (details == null) {
                ItemStack unknownItem = new ItemStack((Block)Blocks.field_150480_ab);
                unknownItem.func_151001_c(GuiText.UnknownItem.getLocal());
                inItems = PatternHelper.convertToCondensedList((IAEItemStack[])PatternHelper.loadIAEItemStackFromNBT((NBTTagList)encodedValue.func_150295_c("in", 10), (boolean)false, (ItemStack)unknownItem));
                outItems = PatternHelper.convertToCondensedList((IAEItemStack[])PatternHelper.loadIAEItemStackFromNBT((NBTTagList)encodedValue.func_150295_c("out", 10), (boolean)false, (ItemStack)unknownItem));
            } else {
                inItems = details.getCondensedInputs();
                outItems = details.getCondensedOutputs();
            }
            boolean recipeIsBroken = details == null;
            ArrayList<String> in = new ArrayList<String>();
            ArrayList<String> out = new ArrayList<String>();
            String substitutionLabel = EnumChatFormatting.YELLOW + GuiText.Substitute.getLocal() + " " + EnumChatFormatting.RESET;
            String beSubstitutionLabel = EnumChatFormatting.YELLOW + GuiText.BeSubstitute.getLocal() + " " + EnumChatFormatting.RESET;
            String canSubstitute = substitute ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
            String canBeSubstitute = beSubstitute ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
            String label = isCrafting ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal();
            String with = GuiText.With.getLocal();
            String result = EnumChatFormatting.DARK_AQUA + label + ": " + EnumChatFormatting.RESET;
            String ingredients = EnumChatFormatting.DARK_GREEN + with + ": " + EnumChatFormatting.RESET;
            String holdShift = I18n.func_135052_a((String)"ae2thing.tooltip.shift_for_more", (Object[])new Object[0]) + EnumChatFormatting.RESET;
            recipeIsBroken = this.addInformation(inItems, in, ingredients, EnumChatFormatting.GREEN) || recipeIsBroken;
            boolean bl = recipeIsBroken = this.addInformation(outItems, out, result, EnumChatFormatting.AQUA) || recipeIsBroken;
            if (recipeIsBroken) {
                lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            } else {
                lines.addAll(out);
                if (GuiScreen.func_146272_n()) {
                    lines.addAll(in);
                } else {
                    lines.add(holdShift);
                }
                lines.add(substitutionLabel + canSubstitute);
                lines.add(beSubstitutionLabel + canBeSubstitute);
                if (!StringUtils.func_151246_b((String)author)) {
                    lines.add(EnumChatFormatting.LIGHT_PURPLE + GuiText.EncodedBy.getLocal(new Object[]{author}) + EnumChatFormatting.RESET);
                }
            }
            lines.add(lastLine);
        }
        return lines;
    }

    private boolean addInformation(IAEItemStack[] items, List<String> lines, String label, EnumChatFormatting color) {
        ItemStack unknownItem = new ItemStack((Block)Blocks.field_150480_ab);
        boolean recipeIsBroken = false;
        boolean first = true;
        List<IAEItemStack> itemsList = Arrays.asList(items);
        List sortedItems = itemsList.stream().sorted(Comparator.comparingLong(IAEStack::getStackSize).reversed()).collect(Collectors.toList());
        boolean isFluid = false;
        for (IAEItemStack item : sortedItems) {
            if (!recipeIsBroken && item.equals(unknownItem)) {
                recipeIsBroken = true;
            }
            if (item.getItemStack().func_77973_b() instanceof ItemFluidDrop) {
                label = EnumChatFormatting.GOLD + label;
                color = EnumChatFormatting.GOLD;
                isFluid = true;
            }
            if (first) {
                lines.add(label);
                lines.add("   " + EnumChatFormatting.WHITE + NumberFormat.getNumberInstance(Locale.US).format(item.getStackSize()) + EnumChatFormatting.RESET + (isFluid ? EnumChatFormatting.WHITE + "L " : " ") + EnumChatFormatting.RESET + color + Util.getDisplayName(item));
            }
            if (!first) {
                lines.add("   " + EnumChatFormatting.WHITE + NumberFormat.getNumberInstance(Locale.US).format(item.getStackSize()) + EnumChatFormatting.RESET + (isFluid ? EnumChatFormatting.WHITE + "L " : " ") + EnumChatFormatting.RESET + color + Util.getDisplayName(item));
            }
            first = false;
        }
        return recipeIsBroken;
    }
}

