/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.loader.recipe;

import appeng.util.Platform;
import com.asdflj.ae2thing.api.WirelessObject;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WirelessTerminalQuantumBridgeRecipe
extends ShapelessRecipes {
    public static List<ItemStack> CARDS = new ArrayList<ItemStack>();
    private static final Set<Class<? extends Item>> terminalClass = new HashSet<Class<? extends Item>>();
    private final ItemStack installedTerm;

    public boolean isQuantumBridgeCard(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return false;
        }
        return CARDS.stream().anyMatch(x -> Objects.equals(x.func_77973_b(), is.func_77973_b()));
    }

    private WirelessTerminalQuantumBridgeRecipe(ItemStack term, ItemStack card) {
        super(term, Arrays.asList(term, card));
        this.installedTerm = this.installQuantumBridgeCard(term);
    }

    public static void registerCard(ItemStack card, ItemStack terminal) {
        if (terminal == null || terminal.func_77973_b() == null) {
            return;
        }
        CARDS.add(card);
        GameRegistry.addRecipe((IRecipe)new WirelessTerminalQuantumBridgeRecipe(terminal, card));
        terminalClass.add(terminal.func_77973_b().getClass());
    }

    public static void register(ItemStack terminal) {
        ItemStack card = GameRegistry.findItemStack((String)"ae2wct", (String)"infinityBoosterCard", (int)1);
        if (card != null) {
            WirelessTerminalQuantumBridgeRecipe.registerCard(card, terminal);
        }
        if ((card = GameRegistry.findItemStack((String)"ae2fc", (String)"quantum_bridge_card", (int)1)) != null) {
            WirelessTerminalQuantumBridgeRecipe.registerCard(card, terminal);
        }
    }

    public static ItemStack getInfinityBoosterCard() {
        Optional card = CARDS.stream().findFirst();
        return card.orElse(null);
    }

    public boolean func_77569_a(InventoryCrafting inv, World w) {
        ItemStack term = inv.func_70301_a(0);
        ItemStack infinityBoosterCard = inv.func_70301_a(1);
        return term != null && term.func_77973_b() != null && terminalClass.contains(term.func_77973_b().getClass()) && !WirelessObject.hasInfinityBoosterCard(term) && this.isQuantumBridgeCard(infinityBoosterCard);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.installQuantumBridgeCard(inv.func_70301_a(0));
    }

    public int func_77570_a() {
        return 2;
    }

    private ItemStack installQuantumBridgeCard(ItemStack is) {
        is = is.func_77946_l();
        NBTTagCompound data = Platform.openNbtData((ItemStack)is);
        data.func_74757_a("infinityBoosterCard", true);
        is.func_77982_d(data);
        return is;
    }

    public ItemStack func_77571_b() {
        return this.installedTerm;
    }
}

