/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.config.CraftingMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import appeng.me.cache.CraftingGridCache;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.adapter.crafting.ICraftingTerminalAdapter;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.util.BlockPos;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketCraftRequest
implements IMessage {
    private long amount;
    private boolean heldShift;
    private IAEItemStack item = null;
    private Mode mode;
    private CraftingMode craftingMode;

    public CPacketCraftRequest() {
    }

    public CPacketCraftRequest(IAEItemStack item, boolean shift) {
        this(item, shift, CraftingMode.STANDARD);
    }

    public CPacketCraftRequest(IAEItemStack item, boolean shift, CraftingMode currentValue) {
        this.item = item;
        this.heldShift = shift;
        this.mode = Mode.ITEM;
        this.craftingMode = currentValue;
    }

    public CPacketCraftRequest(long craftAmt, boolean shift, CraftingMode currentValue) {
        this.amount = craftAmt;
        this.heldShift = shift;
        this.mode = Mode.STACK_SIZE;
        this.craftingMode = currentValue;
    }

    public CPacketCraftRequest(long craftAmt, boolean shift) {
        this(craftAmt, shift, CraftingMode.STANDARD);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.mode.ordinal());
        buf.writeByte(this.craftingMode.ordinal());
        if (this.mode == Mode.ITEM) {
            try {
                this.item.writeToPacket(buf);
                buf.writeBoolean(this.heldShift);
            }
            catch (Exception exception) {}
        } else {
            buf.writeLong(this.amount);
            buf.writeBoolean(this.heldShift);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = Mode.values()[buf.readByte()];
        this.craftingMode = CraftingMode.values()[buf.readByte()];
        if (this.mode == Mode.ITEM) {
            try {
                this.item = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
                this.heldShift = buf.readBoolean();
            }
            catch (Exception exception) {}
        } else {
            this.amount = buf.readLong();
            this.heldShift = buf.readBoolean();
        }
    }

    private static enum Mode {
        ITEM,
        STACK_SIZE;

    }

    public static class Handler
    implements IMessageHandler<CPacketCraftRequest, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketCraftRequest message, MessageContext ctx) {
            Container gh;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerCraftAmount) {
                ContainerCraftAmount cca = (ContainerCraftAmount)container;
                Object target = cca.getTarget();
                if (target instanceof IGridHost) {
                    gh = (IGridHost)target;
                    IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
                    if (gn == null) {
                        return null;
                    }
                    IGrid g = gn.getGrid();
                    if (g == null || cca.getItemToCraft() == null) {
                        return null;
                    }
                    cca.getItemToCraft().setStackSize(message.amount);
                    Future futureJob = null;
                    try {
                        ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                        if (cg instanceof CraftingGridCache) {
                            CraftingGridCache cgc = (CraftingGridCache)cg;
                            futureJob = cgc.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), message.craftingMode, null);
                        } else {
                            futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                        }
                        ContainerOpenContext context = cca.getOpenContext();
                        if (context != null) {
                            TileEntity te = context.getTile();
                            if (te != null) {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), GuiType.CRAFTING_CONFIRM);
                            } else {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((WirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(cca.getOpenContext().getSide()), GuiType.CRAFTING_CONFIRM_ITEM);
                            }
                            Container container2 = player.field_71070_bA;
                            if (container2 instanceof ContainerCraftConfirm) {
                                ContainerCraftConfirm ccc = (ContainerCraftConfirm)container2;
                                ccc.setItemToCraft(cca.getItemToCraft());
                                ccc.setAutoStart(message.heldShift);
                                ccc.setJob(futureJob);
                                cca.func_75142_b();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (futureJob != null) {
                            futureJob.cancel(true);
                        }
                        AELog.debug((Throwable)e);
                    }
                }
            } else {
                AEBaseContainer c;
                Object target;
                gh = player.field_71070_bA;
                if (gh instanceof AEBaseContainer && (target = (c = (AEBaseContainer)gh).getTarget()) instanceof IGridHost) {
                    gh = (IGridHost)target;
                    IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
                    if (gn == null) {
                        return null;
                    }
                    IGrid g = gn.getGrid();
                    if (g == null) {
                        return null;
                    }
                    Future futureJob = null;
                    try {
                        IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                        if (storageGrid == null) {
                            return null;
                        }
                        IAEItemStack storedItem = (IAEItemStack)storageGrid.getItemInventory().getStorageList().findPrecise((IAEStack)message.item);
                        if (storedItem == null || !storedItem.isCraftable()) {
                            return null;
                        }
                        ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                        if (cg instanceof CraftingGridCache) {
                            CraftingGridCache cgc = (CraftingGridCache)cg;
                            futureJob = cgc.beginCraftingJob(player.func_130014_f_(), ((IActionHost)target).getActionableNode().getGrid(), (BaseActionSource)new PlayerSource((EntityPlayer)player, (IActionHost)target), message.item, message.craftingMode, null);
                        } else {
                            futureJob = cg.beginCraftingJob(player.func_130014_f_(), ((IActionHost)target).getActionableNode().getGrid(), (BaseActionSource)new PlayerSource((EntityPlayer)player, (IActionHost)target), message.item, null);
                        }
                        ContainerOpenContext context = c.getOpenContext();
                        if (context != null) {
                            for (ICraftingTerminalAdapter adapter : AE2ThingAPI.instance().terminal().getCraftingTerminal().values()) {
                                if (player.field_71070_bA.getClass() != adapter.getContainer()) continue;
                                TileEntity te = context.getTile();
                                adapter.openGui(player, te, context.getSide(), target);
                            }
                            Container container3 = player.field_71070_bA;
                            if (container3 instanceof ContainerCraftConfirm) {
                                ContainerCraftConfirm ccc = (ContainerCraftConfirm)container3;
                                ccc.setItemToCraft(message.item);
                                ccc.setAutoStart(message.heldShift);
                                ccc.setJob(futureJob);
                                ccc.func_75142_b();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (futureJob != null) {
                            futureJob.cancel(true);
                        }
                        AELog.debug((Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

