/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.core.localization.GuiText;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.InventoryActionExtend;
import com.asdflj.ae2thing.api.WirelessObject;
import com.asdflj.ae2thing.client.gui.container.ContainerCraftingTerminal;
import com.asdflj.ae2thing.client.gui.container.ContainerPatternModifier;
import com.asdflj.ae2thing.client.gui.container.ContainerPatternValueName;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.network.SPacketCraftingStateUpdate;
import com.asdflj.ae2thing.network.SPacketSetItemName;
import com.asdflj.ae2thing.util.BlockPos;
import com.asdflj.ae2thing.util.CPUCraftingPreview;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class CPacketInventoryActionExtend
implements IMessage {
    private InventoryActionExtend action;
    private int slot;
    private long id;
    private IAEItemStack stack;
    private boolean isEmpty;

    public CPacketInventoryActionExtend() {
    }

    public CPacketInventoryActionExtend(InventoryActionExtend action, int slot, int id) {
        this(action, slot, id, null);
    }

    public CPacketInventoryActionExtend(InventoryActionExtend action) {
        this(action, 0, 0, null);
    }

    public CPacketInventoryActionExtend(InventoryActionExtend action, int slot, int id, IAEItemStack stack) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = stack;
        this.isEmpty = stack == null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slot);
        buf.writeLong(this.id);
        buf.writeBoolean(this.isEmpty);
        if (!this.isEmpty) {
            try {
                this.stack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = InventoryActionExtend.values()[buf.readInt()];
        this.slot = buf.readInt();
        this.id = buf.readLong();
        this.isEmpty = buf.readBoolean();
        if (!this.isEmpty) {
            try {
                this.stack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketInventoryActionExtend, IMessage> {
        private void extractItemFromME(EntityPlayer player, IAEItemStack requestItem, int slot) {
            if (requestItem.getStackSize() <= 0L) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack item = player.field_71071_by.field_70462_a[i];
                if (item == null || !(item.func_77973_b() instanceof IWirelessTermHandler)) continue;
                try {
                    WirelessObject object = new WirelessObject(item, player.field_70170_p, slot, 0, 0, player);
                    if (!object.rangeCheck() || requestItem.getStackSize() <= 0L) continue;
                    IAEItemStack result = (IAEItemStack)object.getItemInventory().extractItems((IAEStack)requestItem, Actionable.MODULATE, (BaseActionSource)object.getSource());
                    if (result != null) {
                        requestItem.decStackSize(result.getStackSize());
                    }
                    if (requestItem.getStackSize() > 0L) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Nullable
        public IMessage onMessage(CPacketInventoryActionExtend message, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            if (message.action == InventoryActionExtend.REQUEST_ITEM && sender.field_71071_by.field_70462_a[message.slot] == null) {
                message.stack.setStackSize((long)message.stack.getItemStack().func_77976_d());
                IAEItemStack requestItem = message.stack.copy();
                this.extractItemFromME((EntityPlayer)sender, requestItem, message.slot);
                message.stack.decStackSize(requestItem.getStackSize());
                if (message.stack.getStackSize() > 0L) {
                    sender.field_71071_by.func_70299_a(message.slot, message.stack.getItemStack());
                }
                return null;
            }
            if (sender.field_71070_bA instanceof ContainerCraftingTerminal) {
                return null;
            }
            Container container = sender.field_71070_bA;
            if (container instanceof AEBaseContainer) {
                AEBaseContainer baseContainer = (AEBaseContainer)container;
                Object target = baseContainer.getTarget();
                if (message.action == InventoryActionExtend.SET_PATTERN_NAME) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null && message.stack != null) {
                        Container container2;
                        TileEntity te = context.getTile();
                        if (te != null) {
                            InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_NAME_SET);
                        } else {
                            InventoryHandler.openGui((EntityPlayer)sender, sender.func_130014_f_(), new BlockPos(((WirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_NAME_SET_ITEM);
                        }
                        ItemStack itemStack = message.stack.getItemStack();
                        if (itemStack.func_82837_s()) {
                            String name = itemStack.func_82833_r();
                            AE2Thing.proxy.netHandler.sendTo(new SPacketSetItemName(name), sender);
                        }
                        if ((container2 = sender.field_71070_bA) instanceof ContainerPatternValueName) {
                            ContainerPatternValueName cpv = (ContainerPatternValueName)container2;
                            if (baseContainer.getTargetStack() != null) {
                                cpv.setValueIndex(message.slot);
                                cpv.getPatternValue().func_75215_d(baseContainer.getTargetStack().getItemStack());
                            }
                            cpv.func_75142_b();
                        }
                    }
                } else if (message.action == InventoryActionExtend.GET_CRAFTING_STATE) {
                    if (target instanceof IActionHost) {
                        IActionHost gh = (IActionHost)target;
                        ICraftingGrid craftingGrid = (ICraftingGrid)gh.getActionableNode().getGrid().getCache(ICraftingGrid.class);
                        NBTTagCompound cpuData = new NBTTagCompound();
                        NBTTagList tagList = new NBTTagList();
                        cpuData.func_74782_a("cpu_list", (NBTBase)tagList);
                        int i = 0;
                        for (ICraftingCPU cpu : craftingGrid.getCpus()) {
                            CraftingCPUCluster ccc;
                            ++i;
                            if (!(cpu instanceof CraftingCPUCluster) || (ccc = (CraftingCPUCluster)cpu).getFinalOutput() == null || message.stack.hashCode() != ccc.getFinalOutput().hashCode()) continue;
                            IItemList list = AEApi.instance().storage().createPrimitiveItemList();
                            ccc.getListOfItem(list, CraftingItemList.ACTIVE);
                            List<IAEItemStack> activeItems = Arrays.stream((IAEItemStack[])list.toArray((IAEStack[])((IAEItemStack[])list.toArray((IAEStack[])new IAEItemStack[0])))).limit(5L).sorted(Comparator.comparingLong(IAEStack::getStackSize).reversed()).collect(Collectors.toList());
                            if (activeItems.isEmpty()) continue;
                            NBTTagCompound data = new NBTTagCompound();
                            String name = ccc.getName().isEmpty() ? GuiText.CPUs.getLocal() + ": #" + i : GuiText.CPUs.getLocal() + ": " + ccc.getName().substring(0, Math.min(20, ccc.getName().length()));
                            new CPUCraftingPreview(name, ccc.getRemainingItemCount(), ccc.getElapsedTime(), activeItems).writeToNBT(data);
                            tagList.func_74742_a((NBTBase)data);
                        }
                        AE2Thing.proxy.netHandler.sendTo(new SPacketCraftingStateUpdate(cpuData), ctx.getServerHandler().field_147369_b);
                    }
                } else if (message.action == InventoryActionExtend.CLEAR_PATTERN && baseContainer instanceof ContainerPatternModifier) {
                    ContainerPatternModifier patternModifier = (ContainerPatternModifier)baseContainer;
                    patternModifier.clearPattern();
                } else if (message.action == InventoryActionExtend.REPLACE_PATTERN && baseContainer instanceof ContainerPatternModifier) {
                    ContainerPatternModifier patternModifier = (ContainerPatternModifier)baseContainer;
                    patternModifier.replacePattern();
                }
            }
            return null;
        }
    }
}

