/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.IPartitionList;
import com.asdflj.ae2thing.client.gui.container.ContainerCraftingTerminal;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketNEIRecipe
implements IMessage {
    private ItemStack[][] recipe;
    private NBTTagCompound r;

    public CPacketNEIRecipe() {
    }

    public CPacketNEIRecipe(NBTTagCompound r) {
        this.r = r;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(buf.array());
            bytes.skip(1L);
            NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
            if (comp != null) {
                this.recipe = new ItemStack[9][];
                for (int x = 0; x < this.recipe.length; ++x) {
                    NBTTagList list = comp.func_150295_c("#" + x, 10);
                    if (list.func_74745_c() <= 0) continue;
                    this.recipe[x] = new ItemStack[list.func_74745_c()];
                    for (int y = 0; y < list.func_74745_c(); ++y) {
                        NBTTagCompound tag = list.func_150305_b(y);
                        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                        if (itemStack != null) {
                            itemStack.field_77994_a = tag.func_74765_d("Count");
                        }
                        this.recipe[x][y] = itemStack;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            ByteBuf data = Unpooled.buffer();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.r, (OutputStream)outputStream);
            data.writeBytes(bytes.toByteArray());
            data.capacity(data.readableBytes());
            buf.writeBytes(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketNEIRecipe, IMessage> {
        private ItemStack[][] recipe;

        public IMessage onMessage(CPacketNEIRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerCraftingTerminal) {
                ContainerCraftingTerminal cct = (ContainerCraftingTerminal)container;
                this.recipe = message.recipe;
                this.serverPacketData((EntityPlayer)ctx.getServerHandler().field_147369_b, cct);
            }
            return null;
        }

        private ItemStack extractItemFromPlayerInventory(EntityPlayer player, Actionable mode, ItemStack patternItem) {
            boolean checkFuzzy;
            InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
            AEItemStack request = AEItemStack.create((ItemStack)patternItem);
            boolean isSimulated = mode == Actionable.SIMULATE;
            boolean bl = checkFuzzy = request.isOre() || patternItem.func_77960_j() == Short.MAX_VALUE || patternItem.func_77942_o() || patternItem.func_77984_f();
            if (!checkFuzzy) {
                if (isSimulated) {
                    return ia.simulateRemove(1, patternItem, null);
                }
                return ia.removeItems(1, patternItem, null);
            }
            if (isSimulated) {
                return ia.simulateSimilarRemove(1, patternItem, FuzzyMode.IGNORE_ALL, null);
            }
            return ia.removeSimilarItems(1, patternItem, FuzzyMode.IGNORE_ALL, null);
        }

        public void serverPacketData(EntityPlayer player, ContainerCraftingTerminal cct) {
            Actionable realForFake;
            EntityPlayerMP pmp = (EntityPlayerMP)player;
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            IInventory playerInventory = cct.getInventoryByName("player");
            IEnergySource energy = cct.getPowerSource();
            Actionable actionable = realForFake = cct.useRealItems() ? Actionable.MODULATE : Actionable.SIMULATE;
            if (this.recipe != null) {
                ItemStack is;
                InventoryCrafting testInv = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    if (this.recipe[x] == null || this.recipe[x].length <= 0) continue;
                    testInv.func_70299_a(x, this.recipe[x][0]);
                }
                IRecipe r = Platform.findMatchingRecipe((InventoryCrafting)testInv, (World)pmp.field_70170_p);
                if (r != null && (is = r.func_77572_b(testInv)) != null) {
                    IMEMonitor<IAEItemStack> storage = cct.getMonitor();
                    IItemList all = storage.getStorageList();
                    IPartitionList filter = ItemViewCell.createFilter((ItemStack[])cct.getViewCells());
                    for (int x = 0; x < craftMatrix.func_70302_i_(); ++x) {
                        ItemStack patternItem = testInv.func_70301_a(x);
                        ItemStack currentItem = craftMatrix.func_70301_a(x);
                        if (currentItem != null) {
                            AEItemStack in;
                            testInv.func_70299_a(x, currentItem);
                            ItemStack newItemStack = r.func_77569_a(testInv, pmp.field_70170_p) ? r.func_77572_b(testInv) : null;
                            testInv.func_70299_a(x, patternItem);
                            if (!(newItemStack != null && Platform.isSameItemPrecise((ItemStack)newItemStack, (ItemStack)is) || (in = AEItemStack.create((ItemStack)currentItem)) == null)) {
                                IAEItemStack out;
                                IAEItemStack iAEItemStack = out = realForFake == Actionable.SIMULATE ? null : (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, storage, (IAEStack)in, (BaseActionSource)cct.getActionSource());
                                if (out != null) {
                                    craftMatrix.func_70299_a(x, out.getItemStack());
                                } else {
                                    craftMatrix.func_70299_a(x, null);
                                }
                                currentItem = craftMatrix.func_70301_a(x);
                            }
                        }
                        if (patternItem == null || currentItem != null) continue;
                        ItemStack whichItem = Platform.extractItemsByRecipe((IEnergySource)energy, (BaseActionSource)cct.getActionSource(), storage, (World)player.field_70170_p, (IRecipe)r, (ItemStack)is, (InventoryCrafting)testInv, (ItemStack)patternItem, (int)x, (IItemList)all, (Actionable)realForFake, (IPartitionList)filter);
                        if (whichItem == null) {
                            for (int y = 0; y < this.recipe[x].length; ++y) {
                                AEItemStack request = AEItemStack.create((ItemStack)this.recipe[x][y]);
                                if (request == null || filter != null && !filter.isListed((IAEStack)request)) continue;
                                request.setStackSize(1L);
                                IAEItemStack out = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, storage, (IAEStack)request, (BaseActionSource)cct.getActionSource());
                                if (out == null) continue;
                                whichItem = out.getItemStack();
                                break;
                            }
                        }
                        if (whichItem == null && playerInventory != null) {
                            whichItem = this.extractItemFromPlayerInventory(player, realForFake, patternItem);
                        }
                        craftMatrix.func_70299_a(x, whichItem);
                    }
                    cct.func_75130_a(craftMatrix);
                }
            }
        }
    }
}

