/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.adapter.pattern.IPatternTerminalAdapter;
import com.asdflj.ae2thing.nei.object.OrderStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CPacketTransferRecipe
implements IMessage {
    private List<OrderStack<?>> inputs;
    private List<OrderStack<?>> outputs;
    private String identifier;
    public boolean isCraft;
    private static final int MAX_INDEX = 32;
    public boolean shift;

    public CPacketTransferRecipe() {
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft) {
        this(IN, OUT, craft, false);
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft, boolean shift) {
        this(IN, OUT, craft, shift, "nei.default");
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft, boolean shift, String identifier) {
        this.inputs = IN;
        this.outputs = OUT;
        this.isCraft = craft;
        this.shift = shift;
        this.identifier = identifier;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isCraft);
        buf.writeBoolean(this.shift);
        NBTTagCompound nbt_m = new NBTTagCompound();
        NBTTagCompound nbt_i = new NBTTagCompound();
        NBTTagCompound nbt_o = new NBTTagCompound();
        for (OrderStack<?> stack : this.inputs) {
            stack.writeToNBT(nbt_i);
        }
        for (OrderStack<?> stack : this.outputs) {
            stack.writeToNBT(nbt_o);
        }
        nbt_m.func_74782_a("i", (NBTBase)nbt_i);
        nbt_m.func_74782_a("o", (NBTBase)nbt_o);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt_m);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.identifier);
    }

    public void fromBytes(ByteBuf buf) {
        OrderStack<?> tmp;
        int i;
        this.isCraft = buf.readBoolean();
        this.shift = buf.readBoolean();
        this.inputs = new LinkedList();
        this.outputs = new LinkedList();
        NBTTagCompound nbt_m = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagCompound nbt_i = nbt_m.func_74775_l("i");
        NBTTagCompound nbt_o = nbt_m.func_74775_l("o");
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_i, null, i);
            if (tmp == null) continue;
            this.inputs.add(tmp);
        }
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_o, null, i);
            if (tmp == null) continue;
            this.outputs.add(tmp);
        }
        this.identifier = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<CPacketTransferRecipe, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketTransferRecipe message, MessageContext ctx) {
            Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
            IPatternTerminalAdapter adapter = AE2ThingAPI.instance().terminal().getPatternTerminal(c);
            if (adapter != null && adapter.getIdentifiers().containsKey(message.identifier)) {
                adapter.transfer(c, message.inputs, message.outputs, message.identifier, message);
                return null;
            }
            return null;
        }
    }
}

