/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.CraftingDebugCardObject;
import com.asdflj.ae2thing.api.CraftingDebugHelper;
import com.asdflj.ae2thing.api.LimitedSizeLinkedList;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class SPacketCraftingDebugCardUpdate
implements IMessage {
    private NBTTagCompound data;
    private LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> infos;
    private long networkID;
    private CraftingDebugCardObject.Mode mode;

    public SPacketCraftingDebugCardUpdate(long networkID, LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> infos) {
        this(networkID, infos, CraftingDebugCardObject.Mode.Everything);
    }

    public SPacketCraftingDebugCardUpdate(long networkID, LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> infos, CraftingDebugCardObject.Mode mode) {
        this.infos = infos;
        this.data = new NBTTagCompound();
        this.networkID = networkID;
        this.mode = mode;
        CraftingDebugHelper.CraftingInfo.writeToNBTList(infos, this.data, this.networkID);
    }

    public SPacketCraftingDebugCardUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = CraftingDebugCardObject.Mode.values()[buf.readByte()];
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(buf.readBytes(buf.readableBytes()).array());
            NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
            this.networkID = comp.func_74763_f("networkID");
            this.data = comp;
            this.infos = CraftingDebugHelper.CraftingInfo.readFromNBTList(this.data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.mode.ordinal());
        try {
            ByteBuf data = Unpooled.buffer();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)outputStream);
            data.writeBytes(bytes.toByteArray());
            data.capacity(data.readableBytes());
            buf.writeBytes(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketCraftingDebugCardUpdate, IMessage> {
        public IMessage onMessage(SPacketCraftingDebugCardUpdate message, MessageContext ctx) {
            AE2ThingAPI.instance().pushHistory(message.networkID, message.infos);
            CraftingDebugCardObject.sendMessageToPlayer(message.networkID, message.mode);
            AE2ThingAPI.instance().saveHistory();
            return null;
        }
    }
}

